/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.japi;

import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.RDDFunctions;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.japi.CassandraJavaUtil;
import com.datastax.spark.connector.japi.RDDAndDStreamCommonJavaFunctions;
import com.datastax.spark.connector.japi.rdd.CassandraJavaPairRDD;
import com.datastax.spark.connector.rdd.CassandraJoinRDD;
import com.datastax.spark.connector.rdd.CassandraLimit;
import com.datastax.spark.connector.rdd.ClusteringOrder;
import com.datastax.spark.connector.rdd.CqlWhereClause;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionedRDD;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import com.datastax.spark.connector.util.JavaApiHelper;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.WriteConf;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.rdd.RDD;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ClassTag;

public class RDDJavaFunctions<T>
extends RDDAndDStreamCommonJavaFunctions<T> {
    public final RDD<T> rdd;
    public final RDDFunctions<T> rddFunctions;

    public RDDJavaFunctions(RDD<T> rDD) {
        this.rdd = rDD;
        this.rddFunctions = new RDDFunctions<T>(rDD);
    }

    @Override
    public CassandraConnector defaultConnector() {
        return CassandraConnector$.MODULE$.apply(this.rdd.conf());
    }

    @Override
    public SparkConf getConf() {
        return this.rdd.conf();
    }

    @Override
    public void saveToCassandra(String string, String string2, RowWriterFactory<T> rowWriterFactory, ColumnSelector columnSelector, WriteConf writeConf, CassandraConnector cassandraConnector) {
        this.rddFunctions.saveToCassandra(string, string2, columnSelector, writeConf, cassandraConnector, rowWriterFactory);
    }

    public void deleteFromCassandra(String string, String string2, RowWriterFactory<T> rowWriterFactory, ColumnSelector columnSelector, ColumnSelector columnSelector2, WriteConf writeConf, CassandraConnector cassandraConnector) {
        this.rddFunctions.deleteFromCassandra(string, string2, columnSelector, columnSelector2, writeConf, cassandraConnector, rowWriterFactory);
    }

    public <U> JavaPairRDD<U, Iterable<T>> spanBy(Function<T, U> function, ClassTag<U> classTag) {
        ClassTag classTag2 = CassandraJavaUtil.classTag(Tuple2.class);
        ClassTag classTag3 = CassandraJavaUtil.classTag(Iterable.class);
        RDD rDD = this.rddFunctions.spanBy(JavaApiHelper.toScalaFunction1(function)).map(JavaApiHelper.valuesAsJavaIterable(), classTag2);
        return new JavaPairRDD(rDD, classTag, classTag3);
    }

    public <R> CassandraJavaPairRDD<T, R> joinWithCassandraTable(String string, String string2, ColumnSelector columnSelector, ColumnSelector columnSelector2, RowReaderFactory<R> rowReaderFactory, RowWriterFactory<T> rowWriterFactory) {
        ClassTag classTag = this.rdd.toJavaRDD().classTag();
        ClassTag<R> classTag2 = JavaApiHelper.getClassTag(rowReaderFactory.targetClass());
        CassandraConnector cassandraConnector = this.defaultConnector();
        Option option = Option.empty();
        Option option2 = Option.empty();
        CqlWhereClause cqlWhereClause = CqlWhereClause.empty();
        ReadConf readConf = ReadConf.fromSparkConf(this.rdd.conf());
        CassandraJoinRDD<T, R> cassandraJoinRDD = new CassandraJoinRDD<T, R>(this.rdd, string, string2, cassandraConnector, columnSelector, columnSelector2, cqlWhereClause, (Option<CassandraLimit>)option2, (Option<ClusteringOrder>)option, readConf, Option.empty(), Option.empty(), classTag, classTag2, rowWriterFactory, rowReaderFactory);
        return new CassandraJavaPairRDD(cassandraJoinRDD, classTag, classTag2);
    }

    public JavaRDD<T> repartitionByCassandraReplica(String string, String string2, int n, ColumnSelector columnSelector, RowWriterFactory<T> rowWriterFactory) {
        CassandraConnector cassandraConnector = this.defaultConnector();
        ClassTag classTag = this.rdd.toJavaRDD().classTag();
        CassandraPartitionedRDD<T> cassandraPartitionedRDD = this.rddFunctions.repartitionByCassandraReplica(string, string2, n, columnSelector, cassandraConnector, classTag, rowWriterFactory);
        return new JavaRDD(cassandraPartitionedRDD, classTag);
    }
}

