/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.PagingIterable;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.PropertyMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import shade.com.datastax.spark.connector.google.common.base.Function;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.ListenableFuture;

public class Result<T>
implements PagingIterable<Result<T>, T> {
    private final ResultSet rs;
    private final EntityMapper<T> mapper;
    private final boolean useAlias;

    Result(ResultSet rs, EntityMapper<T> mapper) {
        this(rs, mapper, false);
    }

    Result(ResultSet rs, EntityMapper<T> mapper, boolean useAlias) {
        this.rs = rs;
        this.mapper = mapper;
        this.useAlias = useAlias;
    }

    private T map(Row row) {
        T entity = this.mapper.newEntity();
        for (PropertyMapper col : this.mapper.allColumns) {
            TypeCodec<Object> customCodec;
            Object value2;
            String name;
            String string = name = col.alias != null && this.useAlias ? col.alias : col.columnName;
            if (!row.getColumnDefinitions().contains(name) || !Result.shouldSetValue(value2 = (customCodec = col.customCodec) != null ? row.get(name, customCodec) : row.get(name, col.javaType))) continue;
            col.setValue(entity, value2);
        }
        return entity;
    }

    private static boolean shouldSetValue(Object value2) {
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof Collection) {
            return !((Collection)value2).isEmpty();
        }
        if (value2 instanceof Map) {
            return !((Map)value2).isEmpty();
        }
        return true;
    }

    @Override
    public boolean isExhausted() {
        return this.rs.isExhausted();
    }

    @Override
    public T one() {
        Row row = this.rs.one();
        return row == null ? null : (T)this.map(row);
    }

    @Override
    public List<T> all() {
        List rows = this.rs.all();
        ArrayList<T> entities = new ArrayList<T>(rows.size());
        for (Row row : rows) {
            entities.add(this.map(row));
        }
        return entities;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Row> rowIterator;
            {
                this.rowIterator = Result.this.rs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.rowIterator.hasNext();
            }

            @Override
            public T next() {
                return Result.this.map(this.rowIterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public ExecutionInfo getExecutionInfo() {
        return this.rs.getExecutionInfo();
    }

    @Override
    public List<ExecutionInfo> getAllExecutionInfo() {
        return this.rs.getAllExecutionInfo();
    }

    @Override
    public ListenableFuture<Result<T>> fetchMoreResults() {
        return Futures.transform(this.rs.fetchMoreResults(), new Function<ResultSet, Result<T>>(){

            @Override
            public Result<T> apply(ResultSet rs) {
                return Result.this;
            }
        });
    }

    @Override
    public boolean isFullyFetched() {
        return this.rs.isFullyFetched();
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.rs.getAvailableWithoutFetching();
    }
}

