/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.mapping.PropertyMapper;
import com.datastax.driver.mapping.annotations.Column;
import com.datastax.driver.mapping.annotations.Computed;
import com.datastax.driver.mapping.annotations.Table;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

class AnnotationChecks {
    private static final Package MAPPING_PACKAGE = Table.class.getPackage();

    AnnotationChecks() {
    }

    static <T extends Annotation> T getTypeAnnotation(Class<T> annotation, Class<?> annotatedClass) {
        T instance = annotatedClass.getAnnotation(annotation);
        if (instance == null) {
            throw new IllegalArgumentException(String.format("@%s annotation was not found on %s", annotation.getSimpleName(), annotatedClass));
        }
        AnnotationChecks.validateAnnotations(annotatedClass, annotation);
        return instance;
    }

    private static void validateAnnotations(Class<?> clazz, Class<? extends Annotation> allowed) {
        HashSet<Annotation> classAnnotations = new HashSet<Annotation>();
        Collections.addAll(classAnnotations, clazz.getAnnotations());
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(classAnnotations, Collections.singleton(allowed));
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Cannot have both @%s and @%s on %s", allowed.getSimpleName(), invalid.getSimpleName(), clazz));
        }
    }

    static void validateAnnotations(PropertyMapper property, Collection<? extends Class<? extends Annotation>> allowed) {
        Class<? extends Annotation> invalid = AnnotationChecks.validateAnnotations(property.getAnnotations(), allowed);
        if (invalid != null) {
            throw new IllegalArgumentException(String.format("Annotation @%s is not allowed on property '%s'", invalid.getSimpleName(), property));
        }
        AnnotationChecks.checkValidPrimaryKey(property);
        AnnotationChecks.checkValidComputed(property);
    }

    private static Class<? extends Annotation> validateAnnotations(Collection<Annotation> annotations, Collection<? extends Class<? extends Annotation>> allowed) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> actual = annotation.annotationType();
            if (!actual.getPackage().equals(MAPPING_PACKAGE) || allowed.contains(actual)) continue;
            return actual;
        }
        return null;
    }

    private static void checkValidPrimaryKey(PropertyMapper property) {
        if (property.isPartitionKey() && property.isClusteringColumn()) {
            throw new IllegalArgumentException(String.format("Property '%s' cannot be annotated with both @PartitionKey and @ClusteringColumn", property));
        }
    }

    private static void checkValidComputed(PropertyMapper property) {
        if (property.isComputed()) {
            Computed computed = property.annotation(Computed.class);
            if (computed.value().isEmpty()) {
                throw new IllegalArgumentException(String.format("Property '%s': attribute 'value' of annotation @Computed is mandatory for computed properties", property));
            }
            if (property.hasAnnotation(Column.class)) {
                throw new IllegalArgumentException(String.format("Property '%s' cannot be annotated with both @Column and @Computed", property));
            }
        }
    }

    static void validateOrder(List<PropertyMapper> properties, String annotation) {
        for (int i = 0; i < properties.size(); ++i) {
            PropertyMapper property = properties.get(i);
            int pos = property.position;
            if (pos == i) continue;
            throw new IllegalArgumentException(String.format("Invalid ordering value %d for annotation %s of property '%s', was expecting %d", pos, annotation, property, i));
        }
    }
}

