/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.DriverThrowables;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import shade.com.datastax.spark.connector.google.common.util.concurrent.AbstractFuture;
import shade.com.datastax.spark.connector.google.common.util.concurrent.FutureCallback;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Futures;
import shade.com.datastax.spark.connector.google.common.util.concurrent.Uninterruptibles;

class ChainedResultSetFuture
extends AbstractFuture<ResultSet>
implements ResultSetFuture {
    private volatile ResultSetFuture source;

    ChainedResultSetFuture() {
    }

    void setSource(ResultSetFuture source) {
        if (this.isCancelled()) {
            source.cancel(false);
        }
        this.source = source;
        Futures.addCallback(source, new FutureCallback<ResultSet>(){

            @Override
            public void onSuccess(ResultSet result) {
                ChainedResultSetFuture.this.set(result);
            }

            @Override
            public void onFailure(Throwable t) {
                ChainedResultSetFuture.this.setException(t);
            }
        });
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return (this.source == null || this.source.cancel(mayInterruptIfRunning)) && super.cancel(mayInterruptIfRunning);
    }

    @Override
    public ResultSet getUninterruptibly() {
        try {
            return Uninterruptibles.getUninterruptibly(this);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ResultSet getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return Uninterruptibles.getUninterruptibly(this, timeout, unit);
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }
}

