/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.EnumSet;
import java.util.Properties;
import java.util.concurrent.Executor;
import oracle.jdbc.LogicalTransactionId;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.ACProxyable;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OracleConnectionBuilderImpl;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.proxy.ProxyFactory;
import oracle.jdbc.proxy.annotation.GetCreator;
import oracle.jdbc.proxy.annotation.GetDelegate;
import oracle.jdbc.proxy.annotation.Methods;
import oracle.jdbc.proxy.annotation.OnError;
import oracle.jdbc.proxy.annotation.Post;
import oracle.jdbc.proxy.annotation.Pre;
import oracle.jdbc.proxy.annotation.ProxyAccess;
import oracle.jdbc.proxy.annotation.ProxyFor;
import oracle.jdbc.proxy.annotation.ProxyLocale;
import oracle.jdbc.proxy.annotation.ProxyResult;
import oracle.jdbc.proxy.annotation.ProxyResultPolicy;
import oracle.jdbc.proxy.annotation.SetDelegate;
import oracle.jdbc.proxy.annotation.Signature;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.replay.driver.JDBCReplayable;
import oracle.jdbc.replay.driver.LogicalConnectionImpl;
import oracle.jdbc.replay.driver.TxnFailoverManagerImpl;
import oracle.jdbc.replay.driver.TxnReplayableBase;
import oracle.jdbc.replay.internal.OracleDataSource;
import oracle.jdbc.replay.internal.ReplayableConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

@ProxyFor(value={OracleConnection.class})
@ProxyLocale
@ProxyAccess(value=ACProxyable.class)
@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
public abstract class TxnReplayableConnection
extends TxnReplayableBase
implements JDBCReplayable,
ReplayableConnection {
    private static final Method CREATEARRAY_METHOD = TxnReplayableConnection.getCreateARRAYMethod();
    private static final Method CREATEARRAYOF_METHOD = TxnReplayableConnection.getCreateArrayOfMethod();
    private static final Method CREATESTRUCT_METHOD = TxnReplayableConnection.getCreateStructMethod();
    private static final Method CREATECLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createClob");
    private static final Method CREATECLOB_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createClob", byte[].class);
    private static final Method CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD = TxnReplayableConnection.getCreateClobWithLocatorAndCSFORMMethod();
    private static final Method CREATECLOB_WITH_UNPICKLEDBYTES_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createClobWithUnpickledBytes", byte[].class);
    private static final Method CREATENCLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createNClob");
    private static final Method CREATEBLOB_METHOD = TxnReplayableConnection.getCreateLobMethod("createBlob");
    private static final Method CREATEBLOB_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBlob", byte[].class);
    private static final Method CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBlobWithUnpickledBytes", byte[].class);
    private static final Method CREATEBFILE_WITH_LOCATOR_METHOD = TxnReplayableConnection.getCreateLobWithLocatorMethod("createBfile", byte[].class);
    private static final Method GETDESCRIPTOR_WITH_NAME_METHOD = TxnReplayableConnection.getMethod("getDescriptor", String.class);
    OracleConnectionBuilderImpl originalConnectionBuilder;
    private Object logicalProxy = null;
    boolean autoCommitBeforeOutage = true;

    protected TxnReplayableConnection() {
        this.thisProxyNameInLog = "CONN" + this.thisProxyNameInLog;
    }

    private static final Method getCreateARRAYMethod() {
        try {
            return OracleConnection.class.getMethod("createARRAY", String.class, Object.class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateArrayOfMethod() {
        try {
            return Connection.class.getDeclaredMethod("createArrayOf", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateStructMethod() {
        try {
            return Connection.class.getDeclaredMethod("createStruct", String.class, Object[].class);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateLobMethod(String string) {
        try {
            return OracleConnection.class.getMethod(string, new Class[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateLobWithLocatorMethod(String string, Class<?> clazz) {
        try {
            return OracleConnection.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getCreateClobWithLocatorAndCSFORMMethod() {
        try {
            return OracleConnection.class.getMethod("createClob", byte[].class, Short.TYPE);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static final Method getMethod(String string, Class<?> clazz) {
        try {
            return OracleConnection.class.getMethod(string, clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Pre
    protected void preForAll(Method method, Object object, Object ... objectArray) {
        super.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="prepareStatement", args={String.class}), @Signature(name="prepareStatement", args={String.class, int.class}), @Signature(name="prepareStatement", args={String.class, int[].class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, int.class, int.class, int.class}), @Signature(name="prepareStatement", args={String.class, String[].class}), @Signature(name="prepareCall", args={String.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class}), @Signature(name="prepareCall", args={String.class, int.class, int.class, int.class})})
    protected void preForStatementCreation(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
    }

    @Pre
    @Methods(signatures={@Signature(name="setAutoCommit", args={Boolean.class})})
    protected void preForSetAutoCommit(Method method, Object object, Object ... objectArray) {
        this.preForAll(method, object, objectArray);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case ENABLED_NOT_REPLAYING: 
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                this.autoCommitBeforeOutage = (Boolean)objectArray[0];
                break;
            }
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class})})
    protected void preForAbort(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="close", args={})})
    protected void preForClosure(Method method, Object object, Object ... objectArray) {
        String string;
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string2 = string = stackTraceElementArray != null && stackTraceElementArray.length > 4 ? stackTraceElementArray[4].getClassName() : "";
        this.isClosedAndNoReplay = !string.startsWith("oracle.ucp") || this.isClosedAndNoReplay || !this.abortCalledBeforeLatestClose;
    }

    @Pre
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void preForCancel(Method method, Object object, Object ... objectArray) {
    }

    @Pre
    @Methods(signatures={@Signature(name="openProxySession", args={int.class, Properties.class})})
    protected void preForOpenProxySession(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
    }

    @Pre
    @Methods(signatures={@Signature(name="isValid", args={int.class}), @Signature(name="isValid", args={OracleConnection.ConnectionValidation.class, int.class}), @Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class}), @Signature(name="isUsable", args={}), @Signature(name="isUsable", args={boolean.class})})
    protected void preForSafeDrainingAPIs(Method method, Object object, Object ... objectArray) {
    }

    protected void preForMethodWithConcreteClass(Method method, Object object, Object ... objectArray) {
        block1: {
            TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
            if (replayLifecycle != TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
                return;
            }
            if (this.failoverMngr == null) break block1;
            this.failoverMngr.disableReplayInternal(method, 397, "Replay disabled because of concrete class usage", null);
        }
    }

    @Override
    @Post
    protected void postForAll(Method method) {
        this.postForAll(method, null);
    }

    @Override
    @Post
    protected Object postForAll(Method method, Object object) {
        return super.postForAll(method, object);
    }

    @Post
    @Methods(signatures={@Signature(name="abort", args={}), @Signature(name="abort", args={Executor.class})})
    protected void postForAbort(Method method) {
        this.abortCalledBeforeLatestClose = true;
    }

    @Post
    @Methods(signatures={@Signature(name="close", args={}), @Signature(name="close", args={int.class}), @Signature(name="close", args={Properties.class})})
    protected void postForClosure(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="cancel", args={})})
    protected void postForCancel(Method method) {
    }

    @Post
    @Methods(signatures={@Signature(name="isValid", args={int.class}), @Signature(name="isValid", args={OracleConnection.ConnectionValidation.class, int.class}), @Signature(name="isUsable", args={}), @Signature(name="isUsable", args={boolean.class})})
    protected boolean postForSafeDrainingAPIs(Method method, boolean bl) {
        block0: {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            if (this.failoverMngr == null || oracleConnection.isUsable(false)) break block0;
            this.failoverMngr.disableReplayInternal(method, 372, "Replay disabled because of nonreplayable call", null);
        }
        return bl;
    }

    @Post
    @Methods(signatures={@Signature(name="pingDatabase", args={}), @Signature(name="pingDatabase", args={int.class})})
    protected int postForPingDatabase(Method method, int n2) {
        return n2;
    }

    @Post
    @Methods(signatures={@Signature(name="commit", args={}), @Signature(name="commit", args={EnumSet.class}), @Signature(name="rollback", args={})})
    protected void postForTxnCompletion(Method method) {
        this.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING || replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.INTERNALLY_DISABLED) {
            try {
                this.checkImplicitRequestBoundary();
            }
            catch (Throwable throwable) {
            }
        }
    }

    @Post
    @Methods(signatures={@Signature(name="setClientInfo", args={String.class, String.class}), @Signature(name="setClientInfo", args={Properties.class})})
    protected void postForSetClientInfo(Method method) {
        super.postForAll(method);
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        if (replayLifecycle == TxnFailoverManagerImpl.ReplayLifecycle.ENABLED_NOT_REPLAYING) {
            this.failoverMngr.setStateSignatureSyncUp();
        }
    }

    @Override
    @OnError(value=SQLException.class)
    protected void onErrorVoidForAll(Method method, SQLException sQLException) throws SQLException {
        super.onErrorVoidForAll(method, sQLException);
    }

    @Override
    @OnError(value=SQLException.class)
    protected Object onErrorForAll(Method method, SQLException sQLException) throws SQLException {
        return super.onErrorForAll(method, sQLException);
    }

    @Override
    @GetDelegate
    protected abstract Object getDelegate();

    @Override
    @SetDelegate
    protected abstract void setDelegate(Object var1);

    @Override
    @GetCreator
    protected abstract Object getCreator();

    @Override
    public void setReplayInitiationTimeout(int n2) throws SQLException {
        this.failoverMngr.setReplayInitiationTimeout(n2);
    }

    @Override
    public void initialize(OracleDataSource oracleDataSource, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        TxnFailoverManagerImpl txnFailoverManagerImpl = (TxnFailoverManagerImpl)TxnFailoverManagerImpl.getFailoverManager(this, oracleDataSource);
        this.setFailoverManager(txnFailoverManagerImpl);
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
    }

    @Override
    public void setSessionStateConsistency(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateConsistency(bl);
    }

    @Override
    public void setSessionStateRestoration(boolean bl) throws SQLException {
        this.failoverMngr.setSessionStateRestoration(bl);
    }

    @Override
    public void setAutoAC(boolean bl) throws SQLException {
        this.failoverMngr.setAutoAC(bl);
    }

    @Override
    public Object getProxyObject() throws SQLException {
        return this.logicalProxy;
    }

    @Override
    public void setProxyObject(Object object) throws SQLException {
        this.logicalProxy = object;
    }

    @Override
    public void setProxyObject(Object object, OracleConnectionBuilderImpl oracleConnectionBuilderImpl) throws SQLException {
        this.logicalProxy = object;
        this.originalConnectionBuilder = oracleConnectionBuilderImpl;
    }

    @Override
    public OracleConnectionBuilderImpl getConnectionBuilder() {
        return this.originalConnectionBuilder;
    }

    @Override
    public void beginRequest() throws SQLException {
        this.failoverMngr.beginRequest();
    }

    @Override
    public void beginRequest(boolean bl) throws SQLException {
        this.failoverMngr.beginRequest(bl);
    }

    @Override
    public void endRequest() throws SQLException {
        this.endRequest(false);
    }

    public void endRequest(boolean bl) throws SQLException {
        this.failoverMngr.endRequest();
        OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
        oracleConnection.endRequest(bl);
        this.failoverMngr.checkStateSignatureSyncUp();
        this.abortCalledBeforeLatestClose = false;
    }

    public void checkImplicitRequestBoundary() throws SQLException {
        if (this.failoverMngr.isStateUnrestorable()) {
            return;
        }
        OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
        if (this.failoverMngr.isAutoAC && oracleConnection.hasNoOpenHandles()) {
            this.endRequest(true);
            this.beginRequest(true);
        }
    }

    @Override
    public void disableReplay() throws SQLException {
        this.failoverMngr.disableReplay();
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ARRAY createARRAY(String string, Object object) throws SQLException {
        Object object2 = object != null ? (!object.getClass().isArray() || this.isElementTypePrimitive(object) ? object : this.unwrapProxies(object)) : null;
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method method = CREATEARRAY_METHOD;
        this.preForAll(method, this, string, object2);
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            ARRAY aRRAY = oracleConnection.createARRAY(string, object2);
            return (ARRAY)this.postForAll(method, aRRAY);
        }
        catch (SQLException sQLException) {
            return (ARRAY)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public ARRAY ARRAYConstructorRecording(String string, Object object, ARRAY aRRAY) throws SQLException {
        Object object2 = object != null ? (!object.getClass().isArray() || this.isElementTypePrimitive(object) ? object : this.unwrapProxies(object)) : null;
        if (CREATEARRAY_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create ARRAY instance");
        }
        Method method = CREATEARRAY_METHOD;
        this.preForAll(method, this, string, object2);
        return (ARRAY)this.postForAll(method, aRRAY);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array createOracleArray(String string, Object object) throws SQLException {
        return this.createARRAY(string, object);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2 = (Object[])this.unwrapProxies(objectArray);
        if (CREATEARRAYOF_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Array instance");
        }
        Method method = CREATEARRAYOF_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Array array = connection.createArrayOf(string, objectArray2);
            return (Array)this.postForAll(method, array);
        }
        catch (SQLException sQLException) {
            return (Array)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        try {
            Connection connection = (Connection)this.getDelegate();
            Struct struct = connection.createStruct(string, objectArray2);
            return (Struct)this.postForAll(method, struct);
        }
        catch (SQLException sQLException) {
            return (Struct)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public STRUCT STRUCTConstructorRecording(String string, Object[] objectArray, STRUCT sTRUCT) throws SQLException {
        Object[] objectArray2;
        if (objectArray != null && objectArray.length > 0) {
            objectArray2 = new Object[objectArray.length];
            int n2 = 0;
            for (Object object : objectArray) {
                objectArray2[n2++] = object instanceof TxnReplayableBase ? ((TxnReplayableBase)object).getDelegate() : object;
            }
        } else {
            objectArray2 = objectArray;
        }
        if (CREATESTRUCT_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create Struct instance");
        }
        Method method = CREATESTRUCT_METHOD;
        this.preForAll(method, this, string, objectArray2);
        return (STRUCT)this.postForAll(method, sTRUCT);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Clob createClob() throws SQLException {
        if (CREATECLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB instance");
        }
        Method method = CREATECLOB_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Connection connection = (Connection)this.getDelegate();
            Clob clob = connection.createClob();
            return (Clob)this.postForAll(method, clob);
        }
        catch (SQLException sQLException) {
            return (Clob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClob(byte[] byArray) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes instance");
        }
        Method method = CREATECLOB_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            CLOB cLOB = oracleConnection.createClob(byArray);
            return (CLOB)this.postForAll(method, cLOB);
        }
        catch (SQLException sQLException) {
            return (CLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClob(byte[] byArray, short s2) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes and csform instance");
        }
        Method method = CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
        this.preForAll(method, this, byArray, s2);
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            CLOB cLOB = oracleConnection.createClob(byArray, s2);
            return (CLOB)this.postForAll(method, cLOB);
        }
        catch (SQLException sQLException) {
            return (CLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB CLOBConstructorRecording(byte[] byArray, short s2, CLOB cLOB) throws SQLException {
        if (CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with locater bytes and csform instance");
        }
        Method method = CREATECLOB_WITH_LOCATOR_AND_CSFORM_METHOD;
        this.preForAll(method, this, byArray, s2);
        return (CLOB)this.postForAll(method, cLOB);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public CLOB createClobWithUnpickledBytes(byte[] byArray) throws SQLException {
        if (CREATECLOB_WITH_UNPICKLEDBYTES_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create CLOB with unpickled bytes instance");
        }
        Method method = CREATECLOB_WITH_UNPICKLEDBYTES_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            CLOB cLOB = oracleConnection.createClobWithUnpickledBytes(byArray);
            return (CLOB)this.postForAll(method, cLOB);
        }
        catch (SQLException sQLException) {
            return (CLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public NClob createNClob() throws SQLException {
        if (CREATENCLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create NCLOB instance");
        }
        Method method = CREATENCLOB_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Connection connection = (Connection)this.getDelegate();
            NClob nClob = connection.createNClob();
            return (NClob)this.postForAll(method, nClob);
        }
        catch (SQLException sQLException) {
            return (NClob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Blob createBlob() throws SQLException {
        if (CREATEBLOB_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB instance");
        }
        Method method = CREATEBLOB_METHOD;
        this.preForAll(method, this, new Object[0]);
        try {
            Connection connection = (Connection)this.getDelegate();
            Blob blob = connection.createBlob();
            return (Blob)this.postForAll(method, blob);
        }
        catch (SQLException sQLException) {
            return (Blob)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB createBlob(byte[] byArray) throws SQLException {
        if (CREATEBLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with locater bytes instance");
        }
        Method method = CREATEBLOB_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            BLOB bLOB = oracleConnection.createBlob(byArray);
            return (BLOB)this.postForAll(method, bLOB);
        }
        catch (SQLException sQLException) {
            return (BLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB createBlobWithUnpickledBytes(byte[] byArray) throws SQLException {
        if (CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with unpickled bytes instance");
        }
        Method method = CREATEBLOB_WITH_UNPICKLEDBYTES_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            BLOB bLOB = oracleConnection.createBlobWithUnpickledBytes(byArray);
            return (BLOB)this.postForAll(method, (Clob)((Object)bLOB));
        }
        catch (SQLException sQLException) {
            return (BLOB)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BLOB BLOBConstructorRecording(byte[] byArray, BLOB bLOB) throws SQLException {
        if (CREATEBLOB_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BLOB with locater bytes instance");
        }
        Method method = CREATEBLOB_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        return (BLOB)this.postForAll(method, bLOB);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE createBfile(byte[] byArray) throws SQLException {
        if (CREATEBFILE_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BFILE with locater bytes instance");
        }
        Method method = CREATEBFILE_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        try {
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            BFILE bFILE = oracleConnection.createBfile(byArray);
            return (BFILE)this.postForAll(method, bFILE);
        }
        catch (SQLException sQLException) {
            return (BFILE)this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public BFILE BFILEConstructorRecording(byte[] byArray, BFILE bFILE) throws SQLException {
        if (CREATEBFILE_WITH_LOCATOR_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot create BFILE with locater bytes instance");
        }
        Method method = CREATEBFILE_WITH_LOCATOR_METHOD;
        this.preForAll(method, this, new Object[]{byArray});
        return (BFILE)this.postForAll(method, bFILE);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Object getDescriptor(String string) throws SQLException {
        if (GETDESCRIPTOR_WITH_NAME_METHOD == null) {
            throw DatabaseError.createSqlException(1, "Cannot get getDescriptor method");
        }
        Method method = GETDESCRIPTOR_WITH_NAME_METHOD;
        this.preForAll(method, this, string);
        try {
            ProxyFactory proxyFactory;
            OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
            Object object = oracleConnection.getDescriptor(string);
            if (!(object instanceof StructDescriptor) && !(object instanceof ArrayDescriptor) && (proxyFactory = this.failoverMngr.getProxyFactory()) != null) {
                return this.postForAll(method, proxyFactory.proxyFor(object));
            }
            return this.postForAll(method, object);
        }
        catch (SQLException sQLException) {
            return this.postForAll(method, this.onErrorForAll(method, sQLException));
        }
    }

    Object unwrapProxies(Object object) {
        if (object == null) {
            return null;
        }
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n2 = objectArray.length;
            if (n2 > 0) {
                Object[] objectArray2 = new Object[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    objectArray2[i2] = this.unwrapProxies(objectArray[i2]);
                }
                return objectArray2;
            }
            return object;
        }
        if (object instanceof TxnReplayableBase) {
            return ((TxnReplayableBase)object).getDelegate();
        }
        return object;
    }

    boolean isElementTypePrimitive(Object object) {
        Class<?> clazz = object.getClass();
        while (clazz.isArray()) {
            clazz = clazz.getComponentType();
        }
        return clazz.isPrimitive();
    }

    @Override
    public ReplayStatistics getReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        return this.failoverMngr.getReplayStatistics(statisticsReportType);
    }

    @Override
    public void clearReplayStatistics(ReplayableConnection.StatisticsReportType statisticsReportType) {
        this.failoverMngr.clearReplayStatistics(statisticsReportType);
    }

    @ProxyResult(value=ProxyResultPolicy.MANUAL)
    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        LogicalConnectionImpl logicalConnectionImpl = new LogicalConnectionImpl(oraclePooledConnection, (OracleConnection)((Object)this), bl);
        return logicalConnectionImpl;
    }

    public LogicalTransactionId getLogicalTransactionId() throws SQLException {
        TxnFailoverManagerImpl.ReplayLifecycle replayLifecycle = this.failoverMngr.getReplayLifecycle();
        switch (replayLifecycle) {
            case REPLAYING_CALLBACK: {
                throw (SQLException)DatabaseError.createSqlException(368).fillInStackTrace();
            }
            case INTERNALLY_FAILED: 
            case ALWAYS_DISABLED: 
            case INTERNALLY_DISABLED: 
            case EXTERNALLY_DISABLED: {
                OracleConnection oracleConnection = (OracleConnection)this.getDelegate();
                return oracleConnection.isUsable(false) ? this.failoverMngr.getLogicalTransactionId() : this.failoverMngr.getLtxidAtOriginalOutage();
            }
        }
        return this.failoverMngr.getLogicalTransactionId();
    }
}

