/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.support.conv;

import com.amazon.support.conv.ConversionResult;
import com.amazon.support.conv.ConverterConstants;
import com.amazon.support.conv.ExactNumConverter;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ApproxNumConverter {
    private static final double SMALLEST_DOUBLE_GREATER_THAN_NEGATIVE_ONE = -1.0 + Math.ulp(1.0);
    private static final double SBIGINT_MIN = ConverterConstants.SIGNED_BIGINT_MIN.doubleValue();
    private static final double SBIGINT_MAX_PLUS_ONE = ConverterConstants.SIGNED_BIGINT_MAX.doubleValue();
    private static final double UBIGINT_MAX_PLUS_ONE = ConverterConstants.UNSIGNED_BIGINT_MAX.doubleValue();

    private ApproxNumConverter() {
        throw new UnsupportedOperationException();
    }

    public static BigDecimal toBigDecimal(double d, short s, short s2, ConversionResult conversionResult) {
        if (Double.isNaN(d)) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return null;
        }
        if (Double.POSITIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (Double.NEGATIVE_INFINITY == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        return ExactNumConverter.setPrecScale(new BigDecimal(d), s, s2, conversionResult);
    }

    public static BigInteger toBigInt(double d, boolean bl, ConversionResult conversionResult) {
        double d2;
        if (Double.isNaN(d)) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return null;
        }
        double d3 = d2 = bl ? SBIGINT_MIN : SMALLEST_DOUBLE_GREATER_THAN_NEGATIVE_ONE;
        if (d >= SBIGINT_MAX_PLUS_ONE) {
            if (!bl && d < UBIGINT_MAX_PLUS_ONE) {
                conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
                BigDecimal bigDecimal = new BigDecimal(d);
                return bigDecimal.toBigIntegerExact();
            }
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            return null;
        }
        if (d < d2) {
            conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            return null;
        }
        long l = (long)d;
        if ((double)l == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(0.0 < d ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return BigInteger.valueOf(l);
    }

    public static String toChar(double d, long l, ConversionResult conversionResult) {
        String string = Double.POSITIVE_INFINITY == d ? "INFINITY" : (Double.NEGATIVE_INFINITY == d ? "-INFINITY" : Double.toString(d));
        if ((long)string.length() <= l) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(ConversionResult.TypeConversionState.STRING_RIGHT_TRUNCATION);
            string = string.substring(0, (int)l);
        }
        return string;
    }

    public static float toFloat(double d, ConversionResult conversionResult) {
        conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        return (float)d;
    }

    public static long toInteger(double d, boolean bl, ConversionResult conversionResult) {
        double d2;
        double d3;
        long l = 0L;
        if (Double.isNaN(d)) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return l;
        }
        if (bl) {
            d3 = -2.147483648E9;
            d2 = 2.147483647E9;
        } else {
            d3 = 0.0;
            d2 = 4.294967295E9;
        }
        l = (long)d;
        if (d > d2) {
            if ((long)d2 == l) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
        } else if (d < d3) {
            if ((long)d3 == l) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            }
        } else if ((double)l == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(0.0 < d ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return l;
    }

    public static int toSmallInt(double d, boolean bl, ConversionResult conversionResult) {
        double d2;
        double d3;
        int n = 0;
        if (Double.isNaN(d)) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return n;
        }
        if (bl) {
            d3 = -32768.0;
            d2 = 32767.0;
        } else {
            d3 = 0.0;
            d2 = 65535.0;
        }
        n = (int)d;
        if (d > d2) {
            if ((int)d2 == n) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
        } else if (d < d3) {
            if ((int)d3 == n) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            }
        } else if ((double)n == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(0.0 < d ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return n;
    }

    public static short toTinyInt(double d, boolean bl, ConversionResult conversionResult) {
        double d2;
        double d3;
        int n = 0;
        if (Double.isNaN(d)) {
            conversionResult.setState(ConversionResult.TypeConversionState.INVALID_DATA);
            return (short)n;
        }
        if (bl) {
            d3 = -128.0;
            d2 = 127.0;
        } else {
            d3 = 0.0;
            d2 = 255.0;
        }
        n = (int)d;
        if (d > d2) {
            if ((int)d2 == n) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_LARGE);
            }
        } else if (d < d3) {
            if ((int)d3 == n) {
                conversionResult.setState(ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
            } else {
                conversionResult.setState(ConversionResult.TypeConversionState.NUMERIC_OUT_OF_RANGE_TOO_SMALL);
            }
        } else if ((double)n == d) {
            conversionResult.setState(ConversionResult.TypeConversionState.SUCCESS);
        } else {
            conversionResult.setState(0.0 < d ? ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_DOWN : ConversionResult.TypeConversionState.FRAC_TRUNCATION_ROUNDED_UP);
        }
        return (short)n;
    }
}

