/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core.jdbc42;

import com.amazon.dsi.core.interfaces.IStatement;
import com.amazon.dsi.dataengine.utilities.DataWrapper;
import com.amazon.dsi.dataengine.utilities.ParameterMetadata;
import com.amazon.exceptions.ExceptionConverter;
import com.amazon.jdbc.common.SConnection;
import com.amazon.jdbc.jdbc42.S42CallableStatement;
import com.amazon.redshift.core.PGDSIOverrideHelper;
import com.amazon.redshift.core.PGJDBCStatement;
import com.amazon.support.LogUtilities;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PGJDBC42CallableStatement
extends S42CallableStatement {
    public static final int NOT_REGISTERED = -11111;
    private int registeredType = -11111;

    public PGJDBC42CallableStatement(String string, IStatement iStatement, SConnection sConnection, int n) throws SQLException {
        super(string, iStatement, sConnection, n);
    }

    @Override
    protected void checkValidParameterIndex(int n) throws SQLException {
        PGDSIOverrideHelper.checkValidParameterIndex(this.m_numParameters, n, (PGJDBCStatement)this.m_statement, this.m_warningListener);
    }

    @Override
    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, n2, n3);
            this.checkIfOpen();
            this.checkValidParameterIndex(n);
            this.checkTypeSupported(n2);
            PGDSIOverrideHelper.registerOutParameter(n, n2, n3, this.m_warningListener, this.m_parameterTypes, this.m_parameterScale, n3, this.m_parameterMetadata);
            int n4 = this.getOutputParameterOnlyIndex(n);
            this.registeredType = n2;
            this.m_parameterRegistered.set(n4 - 1, Boolean.TRUE);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    protected DataWrapper getOutputParameterValue(int n) throws SQLException {
        ResultSet resultSet = null;
        if (this.m_resultSets != null) {
            resultSet = super.getResultSet();
        }
        return PGDSIOverrideHelper.getOutputParameterValue(n, resultSet, n, this.m_parameterMetadata, n);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        ParameterMetadata parameterMetadata = (ParameterMetadata)this.m_parameterMetadata.get(0);
        PGDSIOverrideHelper.execute(this.m_parameterMetadata, this.m_parameterRegistered, this.m_logger, this.m_warningListener, parameterMetadata, this.registeredType);
        return super.execute();
    }
}

