/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.amazonaws.protocol.json;

import com.amazon.redshift.amazonaws.AmazonServiceException;
import com.amazon.redshift.amazonaws.AmazonWebServiceResponse;
import com.amazon.redshift.amazonaws.SDKGlobalConfiguration;
import com.amazon.redshift.amazonaws.annotation.SdkProtectedApi;
import com.amazon.redshift.amazonaws.annotation.ThreadSafe;
import com.amazon.redshift.amazonaws.http.HttpResponseHandler;
import com.amazon.redshift.amazonaws.protocol.OperationInfo;
import com.amazon.redshift.amazonaws.protocol.Protocol;
import com.amazon.redshift.amazonaws.protocol.ProtocolRequestMarshaller;
import com.amazon.redshift.amazonaws.protocol.json.JsonClientMetadata;
import com.amazon.redshift.amazonaws.protocol.json.JsonContentTypeResolver;
import com.amazon.redshift.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazon.redshift.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazon.redshift.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazon.redshift.amazonaws.protocol.json.JsonProtocolMarshallerBuilder;
import com.amazon.redshift.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazon.redshift.amazonaws.protocol.json.SdkStructuredCborFactory;
import com.amazon.redshift.amazonaws.protocol.json.SdkStructuredIonFactory;
import com.amazon.redshift.amazonaws.protocol.json.SdkStructuredJsonFactory;
import com.amazon.redshift.amazonaws.protocol.json.SdkStructuredPlainJsonFactory;
import com.amazon.redshift.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazon.redshift.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazon.redshift.amazonaws.transform.JsonUnmarshallerContext;
import com.amazon.redshift.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import java.util.List;

@ThreadSafe
@SdkProtectedApi
public class SdkJsonProtocolFactory
implements SdkJsonMarshallerFactory {
    private final JsonClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkJsonProtocolFactory(JsonClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    @Override
    public StructuredJsonGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    @Override
    public String getContentType() {
        return this.getContentTypeResolver().resolveContentType(this.metadata);
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return JsonProtocolMarshallerBuilder.standard().jsonGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).sendExplicitNullForPayload(false).build();
    }

    private StructuredJsonGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.AWS_JSON) {
            return this.createGenerator();
        }
        return StructuredJsonGenerator.NO_OP;
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(JsonOperationMetadata operationMetadata, Unmarshaller<T, JsonUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(JsonErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(this.errorUnmarshallers, errorResponsMetadata.getCustomErrorCodeFieldName());
    }

    private void createErrorUnmarshallers() {
        for (JsonErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
    }

    private SdkStructuredJsonFactory getSdkFactory() {
        if (this.isCborEnabled()) {
            return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? SdkStructuredIonFactory.SDK_ION_BINARY_FACTORY : SdkStructuredIonFactory.SDK_ION_TEXT_FACTORY;
        }
        return SdkStructuredPlainJsonFactory.SDK_JSON_FACTORY;
    }

    private JsonContentTypeResolver getContentTypeResolver() {
        if (this.isCborEnabled()) {
            return JsonContentTypeResolver.CBOR;
        }
        if (this.isIonEnabled()) {
            return this.isIonBinaryEnabled() ? JsonContentTypeResolver.ION_BINARY : JsonContentTypeResolver.ION_TEXT;
        }
        return JsonContentTypeResolver.JSON;
    }

    private boolean isCborEnabled() {
        return this.metadata.isSupportsCbor() && !SDKGlobalConfiguration.isCborDisabled();
    }

    private boolean isIonEnabled() {
        return this.metadata.isSupportsIon();
    }

    boolean isIonBinaryEnabled() {
        return !SDKGlobalConfiguration.isIonBinaryDisabled();
    }
}

