# -------------------------------------------------------------------------------------------------
#  Copyright (C) 2015-2025 Nautech Systems Pty Ltd. All rights reserved.
#  https://nautechsystems.io
#
#  Licensed under the GNU Lesser General Public License Version 3.0 (the "License");
#  You may not use this file except in compliance with the License.
#  You may obtain a copy of the License at https://www.gnu.org/licenses/lgpl-3.0.en.html
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
# -------------------------------------------------------------------------------------------------

from typing import Any

from nautilus_trader.common.component import ComponentState
from nautilus_trader.core.message import Command
from nautilus_trader.core.message import Event
from nautilus_trader.core.uuid import UUID4
from nautilus_trader.model.enums import TradingState
from nautilus_trader.model.identifiers import ComponentId
from nautilus_trader.model.identifiers import TraderId

class ShutdownSystem(Command):
    @property
    def trader_id(self) -> TraderId: ...
    @property
    def component_id(self) -> ComponentId: ...
    @property
    def reason(self) -> str | None: ...
    @property
    def id(self) -> UUID4: ...
    @property
    def ts_init(self) -> int: ...
    @staticmethod
    def from_dict(values: dict[str, Any]) -> ShutdownSystem: ...
    @staticmethod
    def to_dict(obj: ShutdownSystem) -> dict[str, Any]: ...

class ComponentStateChanged(Event):
    @property
    def trader_id(self) -> TraderId: ...
    @property
    def component_id(self) -> ComponentId: ...
    @property
    def component_type(self) -> str: ...
    @property
    def state(self) -> ComponentState: ...
    @property
    def config(self) -> dict[str, Any]: ...
    @property
    def id(self) -> UUID4: ...
    @property
    def ts_event(self) -> int: ...
    @property
    def ts_init(self) -> int: ...
    @staticmethod
    def from_dict(values: dict[str, Any]) -> ComponentStateChanged: ...
    @staticmethod
    def to_dict(obj: ComponentStateChanged) -> dict[str, Any]: ...

class RiskEvent(Event):
    @property
    def trader_id(self) -> TraderId: ...
    @property
    def id(self) -> UUID4: ...
    @property
    def ts_event(self) -> int: ...
    @property
    def ts_init(self) -> int: ...

class TradingStateChanged(RiskEvent):
    @property
    def state(self) -> TradingState: ...
    @property
    def config(self) -> dict[str, Any]: ...
    @property
    def id(self) -> UUID4: ...
    @property
    def ts_event(self) -> int: ...
    @property
    def ts_init(self) -> int: ...
    @staticmethod
    def from_dict(values: dict[str, Any]) -> TradingStateChanged: ...
    @staticmethod
    def to_dict(obj: TradingStateChanged) -> dict[str, Any]: ...
