import { PipelineBase, PipelineBaseProps } from 'aws-cdk-lib/pipelines';
import { Construct } from 'constructs';
import { DockerCredential } from './docker-credentials';
import * as github from './workflows-model';
/**
 * Props for `GitHubWorkflow`.
 *
 * @stability stable
 */
export interface GitHubWorkflowProps extends PipelineBaseProps {
    /**
     * File path for the GitHub workflow.
     *
     * @default ".github/workflows/deploy.yml"
     * @stability stable
     */
    readonly workflowPath?: string;
    /**
     * Name of the workflow.
     *
     * @default "deploy"
     * @stability stable
     */
    readonly workflowName?: string;
    /**
     * GitHub workflow triggers.
     *
     * @default - By default, workflow is triggered on push to the `main` branch
     * and can also be triggered manually (`workflow_dispatch`).
     * @stability stable
     */
    readonly workflowTriggers?: github.Triggers;
    /**
     * Version of the CDK CLI to use.
     *
     * @default - automatic
     * @stability stable
     */
    readonly cdkCliVersion?: string;
    /**
     * Indicates if the repository already contains a synthesized `cdk.out` directory, in which case we will simply checkout the repo in jobs that require `cdk.out`.
     *
     * @default false
     * @stability stable
     */
    readonly preSynthed?: boolean;
    /**
     * Names of GitHub repository secrets that include AWS credentials for deployment.
     *
     * @default - `AWS_ACCESS_KEY_ID` and `AWS_SECRET_ACCESS_KEY`.
     * @stability stable
     */
    readonly awsCredentials?: AwsCredentialsSecrets;
    /**
     * Build container options.
     *
     * @default - GitHub defaults
     * @stability stable
     */
    readonly buildContainer?: github.ContainerOptions;
    /**
     * GitHub workflow steps to execute before build.
     *
     * @default []
     * @stability stable
     */
    readonly preBuildSteps?: github.JobStep[];
    /**
     * GitHub workflow steps to execute after build.
     *
     * @default []
     * @stability stable
     */
    readonly postBuildSteps?: github.JobStep[];
    /**
     * The Docker Credentials to use to login.
     *
     * If you set this variable,
     * you will be logged in to docker when you upload Docker Assets.
     *
     * @stability stable
     */
    readonly dockerCredentials?: DockerCredential[];
}
/**
 * CDK Pipelines for GitHub workflows.
 *
 * @stability stable
 */
export declare class GitHubWorkflow extends PipelineBase {
    /**
     * @stability stable
     */
    readonly workflowPath: string;
    /**
     * @stability stable
     */
    readonly workflowName: string;
    private readonly workflowTriggers;
    private readonly preSynthed;
    private readonly awsCredentials;
    private readonly dockerCredentials;
    private readonly cdkCliVersion?;
    private readonly buildContainer?;
    private readonly preBuildSteps;
    private readonly postBuildSteps;
    private readonly jobOutputs;
    private readonly assetHashMap;
    /**
     * @stability stable
     */
    constructor(scope: Construct, id: string, props: GitHubWorkflowProps);
    /**
     * Implemented by subclasses to do the actual pipeline construction.
     *
     * @stability stable
     */
    protected doBuildPipeline(): void;
    private insertJobOutputs;
    private renderJobOutputs;
    /**
     * Make an action from the given node and/or step
     */
    private jobForNode;
    private jobForAssetPublish;
    private jobForDeploy;
    private jobForBuildStep;
    /**
     * Searches for the stack that produced the output via the current
     * job's dependencies.
     *
     * This function should always find a stack, since it is guaranteed
     * that a CfnOutput comes from a referenced stack.
     */
    private findStackOfOutput;
    private addJobOutput;
    private jobForScriptStep;
    private stepsToConfigureAws;
    private stepsToConfigureDocker;
    private stepsToDownloadAssembly;
    private stepsToCheckout;
    private stepsToUploadAssembly;
    private renderDependencies;
}
/**
 * Names of secrets for AWS credentials.
 *
 * @stability stable
 */
export interface AwsCredentialsSecrets {
    /**
     * @default "AWS_ACCESS_KEY_ID"
     * @stability stable
     */
    readonly accessKeyId?: string;
    /**
     * @default "AWS_SECRET_ACCESS_KEY"
     * @stability stable
     */
    readonly secretAccessKey?: string;
    /**
     * @default - no session token is used
     * @stability stable
     */
    readonly sessionToken?: string;
}
export declare function flatten<A>(xs: Iterable<A[]>): IterableIterator<A>;
