"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DockerCredential = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Represents a credential used to authenticate to a docker registry.
 *
 * Uses the official Docker Login Github Action to authenticate.
 *
 * @see https://github.com/marketplace/actions/docker-login
 * @stability stable
 */
class DockerCredential {
    constructor(name, registry, usernameKey, passwordKey) {
        this.name = name;
        this.registry = registry;
        this.usernameKey = usernameKey;
        this.passwordKey = passwordKey;
    }
    /**
     * Reference credential secrets to authenticate to DockerHub.
     *
     * This method assumes
     * that your credentials will be stored as long-lived Github Secrets under the
     * usernameKey and personalAccessTokenKey.
     *
     * The default for usernameKey is `DOCKERHUB_USERNAME`. The default for personalAccessTokenKey
     * is `DOCKERHUB_TOKEN`. If you do not set these values, your credentials should be
     * found in your Github Secrets under these default keys.
     *
     * @stability stable
     */
    static dockerHub(creds = {}) {
        var _b, _c;
        return new DockerCredential('docker', undefined, (_b = creds.usernameKey) !== null && _b !== void 0 ? _b : 'DOCKERHUB_USERNAME', (_c = creds.personalAccessTokenKey) !== null && _c !== void 0 ? _c : 'DOCKERHUB_TOKEN');
    }
    /**
     * Create a credential for ECR.
     *
     * This method will reuse your AWS credentials to log in to AWS.
     * Your AWS credentials are already used to deploy your CDK stacks. It can be supplied via
     * Github Secrets or using an IAM role that trusts the Github OIDC identity provider.
     *
     * TODO: note the necessary permissions for the IAM role here.
     *
     * NOTE - All ECR repositories in the same account and region share a domain name
     * (e.g., 0123456789012.dkr.ecr.eu-west-1.amazonaws.com), and can only have one associated
     * set of credentials (and DockerCredential). Attempting to associate one set of credentials
     * with one ECR repo and another with another ECR repo in the same account and region will
     * result in failures when using these credentials in the pipeline.
     *
     * @stability stable
     */
    static ecr(registry) {
        return new DockerCredential('ecr', registry);
    }
    /**
     * Create a credential for a custom registry.
     *
     * This method assumes that you will have long-lived
     * Github Secrets stored under the usernameKey and passwordKey that will authenticate to the
     * registry you provide.
     *
     * @see https://github.com/marketplace/actions/docker-login
     * @stability stable
     */
    static customRegistry(registry, creds) {
        return new DockerCredential('custom', registry, creds.usernameKey, creds.passwordKey);
    }
}
exports.DockerCredential = DockerCredential;
_a = JSII_RTTI_SYMBOL_1;
DockerCredential[_a] = { fqn: "cdk-pipelines-github.DockerCredential", version: "0.1.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9ja2VyLWNyZWRlbnRpYWxzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL2RvY2tlci1jcmVkZW50aWFscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7O0FBQ0EsTUFBYSxnQkFBZ0I7SUFxQjNCLFlBQ1csSUFBWSxFQUNaLFFBQWlCLEVBQ2pCLFdBQW9CLEVBQ3BCLFdBQW9CO1FBSHBCLFNBQUksR0FBSixJQUFJLENBQVE7UUFDWixhQUFRLEdBQVIsUUFBUSxDQUFTO1FBQ2pCLGdCQUFXLEdBQVgsV0FBVyxDQUFTO1FBQ3BCLGdCQUFXLEdBQVgsV0FBVyxDQUFTO0lBQzVCLENBQUM7Ozs7Ozs7Ozs7Ozs7O0lBeEJHLE1BQU0sQ0FBQyxTQUFTLENBQUMsUUFBb0MsRUFBRTs7UUFDNUQsT0FBTyxJQUFJLGdCQUFnQixDQUN6QixRQUFRLEVBQ1IsU0FBUyxRQUNULEtBQUssQ0FBQyxXQUFXLG1DQUFJLG9CQUFvQixRQUN6QyxLQUFLLENBQUMsc0JBQXNCLG1DQUFJLGlCQUFpQixDQUNsRCxDQUFDO0lBQ0osQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0lBR00sTUFBTSxDQUFDLEdBQUcsQ0FBQyxRQUFnQjtRQUNoQyxPQUFPLElBQUksZ0JBQWdCLENBQUMsS0FBSyxFQUFFLFFBQVEsQ0FBQyxDQUFDO0lBQy9DLENBQUM7Ozs7Ozs7Ozs7O0lBR00sTUFBTSxDQUFDLGNBQWMsQ0FBQyxRQUFnQixFQUFFLEtBQXNDO1FBQ25GLE9BQU8sSUFBSSxnQkFBZ0IsQ0FBQyxRQUFRLEVBQUUsUUFBUSxFQUFFLEtBQUssQ0FBQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsQ0FBQyxDQUFDO0lBQ3hGLENBQUM7O0FBbkJILDRDQTJCQyIsInNvdXJjZXNDb250ZW50IjpbIiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBjbGFzcyBEb2NrZXJDcmVkZW50aWFsIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyBkb2NrZXJIdWIoY3JlZHM6IERvY2tlckh1YkNyZWRlbnRpYWxTZWNyZXRzID0ge30pOiBEb2NrZXJDcmVkZW50aWFsIHtcbiAgICByZXR1cm4gbmV3IERvY2tlckNyZWRlbnRpYWwoXG4gICAgICAnZG9ja2VyJyxcbiAgICAgIHVuZGVmaW5lZCxcbiAgICAgIGNyZWRzLnVzZXJuYW1lS2V5ID8/ICdET0NLRVJIVUJfVVNFUk5BTUUnLFxuICAgICAgY3JlZHMucGVyc29uYWxBY2Nlc3NUb2tlbktleSA/PyAnRE9DS0VSSFVCX1RPS0VOJyxcbiAgICApO1xuICB9XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGVjcihyZWdpc3RyeTogc3RyaW5nKTogRG9ja2VyQ3JlZGVudGlhbCB7XG4gICAgcmV0dXJuIG5ldyBEb2NrZXJDcmVkZW50aWFsKCdlY3InLCByZWdpc3RyeSk7XG4gIH1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICBwdWJsaWMgc3RhdGljIGN1c3RvbVJlZ2lzdHJ5KHJlZ2lzdHJ5OiBzdHJpbmcsIGNyZWRzOiBFeHRlcm5hbERvY2tlckNyZWRlbnRpYWxTZWNyZXRzKTogRG9ja2VyQ3JlZGVudGlhbCB7XG4gICAgcmV0dXJuIG5ldyBEb2NrZXJDcmVkZW50aWFsKCdjdXN0b20nLCByZWdpc3RyeSwgY3JlZHMudXNlcm5hbWVLZXksIGNyZWRzLnBhc3N3b3JkS2V5KTtcbiAgfVxuXG4gIHByaXZhdGUgY29uc3RydWN0b3IoXG4gICAgcmVhZG9ubHkgbmFtZTogc3RyaW5nLFxuICAgIHJlYWRvbmx5IHJlZ2lzdHJ5Pzogc3RyaW5nLFxuICAgIHJlYWRvbmx5IHVzZXJuYW1lS2V5Pzogc3RyaW5nLFxuICAgIHJlYWRvbmx5IHBhc3N3b3JkS2V5Pzogc3RyaW5nLFxuICApIHt9XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgRG9ja2VySHViQ3JlZGVudGlhbFNlY3JldHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHVzZXJuYW1lS2V5Pzogc3RyaW5nO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHBlcnNvbmFsQWNjZXNzVG9rZW5LZXk/OiBzdHJpbmc7XG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEV4dGVybmFsRG9ja2VyQ3JlZGVudGlhbFNlY3JldHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdXNlcm5hbWVLZXk6IHN0cmluZztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgcGFzc3dvcmRLZXk6IHN0cmluZztcbn1cbiJdfQ==