/******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 99628:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  iN: function() { return /* binding */ blue; },
  R_: function() { return /* reexport */ generate; },
  ez: function() { return /* binding */ presetPrimaryColors; }
});

// UNUSED EXPORTS: cyan, geekblue, gold, gray, green, grey, lime, magenta, orange, presetDarkPalettes, presetPalettes, purple, red, volcano, yellow

// EXTERNAL MODULE: ../../node_modules/.pnpm/@ctrl+tinycolor@3.6.1/node_modules/@ctrl/tinycolor/dist/module/conversion.js
var conversion = __webpack_require__(20117);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@ctrl+tinycolor@3.6.1/node_modules/@ctrl/tinycolor/dist/module/format-input.js
var format_input = __webpack_require__(76981);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+colors@7.0.2/node_modules/@ant-design/colors/es/generate.js

var hueStep = 2; // 色相阶梯
var saturationStep = 0.16; // 饱和度阶梯，浅色部分
var saturationStep2 = 0.05; // 饱和度阶梯，深色部分
var brightnessStep1 = 0.05; // 亮度阶梯，浅色部分
var brightnessStep2 = 0.15; // 亮度阶梯，深色部分
var lightColorCount = 5; // 浅色数量，主色上
var darkColorCount = 4; // 深色数量，主色下
// 暗色主题颜色映射关系表
var darkColorMap = [{
  index: 7,
  opacity: 0.15
}, {
  index: 6,
  opacity: 0.25
}, {
  index: 5,
  opacity: 0.3
}, {
  index: 5,
  opacity: 0.45
}, {
  index: 5,
  opacity: 0.65
}, {
  index: 5,
  opacity: 0.85
}, {
  index: 4,
  opacity: 0.9
}, {
  index: 3,
  opacity: 0.95
}, {
  index: 2,
  opacity: 0.97
}, {
  index: 1,
  opacity: 0.98
}];
// Wrapper function ported from TinyColor.prototype.toHsv
// Keep it here because of `hsv.h * 360`
function toHsv(_ref) {
  var r = _ref.r,
    g = _ref.g,
    b = _ref.b;
  var hsv = (0,conversion/* rgbToHsv */.py)(r, g, b);
  return {
    h: hsv.h * 360,
    s: hsv.s,
    v: hsv.v
  };
}

// Wrapper function ported from TinyColor.prototype.toHexString
// Keep it here because of the prefix `#`
function toHex(_ref2) {
  var r = _ref2.r,
    g = _ref2.g,
    b = _ref2.b;
  return "#".concat((0,conversion/* rgbToHex */.vq)(r, g, b, false));
}

// Wrapper function ported from TinyColor.prototype.mix, not treeshakable.
// Amount in range [0, 1]
// Assume color1 & color2 has no alpha, since the following src code did so.
function mix(rgb1, rgb2, amount) {
  var p = amount / 100;
  var rgb = {
    r: (rgb2.r - rgb1.r) * p + rgb1.r,
    g: (rgb2.g - rgb1.g) * p + rgb1.g,
    b: (rgb2.b - rgb1.b) * p + rgb1.b
  };
  return rgb;
}
function getHue(hsv, i, light) {
  var hue;
  // 根据色相不同，色相转向不同
  if (Math.round(hsv.h) >= 60 && Math.round(hsv.h) <= 240) {
    hue = light ? Math.round(hsv.h) - hueStep * i : Math.round(hsv.h) + hueStep * i;
  } else {
    hue = light ? Math.round(hsv.h) + hueStep * i : Math.round(hsv.h) - hueStep * i;
  }
  if (hue < 0) {
    hue += 360;
  } else if (hue >= 360) {
    hue -= 360;
  }
  return hue;
}
function getSaturation(hsv, i, light) {
  // grey color don't change saturation
  if (hsv.h === 0 && hsv.s === 0) {
    return hsv.s;
  }
  var saturation;
  if (light) {
    saturation = hsv.s - saturationStep * i;
  } else if (i === darkColorCount) {
    saturation = hsv.s + saturationStep;
  } else {
    saturation = hsv.s + saturationStep2 * i;
  }
  // 边界值修正
  if (saturation > 1) {
    saturation = 1;
  }
  // 第一格的 s 限制在 0.06-0.1 之间
  if (light && i === lightColorCount && saturation > 0.1) {
    saturation = 0.1;
  }
  if (saturation < 0.06) {
    saturation = 0.06;
  }
  return Number(saturation.toFixed(2));
}
function getValue(hsv, i, light) {
  var value;
  if (light) {
    value = hsv.v + brightnessStep1 * i;
  } else {
    value = hsv.v - brightnessStep2 * i;
  }
  if (value > 1) {
    value = 1;
  }
  return Number(value.toFixed(2));
}
function generate(color) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var patterns = [];
  var pColor = (0,format_input/* inputToRGB */.uA)(color);
  for (var i = lightColorCount; i > 0; i -= 1) {
    var hsv = toHsv(pColor);
    var colorString = toHex((0,format_input/* inputToRGB */.uA)({
      h: getHue(hsv, i, true),
      s: getSaturation(hsv, i, true),
      v: getValue(hsv, i, true)
    }));
    patterns.push(colorString);
  }
  patterns.push(toHex(pColor));
  for (var _i = 1; _i <= darkColorCount; _i += 1) {
    var _hsv = toHsv(pColor);
    var _colorString = toHex((0,format_input/* inputToRGB */.uA)({
      h: getHue(_hsv, _i),
      s: getSaturation(_hsv, _i),
      v: getValue(_hsv, _i)
    }));
    patterns.push(_colorString);
  }

  // dark theme patterns
  if (opts.theme === 'dark') {
    return darkColorMap.map(function (_ref3) {
      var index = _ref3.index,
        opacity = _ref3.opacity;
      var darkColorString = toHex(mix((0,format_input/* inputToRGB */.uA)(opts.backgroundColor || '#141414'), (0,format_input/* inputToRGB */.uA)(patterns[index]), opacity * 100));
      return darkColorString;
    });
  }
  return patterns;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+colors@7.0.2/node_modules/@ant-design/colors/es/index.js

var presetPrimaryColors = {
  red: '#F5222D',
  volcano: '#FA541C',
  orange: '#FA8C16',
  gold: '#FAAD14',
  yellow: '#FADB14',
  lime: '#A0D911',
  green: '#52C41A',
  cyan: '#13C2C2',
  blue: '#1677FF',
  geekblue: '#2F54EB',
  purple: '#722ED1',
  magenta: '#EB2F96',
  grey: '#666666'
};
var presetPalettes = {};
var presetDarkPalettes = {};
Object.keys(presetPrimaryColors).forEach(function (key) {
  presetPalettes[key] = generate(presetPrimaryColors[key]);
  presetPalettes[key].primary = presetPalettes[key][5];

  // dark presetPalettes
  presetDarkPalettes[key] = generate(presetPrimaryColors[key], {
    theme: 'dark',
    backgroundColor: '#141414'
  });
  presetDarkPalettes[key].primary = presetDarkPalettes[key][5];
});
var red = presetPalettes.red;
var volcano = presetPalettes.volcano;
var gold = presetPalettes.gold;
var orange = presetPalettes.orange;
var yellow = presetPalettes.yellow;
var lime = presetPalettes.lime;
var green = presetPalettes.green;
var cyan = presetPalettes.cyan;
var blue = presetPalettes.blue;
var geekblue = presetPalettes.geekblue;
var purple = presetPalettes.purple;
var magenta = presetPalettes.magenta;
var grey = presetPalettes.grey;
var gray = presetPalettes.grey;


/***/ }),

/***/ 34711:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Z: function() { return /* binding */ AntdIcon; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(83573);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/slicedToArray.js + 1 modules
var slicedToArray = __webpack_require__(29852);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/defineProperty.js
var defineProperty = __webpack_require__(32134);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/objectWithoutProperties.js + 1 modules
var objectWithoutProperties = __webpack_require__(93901);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
// EXTERNAL MODULE: ../../node_modules/.pnpm/classnames@2.5.1/node_modules/classnames/index.js
var classnames = __webpack_require__(51865);
var classnames_default = /*#__PURE__*/__webpack_require__.n(classnames);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+colors@7.0.2/node_modules/@ant-design/colors/es/index.js + 1 modules
var es = __webpack_require__(99628);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/Context.js
var Context = __webpack_require__(51262);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/objectSpread2.js
var objectSpread2 = __webpack_require__(6480);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/typeof.js
var esm_typeof = __webpack_require__(75158);
// EXTERNAL MODULE: ../../node_modules/.pnpm/rc-util@5.41.0_react-dom@18.3.1_react@18.3.1/node_modules/rc-util/es/Dom/dynamicCSS.js
var dynamicCSS = __webpack_require__(10217);
// EXTERNAL MODULE: ../../node_modules/.pnpm/rc-util@5.41.0_react-dom@18.3.1_react@18.3.1/node_modules/rc-util/es/Dom/shadow.js
var shadow = __webpack_require__(50310);
// EXTERNAL MODULE: ../../node_modules/.pnpm/rc-util@5.41.0_react-dom@18.3.1_react@18.3.1/node_modules/rc-util/es/warning.js
var warning = __webpack_require__(22681);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/utils.js








function camelCase(input) {
  return input.replace(/-(.)/g, function (match, g) {
    return g.toUpperCase();
  });
}
function utils_warning(valid, message) {
  (0,warning/* default */.ZP)(valid, "[@ant-design/icons] ".concat(message));
}
function isIconDefinition(target) {
  return (0,esm_typeof/* default */.Z)(target) === 'object' && typeof target.name === 'string' && typeof target.theme === 'string' && ((0,esm_typeof/* default */.Z)(target.icon) === 'object' || typeof target.icon === 'function');
}
function normalizeAttrs() {
  var attrs = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return Object.keys(attrs).reduce(function (acc, key) {
    var val = attrs[key];
    switch (key) {
      case 'class':
        acc.className = val;
        delete acc.class;
        break;
      default:
        delete acc[key];
        acc[camelCase(key)] = val;
    }
    return acc;
  }, {});
}
function generate(node, key, rootProps) {
  if (!rootProps) {
    return /*#__PURE__*/react.createElement(node.tag, (0,objectSpread2/* default */.Z)({
      key: key
    }, normalizeAttrs(node.attrs)), (node.children || []).map(function (child, index) {
      return generate(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
    }));
  }
  return /*#__PURE__*/react.createElement(node.tag, (0,objectSpread2/* default */.Z)((0,objectSpread2/* default */.Z)({
    key: key
  }, normalizeAttrs(node.attrs)), rootProps), (node.children || []).map(function (child, index) {
    return generate(child, "".concat(key, "-").concat(node.tag, "-").concat(index));
  }));
}
function getSecondaryColor(primaryColor) {
  // choose the second color
  return (0,es/* generate */.R_)(primaryColor)[0];
}
function normalizeTwoToneColors(twoToneColor) {
  if (!twoToneColor) {
    return [];
  }
  return Array.isArray(twoToneColor) ? twoToneColor : [twoToneColor];
}

// These props make sure that the SVG behaviours like general text.
// Reference: https://blog.prototypr.io/align-svg-icons-to-text-and-say-goodbye-to-font-icons-d44b3d7b26b4
var svgBaseProps = {
  width: '1em',
  height: '1em',
  fill: 'currentColor',
  'aria-hidden': 'true',
  focusable: 'false'
};
var iconStyles = "\n.anticon {\n  display: inline-flex;\n  align-items: center;\n  color: inherit;\n  font-style: normal;\n  line-height: 0;\n  text-align: center;\n  text-transform: none;\n  vertical-align: -0.125em;\n  text-rendering: optimizeLegibility;\n  -webkit-font-smoothing: antialiased;\n  -moz-osx-font-smoothing: grayscale;\n}\n\n.anticon > * {\n  line-height: 1;\n}\n\n.anticon svg {\n  display: inline-block;\n}\n\n.anticon::before {\n  display: none;\n}\n\n.anticon .anticon-icon {\n  display: block;\n}\n\n.anticon[tabindex] {\n  cursor: pointer;\n}\n\n.anticon-spin::before,\n.anticon-spin {\n  display: inline-block;\n  -webkit-animation: loadingCircle 1s infinite linear;\n  animation: loadingCircle 1s infinite linear;\n}\n\n@-webkit-keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n\n@keyframes loadingCircle {\n  100% {\n    -webkit-transform: rotate(360deg);\n    transform: rotate(360deg);\n  }\n}\n";
var useInsertStyles = function useInsertStyles(eleRef) {
  var _useContext = (0,react.useContext)(Context/* default */.Z),
    csp = _useContext.csp,
    prefixCls = _useContext.prefixCls;
  var mergedStyleStr = iconStyles;
  if (prefixCls) {
    mergedStyleStr = mergedStyleStr.replace(/anticon/g, prefixCls);
  }
  (0,react.useEffect)(function () {
    var ele = eleRef.current;
    var shadowRoot = (0,shadow/* getShadowRoot */.A)(ele);
    (0,dynamicCSS/* updateCSS */.hq)(mergedStyleStr, '@ant-design-icons', {
      prepend: true,
      csp: csp,
      attachTo: shadowRoot
    });
  }, []);
};
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/IconBase.js


var _excluded = ["icon", "className", "onClick", "style", "primaryColor", "secondaryColor"];


var twoToneColorPalette = {
  primaryColor: '#333',
  secondaryColor: '#E6E6E6',
  calculated: false
};
function setTwoToneColors(_ref) {
  var primaryColor = _ref.primaryColor,
    secondaryColor = _ref.secondaryColor;
  twoToneColorPalette.primaryColor = primaryColor;
  twoToneColorPalette.secondaryColor = secondaryColor || getSecondaryColor(primaryColor);
  twoToneColorPalette.calculated = !!secondaryColor;
}
function getTwoToneColors() {
  return (0,objectSpread2/* default */.Z)({}, twoToneColorPalette);
}
var IconBase = function IconBase(props) {
  var icon = props.icon,
    className = props.className,
    onClick = props.onClick,
    style = props.style,
    primaryColor = props.primaryColor,
    secondaryColor = props.secondaryColor,
    restProps = (0,objectWithoutProperties/* default */.Z)(props, _excluded);
  var svgRef = react.useRef();
  var colors = twoToneColorPalette;
  if (primaryColor) {
    colors = {
      primaryColor: primaryColor,
      secondaryColor: secondaryColor || getSecondaryColor(primaryColor)
    };
  }
  useInsertStyles(svgRef);
  utils_warning(isIconDefinition(icon), "icon should be icon definiton, but got ".concat(icon));
  if (!isIconDefinition(icon)) {
    return null;
  }
  var target = icon;
  if (target && typeof target.icon === 'function') {
    target = (0,objectSpread2/* default */.Z)((0,objectSpread2/* default */.Z)({}, target), {}, {
      icon: target.icon(colors.primaryColor, colors.secondaryColor)
    });
  }
  return generate(target.icon, "svg-".concat(target.name), (0,objectSpread2/* default */.Z)((0,objectSpread2/* default */.Z)({
    className: className,
    onClick: onClick,
    style: style,
    'data-icon': target.name,
    width: '1em',
    height: '1em',
    fill: 'currentColor',
    'aria-hidden': 'true'
  }, restProps), {}, {
    ref: svgRef
  }));
};
IconBase.displayName = 'IconReact';
IconBase.getTwoToneColors = getTwoToneColors;
IconBase.setTwoToneColors = setTwoToneColors;
/* harmony default export */ var components_IconBase = (IconBase);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/twoTonePrimaryColor.js



function setTwoToneColor(twoToneColor) {
  var _normalizeTwoToneColo = normalizeTwoToneColors(twoToneColor),
    _normalizeTwoToneColo2 = (0,slicedToArray/* default */.Z)(_normalizeTwoToneColo, 2),
    primaryColor = _normalizeTwoToneColo2[0],
    secondaryColor = _normalizeTwoToneColo2[1];
  return components_IconBase.setTwoToneColors({
    primaryColor: primaryColor,
    secondaryColor: secondaryColor
  });
}
function getTwoToneColor() {
  var colors = components_IconBase.getTwoToneColors();
  if (!colors.calculated) {
    return colors.primaryColor;
  }
  return [colors.primaryColor, colors.secondaryColor];
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/AntdIcon.js
'use client';





var AntdIcon_excluded = ["className", "icon", "spin", "rotate", "tabIndex", "onClick", "twoToneColor"];







// Initial setting
// should move it to antd main repo?
setTwoToneColor(es/* blue */.iN.primary);

// https://github.com/DefinitelyTyped/DefinitelyTyped/issues/34757#issuecomment-488848720

var Icon = /*#__PURE__*/react.forwardRef(function (props, ref) {
  var className = props.className,
    icon = props.icon,
    spin = props.spin,
    rotate = props.rotate,
    tabIndex = props.tabIndex,
    onClick = props.onClick,
    twoToneColor = props.twoToneColor,
    restProps = (0,objectWithoutProperties/* default */.Z)(props, AntdIcon_excluded);
  var _React$useContext = react.useContext(Context/* default */.Z),
    _React$useContext$pre = _React$useContext.prefixCls,
    prefixCls = _React$useContext$pre === void 0 ? 'anticon' : _React$useContext$pre,
    rootClassName = _React$useContext.rootClassName;
  var classString = classnames_default()(rootClassName, prefixCls, (0,defineProperty/* default */.Z)((0,defineProperty/* default */.Z)({}, "".concat(prefixCls, "-").concat(icon.name), !!icon.name), "".concat(prefixCls, "-spin"), !!spin || icon.name === 'loading'), className);
  var iconTabIndex = tabIndex;
  if (iconTabIndex === undefined && onClick) {
    iconTabIndex = -1;
  }
  var svgStyle = rotate ? {
    msTransform: "rotate(".concat(rotate, "deg)"),
    transform: "rotate(".concat(rotate, "deg)")
  } : undefined;
  var _normalizeTwoToneColo = normalizeTwoToneColors(twoToneColor),
    _normalizeTwoToneColo2 = (0,slicedToArray/* default */.Z)(_normalizeTwoToneColo, 2),
    primaryColor = _normalizeTwoToneColo2[0],
    secondaryColor = _normalizeTwoToneColo2[1];
  return /*#__PURE__*/react.createElement("span", (0,esm_extends/* default */.Z)({
    role: "img",
    "aria-label": icon.name
  }, restProps, {
    ref: ref,
    tabIndex: iconTabIndex,
    onClick: onClick,
    className: classString
  }), /*#__PURE__*/react.createElement(components_IconBase, {
    icon: icon,
    primaryColor: primaryColor,
    secondaryColor: secondaryColor,
    style: svgStyle
  }));
});
Icon.displayName = 'AntdIcon';
Icon.getTwoToneColor = getTwoToneColor;
Icon.setTwoToneColor = setTwoToneColor;
/* harmony default export */ var AntdIcon = (Icon);

/***/ }),

/***/ 51262:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(58757);

var IconContext = /*#__PURE__*/(0,react__WEBPACK_IMPORTED_MODULE_0__.createContext)({});
/* harmony default export */ __webpack_exports__.Z = (IconContext);

/***/ }),

/***/ 80283:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Z: function() { return /* binding */ icons_CloseOutlined; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(83573);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons-svg@4.4.2/node_modules/@ant-design/icons-svg/es/asn/CloseOutlined.js
// This icon file is generated automatically.
var CloseOutlined = { "icon": { "tag": "svg", "attrs": { "fill-rule": "evenodd", "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M799.86 166.31c.02 0 .04.02.08.06l57.69 57.7c.04.03.05.05.06.08a.12.12 0 010 .06c0 .03-.02.05-.06.09L569.93 512l287.7 287.7c.04.04.05.06.06.09a.12.12 0 010 .07c0 .02-.02.04-.06.08l-57.7 57.69c-.03.04-.05.05-.07.06a.12.12 0 01-.07 0c-.03 0-.05-.02-.09-.06L512 569.93l-287.7 287.7c-.04.04-.06.05-.09.06a.12.12 0 01-.07 0c-.02 0-.04-.02-.08-.06l-57.69-57.7c-.04-.03-.05-.05-.06-.07a.12.12 0 010-.07c0-.03.02-.05.06-.09L454.07 512l-287.7-287.7c-.04-.04-.05-.06-.06-.09a.12.12 0 010-.07c0-.02.02-.04.06-.08l57.7-57.69c.03-.04.05-.05.07-.06a.12.12 0 01.07 0c.03 0 .05.02.09.06L512 454.07l287.7-287.7c.04-.04.06-.05.09-.06a.12.12 0 01.07 0z" } }] }, "name": "close", "theme": "outlined" };
/* harmony default export */ var asn_CloseOutlined = (CloseOutlined);

// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/AntdIcon.js + 3 modules
var AntdIcon = __webpack_require__(34711);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/icons/CloseOutlined.js

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var CloseOutlined_CloseOutlined = function CloseOutlined(props, ref) {
  return /*#__PURE__*/react.createElement(AntdIcon/* default */.Z, (0,esm_extends/* default */.Z)({}, props, {
    ref: ref,
    icon: asn_CloseOutlined
  }));
};

/**![close](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIGZpbGw9IiNjYWNhY2EiIGZpbGwtcnVsZT0iZXZlbm9kZCIgdmlld0JveD0iNjQgNjQgODk2IDg5NiIgZm9jdXNhYmxlPSJmYWxzZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj48cGF0aCBkPSJNNzk5Ljg2IDE2Ni4zMWMuMDIgMCAuMDQuMDIuMDguMDZsNTcuNjkgNTcuN2MuMDQuMDMuMDUuMDUuMDYuMDhhLjEyLjEyIDAgMDEwIC4wNmMwIC4wMy0uMDIuMDUtLjA2LjA5TDU2OS45MyA1MTJsMjg3LjcgMjg3LjdjLjA0LjA0LjA1LjA2LjA2LjA5YS4xMi4xMiAwIDAxMCAuMDdjMCAuMDItLjAyLjA0LS4wNi4wOGwtNTcuNyA1Ny42OWMtLjAzLjA0LS4wNS4wNS0uMDcuMDZhLjEyLjEyIDAgMDEtLjA3IDBjLS4wMyAwLS4wNS0uMDItLjA5LS4wNkw1MTIgNTY5LjkzbC0yODcuNyAyODcuN2MtLjA0LjA0LS4wNi4wNS0uMDkuMDZhLjEyLjEyIDAgMDEtLjA3IDBjLS4wMiAwLS4wNC0uMDItLjA4LS4wNmwtNTcuNjktNTcuN2MtLjA0LS4wMy0uMDUtLjA1LS4wNi0uMDdhLjEyLjEyIDAgMDEwLS4wN2MwLS4wMy4wMi0uMDUuMDYtLjA5TDQ1NC4wNyA1MTJsLTI4Ny43LTI4Ny43Yy0uMDQtLjA0LS4wNS0uMDYtLjA2LS4wOWEuMTIuMTIgMCAwMTAtLjA3YzAtLjAyLjAyLS4wNC4wNi0uMDhsNTcuNy01Ny42OWMuMDMtLjA0LjA1LS4wNS4wNy0uMDZhLjEyLjEyIDAgMDEuMDcgMGMuMDMgMCAuMDUuMDIuMDkuMDZMNTEyIDQ1NC4wN2wyODcuNy0yODcuN2MuMDQtLjA0LjA2LS4wNS4wOS0uMDZhLjEyLjEyIDAgMDEuMDcgMHoiIC8+PC9zdmc+) */
var RefIcon = /*#__PURE__*/react.forwardRef(CloseOutlined_CloseOutlined);
if (false) {}
/* harmony default export */ var icons_CloseOutlined = (RefIcon);

/***/ }),

/***/ 327:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Z: function() { return /* binding */ icons_DownOutlined; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(83573);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons-svg@4.4.2/node_modules/@ant-design/icons-svg/es/asn/DownOutlined.js
// This icon file is generated automatically.
var DownOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M884 256h-75c-5.1 0-9.9 2.5-12.9 6.6L512 654.2 227.9 262.6c-3-4.1-7.8-6.6-12.9-6.6h-75c-6.5 0-10.3 7.4-6.5 12.7l352.6 486.1c12.8 17.6 39 17.6 51.7 0l352.6-486.1c3.9-5.3.1-12.7-6.4-12.7z" } }] }, "name": "down", "theme": "outlined" };
/* harmony default export */ var asn_DownOutlined = (DownOutlined);

// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/AntdIcon.js + 3 modules
var AntdIcon = __webpack_require__(34711);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/icons/DownOutlined.js

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var DownOutlined_DownOutlined = function DownOutlined(props, ref) {
  return /*#__PURE__*/react.createElement(AntdIcon/* default */.Z, (0,esm_extends/* default */.Z)({}, props, {
    ref: ref,
    icon: asn_DownOutlined
  }));
};

/**![down](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIGZpbGw9IiNjYWNhY2EiIHZpZXdCb3g9IjY0IDY0IDg5NiA4OTYiIGZvY3VzYWJsZT0iZmFsc2UiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTg4NCAyNTZoLTc1Yy01LjEgMC05LjkgMi41LTEyLjkgNi42TDUxMiA2NTQuMiAyMjcuOSAyNjIuNmMtMy00LjEtNy44LTYuNi0xMi45LTYuNmgtNzVjLTYuNSAwLTEwLjMgNy40LTYuNSAxMi43bDM1Mi42IDQ4Ni4xYzEyLjggMTcuNiAzOSAxNy42IDUxLjcgMGwzNTIuNi00ODYuMWMzLjktNS4zLjEtMTIuNy02LjQtMTIuN3oiIC8+PC9zdmc+) */
var RefIcon = /*#__PURE__*/react.forwardRef(DownOutlined_DownOutlined);
if (false) {}
/* harmony default export */ var icons_DownOutlined = (RefIcon);

/***/ }),

/***/ 36487:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Z: function() { return /* binding */ icons_EllipsisOutlined; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(83573);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons-svg@4.4.2/node_modules/@ant-design/icons-svg/es/asn/EllipsisOutlined.js
// This icon file is generated automatically.
var EllipsisOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M176 511a56 56 0 10112 0 56 56 0 10-112 0zm280 0a56 56 0 10112 0 56 56 0 10-112 0zm280 0a56 56 0 10112 0 56 56 0 10-112 0z" } }] }, "name": "ellipsis", "theme": "outlined" };
/* harmony default export */ var asn_EllipsisOutlined = (EllipsisOutlined);

// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/AntdIcon.js + 3 modules
var AntdIcon = __webpack_require__(34711);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/icons/EllipsisOutlined.js

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var EllipsisOutlined_EllipsisOutlined = function EllipsisOutlined(props, ref) {
  return /*#__PURE__*/react.createElement(AntdIcon/* default */.Z, (0,esm_extends/* default */.Z)({}, props, {
    ref: ref,
    icon: asn_EllipsisOutlined
  }));
};

/**![ellipsis](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIGZpbGw9IiNjYWNhY2EiIHZpZXdCb3g9IjY0IDY0IDg5NiA4OTYiIGZvY3VzYWJsZT0iZmFsc2UiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTE3NiA1MTFhNTYgNTYgMCAxMDExMiAwIDU2IDU2IDAgMTAtMTEyIDB6bTI4MCAwYTU2IDU2IDAgMTAxMTIgMCA1NiA1NiAwIDEwLTExMiAwem0yODAgMGE1NiA1NiAwIDEwMTEyIDAgNTYgNTYgMCAxMC0xMTIgMHoiIC8+PC9zdmc+) */
var RefIcon = /*#__PURE__*/react.forwardRef(EllipsisOutlined_EllipsisOutlined);
if (false) {}
/* harmony default export */ var icons_EllipsisOutlined = (RefIcon);

/***/ }),

/***/ 50943:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Z: function() { return /* binding */ icons_FileOutlined; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(83573);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons-svg@4.4.2/node_modules/@ant-design/icons-svg/es/asn/FileOutlined.js
// This icon file is generated automatically.
var FileOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M854.6 288.6L639.4 73.4c-6-6-14.1-9.4-22.6-9.4H192c-17.7 0-32 14.3-32 32v832c0 17.7 14.3 32 32 32h640c17.7 0 32-14.3 32-32V311.3c0-8.5-3.4-16.7-9.4-22.7zM790.2 326H602V137.8L790.2 326zm1.8 562H232V136h302v216a42 42 0 0042 42h216v494z" } }] }, "name": "file", "theme": "outlined" };
/* harmony default export */ var asn_FileOutlined = (FileOutlined);

// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/AntdIcon.js + 3 modules
var AntdIcon = __webpack_require__(34711);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/icons/FileOutlined.js

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var FileOutlined_FileOutlined = function FileOutlined(props, ref) {
  return /*#__PURE__*/react.createElement(AntdIcon/* default */.Z, (0,esm_extends/* default */.Z)({}, props, {
    ref: ref,
    icon: asn_FileOutlined
  }));
};

/**![file](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIGZpbGw9IiNjYWNhY2EiIHZpZXdCb3g9IjY0IDY0IDg5NiA4OTYiIGZvY3VzYWJsZT0iZmFsc2UiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTg1NC42IDI4OC42TDYzOS40IDczLjRjLTYtNi0xNC4xLTkuNC0yMi42LTkuNEgxOTJjLTE3LjcgMC0zMiAxNC4zLTMyIDMydjgzMmMwIDE3LjcgMTQuMyAzMiAzMiAzMmg2NDBjMTcuNyAwIDMyLTE0LjMgMzItMzJWMzExLjNjMC04LjUtMy40LTE2LjctOS40LTIyLjd6TTc5MC4yIDMyNkg2MDJWMTM3LjhMNzkwLjIgMzI2em0xLjggNTYySDIzMlYxMzZoMzAydjIxNmE0MiA0MiAwIDAwNDIgNDJoMjE2djQ5NHoiIC8+PC9zdmc+) */
var RefIcon = /*#__PURE__*/react.forwardRef(FileOutlined_FileOutlined);
if (false) {}
/* harmony default export */ var icons_FileOutlined = (RefIcon);

/***/ }),

/***/ 13821:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  Z: function() { return /* binding */ icons_PlusOutlined; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@babel+runtime@7.24.7/node_modules/@babel/runtime/helpers/esm/extends.js
var esm_extends = __webpack_require__(83573);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons-svg@4.4.2/node_modules/@ant-design/icons-svg/es/asn/PlusOutlined.js
// This icon file is generated automatically.
var PlusOutlined = { "icon": { "tag": "svg", "attrs": { "viewBox": "64 64 896 896", "focusable": "false" }, "children": [{ "tag": "path", "attrs": { "d": "M482 152h60q8 0 8 8v704q0 8-8 8h-60q-8 0-8-8V160q0-8 8-8z" } }, { "tag": "path", "attrs": { "d": "M192 474h672q8 0 8 8v60q0 8-8 8H160q-8 0-8-8v-60q0-8 8-8z" } }] }, "name": "plus", "theme": "outlined" };
/* harmony default export */ var asn_PlusOutlined = (PlusOutlined);

// EXTERNAL MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/components/AntdIcon.js + 3 modules
var AntdIcon = __webpack_require__(34711);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@ant-design+icons@5.3.7_react-dom@18.3.1_react@18.3.1/node_modules/@ant-design/icons/es/icons/PlusOutlined.js

// GENERATE BY ./scripts/generate.ts
// DON NOT EDIT IT MANUALLY




var PlusOutlined_PlusOutlined = function PlusOutlined(props, ref) {
  return /*#__PURE__*/react.createElement(AntdIcon/* default */.Z, (0,esm_extends/* default */.Z)({}, props, {
    ref: ref,
    icon: asn_PlusOutlined
  }));
};

/**![plus](data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNTAiIGhlaWdodD0iNTAiIGZpbGw9IiNjYWNhY2EiIHZpZXdCb3g9IjY0IDY0IDg5NiA4OTYiIGZvY3VzYWJsZT0iZmFsc2UiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+PHBhdGggZD0iTTQ4MiAxNTJoNjBxOCAwIDggOHY3MDRxMCA4LTggOGgtNjBxLTggMC04LThWMTYwcTAtOCA4LTh6IiAvPjxwYXRoIGQ9Ik0xOTIgNDc0aDY3MnE4IDAgOCA4djYwcTAgOC04IDhIMTYwcS04IDAtOC04di02MHEwLTggOC04eiIgLz48L3N2Zz4=) */
var RefIcon = /*#__PURE__*/react.forwardRef(PlusOutlined_PlusOutlined);
if (false) {}
/* harmony default export */ var icons_PlusOutlined = (RefIcon);

/***/ }),

/***/ 20117:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   T6: function() { return /* binding */ convertHexToDecimal; },
/* harmony export */   VD: function() { return /* binding */ parseIntFromHex; },
/* harmony export */   WE: function() { return /* binding */ hsvToRgb; },
/* harmony export */   Yt: function() { return /* binding */ numberInputToObject; },
/* harmony export */   lC: function() { return /* binding */ rgbToHsl; },
/* harmony export */   py: function() { return /* binding */ rgbToHsv; },
/* harmony export */   rW: function() { return /* binding */ rgbToRgb; },
/* harmony export */   s: function() { return /* binding */ rgbaToHex; },
/* harmony export */   ve: function() { return /* binding */ hslToRgb; },
/* harmony export */   vq: function() { return /* binding */ rgbToHex; }
/* harmony export */ });
/* unused harmony exports rgbaToArgbHex, convertDecimalToHex */
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(33146);

// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:
// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>
/**
 * Handle bounds / percentage checking to conform to CSS color spec
 * <http://www.w3.org/TR/css3-color/>
 * *Assumes:* r, g, b in [0, 255] or [0, 1]
 * *Returns:* { r, g, b } in [0, 255]
 */
function rgbToRgb(r, g, b) {
    return {
        r: (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(r, 255) * 255,
        g: (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(g, 255) * 255,
        b: (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(b, 255) * 255,
    };
}
/**
 * Converts an RGB color value to HSL.
 * *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]
 * *Returns:* { h, s, l } in [0,1]
 */
function rgbToHsl(r, g, b) {
    r = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(r, 255);
    g = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(g, 255);
    b = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(b, 255);
    var max = Math.max(r, g, b);
    var min = Math.min(r, g, b);
    var h = 0;
    var s = 0;
    var l = (max + min) / 2;
    if (max === min) {
        s = 0;
        h = 0; // achromatic
    }
    else {
        var d = max - min;
        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
        switch (max) {
            case r:
                h = (g - b) / d + (g < b ? 6 : 0);
                break;
            case g:
                h = (b - r) / d + 2;
                break;
            case b:
                h = (r - g) / d + 4;
                break;
            default:
                break;
        }
        h /= 6;
    }
    return { h: h, s: s, l: l };
}
function hue2rgb(p, q, t) {
    if (t < 0) {
        t += 1;
    }
    if (t > 1) {
        t -= 1;
    }
    if (t < 1 / 6) {
        return p + (q - p) * (6 * t);
    }
    if (t < 1 / 2) {
        return q;
    }
    if (t < 2 / 3) {
        return p + (q - p) * (2 / 3 - t) * 6;
    }
    return p;
}
/**
 * Converts an HSL color value to RGB.
 *
 * *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]
 * *Returns:* { r, g, b } in the set [0, 255]
 */
function hslToRgb(h, s, l) {
    var r;
    var g;
    var b;
    h = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(h, 360);
    s = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(s, 100);
    l = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(l, 100);
    if (s === 0) {
        // achromatic
        g = l;
        b = l;
        r = l;
    }
    else {
        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        var p = 2 * l - q;
        r = hue2rgb(p, q, h + 1 / 3);
        g = hue2rgb(p, q, h);
        b = hue2rgb(p, q, h - 1 / 3);
    }
    return { r: r * 255, g: g * 255, b: b * 255 };
}
/**
 * Converts an RGB color value to HSV
 *
 * *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]
 * *Returns:* { h, s, v } in [0,1]
 */
function rgbToHsv(r, g, b) {
    r = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(r, 255);
    g = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(g, 255);
    b = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(b, 255);
    var max = Math.max(r, g, b);
    var min = Math.min(r, g, b);
    var h = 0;
    var v = max;
    var d = max - min;
    var s = max === 0 ? 0 : d / max;
    if (max === min) {
        h = 0; // achromatic
    }
    else {
        switch (max) {
            case r:
                h = (g - b) / d + (g < b ? 6 : 0);
                break;
            case g:
                h = (b - r) / d + 2;
                break;
            case b:
                h = (r - g) / d + 4;
                break;
            default:
                break;
        }
        h /= 6;
    }
    return { h: h, s: s, v: v };
}
/**
 * Converts an HSV color value to RGB.
 *
 * *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]
 * *Returns:* { r, g, b } in the set [0, 255]
 */
function hsvToRgb(h, s, v) {
    h = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(h, 360) * 6;
    s = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(s, 100);
    v = (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .bound01 */ .sh)(v, 100);
    var i = Math.floor(h);
    var f = h - i;
    var p = v * (1 - s);
    var q = v * (1 - f * s);
    var t = v * (1 - (1 - f) * s);
    var mod = i % 6;
    var r = [v, q, p, p, t, v][mod];
    var g = [t, v, v, q, p, p][mod];
    var b = [p, p, t, v, v, q][mod];
    return { r: r * 255, g: g * 255, b: b * 255 };
}
/**
 * Converts an RGB color to hex
 *
 * Assumes r, g, and b are contained in the set [0, 255]
 * Returns a 3 or 6 character hex
 */
function rgbToHex(r, g, b, allow3Char) {
    var hex = [
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(Math.round(r).toString(16)),
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(Math.round(g).toString(16)),
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(Math.round(b).toString(16)),
    ];
    // Return a 3 character hex if possible
    if (allow3Char &&
        hex[0].startsWith(hex[0].charAt(1)) &&
        hex[1].startsWith(hex[1].charAt(1)) &&
        hex[2].startsWith(hex[2].charAt(1))) {
        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
    }
    return hex.join('');
}
/**
 * Converts an RGBA color plus alpha transparency to hex
 *
 * Assumes r, g, b are contained in the set [0, 255] and
 * a in [0, 1]. Returns a 4 or 8 character rgba hex
 */
// eslint-disable-next-line max-params
function rgbaToHex(r, g, b, a, allow4Char) {
    var hex = [
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(Math.round(r).toString(16)),
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(Math.round(g).toString(16)),
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(Math.round(b).toString(16)),
        (0,_util_js__WEBPACK_IMPORTED_MODULE_0__/* .pad2 */ .FZ)(convertDecimalToHex(a)),
    ];
    // Return a 4 character hex if possible
    if (allow4Char &&
        hex[0].startsWith(hex[0].charAt(1)) &&
        hex[1].startsWith(hex[1].charAt(1)) &&
        hex[2].startsWith(hex[2].charAt(1)) &&
        hex[3].startsWith(hex[3].charAt(1))) {
        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
    }
    return hex.join('');
}
/**
 * Converts an RGBA color to an ARGB Hex8 string
 * Rarely used, but required for "toFilter()"
 */
function rgbaToArgbHex(r, g, b, a) {
    var hex = [
        pad2(convertDecimalToHex(a)),
        pad2(Math.round(r).toString(16)),
        pad2(Math.round(g).toString(16)),
        pad2(Math.round(b).toString(16)),
    ];
    return hex.join('');
}
/** Converts a decimal to a hex value */
function convertDecimalToHex(d) {
    return Math.round(parseFloat(d) * 255).toString(16);
}
/** Converts a hex value to a decimal */
function convertHexToDecimal(h) {
    return parseIntFromHex(h) / 255;
}
/** Parse a base-16 hex value into a base-10 integer */
function parseIntFromHex(val) {
    return parseInt(val, 16);
}
function numberInputToObject(color) {
    return {
        r: color >> 16,
        g: (color & 0xff00) >> 8,
        b: color & 0xff,
    };
}


/***/ }),

/***/ 53099:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   R: function() { return /* binding */ names; }
/* harmony export */ });
// https://github.com/bahamas10/css-color-names/blob/master/css-color-names.json
/**
 * @hidden
 */
var names = {
    aliceblue: '#f0f8ff',
    antiquewhite: '#faebd7',
    aqua: '#00ffff',
    aquamarine: '#7fffd4',
    azure: '#f0ffff',
    beige: '#f5f5dc',
    bisque: '#ffe4c4',
    black: '#000000',
    blanchedalmond: '#ffebcd',
    blue: '#0000ff',
    blueviolet: '#8a2be2',
    brown: '#a52a2a',
    burlywood: '#deb887',
    cadetblue: '#5f9ea0',
    chartreuse: '#7fff00',
    chocolate: '#d2691e',
    coral: '#ff7f50',
    cornflowerblue: '#6495ed',
    cornsilk: '#fff8dc',
    crimson: '#dc143c',
    cyan: '#00ffff',
    darkblue: '#00008b',
    darkcyan: '#008b8b',
    darkgoldenrod: '#b8860b',
    darkgray: '#a9a9a9',
    darkgreen: '#006400',
    darkgrey: '#a9a9a9',
    darkkhaki: '#bdb76b',
    darkmagenta: '#8b008b',
    darkolivegreen: '#556b2f',
    darkorange: '#ff8c00',
    darkorchid: '#9932cc',
    darkred: '#8b0000',
    darksalmon: '#e9967a',
    darkseagreen: '#8fbc8f',
    darkslateblue: '#483d8b',
    darkslategray: '#2f4f4f',
    darkslategrey: '#2f4f4f',
    darkturquoise: '#00ced1',
    darkviolet: '#9400d3',
    deeppink: '#ff1493',
    deepskyblue: '#00bfff',
    dimgray: '#696969',
    dimgrey: '#696969',
    dodgerblue: '#1e90ff',
    firebrick: '#b22222',
    floralwhite: '#fffaf0',
    forestgreen: '#228b22',
    fuchsia: '#ff00ff',
    gainsboro: '#dcdcdc',
    ghostwhite: '#f8f8ff',
    goldenrod: '#daa520',
    gold: '#ffd700',
    gray: '#808080',
    green: '#008000',
    greenyellow: '#adff2f',
    grey: '#808080',
    honeydew: '#f0fff0',
    hotpink: '#ff69b4',
    indianred: '#cd5c5c',
    indigo: '#4b0082',
    ivory: '#fffff0',
    khaki: '#f0e68c',
    lavenderblush: '#fff0f5',
    lavender: '#e6e6fa',
    lawngreen: '#7cfc00',
    lemonchiffon: '#fffacd',
    lightblue: '#add8e6',
    lightcoral: '#f08080',
    lightcyan: '#e0ffff',
    lightgoldenrodyellow: '#fafad2',
    lightgray: '#d3d3d3',
    lightgreen: '#90ee90',
    lightgrey: '#d3d3d3',
    lightpink: '#ffb6c1',
    lightsalmon: '#ffa07a',
    lightseagreen: '#20b2aa',
    lightskyblue: '#87cefa',
    lightslategray: '#778899',
    lightslategrey: '#778899',
    lightsteelblue: '#b0c4de',
    lightyellow: '#ffffe0',
    lime: '#00ff00',
    limegreen: '#32cd32',
    linen: '#faf0e6',
    magenta: '#ff00ff',
    maroon: '#800000',
    mediumaquamarine: '#66cdaa',
    mediumblue: '#0000cd',
    mediumorchid: '#ba55d3',
    mediumpurple: '#9370db',
    mediumseagreen: '#3cb371',
    mediumslateblue: '#7b68ee',
    mediumspringgreen: '#00fa9a',
    mediumturquoise: '#48d1cc',
    mediumvioletred: '#c71585',
    midnightblue: '#191970',
    mintcream: '#f5fffa',
    mistyrose: '#ffe4e1',
    moccasin: '#ffe4b5',
    navajowhite: '#ffdead',
    navy: '#000080',
    oldlace: '#fdf5e6',
    olive: '#808000',
    olivedrab: '#6b8e23',
    orange: '#ffa500',
    orangered: '#ff4500',
    orchid: '#da70d6',
    palegoldenrod: '#eee8aa',
    palegreen: '#98fb98',
    paleturquoise: '#afeeee',
    palevioletred: '#db7093',
    papayawhip: '#ffefd5',
    peachpuff: '#ffdab9',
    peru: '#cd853f',
    pink: '#ffc0cb',
    plum: '#dda0dd',
    powderblue: '#b0e0e6',
    purple: '#800080',
    rebeccapurple: '#663399',
    red: '#ff0000',
    rosybrown: '#bc8f8f',
    royalblue: '#4169e1',
    saddlebrown: '#8b4513',
    salmon: '#fa8072',
    sandybrown: '#f4a460',
    seagreen: '#2e8b57',
    seashell: '#fff5ee',
    sienna: '#a0522d',
    silver: '#c0c0c0',
    skyblue: '#87ceeb',
    slateblue: '#6a5acd',
    slategray: '#708090',
    slategrey: '#708090',
    snow: '#fffafa',
    springgreen: '#00ff7f',
    steelblue: '#4682b4',
    tan: '#d2b48c',
    teal: '#008080',
    thistle: '#d8bfd8',
    tomato: '#ff6347',
    turquoise: '#40e0d0',
    violet: '#ee82ee',
    wheat: '#f5deb3',
    white: '#ffffff',
    whitesmoke: '#f5f5f5',
    yellow: '#ffff00',
    yellowgreen: '#9acd32',
};


/***/ }),

/***/ 76981:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   uA: function() { return /* binding */ inputToRGB; }
/* harmony export */ });
/* unused harmony exports stringInputToObject, isValidCSSUnit */
/* harmony import */ var _conversion_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(20117);
/* harmony import */ var _css_color_names_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(53099);
/* harmony import */ var _util_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(33146);
/* eslint-disable @typescript-eslint/no-redundant-type-constituents */



/**
 * Given a string or object, convert that input to RGB
 *
 * Possible string inputs:
 * ```
 * "red"
 * "#f00" or "f00"
 * "#ff0000" or "ff0000"
 * "#ff000000" or "ff000000"
 * "rgb 255 0 0" or "rgb (255, 0, 0)"
 * "rgb 1.0 0 0" or "rgb (1, 0, 0)"
 * "rgba (255, 0, 0, 1)" or "rgba 255, 0, 0, 1"
 * "rgba (1.0, 0, 0, 1)" or "rgba 1.0, 0, 0, 1"
 * "hsl(0, 100%, 50%)" or "hsl 0 100% 50%"
 * "hsla(0, 100%, 50%, 1)" or "hsla 0 100% 50%, 1"
 * "hsv(0, 100%, 100%)" or "hsv 0 100% 100%"
 * ```
 */
function inputToRGB(color) {
    var rgb = { r: 0, g: 0, b: 0 };
    var a = 1;
    var s = null;
    var v = null;
    var l = null;
    var ok = false;
    var format = false;
    if (typeof color === 'string') {
        color = stringInputToObject(color);
    }
    if (typeof color === 'object') {
        if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
            rgb = (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .rgbToRgb */ .rW)(color.r, color.g, color.b);
            ok = true;
            format = String(color.r).substr(-1) === '%' ? 'prgb' : 'rgb';
        }
        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
            s = (0,_util_js__WEBPACK_IMPORTED_MODULE_1__/* .convertToPercentage */ .JX)(color.s);
            v = (0,_util_js__WEBPACK_IMPORTED_MODULE_1__/* .convertToPercentage */ .JX)(color.v);
            rgb = (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .hsvToRgb */ .WE)(color.h, s, v);
            ok = true;
            format = 'hsv';
        }
        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
            s = (0,_util_js__WEBPACK_IMPORTED_MODULE_1__/* .convertToPercentage */ .JX)(color.s);
            l = (0,_util_js__WEBPACK_IMPORTED_MODULE_1__/* .convertToPercentage */ .JX)(color.l);
            rgb = (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .hslToRgb */ .ve)(color.h, s, l);
            ok = true;
            format = 'hsl';
        }
        if (Object.prototype.hasOwnProperty.call(color, 'a')) {
            a = color.a;
        }
    }
    a = (0,_util_js__WEBPACK_IMPORTED_MODULE_1__/* .boundAlpha */ .Yq)(a);
    return {
        ok: ok,
        format: color.format || format,
        r: Math.min(255, Math.max(rgb.r, 0)),
        g: Math.min(255, Math.max(rgb.g, 0)),
        b: Math.min(255, Math.max(rgb.b, 0)),
        a: a,
    };
}
// <http://www.w3.org/TR/css3-values/#integers>
var CSS_INTEGER = '[-\\+]?\\d+%?';
// <http://www.w3.org/TR/css3-values/#number-value>
var CSS_NUMBER = '[-\\+]?\\d*\\.\\d+%?';
// Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.
var CSS_UNIT = "(?:".concat(CSS_NUMBER, ")|(?:").concat(CSS_INTEGER, ")");
// Actual matching.
// Parentheses and commas are optional, but not required.
// Whitespace can take the place of commas or opening paren
var PERMISSIVE_MATCH3 = "[\\s|\\(]+(".concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")\\s*\\)?");
var PERMISSIVE_MATCH4 = "[\\s|\\(]+(".concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")[,|\\s]+(").concat(CSS_UNIT, ")\\s*\\)?");
var matchers = {
    CSS_UNIT: new RegExp(CSS_UNIT),
    rgb: new RegExp('rgb' + PERMISSIVE_MATCH3),
    rgba: new RegExp('rgba' + PERMISSIVE_MATCH4),
    hsl: new RegExp('hsl' + PERMISSIVE_MATCH3),
    hsla: new RegExp('hsla' + PERMISSIVE_MATCH4),
    hsv: new RegExp('hsv' + PERMISSIVE_MATCH3),
    hsva: new RegExp('hsva' + PERMISSIVE_MATCH4),
    hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
    hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
    hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
    hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
};
/**
 * Permissive string parsing.  Take in a number of formats, and output an object
 * based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`
 */
function stringInputToObject(color) {
    color = color.trim().toLowerCase();
    if (color.length === 0) {
        return false;
    }
    var named = false;
    if (_css_color_names_js__WEBPACK_IMPORTED_MODULE_2__/* .names */ .R[color]) {
        color = _css_color_names_js__WEBPACK_IMPORTED_MODULE_2__/* .names */ .R[color];
        named = true;
    }
    else if (color === 'transparent') {
        return { r: 0, g: 0, b: 0, a: 0, format: 'name' };
    }
    // Try to match string input using regular expressions.
    // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]
    // Just return an object and let the conversion functions handle that.
    // This way the result will be the same whether the tinycolor is initialized with string or object.
    var match = matchers.rgb.exec(color);
    if (match) {
        return { r: match[1], g: match[2], b: match[3] };
    }
    match = matchers.rgba.exec(color);
    if (match) {
        return { r: match[1], g: match[2], b: match[3], a: match[4] };
    }
    match = matchers.hsl.exec(color);
    if (match) {
        return { h: match[1], s: match[2], l: match[3] };
    }
    match = matchers.hsla.exec(color);
    if (match) {
        return { h: match[1], s: match[2], l: match[3], a: match[4] };
    }
    match = matchers.hsv.exec(color);
    if (match) {
        return { h: match[1], s: match[2], v: match[3] };
    }
    match = matchers.hsva.exec(color);
    if (match) {
        return { h: match[1], s: match[2], v: match[3], a: match[4] };
    }
    match = matchers.hex8.exec(color);
    if (match) {
        return {
            r: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[1]),
            g: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[2]),
            b: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[3]),
            a: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .convertHexToDecimal */ .T6)(match[4]),
            format: named ? 'name' : 'hex8',
        };
    }
    match = matchers.hex6.exec(color);
    if (match) {
        return {
            r: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[1]),
            g: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[2]),
            b: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[3]),
            format: named ? 'name' : 'hex',
        };
    }
    match = matchers.hex4.exec(color);
    if (match) {
        return {
            r: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[1] + match[1]),
            g: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[2] + match[2]),
            b: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[3] + match[3]),
            a: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .convertHexToDecimal */ .T6)(match[4] + match[4]),
            format: named ? 'name' : 'hex8',
        };
    }
    match = matchers.hex3.exec(color);
    if (match) {
        return {
            r: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[1] + match[1]),
            g: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[2] + match[2]),
            b: (0,_conversion_js__WEBPACK_IMPORTED_MODULE_0__/* .parseIntFromHex */ .VD)(match[3] + match[3]),
            format: named ? 'name' : 'hex',
        };
    }
    return false;
}
/**
 * Check to see if it looks like a CSS unit
 * (see `matchers` above for definition).
 */
function isValidCSSUnit(color) {
    return Boolean(matchers.CSS_UNIT.exec(String(color)));
}


/***/ }),

/***/ 33146:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   FZ: function() { return /* binding */ pad2; },
/* harmony export */   JX: function() { return /* binding */ convertToPercentage; },
/* harmony export */   V2: function() { return /* binding */ clamp01; },
/* harmony export */   Yq: function() { return /* binding */ boundAlpha; },
/* harmony export */   sh: function() { return /* binding */ bound01; }
/* harmony export */ });
/* unused harmony exports isOnePointZero, isPercentage */
/**
 * Take input from [0, n] and return it as [0, 1]
 * @hidden
 */
function bound01(n, max) {
    if (isOnePointZero(n)) {
        n = '100%';
    }
    var isPercent = isPercentage(n);
    n = max === 360 ? n : Math.min(max, Math.max(0, parseFloat(n)));
    // Automatically convert percentage into number
    if (isPercent) {
        n = parseInt(String(n * max), 10) / 100;
    }
    // Handle floating point rounding errors
    if (Math.abs(n - max) < 0.000001) {
        return 1;
    }
    // Convert into [0, 1] range if it isn't already
    if (max === 360) {
        // If n is a hue given in degrees,
        // wrap around out-of-range values into [0, 360] range
        // then convert into [0, 1].
        n = (n < 0 ? (n % max) + max : n % max) / parseFloat(String(max));
    }
    else {
        // If n not a hue given in degrees
        // Convert into [0, 1] range if it isn't already.
        n = (n % max) / parseFloat(String(max));
    }
    return n;
}
/**
 * Force a number between 0 and 1
 * @hidden
 */
function clamp01(val) {
    return Math.min(1, Math.max(0, val));
}
/**
 * Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1
 * <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>
 * @hidden
 */
function isOnePointZero(n) {
    return typeof n === 'string' && n.indexOf('.') !== -1 && parseFloat(n) === 1;
}
/**
 * Check to see if string passed in is a percentage
 * @hidden
 */
function isPercentage(n) {
    return typeof n === 'string' && n.indexOf('%') !== -1;
}
/**
 * Return a valid alpha value [0,1] with all invalid values being set to 1
 * @hidden
 */
function boundAlpha(a) {
    a = parseFloat(a);
    if (isNaN(a) || a < 0 || a > 1) {
        a = 1;
    }
    return a;
}
/**
 * Replace a decimal with it's percentage value
 * @hidden
 */
function convertToPercentage(n) {
    if (n <= 1) {
        return "".concat(Number(n) * 100, "%");
    }
    return n;
}
/**
 * Force a hex value to have 2 characters
 * @hidden
 */
function pad2(c) {
    return c.length === 1 ? '0' + c : String(c);
}


/***/ }),

/***/ 14376:
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  ACCOUNTS_MENU: function() { return /* reexport */ menu_menu_protocol/* ACCOUNTS_MENU */.hL; },
  ACCOUNTS_SUBMENU: function() { return /* reexport */ menu_menu_protocol/* ACCOUNTS_SUBMENU */.IM; },
  AbstractTreeDecoratorService: function() { return /* reexport */ tree_decorator/* AbstractTreeDecoratorService */.v$; },
  AbstractTreeIterator: function() { return /* reexport */ tree_iterator/* AbstractTreeIterator */.Zu; },
  ActionMenuItem: function() { return /* reexport */ menu_protocol/* ActionMenuItem */.F9; },
  ActionMenuItemFactory: function() { return /* reexport */ menu_protocol/* ActionMenuItemFactory */.z; },
  ActionMenuNode: function() { return /* reexport */ menu_protocol/* ActionMenuNode */.f5; },
  Application: function() { return /* reexport */ application/* Application */.Mx; },
  ApplicationComponent: function() { return /* reexport */ components/* ApplicationComponent */.wC; },
  ApplicationContribution: function() { return /* reexport */ application/* ApplicationContribution */.rS; },
  ApplicationModule: function() { return /* reexport */ application/* ApplicationModule */.hG; },
  ApplicationState: function() { return /* reexport */ application/* ApplicationState */.iY; },
  ApplicationStateService: function() { return /* reexport */ application/* ApplicationStateService */.VR; },
  BaseSlotView: function() { return /* reexport */ default_slot_view/* BaseSlotView */.Os; },
  BaseStat: function() { return /* reexport */ BaseStat; },
  BaseStatefulView: function() { return /* reexport */ BaseStatefulView; },
  BaseView: function() { return /* reexport */ default_view/* BaseView */.P; },
  BaseViewRender: function() { return /* reexport */ default_view/* BaseViewRender */.t; },
  BinarySize: function() { return /* reexport */ BinarySize; },
  BottomUpTreeIterator: function() { return /* reexport */ tree_iterator/* BottomUpTreeIterator */.ev; },
  BoxSlotView: function() { return /* reexport */ BoxSlotView; },
  BoxViewComponent: function() { return /* reexport */ BoxViewComponent; },
  BreadthFirstTreeIterator: function() { return /* reexport */ tree_iterator/* BreadthFirstTreeIterator */.oE; },
  BrowserKeyboardLayoutProvider: function() { return /* reexport */ BrowserKeyboardLayoutProvider; },
  BuiltinThemeProvider: function() { return /* reexport */ BuiltinThemeProvider; },
  COMPOSITE_TREE_NODE_CLASS: function() { return /* reexport */ tree_protocol/* COMPOSITE_TREE_NODE_CLASS */.Ej; },
  CallbackList: function() { return /* reexport */ es_event/* CallbackList */.BO; },
  CancellationToken: function() { return /* reexport */ cancellation/* CancellationToken */.Ts; },
  CancellationTokenSource: function() { return /* reexport */ cancellation/* CancellationTokenSource */.AU; },
  CaptionHighlight: function() { return /* reexport */ tree_view_decoration/* CaptionHighlight */["if"]; },
  CardTabView: function() { return /* reexport */ CardTabView; },
  CharCode: function() { return /* reexport */ CharCode; },
  Color: function() { return /* reexport */ color_registry_Color; },
  ColorApplication: function() { return /* reexport */ ColorApplication; },
  ColorContribution: function() { return /* reexport */ ColorContribution; },
  ColorRegistry: function() { return /* reexport */ ColorRegistry; },
  Command: function() { return /* reexport */ command_protocol/* Command */.m; },
  CommandContribution: function() { return /* reexport */ command_registry/* CommandContribution */.p; },
  CommandMenuNode: function() { return /* reexport */ menu_protocol/* CommandMenuNode */.dP; },
  CommandModule: function() { return /* reexport */ CommandModule; },
  CommandRegistry: function() { return /* reexport */ command_registry/* CommandRegistry */.H; },
  CommandService: function() { return /* reexport */ command_protocol/* CommandService */.V; },
  CommonModule: function() { return /* reexport */ CommonModule; },
  CompositeTreeNode: function() { return /* reexport */ tree/* CompositeTreeNode */.ce; },
  ConfigKeysIterator: function() { return /* reexport */ ConfigKeysIterator; },
  ConfigurationContribution: function() { return /* reexport */ ConfigurationContribution; },
  ConfigurationModule: function() { return /* reexport */ ConfigurationModule; },
  ConfigurationProvider: function() { return /* reexport */ ConfigurationProvider; },
  ConfigurationRegistry: function() { return /* reexport */ ConfigurationRegistry; },
  ConfigurationRenderContribution: function() { return /* reexport */ ConfigurationRenderContribution; },
  ConfigurationRenderRegistry: function() { return /* reexport */ ConfigurationRenderRegistry; },
  ConfigurationService: function() { return /* reexport */ ConfigurationService; },
  Container: function() { return /* reexport */ mana_syringe_es/* Container */.W2; },
  ContainerMeta: function() { return /* reexport */ mana_syringe_es/* ContainerMeta */.fg; },
  ContextComponent: function() { return /* reexport */ components/* ContextComponent */.T0; },
  ContextKeyAndExpr: function() { return /* reexport */ ContextKeyAndExpr; },
  ContextKeyDefinedExpr: function() { return /* reexport */ ContextKeyDefinedExpr; },
  ContextKeyEqualsExpr: function() { return /* reexport */ ContextKeyEqualsExpr; },
  ContextKeyExpr: function() { return /* reexport */ ContextKeyExpr; },
  ContextKeyExprType: function() { return /* reexport */ ContextKeyExprType; },
  ContextKeyFalseExpr: function() { return /* reexport */ ContextKeyFalseExpr; },
  ContextKeyGreaterEqualsExpr: function() { return /* reexport */ ContextKeyGreaterEqualsExpr; },
  ContextKeyGreaterExpr: function() { return /* reexport */ ContextKeyGreaterExpr; },
  ContextKeyInExpr: function() { return /* reexport */ ContextKeyInExpr; },
  ContextKeyNotEqualsExpr: function() { return /* reexport */ ContextKeyNotEqualsExpr; },
  ContextKeyNotExpr: function() { return /* reexport */ ContextKeyNotExpr; },
  ContextKeyNotInExpr: function() { return /* reexport */ ContextKeyNotInExpr; },
  ContextKeyNotRegexExpr: function() { return /* reexport */ ContextKeyNotRegexExpr; },
  ContextKeyOrExpr: function() { return /* reexport */ ContextKeyOrExpr; },
  ContextKeyRegexExpr: function() { return /* reexport */ ContextKeyRegexExpr; },
  ContextKeyService: function() { return /* reexport */ ContextKeyService; },
  ContextKeySmallerEqualsExpr: function() { return /* reexport */ ContextKeySmallerEqualsExpr; },
  ContextKeySmallerExpr: function() { return /* reexport */ ContextKeySmallerExpr; },
  ContextKeyTrueExpr: function() { return /* reexport */ ContextKeyTrueExpr; },
  ContextModule: function() { return /* reexport */ ContextModule; },
  Contribution: function() { return /* reexport */ mana_syringe_es/* Contribution */.Ll; },
  ContributionOptionConfig: function() { return /* reexport */ mana_syringe_es/* ContributionOptionConfig */.JD; },
  CoreMenuModule: function() { return /* reexport */ CoreMenuModule; },
  CoreToolbarModule: function() { return /* reexport */ CoreToolbarModule; },
  DEFAULT_LAYOUT_DATA: function() { return /* reexport */ DEFAULT_LAYOUT_DATA; },
  DIR_NODE_CLASS: function() { return /* reexport */ DIR_NODE_CLASS; },
  DataContext: function() { return /* reexport */ DataContext; },
  DataContextContriburtion: function() { return /* reexport */ DataContextContriburtion; },
  DataContextManager: function() { return /* reexport */ DataContextManager; },
  DataContextSymbol: function() { return /* reexport */ DataContextSymbol; },
  DebugService: function() { return /* reexport */ debug/* DebugService */.r; },
  DecoratedTreeNode: function() { return /* reexport */ tree_decorator/* DecoratedTreeNode */.yl; },
  DefaultConfigurationProvider: function() { return /* reexport */ DefaultConfigurationProvider; },
  DefaultConfigurationStorage: function() { return /* reexport */ DefaultConfigurationStorage; },
  DefaultContributionProvider: function() { return /* reexport */ mana_syringe_es/* DefaultContributionProvider */.yF; },
  DefaultOpenerService: function() { return /* reexport */ DefaultOpenerService; },
  DefaultSlotView: function() { return /* reexport */ default_slot_view/* DefaultSlotView */.W$; },
  DefaultSlotViewComponent: function() { return /* reexport */ default_slot_view/* DefaultSlotViewComponent */.Wg; },
  DefaultSlotViewId: function() { return /* reexport */ default_slot_view/* DefaultSlotViewId */.YB; },
  DefaultToolbarItem: function() { return /* reexport */ DefaultToolbarItem; },
  DefaultTreeNodeComponents: function() { return /* reexport */ DefaultTreeNodeComponents; },
  DefaultTreeProps: function() { return /* reexport */ tree/* DefaultTreeProps */.JZ; },
  DefaultUriLabelProviderContribution: function() { return /* reexport */ label_provider/* DefaultUriLabelProviderContribution */.hO; },
  DefaultViewModule: function() { return /* reexport */ DefaultViewModule; },
  Deferred: function() { return /* reexport */ deferred/* Deferred */.B; },
  DepthFirstTreeIterator: function() { return /* reexport */ tree_iterator/* DepthFirstTreeIterator */.Iy; },
  DirNode: function() { return /* reexport */ DirNode; },
  Disposable: function() { return /* reexport */ disposable/* Disposable */.J; },
  DisposableCollection: function() { return /* reexport */ disposable_collection/* DisposableCollection */.K; },
  DisposableStore: function() { return /* reexport */ DisposableStore; },
  Disposed: function() { return /* reexport */ disposable/* Disposed */.r; },
  ETAG_DISABLED: function() { return /* reexport */ ETAG_DISABLED; },
  EXPANDABLE_TREE_NODE_CLASS: function() { return /* reexport */ tree_protocol/* EXPANDABLE_TREE_NODE_CLASS */.Bq; },
  Emitter: function() { return /* reexport */ es_event/* Emitter */.Q5; },
  Event: function() { return /* reexport */ es_event/* Event */.ju; },
  ExecutableMenuNode: function() { return /* reexport */ menu_protocol/* ExecutableMenuNode */.vd; },
  ExpandableTreeNode: function() { return /* reexport */ tree_expansion/* ExpandableTreeNode */.Hd; },
  FILE_STAT_ICON_CLASS: function() { return /* reexport */ FILE_STAT_ICON_CLASS; },
  FILE_STAT_NODE_CLASS: function() { return /* reexport */ FILE_STAT_NODE_CLASS; },
  FILE_TREE_CLASS: function() { return /* reexport */ FILE_TREE_CLASS; },
  FileChangeType: function() { return /* reexport */ FileChangeType; },
  FileChangesEvent: function() { return /* reexport */ FileChangesEvent; },
  FileNode: function() { return /* reexport */ FileNode; },
  FileOperation: function() { return /* reexport */ FileOperation; },
  FileOperationError: function() { return /* reexport */ FileOperationError; },
  FileOperationEvent: function() { return /* reexport */ FileOperationEvent; },
  FileOperationResult: function() { return /* reexport */ FileOperationResult; },
  FileService: function() { return /* reexport */ FileService; },
  FileStat: function() { return /* reexport */ FileStat; },
  FileStatNode: function() { return /* reexport */ FileStatNode; },
  FileStatNodeData: function() { return /* reexport */ FileStatNodeData; },
  FileSystemProvider: function() { return /* reexport */ FileSystemProvider; },
  FileSystemProviderCapabilities: function() { return /* reexport */ FileSystemProviderCapabilities; },
  FileSystemProviderError: function() { return /* reexport */ FileSystemProviderError; },
  FileSystemProviderErrorCode: function() { return /* reexport */ FileSystemProviderErrorCode; },
  FileTree: function() { return /* reexport */ FileTree; },
  FileTreeModel: function() { return /* reexport */ FileTreeModel; },
  FileTreeModule: function() { return /* reexport */ FileTreeModule; },
  FileTreeView: function() { return /* reexport */ FileTreeView; },
  FileTreeViewComponent: function() { return /* reexport */ FileTreeViewComponent; },
  FileTreeViewFactory: function() { return /* reexport */ FileTreeViewFactory; },
  FileTreeViewModule: function() { return /* reexport */ FileTreeViewModule; },
  FileType: function() { return /* reexport */ FileType; },
  FlexSlotView: function() { return /* reexport */ FlexSlotView; },
  FlexViewComponent: function() { return /* reexport */ FlexViewComponent; },
  GeneralMenuItem: function() { return /* reexport */ menu_protocol/* GeneralMenuItem */.dV; },
  GeneralMenuItemFactory: function() { return /* reexport */ menu_protocol/* GeneralMenuItemFactory */.yz; },
  GlobalContainer: function() { return /* reexport */ mana_syringe_es/* GlobalContainer */.iI; },
  HeaderArea: function() { return /* reexport */ header_view/* HeaderArea */.M; },
  HeaderModule: function() { return /* reexport */ HeaderModule; },
  HeaderView: function() { return /* reexport */ header_view/* HeaderView */.m; },
  IContextKey: function() { return /* reexport */ IContextKey; },
  IContextKeyService: function() { return /* reexport */ IContextKeyService; },
  IconOverlayPosition: function() { return /* reexport */ tree_view_decoration/* IconOverlayPosition */.L$; },
  ImmortalReference: function() { return /* reexport */ ImmortalReference; },
  InstanceValue: function() { return /* reexport */ es/* InstanceValue */.XA; },
  Iterable: function() { return /* reexport */ Iterable; },
  Iterators: function() { return /* reexport */ tree_iterator/* Iterators */.eK; },
  Key: function() { return /* reexport */ Key; },
  KeyCode: function() { return /* reexport */ KeyCode; },
  KeyModifier: function() { return /* reexport */ KeyModifier; },
  KeySequence: function() { return /* reexport */ KeySequence; },
  KeyValidator: function() { return /* reexport */ KeyValidator; },
  KeybindModule: function() { return /* reexport */ KeybindModule; },
  KeybindingContribution: function() { return /* reexport */ KeybindingContribution; },
  KeybindingRegistry: function() { return /* reexport */ KeybindingRegistry; },
  KeyboardLayoutChangeNotifier: function() { return /* reexport */ KeyboardLayoutChangeNotifier; },
  KeyboardLayoutProvider: function() { return /* reexport */ KeyboardLayoutProvider; },
  KeyboardLayoutService: function() { return /* reexport */ KeyboardLayoutService; },
  KeyboardTester: function() { return /* reexport */ KeyboardTester; },
  KeysOrKeyCodes: function() { return /* reexport */ KeysOrKeyCodes; },
  LabelModule: function() { return /* reexport */ LabelModule; },
  LabelProvider: function() { return /* reexport */ label_provider/* LabelProvider */.L1; },
  LabelProviderContribution: function() { return /* reexport */ label_provider/* LabelProviderContribution */.F$; },
  Language: function() { return /* reexport */ platform/* Language */.SQ; },
  LinkedList: function() { return /* reexport */ linkedList/* LinkedList */.S; },
  LinkedMap: function() { return /* reexport */ LinkedMap; },
  Loading: function() { return /* reexport */ Loading; },
  LocalConfigurationStorage: function() { return /* reexport */ LocalConfigurationStorage; },
  LocalStorageConfigurationProvider: function() { return /* reexport */ LocalStorageConfigurationProvider; },
  LocalStorageService: function() { return /* reexport */ LocalStorageService; },
  MAIN_MENU_BAR: function() { return /* reexport */ menu_menu_protocol/* MAIN_MENU_BAR */.Qy; },
  ManaAppPreset: function() { return /* binding */ ManaAppPreset; },
  ManaComponents: function() { return /* reexport */ components/* ManaComponents */.rF; },
  ManaContext: function() { return /* reexport */ mana_module_context/* ManaContext */.K; },
  ManaModule: function() { return /* reexport */ mana_module/* ManaModule */.R; },
  ManaModules: function() { return /* reexport */ ManaModules; },
  ManaPreset: function() { return /* reexport */ ManaPreset; },
  Menu: function() { return /* reexport */ menu/* Menu */.v2; },
  MenuBarRender: function() { return /* reexport */ MenuBarRender; },
  MenuContribution: function() { return /* reexport */ menu_registry/* MenuContribution */.P; },
  MenuFactory: function() { return /* reexport */ menu/* MenuFactory */.El; },
  MenuInstance: function() { return /* reexport */ menu_menu_protocol/* MenuInstance */.ib; },
  MenuItem: function() { return /* reexport */ menu_protocol/* MenuItem */.sN; },
  MenuModule: function() { return /* reexport */ MenuModule; },
  MenuNode: function() { return /* reexport */ menu_protocol/* MenuNode */.eJ; },
  MenuPathSymbol: function() { return /* reexport */ menu/* MenuPathSymbol */.XN; },
  MenuRegistry: function() { return /* reexport */ menu_registry/* MenuRegistry */.B; },
  MenuRender: function() { return /* reexport */ menu_render/* MenuRender */.k; },
  MenuSymbol: function() { return /* reexport */ menu_protocol/* MenuSymbol */.OH; },
  ModalApplicationContribution: function() { return /* reexport */ ModalApplicationContribution; },
  ModalContribution: function() { return /* reexport */ ModalContribution; },
  ModalItemView: function() { return /* reexport */ ModalItemView; },
  ModalModule: function() { return /* reexport */ ModalModule; },
  ModalRender: function() { return /* reexport */ modal_ModalRender; },
  ModalRenderView: function() { return /* reexport */ ModalRenderView; },
  ModalService: function() { return /* reexport */ ModalService; },
  Module: function() { return /* reexport */ mana_syringe_es/* Module */.Yl; },
  MultiDisposeError: function() { return /* reexport */ MultiDisposeError; },
  MutableDisposable: function() { return /* reexport */ MutableDisposable; },
  Navigatable: function() { return /* reexport */ navigatable_types/* Navigatable */.EH; },
  NavigatableView: function() { return /* reexport */ navigatable_types/* NavigatableView */.a8; },
  NavigatableViewOpenHandler: function() { return /* reexport */ NavigatableViewOpenHandler; },
  NavigatableWidgetOptions: function() { return /* reexport */ navigatable_types/* NavigatableWidgetOptions */.n7; },
  NoopTreeDecoratorService: function() { return /* reexport */ tree_decorator/* NoopTreeDecoratorService */.m8; },
  Notifiable: function() { return /* reexport */ es/* Notifiable */.Bf; },
  Notifier: function() { return /* reexport */ es/* Notifier */.d4; },
  OS: function() { return /* reexport */ platform.OS; },
  Observability: function() { return /* reexport */ es/* Observability */.IN; },
  Observable: function() { return /* reexport */ es/* Observable */.y$; },
  ObservableConfig: function() { return /* reexport */ es/* ObservableConfig */.k3; },
  ObservableContext: function() { return /* reexport */ es/* ObservableContext */.A5; },
  ObservableContextImpl: function() { return /* reexport */ es/* ObservableContextImpl */.uA; },
  ObservableProperties: function() { return /* reexport */ es/* ObservableProperties */.IH; },
  ObservableSymbol: function() { return /* reexport */ es/* ObservableSymbol */.Xy; },
  OpenHandler: function() { return /* reexport */ OpenHandler; },
  OpenerService: function() { return /* reexport */ OpenerService; },
  OperatingSystem: function() { return /* reexport */ platform/* OperatingSystem */.U5; },
  OptionSymbol: function() { return /* reexport */ mana_syringe_es/* OptionSymbol */.Y9; },
  OriginViewComponent: function() { return /* reexport */ view_protocol/* OriginViewComponent */.Vc; },
  Path: function() { return /* reexport */ path/* Path */.y; },
  PathIterator: function() { return /* reexport */ PathIterator; },
  PauseableEmitter: function() { return /* reexport */ es_event/* PauseableEmitter */.K3; },
  Platform: function() { return /* reexport */ platform/* Platform */.t4; },
  PlatformToString: function() { return /* reexport */ platform/* PlatformToString */.PW; },
  PortalSlotId: function() { return /* reexport */ view_protocol/* PortalSlotId */.gv; },
  Priority: function() { return /* reexport */ priority/* Priority */.U; },
  Provider: function() { return /* reexport */ mana_syringe_es/* Provider */.zt; },
  RawContextKey: function() { return /* reexport */ RawContextKey; },
  ReferenceCollection: function() { return /* reexport */ ReferenceCollection; },
  ResourceMap: function() { return /* reexport */ ResourceMap; },
  RootSlotId: function() { return /* reexport */ view_protocol/* RootSlotId */.lI; },
  RootViewId: function() { return /* reexport */ view_protocol/* RootViewId */.ar; },
  SETTINGS_MENU: function() { return /* reexport */ menu_menu_protocol/* SETTINGS_MENU */.n8; },
  SET_CONTEXT_COMMAND_ID: function() { return /* reexport */ SET_CONTEXT_COMMAND_ID; },
  Saveable: function() { return /* reexport */ Saveable; },
  SaveableView: function() { return /* reexport */ SaveableView; },
  SavedView: function() { return /* reexport */ SavedView; },
  SchemaValidator: function() { return /* reexport */ SchemaValidator; },
  SelectableTreeNode: function() { return /* reexport */ tree_selection/* SelectableTreeNode */.CX; },
  SelectionModule: function() { return /* reexport */ SelectionModule; },
  SelectionService: function() { return /* reexport */ selection_service/* SelectionService */.z; },
  SetMap: function() { return /* reexport */ SetMap; },
  SideTabView: function() { return /* reexport */ SideTabView; },
  Slot: function() { return /* reexport */ slot/* Slot */.g; },
  SlotPreferenceContribution: function() { return /* reexport */ view_protocol/* SlotPreferenceContribution */.sU; },
  SlotView: function() { return /* reexport */ view_protocol/* SlotView */.tl; },
  SlotViewManager: function() { return /* reexport */ slot_view_manager/* SlotViewManager */.I; },
  SlotViewOption: function() { return /* reexport */ view_protocol/* SlotViewOption */.tG; },
  SpecialCases: function() { return /* reexport */ SpecialCases; },
  StatefulView: function() { return /* reexport */ view_protocol/* StatefulView */.sh; },
  StorageService: function() { return /* reexport */ StorageService; },
  StringIterator: function() { return /* reexport */ StringIterator; },
  Syringe: function() { return /* reexport */ mana_syringe_es/* Syringe */.J3; },
  SyringeModule: function() { return /* reexport */ mana_syringe_es/* SyringeModule */.q0; },
  TREE_CLASS: function() { return /* reexport */ tree_protocol/* TREE_CLASS */.iN; },
  TREE_CONTAINER_CLASS: function() { return /* reexport */ tree_protocol/* TREE_CONTAINER_CLASS */.B3; },
  TREE_NODE_CAPTION_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_CAPTION_CLASS */.HL; },
  TREE_NODE_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_CLASS */.Js; },
  TREE_NODE_CONTENT_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_CONTENT_CLASS */.ig; },
  TREE_NODE_INDENT_GUIDE_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_INDENT_GUIDE_CLASS */.sA; },
  TREE_NODE_SEGMENT_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_SEGMENT_CLASS */.zz; },
  TREE_NODE_SEGMENT_GROW_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_SEGMENT_GROW_CLASS */.L3; },
  TREE_NODE_TAIL_CLASS: function() { return /* reexport */ tree_protocol/* TREE_NODE_TAIL_CLASS */.ID; },
  TabSlotView: function() { return /* reexport */ TabSlotView; },
  TabViewComponent: function() { return /* reexport */ TabViewComponent; },
  TernarySearchTree: function() { return /* reexport */ TernarySearchTree; },
  ThemeModule: function() { return /* reexport */ ThemeModule; },
  ThemeService: function() { return /* reexport */ ThemeService; },
  ThemeServiceSymbol: function() { return /* reexport */ ThemeServiceSymbol; },
  ThemeVariableModule: function() { return /* reexport */ ThemeVariableModule; },
  Toolbar: function() { return /* reexport */ Toolbar; },
  ToolbarContribution: function() { return /* reexport */ ToolbarContribution; },
  ToolbarFactory: function() { return /* reexport */ ToolbarFactory; },
  ToolbarInstance: function() { return /* reexport */ ToolbarInstance; },
  ToolbarItem: function() { return /* reexport */ ToolbarItem; },
  ToolbarItemFactory: function() { return /* reexport */ ToolbarItemFactory; },
  ToolbarModule: function() { return /* reexport */ ToolbarModule; },
  ToolbarNode: function() { return /* reexport */ ToolbarNode; },
  ToolbarRegistry: function() { return /* reexport */ ToolbarRegistry; },
  ToolbarRender: function() { return /* reexport */ ToolbarRender; },
  TopDownTreeIterator: function() { return /* reexport */ tree_iterator/* TopDownTreeIterator */.Xn; },
  Touch: function() { return /* reexport */ Touch; },
  Trackable: function() { return /* reexport */ es/* Trackable */.Xj; },
  Tracker: function() { return /* reexport */ es/* Tracker */.fX; },
  Tree: function() { return /* reexport */ tree/* Tree */.mp; },
  TreeDecoratorService: function() { return /* reexport */ tree_decorator/* TreeDecoratorService */.Dv; },
  TreeExpansionService: function() { return /* reexport */ tree_expansion/* TreeExpansionService */.$s; },
  TreeExpansionServiceImpl: function() { return /* reexport */ tree_expansion/* TreeExpansionServiceImpl */.St; },
  TreeImpl: function() { return /* reexport */ tree_impl/* TreeImpl */.Q; },
  TreeIterator: function() { return /* reexport */ tree_iterator/* TreeIterator */.uF; },
  TreeLabelProvider: function() { return /* reexport */ TreeLabelProvider; },
  TreeModel: function() { return /* reexport */ tree_model/* TreeModel */.r; },
  TreeModelImpl: function() { return /* reexport */ tree_model/* TreeModelImpl */.n; },
  TreeModule: function() { return /* reexport */ TreeModule; },
  TreeNavigationService: function() { return /* reexport */ tree_navigation/* TreeNavigationService */.T; },
  TreeNode: function() { return /* reexport */ tree/* TreeNode */.OF; },
  TreeNodeComponents: function() { return /* reexport */ tree/* TreeNodeComponents */.EH; },
  TreeProps: function() { return /* reexport */ tree_protocol/* TreeProps */.Fj; },
  TreeSelection: function() { return /* reexport */ tree_selection/* TreeSelection */.Kf; },
  TreeSelectionService: function() { return /* reexport */ tree_selection/* TreeSelectionService */.p$; },
  TreeSelectionServiceImpl: function() { return /* reexport */ tree_selection_impl/* TreeSelectionServiceImpl */.H; },
  TreeView: function() { return /* reexport */ tree_view/* TreeView */.LQ; },
  TreeViewComponent: function() { return /* reexport */ tree_view/* TreeViewComponent */.kD; },
  TreeViewContent: function() { return /* reexport */ tree_view/* TreeViewContent */.i7; },
  TreeViewDecoration: function() { return /* reexport */ tree_view_decoration/* TreeViewDecoration */.U0; },
  TreeViewDecorationData: function() { return /* reexport */ tree_view_decoration/* TreeViewDecorationData */.zn; },
  TreeViewDecorationStyles: function() { return /* reexport */ tree_view_decoration/* TreeViewDecorationStyles */.jc; },
  TreeViewDecorator: function() { return /* reexport */ tree_view_decorator/* TreeViewDecorator */.W; },
  TreeViewFactoryId: function() { return /* reexport */ tree_view/* TreeViewFactoryId */.Pl; },
  TreeViewModule: function() { return /* reexport */ tree_view_module/* TreeViewModule */.d; },
  TreeViewRow: function() { return /* reexport */ tree_view/* TreeViewRow */.Jk; },
  TreeViewSelection: function() { return /* reexport */ tree_view/* TreeViewSelection */.e4; },
  URI: function() { return /* reexport */ es_uri/* URI */.o; },
  URIIconReference: function() { return /* reexport */ label_provider/* URIIconReference */.Dc; },
  UriIterator: function() { return /* reexport */ UriIterator; },
  Utils: function() { return /* reexport */ mana_syringe_es/* Utils */.cQ; },
  VSDisposable: function() { return /* reexport */ VSDisposable; },
  VariableApplication: function() { return /* reexport */ VariableApplication; },
  VariableContribution: function() { return /* reexport */ VariableContribution; },
  VariableRegistry: function() { return /* reexport */ VariableRegistry; },
  View: function() { return /* reexport */ view_protocol/* View */.G7; },
  ViewApplication: function() { return /* reexport */ ViewApplication; },
  ViewComponent: function() { return /* reexport */ view_protocol/* ViewComponent */.Hr; },
  ViewContext: function() { return /* reexport */ view_context/* ViewContext */.A; },
  ViewContextMetaKey: function() { return /* reexport */ view_protocol/* ViewContextMetaKey */.gk; },
  ViewDecoration: function() { return /* reexport */ ViewDecoration; },
  ViewDefineToken: function() { return /* reexport */ view_protocol/* ViewDefineToken */.nZ; },
  ViewFactory: function() { return /* reexport */ view_protocol/* ViewFactory */.Pc; },
  ViewInstance: function() { return /* reexport */ view_protocol/* ViewInstance */.yd; },
  ViewManager: function() { return /* reexport */ view_manager/* ViewManager */.v; },
  ViewModule: function() { return /* reexport */ ViewModule; },
  ViewOpenHandler: function() { return /* reexport */ ViewOpenHandler; },
  ViewOption: function() { return /* reexport */ view_protocol/* ViewOption */.Hj; },
  ViewPreferenceContribution: function() { return /* reexport */ view_protocol/* ViewPreferenceContribution */._k; },
  ViewPriority: function() { return /* reexport */ view_protocol/* ViewPriority */.OE; },
  ViewRender: function() { return /* reexport */ view_render/* ViewRender */.o; },
  ViewStorage: function() { return /* reexport */ ViewStorage; },
  VscodeURI: function() { return /* reexport */ uri/* URI */.o; },
  VscodeUriUtils: function() { return /* reexport */ Utils; },
  WaitUntilEvent: function() { return /* reexport */ wait_until_event/* WaitUntilEvent */.c; },
  animationFrame: function() { return /* reexport */ browser/* animationFrame */.rs; },
  application: function() { return /* reexport */ application/* application */.wU; },
  browserCodeLoadingCacheStrategy: function() { return /* reexport */ platform/* browserCodeLoadingCacheStrategy */.US; },
  cancelled: function() { return /* reexport */ cancellation/* cancelled */.By; },
  checkCancelled: function() { return /* reexport */ cancellation/* checkCancelled */.Vp; },
  cloneAndChange: function() { return /* reexport */ objects.cloneAndChange; },
  combinedDisposable: function() { return /* reexport */ combinedDisposable; },
  commonPrefixLength: function() { return /* reexport */ commonPrefixLength; },
  commonSuffixLength: function() { return /* reexport */ commonSuffixLength; },
  compare: function() { return /* reexport */ compare; },
  compareIgnoreCase: function() { return /* reexport */ compareIgnoreCase; },
  compareSubstring: function() { return /* reexport */ compareSubstring; },
  compareSubstringIgnoreCase: function() { return /* reexport */ compareSubstringIgnoreCase; },
  computeCodePoint: function() { return /* reexport */ computeCodePoint; },
  contrib: function() { return /* reexport */ mana_syringe_es/* contrib */.el; },
  convertSimple2RegExpPattern: function() { return /* reexport */ convertSimple2RegExpPattern; },
  count: function() { return /* reexport */ count; },
  createDataContextContriburtion: function() { return /* reexport */ createDataContextContriburtion; },
  createFileSystemProviderError: function() { return /* reexport */ createFileSystemProviderError; },
  createRegExp: function() { return /* reexport */ createRegExp; },
  createSlotPreference: function() { return /* reexport */ decorator/* createSlotPreference */.vk; },
  createViewPreference: function() { return /* reexport */ decorator/* createViewPreference */.bQ; },
  debug: function() { return /* reexport */ debug/* debug */.f; },
  decorate: function() { return /* reexport */ mana_syringe_es/* decorate */.GW; },
  deepClone: function() { return /* reexport */ objects.deepClone; },
  deepFreeze: function() { return /* reexport */ objects.deepFreeze; },
  defaultContainerContext: function() { return /* reexport */ es/* defaultContainerContext */.T1; },
  defaultObservableContext: function() { return /* reexport */ es/* defaultObservableContext */.rj; },
  defineProperty: function() { return /* reexport */ es/* defineProperty */._x; },
  diffMaps: function() { return /* reexport */ diffMaps; },
  diffSets: function() { return /* reexport */ diffSets; },
  dispose: function() { return /* reexport */ dispose; },
  distinct: function() { return /* reexport */ objects.distinct; },
  ensureFileSystemProviderError: function() { return /* reexport */ ensureFileSystemProviderError; },
  equals: function() { return /* reexport */ es/* equals */.fS; },
  equalsIgnoreCase: function() { return /* reexport */ equalsIgnoreCase; },
  escape: function() { return /* reexport */ strings_escape; },
  escapeRegExpCharacters: function() { return /* reexport */ escapeRegExpCharacters; },
  etag: function() { return /* reexport */ etag; },
  firstNonWhitespaceIndex: function() { return /* reexport */ firstNonWhitespaceIndex; },
  forEach: function() { return /* reexport */ forEach; },
  format: function() { return /* reexport */ format; },
  fromMap: function() { return /* reexport */ fromMap; },
  getCaseInsensitive: function() { return /* reexport */ objects.getCaseInsensitive; },
  getLeadingWhitespace: function() { return /* reexport */ getLeadingWhitespace; },
  getNextCodePoint: function() { return /* reexport */ getNextCodePoint; },
  getOrDefault: function() { return /* reexport */ objects.getOrDefault; },
  getOrSet: function() { return /* reexport */ map_getOrSet; },
  getOrigin: function() { return /* reexport */ es/* getOrigin */.P$; },
  getPropertyDescriptor: function() { return /* reexport */ es_utils/* getPropertyDescriptor */.w7; },
  globals: function() { return /* reexport */ platform/* globals */.li; },
  groupBy: function() { return /* reexport */ groupBy; },
  hasAccessCapability: function() { return /* reexport */ hasAccessCapability; },
  hasFileFolderCopyCapability: function() { return /* reexport */ hasFileFolderCopyCapability; },
  hasOpenReadWriteCloseCapability: function() { return /* reexport */ hasOpenReadWriteCloseCapability; },
  hasReadWriteCapability: function() { return /* reexport */ hasReadWriteCapability; },
  inject: function() { return /* reexport */ mana_syringe_es/* inject */.f3; },
  injectable: function() { return /* reexport */ mana_syringe_es/* injectable */.b2; },
  isBasicWasmSupported: function() { return /* reexport */ platform/* isBasicWasmSupported */.pC; },
  isCancelled: function() { return /* reexport */ cancellation/* isCancelled */.j2; },
  isChrome: function() { return /* reexport */ platform/* isChrome */.i7; },
  isDisposable: function() { return /* reexport */ isDisposable; },
  isEdge: function() { return /* reexport */ platform/* isEdge */.un; },
  isEdgeOrIE: function() { return /* reexport */ platform/* isEdgeOrIE */.eU; },
  isElectronSandboxed: function() { return /* reexport */ platform/* isElectronSandboxed */.O7; },
  isEmpty: function() { return /* reexport */ objects.isEmpty; },
  isFalsyOrWhitespace: function() { return /* reexport */ isFalsyOrWhitespace; },
  isFirefox: function() { return /* reexport */ platform/* isFirefox */.vU; },
  isForwardRefComponent: function() { return /* reexport */ utils/* isForwardRefComponent */.YP; },
  isHighSurrogate: function() { return /* reexport */ isHighSurrogate; },
  isIE: function() { return /* reexport */ platform/* isIE */.w1; },
  isIOS: function() { return /* reexport */ platform/* isIOS */.gn; },
  isIPad: function() { return /* reexport */ platform/* isIPad */.zc; },
  isLinux: function() { return /* reexport */ platform/* isLinux */.IJ; },
  isLinuxSnap: function() { return /* reexport */ platform/* isLinuxSnap */.py; },
  isLittleEndian: function() { return /* reexport */ platform/* isLittleEndian */.r; },
  isLowSurrogate: function() { return /* reexport */ isLowSurrogate; },
  isLowerAsciiLetter: function() { return /* reexport */ isLowerAsciiLetter; },
  isMacintosh: function() { return /* reexport */ platform/* isMacintosh */.dz; },
  isMemoComponent: function() { return /* reexport */ utils/* isMemoComponent */.ue; },
  isNative: function() { return /* reexport */ platform/* isNative */.tY; },
  isOSX: function() { return /* reexport */ platform/* isOSX */.id; },
  isOpera: function() { return /* reexport */ platform/* isOpera */.f0; },
  isPlainObject: function() { return /* reexport */ es_utils/* isPlainObject */.PO; },
  isPreferringBrowserCodeLoad: function() { return /* reexport */ platform/* isPreferringBrowserCodeLoad */.MM; },
  isPromise: function() { return /* reexport */ isPromise; },
  isPromiseLike: function() { return /* reexport */ isPromiseLike; },
  isReadonly: function() { return /* reexport */ es/* isReadonly */.$y; },
  isSafari: function() { return /* reexport */ platform/* isSafari */.G6; },
  isSyringeModule: function() { return /* reexport */ mana_syringe_es/* isSyringeModule */.fE; },
  isUpperAsciiLetter: function() { return /* reexport */ isUpperAsciiLetter; },
  isWeb: function() { return /* reexport */ platform/* isWeb */.$L; },
  isWebKit: function() { return /* reexport */ platform/* isWebKit */.Pf; },
  isWindows: function() { return /* reexport */ platform/* isWindows */.ED; },
  language: function() { return /* reexport */ platform/* language */.dK; },
  lastNonWhitespaceIndex: function() { return /* reexport */ lastNonWhitespaceIndex; },
  localStorageService: function() { return /* reexport */ localStorageService; },
  locale: function() { return /* reexport */ platform/* locale */.SP; },
  ltrim: function() { return /* reexport */ ltrim; },
  markAsFileSystemProviderError: function() { return /* reexport */ markAsFileSystemProviderError; },
  mixin: function() { return /* reexport */ objects.mixin; },
  named: function() { return /* reexport */ mana_syringe_es/* named */.t6; },
  noop: function() { return /* reexport */ es_utils/* noop */.ZT; },
  notEmpty: function() { return /* reexport */ objects.notEmpty; },
  notFalse: function() { return /* reexport */ notFalse; },
  objectEquals: function() { return /* reexport */ objects.objectEquals; },
  objects: function() { return /* reexport */ objects; },
  observable: function() { return /* reexport */ es/* observable */.LO; },
  ok: function() { return /* reexport */ ok; },
  once: function() { return /* reexport */ once; },
  open: function() { return /* reexport */ open_handler_open; },
  optional: function() { return /* reexport */ mana_syringe_es/* optional */.jt; },
  origin: function() { return /* reexport */ es/* origin */.hW; },
  parseCssMagnitude: function() { return /* reexport */ browser/* parseCssMagnitude */.xC; },
  parseCssTime: function() { return /* reexport */ browser/* parseCssTime */.Jw; },
  platform: function() { return /* reexport */ platform/* platform */.Jv; },
  postConstruct: function() { return /* reexport */ mana_syringe_es/* postConstruct */.zY; },
  preventNavigation: function() { return /* reexport */ browser/* preventNavigation */.E0; },
  prop: function() { return /* reexport */ es/* prop */.vg; },
  regExpContainsBackreference: function() { return /* reexport */ regExpContainsBackreference; },
  regExpFlags: function() { return /* reexport */ regExpFlags; },
  regExpLeadsToEndlessLoop: function() { return /* reexport */ regExpLeadsToEndlessLoop; },
  register: function() { return /* reexport */ mana_syringe_es/* register */.z2; },
  registerSideOption: function() { return /* reexport */ mana_syringe_es/* registerSideOption */.SZ; },
  renderModal: function() { return /* reexport */ modal_protocol_renderModal; },
  renderNode: function() { return /* reexport */ utils/* renderNode */.$u; },
  retry: function() { return /* reexport */ promise_util/* retry */.X; },
  rtrim: function() { return /* reexport */ rtrim; },
  safeStringify: function() { return /* reexport */ objects.safeStringify; },
  setDisposableTracker: function() { return /* reexport */ setDisposableTracker; },
  singleton: function() { return /* reexport */ mana_syringe_es/* singleton */.ri; },
  splitLines: function() { return /* reexport */ splitLines; },
  startsWithIgnoreCase: function() { return /* reexport */ startsWithIgnoreCase; },
  stripWildcards: function() { return /* reexport */ stripWildcards; },
  timeout: function() { return /* reexport */ promise_util/* timeout */.V; },
  toArray: function() { return /* reexport */ toArray; },
  toDisposable: function() { return /* reexport */ toDisposable; },
  toFileOperationResult: function() { return /* reexport */ toFileOperationResult; },
  toFileSystemProviderErrorCode: function() { return /* reexport */ toFileSystemProviderErrorCode; },
  trackDisposable: function() { return /* reexport */ trackDisposable; },
  transient: function() { return /* reexport */ mana_syringe_es/* transient */.H3; },
  translationsConfigFile: function() { return /* reexport */ platform/* translationsConfigFile */.bN; },
  trim: function() { return /* reexport */ trim; },
  truncate: function() { return /* reexport */ truncate; },
  tryInvokeGetter: function() { return /* reexport */ es/* tryInvokeGetter */.gE; },
  types: function() { return /* reexport */ valueTypes; },
  unmanaged: function() { return /* reexport */ mana_syringe_es/* unmanaged */.NT; },
  useChildContainer: function() { return /* reexport */ menu_render/* useChildContainer */.E; },
  useConfigurationValue: function() { return /* reexport */ useConfigurationValue; },
  useInject: function() { return /* reexport */ es/* useInject */.oC; },
  useLatest: function() { return /* reexport */ utils_hooks/* useLatest */.dU; },
  useMount: function() { return /* reexport */ utils_hooks/* useMount */.b6; },
  useObservableState: function() { return /* reexport */ es/* useObservableState */.pw; },
  useObserve: function() { return /* reexport */ es/* useObserve */.Re; },
  useSize: function() { return /* reexport */ utils_hooks/* useSize */.tH; },
  useSizeCallback: function() { return /* reexport */ utils_hooks/* useSizeCallback */.kp; },
  useUnmount: function() { return /* reexport */ utils_hooks/* useUnmount */.kw; },
  useViewSize: function() { return /* reexport */ hooks/* useViewSize */.d; },
  userAgent: function() { return /* reexport */ platform/* userAgent */.WE; },
  values: function() { return /* reexport */ values; },
  view: function() { return /* reexport */ decorator/* view */.ei; },
  watch: function() { return /* reexport */ es/* watch */.YP; }
});

// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/module/mana-module.js
var mana_module = __webpack_require__(19859);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/application/index.js + 1 modules
var application = __webpack_require__(84034);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/command/command-registry.js
var command_registry = __webpack_require__(68280);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/command/command-protocol.js
var command_protocol = __webpack_require__(94194);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/command/index.js




var CommandModule = mana_module/* ManaModule */.R.create().contribution(command_registry/* CommandContribution */.p).register(command_registry/* CommandRegistry */.H);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/common/debug.js
var debug = __webpack_require__(24516);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/common/storage-protocol.js
var StorageService = Symbol('StorageService');

/**
 * The storage service provides an interface to some data storage that allows extensions to keep state among sessions.
 */
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/common/storage-service.js
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor); } }
function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : String(i); }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

var LocalStorageService = /*#__PURE__*/function () {
  function LocalStorageService() {
    _classCallCheck(this, LocalStorageService);
    this.storage = {};
    this.logger = debug/* debug */.f;
    if (typeof window !== 'undefined' && window.localStorage) {
      this.storage = window.localStorage;
      this.testLocalStorage();
    } else {
      this.logger.log("The browser doesn't support localStorage.");
      this.storage = {};
    }
  }
  _createClass(LocalStorageService, [{
    key: "setData",
    value: function setData(key, data) {
      if (data !== undefined) {
        try {
          this.storage[this.prefix(key)] = JSON.stringify(data);
        } catch (e) {
          this.showDiskQuotaExceededMessage();
        }
      } else {
        delete this.storage[this.prefix(key)];
      }
      return;
    }
  }, {
    key: "getData",
    value: function getData(key, defaultValue) {
      var result = this.storage[this.prefix(key)];
      if (result === undefined) {
        return defaultValue;
      }
      return JSON.parse(result);
    }
  }, {
    key: "prefix",
    value: function prefix(key) {
      var pathname = typeof window === 'undefined' ? '' : window.location.pathname;
      return "mana:".concat(pathname, ":").concat(key);
    }

    // TODO
  }, {
    key: "showDiskQuotaExceededMessage",
    value: function () {
      var _showDiskQuotaExceededMessage = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      function showDiskQuotaExceededMessage() {
        return _showDiskQuotaExceededMessage.apply(this, arguments);
      }
      return showDiskQuotaExceededMessage;
    }()
    /**
     * Verify if there is still some spaces left to save another workspace configuration into the local storage of your browser.
     * If we are close to the limit, use a dialog to notify the user.
     */
  }, {
    key: "testLocalStorage",
    value: function testLocalStorage() {
      var keyTest = this.prefix('Test');
      try {
        this.storage[keyTest] = JSON.stringify(new Array(60000));
      } catch (error) {
        this.showDiskQuotaExceededMessage();
      } finally {
        var _this$storage$removeI, _this$storage;
        (_this$storage$removeI = (_this$storage = this.storage).removeItem) === null || _this$storage$removeI === void 0 || _this$storage$removeI.call(_this$storage, keyTest);
      }
    }
  }, {
    key: "clearStorage",
    value: function clearStorage() {
      var _this$storage$clear, _this$storage2;
      (_this$storage$clear = (_this$storage2 = this.storage).clear) === null || _this$storage$clear === void 0 || _this$storage$clear.call(_this$storage2);
    }
  }]);
  return LocalStorageService;
}();
var localStorageService = new LocalStorageService();
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/common/index.js







var CommonModule = mana_module/* ManaModule */.R.create().register({
  token: StorageService,
  useValue: localStorageService
}).register({
  token: LocalStorageService,
  useValue: localStorageService
}).register({
  token: debug/* DebugService */.r,
  useValue: debug/* debug */.f
});
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-observable@0.1.19_react@18.3.1/node_modules/@difizen/mana-observable/es/index.js + 12 modules
var es = __webpack_require__(73004);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-syringe@0.1.19/node_modules/@difizen/mana-syringe/es/index.js + 15 modules
var mana_syringe_es = __webpack_require__(37637);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/configuration-storage.js
/**
 * 内存存储
 */
var DefaultConfigurationStorage = {
  id: '__default_configuration_storage',
  priority: 0
};

/**
 * localstorage 存储
 */
var LocalConfigurationStorage = {
  id: '__local_configuration_storage',
  priority: 1
};
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/configuration-provider.js
function configuration_provider_typeof(o) { "@babel/helpers - typeof"; return configuration_provider_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configuration_provider_typeof(o); }
var _dec, _dec2, _class, _class2, _descriptor, _dec3, _class3;
function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function configuration_provider_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configuration_provider_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configuration_provider_toPropertyKey(descriptor.key), descriptor); } }
function configuration_provider_createClass(Constructor, protoProps, staticProps) { if (protoProps) configuration_provider_defineProperties(Constructor.prototype, protoProps); if (staticProps) configuration_provider_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configuration_provider_toPropertyKey(t) { var i = configuration_provider_toPrimitive(t, "string"); return "symbol" == configuration_provider_typeof(i) ? i : String(i); }
function configuration_provider_toPrimitive(t, r) { if ("object" != configuration_provider_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configuration_provider_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }



var ConfigurationProvider = mana_syringe_es/* Syringe */.J3.defineToken('ConfigurationProvider');
var DefaultConfigurationProvider = (_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: [ConfigurationProvider]
}), _dec2 = (0,es/* prop */.vg)(), _dec(_class = (_class2 = /*#__PURE__*/function () {
  function DefaultConfigurationProvider() {
    var _this = this;
    configuration_provider_classCallCheck(this, DefaultConfigurationProvider);
    _initializerDefineProperty(this, "configStore", _descriptor, this);
    this.has = function (node) {
      return _this.configStore.has(node.id);
    };
    this.get = function (node) {
      return _this.configStore.get(node.id);
    };
    this.set = function (node, value) {
      _this.configStore.set(node.id, value);
    };
    this.remove = function (node) {
      _this.configStore.delete(node.id);
    };
  }
  configuration_provider_createClass(DefaultConfigurationProvider, [{
    key: "canHandle",
    value:
    /**
     * 默认用内存的provider
     * @returns
     */
    function canHandle(storage) {
      if (storage === DefaultConfigurationStorage) {
        return 100;
      }
      return 0;
    }
  }]);
  return DefaultConfigurationProvider;
}(), (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "configStore", [_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Map();
  }
})), _class2)) || _class);
var LocalStorageConfigurationProvider = (_dec3 = (0,mana_syringe_es/* singleton */.ri)({
  contrib: [ConfigurationProvider]
}), _dec3(_class3 = /*#__PURE__*/function () {
  function LocalStorageConfigurationProvider() {
    var _this2 = this;
    configuration_provider_classCallCheck(this, LocalStorageConfigurationProvider);
    this.configStore = localStorage;
    this.has = function (node) {
      return _this2.configStore.getItem(_this2.prefix(node.id)) !== null;
    };
    this.get = function (node) {
      var result = _this2.configStore.getItem(_this2.prefix(node.id));
      return JSON.parse(result !== null && result !== void 0 ? result : '');
    };
    this.set = function (node, value) {
      _this2.configStore.setItem(_this2.prefix(node.id), JSON.stringify(value));
    };
    this.remove = function (node) {
      _this2.configStore.removeItem(_this2.prefix(node.id));
    };
  }
  configuration_provider_createClass(LocalStorageConfigurationProvider, [{
    key: "canHandle",
    value: function canHandle(storage) {
      if (storage === LocalConfigurationStorage) {
        return 100;
      }
      return 0;
    }
  }, {
    key: "prefix",
    value: function prefix(key) {
      var pathname = typeof window === 'undefined' ? '' : window.location.pathname;
      return "mana:configuration:".concat(pathname, ":").concat(key);
    }
  }]);
  return LocalStorageConfigurationProvider;
}()) || _class3);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/disposable-collection.js
var disposable_collection = __webpack_require__(65583);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/application/application.js
var application_application = __webpack_require__(1856);
// EXTERNAL MODULE: ../../node_modules/.pnpm/ajv@8.16.0/node_modules/ajv/dist/ajv.js
var ajv = __webpack_require__(13792);
var ajv_default = /*#__PURE__*/__webpack_require__.n(ajv);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/validation.js
function validation_typeof(o) { "@babel/helpers - typeof"; return validation_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, validation_typeof(o); }
var validation_dec, validation_class;
function validation_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function validation_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, validation_toPropertyKey(descriptor.key), descriptor); } }
function validation_createClass(Constructor, protoProps, staticProps) { if (protoProps) validation_defineProperties(Constructor.prototype, protoProps); if (staticProps) validation_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function validation_toPropertyKey(t) { var i = validation_toPrimitive(t, "string"); return "symbol" == validation_typeof(i) ? i : String(i); }
function validation_toPrimitive(t, r) { if ("object" != validation_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != validation_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var SchemaValidator = (validation_dec = (0,mana_syringe_es/* singleton */.ri)(), validation_dec(validation_class = /*#__PURE__*/function () {
  function SchemaValidator() {
    validation_classCallCheck(this, SchemaValidator);
    this.ajvInstance = new (ajv_default())();
  }
  validation_createClass(SchemaValidator, [{
    key: "addSchema",
    value:
    /**
     * https://ajv.js.org/guide/managing-schemas.html#using-ajv-instance-cache
     */
    function addSchema(node) {
      (0,es/* getOrigin */.P$)(this.ajvInstance).addSchema(node.schema, node.id);
    }
  }, {
    key: "getSchema",
    value: function getSchema(node) {
      return (0,es/* getOrigin */.P$)(this.ajvInstance).getSchema(node.id);
    }
  }, {
    key: "validateNode",
    value: function validateNode(node, value) {
      var validate = this.getSchema(node);
      if (validate === undefined) {
        return false;
      }
      var valid = validate(value);
      if (!valid) {
        console.warn(validate.errors);
      }
      return valid;
    }
  }]);
  return SchemaValidator;
}()) || validation_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/configuration-registry.js
function configuration_registry_typeof(o) { "@babel/helpers - typeof"; return configuration_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configuration_registry_typeof(o); }
var configuration_registry_dec, configuration_registry_class;
function _createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }
function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function configuration_registry_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ configuration_registry_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == configuration_registry_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(configuration_registry_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function configuration_registry_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function configuration_registry_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { configuration_registry_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { configuration_registry_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function configuration_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configuration_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configuration_registry_toPropertyKey(descriptor.key), descriptor); } }
function configuration_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) configuration_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) configuration_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configuration_registry_toPropertyKey(t) { var i = configuration_registry_toPrimitive(t, "string"); return "symbol" == configuration_registry_typeof(i) ? i : String(i); }
function configuration_registry_toPrimitive(t, r) { if ("object" != configuration_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configuration_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





var ConfigurationContribution = mana_syringe_es/* Syringe */.J3.defineToken('ConfigurationContribution');
var ConfigurationRegistry = (configuration_registry_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: [application_application/* ApplicationContribution */.rS]
}), configuration_registry_dec(configuration_registry_class = /*#__PURE__*/function () {
  function ConfigurationRegistry(schemaValidator, providers) {
    configuration_registry_classCallCheck(this, ConfigurationRegistry);
    this.toDispose = new disposable_collection/* DisposableCollection */.K();
    this.defaultStorage = DefaultConfigurationStorage;
    this.configurationNodes = [];
    this.scopes = new Map();
    this.schemaValidator = schemaValidator;
    this.providers = providers;
  }
  ConfigurationRegistry = (0,mana_syringe_es/* contrib */.el)(ConfigurationContribution)(ConfigurationRegistry, undefined, 1) || ConfigurationRegistry;
  ConfigurationRegistry = (0,mana_syringe_es/* inject */.f3)(SchemaValidator)(ConfigurationRegistry, undefined, 0) || ConfigurationRegistry;
  configuration_registry_createClass(ConfigurationRegistry, [{
    key: "onStart",
    value: function () {
      var _onStart = configuration_registry_asyncToGenerator( /*#__PURE__*/configuration_registry_regeneratorRuntime().mark(function _callee() {
        return configuration_registry_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.setupConfiguration();
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function onStart() {
        return _onStart.apply(this, arguments);
      }
      return onStart;
    }()
  }, {
    key: "setupConfiguration",
    value: function () {
      var _setupConfiguration = configuration_registry_asyncToGenerator( /*#__PURE__*/configuration_registry_regeneratorRuntime().mark(function _callee2() {
        var contribs, _iterator, _step, configurationContrib, node, nodes, _iterator2, _step2, _configurationContrib, _nodes;
        return configuration_registry_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              contribs = this.providers.getContributions();
              _iterator = _createForOfIteratorHelper(contribs);
              _context2.prev = 2;
              _iterator.s();
            case 4:
              if ((_step = _iterator.n()).done) {
                _context2.next = 18;
                break;
              }
              configurationContrib = _step.value;
              if (!configurationContrib.registerConfiguration) {
                _context2.next = 11;
                break;
              }
              _context2.next = 9;
              return configurationContrib.registerConfiguration();
            case 9:
              node = _context2.sent;
              this.registerConfiguration(node);
            case 11:
              if (!configurationContrib.registerConfigurations) {
                _context2.next = 16;
                break;
              }
              _context2.next = 14;
              return configurationContrib.registerConfigurations();
            case 14:
              nodes = _context2.sent;
              this.registerConfigurations(nodes);
            case 16:
              _context2.next = 4;
              break;
            case 18:
              _context2.next = 23;
              break;
            case 20:
              _context2.prev = 20;
              _context2.t0 = _context2["catch"](2);
              _iterator.e(_context2.t0);
            case 23:
              _context2.prev = 23;
              _iterator.f();
              return _context2.finish(23);
            case 26:
              _iterator2 = _createForOfIteratorHelper(contribs);
              _context2.prev = 27;
              _iterator2.s();
            case 29:
              if ((_step2 = _iterator2.n()).done) {
                _context2.next = 38;
                break;
              }
              _configurationContrib = _step2.value;
              if (!_configurationContrib.deregisterConfigurations) {
                _context2.next = 36;
                break;
              }
              _context2.next = 34;
              return _configurationContrib.deregisterConfigurations();
            case 34:
              _nodes = _context2.sent;
              this.deregisterConfigurations(_nodes);
            case 36:
              _context2.next = 29;
              break;
            case 38:
              _context2.next = 43;
              break;
            case 40:
              _context2.prev = 40;
              _context2.t1 = _context2["catch"](27);
              _iterator2.e(_context2.t1);
            case 43:
              _context2.prev = 43;
              _iterator2.f();
              return _context2.finish(43);
            case 46:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[2, 20, 23, 26], [27, 40, 43, 46]]);
      }));
      function setupConfiguration() {
        return _setupConfiguration.apply(this, arguments);
      }
      return setupConfiguration;
    }()
  }, {
    key: "getStorage",
    value: function getStorage(configuration) {
      var _configuration$storag;
      return (_configuration$storag = configuration.storage) !== null && _configuration$storag !== void 0 ? _configuration$storag : this.defaultStorage;
    }
  }, {
    key: "hasConfiguration",
    value: function hasConfiguration(configuration) {
      var has = false;
      var _iterator3 = _createForOfIteratorHelper(this.configurationNodes),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var node = _step3.value;
          if (node.id === configuration.id) {
            has = true;
            break;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return has;
    }
  }, {
    key: "findConfiguration",
    value: function findConfiguration(id) {
      var result;
      var _iterator4 = _createForOfIteratorHelper(this.configurationNodes),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var node = _step4.value;
          if (node.id === id) {
            result = node;
            break;
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      return result;
    }

    /**
     * Register a configuration to the registry.
     */
  }, {
    key: "registerConfiguration",
    value: function registerConfiguration(configuration) {
      var config = this.findConfiguration(configuration.id);
      if (config && config.overridable === false) {
        console.warn("cannot override configuration: ".concat(config.id));
        return;
      }
      this.schemaValidator.addSchema(configuration);
      this.deregisterConfiguration(configuration);
      this.configurationNodes.push(configuration);
      var scope = this.getStorage(configuration);
      this.addStorage(scope);
    }

    /**
     * Register multiple configurations to the registry.
     */
  }, {
    key: "registerConfigurations",
    value: function registerConfigurations(configurations) {
      var _this = this;
      configurations.forEach(function (config) {
        _this.registerConfiguration(config);
      });
    }

    /**
     * Deregister multiple configurations from the registry.
     */
  }, {
    key: "deregisterConfigurations",
    value: function deregisterConfigurations(configurations) {
      var _this2 = this;
      configurations.forEach(function (config) {
        _this2.deregisterConfiguration(config);
      });
    }
  }, {
    key: "deregisterConfiguration",
    value: function deregisterConfiguration(configuration) {
      var currentConfig = this.findConfiguration(configuration.id);
      if (!currentConfig) {
        return;
      }
      var index = this.configurationNodes.findIndex(function (item) {
        return item.id === configuration.id;
      });
      if (index >= 0) {
        this.configurationNodes.splice(index, 1);
      }
    }
  }, {
    key: "getConfigurationsByScope",
    value: function getConfigurationsByScope(storage) {
      return this.configurationNodes.filter(function (node) {
        var _node$storage;
        var nodeStorage = (_node$storage = node.storage) !== null && _node$storage !== void 0 ? _node$storage : DefaultConfigurationStorage;
        return nodeStorage === storage;
      });
    }
  }, {
    key: "getStorages",
    value: function getStorages() {
      return Array.from(this.scopes.values());
    }

    /**
     *  添加scope，已包含错误处理
     */
  }, {
    key: "addStorage",
    value: function addStorage(scope) {
      var _this$scopes$get;
      if (this.scopes.get(scope.id) && ((_this$scopes$get = this.scopes.get(scope.id)) === null || _this$scopes$get === void 0 ? void 0 : _this$scopes$get.priority) !== scope.priority) {
        console.warn('添加scope时,scopeId相同,priority不一致');
        return;
      }
      if (!this.scopes.has(scope.id)) {
        this.scopes.set(scope.id, scope);
      }
    }
  }, {
    key: "getConfigurationByNamespace",
    value: function getConfigurationByNamespace(namespace) {
      var isFullMatch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var nodes = [];
      var _iterator5 = _createForOfIteratorHelper(this.configurationNodes),
        _step5;
      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var node = _step5.value;
          var nodeNamespace = this.getNamespace(node);
          if (isFullMatch) {
            if (nodeNamespace.join('.') === namespace.join('.')) {
              nodes.push(node);
            }
          } else {
            if (nodeNamespace.join('.').startsWith(namespace.join('.'))) {
              nodes.push(node);
            }
          }
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
      return nodes;
    }
  }, {
    key: "getNamespace",
    value: function getNamespace(node) {
      var segments = node.id.split('.').filter(function (item) {
        return item.trim() !== '';
      });
      if (segments.length <= 1) {
        throw new Error('invalid configuration! id must have dot, eg. editor.fontsize');
      }
      return segments.slice(0, segments.length - 1);
    }
  }, {
    key: "getRootNamespaces",
    value: function getRootNamespaces() {
      var ids = this.configurationNodes.map(function (item) {
        return item.id.split('.').at(0);
      }).filter(function (item) {
        return item !== undefined;
      });
      return Array.from(new Set(ids));
    }
  }, {
    key: "getChildNamespaces",
    value: function getChildNamespaces(namespace) {
      var _this3 = this;
      if (namespace.length === 0) {
        console.warn('invalid namespace');
        return [];
      }
      return this.configurationNodes.map(function (item) {
        var nodeNamespace = _this3.getNamespace(item);
        if (namespace.length < nodeNamespace.length && nodeNamespace.join('.').startsWith(namespace.join('.'))) {
          return nodeNamespace.slice(0, namespace.length + 1);
        }
        return [];
      }).filter(function (item) {
        return item.length > 0;
      });
    }
  }]);
  return ConfigurationRegistry;
}()) || configuration_registry_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/configuration-render-registry.js
function configuration_render_registry_typeof(o) { "@babel/helpers - typeof"; return configuration_render_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configuration_render_registry_typeof(o); }
var configuration_render_registry_dec, configuration_render_registry_class;
function configuration_render_registry_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = configuration_render_registry_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function configuration_render_registry_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return configuration_render_registry_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return configuration_render_registry_arrayLikeToArray(o, minLen); }
function configuration_render_registry_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(obj, key, value) { key = configuration_render_registry_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function configuration_render_registry_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ configuration_render_registry_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == configuration_render_registry_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(configuration_render_registry_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function configuration_render_registry_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function configuration_render_registry_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { configuration_render_registry_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { configuration_render_registry_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function configuration_render_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configuration_render_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configuration_render_registry_toPropertyKey(descriptor.key), descriptor); } }
function configuration_render_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) configuration_render_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) configuration_render_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configuration_render_registry_toPropertyKey(t) { var i = configuration_render_registry_toPrimitive(t, "string"); return "symbol" == configuration_render_registry_typeof(i) ? i : String(i); }
function configuration_render_registry_toPrimitive(t, r) { if ("object" != configuration_render_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configuration_render_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


function notFalse(x) {
  return x !== false;
}
var ConfigurationRenderContribution = mana_syringe_es/* Syringe */.J3.defineToken('ConfigurationRenderContribution');
var ConfigurationRenderRegistry = (configuration_render_registry_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: [application_application/* ApplicationContribution */.rS]
}), configuration_render_registry_dec(configuration_render_registry_class = /*#__PURE__*/function () {
  function ConfigurationRenderRegistry(providers) {
    configuration_render_registry_classCallCheck(this, ConfigurationRenderRegistry);
    this.renders = [];
    this.providers = providers;
  }
  ConfigurationRenderRegistry = (0,mana_syringe_es/* contrib */.el)(ConfigurationRenderContribution)(ConfigurationRenderRegistry, undefined, 0) || ConfigurationRenderRegistry;
  configuration_render_registry_createClass(ConfigurationRenderRegistry, [{
    key: "onStart",
    value: function () {
      var _onStart = configuration_render_registry_asyncToGenerator( /*#__PURE__*/configuration_render_registry_regeneratorRuntime().mark(function _callee() {
        return configuration_render_registry_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.setupRenderContribution();
            case 2:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function onStart() {
        return _onStart.apply(this, arguments);
      }
      return onStart;
    }()
  }, {
    key: "setupRenderContribution",
    value: function () {
      var _setupRenderContribution = configuration_render_registry_asyncToGenerator( /*#__PURE__*/configuration_render_registry_regeneratorRuntime().mark(function _callee2() {
        var _this = this;
        return configuration_render_registry_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              this.providers.getContributions().forEach(function (contribution) {
                if (contribution.registerConfigurationRenders) {
                  var renders = contribution.registerConfigurationRenders();
                  renders.forEach(function (render) {
                    _this.registerConfigurationRender(render);
                  });
                }
              });
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function setupRenderContribution() {
        return _setupRenderContribution.apply(this, arguments);
      }
      return setupRenderContribution;
    }()
  }, {
    key: "registerConfigurationRender",
    value: function registerConfigurationRender(render) {
      this.renders.push(render);
    }
  }, {
    key: "getConfigurationRender",
    value: function getConfigurationRender(configuration) {
      var validRender = this.renders.map(function (render) {
        return _objectSpread(_objectSpread({}, render), {}, {
          priority: render.canHandle(configuration)
        });
      }).filter(function (render) {
        return notFalse(render.priority);
      });
      if (validRender.length === 0) {
        console.warn("found no component for ".concat(configuration.type));
        return null;
      }
      // 相比sort性能更高
      var maxPriorityRender = validRender[0];
      var _iterator = configuration_render_registry_createForOfIteratorHelper(validRender),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var render = _step.value;
          if (render.priority > maxPriorityRender.priority) {
            maxPriorityRender = render;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return maxPriorityRender.component;
    }
  }]);
  return ConfigurationRenderRegistry;
}()) || configuration_render_registry_class);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/event.js
var es_event = __webpack_require__(27182);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/configuration-service.js
function configuration_service_typeof(o) { "@babel/helpers - typeof"; return configuration_service_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configuration_service_typeof(o); }
var configuration_service_dec, configuration_service_class;
function configuration_service_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function configuration_service_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? configuration_service_ownKeys(Object(t), !0).forEach(function (r) { configuration_service_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : configuration_service_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function configuration_service_defineProperty(obj, key, value) { key = configuration_service_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function configuration_service_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ configuration_service_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == configuration_service_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(configuration_service_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function configuration_service_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = configuration_service_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function configuration_service_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return configuration_service_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return configuration_service_arrayLikeToArray(o, minLen); }
function configuration_service_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function configuration_service_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function configuration_service_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { configuration_service_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { configuration_service_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function configuration_service_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configuration_service_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configuration_service_toPropertyKey(descriptor.key), descriptor); } }
function configuration_service_createClass(Constructor, protoProps, staticProps) { if (protoProps) configuration_service_defineProperties(Constructor.prototype, protoProps); if (staticProps) configuration_service_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configuration_service_toPropertyKey(t) { var i = configuration_service_toPrimitive(t, "string"); return "symbol" == configuration_service_typeof(i) ? i : String(i); }
function configuration_service_toPrimitive(t, r) { if ("object" != configuration_service_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configuration_service_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }







var ConfigurationService = (configuration_service_dec = (0,mana_syringe_es/* singleton */.ri)(), configuration_service_dec(configuration_service_class = /*#__PURE__*/function () {
  function ConfigurationService(providers, configurationRegistry, schemaValidator) {
    configuration_service_classCallCheck(this, ConfigurationService);
    this.onConfigurationValueChangeEmitter = new es_event/* Emitter */.Q5();
    this.onConfigurationValueChange = this.onConfigurationValueChangeEmitter.event;
    this.providers = providers;
    this.configurationRegistry = configurationRegistry;
    this.schemaValidator = schemaValidator;
  }
  ConfigurationService = (0,mana_syringe_es/* inject */.f3)(SchemaValidator)(ConfigurationService, undefined, 2) || ConfigurationService;
  ConfigurationService = (0,mana_syringe_es/* inject */.f3)(ConfigurationRegistry)(ConfigurationService, undefined, 1) || ConfigurationService;
  ConfigurationService = (0,mana_syringe_es/* contrib */.el)(ConfigurationProvider)(ConfigurationService, undefined, 0) || ConfigurationService;
  configuration_service_createClass(ConfigurationService, [{
    key: "has",
    value: function () {
      var _has = configuration_service_asyncToGenerator( /*#__PURE__*/configuration_service_regeneratorRuntime().mark(function _callee(node) {
        var result, scopeArray, _iterator, _step, scope, provider, hasValue;
        return configuration_service_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              result = false;
              scopeArray = this.configurationRegistry.getStorages();
              _iterator = configuration_service_createForOfIteratorHelper(scopeArray.sort(function (a, b) {
                return b.priority - a.priority;
              }));
              _context.prev = 3;
              _iterator.s();
            case 5:
              if ((_step = _iterator.n()).done) {
                _context.next = 18;
                break;
              }
              scope = _step.value;
              provider = this.getConfigurationProviderByStorage(scope);
              if (provider) {
                _context.next = 10;
                break;
              }
              return _context.abrupt("continue", 16);
            case 10:
              _context.next = 12;
              return provider.has(node);
            case 12:
              hasValue = _context.sent;
              if (!hasValue) {
                _context.next = 16;
                break;
              }
              result = true;
              return _context.abrupt("break", 18);
            case 16:
              _context.next = 5;
              break;
            case 18:
              _context.next = 23;
              break;
            case 20:
              _context.prev = 20;
              _context.t0 = _context["catch"](3);
              _iterator.e(_context.t0);
            case 23:
              _context.prev = 23;
              _iterator.f();
              return _context.finish(23);
            case 26:
              return _context.abrupt("return", result);
            case 27:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[3, 20, 23, 26]]);
      }));
      function has(_x) {
        return _has.apply(this, arguments);
      }
      return has;
    }()
  }, {
    key: "get",
    value: function () {
      var _get = configuration_service_asyncToGenerator( /*#__PURE__*/configuration_service_regeneratorRuntime().mark(function _callee2(node, defaultValue) {
        var result, scopeArray, _iterator2, _step2, scope, provider, hasValue, val;
        return configuration_service_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              result = defaultValue !== null && defaultValue !== void 0 ? defaultValue : node.defaultValue;
              scopeArray = this.configurationRegistry.getStorages();
              _iterator2 = configuration_service_createForOfIteratorHelper(scopeArray.sort(function (a, b) {
                return b.priority - a.priority;
              }));
              _context2.prev = 3;
              _iterator2.s();
            case 5:
              if ((_step2 = _iterator2.n()).done) {
                _context2.next = 22;
                break;
              }
              scope = _step2.value;
              provider = this.getConfigurationProviderByStorage(scope);
              if (provider) {
                _context2.next = 10;
                break;
              }
              return _context2.abrupt("continue", 20);
            case 10:
              _context2.next = 12;
              return provider.has(node);
            case 12:
              hasValue = _context2.sent;
              if (hasValue) {
                _context2.next = 15;
                break;
              }
              return _context2.abrupt("continue", 20);
            case 15:
              _context2.next = 17;
              return provider.get(node);
            case 17:
              val = _context2.sent;
              result = val;
              return _context2.abrupt("break", 22);
            case 20:
              _context2.next = 5;
              break;
            case 22:
              _context2.next = 27;
              break;
            case 24:
              _context2.prev = 24;
              _context2.t0 = _context2["catch"](3);
              _iterator2.e(_context2.t0);
            case 27:
              _context2.prev = 27;
              _iterator2.f();
              return _context2.finish(27);
            case 30:
              return _context2.abrupt("return", result);
            case 31:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this, [[3, 24, 27, 30]]);
      }));
      function get(_x2, _x3) {
        return _get.apply(this, arguments);
      }
      return get;
    }()
    /**
     *
     * @param node 配置
     * @param value 配置的值
     * @param storage 指定配置的值存储的scope。默认为配置的scope，
     * @param validate
     * @returns
     */
  }, {
    key: "set",
    value: (function () {
      var _set = configuration_service_asyncToGenerator( /*#__PURE__*/configuration_service_regeneratorRuntime().mark(function _callee3(node, value, storage, validate) {
        var _ref;
        var setStorage, provider;
        return configuration_service_regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              if (!(validate !== false && !this.schemaValidator.validateNode(node, value))) {
                _context3.next = 2;
                break;
              }
              return _context3.abrupt("return");
            case 2:
              setStorage = (_ref = storage !== null && storage !== void 0 ? storage : node.storage) !== null && _ref !== void 0 ? _ref : DefaultConfigurationStorage;
              this.configurationRegistry.addStorage(setStorage);
              provider = this.getConfigurationProviderByStorage(setStorage);
              if (provider) {
                _context3.next = 7;
                break;
              }
              return _context3.abrupt("return");
            case 7:
              _context3.next = 9;
              return provider.set(node, value);
            case 9:
              this.onConfigurationValueChangeEmitter.fire({
                key: node.id,
                value: value
              });
            case 10:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function set(_x4, _x5, _x6, _x7) {
        return _set.apply(this, arguments);
      }
      return set;
    }())
  }, {
    key: "remove",
    value: function () {
      var _remove = configuration_service_asyncToGenerator( /*#__PURE__*/configuration_service_regeneratorRuntime().mark(function _callee4(node) {
        var scopeArray, _iterator3, _step3, scope, provider;
        return configuration_service_regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              scopeArray = this.configurationRegistry.getStorages();
              _iterator3 = configuration_service_createForOfIteratorHelper(scopeArray.sort(function (a, b) {
                return b.priority - a.priority;
              }));
              _context4.prev = 2;
              _iterator3.s();
            case 4:
              if ((_step3 = _iterator3.n()).done) {
                _context4.next = 14;
                break;
              }
              scope = _step3.value;
              provider = this.getConfigurationProviderByStorage(scope);
              if (provider) {
                _context4.next = 9;
                break;
              }
              return _context4.abrupt("continue", 12);
            case 9:
              if (provider.has(node)) {
                _context4.next = 11;
                break;
              }
              return _context4.abrupt("continue", 12);
            case 11:
              provider.remove(node);
            case 12:
              _context4.next = 4;
              break;
            case 14:
              _context4.next = 19;
              break;
            case 16:
              _context4.prev = 16;
              _context4.t0 = _context4["catch"](2);
              _iterator3.e(_context4.t0);
            case 19:
              _context4.prev = 19;
              _iterator3.f();
              return _context4.finish(19);
            case 22:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this, [[2, 16, 19, 22]]);
      }));
      function remove(_x8) {
        return _remove.apply(this, arguments);
      }
      return remove;
    }()
  }, {
    key: "getConfigurationProviderByStorage",
    value: function getConfigurationProviderByStorage(scope) {
      var contribs = this.providers.getContributions().map(function (item) {
        return configuration_service_objectSpread(configuration_service_objectSpread({}, item), {}, {
          priority: item.canHandle((0,es/* getOrigin */.P$)(scope))
        });
      }).filter(function (item) {
        return item.priority !== false;
      });
      if (contribs.length === 0) {
        return undefined;
      }
      // 相比sort性能更高
      var maxPriorityProvider = contribs[0];
      var _iterator4 = configuration_service_createForOfIteratorHelper(contribs),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var provider = _step4.value;
          if (provider.priority > maxPriorityProvider.priority) {
            maxPriorityProvider = provider;
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      return maxPriorityProvider;
    }
  }]);
  return ConfigurationService;
}()) || configuration_service_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/configuration/module.js






var ConfigurationModule = mana_module/* ManaModule */.R.create().contribution(ConfigurationProvider, ConfigurationContribution, ConfigurationRenderContribution).register(ConfigurationService, DefaultConfigurationProvider, LocalStorageConfigurationProvider, ConfigurationRegistry, ConfigurationRenderRegistry, SchemaValidator);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/module/mana-module-context.js
var mana_module_context = __webpack_require__(61865);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/context/data-context-protocol.js
/* eslint-disable @typescript-eslint/no-explicit-any */

var DataContextContriburtion = mana_syringe_es/* Syringe */.J3.defineToken('DataContextContriburtion');
var createDataContextContriburtion = function createDataContextContriburtion(contribution) {
  return {
    token: DataContextContriburtion,
    useValue: contribution
  };
};
var DataContextSymbol = Symbol('DataContextSymbol');
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/context/data-context-manager.js
function data_context_manager_typeof(o) { "@babel/helpers - typeof"; return data_context_manager_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, data_context_manager_typeof(o); }
var data_context_manager_dec, data_context_manager_class;
function data_context_manager_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = data_context_manager_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function data_context_manager_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return data_context_manager_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return data_context_manager_arrayLikeToArray(o, minLen); }
function data_context_manager_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function data_context_manager_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function data_context_manager_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, data_context_manager_toPropertyKey(descriptor.key), descriptor); } }
function data_context_manager_createClass(Constructor, protoProps, staticProps) { if (protoProps) data_context_manager_defineProperties(Constructor.prototype, protoProps); if (staticProps) data_context_manager_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function data_context_manager_toPropertyKey(t) { var i = data_context_manager_toPrimitive(t, "string"); return "symbol" == data_context_manager_typeof(i) ? i : String(i); }
function data_context_manager_toPrimitive(t, r) { if ("object" != data_context_manager_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != data_context_manager_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var DataContextManager = (data_context_manager_dec = (0,mana_syringe_es/* singleton */.ri)(), data_context_manager_dec(data_context_manager_class = /*#__PURE__*/function () {
  function DataContextManager(provider, context) {
    data_context_manager_classCallCheck(this, DataContextManager);
    this.contruibutions = [];
    this.contextMap = new Map();
    this.provider = provider;
    this.context = context;
  }
  DataContextManager = (0,mana_syringe_es/* inject */.f3)(DataContextSymbol)(DataContextManager, undefined, 1) || DataContextManager;
  DataContextManager = (0,mana_syringe_es/* contrib */.el)(DataContextContriburtion)(DataContextManager, undefined, 0) || DataContextManager;
  data_context_manager_createClass(DataContextManager, [{
    key: "getContributionMap",
    value: function getContributionMap() {
      if (this.contributionMap) {
        return this.contributionMap;
      }
      this.contributionMap = new Map();
      var _iterator = data_context_manager_createForOfIteratorHelper(this.provider.getContributions()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var contribution = _step.value;
          this.contributionMap.set(contribution.key, contribution);
          this.contruibutions.push(contribution);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return this.contributionMap;
    }
  }, {
    key: "create",
    value: function create(contributionKey, options) {
      var contribution = this.getContributionMap().get(contributionKey);
      if (contribution) {
        var child = this.context.container.createChild();
        var ctx = new mana_module_context/* ManaContext */.K(child);
        child.register({
          token: DataContextSymbol,
          useDynamic: function useDynamic() {
            return ctx;
          }
        });
        child.load(contribution.module);
        if (contribution.onCreate) {
          contribution.onCreate(ctx, options);
        }
        var key;
        if (contribution.getKey) {
          key = contribution.getKey(ctx, options);
        } else {
          key = ctx;
        }
        this.contextMap.set(key, ctx);
        return key;
      }
    }
  }, {
    key: "getContext",
    value: function getContext(key) {
      return this.contextMap.get(key);
    }
  }]);
  return DataContextManager;
}()) || data_context_manager_class);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/index.js
var react = __webpack_require__(58757);
// EXTERNAL MODULE: ../../node_modules/.pnpm/react@18.1.0/node_modules/react/jsx-runtime.js
var jsx_runtime = __webpack_require__(35667);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/context/data-context.js




var DataContextRender = /*#__PURE__*/react.memo(function DataContextRender(props) {
  var context = props.context,
    children = props.children;
  if (context) {
    return /*#__PURE__*/(0,jsx_runtime.jsx)(es/* ObservableContext */.A5.Provider, {
      value: {
        getContainer: function getContainer() {
          return context.container;
        }
      },
      children: children
    });
  }
  return /*#__PURE__*/(0,jsx_runtime.jsx)(jsx_runtime.Fragment, {});
}, function (prev, next) {
  return prev.context === next.context;
});
var DataContext = function DataContext(props) {
  var contextKey = props.contextKey,
    children = props.children;
  var dataContextManager = (0,es/* useInject */.oC)(DataContextManager);
  var ctx = dataContextManager.getContext((0,es/* getOrigin */.P$)(contextKey));
  return /*#__PURE__*/(0,jsx_runtime.jsx)(DataContextRender, {
    context: ctx,
    children: children
  });
};
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/context/index.js






var ContextModule = mana_module/* ManaModule */.R.create().contribution(DataContextContriburtion).register(DataContextManager, {
  token: DataContextSymbol,
  useDynamic: function useDynamic(ctx) {
    return ctx;
  }
});
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/deferred.js
var deferred = __webpack_require__(83743);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/platform.js
var platform = __webpack_require__(29586);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/keyboard-protocol.js
/* eslint-disable @typescript-eslint/no-redeclare */

var KeyboardLayoutProvider = Symbol('KeyboardLayoutProvider');
var KeyboardLayoutChangeNotifier = Symbol('KeyboardLayoutChangeNotifier');
var KeyValidator = Symbol('KeyValidator');
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/layouts/en-US-mac.js
var en_US_mac = __webpack_require__(38641);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/layouts/en-US-pc.js
var en_US_pc = __webpack_require__(91385);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/layouts/index.js


var layouts_en_US_mac = en_US_mac["default"];
var layouts_en_US_pc = en_US_pc["default"];
var layoutRawDataLoader = {
  'en-US-pc': function enUSPc() {
    return Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 91385));
  },
  'en-US-mac': function enUSMac() {
    return Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 38641));
  },
  'en-Dvorak-pc': function enDvorakPc() {
    return __webpack_require__.e(/* import() */ 391).then(__webpack_require__.bind(__webpack_require__, 15391));
  },
  'en-Dvorak-mac': function enDvorakMac() {
    return __webpack_require__.e(/* import() */ 512).then(__webpack_require__.bind(__webpack_require__, 29512));
  },
  'en-Dvorak_Lefthanded-pc': function enDvorak_LefthandedPc() {
    return __webpack_require__.e(/* import() */ 158).then(__webpack_require__.bind(__webpack_require__, 17158));
  },
  'en-Dvorak_Lefthanded-mac': function enDvorak_LefthandedMac() {
    return __webpack_require__.e(/* import() */ 154).then(__webpack_require__.bind(__webpack_require__, 46154));
  },
  'en-Dvorak_Righthanded-pc': function enDvorak_RighthandedPc() {
    return __webpack_require__.e(/* import() */ 663).then(__webpack_require__.bind(__webpack_require__, 90663));
  },
  'en-Dvorak_Righthanded-mac': function enDvorak_RighthandedMac() {
    return __webpack_require__.e(/* import() */ 182).then(__webpack_require__.bind(__webpack_require__, 36182));
  },
  'en-Colemak-mac': function enColemakMac() {
    return __webpack_require__.e(/* import() */ 414).then(__webpack_require__.bind(__webpack_require__, 57414));
  },
  'en-British-pc': function enBritishPc() {
    return __webpack_require__.e(/* import() */ 444).then(__webpack_require__.bind(__webpack_require__, 4444));
  },
  'en-British-mac': function enBritishMac() {
    return __webpack_require__.e(/* import() */ 215).then(__webpack_require__.bind(__webpack_require__, 59215));
  },
  'de-German-pc': function deGermanPc() {
    return __webpack_require__.e(/* import() */ 365).then(__webpack_require__.bind(__webpack_require__, 77365));
  },
  'de-German-mac': function deGermanMac() {
    return __webpack_require__.e(/* import() */ 432).then(__webpack_require__.bind(__webpack_require__, 15432));
  },
  'de-Swiss_German-pc': function deSwiss_GermanPc() {
    return __webpack_require__.e(/* import() */ 665).then(__webpack_require__.bind(__webpack_require__, 92665));
  },
  'de-Swiss_German-mac': function deSwiss_GermanMac() {
    return __webpack_require__.e(/* import() */ 473).then(__webpack_require__.bind(__webpack_require__, 78473));
  },
  'fr-French-pc': function frFrenchPc() {
    return __webpack_require__.e(/* import() */ 210).then(__webpack_require__.bind(__webpack_require__, 73210));
  },
  'fr-French-mac': function frFrenchMac() {
    return __webpack_require__.e(/* import() */ 723).then(__webpack_require__.bind(__webpack_require__, 27723));
  },
  'fr-Canadian_French-pc': function frCanadian_FrenchPc() {
    return __webpack_require__.e(/* import() */ 133).then(__webpack_require__.bind(__webpack_require__, 17133));
  },
  'fr-Canadian_French-mac': function frCanadian_FrenchMac() {
    return __webpack_require__.e(/* import() */ 986).then(__webpack_require__.bind(__webpack_require__, 64986));
  },
  'fr-Swiss_French-pc': function frSwiss_FrenchPc() {
    return __webpack_require__.e(/* import() */ 238).then(__webpack_require__.bind(__webpack_require__, 43238));
  },
  'fr-Swiss_French-mac': function frSwiss_FrenchMac() {
    return __webpack_require__.e(/* import() */ 525).then(__webpack_require__.bind(__webpack_require__, 75525));
  },
  'fr-Bepo-pc': function frBepoPc() {
    return __webpack_require__.e(/* import() */ 201).then(__webpack_require__.bind(__webpack_require__, 98201));
  },
  'pt-Portuguese-pc': function ptPortuguesePc() {
    return __webpack_require__.e(/* import() */ 519).then(__webpack_require__.bind(__webpack_require__, 48519));
  },
  'pt-Portuguese-mac': function ptPortugueseMac() {
    return __webpack_require__.e(/* import() */ 304).then(__webpack_require__.bind(__webpack_require__, 42304));
  },
  'pt-Brazilian-mac': function ptBrazilianMac() {
    return __webpack_require__.e(/* import() */ 266).then(__webpack_require__.bind(__webpack_require__, 66266));
  },
  'pl-Polish-pc': function plPolishPc() {
    return __webpack_require__.e(/* import() */ 981).then(__webpack_require__.bind(__webpack_require__, 25981));
  },
  'pl-Polish-mac': function plPolishMac() {
    return __webpack_require__.e(/* import() */ 994).then(__webpack_require__.bind(__webpack_require__, 98994));
  },
  'nl-Dutch-pc': function nlDutchPc() {
    return __webpack_require__.e(/* import() */ 825).then(__webpack_require__.bind(__webpack_require__, 44825));
  },
  'nl-Dutch-mac': function nlDutchMac() {
    return __webpack_require__.e(/* import() */ 341).then(__webpack_require__.bind(__webpack_require__, 9166));
  },
  'es-Spanish-pc': function esSpanishPc() {
    return __webpack_require__.e(/* import() */ 14).then(__webpack_require__.bind(__webpack_require__, 57014));
  },
  'es-Spanish-mac': function esSpanishMac() {
    return __webpack_require__.e(/* import() */ 350).then(__webpack_require__.bind(__webpack_require__, 40350));
  },
  'it-Italian-pc': function itItalianPc() {
    return __webpack_require__.e(/* import() */ 660).then(__webpack_require__.bind(__webpack_require__, 29660));
  },
  'it-Italian-mac': function itItalianMac() {
    return __webpack_require__.e(/* import() */ 584).then(__webpack_require__.bind(__webpack_require__, 69584));
  },
  'sv-Swedish-pc': function svSwedishPc() {
    return __webpack_require__.e(/* import() */ 818).then(__webpack_require__.bind(__webpack_require__, 26818));
  },
  'sv-Swedish-mac': function svSwedishMac() {
    return __webpack_require__.e(/* import() */ 697).then(__webpack_require__.bind(__webpack_require__, 89697));
  },
  'tr-Turkish_Q-pc': function trTurkish_QPc() {
    return __webpack_require__.e(/* import() */ 332).then(__webpack_require__.bind(__webpack_require__, 59332));
  },
  'tr-Turkish_Q-mac': function trTurkish_QMac() {
    return __webpack_require__.e(/* import() */ 308).then(__webpack_require__.bind(__webpack_require__, 62308));
  },
  'cs-Czech-pc': function csCzechPc() {
    return __webpack_require__.e(/* import() */ 631).then(__webpack_require__.bind(__webpack_require__, 48631));
  },
  'cs-Czech-mac': function csCzechMac() {
    return __webpack_require__.e(/* import() */ 396).then(__webpack_require__.bind(__webpack_require__, 49396));
  },
  'ro-Romanian-pc': function roRomanianPc() {
    return __webpack_require__.e(/* import() */ 439).then(__webpack_require__.bind(__webpack_require__, 37439));
  },
  'ro-Romanian-mac': function roRomanianMac() {
    return __webpack_require__.e(/* import() */ 402).then(__webpack_require__.bind(__webpack_require__, 35402));
  },
  'da-Danish-pc': function daDanishPc() {
    return __webpack_require__.e(/* import() */ 708).then(__webpack_require__.bind(__webpack_require__, 41708));
  },
  'da-Danish-mac': function daDanishMac() {
    return __webpack_require__.e(/* import() */ 142).then(__webpack_require__.bind(__webpack_require__, 37142));
  },
  'nb-Norwegian-pc': function nbNorwegianPc() {
    return __webpack_require__.e(/* import() */ 527).then(__webpack_require__.bind(__webpack_require__, 88527));
  },
  'nb-Norwegian-mac': function nbNorwegianMac() {
    return __webpack_require__.e(/* import() */ 728).then(__webpack_require__.bind(__webpack_require__, 49728));
  },
  'hu-Hungarian-pc': function huHungarianPc() {
    return __webpack_require__.e(/* import() */ 297).then(__webpack_require__.bind(__webpack_require__, 77297));
  },
  'hu-Hungarian-mac': function huHungarianMac() {
    return __webpack_require__.e(/* import() */ 654).then(__webpack_require__.bind(__webpack_require__, 39934));
  }
};
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/browser-keyboard-layout-provider.js
function browser_keyboard_layout_provider_typeof(o) { "@babel/helpers - typeof"; return browser_keyboard_layout_provider_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, browser_keyboard_layout_provider_typeof(o); }
var browser_keyboard_layout_provider_dec, browser_keyboard_layout_provider_dec2, browser_keyboard_layout_provider_dec3, browser_keyboard_layout_provider_class, browser_keyboard_layout_provider_class2, browser_keyboard_layout_provider_descriptor;
function browser_keyboard_layout_provider_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = browser_keyboard_layout_provider_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function browser_keyboard_layout_provider_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ browser_keyboard_layout_provider_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == browser_keyboard_layout_provider_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(browser_keyboard_layout_provider_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function browser_keyboard_layout_provider_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function browser_keyboard_layout_provider_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { browser_keyboard_layout_provider_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { browser_keyboard_layout_provider_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || browser_keyboard_layout_provider_unsupportedIterableToArray(arr, i) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function browser_keyboard_layout_provider_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return browser_keyboard_layout_provider_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return browser_keyboard_layout_provider_arrayLikeToArray(o, minLen); }
function browser_keyboard_layout_provider_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function browser_keyboard_layout_provider_initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function browser_keyboard_layout_provider_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function browser_keyboard_layout_provider_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, browser_keyboard_layout_provider_toPropertyKey(descriptor.key), descriptor); } }
function browser_keyboard_layout_provider_createClass(Constructor, protoProps, staticProps) { if (protoProps) browser_keyboard_layout_provider_defineProperties(Constructor.prototype, protoProps); if (staticProps) browser_keyboard_layout_provider_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function browser_keyboard_layout_provider_toPropertyKey(t) { var i = browser_keyboard_layout_provider_toPrimitive(t, "string"); return "symbol" == browser_keyboard_layout_provider_typeof(i) ? i : String(i); }
function browser_keyboard_layout_provider_toPrimitive(t, r) { if ("object" != browser_keyboard_layout_provider_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != browser_keyboard_layout_provider_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function browser_keyboard_layout_provider_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function browser_keyboard_layout_provider_initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }






var BrowserKeyboardLayoutProvider = (browser_keyboard_layout_provider_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: [KeyboardLayoutProvider, KeyboardLayoutChangeNotifier]
}), browser_keyboard_layout_provider_dec2 = (0,mana_syringe_es/* inject */.f3)(LocalStorageService), browser_keyboard_layout_provider_dec3 = (0,mana_syringe_es/* postConstruct */.zY)(), browser_keyboard_layout_provider_dec(browser_keyboard_layout_provider_class = (browser_keyboard_layout_provider_class2 = /*#__PURE__*/function () {
  function BrowserKeyboardLayoutProvider(storageService) {
    browser_keyboard_layout_provider_classCallCheck(this, BrowserKeyboardLayoutProvider);
    this.pendingLayoutMap = new Map();
    browser_keyboard_layout_provider_initializerDefineProperty(this, "storageService", browser_keyboard_layout_provider_descriptor, this);
    this.initialized = new deferred/* Deferred */.B();
    this.nativeLayoutChanged = new es_event/* Emitter */.Q5();
    this.source = 'pressed-keys';
    this.currentLayout = DEFAULT_LAYOUT_DATA;
    this.storageService = storageService;
    this.layoutDatas = [this.getLayoutData('en-US-pc', layouts_en_US_pc), this.getLayoutData('en-US-mac', layouts_en_US_mac)];
    this.tester = new KeyboardTester(this.layoutDatas);
  }
  BrowserKeyboardLayoutProvider = (0,mana_syringe_es/* inject */.f3)(LocalStorageService)(BrowserKeyboardLayoutProvider, undefined, 0) || BrowserKeyboardLayoutProvider;
  browser_keyboard_layout_provider_createClass(BrowserKeyboardLayoutProvider, [{
    key: "onDidChangeNativeLayout",
    get: function get() {
      return this.nativeLayoutChanged.event;
    }
  }, {
    key: "updateTester",
    value: function updateTester() {
      this.tester = new KeyboardTester(this.layoutDatas);
    }

    /**
     * Keyboard layout files are expected to have the following name scheme:
     *     `language-name-hardware.json`
     *
     * - `language`: A language subtag according to IETF BCP 47
     * - `name`:     Display name of the keyboard layout (without dashes)
     * - `hardware`: `pc` or `mac`
     */
  }, {
    key: "getLayoutData",
    value: function getLayoutData(layoutId, raw) {
      var _layoutId$split = layoutId.split('-'),
        _layoutId$split2 = _slicedToArray(_layoutId$split, 3),
        language = _layoutId$split2[0],
        name = _layoutId$split2[1],
        hardware = _layoutId$split2[2];
      return {
        name: name.replace('_', ' '),
        hardware: hardware,
        language: language,
        // Webpack knows what to do here and it should bundle all files under `../../../src/common/keyboard/layouts/`
        raw: raw
      };
    }
  }, {
    key: "loadLayout",
    value: function () {
      var _loadLayout = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee(layoutId) {
        var loader;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              loader = layoutRawDataLoader[layoutId];
              _context.t0 = this;
              _context.t1 = layoutId;
              _context.next = 5;
              return loader();
            case 5:
              _context.t2 = _context.sent;
              return _context.abrupt("return", _context.t0.getLayoutData.call(_context.t0, _context.t1, _context.t2));
            case 7:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function loadLayout(_x) {
        return _loadLayout.apply(this, arguments);
      }
      return loadLayout;
    }()
  }, {
    key: "addLayout",
    value: function () {
      var _addLayout = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee2(layoutId) {
        var layout;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              if (!this.layoutDatas.find(function (layout) {
                return getLayoutId(layout) === layoutId;
              })) {
                _context2.next = 2;
                break;
              }
              return _context2.abrupt("return");
            case 2:
              if (!this.pendingLayoutMap.has(layoutId)) {
                this.pendingLayoutMap.set(layoutId, this.loadLayout(layoutId));
              }
              _context2.next = 5;
              return this.pendingLayoutMap.get(layoutId);
            case 5:
              layout = _context2.sent;
              if (layout) {
                this.layoutDatas.push(layout);
                this.updateTester();
              }
            case 7:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function addLayout(_x2) {
        return _addLayout.apply(this, arguments);
      }
      return addLayout;
    }()
  }, {
    key: "allLayoutData",
    get: function get() {
      return this.tester.candidates.slice();
    }
  }, {
    key: "currentLayoutData",
    get: function get() {
      return this.currentLayout;
    }
  }, {
    key: "currentLayoutSource",
    get: function get() {
      return this.source;
    }
  }, {
    key: "initialize",
    value: function () {
      var _initialize = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee4() {
        var _this = this;
        var keyboard;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              // await this.loadState();
              keyboard = navigator.keyboard;
              if (keyboard && keyboard.addEventListener) {
                keyboard.addEventListener('layoutchange', /*#__PURE__*/browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee3() {
                  var newLayout;
                  return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee3$(_context3) {
                    while (1) switch (_context3.prev = _context3.next) {
                      case 0:
                        _context3.next = 2;
                        return _this.getNativeLayout();
                      case 2:
                        newLayout = _context3.sent;
                        _this.nativeLayoutChanged.fire(newLayout);
                      case 4:
                      case "end":
                        return _context3.stop();
                    }
                  }, _callee3);
                })));
              }
              this.initialized.resolve();
            case 3:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function initialize() {
        return _initialize.apply(this, arguments);
      }
      return initialize;
    }()
  }, {
    key: "getNativeLayout",
    value: function () {
      var _getNativeLayout = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee5() {
        var _yield$this$autodetec, _yield$this$autodetec2, layout, source;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              _context5.next = 2;
              return this.initialized.promise;
            case 2:
              if (!(this.source === 'user-choice')) {
                _context5.next = 4;
                break;
              }
              return _context5.abrupt("return", this.currentLayout.raw);
            case 4:
              _context5.next = 6;
              return this.autodetect();
            case 6:
              _yield$this$autodetec = _context5.sent;
              _yield$this$autodetec2 = _slicedToArray(_yield$this$autodetec, 2);
              layout = _yield$this$autodetec2[0];
              source = _yield$this$autodetec2[1];
              this.setCurrent(layout, source);
              return _context5.abrupt("return", layout.raw);
            case 12:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this);
      }));
      function getNativeLayout() {
        return _getNativeLayout.apply(this, arguments);
      }
      return getNativeLayout;
    }()
    /**
     * Set user-chosen keyboard layout data.
     */
  }, {
    key: "setLayoutData",
    value: (function () {
      var _setLayoutData = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee6(layout) {
        var _yield$this$autodetec3, _yield$this$autodetec4, newLayout, source;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee6$(_context6) {
          while (1) switch (_context6.prev = _context6.next) {
            case 0:
              if (!(layout === 'autodetect')) {
                _context6.next = 14;
                break;
              }
              if (!(this.source === 'user-choice')) {
                _context6.next = 11;
                break;
              }
              _context6.next = 4;
              return this.autodetect();
            case 4:
              _yield$this$autodetec3 = _context6.sent;
              _yield$this$autodetec4 = _slicedToArray(_yield$this$autodetec3, 2);
              newLayout = _yield$this$autodetec4[0];
              source = _yield$this$autodetec4[1];
              this.setCurrent(newLayout, source);
              this.nativeLayoutChanged.fire(newLayout.raw);
              return _context6.abrupt("return", newLayout);
            case 11:
              return _context6.abrupt("return", this.currentLayout);
            case 14:
              if (this.source !== 'user-choice' || layout !== this.currentLayout) {
                this.setCurrent(layout, 'user-choice');
                this.nativeLayoutChanged.fire(layout.raw);
              }
              return _context6.abrupt("return", layout);
            case 16:
            case "end":
              return _context6.stop();
          }
        }, _callee6, this);
      }));
      function setLayoutData(_x3) {
        return _setLayoutData.apply(this, arguments);
      }
      return setLayoutData;
    }()
    /**
     * Test all known keyboard layouts with the given combination of pressed key and
     * produced character. Matching layouts have their score increased (see class
     * KeyboardTester). If this leads to a change of the top-scoring layout, a layout
     * change event is fired.
     */
    )
  }, {
    key: "validateKey",
    value: function validateKey(keyCode) {
      if (this.source !== 'pressed-keys') {
        return;
      }
      var accepted = this.tester.updateScores(keyCode);
      if (!accepted) {
        return;
      }
      var layout = this.selectLayout();
      if (layout !== this.currentLayout && layout !== DEFAULT_LAYOUT_DATA) {
        this.setCurrent(layout, 'pressed-keys');
        this.nativeLayoutChanged.fire(layout.raw);
      }
    }
  }, {
    key: "setCurrent",
    value: function setCurrent(layout, source) {
      this.currentLayout = layout;
      this.source = source;
      // this.saveState();
      if (this.tester.inputCount && (source === 'pressed-keys' || source === 'navigator.keyboard')) {
        var from = source === 'pressed-keys' ? 'pressed keys' : 'browser API';
        var hardware = layout.hardware === 'mac' ? 'Mac' : 'PC';
        console.warn("Detected keyboard layout from ".concat(from, ": ").concat(layout.name, " (").concat(hardware, ")"));
      }
    }
  }, {
    key: "autodetect",
    value: function () {
      var _autodetect = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee7() {
        var keyboard, layoutMap;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee7$(_context7) {
          while (1) switch (_context7.prev = _context7.next) {
            case 0:
              keyboard = navigator.keyboard;
              if (!(keyboard && keyboard.getLayoutMap)) {
                _context7.next = 13;
                break;
              }
              _context7.prev = 2;
              _context7.next = 5;
              return keyboard.getLayoutMap();
            case 5:
              layoutMap = _context7.sent;
              this.testLayoutMap(layoutMap);
              return _context7.abrupt("return", [this.selectLayout(), 'navigator.keyboard']);
            case 10:
              _context7.prev = 10;
              _context7.t0 = _context7["catch"](2);
              console.warn('Failed to obtain keyboard layout map.', _context7.t0);
            case 13:
              return _context7.abrupt("return", [this.selectLayout(), 'pressed-keys']);
            case 14:
            case "end":
              return _context7.stop();
          }
        }, _callee7, this, [[2, 10]]);
      }));
      function autodetect() {
        return _autodetect.apply(this, arguments);
      }
      return autodetect;
    }()
    /**
     * @param layoutMap a keyboard layout map according to https://wicg.github.io/keyboard-map/
     */
  }, {
    key: "testLayoutMap",
    value: function testLayoutMap(layoutMap) {
      this.tester.reset();
      var _iterator = browser_keyboard_layout_provider_createForOfIteratorHelper(layoutMap.entries()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = _slicedToArray(_step.value, 2),
            code = _step$value[0],
            key = _step$value[1];
          this.tester.updateScores({
            code: code,
            character: key
          });
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Select a layout based on the current tester state and the operating system
     * and language detected from the browser.
     */
  }, {
    key: "selectLayout",
    value: function selectLayout() {
      var candidates = this.tester.candidates;
      var scores = this.tester.scores;
      var topScore = this.tester.topScore;
      var language = navigator.language;
      var matchingOScount = 0;
      var topScoringCount = 0;
      for (var i = 0; i < candidates.length; i++) {
        if (scores[i] === topScore) {
          var candidate = candidates[i];
          if (osMatches(candidate.hardware)) {
            if (language && language.startsWith(candidate.language)) {
              return candidate;
            }
            matchingOScount++;
          }
          topScoringCount++;
        }
      }
      if (matchingOScount >= 1) {
        return candidates.find(function (c, i) {
          return scores[i] === topScore && osMatches(c.hardware);
        });
      }
      if (topScoringCount >= 1) {
        return candidates.find(function (_, i) {
          return scores[i] === topScore;
        });
      }
      return DEFAULT_LAYOUT_DATA;
    }
  }, {
    key: "saveState",
    value: function () {
      var _saveState = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee8() {
        var data;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee8$(_context8) {
          while (1) switch (_context8.prev = _context8.next) {
            case 0:
              data = {
                tester: this.tester.getState(),
                source: this.source,
                currentLayout: this.currentLayout !== DEFAULT_LAYOUT_DATA ? getLayoutId(this.currentLayout) : undefined
              };
              return _context8.abrupt("return", this.storageService.setData('keyboard', data));
            case 2:
            case "end":
              return _context8.stop();
          }
        }, _callee8, this);
      }));
      function saveState() {
        return _saveState.apply(this, arguments);
      }
      return saveState;
    }()
  }, {
    key: "loadState",
    value: function () {
      var _loadState = browser_keyboard_layout_provider_asyncToGenerator( /*#__PURE__*/browser_keyboard_layout_provider_regeneratorRuntime().mark(function _callee9() {
        var data, layout;
        return browser_keyboard_layout_provider_regeneratorRuntime().wrap(function _callee9$(_context9) {
          while (1) switch (_context9.prev = _context9.next) {
            case 0:
              _context9.next = 2;
              return this.storageService.getData('keyboard');
            case 2:
              data = _context9.sent;
              if (data) {
                this.tester.setState(data.tester || {});
                this.source = data.source || 'pressed-keys';
                if (data.currentLayout) {
                  layout = this.tester.candidates.find(function (c) {
                    return getLayoutId(c) === data.currentLayout;
                  });
                  if (layout) {
                    this.currentLayout = layout;
                  }
                } else {
                  this.currentLayout = DEFAULT_LAYOUT_DATA;
                }
              }
            case 4:
            case "end":
              return _context9.stop();
          }
        }, _callee9, this);
      }));
      function loadState() {
        return _loadState.apply(this, arguments);
      }
      return loadState;
    }()
  }]);
  return BrowserKeyboardLayoutProvider;
}(), (browser_keyboard_layout_provider_descriptor = browser_keyboard_layout_provider_applyDecoratedDescriptor(browser_keyboard_layout_provider_class2.prototype, "storageService", [browser_keyboard_layout_provider_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), browser_keyboard_layout_provider_applyDecoratedDescriptor(browser_keyboard_layout_provider_class2.prototype, "initialize", [browser_keyboard_layout_provider_dec3], Object.getOwnPropertyDescriptor(browser_keyboard_layout_provider_class2.prototype, "initialize"), browser_keyboard_layout_provider_class2.prototype)), browser_keyboard_layout_provider_class2)) || browser_keyboard_layout_provider_class);
function osMatches(hardware) {
  return platform/* isOSX */.id ? hardware === 'mac' : hardware === 'pc';
}

/**
 * This is the fallback keyboard layout selected when nothing else matches.
 * It has an empty mapping, so user inputs are handled like with a standard US keyboard.
 */
var DEFAULT_LAYOUT_DATA = {
  name: 'US',
  hardware: platform/* isOSX */.id ? 'mac' : 'pc',
  language: 'en',
  raw: {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    info: {},
    mapping: {}
  }
};
/**
 * Holds score values for all known keyboard layouts. Scores are updated
 * by comparing key codes with the corresponding character produced by
 * the user's keyboard.
 */
var KeyboardTester = /*#__PURE__*/function () {
  function KeyboardTester(candidates) {
    browser_keyboard_layout_provider_classCallCheck(this, KeyboardTester);
    this.topScore = 0;
    this.testedInputs = new Map();
    this.candidates = candidates;
    this.scores = this.candidates.map(function () {
      return 0;
    });
  }
  browser_keyboard_layout_provider_createClass(KeyboardTester, [{
    key: "inputCount",
    get: function get() {
      return this.testedInputs.size;
    }
  }, {
    key: "reset",
    value: function reset() {
      for (var i = 0; i < this.scores.length; i++) {
        this.scores[i] = 0;
      }
      this.topScore = 0;
      this.testedInputs.clear();
    }
  }, {
    key: "updateScores",
    value: function updateScores(input) {
      var property;
      if (input.shiftKey && input.altKey) {
        property = 'withShiftAltGr';
      } else if (input.shiftKey) {
        property = 'withShift';
      } else if (input.altKey) {
        property = 'withAltGr';
      } else {
        property = 'value';
      }
      var inputKey = "".concat(input.code, ".").concat(property);
      if (this.testedInputs.has(inputKey)) {
        if (this.testedInputs.get(inputKey) === input.character) {
          return false;
        } else {
          // The same input keystroke leads to a different character:
          // probably a keyboard layout change, so forget all previous scores
          this.reset();
        }
      }
      var scores = this.scores;
      for (var i = 0; i < this.candidates.length; i++) {
        scores[i] += this.testCandidate(this.candidates[i], input, property);
        if (scores[i] > this.topScore) {
          this.topScore = scores[i];
        }
      }
      this.testedInputs.set(inputKey, input.character);
      return true;
    }
  }, {
    key: "testCandidate",
    value: function testCandidate(candidate, input, property) {
      var keyMapping = candidate.raw.mapping[input.code];
      if (keyMapping && keyMapping[property]) {
        return keyMapping[property] === input.character ? 1 : 0;
      } else {
        return 0;
      }
    }
  }, {
    key: "getState",
    value: function getState() {
      var scores = {};
      for (var i = 0; i < this.scores.length; i++) {
        scores[getLayoutId(this.candidates[i])] = this.scores[i];
      }
      var testedInputs = {};
      var _iterator2 = browser_keyboard_layout_provider_createForOfIteratorHelper(this.testedInputs.entries()),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _step2$value = _slicedToArray(_step2.value, 2),
            key = _step2$value[0],
            character = _step2$value[1];
          testedInputs[key] = character;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return {
        scores: scores,
        topScore: this.topScore,
        testedInputs: testedInputs
      };
    }
  }, {
    key: "setState",
    value: function setState(state) {
      this.reset();
      if (state.scores) {
        var layoutIds = this.candidates.map(getLayoutId);
        for (var id in state.scores) {
          if (Object.prototype.hasOwnProperty.call(state.scores, id)) {
            var index = layoutIds.indexOf(id);
            if (index > 0) {
              this.scores[index] = state.scores[id];
            }
          }
        }
      }
      if (state.topScore) {
        this.topScore = state.topScore;
      }
      if (state.testedInputs) {
        for (var key in state.testedInputs) {
          if (Object.prototype.hasOwnProperty.call(state.testedInputs, key)) {
            this.testedInputs.set(key, state.testedInputs[key]);
          }
        }
      }
    }
  }]);
  return KeyboardTester;
}();

/**
 * API specified by https://wicg.github.io/keyboard-map/
 */

function getLayoutId(layout) {
  return "".concat(layout.language, "-").concat(layout.name.replace(' ', '_'), "-").concat(layout.hardware);
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/keys.js
function keys_typeof(o) { "@babel/helpers - typeof"; return keys_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, keys_typeof(o); }
function keys_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = keys_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function keys_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return keys_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return keys_arrayLikeToArray(o, minLen); }
function keys_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function keys_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function keys_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, keys_toPropertyKey(descriptor.key), descriptor); } }
function keys_createClass(Constructor, protoProps, staticProps) { if (protoProps) keys_defineProperties(Constructor.prototype, protoProps); if (staticProps) keys_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function keys_toPropertyKey(t) { var i = keys_toPrimitive(t, "string"); return "symbol" == keys_typeof(i) ? i : String(i); }
function keys_toPrimitive(t, r) { if ("object" != keys_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != keys_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable @typescript-eslint/no-use-before-define */
/* eslint-disable no-restricted-syntax */
/* eslint-disable no-plusplus */
/* eslint-disable @typescript-eslint/no-redeclare */

var KeySequence;
(function (_KeySequence) {
  function equals(a, b) {
    if (a.length !== b.length) {
      return false;
    }
    for (var i = 0; i < a.length; i++) {
      if (!a[i].equals(b[i])) {
        return false;
      }
    }
    return true;
  }
  _KeySequence.equals = equals;
  var CompareResult = /*#__PURE__*/function (CompareResult) {
    CompareResult[CompareResult["NONE"] = 0] = "NONE";
    CompareResult[CompareResult["PARTIAL"] = 1] = "PARTIAL";
    CompareResult[CompareResult["SHADOW"] = 2] = "SHADOW";
    CompareResult[CompareResult["FULL"] = 3] = "FULL";
    return CompareResult;
  }({});
  _KeySequence.CompareResult = CompareResult;
  function compare(a, b) {
    var first = a;
    var second = b;
    var shadow = false;
    if (b.length < a.length) {
      first = b;
      second = a;
      shadow = true;
    }
    for (var i = 0; i < first.length; i++) {
      if (first[i].equals(second[i]) === false) {
        return KeySequence.CompareResult.NONE;
      }
    }
    if (first.length < second.length) {
      if (shadow === false) {
        return KeySequence.CompareResult.PARTIAL;
      }
      return KeySequence.CompareResult.SHADOW;
    }
    return KeySequence.CompareResult.FULL;
  }
  _KeySequence.compare = compare;
  function parse(keybinding) {
    var keyCodes = [];
    var rawKeyCodes = keybinding.trim().split(/\s+/g);
    var _iterator2 = keys_createForOfIteratorHelper(rawKeyCodes),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var rawKeyCode = _step2.value;
        var _keyCode = KeyCode.parse(rawKeyCode);
        if (_keyCode !== undefined) {
          keyCodes.push(_keyCode);
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
    return keyCodes;
  }
  _KeySequence.parse = parse;
})(KeySequence || (KeySequence = {}));
/**
 * The key sequence for this binding. This key sequence should consist of one or more key strokes. Key strokes
 * consist of one or more keys held down at the same time. This should be zero or more modifier keys, and zero or one other key.
 * Since `M2+M3+<Key>` (Alt+Shift+<Key>) is reserved on MacOS X for writing special characters, such bindings are commonly
 * undefined for platform MacOS X and redefined as `M1+M3+<Key>`. The rule applies on the `M3+M2+<Key>` sequence.
 */
/**
 * Representation of a pressed key combined with key modifiers.
 */
var KeyCode = /*#__PURE__*/function () {
  function KeyCode(schema) {
    keys_classCallCheck(this, KeyCode);
    var key = schema.key;
    if (key) {
      if (key.code && key.keyCode && key.easyString) {
        this.key = key;
      } else if (key.code) {
        this.key = Key.getKey(key.code);
      } else if (key.keyCode) {
        this.key = Key.getKey(key.keyCode);
      }
    }
    this.ctrl = !!schema.ctrl;
    this.shift = !!schema.shift;
    this.alt = !!schema.alt;
    this.meta = !!schema.meta;
    this.character = schema.character;
  }

  /**
   * Return true if this KeyCode only contains modifiers.
   */
  keys_createClass(KeyCode, [{
    key: "isModifierOnly",
    value: function isModifierOnly() {
      return this.key === undefined;
    }

    /**
     * Return true if the given KeyCode is equal to this one.
     */
  }, {
    key: "equals",
    value: function equals(other) {
      if (this.key && (!other.key || this.key.code !== other.key.code) || !this.key && other.key) {
        return false;
      }
      return this.ctrl === other.ctrl && this.alt === other.alt && this.shift === other.shift && this.meta === other.meta;
    }

    /*
     * Return a keybinding string compatible with the `Keybinding.keybinding` property.
     */
  }, {
    key: "toString",
    value: function toString() {
      var result = [];
      if (this.meta) {
        result.push(SpecialCases.META);
      }
      if (this.shift) {
        result.push(Key.SHIFT_LEFT.easyString);
      }
      if (this.alt) {
        result.push(Key.ALT_LEFT.easyString);
      }
      if (this.ctrl) {
        result.push(Key.CONTROL_LEFT.easyString);
      }
      if (this.key) {
        result.push(this.key.easyString);
      }
      return result.join('+');
    }

    /**
     * Create a KeyCode from one of several input types.
     */
  }], [{
    key: "createKeyCode",
    value: function createKeyCode(input) {
      var eventDispatch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'code';
      if (typeof input === 'string') {
        var parts = input.split('+');
        if (!KeyCode.isModifierString(parts[0])) {
          return KeyCode.createKeyCode({
            first: Key.getKey(parts[0]),
            modifiers: parts.slice(1)
          });
        }
        return KeyCode.createKeyCode({
          modifiers: parts
        });
      }
      if (KeyCode.isKeyboardEvent(input)) {
        var key = KeyCode.toKey(input, eventDispatch);
        return new KeyCode({
          key: Key.isModifier(key.code) ? undefined : key,
          meta: platform/* isOSX */.id && input.metaKey,
          shift: input.shiftKey,
          alt: input.altKey,
          ctrl: input.ctrlKey,
          character: KeyCode.toCharacter(input)
        });
      }
      if (input.first || input.modifiers) {
        var keystroke = input;
        var schema = {
          key: keystroke.first
        };
        if (keystroke.modifiers) {
          if (platform/* isOSX */.id) {
            schema.meta = keystroke.modifiers.some(function (mod) {
              return mod === KeyModifier.CtrlCmd;
            });
            schema.ctrl = keystroke.modifiers.some(function (mod) {
              return mod === KeyModifier.MacCtrl;
            });
          } else {
            schema.meta = false;
            schema.ctrl = keystroke.modifiers.some(function (mod) {
              return mod === KeyModifier.CtrlCmd;
            });
          }
          schema.shift = keystroke.modifiers.some(function (mod) {
            return mod === KeyModifier.Shift;
          });
          schema.alt = keystroke.modifiers.some(function (mod) {
            return mod === KeyModifier.Alt;
          });
        }
        return new KeyCode(schema);
      }
      return new KeyCode(input);
    }
  }, {
    key: "resetKeyBindings",
    value: /* Reset the key hashmap, this is for testing purposes.  */
    function resetKeyBindings() {
      KeyCode.keybindings = {};
    }

    /**
     * Parses a string and returns a KeyCode object.
     * @param keybinding String representation of a keybinding
     */
  }, {
    key: "parse",
    value: function parse(keybinding) {
      if (KeyCode.keybindings[keybinding]) {
        return KeyCode.keybindings[keybinding];
      }
      var schema = {};
      var keys = [];
      var currentKey = '';
      var _iterator = keys_createForOfIteratorHelper(keybinding.trim().toLowerCase()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var character = _step.value;
          if (currentKey && (character === '-' || character === '+')) {
            keys.push(currentKey);
            currentKey = '';
          } else if (character !== '+') {
            currentKey += character;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      if (currentKey) {
        keys.push(currentKey);
      }
      /* If duplicates i.e ctrl+ctrl+a or alt+alt+b or b+alt+b it is invalid */
      if (keys.length !== new Set(keys).size) {
        throw new Error("Can't parse keybinding ".concat(keybinding, " Duplicate modifiers"));
      }
      for (var _i = 0, _keys = keys; _i < _keys.length; _i++) {
        var keyString = _keys[_i];
        if (SPECIAL_ALIASES[keyString] !== undefined) {
          keyString = SPECIAL_ALIASES[keyString];
        }
        var key = EASY_TO_KEY[keyString];

        /* meta only works on macOS */
        if (keyString === SpecialCases.META) {
          if (platform/* isOSX */.id) {
            schema.meta = true;
          } else {
            throw new Error("Can't parse keybinding ".concat(keybinding, " meta is for OSX only"));
          }
          /* ctrlcmd for M1 keybindings that work on both macOS and other platforms */
        } else if (keyString === SpecialCases.CTRLCMD) {
          if (platform/* isOSX */.id) {
            schema.meta = true;
          } else {
            schema.ctrl = true;
          }
        } else if (Key.isKey(key)) {
          if (Key.isModifier(key.code)) {
            if (key.code === Key.CONTROL_LEFT.code || key.code === Key.CONTROL_RIGHT.code) {
              schema.ctrl = true;
            } else if (key.code === Key.SHIFT_LEFT.code || key.code === Key.SHIFT_RIGHT.code) {
              schema.shift = true;
            } else if (key.code === Key.ALT_LEFT.code || key.code === Key.ALT_RIGHT.code) {
              schema.alt = true;
            }
          } else {
            schema.key = key;
          }
        } else {
          throw new Error("Unrecognized key '".concat(keyString, "' in '").concat(keybinding, "'"));
        }
      }
      KeyCode.keybindings[keybinding] = new KeyCode(schema);
      return KeyCode.keybindings[keybinding];
    }
  }]);
  return KeyCode;
}();
KeyCode.keybindings = {};
(function (_KeyCode2) {
  /**
   * Determines a `true` of `false` value for the key code argument.
   */

  /*
   * Return true if the string is a modifier M1 to M4.
   */
  function isModifierString(key) {
    return key === KeyModifier.CtrlCmd || key === KeyModifier.Shift || key === KeyModifier.Alt || key === KeyModifier.MacCtrl;
  }
  _KeyCode2.isModifierString = isModifierString;
  function isKeyboardEvent(event) {
    if (typeof KeyboardEvent === 'undefined') {
      // This can happen in tests
      return false;
    }
    if (event instanceof KeyboardEvent) {
      return true;
    }
    var type = event.type;
    if (type) {
      return type === 'keypress' || type === 'keydown' || type === 'keyup';
    }
    return false;
  }
  _KeyCode2.isKeyboardEvent = isKeyboardEvent;
  function toKey(event) {
    var dispatch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'code';
    var code = event.code;
    if (code && dispatch === 'code') {
      if (platform/* isOSX */.id) {
        // https://github.com/eclipse-mana/mana/issues/4986
        var char = event.key;
        if (code === 'IntlBackslash' && (char === '`' || char === '~')) {
          return Key.BACKQUOTE;
        }
        if (code === 'Backquote' && (char === '§' || char === '±')) {
          return Key.INTL_BACKSLASH;
        }
      }

      // https://github.com/eclipse-mana/mana/issues/7315
      if (code.startsWith('Numpad') && event.key && event.key.length > 1) {
        var k = Key.getKey(event.key);
        if (k) {
          return k;
        }
      }
      var key = Key.getKey(code);
      if (key) {
        return key;
      }
    }

    // tslint:disable-next-line: deprecation
    var keyCode = event.keyCode;
    if (keyCode) {
      var _key = Key.getKey(keyCode);
      if (_key) {
        return _key;
      }
    }
    var _ref = event,
      keyIdentifier = _ref.keyIdentifier;
    if (keyIdentifier) {
      var _key2 = Key.getKey(keyIdentifier);
      if (_key2) {
        return _key2;
      }
    }
    throw new Error("Cannot get key code from the keyboard event: ".concat(event, "."));
  }
  _KeyCode2.toKey = toKey;
  function toCharacter(event) {
    var key = event.key;
    // Use the key property if it contains exactly one unicode character
    if (key && Array.from(key).length === 1) {
      return key;
    }
    var charCode = event.charCode;
    // Use the charCode property if it does not correspond to a unicode control character
    if (charCode && charCode > 0x1f && !(charCode >= 0x80 && charCode <= 0x9f)) {
      return String.fromCharCode(charCode);
    }
    return undefined;
  }
  _KeyCode2.toCharacter = toCharacter;
})(KeyCode || (KeyCode = {}));
var KeyModifier = /*#__PURE__*/function (KeyModifier) {
  KeyModifier["CtrlCmd"] = "M1";
  KeyModifier["Shift"] = "M2";
  KeyModifier["Alt"] = "M3";
  KeyModifier["MacCtrl"] = "M4";
  return KeyModifier;
}({});
(function (_KeyModifier) {
  var CTRL = _KeyModifier.CTRL = platform/* isOSX */.id ? KeyModifier.MacCtrl : KeyModifier.CtrlCmd;
  var SHIFT = _KeyModifier.SHIFT = KeyModifier.Shift;
  function isModifier(key) {
    if (key) {
      switch (key) {
        case 'M1': // Fall through.
        case 'M2': // Fall through.
        case 'M3': // Fall through.
        case 'M4':
          return true;
        default:
          return false;
      }
    }
    return false;
  }
  _KeyModifier.isModifier = isModifier;
})(KeyModifier || (KeyModifier = {}));
var CODE_TO_KEY = {};
var KEY_CODE_TO_KEY = {};
var EASY_TO_KEY = {}; // From 'ctrl' to Key structure
var MODIFIERS = [];
var SPECIAL_ALIASES = {
  option: 'alt',
  command: 'meta',
  cmd: 'meta',
  return: 'enter',
  esc: 'escape',
  mod: 'ctrl',
  ins: 'insert',
  del: 'delete',
  control: 'ctrl'
};
var SpecialCases;
(function (_SpecialCases) {
  var META = _SpecialCases.META = 'meta';
  var CTRLCMD = _SpecialCases.CTRLCMD = 'ctrlcmd';
})(SpecialCases || (SpecialCases = {}));
var Key;
(function (_Key) {
  function isKey(arg) {
    return keys_typeof(arg) === 'object' && 'code' in arg && 'keyCode' in arg;
  }
  _Key.isKey = isKey;
  function getKey(arg) {
    if (typeof arg === 'number') {
      return KEY_CODE_TO_KEY[arg];
    }
    return CODE_TO_KEY[arg];
  }
  _Key.getKey = getKey;
  function isModifier(arg) {
    if (typeof arg === 'number') {
      return MODIFIERS.find(function (key) {
        return key.keyCode === arg;
      }) !== undefined;
    }
    return MODIFIERS.find(function (key) {
      return key.code === arg;
    }) !== undefined;
  }
  _Key.isModifier = isModifier;
  function equals(key, keyCode) {
    return !!keyCode.key && key.keyCode === keyCode.key.keyCode;
  }
  _Key.equals = equals;
  var BACKSPACE = _Key.BACKSPACE = {
    code: 'Backspace',
    keyCode: 8,
    easyString: 'backspace'
  };
  var TAB = _Key.TAB = {
    code: 'Tab',
    keyCode: 9,
    easyString: 'tab'
  };
  var ENTER = _Key.ENTER = {
    code: 'Enter',
    keyCode: 13,
    easyString: 'enter'
  };
  var ESCAPE = _Key.ESCAPE = {
    code: 'Escape',
    keyCode: 27,
    easyString: 'escape'
  };
  var SPACE = _Key.SPACE = {
    code: 'Space',
    keyCode: 32,
    easyString: 'space'
  };
  var PAGE_UP = _Key.PAGE_UP = {
    code: 'PageUp',
    keyCode: 33,
    easyString: 'pageup'
  };
  var PAGE_DOWN = _Key.PAGE_DOWN = {
    code: 'PageDown',
    keyCode: 34,
    easyString: 'pagedown'
  };
  var END = _Key.END = {
    code: 'End',
    keyCode: 35,
    easyString: 'end'
  };
  var HOME = _Key.HOME = {
    code: 'Home',
    keyCode: 36,
    easyString: 'home'
  };
  var ARROW_LEFT = _Key.ARROW_LEFT = {
    code: 'ArrowLeft',
    keyCode: 37,
    easyString: 'left'
  };
  var ARROW_UP = _Key.ARROW_UP = {
    code: 'ArrowUp',
    keyCode: 38,
    easyString: 'up'
  };
  var ARROW_RIGHT = _Key.ARROW_RIGHT = {
    code: 'ArrowRight',
    keyCode: 39,
    easyString: 'right'
  };
  var ARROW_DOWN = _Key.ARROW_DOWN = {
    code: 'ArrowDown',
    keyCode: 40,
    easyString: 'down'
  };
  var INSERT = _Key.INSERT = {
    code: 'Insert',
    keyCode: 45,
    easyString: 'insert'
  };
  var DELETE = _Key.DELETE = {
    code: 'Delete',
    keyCode: 46,
    easyString: 'delete'
  };
  var SHIFT_LEFT = _Key.SHIFT_LEFT = {
    code: 'ShiftLeft',
    keyCode: 16,
    easyString: 'shift'
  };
  var SHIFT_RIGHT = _Key.SHIFT_RIGHT = {
    code: 'ShiftRight',
    keyCode: 16,
    easyString: 'shift'
  };
  var CONTROL_LEFT = _Key.CONTROL_LEFT = {
    code: 'ControlLeft',
    keyCode: 17,
    easyString: 'ctrl'
  };
  var CONTROL_RIGHT = _Key.CONTROL_RIGHT = {
    code: 'ControlRight',
    keyCode: 17,
    easyString: 'ctrl'
  };
  var ALT_LEFT = _Key.ALT_LEFT = {
    code: 'AltLeft',
    keyCode: 18,
    easyString: 'alt'
  };
  var ALT_RIGHT = _Key.ALT_RIGHT = {
    code: 'AltRight',
    keyCode: 18,
    easyString: 'alt'
  };
  var CAPS_LOCK = _Key.CAPS_LOCK = {
    code: 'CapsLock',
    keyCode: 20,
    easyString: 'capslock'
  };
  var OS_LEFT = _Key.OS_LEFT = {
    code: 'OSLeft',
    keyCode: 91,
    easyString: 'super'
  };
  var OS_RIGHT = _Key.OS_RIGHT = {
    code: 'OSRight',
    keyCode: 92,
    easyString: 'super'
  };
  var DIGIT0 = _Key.DIGIT0 = {
    code: 'Digit0',
    keyCode: 48,
    easyString: '0'
  };
  var DIGIT1 = _Key.DIGIT1 = {
    code: 'Digit1',
    keyCode: 49,
    easyString: '1'
  };
  var DIGIT2 = _Key.DIGIT2 = {
    code: 'Digit2',
    keyCode: 50,
    easyString: '2'
  };
  var DIGIT3 = _Key.DIGIT3 = {
    code: 'Digit3',
    keyCode: 51,
    easyString: '3'
  };
  var DIGIT4 = _Key.DIGIT4 = {
    code: 'Digit4',
    keyCode: 52,
    easyString: '4'
  };
  var DIGIT5 = _Key.DIGIT5 = {
    code: 'Digit5',
    keyCode: 53,
    easyString: '5'
  };
  var DIGIT6 = _Key.DIGIT6 = {
    code: 'Digit6',
    keyCode: 54,
    easyString: '6'
  };
  var DIGIT7 = _Key.DIGIT7 = {
    code: 'Digit7',
    keyCode: 55,
    easyString: '7'
  };
  var DIGIT8 = _Key.DIGIT8 = {
    code: 'Digit8',
    keyCode: 56,
    easyString: '8'
  };
  var DIGIT9 = _Key.DIGIT9 = {
    code: 'Digit9',
    keyCode: 57,
    easyString: '9'
  };
  var KEY_A = _Key.KEY_A = {
    code: 'KeyA',
    keyCode: 65,
    easyString: 'a'
  };
  var KEY_B = _Key.KEY_B = {
    code: 'KeyB',
    keyCode: 66,
    easyString: 'b'
  };
  var KEY_C = _Key.KEY_C = {
    code: 'KeyC',
    keyCode: 67,
    easyString: 'c'
  };
  var KEY_D = _Key.KEY_D = {
    code: 'KeyD',
    keyCode: 68,
    easyString: 'd'
  };
  var KEY_E = _Key.KEY_E = {
    code: 'KeyE',
    keyCode: 69,
    easyString: 'e'
  };
  var KEY_F = _Key.KEY_F = {
    code: 'KeyF',
    keyCode: 70,
    easyString: 'f'
  };
  var KEY_G = _Key.KEY_G = {
    code: 'KeyG',
    keyCode: 71,
    easyString: 'g'
  };
  var KEY_H = _Key.KEY_H = {
    code: 'KeyH',
    keyCode: 72,
    easyString: 'h'
  };
  var KEY_I = _Key.KEY_I = {
    code: 'KeyI',
    keyCode: 73,
    easyString: 'i'
  };
  var KEY_J = _Key.KEY_J = {
    code: 'KeyJ',
    keyCode: 74,
    easyString: 'j'
  };
  var KEY_K = _Key.KEY_K = {
    code: 'KeyK',
    keyCode: 75,
    easyString: 'k'
  };
  var KEY_L = _Key.KEY_L = {
    code: 'KeyL',
    keyCode: 76,
    easyString: 'l'
  };
  var KEY_M = _Key.KEY_M = {
    code: 'KeyM',
    keyCode: 77,
    easyString: 'm'
  };
  var KEY_N = _Key.KEY_N = {
    code: 'KeyN',
    keyCode: 78,
    easyString: 'n'
  };
  var KEY_O = _Key.KEY_O = {
    code: 'KeyO',
    keyCode: 79,
    easyString: 'o'
  };
  var KEY_P = _Key.KEY_P = {
    code: 'KeyP',
    keyCode: 80,
    easyString: 'p'
  };
  var KEY_Q = _Key.KEY_Q = {
    code: 'KeyQ',
    keyCode: 81,
    easyString: 'q'
  };
  var KEY_R = _Key.KEY_R = {
    code: 'KeyR',
    keyCode: 82,
    easyString: 'r'
  };
  var KEY_S = _Key.KEY_S = {
    code: 'KeyS',
    keyCode: 83,
    easyString: 's'
  };
  var KEY_T = _Key.KEY_T = {
    code: 'KeyT',
    keyCode: 84,
    easyString: 't'
  };
  var KEY_U = _Key.KEY_U = {
    code: 'KeyU',
    keyCode: 85,
    easyString: 'u'
  };
  var KEY_V = _Key.KEY_V = {
    code: 'KeyV',
    keyCode: 86,
    easyString: 'v'
  };
  var KEY_W = _Key.KEY_W = {
    code: 'KeyW',
    keyCode: 87,
    easyString: 'w'
  };
  var KEY_X = _Key.KEY_X = {
    code: 'KeyX',
    keyCode: 88,
    easyString: 'x'
  };
  var KEY_Y = _Key.KEY_Y = {
    code: 'KeyY',
    keyCode: 89,
    easyString: 'y'
  };
  var KEY_Z = _Key.KEY_Z = {
    code: 'KeyZ',
    keyCode: 90,
    easyString: 'z'
  };
  var MULTIPLY = _Key.MULTIPLY = {
    code: 'NumpadMultiply',
    keyCode: 106,
    easyString: 'multiply'
  };
  var ADD = _Key.ADD = {
    code: 'NumpadAdd',
    keyCode: 107,
    easyString: 'add'
  };
  var DECIMAL = _Key.DECIMAL = {
    code: 'NumpadDecimal',
    keyCode: 108,
    easyString: 'decimal'
  };
  var SUBTRACT = _Key.SUBTRACT = {
    code: 'NumpadSubtract',
    keyCode: 109,
    easyString: 'subtract'
  };
  var DIVIDE = _Key.DIVIDE = {
    code: 'NumpadDivide',
    keyCode: 111,
    easyString: 'divide'
  };
  var F1 = _Key.F1 = {
    code: 'F1',
    keyCode: 112,
    easyString: 'f1'
  };
  var F2 = _Key.F2 = {
    code: 'F2',
    keyCode: 113,
    easyString: 'f2'
  };
  var F3 = _Key.F3 = {
    code: 'F3',
    keyCode: 114,
    easyString: 'f3'
  };
  var F4 = _Key.F4 = {
    code: 'F4',
    keyCode: 115,
    easyString: 'f4'
  };
  var F5 = _Key.F5 = {
    code: 'F5',
    keyCode: 116,
    easyString: 'f5'
  };
  var F6 = _Key.F6 = {
    code: 'F6',
    keyCode: 117,
    easyString: 'f6'
  };
  var F7 = _Key.F7 = {
    code: 'F7',
    keyCode: 118,
    easyString: 'f7'
  };
  var F8 = _Key.F8 = {
    code: 'F8',
    keyCode: 119,
    easyString: 'f8'
  };
  var F9 = _Key.F9 = {
    code: 'F9',
    keyCode: 120,
    easyString: 'f9'
  };
  var F10 = _Key.F10 = {
    code: 'F10',
    keyCode: 121,
    easyString: 'f10'
  };
  var F11 = _Key.F11 = {
    code: 'F11',
    keyCode: 122,
    easyString: 'f11'
  };
  var F12 = _Key.F12 = {
    code: 'F12',
    keyCode: 123,
    easyString: 'f12'
  };
  var F13 = _Key.F13 = {
    code: 'F13',
    keyCode: 124,
    easyString: 'f13'
  };
  var F14 = _Key.F14 = {
    code: 'F14',
    keyCode: 125,
    easyString: 'f14'
  };
  var F15 = _Key.F15 = {
    code: 'F15',
    keyCode: 126,
    easyString: 'f15'
  };
  var F16 = _Key.F16 = {
    code: 'F16',
    keyCode: 127,
    easyString: 'f16'
  };
  var F17 = _Key.F17 = {
    code: 'F17',
    keyCode: 128,
    easyString: 'f17'
  };
  var F18 = _Key.F18 = {
    code: 'F18',
    keyCode: 129,
    easyString: 'f18'
  };
  var F19 = _Key.F19 = {
    code: 'F19',
    keyCode: 130,
    easyString: 'f19'
  };
  var F20 = _Key.F20 = {
    code: 'F20',
    keyCode: 131,
    easyString: 'f20'
  };
  var F21 = _Key.F21 = {
    code: 'F21',
    keyCode: 132,
    easyString: 'f21'
  };
  var F22 = _Key.F22 = {
    code: 'F22',
    keyCode: 133,
    easyString: 'f22'
  };
  var F23 = _Key.F23 = {
    code: 'F23',
    keyCode: 134,
    easyString: 'f23'
  };
  var F24 = _Key.F24 = {
    code: 'F24',
    keyCode: 135,
    easyString: 'f24'
  };
  var NUM_LOCK = _Key.NUM_LOCK = {
    code: 'NumLock',
    keyCode: 144,
    easyString: 'numlock'
  };
  var SEMICOLON = _Key.SEMICOLON = {
    code: 'Semicolon',
    keyCode: 186,
    easyString: ';'
  };
  var EQUAL = _Key.EQUAL = {
    code: 'Equal',
    keyCode: 187,
    easyString: '='
  };
  var COMMA = _Key.COMMA = {
    code: 'Comma',
    keyCode: 188,
    easyString: ','
  };
  var MINUS = _Key.MINUS = {
    code: 'Minus',
    keyCode: 189,
    easyString: '-'
  };
  var PERIOD = _Key.PERIOD = {
    code: 'Period',
    keyCode: 190,
    easyString: '.'
  };
  var SLASH = _Key.SLASH = {
    code: 'Slash',
    keyCode: 191,
    easyString: '/'
  };
  var BACKQUOTE = _Key.BACKQUOTE = {
    code: 'Backquote',
    keyCode: 192,
    easyString: '`'
  };
  var INTL_RO = _Key.INTL_RO = {
    code: 'IntlRo',
    keyCode: 193,
    easyString: 'intlro'
  };
  var BRACKET_LEFT = _Key.BRACKET_LEFT = {
    code: 'BracketLeft',
    keyCode: 219,
    easyString: '['
  };
  var BACKSLASH = _Key.BACKSLASH = {
    code: 'Backslash',
    keyCode: 220,
    easyString: '\\'
  };
  var BRACKET_RIGHT = _Key.BRACKET_RIGHT = {
    code: 'BracketRight',
    keyCode: 221,
    easyString: ']'
  };
  var QUOTE = _Key.QUOTE = {
    code: 'Quote',
    keyCode: 222,
    easyString: "'"
  };
  var INTL_BACKSLASH = _Key.INTL_BACKSLASH = {
    code: 'IntlBackslash',
    keyCode: 229,
    easyString: 'intlbackslash'
  };
  var INTL_YEN = _Key.INTL_YEN = {
    code: 'IntlYen',
    keyCode: 255,
    easyString: 'intlyen'
  };
  var MAX_KEY_CODE = _Key.MAX_KEY_CODE = INTL_YEN.keyCode;
})(Key || (Key = {}));
/* -------------------- Initialize the static key mappings -------------------- */
(function () {
  // Set the default key mappings from the constants in the Key namespace
  Object.keys(Key).map(function (prop) {
    return Reflect.get(Key, prop);
  }).filter(function (key) {
    return Key.isKey(key);
  }).forEach(function (key) {
    CODE_TO_KEY[key.code] = key;
    KEY_CODE_TO_KEY[key.keyCode] = key;
    EASY_TO_KEY[key.easyString] = key;
  });

  // Set additional key mappings
  // Set additional key mappings
  CODE_TO_KEY['Numpad0'] = Key.DIGIT0;
  KEY_CODE_TO_KEY[96] = Key.DIGIT0;
  CODE_TO_KEY['Numpad1'] = Key.DIGIT1;
  KEY_CODE_TO_KEY[97] = Key.DIGIT1;
  CODE_TO_KEY['Numpad2'] = Key.DIGIT2;
  KEY_CODE_TO_KEY[98] = Key.DIGIT2;
  CODE_TO_KEY['Numpad3'] = Key.DIGIT3;
  KEY_CODE_TO_KEY[99] = Key.DIGIT3;
  CODE_TO_KEY['Numpad4'] = Key.DIGIT4;
  KEY_CODE_TO_KEY[100] = Key.DIGIT4;
  CODE_TO_KEY['Numpad5'] = Key.DIGIT5;
  KEY_CODE_TO_KEY[101] = Key.DIGIT5;
  CODE_TO_KEY['Numpad6'] = Key.DIGIT6;
  KEY_CODE_TO_KEY[102] = Key.DIGIT6;
  CODE_TO_KEY['Numpad7'] = Key.DIGIT7;
  KEY_CODE_TO_KEY[103] = Key.DIGIT7;
  CODE_TO_KEY['Numpad8'] = Key.DIGIT8;
  KEY_CODE_TO_KEY[104] = Key.DIGIT8;
  CODE_TO_KEY['Numpad9'] = Key.DIGIT9;
  KEY_CODE_TO_KEY[105] = Key.DIGIT9;
  CODE_TO_KEY['NumpadEnter'] = Key.ENTER;
  CODE_TO_KEY['NumpadEqual'] = Key.EQUAL;
  CODE_TO_KEY['MetaLeft'] = Key.OS_LEFT; // Chrome, Safari
  KEY_CODE_TO_KEY[224] = Key.OS_LEFT; // Firefox on Mac
  CODE_TO_KEY['MetaRight'] = Key.OS_RIGHT; // Chrome, Safari
  KEY_CODE_TO_KEY[93] = Key.OS_RIGHT; // Chrome, Safari, Edge
  KEY_CODE_TO_KEY[225] = Key.ALT_RIGHT; // Linux
  KEY_CODE_TO_KEY[110] = Key.DECIMAL; // Mac, Windows
  KEY_CODE_TO_KEY[59] = Key.SEMICOLON; // Firefox
  KEY_CODE_TO_KEY[61] = Key.EQUAL; // Firefox
  KEY_CODE_TO_KEY[173] = Key.MINUS; // Firefox
  KEY_CODE_TO_KEY[226] = Key.BACKSLASH; // Chrome, Edge on Windows
  KEY_CODE_TO_KEY[60] = Key.BACKSLASH; // Firefox on Linux

  // Set the modifier keys
  MODIFIERS.push.apply(MODIFIERS, [Key.ALT_LEFT, Key.ALT_RIGHT, Key.CONTROL_LEFT, Key.CONTROL_RIGHT, Key.OS_LEFT, Key.OS_RIGHT, Key.SHIFT_LEFT, Key.SHIFT_RIGHT]);
})();
var KeysOrKeyCodes;
(function (_KeysOrKeyCodes) {
  var toKeyCode = _KeysOrKeyCodes.toKeyCode = function (keyOrKeyCode) {
    return keyOrKeyCode instanceof KeyCode ? keyOrKeyCode : KeyCode.createKeyCode({
      first: keyOrKeyCode
    });
  };
  var toKeyCodes = _KeysOrKeyCodes.toKeyCodes = function (keysOrKeyCodes) {
    if (keysOrKeyCodes instanceof KeyCode) {
      return [keysOrKeyCodes];
    }
    if (Array.isArray(keysOrKeyCodes)) {
      return keysOrKeyCodes.slice().map(toKeyCode);
    }
    return [toKeyCode(keysOrKeyCodes)];
  };
})(KeysOrKeyCodes || (KeysOrKeyCodes = {}));
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keyboard/keyboard-layout-service.js
function keyboard_layout_service_typeof(o) { "@babel/helpers - typeof"; return keyboard_layout_service_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, keyboard_layout_service_typeof(o); }
var keyboard_layout_service_dec, keyboard_layout_service_class;
function keyboard_layout_service_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ keyboard_layout_service_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == keyboard_layout_service_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(keyboard_layout_service_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function keyboard_layout_service_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function keyboard_layout_service_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { keyboard_layout_service_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { keyboard_layout_service_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function keyboard_layout_service_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function keyboard_layout_service_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, keyboard_layout_service_toPropertyKey(descriptor.key), descriptor); } }
function keyboard_layout_service_createClass(Constructor, protoProps, staticProps) { if (protoProps) keyboard_layout_service_defineProperties(Constructor.prototype, protoProps); if (staticProps) keyboard_layout_service_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function keyboard_layout_service_toPropertyKey(t) { var i = keyboard_layout_service_toPrimitive(t, "string"); return "symbol" == keyboard_layout_service_typeof(i) ? i : String(i); }
function keyboard_layout_service_toPrimitive(t, r) { if ("object" != keyboard_layout_service_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != keyboard_layout_service_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable @typescript-eslint/no-use-before-define */
/* eslint-disable no-param-reassign */
/* eslint-disable no-restricted-syntax */
/* eslint-disable class-methods-use-this */
/* eslint-disable no-plusplus */





var KeyboardLayoutService = (keyboard_layout_service_dec = (0,mana_syringe_es/* singleton */.ri)(), keyboard_layout_service_dec(keyboard_layout_service_class = /*#__PURE__*/function () {
  function KeyboardLayoutService(layoutProvider, layoutChangeNotifier, keyValidator) {
    keyboard_layout_service_classCallCheck(this, KeyboardLayoutService);
    this.keyboardLayoutChanged = new es_event/* Emitter */.Q5();
    this.layoutProvider = layoutProvider;
    this.layoutChangeNotifier = layoutChangeNotifier;
    this.keyValidator = keyValidator;
  }
  KeyboardLayoutService = (0,mana_syringe_es/* optional */.jt)()(KeyboardLayoutService, undefined, 2) || KeyboardLayoutService;
  KeyboardLayoutService = (0,mana_syringe_es/* inject */.f3)(KeyValidator)(KeyboardLayoutService, undefined, 2) || KeyboardLayoutService;
  KeyboardLayoutService = (0,mana_syringe_es/* inject */.f3)(KeyboardLayoutChangeNotifier)(KeyboardLayoutService, undefined, 1) || KeyboardLayoutService;
  KeyboardLayoutService = (0,mana_syringe_es/* inject */.f3)(KeyboardLayoutProvider)(KeyboardLayoutService, undefined, 0) || KeyboardLayoutService;
  keyboard_layout_service_createClass(KeyboardLayoutService, [{
    key: "updateLayout",
    value: function updateLayout(newLayout) {
      var transformed = this.transformNativeLayout(newLayout);
      this.currentLayout = transformed;
      this.keyboardLayoutChanged.fire(transformed);
      return transformed;
    }
  }, {
    key: "onKeyboardLayoutChanged",
    get: function get() {
      return this.keyboardLayoutChanged.event;
    }
  }, {
    key: "initialize",
    value: function () {
      var _initialize = keyboard_layout_service_asyncToGenerator( /*#__PURE__*/keyboard_layout_service_regeneratorRuntime().mark(function _callee() {
        var _this = this;
        var initialLayout;
        return keyboard_layout_service_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              this.layoutChangeNotifier.onDidChangeNativeLayout(function (newLayout) {
                return _this.updateLayout(newLayout);
              });
              _context.next = 3;
              return this.layoutProvider.getNativeLayout();
            case 3:
              initialLayout = _context.sent;
              this.updateLayout(initialLayout);
            case 5:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function initialize() {
        return _initialize.apply(this, arguments);
      }
      return initialize;
    }()
    /**
     * Resolve a KeyCode of a keybinding using the current keyboard layout.
     * If no keyboard layout has been detected or the layout does not contain the
     * key used in the KeyCode, the KeyCode is returned unchanged.
     */
  }, {
    key: "resolveKeyCode",
    value: function resolveKeyCode(inCode) {
      var layout = this.currentLayout;
      if (layout && inCode.key) {
        for (var shift = 0; shift <= 1; shift++) {
          var index = this.getCharacterIndex(inCode.key, !!shift);
          var mappedCode = layout.key2KeyCode[index];
          if (mappedCode) {
            var transformed = this.transformKeyCode(inCode, mappedCode, !!shift);
            if (transformed) {
              return transformed;
            }
          }
        }
      }
      return inCode;
    }

    /**
     * Return the character shown on the user's keyboard for the given key.
     * Use this to determine UI representations of keybindings.
     */
  }, {
    key: "getKeyboardCharacter",
    value: function getKeyboardCharacter(key) {
      var layout = this.currentLayout;
      if (layout) {
        var value = layout.code2Character[key.code];
        if (value && value.replace(/[\n\r\t]/g, '')) {
          return value;
        }
      }
      return key.easyString;
    }

    /**
     * Called when a KeyboardEvent is processed by the KeybindingRegistry.
     * The KeyValidator may trigger a keyboard layout change.
     */
  }, {
    key: "validateKeyCode",
    value: function validateKeyCode(keyCode) {
      if (this.keyValidator && keyCode.key && keyCode.character) {
        this.keyValidator.validateKey({
          code: keyCode.key.code,
          character: keyCode.character,
          shiftKey: keyCode.shift,
          ctrlKey: keyCode.ctrl,
          altKey: keyCode.alt
        });
      }
    }
  }, {
    key: "transformKeyCode",
    value: function transformKeyCode(inCode, mappedCode, keyNeedsShift) {
      if (!inCode.shift && keyNeedsShift) {
        return undefined;
      }
      if (mappedCode.alt && (inCode.alt || inCode.ctrl || inCode.shift && !keyNeedsShift)) {
        return undefined;
      }
      return new KeyCode({
        key: mappedCode.key,
        meta: inCode.meta,
        ctrl: inCode.ctrl || mappedCode.alt,
        shift: inCode.shift && !keyNeedsShift || mappedCode.shift,
        alt: inCode.alt || mappedCode.alt
      });
    }
  }, {
    key: "transformNativeLayout",
    value: function transformNativeLayout(nativeLayout) {
      var key2KeyCode = new Array(2 * (Key.MAX_KEY_CODE + 1));
      var code2Character = {};
      var mapping = nativeLayout.mapping;
      for (var code in mapping) {
        if (Object.prototype.hasOwnProperty.call(mapping, code)) {
          var keyMapping = mapping[code];
          var mappedKey = Key.getKey(code);
          if (mappedKey && this.shouldIncludeKey(code)) {
            if (platform/* isWindows */.ED) {
              this.addWindowsKeyMapping(key2KeyCode, mappedKey, keyMapping.vkey, keyMapping.value);
            } else {
              if (keyMapping.value) {
                this.addKeyMapping(key2KeyCode, mappedKey, keyMapping.value, false, false);
              }
              if (keyMapping.withShift) {
                this.addKeyMapping(key2KeyCode, mappedKey, keyMapping.withShift, true, false);
              }
              if (keyMapping.withAltGr) {
                this.addKeyMapping(key2KeyCode, mappedKey, keyMapping.withAltGr, false, true);
              }
              if (keyMapping.withShiftAltGr) {
                this.addKeyMapping(key2KeyCode, mappedKey, keyMapping.withShiftAltGr, true, true);
              }
            }
          }
          if (keyMapping.value) {
            code2Character[code] = keyMapping.value;
          }
        }
      }
      return {
        key2KeyCode: key2KeyCode,
        code2Character: code2Character
      };
    }
  }, {
    key: "shouldIncludeKey",
    value: function shouldIncludeKey(code) {
      // Exclude all numpad keys because they produce values that are already found elsewhere on the keyboard.
      // This can cause problems, e.g. if `Numpad3` maps to `PageDown` then commands bound to `PageDown` would
      // be resolved to `Digit3` (`Numpad3` is associated with `Key.DIGIT3`), effectively blocking the user
      // from typing `3` in an editor.
      return !code.startsWith('Numpad');
    }
  }, {
    key: "addKeyMapping",
    value: function addKeyMapping(key2KeyCode, mappedKey, value, shift, alt) {
      var key = VALUE_TO_KEY[value];
      if (key) {
        var index = this.getCharacterIndex(key.key, key.shift);
        if (key2KeyCode[index] === undefined) {
          key2KeyCode[index] = new KeyCode({
            key: mappedKey,
            shift: shift,
            alt: alt,
            character: value
          });
        }
      }
    }
  }, {
    key: "addWindowsKeyMapping",
    value: function addWindowsKeyMapping(key2KeyCode, mappedKey, vkey, value) {
      var key = VKEY_TO_KEY[vkey];
      if (key) {
        var index = this.getCharacterIndex(key);
        if (key2KeyCode[index] === undefined) {
          key2KeyCode[index] = new KeyCode({
            key: mappedKey,
            character: value
          });
        }
      }
    }
  }, {
    key: "getCharacterIndex",
    value: function getCharacterIndex(key, shift) {
      if (shift) {
        return Key.MAX_KEY_CODE + key.keyCode + 1;
      }
      return key.keyCode;
    }
  }]);
  return KeyboardLayoutService;
}()) || keyboard_layout_service_class);

/**
 * Mapping of character values to the corresponding keys on a standard US keyboard layout.
 */
var VALUE_TO_KEY = {
  '`': {
    key: Key.BACKQUOTE
  },
  '~': {
    key: Key.BACKQUOTE,
    shift: true
  },
  '1': {
    key: Key.DIGIT1
  },
  '!': {
    key: Key.DIGIT1,
    shift: true
  },
  '2': {
    key: Key.DIGIT2
  },
  '@': {
    key: Key.DIGIT2,
    shift: true
  },
  '3': {
    key: Key.DIGIT3
  },
  '#': {
    key: Key.DIGIT3,
    shift: true
  },
  '4': {
    key: Key.DIGIT4
  },
  $: {
    key: Key.DIGIT4,
    shift: true
  },
  '5': {
    key: Key.DIGIT5
  },
  '%': {
    key: Key.DIGIT5,
    shift: true
  },
  '6': {
    key: Key.DIGIT6
  },
  '^': {
    key: Key.DIGIT6,
    shift: true
  },
  '7': {
    key: Key.DIGIT7
  },
  '&': {
    key: Key.DIGIT7,
    shift: true
  },
  '8': {
    key: Key.DIGIT8
  },
  '*': {
    key: Key.DIGIT8,
    shift: true
  },
  '9': {
    key: Key.DIGIT9
  },
  '(': {
    key: Key.DIGIT9,
    shift: true
  },
  '0': {
    key: Key.DIGIT0
  },
  ')': {
    key: Key.DIGIT0,
    shift: true
  },
  '-': {
    key: Key.MINUS
  },
  _: {
    key: Key.MINUS,
    shift: true
  },
  '=': {
    key: Key.EQUAL
  },
  '+': {
    key: Key.EQUAL,
    shift: true
  },
  a: {
    key: Key.KEY_A
  },
  A: {
    key: Key.KEY_A,
    shift: true
  },
  b: {
    key: Key.KEY_B
  },
  B: {
    key: Key.KEY_B,
    shift: true
  },
  c: {
    key: Key.KEY_C
  },
  C: {
    key: Key.KEY_C,
    shift: true
  },
  d: {
    key: Key.KEY_D
  },
  D: {
    key: Key.KEY_D,
    shift: true
  },
  e: {
    key: Key.KEY_E
  },
  E: {
    key: Key.KEY_E,
    shift: true
  },
  f: {
    key: Key.KEY_F
  },
  F: {
    key: Key.KEY_F,
    shift: true
  },
  g: {
    key: Key.KEY_G
  },
  G: {
    key: Key.KEY_G,
    shift: true
  },
  h: {
    key: Key.KEY_H
  },
  H: {
    key: Key.KEY_H,
    shift: true
  },
  i: {
    key: Key.KEY_I
  },
  I: {
    key: Key.KEY_I,
    shift: true
  },
  j: {
    key: Key.KEY_J
  },
  J: {
    key: Key.KEY_J,
    shift: true
  },
  k: {
    key: Key.KEY_K
  },
  K: {
    key: Key.KEY_K,
    shift: true
  },
  l: {
    key: Key.KEY_L
  },
  L: {
    key: Key.KEY_L,
    shift: true
  },
  m: {
    key: Key.KEY_M
  },
  M: {
    key: Key.KEY_M,
    shift: true
  },
  n: {
    key: Key.KEY_N
  },
  N: {
    key: Key.KEY_N,
    shift: true
  },
  o: {
    key: Key.KEY_O
  },
  O: {
    key: Key.KEY_O,
    shift: true
  },
  p: {
    key: Key.KEY_P
  },
  P: {
    key: Key.KEY_P,
    shift: true
  },
  q: {
    key: Key.KEY_Q
  },
  Q: {
    key: Key.KEY_Q,
    shift: true
  },
  r: {
    key: Key.KEY_R
  },
  R: {
    key: Key.KEY_R,
    shift: true
  },
  s: {
    key: Key.KEY_S
  },
  S: {
    key: Key.KEY_S,
    shift: true
  },
  t: {
    key: Key.KEY_T
  },
  T: {
    key: Key.KEY_T,
    shift: true
  },
  u: {
    key: Key.KEY_U
  },
  U: {
    key: Key.KEY_U,
    shift: true
  },
  v: {
    key: Key.KEY_V
  },
  V: {
    key: Key.KEY_V,
    shift: true
  },
  w: {
    key: Key.KEY_W
  },
  W: {
    key: Key.KEY_W,
    shift: true
  },
  x: {
    key: Key.KEY_X
  },
  X: {
    key: Key.KEY_X,
    shift: true
  },
  y: {
    key: Key.KEY_Y
  },
  Y: {
    key: Key.KEY_Y,
    shift: true
  },
  z: {
    key: Key.KEY_Z
  },
  Z: {
    key: Key.KEY_Z,
    shift: true
  },
  '[': {
    key: Key.BRACKET_LEFT
  },
  '{': {
    key: Key.BRACKET_LEFT,
    shift: true
  },
  ']': {
    key: Key.BRACKET_RIGHT
  },
  '}': {
    key: Key.BRACKET_RIGHT,
    shift: true
  },
  ';': {
    key: Key.SEMICOLON
  },
  ':': {
    key: Key.SEMICOLON,
    shift: true
  },
  "'": {
    key: Key.QUOTE
  },
  '"': {
    key: Key.QUOTE,
    shift: true
  },
  ',': {
    key: Key.COMMA
  },
  '<': {
    key: Key.COMMA,
    shift: true
  },
  '.': {
    key: Key.PERIOD
  },
  '>': {
    key: Key.PERIOD,
    shift: true
  },
  '/': {
    key: Key.SLASH
  },
  '?': {
    key: Key.SLASH,
    shift: true
  },
  '\\': {
    key: Key.BACKSLASH
  },
  '|': {
    key: Key.BACKSLASH,
    shift: true
  },
  '\t': {
    key: Key.TAB
  },
  '\r': {
    key: Key.ENTER
  },
  '\n': {
    key: Key.ENTER
  },
  ' ': {
    key: Key.SPACE
  }
};

/**
 * Mapping of Windows Virtual Keys to the corresponding keys on a standard US keyboard layout.
 */
var VKEY_TO_KEY = {
  VK_SHIFT: Key.SHIFT_LEFT,
  VK_LSHIFT: Key.SHIFT_LEFT,
  VK_RSHIFT: Key.SHIFT_RIGHT,
  VK_CONTROL: Key.CONTROL_LEFT,
  VK_LCONTROL: Key.CONTROL_LEFT,
  VK_RCONTROL: Key.CONTROL_RIGHT,
  VK_MENU: Key.ALT_LEFT,
  VK_COMMAND: Key.OS_LEFT,
  VK_LWIN: Key.OS_LEFT,
  VK_RWIN: Key.OS_RIGHT,
  VK_0: Key.DIGIT0,
  VK_1: Key.DIGIT1,
  VK_2: Key.DIGIT2,
  VK_3: Key.DIGIT3,
  VK_4: Key.DIGIT4,
  VK_5: Key.DIGIT5,
  VK_6: Key.DIGIT6,
  VK_7: Key.DIGIT7,
  VK_8: Key.DIGIT8,
  VK_9: Key.DIGIT9,
  VK_A: Key.KEY_A,
  VK_B: Key.KEY_B,
  VK_C: Key.KEY_C,
  VK_D: Key.KEY_D,
  VK_E: Key.KEY_E,
  VK_F: Key.KEY_F,
  VK_G: Key.KEY_G,
  VK_H: Key.KEY_H,
  VK_I: Key.KEY_I,
  VK_J: Key.KEY_J,
  VK_K: Key.KEY_K,
  VK_L: Key.KEY_L,
  VK_M: Key.KEY_M,
  VK_N: Key.KEY_N,
  VK_O: Key.KEY_O,
  VK_P: Key.KEY_P,
  VK_Q: Key.KEY_Q,
  VK_R: Key.KEY_R,
  VK_S: Key.KEY_S,
  VK_T: Key.KEY_T,
  VK_U: Key.KEY_U,
  VK_V: Key.KEY_V,
  VK_W: Key.KEY_W,
  VK_X: Key.KEY_X,
  VK_Y: Key.KEY_Y,
  VK_Z: Key.KEY_Z,
  VK_OEM_1: Key.SEMICOLON,
  VK_OEM_2: Key.SLASH,
  VK_OEM_3: Key.BACKQUOTE,
  VK_OEM_4: Key.BRACKET_LEFT,
  VK_OEM_5: Key.BACKSLASH,
  VK_OEM_6: Key.BRACKET_RIGHT,
  VK_OEM_7: Key.QUOTE,
  VK_OEM_PLUS: Key.EQUAL,
  VK_OEM_COMMA: Key.COMMA,
  VK_OEM_MINUS: Key.MINUS,
  VK_OEM_PERIOD: Key.PERIOD,
  VK_F1: Key.F1,
  VK_F2: Key.F2,
  VK_F3: Key.F3,
  VK_F4: Key.F4,
  VK_F5: Key.F5,
  VK_F6: Key.F6,
  VK_F7: Key.F7,
  VK_F8: Key.F8,
  VK_F9: Key.F9,
  VK_F10: Key.F10,
  VK_F11: Key.F11,
  VK_F12: Key.F12,
  VK_F13: Key.F13,
  VK_F14: Key.F14,
  VK_F15: Key.F15,
  VK_F16: Key.F16,
  VK_F17: Key.F17,
  VK_F18: Key.F18,
  VK_F19: Key.F19,
  VK_BACK: Key.BACKSPACE,
  VK_TAB: Key.TAB,
  VK_RETURN: Key.ENTER,
  VK_CAPITAL: Key.CAPS_LOCK,
  VK_ESCAPE: Key.ESCAPE,
  VK_SPACE: Key.SPACE,
  VK_PRIOR: Key.PAGE_UP,
  VK_NEXT: Key.PAGE_DOWN,
  VK_END: Key.END,
  VK_HOME: Key.HOME,
  VK_INSERT: Key.INSERT,
  VK_DELETE: Key.DELETE,
  VK_LEFT: Key.ARROW_LEFT,
  VK_UP: Key.ARROW_UP,
  VK_RIGHT: Key.ARROW_RIGHT,
  VK_DOWN: Key.ARROW_DOWN,
  VK_NUMLOCK: Key.NUM_LOCK,
  VK_NUMPAD0: Key.DIGIT0,
  VK_NUMPAD1: Key.DIGIT1,
  VK_NUMPAD2: Key.DIGIT2,
  VK_NUMPAD3: Key.DIGIT3,
  VK_NUMPAD4: Key.DIGIT4,
  VK_NUMPAD5: Key.DIGIT5,
  VK_NUMPAD6: Key.DIGIT6,
  VK_NUMPAD7: Key.DIGIT7,
  VK_NUMPAD8: Key.DIGIT8,
  VK_NUMPAD9: Key.DIGIT9,
  VK_MULTIPLY: Key.MULTIPLY,
  VK_ADD: Key.ADD,
  VK_SUBTRACT: Key.SUBTRACT,
  VK_DECIMAL: Key.DECIMAL,
  VK_DIVIDE: Key.DIVIDE
};
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/charCode.js
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

// Names from https://blog.codinghorror.com/ascii-pronunciation-rules-for-programmers/

/**
 * An inlined enum containing useful character codes (to be used with String.charCodeAt).
 * Please leave the const keyword such that it gets inlined when compiled to JavaScript!
 */
var CharCode = /*#__PURE__*/function (CharCode) {
  CharCode[CharCode["Null"] = 0] = "Null";
  CharCode[CharCode["Backspace"] = 8] = "Backspace";
  CharCode[CharCode["Tab"] = 9] = "Tab";
  CharCode[CharCode["LineFeed"] = 10] = "LineFeed";
  CharCode[CharCode["CarriageReturn"] = 13] = "CarriageReturn";
  CharCode[CharCode["Space"] = 32] = "Space";
  CharCode[CharCode["ExclamationMark"] = 33] = "ExclamationMark";
  CharCode[CharCode["DoubleQuote"] = 34] = "DoubleQuote";
  CharCode[CharCode["Hash"] = 35] = "Hash";
  CharCode[CharCode["DollarSign"] = 36] = "DollarSign";
  CharCode[CharCode["PercentSign"] = 37] = "PercentSign";
  CharCode[CharCode["Ampersand"] = 38] = "Ampersand";
  CharCode[CharCode["SingleQuote"] = 39] = "SingleQuote";
  CharCode[CharCode["OpenParen"] = 40] = "OpenParen";
  CharCode[CharCode["CloseParen"] = 41] = "CloseParen";
  CharCode[CharCode["Asterisk"] = 42] = "Asterisk";
  CharCode[CharCode["Plus"] = 43] = "Plus";
  CharCode[CharCode["Comma"] = 44] = "Comma";
  CharCode[CharCode["Dash"] = 45] = "Dash";
  CharCode[CharCode["Period"] = 46] = "Period";
  CharCode[CharCode["Slash"] = 47] = "Slash";
  CharCode[CharCode["Digit0"] = 48] = "Digit0";
  CharCode[CharCode["Digit1"] = 49] = "Digit1";
  CharCode[CharCode["Digit2"] = 50] = "Digit2";
  CharCode[CharCode["Digit3"] = 51] = "Digit3";
  CharCode[CharCode["Digit4"] = 52] = "Digit4";
  CharCode[CharCode["Digit5"] = 53] = "Digit5";
  CharCode[CharCode["Digit6"] = 54] = "Digit6";
  CharCode[CharCode["Digit7"] = 55] = "Digit7";
  CharCode[CharCode["Digit8"] = 56] = "Digit8";
  CharCode[CharCode["Digit9"] = 57] = "Digit9";
  CharCode[CharCode["Colon"] = 58] = "Colon";
  CharCode[CharCode["Semicolon"] = 59] = "Semicolon";
  CharCode[CharCode["LessThan"] = 60] = "LessThan";
  CharCode[CharCode["Equals"] = 61] = "Equals";
  CharCode[CharCode["GreaterThan"] = 62] = "GreaterThan";
  CharCode[CharCode["QuestionMark"] = 63] = "QuestionMark";
  CharCode[CharCode["AtSign"] = 64] = "AtSign";
  CharCode[CharCode["A"] = 65] = "A";
  CharCode[CharCode["B"] = 66] = "B";
  CharCode[CharCode["C"] = 67] = "C";
  CharCode[CharCode["D"] = 68] = "D";
  CharCode[CharCode["E"] = 69] = "E";
  CharCode[CharCode["F"] = 70] = "F";
  CharCode[CharCode["G"] = 71] = "G";
  CharCode[CharCode["H"] = 72] = "H";
  CharCode[CharCode["I"] = 73] = "I";
  CharCode[CharCode["J"] = 74] = "J";
  CharCode[CharCode["K"] = 75] = "K";
  CharCode[CharCode["L"] = 76] = "L";
  CharCode[CharCode["M"] = 77] = "M";
  CharCode[CharCode["N"] = 78] = "N";
  CharCode[CharCode["O"] = 79] = "O";
  CharCode[CharCode["P"] = 80] = "P";
  CharCode[CharCode["Q"] = 81] = "Q";
  CharCode[CharCode["R"] = 82] = "R";
  CharCode[CharCode["S"] = 83] = "S";
  CharCode[CharCode["T"] = 84] = "T";
  CharCode[CharCode["U"] = 85] = "U";
  CharCode[CharCode["V"] = 86] = "V";
  CharCode[CharCode["W"] = 87] = "W";
  CharCode[CharCode["X"] = 88] = "X";
  CharCode[CharCode["Y"] = 89] = "Y";
  CharCode[CharCode["Z"] = 90] = "Z";
  CharCode[CharCode["OpenSquareBracket"] = 91] = "OpenSquareBracket";
  CharCode[CharCode["Backslash"] = 92] = "Backslash";
  CharCode[CharCode["CloseSquareBracket"] = 93] = "CloseSquareBracket";
  CharCode[CharCode["Caret"] = 94] = "Caret";
  CharCode[CharCode["Underline"] = 95] = "Underline";
  CharCode[CharCode["BackTick"] = 96] = "BackTick";
  CharCode[CharCode["a"] = 97] = "a";
  CharCode[CharCode["b"] = 98] = "b";
  CharCode[CharCode["c"] = 99] = "c";
  CharCode[CharCode["d"] = 100] = "d";
  CharCode[CharCode["e"] = 101] = "e";
  CharCode[CharCode["f"] = 102] = "f";
  CharCode[CharCode["g"] = 103] = "g";
  CharCode[CharCode["h"] = 104] = "h";
  CharCode[CharCode["i"] = 105] = "i";
  CharCode[CharCode["j"] = 106] = "j";
  CharCode[CharCode["k"] = 107] = "k";
  CharCode[CharCode["l"] = 108] = "l";
  CharCode[CharCode["m"] = 109] = "m";
  CharCode[CharCode["n"] = 110] = "n";
  CharCode[CharCode["o"] = 111] = "o";
  CharCode[CharCode["p"] = 112] = "p";
  CharCode[CharCode["q"] = 113] = "q";
  CharCode[CharCode["r"] = 114] = "r";
  CharCode[CharCode["s"] = 115] = "s";
  CharCode[CharCode["t"] = 116] = "t";
  CharCode[CharCode["u"] = 117] = "u";
  CharCode[CharCode["v"] = 118] = "v";
  CharCode[CharCode["w"] = 119] = "w";
  CharCode[CharCode["x"] = 120] = "x";
  CharCode[CharCode["y"] = 121] = "y";
  CharCode[CharCode["z"] = 122] = "z";
  CharCode[CharCode["OpenCurlyBrace"] = 123] = "OpenCurlyBrace";
  CharCode[CharCode["Pipe"] = 124] = "Pipe";
  CharCode[CharCode["CloseCurlyBrace"] = 125] = "CloseCurlyBrace";
  CharCode[CharCode["Tilde"] = 126] = "Tilde";
  CharCode[CharCode["U_Combining_Grave_Accent"] = 768] = "U_Combining_Grave_Accent";
  CharCode[CharCode["U_Combining_Acute_Accent"] = 769] = "U_Combining_Acute_Accent";
  CharCode[CharCode["U_Combining_Circumflex_Accent"] = 770] = "U_Combining_Circumflex_Accent";
  CharCode[CharCode["U_Combining_Tilde"] = 771] = "U_Combining_Tilde";
  CharCode[CharCode["U_Combining_Macron"] = 772] = "U_Combining_Macron";
  CharCode[CharCode["U_Combining_Overline"] = 773] = "U_Combining_Overline";
  CharCode[CharCode["U_Combining_Breve"] = 774] = "U_Combining_Breve";
  CharCode[CharCode["U_Combining_Dot_Above"] = 775] = "U_Combining_Dot_Above";
  CharCode[CharCode["U_Combining_Diaeresis"] = 776] = "U_Combining_Diaeresis";
  CharCode[CharCode["U_Combining_Hook_Above"] = 777] = "U_Combining_Hook_Above";
  CharCode[CharCode["U_Combining_Ring_Above"] = 778] = "U_Combining_Ring_Above";
  CharCode[CharCode["U_Combining_Double_Acute_Accent"] = 779] = "U_Combining_Double_Acute_Accent";
  CharCode[CharCode["U_Combining_Caron"] = 780] = "U_Combining_Caron";
  CharCode[CharCode["U_Combining_Vertical_Line_Above"] = 781] = "U_Combining_Vertical_Line_Above";
  CharCode[CharCode["U_Combining_Double_Vertical_Line_Above"] = 782] = "U_Combining_Double_Vertical_Line_Above";
  CharCode[CharCode["U_Combining_Double_Grave_Accent"] = 783] = "U_Combining_Double_Grave_Accent";
  CharCode[CharCode["U_Combining_Candrabindu"] = 784] = "U_Combining_Candrabindu";
  CharCode[CharCode["U_Combining_Inverted_Breve"] = 785] = "U_Combining_Inverted_Breve";
  CharCode[CharCode["U_Combining_Turned_Comma_Above"] = 786] = "U_Combining_Turned_Comma_Above";
  CharCode[CharCode["U_Combining_Comma_Above"] = 787] = "U_Combining_Comma_Above";
  CharCode[CharCode["U_Combining_Reversed_Comma_Above"] = 788] = "U_Combining_Reversed_Comma_Above";
  CharCode[CharCode["U_Combining_Comma_Above_Right"] = 789] = "U_Combining_Comma_Above_Right";
  CharCode[CharCode["U_Combining_Grave_Accent_Below"] = 790] = "U_Combining_Grave_Accent_Below";
  CharCode[CharCode["U_Combining_Acute_Accent_Below"] = 791] = "U_Combining_Acute_Accent_Below";
  CharCode[CharCode["U_Combining_Left_Tack_Below"] = 792] = "U_Combining_Left_Tack_Below";
  CharCode[CharCode["U_Combining_Right_Tack_Below"] = 793] = "U_Combining_Right_Tack_Below";
  CharCode[CharCode["U_Combining_Left_Angle_Above"] = 794] = "U_Combining_Left_Angle_Above";
  CharCode[CharCode["U_Combining_Horn"] = 795] = "U_Combining_Horn";
  CharCode[CharCode["U_Combining_Left_Half_Ring_Below"] = 796] = "U_Combining_Left_Half_Ring_Below";
  CharCode[CharCode["U_Combining_Up_Tack_Below"] = 797] = "U_Combining_Up_Tack_Below";
  CharCode[CharCode["U_Combining_Down_Tack_Below"] = 798] = "U_Combining_Down_Tack_Below";
  CharCode[CharCode["U_Combining_Plus_Sign_Below"] = 799] = "U_Combining_Plus_Sign_Below";
  CharCode[CharCode["U_Combining_Minus_Sign_Below"] = 800] = "U_Combining_Minus_Sign_Below";
  CharCode[CharCode["U_Combining_Palatalized_Hook_Below"] = 801] = "U_Combining_Palatalized_Hook_Below";
  CharCode[CharCode["U_Combining_Retroflex_Hook_Below"] = 802] = "U_Combining_Retroflex_Hook_Below";
  CharCode[CharCode["U_Combining_Dot_Below"] = 803] = "U_Combining_Dot_Below";
  CharCode[CharCode["U_Combining_Diaeresis_Below"] = 804] = "U_Combining_Diaeresis_Below";
  CharCode[CharCode["U_Combining_Ring_Below"] = 805] = "U_Combining_Ring_Below";
  CharCode[CharCode["U_Combining_Comma_Below"] = 806] = "U_Combining_Comma_Below";
  CharCode[CharCode["U_Combining_Cedilla"] = 807] = "U_Combining_Cedilla";
  CharCode[CharCode["U_Combining_Ogonek"] = 808] = "U_Combining_Ogonek";
  CharCode[CharCode["U_Combining_Vertical_Line_Below"] = 809] = "U_Combining_Vertical_Line_Below";
  CharCode[CharCode["U_Combining_Bridge_Below"] = 810] = "U_Combining_Bridge_Below";
  CharCode[CharCode["U_Combining_Inverted_Double_Arch_Below"] = 811] = "U_Combining_Inverted_Double_Arch_Below";
  CharCode[CharCode["U_Combining_Caron_Below"] = 812] = "U_Combining_Caron_Below";
  CharCode[CharCode["U_Combining_Circumflex_Accent_Below"] = 813] = "U_Combining_Circumflex_Accent_Below";
  CharCode[CharCode["U_Combining_Breve_Below"] = 814] = "U_Combining_Breve_Below";
  CharCode[CharCode["U_Combining_Inverted_Breve_Below"] = 815] = "U_Combining_Inverted_Breve_Below";
  CharCode[CharCode["U_Combining_Tilde_Below"] = 816] = "U_Combining_Tilde_Below";
  CharCode[CharCode["U_Combining_Macron_Below"] = 817] = "U_Combining_Macron_Below";
  CharCode[CharCode["U_Combining_Low_Line"] = 818] = "U_Combining_Low_Line";
  CharCode[CharCode["U_Combining_Double_Low_Line"] = 819] = "U_Combining_Double_Low_Line";
  CharCode[CharCode["U_Combining_Tilde_Overlay"] = 820] = "U_Combining_Tilde_Overlay";
  CharCode[CharCode["U_Combining_Short_Stroke_Overlay"] = 821] = "U_Combining_Short_Stroke_Overlay";
  CharCode[CharCode["U_Combining_Long_Stroke_Overlay"] = 822] = "U_Combining_Long_Stroke_Overlay";
  CharCode[CharCode["U_Combining_Short_Solidus_Overlay"] = 823] = "U_Combining_Short_Solidus_Overlay";
  CharCode[CharCode["U_Combining_Long_Solidus_Overlay"] = 824] = "U_Combining_Long_Solidus_Overlay";
  CharCode[CharCode["U_Combining_Right_Half_Ring_Below"] = 825] = "U_Combining_Right_Half_Ring_Below";
  CharCode[CharCode["U_Combining_Inverted_Bridge_Below"] = 826] = "U_Combining_Inverted_Bridge_Below";
  CharCode[CharCode["U_Combining_Square_Below"] = 827] = "U_Combining_Square_Below";
  CharCode[CharCode["U_Combining_Seagull_Below"] = 828] = "U_Combining_Seagull_Below";
  CharCode[CharCode["U_Combining_X_Above"] = 829] = "U_Combining_X_Above";
  CharCode[CharCode["U_Combining_Vertical_Tilde"] = 830] = "U_Combining_Vertical_Tilde";
  CharCode[CharCode["U_Combining_Double_Overline"] = 831] = "U_Combining_Double_Overline";
  CharCode[CharCode["U_Combining_Grave_Tone_Mark"] = 832] = "U_Combining_Grave_Tone_Mark";
  CharCode[CharCode["U_Combining_Acute_Tone_Mark"] = 833] = "U_Combining_Acute_Tone_Mark";
  CharCode[CharCode["U_Combining_Greek_Perispomeni"] = 834] = "U_Combining_Greek_Perispomeni";
  CharCode[CharCode["U_Combining_Greek_Koronis"] = 835] = "U_Combining_Greek_Koronis";
  CharCode[CharCode["U_Combining_Greek_Dialytika_Tonos"] = 836] = "U_Combining_Greek_Dialytika_Tonos";
  CharCode[CharCode["U_Combining_Greek_Ypogegrammeni"] = 837] = "U_Combining_Greek_Ypogegrammeni";
  CharCode[CharCode["U_Combining_Bridge_Above"] = 838] = "U_Combining_Bridge_Above";
  CharCode[CharCode["U_Combining_Equals_Sign_Below"] = 839] = "U_Combining_Equals_Sign_Below";
  CharCode[CharCode["U_Combining_Double_Vertical_Line_Below"] = 840] = "U_Combining_Double_Vertical_Line_Below";
  CharCode[CharCode["U_Combining_Left_Angle_Below"] = 841] = "U_Combining_Left_Angle_Below";
  CharCode[CharCode["U_Combining_Not_Tilde_Above"] = 842] = "U_Combining_Not_Tilde_Above";
  CharCode[CharCode["U_Combining_Homothetic_Above"] = 843] = "U_Combining_Homothetic_Above";
  CharCode[CharCode["U_Combining_Almost_Equal_To_Above"] = 844] = "U_Combining_Almost_Equal_To_Above";
  CharCode[CharCode["U_Combining_Left_Right_Arrow_Below"] = 845] = "U_Combining_Left_Right_Arrow_Below";
  CharCode[CharCode["U_Combining_Upwards_Arrow_Below"] = 846] = "U_Combining_Upwards_Arrow_Below";
  CharCode[CharCode["U_Combining_Grapheme_Joiner"] = 847] = "U_Combining_Grapheme_Joiner";
  CharCode[CharCode["U_Combining_Right_Arrowhead_Above"] = 848] = "U_Combining_Right_Arrowhead_Above";
  CharCode[CharCode["U_Combining_Left_Half_Ring_Above"] = 849] = "U_Combining_Left_Half_Ring_Above";
  CharCode[CharCode["U_Combining_Fermata"] = 850] = "U_Combining_Fermata";
  CharCode[CharCode["U_Combining_X_Below"] = 851] = "U_Combining_X_Below";
  CharCode[CharCode["U_Combining_Left_Arrowhead_Below"] = 852] = "U_Combining_Left_Arrowhead_Below";
  CharCode[CharCode["U_Combining_Right_Arrowhead_Below"] = 853] = "U_Combining_Right_Arrowhead_Below";
  CharCode[CharCode["U_Combining_Right_Arrowhead_And_Up_Arrowhead_Below"] = 854] = "U_Combining_Right_Arrowhead_And_Up_Arrowhead_Below";
  CharCode[CharCode["U_Combining_Right_Half_Ring_Above"] = 855] = "U_Combining_Right_Half_Ring_Above";
  CharCode[CharCode["U_Combining_Dot_Above_Right"] = 856] = "U_Combining_Dot_Above_Right";
  CharCode[CharCode["U_Combining_Asterisk_Below"] = 857] = "U_Combining_Asterisk_Below";
  CharCode[CharCode["U_Combining_Double_Ring_Below"] = 858] = "U_Combining_Double_Ring_Below";
  CharCode[CharCode["U_Combining_Zigzag_Above"] = 859] = "U_Combining_Zigzag_Above";
  CharCode[CharCode["U_Combining_Double_Breve_Below"] = 860] = "U_Combining_Double_Breve_Below";
  CharCode[CharCode["U_Combining_Double_Breve"] = 861] = "U_Combining_Double_Breve";
  CharCode[CharCode["U_Combining_Double_Macron"] = 862] = "U_Combining_Double_Macron";
  CharCode[CharCode["U_Combining_Double_Macron_Below"] = 863] = "U_Combining_Double_Macron_Below";
  CharCode[CharCode["U_Combining_Double_Tilde"] = 864] = "U_Combining_Double_Tilde";
  CharCode[CharCode["U_Combining_Double_Inverted_Breve"] = 865] = "U_Combining_Double_Inverted_Breve";
  CharCode[CharCode["U_Combining_Double_Rightwards_Arrow_Below"] = 866] = "U_Combining_Double_Rightwards_Arrow_Below";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_A"] = 867] = "U_Combining_Latin_Small_Letter_A";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_E"] = 868] = "U_Combining_Latin_Small_Letter_E";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_I"] = 869] = "U_Combining_Latin_Small_Letter_I";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_O"] = 870] = "U_Combining_Latin_Small_Letter_O";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_U"] = 871] = "U_Combining_Latin_Small_Letter_U";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_C"] = 872] = "U_Combining_Latin_Small_Letter_C";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_D"] = 873] = "U_Combining_Latin_Small_Letter_D";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_H"] = 874] = "U_Combining_Latin_Small_Letter_H";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_M"] = 875] = "U_Combining_Latin_Small_Letter_M";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_R"] = 876] = "U_Combining_Latin_Small_Letter_R";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_T"] = 877] = "U_Combining_Latin_Small_Letter_T";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_V"] = 878] = "U_Combining_Latin_Small_Letter_V";
  CharCode[CharCode["U_Combining_Latin_Small_Letter_X"] = 879] = "U_Combining_Latin_Small_Letter_X";
  CharCode[CharCode["LINE_SEPARATOR"] = 8232] = "LINE_SEPARATOR";
  CharCode[CharCode["PARAGRAPH_SEPARATOR"] = 8233] = "PARAGRAPH_SEPARATOR";
  CharCode[CharCode["NEXT_LINE"] = 133] = "NEXT_LINE";
  CharCode[CharCode["U_CIRCUMFLEX"] = 94] = "U_CIRCUMFLEX";
  CharCode[CharCode["U_GRAVE_ACCENT"] = 96] = "U_GRAVE_ACCENT";
  CharCode[CharCode["U_DIAERESIS"] = 168] = "U_DIAERESIS";
  CharCode[CharCode["U_MACRON"] = 175] = "U_MACRON";
  CharCode[CharCode["U_ACUTE_ACCENT"] = 180] = "U_ACUTE_ACCENT";
  CharCode[CharCode["U_CEDILLA"] = 184] = "U_CEDILLA";
  CharCode[CharCode["U_MODIFIER_LETTER_LEFT_ARROWHEAD"] = 706] = "U_MODIFIER_LETTER_LEFT_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_RIGHT_ARROWHEAD"] = 707] = "U_MODIFIER_LETTER_RIGHT_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_UP_ARROWHEAD"] = 708] = "U_MODIFIER_LETTER_UP_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_DOWN_ARROWHEAD"] = 709] = "U_MODIFIER_LETTER_DOWN_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING"] = 722] = "U_MODIFIER_LETTER_CENTRED_RIGHT_HALF_RING";
  CharCode[CharCode["U_MODIFIER_LETTER_CENTRED_LEFT_HALF_RING"] = 723] = "U_MODIFIER_LETTER_CENTRED_LEFT_HALF_RING";
  CharCode[CharCode["U_MODIFIER_LETTER_UP_TACK"] = 724] = "U_MODIFIER_LETTER_UP_TACK";
  CharCode[CharCode["U_MODIFIER_LETTER_DOWN_TACK"] = 725] = "U_MODIFIER_LETTER_DOWN_TACK";
  CharCode[CharCode["U_MODIFIER_LETTER_PLUS_SIGN"] = 726] = "U_MODIFIER_LETTER_PLUS_SIGN";
  CharCode[CharCode["U_MODIFIER_LETTER_MINUS_SIGN"] = 727] = "U_MODIFIER_LETTER_MINUS_SIGN";
  CharCode[CharCode["U_BREVE"] = 728] = "U_BREVE";
  CharCode[CharCode["U_DOT_ABOVE"] = 729] = "U_DOT_ABOVE";
  CharCode[CharCode["U_RING_ABOVE"] = 730] = "U_RING_ABOVE";
  CharCode[CharCode["U_OGONEK"] = 731] = "U_OGONEK";
  CharCode[CharCode["U_SMALL_TILDE"] = 732] = "U_SMALL_TILDE";
  CharCode[CharCode["U_DOUBLE_ACUTE_ACCENT"] = 733] = "U_DOUBLE_ACUTE_ACCENT";
  CharCode[CharCode["U_MODIFIER_LETTER_RHOTIC_HOOK"] = 734] = "U_MODIFIER_LETTER_RHOTIC_HOOK";
  CharCode[CharCode["U_MODIFIER_LETTER_CROSS_ACCENT"] = 735] = "U_MODIFIER_LETTER_CROSS_ACCENT";
  CharCode[CharCode["U_MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR"] = 741] = "U_MODIFIER_LETTER_EXTRA_HIGH_TONE_BAR";
  CharCode[CharCode["U_MODIFIER_LETTER_HIGH_TONE_BAR"] = 742] = "U_MODIFIER_LETTER_HIGH_TONE_BAR";
  CharCode[CharCode["U_MODIFIER_LETTER_MID_TONE_BAR"] = 743] = "U_MODIFIER_LETTER_MID_TONE_BAR";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_TONE_BAR"] = 744] = "U_MODIFIER_LETTER_LOW_TONE_BAR";
  CharCode[CharCode["U_MODIFIER_LETTER_EXTRA_LOW_TONE_BAR"] = 745] = "U_MODIFIER_LETTER_EXTRA_LOW_TONE_BAR";
  CharCode[CharCode["U_MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK"] = 746] = "U_MODIFIER_LETTER_YIN_DEPARTING_TONE_MARK";
  CharCode[CharCode["U_MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK"] = 747] = "U_MODIFIER_LETTER_YANG_DEPARTING_TONE_MARK";
  CharCode[CharCode["U_MODIFIER_LETTER_UNASPIRATED"] = 749] = "U_MODIFIER_LETTER_UNASPIRATED";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_DOWN_ARROWHEAD"] = 751] = "U_MODIFIER_LETTER_LOW_DOWN_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_UP_ARROWHEAD"] = 752] = "U_MODIFIER_LETTER_LOW_UP_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_LEFT_ARROWHEAD"] = 753] = "U_MODIFIER_LETTER_LOW_LEFT_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_RIGHT_ARROWHEAD"] = 754] = "U_MODIFIER_LETTER_LOW_RIGHT_ARROWHEAD";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_RING"] = 755] = "U_MODIFIER_LETTER_LOW_RING";
  CharCode[CharCode["U_MODIFIER_LETTER_MIDDLE_GRAVE_ACCENT"] = 756] = "U_MODIFIER_LETTER_MIDDLE_GRAVE_ACCENT";
  CharCode[CharCode["U_MODIFIER_LETTER_MIDDLE_DOUBLE_GRAVE_ACCENT"] = 757] = "U_MODIFIER_LETTER_MIDDLE_DOUBLE_GRAVE_ACCENT";
  CharCode[CharCode["U_MODIFIER_LETTER_MIDDLE_DOUBLE_ACUTE_ACCENT"] = 758] = "U_MODIFIER_LETTER_MIDDLE_DOUBLE_ACUTE_ACCENT";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_TILDE"] = 759] = "U_MODIFIER_LETTER_LOW_TILDE";
  CharCode[CharCode["U_MODIFIER_LETTER_RAISED_COLON"] = 760] = "U_MODIFIER_LETTER_RAISED_COLON";
  CharCode[CharCode["U_MODIFIER_LETTER_BEGIN_HIGH_TONE"] = 761] = "U_MODIFIER_LETTER_BEGIN_HIGH_TONE";
  CharCode[CharCode["U_MODIFIER_LETTER_END_HIGH_TONE"] = 762] = "U_MODIFIER_LETTER_END_HIGH_TONE";
  CharCode[CharCode["U_MODIFIER_LETTER_BEGIN_LOW_TONE"] = 763] = "U_MODIFIER_LETTER_BEGIN_LOW_TONE";
  CharCode[CharCode["U_MODIFIER_LETTER_END_LOW_TONE"] = 764] = "U_MODIFIER_LETTER_END_LOW_TONE";
  CharCode[CharCode["U_MODIFIER_LETTER_SHELF"] = 765] = "U_MODIFIER_LETTER_SHELF";
  CharCode[CharCode["U_MODIFIER_LETTER_OPEN_SHELF"] = 766] = "U_MODIFIER_LETTER_OPEN_SHELF";
  CharCode[CharCode["U_MODIFIER_LETTER_LOW_LEFT_ARROW"] = 767] = "U_MODIFIER_LETTER_LOW_LEFT_ARROW";
  CharCode[CharCode["U_GREEK_LOWER_NUMERAL_SIGN"] = 885] = "U_GREEK_LOWER_NUMERAL_SIGN";
  CharCode[CharCode["U_GREEK_TONOS"] = 900] = "U_GREEK_TONOS";
  CharCode[CharCode["U_GREEK_DIALYTIKA_TONOS"] = 901] = "U_GREEK_DIALYTIKA_TONOS";
  CharCode[CharCode["U_GREEK_KORONIS"] = 8125] = "U_GREEK_KORONIS";
  CharCode[CharCode["U_GREEK_PSILI"] = 8127] = "U_GREEK_PSILI";
  CharCode[CharCode["U_GREEK_PERISPOMENI"] = 8128] = "U_GREEK_PERISPOMENI";
  CharCode[CharCode["U_GREEK_DIALYTIKA_AND_PERISPOMENI"] = 8129] = "U_GREEK_DIALYTIKA_AND_PERISPOMENI";
  CharCode[CharCode["U_GREEK_PSILI_AND_VARIA"] = 8141] = "U_GREEK_PSILI_AND_VARIA";
  CharCode[CharCode["U_GREEK_PSILI_AND_OXIA"] = 8142] = "U_GREEK_PSILI_AND_OXIA";
  CharCode[CharCode["U_GREEK_PSILI_AND_PERISPOMENI"] = 8143] = "U_GREEK_PSILI_AND_PERISPOMENI";
  CharCode[CharCode["U_GREEK_DASIA_AND_VARIA"] = 8157] = "U_GREEK_DASIA_AND_VARIA";
  CharCode[CharCode["U_GREEK_DASIA_AND_OXIA"] = 8158] = "U_GREEK_DASIA_AND_OXIA";
  CharCode[CharCode["U_GREEK_DASIA_AND_PERISPOMENI"] = 8159] = "U_GREEK_DASIA_AND_PERISPOMENI";
  CharCode[CharCode["U_GREEK_DIALYTIKA_AND_VARIA"] = 8173] = "U_GREEK_DIALYTIKA_AND_VARIA";
  CharCode[CharCode["U_GREEK_DIALYTIKA_AND_OXIA"] = 8174] = "U_GREEK_DIALYTIKA_AND_OXIA";
  CharCode[CharCode["U_GREEK_VARIA"] = 8175] = "U_GREEK_VARIA";
  CharCode[CharCode["U_GREEK_OXIA"] = 8189] = "U_GREEK_OXIA";
  CharCode[CharCode["U_GREEK_DASIA"] = 8190] = "U_GREEK_DASIA";
  CharCode[CharCode["U_OVERLINE"] = 8254] = "U_OVERLINE";
  CharCode[CharCode["UTF8_BOM"] = 65279] = "UTF8_BOM";
  return CharCode;
}({});
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/strings.js
/* eslint-disable no-control-regex */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


function isFalsyOrWhitespace(str) {
  if (!str || typeof str !== 'string') {
    return true;
  }
  return str.trim().length === 0;
}
var _formatRegexp = /{(\d+)}/g;

/**
 * Helper to produce a string with a variable number of arguments. Insert variable segments
 * into the string using the {n} notation where N is the index of the argument following the string.
 * @param value string to which formatting is applied
 * @param args replacements for {n}-entries
 */
function format(value) {
  for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
    args[_key - 1] = arguments[_key];
  }
  if (args.length === 0) {
    return value;
  }
  return value.replace(_formatRegexp, function (match, group) {
    var idx = parseInt(group, 10);
    // eslint-disable-next-line no-restricted-globals
    return isNaN(idx) || idx < 0 || idx >= args.length ? match : args[idx];
  });
}

/**
 * Converts HTML characters inside the string to use entities instead. Makes the string safe from
 * being used e.g. in HTMLElement.innerHTML.
 */
function strings_escape(html) {
  return html.replace(/[<>&]/g, function (match) {
    switch (match) {
      case '<':
        return '&lt;';
      case '>':
        return '&gt;';
      case '&':
        return '&amp;';
      default:
        return match;
    }
  });
}

/**
 * Escapes regular expression characters in a given string
 */
function escapeRegExpCharacters(value) {
  // eslint-disable-next-line no-useless-escape
  return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, '\\$&');
}

/**
 * Counts how often `character` occurs inside `value`.
 */
function count(value, character) {
  var result = 0;
  var ch = character.charCodeAt(0);
  for (var i = value.length - 1; i >= 0; i--) {
    if (value.charCodeAt(i) === ch) {
      result++;
    }
  }
  return result;
}
function truncate(value, maxLength) {
  var suffix = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : '…';
  if (value.length <= maxLength) {
    return value;
  }
  return "".concat(value.substr(0, maxLength)).concat(suffix);
}

/**
 * Removes all occurrences of needle from the beginning and end of haystack.
 * @param haystack string to trim
 * @param needle the thing to trim (default is a blank)
 */
function trim(haystack) {
  var needle = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' ';
  var trimmed = ltrim(haystack, needle);
  return rtrim(trimmed, needle);
}

/**
 * Removes all occurrences of needle from the beginning of haystack.
 * @param haystack string to trim
 * @param needle the thing to trim
 */
function ltrim(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  var needleLen = needle.length;
  if (needleLen === 0 || haystack.length === 0) {
    return haystack;
  }
  var offset = 0;
  while (haystack.indexOf(needle, offset) === offset) {
    offset += needleLen;
  }
  return haystack.substring(offset);
}

/**
 * Removes all occurrences of needle from the end of haystack.
 * @param haystack string to trim
 * @param needle the thing to trim
 */
function rtrim(haystack, needle) {
  if (!haystack || !needle) {
    return haystack;
  }
  var needleLen = needle.length;
  var haystackLen = haystack.length;
  if (needleLen === 0 || haystackLen === 0) {
    return haystack;
  }
  var offset = haystackLen;
  var idx = -1;

  // eslint-disable-next-line no-constant-condition
  while (true) {
    idx = haystack.lastIndexOf(needle, offset - 1);
    if (idx === -1 || idx + needleLen !== offset) {
      break;
    }
    if (idx === 0) {
      return '';
    }
    offset = idx;
  }
  return haystack.substring(0, offset);
}
function convertSimple2RegExpPattern(pattern) {
  // eslint-disable-next-line no-useless-escape
  return pattern
  // eslint-disable-next-line no-useless-escape
  .replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g, '\\$&')
  // eslint-disable-next-line no-useless-escape
  .replace(/[\*]/g, '.*');
}
function stripWildcards(pattern) {
  return pattern.replace(/\*/g, '');
}
function createRegExp(searchString, isRegex) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  if (!searchString) {
    throw new Error('Cannot create regex from empty string');
  }
  if (!isRegex) {
    searchString = escapeRegExpCharacters(searchString);
  }
  if (options.wholeWord) {
    if (!/\B/.test(searchString.charAt(0))) {
      searchString = "\\b".concat(searchString);
    }
    if (!/\B/.test(searchString.charAt(searchString.length - 1))) {
      searchString += '\\b';
    }
  }
  var modifiers = '';
  if (options.global) {
    modifiers += 'g';
  }
  if (!options.matchCase) {
    modifiers += 'i';
  }
  if (options.multiline) {
    modifiers += 'm';
  }
  if (options.unicode) {
    modifiers += 'u';
  }
  return new RegExp(searchString, modifiers);
}
function regExpLeadsToEndlessLoop(regexp) {
  // Exit early if it's one of these special cases which are meant to match
  // against an empty string
  if (regexp.source === '^' || regexp.source === '^$' || regexp.source === '$' || regexp.source === '^\\s*$') {
    return false;
  }

  // We check against an empty string. If the regular expression doesn't advance
  // (e.g. ends in an endless loop) it will match an empty string.
  var match = regexp.exec('');
  return !!(match && regexp.lastIndex === 0);
}
function regExpContainsBackreference(regexpValue) {
  return !!regexpValue.match(/([^\\]|^)(\\\\)*\\\d+/);
}
function regExpFlags(regexp) {
  return (regexp.global ? 'g' : '') + (regexp.ignoreCase ? 'i' : '') + (regexp.multiline ? 'm' : '') + (regexp /* standalone editor compilation */.unicode ? 'u' : '');
}
function splitLines(str) {
  return str.split(/\r\n|\r|\n/);
}

/**
 * Returns first index of the string that is not whitespace.
 * If string is empty or contains only whitespaces, returns -1
 */
function firstNonWhitespaceIndex(str) {
  for (var i = 0, len = str.length; i < len; i++) {
    var chCode = str.charCodeAt(i);
    if (chCode !== CharCode.Space && chCode !== CharCode.Tab) {
      return i;
    }
  }
  return -1;
}

/**
 * Returns the leading whitespace of the string.
 * If the string contains only whitespaces, returns entire string
 */
function getLeadingWhitespace(str) {
  var start = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
  var end = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : str.length;
  for (var i = start; i < end; i++) {
    var chCode = str.charCodeAt(i);
    if (chCode !== CharCode.Space && chCode !== CharCode.Tab) {
      return str.substring(start, i);
    }
  }
  return str.substring(start, end);
}

/**
 * Returns last index of the string that is not whitespace.
 * If string is empty or contains only whitespaces, returns -1
 */
function lastNonWhitespaceIndex(str) {
  var startIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : str.length - 1;
  for (var i = startIndex; i >= 0; i--) {
    var chCode = str.charCodeAt(i);
    if (chCode !== CharCode.Space && chCode !== CharCode.Tab) {
      return i;
    }
  }
  return -1;
}
function compare(a, b) {
  if (a < b) {
    return -1;
  }
  if (a > b) {
    return 1;
  }
  return 0;
}
function compareSubstring(a, b) {
  var aStart = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  var aEnd = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : a.length;
  var bStart = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
  var bEnd = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : b.length;
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    var codeA = a.charCodeAt(aStart);
    var codeB = b.charCodeAt(bStart);
    if (codeA < codeB) {
      return -1;
    }
    if (codeA > codeB) {
      return 1;
    }
  }
  var aLen = aEnd - aStart;
  var bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  }
  if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function compareIgnoreCase(a, b) {
  return compareSubstringIgnoreCase(a, b, 0, a.length, 0, b.length);
}
function compareSubstringIgnoreCase(a, b) {
  var aStart = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;
  var aEnd = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : a.length;
  var bStart = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : 0;
  var bEnd = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : b.length;
  for (; aStart < aEnd && bStart < bEnd; aStart++, bStart++) {
    var codeA = a.charCodeAt(aStart);
    var codeB = b.charCodeAt(bStart);
    if (codeA === codeB) {
      // equal
      continue;
    }
    var diff = codeA - codeB;
    if (diff === 32 && isUpperAsciiLetter(codeB)) {
      //codeB =[65-90] && codeA =[97-122]
      continue;
    } else if (diff === -32 && isUpperAsciiLetter(codeA)) {
      //codeB =[97-122] && codeA =[65-90]
      continue;
    }
    if (isLowerAsciiLetter(codeA) && isLowerAsciiLetter(codeB)) {
      //
      return diff;
    }
    return compareSubstring(a.toLowerCase(), b.toLowerCase(), aStart, aEnd, bStart, bEnd);
  }
  var aLen = aEnd - aStart;
  var bLen = bEnd - bStart;
  if (aLen < bLen) {
    return -1;
  }
  if (aLen > bLen) {
    return 1;
  }
  return 0;
}
function isLowerAsciiLetter(code) {
  return code >= CharCode.a && code <= CharCode.z;
}
function isUpperAsciiLetter(code) {
  return code >= CharCode.A && code <= CharCode.Z;
}
function isAsciiLetter(code) {
  return isLowerAsciiLetter(code) || isUpperAsciiLetter(code);
}
function equalsIgnoreCase(a, b) {
  return a.length === b.length && doEqualsIgnoreCase(a, b);
}
function doEqualsIgnoreCase(a, b) {
  var stopAt = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : a.length;
  for (var i = 0; i < stopAt; i++) {
    var codeA = a.charCodeAt(i);
    var codeB = b.charCodeAt(i);
    if (codeA === codeB) {
      continue;
    }

    // a-z A-Z
    if (isAsciiLetter(codeA) && isAsciiLetter(codeB)) {
      var diff = Math.abs(codeA - codeB);
      if (diff !== 0 && diff !== 32) {
        return false;
      }
    }

    // Any other charcode
    else if (String.fromCharCode(codeA).toLowerCase() !== String.fromCharCode(codeB).toLowerCase()) {
      return false;
    }
  }
  return true;
}
function startsWithIgnoreCase(str, candidate) {
  var candidateLength = candidate.length;
  if (candidate.length > str.length) {
    return false;
  }
  return doEqualsIgnoreCase(str, candidate, candidateLength);
}

/**
 * @returns the length of the common prefix of the two strings.
 */
function commonPrefixLength(a, b) {
  var i;
  var len = Math.min(a.length, b.length);
  for (i = 0; i < len; i++) {
    if (a.charCodeAt(i) !== b.charCodeAt(i)) {
      return i;
    }
  }
  return len;
}

/**
 * @returns the length of the common suffix of the two strings.
 */
function commonSuffixLength(a, b) {
  var i;
  var len = Math.min(a.length, b.length);
  var aLastIndex = a.length - 1;
  var bLastIndex = b.length - 1;
  for (i = 0; i < len; i++) {
    if (a.charCodeAt(aLastIndex - i) !== b.charCodeAt(bLastIndex - i)) {
      return i;
    }
  }
  return len;
}

/**
 * See http://en.wikipedia.org/wiki/Surrogate_pair
 */
function isHighSurrogate(charCode) {
  return charCode >= 0xd800 && charCode <= 0xdbff;
}

/**
 * See http://en.wikipedia.org/wiki/Surrogate_pair
 */
function isLowSurrogate(charCode) {
  return charCode >= 0xdc00 && charCode <= 0xdfff;
}

/**
 * See http://en.wikipedia.org/wiki/Surrogate_pair
 */
function computeCodePoint(highSurrogate, lowSurrogate) {
  return (highSurrogate - 0xd800 << 10) + (lowSurrogate - 0xdc00) + 0x10000;
}

/**
 * get the code point that begins at offset `offset`
 */
function getNextCodePoint(str, len, offset) {
  var charCode = str.charCodeAt(offset);
  if (isHighSurrogate(charCode) && offset + 1 < len) {
    var nextCharCode = str.charCodeAt(offset + 1);
    if (isLowSurrogate(nextCharCode)) {
      return computeCodePoint(charCode, nextCharCode);
    }
  }
  return charCode;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/contextkey.js
var _ContextKeyFalseExpr, _ContextKeyTrueExpr;
function contextkey_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function contextkey_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? contextkey_ownKeys(Object(t), !0).forEach(function (r) { contextkey_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : contextkey_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function contextkey_defineProperty(obj, key, value) { key = contextkey_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) _setPrototypeOf(subClass, superClass); }
function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }
function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }
function _possibleConstructorReturn(self, call) { if (call && (contextkey_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return _assertThisInitialized(self); }
function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || contextkey_unsupportedIterableToArray(arr) || _nonIterableSpread(); }
function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return contextkey_arrayLikeToArray(arr); }
function contextkey_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = contextkey_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function contextkey_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return contextkey_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return contextkey_arrayLikeToArray(o, minLen); }
function contextkey_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function contextkey_typeof(o) { "@babel/helpers - typeof"; return contextkey_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, contextkey_typeof(o); }
function contextkey_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function contextkey_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, contextkey_toPropertyKey(descriptor.key), descriptor); } }
function contextkey_createClass(Constructor, protoProps, staticProps) { if (protoProps) contextkey_defineProperties(Constructor.prototype, protoProps); if (staticProps) contextkey_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function contextkey_toPropertyKey(t) { var i = contextkey_toPrimitive(t, "string"); return "symbol" == contextkey_typeof(i) ? i : String(i); }
function contextkey_toPrimitive(t, r) { if ("object" != contextkey_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != contextkey_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


// import { createDecorator } from 'vs/platform/instantiation/common/instantiation';


var _userAgent = platform/* userAgent */.WE || '';
var STATIC_VALUES = new Map();
STATIC_VALUES.set('false', false);
STATIC_VALUES.set('true', true);
STATIC_VALUES.set('isMac', platform/* isMacintosh */.dz);
STATIC_VALUES.set('isLinux', platform/* isLinux */.IJ);
STATIC_VALUES.set('isWindows', platform/* isWindows */.ED);
STATIC_VALUES.set('isWeb', platform/* isWeb */.$L);
STATIC_VALUES.set('isMacNative', platform/* isMacintosh */.dz && !platform/* isWeb */.$L);
STATIC_VALUES.set('isEdge', _userAgent.indexOf('Edg/') >= 0);
STATIC_VALUES.set('isFirefox', _userAgent.indexOf('Firefox') >= 0);
STATIC_VALUES.set('isChrome', _userAgent.indexOf('Chrome') >= 0);
STATIC_VALUES.set('isSafari', _userAgent.indexOf('Safari') >= 0);
STATIC_VALUES.set('isIPad', _userAgent.indexOf('iPad') >= 0);
var contextkey_hasOwnProperty = Object.prototype.hasOwnProperty;
var ContextKeyExprType = /*#__PURE__*/function (ContextKeyExprType) {
  ContextKeyExprType[ContextKeyExprType["False"] = 0] = "False";
  ContextKeyExprType[ContextKeyExprType["True"] = 1] = "True";
  ContextKeyExprType[ContextKeyExprType["Defined"] = 2] = "Defined";
  ContextKeyExprType[ContextKeyExprType["Not"] = 3] = "Not";
  ContextKeyExprType[ContextKeyExprType["Equals"] = 4] = "Equals";
  ContextKeyExprType[ContextKeyExprType["NotEquals"] = 5] = "NotEquals";
  ContextKeyExprType[ContextKeyExprType["And"] = 6] = "And";
  ContextKeyExprType[ContextKeyExprType["Regex"] = 7] = "Regex";
  ContextKeyExprType[ContextKeyExprType["NotRegex"] = 8] = "NotRegex";
  ContextKeyExprType[ContextKeyExprType["Or"] = 9] = "Or";
  ContextKeyExprType[ContextKeyExprType["In"] = 10] = "In";
  ContextKeyExprType[ContextKeyExprType["NotIn"] = 11] = "NotIn";
  ContextKeyExprType[ContextKeyExprType["Greater"] = 12] = "Greater";
  ContextKeyExprType[ContextKeyExprType["GreaterEquals"] = 13] = "GreaterEquals";
  ContextKeyExprType[ContextKeyExprType["Smaller"] = 14] = "Smaller";
  ContextKeyExprType[ContextKeyExprType["SmallerEquals"] = 15] = "SmallerEquals";
  return ContextKeyExprType;
}({});
var ContextKeyExpr = /*#__PURE__*/function () {
  function ContextKeyExpr() {
    contextkey_classCallCheck(this, ContextKeyExpr);
  }
  contextkey_createClass(ContextKeyExpr, null, [{
    key: "false",
    value: function _false() {
      return ContextKeyFalseExpr.INSTANCE;
    }
  }, {
    key: "true",
    value: function _true() {
      return ContextKeyTrueExpr.INSTANCE;
    }
  }, {
    key: "has",
    value: function has(key) {
      return ContextKeyDefinedExpr.create(key);
    }
  }, {
    key: "equals",
    value: function equals(key, value) {
      return ContextKeyEqualsExpr.create(key, value);
    }
  }, {
    key: "notEquals",
    value: function notEquals(key, value) {
      return ContextKeyNotEqualsExpr.create(key, value);
    }
  }, {
    key: "regex",
    value: function regex(key, value) {
      return ContextKeyRegexExpr.create(key, value);
    }
  }, {
    key: "in",
    value: function _in(key, value) {
      return ContextKeyInExpr.create(key, value);
    }
  }, {
    key: "not",
    value: function not(key) {
      return ContextKeyNotExpr.create(key);
    }
  }, {
    key: "and",
    value: function and() {
      for (var _len = arguments.length, expr = new Array(_len), _key = 0; _key < _len; _key++) {
        expr[_key] = arguments[_key];
      }
      return ContextKeyAndExpr.create(expr);
    }
  }, {
    key: "or",
    value: function or() {
      for (var _len2 = arguments.length, expr = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        expr[_key2] = arguments[_key2];
      }
      return ContextKeyOrExpr.create(expr);
    }
  }, {
    key: "greater",
    value: function greater(key, value) {
      return ContextKeyGreaterExpr.create(key, value);
    }
  }, {
    key: "less",
    value: function less(key, value) {
      return ContextKeySmallerExpr.create(key, value);
    }
  }, {
    key: "deserialize",
    value: function deserialize(serialized) {
      var strict = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
      if (!serialized) {
        return undefined;
      }
      return this._deserializeOrExpression(serialized, strict);
    }
  }, {
    key: "_deserializeOrExpression",
    value: function _deserializeOrExpression(serialized, strict) {
      var _this = this;
      var pieces = serialized.split('||');
      return ContextKeyOrExpr.create(pieces.map(function (p) {
        return _this._deserializeAndExpression(p, strict);
      }));
    }
  }, {
    key: "_deserializeAndExpression",
    value: function _deserializeAndExpression(serialized, strict) {
      var _this2 = this;
      var pieces = serialized.split('&&');
      return ContextKeyAndExpr.create(pieces.map(function (p) {
        return _this2._deserializeOne(p, strict);
      }));
    }
  }, {
    key: "_deserializeOne",
    value: function _deserializeOne(serializedOne, strict) {
      serializedOne = serializedOne.trim();
      if (serializedOne.indexOf('!=') >= 0) {
        var pieces = serializedOne.split('!=');
        return ContextKeyNotEqualsExpr.create(pieces[0].trim(), this._deserializeValue(pieces[1], strict));
      }
      if (serializedOne.indexOf('==') >= 0) {
        var _pieces = serializedOne.split('==');
        return ContextKeyEqualsExpr.create(_pieces[0].trim(), this._deserializeValue(_pieces[1], strict));
      }
      if (serializedOne.indexOf('=~') >= 0) {
        var _pieces2 = serializedOne.split('=~');
        return ContextKeyRegexExpr.create(_pieces2[0].trim(), this._deserializeRegexValue(_pieces2[1], strict));
      }
      if (serializedOne.indexOf(' in ') >= 0) {
        var _pieces3 = serializedOne.split(' in ');
        return ContextKeyInExpr.create(_pieces3[0].trim(), _pieces3[1].trim());
      }
      if (/^[^<=>]+>=[^<=>]+$/.test(serializedOne)) {
        var _pieces4 = serializedOne.split('>=');
        return ContextKeyGreaterEqualsExpr.create(_pieces4[0].trim(), _pieces4[1].trim());
      }
      if (/^[^<=>]+>[^<=>]+$/.test(serializedOne)) {
        var _pieces5 = serializedOne.split('>');
        return ContextKeyGreaterExpr.create(_pieces5[0].trim(), _pieces5[1].trim());
      }
      if (/^[^<=>]+<=[^<=>]+$/.test(serializedOne)) {
        var _pieces6 = serializedOne.split('<=');
        return ContextKeySmallerEqualsExpr.create(_pieces6[0].trim(), _pieces6[1].trim());
      }
      if (/^[^<=>]+<[^<=>]+$/.test(serializedOne)) {
        var _pieces7 = serializedOne.split('<');
        return ContextKeySmallerExpr.create(_pieces7[0].trim(), _pieces7[1].trim());
      }

      // eslint-disable-next-line no-useless-escape
      if (/^\!\s*/.test(serializedOne)) {
        return ContextKeyNotExpr.create(serializedOne.substr(1).trim());
      }
      return ContextKeyDefinedExpr.create(serializedOne);
    }
  }, {
    key: "_deserializeValue",
    value: function _deserializeValue(serializedValue, _strict) {
      serializedValue = serializedValue.trim();
      if (serializedValue === 'true') {
        return true;
      }
      if (serializedValue === 'false') {
        return false;
      }
      var m = /^'([^']*)'$/.exec(serializedValue);
      if (m) {
        return m[1].trim();
      }
      return serializedValue;
    }
  }, {
    key: "_deserializeRegexValue",
    value: function _deserializeRegexValue(serializedValue, strict) {
      if (isFalsyOrWhitespace(serializedValue)) {
        if (strict) {
          throw new Error('missing regexp-value for =~-expression');
        } else {
          console.warn('missing regexp-value for =~-expression');
        }
        return null;
      }
      var start = serializedValue.indexOf('/');
      var end = serializedValue.lastIndexOf('/');
      if (start === end || start < 0 /* || to < 0 */) {
        if (strict) {
          throw new Error("bad regexp-value '".concat(serializedValue, "', missing /-enclosure"));
        } else {
          console.warn("bad regexp-value '".concat(serializedValue, "', missing /-enclosure"));
        }
        return null;
      }
      var value = serializedValue.slice(start + 1, end);
      var caseIgnoreFlag = serializedValue[end + 1] === 'i' ? 'i' : '';
      try {
        return new RegExp(value, caseIgnoreFlag);
      } catch (e) {
        if (strict) {
          throw new Error("bad regexp-value '".concat(serializedValue, "', parse error: ").concat(e));
        } else {
          console.warn("bad regexp-value '".concat(serializedValue, "', parse error: ").concat(e));
        }
        return null;
      }
    }
  }]);
  return ContextKeyExpr;
}();
function _cmp(a, b) {
  return a.cmp(b);
}
var ContextKeyFalseExpr = /*#__PURE__*/function () {
  function ContextKeyFalseExpr() {
    contextkey_classCallCheck(this, ContextKeyFalseExpr);
    this.type = ContextKeyExprType.False;
  } //
  contextkey_createClass(ContextKeyFalseExpr, [{
    key: "cmp",
    value: function cmp(other) {
      return this.type - other.type;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return other.type === this.type;
    }
  }, {
    key: "evaluate",
    value: function evaluate(_context) {
      return false;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return 'false';
    }
  }, {
    key: "keys",
    value: function keys() {
      return [];
    }
  }, {
    key: "map",
    value: function map(_mapFnc) {
      return this;
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyTrueExpr.INSTANCE;
    }
  }]);
  return ContextKeyFalseExpr;
}();
_ContextKeyFalseExpr = ContextKeyFalseExpr;
ContextKeyFalseExpr.INSTANCE = new _ContextKeyFalseExpr();
var ContextKeyTrueExpr = /*#__PURE__*/function () {
  function ContextKeyTrueExpr() {
    contextkey_classCallCheck(this, ContextKeyTrueExpr);
    this.type = ContextKeyExprType.True;
  } //
  contextkey_createClass(ContextKeyTrueExpr, [{
    key: "cmp",
    value: function cmp(other) {
      return this.type - other.type;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return other.type === this.type;
    }
  }, {
    key: "evaluate",
    value: function evaluate(_context) {
      return true;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return 'true';
    }
  }, {
    key: "keys",
    value: function keys() {
      return [];
    }
  }, {
    key: "map",
    value: function map(_mapFnc) {
      return this;
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyFalseExpr.INSTANCE;
    }
  }]);
  return ContextKeyTrueExpr;
}();
_ContextKeyTrueExpr = ContextKeyTrueExpr;
ContextKeyTrueExpr.INSTANCE = new _ContextKeyTrueExpr();
var ContextKeyDefinedExpr = /*#__PURE__*/function () {
  function ContextKeyDefinedExpr(key) {
    contextkey_classCallCheck(this, ContextKeyDefinedExpr);
    this.type = ContextKeyExprType.Defined;
    this.key = key;
  }
  contextkey_createClass(ContextKeyDefinedExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp1(this.key, other.key);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return !!context.getValue(this.key);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return this.key;
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapDefined(this.key);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyNotExpr.create(this.key);
    }
  }], [{
    key: "create",
    value: function create(key) {
      var staticValue = STATIC_VALUES.get(key);
      if (typeof staticValue === 'boolean') {
        return staticValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
      }
      return new ContextKeyDefinedExpr(key);
    }
  }]);
  return ContextKeyDefinedExpr;
}();
var ContextKeyEqualsExpr = /*#__PURE__*/function () {
  function ContextKeyEqualsExpr(key, value) {
    contextkey_classCallCheck(this, ContextKeyEqualsExpr);
    this.type = ContextKeyExprType.Equals;
    this.key = key;
    this.value = value;
  }
  contextkey_createClass(ContextKeyEqualsExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.value, other.key, other.value);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.value === other.value;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      // Intentional ==
      // eslint-disable-next-line eqeqeq
      return context.getValue(this.key) == this.value;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " == '").concat(this.value, "'");
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapEquals(this.key, this.value);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyNotEqualsExpr.create(this.key, this.value);
    }
  }], [{
    key: "create",
    value: function create(key, value) {
      if (typeof value === 'boolean') {
        return value ? ContextKeyDefinedExpr.create(key) : ContextKeyNotExpr.create(key);
      }
      var staticValue = STATIC_VALUES.get(key);
      if (typeof staticValue === 'boolean') {
        var trueValue = staticValue ? 'true' : 'false';
        return value === trueValue ? ContextKeyTrueExpr.INSTANCE : ContextKeyFalseExpr.INSTANCE;
      }
      return new ContextKeyEqualsExpr(key, value);
    }
  }]);
  return ContextKeyEqualsExpr;
}();
var ContextKeyInExpr = /*#__PURE__*/function () {
  function ContextKeyInExpr(key, valueKey) {
    contextkey_classCallCheck(this, ContextKeyInExpr);
    this.type = ContextKeyExprType.In;
    this.key = key;
    this.valueKey = valueKey;
  }
  contextkey_createClass(ContextKeyInExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.valueKey, other.key, other.valueKey);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.valueKey === other.valueKey;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      var source = context.getValue(this.valueKey);
      var item = context.getValue(this.key);
      if (Array.isArray(source)) {
        return source.indexOf(item) >= 0;
      }
      if (typeof item === 'string' && contextkey_typeof(source) === 'object' && source !== null) {
        return contextkey_hasOwnProperty.call(source, item);
      }
      return false;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " in '").concat(this.valueKey, "'");
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key, this.valueKey];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapIn(this.key, this.valueKey);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyNotInExpr.create(this);
    }
  }], [{
    key: "create",
    value: function create(key, valueKey) {
      return new ContextKeyInExpr(key, valueKey);
    }
  }]);
  return ContextKeyInExpr;
}();
var ContextKeyNotInExpr = /*#__PURE__*/function () {
  function ContextKeyNotInExpr(_actual) {
    contextkey_classCallCheck(this, ContextKeyNotInExpr);
    this.type = ContextKeyExprType.NotIn;
    //
    this._actual = _actual;
  }
  contextkey_createClass(ContextKeyNotInExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return this._actual.cmp(other._actual);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this._actual.equals(other._actual);
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return !this._actual.evaluate(context);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      throw new Error('Method not implemented.');
    }
  }, {
    key: "keys",
    value: function keys() {
      return this._actual.keys();
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return new ContextKeyNotInExpr(this._actual.map(mapFnc));
    }
  }, {
    key: "negate",
    value: function negate() {
      return this._actual;
    }
  }], [{
    key: "create",
    value: function create(actual) {
      return new ContextKeyNotInExpr(actual);
    }
  }]);
  return ContextKeyNotInExpr;
}();
var ContextKeyNotEqualsExpr = /*#__PURE__*/function () {
  function ContextKeyNotEqualsExpr(key, value) {
    contextkey_classCallCheck(this, ContextKeyNotEqualsExpr);
    this.type = ContextKeyExprType.NotEquals;
    this.key = key;
    this.value = value;
  }
  contextkey_createClass(ContextKeyNotEqualsExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.value, other.key, other.value);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.value === other.value;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      // Intentional !=
      // eslint-disable-next-line eqeqeq
      return context.getValue(this.key) != this.value;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " != '").concat(this.value, "'");
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapNotEquals(this.key, this.value);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyEqualsExpr.create(this.key, this.value);
    }
  }], [{
    key: "create",
    value: function create(key, value) {
      if (typeof value === 'boolean') {
        if (value) {
          return ContextKeyNotExpr.create(key);
        }
        return ContextKeyDefinedExpr.create(key);
      }
      var staticValue = STATIC_VALUES.get(key);
      if (typeof staticValue === 'boolean') {
        var falseValue = staticValue ? 'true' : 'false';
        return value === falseValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE;
      }
      return new ContextKeyNotEqualsExpr(key, value);
    }
  }]);
  return ContextKeyNotEqualsExpr;
}();
var ContextKeyNotExpr = /*#__PURE__*/function () {
  function ContextKeyNotExpr(key) {
    contextkey_classCallCheck(this, ContextKeyNotExpr);
    this.type = ContextKeyExprType.Not;
    this.key = key;
  }
  contextkey_createClass(ContextKeyNotExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp1(this.key, other.key);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return !context.getValue(this.key);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "!".concat(this.key);
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapNot(this.key);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyDefinedExpr.create(this.key);
    }
  }], [{
    key: "create",
    value: function create(key) {
      var staticValue = STATIC_VALUES.get(key);
      if (typeof staticValue === 'boolean') {
        return staticValue ? ContextKeyFalseExpr.INSTANCE : ContextKeyTrueExpr.INSTANCE;
      }
      return new ContextKeyNotExpr(key);
    }
  }]);
  return ContextKeyNotExpr;
}();
var ContextKeyGreaterExpr = /*#__PURE__*/function () {
  function ContextKeyGreaterExpr(key, value) {
    contextkey_classCallCheck(this, ContextKeyGreaterExpr);
    this.type = ContextKeyExprType.Greater;
    this.key = key;
    this.value = value;
  }
  contextkey_createClass(ContextKeyGreaterExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.value, other.key, other.value);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.value === other.value;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return parseFloat(context.getValue(this.key)) > parseFloat(this.value);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " > ").concat(this.value);
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapGreater(this.key, this.value);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeySmallerEqualsExpr.create(this.key, this.value);
    }
  }], [{
    key: "create",
    value: function create(key, value) {
      return new ContextKeyGreaterExpr(key, value);
    }
  }]);
  return ContextKeyGreaterExpr;
}();
var ContextKeyGreaterEqualsExpr = /*#__PURE__*/function () {
  function ContextKeyGreaterEqualsExpr(key, value) {
    contextkey_classCallCheck(this, ContextKeyGreaterEqualsExpr);
    this.type = ContextKeyExprType.GreaterEquals;
    this.key = key;
    this.value = value;
  }
  contextkey_createClass(ContextKeyGreaterEqualsExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.value, other.key, other.value);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.value === other.value;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return parseFloat(context.getValue(this.key)) >= parseFloat(this.value);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " >= ").concat(this.value);
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapGreaterEquals(this.key, this.value);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeySmallerExpr.create(this.key, this.value);
    }
  }], [{
    key: "create",
    value: function create(key, value) {
      return new ContextKeyGreaterEqualsExpr(key, value);
    }
  }]);
  return ContextKeyGreaterEqualsExpr;
}();
var ContextKeySmallerExpr = /*#__PURE__*/function () {
  function ContextKeySmallerExpr(key, value) {
    contextkey_classCallCheck(this, ContextKeySmallerExpr);
    this.type = ContextKeyExprType.Smaller;
    this.key = key;
    this.value = value;
  }
  contextkey_createClass(ContextKeySmallerExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.value, other.key, other.value);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.value === other.value;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return parseFloat(context.getValue(this.key)) < parseFloat(this.value);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " < ").concat(this.value);
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapSmaller(this.key, this.value);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyGreaterEqualsExpr.create(this.key, this.value);
    }
  }], [{
    key: "create",
    value: function create(key, value) {
      return new ContextKeySmallerExpr(key, value);
    }
  }]);
  return ContextKeySmallerExpr;
}();
var ContextKeySmallerEqualsExpr = /*#__PURE__*/function () {
  function ContextKeySmallerEqualsExpr(key, value) {
    contextkey_classCallCheck(this, ContextKeySmallerEqualsExpr);
    this.type = ContextKeyExprType.SmallerEquals;
    this.key = key;
    this.value = value;
  }
  contextkey_createClass(ContextKeySmallerEqualsExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return cmp2(this.key, this.value, other.key, other.value);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this.key === other.key && this.value === other.value;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return parseFloat(context.getValue(this.key)) <= parseFloat(this.value);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return "".concat(this.key, " <= ").concat(this.value);
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapSmallerEquals(this.key, this.value);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyGreaterExpr.create(this.key, this.value);
    }
  }], [{
    key: "create",
    value: function create(key, value) {
      return new ContextKeySmallerEqualsExpr(key, value);
    }
  }]);
  return ContextKeySmallerEqualsExpr;
}();
var ContextKeyRegexExpr = /*#__PURE__*/function () {
  function ContextKeyRegexExpr(key, regexp) {
    contextkey_classCallCheck(this, ContextKeyRegexExpr);
    this.type = ContextKeyExprType.Regex;
    //
    this.key = key;
    this.regexp = regexp;
  }
  contextkey_createClass(ContextKeyRegexExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      if (this.key < other.key) {
        return -1;
      }
      if (this.key > other.key) {
        return 1;
      }
      var thisSource = this.regexp ? this.regexp.source : '';
      var otherSource = other.regexp ? other.regexp.source : '';
      if (thisSource < otherSource) {
        return -1;
      }
      if (thisSource > otherSource) {
        return 1;
      }
      return 0;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        var thisSource = this.regexp ? this.regexp.source : '';
        var otherSource = other.regexp ? other.regexp.source : '';
        return this.key === other.key && thisSource === otherSource;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      var value = context.getValue(this.key);
      return this.regexp ? this.regexp.test(value) : false;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      var value = this.regexp ? "/".concat(this.regexp.source, "/").concat(this.regexp.ignoreCase ? 'i' : '') : '/invalid/';
      return "".concat(this.key, " =~ ").concat(value);
    }
  }, {
    key: "keys",
    value: function keys() {
      return [this.key];
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return mapFnc.mapRegex(this.key, this.regexp);
    }
  }, {
    key: "negate",
    value: function negate() {
      return ContextKeyNotRegexExpr.create(this);
    }
  }], [{
    key: "create",
    value: function create(key, regexp) {
      return new ContextKeyRegexExpr(key, regexp);
    }
  }]);
  return ContextKeyRegexExpr;
}();
var ContextKeyNotRegexExpr = /*#__PURE__*/function () {
  function ContextKeyNotRegexExpr(_actual) {
    contextkey_classCallCheck(this, ContextKeyNotRegexExpr);
    this.type = ContextKeyExprType.NotRegex;
    this._actual = _actual;
  }
  contextkey_createClass(ContextKeyNotRegexExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      return this._actual.cmp(other._actual);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        return this._actual.equals(other._actual);
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      return !this._actual.evaluate(context);
    }
  }, {
    key: "serialize",
    value: function serialize() {
      throw new Error('Method not implemented.');
    }
  }, {
    key: "keys",
    value: function keys() {
      return this._actual.keys();
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return new ContextKeyNotRegexExpr(this._actual.map(mapFnc));
    }
  }, {
    key: "negate",
    value: function negate() {
      return this._actual;
    }
  }], [{
    key: "create",
    value: function create(actual) {
      return new ContextKeyNotRegexExpr(actual);
    }
  }]);
  return ContextKeyNotRegexExpr;
}();
var ContextKeyAndExpr = /*#__PURE__*/function () {
  function ContextKeyAndExpr(expr) {
    contextkey_classCallCheck(this, ContextKeyAndExpr);
    this.type = ContextKeyExprType.And;
    this.expr = expr;
  }
  contextkey_createClass(ContextKeyAndExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      if (this.expr.length < other.expr.length) {
        return -1;
      }
      if (this.expr.length > other.expr.length) {
        return 1;
      }
      for (var i = 0, len = this.expr.length; i < len; i++) {
        var r = _cmp(this.expr[i], other.expr[i]);
        if (r !== 0) {
          return r;
        }
      }
      return 0;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        if (this.expr.length !== other.expr.length) {
          return false;
        }
        for (var i = 0, len = this.expr.length; i < len; i++) {
          if (!this.expr[i].equals(other.expr[i])) {
            return false;
          }
        }
        return true;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      for (var i = 0, len = this.expr.length; i < len; i++) {
        if (!this.expr[i].evaluate(context)) {
          return false;
        }
      }
      return true;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return this.expr.map(function (e) {
        return e.serialize();
      }).join(' && ');
    }
  }, {
    key: "keys",
    value: function keys() {
      var result = [];
      var _iterator = contextkey_createForOfIteratorHelper(this.expr),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var expr = _step.value;
          result.push.apply(result, _toConsumableArray(expr.keys()));
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return result;
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return new ContextKeyAndExpr(this.expr.map(function (expr) {
        return expr.map(mapFnc);
      }));
    }
  }, {
    key: "negate",
    value: function negate() {
      var result = [];
      var _iterator2 = contextkey_createForOfIteratorHelper(this.expr),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var expr = _step2.value;
          result.push(expr.negate());
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return ContextKeyOrExpr.create(result);
    }
  }], [{
    key: "create",
    value: function create(_expr) {
      return ContextKeyAndExpr._normalizeArr(_expr);
    }
  }, {
    key: "_normalizeArr",
    value: function _normalizeArr(arr) {
      var expr = [];
      var hasTrue = false;
      var _iterator3 = contextkey_createForOfIteratorHelper(arr),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var e = _step3.value;
          if (!e) {
            continue;
          }
          if (e.type === ContextKeyExprType.True) {
            // anything && true ==> anything
            hasTrue = true;
            continue;
          }
          if (e.type === ContextKeyExprType.False) {
            // anything && false ==> false
            return ContextKeyFalseExpr.INSTANCE;
          }
          if (e.type === ContextKeyExprType.And) {
            expr.push.apply(expr, _toConsumableArray(e.expr));
            continue;
          }
          expr.push(e);
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      if (expr.length === 0 && hasTrue) {
        return ContextKeyTrueExpr.INSTANCE;
      }
      if (expr.length === 0) {
        return undefined;
      }
      if (expr.length === 1) {
        return expr[0];
      }
      expr.sort(_cmp);

      // We must distribute any OR expression because we don't support parens
      // OR extensions will be at the end (due to sorting rules)
      var _loop = function _loop() {
        var lastElement = expr[expr.length - 1];
        if (lastElement.type !== ContextKeyExprType.Or) {
          return 1; // break
        }
        // pop the last element
        expr.pop();

        // pop the second to last element
        var secondToLastElement = expr.pop();

        // distribute `lastElement` over `secondToLastElement`
        var resultElement = ContextKeyOrExpr.create(lastElement.expr.map(function (el) {
          return ContextKeyAndExpr.create([el, secondToLastElement]);
        }));
        if (resultElement) {
          expr.push(resultElement);
          expr.sort(_cmp);
        }
      };
      while (expr.length > 1) {
        if (_loop()) break;
      }
      if (expr.length === 1) {
        return expr[0];
      }
      return new ContextKeyAndExpr(expr);
    }
  }]);
  return ContextKeyAndExpr;
}();
var ContextKeyOrExpr = /*#__PURE__*/function () {
  function ContextKeyOrExpr(expr) {
    contextkey_classCallCheck(this, ContextKeyOrExpr);
    this.type = ContextKeyExprType.Or;
    this.expr = expr;
  }
  contextkey_createClass(ContextKeyOrExpr, [{
    key: "cmp",
    value: function cmp(other) {
      if (other.type !== this.type) {
        return this.type - other.type;
      }
      if (this.expr.length < other.expr.length) {
        return -1;
      }
      if (this.expr.length > other.expr.length) {
        return 1;
      }
      for (var i = 0, len = this.expr.length; i < len; i++) {
        var r = _cmp(this.expr[i], other.expr[i]);
        if (r !== 0) {
          return r;
        }
      }
      return 0;
    }
  }, {
    key: "equals",
    value: function equals(other) {
      if (other.type === this.type) {
        if (this.expr.length !== other.expr.length) {
          return false;
        }
        for (var i = 0, len = this.expr.length; i < len; i++) {
          if (!this.expr[i].equals(other.expr[i])) {
            return false;
          }
        }
        return true;
      }
      return false;
    }
  }, {
    key: "evaluate",
    value: function evaluate(context) {
      for (var i = 0, len = this.expr.length; i < len; i++) {
        if (this.expr[i].evaluate(context)) {
          return true;
        }
      }
      return false;
    }
  }, {
    key: "serialize",
    value: function serialize() {
      return this.expr.map(function (e) {
        return e.serialize();
      }).join(' || ');
    }
  }, {
    key: "keys",
    value: function keys() {
      var result = [];
      var _iterator4 = contextkey_createForOfIteratorHelper(this.expr),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var expr = _step4.value;
          result.push.apply(result, _toConsumableArray(expr.keys()));
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      return result;
    }
  }, {
    key: "map",
    value: function map(mapFnc) {
      return new ContextKeyOrExpr(this.expr.map(function (expr) {
        return expr.map(mapFnc);
      }));
    }
  }, {
    key: "negate",
    value: function negate() {
      var result = [];
      var _iterator5 = contextkey_createForOfIteratorHelper(this.expr),
        _step5;
      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var expr = _step5.value;
          result.push(expr.negate());
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
      var terminals = function terminals(node) {
        if (node.type === ContextKeyExprType.Or) {
          return node.expr;
        }
        return [node];
      };

      // We don't support parens, so here we distribute the AND over the OR terminals
      // We always take the first 2 AND pairs and distribute them
      while (result.length > 1) {
        var LEFT = result.shift();
        var RIGHT = result.shift();
        var all = [];
        var _iterator6 = contextkey_createForOfIteratorHelper(terminals(LEFT)),
          _step6;
        try {
          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
            var left = _step6.value;
            var _iterator7 = contextkey_createForOfIteratorHelper(terminals(RIGHT)),
              _step7;
            try {
              for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
                var right = _step7.value;
                all.push(ContextKeyExpr.and(left, right));
              }
            } catch (err) {
              _iterator7.e(err);
            } finally {
              _iterator7.f();
            }
          }
        } catch (err) {
          _iterator6.e(err);
        } finally {
          _iterator6.f();
        }
        result.unshift(ContextKeyExpr.or.apply(ContextKeyExpr, all));
      }
      return result[0];
    }
  }], [{
    key: "create",
    value: function create(_expr) {
      var expr = ContextKeyOrExpr._normalizeArr(_expr);
      if (expr.length === 0) {
        return undefined;
      }
      if (expr.length === 1) {
        return expr[0];
      }
      return new ContextKeyOrExpr(expr);
    }
  }, {
    key: "_normalizeArr",
    value: function _normalizeArr(arr) {
      var expr = [];
      var hasFalse = false;
      if (arr) {
        for (var i = 0, len = arr.length; i < len; i++) {
          var e = arr[i];
          if (!e) {
            continue;
          }
          if (e.type === ContextKeyExprType.False) {
            // anything || false ==> anything
            hasFalse = true;
            continue;
          }
          if (e.type === ContextKeyExprType.True) {
            // anything || true ==> true
            return [ContextKeyTrueExpr.INSTANCE];
          }
          if (e.type === ContextKeyExprType.Or) {
            expr = expr.concat(e.expr);
            continue;
          }
          expr.push(e);
        }
        if (expr.length === 0 && hasFalse) {
          return [ContextKeyFalseExpr.INSTANCE];
        }
        expr.sort(_cmp);
      }
      return expr;
    }
  }]);
  return ContextKeyOrExpr;
}();
var RawContextKey = /*#__PURE__*/function (_ContextKeyDefinedExp) {
  _inherits(RawContextKey, _ContextKeyDefinedExp);
  var _super = _createSuper(RawContextKey);
  function RawContextKey(key, defaultValue, metaOrHide) {
    var _this3;
    contextkey_classCallCheck(this, RawContextKey);
    _this3 = _super.call(this, key);
    _this3.key = key;
    _this3._defaultValue = defaultValue;

    // collect all context keys into a central place
    if (contextkey_typeof(metaOrHide) === 'object') {
      RawContextKey._info.push(contextkey_objectSpread(contextkey_objectSpread({}, metaOrHide), {}, {
        key: key
      }));
    } else if (metaOrHide !== true) {
      RawContextKey._info.push({
        key: key,
        description: metaOrHide,
        type: defaultValue !== null && defaultValue !== undefined ? contextkey_typeof(defaultValue) : undefined
      });
    }
    return _this3;
  }
  contextkey_createClass(RawContextKey, [{
    key: "bindTo",
    value: function bindTo(target) {
      return target.createKey(this.key, this._defaultValue);
    }
  }, {
    key: "getValue",
    value: function getValue(target) {
      return target.getContextKeyValue(this.key);
    }
  }, {
    key: "toNegated",
    value: function toNegated() {
      return ContextKeyExpr.not(this.key);
    }
  }, {
    key: "isEqualTo",
    value: function isEqualTo(value) {
      return ContextKeyExpr.equals(this.key, value);
    }
  }, {
    key: "notEqualsTo",
    value: function notEqualsTo(value) {
      return ContextKeyExpr.notEquals(this.key, value);
    }
  }], [{
    key: "all",
    value: function all() {
      return RawContextKey._info.values();
    }
  }]);
  return RawContextKey;
}(ContextKeyDefinedExpr);
RawContextKey._info = [];
var IContextKey;
(function (_IContextKey) {
  var None = _IContextKey.None = Object.freeze({
    set: function set() {
      //
    },
    reset: function reset() {
      //
    },
    get: function get() {
      return undefined;
    }
  });
})(IContextKey || (IContextKey = {}));
// export const IContextKeyService = createDecorator<IContextKeyService>('contextKeyService');
var IContextKeyService = mana_syringe_es/* Syringe */.J3.defineToken('IContextKeyService');
var SET_CONTEXT_COMMAND_ID = 'setContext';
function cmp1(key1, key2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  return 0;
}
function cmp2(key1, value1, key2, value2) {
  if (key1 < key2) {
    return -1;
  }
  if (key1 > key2) {
    return 1;
  }
  if (value1 < value2) {
    return -1;
  }
  if (value1 > value2) {
    return 1;
  }
  return 0;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/iterator.js
function iterator_defineProperty(obj, key, value) { key = iterator_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function iterator_toPropertyKey(t) { var i = iterator_toPrimitive(t, "string"); return "symbol" == iterator_typeof(i) ? i : String(i); }
function iterator_toPrimitive(t, r) { if ("object" != iterator_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != iterator_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function iterator_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = iterator_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function iterator_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return iterator_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return iterator_arrayLikeToArray(o, minLen); }
function iterator_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function iterator_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ iterator_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == iterator_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(iterator_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function iterator_typeof(o) { "@babel/helpers - typeof"; return iterator_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, iterator_typeof(o); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var Iterable;
(function (_Iterable) {
  var _marked = /*#__PURE__*/iterator_regeneratorRuntime().mark(single),
    _marked2 = /*#__PURE__*/iterator_regeneratorRuntime().mark(filter),
    _marked3 = /*#__PURE__*/iterator_regeneratorRuntime().mark(map),
    _marked4 = /*#__PURE__*/iterator_regeneratorRuntime().mark(concat),
    _marked5 = /*#__PURE__*/iterator_regeneratorRuntime().mark(concatNested);
  function is(thing) {
    return thing && iterator_typeof(thing) === 'object' && typeof thing[Symbol.iterator] === 'function';
  }
  _Iterable.is = is;
  var _empty = Object.freeze([]);
  function empty() {
    return _empty;
  }
  _Iterable.empty = empty;
  function single(element) {
    return iterator_regeneratorRuntime().wrap(function single$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          _context.next = 2;
          return element;
        case 2:
        case "end":
          return _context.stop();
      }
    }, _marked);
  }
  _Iterable.single = single;
  function from(iterable) {
    return iterable || _empty;
  }
  _Iterable.from = from;
  function isEmpty(iterable) {
    return !iterable || iterable[Symbol.iterator]().next().done === true;
  }
  _Iterable.isEmpty = isEmpty;
  function first(iterable) {
    return iterable[Symbol.iterator]().next().value;
  }
  _Iterable.first = first;
  function some(iterable, predicate) {
    var _iterator = iterator_createForOfIteratorHelper(iterable),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var element = _step.value;
        if (predicate(element)) {
          return true;
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    return false;
  }
  _Iterable.some = some;
  function find(iterable, predicate) {
    var _iterator2 = iterator_createForOfIteratorHelper(iterable),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var element = _step2.value;
        if (predicate(element)) {
          return element;
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
    return undefined;
  }
  _Iterable.find = find;
  function filter(iterable, predicate) {
    var _iterator3, _step3, element;
    return iterator_regeneratorRuntime().wrap(function filter$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          _iterator3 = iterator_createForOfIteratorHelper(iterable);
          _context2.prev = 1;
          _iterator3.s();
        case 3:
          if ((_step3 = _iterator3.n()).done) {
            _context2.next = 10;
            break;
          }
          element = _step3.value;
          if (!predicate(element)) {
            _context2.next = 8;
            break;
          }
          _context2.next = 8;
          return element;
        case 8:
          _context2.next = 3;
          break;
        case 10:
          _context2.next = 15;
          break;
        case 12:
          _context2.prev = 12;
          _context2.t0 = _context2["catch"](1);
          _iterator3.e(_context2.t0);
        case 15:
          _context2.prev = 15;
          _iterator3.f();
          return _context2.finish(15);
        case 18:
        case "end":
          return _context2.stop();
      }
    }, _marked2, null, [[1, 12, 15, 18]]);
  }
  _Iterable.filter = filter;
  function map(iterable, fn) {
    var _iterator4, _step4, element;
    return iterator_regeneratorRuntime().wrap(function map$(_context3) {
      while (1) switch (_context3.prev = _context3.next) {
        case 0:
          _iterator4 = iterator_createForOfIteratorHelper(iterable);
          _context3.prev = 1;
          _iterator4.s();
        case 3:
          if ((_step4 = _iterator4.n()).done) {
            _context3.next = 9;
            break;
          }
          element = _step4.value;
          _context3.next = 7;
          return fn(element);
        case 7:
          _context3.next = 3;
          break;
        case 9:
          _context3.next = 14;
          break;
        case 11:
          _context3.prev = 11;
          _context3.t0 = _context3["catch"](1);
          _iterator4.e(_context3.t0);
        case 14:
          _context3.prev = 14;
          _iterator4.f();
          return _context3.finish(14);
        case 17:
        case "end":
          return _context3.stop();
      }
    }, _marked3, null, [[1, 11, 14, 17]]);
  }
  _Iterable.map = map;
  function concat() {
    var _len,
      iterables,
      _key,
      _i,
      _iterables,
      _iterable,
      _iterator5,
      _step5,
      element,
      _args4 = arguments;
    return iterator_regeneratorRuntime().wrap(function concat$(_context4) {
      while (1) switch (_context4.prev = _context4.next) {
        case 0:
          for (_len = _args4.length, iterables = new Array(_len), _key = 0; _key < _len; _key++) {
            iterables[_key] = _args4[_key];
          }
          _i = 0, _iterables = iterables;
        case 2:
          if (!(_i < _iterables.length)) {
            _context4.next = 24;
            break;
          }
          _iterable = _iterables[_i];
          _iterator5 = iterator_createForOfIteratorHelper(_iterable);
          _context4.prev = 5;
          _iterator5.s();
        case 7:
          if ((_step5 = _iterator5.n()).done) {
            _context4.next = 13;
            break;
          }
          element = _step5.value;
          _context4.next = 11;
          return element;
        case 11:
          _context4.next = 7;
          break;
        case 13:
          _context4.next = 18;
          break;
        case 15:
          _context4.prev = 15;
          _context4.t0 = _context4["catch"](5);
          _iterator5.e(_context4.t0);
        case 18:
          _context4.prev = 18;
          _iterator5.f();
          return _context4.finish(18);
        case 21:
          _i++;
          _context4.next = 2;
          break;
        case 24:
        case "end":
          return _context4.stop();
      }
    }, _marked4, null, [[5, 15, 18, 21]]);
  }
  _Iterable.concat = concat;
  function concatNested(iterables) {
    var _iterator6, _step6, _iterable2, _iterator7, _step7, element;
    return iterator_regeneratorRuntime().wrap(function concatNested$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _iterator6 = iterator_createForOfIteratorHelper(iterables);
          _context5.prev = 1;
          _iterator6.s();
        case 3:
          if ((_step6 = _iterator6.n()).done) {
            _context5.next = 24;
            break;
          }
          _iterable2 = _step6.value;
          _iterator7 = iterator_createForOfIteratorHelper(_iterable2);
          _context5.prev = 6;
          _iterator7.s();
        case 8:
          if ((_step7 = _iterator7.n()).done) {
            _context5.next = 14;
            break;
          }
          element = _step7.value;
          _context5.next = 12;
          return element;
        case 12:
          _context5.next = 8;
          break;
        case 14:
          _context5.next = 19;
          break;
        case 16:
          _context5.prev = 16;
          _context5.t0 = _context5["catch"](6);
          _iterator7.e(_context5.t0);
        case 19:
          _context5.prev = 19;
          _iterator7.f();
          return _context5.finish(19);
        case 22:
          _context5.next = 3;
          break;
        case 24:
          _context5.next = 29;
          break;
        case 26:
          _context5.prev = 26;
          _context5.t1 = _context5["catch"](1);
          _iterator6.e(_context5.t1);
        case 29:
          _context5.prev = 29;
          _iterator6.f();
          return _context5.finish(29);
        case 32:
        case "end":
          return _context5.stop();
      }
    }, _marked5, null, [[1, 26, 29, 32], [6, 16, 19, 22]]);
  }
  _Iterable.concatNested = concatNested;
  function reduce(iterable, reducer, initialValue) {
    var value = initialValue;
    var _iterator8 = iterator_createForOfIteratorHelper(iterable),
      _step8;
    try {
      for (_iterator8.s(); !(_step8 = _iterator8.n()).done;) {
        var element = _step8.value;
        value = reducer(value, element);
      }
    } catch (err) {
      _iterator8.e(err);
    } finally {
      _iterator8.f();
    }
    return value;
  }
  _Iterable.reduce = reduce;
  function slice(arr, from) {
    var to = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : arr.length;
    return /*#__PURE__*/iterator_regeneratorRuntime().mark(function _callee() {
      return iterator_regeneratorRuntime().wrap(function _callee$(_context6) {
        while (1) switch (_context6.prev = _context6.next) {
          case 0:
            if (from < 0) {
              from += arr.length;
            }
            if (to < 0) {
              to += arr.length;
            } else if (to > arr.length) {
              to = arr.length;
            }
          case 2:
            if (!(from < to)) {
              _context6.next = 8;
              break;
            }
            _context6.next = 5;
            return arr[from];
          case 5:
            from++;
            _context6.next = 2;
            break;
          case 8:
          case "end":
            return _context6.stop();
        }
      }, _callee);
    })();
  }
  _Iterable.slice = slice;
  function consume(iterable) {
    var atMost = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.POSITIVE_INFINITY;
    var consumed = [];
    if (atMost === 0) {
      return [consumed, iterable];
    }
    var iterator = iterable[Symbol.iterator]();
    for (var i = 0; i < atMost; i++) {
      var next = iterator.next();
      if (next.done) {
        return [consumed, Iterable.empty()];
      }
      consumed.push(next.value);
    }
    return [consumed, iterator_defineProperty({}, Symbol.iterator, function () {
      return iterator;
    })];
  }
  _Iterable.consume = consume;
  function equals(a, b) {
    var comparator = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function (at, bt) {
      return at === bt;
    };
    var ai = a[Symbol.iterator]();
    var bi = b[Symbol.iterator]();
    // eslint-disable-next-line no-constant-condition
    while (true) {
      var an = ai.next();
      var bn = bi.next();
      if (an.done !== bn.done) {
        return false;
      }
      if (an.done) {
        return true;
      }
      if (!comparator(an.value, bn.value)) {
        return false;
      }
    }
  }
  _Iterable.equals = equals;
  function max(iterable, comparator) {
    var firstValue = first(iterable);
    if (!firstValue) {
      return undefined;
    }
    return reduce(iterable, function (prev, curr) {
      return comparator(prev, curr) > 0 ? prev : curr;
    }, firstValue);
  }
  _Iterable.max = max;
})(Iterable || (Iterable = {}));
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/objects.js
var objects = __webpack_require__(61743);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/utils/lifecycle.js
var lifecycle_dec, lifecycle_class2, _VSDisposable;
function lifecycle_typeof(o) { "@babel/helpers - typeof"; return lifecycle_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, lifecycle_typeof(o); }
function lifecycle_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = lifecycle_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function lifecycle_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return lifecycle_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return lifecycle_arrayLikeToArray(o, minLen); }
function lifecycle_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function lifecycle_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) lifecycle_setPrototypeOf(subClass, superClass); }
function lifecycle_createSuper(Derived) { var hasNativeReflectConstruct = lifecycle_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = lifecycle_getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = lifecycle_getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return lifecycle_possibleConstructorReturn(this, result); }; }
function lifecycle_possibleConstructorReturn(self, call) { if (call && (lifecycle_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return lifecycle_assertThisInitialized(self); }
function lifecycle_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function _wrapNativeSuper(Class) { var _cache = typeof Map === "function" ? new Map() : undefined; _wrapNativeSuper = function _wrapNativeSuper(Class) { if (Class === null || !_isNativeFunction(Class)) return Class; if (typeof Class !== "function") { throw new TypeError("Super expression must either be null or a function"); } if (typeof _cache !== "undefined") { if (_cache.has(Class)) return _cache.get(Class); _cache.set(Class, Wrapper); } function Wrapper() { return _construct(Class, arguments, lifecycle_getPrototypeOf(this).constructor); } Wrapper.prototype = Object.create(Class.prototype, { constructor: { value: Wrapper, enumerable: false, writable: true, configurable: true } }); return lifecycle_setPrototypeOf(Wrapper, Class); }; return _wrapNativeSuper(Class); }
function _construct(Parent, args, Class) { if (lifecycle_isNativeReflectConstruct()) { _construct = Reflect.construct.bind(); } else { _construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) lifecycle_setPrototypeOf(instance, Class.prototype); return instance; }; } return _construct.apply(null, arguments); }
function lifecycle_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function _isNativeFunction(fn) { try { return Function.toString.call(fn).indexOf("[native code]") !== -1; } catch (e) { return typeof fn === "function"; } }
function lifecycle_setPrototypeOf(o, p) { lifecycle_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return lifecycle_setPrototypeOf(o, p); }
function lifecycle_getPrototypeOf(o) { lifecycle_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return lifecycle_getPrototypeOf(o); }
function lifecycle_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function lifecycle_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, lifecycle_toPropertyKey(descriptor.key), descriptor); } }
function lifecycle_createClass(Constructor, protoProps, staticProps) { if (protoProps) lifecycle_defineProperties(Constructor.prototype, protoProps); if (staticProps) lifecycle_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function lifecycle_toPropertyKey(t) { var i = lifecycle_toPrimitive(t, "string"); return "symbol" == lifecycle_typeof(i) ? i : String(i); }
function lifecycle_toPrimitive(t, r) { if ("object" != lifecycle_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != lifecycle_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



function once(fn) {
  // eslint-disable-next-line @typescript-eslint/no-this-alias
  var _this = this;
  var didCall = false;
  var result;
  return function () {
    if (didCall) {
      return result;
    }
    didCall = true;
    // eslint-disable-next-line prefer-rest-params
    result = fn.apply(_this, Array.prototype.slice.call(arguments));
    return result;
  };
}

/**
 * Enables logging of potentially leaked disposables.
 *
 * A disposable is considered leaked if it is not disposed or not registered as the child of
 * another disposable. This tracking is very simple an only works for classes that either
 * extend VSDisposable or use a DisposableStore. This means there are a lot of false positives.
 */
var TRACK_DISPOSABLES = false;
var disposableTracker = null;
function setDisposableTracker(tracker) {
  disposableTracker = tracker;
}
if (TRACK_DISPOSABLES) {
  var __is_disposable_tracked__ = '__is_disposable_tracked__';
  disposableTracker = new ( /*#__PURE__*/function () {
    function _class() {
      lifecycle_classCallCheck(this, _class);
    }
    lifecycle_createClass(_class, [{
      key: "trackDisposable",
      value: function trackDisposable(x) {
        var stack = new Error('Potentially leaked disposable').stack;
        setTimeout(function () {
          if (!x[__is_disposable_tracked__]) {
            console.warn(stack);
          }
        }, 3000);
      }
    }, {
      key: "markTracked",
      value: function markTracked(x) {
        // eslint-disable-next-line @typescript-eslint/no-use-before-define
        if (x && x !== VSDisposable.None) {
          try {
            x[__is_disposable_tracked__] = true;
          } catch (_unused) {
            // noop
          }
        }
      }
    }]);
    return _class;
  }())();
}
function markTracked(x) {
  if (!disposableTracker) {
    return;
  }
  disposableTracker.markTracked(x);
}
function trackDisposable(x) {
  if (!disposableTracker) {
    return x;
  }
  disposableTracker.trackDisposable(x);
  return x;
}
var MultiDisposeError = /*#__PURE__*/function (_Error) {
  lifecycle_inherits(MultiDisposeError, _Error);
  var _super = lifecycle_createSuper(MultiDisposeError);
  function MultiDisposeError(errors) {
    var _this2;
    lifecycle_classCallCheck(this, MultiDisposeError);
    _this2 = _super.call(this, "Encountered errors while disposing of store. Errors: [".concat(errors.join(', '), "]"));
    _this2.errors = errors;
    return _this2;
  }
  return lifecycle_createClass(MultiDisposeError);
}( /*#__PURE__*/_wrapNativeSuper(Error));
function isDisposable(thing) {
  return typeof thing.dispose === 'function' && thing.dispose.length === 0;
}
function dispose(arg) {
  if (Iterable.is(arg)) {
    var errors = [];
    var _iterator = lifecycle_createForOfIteratorHelper(arg),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var d = _step.value;
        if (d) {
          markTracked(d);
          try {
            d.dispose();
          } catch (e) {
            errors.push(e);
          }
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
    if (errors.length === 1) {
      throw errors[0];
    } else if (errors.length > 1) {
      throw new MultiDisposeError(errors);
    }
    return Array.isArray(arg) ? [] : arg;
  }
  if (arg) {
    markTracked(arg);
    arg.dispose();
    return arg;
  }
}
function combinedDisposable() {
  for (var _len = arguments.length, disposables = new Array(_len), _key = 0; _key < _len; _key++) {
    disposables[_key] = arguments[_key];
  }
  disposables.forEach(markTracked);
  return toDisposable(function () {
    return dispose(disposables);
  });
}
function toDisposable(fn) {
  var self = trackDisposable({
    dispose: function dispose() {
      markTracked(self);
      fn();
    }
  });
  return self;
}
var DisposableStore = /*#__PURE__*/function () {
  function DisposableStore() {
    lifecycle_classCallCheck(this, DisposableStore);
    this._toDispose = new Set();
    this._isDisposed = false;
  }
  lifecycle_createClass(DisposableStore, [{
    key: "dispose",
    value:
    /**
     * Dispose of all registered disposables and mark this object as disposed.
     *
     * Any future disposables added to this object will be disposed of on `add`.
     */
    function dispose() {
      if (this._isDisposed) {
        return;
      }
      markTracked(this);
      this._isDisposed = true;
      this.clear();
    }

    /**
     * Dispose of all registered disposables but do not mark this object as disposed.
     */
  }, {
    key: "clear",
    value: function clear() {
      try {
        dispose(this._toDispose.values());
      } finally {
        this._toDispose.clear();
      }
    }
  }, {
    key: "add",
    value: function add(t) {
      if (!t) {
        return t;
      }
      if (t === this) {
        throw new Error('Cannot register a disposable on itself!');
      }
      markTracked(t);
      if (this._isDisposed) {
        if (!DisposableStore.DISABLE_DISPOSED_WARNING) {
          console.warn(new Error('Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!').stack);
        }
      } else {
        this._toDispose.add(t);
      }
      return t;
    }
  }]);
  return DisposableStore;
}();
DisposableStore.DISABLE_DISPOSED_WARNING = false;
var VSDisposable = (lifecycle_dec = (0,mana_syringe_es/* injectable */.b2)(), lifecycle_dec(lifecycle_class2 = (_VSDisposable = /*#__PURE__*/function () {
  function VSDisposable() {
    lifecycle_classCallCheck(this, VSDisposable);
    this._store = new DisposableStore();
    trackDisposable(this);
  }
  lifecycle_createClass(VSDisposable, [{
    key: "dispose",
    value: function dispose() {
      markTracked(this);
      this._store.dispose();
    }
  }, {
    key: "_register",
    value: function _register(t) {
      if (t === this) {
        throw new Error('Cannot register a disposable on itself!');
      }
      return this._store.add(t);
    }
  }]);
  return VSDisposable;
}(), _VSDisposable.None = Object.freeze({
  dispose: function dispose() {
    //
  }
}), _VSDisposable)) || lifecycle_class2);

/**
 * Manages the lifecycle of a disposable value that may be changed.
 *
 * This ensures that when the disposable value is changed, the previously held disposable is disposed of. You can
 * also register a `MutableDisposable` on a `VSDisposable` to ensure it is automatically cleaned up.
 */
var MutableDisposable = /*#__PURE__*/function () {
  function MutableDisposable() {
    lifecycle_classCallCheck(this, MutableDisposable);
    this._isDisposed = false;
    trackDisposable(this);
  }
  lifecycle_createClass(MutableDisposable, [{
    key: "value",
    get: function get() {
      return this._isDisposed ? undefined : this._value;
    },
    set: function set(value) {
      var _this$_value;
      if (this._isDisposed || value === this._value) {
        return;
      }
      (_this$_value = this._value) === null || _this$_value === void 0 || _this$_value.dispose();
      if (value) {
        markTracked(value);
      }
      this._value = value;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.value = undefined;
    }
  }, {
    key: "dispose",
    value: function dispose() {
      var _this$_value2;
      this._isDisposed = true;
      markTracked(this);
      (_this$_value2 = this._value) === null || _this$_value2 === void 0 || _this$_value2.dispose();
      this._value = undefined;
    }
  }]);
  return MutableDisposable;
}();
var ReferenceCollection = /*#__PURE__*/function () {
  function ReferenceCollection() {
    lifecycle_classCallCheck(this, ReferenceCollection);
    this.references = new Map();
  }
  lifecycle_createClass(ReferenceCollection, [{
    key: "acquire",
    value: function acquire(key) {
      var _this3 = this;
      var reference = this.references.get(key);
      if (!reference) {
        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }
        reference = {
          counter: 0,
          object: this.createReferencedObject.apply(this, [key].concat(args))
        };
        this.references.set(key, reference);
      }
      var _reference = reference,
        object = _reference.object;
      // eslint-disable-next-line @typescript-eslint/no-shadow
      var dispose = once(function () {
        if (--reference.counter === 0) {
          _this3.destroyReferencedObject(key, reference.object);
          _this3.references.delete(key);
        }
      });
      reference.counter++;
      return {
        object: object,
        dispose: dispose
      };
    }
  }]);
  return ReferenceCollection;
}();
var ImmortalReference = /*#__PURE__*/function () {
  function ImmortalReference(object) {
    lifecycle_classCallCheck(this, ImmortalReference);
    this.object = object;
  }
  lifecycle_createClass(ImmortalReference, [{
    key: "dispose",
    value: function dispose() {
      /* noop */
    }
  }]);
  return ImmortalReference;
}();
;// CONCATENATED MODULE: ../../node_modules/.pnpm/vscode-uri@2.1.2/node_modules/vscode-uri/lib/esm/index.js
/* provided dependency */ var process = __webpack_require__(73656);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var _a;
var isWindows;
if (typeof process === 'object') {
    isWindows = process.platform === 'win32';
}
else if (typeof navigator === 'object') {
    var userAgent = navigator.userAgent;
    isWindows = userAgent.indexOf('Windows') >= 0;
}
function esm_isHighSurrogate(charCode) {
    return (0xD800 <= charCode && charCode <= 0xDBFF);
}
function esm_isLowSurrogate(charCode) {
    return (0xDC00 <= charCode && charCode <= 0xDFFF);
}
function isLowerAsciiHex(code) {
    return code >= 97 /* a */ && code <= 102 /* f */;
}
function esm_isLowerAsciiLetter(code) {
    return code >= 97 /* a */ && code <= 122 /* z */;
}
function esm_isUpperAsciiLetter(code) {
    return code >= 65 /* A */ && code <= 90 /* Z */;
}
function esm_isAsciiLetter(code) {
    return esm_isLowerAsciiLetter(code) || esm_isUpperAsciiLetter(code);
}
//#endregion
var _schemePattern = /^\w[\w\d+.-]*$/;
var _singleSlashStart = /^\//;
var _doubleSlashStart = /^\/\//;
function _validateUri(ret, _strict) {
    // scheme, must be set
    if (!ret.scheme && _strict) {
        throw new Error("[UriError]: Scheme is missing: {scheme: \"\", authority: \"" + ret.authority + "\", path: \"" + ret.path + "\", query: \"" + ret.query + "\", fragment: \"" + ret.fragment + "\"}");
    }
    // scheme, https://tools.ietf.org/html/rfc3986#section-3.1
    // ALPHA *( ALPHA / DIGIT / "+" / "-" / "." )
    if (ret.scheme && !_schemePattern.test(ret.scheme)) {
        throw new Error('[UriError]: Scheme contains illegal characters.');
    }
    // path, http://tools.ietf.org/html/rfc3986#section-3.3
    // If a URI contains an authority component, then the path component
    // must either be empty or begin with a slash ("/") character.  If a URI
    // does not contain an authority component, then the path cannot begin
    // with two slash characters ("//").
    if (ret.path) {
        if (ret.authority) {
            if (!_singleSlashStart.test(ret.path)) {
                throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
            }
        }
        else {
            if (_doubleSlashStart.test(ret.path)) {
                throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
            }
        }
    }
}
// for a while we allowed uris *without* schemes and this is the migration
// for them, e.g. an uri without scheme and without strict-mode warns and falls
// back to the file-scheme. that should cause the least carnage and still be a
// clear warning
function _schemeFix(scheme, _strict) {
    if (!scheme && !_strict) {
        return 'file';
    }
    return scheme;
}
// implements a bit of https://tools.ietf.org/html/rfc3986#section-5
function _referenceResolution(scheme, path) {
    // the slash-character is our 'default base' as we don't
    // support constructing URIs relative to other URIs. This
    // also means that we alter and potentially break paths.
    // see https://tools.ietf.org/html/rfc3986#section-5.1.4
    switch (scheme) {
        case 'https':
        case 'http':
        case 'file':
            if (!path) {
                path = _slash;
            }
            else if (path[0] !== _slash) {
                path = _slash + path;
            }
            break;
    }
    return path;
}
var _empty = '';
var _slash = '/';
var _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
/**
 * Uniform Resource Identifier (URI) http://tools.ietf.org/html/rfc3986.
 * This class is a simple parser which creates the basic component parts
 * (http://tools.ietf.org/html/rfc3986#section-3) with minimal validation
 * and encoding.
 *
 * ```txt
 *       foo://example.com:8042/over/there?name=ferret#nose
 *       \_/   \______________/\_________/ \_________/ \__/
 *        |           |            |            |        |
 *     scheme     authority       path        query   fragment
 *        |   _____________________|__
 *       / \ /                        \
 *       urn:example:animal:ferret:nose
 * ```
 */
var URI = /** @class */ (function () {
    /**
     * @internal
     */
    function URI(schemeOrData, authority, path, query, fragment, _strict) {
        if (_strict === void 0) { _strict = false; }
        if (typeof schemeOrData === 'object') {
            this.scheme = schemeOrData.scheme || _empty;
            this.authority = schemeOrData.authority || _empty;
            this.path = schemeOrData.path || _empty;
            this.query = schemeOrData.query || _empty;
            this.fragment = schemeOrData.fragment || _empty;
            // no validation because it's this URI
            // that creates uri components.
            // _validateUri(this);
        }
        else {
            this.scheme = _schemeFix(schemeOrData, _strict);
            this.authority = authority || _empty;
            this.path = _referenceResolution(this.scheme, path || _empty);
            this.query = query || _empty;
            this.fragment = fragment || _empty;
            _validateUri(this, _strict);
        }
    }
    URI.isUri = function (thing) {
        if (thing instanceof URI) {
            return true;
        }
        if (!thing) {
            return false;
        }
        return typeof thing.authority === 'string'
            && typeof thing.fragment === 'string'
            && typeof thing.path === 'string'
            && typeof thing.query === 'string'
            && typeof thing.scheme === 'string'
            && typeof thing.fsPath === 'function'
            && typeof thing.with === 'function'
            && typeof thing.toString === 'function';
    };
    Object.defineProperty(URI.prototype, "fsPath", {
        // ---- filesystem path -----------------------
        /**
         * Returns a string representing the corresponding file system path of this URI.
         * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
         * platform specific path separator.
         *
         * * Will *not* validate the path for invalid characters and semantics.
         * * Will *not* look at the scheme of this URI.
         * * The result shall *not* be used for display purposes but for accessing a file on disk.
         *
         *
         * The *difference* to `URI#path` is the use of the platform specific separator and the handling
         * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
         *
         * ```ts
            const u = URI.parse('file://server/c$/folder/file.txt')
            u.authority === 'server'
            u.path === '/shares/c$/file.txt'
            u.fsPath === '\\server\c$\folder\file.txt'
        ```
         *
         * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
         * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
         * with URIs that represent files on disk (`file` scheme).
         */
        get: function () {
            // if (this.scheme !== 'file') {
            // 	console.warn(`[UriError] calling fsPath with scheme ${this.scheme}`);
            // }
            return uriToFsPath(this, false);
        },
        enumerable: true,
        configurable: true
    });
    // ---- modify to new -------------------------
    URI.prototype.with = function (change) {
        if (!change) {
            return this;
        }
        var scheme = change.scheme, authority = change.authority, path = change.path, query = change.query, fragment = change.fragment;
        if (scheme === undefined) {
            scheme = this.scheme;
        }
        else if (scheme === null) {
            scheme = _empty;
        }
        if (authority === undefined) {
            authority = this.authority;
        }
        else if (authority === null) {
            authority = _empty;
        }
        if (path === undefined) {
            path = this.path;
        }
        else if (path === null) {
            path = _empty;
        }
        if (query === undefined) {
            query = this.query;
        }
        else if (query === null) {
            query = _empty;
        }
        if (fragment === undefined) {
            fragment = this.fragment;
        }
        else if (fragment === null) {
            fragment = _empty;
        }
        if (scheme === this.scheme
            && authority === this.authority
            && path === this.path
            && query === this.query
            && fragment === this.fragment) {
            return this;
        }
        return new _URI(scheme, authority, path, query, fragment);
    };
    // ---- parse & validate ------------------------
    /**
     * Creates a new URI from a string, e.g. `http://www.msft.com/some/path`,
     * `file:///usr/home`, or `scheme:with/path`.
     *
     * @param value A string which represents an URI (see `URI#toString`).
     */
    URI.parse = function (value, _strict) {
        if (_strict === void 0) { _strict = false; }
        var match = _regexp.exec(value);
        if (!match) {
            return new _URI(_empty, _empty, _empty, _empty, _empty);
        }
        return new _URI(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
    };
    /**
     * Creates a new URI from a file system path, e.g. `c:\my\files`,
     * `/usr/home`, or `\\server\share\some\path`.
     *
     * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
     * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
     * `URI.parse('file://' + path)` because the path might contain characters that are
     * interpreted (# and ?). See the following sample:
     * ```ts
    const good = URI.file('/coding/c#/project1');
    good.scheme === 'file';
    good.path === '/coding/c#/project1';
    good.fragment === '';
    const bad = URI.parse('file://' + '/coding/c#/project1');
    bad.scheme === 'file';
    bad.path === '/coding/c'; // path is now broken
    bad.fragment === '/project1';
    ```
     *
     * @param path A file system path (see `URI#fsPath`)
     */
    URI.file = function (path) {
        var authority = _empty;
        // normalize to fwd-slashes on windows,
        // on other systems bwd-slashes are valid
        // filename character, eg /f\oo/ba\r.txt
        if (isWindows) {
            path = path.replace(/\\/g, _slash);
        }
        // check for authority as used in UNC shares
        // or use the path as given
        if (path[0] === _slash && path[1] === _slash) {
            var idx = path.indexOf(_slash, 2);
            if (idx === -1) {
                authority = path.substring(2);
                path = _slash;
            }
            else {
                authority = path.substring(2, idx);
                path = path.substring(idx) || _slash;
            }
        }
        return new _URI('file', authority, path, _empty, _empty);
    };
    URI.from = function (components) {
        return new _URI(components.scheme, components.authority, components.path, components.query, components.fragment);
    };
    // /**
    //  * Join a URI path with path fragments and normalizes the resulting path.
    //  *
    //  * @param uri The input URI.
    //  * @param pathFragment The path fragment to add to the URI path.
    //  * @returns The resulting URI.
    //  */
    // static joinPath(uri: URI, ...pathFragment: string[]): URI {
    // 	if (!uri.path) {
    // 		throw new Error(`[UriError]: cannot call joinPaths on URI without path`);
    // 	}
    // 	let newPath: string;
    // 	if (isWindows && uri.scheme === 'file') {
    // 		newPath = URI.file(paths.win32.join(uriToFsPath(uri, true), ...pathFragment)).path;
    // 	} else {
    // 		newPath = paths.posix.join(uri.path, ...pathFragment);
    // 	}
    // 	return uri.with({ path: newPath });
    // }
    // ---- printing/externalize ---------------------------
    /**
     * Creates a string representation for this URI. It's guaranteed that calling
     * `URI.parse` with the result of this function creates an URI which is equal
     * to this URI.
     *
     * * The result shall *not* be used for display purposes but for externalization or transport.
     * * The result will be encoded using the percentage encoding and encoding happens mostly
     * ignore the scheme-specific encoding rules.
     *
     * @param skipEncoding Do not encode the result, default is `false`
     */
    URI.prototype.toString = function (skipEncoding) {
        if (skipEncoding === void 0) { skipEncoding = false; }
        return _asFormatted(this, skipEncoding);
    };
    URI.prototype.toJSON = function () {
        return this;
    };
    URI.revive = function (data) {
        if (!data) {
            return data;
        }
        else if (data instanceof URI) {
            return data;
        }
        else {
            var result = new _URI(data);
            result._formatted = data.external;
            result._fsPath = data._sep === _pathSepMarker ? data.fsPath : null;
            return result;
        }
    };
    return URI;
}());

var _pathSepMarker = isWindows ? 1 : undefined;
// eslint-disable-next-line @typescript-eslint/class-name-casing
var _URI = /** @class */ (function (_super) {
    __extends(_URI, _super);
    function _URI() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._formatted = null;
        _this._fsPath = null;
        return _this;
    }
    Object.defineProperty(_URI.prototype, "fsPath", {
        get: function () {
            if (!this._fsPath) {
                this._fsPath = uriToFsPath(this, false);
            }
            return this._fsPath;
        },
        enumerable: true,
        configurable: true
    });
    _URI.prototype.toString = function (skipEncoding) {
        if (skipEncoding === void 0) { skipEncoding = false; }
        if (!skipEncoding) {
            if (!this._formatted) {
                this._formatted = _asFormatted(this, false);
            }
            return this._formatted;
        }
        else {
            // we don't cache that
            return _asFormatted(this, true);
        }
    };
    _URI.prototype.toJSON = function () {
        var res = {
            $mid: 1
        };
        // cached state
        if (this._fsPath) {
            res.fsPath = this._fsPath;
            res._sep = _pathSepMarker;
        }
        if (this._formatted) {
            res.external = this._formatted;
        }
        // uri components
        if (this.path) {
            res.path = this.path;
        }
        if (this.scheme) {
            res.scheme = this.scheme;
        }
        if (this.authority) {
            res.authority = this.authority;
        }
        if (this.query) {
            res.query = this.query;
        }
        if (this.fragment) {
            res.fragment = this.fragment;
        }
        return res;
    };
    return _URI;
}(URI));
// reserved characters: https://tools.ietf.org/html/rfc3986#section-2.2
var encodeTable = (_a = {},
    _a[58 /* Colon */] = '%3A',
    _a[47 /* Slash */] = '%2F',
    _a[63 /* QuestionMark */] = '%3F',
    _a[35 /* Hash */] = '%23',
    _a[91 /* OpenSquareBracket */] = '%5B',
    _a[93 /* CloseSquareBracket */] = '%5D',
    _a[64 /* AtSign */] = '%40',
    _a[33 /* ExclamationMark */] = '%21',
    _a[36 /* DollarSign */] = '%24',
    _a[38 /* Ampersand */] = '%26',
    _a[39 /* SingleQuote */] = '%27',
    _a[40 /* OpenParen */] = '%28',
    _a[41 /* CloseParen */] = '%29',
    _a[42 /* Asterisk */] = '%2A',
    _a[43 /* Plus */] = '%2B',
    _a[44 /* Comma */] = '%2C',
    _a[59 /* Semicolon */] = '%3B',
    _a[61 /* Equals */] = '%3D',
    _a[32 /* Space */] = '%20',
    _a);
function encodeURIComponentFast(uriComponent, allowSlash) {
    var res = undefined;
    var nativeEncodePos = -1;
    for (var pos = 0; pos < uriComponent.length; pos++) {
        var code = uriComponent.charCodeAt(pos);
        // unreserved characters: https://tools.ietf.org/html/rfc3986#section-2.3
        if ((code >= 97 /* a */ && code <= 122 /* z */)
            || (code >= 65 /* A */ && code <= 90 /* Z */)
            || (code >= 48 /* Digit0 */ && code <= 57 /* Digit9 */)
            || code === 45 /* Dash */
            || code === 46 /* Period */
            || code === 95 /* Underline */
            || code === 126 /* Tilde */
            || (allowSlash && code === 47 /* Slash */)) {
            // check if we are delaying native encode
            if (nativeEncodePos !== -1) {
                res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
                nativeEncodePos = -1;
            }
            // check if we write into a new string (by default we try to return the param)
            if (res !== undefined) {
                res += uriComponent.charAt(pos);
            }
        }
        else {
            // encoding needed, we need to allocate a new string
            if (res === undefined) {
                res = uriComponent.substr(0, pos);
            }
            // check with default table first
            var escaped = encodeTable[code];
            if (escaped !== undefined) {
                // check if we are delaying native encode
                if (nativeEncodePos !== -1) {
                    res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
                    nativeEncodePos = -1;
                }
                // append escaped variant to result
                res += escaped;
            }
            else if (nativeEncodePos === -1) {
                // use native encode only when needed
                nativeEncodePos = pos;
            }
        }
    }
    if (nativeEncodePos !== -1) {
        res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
    }
    return res !== undefined ? res : uriComponent;
}
function encodeURIComponentMinimal(path) {
    var res = undefined;
    for (var pos = 0; pos < path.length; pos++) {
        var code = path.charCodeAt(pos);
        if (code === 35 /* Hash */ || code === 63 /* QuestionMark */) {
            if (res === undefined) {
                res = path.substr(0, pos);
            }
            res += encodeTable[code];
        }
        else {
            if (res !== undefined) {
                res += path[pos];
            }
        }
    }
    return res !== undefined ? res : path;
}
/**
 * Compute `fsPath` for the given uri
 */
function uriToFsPath(uri, keepDriveLetterCasing) {
    var value;
    if (uri.authority && uri.path.length > 1 && uri.scheme === 'file') {
        // unc path: file://shares/c$/far/boo
        value = "//" + uri.authority + uri.path;
    }
    else if (uri.path.charCodeAt(0) === 47 /* Slash */
        && (uri.path.charCodeAt(1) >= 65 /* A */ && uri.path.charCodeAt(1) <= 90 /* Z */ || uri.path.charCodeAt(1) >= 97 /* a */ && uri.path.charCodeAt(1) <= 122 /* z */)
        && uri.path.charCodeAt(2) === 58 /* Colon */) {
        if (!keepDriveLetterCasing) {
            // windows drive letter: file:///c:/far/boo
            value = uri.path[1].toLowerCase() + uri.path.substr(2);
        }
        else {
            value = uri.path.substr(1);
        }
    }
    else {
        // other path
        value = uri.path;
    }
    if (isWindows) {
        value = value.replace(/\//g, '\\');
    }
    return value;
}
/**
 * Create the external version of a uri
 */
function _asFormatted(uri, skipEncoding) {
    var encoder = !skipEncoding
        ? encodeURIComponentFast
        : encodeURIComponentMinimal;
    var res = '';
    var scheme = uri.scheme, authority = uri.authority, path = uri.path, query = uri.query, fragment = uri.fragment;
    if (scheme) {
        res += scheme;
        res += ':';
    }
    if (authority || scheme === 'file') {
        res += _slash;
        res += _slash;
    }
    if (authority) {
        var idx = authority.indexOf('@');
        if (idx !== -1) {
            // <user>@<auth>
            var userinfo = authority.substr(0, idx);
            authority = authority.substr(idx + 1);
            idx = userinfo.indexOf(':');
            if (idx === -1) {
                res += encoder(userinfo, false);
            }
            else {
                // <user>:<pass>@<auth>
                res += encoder(userinfo.substr(0, idx), false);
                res += ':';
                res += encoder(userinfo.substr(idx + 1), false);
            }
            res += '@';
        }
        authority = authority.toLowerCase();
        idx = authority.indexOf(':');
        if (idx === -1) {
            res += encoder(authority, false);
        }
        else {
            // <auth>:<port>
            res += encoder(authority.substr(0, idx), false);
            res += authority.substr(idx);
        }
    }
    if (path) {
        // lower-case windows drive letters in /C:/fff or C:/fff
        if (path.length >= 3 && path.charCodeAt(0) === 47 /* Slash */ && path.charCodeAt(2) === 58 /* Colon */) {
            var code = path.charCodeAt(1);
            if (code >= 65 /* A */ && code <= 90 /* Z */) {
                path = "/" + String.fromCharCode(code + 32) + ":" + path.substr(3); // "/c:".length === 3
            }
        }
        else if (path.length >= 2 && path.charCodeAt(1) === 58 /* Colon */) {
            var code = path.charCodeAt(0);
            if (code >= 65 /* A */ && code <= 90 /* Z */) {
                path = String.fromCharCode(code + 32) + ":" + path.substr(2); // "/c:".length === 3
            }
        }
        // encode the rest of the path
        res += encoder(path, true);
    }
    if (query) {
        res += '?';
        res += encoder(query, false);
    }
    if (fragment) {
        res += '#';
        res += !skipEncoding ? encodeURIComponentFast(fragment, false) : fragment;
    }
    return res;
}
// --- decode
function decodeURIComponentGraceful(str) {
    try {
        return decodeURIComponent(str);
    }
    catch (_a) {
        if (str.length > 3) {
            return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
        }
        else {
            return str;
        }
    }
}
var _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
function percentDecode(str) {
    if (!str.match(_rEncodedAsHex)) {
        return str;
    }
    return str.replace(_rEncodedAsHex, function (match) { return decodeURIComponentGraceful(match); });
}

;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/utils/map.js
var _Symbol$toStringTag, _Symbol$iterator2, _Symbol$toStringTag2, _Symbol$iterator3;
function map_typeof(o) { "@babel/helpers - typeof"; return map_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, map_typeof(o); }
function map_defineProperty(obj, key, value) { key = map_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function map_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ map_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == map_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(map_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function map_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = map_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function map_slicedToArray(arr, i) { return map_arrayWithHoles(arr) || map_iterableToArrayLimit(arr, i) || map_unsupportedIterableToArray(arr, i) || map_nonIterableRest(); }
function map_nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function map_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return map_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return map_arrayLikeToArray(o, minLen); }
function map_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function map_iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function map_arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function map_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function map_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, map_toPropertyKey(descriptor.key), descriptor); } }
function map_createClass(Constructor, protoProps, staticProps) { if (protoProps) map_defineProperties(Constructor.prototype, protoProps); if (staticProps) map_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function map_toPropertyKey(t) { var i = map_toPrimitive(t, "string"); return "symbol" == map_typeof(i) ? i : String(i); }
function map_toPrimitive(t, r) { if ("object" != map_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != map_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable @typescript-eslint/no-this-alias */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



function map_getOrSet(map, key, value) {
  var result = map.get(key);
  if (result === undefined) {
    result = value;
    map.set(key, result);
  }
  return result;
}
var StringIterator = /*#__PURE__*/function () {
  function StringIterator() {
    map_classCallCheck(this, StringIterator);
    this._value = '';
    this._pos = 0;
  }
  map_createClass(StringIterator, [{
    key: "reset",
    value: function reset(key) {
      this._value = key;
      this._pos = 0;
      return this;
    }
  }, {
    key: "next",
    value: function next() {
      this._pos += 1;
      return this;
    }
  }, {
    key: "hasNext",
    value: function hasNext() {
      return this._pos < this._value.length - 1;
    }
  }, {
    key: "cmp",
    value: function cmp(a) {
      var aCode = a.charCodeAt(0);
      var thisCode = this._value.charCodeAt(this._pos);
      return aCode - thisCode;
    }
  }, {
    key: "value",
    value: function value() {
      return this._value[this._pos];
    }
  }]);
  return StringIterator;
}();
var ConfigKeysIterator = /*#__PURE__*/function () {
  function ConfigKeysIterator() {
    var _caseSensitive = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    map_classCallCheck(this, ConfigKeysIterator);
    this._caseSensitive = true;
    this._caseSensitive = _caseSensitive;
  }
  map_createClass(ConfigKeysIterator, [{
    key: "reset",
    value: function reset(key) {
      this._value = key;
      this._from = 0;
      this._to = 0;
      return this.next();
    }
  }, {
    key: "hasNext",
    value: function hasNext() {
      return this._to < this._value.length;
    }
  }, {
    key: "next",
    value: function next() {
      // this._data = key.split(/[\\/]/).filter(s => !!s);
      this._from = this._to;
      var justSeps = true;
      for (; this._to < this._value.length; this._to++) {
        var ch = this._value.charCodeAt(this._to);
        if (ch === CharCode.Period) {
          if (justSeps) {
            this._from++;
          } else {
            break;
          }
        } else {
          justSeps = false;
        }
      }
      return this;
    }
  }, {
    key: "cmp",
    value: function cmp(a) {
      return this._caseSensitive ? compareSubstring(a, this._value, 0, a.length, this._from, this._to) : compareSubstringIgnoreCase(a, this._value, 0, a.length, this._from, this._to);
    }
  }, {
    key: "value",
    value: function value() {
      return this._value.substring(this._from, this._to);
    }
  }]);
  return ConfigKeysIterator;
}();
var PathIterator = /*#__PURE__*/function () {
  function PathIterator() {
    var _splitOnBackslash = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;
    var _caseSensitive = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    map_classCallCheck(this, PathIterator);
    this._splitOnBackslash = true;
    this._caseSensitive = true;
    this._splitOnBackslash = _splitOnBackslash;
    this._caseSensitive = _caseSensitive;
  }
  map_createClass(PathIterator, [{
    key: "reset",
    value: function reset(key) {
      this._value = key.replace(/\\$|\/$/, '');
      this._from = 0;
      this._to = 0;
      return this.next();
    }
  }, {
    key: "hasNext",
    value: function hasNext() {
      return this._to < this._value.length;
    }
  }, {
    key: "next",
    value: function next() {
      // this._data = key.split(/[\\/]/).filter(s => !!s);
      this._from = this._to;
      var justSeps = true;
      for (; this._to < this._value.length; this._to++) {
        var ch = this._value.charCodeAt(this._to);
        if (ch === CharCode.Slash || this._splitOnBackslash && ch === CharCode.Backslash) {
          if (justSeps) {
            this._from++;
          } else {
            break;
          }
        } else {
          justSeps = false;
        }
      }
      return this;
    }
  }, {
    key: "cmp",
    value: function cmp(a) {
      return this._caseSensitive ? compareSubstring(a, this._value, 0, a.length, this._from, this._to) : compareSubstringIgnoreCase(a, this._value, 0, a.length, this._from, this._to);
    }
  }, {
    key: "value",
    value: function value() {
      return this._value.substring(this._from, this._to);
    }
  }]);
  return PathIterator;
}();
var UriIteratorState = /*#__PURE__*/function (UriIteratorState) {
  UriIteratorState[UriIteratorState["Scheme"] = 1] = "Scheme";
  UriIteratorState[UriIteratorState["Authority"] = 2] = "Authority";
  UriIteratorState[UriIteratorState["Path"] = 3] = "Path";
  UriIteratorState[UriIteratorState["Query"] = 4] = "Query";
  UriIteratorState[UriIteratorState["Fragment"] = 5] = "Fragment";
  return UriIteratorState;
}(UriIteratorState || {});
var UriIterator = /*#__PURE__*/function () {
  // eslint-disable-next-line @typescript-eslint/no-unused-vars

  function UriIterator(_ignorePathCasing) {
    map_classCallCheck(this, UriIterator);
    this._states = [];
    this._stateIdx = 0;
    this._ignorePathCasing = _ignorePathCasing;
  }
  map_createClass(UriIterator, [{
    key: "reset",
    value: function reset(key) {
      this._value = key;
      this._states = [];
      if (this._value.scheme) {
        this._states.push(UriIteratorState.Scheme);
      }
      if (this._value.authority) {
        this._states.push(UriIteratorState.Authority);
      }
      if (this._value.path) {
        this._pathIterator = new PathIterator(false, !this._ignorePathCasing(key));
        this._pathIterator.reset(key.path);
        if (this._pathIterator.value()) {
          this._states.push(UriIteratorState.Path);
        }
      }
      if (this._value.query) {
        this._states.push(UriIteratorState.Query);
      }
      if (this._value.fragment) {
        this._states.push(UriIteratorState.Fragment);
      }
      this._stateIdx = 0;
      return this;
    }
  }, {
    key: "next",
    value: function next() {
      if (this._states[this._stateIdx] === UriIteratorState.Path && this._pathIterator.hasNext()) {
        this._pathIterator.next();
      } else {
        this._stateIdx += 1;
      }
      return this;
    }
  }, {
    key: "hasNext",
    value: function hasNext() {
      return this._states[this._stateIdx] === UriIteratorState.Path && this._pathIterator.hasNext() || this._stateIdx < this._states.length - 1;
    }
  }, {
    key: "cmp",
    value: function cmp(a) {
      if (this._states[this._stateIdx] === UriIteratorState.Scheme) {
        return compareIgnoreCase(a, this._value.scheme);
      }
      if (this._states[this._stateIdx] === UriIteratorState.Authority) {
        return compareIgnoreCase(a, this._value.authority);
      }
      if (this._states[this._stateIdx] === UriIteratorState.Path) {
        return this._pathIterator.cmp(a);
      }
      if (this._states[this._stateIdx] === UriIteratorState.Query) {
        return compare(a, this._value.query);
      }
      if (this._states[this._stateIdx] === UriIteratorState.Fragment) {
        return compare(a, this._value.fragment);
      }
      throw new Error();
    }
  }, {
    key: "value",
    value: function value() {
      if (this._states[this._stateIdx] === UriIteratorState.Scheme) {
        return this._value.scheme;
      }
      if (this._states[this._stateIdx] === UriIteratorState.Authority) {
        return this._value.authority;
      }
      if (this._states[this._stateIdx] === UriIteratorState.Path) {
        return this._pathIterator.value();
      }
      if (this._states[this._stateIdx] === UriIteratorState.Query) {
        return this._value.query;
      }
      if (this._states[this._stateIdx] === UriIteratorState.Fragment) {
        return this._value.fragment;
      }
      throw new Error();
    }
  }]);
  return UriIterator;
}();
var TernarySearchTreeNode = /*#__PURE__*/function () {
  function TernarySearchTreeNode() {
    map_classCallCheck(this, TernarySearchTreeNode);
  }
  map_createClass(TernarySearchTreeNode, [{
    key: "isEmpty",
    value: function isEmpty() {
      return !this.left && !this.mid && !this.right && !this.value;
    }
  }]);
  return TernarySearchTreeNode;
}();
var TernarySearchTree = /*#__PURE__*/function (_Symbol$iterator) {
  function TernarySearchTree(segments) {
    map_classCallCheck(this, TernarySearchTree);
    this._iter = segments;
  }
  map_createClass(TernarySearchTree, [{
    key: "clear",
    value: function clear() {
      this._root = undefined;
    }
  }, {
    key: "set",
    value: function set(key, element) {
      var iter = this._iter.reset(key);
      var node;
      if (!this._root) {
        this._root = new TernarySearchTreeNode();
        this._root.segment = iter.value();
      }
      node = this._root;
      // eslint-disable-next-line no-constant-condition
      while (true) {
        var val = iter.cmp(node.segment);
        if (val > 0) {
          // left
          if (!node.left) {
            node.left = new TernarySearchTreeNode();
            node.left.segment = iter.value();
          }
          node = node.left;
        } else if (val < 0) {
          // right
          if (!node.right) {
            node.right = new TernarySearchTreeNode();
            node.right.segment = iter.value();
          }
          node = node.right;
        } else if (iter.hasNext()) {
          // mid
          iter.next();
          if (!node.mid) {
            node.mid = new TernarySearchTreeNode();
            node.mid.segment = iter.value();
          }
          node = node.mid;
        } else {
          break;
        }
      }
      var oldElement = node.value;
      node.value = element;
      node.key = key;
      return oldElement;
    }
  }, {
    key: "get",
    value: function get(key) {
      var _this$_getNode;
      return (_this$_getNode = this._getNode(key)) === null || _this$_getNode === void 0 ? void 0 : _this$_getNode.value;
    }
  }, {
    key: "_getNode",
    value: function _getNode(key) {
      var iter = this._iter.reset(key);
      var node = this._root;
      while (node) {
        var val = iter.cmp(node.segment);
        if (val > 0) {
          // left
          node = node.left;
        } else if (val < 0) {
          // right
          node = node.right;
        } else if (iter.hasNext()) {
          // mid
          iter.next();
          node = node.mid;
        } else {
          break;
        }
      }
      return node;
    }
  }, {
    key: "has",
    value: function has(key) {
      var node = this._getNode(key);
      return !((node === null || node === void 0 ? void 0 : node.value) === undefined && (node === null || node === void 0 ? void 0 : node.mid) === undefined);
    }
  }, {
    key: "delete",
    value: function _delete(key) {
      return this._delete(key, false);
    }
  }, {
    key: "deleteSuperstr",
    value: function deleteSuperstr(key) {
      return this._delete(key, true);
    }
  }, {
    key: "_delete",
    value: function _delete(key, superStr) {
      var iter = this._iter.reset(key);
      var stack = [];
      var node = this._root;

      // find and unset node
      while (node) {
        var val = iter.cmp(node.segment);
        if (val > 0) {
          // left
          stack.push([1, node]);
          node = node.left;
        } else if (val < 0) {
          // right
          stack.push([-1, node]);
          node = node.right;
        } else if (iter.hasNext()) {
          // mid
          iter.next();
          stack.push([0, node]);
          node = node.mid;
        } else {
          if (superStr) {
            // remove children
            node.left = undefined;
            node.mid = undefined;
            node.right = undefined;
          } else {
            // remove element
            node.value = undefined;
          }

          // clean up empty nodes
          while (stack.length > 0 && node.isEmpty()) {
            var _ref = stack.pop(),
              _ref2 = map_slicedToArray(_ref, 2),
              dir = _ref2[0],
              parent = _ref2[1];
            // eslint-disable-next-line default-case
            switch (dir) {
              case 1:
                parent.left = undefined;
                break;
              case 0:
                parent.mid = undefined;
                break;
              case -1:
                parent.right = undefined;
                break;
            }
            node = parent;
          }
          break;
        }
      }
    }
  }, {
    key: "findSubstr",
    value: function findSubstr(key) {
      var iter = this._iter.reset(key);
      var node = this._root;
      var candidate;
      while (node) {
        var val = iter.cmp(node.segment);
        if (val > 0) {
          // left
          node = node.left;
        } else if (val < 0) {
          // right
          node = node.right;
        } else if (iter.hasNext()) {
          // mid
          iter.next();
          candidate = node.value || candidate;
          node = node.mid;
        } else {
          break;
        }
      }
      return node && node.value || candidate;
    }
  }, {
    key: "findSuperstr",
    value: function findSuperstr(key) {
      var iter = this._iter.reset(key);
      var node = this._root;
      while (node) {
        var val = iter.cmp(node.segment);
        if (val > 0) {
          // left
          node = node.left;
        } else if (val < 0) {
          // right
          node = node.right;
        } else if (iter.hasNext()) {
          // mid
          iter.next();
          node = node.mid;
        } else {
          // collect
          if (!node.mid) {
            return undefined;
          }
          return this._entries(node.mid);
        }
      }
      return undefined;
    }
  }, {
    key: "forEach",
    value: function forEach(callback) {
      var _iterator = map_createForOfIteratorHelper(this),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _step$value = map_slicedToArray(_step.value, 2),
            _key = _step$value[0],
            _value = _step$value[1];
          callback(_value, _key);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }, {
    key: _Symbol$iterator,
    value: /*#__PURE__*/map_regeneratorRuntime().mark(function value() {
      return map_regeneratorRuntime().wrap(function value$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            return _context.delegateYield(this._entries(this._root), "t0", 1);
          case 1:
          case "end":
            return _context.stop();
        }
      }, value, this);
    })
  }, {
    key: "_entries",
    value: /*#__PURE__*/map_regeneratorRuntime().mark(function _entries(node) {
      return map_regeneratorRuntime().wrap(function _entries$(_context2) {
        while (1) switch (_context2.prev = _context2.next) {
          case 0:
            if (!node) {
              _context2.next = 7;
              break;
            }
            return _context2.delegateYield(this._entries(node.left), "t0", 2);
          case 2:
            if (!node.value) {
              _context2.next = 5;
              break;
            }
            _context2.next = 5;
            return [node.key, node.value];
          case 5:
            return _context2.delegateYield(this._entries(node.mid), "t1", 6);
          case 6:
            return _context2.delegateYield(this._entries(node.right), "t2", 7);
          case 7:
          case "end":
            return _context2.stop();
        }
      }, _entries, this);
    })
  }], [{
    key: "forUris",
    value: function forUris() {
      var ignorePathCasing = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : function () {
        return false;
      };
      return new TernarySearchTree(new UriIterator(ignorePathCasing));
    }
  }, {
    key: "forPaths",
    value: function forPaths() {
      return new TernarySearchTree(new PathIterator());
    }
  }, {
    key: "forStrings",
    value: function forStrings() {
      return new TernarySearchTree(new StringIterator());
    }
  }, {
    key: "forConfigKeys",
    value: function forConfigKeys() {
      return new TernarySearchTree(new ConfigKeysIterator());
    }
  }]);
  return TernarySearchTree;
}(Symbol.iterator);
_Symbol$toStringTag = Symbol.toStringTag;
_Symbol$iterator2 = Symbol.iterator;
var ResourceMap = /*#__PURE__*/function () {
  function ResourceMap(mapOrKeyFn, toKey) {
    map_classCallCheck(this, ResourceMap);
    this[_Symbol$toStringTag] = 'ResourceMap';
    if (mapOrKeyFn instanceof ResourceMap) {
      this.map = new Map(mapOrKeyFn.map);
      this.toKey = toKey !== null && toKey !== void 0 ? toKey : ResourceMap.defaultToKey;
    } else {
      this.map = new Map();
      this.toKey = mapOrKeyFn !== null && mapOrKeyFn !== void 0 ? mapOrKeyFn : ResourceMap.defaultToKey;
    }
  }
  map_createClass(ResourceMap, [{
    key: "set",
    value: function set(resource, value) {
      this.map.set(this.toKey(resource), value);
      return this;
    }
  }, {
    key: "get",
    value: function get(resource) {
      return this.map.get(this.toKey(resource));
    }
  }, {
    key: "has",
    value: function has(resource) {
      return this.map.has(this.toKey(resource));
    }
  }, {
    key: "size",
    get: function get() {
      return this.map.size;
    }
  }, {
    key: "clear",
    value: function clear() {
      this.map.clear();
    }
  }, {
    key: "delete",
    value: function _delete(resource) {
      return this.map.delete(this.toKey(resource));
    }
  }, {
    key: "forEach",
    value: function forEach(clb, thisArg) {
      if (typeof thisArg !== 'undefined') {
        clb = clb.bind(thisArg);
      }
      var _iterator2 = map_createForOfIteratorHelper(this.map),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _step2$value = map_slicedToArray(_step2.value, 2),
            _index = _step2$value[0],
            _value2 = _step2$value[1];
          clb(_value2, URI.parse(_index), this);
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "values",
    value: function values() {
      return this.map.values();
    }
  }, {
    key: "keys",
    value: /*#__PURE__*/map_regeneratorRuntime().mark(function keys() {
      var _iterator3, _step3, _key2;
      return map_regeneratorRuntime().wrap(function keys$(_context3) {
        while (1) switch (_context3.prev = _context3.next) {
          case 0:
            _iterator3 = map_createForOfIteratorHelper(this.map.keys());
            _context3.prev = 1;
            _iterator3.s();
          case 3:
            if ((_step3 = _iterator3.n()).done) {
              _context3.next = 9;
              break;
            }
            _key2 = _step3.value;
            _context3.next = 7;
            return URI.parse(_key2);
          case 7:
            _context3.next = 3;
            break;
          case 9:
            _context3.next = 14;
            break;
          case 11:
            _context3.prev = 11;
            _context3.t0 = _context3["catch"](1);
            _iterator3.e(_context3.t0);
          case 14:
            _context3.prev = 14;
            _iterator3.f();
            return _context3.finish(14);
          case 17:
          case "end":
            return _context3.stop();
        }
      }, keys, this, [[1, 11, 14, 17]]);
    })
  }, {
    key: "entries",
    value: /*#__PURE__*/map_regeneratorRuntime().mark(function entries() {
      var _iterator4, _step4, tuple;
      return map_regeneratorRuntime().wrap(function entries$(_context4) {
        while (1) switch (_context4.prev = _context4.next) {
          case 0:
            _iterator4 = map_createForOfIteratorHelper(this.map.entries());
            _context4.prev = 1;
            _iterator4.s();
          case 3:
            if ((_step4 = _iterator4.n()).done) {
              _context4.next = 9;
              break;
            }
            tuple = _step4.value;
            _context4.next = 7;
            return [URI.parse(tuple[0]), tuple[1]];
          case 7:
            _context4.next = 3;
            break;
          case 9:
            _context4.next = 14;
            break;
          case 11:
            _context4.prev = 11;
            _context4.t0 = _context4["catch"](1);
            _iterator4.e(_context4.t0);
          case 14:
            _context4.prev = 14;
            _iterator4.f();
            return _context4.finish(14);
          case 17:
          case "end":
            return _context4.stop();
        }
      }, entries, this, [[1, 11, 14, 17]]);
    })
  }, {
    key: _Symbol$iterator2,
    value: /*#__PURE__*/map_regeneratorRuntime().mark(function value() {
      var _iterator5, _step5, item;
      return map_regeneratorRuntime().wrap(function value$(_context5) {
        while (1) switch (_context5.prev = _context5.next) {
          case 0:
            _iterator5 = map_createForOfIteratorHelper(this.map);
            _context5.prev = 1;
            _iterator5.s();
          case 3:
            if ((_step5 = _iterator5.n()).done) {
              _context5.next = 9;
              break;
            }
            item = _step5.value;
            _context5.next = 7;
            return [URI.parse(item[0]), item[1]];
          case 7:
            _context5.next = 3;
            break;
          case 9:
            _context5.next = 14;
            break;
          case 11:
            _context5.prev = 11;
            _context5.t0 = _context5["catch"](1);
            _iterator5.e(_context5.t0);
          case 14:
            _context5.prev = 14;
            _iterator5.f();
            return _context5.finish(14);
          case 17:
          case "end":
            return _context5.stop();
        }
      }, value, this, [[1, 11, 14, 17]]);
    })
  }]);
  return ResourceMap;
}();
ResourceMap.defaultToKey = function (resource) {
  return resource.toString();
};
var Touch = /*#__PURE__*/function (Touch) {
  Touch[Touch["None"] = 0] = "None";
  Touch[Touch["AsOld"] = 1] = "AsOld";
  Touch[Touch["AsNew"] = 2] = "AsNew";
  return Touch;
}({});
_Symbol$toStringTag2 = Symbol.toStringTag;
_Symbol$iterator3 = Symbol.iterator;
var LinkedMap = /*#__PURE__*/function () {
  function LinkedMap() {
    map_classCallCheck(this, LinkedMap);
    this[_Symbol$toStringTag2] = 'LinkedMap';
    this._map = new Map();
    this._head = undefined;
    this._tail = undefined;
    this._size = 0;
    this._state = 0;
  }
  map_createClass(LinkedMap, [{
    key: "clear",
    value: function clear() {
      this._map.clear();
      this._head = undefined;
      this._tail = undefined;
      this._size = 0;
      this._state++;
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return !this._head && !this._tail;
    }
  }, {
    key: "size",
    get: function get() {
      return this._size;
    }
  }, {
    key: "first",
    get: function get() {
      var _this$_head;
      return (_this$_head = this._head) === null || _this$_head === void 0 ? void 0 : _this$_head.value;
    }
  }, {
    key: "last",
    get: function get() {
      var _this$_tail;
      return (_this$_tail = this._tail) === null || _this$_tail === void 0 ? void 0 : _this$_tail.value;
    }
  }, {
    key: "has",
    value: function has(key) {
      return this._map.has(key);
    }
  }, {
    key: "get",
    value: function get(key) {
      var touch = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Touch.None;
      var item = this._map.get(key);
      if (!item) {
        return undefined;
      }
      if (touch !== Touch.None) {
        this.touch(item, touch);
      }
      return item.value;
    }
  }, {
    key: "set",
    value: function set(key, value) {
      var touch = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : Touch.None;
      var item = this._map.get(key);
      if (item) {
        item.value = value;
        if (touch !== Touch.None) {
          this.touch(item, touch);
        }
      } else {
        item = {
          key: key,
          value: value,
          next: undefined,
          previous: undefined
        };
        switch (touch) {
          case Touch.None:
            this.addItemLast(item);
            break;
          case Touch.AsOld:
            this.addItemFirst(item);
            break;
          case Touch.AsNew:
            this.addItemLast(item);
            break;
          default:
            this.addItemLast(item);
            break;
        }
        this._map.set(key, item);
        this._size++;
      }
      return this;
    }
  }, {
    key: "delete",
    value: function _delete(key) {
      return !!this.remove(key);
    }
  }, {
    key: "remove",
    value: function remove(key) {
      var item = this._map.get(key);
      if (!item) {
        return undefined;
      }
      this._map.delete(key);
      this.removeItem(item);
      this._size--;
      return item.value;
    }
  }, {
    key: "shift",
    value: function shift() {
      if (!this._head && !this._tail) {
        return undefined;
      }
      if (!this._head || !this._tail) {
        throw new Error('Invalid list');
      }
      var item = this._head;
      this._map.delete(item.key);
      this.removeItem(item);
      this._size--;
      return item.value;
    }
  }, {
    key: "forEach",
    value: function forEach(callbackfn, thisArg) {
      var state = this._state;
      var current = this._head;
      while (current) {
        if (thisArg) {
          callbackfn.bind(thisArg)(current.value, current.key, this);
        } else {
          callbackfn(current.value, current.key, this);
        }
        if (this._state !== state) {
          throw new Error("LinkedMap got modified during iteration.");
        }
        current = current.next;
      }
    }
  }, {
    key: "keys",
    value: function keys() {
      var map = this;
      var state = this._state;
      var current = this._head;
      var iterator = map_defineProperty(map_defineProperty({}, Symbol.iterator, function () {
        return iterator;
      }), "next", function next() {
        if (map._state !== state) {
          throw new Error("LinkedMap got modified during iteration.");
        }
        if (current) {
          var result = {
            value: current.key,
            done: false
          };
          current = current.next;
          return result;
        }
        return {
          value: undefined,
          done: true
        };
      });
      return iterator;
    }
  }, {
    key: "values",
    value: function values() {
      var map = this;
      var state = this._state;
      var current = this._head;
      var iterator = map_defineProperty(map_defineProperty({}, Symbol.iterator, function () {
        return iterator;
      }), "next", function next() {
        if (map._state !== state) {
          throw new Error("LinkedMap got modified during iteration.");
        }
        if (current) {
          var result = {
            value: current.value,
            done: false
          };
          current = current.next;
          return result;
        }
        return {
          value: undefined,
          done: true
        };
      });
      return iterator;
    }
  }, {
    key: "entries",
    value: function entries() {
      var map = this;
      var state = this._state;
      var current = this._head;
      var iterator = map_defineProperty(map_defineProperty({}, Symbol.iterator, function () {
        return iterator;
      }), "next", function next() {
        if (map._state !== state) {
          throw new Error("LinkedMap got modified during iteration.");
        }
        if (current) {
          var result = {
            value: [current.key, current.value],
            done: false
          };
          current = current.next;
          return result;
        }
        return {
          value: undefined,
          done: true
        };
      });
      return iterator;
    }
  }, {
    key: _Symbol$iterator3,
    value: function value() {
      return this.entries();
    }
  }, {
    key: "trimOld",
    value: function trimOld(newSize) {
      if (newSize >= this.size) {
        return;
      }
      if (newSize === 0) {
        this.clear();
        return;
      }
      var current = this._head;
      var currentSize = this.size;
      while (current && currentSize > newSize) {
        this._map.delete(current.key);
        current = current.next;
        currentSize--;
      }
      this._head = current;
      this._size = currentSize;
      if (current) {
        current.previous = undefined;
      }
      this._state++;
    }
  }, {
    key: "addItemFirst",
    value: function addItemFirst(item) {
      // First time Insert
      if (!this._head && !this._tail) {
        this._tail = item;
      } else if (!this._head) {
        throw new Error('Invalid list');
      } else {
        item.next = this._head;
        this._head.previous = item;
      }
      this._head = item;
      this._state++;
    }
  }, {
    key: "addItemLast",
    value: function addItemLast(item) {
      // First time Insert
      if (!this._head && !this._tail) {
        this._head = item;
      } else if (!this._tail) {
        throw new Error('Invalid list');
      } else {
        item.previous = this._tail;
        this._tail.next = item;
      }
      this._tail = item;
      this._state++;
    }
  }, {
    key: "removeItem",
    value: function removeItem(item) {
      if (item === this._head && item === this._tail) {
        this._head = undefined;
        this._tail = undefined;
      } else if (item === this._head) {
        // This can only happend if size === 1 which is handle
        // by the case above.
        if (!item.next) {
          throw new Error('Invalid list');
        }
        item.next.previous = undefined;
        this._head = item.next;
      } else if (item === this._tail) {
        // This can only happend if size === 1 which is handle
        // by the case above.
        if (!item.previous) {
          throw new Error('Invalid list');
        }
        item.previous.next = undefined;
        this._tail = item.previous;
      } else {
        var next = item.next;
        var previous = item.previous;
        if (!next || !previous) {
          throw new Error('Invalid list');
        }
        next.previous = previous;
        previous.next = next;
      }
      item.next = undefined;
      item.previous = undefined;
      this._state++;
    }
  }, {
    key: "touch",
    value: function touch(item, _touch) {
      if (!this._head || !this._tail) {
        throw new Error('Invalid list');
      }
      if (_touch !== Touch.AsOld && _touch !== Touch.AsNew) {
        return;
      }
      if (_touch === Touch.AsOld) {
        if (item === this._head) {
          return;
        }
        var next = item.next;
        var previous = item.previous;

        // Unlink the item
        if (item === this._tail) {
          // previous must be defined since item was not head but is tail
          // So there are more than on item in the map
          previous.next = undefined;
          this._tail = previous;
        } else {
          // Both next and previous are not undefined since item was neither head nor tail.
          next.previous = previous;
          previous.next = next;
        }

        // Insert the node at head
        item.previous = undefined;
        item.next = this._head;
        this._head.previous = item;
        this._head = item;
        this._state++;
      } else if (_touch === Touch.AsNew) {
        if (item === this._tail) {
          return;
        }
        var _next = item.next;
        var _previous = item.previous;

        // Unlink the item.
        if (item === this._head) {
          // next must be defined since item was not tail but is head
          // So there are more than on item in the map
          _next.previous = undefined;
          this._head = _next;
        } else {
          // Both next and previous are not undefined since item was neither head nor tail.
          _next.previous = _previous;
          _previous.next = _next;
        }
        item.next = undefined;
        item.previous = this._tail;
        this._tail.next = item;
        this._tail = item;
        this._state++;
      }
    }
  }, {
    key: "toJSON",
    value: function toJSON() {
      var data = [];
      this.forEach(function (value, key) {
        data.push([key, value]);
      });
      return data;
    }
  }, {
    key: "fromJSON",
    value: function fromJSON(data) {
      this.clear();
      var _iterator9 = map_createForOfIteratorHelper(data),
        _step6;
      try {
        for (_iterator9.s(); !(_step6 = _iterator9.n()).done;) {
          var _step6$value = map_slicedToArray(_step6.value, 2),
            _key3 = _step6$value[0],
            _value3 = _step6$value[1];
          this.set(_key3, _value3);
        }
      } catch (err) {
        _iterator9.e(err);
      } finally {
        _iterator9.f();
      }
    }
  }]);
  return LinkedMap;
}();
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/uri.js
var es_uri = __webpack_require__(33478);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/assert.js
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

/**
 * Throws an error with the provided message if the provided value does not evaluate to a true Javascript value.
 */
function ok(value, message) {
  if (!value) {
    throw new Error(message ? "Assertion failed (".concat(message, ")") : 'Assertion Failed');
  }
}
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/valueTypes.js
var valueTypes = __webpack_require__(96745);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/platform.js
function platform_typeof(o) { "@babel/helpers - typeof"; return platform_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, platform_typeof(o); }
function platform_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function platform_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, platform_toPropertyKey(descriptor.key), descriptor); } }
function platform_createClass(Constructor, protoProps, staticProps) { if (protoProps) platform_defineProperties(Constructor.prototype, protoProps); if (staticProps) platform_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function platform_toPropertyKey(t) { var i = platform_toPrimitive(t, "string"); return "symbol" == platform_typeof(i) ? i : String(i); }
function platform_toPrimitive(t, r) { if ("object" != platform_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != platform_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var RegistryImpl = /*#__PURE__*/function () {
  function RegistryImpl() {
    platform_classCallCheck(this, RegistryImpl);
    this.data = new Map();
  }
  platform_createClass(RegistryImpl, [{
    key: "add",
    value: function add(id, data) {
      ok(valueTypes.isString(id));
      ok(valueTypes.isObject(data));
      ok(!this.data.has(id), 'There is already an extension with this id');
      this.data.set(id, data);
    }
  }, {
    key: "knows",
    value: function knows(id) {
      return this.data.has(id);
    }
  }, {
    key: "as",
    value: function as(id) {
      return this.data.get(id) || null;
    }
  }]);
  return RegistryImpl;
}();
var Registry = new RegistryImpl();
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/nls.js
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

/**
 * Localize a message.
 *
 * `message` can contain `{n}` notation where it is replaced by the nth value in `...args`
 * For example, `localize({ key: 'sayHello', comment: ['Welcomes user'] }, 'hello {0}', name)`
 */

/**
 * Localize a message.
 *
 * `message` can contain `{n}` notation where it is replaced by the nth value in `...args`
 * For example, `localize('sayHello', 'hello {0}', name)`
 */

function localize(key, message) {
  if (typeof key === 'string') {
    return key + message;
  }
  return key.comment + message;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/jsonContributionRegistry.js
function jsonContributionRegistry_typeof(o) { "@babel/helpers - typeof"; return jsonContributionRegistry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, jsonContributionRegistry_typeof(o); }
function jsonContributionRegistry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function jsonContributionRegistry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, jsonContributionRegistry_toPropertyKey(descriptor.key), descriptor); } }
function jsonContributionRegistry_createClass(Constructor, protoProps, staticProps) { if (protoProps) jsonContributionRegistry_defineProperties(Constructor.prototype, protoProps); if (staticProps) jsonContributionRegistry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function jsonContributionRegistry_toPropertyKey(t) { var i = jsonContributionRegistry_toPrimitive(t, "string"); return "symbol" == jsonContributionRegistry_typeof(i) ? i : String(i); }
function jsonContributionRegistry_toPrimitive(t, r) { if ("object" != jsonContributionRegistry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != jsonContributionRegistry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



var Extensions = {
  JSONContribution: 'base.contributions.json'
};
function normalizeId(id) {
  if (id.length > 0 && id.charAt(id.length - 1) === '#') {
    return id.substring(0, id.length - 1);
  }
  return id;
}
var JSONContributionRegistry = /*#__PURE__*/function () {
  function JSONContributionRegistry() {
    jsonContributionRegistry_classCallCheck(this, JSONContributionRegistry);
    this._onDidChangeSchema = new es_event/* Emitter */.Q5();
    this.onDidChangeSchema = this._onDidChangeSchema.event;
    this.schemasById = {};
  }
  jsonContributionRegistry_createClass(JSONContributionRegistry, [{
    key: "registerSchema",
    value: function registerSchema(uri, unresolvedSchemaContent) {
      this.schemasById[normalizeId(uri)] = unresolvedSchemaContent;
      this._onDidChangeSchema.fire(uri);
    }
  }, {
    key: "notifySchemaChanged",
    value: function notifySchemaChanged(uri) {
      this._onDidChangeSchema.fire(uri);
    }
  }, {
    key: "getSchemaContributions",
    value: function getSchemaContributions() {
      return {
        schemas: this.schemasById
      };
    }
  }]);
  return JSONContributionRegistry;
}();
var jsonContributionRegistry = new JSONContributionRegistry();
Registry.add(Extensions.JSONContribution, jsonContributionRegistry);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/configuration/configurationRegistry.js
function configurationRegistry_typeof(o) { "@babel/helpers - typeof"; return configurationRegistry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configurationRegistry_typeof(o); }
function configurationRegistry_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function configurationRegistry_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? configurationRegistry_ownKeys(Object(t), !0).forEach(function (r) { configurationRegistry_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : configurationRegistry_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function configurationRegistry_defineProperty(obj, key, value) { key = configurationRegistry_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function configurationRegistry_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = configurationRegistry_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function configurationRegistry_toConsumableArray(arr) { return configurationRegistry_arrayWithoutHoles(arr) || configurationRegistry_iterableToArray(arr) || configurationRegistry_unsupportedIterableToArray(arr) || configurationRegistry_nonIterableSpread(); }
function configurationRegistry_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function configurationRegistry_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return configurationRegistry_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return configurationRegistry_arrayLikeToArray(o, minLen); }
function configurationRegistry_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function configurationRegistry_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return configurationRegistry_arrayLikeToArray(arr); }
function configurationRegistry_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function configurationRegistry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configurationRegistry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configurationRegistry_toPropertyKey(descriptor.key), descriptor); } }
function configurationRegistry_createClass(Constructor, protoProps, staticProps) { if (protoProps) configurationRegistry_defineProperties(Constructor.prototype, protoProps); if (staticProps) configurationRegistry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configurationRegistry_toPropertyKey(t) { var i = configurationRegistry_toPrimitive(t, "string"); return "symbol" == configurationRegistry_typeof(i) ? i : String(i); }
function configurationRegistry_toPrimitive(t, r) { if ("object" != configurationRegistry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configurationRegistry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable @typescript-eslint/no-use-before-define */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/





var configurationRegistry_Extensions = {
  Configuration: 'base.contributions.configuration'
};
var ConfigurationScope = /*#__PURE__*/function (ConfigurationScope) {
  ConfigurationScope[ConfigurationScope["APPLICATION"] = 1] = "APPLICATION";
  ConfigurationScope[ConfigurationScope["MACHINE"] = 2] = "MACHINE";
  ConfigurationScope[ConfigurationScope["WINDOW"] = 3] = "WINDOW";
  ConfigurationScope[ConfigurationScope["RESOURCE"] = 4] = "RESOURCE";
  ConfigurationScope[ConfigurationScope["LANGUAGE_OVERRIDABLE"] = 5] = "LANGUAGE_OVERRIDABLE";
  ConfigurationScope[ConfigurationScope["MACHINE_OVERRIDABLE"] = 6] = "MACHINE_OVERRIDABLE";
  return ConfigurationScope;
}({});
var allSettings = {
  properties: {},
  patternProperties: {}
};
var applicationSettings = {
  properties: {},
  patternProperties: {}
};
var machineSettings = {
  properties: {},
  patternProperties: {}
};
var machineOverridableSettings = {
  properties: {},
  patternProperties: {}
};
var windowSettings = {
  properties: {},
  patternProperties: {}
};
var resourceSettings = {
  properties: {},
  patternProperties: {}
};
var resourceLanguageSettingsSchemaId = 'vscode://schemas/settings/resourceLanguage';
var contributionRegistry = Registry.as(Extensions.JSONContribution);
var configurationRegistry_ConfigurationRegistry = /*#__PURE__*/function () {
  function ConfigurationRegistry() {
    configurationRegistry_classCallCheck(this, ConfigurationRegistry);
    this.overrideIdentifiers = new Set();
    this._onDidSchemaChange = new es_event/* Emitter */.Q5();
    this.onDidSchemaChange = this._onDidSchemaChange.event;
    this._onDidUpdateConfiguration = new es_event/* Emitter */.Q5();
    this.onDidUpdateConfiguration = this._onDidUpdateConfiguration.event;
    this.defaultValues = {};
    this.defaultLanguageConfigurationOverridesNode = {
      id: 'defaultOverrides',
      title: localize('defaultLanguageConfigurationOverrides.title', 'Default Language Configuration Overrides'),
      properties: {}
    };
    this.configurationContributors = [this.defaultLanguageConfigurationOverridesNode];
    this.resourceLanguageSettingsSchema = {
      properties: {},
      patternProperties: {},
      additionalProperties: false,
      errorMessage: 'Unknown editor configuration setting',
      allowTrailingCommas: true,
      allowComments: true
    };
    this.configurationProperties = {};
    this.excludedConfigurationProperties = {};
    contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
  }
  configurationRegistry_createClass(ConfigurationRegistry, [{
    key: "registerConfiguration",
    value: function registerConfiguration(configuration) {
      var validate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      this.registerConfigurations([configuration], validate);
    }
  }, {
    key: "registerConfigurations",
    value: function registerConfigurations(configurations) {
      var _this = this;
      var validate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var properties = [];
      configurations.forEach(function (configuration) {
        properties.push.apply(properties, configurationRegistry_toConsumableArray(_this.validateAndRegisterProperties(configuration, validate))); // fills in defaults
        _this.configurationContributors.push(configuration);
        _this.registerJSONConfiguration(configuration);
      });
      contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
      this._onDidSchemaChange.fire();
      this._onDidUpdateConfiguration.fire(properties);
    }
  }, {
    key: "deregisterConfigurations",
    value: function deregisterConfigurations(configurations) {
      var _this2 = this;
      var properties = [];
      var deregisterConfiguration = function deregisterConfiguration(configuration) {
        if (configuration.properties) {
          for (var key in configuration.properties) {
            properties.push(key);
            delete _this2.configurationProperties[key];
            _this2.removeFromSchema(key, configuration.properties[key]);
          }
        }
        if (configuration.allOf) {
          configuration.allOf.forEach(function (node) {
            return deregisterConfiguration(node);
          });
        }
      };
      var _iterator = configurationRegistry_createForOfIteratorHelper(configurations),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var _configuration = _step.value;
          deregisterConfiguration(_configuration);
          var index = this.configurationContributors.indexOf(_configuration);
          if (index !== -1) {
            this.configurationContributors.splice(index, 1);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      contributionRegistry.registerSchema(resourceLanguageSettingsSchemaId, this.resourceLanguageSettingsSchema);
      this._onDidSchemaChange.fire();
      this._onDidUpdateConfiguration.fire(properties);
    }
  }, {
    key: "registerDefaultConfigurations",
    value: function registerDefaultConfigurations(defaultConfigurations) {
      var properties = [];
      var overrideIdentifiers = [];
      var _iterator2 = configurationRegistry_createForOfIteratorHelper(defaultConfigurations),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var defaultConfiguration = _step2.value;
          for (var key in defaultConfiguration) {
            properties.push(key);
            if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
              this.defaultValues[key] = configurationRegistry_objectSpread(configurationRegistry_objectSpread({}, this.defaultValues[key] || {}), defaultConfiguration[key]);
              var property = {
                type: 'object',
                default: this.defaultValues[key],
                description: localize('defaultLanguageConfiguration.description', 'Configure settings to be overridden for {0} language.', key),
                $ref: resourceLanguageSettingsSchemaId
              };
              overrideIdentifiers.push(overrideIdentifierFromKey(key));
              this.configurationProperties[key] = property;
              this.defaultLanguageConfigurationOverridesNode.properties[key] = property;
            } else {
              this.defaultValues[key] = defaultConfiguration[key];
              var _property = this.configurationProperties[key];
              if (_property) {
                this.updatePropertyDefaultValue(key, _property);
                this.updateSchema(key, _property);
              }
            }
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      this.registerOverrideIdentifiers(overrideIdentifiers);
      this._onDidSchemaChange.fire();
      this._onDidUpdateConfiguration.fire(properties);
    }
  }, {
    key: "deregisterDefaultConfigurations",
    value: function deregisterDefaultConfigurations(defaultConfigurations) {
      var properties = [];
      var _iterator3 = configurationRegistry_createForOfIteratorHelper(defaultConfigurations),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var defaultConfiguration = _step3.value;
          for (var key in defaultConfiguration) {
            properties.push(key);
            delete this.defaultValues[key];
            if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
              delete this.configurationProperties[key];
              delete this.defaultLanguageConfigurationOverridesNode.properties[key];
            } else {
              var property = this.configurationProperties[key];
              if (property) {
                this.updatePropertyDefaultValue(key, property);
                this.updateSchema(key, property);
              }
            }
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      this.updateOverridePropertyPatternKey();
      this._onDidSchemaChange.fire();
      this._onDidUpdateConfiguration.fire(properties);
    }
  }, {
    key: "notifyConfigurationSchemaUpdated",
    value: function notifyConfigurationSchemaUpdated() {
      this._onDidSchemaChange.fire();
    }
  }, {
    key: "registerOverrideIdentifiers",
    value: function registerOverrideIdentifiers(overrideIdentifiers) {
      var _iterator4 = configurationRegistry_createForOfIteratorHelper(overrideIdentifiers),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var overrideIdentifier = _step4.value;
          this.overrideIdentifiers.add(overrideIdentifier);
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      this.updateOverridePropertyPatternKey();
    }
  }, {
    key: "validateAndRegisterProperties",
    value: function validateAndRegisterProperties(configuration) {
      var validate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
      var scope = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ConfigurationScope.WINDOW;
      scope = valueTypes.isUndefinedOrNull(configuration.scope) ? scope : configuration.scope;
      var propertyKeys = [];
      var properties = configuration.properties;
      if (properties) {
        for (var key in properties) {
          if (validate && validateProperty(key)) {
            delete properties[key];
            continue;
          }
          var property = properties[key];

          // update default value
          this.updatePropertyDefaultValue(key, property);

          // update scope
          if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
            property.scope = undefined; // No scope for overridable properties `[${identifier}]`
          } else {
            property.scope = valueTypes.isUndefinedOrNull(property.scope) ? scope : property.scope;
          }

          // Add to properties maps
          // Property is included by default if 'included' is unspecified
          if (Object.prototype.hasOwnProperty.call(properties[key], 'included') && !properties[key].included) {
            this.excludedConfigurationProperties[key] = properties[key];
            delete properties[key];
            continue;
          } else {
            this.configurationProperties[key] = properties[key];
          }
          if (!properties[key].deprecationMessage && properties[key].markdownDeprecationMessage) {
            // If not set, default deprecationMessage to the markdown source
            properties[key].deprecationMessage = properties[key].markdownDeprecationMessage;
          }
          propertyKeys.push(key);
        }
      }
      var subNodes = configuration.allOf;
      if (subNodes) {
        var _iterator5 = configurationRegistry_createForOfIteratorHelper(subNodes),
          _step5;
        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var node = _step5.value;
            propertyKeys.push.apply(propertyKeys, configurationRegistry_toConsumableArray(this.validateAndRegisterProperties(node, validate, scope)));
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }
      }
      return propertyKeys;
    }
  }, {
    key: "getConfigurations",
    value: function getConfigurations() {
      return this.configurationContributors;
    }
  }, {
    key: "getConfigurationProperties",
    value: function getConfigurationProperties() {
      return this.configurationProperties;
    }
  }, {
    key: "getExcludedConfigurationProperties",
    value: function getExcludedConfigurationProperties() {
      return this.excludedConfigurationProperties;
    }
  }, {
    key: "registerJSONConfiguration",
    value: function registerJSONConfiguration(configuration) {
      var _this3 = this;
      var register = function register(configuration) {
        var properties = configuration.properties;
        if (properties) {
          for (var key in properties) {
            _this3.updateSchema(key, properties[key]);
          }
        }
        var subNodes = configuration.allOf;
        if (subNodes) {
          subNodes.forEach(register);
        }
      };
      register(configuration);
    }
  }, {
    key: "updateSchema",
    value: function updateSchema(key, property) {
      allSettings.properties[key] = property;
      switch (property.scope) {
        case ConfigurationScope.APPLICATION:
          applicationSettings.properties[key] = property;
          break;
        case ConfigurationScope.MACHINE:
          machineSettings.properties[key] = property;
          break;
        case ConfigurationScope.MACHINE_OVERRIDABLE:
          machineOverridableSettings.properties[key] = property;
          break;
        case ConfigurationScope.WINDOW:
          windowSettings.properties[key] = property;
          break;
        case ConfigurationScope.RESOURCE:
          resourceSettings.properties[key] = property;
          break;
        case ConfigurationScope.LANGUAGE_OVERRIDABLE:
          resourceSettings.properties[key] = property;
          this.resourceLanguageSettingsSchema.properties[key] = property;
          break;
      }
    }
  }, {
    key: "removeFromSchema",
    value: function removeFromSchema(key, property) {
      delete allSettings.properties[key];
      switch (property.scope) {
        case ConfigurationScope.APPLICATION:
          delete applicationSettings.properties[key];
          break;
        case ConfigurationScope.MACHINE:
          delete machineSettings.properties[key];
          break;
        case ConfigurationScope.MACHINE_OVERRIDABLE:
          delete machineOverridableSettings.properties[key];
          break;
        case ConfigurationScope.WINDOW:
          delete windowSettings.properties[key];
          break;
        case ConfigurationScope.RESOURCE:
        case ConfigurationScope.LANGUAGE_OVERRIDABLE:
          delete resourceSettings.properties[key];
          break;
      }
    }
  }, {
    key: "updateOverridePropertyPatternKey",
    value: function updateOverridePropertyPatternKey() {
      var _iterator6 = configurationRegistry_createForOfIteratorHelper(this.overrideIdentifiers.values()),
        _step6;
      try {
        for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
          var overrideIdentifier = _step6.value;
          var overrideIdentifierProperty = "[".concat(overrideIdentifier, "]");
          var resourceLanguagePropertiesSchema = {
            type: 'object',
            description: localize('overrideSettings.defaultDescription', 'Configure editor settings to be overridden for a language.'),
            errorMessage: localize('overrideSettings.errorMessage', 'This setting does not support per-language configuration.'),
            $ref: resourceLanguageSettingsSchemaId
          };
          this.updatePropertyDefaultValue(overrideIdentifierProperty, resourceLanguagePropertiesSchema);
          allSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          applicationSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          machineSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          machineOverridableSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          windowSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
          resourceSettings.properties[overrideIdentifierProperty] = resourceLanguagePropertiesSchema;
        }
      } catch (err) {
        _iterator6.e(err);
      } finally {
        _iterator6.f();
      }
      this._onDidSchemaChange.fire();
    }
  }, {
    key: "updatePropertyDefaultValue",
    value: function updatePropertyDefaultValue(key, property) {
      var defaultValue = this.defaultValues[key];
      if (valueTypes.isUndefined(defaultValue)) {
        defaultValue = property.default;
      }
      if (valueTypes.isUndefined(defaultValue)) {
        defaultValue = getDefaultValue(property.type);
      }
      property.default = defaultValue;
    }
  }]);
  return ConfigurationRegistry;
}();
var OVERRIDE_PROPERTY = '\\[.*\\]$';
var OVERRIDE_PROPERTY_PATTERN = new RegExp(OVERRIDE_PROPERTY);
function overrideIdentifierFromKey(key) {
  return key.substring(1, key.length - 1);
}
function getDefaultValue(type) {
  var t = Array.isArray(type) ? type[0] : type;
  switch (t) {
    case 'boolean':
      return false;
    case 'integer':
    case 'number':
      return 0;
    case 'string':
      return '';
    case 'array':
      return [];
    case 'object':
      return {};
    default:
      return null;
  }
}
var configurationRegistry = new configurationRegistry_ConfigurationRegistry();
Registry.add(configurationRegistry_Extensions.Configuration, configurationRegistry);
function validateProperty(property) {
  if (!property.trim()) {
    return localize('config.property.empty', 'Cannot register an empty property');
  }
  if (OVERRIDE_PROPERTY_PATTERN.test(property)) {
    return localize('config.property.languageDefault', "Cannot register '{0}'. This matches property pattern '\\\\[.*\\\\]$' for describing language specific editor settings. Use 'configurationDefaults' contribution.", property);
  }
  if (configurationRegistry.getConfigurationProperties()[property] !== undefined) {
    return localize('config.property.duplicate', "Cannot register '{0}'. This property is already registered.", property);
  }
  return null;
}
function getScopes() {
  var scopes = [];
  var configurationProperties = configurationRegistry.getConfigurationProperties();
  for (var _i = 0, _Object$keys = Object.keys(configurationProperties); _i < _Object$keys.length; _i++) {
    var key = _Object$keys[_i];
    scopes.push([key, configurationProperties[key].scope]);
  }
  scopes.push(['launch', ConfigurationScope.RESOURCE]);
  scopes.push(['task', ConfigurationScope.RESOURCE]);
  return scopes;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/configuration/configuration.js
function configuration_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = configuration_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function configuration_toConsumableArray(arr) { return configuration_arrayWithoutHoles(arr) || configuration_iterableToArray(arr) || configuration_unsupportedIterableToArray(arr) || configuration_nonIterableSpread(); }
function configuration_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function configuration_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return configuration_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return configuration_arrayLikeToArray(o, minLen); }
function configuration_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function configuration_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return configuration_arrayLikeToArray(arr); }
function configuration_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function configuration_typeof(o) { "@babel/helpers - typeof"; return configuration_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configuration_typeof(o); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/





// import type { IWorkspaceFolder } from 'vs/platform/workspace/common/workspace';
// import { createDecorator } from 'vs/platform/instantiation/common/instantiation';



// export const IConfigurationService = createDecorator<IConfigurationService>('configurationService');
var IConfigurationService = mana_syringe_es/* Syringe */.J3.defineToken('IConfigurationService');
function isConfigurationOverrides(thing) {
  return thing && configuration_typeof(thing) === 'object' && (!thing.overrideIdentifier || typeof thing.overrideIdentifier === 'string') && (!thing.resource || thing.resource instanceof es_uri/* URI */.o);
}
var ConfigurationTarget = /*#__PURE__*/function (ConfigurationTarget) {
  ConfigurationTarget[ConfigurationTarget["USER"] = 1] = "USER";
  ConfigurationTarget[ConfigurationTarget["USER_LOCAL"] = 2] = "USER_LOCAL";
  ConfigurationTarget[ConfigurationTarget["USER_REMOTE"] = 3] = "USER_REMOTE";
  ConfigurationTarget[ConfigurationTarget["WORKSPACE"] = 4] = "WORKSPACE";
  ConfigurationTarget[ConfigurationTarget["WORKSPACE_FOLDER"] = 5] = "WORKSPACE_FOLDER";
  ConfigurationTarget[ConfigurationTarget["DEFAULT"] = 6] = "DEFAULT";
  ConfigurationTarget[ConfigurationTarget["MEMORY"] = 7] = "MEMORY";
  return ConfigurationTarget;
}({});
function ConfigurationTargetToString(configurationTarget) {
  switch (configurationTarget) {
    case ConfigurationTarget.USER:
      return 'USER';
    case ConfigurationTarget.USER_LOCAL:
      return 'USER_LOCAL';
    case ConfigurationTarget.USER_REMOTE:
      return 'USER_REMOTE';
    case ConfigurationTarget.WORKSPACE:
      return 'WORKSPACE';
    case ConfigurationTarget.WORKSPACE_FOLDER:
      return 'WORKSPACE_FOLDER';
    case ConfigurationTarget.DEFAULT:
      return 'DEFAULT';
    case ConfigurationTarget.MEMORY:
      return 'MEMORY';
  }
}
function configuration_compare(from, to) {
  var added = to ? from ? to.keys.filter(function (key) {
    return from.keys.indexOf(key) === -1;
  }) : configuration_toConsumableArray(to.keys) : [];
  var removed = from ? to ? from.keys.filter(function (key) {
    return to.keys.indexOf(key) === -1;
  }) : configuration_toConsumableArray(from.keys) : [];
  var updated = [];
  if (to && from) {
    var _iterator = configuration_createForOfIteratorHelper(from.keys),
      _step;
    try {
      for (_iterator.s(); !(_step = _iterator.n()).done;) {
        var _key = _step.value;
        if (to.keys.indexOf(_key) !== -1) {
          var value1 = getConfigurationValue(from.contents, _key);
          var value2 = getConfigurationValue(to.contents, _key);
          if (!objects.objectEquals(value1, value2)) {
            updated.push(_key);
          }
        }
      }
    } catch (err) {
      _iterator.e(err);
    } finally {
      _iterator.f();
    }
  }
  var overrides = [];
  var byOverrideIdentifier = function byOverrideIdentifier(overrides) {
    var result = {};
    var _iterator2 = configuration_createForOfIteratorHelper(overrides),
      _step2;
    try {
      for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
        var override = _step2.value;
        var _iterator3 = configuration_createForOfIteratorHelper(override.identifiers),
          _step3;
        try {
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            var identifier = _step3.value;
            result[keyFromOverrideIdentifier(identifier)] = override;
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
      }
    } catch (err) {
      _iterator2.e(err);
    } finally {
      _iterator2.f();
    }
    return result;
  };
  var toOverridesByIdentifier = to ? byOverrideIdentifier(to.overrides) : {};
  var fromOverridesByIdentifier = from ? byOverrideIdentifier(from.overrides) : {};
  if (Object.keys(toOverridesByIdentifier).length) {
    var _iterator4 = configuration_createForOfIteratorHelper(added),
      _step4;
    try {
      for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
        var _key2 = _step4.value;
        var override = toOverridesByIdentifier[_key2];
        if (override) {
          overrides.push([overrideIdentifierFromKey(_key2), override.keys]);
        }
      }
    } catch (err) {
      _iterator4.e(err);
    } finally {
      _iterator4.f();
    }
  }
  if (Object.keys(fromOverridesByIdentifier).length) {
    var _iterator5 = configuration_createForOfIteratorHelper(removed),
      _step5;
    try {
      for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
        var _key3 = _step5.value;
        var _override = fromOverridesByIdentifier[_key3];
        if (_override) {
          overrides.push([overrideIdentifierFromKey(_key3), _override.keys]);
        }
      }
    } catch (err) {
      _iterator5.e(err);
    } finally {
      _iterator5.f();
    }
  }
  if (Object.keys(toOverridesByIdentifier).length && Object.keys(fromOverridesByIdentifier).length) {
    var _iterator6 = configuration_createForOfIteratorHelper(updated),
      _step6;
    try {
      for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
        var _key4 = _step6.value;
        var fromOverride = fromOverridesByIdentifier[_key4];
        var toOverride = toOverridesByIdentifier[_key4];
        if (fromOverride && toOverride) {
          var result = configuration_compare({
            contents: fromOverride.contents,
            keys: fromOverride.keys,
            overrides: []
          }, {
            contents: toOverride.contents,
            keys: toOverride.keys,
            overrides: []
          });
          overrides.push([overrideIdentifierFromKey(_key4), [].concat(configuration_toConsumableArray(result.added), configuration_toConsumableArray(result.removed), configuration_toConsumableArray(result.updated))]);
        }
      }
    } catch (err) {
      _iterator6.e(err);
    } finally {
      _iterator6.f();
    }
  }
  return {
    added: added,
    removed: removed,
    updated: updated,
    overrides: overrides
  };
}
function toOverrides(raw, conflictReporter) {
  var overrides = [];
  for (var _i = 0, _Object$keys = Object.keys(raw); _i < _Object$keys.length; _i++) {
    var _key5 = _Object$keys[_i];
    if (OVERRIDE_PROPERTY_PATTERN.test(_key5)) {
      var overrideRaw = {};
      for (var keyInOverrideRaw in raw[_key5]) {
        overrideRaw[keyInOverrideRaw] = raw[_key5][keyInOverrideRaw];
      }
      overrides.push({
        identifiers: [overrideIdentifierFromKey(_key5).trim()],
        keys: Object.keys(overrideRaw),
        contents: toValuesTree(overrideRaw, conflictReporter)
      });
    }
  }
  return overrides;
}
function toValuesTree(properties, conflictReporter) {
  var root = Object.create(null);
  for (var _key6 in properties) {
    addToValueTree(root, _key6, properties[_key6], conflictReporter);
  }
  return root;
}
function addToValueTree(settingsTreeRoot, key, value, conflictReporter) {
  var segments = key.split('.');
  var last = segments.pop();
  var curr = settingsTreeRoot;
  for (var i = 0; i < segments.length; i++) {
    var s = segments[i];
    var obj = curr[s];
    switch (configuration_typeof(obj)) {
      case 'undefined':
        obj = curr[s] = Object.create(null);
        break;
      case 'object':
        break;
      default:
        conflictReporter("Ignoring ".concat(key, " as ").concat(segments.slice(0, i + 1).join('.'), " is ").concat(JSON.stringify(obj)));
        return;
    }
    curr = obj;
  }
  if (configuration_typeof(curr) === 'object' && curr !== null) {
    try {
      curr[last] = value; // workaround https://github.com/microsoft/vscode/issues/13606
    } catch (e) {
      conflictReporter("Ignoring ".concat(key, " as ").concat(segments.join('.'), " is ").concat(JSON.stringify(curr)));
    }
  } else {
    conflictReporter("Ignoring ".concat(key, " as ").concat(segments.join('.'), " is ").concat(JSON.stringify(curr)));
  }
}
function removeFromValueTree(valueTree, key) {
  var segments = key.split('.');
  doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
  var first = segments.shift();
  if (segments.length === 0) {
    // Reached last segment
    delete valueTree[first];
    return;
  }
  if (Object.keys(valueTree).indexOf(first) !== -1) {
    var _value = valueTree[first];
    if (configuration_typeof(_value) === 'object' && !Array.isArray(_value)) {
      doRemoveFromValueTree(_value, segments);
      if (Object.keys(_value).length === 0) {
        delete valueTree[first];
      }
    }
  }
}

/**
 * A helper function to get the configuration value with a specific settings path (e.g. config.some.setting)
 */
function getConfigurationValue(config, settingPath, defaultValue) {
  function accessSetting(config, path) {
    var current = config;
    var _iterator7 = configuration_createForOfIteratorHelper(path),
      _step7;
    try {
      for (_iterator7.s(); !(_step7 = _iterator7.n()).done;) {
        var component = _step7.value;
        if (configuration_typeof(current) !== 'object' || current === null) {
          return undefined;
        }
        current = current[component];
      }
    } catch (err) {
      _iterator7.e(err);
    } finally {
      _iterator7.f();
    }
    return current;
  }
  var path = settingPath.split('.');
  var result = accessSetting(config, path);
  return typeof result === 'undefined' ? defaultValue : result;
}
function merge(base, add, overwrite) {
  Object.keys(add).forEach(function (key) {
    if (key !== '__proto__') {
      if (key in base) {
        if (types.isObject(base[key]) && types.isObject(add[key])) {
          merge(base[key], add[key], overwrite);
        } else if (overwrite) {
          base[key] = add[key];
        }
      } else {
        base[key] = add[key];
      }
    }
  });
}
function getConfigurationKeys() {
  var properties = Registry.as(configurationRegistry_Extensions.Configuration).getConfigurationProperties();
  return Object.keys(properties);
}
function getDefaultValues() {
  var valueTreeRoot = Object.create(null);
  var properties = Registry.as(configurationRegistry_Extensions.Configuration).getConfigurationProperties();
  for (var _key7 in properties) {
    var _value2 = properties[_key7].default;
    addToValueTree(valueTreeRoot, _key7, _value2, function (message) {
      return console.error("Conflict in default settings: ".concat(message));
    });
  }
  return valueTreeRoot;
}
function keyFromOverrideIdentifier(overrideIdentifier) {
  return "[".concat(overrideIdentifier, "]");
}
function getMigratedSettingValue(configurationService, currentSettingName, legacySettingName) {
  var setting = configurationService.inspect(currentSettingName);
  var legacySetting = configurationService.inspect(legacySettingName);
  if (typeof setting.userValue !== 'undefined' || typeof setting.workspaceValue !== 'undefined' || typeof setting.workspaceFolderValue !== 'undefined') {
    return setting.value;
  }
  if (typeof legacySetting.userValue !== 'undefined' || typeof legacySetting.workspaceValue !== 'undefined' || typeof legacySetting.workspaceFolderValue !== 'undefined') {
    return legacySetting.value;
  }
  return setting.defaultValue;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/contextKeyService.js
var contextKeyService_dec, contextKeyService_class, contextKeyService_descriptor, _NullContext, contextKeyService_dec2, contextKeyService_class2, contextKeyService_dec3, contextKeyService_class3;
function contextKeyService_typeof(o) { "@babel/helpers - typeof"; return contextKeyService_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, contextKeyService_typeof(o); }
function contextKeyService_toConsumableArray(arr) { return contextKeyService_arrayWithoutHoles(arr) || contextKeyService_iterableToArray(arr) || contextKeyService_unsupportedIterableToArray(arr) || contextKeyService_nonIterableSpread(); }
function contextKeyService_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function contextKeyService_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function contextKeyService_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return contextKeyService_arrayLikeToArray(arr); }
function contextKeyService_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = contextKeyService_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function contextKeyService_slicedToArray(arr, i) { return contextKeyService_arrayWithHoles(arr) || contextKeyService_iterableToArrayLimit(arr, i) || contextKeyService_unsupportedIterableToArray(arr, i) || contextKeyService_nonIterableRest(); }
function contextKeyService_nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function contextKeyService_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return contextKeyService_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return contextKeyService_arrayLikeToArray(o, minLen); }
function contextKeyService_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function contextKeyService_iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function contextKeyService_arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function _get() { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get.bind(); } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(arguments.length < 3 ? target : receiver); } return desc.value; }; } return _get.apply(this, arguments); }
function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = contextKeyService_getPrototypeOf(object); if (object === null) break; } return object; }
function contextKeyService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) contextKeyService_setPrototypeOf(subClass, superClass); }
function contextKeyService_setPrototypeOf(o, p) { contextKeyService_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return contextKeyService_setPrototypeOf(o, p); }
function contextKeyService_createSuper(Derived) { var hasNativeReflectConstruct = contextKeyService_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = contextKeyService_getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = contextKeyService_getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return contextKeyService_possibleConstructorReturn(this, result); }; }
function contextKeyService_possibleConstructorReturn(self, call) { if (call && (contextKeyService_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return contextKeyService_assertThisInitialized(self); }
function contextKeyService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function contextKeyService_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function contextKeyService_getPrototypeOf(o) { contextKeyService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return contextKeyService_getPrototypeOf(o); }
function contextKeyService_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function contextKeyService_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? contextKeyService_ownKeys(Object(t), !0).forEach(function (r) { contextKeyService_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : contextKeyService_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function contextKeyService_defineProperty(obj, key, value) { key = contextKeyService_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function contextKeyService_initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function contextKeyService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function contextKeyService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, contextKeyService_toPropertyKey(descriptor.key), descriptor); } }
function contextKeyService_createClass(Constructor, protoProps, staticProps) { if (protoProps) contextKeyService_defineProperties(Constructor.prototype, protoProps); if (staticProps) contextKeyService_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function contextKeyService_toPropertyKey(t) { var i = contextKeyService_toPrimitive(t, "string"); return "symbol" == contextKeyService_typeof(i) ? i : String(i); }
function contextKeyService_toPrimitive(t, r) { if ("object" != contextKeyService_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != contextKeyService_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function contextKeyService_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function contextKeyService_initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/










var KEYBINDING_CONTEXT_ATTR = 'data-mana-keybinding-context';
var Context = (contextKeyService_dec = (0,es/* prop */.vg)(), (contextKeyService_class = /*#__PURE__*/function () {
  function Context(id, parent) {
    contextKeyService_classCallCheck(this, Context);
    contextKeyService_initializerDefineProperty(this, "_value", contextKeyService_descriptor, this);
    this._id = id;
    this._parent = parent;
    this._value = Object.create(null);
    this._value['_contextId'] = id;
  }
  contextKeyService_createClass(Context, [{
    key: "setValue",
    value: function setValue(key, value) {
      if (this._value[key] !== value) {
        this._value[key] = value;
        return true;
      }
      return false;
    }
  }, {
    key: "removeValue",
    value: function removeValue(key) {
      if (key in this._value) {
        delete this._value[key];
        return true;
      }
      return false;
    }
  }, {
    key: "getValue",
    value: function getValue(key) {
      var ret = this._value[key];
      if (typeof ret === 'undefined' && this._parent) {
        return this._parent.getValue(key);
      }
      return ret;
    }
  }, {
    key: "updateParent",
    value: function updateParent(parent) {
      this._parent = parent;
    }
  }, {
    key: "collectAllValues",
    value: function collectAllValues() {
      var result = this._parent ? this._parent.collectAllValues() : Object.create(null);
      result = contextKeyService_objectSpread(contextKeyService_objectSpread({}, result), this._value);
      delete result._contextId;
      return result;
    }
  }]);
  return Context;
}(), (contextKeyService_descriptor = contextKeyService_applyDecoratedDescriptor(contextKeyService_class.prototype, "_value", [contextKeyService_dec], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
})), contextKeyService_class));
var NullContext = /*#__PURE__*/function (_Context2) {
  contextKeyService_inherits(NullContext, _Context2);
  var _super = contextKeyService_createSuper(NullContext);
  function NullContext() {
    contextKeyService_classCallCheck(this, NullContext);
    return _super.call(this, -1, null);
  }
  contextKeyService_createClass(NullContext, [{
    key: "setValue",
    value: function setValue(_key, _value) {
      return false;
    }
  }, {
    key: "removeValue",
    value: function removeValue(_key) {
      return false;
    }
  }, {
    key: "getValue",
    value: function getValue(_key) {
      return undefined;
    }
  }, {
    key: "collectAllValues",
    value: function collectAllValues() {
      return Object.create(null);
    }
  }]);
  return NullContext;
}(Context);
_NullContext = NullContext;
NullContext.INSTANCE = new _NullContext();
var ConfigAwareContextValuesContainer = /*#__PURE__*/function (_Context3) {
  contextKeyService_inherits(ConfigAwareContextValuesContainer, _Context3);
  var _super2 = contextKeyService_createSuper(ConfigAwareContextValuesContainer);
  function ConfigAwareContextValuesContainer(id, _configurationService, emitter) {
    var _this;
    contextKeyService_classCallCheck(this, ConfigAwareContextValuesContainer);
    _this = _super2.call(this, id, null);
    _this._values = TernarySearchTree.forConfigKeys();
    _this._configurationService = _configurationService;
    _this._listener = _this._configurationService.onDidChangeConfiguration(function (event) {
      if (event.source === ConfigurationTarget.DEFAULT) {
        // new setting, reset everything
        var allKeys = Array.from(Iterable.map(_this._values, function (_ref) {
          var _ref2 = contextKeyService_slicedToArray(_ref, 1),
            k = _ref2[0];
          return k;
        }));
        _this._values.clear();
        emitter.fire(new ArrayContextKeyChangeEvent(allKeys));
      } else {
        var changedKeys = [];
        var _iterator = contextKeyService_createForOfIteratorHelper(event.affectedKeys),
          _step;
        try {
          for (_iterator.s(); !(_step = _iterator.n()).done;) {
            var configKey = _step.value;
            var contextKey = "config.".concat(configKey);
            var cachedItems = _this._values.findSuperstr(contextKey);
            if (cachedItems !== undefined) {
              changedKeys.push.apply(changedKeys, contextKeyService_toConsumableArray(Iterable.map(cachedItems, function (_ref3) {
                var _ref4 = contextKeyService_slicedToArray(_ref3, 1),
                  key = _ref4[0];
                return key;
              })));
              _this._values.deleteSuperstr(contextKey);
            }
            if (_this._values.has(contextKey)) {
              changedKeys.push(contextKey);
              _this._values.delete(contextKey);
            }
          }
        } catch (err) {
          _iterator.e(err);
        } finally {
          _iterator.f();
        }
        emitter.fire(new ArrayContextKeyChangeEvent(changedKeys));
      }
    });
    return _this;
  }
  contextKeyService_createClass(ConfigAwareContextValuesContainer, [{
    key: "dispose",
    value: function dispose() {
      this._listener.dispose();
    }
  }, {
    key: "getValue",
    value: function getValue(key) {
      if (key.indexOf(ConfigAwareContextValuesContainer._keyPrefix) !== 0) {
        return _get(contextKeyService_getPrototypeOf(ConfigAwareContextValuesContainer.prototype), "getValue", this).call(this, key);
      }
      if (this._values.has(key)) {
        return this._values.get(key);
      }
      var configKey = key.substr(ConfigAwareContextValuesContainer._keyPrefix.length);
      var configValue = this._configurationService.getValue(configKey);
      var value;
      switch (contextKeyService_typeof(configValue)) {
        case 'number':
        case 'boolean':
        case 'string':
          value = configValue;
          break;
        default:
          if (Array.isArray(configValue)) {
            value = JSON.stringify(configValue);
          } else {
            value = configValue;
          }
      }
      this._values.set(key, value);
      return value;
    }
  }, {
    key: "setValue",
    value: function setValue(key, value) {
      return _get(contextKeyService_getPrototypeOf(ConfigAwareContextValuesContainer.prototype), "setValue", this).call(this, key, value);
    }
  }, {
    key: "removeValue",
    value: function removeValue(key) {
      return _get(contextKeyService_getPrototypeOf(ConfigAwareContextValuesContainer.prototype), "removeValue", this).call(this, key);
    }
  }, {
    key: "collectAllValues",
    value: function collectAllValues() {
      var result = Object.create(null);
      this._values.forEach(function (value, index) {
        return result[index] = value;
      });
      return contextKeyService_objectSpread(contextKeyService_objectSpread({}, result), _get(contextKeyService_getPrototypeOf(ConfigAwareContextValuesContainer.prototype), "collectAllValues", this).call(this));
    }
  }]);
  return ConfigAwareContextValuesContainer;
}(Context);
ConfigAwareContextValuesContainer._keyPrefix = 'config.';
var ContextKey = /*#__PURE__*/function () {
  function ContextKey(service, key, defaultValue) {
    contextKeyService_classCallCheck(this, ContextKey);
    this._service = service;
    this._key = key;
    this._defaultValue = defaultValue;
    this.reset();
  }
  contextKeyService_createClass(ContextKey, [{
    key: "set",
    value: function set(value) {
      this._service.setContext(this._key, value);
    }
  }, {
    key: "reset",
    value: function reset() {
      if (typeof this._defaultValue === 'undefined') {
        this._service.removeContext(this._key);
      } else {
        this._service.setContext(this._key, this._defaultValue);
      }
    }
  }, {
    key: "get",
    value: function get() {
      return this._service.getContextKeyValue(this._key);
    }
  }]);
  return ContextKey;
}();
var SimpleContextKeyChangeEvent = /*#__PURE__*/function () {
  function SimpleContextKeyChangeEvent(key) {
    contextKeyService_classCallCheck(this, SimpleContextKeyChangeEvent);
    this.key = key;
  }
  contextKeyService_createClass(SimpleContextKeyChangeEvent, [{
    key: "affectsSome",
    value: function affectsSome(keys) {
      return keys.has(this.key);
    }
  }]);
  return SimpleContextKeyChangeEvent;
}();
var ArrayContextKeyChangeEvent = /*#__PURE__*/function () {
  function ArrayContextKeyChangeEvent(keys) {
    contextKeyService_classCallCheck(this, ArrayContextKeyChangeEvent);
    this.keys = keys;
  }
  contextKeyService_createClass(ArrayContextKeyChangeEvent, [{
    key: "affectsSome",
    value: function affectsSome(keys) {
      var _iterator2 = contextKeyService_createForOfIteratorHelper(this.keys),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var key = _step2.value;
          if (keys.has(key)) {
            return true;
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return false;
    }
  }]);
  return ArrayContextKeyChangeEvent;
}();
var CompositeContextKeyChangeEvent = /*#__PURE__*/function () {
  function CompositeContextKeyChangeEvent(events) {
    contextKeyService_classCallCheck(this, CompositeContextKeyChangeEvent);
    this.events = events;
  }
  contextKeyService_createClass(CompositeContextKeyChangeEvent, [{
    key: "affectsSome",
    value: function affectsSome(keys) {
      var _iterator3 = contextKeyService_createForOfIteratorHelper(this.events),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var e = _step3.value;
          if (e.affectsSome(keys)) {
            return true;
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return false;
    }
  }]);
  return CompositeContextKeyChangeEvent;
}();
var AbstractContextKeyService = (contextKeyService_dec2 = (0,mana_syringe_es/* injectable */.b2)(), contextKeyService_dec2(contextKeyService_class2 = /*#__PURE__*/function () {
  function AbstractContextKeyService(myContextId) {
    contextKeyService_classCallCheck(this, AbstractContextKeyService);
    this._onDidChangeContext = new es_event/* PauseableEmitter */.K3({
      merge: function merge(input) {
        return new CompositeContextKeyChangeEvent(input);
      }
    });
    this.onDidChangeContext = this._onDidChangeContext.event;
    this._isDisposed = false;
    this._myContextId = myContextId;
  }
  contextKeyService_createClass(AbstractContextKeyService, [{
    key: "contextId",
    get: function get() {
      return this._myContextId;
    }
  }, {
    key: "createKey",
    value: function createKey(key, defaultValue) {
      if (this._isDisposed) {
        throw new Error("AbstractContextKeyService has been disposed");
      }
      return new ContextKey(this, key, defaultValue);
    }
  }, {
    key: "bufferChangeEvents",
    value: function bufferChangeEvents(callback) {
      this._onDidChangeContext.pause();
      try {
        callback();
      } finally {
        this._onDidChangeContext.resume();
      }
    }
  }, {
    key: "createScoped",
    value: function createScoped(domNode) {
      if (this._isDisposed) {
        throw new Error("AbstractContextKeyService has been disposed");
      }
      return new ScopedContextKeyService(this, domNode);
    }
  }, {
    key: "createOverlay",
    value: function createOverlay() {
      var overlay = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Iterable.empty();
      if (this._isDisposed) {
        throw new Error("AbstractContextKeyService has been disposed");
      }
      return new OverlayContextKeyService(this, overlay);
    }
  }, {
    key: "contextMatchesRules",
    value: function contextMatchesRules(rules) {
      if (this._isDisposed) {
        throw new Error("AbstractContextKeyService has been disposed");
      }
      var context = this.getContextValuesContainer(this._myContextId);
      if (!rules) {
        return true;
      }
      return rules.evaluate(context);
      // console.group(rules.serialize() + ' -> ' + result);
      // rules.keys().forEach(key => { console.log(key, ctx[key]); });
      // console.groupEnd();
      // return result;
    }
  }, {
    key: "getContextKeyValue",
    value: function getContextKeyValue(key) {
      if (this._isDisposed) {
        return undefined;
      }
      return this.getContextValuesContainer(this._myContextId).getValue(key);
    }
  }, {
    key: "setContext",
    value: function setContext(key, value) {
      if (this._isDisposed) {
        return;
      }
      var myContext = this.getContextValuesContainer(this._myContextId);
      if (!myContext) {
        return;
      }
      if (myContext.setValue(key, value)) {
        this._onDidChangeContext.fire(new SimpleContextKeyChangeEvent(key));
      }
    }
  }, {
    key: "removeContext",
    value: function removeContext(key) {
      if (this._isDisposed) {
        return;
      }
      if (this.getContextValuesContainer(this._myContextId).removeValue(key)) {
        this._onDidChangeContext.fire(new SimpleContextKeyChangeEvent(key));
      }
    }
  }, {
    key: "getContext",
    value: function getContext(target) {
      if (this._isDisposed) {
        return NullContext.INSTANCE;
      }
      return this.getContextValuesContainer(findContextAttr(target));
    }
  }]);
  return AbstractContextKeyService;
}()) || contextKeyService_class2);
var VSContextKeyService = (contextKeyService_dec3 = (0,mana_syringe_es/* singleton */.ri)({
  contrib: IContextKeyService
}), contextKeyService_dec3(contextKeyService_class3 = /*#__PURE__*/function (_AbstractContextKeySe) {
  contextKeyService_inherits(VSContextKeyService, _AbstractContextKeySe);
  var _super3 = contextKeyService_createSuper(VSContextKeyService);
  function VSContextKeyService(configurationService) {
    var _this2;
    contextKeyService_classCallCheck(this, VSContextKeyService);
    _this2 = _super3.call(this, 0);
    _this2._contexts = new Map();
    _this2._toDispose = new DisposableStore();
    _this2.configurationService = configurationService;
    _this2._lastContextId = 0;
    var myContext = new ConfigAwareContextValuesContainer(_this2._myContextId, configurationService, _this2._onDidChangeContext);
    _this2._contexts.set(_this2._myContextId, myContext);
    _this2._toDispose.add(myContext);

    // Uncomment this to see the contexts continuously logged
    // let lastLoggedValue: string | null = null;
    // setInterval(() => {
    // 	let values = Object.keys(this._contexts).map((key) => this._contexts[key]);
    // 	let logValue = values.map(v => JSON.stringify(v._value, null, '\t')).join('\n');
    // 	if (lastLoggedValue !== logValue) {
    // 		lastLoggedValue = logValue;
    // 		console.log(lastLoggedValue);
    // 	}
    // }, 2000);
    return _this2;
  }
  VSContextKeyService = (0,mana_syringe_es/* inject */.f3)(IConfigurationService)(VSContextKeyService, undefined, 0) || VSContextKeyService;
  contextKeyService_createClass(VSContextKeyService, [{
    key: "registerCommands",
    value: function registerCommands(commands) {
      var _this3 = this;
      commands.registerCommand({
        id: SET_CONTEXT_COMMAND_ID
      }, {
        execute: function execute(contextKey, contextValue) {
          _this3.createKey(String(contextKey), contextValue);
        }
      });
      commands.registerCommand({
        id: 'getContextKeyInfo',
        label: 'getContextKeyInfo, A command that returns information about context keys'
      }, {
        execute: function execute() {
          return contextKeyService_toConsumableArray(RawContextKey.all()).sort(function (a, b) {
            return a.key.localeCompare(b.key);
          });
        }
      });
      commands.registerCommand({
        id: '_generateContextKeyInfo'
      }, {
        execute: function execute() {
          var result = [];
          var seen = new Set();
          var _iterator4 = contextKeyService_createForOfIteratorHelper(RawContextKey.all()),
            _step4;
          try {
            for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
              var info = _step4.value;
              if (!seen.has(info.key)) {
                seen.add(info.key);
                result.push(info);
              }
            }
          } catch (err) {
            _iterator4.e(err);
          } finally {
            _iterator4.f();
          }
          result.sort(function (a, b) {
            return a.key.localeCompare(b.key);
          });
        }
      });
    }
  }, {
    key: "dispose",
    value: function dispose() {
      this._onDidChangeContext.dispose();
      this._isDisposed = true;
      this._toDispose.dispose();
    }
  }, {
    key: "getContextValuesContainer",
    value: function getContextValuesContainer(contextId) {
      if (this._isDisposed) {
        return NullContext.INSTANCE;
      }
      return this._contexts.get(contextId) || NullContext.INSTANCE;
    }
  }, {
    key: "createChildContext",
    value: function createChildContext() {
      var parentContextId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this._myContextId;
      if (this._isDisposed) {
        throw new Error("ContextKeyService has been disposed");
      }
      var id = ++this._lastContextId;
      this._contexts.set(id, new Context(id, this.getContextValuesContainer(parentContextId)));
      return id;
    }
  }, {
    key: "disposeContext",
    value: function disposeContext(contextId) {
      if (!this._isDisposed) {
        this._contexts.delete(contextId);
      }
    }
  }, {
    key: "updateParent",
    value: function updateParent(_parentContextKeyService) {
      throw new Error('Cannot update parent of root ContextKeyService');
    }
  }]);
  return VSContextKeyService;
}(AbstractContextKeyService)) || contextKeyService_class3);
var ScopedContextKeyService = /*#__PURE__*/function (_AbstractContextKeySe2) {
  contextKeyService_inherits(ScopedContextKeyService, _AbstractContextKeySe2);
  var _super4 = contextKeyService_createSuper(ScopedContextKeyService);
  function ScopedContextKeyService(parent, domNode) {
    var _this4;
    contextKeyService_classCallCheck(this, ScopedContextKeyService);
    _this4 = _super4.call(this, parent.createChildContext());
    _this4._parentChangeListener = new MutableDisposable();
    _this4._parent = parent;
    _this4._updateParentChangeListener();
    _this4._domNode = domNode;
    if (_this4._domNode.hasAttribute(KEYBINDING_CONTEXT_ATTR)) {
      var extraInfo = '';
      if (_this4._domNode.classList) {
        extraInfo = Array.from(_this4._domNode.classList.values()).join(', ');
      }
      console.error("Element already has context attribute".concat(extraInfo ? ": ".concat(extraInfo) : ''));
    }
    _this4._domNode.setAttribute(KEYBINDING_CONTEXT_ATTR, String(_this4._myContextId));
    return _this4;
  }
  contextKeyService_createClass(ScopedContextKeyService, [{
    key: "_updateParentChangeListener",
    value: function _updateParentChangeListener() {
      // Forward parent events to this listener. Parent will change.
      this._parentChangeListener.value = this._parent.onDidChangeContext(this._onDidChangeContext.fire, this._onDidChangeContext);
    }
  }, {
    key: "dispose",
    value: function dispose() {
      if (this._isDisposed) {
        return;
      }
      this._onDidChangeContext.dispose();
      this._parent.disposeContext(this._myContextId);
      this._parentChangeListener.dispose();
      this._domNode.removeAttribute(KEYBINDING_CONTEXT_ATTR);
      this._isDisposed = true;
    }
  }, {
    key: "getContextValuesContainer",
    value: function getContextValuesContainer(contextId) {
      if (this._isDisposed) {
        return NullContext.INSTANCE;
      }
      return this._parent.getContextValuesContainer(contextId);
    }
  }, {
    key: "createChildContext",
    value: function createChildContext() {
      var parentContextId = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this._myContextId;
      if (this._isDisposed) {
        throw new Error("ScopedContextKeyService has been disposed");
      }
      return this._parent.createChildContext(parentContextId);
    }
  }, {
    key: "disposeContext",
    value: function disposeContext(contextId) {
      if (this._isDisposed) {
        return;
      }
      this._parent.disposeContext(contextId);
    }
  }, {
    key: "updateParent",
    value: function updateParent(parentContextKeyService) {
      var thisContainer = this._parent.getContextValuesContainer(this._myContextId);
      var oldAllValues = thisContainer.collectAllValues();
      this._parent = parentContextKeyService;
      this._updateParentChangeListener();
      var newParentContainer = this._parent.getContextValuesContainer(this._parent.contextId);
      thisContainer.updateParent(newParentContainer);
      var newAllValues = thisContainer.collectAllValues();
      var allValuesDiff = contextKeyService_objectSpread(contextKeyService_objectSpread({}, objects.distinct(oldAllValues, newAllValues)), objects.distinct(newAllValues, oldAllValues));
      var changedKeys = Object.keys(allValuesDiff);
      this._onDidChangeContext.fire(new ArrayContextKeyChangeEvent(changedKeys));
    }
  }]);
  return ScopedContextKeyService;
}(AbstractContextKeyService);
var OverlayContext = /*#__PURE__*/function () {
  function OverlayContext(parent, overlay) {
    contextKeyService_classCallCheck(this, OverlayContext);
    this.parent = parent;
    this.overlay = overlay;
  }
  contextKeyService_createClass(OverlayContext, [{
    key: "getValue",
    value: function getValue(key) {
      return this.overlay.has(key) ? this.overlay.get(key) : this.parent.getValue(key);
    }
  }]);
  return OverlayContext;
}();
var OverlayContextKeyService = /*#__PURE__*/function () {
  function OverlayContextKeyService(parent, overlay) {
    contextKeyService_classCallCheck(this, OverlayContextKeyService);
    this.parent = parent;
    this.overlay = new Map(overlay);
  }
  contextKeyService_createClass(OverlayContextKeyService, [{
    key: "contextId",
    get: function get() {
      return this.parent.contextId;
    }
  }, {
    key: "onDidChangeContext",
    get: function get() {
      return this.parent.onDidChangeContext;
    }
  }, {
    key: "bufferChangeEvents",
    value: function bufferChangeEvents(callback) {
      this.parent.bufferChangeEvents(callback);
    }
  }, {
    key: "createKey",
    value: function createKey() {
      throw new Error('Not supported.');
    }
  }, {
    key: "getContext",
    value: function getContext(target) {
      return new OverlayContext(this.parent.getContext(target), this.overlay);
    }
  }, {
    key: "getContextValuesContainer",
    value: function getContextValuesContainer(contextId) {
      var parentContext = this.parent.getContextValuesContainer(contextId);
      return new OverlayContext(parentContext, this.overlay);
    }
  }, {
    key: "contextMatchesRules",
    value: function contextMatchesRules(rules) {
      var context = this.getContextValuesContainer(this.contextId);
      if (!rules) {
        return true;
      }
      return rules.evaluate(context);
      // return result;
    }
  }, {
    key: "getContextKeyValue",
    value: function getContextKeyValue(key) {
      return this.overlay.has(key) ? this.overlay.get(key) : this.parent.getContextKeyValue(key);
    }
  }, {
    key: "createScoped",
    value: function createScoped() {
      throw new Error('Not supported.');
    }
  }, {
    key: "createOverlay",
    value: function createOverlay() {
      var overlay = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : Iterable.empty();
      return new OverlayContextKeyService(this, overlay);
    }
  }, {
    key: "updateParent",
    value: function updateParent() {
      throw new Error('Not supported.');
    }
  }, {
    key: "dispose",
    value: function dispose() {
      // noop
    }
  }]);
  return OverlayContextKeyService;
}();
function findContextAttr(domNode) {
  while (domNode) {
    if (domNode.hasAttribute(KEYBINDING_CONTEXT_ATTR)) {
      var attr = domNode.getAttribute(KEYBINDING_CONTEXT_ATTR);
      if (attr) {
        return parseInt(attr, 10);
      }
      return NaN;
    }
    domNode = domNode.parentElement;
  }
  return 0;
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/context-key-service.js
function context_key_service_typeof(o) { "@babel/helpers - typeof"; return context_key_service_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, context_key_service_typeof(o); }
var context_key_service_dec, context_key_service_dec2, context_key_service_class, context_key_service_class2;
function context_key_service_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function context_key_service_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, context_key_service_toPropertyKey(descriptor.key), descriptor); } }
function context_key_service_createClass(Constructor, protoProps, staticProps) { if (protoProps) context_key_service_defineProperties(Constructor.prototype, protoProps); if (staticProps) context_key_service_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function context_key_service_toPropertyKey(t) { var i = context_key_service_toPrimitive(t, "string"); return "symbol" == context_key_service_typeof(i) ? i : String(i); }
function context_key_service_toPrimitive(t, r) { if ("object" != context_key_service_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != context_key_service_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function context_key_service_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }




var ContextKeyService = (context_key_service_dec = (0,mana_syringe_es/* singleton */.ri)(), context_key_service_dec2 = (0,mana_syringe_es/* postConstruct */.zY)(), context_key_service_dec(context_key_service_class = (context_key_service_class2 = /*#__PURE__*/function () {
  function ContextKeyService(vsContextKeyService) {
    context_key_service_classCallCheck(this, ContextKeyService);
    this.onDidChangeEmitter = new es_event/* Emitter */.Q5();
    this.onDidChange = this.onDidChangeEmitter.event;
    this.expressions = new Map();
    this.vsContextKeyService = vsContextKeyService;
    this.contextKeyService = vsContextKeyService;
  }
  ContextKeyService = (0,mana_syringe_es/* inject */.f3)(VSContextKeyService)(ContextKeyService, undefined, 0) || ContextKeyService;
  context_key_service_createClass(ContextKeyService, [{
    key: "fireDidChange",
    value: function fireDidChange(event) {
      this.onDidChangeEmitter.fire(event);
    }
  }, {
    key: "init",
    value: function init() {
      var _this = this;
      this.contextKeyService.onDidChangeContext(function (e) {
        return _this.fireDidChange({
          affects: function affects(keys) {
            return e.affectsSome(keys);
          }
        });
      });
    }
  }, {
    key: "createKey",
    value: function createKey(key, defaultValue) {
      return this.contextKeyService.createKey(key, defaultValue);
    }
  }, {
    key: "match",
    value: function match(expression, context) {
      var ctx = context || this.activeContext || (window.document.activeElement instanceof HTMLElement ? window.document.activeElement : undefined);
      var parsed = this.parse(expression);
      if (!ctx) {
        return this.contextKeyService.contextMatchesRules(parsed);
      }
      var keyContext = this.contextKeyService.getContext(ctx);
      if (!parsed) {
        return true;
      }
      return parsed.evaluate(keyContext);
    }
  }, {
    key: "parse",
    value: function parse(when) {
      var expression = this.expressions.get(when);
      if (!expression) {
        expression = ContextKeyExpr.deserialize(when);
        if (expression) {
          this.expressions.set(when, expression);
        }
      }
      return expression;
    }
  }, {
    key: "parseKeys",
    value: function parseKeys(expression) {
      var expr = ContextKeyExpr.deserialize(expression);
      return expr ? new Set(expr.keys()) : expr;
    }
  }]);
  return ContextKeyService;
}(), (context_key_service_applyDecoratedDescriptor(context_key_service_class2.prototype, "init", [context_key_service_dec2], Object.getOwnPropertyDescriptor(context_key_service_class2.prototype, "init"), context_key_service_class2.prototype)), context_key_service_class2)) || context_key_service_class);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/disposable.js
var disposable = __webpack_require__(80042);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/keybinding-proocol.js

var KeybindingContribution = mana_syringe_es/* Syringe */.J3.defineToken('KeybindingContribution');
/**
 * Allows extensions to contribute {@link common.Keybinding}s
 */
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/keybinding.js
function keybinding_typeof(o) { "@babel/helpers - typeof"; return keybinding_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, keybinding_typeof(o); }
var keybinding_dec, keybinding_class, _KeybindingRegistry;
function keybinding_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function keybinding_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? keybinding_ownKeys(Object(t), !0).forEach(function (r) { keybinding_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : keybinding_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function keybinding_defineProperty(obj, key, value) { key = keybinding_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function keybinding_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ keybinding_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == keybinding_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(keybinding_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function keybinding_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = keybinding_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function keybinding_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function keybinding_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { keybinding_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { keybinding_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function keybinding_toConsumableArray(arr) { return keybinding_arrayWithoutHoles(arr) || keybinding_iterableToArray(arr) || keybinding_unsupportedIterableToArray(arr) || keybinding_nonIterableSpread(); }
function keybinding_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function keybinding_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return keybinding_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return keybinding_arrayLikeToArray(o, minLen); }
function keybinding_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function keybinding_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return keybinding_arrayLikeToArray(arr); }
function keybinding_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function keybinding_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function keybinding_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, keybinding_toPropertyKey(descriptor.key), descriptor); } }
function keybinding_createClass(Constructor, protoProps, staticProps) { if (protoProps) keybinding_defineProperties(Constructor.prototype, protoProps); if (staticProps) keybinding_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function keybinding_toPropertyKey(t) { var i = keybinding_toPrimitive(t, "string"); return "symbol" == keybinding_typeof(i) ? i : String(i); }
function keybinding_toPrimitive(t, r) { if ("object" != keybinding_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != keybinding_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }











/**
 * A Keybinding binds a specific key sequence ({@link Keybinding#keybinding}) to trigger a command ({@link Keybinding#command}). A Keybinding optionally may
 * define a "when clause" ({@link Keybinding#when}) to specify in which context it becomes active.
 * @see KeyBindingRegistry
 */
var Keybinding;
(function (_Keybinding) {
  function equals(a, b) {
    var ignoreKeybinding = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
    var ignoreArgs = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    if (a.command === b.command && (a.context || '') === (b.context || '') && (a.when || '') === (b.when || '') && (ignoreKeybinding || a.keybinding === b.keybinding) && (ignoreArgs || (a.args || '') === (b.args || ''))) {
      return true;
    }
    return false;
  }
  _Keybinding.equals = equals;
  function apiObjectify(binding) {
    return {
      command: binding.command,
      keybinding: binding.keybinding,
      context: binding.context,
      when: binding.when,
      args: binding.args
    };
  }
  _Keybinding.apiObjectify = apiObjectify;
  function stringify(binding) {
    return JSON.stringify(apiObjectify(binding));
  }
  _Keybinding.stringify = stringify;
  function is(arg) {
    return !!arg && arg === Object(arg) && 'command' in arg && 'keybinding' in arg;
  }
  _Keybinding.is = is;
})(Keybinding || (Keybinding = {}));
var KeybindingScope = /*#__PURE__*/function (KeybindingScope) {
  KeybindingScope[KeybindingScope["DEFAULT"] = 0] = "DEFAULT";
  KeybindingScope[KeybindingScope["USER"] = 1] = "USER";
  KeybindingScope[KeybindingScope["WORKSPACE"] = 2] = "WORKSPACE";
  KeybindingScope[KeybindingScope["END"] = 3] = "END";
  return KeybindingScope;
}({});
(function (_KeybindingScope) {
  var length = _KeybindingScope.length = KeybindingScope.END - KeybindingScope.DEFAULT;
})(KeybindingScope || (KeybindingScope = {}));
var KeybindingContext = mana_syringe_es/* Syringe */.J3.defineToken('KeybindingContext');
var KeybindingContexts;
(function (_KeybindingContexts) {
  var NOOP_CONTEXT = _KeybindingContexts.NOOP_CONTEXT = {
    id: 'noop.keybinding.context',
    isEnabled: function isEnabled() {
      return true;
    }
  };
  var DEFAULT_CONTEXT = _KeybindingContexts.DEFAULT_CONTEXT = {
    id: 'default.keybinding.context',
    isEnabled: function isEnabled() {
      return false;
    }
  };
})(KeybindingContexts || (KeybindingContexts = {}));
var KeybindingRegistry = (keybinding_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: application_application/* ApplicationContribution */.rS
}), keybinding_dec(keybinding_class = (_KeybindingRegistry = /*#__PURE__*/function () {
  function KeybindingRegistry(keyboardLayoutService, contextProvider, commandRegistry, contributions, logger, whenContextService) {
    keybinding_classCallCheck(this, KeybindingRegistry);
    this.preventDefault = false;
    this.stopPropagation = false;
    this.keySequence = [];
    this.contexts = {};
    this.keymaps = keybinding_toConsumableArray(Array(KeybindingScope.length)).map(function () {
      return [];
    });
    this.emitter = new es_event/* Emitter */.Q5();
    this.keybindingsChanged = new es_event/* Emitter */.Q5();
    this.toResetKeymap = new Map();
    this.keyboardLayoutService = keyboardLayoutService;
    this.contextProvider = contextProvider;
    this.commandRegistry = commandRegistry;
    this.contributions = contributions;
    this.logger = logger;
    this.whenContextService = whenContextService;
  }
  KeybindingRegistry = (0,mana_syringe_es/* inject */.f3)(ContextKeyService)(KeybindingRegistry, undefined, 5) || KeybindingRegistry;
  KeybindingRegistry = (0,mana_syringe_es/* inject */.f3)(debug/* DebugService */.r)(KeybindingRegistry, undefined, 4) || KeybindingRegistry;
  KeybindingRegistry = (0,mana_syringe_es/* contrib */.el)(KeybindingContribution)(KeybindingRegistry, undefined, 3) || KeybindingRegistry;
  KeybindingRegistry = (0,mana_syringe_es/* inject */.f3)(command_registry/* CommandRegistry */.H)(KeybindingRegistry, undefined, 2) || KeybindingRegistry;
  KeybindingRegistry = (0,mana_syringe_es/* contrib */.el)(KeybindingContext)(KeybindingRegistry, undefined, 1) || KeybindingRegistry;
  KeybindingRegistry = (0,mana_syringe_es/* inject */.f3)(KeyboardLayoutService)(KeybindingRegistry, undefined, 0) || KeybindingRegistry;
  keybinding_createClass(KeybindingRegistry, [{
    key: "onStart",
    value: function () {
      var _onStart = keybinding_asyncToGenerator( /*#__PURE__*/keybinding_regeneratorRuntime().mark(function _callee(app) {
        var _this = this;
        var _iterator, _step, contribution;
        return keybinding_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.keyboardLayoutService.initialize();
            case 2:
              this.keyboardLayoutService.onKeyboardLayoutChanged(function () {
                _this.clearResolvedKeybindings();
                _this.keybindingsChanged.fire(undefined);
              });
              this.registerContext(KeybindingContexts.NOOP_CONTEXT);
              this.registerContext(KeybindingContexts.DEFAULT_CONTEXT);
              this.registerContext.apply(this, keybinding_toConsumableArray(this.contextProvider.getContributions()));
              _iterator = keybinding_createForOfIteratorHelper(this.contributions.getContributions());
              try {
                for (_iterator.s(); !(_step = _iterator.n()).done;) {
                  contribution = _step.value;
                  contribution.registerKeybindings(this);
                }
              } catch (err) {
                _iterator.e(err);
              } finally {
                _iterator.f();
              }
              app.onKeyDown(function (event) {
                if (app.inComposition !== true) {
                  _this.run(event);
                }
              });
            case 9:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function onStart(_x) {
        return _onStart.apply(this, arguments);
      }
      return onStart;
    }()
  }, {
    key: "onKeybindingsChanged",
    get:
    /**
     * Event that is fired when the resolved keybindings change due to a different keyboard layout
     * or when a new keymap is being set
     */
    function get() {
      return this.keybindingsChanged.event;
    }

    /**
     * Registers the keybinding context arguments into the application. Fails when an already registered
     * context is being registered.
     *
     * @param contexts the keybinding contexts to register into the application.
     */
  }, {
    key: "registerContext",
    value: function registerContext() {
      for (var _len = arguments.length, contexts = new Array(_len), _key = 0; _key < _len; _key++) {
        contexts[_key] = arguments[_key];
      }
      for (var _i = 0, _contexts = contexts; _i < _contexts.length; _i++) {
        var context = _contexts[_i];
        var id = context.id;
        if (this.contexts[id]) {
          this.logger("A keybinding context with ID ".concat(id, " is already registered."));
        } else {
          this.contexts[id] = context;
        }
      }
    }

    /**
     * Register a default keybinding to the registry.
     *
     * Keybindings registered later have higher priority during evaluation.
     *
     * @param binding the keybinding to be registered
     */
  }, {
    key: "registerKeybinding",
    value: function registerKeybinding(binding) {
      return this.doRegisterKeybinding(binding);
    }

    /**
     * Register multiple default keybindings to the registry
     *
     * @param bindings An array of keybinding to be registered
     */
  }, {
    key: "registerKeybindings",
    value: function registerKeybindings() {
      for (var _len2 = arguments.length, bindings = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        bindings[_key2] = arguments[_key2];
      }
      return this.doRegisterKeybindings(bindings, KeybindingScope.DEFAULT);
    }

    /**
     * Unregister all keybindings from the registry that are bound to the key of the given keybinding
     *
     * @param binding a keybinding specifying the key to be unregistered
     */
  }, {
    key: "unregisterKeybinding",
    value: function unregisterKeybinding(arg) {
      var keymap = this.keymaps[KeybindingScope.DEFAULT];
      var filter = command_protocol/* Command */.m.is(arg) ? function (_ref) {
        var command = _ref.command;
        return command === arg.id;
      } : function (_ref2) {
        var keybinding = _ref2.keybinding;
        return Keybinding.is(arg) ? keybinding === arg.keybinding : keybinding === arg;
      };
      var _iterator2 = keybinding_createForOfIteratorHelper(keymap.filter(filter)),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var _binding = _step2.value;
          var idx = keymap.indexOf(_binding);
          if (idx !== -1) {
            keymap.splice(idx, 1);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }
  }, {
    key: "doRegisterKeybindings",
    value: function doRegisterKeybindings(bindings) {
      var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : KeybindingScope.DEFAULT;
      var toDispose = new disposable_collection/* DisposableCollection */.K();
      var _iterator3 = keybinding_createForOfIteratorHelper(bindings),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var _binding2 = _step3.value;
          toDispose.push(this.doRegisterKeybinding(_binding2, scope));
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return toDispose;
    }
  }, {
    key: "doRegisterKeybinding",
    value: function doRegisterKeybinding(binding) {
      var _this2 = this;
      var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : KeybindingScope.DEFAULT;
      try {
        this.resolveKeybinding(binding);
        var scoped = Object.assign(binding, {
          scope: scope
        });
        this.insertBindingIntoScope(scoped, scope);
        return disposable/* Disposable */.J.create(function () {
          var index = _this2.keymaps[scope].indexOf(scoped);
          if (index !== -1) {
            _this2.keymaps[scope].splice(index, 1);
          }
        });
      } catch (error) {
        this.logger("Could not register keybinding:\n  ".concat(Keybinding.stringify(binding), "\n").concat(error));
        return disposable/* Disposable */.J.NONE;
      }
    }

    /**
     * Ensures that keybindings are inserted in order of increasing length of binding to ensure that if a
     * user triggers a short keybinding (e.g. ctrl+k), the UI won't wait for a longer one (e.g. ctrl+k enter)
     */
  }, {
    key: "insertBindingIntoScope",
    value: function insertBindingIntoScope(item, scope) {
      var scopedKeymap = this.keymaps[scope];
      var getNumberOfKeystrokes = function getNumberOfKeystrokes(binding) {
        var _binding$keybinding$t, _binding$keybinding$t2;
        return ((_binding$keybinding$t = (_binding$keybinding$t2 = binding.keybinding.trim().match(/\s/g)) === null || _binding$keybinding$t2 === void 0 ? void 0 : _binding$keybinding$t2.length) !== null && _binding$keybinding$t !== void 0 ? _binding$keybinding$t : 0) + 1;
      };
      var numberOfKeystrokesInBinding = getNumberOfKeystrokes(item);
      var indexOfFirstItemWithEqualStrokes = scopedKeymap.findIndex(function (existingBinding) {
        return getNumberOfKeystrokes(existingBinding) === numberOfKeystrokesInBinding;
      });
      if (indexOfFirstItemWithEqualStrokes > -1) {
        scopedKeymap.splice(indexOfFirstItemWithEqualStrokes, 0, item);
      } else {
        scopedKeymap.push(item);
      }
    }

    /**
     * Ensure that the `resolved` property of the given binding is set by calling the KeyboardLayoutService.
     */
  }, {
    key: "resolveKeybinding",
    value: function resolveKeybinding(binding) {
      var _this3 = this;
      if (!binding.resolved) {
        var sequence = KeySequence.parse(binding.keybinding);
        binding.resolved = sequence.map(function (code) {
          return _this3.keyboardLayoutService.resolveKeyCode(code);
        });
      }
      return binding.resolved;
    }

    /**
     * Clear all `resolved` properties of registered keybindings so the KeyboardLayoutService is called
     * again to resolve them. This is necessary when the user's keyboard layout has changed.
     */
  }, {
    key: "clearResolvedKeybindings",
    value: function clearResolvedKeybindings() {
      for (var i = KeybindingScope.DEFAULT; i < KeybindingScope.END; i++) {
        var bindings = this.keymaps[i];
        for (var j = 0; j < bindings.length; j++) {
          var _binding3 = bindings[j];
          _binding3.resolved = undefined;
        }
      }
    }

    /**
     * Checks whether a colliding {@link common.Keybinding} exists in a specific scope.
     * @param binding the keybinding to check
     * @param scope the keybinding scope to check
     * @returns true if there is a colliding keybinding
     */
  }, {
    key: "containsKeybindingInScope",
    value: function containsKeybindingInScope(binding) {
      var scope = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : KeybindingScope.USER;
      var bindingKeySequence = this.resolveKeybinding(binding);
      var collisions = this.getKeySequenceCollisions(this.getUsableBindings(this.keymaps[scope]), bindingKeySequence).filter(function (b) {
        return b.context === binding.context && !b.when && !binding.when;
      });
      if (collisions.full.length > 0) {
        return true;
      }
      if (collisions.partial.length > 0) {
        return true;
      }
      if (collisions.shadow.length > 0) {
        return true;
      }
      return false;
    }

    /**
     * Get a user visible representation of a {@link common.Keybinding}.
     * @returns an array of strings representing all elements of the {@link KeySequence} defined by the {@link common.Keybinding}
     * @param keybinding the keybinding
     * @param separator the separator to be used to stringify {@link KeyCode}s that are part of the {@link KeySequence}
     */
  }, {
    key: "acceleratorFor",
    value: function acceleratorFor(keybinding) {
      var separator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' ';
      var bindingKeySequence = this.resolveKeybinding(keybinding);
      return this.acceleratorForSequence(bindingKeySequence, separator);
    }

    /**
     * Get a user visible representation of a {@link KeySequence}.
     * @returns an array of strings representing all elements of the {@link KeySequence}
     * @param keySequence the keysequence
     * @param separator the separator to be used to stringify {@link KeyCode}s that are part of the {@link KeySequence}
     */
  }, {
    key: "acceleratorForSequence",
    value: function acceleratorForSequence(keySequence) {
      var _this4 = this;
      var separator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' ';
      return keySequence.map(function (keyCode) {
        return _this4.acceleratorForKeyCode(keyCode, separator);
      });
    }

    /**
     * Get a user visible representation of a key code (a key with modifiers).
     * @returns a string representing the {@link KeyCode}
     * @param keyCode the keycode
     * @param separator the separator used to separate keys (key and modifiers) in the returning string
     */
  }, {
    key: "acceleratorForKeyCode",
    value: function acceleratorForKeyCode(keyCode) {
      var separator = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : ' ';
      var keyCodeResult = [];
      if (keyCode.meta && platform/* isOSX */.id) {
        keyCodeResult.push('Cmd');
      }
      if (keyCode.ctrl) {
        keyCodeResult.push('Ctrl');
      }
      if (keyCode.alt) {
        keyCodeResult.push('Alt');
      }
      if (keyCode.shift) {
        keyCodeResult.push('Shift');
      }
      if (keyCode.key) {
        keyCodeResult.push(this.acceleratorForKey(keyCode.key));
      }
      return keyCodeResult.join(separator);
    }

    /**
     * Return a user visible representation of a single key.
     */
  }, {
    key: "acceleratorForKey",
    value: function acceleratorForKey(key) {
      if (platform/* isOSX */.id) {
        if (key === Key.ARROW_LEFT) {
          return '←';
        }
        if (key === Key.ARROW_RIGHT) {
          return '→';
        }
        if (key === Key.ARROW_UP) {
          return '↑';
        }
        if (key === Key.ARROW_DOWN) {
          return '↓';
        }
      }
      var keyString = this.keyboardLayoutService.getKeyboardCharacter(key);
      if (key.keyCode >= Key.KEY_A.keyCode && key.keyCode <= Key.KEY_Z.keyCode || key.keyCode >= Key.F1.keyCode && key.keyCode <= Key.F24.keyCode) {
        return keyString.toUpperCase();
      }
      if (keyString.length > 1) {
        return keyString.charAt(0).toUpperCase() + keyString.slice(1);
      }
      return keyString;
    }

    /**
     * Finds collisions for a key sequence inside a list of bindings (error-free)
     *
     * @param bindings the reference bindings
     * @param candidate the sequence to match
     */
  }, {
    key: "getKeySequenceCollisions",
    value: function getKeySequenceCollisions(bindings, candidate) {
      var result = new KeybindingRegistry.KeybindingsResult();
      var _iterator4 = keybinding_createForOfIteratorHelper(bindings),
        _step4;
      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var _binding4 = _step4.value;
          try {
            var bindingKeySequence = this.resolveKeybinding(_binding4);
            var compareResult = KeySequence.compare(candidate, bindingKeySequence);
            switch (compareResult) {
              case KeySequence.CompareResult.FULL:
                {
                  result.full.push(_binding4);
                  break;
                }
              case KeySequence.CompareResult.PARTIAL:
                {
                  result.partial.push(_binding4);
                  break;
                }
              case KeySequence.CompareResult.SHADOW:
                {
                  result.shadow.push(_binding4);
                  break;
                }
            }
          } catch (error) {
            this.logger(error);
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
      return result;
    }

    /**
     * Get all keybindings associated to a commandId.
     *
     * @param commandId The ID of the command for which we are looking for keybindings.
     * @returns an array of {@link ScopedKeybinding}
     */
  }, {
    key: "getKeybindingsForCommand",
    value: function getKeybindingsForCommand(commandId) {
      var _this5 = this;
      var result = [];
      var _loop = function _loop(scope) {
          _this5.keymaps[scope].forEach(function (binding) {
            var command = _this5.commandRegistry.getCommand(binding.command);
            if (command) {
              if (command.id === commandId) {
                result.push(keybinding_objectSpread(keybinding_objectSpread({}, binding), {}, {
                  scope: scope
                }));
              }
            }
          });
          if (result.length > 0) {
            return {
              v: result
            };
          }
        },
        _ret;
      for (var scope = KeybindingScope.END - 1; scope >= KeybindingScope.DEFAULT; scope--) {
        _ret = _loop(scope);
        if (_ret) return _ret.v;
      }
      return result;
    }
  }, {
    key: "isActive",
    value: function isActive(binding) {
      /* Pseudo commands like "passthrough" are always active (and not found
              in the command registry).  */
      if (this.isPseudoCommand(binding.command)) {
        return true;
      }
      var command = this.commandRegistry.getCommand(binding.command);
      return !!command && !!this.commandRegistry.getEnableHandler(command.id);
    }

    /**
     * Tries to execute a keybinding.
     *
     * @param binding to execute
     * @param event keyboard event.
     */
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
  }, {
    key: "executeKeyBinding",
    value: function executeKeyBinding(binding, event) {
      if (this.isPseudoCommand(binding.command)) {
        /* Don't do anything, let the event propagate.  */
      } else {
        var _command = this.commandRegistry.getCommand(binding.command);
        if (_command) {
          if (this.commandRegistry.isEnabled(binding.command, binding.args)) {
            this.commandRegistry.executeCommand(binding.command, binding.args).catch(function (e) {
              return console.error('Failed to execute command:', e);
            });
          }

          /* Note that if a keybinding is in context but the command is
                      not active we still stop the processing here.  */
          var _binding$preventDefau = binding.preventDefault,
            preventDefault = _binding$preventDefau === void 0 ? this.preventDefault : _binding$preventDefau,
            _binding$stopPropagat = binding.stopPropagation,
            stopPropagation = _binding$stopPropagat === void 0 ? this.stopPropagation : _binding$stopPropagat;
          if (preventDefault) {
            event.preventDefault();
          }
          if (stopPropagation) {
            event.stopPropagation();
          }
        }
      }
    }

    /**
     * Only execute if it has no context (global context) or if we're in that context.
     */
  }, {
    key: "isEnabled",
    value: function isEnabled(binding, event) {
      var context = binding.context && this.contexts[binding.context];
      if (context && !context.isEnabled(binding)) {
        return false;
      }
      if (binding.when && !this.whenContextService.match(binding.when, event.target)) {
        return false;
      }
      return true;
    }
  }, {
    key: "dispatchCommand",
    value: function dispatchCommand(id, target) {
      var keybindings = this.getKeybindingsForCommand(id);
      if (keybindings.length) {
        var _iterator5 = keybinding_createForOfIteratorHelper(this.resolveKeybinding(keybindings[0])),
          _step5;
        try {
          for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
            var keyCode = _step5.value;
            this.dispatchKeyDown(keyCode, target);
          }
        } catch (err) {
          _iterator5.e(err);
        } finally {
          _iterator5.f();
        }
      }
    }
  }, {
    key: "dispatchKeyDown",
    value: function dispatchKeyDown(input) {
      var target = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : document.activeElement || window;
      var eventInit = this.asKeyboardEventInit(input);
      var emulatedKeyboardEvent = new KeyboardEvent('keydown', eventInit);
      target.dispatchEvent(emulatedKeyboardEvent);
    }
  }, {
    key: "asKeyboardEventInit",
    value: function asKeyboardEventInit(input) {
      if (typeof input === 'string') {
        return this.asKeyboardEventInit(KeyCode.createKeyCode(input));
      }
      if (input instanceof KeyCode) {
        return {
          metaKey: input.meta,
          shiftKey: input.shift,
          altKey: input.alt,
          ctrlKey: input.ctrl,
          code: input.key && input.key.code,
          key: input && input.character || input.key && input.key.code,
          keyCode: input.key && input.key.keyCode
        };
      }
      return input;
    }

    /**
     * Run the command matching to the given keyboard event.
     */
  }, {
    key: "run",
    value: function run(event) {
      if (event.defaultPrevented) {
        return;
      }
      var keyCode = KeyCode.createKeyCode(event, 'code');
      /* Keycode is only a modifier, next keycode will be modifier + key.
              Ignore this one.  */
      if (keyCode.isModifierOnly()) {
        return;
      }
      this.keyboardLayoutService.validateKeyCode(keyCode);
      this.keySequence.push(keyCode);
      var match = this.matchKeybinding(this.keySequence, event);
      if (match && match.kind === 'partial') {
        /* Accumulate the keysequence */
        // TODO: The effective scope of of prevent propagation.
        var _match$binding = match.binding,
          _match$binding$preven = _match$binding.preventDefault,
          preventDefault = _match$binding$preven === void 0 ? this.preventDefault : _match$binding$preven,
          _match$binding$stopPr = _match$binding.stopPropagation,
          stopPropagation = _match$binding$stopPr === void 0 ? this.stopPropagation : _match$binding$stopPr;
        if (preventDefault) {
          event.preventDefault();
        }
        if (stopPropagation) {
          event.stopPropagation();
        }
        this.emitter.fire(match);
      } else {
        if (match && match.kind === 'full') {
          this.executeKeyBinding(match.binding, event);
        }
        this.keySequence = [];
        this.emitter.fire(match);
      }
    }
  }, {
    key: "onMatchChange",
    value: function onMatchChange(callback) {
      this.emitter.event(callback);
    }

    /**
     * Match first binding in the current context.
     * Keybindings ordered by a scope and by a registration order within the scope.
     *
     * FIXME:
     * This method should run very fast since it happens on each keystroke. We should reconsider how keybindings are stored.
     * It should be possible to look up full and partial keybinding for given key sequence for constant time using some kind of tree.
     * Such tree should not contain disabled keybindings and be invalidated whenever the registry is changed.
     */
  }, {
    key: "matchKeybinding",
    value: function matchKeybinding(keySequence, event) {
      var _this6 = this;
      var disabled;
      var isEnabled = function isEnabled(binding) {
        var _disabled;
        if (event && !_this6.isEnabled(binding, event)) {
          return false;
        }
        var command = binding.command,
          context = binding.context,
          when = binding.when,
          keybinding = binding.keybinding;
        if (!_this6.isUsable(binding)) {
          disabled = disabled || new Set();
          disabled.add(JSON.stringify({
            command: command.substr(1),
            context: context,
            when: when,
            keybinding: keybinding
          }));
          return false;
        }
        return !((_disabled = disabled) !== null && _disabled !== void 0 && _disabled.has(JSON.stringify({
          command: command,
          context: context,
          when: when,
          keybinding: keybinding
        })));
      };
      for (var scope = KeybindingScope.END; --scope >= KeybindingScope.DEFAULT;) {
        var _iterator6 = keybinding_createForOfIteratorHelper(this.keymaps[scope]),
          _step6;
        try {
          for (_iterator6.s(); !(_step6 = _iterator6.n()).done;) {
            var _binding5 = _step6.value;
            var resolved = this.resolveKeybinding(_binding5);
            var compareResult = KeySequence.compare(keySequence, resolved);
            if (compareResult === KeySequence.CompareResult.FULL && isEnabled(_binding5)) {
              return {
                kind: 'full',
                binding: _binding5
              };
            }
            if (compareResult === KeySequence.CompareResult.PARTIAL && isEnabled(_binding5)) {
              return {
                kind: 'partial',
                binding: _binding5
              };
            }
          }
        } catch (err) {
          _iterator6.e(err);
        } finally {
          _iterator6.f();
        }
      }
      return undefined;
    }

    /**
     * Returns true if the binding is usable
     * @param binding Binding to be checked
     */
  }, {
    key: "isUsable",
    value: function isUsable(binding) {
      return binding.command.charAt(0) !== '-';
    }

    /**
     * Return a new filtered array containing only the usable bindings among the input bindings
     * @param bindings Bindings to filter
     */
  }, {
    key: "getUsableBindings",
    value: function getUsableBindings(bindings) {
      var _this7 = this;
      return bindings.filter(function (binding) {
        return _this7.isUsable(binding);
      });
    }

    /**
     * Return true of string a pseudo-command id, in other words a command id
     * that has a special meaning and that we won't find in the command
     * registry.
     *
     * @param commandId commandId to test
     */
  }, {
    key: "isPseudoCommand",
    value: function isPseudoCommand(commandId) {
      return commandId === KeybindingRegistry.PASSTHROUGH_PSEUDO_COMMAND;
    }

    /**
     * Sets a new keymap replacing all existing {@link common.Keybinding}s in the given scope.
     * @param scope the keybinding scope
     * @param bindings an array containing the new {@link common.Keybinding}s
     */
  }, {
    key: "setKeymap",
    value: function setKeymap(scope, bindings) {
      this.resetKeybindingsForScope(scope);
      this.toResetKeymap.set(scope, this.doRegisterKeybindings(bindings, scope));
      this.keybindingsChanged.fire(undefined);
    }
  }, {
    key: "resetKeybindingsForScope",
    value:
    /**
     * Reset keybindings for a specific scope
     * @param scope scope to reset the keybindings for
     */
    function resetKeybindingsForScope(scope) {
      var toReset = this.toResetKeymap.get(scope);
      if (toReset) {
        toReset.dispose();
      }
    }

    /**
     * Reset keybindings for all scopes(only leaves the default keybindings mapped)
     */
  }, {
    key: "resetKeybindings",
    value: function resetKeybindings() {
      for (var i = KeybindingScope.DEFAULT + 1; i < KeybindingScope.END; i++) {
        this.keymaps[i] = [];
      }
    }

    /**
     * Get all {@link common.Keybinding}s for a {@link KeybindingScope}.
     * @returns an array of {@link common.ScopedKeybinding}
     * @param scope the keybinding scope to retrieve the {@link common.Keybinding}s for.
     */
  }, {
    key: "getKeybindingsByScope",
    value: function getKeybindingsByScope(scope) {
      return this.keymaps[scope];
    }
  }]);
  return KeybindingRegistry;
}(), _KeybindingRegistry.PASSTHROUGH_PSEUDO_COMMAND = 'passthrough', _KeybindingRegistry)) || keybinding_class);
(function (_KeybindingRegistry2) {
  var KeybindingsResult = /*#__PURE__*/function () {
    function KeybindingsResult() {
      keybinding_classCallCheck(this, KeybindingsResult);
      this.full = [];
      this.partial = [];
      this.shadow = [];
    }
    keybinding_createClass(KeybindingsResult, [{
      key: "merge",
      value:
      /**
       * Merge two results together inside `this`
       *
       * @param other the other KeybindingsResult to merge with
       * @return this
       */
      function merge(other) {
        var _this$full, _this$partial, _this$shadow;
        (_this$full = this.full).push.apply(_this$full, keybinding_toConsumableArray(other.full));
        (_this$partial = this.partial).push.apply(_this$partial, keybinding_toConsumableArray(other.partial));
        (_this$shadow = this.shadow).push.apply(_this$shadow, keybinding_toConsumableArray(other.shadow));
        return this;
      }

      /**
       * Returns a new filtered KeybindingsResult
       *
       * @param fn callback filter on the results
       * @return filtered new result
       */
    }, {
      key: "filter",
      value: function filter(fn) {
        var result = new KeybindingsResult();
        result.full = this.full.filter(fn);
        result.partial = this.partial.filter(fn);
        result.shadow = this.shadow.filter(fn);
        return result;
      }
    }]);
    return KeybindingsResult;
  }();
  _KeybindingRegistry2.KeybindingsResult = KeybindingsResult;
})(KeybindingRegistry || (KeybindingRegistry = {}));
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/configuration/json.js
function json_typeof(o) { "@babel/helpers - typeof"; return json_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, json_typeof(o); }
function json_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = json_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function json_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return json_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return json_arrayLikeToArray(o, minLen); }
function json_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
/* eslint-disable no-fallthrough */
/* eslint-disable no-case-declarations */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var ScanError = /*#__PURE__*/function (ScanError) {
  ScanError[ScanError["None"] = 0] = "None";
  ScanError[ScanError["UnexpectedEndOfComment"] = 1] = "UnexpectedEndOfComment";
  ScanError[ScanError["UnexpectedEndOfString"] = 2] = "UnexpectedEndOfString";
  ScanError[ScanError["UnexpectedEndOfNumber"] = 3] = "UnexpectedEndOfNumber";
  ScanError[ScanError["InvalidUnicode"] = 4] = "InvalidUnicode";
  ScanError[ScanError["InvalidEscapeCharacter"] = 5] = "InvalidEscapeCharacter";
  ScanError[ScanError["InvalidCharacter"] = 6] = "InvalidCharacter";
  return ScanError;
}({});
var SyntaxKind = /*#__PURE__*/function (SyntaxKind) {
  SyntaxKind[SyntaxKind["OpenBraceToken"] = 1] = "OpenBraceToken";
  SyntaxKind[SyntaxKind["CloseBraceToken"] = 2] = "CloseBraceToken";
  SyntaxKind[SyntaxKind["OpenBracketToken"] = 3] = "OpenBracketToken";
  SyntaxKind[SyntaxKind["CloseBracketToken"] = 4] = "CloseBracketToken";
  SyntaxKind[SyntaxKind["CommaToken"] = 5] = "CommaToken";
  SyntaxKind[SyntaxKind["ColonToken"] = 6] = "ColonToken";
  SyntaxKind[SyntaxKind["NullKeyword"] = 7] = "NullKeyword";
  SyntaxKind[SyntaxKind["TrueKeyword"] = 8] = "TrueKeyword";
  SyntaxKind[SyntaxKind["FalseKeyword"] = 9] = "FalseKeyword";
  SyntaxKind[SyntaxKind["StringLiteral"] = 10] = "StringLiteral";
  SyntaxKind[SyntaxKind["NumericLiteral"] = 11] = "NumericLiteral";
  SyntaxKind[SyntaxKind["LineCommentTrivia"] = 12] = "LineCommentTrivia";
  SyntaxKind[SyntaxKind["BlockCommentTrivia"] = 13] = "BlockCommentTrivia";
  SyntaxKind[SyntaxKind["LineBreakTrivia"] = 14] = "LineBreakTrivia";
  SyntaxKind[SyntaxKind["Trivia"] = 15] = "Trivia";
  SyntaxKind[SyntaxKind["Unknown"] = 16] = "Unknown";
  SyntaxKind[SyntaxKind["EOF"] = 17] = "EOF";
  return SyntaxKind;
}({});

/**
 * The scanner object, representing a JSON scanner at a position in the input string.
 */

var ParseErrorCode = /*#__PURE__*/function (ParseErrorCode) {
  ParseErrorCode[ParseErrorCode["InvalidSymbol"] = 1] = "InvalidSymbol";
  ParseErrorCode[ParseErrorCode["InvalidNumberFormat"] = 2] = "InvalidNumberFormat";
  ParseErrorCode[ParseErrorCode["PropertyNameExpected"] = 3] = "PropertyNameExpected";
  ParseErrorCode[ParseErrorCode["ValueExpected"] = 4] = "ValueExpected";
  ParseErrorCode[ParseErrorCode["ColonExpected"] = 5] = "ColonExpected";
  ParseErrorCode[ParseErrorCode["CommaExpected"] = 6] = "CommaExpected";
  ParseErrorCode[ParseErrorCode["CloseBraceExpected"] = 7] = "CloseBraceExpected";
  ParseErrorCode[ParseErrorCode["CloseBracketExpected"] = 8] = "CloseBracketExpected";
  ParseErrorCode[ParseErrorCode["EndOfFileExpected"] = 9] = "EndOfFileExpected";
  ParseErrorCode[ParseErrorCode["InvalidCommentToken"] = 10] = "InvalidCommentToken";
  ParseErrorCode[ParseErrorCode["UnexpectedEndOfComment"] = 11] = "UnexpectedEndOfComment";
  ParseErrorCode[ParseErrorCode["UnexpectedEndOfString"] = 12] = "UnexpectedEndOfString";
  ParseErrorCode[ParseErrorCode["UnexpectedEndOfNumber"] = 13] = "UnexpectedEndOfNumber";
  ParseErrorCode[ParseErrorCode["InvalidUnicode"] = 14] = "InvalidUnicode";
  ParseErrorCode[ParseErrorCode["InvalidEscapeCharacter"] = 15] = "InvalidEscapeCharacter";
  ParseErrorCode[ParseErrorCode["InvalidCharacter"] = 16] = "InvalidCharacter";
  return ParseErrorCode;
}({});
var ParseOptions;
(function (_ParseOptions) {
  var DEFAULT = _ParseOptions.DEFAULT = {
    allowTrailingComma: true
  };
})(ParseOptions || (ParseOptions = {}));
/**
 * Creates a JSON scanner on the given text.
 * If ignoreTrivia is set, whitespaces or comments are ignored.
 */
function createScanner(text) {
  var ignoreTrivia = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
  var pos = 0;
  var len = text.length;
  var value = '';
  var tokenOffset = 0;
  var token = SyntaxKind.Unknown;
  var scanError = ScanError.None;
  function scanHexDigits(count) {
    var digits = 0;
    var hexValue = 0;
    while (digits < count) {
      var ch = text.charCodeAt(pos);
      if (ch >= CharacterCodes._0 && ch <= CharacterCodes._9) {
        hexValue = hexValue * 16 + ch - CharacterCodes._0;
      } else if (ch >= CharacterCodes.A && ch <= CharacterCodes.F) {
        hexValue = hexValue * 16 + ch - CharacterCodes.A + 10;
      } else if (ch >= CharacterCodes.a && ch <= CharacterCodes.f) {
        hexValue = hexValue * 16 + ch - CharacterCodes.a + 10;
      } else {
        break;
      }
      pos++;
      digits++;
    }
    if (digits < count) {
      hexValue = -1;
    }
    return hexValue;
  }
  function setPosition(newPosition) {
    pos = newPosition;
    value = '';
    tokenOffset = 0;
    token = SyntaxKind.Unknown;
    scanError = ScanError.None;
  }
  function scanNumber() {
    var start = pos;
    if (text.charCodeAt(pos) === CharacterCodes._0) {
      pos++;
    } else {
      pos++;
      while (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
      }
    }
    if (pos < text.length && text.charCodeAt(pos) === CharacterCodes.dot) {
      pos++;
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
      } else {
        scanError = ScanError.UnexpectedEndOfNumber;
        return text.substring(start, pos);
      }
    }
    var end = pos;
    if (pos < text.length && (text.charCodeAt(pos) === CharacterCodes.E || text.charCodeAt(pos) === CharacterCodes.e)) {
      pos++;
      if (pos < text.length && text.charCodeAt(pos) === CharacterCodes.plus || text.charCodeAt(pos) === CharacterCodes.minus) {
        pos++;
      }
      if (pos < text.length && isDigit(text.charCodeAt(pos))) {
        pos++;
        while (pos < text.length && isDigit(text.charCodeAt(pos))) {
          pos++;
        }
        end = pos;
      } else {
        scanError = ScanError.UnexpectedEndOfNumber;
      }
    }
    return text.substring(start, end);
  }
  function scanString() {
    var result = '';
    var start = pos;

    // eslint-disable-next-line no-constant-condition
    while (true) {
      if (pos >= len) {
        result += text.substring(start, pos);
        scanError = ScanError.UnexpectedEndOfString;
        break;
      }
      var ch = text.charCodeAt(pos);
      if (ch === CharacterCodes.doubleQuote) {
        result += text.substring(start, pos);
        pos++;
        break;
      }
      if (ch === CharacterCodes.backslash) {
        result += text.substring(start, pos);
        pos++;
        if (pos >= len) {
          scanError = ScanError.UnexpectedEndOfString;
          break;
        }
        var ch2 = text.charCodeAt(pos++);
        switch (ch2) {
          case CharacterCodes.doubleQuote:
            result += '"';
            break;
          case CharacterCodes.backslash:
            result += '\\';
            break;
          case CharacterCodes.slash:
            result += '/';
            break;
          case CharacterCodes.b:
            result += '\b';
            break;
          case CharacterCodes.f:
            result += '\f';
            break;
          case CharacterCodes.n:
            result += '\n';
            break;
          case CharacterCodes.r:
            result += '\r';
            break;
          case CharacterCodes.t:
            result += '\t';
            break;
          case CharacterCodes.u:
            var ch3 = scanHexDigits(4);
            if (ch3 >= 0) {
              result += String.fromCharCode(ch3);
            } else {
              scanError = ScanError.InvalidUnicode;
            }
            break;
          default:
            scanError = ScanError.InvalidEscapeCharacter;
        }
        start = pos;
        continue;
      }
      if (ch >= 0 && ch <= 0x1f) {
        if (isLineBreak(ch)) {
          result += text.substring(start, pos);
          scanError = ScanError.UnexpectedEndOfString;
          break;
        } else {
          scanError = ScanError.InvalidCharacter;
          // mark as error but continue with string
        }
      }
      pos++;
    }
    return result;
  }
  function scanNext() {
    value = '';
    scanError = ScanError.None;
    tokenOffset = pos;
    if (pos >= len) {
      // at the end
      tokenOffset = len;
      return token = SyntaxKind.EOF;
    }
    var code = text.charCodeAt(pos);
    // trivia: whitespace
    if (isWhitespace(code)) {
      do {
        pos++;
        value += String.fromCharCode(code);
        code = text.charCodeAt(pos);
      } while (isWhitespace(code));
      return token = SyntaxKind.Trivia;
    }

    // trivia: newlines
    if (isLineBreak(code)) {
      pos++;
      value += String.fromCharCode(code);
      if (code === CharacterCodes.carriageReturn && text.charCodeAt(pos) === CharacterCodes.lineFeed) {
        pos++;
        value += '\n';
      }
      return token = SyntaxKind.LineBreakTrivia;
    }
    switch (code) {
      // tokens: []{}:,
      case CharacterCodes.openBrace:
        pos++;
        return token = SyntaxKind.OpenBraceToken;
      case CharacterCodes.closeBrace:
        pos++;
        return token = SyntaxKind.CloseBraceToken;
      case CharacterCodes.openBracket:
        pos++;
        return token = SyntaxKind.OpenBracketToken;
      case CharacterCodes.closeBracket:
        pos++;
        return token = SyntaxKind.CloseBracketToken;
      case CharacterCodes.colon:
        pos++;
        return token = SyntaxKind.ColonToken;
      case CharacterCodes.comma:
        pos++;
        return token = SyntaxKind.CommaToken;

      // strings
      case CharacterCodes.doubleQuote:
        pos++;
        value = scanString();
        return token = SyntaxKind.StringLiteral;

      // comments
      case CharacterCodes.slash:
        var start = pos - 1;
        // Single-line comment
        if (text.charCodeAt(pos + 1) === CharacterCodes.slash) {
          pos += 2;
          while (pos < len) {
            if (isLineBreak(text.charCodeAt(pos))) {
              break;
            }
            pos++;
          }
          value = text.substring(start, pos);
          return token = SyntaxKind.LineCommentTrivia;
        }

        // Multi-line comment
        if (text.charCodeAt(pos + 1) === CharacterCodes.asterisk) {
          pos += 2;
          var safeLength = len - 1; // For lookahead.
          var commentClosed = false;
          while (pos < safeLength) {
            var ch = text.charCodeAt(pos);
            if (ch === CharacterCodes.asterisk && text.charCodeAt(pos + 1) === CharacterCodes.slash) {
              pos += 2;
              commentClosed = true;
              break;
            }
            pos++;
          }
          if (!commentClosed) {
            pos++;
            scanError = ScanError.UnexpectedEndOfComment;
          }
          value = text.substring(start, pos);
          return token = SyntaxKind.BlockCommentTrivia;
        }
        // just a single slash
        value += String.fromCharCode(code);
        pos++;
        return token = SyntaxKind.Unknown;

      // numbers
      case CharacterCodes.minus:
        value += String.fromCharCode(code);
        pos++;
        if (pos === len || !isDigit(text.charCodeAt(pos))) {
          return token = SyntaxKind.Unknown;
        }
      // found a minus, followed by a number so
      // we fall through to proceed with scanning
      // numbers
      case CharacterCodes._0:
      case CharacterCodes._1:
      case CharacterCodes._2:
      case CharacterCodes._3:
      case CharacterCodes._4:
      case CharacterCodes._5:
      case CharacterCodes._6:
      case CharacterCodes._7:
      case CharacterCodes._8:
      case CharacterCodes._9:
        value += scanNumber();
        return token = SyntaxKind.NumericLiteral;
      // literals and unknown symbols
      default:
        // is a literal? Read the full word.
        while (pos < len && isUnknownContentCharacter(code)) {
          pos++;
          code = text.charCodeAt(pos);
        }
        if (tokenOffset !== pos) {
          value = text.substring(tokenOffset, pos);
          // keywords: true, false, null
          switch (value) {
            case 'true':
              return token = SyntaxKind.TrueKeyword;
            case 'false':
              return token = SyntaxKind.FalseKeyword;
            case 'null':
              return token = SyntaxKind.NullKeyword;
          }
          return token = SyntaxKind.Unknown;
        }
        // some
        value += String.fromCharCode(code);
        pos++;
        return token = SyntaxKind.Unknown;
    }
  }
  function isUnknownContentCharacter(code) {
    if (isWhitespace(code) || isLineBreak(code)) {
      return false;
    }
    // eslint-disable-next-line @typescript-eslint/switch-exhaustiveness-check
    switch (code) {
      case CharacterCodes.closeBrace:
      case CharacterCodes.closeBracket:
      case CharacterCodes.openBrace:
      case CharacterCodes.openBracket:
      case CharacterCodes.doubleQuote:
      case CharacterCodes.colon:
      case CharacterCodes.comma:
      case CharacterCodes.slash:
        return false;
    }
    return true;
  }
  function scanNextNonTrivia() {
    var result;
    do {
      result = scanNext();
    } while (result >= SyntaxKind.LineCommentTrivia && result <= SyntaxKind.Trivia);
    return result;
  }
  return {
    setPosition: setPosition,
    getPosition: function getPosition() {
      return pos;
    },
    scan: ignoreTrivia ? scanNextNonTrivia : scanNext,
    getToken: function getToken() {
      return token;
    },
    getTokenValue: function getTokenValue() {
      return value;
    },
    getTokenOffset: function getTokenOffset() {
      return tokenOffset;
    },
    getTokenLength: function getTokenLength() {
      return pos - tokenOffset;
    },
    getTokenError: function getTokenError() {
      return scanError;
    }
  };
}
function isWhitespace(ch) {
  return ch === CharacterCodes.space || ch === CharacterCodes.tab || ch === CharacterCodes.verticalTab || ch === CharacterCodes.formFeed || ch === CharacterCodes.nonBreakingSpace || ch === CharacterCodes.ogham || ch >= CharacterCodes.enQuad && ch <= CharacterCodes.zeroWidthSpace || ch === CharacterCodes.narrowNoBreakSpace || ch === CharacterCodes.mathematicalSpace || ch === CharacterCodes.ideographicSpace || ch === CharacterCodes.byteOrderMark;
}
function isLineBreak(ch) {
  return ch === CharacterCodes.lineFeed || ch === CharacterCodes.carriageReturn || ch === CharacterCodes.lineSeparator || ch === CharacterCodes.paragraphSeparator;
}
function isDigit(ch) {
  return ch >= CharacterCodes._0 && ch <= CharacterCodes._9;
}
var CharacterCodes = /*#__PURE__*/function (CharacterCodes) {
  CharacterCodes[CharacterCodes["nullCharacter"] = 0] = "nullCharacter";
  CharacterCodes[CharacterCodes["maxAsciiCharacter"] = 127] = "maxAsciiCharacter";
  CharacterCodes[CharacterCodes["lineFeed"] = 10] = "lineFeed";
  CharacterCodes[CharacterCodes["carriageReturn"] = 13] = "carriageReturn";
  CharacterCodes[CharacterCodes["lineSeparator"] = 8232] = "lineSeparator";
  CharacterCodes[CharacterCodes["paragraphSeparator"] = 8233] = "paragraphSeparator";
  CharacterCodes[CharacterCodes["nextLine"] = 133] = "nextLine";
  CharacterCodes[CharacterCodes["space"] = 32] = "space";
  CharacterCodes[CharacterCodes["nonBreakingSpace"] = 160] = "nonBreakingSpace";
  CharacterCodes[CharacterCodes["enQuad"] = 8192] = "enQuad";
  CharacterCodes[CharacterCodes["emQuad"] = 8193] = "emQuad";
  CharacterCodes[CharacterCodes["enSpace"] = 8194] = "enSpace";
  CharacterCodes[CharacterCodes["emSpace"] = 8195] = "emSpace";
  CharacterCodes[CharacterCodes["threePerEmSpace"] = 8196] = "threePerEmSpace";
  CharacterCodes[CharacterCodes["fourPerEmSpace"] = 8197] = "fourPerEmSpace";
  CharacterCodes[CharacterCodes["sixPerEmSpace"] = 8198] = "sixPerEmSpace";
  CharacterCodes[CharacterCodes["figureSpace"] = 8199] = "figureSpace";
  CharacterCodes[CharacterCodes["punctuationSpace"] = 8200] = "punctuationSpace";
  CharacterCodes[CharacterCodes["thinSpace"] = 8201] = "thinSpace";
  CharacterCodes[CharacterCodes["hairSpace"] = 8202] = "hairSpace";
  CharacterCodes[CharacterCodes["zeroWidthSpace"] = 8203] = "zeroWidthSpace";
  CharacterCodes[CharacterCodes["narrowNoBreakSpace"] = 8239] = "narrowNoBreakSpace";
  CharacterCodes[CharacterCodes["ideographicSpace"] = 12288] = "ideographicSpace";
  CharacterCodes[CharacterCodes["mathematicalSpace"] = 8287] = "mathematicalSpace";
  CharacterCodes[CharacterCodes["ogham"] = 5760] = "ogham";
  CharacterCodes[CharacterCodes["_"] = 95] = "_";
  CharacterCodes[CharacterCodes["$"] = 36] = "$";
  CharacterCodes[CharacterCodes["_0"] = 48] = "_0";
  CharacterCodes[CharacterCodes["_1"] = 49] = "_1";
  CharacterCodes[CharacterCodes["_2"] = 50] = "_2";
  CharacterCodes[CharacterCodes["_3"] = 51] = "_3";
  CharacterCodes[CharacterCodes["_4"] = 52] = "_4";
  CharacterCodes[CharacterCodes["_5"] = 53] = "_5";
  CharacterCodes[CharacterCodes["_6"] = 54] = "_6";
  CharacterCodes[CharacterCodes["_7"] = 55] = "_7";
  CharacterCodes[CharacterCodes["_8"] = 56] = "_8";
  CharacterCodes[CharacterCodes["_9"] = 57] = "_9";
  CharacterCodes[CharacterCodes["a"] = 97] = "a";
  CharacterCodes[CharacterCodes["b"] = 98] = "b";
  CharacterCodes[CharacterCodes["c"] = 99] = "c";
  CharacterCodes[CharacterCodes["d"] = 100] = "d";
  CharacterCodes[CharacterCodes["e"] = 101] = "e";
  CharacterCodes[CharacterCodes["f"] = 102] = "f";
  CharacterCodes[CharacterCodes["g"] = 103] = "g";
  CharacterCodes[CharacterCodes["h"] = 104] = "h";
  CharacterCodes[CharacterCodes["i"] = 105] = "i";
  CharacterCodes[CharacterCodes["j"] = 106] = "j";
  CharacterCodes[CharacterCodes["k"] = 107] = "k";
  CharacterCodes[CharacterCodes["l"] = 108] = "l";
  CharacterCodes[CharacterCodes["m"] = 109] = "m";
  CharacterCodes[CharacterCodes["n"] = 110] = "n";
  CharacterCodes[CharacterCodes["o"] = 111] = "o";
  CharacterCodes[CharacterCodes["p"] = 112] = "p";
  CharacterCodes[CharacterCodes["q"] = 113] = "q";
  CharacterCodes[CharacterCodes["r"] = 114] = "r";
  CharacterCodes[CharacterCodes["s"] = 115] = "s";
  CharacterCodes[CharacterCodes["t"] = 116] = "t";
  CharacterCodes[CharacterCodes["u"] = 117] = "u";
  CharacterCodes[CharacterCodes["v"] = 118] = "v";
  CharacterCodes[CharacterCodes["w"] = 119] = "w";
  CharacterCodes[CharacterCodes["x"] = 120] = "x";
  CharacterCodes[CharacterCodes["y"] = 121] = "y";
  CharacterCodes[CharacterCodes["z"] = 122] = "z";
  CharacterCodes[CharacterCodes["A"] = 65] = "A";
  CharacterCodes[CharacterCodes["B"] = 66] = "B";
  CharacterCodes[CharacterCodes["C"] = 67] = "C";
  CharacterCodes[CharacterCodes["D"] = 68] = "D";
  CharacterCodes[CharacterCodes["E"] = 69] = "E";
  CharacterCodes[CharacterCodes["F"] = 70] = "F";
  CharacterCodes[CharacterCodes["G"] = 71] = "G";
  CharacterCodes[CharacterCodes["H"] = 72] = "H";
  CharacterCodes[CharacterCodes["I"] = 73] = "I";
  CharacterCodes[CharacterCodes["J"] = 74] = "J";
  CharacterCodes[CharacterCodes["K"] = 75] = "K";
  CharacterCodes[CharacterCodes["L"] = 76] = "L";
  CharacterCodes[CharacterCodes["M"] = 77] = "M";
  CharacterCodes[CharacterCodes["N"] = 78] = "N";
  CharacterCodes[CharacterCodes["O"] = 79] = "O";
  CharacterCodes[CharacterCodes["P"] = 80] = "P";
  CharacterCodes[CharacterCodes["Q"] = 81] = "Q";
  CharacterCodes[CharacterCodes["R"] = 82] = "R";
  CharacterCodes[CharacterCodes["S"] = 83] = "S";
  CharacterCodes[CharacterCodes["T"] = 84] = "T";
  CharacterCodes[CharacterCodes["U"] = 85] = "U";
  CharacterCodes[CharacterCodes["V"] = 86] = "V";
  CharacterCodes[CharacterCodes["W"] = 87] = "W";
  CharacterCodes[CharacterCodes["X"] = 88] = "X";
  CharacterCodes[CharacterCodes["Y"] = 89] = "Y";
  CharacterCodes[CharacterCodes["Z"] = 90] = "Z";
  CharacterCodes[CharacterCodes["ampersand"] = 38] = "ampersand";
  CharacterCodes[CharacterCodes["asterisk"] = 42] = "asterisk";
  CharacterCodes[CharacterCodes["at"] = 64] = "at";
  CharacterCodes[CharacterCodes["backslash"] = 92] = "backslash";
  CharacterCodes[CharacterCodes["bar"] = 124] = "bar";
  CharacterCodes[CharacterCodes["caret"] = 94] = "caret";
  CharacterCodes[CharacterCodes["closeBrace"] = 125] = "closeBrace";
  CharacterCodes[CharacterCodes["closeBracket"] = 93] = "closeBracket";
  CharacterCodes[CharacterCodes["closeParen"] = 41] = "closeParen";
  CharacterCodes[CharacterCodes["colon"] = 58] = "colon";
  CharacterCodes[CharacterCodes["comma"] = 44] = "comma";
  CharacterCodes[CharacterCodes["dot"] = 46] = "dot";
  CharacterCodes[CharacterCodes["doubleQuote"] = 34] = "doubleQuote";
  CharacterCodes[CharacterCodes["equals"] = 61] = "equals";
  CharacterCodes[CharacterCodes["exclamation"] = 33] = "exclamation";
  CharacterCodes[CharacterCodes["greaterThan"] = 62] = "greaterThan";
  CharacterCodes[CharacterCodes["lessThan"] = 60] = "lessThan";
  CharacterCodes[CharacterCodes["minus"] = 45] = "minus";
  CharacterCodes[CharacterCodes["openBrace"] = 123] = "openBrace";
  CharacterCodes[CharacterCodes["openBracket"] = 91] = "openBracket";
  CharacterCodes[CharacterCodes["openParen"] = 40] = "openParen";
  CharacterCodes[CharacterCodes["percent"] = 37] = "percent";
  CharacterCodes[CharacterCodes["plus"] = 43] = "plus";
  CharacterCodes[CharacterCodes["question"] = 63] = "question";
  CharacterCodes[CharacterCodes["semicolon"] = 59] = "semicolon";
  CharacterCodes[CharacterCodes["singleQuote"] = 39] = "singleQuote";
  CharacterCodes[CharacterCodes["slash"] = 47] = "slash";
  CharacterCodes[CharacterCodes["tilde"] = 126] = "tilde";
  CharacterCodes[CharacterCodes["backspace"] = 8] = "backspace";
  CharacterCodes[CharacterCodes["formFeed"] = 12] = "formFeed";
  CharacterCodes[CharacterCodes["byteOrderMark"] = 65279] = "byteOrderMark";
  CharacterCodes[CharacterCodes["tab"] = 9] = "tab";
  CharacterCodes[CharacterCodes["verticalTab"] = 11] = "verticalTab";
  return CharacterCodes;
}(CharacterCodes || {}); // \v
/**
 * For a given offset, evaluate the location in the JSON document. Each segment in the location path is either a property name or an array index.
 */
function getLocation(text, position) {
  var segments = []; // strings or numbers
  // eslint-disable-next-line no-new-object
  var earlyReturnException = new Object();
  var previousNode;
  var previousNodeInst = {
    value: {},
    offset: 0,
    length: 0,
    type: 'object',
    parent: undefined
  };
  var isAtPropertyKey = false;
  function setPreviousNode(value, offset, length, type) {
    previousNodeInst.value = value;
    previousNodeInst.offset = offset;
    previousNodeInst.length = length;
    previousNodeInst.type = type;
    previousNodeInst.colonOffset = undefined;
    previousNode = previousNodeInst;
  }
  try {
    visit(text, {
      onObjectBegin: function onObjectBegin(offset, _length) {
        if (position <= offset) {
          throw earlyReturnException;
        }
        previousNode = undefined;
        isAtPropertyKey = position > offset;
        segments.push(''); // push a placeholder (will be replaced)
      },
      onObjectProperty: function onObjectProperty(name, offset, length) {
        if (position < offset) {
          throw earlyReturnException;
        }
        setPreviousNode(name, offset, length, 'property');
        segments[segments.length - 1] = name;
        if (position <= offset + length) {
          throw earlyReturnException;
        }
      },
      onObjectEnd: function onObjectEnd(offset, _length) {
        if (position <= offset) {
          throw earlyReturnException;
        }
        previousNode = undefined;
        segments.pop();
      },
      onArrayBegin: function onArrayBegin(offset, _length) {
        if (position <= offset) {
          throw earlyReturnException;
        }
        previousNode = undefined;
        segments.push(0);
      },
      onArrayEnd: function onArrayEnd(offset, _length) {
        if (position <= offset) {
          throw earlyReturnException;
        }
        previousNode = undefined;
        segments.pop();
      },
      onLiteralValue: function onLiteralValue(value, offset, length) {
        if (position < offset) {
          throw earlyReturnException;
        }
        setPreviousNode(value, offset, length, getNodeType(value));
        if (position <= offset + length) {
          throw earlyReturnException;
        }
      },
      onSeparator: function onSeparator(sep, offset, _length) {
        if (position <= offset) {
          throw earlyReturnException;
        }
        if (sep === ':' && previousNode && previousNode.type === 'property') {
          previousNode.colonOffset = offset;
          isAtPropertyKey = false;
          previousNode = undefined;
        } else if (sep === ',') {
          var last = segments[segments.length - 1];
          if (typeof last === 'number') {
            segments[segments.length - 1] = last + 1;
          } else {
            isAtPropertyKey = true;
            segments[segments.length - 1] = '';
          }
          previousNode = undefined;
        }
      }
    });
  } catch (e) {
    if (e !== earlyReturnException) {
      throw e;
    }
  }
  return {
    path: segments,
    previousNode: previousNode,
    isAtPropertyKey: isAtPropertyKey,
    matches: function matches(pattern) {
      var k = 0;
      for (var i = 0; k < pattern.length && i < segments.length; i++) {
        if (pattern[k] === segments[i] || pattern[k] === '*') {
          k++;
        } else if (pattern[k] !== '**') {
          return false;
        }
      }
      return k === pattern.length;
    }
  };
}

/**
 * Parses the given text and returns the object the JSON content represents. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 * Therefore always check the errors list to find out if the input was valid.
 */
function parse(text) {
  var errors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ParseOptions.DEFAULT;
  var currentProperty = null;
  var currentParent = [];
  var previousParents = [];
  function onValue(value) {
    if (Array.isArray(currentParent)) {
      currentParent.push(value);
    } else if (currentProperty !== null) {
      currentParent[currentProperty] = value;
    }
  }
  var visitor = {
    onObjectBegin: function onObjectBegin() {
      var object = {};
      onValue(object);
      previousParents.push(currentParent);
      currentParent = object;
      currentProperty = null;
    },
    onObjectProperty: function onObjectProperty(name) {
      currentProperty = name;
    },
    onObjectEnd: function onObjectEnd() {
      currentParent = previousParents.pop();
    },
    onArrayBegin: function onArrayBegin() {
      var array = [];
      onValue(array);
      previousParents.push(currentParent);
      currentParent = array;
      currentProperty = null;
    },
    onArrayEnd: function onArrayEnd() {
      currentParent = previousParents.pop();
    },
    onLiteralValue: onValue,
    onError: function onError(error, offset, length) {
      errors.push({
        error: error,
        offset: offset,
        length: length
      });
    }
  };
  visit(text, visitor, options);
  return currentParent[0];
}

/**
 * Parses the given text and returns a tree representation the JSON content. On invalid input, the parser tries to be as fault tolerant as possible, but still return a result.
 */
function parseTree(text) {
  var errors = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ParseOptions.DEFAULT;
  var currentParent = {
    type: 'array',
    offset: -1,
    length: -1,
    children: [],
    parent: undefined
  }; // artificial root

  function ensurePropertyComplete(endOffset) {
    if (currentParent.type === 'property') {
      currentParent.length = endOffset - currentParent.offset;
      currentParent = currentParent.parent;
    }
  }
  function onValue(valueNode) {
    currentParent.children.push(valueNode);
    return valueNode;
  }
  var visitor = {
    onObjectBegin: function onObjectBegin(offset) {
      currentParent = onValue({
        type: 'object',
        offset: offset,
        length: -1,
        parent: currentParent,
        children: []
      });
    },
    onObjectProperty: function onObjectProperty(name, offset, length) {
      currentParent = onValue({
        type: 'property',
        offset: offset,
        length: -1,
        parent: currentParent,
        children: []
      });
      currentParent.children.push({
        type: 'string',
        value: name,
        offset: offset,
        length: length,
        parent: currentParent
      });
    },
    onObjectEnd: function onObjectEnd(offset, length) {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    },
    onArrayBegin: function onArrayBegin(offset, _length) {
      currentParent = onValue({
        type: 'array',
        offset: offset,
        length: -1,
        parent: currentParent,
        children: []
      });
    },
    onArrayEnd: function onArrayEnd(offset, length) {
      currentParent.length = offset + length - currentParent.offset;
      currentParent = currentParent.parent;
      ensurePropertyComplete(offset + length);
    },
    onLiteralValue: function onLiteralValue(value, offset, length) {
      onValue({
        type: getNodeType(value),
        offset: offset,
        length: length,
        parent: currentParent,
        value: value
      });
      ensurePropertyComplete(offset + length);
    },
    onSeparator: function onSeparator(sep, offset, _length) {
      if (currentParent.type === 'property') {
        if (sep === ':') {
          currentParent.colonOffset = offset;
        } else if (sep === ',') {
          ensurePropertyComplete(offset);
        }
      }
    },
    onError: function onError(error, offset, length) {
      errors.push({
        error: error,
        offset: offset,
        length: length
      });
    }
  };
  visit(text, visitor, options);
  var result = currentParent.children[0];
  if (result) {
    delete result.parent;
  }
  return result;
}

/**
 * Finds the node at the given path in a JSON DOM.
 */
function findNodeAtLocation(root, path) {
  if (!root) {
    return undefined;
  }
  var node = root;
  var _iterator = json_createForOfIteratorHelper(path),
    _step;
  try {
    for (_iterator.s(); !(_step = _iterator.n()).done;) {
      var segment = _step.value;
      if (typeof segment === 'string') {
        if (node.type !== 'object' || !Array.isArray(node.children)) {
          return undefined;
        }
        var found = false;
        var _iterator2 = json_createForOfIteratorHelper(node.children),
          _step2;
        try {
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            var propertyNode = _step2.value;
            if (Array.isArray(propertyNode.children) && propertyNode.children[0].value === segment) {
              // eslint-disable-next-line prefer-destructuring
              node = propertyNode.children[1];
              found = true;
              break;
            }
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
        if (!found) {
          return undefined;
        }
      } else {
        var index = segment;
        if (node.type !== 'array' || index < 0 || !Array.isArray(node.children) || index >= node.children.length) {
          return undefined;
        }
        node = node.children[index];
      }
    }
  } catch (err) {
    _iterator.e(err);
  } finally {
    _iterator.f();
  }
  return node;
}

/**
 * Gets the JSON path of the given JSON DOM node
 */
function getNodePath(node) {
  if (!node.parent || !node.parent.children) {
    return [];
  }
  var path = getNodePath(node.parent);
  if (node.parent.type === 'property') {
    var key = node.parent.children[0].value;
    path.push(key);
  } else if (node.parent.type === 'array') {
    var index = node.parent.children.indexOf(node);
    if (index !== -1) {
      path.push(index);
    }
  }
  return path;
}

/**
 * Evaluates the JavaScript object of the given JSON DOM node
 */
function getNodeValue(node) {
  switch (node.type) {
    case 'array':
      return node.children.map(getNodeValue);
    case 'object':
      var obj = Object.create(null);
      var _iterator3 = json_createForOfIteratorHelper(node.children),
        _step3;
      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var prop = _step3.value;
          var valueNode = prop.children[1];
          if (valueNode) {
            obj[prop.children[0].value] = getNodeValue(valueNode);
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
      return obj;
    case 'null':
    case 'string':
    case 'number':
    case 'boolean':
      return node.value;
    default:
      return undefined;
  }
}
function contains(node, offset) {
  var includeRightBound = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  return offset >= node.offset && offset < node.offset + node.length || includeRightBound && offset === node.offset + node.length;
}

/**
 * Finds the most inner node at the given offset. If includeRightBound is set, also finds nodes that end at the given offset.
 */
function findNodeAtOffset(node, offset) {
  var includeRightBound = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;
  if (contains(node, offset, includeRightBound)) {
    var children = node.children;
    if (Array.isArray(children)) {
      for (var i = 0; i < children.length && children[i].offset <= offset; i++) {
        var item = findNodeAtOffset(children[i], offset, includeRightBound);
        if (item) {
          return item;
        }
      }
    }
    return node;
  }
  return undefined;
}

/**
 * Parses the given text and invokes the visitor functions for each object, array and literal reached.
 */
function visit(text, visitor) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : ParseOptions.DEFAULT;
  var _scanner = createScanner(text, false);
  function toNoArgVisit(visitFunction) {
    return visitFunction ? function () {
      return visitFunction(_scanner.getTokenOffset(), _scanner.getTokenLength());
    } : function () {
      return true;
    };
  }
  function toOneArgVisit(visitFunction) {
    return visitFunction ? function (arg) {
      return visitFunction(arg, _scanner.getTokenOffset(), _scanner.getTokenLength());
    } : function () {
      return true;
    };
  }
  var onObjectBegin = toNoArgVisit(visitor.onObjectBegin);
  var onObjectProperty = toOneArgVisit(visitor.onObjectProperty);
  var onObjectEnd = toNoArgVisit(visitor.onObjectEnd);
  var onArrayBegin = toNoArgVisit(visitor.onArrayBegin);
  var onArrayEnd = toNoArgVisit(visitor.onArrayEnd);
  var onLiteralValue = toOneArgVisit(visitor.onLiteralValue);
  var onSeparator = toOneArgVisit(visitor.onSeparator);
  var onComment = toNoArgVisit(visitor.onComment);
  var onError = toOneArgVisit(visitor.onError);
  var disallowComments = options && options.disallowComments;
  var allowTrailingComma = options && options.allowTrailingComma;
  function scanNext() {
    // eslint-disable-next-line no-constant-condition
    while (true) {
      var token = _scanner.scan();
      // eslint-disable-next-line @typescript-eslint/switch-exhaustiveness-check
      switch (_scanner.getTokenError()) {
        case ScanError.InvalidUnicode:
          handleError(ParseErrorCode.InvalidUnicode);
          break;
        case ScanError.InvalidEscapeCharacter:
          handleError(ParseErrorCode.InvalidEscapeCharacter);
          break;
        case ScanError.UnexpectedEndOfNumber:
          handleError(ParseErrorCode.UnexpectedEndOfNumber);
          break;
        case ScanError.UnexpectedEndOfComment:
          if (!disallowComments) {
            handleError(ParseErrorCode.UnexpectedEndOfComment);
          }
          break;
        case ScanError.UnexpectedEndOfString:
          handleError(ParseErrorCode.UnexpectedEndOfString);
          break;
        case ScanError.InvalidCharacter:
          handleError(ParseErrorCode.InvalidCharacter);
          break;
      }
      switch (token) {
        case SyntaxKind.LineCommentTrivia:
        case SyntaxKind.BlockCommentTrivia:
          if (disallowComments) {
            handleError(ParseErrorCode.InvalidCommentToken);
          } else {
            onComment();
          }
          break;
        case SyntaxKind.Unknown:
          handleError(ParseErrorCode.InvalidSymbol);
          break;
        case SyntaxKind.Trivia:
        case SyntaxKind.LineBreakTrivia:
          break;
        default:
          return token;
      }
    }
  }
  function handleError(error) {
    var skipUntilAfter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var skipUntil = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    onError(error);
    if (skipUntilAfter.length + skipUntil.length > 0) {
      var token = _scanner.getToken();
      while (token !== SyntaxKind.EOF) {
        if (skipUntilAfter.indexOf(token) !== -1) {
          scanNext();
          break;
        } else if (skipUntil.indexOf(token) !== -1) {
          break;
        }
        token = scanNext();
      }
    }
  }
  function parseString(isValue) {
    var value = _scanner.getTokenValue();
    if (isValue) {
      onLiteralValue(value);
    } else {
      onObjectProperty(value);
    }
    scanNext();
    return true;
  }
  function parseLiteral() {
    switch (_scanner.getToken()) {
      case SyntaxKind.NumericLiteral:
        var _value = 0;
        try {
          _value = JSON.parse(_scanner.getTokenValue());
          if (typeof _value !== 'number') {
            handleError(ParseErrorCode.InvalidNumberFormat);
            _value = 0;
          }
        } catch (e) {
          handleError(ParseErrorCode.InvalidNumberFormat);
        }
        onLiteralValue(_value);
        break;
      case SyntaxKind.NullKeyword:
        onLiteralValue(null);
        break;
      case SyntaxKind.TrueKeyword:
        onLiteralValue(true);
        break;
      case SyntaxKind.FalseKeyword:
        onLiteralValue(false);
        break;
      default:
        return false;
    }
    scanNext();
    return true;
  }
  function parseProperty() {
    if (_scanner.getToken() !== SyntaxKind.StringLiteral) {
      handleError(ParseErrorCode.PropertyNameExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
      return false;
    }
    parseString(false);
    if (_scanner.getToken() === SyntaxKind.ColonToken) {
      onSeparator(':');
      scanNext(); // consume colon

      if (!parseValue()) {
        handleError(ParseErrorCode.ValueExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
      }
    } else {
      handleError(ParseErrorCode.ColonExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
    }
    return true;
  }
  function parseObject() {
    onObjectBegin();
    scanNext(); // consume open brace

    var needsComma = false;
    while (_scanner.getToken() !== SyntaxKind.CloseBraceToken && _scanner.getToken() !== SyntaxKind.EOF) {
      if (_scanner.getToken() === SyntaxKind.CommaToken) {
        if (!needsComma) {
          handleError(ParseErrorCode.ValueExpected, [], []);
        }
        onSeparator(',');
        scanNext(); // consume comma
        if (_scanner.getToken() === SyntaxKind.CloseBraceToken && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(ParseErrorCode.CommaExpected, [], []);
      }
      if (!parseProperty()) {
        handleError(ParseErrorCode.ValueExpected, [], [SyntaxKind.CloseBraceToken, SyntaxKind.CommaToken]);
      }
      needsComma = true;
    }
    onObjectEnd();
    if (_scanner.getToken() !== SyntaxKind.CloseBraceToken) {
      handleError(ParseErrorCode.CloseBraceExpected, [SyntaxKind.CloseBraceToken], []);
    } else {
      scanNext(); // consume close brace
    }
    return true;
  }
  function parseArray() {
    onArrayBegin();
    scanNext(); // consume open bracket

    var needsComma = false;
    while (_scanner.getToken() !== SyntaxKind.CloseBracketToken && _scanner.getToken() !== SyntaxKind.EOF) {
      if (_scanner.getToken() === SyntaxKind.CommaToken) {
        if (!needsComma) {
          handleError(ParseErrorCode.ValueExpected, [], []);
        }
        onSeparator(',');
        scanNext(); // consume comma
        if (_scanner.getToken() === SyntaxKind.CloseBracketToken && allowTrailingComma) {
          break;
        }
      } else if (needsComma) {
        handleError(ParseErrorCode.CommaExpected, [], []);
      }
      if (!parseValue()) {
        handleError(ParseErrorCode.ValueExpected, [], [SyntaxKind.CloseBracketToken, SyntaxKind.CommaToken]);
      }
      needsComma = true;
    }
    onArrayEnd();
    if (_scanner.getToken() !== SyntaxKind.CloseBracketToken) {
      handleError(ParseErrorCode.CloseBracketExpected, [SyntaxKind.CloseBracketToken], []);
    } else {
      scanNext(); // consume close bracket
    }
    return true;
  }
  function parseValue() {
    switch (_scanner.getToken()) {
      case SyntaxKind.OpenBracketToken:
        return parseArray();
      case SyntaxKind.OpenBraceToken:
        return parseObject();
      case SyntaxKind.StringLiteral:
        return parseString(true);
      default:
        return parseLiteral();
    }
  }
  scanNext();
  if (_scanner.getToken() === SyntaxKind.EOF) {
    if (options.allowEmptyContent) {
      return true;
    }
    handleError(ParseErrorCode.ValueExpected, [], []);
    return false;
  }
  if (!parseValue()) {
    handleError(ParseErrorCode.ValueExpected, [], []);
    return false;
  }
  if (_scanner.getToken() !== SyntaxKind.EOF) {
    handleError(ParseErrorCode.EndOfFileExpected, [], []);
  }
  return true;
}

/**
 * Takes JSON with JavaScript-style comments and remove
 * them. Optionally replaces every none-newline character
 * of comments with a replaceCharacter
 */
function stripComments(text, replaceCh) {
  var _scanner = createScanner(text);
  var parts = [];
  var kind;
  var offset = 0;
  var pos;
  do {
    pos = _scanner.getPosition();
    kind = _scanner.scan();
    // eslint-disable-next-line @typescript-eslint/switch-exhaustiveness-check
    switch (kind) {
      case SyntaxKind.LineCommentTrivia:
      case SyntaxKind.BlockCommentTrivia:
      case SyntaxKind.EOF:
        if (offset !== pos) {
          parts.push(text.substring(offset, pos));
        }
        if (replaceCh !== undefined) {
          parts.push(_scanner.getTokenValue().replace(/[^\r\n]/g, replaceCh));
        }
        offset = _scanner.getPosition();
        break;
    }
  } while (kind !== SyntaxKind.EOF);
  return parts.join('');
}
function getNodeType(value) {
  switch (json_typeof(value)) {
    case 'boolean':
      return 'boolean';
    case 'number':
      return 'number';
    case 'string':
      return 'string';
    case 'object':
      {
        if (!value) {
          return 'null';
        }
        if (Array.isArray(value)) {
          return 'array';
        }
        return 'object';
      }
    default:
      return 'null';
  }
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/configuration/configurationModels.js
function configurationModels_defineProperty(obj, key, value) { key = configurationModels_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function configurationModels_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ configurationModels_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == configurationModels_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(configurationModels_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function configurationModels_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function configurationModels_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { configurationModels_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { configurationModels_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function configurationModels_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) configurationModels_setPrototypeOf(subClass, superClass); }
function configurationModels_setPrototypeOf(o, p) { configurationModels_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return configurationModels_setPrototypeOf(o, p); }
function configurationModels_createSuper(Derived) { var hasNativeReflectConstruct = configurationModels_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = configurationModels_getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = configurationModels_getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return configurationModels_possibleConstructorReturn(this, result); }; }
function configurationModels_possibleConstructorReturn(self, call) { if (call && (configurationModels_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return configurationModels_assertThisInitialized(self); }
function configurationModels_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function configurationModels_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function configurationModels_getPrototypeOf(o) { configurationModels_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return configurationModels_getPrototypeOf(o); }
function configurationModels_slicedToArray(arr, i) { return configurationModels_arrayWithHoles(arr) || configurationModels_iterableToArrayLimit(arr, i) || configurationModels_unsupportedIterableToArray(arr, i) || configurationModels_nonIterableRest(); }
function configurationModels_nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function configurationModels_iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function configurationModels_arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }
function configurationModels_toConsumableArray(arr) { return configurationModels_arrayWithoutHoles(arr) || configurationModels_iterableToArray(arr) || configurationModels_unsupportedIterableToArray(arr) || configurationModels_nonIterableSpread(); }
function configurationModels_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function configurationModels_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function configurationModels_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return configurationModels_arrayLikeToArray(arr); }
function configurationModels_typeof(o) { "@babel/helpers - typeof"; return configurationModels_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configurationModels_typeof(o); }
function configurationModels_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = configurationModels_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function configurationModels_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return configurationModels_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return configurationModels_arrayLikeToArray(o, minLen); }
function configurationModels_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function configurationModels_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configurationModels_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configurationModels_toPropertyKey(descriptor.key), descriptor); } }
function configurationModels_createClass(Constructor, protoProps, staticProps) { if (protoProps) configurationModels_defineProperties(Constructor.prototype, protoProps); if (staticProps) configurationModels_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configurationModels_toPropertyKey(t) { var i = configurationModels_toPrimitive(t, "string"); return "symbol" == configurationModels_typeof(i) ? i : String(i); }
function configurationModels_toPrimitive(t, r) { if ("object" != configurationModels_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configurationModels_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/










//TODO

function distinct(array, keyFn) {
  if (!keyFn) {
    return array.filter(function (element, position) {
      return array.indexOf(element) === position;
    });
  }
  var seen = Object.create(null);
  return array.filter(function (elem) {
    var key = keyFn(elem);
    if (seen[key]) {
      return false;
    }
    seen[key] = true;
    return true;
  });
}
function equals(one, other) {
  var itemEquals = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : function (a, b) {
    return a === b;
  };
  if (one === other) {
    return true;
  }
  if (!one || !other) {
    return false;
  }
  if (one.length !== other.length) {
    return false;
  }
  for (var i = 0, len = one.length; i < len; i++) {
    if (!itemEquals(one[i], other[i])) {
      return false;
    }
  }
  return true;
}
var ConfigurationModel = /*#__PURE__*/function () {
  function ConfigurationModel() {
    var _contents = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var _keys = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];
    var _overrides = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
    configurationModels_classCallCheck(this, ConfigurationModel);
    this.isFrozen = false;
    this._contents = {};
    this._keys = [];
    this._overrides = [];
    this._contents = _contents;
    this._keys = _keys;
    this._overrides = _overrides;
  }
  configurationModels_createClass(ConfigurationModel, [{
    key: "contents",
    get: function get() {
      return this.checkAndFreeze(this._contents);
    }
  }, {
    key: "overrides",
    get: function get() {
      return this.checkAndFreeze(this._overrides);
    }
  }, {
    key: "keys",
    get: function get() {
      return this.checkAndFreeze(this._keys);
    }
  }, {
    key: "isEmpty",
    value: function isEmpty() {
      return this._keys.length === 0 && Object.keys(this._contents).length === 0 && this._overrides.length === 0;
    }
  }, {
    key: "getValue",
    value: function getValue(section) {
      return section ? getConfigurationValue(this.contents, section) : this.contents;
    }
  }, {
    key: "getOverrideValue",
    value: function getOverrideValue(section, overrideIdentifier) {
      var overrideContents = this.getContentsForOverrideIdentifer(overrideIdentifier);
      return overrideContents ? section ? getConfigurationValue(overrideContents, section) : overrideContents : undefined;
    }
  }, {
    key: "getKeysForOverrideIdentifier",
    value: function getKeysForOverrideIdentifier(identifier) {
      var _iterator = configurationModels_createForOfIteratorHelper(this.overrides),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var override = _step.value;
          if (override.identifiers.indexOf(identifier) !== -1) {
            return override.keys;
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      return [];
    }
  }, {
    key: "override",
    value: function override(identifier) {
      var overrideContents = this.getContentsForOverrideIdentifer(identifier);
      if (!overrideContents || configurationModels_typeof(overrideContents) !== 'object' || !Object.keys(overrideContents).length) {
        // If there are no valid overrides, return self
        return this;
      }
      var contents = {};
      var _iterator2 = configurationModels_createForOfIteratorHelper(distinct([].concat(configurationModels_toConsumableArray(Object.keys(this.contents)), configurationModels_toConsumableArray(Object.keys(overrideContents))))),
        _step2;
      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var key = _step2.value;
          var contentsForKey = this.contents[key];
          var overrideContentsForKey = overrideContents[key];

          // If there are override contents for the key, clone and merge otherwise use base contents
          if (overrideContentsForKey) {
            // Clone and merge only if base contents and override contents are of type object otherwise just override
            if (configurationModels_typeof(contentsForKey) === 'object' && configurationModels_typeof(overrideContentsForKey) === 'object') {
              contentsForKey = objects.deepClone(contentsForKey);
              this.mergeContents(contentsForKey, overrideContentsForKey);
            } else {
              contentsForKey = overrideContentsForKey;
            }
          }
          contents[key] = contentsForKey;
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
      return new ConfigurationModel(contents, this.keys, this.overrides);
    }
  }, {
    key: "merge",
    value: function merge() {
      var _this = this;
      var contents = objects.deepClone(this.contents);
      var overrides = objects.deepClone(this.overrides);
      var keys = configurationModels_toConsumableArray(this.keys);
      for (var _len = arguments.length, others = new Array(_len), _key2 = 0; _key2 < _len; _key2++) {
        others[_key2] = arguments[_key2];
      }
      for (var _i = 0, _others = others; _i < _others.length; _i++) {
        var other = _others[_i];
        this.mergeContents(contents, other.contents);
        var _iterator3 = configurationModels_createForOfIteratorHelper(other.overrides),
          _step3;
        try {
          var _loop = function _loop() {
            var otherOverride = _step3.value;
            var _overrides$filter = overrides.filter(function (o) {
                return equals(o.identifiers, otherOverride.identifiers);
              }),
              _overrides$filter2 = configurationModels_slicedToArray(_overrides$filter, 1),
              override = _overrides$filter2[0];
            if (override) {
              _this.mergeContents(override.contents, otherOverride.contents);
            } else {
              overrides.push(objects.deepClone(otherOverride));
            }
          };
          for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
            _loop();
          }
        } catch (err) {
          _iterator3.e(err);
        } finally {
          _iterator3.f();
        }
        var _iterator4 = configurationModels_createForOfIteratorHelper(other.keys),
          _step4;
        try {
          for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
            var key = _step4.value;
            if (keys.indexOf(key) === -1) {
              keys.push(key);
            }
          }
        } catch (err) {
          _iterator4.e(err);
        } finally {
          _iterator4.f();
        }
      }
      return new ConfigurationModel(contents, keys, overrides);
    }
  }, {
    key: "freeze",
    value: function freeze() {
      this.isFrozen = true;
      return this;
    }
  }, {
    key: "mergeContents",
    value: function mergeContents(source, target) {
      for (var _i2 = 0, _Object$keys = Object.keys(target); _i2 < _Object$keys.length; _i2++) {
        var key = _Object$keys[_i2];
        if (key in source) {
          if (valueTypes.isObject(source[key]) && valueTypes.isObject(target[key])) {
            this.mergeContents(source[key], target[key]);
            continue;
          }
        }
        source[key] = objects.deepClone(target[key]);
      }
    }
  }, {
    key: "checkAndFreeze",
    value: function checkAndFreeze(data) {
      if (this.isFrozen && !Object.isFrozen(data)) {
        return objects.deepFreeze(data);
      }
      return data;
    }
  }, {
    key: "getContentsForOverrideIdentifer",
    value: function getContentsForOverrideIdentifer(identifier) {
      var _iterator5 = configurationModels_createForOfIteratorHelper(this.overrides),
        _step5;
      try {
        for (_iterator5.s(); !(_step5 = _iterator5.n()).done;) {
          var override = _step5.value;
          if (override.identifiers.indexOf(identifier) !== -1) {
            return override.contents;
          }
        }
      } catch (err) {
        _iterator5.e(err);
      } finally {
        _iterator5.f();
      }
      return null;
    }
  }, {
    key: "toJSON",
    value: function toJSON() {
      return {
        contents: this.contents,
        overrides: this.overrides,
        keys: this.keys
      };
    }

    // Update methods
  }, {
    key: "setValue",
    value: function setValue(key, value) {
      this.addKey(key);
      addToValueTree(this.contents, key, value, function (e) {
        throw new Error(e);
      });
    }
  }, {
    key: "removeValue",
    value: function removeValue(key) {
      if (this.removeKey(key)) {
        removeFromValueTree(this.contents, key);
      }
    }
  }, {
    key: "addKey",
    value: function addKey(key) {
      var index = this.keys.length;
      for (var i = 0; i < index; i++) {
        if (key.indexOf(this.keys[i]) === 0) {
          index = i;
        }
      }
      this.keys.splice(index, 1, key);
    }
  }, {
    key: "removeKey",
    value: function removeKey(key) {
      var index = this.keys.indexOf(key);
      if (index !== -1) {
        this.keys.splice(index, 1);
        return true;
      }
      return false;
    }
  }]);
  return ConfigurationModel;
}();
var DefaultConfigurationModel = /*#__PURE__*/function (_ConfigurationModel2) {
  configurationModels_inherits(DefaultConfigurationModel, _ConfigurationModel2);
  var _super = configurationModels_createSuper(DefaultConfigurationModel);
  function DefaultConfigurationModel() {
    configurationModels_classCallCheck(this, DefaultConfigurationModel);
    var contents = getDefaultValues();
    var keys = getConfigurationKeys();
    var overrides = [];
    for (var _i3 = 0, _Object$keys2 = Object.keys(contents); _i3 < _Object$keys2.length; _i3++) {
      var key = _Object$keys2[_i3];
      if (OVERRIDE_PROPERTY_PATTERN.test(key)) {
        overrides.push({
          identifiers: [overrideIdentifierFromKey(key).trim()],
          keys: Object.keys(contents[key]),
          contents: toValuesTree(contents[key], function (message) {
            return console.error("Conflict in default settings file: ".concat(message));
          })
        });
      }
    }
    return _super.call(this, contents, keys, overrides);
  }
  return configurationModels_createClass(DefaultConfigurationModel);
}(ConfigurationModel);
var ConfigurationModelParser = /*#__PURE__*/function () {
  function ConfigurationModelParser(_name, _scopes) {
    configurationModels_classCallCheck(this, ConfigurationModelParser);
    this._raw = null;
    this._configurationModel = null;
    this._parseErrors = [];
    this._name = _name;
    this._scopes = _scopes;
  }
  configurationModels_createClass(ConfigurationModelParser, [{
    key: "configurationModel",
    get: function get() {
      return this._configurationModel || new ConfigurationModel();
    }
  }, {
    key: "errors",
    get: function get() {
      return this._parseErrors;
    }
  }, {
    key: "parseContent",
    value: function parseContent(content) {
      if (!valueTypes.isUndefinedOrNull(content)) {
        var raw = this.doParseContent(content);
        this.parseRaw(raw);
      }
    }
  }, {
    key: "parseRaw",
    value: function parseRaw(raw) {
      this._raw = raw;
      var configurationModel = this.doParseRaw(raw);
      this._configurationModel = new ConfigurationModel(configurationModel.contents, configurationModel.keys, configurationModel.overrides);
    }
  }, {
    key: "parse",
    value: function parse() {
      if (this._raw) {
        this.parseRaw(this._raw);
      }
    }
  }, {
    key: "doParseContent",
    value: function doParseContent(content) {
      var raw = {};
      var currentProperty = null;
      var currentParent = [];
      var previousParents = [];
      var parseErrors = [];
      function onValue(value) {
        if (Array.isArray(currentParent)) {
          currentParent.push(value);
        } else if (currentProperty) {
          currentParent[currentProperty] = value;
        }
      }
      var visitor = {
        onObjectBegin: function onObjectBegin() {
          var object = {};
          onValue(object);
          previousParents.push(currentParent);
          currentParent = object;
          currentProperty = null;
        },
        onObjectProperty: function onObjectProperty(name) {
          currentProperty = name;
        },
        onObjectEnd: function onObjectEnd() {
          currentParent = previousParents.pop();
        },
        onArrayBegin: function onArrayBegin() {
          var array = [];
          onValue(array);
          previousParents.push(currentParent);
          currentParent = array;
          currentProperty = null;
        },
        onArrayEnd: function onArrayEnd() {
          currentParent = previousParents.pop();
        },
        onLiteralValue: onValue,
        onError: function onError(error, offset, length) {
          parseErrors.push({
            error: error,
            offset: offset,
            length: length
          });
        }
      };
      if (content) {
        try {
          visit(content, visitor);
          raw = currentParent[0] || {};
        } catch (e) {
          console.error("Error while parsing settings file ".concat(this._name, ": ").concat(e));
          this._parseErrors = [e];
        }
      }
      return raw;
    }
  }, {
    key: "doParseRaw",
    value: function doParseRaw(raw) {
      var _this2 = this;
      if (this._scopes) {
        var configurationProperties = Registry.as(configurationRegistry_Extensions.Configuration).getConfigurationProperties();
        raw = this.filterByScope(raw, configurationProperties, true, this._scopes);
      }
      var contents = toValuesTree(raw, function (message) {
        return console.error("Conflict in settings file ".concat(_this2._name, ": ").concat(message));
      });
      var keys = Object.keys(raw);
      var overrides = toOverrides(raw, function (message) {
        return console.error("Conflict in settings file ".concat(_this2._name, ": ").concat(message));
      });
      return {
        contents: contents,
        keys: keys,
        overrides: overrides
      };
    }
  }, {
    key: "filterByScope",
    value: function filterByScope(properties, configurationProperties, filterOverriddenProperties, scopes) {
      var result = {};
      for (var key in properties) {
        if (OVERRIDE_PROPERTY_PATTERN.test(key) && filterOverriddenProperties) {
          result[key] = this.filterByScope(properties[key], configurationProperties, false, scopes);
        } else {
          var scope = this.getScope(key, configurationProperties);
          // Load unregistered configurations always.
          if (scope === undefined || scopes.indexOf(scope) !== -1) {
            result[key] = properties[key];
          }
        }
      }
      return result;
    }
  }, {
    key: "getScope",
    value: function getScope(key, configurationProperties) {
      var propertySchema = configurationProperties[key];
      return propertySchema ? typeof propertySchema.scope !== 'undefined' ? propertySchema.scope : ConfigurationScope.WINDOW : undefined;
    }
  }]);
  return ConfigurationModelParser;
}();
var UserSettings = /*#__PURE__*/function (_VSDisposable) {
  configurationModels_inherits(UserSettings, _VSDisposable);
  var _super2 = configurationModels_createSuper(UserSettings);
  function UserSettings(scopes) {
    var _this3;
    configurationModels_classCallCheck(this, UserSettings);
    _this3 = _super2.call(this);
    _this3._onDidChange = _this3._register(new es_event/* Emitter */.Q5());
    _this3.onDidChange = _this3._onDidChange.event;
    _this3.scopes = scopes;
    _this3.parser = new ConfigurationModelParser('UserSettings', _this3.scopes);
    return _this3;
  }
  configurationModels_createClass(UserSettings, [{
    key: "loadConfiguration",
    value: function () {
      var _loadConfiguration = configurationModels_asyncToGenerator( /*#__PURE__*/configurationModels_regeneratorRuntime().mark(function _callee() {
        return configurationModels_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.prev = 0;
              this.parser.parseContent('{}');
              return _context.abrupt("return", this.parser.configurationModel);
            case 5:
              _context.prev = 5;
              _context.t0 = _context["catch"](0);
              return _context.abrupt("return", new ConfigurationModel());
            case 8:
            case "end":
              return _context.stop();
          }
        }, _callee, this, [[0, 5]]);
      }));
      function loadConfiguration() {
        return _loadConfiguration.apply(this, arguments);
      }
      return loadConfiguration;
    }()
  }, {
    key: "reprocess",
    value: function reprocess() {
      this.parser.parse();
      return this.parser.configurationModel;
    }
  }]);
  return UserSettings;
}(VSDisposable);
var Configuration = /*#__PURE__*/function () {
  function Configuration(_defaultConfiguration, _localUserConfiguration) {
    var _remoteUserConfiguration = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : new ConfigurationModel();
    var _workspaceConfiguration = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : new ConfigurationModel();
    var _memoryConfiguration = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : new ConfigurationModel();
    var _memoryConfigurationByResource = arguments.length > 5 && arguments[5] !== undefined ? arguments[5] : new ResourceMap();
    var _freeze = arguments.length > 6 && arguments[6] !== undefined ? arguments[6] : true;
    configurationModels_classCallCheck(this, Configuration);
    this._workspaceConsolidatedConfiguration = null;
    this._foldersConsolidatedConfigurations = new ResourceMap();
    this._remoteUserConfiguration = new ConfigurationModel();
    this._workspaceConfiguration = new ConfigurationModel();
    this._memoryConfiguration = new ConfigurationModel();
    this._memoryConfigurationByResource = new ResourceMap();
    this._freeze = true;
    this._userConfiguration = null;
    this._memoryConfigurationByResource;
    this._defaultConfiguration = _defaultConfiguration;
    this._localUserConfiguration = _localUserConfiguration;
    this._remoteUserConfiguration = _remoteUserConfiguration;
    this._workspaceConfiguration = _workspaceConfiguration;
    this._memoryConfiguration = _memoryConfiguration;
    this._memoryConfigurationByResource = _memoryConfigurationByResource;
    this._freeze = _freeze;
  }
  configurationModels_createClass(Configuration, [{
    key: "getValue",
    value: function getValue(section, overrides, workspace) {
      var consolidateConfigurationModel = this.getConsolidateConfigurationModel(overrides, workspace);
      return consolidateConfigurationModel.getValue(section);
    }
  }, {
    key: "updateValue",
    value: function updateValue(_key, _value) {
      var _overrides = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    } //
  }, {
    key: "inspect",
    value: function inspect(key, overrides, _workspace) {
      var defaultValue = overrides.overrideIdentifier ? this._defaultConfiguration.freeze().override(overrides.overrideIdentifier).getValue(key) : this._defaultConfiguration.freeze().getValue(key);
      return {
        defaultValue: defaultValue,
        default: defaultValue !== undefined ? {
          value: this._defaultConfiguration.freeze().getValue(key),
          override: overrides.overrideIdentifier ? this._defaultConfiguration.freeze().getOverrideValue(key, overrides.overrideIdentifier) : undefined
        } : undefined
      };
    }
  }, {
    key: "keys",
    value: function keys(_workspace) {
      return {
        default: this._defaultConfiguration.freeze().keys,
        user: this._defaultConfiguration.freeze().keys,
        workspace: this._defaultConfiguration.freeze().keys,
        workspaceFolder: this._defaultConfiguration.freeze().keys
      };
    }
  }, {
    key: "updateDefaultConfiguration",
    value: function updateDefaultConfiguration(defaultConfiguration) {
      this._defaultConfiguration = defaultConfiguration;
      this._workspaceConsolidatedConfiguration = null;
      this._foldersConsolidatedConfigurations.clear();
    }
  }, {
    key: "updateLocalUserConfiguration",
    value: function updateLocalUserConfiguration(localUserConfiguration) {
      this._localUserConfiguration = localUserConfiguration;
      this._userConfiguration = null;
      this._workspaceConsolidatedConfiguration = null;
      this._foldersConsolidatedConfigurations.clear();
    }
  }, {
    key: "updateRemoteUserConfiguration",
    value: function updateRemoteUserConfiguration(remoteUserConfiguration) {
      this._remoteUserConfiguration = remoteUserConfiguration;
      this._userConfiguration = null;
      this._workspaceConsolidatedConfiguration = null;
      this._foldersConsolidatedConfigurations.clear();
    }
  }, {
    key: "updateWorkspaceConfiguration",
    value: function updateWorkspaceConfiguration(workspaceConfiguration) {
      this._workspaceConfiguration = workspaceConfiguration;
      this._workspaceConsolidatedConfiguration = null;
      this._foldersConsolidatedConfigurations.clear();
    }
  }, {
    key: "compareAndUpdateDefaultConfiguration",
    value: function compareAndUpdateDefaultConfiguration(defaults, keys) {
      var _this4 = this;
      var overrides = keys.filter(function (key) {
        return OVERRIDE_PROPERTY_PATTERN.test(key);
      }).map(function (key) {
        var overrideIdentifier = overrideIdentifierFromKey(key);
        var fromKeys = _this4._defaultConfiguration.getKeysForOverrideIdentifier(overrideIdentifier);
        var toKeys = defaults.getKeysForOverrideIdentifier(overrideIdentifier);
        var keys = [].concat(configurationModels_toConsumableArray(toKeys.filter(function (key) {
          return fromKeys.indexOf(key) === -1;
        })), configurationModels_toConsumableArray(fromKeys.filter(function (key) {
          return toKeys.indexOf(key) === -1;
        })), configurationModels_toConsumableArray(fromKeys.filter(function (key) {
          return !objects.objectEquals(_this4._defaultConfiguration.override(overrideIdentifier).getValue(key), defaults.override(overrideIdentifier).getValue(key));
        })));
        return [overrideIdentifier, keys];
      });
      this.updateDefaultConfiguration(defaults);
      return {
        keys: keys,
        overrides: overrides
      };
    }
  }, {
    key: "compareAndUpdateLocalUserConfiguration",
    value: function compareAndUpdateLocalUserConfiguration(user) {
      var _compare = configuration_compare(this.localUserConfiguration, user),
        added = _compare.added,
        updated = _compare.updated,
        removed = _compare.removed,
        overrides = _compare.overrides;
      var keys = [].concat(configurationModels_toConsumableArray(added), configurationModels_toConsumableArray(updated), configurationModels_toConsumableArray(removed));
      if (keys.length) {
        this.updateLocalUserConfiguration(user);
      }
      return {
        keys: keys,
        overrides: overrides
      };
    }
  }, {
    key: "compareAndUpdateRemoteUserConfiguration",
    value: function compareAndUpdateRemoteUserConfiguration(user) {
      var _compare2 = configuration_compare(this.remoteUserConfiguration, user),
        added = _compare2.added,
        updated = _compare2.updated,
        removed = _compare2.removed,
        overrides = _compare2.overrides;
      var keys = [].concat(configurationModels_toConsumableArray(added), configurationModels_toConsumableArray(updated), configurationModels_toConsumableArray(removed));
      if (keys.length) {
        this.updateRemoteUserConfiguration(user);
      }
      return {
        keys: keys,
        overrides: overrides
      };
    }
  }, {
    key: "compareAndUpdateWorkspaceConfiguration",
    value: function compareAndUpdateWorkspaceConfiguration(workspaceConfiguration) {
      var _compare3 = configuration_compare(this.workspaceConfiguration, workspaceConfiguration),
        added = _compare3.added,
        updated = _compare3.updated,
        removed = _compare3.removed,
        overrides = _compare3.overrides;
      var keys = [].concat(configurationModels_toConsumableArray(added), configurationModels_toConsumableArray(updated), configurationModels_toConsumableArray(removed));
      if (keys.length) {
        this.updateWorkspaceConfiguration(workspaceConfiguration);
      }
      return {
        keys: keys,
        overrides: overrides
      };
    }
  }, {
    key: "compareAndUpdateFolderConfiguration",
    value: function compareAndUpdateFolderConfiguration(_resource, _folderConfiguration) {
      return {
        keys: [],
        overrides: []
      };
    }
  }, {
    key: "compareAndDeleteFolderConfiguration",
    value: function compareAndDeleteFolderConfiguration(_folder) {
      return {
        keys: [],
        overrides: []
      };
    }
  }, {
    key: "defaults",
    get: function get() {
      return this._defaultConfiguration;
    }
  }, {
    key: "userConfiguration",
    get: function get() {
      if (!this._userConfiguration) {
        this._userConfiguration = this._remoteUserConfiguration.isEmpty() ? this._localUserConfiguration : this._localUserConfiguration.merge(this._remoteUserConfiguration);
        if (this._freeze) {
          this._userConfiguration.freeze();
        }
      }
      return this._userConfiguration;
    }
  }, {
    key: "localUserConfiguration",
    get: function get() {
      return this._localUserConfiguration;
    }
  }, {
    key: "remoteUserConfiguration",
    get: function get() {
      return this._remoteUserConfiguration;
    }
  }, {
    key: "workspaceConfiguration",
    get: function get() {
      return this._workspaceConfiguration;
    }
  }, {
    key: "getConsolidateConfigurationModel",
    value: function getConsolidateConfigurationModel(overrides, workspace) {
      var configurationModel = this.getConsolidatedConfigurationModelForResource(overrides, workspace);
      return overrides.overrideIdentifier ? configurationModel.override(overrides.overrideIdentifier) : configurationModel;
    }
  }, {
    key: "getConsolidatedConfigurationModelForResource",
    value: function getConsolidatedConfigurationModelForResource(_ref, _workspace) {
      var _resource = _ref.resource;
      var consolidateConfiguration = this.getWorkspaceConsolidatedConfiguration();
      return consolidateConfiguration;
    }
  }, {
    key: "getWorkspaceConsolidatedConfiguration",
    value: function getWorkspaceConsolidatedConfiguration() {
      if (!this._workspaceConsolidatedConfiguration) {
        this._workspaceConsolidatedConfiguration = this._defaultConfiguration.merge(this.userConfiguration, this._workspaceConfiguration, this._memoryConfiguration);
        if (this._freeze) {
          this._workspaceConfiguration = this._workspaceConfiguration.freeze();
        }
      }
      return this._workspaceConsolidatedConfiguration;
    }
  }, {
    key: "toData",
    value: function toData() {
      return {
        defaults: {
          contents: this._defaultConfiguration.contents,
          overrides: this._defaultConfiguration.overrides,
          keys: this._defaultConfiguration.keys
        },
        user: {
          contents: this.userConfiguration.contents,
          overrides: this.userConfiguration.overrides,
          keys: this.userConfiguration.keys
        },
        workspace: {
          contents: this._workspaceConfiguration.contents,
          overrides: this._workspaceConfiguration.overrides,
          keys: this._workspaceConfiguration.keys
        }
      };
    }
  }, {
    key: "allKeys",
    value: function allKeys() {
      var keys = new Set();
      this._defaultConfiguration.freeze().keys.forEach(function (key) {
        return keys.add(key);
      });
      this.userConfiguration.freeze().keys.forEach(function (key) {
        return keys.add(key);
      });
      this._workspaceConfiguration.freeze().keys.forEach(function (key) {
        return keys.add(key);
      });
      return configurationModels_toConsumableArray(keys.values());
    }
  }, {
    key: "getAllKeysForOverrideIdentifier",
    value: function getAllKeysForOverrideIdentifier(overrideIdentifier) {
      var keys = new Set();
      this._defaultConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) {
        return keys.add(key);
      });
      this.userConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) {
        return keys.add(key);
      });
      this._workspaceConfiguration.getKeysForOverrideIdentifier(overrideIdentifier).forEach(function (key) {
        return keys.add(key);
      });
      return configurationModels_toConsumableArray(keys.values());
    }
  }], [{
    key: "parse",
    value: function parse(data) {
      var defaultConfiguration = this.parseConfigurationModel(data.defaults);
      var userConfiguration = this.parseConfigurationModel(data.user);
      var workspaceConfiguration = this.parseConfigurationModel(data.workspace);
      return new Configuration(defaultConfiguration, userConfiguration, new ConfigurationModel(), workspaceConfiguration, new ConfigurationModel(), new ResourceMap(), false);
    }
  }, {
    key: "parseConfigurationModel",
    value: function parseConfigurationModel(model) {
      return new ConfigurationModel(model.contents, model.keys, model.overrides).freeze();
    }
  }]);
  return Configuration;
}();
function mergeChanges() {
  for (var _len2 = arguments.length, changes = new Array(_len2), _key3 = 0; _key3 < _len2; _key3++) {
    changes[_key3] = arguments[_key3];
  }
  if (changes.length === 0) {
    return {
      keys: [],
      overrides: []
    };
  }
  if (changes.length === 1) {
    return changes[0];
  }
  var keysSet = new Set();
  var overridesMap = new Map();
  for (var _i4 = 0, _changes = changes; _i4 < _changes.length; _i4++) {
    var change = _changes[_i4];
    change.keys.forEach(function (key) {
      return keysSet.add(key);
    });
    change.overrides.forEach(function (_ref2) {
      var _ref3 = configurationModels_slicedToArray(_ref2, 2),
        identifier = _ref3[0],
        keys = _ref3[1];
      var result = getOrSet(overridesMap, identifier, new Set());
      keys.forEach(function (key) {
        return result.add(key);
      });
    });
  }
  var overrides = [];
  overridesMap.forEach(function (keys, identifier) {
    return overrides.push([identifier, configurationModels_toConsumableArray(keys.values())]);
  });
  return {
    keys: configurationModels_toConsumableArray(keysSet.values()),
    overrides: overrides
  };
}
var ConfigurationChangeEvent = /*#__PURE__*/function () {
  function ConfigurationChangeEvent(change, previous, currentConfiguraiton, currentWorkspace) {
    configurationModels_classCallCheck(this, ConfigurationChangeEvent);
    this._previousConfiguration = undefined;
    this.change = change;
    this.previous = previous;
    this.currentConfiguraiton = currentConfiguraiton;
    this.currentWorkspace = currentWorkspace;
    var keysSet = new Set();
    change.keys.forEach(function (key) {
      return keysSet.add(key);
    });
    change.overrides.forEach(function (_ref4) {
      var _ref5 = configurationModels_slicedToArray(_ref4, 2),
        keys = _ref5[1];
      return keys.forEach(function (key) {
        return keysSet.add(key);
      });
    });
    this.affectedKeys = configurationModels_toConsumableArray(keysSet.values());
    var configurationModel = new ConfigurationModel();
    this.affectedKeys.forEach(function (key) {
      return configurationModel.setValue(key, {});
    });
    this.affectedKeysTree = configurationModel.contents;
  }
  configurationModels_createClass(ConfigurationChangeEvent, [{
    key: "previousConfiguration",
    get: function get() {
      if (!this._previousConfiguration && this.previous) {
        this._previousConfiguration = Configuration.parse(this.previous.data);
      }
      return this._previousConfiguration;
    }
  }, {
    key: "affectsConfiguration",
    value: function affectsConfiguration(section, overrides) {
      if (this.doesAffectedKeysTreeContains(this.affectedKeysTree, section)) {
        if (overrides) {
          var _this$previous;
          var value1 = this.previousConfiguration ? this.previousConfiguration.getValue(section, overrides, (_this$previous = this.previous) === null || _this$previous === void 0 ? void 0 : _this$previous.workspace) : undefined;
          var value2 = this.currentConfiguraiton.getValue(section, overrides, this.currentWorkspace);
          return !objects.objectEquals(value1, value2);
        }
        return true;
      }
      return false;
    }
  }, {
    key: "doesAffectedKeysTreeContains",
    value: function doesAffectedKeysTreeContains(affectedKeysTree, section) {
      var requestedTree = toValuesTree(configurationModels_defineProperty({}, section, true), function () {
        //
      });
      var key;
      while (configurationModels_typeof(requestedTree) === 'object' && (key = Object.keys(requestedTree)[0])) {
        // Only one key should present, since we added only one property
        affectedKeysTree = affectedKeysTree[key];
        if (!affectedKeysTree) {
          return false; // Requested tree is not found
        }
        requestedTree = requestedTree[key];
      }
      return true;
    }
  }]);
  return ConfigurationChangeEvent;
}();
var AllKeysConfigurationChangeEvent = /*#__PURE__*/(/* unused pure expression or super */ null && (function (_ConfigurationChangeE) {
  configurationModels_inherits(AllKeysConfigurationChangeEvent, _ConfigurationChangeE);
  var _super3 = configurationModels_createSuper(AllKeysConfigurationChangeEvent);
  function AllKeysConfigurationChangeEvent(configuration, workspace, source, sourceConfig) {
    var _this5;
    configurationModels_classCallCheck(this, AllKeysConfigurationChangeEvent);
    _this5 = _super3.call(this, {
      keys: configuration.allKeys(),
      overrides: []
    }, undefined, configuration, workspace);
    _this5.source = source;
    _this5.sourceConfig = sourceConfig;
    return _this5;
  }
  return configurationModels_createClass(AllKeysConfigurationChangeEvent);
}(ConfigurationChangeEvent)));
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/vs/configuration/configurationService.js
function configurationService_typeof(o) { "@babel/helpers - typeof"; return configurationService_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, configurationService_typeof(o); }
var configurationService_dec, configurationService_class;
function configurationService_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ configurationService_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == configurationService_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(configurationService_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function configurationService_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function configurationService_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { configurationService_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { configurationService_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function configurationService_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function configurationService_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, configurationService_toPropertyKey(descriptor.key), descriptor); } }
function configurationService_createClass(Constructor, protoProps, staticProps) { if (protoProps) configurationService_defineProperties(Constructor.prototype, protoProps); if (staticProps) configurationService_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function configurationService_toPropertyKey(t) { var i = configurationService_toPrimitive(t, "string"); return "symbol" == configurationService_typeof(i) ? i : String(i); }
function configurationService_toPrimitive(t, r) { if ("object" != configurationService_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != configurationService_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function configurationService_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) configurationService_setPrototypeOf(subClass, superClass); }
function configurationService_setPrototypeOf(o, p) { configurationService_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return configurationService_setPrototypeOf(o, p); }
function configurationService_createSuper(Derived) { var hasNativeReflectConstruct = configurationService_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = configurationService_getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = configurationService_getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return configurationService_possibleConstructorReturn(this, result); }; }
function configurationService_possibleConstructorReturn(self, call) { if (call && (configurationService_typeof(call) === "object" || typeof call === "function")) { return call; } else if (call !== void 0) { throw new TypeError("Derived constructors may only return object or undefined"); } return configurationService_assertThisInitialized(self); }
function configurationService_assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }
function configurationService_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function configurationService_getPrototypeOf(o) { configurationService_getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return configurationService_getPrototypeOf(o); }
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/








var configurationService_ConfigurationService = (configurationService_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: IConfigurationService
}), configurationService_dec(configurationService_class = /*#__PURE__*/function (_VSDisposable) {
  configurationService_inherits(ConfigurationService, _VSDisposable);
  var _super = configurationService_createSuper(ConfigurationService);
  function ConfigurationService() {
    var _this;
    configurationService_classCallCheck(this, ConfigurationService);
    _this = _super.call(this);
    _this._onDidChangeConfiguration = _this._register(new es_event/* Emitter */.Q5());
    _this.onDidChangeConfiguration = _this._onDidChangeConfiguration.event;
    _this.userConfiguration = _this._register(new UserSettings(undefined));
    _this.configuration = new Configuration(new DefaultConfigurationModel(), new ConfigurationModel());
    _this._register(Registry.as(configurationRegistry_Extensions.Configuration).onDidUpdateConfiguration(function (configurationProperties) {
      return _this.onDidDefaultConfigurationChange(configurationProperties);
    }));
    return _this;
  }
  configurationService_createClass(ConfigurationService, [{
    key: "initialize",
    value: function () {
      var _initialize = configurationService_asyncToGenerator( /*#__PURE__*/configurationService_regeneratorRuntime().mark(function _callee() {
        var userConfiguration;
        return configurationService_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.userConfiguration.loadConfiguration();
            case 2:
              userConfiguration = _context.sent;
              this.configuration = new Configuration(new DefaultConfigurationModel(), userConfiguration);
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function initialize() {
        return _initialize.apply(this, arguments);
      }
      return initialize;
    }()
  }, {
    key: "getConfigurationData",
    value: function getConfigurationData() {
      return this.configuration.toData();
    }
  }, {
    key: "getValue",
    value: function getValue(arg1, arg2) {
      var section = typeof arg1 === 'string' ? arg1 : undefined;
      var overrides = isConfigurationOverrides(arg1) ? arg1 : isConfigurationOverrides(arg2) ? arg2 : {};
      return this.configuration.getValue(section, overrides, undefined);
    }
  }, {
    key: "updateValue",
    value: function updateValue(_key, _value, _arg3, _arg4) {
      return Promise.reject(new Error('not supported'));
    }
  }, {
    key: "inspect",
    value: function inspect(key) {
      return this.configuration.inspect(key, {}, undefined);
    }
  }, {
    key: "keys",
    value: function keys() {
      return this.configuration.keys(undefined);
    }
  }, {
    key: "reloadConfiguration",
    value: function () {
      var _reloadConfiguration = configurationService_asyncToGenerator( /*#__PURE__*/configurationService_regeneratorRuntime().mark(function _callee2() {
        var configurationModel;
        return configurationService_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return this.userConfiguration.loadConfiguration();
            case 2:
              configurationModel = _context2.sent;
              this.onDidChangeUserConfiguration(configurationModel);
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function reloadConfiguration() {
        return _reloadConfiguration.apply(this, arguments);
      }
      return reloadConfiguration;
    }()
  }, {
    key: "onDidChangeUserConfiguration",
    value: function onDidChangeUserConfiguration(userConfigurationModel) {
      var previous = this.configuration.toData();
      var change = this.configuration.compareAndUpdateLocalUserConfiguration(userConfigurationModel);
      this.trigger(change, previous, ConfigurationTarget.USER);
    }
  }, {
    key: "onDidDefaultConfigurationChange",
    value: function onDidDefaultConfigurationChange(keys) {
      var previous = this.configuration.toData();
      var change = this.configuration.compareAndUpdateDefaultConfiguration(new DefaultConfigurationModel(), keys);
      this.trigger(change, previous, ConfigurationTarget.DEFAULT);
    }
  }, {
    key: "trigger",
    value: function trigger(configurationChange, previous, source) {
      var event = new ConfigurationChangeEvent(configurationChange, {
        data: previous
      }, this.configuration);
      event.source = source;
      event.sourceConfig = this.getTargetConfiguration(source);
      this._onDidChangeConfiguration.fire(event);
    }
  }, {
    key: "getTargetConfiguration",
    value: function getTargetConfiguration(target) {
      // eslint-disable-next-line @typescript-eslint/switch-exhaustiveness-check
      switch (target) {
        case ConfigurationTarget.DEFAULT:
          return this.configuration.defaults.contents;
        case ConfigurationTarget.USER:
          return this.configuration.localUserConfiguration.contents;
      }
      return {};
    }
  }]);
  return ConfigurationService;
}(VSDisposable)) || configurationService_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/keybinding/module.js







var KeybindModule = mana_module/* ManaModule */.R.create().contribution(KeybindingContribution, KeybindingContext).register(VSContextKeyService, ContextKeyService, KeybindingRegistry,
// keyboard
BrowserKeyboardLayoutProvider, KeyboardLayoutService,
// configuration
configurationService_ConfigurationService);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/utils.js
var utils = __webpack_require__(77750);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/menu/menu-protocol.js
var menu_protocol = __webpack_require__(79039);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/menu/default-menu-node.js
function default_menu_node_typeof(o) { "@babel/helpers - typeof"; return default_menu_node_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, default_menu_node_typeof(o); }
var default_menu_node_dec, default_menu_node_dec2, default_menu_node_class, default_menu_node_class2, default_menu_node_descriptor, default_menu_node_dec3, _dec4, _dec5, _dec6, _dec7, default_menu_node_class3, _class4, _descriptor2, _descriptor3, _descriptor4, _descriptor5;
function default_menu_node_toConsumableArray(arr) { return default_menu_node_arrayWithoutHoles(arr) || default_menu_node_iterableToArray(arr) || default_menu_node_unsupportedIterableToArray(arr) || default_menu_node_nonIterableSpread(); }
function default_menu_node_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function default_menu_node_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return default_menu_node_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return default_menu_node_arrayLikeToArray(o, minLen); }
function default_menu_node_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function default_menu_node_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return default_menu_node_arrayLikeToArray(arr); }
function default_menu_node_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function default_menu_node_initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function default_menu_node_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function default_menu_node_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, default_menu_node_toPropertyKey(descriptor.key), descriptor); } }
function default_menu_node_createClass(Constructor, protoProps, staticProps) { if (protoProps) default_menu_node_defineProperties(Constructor.prototype, protoProps); if (staticProps) default_menu_node_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function default_menu_node_toPropertyKey(t) { var i = default_menu_node_toPrimitive(t, "string"); return "symbol" == default_menu_node_typeof(i) ? i : String(i); }
function default_menu_node_toPrimitive(t, r) { if ("object" != default_menu_node_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != default_menu_node_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function default_menu_node_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function default_menu_node_initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }
/* eslint-disable @typescript-eslint/no-unused-vars */







/**
 * Node representing a (sub)menu in the menu tree structure.
 */
var DefaultActionMenuItem = (default_menu_node_dec = (0,mana_syringe_es/* transient */.H3)(), default_menu_node_dec2 = (0,es/* prop */.vg)(), default_menu_node_dec(default_menu_node_class = (default_menu_node_class2 = /*#__PURE__*/function () {
  function DefaultActionMenuItem(commands, node, parentPath) {
    var _this = this;
    default_menu_node_classCallCheck(this, DefaultActionMenuItem);
    default_menu_node_initializerDefineProperty(this, "order", default_menu_node_descriptor, this);
    this.disposedEventEmitter = new es_event/* Emitter */.Q5();
    this.onDisposed = this.disposedEventEmitter.event;
    this.doCommandExecute = function () {
      if (_this.command) {
        var _this$commands;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        return (_this$commands = _this.commands).executeCommand.apply(_this$commands, [_this.command].concat(args));
      }
    };
    this.renderTitle = function () {
      var label = _this.label;
      if (!label && _this.command) {
        var _this$commands$getCom;
        label = (_this$commands$getCom = _this.commands.getCommand(_this.command)) === null || _this$commands$getCom === void 0 ? void 0 : _this$commands$getCom.label;
      }
      return (0,utils/* renderNode */.$u)(label);
    };
    this.renderIcon = function () {
      var icon = _this.icon;
      if (!icon && _this.command) {
        var _this$commands$getCom2;
        icon = (_this$commands$getCom2 = _this.commands.getCommand(_this.command)) === null || _this$commands$getCom2 === void 0 ? void 0 : _this$commands$getCom2.icon;
      }
      return (0,utils/* renderNode */.$u)(icon);
    };
    this.commands = commands;
    this.node = node;
    this.parentPath = parentPath;
    this.order = node.order;
    this.label = node.label;
    this.icon = node.icon;
    this.id = node.id;
    this.key = parentPath.join('/') + '/' + this.id;
    if (menu_protocol/* CommandMenuNode */.dP.is(node)) {
      this.command = node.command;
      this.execute = this.doCommandExecute;
    }
    if (menu_protocol/* ExecutableMenuNode */.vd.is(node)) {
      this.execute = node.execute;
      this.isEnabled = node.isEnabled;
      this.isVisible = node.isVisible;
      this.isActive = node.isActive;
    }
  }
  DefaultActionMenuItem = (0,mana_syringe_es/* inject */.f3)(menu_protocol/* MenuSymbol */.OH.ParentPathSymbol)(DefaultActionMenuItem, undefined, 2) || DefaultActionMenuItem;
  DefaultActionMenuItem = (0,mana_syringe_es/* inject */.f3)(menu_protocol/* MenuSymbol */.OH.ActionMenuNodeSymbol)(DefaultActionMenuItem, undefined, 1) || DefaultActionMenuItem;
  DefaultActionMenuItem = (0,mana_syringe_es/* inject */.f3)(command_registry/* CommandRegistry */.H)(DefaultActionMenuItem, undefined, 0) || DefaultActionMenuItem;
  default_menu_node_createClass(DefaultActionMenuItem, [{
    key: "dispose",
    value: function dispose() {
      this.disposedEventEmitter.fire();
      this.disposed = true;
    }
  }]);
  return DefaultActionMenuItem;
}(), (default_menu_node_descriptor = default_menu_node_applyDecoratedDescriptor(default_menu_node_class2.prototype, "order", [default_menu_node_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
})), default_menu_node_class2)) || default_menu_node_class);

/**
 * Node representing a (sub)menu in the menu tree structure.
 */
var DefaultGeneralMenuItem = (default_menu_node_dec3 = (0,mana_syringe_es/* transient */.H3)(), _dec4 = (0,es/* prop */.vg)(), _dec5 = (0,es/* prop */.vg)(), _dec6 = (0,es/* prop */.vg)(), _dec7 = (0,es/* prop */.vg)(), default_menu_node_dec3(default_menu_node_class3 = (_class4 = /*#__PURE__*/function () {
  function DefaultGeneralMenuItem(commands, node, parentPath) {
    var _this2 = this;
    default_menu_node_classCallCheck(this, DefaultGeneralMenuItem);
    default_menu_node_initializerDefineProperty(this, "children", _descriptor2, this);
    default_menu_node_initializerDefineProperty(this, "order", _descriptor3, this);
    /**
     * Optional label for the item.
     */
    default_menu_node_initializerDefineProperty(this, "label", _descriptor4, this);
    /**
     * Optional icon for the item.
     */
    default_menu_node_initializerDefineProperty(this, "icon", _descriptor5, this);
    this.disposedEventEmitter = new es_event/* Emitter */.Q5();
    this.onDisposed = this.disposedEventEmitter.event;
    /**
     * Inserts the given node at the position indicated by `sortString`.
     *
     * @returns a disposable which, when called, will remove the given node again.
     */
    this.addNode = function (item) {
      _this2.children.push(item);
      var remove = function remove() {
        var idx = _this2.children.indexOf((0,es/* getOrigin */.P$)(item));
        if (idx >= 0) {
          _this2.children.splice(idx, 1);
        }
      };
      item.onDisposed(remove);
      return item;
    };
    this.renderTitle = function () {
      return (0,utils/* renderNode */.$u)(_this2.label);
    };
    this.renderIcon = function () {
      return (0,utils/* renderNode */.$u)(_this2.icon);
    };
    this.commands = commands;
    this.node = node;
    this.parentPath = parentPath;
    this.order = node.order;
    this.label = node.label;
    this.icon = node.icon;
    this.id = node.id;
    this.key = parentPath.join('/') + '/' + this.id;
    this.path = [].concat(default_menu_node_toConsumableArray(parentPath), [this.id]);
  }
  DefaultGeneralMenuItem = (0,mana_syringe_es/* inject */.f3)(menu_protocol/* MenuSymbol */.OH.ParentPathSymbol)(DefaultGeneralMenuItem, undefined, 2) || DefaultGeneralMenuItem;
  DefaultGeneralMenuItem = (0,mana_syringe_es/* inject */.f3)(menu_protocol/* MenuSymbol */.OH.MenuNodeSymbol)(DefaultGeneralMenuItem, undefined, 1) || DefaultGeneralMenuItem;
  DefaultGeneralMenuItem = (0,mana_syringe_es/* inject */.f3)(command_registry/* CommandRegistry */.H)(DefaultGeneralMenuItem, undefined, 0) || DefaultGeneralMenuItem;
  default_menu_node_createClass(DefaultGeneralMenuItem, [{
    key: "isSubmenu",
    get: function get() {
      return !!this.label;
    }
  }, {
    key: "removeNode",
    value:
    /**
     * Removes the first node with the given id.
     *
     * @param id node id.
     */
    function removeNode(id) {
      var node = this.children.find(function (n) {
        return n.id === id;
      });
      if (node) {
        var idx = this.children.indexOf(node);
        if (idx >= 0) {
          this.children.splice(idx, 1);
        }
      }
    }
  }, {
    key: "dispose",
    value: function dispose() {
      this.disposedEventEmitter.fire();
      this.disposed = true;
    }
  }]);
  return DefaultGeneralMenuItem;
}(), (_descriptor2 = default_menu_node_applyDecoratedDescriptor(_class4.prototype, "children", [_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return [];
  }
}), _descriptor3 = default_menu_node_applyDecoratedDescriptor(_class4.prototype, "order", [_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), _descriptor4 = default_menu_node_applyDecoratedDescriptor(_class4.prototype, "label", [_dec6], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), _descriptor5 = default_menu_node_applyDecoratedDescriptor(_class4.prototype, "icon", [_dec7], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
})), _class4)) || default_menu_node_class3);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/menu/menu-registry.js
var menu_registry = __webpack_require__(17518);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/menu/index.js






var CoreMenuModule = mana_module/* ManaModule */.R.create().contribution(menu_registry/* MenuContribution */.P).register(menu_registry/* MenuRegistry */.B, DefaultGeneralMenuItem, DefaultActionMenuItem).register({
  token: menu_protocol/* GeneralMenuItemFactory */.yz,
  useDynamic: function useDynamic(ctx) {
    return function (item, parent) {
      var child = ctx.container.createChild();
      child.register({
        token: menu_protocol/* MenuSymbol */.OH.MenuNodeSymbol,
        useValue: item
      });
      child.register({
        token: menu_protocol/* MenuSymbol */.OH.ParentPathSymbol,
        useValue: parent
      });
      return child.get(DefaultGeneralMenuItem);
    };
  }
}).register({
  token: menu_protocol/* ActionMenuItemFactory */.z,
  useDynamic: function useDynamic(ctx) {
    return function (item, parent) {
      var child = ctx.container.createChild();
      child.register({
        token: menu_protocol/* MenuSymbol */.OH.ActionMenuNodeSymbol,
        useValue: item
      });
      child.register({
        token: menu_protocol/* MenuSymbol */.OH.ParentPathSymbol,
        useValue: parent
      });
      return child.get(DefaultActionMenuItem);
    };
  }
});
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/selection/selection-service.js
var selection_service = __webpack_require__(40000);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/selection/index.js


var SelectionModule = mana_module/* ManaModule */.R.create().register(selection_service/* SelectionService */.z);

;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/basic/variable-protocol.js

var VariableContribution = mana_syringe_es/* Syringe */.J3.defineToken('VariableContribution');
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/basic/default-variable-registry.js
function default_variable_registry_typeof(o) { "@babel/helpers - typeof"; return default_variable_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, default_variable_registry_typeof(o); }
var default_variable_registry_dec, default_variable_registry_class;
function default_variable_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function default_variable_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, default_variable_registry_toPropertyKey(descriptor.key), descriptor); } }
function default_variable_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) default_variable_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) default_variable_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function default_variable_registry_toPropertyKey(t) { var i = default_variable_registry_toPrimitive(t, "string"); return "symbol" == default_variable_registry_typeof(i) ? i : String(i); }
function default_variable_registry_toPrimitive(t, r) { if ("object" != default_variable_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != default_variable_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


var DefaultVariableRegistry = (default_variable_registry_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: VariableContribution
}), default_variable_registry_dec(default_variable_registry_class = /*#__PURE__*/function () {
  function DefaultVariableRegistry() {
    default_variable_registry_classCallCheck(this, DefaultVariableRegistry);
  }
  default_variable_registry_createClass(DefaultVariableRegistry, [{
    key: "registerVariables",
    value: function registerVariables(vars) {
      vars.register({
        id: 'border.width',
        defaults: {
          dark: '1px',
          light: '1px'
        },
        description: ''
      }, {
        id: 'panel.border.width',
        defaults: {
          dark: '2px',
          light: '2px'
        },
        description: ''
      }, {
        id: 'ui.font.scale.factor',
        defaults: {
          dark: '1.2',
          light: '1.2'
        },
        description: ''
      }, {
        id: 'ui.font.size0',
        defaults: {
          dark: 'calc(var(--mana-ui-font-size1) / var(--mana-ui-font-scale-factor))',
          light: 'calc(var(--mana-ui-font-size1) / var(--mana-ui-font-scale-factor))'
        },
        description: ''
      }, {
        id: 'ui.font.size1',
        defaults: {
          dark: '13px',
          light: '13px'
        },
        description: ''
      }, {
        id: 'ui.font.size2',
        defaults: {
          dark: 'calc(var(--mana-ui-font-size1) * var(--mana-ui-font-scale-factor))',
          light: 'calc(var(--mana-ui-font-size1) * var(--mana-ui-font-scale-factor))'
        },
        description: ''
      }, {
        id: 'ui.font.size3',
        defaults: {
          dark: 'calc(var(--mana-ui-font-size2) * var(--mana-ui-font-scale-factor))',
          light: 'calc(var(--mana-ui-font-size2) * var(--mana-ui-font-scale-factor))'
        },
        description: ''
      }, {
        id: 'ui.icon.font.size',
        defaults: {
          dark: '14px',
          light: '14px'
        },
        description: ''
      }, {
        id: 'ui-font-family',
        defaults: {
          dark: '"Helvetica Neue", helvetica, arial, sans-serif',
          light: '"Helvetica Neue", helvetica, arial, sans-serif'
        },
        description: ''
      }, {
        id: 'content.font.size',
        defaults: {
          dark: '13px',
          light: '13px'
        },
        description: ''
      }, {
        id: 'content.line.height',
        defaults: {
          dark: '22px',
          light: '22px'
        },
        description: ''
      }, {
        id: 'code.font.size',
        defaults: {
          dark: '13px',
          light: '13px'
        },
        description: ''
      }, {
        id: 'code.line.height',
        defaults: {
          dark: '17px',
          light: '17px'
        },
        description: ''
      }, {
        id: 'code.padding',
        defaults: {
          dark: '5px',
          light: '5px'
        },
        description: ''
      }, {
        id: 'code.font.family',
        defaults: {
          dark: 'menlo, monaco, consolas, "Droid Sans Mono", "Courier New", monospace, "Droid Sans Fallback"',
          light: 'menlo, monaco, consolas, "Droid Sans Mono", "Courier New", monospace, "Droid Sans Fallback"'
        },
        description: ''
      }, {
        id: 'monospace.font.family',
        defaults: {
          dark: 'monospace',
          light: 'monospace'
        },
        description: ''
      }, {
        id: 'ui.padding',
        defaults: {
          dark: '6px',
          light: '6px'
        },
        description: ''
      }, {
        id: 'icon.size',
        defaults: {
          dark: '16px',
          light: '16px'
        },
        description: ''
      }, {
        id: 'scrollbar.width',
        defaults: {
          dark: '10px',
          light: '10px'
        },
        description: ''
      }, {
        id: 'scrollbar.rail.width',
        defaults: {
          dark: '10px',
          light: '10px'
        },
        description: ''
      }, {
        id: 'statusBar.font.size',
        defaults: {
          dark: '12px',
          light: '12px'
        },
        description: ''
      }, {
        id: 'mod.disabled.opacity',
        defaults: {
          dark: '0.4',
          light: '0.4'
        },
        description: ''
      }, {
        id: 'sidebar.scrollbar.rail.width',
        defaults: {
          dark: '7px',
          light: '7px'
        },
        description: ''
      }, {
        id: 'sidebar.scrollbar.width',
        defaults: {
          dark: '5px',
          light: '5px'
        },
        description: ''
      }, {
        id: 'sidebar.icon.size',
        defaults: {
          dark: '28px',
          light: '28px'
        },
        description: ''
      });
    }
  }]);
  return DefaultVariableRegistry;
}()) || default_variable_registry_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/types.js
function types_typeof(o) { "@babel/helpers - typeof"; return types_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, types_typeof(o); }
function toArray(v) {
  if (Array.isArray(v)) {
    return v;
  }
  return [v];
}
function isPromise(obj) {
  return !!obj && (types_typeof(obj) === 'object' || typeof obj === 'function') && typeof obj.then === 'function';
}
function isPromiseLike(obj) {
  return isPromise(obj);
}
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/style/theme-base.less
// extracted by mini-css-extract-plugin

;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/theme-service.js
function theme_service_typeof(o) { "@babel/helpers - typeof"; return theme_service_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, theme_service_typeof(o); }
var _BuiltinThemeProvider, theme_service_dec, theme_service_class;
function theme_service_toConsumableArray(arr) { return theme_service_arrayWithoutHoles(arr) || theme_service_iterableToArray(arr) || theme_service_unsupportedIterableToArray(arr) || theme_service_nonIterableSpread(); }
function theme_service_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function theme_service_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return theme_service_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return theme_service_arrayLikeToArray(o, minLen); }
function theme_service_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function theme_service_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return theme_service_arrayLikeToArray(arr); }
function theme_service_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function theme_service_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function theme_service_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? theme_service_ownKeys(Object(t), !0).forEach(function (r) { theme_service_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : theme_service_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function theme_service_defineProperty(obj, key, value) { key = theme_service_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function theme_service_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, theme_service_toPropertyKey(descriptor.key), descriptor); } }
function theme_service_createClass(Constructor, protoProps, staticProps) { if (protoProps) theme_service_defineProperties(Constructor.prototype, protoProps); if (staticProps) theme_service_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function theme_service_toPropertyKey(t) { var i = theme_service_toPrimitive(t, "string"); return "symbol" == theme_service_typeof(i) ? i : String(i); }
function theme_service_toPrimitive(t, r) { if ("object" != theme_service_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != theme_service_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function theme_service_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }





var ThemeServiceSymbol = Symbol('ThemeService');
var BuiltinThemeProvider = /*#__PURE__*/theme_service_createClass(function BuiltinThemeProvider() {
  theme_service_classCallCheck(this, BuiltinThemeProvider);
});
_BuiltinThemeProvider = BuiltinThemeProvider;
BuiltinThemeProvider.darkTheme = {
  id: 'dark',
  type: 'dark',
  label: 'Dark (mana)'
};
BuiltinThemeProvider.lightTheme = {
  id: 'light',
  type: 'light',
  label: 'Light (mana)'
};
BuiltinThemeProvider.hcTheme = {
  id: 'hc-mana',
  type: 'hc',
  label: 'High Contrast (mana)'
};
BuiltinThemeProvider.themes = [_BuiltinThemeProvider.darkTheme, _BuiltinThemeProvider.lightTheme, _BuiltinThemeProvider.hcTheme];
var ThemeService = (theme_service_dec = (0,mana_syringe_es/* singleton */.ri)(), theme_service_dec(theme_service_class = /*#__PURE__*/function () {
  function ThemeService() {
    theme_service_classCallCheck(this, ThemeService);
    this.themes = {};
    this.storageService = localStorageService;
    this.themeChange = new es_event/* Emitter */.Q5();
    this.onDidColorThemeChange = this.themeChange.event;
  }
  theme_service_createClass(ThemeService, [{
    key: "startupTheme",
    value: function startupTheme() {
      this.activeTheme = this.getCurrentTheme();
    }
  }, {
    key: "register",
    value: function register() {
      var _this = this;
      for (var _len = arguments.length, themes = new Array(_len), _key = 0; _key < _len; _key++) {
        themes[_key] = arguments[_key];
      }
      for (var _i = 0, _themes = themes; _i < _themes.length; _i++) {
        var theme = _themes[_i];
        this.themes[theme.id] = theme;
      }
      this.validateActiveTheme();
      return disposable/* Disposable */.J.create(function () {
        for (var _i2 = 0, _themes2 = themes; _i2 < _themes2.length; _i2++) {
          var _theme = _themes2[_i2];
          delete _this.themes[_theme.id];
        }
      });
    }
  }, {
    key: "validateActiveTheme",
    value: function validateActiveTheme() {
      if (!this.activeTheme) {
        return;
      }
      var themeId = this.getCurrentTheme().id;
      if (themeId !== this.activeTheme.id) {
        this.setCurrentTheme(themeId);
      }
    }
  }, {
    key: "getThemes",
    value: function getThemes() {
      var result = [];
      for (var o in this.themes) {
        if (Object.prototype.hasOwnProperty.call(this.themes, o)) {
          result.push(this.themes[o]);
        }
      }
      return result;
    }
  }, {
    key: "getTheme",
    value: function getTheme(themeId) {
      return this.themes[themeId] || this.defaultTheme;
    }
  }, {
    key: "setCurrentTheme",
    value: function setCurrentTheme(themeId) {
      var tokens = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      var newTheme = this.getTheme(themeId);
      var oldTheme = this.activeTheme;
      if (oldTheme) {
        if (oldTheme.id === newTheme.id && !tokens) {
          return;
        }
      }
      this.activeTheme = objects.mixin(objects.deepClone(newTheme), {
        extraTokens: theme_service_objectSpread({}, tokens)
      });
      this.storageService.setData('theme', themeId);
      this.themeChange.fire({
        newTheme: newTheme,
        oldTheme: oldTheme
      });
    }
  }, {
    key: "getCurrentTheme",
    value: function getCurrentTheme() {
      var maybeThemeId = this.storageService.getData('theme');
      var themeId = this.defaultTheme.id;
      if (!isPromiseLike(maybeThemeId) && maybeThemeId) {
        themeId = maybeThemeId;
      }
      return this.getTheme(themeId);
    }
  }, {
    key: "getActiveTheme",
    value: function getActiveTheme() {
      return this.activeTheme || this.getCurrentTheme();
    }
  }, {
    key: "defaultTheme",
    get: function get() {
      return BuiltinThemeProvider.lightTheme;
    }
  }, {
    key: "reset",
    value: function reset() {
      this.setCurrentTheme(this.defaultTheme.id);
    }
  }], [{
    key: "get",
    value: function get() {
      var global = window; // eslint-disable-line @typescript-eslint/no-explicit-any
      if (!global[ThemeServiceSymbol]) {
        var themeService = new ThemeService();
        themeService.register.apply(themeService, theme_service_toConsumableArray(BuiltinThemeProvider.themes));
        themeService.startupTheme();
        global[ThemeServiceSymbol] = themeService;
      }
      return global[ThemeServiceSymbol];
    }
  }]);
  return ThemeService;
}()) || theme_service_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/basic/variable-registry.js
function variable_registry_typeof(o) { "@babel/helpers - typeof"; return variable_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, variable_registry_typeof(o); }
var variable_registry_dec, variable_registry_class;
function variable_registry_construct(Parent, args, Class) { if (variable_registry_isNativeReflectConstruct()) { variable_registry_construct = Reflect.construct.bind(); } else { variable_registry_construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) variable_registry_setPrototypeOf(instance, Class.prototype); return instance; }; } return variable_registry_construct.apply(null, arguments); }
function variable_registry_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function variable_registry_setPrototypeOf(o, p) { variable_registry_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return variable_registry_setPrototypeOf(o, p); }
function variable_registry_toConsumableArray(arr) { return variable_registry_arrayWithoutHoles(arr) || variable_registry_iterableToArray(arr) || variable_registry_unsupportedIterableToArray(arr) || variable_registry_nonIterableSpread(); }
function variable_registry_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function variable_registry_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function variable_registry_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return variable_registry_arrayLikeToArray(arr); }
function variable_registry_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ variable_registry_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == variable_registry_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(variable_registry_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function variable_registry_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = variable_registry_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function variable_registry_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return variable_registry_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return variable_registry_arrayLikeToArray(o, minLen); }
function variable_registry_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function variable_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function variable_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, variable_registry_toPropertyKey(descriptor.key), descriptor); } }
function variable_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) variable_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) variable_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function variable_registry_toPropertyKey(t) { var i = variable_registry_toPrimitive(t, "string"); return "symbol" == variable_registry_typeof(i) ? i : String(i); }
function variable_registry_toPrimitive(t, r) { if ("object" != variable_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != variable_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



/**
 * It should be implemented by an extension, e.g. by the monaco extension.
 */
var VariableRegistry = (variable_registry_dec = (0,mana_syringe_es/* singleton */.ri)(), variable_registry_dec(variable_registry_class = /*#__PURE__*/function () {
  function VariableRegistry(themeService) {
    variable_registry_classCallCheck(this, VariableRegistry);
    this.definitionList = [];
    this.onDidChangeEmitter = new es_event/* Emitter */.Q5();
    this.onDidChange = this.onDidChangeEmitter.event;
    this.themeService = themeService;
  }
  VariableRegistry = (0,mana_syringe_es/* inject */.f3)(ThemeService)(VariableRegistry, undefined, 0) || VariableRegistry;
  variable_registry_createClass(VariableRegistry, [{
    key: "fireDidChange",
    value: function fireDidChange() {
      this.onDidChangeEmitter.fire(undefined);
    }
  }, {
    key: "getVariables",
    value: /*#__PURE__*/variable_registry_regeneratorRuntime().mark(function getVariables() {
      var _iterator, _step, definition;
      return variable_registry_regeneratorRuntime().wrap(function getVariables$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            // eslint-disable-next-line no-restricted-syntax
            _iterator = variable_registry_createForOfIteratorHelper(this.definitionList);
            _context.prev = 1;
            _iterator.s();
          case 3:
            if ((_step = _iterator.n()).done) {
              _context.next = 9;
              break;
            }
            definition = _step.value;
            _context.next = 7;
            return definition.id;
          case 7:
            _context.next = 3;
            break;
          case 9:
            _context.next = 14;
            break;
          case 11:
            _context.prev = 11;
            _context.t0 = _context["catch"](1);
            _iterator.e(_context.t0);
          case 14:
            _context.prev = 14;
            _iterator.f();
            return _context.finish(14);
          case 17:
          case "end":
            return _context.stop();
        }
      }, getVariables, this, [[1, 11, 14, 17]]);
    })
  }, {
    key: "getCurrentCssVariable",
    value: function getCurrentCssVariable(id) {
      var value = this.getCurrentVariable(id);
      if (!value) {
        return undefined;
      }
      var name = this.toCssVariableName(id);
      return {
        name: name,
        value: value
      };
    }
  }, {
    key: "toCssVariableName",
    value: function toCssVariableName(id) {
      var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'mana';
      return "--".concat(prefix, "-").concat(id.replace(/\./g, '-'));
    }
  }, {
    key: "getCurrentVariable",
    value: function getCurrentVariable(id) {
      var theme = this.themeService.getActiveTheme();
      var type = theme.type,
        extraTokens = theme.extraTokens;
      if (extraTokens && extraTokens.basic && extraTokens.basic[id]) {
        return extraTokens.basic[id];
      }
      var definition = this.definitionList.find(function (definition) {
        return definition.id === id;
      });
      if (definition && definition.defaults && definition.defaults[type]) {
        return definition.defaults[type];
      }
      return undefined;
    }
  }, {
    key: "register",
    value: function register() {
      var _this = this;
      for (var _len = arguments.length, definitions = new Array(_len), _key = 0; _key < _len; _key++) {
        definitions[_key] = arguments[_key];
      }
      var result = variable_registry_construct(disposable_collection/* DisposableCollection */.K, variable_registry_toConsumableArray(definitions.map(function (definition) {
        return _this.doRegister(definition);
      })));
      this.fireDidChange();
      return result;
    }
  }, {
    key: "doRegister",
    value: function doRegister(definition) {
      this.definitionList.push({
        id: definition.id,
        defaults: definition.defaults,
        description: definition.description
      });
      return disposable/* Disposable */.J.NONE;
    }
  }]);
  return VariableRegistry;
}()) || variable_registry_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/basic/variable-application.js
function variable_application_typeof(o) { "@babel/helpers - typeof"; return variable_application_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, variable_application_typeof(o); }
var variable_application_dec, variable_application_class;
function variable_application_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = variable_application_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function variable_application_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return variable_application_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return variable_application_arrayLikeToArray(o, minLen); }
function variable_application_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function variable_application_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function variable_application_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, variable_application_toPropertyKey(descriptor.key), descriptor); } }
function variable_application_createClass(Constructor, protoProps, staticProps) { if (protoProps) variable_application_defineProperties(Constructor.prototype, protoProps); if (staticProps) variable_application_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function variable_application_toPropertyKey(t) { var i = variable_application_toPrimitive(t, "string"); return "symbol" == variable_application_typeof(i) ? i : String(i); }
function variable_application_toPrimitive(t, r) { if ("object" != variable_application_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != variable_application_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






var VariableApplication = (variable_application_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: application_application/* ApplicationContribution */.rS
}), variable_application_dec(variable_application_class = /*#__PURE__*/function () {
  // dispose action when update

  function VariableApplication(themeService, variables, variableContributions) {
    variable_application_classCallCheck(this, VariableApplication);
    this.toUpdate = new disposable_collection/* DisposableCollection */.K();
    this.themeService = themeService;
    this.variables = variables;
    this.variableContributions = variableContributions;
  }
  VariableApplication = (0,mana_syringe_es/* contrib */.el)(VariableContribution)(VariableApplication, undefined, 2) || VariableApplication;
  VariableApplication = (0,mana_syringe_es/* inject */.f3)(VariableRegistry)(VariableApplication, undefined, 1) || VariableApplication;
  VariableApplication = (0,mana_syringe_es/* inject */.f3)(ThemeService)(VariableApplication, undefined, 0) || VariableApplication;
  variable_application_createClass(VariableApplication, [{
    key: "onStart",
    value: function onStart(app) {
      var _this = this;
      this.app = app;
      var _iterator = variable_application_createForOfIteratorHelper(this.variableContributions.getContributions()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var contribution = _step.value;
          contribution.registerVariables(this.variables);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      this.update();
      this.themeService.onDidColorThemeChange(function () {
        return _this.update();
      });
      this.variables.onDidChange(function () {
        return _this.update();
      });
    }
  }, {
    key: "update",
    value: function update() {
      var _this2 = this;
      if (!document) {
        return;
      }
      this.toUpdate.dispose();
      var themeClass = "mana-".concat(this.themeService.getCurrentTheme().type);
      document.body.classList.add(themeClass);
      this.toUpdate.push(disposable/* Disposable */.J.create(function () {
        return document.body.classList.remove(themeClass);
      }));
      var _document = document,
        documentElement = _document.documentElement;
      if (documentElement) {
        var _iterator2 = variable_application_createForOfIteratorHelper(this.variables.getVariables()),
          _step2;
        try {
          var _loop = function _loop() {
            var id = _step2.value;
            var variable = _this2.variables.getCurrentCssVariable(id);
            if (variable) {
              var name = variable.name,
                value = variable.value;
              documentElement.style.setProperty(name, value);
              _this2.toUpdate.push(disposable/* Disposable */.J.create(function () {
                return documentElement.style.removeProperty(name);
              }));
            }
          };
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            _loop();
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    }
  }]);
  return VariableApplication;
}()) || variable_application_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/color/color-protocol.js

var ColorContribution = mana_syringe_es/* Syringe */.J3.defineToken('ColorContribution');
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/color/color.js
var _Color;
function color_typeof(o) { "@babel/helpers - typeof"; return color_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, color_typeof(o); }
function color_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function color_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, color_toPropertyKey(descriptor.key), descriptor); } }
function color_createClass(Constructor, protoProps, staticProps) { if (protoProps) color_defineProperties(Constructor.prototype, protoProps); if (staticProps) color_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function color_toPropertyKey(t) { var i = color_toPrimitive(t, "string"); return "symbol" == color_typeof(i) ? i : String(i); }
function color_toPrimitive(t, r) { if ("object" != color_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != color_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/* eslint-disable no-inner-declarations */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


function roundFloat(number, decimalPoints) {
  var decimal = Math.pow(10, decimalPoints);
  return Math.round(number * decimal) / decimal;
}
var RGBA = /*#__PURE__*/function () {
  /**
   * Red: integer in [0-255]
   */

  /**
   * Green: integer in [0-255]
   */

  /**
   * Blue: integer in [0-255]
   */

  /**
   * Alpha: float in [0-1]
   */

  function RGBA(r, g, b) {
    var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    color_classCallCheck(this, RGBA);
    this._rgbaBrand = undefined;
    this.r = Math.min(255, Math.max(0, r)) | 0;
    this.g = Math.min(255, Math.max(0, g)) | 0;
    this.b = Math.min(255, Math.max(0, b)) | 0;
    this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
  }
  color_createClass(RGBA, null, [{
    key: "equals",
    value: function equals(a, b) {
      return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
    }
  }]);
  return RGBA;
}();
var HSLA = /*#__PURE__*/function () {
  /**
   * Hue: integer in [0, 360]
   */

  /**
   * Saturation: float in [0, 1]
   */

  /**
   * Luminosity: float in [0, 1]
   */

  /**
   * Alpha: float in [0, 1]
   */

  function HSLA(h, s, l, a) {
    color_classCallCheck(this, HSLA);
    this._hslaBrand = undefined;
    this.h = Math.max(Math.min(360, h), 0) | 0;
    this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
    this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
    this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
  }
  color_createClass(HSLA, null, [{
    key: "equals",
    value: function equals(a, b) {
      return a.h === b.h && a.s === b.s && a.l === b.l && a.a === b.a;
    }

    /**
     * Converts an RGB color value to HSL. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes r, g, and b are contained in the set [0, 255] and
     * returns h in the set [0, 360], s, and l in the set [0, 1].
     */
  }, {
    key: "fromRGBA",
    value: function fromRGBA(rgba) {
      var r = rgba.r / 255;
      var g = rgba.g / 255;
      var b = rgba.b / 255;
      var a = rgba.a;
      var max = Math.max(r, g, b);
      var min = Math.min(r, g, b);
      var h = 0;
      var s = 0;
      var l = (min + max) / 2;
      var chroma = max - min;
      if (chroma > 0) {
        s = Math.min(l <= 0.5 ? chroma / (2 * l) : chroma / (2 - 2 * l), 1);
        switch (max) {
          case r:
            h = (g - b) / chroma + (g < b ? 6 : 0);
            break;
          case g:
            h = (b - r) / chroma + 2;
            break;
          case b:
            h = (r - g) / chroma + 4;
            break;
        }
        h *= 60;
        h = Math.round(h);
      }
      return new HSLA(h, s, l, a);
    }
  }, {
    key: "_hue2rgb",
    value: function _hue2rgb(p, q, t) {
      if (t < 0) {
        t += 1;
      }
      if (t > 1) {
        t -= 1;
      }
      if (t < 1 / 6) {
        return p + (q - p) * 6 * t;
      }
      if (t < 1 / 2) {
        return q;
      }
      if (t < 2 / 3) {
        return p + (q - p) * (2 / 3 - t) * 6;
      }
      return p;
    }

    /**
     * Converts an HSL color value to RGB. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes h in the set [0, 360] s, and l are contained in the set [0, 1] and
     * returns r, g, and b in the set [0, 255].
     */
  }, {
    key: "toRGBA",
    value: function toRGBA(hsla) {
      var h = hsla.h / 360;
      var s = hsla.s,
        l = hsla.l,
        a = hsla.a;
      var r;
      var g;
      var b;
      if (s === 0) {
        r = g = b = l; // achromatic
      } else {
        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        var p = 2 * l - q;
        r = HSLA._hue2rgb(p, q, h + 1 / 3);
        g = HSLA._hue2rgb(p, q, h);
        b = HSLA._hue2rgb(p, q, h - 1 / 3);
      }
      return new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a);
    }
  }]);
  return HSLA;
}();
var HSVA = /*#__PURE__*/function () {
  /**
   * Hue: integer in [0, 360]
   */

  /**
   * Saturation: float in [0, 1]
   */

  /**
   * Value: float in [0, 1]
   */

  /**
   * Alpha: float in [0, 1]
   */

  function HSVA(h, s, v, a) {
    color_classCallCheck(this, HSVA);
    this._hsvaBrand = undefined;
    this.h = Math.max(Math.min(360, h), 0) | 0;
    this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
    this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
    this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
  }
  color_createClass(HSVA, null, [{
    key: "equals",
    value: function equals(a, b) {
      return a.h === b.h && a.s === b.s && a.v === b.v && a.a === b.a;
    }

    // from http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
  }, {
    key: "fromRGBA",
    value: function fromRGBA(rgba) {
      var r = rgba.r / 255;
      var g = rgba.g / 255;
      var b = rgba.b / 255;
      var cmax = Math.max(r, g, b);
      var cmin = Math.min(r, g, b);
      var delta = cmax - cmin;
      var s = cmax === 0 ? 0 : delta / cmax;
      var m;
      if (delta === 0) {
        m = 0;
      } else if (cmax === r) {
        m = ((g - b) / delta % 6 + 6) % 6;
      } else if (cmax === g) {
        m = (b - r) / delta + 2;
      } else {
        m = (r - g) / delta + 4;
      }
      return new HSVA(Math.round(m * 60), s, cmax, rgba.a);
    }

    // from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
  }, {
    key: "toRGBA",
    value: function toRGBA(hsva) {
      var h = hsva.h,
        s = hsva.s,
        v = hsva.v,
        a = hsva.a;
      var c = v * s;
      var x = c * (1 - Math.abs(h / 60 % 2 - 1));
      var m = v - c;
      var r = 0,
        g = 0,
        b = 0;
      if (h < 60) {
        r = c;
        g = x;
      } else if (h < 120) {
        r = x;
        g = c;
      } else if (h < 180) {
        g = c;
        b = x;
      } else if (h < 240) {
        g = x;
        b = c;
      } else if (h < 300) {
        r = x;
        b = c;
      } else if (h <= 360) {
        r = c;
        b = x;
      }
      r = Math.round((r + m) * 255);
      g = Math.round((g + m) * 255);
      b = Math.round((b + m) * 255);
      return new RGBA(r, g, b, a);
    }
  }]);
  return HSVA;
}();
var Color = /*#__PURE__*/function () {
  function Color(arg) {
    color_classCallCheck(this, Color);
    if (!arg) {
      throw new Error('Color needs a value');
    } else if (arg instanceof RGBA) {
      this.rgba = arg;
    } else if (arg instanceof HSLA) {
      this._hsla = arg;
      this.rgba = HSLA.toRGBA(arg);
    } else if (arg instanceof HSVA) {
      this._hsva = arg;
      this.rgba = HSVA.toRGBA(arg);
    } else {
      throw new Error('Invalid color ctor argument');
    }
  }
  color_createClass(Color, [{
    key: "hsla",
    get: function get() {
      if (this._hsla) {
        return this._hsla;
      }
      return HSLA.fromRGBA(this.rgba);
    }
  }, {
    key: "hsva",
    get: function get() {
      if (this._hsva) {
        return this._hsva;
      }
      return HSVA.fromRGBA(this.rgba);
    }
  }, {
    key: "equals",
    value: function equals(other) {
      return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
    }

    /**
     * http://www.w3.org/TR/WCAG20/#relativeluminancedef
     * Returns the number in the set [0, 1]. O => Darkest Black. 1 => Lightest white.
     */
  }, {
    key: "getRelativeLuminance",
    value: function getRelativeLuminance() {
      var R = Color._relativeLuminanceForComponent(this.rgba.r);
      var G = Color._relativeLuminanceForComponent(this.rgba.g);
      var B = Color._relativeLuminanceForComponent(this.rgba.b);
      var luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
      return roundFloat(luminance, 4);
    }
  }, {
    key: "getContrastRatio",
    value:
    /**
     * http://www.w3.org/TR/WCAG20/#contrast-ratiodef
     * Returns the contrast ration number in the set [1, 21].
     */
    function getContrastRatio(another) {
      var lum1 = this.getRelativeLuminance();
      var lum2 = another.getRelativeLuminance();
      return lum1 > lum2 ? (lum1 + 0.05) / (lum2 + 0.05) : (lum2 + 0.05) / (lum1 + 0.05);
    }

    /**
     *	http://24ways.org/2010/calculating-color-contrast
     *  Return 'true' if darker color otherwise 'false'
     */
  }, {
    key: "isDarker",
    value: function isDarker() {
      var yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1000;
      return yiq < 128;
    }

    /**
     *	http://24ways.org/2010/calculating-color-contrast
     *  Return 'true' if lighter color otherwise 'false'
     */
  }, {
    key: "isLighter",
    value: function isLighter() {
      var yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1000;
      return yiq >= 128;
    }
  }, {
    key: "isLighterThan",
    value: function isLighterThan(another) {
      var lum1 = this.getRelativeLuminance();
      var lum2 = another.getRelativeLuminance();
      return lum1 > lum2;
    }
  }, {
    key: "isDarkerThan",
    value: function isDarkerThan(another) {
      var lum1 = this.getRelativeLuminance();
      var lum2 = another.getRelativeLuminance();
      return lum1 < lum2;
    }
  }, {
    key: "lighten",
    value: function lighten(factor) {
      return new Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a));
    }
  }, {
    key: "darken",
    value: function darken(factor) {
      return new Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a));
    }
  }, {
    key: "transparent",
    value: function transparent(factor) {
      var _this$rgba = this.rgba,
        r = _this$rgba.r,
        g = _this$rgba.g,
        b = _this$rgba.b,
        a = _this$rgba.a;
      return new Color(new RGBA(r, g, b, a * factor));
    }
  }, {
    key: "isTransparent",
    value: function isTransparent() {
      return this.rgba.a === 0;
    }
  }, {
    key: "isOpaque",
    value: function isOpaque() {
      return this.rgba.a === 1;
    }
  }, {
    key: "opposite",
    value: function opposite() {
      return new Color(new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a));
    }
  }, {
    key: "blend",
    value: function blend(c) {
      var rgba = c.rgba;

      // Convert to 0..1 opacity
      var thisA = this.rgba.a;
      var colorA = rgba.a;
      var a = thisA + colorA * (1 - thisA);
      if (a < 1e-6) {
        return Color.transparent;
      }
      var r = this.rgba.r * thisA / a + rgba.r * colorA * (1 - thisA) / a;
      var g = this.rgba.g * thisA / a + rgba.g * colorA * (1 - thisA) / a;
      var b = this.rgba.b * thisA / a + rgba.b * colorA * (1 - thisA) / a;
      return new Color(new RGBA(r, g, b, a));
    }
  }, {
    key: "makeOpaque",
    value: function makeOpaque(opaqueBackground) {
      if (this.isOpaque() || opaqueBackground.rgba.a !== 1) {
        // only allow to blend onto a non-opaque color onto a opaque color
        return this;
      }
      var _this$rgba2 = this.rgba,
        r = _this$rgba2.r,
        g = _this$rgba2.g,
        b = _this$rgba2.b,
        a = _this$rgba2.a;

      // https://stackoverflow.com/questions/12228548/finding-equivalent-color-with-opacity
      return new Color(new RGBA(opaqueBackground.rgba.r - a * (opaqueBackground.rgba.r - r), opaqueBackground.rgba.g - a * (opaqueBackground.rgba.g - g), opaqueBackground.rgba.b - a * (opaqueBackground.rgba.b - b), 1));
    }
  }, {
    key: "flatten",
    value: function flatten() {
      for (var _len = arguments.length, backgrounds = new Array(_len), _key = 0; _key < _len; _key++) {
        backgrounds[_key] = arguments[_key];
      }
      var background = backgrounds.reduceRight(function (accumulator, color) {
        return Color._flatten(color, accumulator);
      });
      return Color._flatten(this, background);
    }
  }, {
    key: "toString",
    value: function toString() {
      if (!this._toString) {
        this._toString = Color.Format.CSS.format(this);
      }
      return this._toString;
    }
  }], [{
    key: "fromHex",
    value: function fromHex(hex) {
      return Color.Format.CSS.parseHex(hex) || Color.red;
    }
  }, {
    key: "_relativeLuminanceForComponent",
    value: function _relativeLuminanceForComponent(color) {
      var c = color / 255;
      return c <= 0.03928 ? c / 12.92 : Math.pow((c + 0.055) / 1.055, 2.4);
    }
  }, {
    key: "_flatten",
    value: function _flatten(foreground, background) {
      var backgroundAlpha = 1 - foreground.rgba.a;
      return new Color(new RGBA(backgroundAlpha * background.rgba.r + foreground.rgba.a * foreground.rgba.r, backgroundAlpha * background.rgba.g + foreground.rgba.a * foreground.rgba.g, backgroundAlpha * background.rgba.b + foreground.rgba.a * foreground.rgba.b));
    }
  }, {
    key: "getLighterColor",
    value: function getLighterColor(of, relative, factor) {
      if (of.isLighterThan(relative)) {
        return of;
      }
      factor = factor || 0.5;
      var lum1 = of.getRelativeLuminance();
      var lum2 = relative.getRelativeLuminance();
      factor = factor * (lum2 - lum1) / lum2;
      return of.lighten(factor);
    }
  }, {
    key: "getDarkerColor",
    value: function getDarkerColor(of, relative, factor) {
      if (of.isDarkerThan(relative)) {
        return of;
      }
      factor = factor || 0.5;
      var lum1 = of.getRelativeLuminance();
      var lum2 = relative.getRelativeLuminance();
      factor = factor * (lum1 - lum2) / lum1;
      return of.darken(factor);
    }
  }]);
  return Color;
}();
_Color = Color;
Color.white = new _Color(new RGBA(255, 255, 255, 1));
Color.black = new _Color(new RGBA(0, 0, 0, 1));
Color.red = new _Color(new RGBA(255, 0, 0, 1));
Color.blue = new _Color(new RGBA(0, 0, 255, 1));
Color.green = new _Color(new RGBA(0, 255, 0, 1));
Color.cyan = new _Color(new RGBA(0, 255, 255, 1));
Color.lightgrey = new _Color(new RGBA(211, 211, 211, 1));
Color.transparent = new _Color(new RGBA(0, 0, 0, 0));
(function (_Color2) {
  var Format;
  (function (_Format) {
    var CSS;
    (function (_CSS) {
      function formatRGB(color) {
        if (color.rgba.a === 1) {
          return "rgb(".concat(color.rgba.r, ", ").concat(color.rgba.g, ", ").concat(color.rgba.b, ")");
        }
        return Color.Format.CSS.formatRGBA(color);
      }
      _CSS.formatRGB = formatRGB;
      function formatRGBA(color) {
        return "rgba(".concat(color.rgba.r, ", ").concat(color.rgba.g, ", ").concat(color.rgba.b, ", ").concat(+color.rgba.a.toFixed(2), ")");
      }
      _CSS.formatRGBA = formatRGBA;
      function formatHSL(color) {
        if (color.hsla.a === 1) {
          return "hsl(".concat(color.hsla.h, ", ").concat((color.hsla.s * 100).toFixed(2), "%, ").concat((color.hsla.l * 100).toFixed(2), "%)");
        }
        return Color.Format.CSS.formatHSLA(color);
      }
      _CSS.formatHSL = formatHSL;
      function formatHSLA(color) {
        return "hsla(".concat(color.hsla.h, ", ").concat((color.hsla.s * 100).toFixed(2), "%, ").concat((color.hsla.l * 100).toFixed(2), "%, ").concat(color.hsla.a.toFixed(2), ")");
      }
      _CSS.formatHSLA = formatHSLA;
      function _toTwoDigitHex(n) {
        var r = n.toString(16);
        return r.length !== 2 ? "0".concat(r) : r;
      }

      /**
       * Formats the color as #RRGGBB
       */
      function formatHex(color) {
        return "#".concat(_toTwoDigitHex(color.rgba.r)).concat(_toTwoDigitHex(color.rgba.g)).concat(_toTwoDigitHex(color.rgba.b));
      }
      _CSS.formatHex = formatHex;
      function formatHexA(color) {
        var compact = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;
        if (compact && color.rgba.a === 1) {
          return Color.Format.CSS.formatHex(color);
        }
        return "#".concat(_toTwoDigitHex(color.rgba.r)).concat(_toTwoDigitHex(color.rgba.g)).concat(_toTwoDigitHex(color.rgba.b)).concat(_toTwoDigitHex(Math.round(color.rgba.a * 255)));
      }
      _CSS.formatHexA = formatHexA;
      function format(color) {
        if (color.isOpaque()) {
          return Color.Format.CSS.formatHex(color);
        }
        return Color.Format.CSS.formatRGBA(color);
      }
      _CSS.format = format;
      function parseHex(hex) {
        var length = hex.length;
        if (length === 0) {
          // Invalid color
          return null;
        }
        if (hex.charCodeAt(0) !== CharCode.Hash) {
          // Does not begin with a #
          return null;
        }
        if (length === 7) {
          // #RRGGBB format
          var r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
          var g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
          var b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
          return new Color(new RGBA(r, g, b, 1));
        }
        if (length === 9) {
          // #RRGGBBAA format
          var _r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
          var _g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
          var _b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
          var a = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
          return new Color(new RGBA(_r, _g, _b, a / 255));
        }
        if (length === 4) {
          // #RGB format
          var _r2 = _parseHexDigit(hex.charCodeAt(1));
          var _g2 = _parseHexDigit(hex.charCodeAt(2));
          var _b2 = _parseHexDigit(hex.charCodeAt(3));
          return new Color(new RGBA(16 * _r2 + _r2, 16 * _g2 + _g2, 16 * _b2 + _b2));
        }
        if (length === 5) {
          // #RGBA format
          var _r3 = _parseHexDigit(hex.charCodeAt(1));
          var _g3 = _parseHexDigit(hex.charCodeAt(2));
          var _b3 = _parseHexDigit(hex.charCodeAt(3));
          var _a = _parseHexDigit(hex.charCodeAt(4));
          return new Color(new RGBA(16 * _r3 + _r3, 16 * _g3 + _g3, 16 * _b3 + _b3, (16 * _a + _a) / 255));
        }

        // Invalid color
        return null;
      }
      _CSS.parseHex = parseHex;
      function _parseHexDigit(charCode) {
        switch (charCode) {
          case CharCode.Digit0:
            return 0;
          case CharCode.Digit1:
            return 1;
          case CharCode.Digit2:
            return 2;
          case CharCode.Digit3:
            return 3;
          case CharCode.Digit4:
            return 4;
          case CharCode.Digit5:
            return 5;
          case CharCode.Digit6:
            return 6;
          case CharCode.Digit7:
            return 7;
          case CharCode.Digit8:
            return 8;
          case CharCode.Digit9:
            return 9;
          case CharCode.a:
            return 10;
          case CharCode.A:
            return 10;
          case CharCode.b:
            return 11;
          case CharCode.B:
            return 11;
          case CharCode.c:
            return 12;
          case CharCode.C:
            return 12;
          case CharCode.d:
            return 13;
          case CharCode.D:
            return 13;
          case CharCode.e:
            return 14;
          case CharCode.E:
            return 14;
          case CharCode.f:
            return 15;
          case CharCode.F:
            return 15;
        }
        return 0;
      }
    })(CSS || (CSS = _Format.CSS || (_Format.CSS = {})));
  })(Format || (Format = _Color2.Format || (_Color2.Format = {})));
})(Color || (Color = {}));
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/color/color-registry.js
function color_registry_typeof(o) { "@babel/helpers - typeof"; return color_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, color_registry_typeof(o); }
var color_registry_dec, color_registry_class;
function color_registry_construct(Parent, args, Class) { if (color_registry_isNativeReflectConstruct()) { color_registry_construct = Reflect.construct.bind(); } else { color_registry_construct = function _construct(Parent, args, Class) { var a = [null]; a.push.apply(a, args); var Constructor = Function.bind.apply(Parent, a); var instance = new Constructor(); if (Class) color_registry_setPrototypeOf(instance, Class.prototype); return instance; }; } return color_registry_construct.apply(null, arguments); }
function color_registry_isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }
function color_registry_setPrototypeOf(o, p) { color_registry_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return color_registry_setPrototypeOf(o, p); }
function color_registry_toConsumableArray(arr) { return color_registry_arrayWithoutHoles(arr) || color_registry_iterableToArray(arr) || color_registry_unsupportedIterableToArray(arr) || color_registry_nonIterableSpread(); }
function color_registry_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function color_registry_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function color_registry_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return color_registry_arrayLikeToArray(arr); }
function color_registry_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ color_registry_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == color_registry_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(color_registry_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function color_registry_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = color_registry_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function color_registry_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return color_registry_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return color_registry_arrayLikeToArray(o, minLen); }
function color_registry_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function color_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function color_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, color_registry_toPropertyKey(descriptor.key), descriptor); } }
function color_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) color_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) color_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function color_registry_toPropertyKey(t) { var i = color_registry_toPrimitive(t, "string"); return "symbol" == color_registry_typeof(i) ? i : String(i); }
function color_registry_toPrimitive(t, r) { if ("object" != color_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != color_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





/**
 * Either be a reference to an existing color or a color value as a hex string, rgba, or hsla.
 */
var color_registry_Color;
(function (_Color) {
  function rgba(r, g, b) {
    var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    return {
      r: r,
      g: g,
      b: b,
      a: a
    };
  }
  _Color.rgba = rgba;
  function hsla(h, s, l) {
    var a = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : 1;
    return {
      h: h,
      s: s,
      l: l,
      a: a
    };
  }
  _Color.hsla = hsla;
  var white = _Color.white = rgba(255, 255, 255, 1);
  var black = _Color.black = rgba(0, 0, 0, 1);
  function transparent(v, f) {
    return {
      v: v,
      f: f,
      kind: 'transparent'
    };
  }
  _Color.transparent = transparent;
  function lighten(v, f) {
    return {
      v: v,
      f: f,
      kind: 'lighten'
    };
  }
  _Color.lighten = lighten;
  function darken(v, f) {
    return {
      v: v,
      f: f,
      kind: 'darken'
    };
  }
  _Color.darken = darken;
})(color_registry_Color || (color_registry_Color = {}));
/**
 * It should be implemented by an extension, e.g. by the monaco extension.
 */
var ColorRegistry = (color_registry_dec = (0,mana_syringe_es/* singleton */.ri)(), color_registry_dec(color_registry_class = /*#__PURE__*/function () {
  function ColorRegistry(themeService) {
    color_registry_classCallCheck(this, ColorRegistry);
    this.definitionList = [];
    this.onDidChangeEmitter = new es_event/* Emitter */.Q5();
    this.onDidChange = this.onDidChangeEmitter.event;
    this.themeService = themeService;
  }
  ColorRegistry = (0,mana_syringe_es/* inject */.f3)(ThemeService)(ColorRegistry, undefined, 0) || ColorRegistry;
  color_registry_createClass(ColorRegistry, [{
    key: "fireDidChange",
    value: function fireDidChange() {
      this.onDidChangeEmitter.fire(undefined);
    }
  }, {
    key: "getColors",
    value: /*#__PURE__*/color_registry_regeneratorRuntime().mark(function getColors() {
      var _iterator, _step, definition;
      return color_registry_regeneratorRuntime().wrap(function getColors$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            // eslint-disable-next-line no-restricted-syntax
            _iterator = color_registry_createForOfIteratorHelper(this.definitionList);
            _context.prev = 1;
            _iterator.s();
          case 3:
            if ((_step = _iterator.n()).done) {
              _context.next = 9;
              break;
            }
            definition = _step.value;
            _context.next = 7;
            return definition.id;
          case 7:
            _context.next = 3;
            break;
          case 9:
            _context.next = 14;
            break;
          case 11:
            _context.prev = 11;
            _context.t0 = _context["catch"](1);
            _iterator.e(_context.t0);
          case 14:
            _context.prev = 14;
            _iterator.f();
            return _context.finish(14);
          case 17:
          case "end":
            return _context.stop();
        }
      }, getColors, this, [[1, 11, 14, 17]]);
    })
  }, {
    key: "getCurrentCssVariable",
    value: function getCurrentCssVariable(id) {
      var value = this.getCurrentColor(id);
      if (!value) {
        return undefined;
      }
      var name = this.toCssVariableName(id);
      return {
        name: name,
        value: value
      };
    }
  }, {
    key: "toCssVariableName",
    value: function toCssVariableName(id) {
      var prefix = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'mana';
      return "--".concat(prefix, "-").concat(id.replace(/\./g, '-'));
    }
  }, {
    key: "getCurrentColor",
    value: function getCurrentColor(id) {
      var theme = this.themeService.getActiveTheme();
      var type = theme.type,
        extraTokens = theme.extraTokens;
      if (extraTokens && extraTokens.color && extraTokens.color[id]) {
        var _this$toColor;
        return (_this$toColor = this.toColor(extraTokens.color[id])) === null || _this$toColor === void 0 ? void 0 : _this$toColor.toString();
      }
      var definition = this.definitionList.find(function (definition) {
        return definition.id === id;
      });
      if (definition && definition.defaults && definition.defaults[type]) {
        var _this$toColor2;
        return (_this$toColor2 = this.toColor(definition.defaults[type])) === null || _this$toColor2 === void 0 ? void 0 : _this$toColor2.toString();
      }
      return undefined;
    }
  }, {
    key: "register",
    value: function register() {
      var _this = this;
      for (var _len = arguments.length, definitions = new Array(_len), _key = 0; _key < _len; _key++) {
        definitions[_key] = arguments[_key];
      }
      var result = color_registry_construct(disposable_collection/* DisposableCollection */.K, color_registry_toConsumableArray(definitions.map(function (definition) {
        return _this.doRegister(definition);
      })));
      this.fireDidChange();
      return result;
    }
  }, {
    key: "doRegister",
    value: function doRegister(definition) {
      this.definitionList.push({
        id: definition.id,
        defaults: definition.defaults,
        description: definition.description
      });
      return disposable/* Disposable */.J.NONE;
    }
  }, {
    key: "toColor",
    value: function toColor(value) {
      if (!value) {
        return undefined;
      }
      if (typeof value === 'string') {
        if (value[0] === '#') {
          return Color.fromHex(value);
        }
        return this.toColor(this.getCurrentColor(value));
      }
      if ('kind' in value) {
        var colorValue = this.getCurrentColor(value.v);
        if (colorValue) {
          var color = Color.fromHex(colorValue);
          return color[value.kind](value.f);
        }
        return undefined;
      }
      if ('r' in value) {
        var r = value.r,
          g = value.g,
          b = value.b,
          _a = value.a;
        return new Color(new RGBA(r, g, b, _a));
      }
      var h = value.h,
        s = value.s,
        l = value.l,
        a = value.a;
      return new Color(new HSLA(h, s, l, a));
    }
  }]);
  return ColorRegistry;
}()) || color_registry_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/color/color-application.js
function color_application_typeof(o) { "@babel/helpers - typeof"; return color_application_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, color_application_typeof(o); }
var color_application_dec, color_application_class;
function color_application_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = color_application_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function color_application_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return color_application_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return color_application_arrayLikeToArray(o, minLen); }
function color_application_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function color_application_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function color_application_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, color_application_toPropertyKey(descriptor.key), descriptor); } }
function color_application_createClass(Constructor, protoProps, staticProps) { if (protoProps) color_application_defineProperties(Constructor.prototype, protoProps); if (staticProps) color_application_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function color_application_toPropertyKey(t) { var i = color_application_toPrimitive(t, "string"); return "symbol" == color_application_typeof(i) ? i : String(i); }
function color_application_toPrimitive(t, r) { if ("object" != color_application_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != color_application_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






var ColorApplication = (color_application_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: application_application/* ApplicationContribution */.rS
}), color_application_dec(color_application_class = /*#__PURE__*/function () {
  // dispose action when update

  function ColorApplication(themeService, colors, colorContributions) {
    color_application_classCallCheck(this, ColorApplication);
    this.toUpdate = new disposable_collection/* DisposableCollection */.K();
    this.themeService = themeService;
    this.colors = colors;
    this.colorContributions = colorContributions;
  }
  ColorApplication = (0,mana_syringe_es/* contrib */.el)(ColorContribution)(ColorApplication, undefined, 2) || ColorApplication;
  ColorApplication = (0,mana_syringe_es/* inject */.f3)(ColorRegistry)(ColorApplication, undefined, 1) || ColorApplication;
  ColorApplication = (0,mana_syringe_es/* inject */.f3)(ThemeService)(ColorApplication, undefined, 0) || ColorApplication;
  color_application_createClass(ColorApplication, [{
    key: "onStart",
    value: function onStart(app) {
      var _this = this;
      this.app = app;
      var _iterator = color_application_createForOfIteratorHelper(this.colorContributions.getContributions()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var contribution = _step.value;
          contribution.registerColors(this.colors);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      this.update();
      this.themeService.onDidColorThemeChange(function () {
        return _this.update();
      });
      this.colors.onDidChange(function () {
        return _this.update();
      });
    }
  }, {
    key: "update",
    value: function update() {
      var _this2 = this;
      if (!document) {
        return;
      }
      this.toUpdate.dispose();
      var themeClass = "mana-".concat(this.themeService.getCurrentTheme().type);
      document.body.classList.add(themeClass);
      this.toUpdate.push(disposable/* Disposable */.J.create(function () {
        return document.body.classList.remove(themeClass);
      }));
      var _document = document,
        documentElement = _document.documentElement;
      if (documentElement) {
        var _iterator2 = color_application_createForOfIteratorHelper(this.colors.getColors()),
          _step2;
        try {
          var _loop = function _loop() {
            var id = _step2.value;
            var variable = _this2.colors.getCurrentCssVariable(id);
            if (variable) {
              var name = variable.name,
                value = variable.value;
              documentElement.style.setProperty(name, value);
              _this2.toUpdate.push(disposable/* Disposable */.J.create(function () {
                return documentElement.style.removeProperty(name);
              }));
            }
          };
          for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
            _loop();
          }
        } catch (err) {
          _iterator2.e(err);
        } finally {
          _iterator2.f();
        }
      }
    }
  }]);
  return ColorApplication;
}()) || color_application_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/color/default-color-registry.js
function default_color_registry_typeof(o) { "@babel/helpers - typeof"; return default_color_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, default_color_registry_typeof(o); }
var default_color_registry_dec, default_color_registry_class;
function default_color_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function default_color_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, default_color_registry_toPropertyKey(descriptor.key), descriptor); } }
function default_color_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) default_color_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) default_color_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function default_color_registry_toPropertyKey(t) { var i = default_color_registry_toPrimitive(t, "string"); return "symbol" == default_color_registry_typeof(i) ? i : String(i); }
function default_color_registry_toPrimitive(t, r) { if ("object" != default_color_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != default_color_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



var DefaultColorRegistry = (default_color_registry_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: ColorContribution
}), default_color_registry_dec(default_color_registry_class = /*#__PURE__*/function () {
  function DefaultColorRegistry() {
    default_color_registry_classCallCheck(this, DefaultColorRegistry);
  }
  default_color_registry_createClass(DefaultColorRegistry, [{
    key: "registerColors",
    value: function registerColors(colors) {
      colors.register(
      // #region antd variable
      {
        id: 'text.color',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.85),
          light: color_registry_Color.rgba(0, 0, 0, 0.88)
        },
        description: ''
      }, {
        id: 'text.secondary',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.65),
          light: color_registry_Color.rgba(0, 0, 0, 0.65)
        },
        description: ''
      }, {
        id: 'text.tertiary',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.45),
          light: color_registry_Color.rgba(0, 0, 0, 0.45)
        },
        description: ''
      }, {
        id: 'text.quaternary',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.25),
          light: color_registry_Color.rgba(0, 0, 0, 0.25)
        },
        description: ''
      }, {
        id: 'color.border',
        defaults: {
          dark: '#424242',
          light: '#d9d9d9'
        },
        description: ''
      }, {
        id: 'color.border.secondary',
        defaults: {
          dark: '#303030',
          light: '#f0f0f0'
        },
        description: ''
      }, {
        id: 'color.fill',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.18),
          light: color_registry_Color.rgba(0, 0, 0, 0.15)
        },
        description: ''
      }, {
        id: 'color.fill.secondary',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.12),
          light: color_registry_Color.rgba(0, 0, 0, 0.06)
        },
        description: ''
      }, {
        id: 'color.fill.tertiary',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.08),
          light: color_registry_Color.rgba(0, 0, 0, 0.04)
        },
        description: ''
      }, {
        id: 'color.fill.quaternary',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.04),
          light: color_registry_Color.rgba(0, 0, 0, 0.02)
        },
        description: ''
      }, {
        id: 'color.bg.container',
        defaults: {
          dark: '#141414',
          light: '#ffffff'
        },
        description: ''
      }, {
        id: 'color.bg.elevated',
        defaults: {
          dark: '#1f1f1f',
          light: '#ffffff'
        },
        description: ''
      }, {
        id: 'color.bg.layout',
        defaults: {
          dark: '#000000',
          light: '#f5f5f5'
        },
        description: ''
      }, {
        id: 'color.bg.spotlight',
        defaults: {
          dark: '#424242',
          light: color_registry_Color.rgba(0, 0, 0, 0.85)
        },
        description: ''
      }, {
        id: 'color.bg.spotlight',
        defaults: {
          dark: color_registry_Color.rgba(0, 0, 0, 0.45),
          light: color_registry_Color.rgba(0, 0, 0, 0.45)
        },
        description: ''
      }, {
        id: 'primary.color',
        defaults: {
          dark: '#177ddc',
          light: '#1890ff'
        },
        description: ''
      }, {
        id: 'primary.color.hover',
        defaults: {
          dark: '#3c9be8',
          light: '#40a9ff'
        },
        description: ''
      }, {
        id: 'primary.color.active',
        defaults: {
          dark: '#095cb5',
          light: '#096dd9'
        },
        description: ''
      }, {
        id: 'primary.color.outline',
        defaults: {
          dark: color_registry_Color.rgba(23, 125, 220, 0.2),
          light: color_registry_Color.rgba(24, 144, 255, 0.2)
        },
        description: ''
      }, {
        id: 'primary.1',
        defaults: {
          dark: '#e6f7ff',
          light: '#e6f7ff'
        },
        description: ''
      }, {
        id: 'primary.2',
        defaults: {
          dark: '#bde8ff',
          light: '#bae7ff'
        },
        description: ''
      }, {
        id: 'primary.3',
        defaults: {
          dark: '#94d6ff',
          light: '#91d5ff'
        },
        description: ''
      }, {
        id: 'primary.4',
        defaults: {
          dark: '#67baf5',
          light: '#69c0ff'
        },
        description: ''
      }, {
        id: 'primary.5',
        defaults: {
          dark: '#3c9be8',
          light: '#40a9ff'
        },
        description: ''
      }, {
        id: 'primary.6',
        defaults: {
          dark: '#177ddc',
          light: '#1890ff'
        },
        description: ''
      }, {
        id: 'primary.7',
        defaults: {
          dark: '#095cb5',
          light: '#096dd9'
        },
        description: ''
      }, {
        id: 'success.color',
        defaults: {
          dark: '#49aa19',
          light: '#52c41a'
        },
        description: ''
      }, {
        id: 'success.color.hover',
        defaults: {
          dark: '#67b839',
          light: '#73d13d'
        },
        description: ''
      }, {
        id: 'success.color.active',
        defaults: {
          dark: '#31850d',
          light: '#389e0d'
        },
        description: ''
      }, {
        id: 'success.color.outline',
        defaults: {
          dark: color_registry_Color.rgba(73, 170, 25, 0.2),
          light: color_registry_Color.rgba(82, 196, 26, 0.2)
        },
        description: ''
      }, {
        id: 'error.color',
        defaults: {
          dark: '#a61d24',
          light: '#ff4d4f'
        },
        description: ''
      }, {
        id: 'error.color.hover',
        defaults: {
          dark: '#b33b3d',
          light: '#ff7875'
        },
        description: ''
      }, {
        id: 'error.color.active',
        defaults: {
          dark: '#800f19',
          light: '#d9363e'
        },
        description: ''
      }, {
        id: 'error.color.outline',
        defaults: {
          dark: color_registry_Color.rgba(166, 29, 36, 0.2),
          light: color_registry_Color.rgba(255, 77, 79, 0.2)
        },
        description: ''
      }, {
        id: 'warning.color',
        defaults: {
          dark: '#d89614',
          light: '#faad14'
        },
        description: ''
      }, {
        id: 'warning.color.hover',
        defaults: {
          dark: '#e6b239',
          light: '#ffc53d'
        },
        description: ''
      }, {
        id: 'warning.color.active',
        defaults: {
          dark: '#b37407',
          light: '#d48806'
        },
        description: ''
      }, {
        id: 'warning.color.outline',
        defaults: {
          dark: color_registry_Color.rgba(216, 150, 20, 0.2),
          light: color_registry_Color.rgba(250, 173, 20, 0.2)
        },
        description: ''
      }, {
        id: 'info.color',
        defaults: {
          dark: '#177ddc',
          light: '#1890ff'
        },
        description: ''
      },
      // #endregion

      // #region basic tag
      {
        id: 'textLink.foreground',
        defaults: {
          dark: 'primary.color',
          light: 'primary.color'
        },
        description: 'foreground color of tag a.'
      }, {
        id: 'textLink.activeForeground',
        defaults: {
          dark: 'primary.color.hover',
          light: 'primary.color.hover'
        },
        description: 'A foreground when hovering over items using the mouse.'
      }, {
        id: 'selection.background',
        defaults: {
          dark: 'primary.color',
          light: 'primary.color'
        },
        description: 'Overall border color for focused elements. This color is only used if not overridden by a component.'
      },
      // #endregion

      // #region tabs
      {
        id: 'activityBar.background',
        defaults: {
          dark: '#35393d',
          light: '#ececec'
        },
        description: 'Activity bar background color. The activity bar is showing on the far left or right and allows to switch between views of the side bar.'
      }, {
        id: 'activityBar.foreground',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.65),
          light: color_registry_Color.rgba(0, 0, 0, 0.65)
        },
        description: 'Activity bar item foreground color when it is active. The activity bar is showing on the far left or right and allows to switch between views of the side bar.'
      }, {
        id: 'activityBar.border',
        defaults: {
          dark: '#252729',
          light: '#e0e0e0'
        },
        description: 'Activity bar border color separating to the side bar. The activity bar is showing on the far left or right and allows to switch between views of the side bar.'
      }, {
        id: 'activityBar.inactiveForeground',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.4),
          light: color_registry_Color.rgba(0, 0, 0, 0.4)
        },
        description: 'Activity bar item foreground color when it is inactive. The activity bar is showing on the far left or right and allows to switch between views of the side bar.'
      }, {
        id: 'sideBar.background',
        defaults: {
          dark: '#252526',
          light: '#f3f3f3'
        },
        description: 'Side bar background color. The side bar is the container for views like explorer and search.'
      }, {
        id: 'tab.activeBackground',
        defaults: {
          dark: 'editor.background',
          light: 'editor.background',
          hc: 'editor.background'
        },
        description: 'Active tab background color. Tabs are the containers for editors in the editor area. Multiple tabs can be opened in one editor group. There can be multiple editor groups.'
      }, {
        id: 'tab.inactiveBackground',
        defaults: {
          dark: '#2D2D2D',
          light: '#ECECEC'
        },
        description: 'Inactive tab background color. Tabs are the containers for editors in the editor area. Multiple tabs can be opened in one editor group. There can be multiple editor groups.'
      }, {
        id: 'tab.activeForeground',
        defaults: {
          dark: color_registry_Color.white,
          light: '#333333'
        },
        description: 'Active tab foreground color in an active group. Tabs are the containers for editors in the editor area. Multiple tabs can be opened in one editor group. There can be multiple editor groups.'
      }, {
        id: 'tab.inactiveForeground',
        defaults: {
          dark: color_registry_Color.transparent('tab.activeForeground', 0.5),
          light: color_registry_Color.transparent('tab.activeForeground', 0.7)
        },
        description: 'Inactive tab foreground color in an active group. Tabs are the containers for editors in the editor area. Multiple tabs can be opened in one editor group. There can be multiple editor groups.'
      }, {
        id: 'tab.border',
        defaults: {
          dark: '#252526',
          light: '#F3F3F3'
        },
        description: 'Border to separate tabs from each other. Tabs are the containers for editors in the editor area. Multiple tabs can be opened in one editor group. There can be multiple editor groups.'
      }, {
        id: 'tab.activeBorder',
        defaults: {
          dark: '#007fd4',
          light: color_registry_Color.rgba(0, 144, 241, 0.7)
        },
        description: 'Border to separate tabs from each other. Tabs are the containers for editors in the editor area. Multiple tabs can be opened in one editor group. There can be multiple editor groups.'
      },
      // #endregion

      // #region list/tree
      {
        id: 'foreground',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.85),
          light: color_registry_Color.rgba(0, 0, 0, 0.85)
        },
        description: 'foreground color of body.'
      }, {
        id: 'list.hoverForeground',
        description: 'List/Tree foreground when hovering over items using the mouse.'
      }, {
        id: 'list.hoverBackground',
        defaults: {
          dark: color_registry_Color.rgba(255, 255, 255, 0.08),
          light: '#f5f5f5'
        },
        description: 'List/Tree background when hovering over items using the mouse.'
      }, {
        id: 'list.activeSelectionForeground',
        defaults: {
          dark: '#FFF',
          light: '#FFF'
        },
        description: 'List/Tree foreground color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not.'
      }, {
        id: 'list.activeSelectionBackground',
        defaults: {
          dark: 'primary.color',
          light: 'primary.color'
        },
        description: 'List/Tree background color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not.'
      }, {
        id: 'list.inactiveSelectionForeground',
        description: 'List/Tree foreground color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not.'
      }, {
        id: 'list.inactiveSelectionBackground',
        defaults: {
          dark: '#37373D',
          light: '#E4E6F1'
        },
        description: 'List/Tree background color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not.'
      }, {
        id: 'tree.indentGuidesStroke',
        defaults: {
          dark: '#585858',
          light: '#a9a9a9'
        },
        description: 'Tree stroke color for the indentation guides.'
      }, {
        id: 'tree.inactiveIndentGuidesStroke',
        defaults: {
          dark: color_registry_Color.transparent('tree.indentGuidesStroke', 0.4),
          light: color_registry_Color.transparent('tree.indentGuidesStroke', 0.4),
          hc: color_registry_Color.transparent('tree.indentGuidesStroke', 0.4)
        },
        description: 'Tree stroke color for the inactive indentation guides.'
      },
      // #endregion

      // #region editor
      {
        id: 'editor.background',
        defaults: {
          dark: '#000',
          light: '#FFF'
        },
        description: 'background color of body.'
      },
      // #endregion

      // #region menu
      {
        id: 'menubar.background',
        defaults: {
          dark: '#3c3c3c',
          light: '#dddddd'
        },
        description: 'background color of side.'
      }, {
        id: 'menubar.border',
        defaults: {
          dark: 'activityBar.border',
          light: 'activityBar.border'
        },
        description: 'Activity bar border color separating to the side bar. The activity bar is showing on the far left or right and allows to switch between views of the side bar.'
      }
      // #endregion
      );
    }
  }]);
  return DefaultColorRegistry;
}()) || default_color_registry_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/basic/index.js



;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/color/index.js



;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/theme/index.js













var ThemeModule = mana_module/* ManaModule */.R.create().register({
  token: ThemeService,
  useDynamic: function useDynamic() {
    return ThemeService.get();
  }
});
var ThemeVariableModule = mana_module/* ManaModule */.R.create().contribution(VariableContribution, ColorContribution).register(VariableRegistry, VariableApplication, DefaultVariableRegistry).register(ColorRegistry, ColorApplication, DefaultColorRegistry).dependOn(ThemeModule);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/toolbar/toolbar-protocol.js
/**
 * Instance of toolbar
 * Use this token to get the toolbar instance when customizing elements on the toolbar.
 */
var ToolbarInstance = Symbol('ToolbarInstance');

/**
 * Factory for instantiating toolbars.
 */
var ToolbarItemFactory = Symbol('ToolbarItemFactory');
var ToolbarNode = Symbol('ToolbarItemDefinition');
var ToolbarItem;
(function (_ToolbarItem) {
  function isDefinition(arg) {
    return !!arg && 'id' in arg && 'command' in arg && typeof arg.command === 'string';
  }
  _ToolbarItem.isDefinition = isDefinition;
  function is(arg) {
    return isDefinition(arg) && 'onDisposed' in arg;
  }
  _ToolbarItem.is = is;
  function getGroupKey(record) {
    if (!record.group) {
      return '';
    }
    if (typeof record.group === 'string') {
      return record.group;
    }
    return record.group.join('.');
  }
  _ToolbarItem.getGroupKey = getGroupKey;
})(ToolbarItem || (ToolbarItem = {}));
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/toolbar/default-toolbar-item.js
function default_toolbar_item_typeof(o) { "@babel/helpers - typeof"; return default_toolbar_item_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, default_toolbar_item_typeof(o); }
var default_toolbar_item_dec, default_toolbar_item_dec2, default_toolbar_item_dec3, default_toolbar_item_dec4, default_toolbar_item_dec5, default_toolbar_item_class, default_toolbar_item_class2, default_toolbar_item_descriptor, default_toolbar_item_descriptor2, default_toolbar_item_descriptor3, default_toolbar_item_descriptor4;
function default_toolbar_item_initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function default_toolbar_item_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function default_toolbar_item_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, default_toolbar_item_toPropertyKey(descriptor.key), descriptor); } }
function default_toolbar_item_createClass(Constructor, protoProps, staticProps) { if (protoProps) default_toolbar_item_defineProperties(Constructor.prototype, protoProps); if (staticProps) default_toolbar_item_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function default_toolbar_item_toPropertyKey(t) { var i = default_toolbar_item_toPrimitive(t, "string"); return "symbol" == default_toolbar_item_typeof(i) ? i : String(i); }
function default_toolbar_item_toPrimitive(t, r) { if ("object" != default_toolbar_item_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != default_toolbar_item_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function default_toolbar_item_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function default_toolbar_item_initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }





var DefaultToolbarItem = (default_toolbar_item_dec = (0,mana_syringe_es/* transient */.H3)(), default_toolbar_item_dec2 = (0,es/* prop */.vg)(), default_toolbar_item_dec3 = (0,es/* prop */.vg)(), default_toolbar_item_dec4 = (0,es/* prop */.vg)(), default_toolbar_item_dec5 = (0,es/* prop */.vg)(), default_toolbar_item_dec(default_toolbar_item_class = (default_toolbar_item_class2 = /*#__PURE__*/function () {
  /**
   * Optional label for the item.
   */

  /**
   * Optional tooltip for the item.
   */

  /**
   * Optional icon for the item.
   */

  function DefaultToolbarItem(item) {
    default_toolbar_item_classCallCheck(this, DefaultToolbarItem);
    default_toolbar_item_initializerDefineProperty(this, "extra", default_toolbar_item_descriptor, this);
    default_toolbar_item_initializerDefineProperty(this, "showLabelInline", default_toolbar_item_descriptor2, this);
    default_toolbar_item_initializerDefineProperty(this, "order", default_toolbar_item_descriptor3, this);
    default_toolbar_item_initializerDefineProperty(this, "group", default_toolbar_item_descriptor4, this);
    this.disposedEventEmitter = new es_event/* Emitter */.Q5();
    this.onDisposed = this.disposedEventEmitter.event;
    this.item = item;
    this.source = item;
    this.id = item.id;
    this.command = item.command;
    this.extra = item.extra;
    this.order = item.order;
    this.label = item.label;
    this.tooltip = item.tooltip;
    this.icon = item.icon;
    this.meta = item.meta;
    this.group = item.group;
    this.showLabelInline = item.showLabelInline;
    this.isActive = item.isActive;
    this.isEnabled = item.isEnabled;
    this.isVisible = item.isVisible;
    this.execute = item.execute;
  }
  DefaultToolbarItem = (0,mana_syringe_es/* inject */.f3)(ToolbarNode)(DefaultToolbarItem, undefined, 0) || DefaultToolbarItem;
  default_toolbar_item_createClass(DefaultToolbarItem, [{
    key: "dispose",
    value: function dispose() {
      this.disposedEventEmitter.fire();
    }
  }]);
  return DefaultToolbarItem;
}(), (default_toolbar_item_descriptor = default_toolbar_item_applyDecoratedDescriptor(default_toolbar_item_class2.prototype, "extra", [default_toolbar_item_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), default_toolbar_item_descriptor2 = default_toolbar_item_applyDecoratedDescriptor(default_toolbar_item_class2.prototype, "showLabelInline", [default_toolbar_item_dec3], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), default_toolbar_item_descriptor3 = default_toolbar_item_applyDecoratedDescriptor(default_toolbar_item_class2.prototype, "order", [default_toolbar_item_dec4], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
}), default_toolbar_item_descriptor4 = default_toolbar_item_applyDecoratedDescriptor(default_toolbar_item_class2.prototype, "group", [default_toolbar_item_dec5], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: null
})), default_toolbar_item_class2)) || default_toolbar_item_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/toolbar/toolbar-registry.js
function toolbar_registry_typeof(o) { "@babel/helpers - typeof"; return toolbar_registry_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, toolbar_registry_typeof(o); }
var toolbar_registry_dec, toolbar_registry_dec2, toolbar_registry_class, toolbar_registry_class2, toolbar_registry_descriptor;
function toolbar_registry_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = toolbar_registry_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function toolbar_registry_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return toolbar_registry_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return toolbar_registry_arrayLikeToArray(o, minLen); }
function toolbar_registry_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function toolbar_registry_initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function toolbar_registry_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function toolbar_registry_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, toolbar_registry_toPropertyKey(descriptor.key), descriptor); } }
function toolbar_registry_createClass(Constructor, protoProps, staticProps) { if (protoProps) toolbar_registry_defineProperties(Constructor.prototype, protoProps); if (staticProps) toolbar_registry_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function toolbar_registry_toPropertyKey(t) { var i = toolbar_registry_toPrimitive(t, "string"); return "symbol" == toolbar_registry_typeof(i) ? i : String(i); }
function toolbar_registry_toPrimitive(t, r) { if ("object" != toolbar_registry_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != toolbar_registry_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function toolbar_registry_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function toolbar_registry_initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }





/**
 * Clients should implement this interface if they want to contribute to the toolbar.
 */
var ToolbarContribution = mana_syringe_es/* Syringe */.J3.defineToken('ToolbarContribution');
/**
 * Main, shared registry for tab-bar toolbar items.
 */
var ToolbarRegistry = (toolbar_registry_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: application_application/* ApplicationContribution */.rS
}), toolbar_registry_dec2 = (0,es/* prop */.vg)(), toolbar_registry_dec(toolbar_registry_class = (toolbar_registry_class2 = /*#__PURE__*/function () {
  function ToolbarRegistry(toolbarItemFactory, contributionProvider) {
    toolbar_registry_classCallCheck(this, ToolbarRegistry);
    toolbar_registry_initializerDefineProperty(this, "items", toolbar_registry_descriptor, this);
    this.onDidChangeEmitter = new es_event/* Emitter */.Q5();
    this.toolbarItemFactory = toolbarItemFactory;
    this.contributionProvider = contributionProvider;
  }
  ToolbarRegistry = (0,mana_syringe_es/* contrib */.el)(ToolbarContribution)(ToolbarRegistry, undefined, 1) || ToolbarRegistry;
  ToolbarRegistry = (0,mana_syringe_es/* inject */.f3)(ToolbarItemFactory)(ToolbarRegistry, undefined, 0) || ToolbarRegistry;
  toolbar_registry_createClass(ToolbarRegistry, [{
    key: "onStart",
    value: function onStart() {
      var contributions = this.contributionProvider.getContributions();
      var _iterator = toolbar_registry_createForOfIteratorHelper(contributions),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var contribution = _step.value;
          contribution.registerToolbarItems(this);
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    /**
     * Registers the given item. Throws an error, if the corresponding command cannot be found or an item has been already registered for the desired command.
     *
     * @param item the item to register.
     */
  }, {
    key: "registerItem",
    value: function registerItem(def) {
      var _this = this;
      var id = def.id;
      if (this.items.has(id)) {
        throw new Error("A toolbar item is already registered with the '".concat(id, "' ID."));
      }
      var item = ToolbarItem.is(def) ? def : this.toolbarItemFactory(def);
      this.items.set(id, item);
      item.onDisposed(function () {
        return _this.items.delete(id);
      });
      return item;
    }
  }, {
    key: "getToolbarItem",
    value: function getToolbarItem(id) {
      return this.items.get(id);
    }
  }, {
    key: "unregisterItem",
    value: function unregisterItem(itemOrId) {
      var id = typeof itemOrId === 'string' ? itemOrId : itemOrId.id;
      this.items.delete(id);
    }
  }]);
  return ToolbarRegistry;
}(), (toolbar_registry_descriptor = toolbar_registry_applyDecoratedDescriptor(toolbar_registry_class2.prototype, "items", [toolbar_registry_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return new Map();
  }
})), toolbar_registry_class2)) || toolbar_registry_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/toolbar/index.js




var CoreToolbarModule = mana_module/* ManaModule */.R.create().contribution(ToolbarContribution).register(DefaultToolbarItem, ToolbarRegistry).register({
  token: ToolbarItemFactory,
  useDynamic: function useDynamic(ctx) {
    return function (item) {
      var child = ctx.container.createChild();
      child.register({
        token: ToolbarNode,
        useValue: item
      });
      return child.get(DefaultToolbarItem);
    };
  }
});



// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/default-slot-view.js
var default_slot_view = __webpack_require__(29083);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-common@0.1.19/node_modules/@difizen/mana-common/es/priority.js
var priority = __webpack_require__(46484);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/open-handler.js
function open_handler_typeof(o) { "@babel/helpers - typeof"; return open_handler_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, open_handler_typeof(o); }
var open_handler_dec, open_handler_class;
function open_handler_toConsumableArray(arr) { return open_handler_arrayWithoutHoles(arr) || open_handler_iterableToArray(arr) || open_handler_unsupportedIterableToArray(arr) || open_handler_nonIterableSpread(); }
function open_handler_nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function open_handler_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return open_handler_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return open_handler_arrayLikeToArray(o, minLen); }
function open_handler_iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }
function open_handler_arrayWithoutHoles(arr) { if (Array.isArray(arr)) return open_handler_arrayLikeToArray(arr); }
function open_handler_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function open_handler_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ open_handler_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == open_handler_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(open_handler_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function open_handler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function open_handler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, open_handler_toPropertyKey(descriptor.key), descriptor); } }
function open_handler_createClass(Constructor, protoProps, staticProps) { if (protoProps) open_handler_defineProperties(Constructor.prototype, protoProps); if (staticProps) open_handler_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function open_handler_toPropertyKey(t) { var i = open_handler_toPrimitive(t, "string"); return "symbol" == open_handler_typeof(i) ? i : String(i); }
function open_handler_toPrimitive(t, r) { if ("object" != open_handler_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != open_handler_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function open_handler_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function open_handler_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { open_handler_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { open_handler_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }



// eslint-disable-next-line @typescript-eslint/no-empty-interface

var OpenHandler = mana_syringe_es/* Syringe */.J3.defineToken('OpenHandler');
/**
 * `OpenHandler` should be implemented to provide a new opener.
 */

var OpenerService = Symbol('OpenerService');
/**
 * `OpenerService` provide an access to existing openers.
 */

function open_handler_open(_x, _x2, _x3) {
  return _open.apply(this, arguments);
}
function _open() {
  _open = open_handler_asyncToGenerator( /*#__PURE__*/open_handler_regeneratorRuntime().mark(function _callee5(openerService, resource, options) {
    var opener;
    return open_handler_regeneratorRuntime().wrap(function _callee5$(_context5) {
      while (1) switch (_context5.prev = _context5.next) {
        case 0:
          _context5.next = 2;
          return openerService.getOpener(resource, options);
        case 2:
          opener = _context5.sent;
          return _context5.abrupt("return", opener.open(resource, options));
        case 4:
        case "end":
          return _context5.stop();
      }
    }, _callee5);
  }));
  return _open.apply(this, arguments);
}
var DefaultOpenerService = (open_handler_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: OpenerService
}), open_handler_dec(open_handler_class = /*#__PURE__*/function () {
  function DefaultOpenerService(handlersProvider) {
    open_handler_classCallCheck(this, DefaultOpenerService);
    this.handlersProvider = handlersProvider;
  }
  DefaultOpenerService = (0,mana_syringe_es/* contrib */.el)(OpenHandler)(DefaultOpenerService, undefined, 0) || DefaultOpenerService;
  open_handler_createClass(DefaultOpenerService, [{
    key: "getOpener",
    value: function () {
      var _getOpener = open_handler_asyncToGenerator( /*#__PURE__*/open_handler_regeneratorRuntime().mark(function _callee(resource, options) {
        var handlers;
        return open_handler_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.prioritize(resource, options);
            case 2:
              handlers = _context.sent;
              if (!(handlers.length >= 1)) {
                _context.next = 5;
                break;
              }
              return _context.abrupt("return", handlers[0]);
            case 5:
              return _context.abrupt("return", Promise.reject(new Error("There is no opener for resource: ".concat(resource.toString(), "."))));
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function getOpener(_x4, _x5) {
        return _getOpener.apply(this, arguments);
      }
      return getOpener;
    }()
  }, {
    key: "getOpeners",
    value: function () {
      var _getOpeners = open_handler_asyncToGenerator( /*#__PURE__*/open_handler_regeneratorRuntime().mark(function _callee2(resource, options) {
        return open_handler_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              return _context2.abrupt("return", resource ? this.prioritize(resource, options) : this.getHandlers());
            case 1:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getOpeners(_x6, _x7) {
        return _getOpeners.apply(this, arguments);
      }
      return getOpeners;
    }()
  }, {
    key: "prioritize",
    value: function () {
      var _prioritize = open_handler_asyncToGenerator( /*#__PURE__*/open_handler_regeneratorRuntime().mark(function _callee4(resource, options) {
        var prioritized;
        return open_handler_regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return priority/* Priority */.U.sort(this.getHandlers(), /*#__PURE__*/function () {
                var _ref = open_handler_asyncToGenerator( /*#__PURE__*/open_handler_regeneratorRuntime().mark(function _callee3(handler) {
                  return open_handler_regeneratorRuntime().wrap(function _callee3$(_context3) {
                    while (1) switch (_context3.prev = _context3.next) {
                      case 0:
                        _context3.prev = 0;
                        _context3.next = 3;
                        return handler.canHandle(resource, options);
                      case 3:
                        return _context3.abrupt("return", _context3.sent);
                      case 6:
                        _context3.prev = 6;
                        _context3.t0 = _context3["catch"](0);
                        return _context3.abrupt("return", 0);
                      case 9:
                      case "end":
                        return _context3.stop();
                    }
                  }, _callee3, null, [[0, 6]]);
                }));
                return function (_x10) {
                  return _ref.apply(this, arguments);
                };
              }());
            case 2:
              prioritized = _context4.sent;
              return _context4.abrupt("return", prioritized.map(function (p) {
                return p.value;
              }));
            case 4:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function prioritize(_x8, _x9) {
        return _prioritize.apply(this, arguments);
      }
      return prioritize;
    }()
  }, {
    key: "getHandlers",
    value: function getHandlers() {
      return open_handler_toConsumableArray(this.handlersProvider.getContributions());
    }
  }]);
  return DefaultOpenerService;
}()) || open_handler_class);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/root-view.js
var root_view = __webpack_require__(47619);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/slot-view-manager.js
var slot_view_manager = __webpack_require__(34837);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/view-manager.js
var view_manager = __webpack_require__(30393);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/view-protocol.js
var view_protocol = __webpack_require__(15063);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/view-storage.js
var view_storage_dec, view_storage_dec2, view_storage_class, view_storage_class2, view_storage_descriptor;
function view_storage_typeof(o) { "@babel/helpers - typeof"; return view_storage_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, view_storage_typeof(o); }
function view_storage_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function view_storage_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? view_storage_ownKeys(Object(t), !0).forEach(function (r) { view_storage_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : view_storage_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function view_storage_defineProperty(obj, key, value) { key = view_storage_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function view_storage_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ view_storage_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == view_storage_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(view_storage_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function view_storage_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function view_storage_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { view_storage_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { view_storage_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function view_storage_initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }
function view_storage_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function view_storage_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, view_storage_toPropertyKey(descriptor.key), descriptor); } }
function view_storage_createClass(Constructor, protoProps, staticProps) { if (protoProps) view_storage_defineProperties(Constructor.prototype, protoProps); if (staticProps) view_storage_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function view_storage_toPropertyKey(t) { var i = view_storage_toPrimitive(t, "string"); return "symbol" == view_storage_typeof(i) ? i : String(i); }
function view_storage_toPrimitive(t, r) { if ("object" != view_storage_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != view_storage_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function view_storage_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }
function view_storage_initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }
/* eslint-disable @typescript-eslint/no-explicit-any */








var SavedView;
(function (_SavedView) {
  function is(data) {
    return !!data && view_storage_typeof(data) === 'object' && 'factoryId' in data;
  }
  _SavedView.is = is;
})(SavedView || (SavedView = {}));
var ShouldPreventStoreViewKey = 'mana-should-prevent-store-view';
var ViewStorage = (view_storage_dec = (0,mana_syringe_es/* singleton */.ri)(), view_storage_dec2 = (0,es/* prop */.vg)(), view_storage_dec(view_storage_class = (view_storage_class2 = /*#__PURE__*/function () {
  function ViewStorage(viewManager, slotViewManager, debugService, storageService) {
    view_storage_classCallCheck(this, ViewStorage);
    this.storageKey = 'mana-view-info';
    this.restoreCount = 0;
    view_storage_initializerDefineProperty(this, "shouldStoreViews", view_storage_descriptor, this);
    this.viewManager = viewManager;
    this.slotViewManager = slotViewManager;
    this.debugService = debugService;
    this.storageService = storageService;
    if (localStorage.getItem(ShouldPreventStoreViewKey) === 'once') {
      localStorage.removeItem(ShouldPreventStoreViewKey);
    }
    if (localStorage.getItem(ShouldPreventStoreViewKey) === 'false') {
      this.shouldStoreViews = true;
    }
  }
  ViewStorage = (0,mana_syringe_es/* inject */.f3)(StorageService)(ViewStorage, undefined, 3) || ViewStorage;
  ViewStorage = (0,mana_syringe_es/* inject */.f3)(debug/* DebugService */.r)(ViewStorage, undefined, 2) || ViewStorage;
  ViewStorage = (0,mana_syringe_es/* inject */.f3)(slot_view_manager/* SlotViewManager */.I)(ViewStorage, undefined, 1) || ViewStorage;
  ViewStorage = (0,mana_syringe_es/* inject */.f3)(view_manager/* ViewManager */.v)(ViewStorage, undefined, 0) || ViewStorage;
  view_storage_createClass(ViewStorage, [{
    key: "canStoreView",
    get: function get() {
      return this.shouldStoreViews;
    }
  }, {
    key: "onlyRootView",
    get: function get() {
      return this.restoreCount < 2;
    }
  }, {
    key: "disableStoreView",
    value: function disableStoreView() {
      this.shouldStoreViews = false;
      this.storageService.setData(this.storageKey, undefined);
      localStorage.setItem(ShouldPreventStoreViewKey, 'true');
    }
  }, {
    key: "enableStoreView",
    value: function enableStoreView() {
      this.shouldStoreViews = true;
      localStorage.setItem(ShouldPreventStoreViewKey, 'false');
    }
  }, {
    key: "resetViews",
    value: function resetViews() {
      this.shouldStoreViews = false;
      this.storageService.setData(this.storageKey, undefined);
      localStorage.removeItem(ShouldPreventStoreViewKey);
      window.location.reload();
    }
  }, {
    key: "saveViews",
    value: function () {
      var _saveViews = view_storage_asyncToGenerator( /*#__PURE__*/view_storage_regeneratorRuntime().mark(function _callee() {
        var rootView, viewInfo;
        return view_storage_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.viewManager.getView(view_protocol/* RootViewId */.ar);
            case 2:
              rootView = _context.sent;
              if (rootView) {
                viewInfo = this.getViewInfo(rootView);
              }
              this.storageService.setData(this.storageKey, viewInfo);
            case 5:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function saveViews() {
        return _saveViews.apply(this, arguments);
      }
      return saveViews;
    }()
  }, {
    key: "getViewInfo",
    value: function getViewInfo(view, slot, openOption) {
      var baseInfo = this.getViewBaseInfo(view, slot);
      if (!baseInfo) {
        return;
      }
      this.debugService('store view >>>>>>>>>>>>>>>', baseInfo.factoryId, baseInfo.option, baseInfo.slot);
      return view_storage_objectSpread(view_storage_objectSpread({}, baseInfo), {}, {
        slots: this.getViewSlotsInfo(view),
        children: this.getViewChildrenInfo(view),
        openOption: openOption
      });
    }
  }, {
    key: "getViewBaseInfo",
    value: function getViewBaseInfo(view, slot) {
      var factoryId = this.viewManager.getFactoryIdByView(view);
      if (!factoryId) {
        return;
      }
      var option = this.viewManager.getViewOption(view);
      return {
        factoryId: factoryId,
        slot: slot,
        option: option,
        state: view_protocol/* StatefulView */.sh.is(view) ? view.storeState() : undefined
      };
    }
  }, {
    key: "getViewSlotsInfo",
    value: function getViewSlotsInfo(parentView) {
      var _this = this;
      var slotNames = this.slotViewManager.getSlotChildren(parentView);
      if (!slotNames) {
        return undefined;
      }
      var slots = slotNames.map(function (slot) {
        var slotView = _this.slotViewManager.getSlotView(slot);
        if (slotView) {
          return _this.getViewInfo(slotView, slot);
        }
        return undefined;
      }).filter(SavedView.is);
      if (slots.length > 0) {
        return slots;
      }
      return undefined;
    }
  }, {
    key: "getViewChildrenInfo",
    value: function getViewChildrenInfo(view) {
      var _this2 = this;
      if (!view_protocol/* SlotView */.tl.is(view)) {
        return undefined;
      }
      var children = view.children.map(function (item) {
        var openOption = view.getViewOption(item);
        openOption === null || openOption === void 0 || delete openOption.reveal;
        return _this2.getViewInfo(item, undefined, openOption);
      }).filter(SavedView.is);
      if (children.length > 0) {
        return children;
      }
      return undefined;
    }
  }, {
    key: "getSavedView",
    value: function () {
      var _getSavedView = view_storage_asyncToGenerator( /*#__PURE__*/view_storage_regeneratorRuntime().mark(function _callee2() {
        var viewInfo;
        return view_storage_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return this.storageService.getData(this.storageKey);
            case 2:
              viewInfo = _context2.sent;
              return _context2.abrupt("return", viewInfo);
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function getSavedView() {
        return _getSavedView.apply(this, arguments);
      }
      return getSavedView;
    }()
  }, {
    key: "restoreView",
    value: function () {
      var _restoreView = view_storage_asyncToGenerator( /*#__PURE__*/view_storage_regeneratorRuntime().mark(function _callee5(savedView) {
        var _this3 = this;
        var factoryId, option, state, view;
        return view_storage_regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              factoryId = savedView.factoryId, option = savedView.option, state = savedView.state;
              _context5.prev = 1;
              this.debugService('restore view >>>>>>>>>>>>>>>', factoryId, option, savedView.slot);
              _context5.next = 5;
              return this.viewManager.getOrCreateView(factoryId, option);
            case 5:
              view = _context5.sent;
              if (savedView.slot) {
                this.slotViewManager.setSlotView(savedView.slot, view);
              }
              if (!savedView.slots) {
                _context5.next = 10;
                break;
              }
              _context5.next = 10;
              return Promise.all(savedView.slots.map( /*#__PURE__*/function () {
                var _ref = view_storage_asyncToGenerator( /*#__PURE__*/view_storage_regeneratorRuntime().mark(function _callee3(item) {
                  return view_storage_regeneratorRuntime().wrap(function _callee3$(_context3) {
                    while (1) switch (_context3.prev = _context3.next) {
                      case 0:
                        _context3.next = 2;
                        return _this3.restoreView(item);
                      case 2:
                        return _context3.abrupt("return", _context3.sent);
                      case 3:
                      case "end":
                        return _context3.stop();
                    }
                  }, _callee3);
                }));
                return function (_x2) {
                  return _ref.apply(this, arguments);
                };
              }()));
            case 10:
              if (!savedView.children) {
                _context5.next = 13;
                break;
              }
              _context5.next = 13;
              return Promise.all(savedView.children.map( /*#__PURE__*/function () {
                var _ref2 = view_storage_asyncToGenerator( /*#__PURE__*/view_storage_regeneratorRuntime().mark(function _callee4(item) {
                  var child;
                  return view_storage_regeneratorRuntime().wrap(function _callee4$(_context4) {
                    while (1) switch (_context4.prev = _context4.next) {
                      case 0:
                        _context4.next = 2;
                        return _this3.restoreView(item);
                      case 2:
                        child = _context4.sent;
                        if (!(child && view_protocol/* SlotView */.tl.is(view) && savedView.slot)) {
                          _context4.next = 6;
                          break;
                        }
                        _context4.next = 6;
                        return _this3.slotViewManager.addView(child, savedView.slot, item.openOption);
                      case 6:
                      case "end":
                        return _context4.stop();
                    }
                  }, _callee4);
                }));
                return function (_x3) {
                  return _ref2.apply(this, arguments);
                };
              }()));
            case 13:
              if (view_protocol/* StatefulView */.sh.is(view)) {
                view.restoreState(state);
              }
              if (!view_protocol/* SlotView */.tl.is(view)) {
                this.restoreCount += 1;
              }
              return _context5.abrupt("return", view);
            case 18:
              _context5.prev = 18;
              _context5.t0 = _context5["catch"](1);
              return _context5.abrupt("return", undefined);
            case 21:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this, [[1, 18]]);
      }));
      function restoreView(_x) {
        return _restoreView.apply(this, arguments);
      }
      return restoreView;
    }()
  }]);
  return ViewStorage;
}(), (view_storage_descriptor = view_storage_applyDecoratedDescriptor(view_storage_class2.prototype, "shouldStoreViews", [view_storage_dec2], {
  configurable: true,
  enumerable: true,
  writable: true,
  initializer: function initializer() {
    return false;
  }
})), view_storage_class2)) || view_storage_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/view-application.js
function view_application_typeof(o) { "@babel/helpers - typeof"; return view_application_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, view_application_typeof(o); }
var view_application_dec, view_application_class;
function view_application_createForOfIteratorHelper(o, allowArrayLike) { var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"]; if (!it) { if (Array.isArray(o) || (it = view_application_unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = it.call(o); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it.return != null) it.return(); } finally { if (didErr) throw err; } } }; }
function view_application_unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return view_application_arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return view_application_arrayLikeToArray(o, minLen); }
function view_application_arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }
function view_application_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ view_application_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == view_application_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(view_application_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function view_application_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function view_application_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { view_application_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { view_application_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function view_application_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function view_application_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, view_application_toPropertyKey(descriptor.key), descriptor); } }
function view_application_createClass(Constructor, protoProps, staticProps) { if (protoProps) view_application_defineProperties(Constructor.prototype, protoProps); if (staticProps) view_application_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function view_application_toPropertyKey(t) { var i = view_application_toPrimitive(t, "string"); return "symbol" == view_application_typeof(i) ? i : String(i); }
function view_application_toPrimitive(t, r) { if ("object" != view_application_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != view_application_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






var ViewApplication = (view_application_dec = (0,mana_syringe_es/* singleton */.ri)({
  contrib: application_application/* ApplicationContribution */.rS
}), view_application_dec(view_application_class = /*#__PURE__*/function () {
  function ViewApplication(viewManager, slotViewManager, viewStorage) {
    view_application_classCallCheck(this, ViewApplication);
    this.viewManager = viewManager;
    this.slotViewManager = slotViewManager;
    this.viewStorage = viewStorage;
  }
  ViewApplication = (0,mana_syringe_es/* inject */.f3)(ViewStorage)(ViewApplication, undefined, 2) || ViewApplication;
  ViewApplication = (0,mana_syringe_es/* inject */.f3)(slot_view_manager/* SlotViewManager */.I)(ViewApplication, undefined, 1) || ViewApplication;
  ViewApplication = (0,mana_syringe_es/* inject */.f3)(view_manager/* ViewManager */.v)(ViewApplication, undefined, 0) || ViewApplication;
  view_application_createClass(ViewApplication, [{
    key: "onStart",
    value: function () {
      var _onStart = view_application_asyncToGenerator( /*#__PURE__*/view_application_regeneratorRuntime().mark(function _callee() {
        var rootView;
        return view_application_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.viewManager.getOrCreateView(view_protocol/* RootViewId */.ar);
            case 2:
              rootView = _context.sent;
              this.viewManager.root = rootView;
            case 4:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function onStart() {
        return _onStart.apply(this, arguments);
      }
      return onStart;
    }()
  }, {
    key: "onViewStart",
    value: function () {
      var _onViewStart = view_application_asyncToGenerator( /*#__PURE__*/view_application_regeneratorRuntime().mark(function _callee2() {
        var view;
        return view_application_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return this.tryRestoreView();
            case 2:
              view = _context2.sent;
              if (!view || this.viewStorage.onlyRootView) {
                this.initView();
              }
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function onViewStart() {
        return _onViewStart.apply(this, arguments);
      }
      return onViewStart;
    }()
  }, {
    key: "tryRestoreView",
    value: function () {
      var _tryRestoreView = view_application_asyncToGenerator( /*#__PURE__*/view_application_regeneratorRuntime().mark(function _callee3() {
        var savedView;
        return view_application_regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return this.viewStorage.getSavedView();
            case 2:
              savedView = _context3.sent;
              if (!(savedView && this.viewStorage.canStoreView)) {
                _context3.next = 5;
                break;
              }
              return _context3.abrupt("return", !!this.viewStorage.restoreView(savedView));
            case 5:
              return _context3.abrupt("return", false);
            case 6:
            case "end":
              return _context3.stop();
          }
        }, _callee3, this);
      }));
      function tryRestoreView() {
        return _tryRestoreView.apply(this, arguments);
      }
      return tryRestoreView;
    }()
  }, {
    key: "initView",
    value: function initView() {
      var preferenceMap = this.viewManager.getPreferenceMap();
      var _iterator = view_application_createForOfIteratorHelper(preferenceMap.keys()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var factoryId = _step.value;
          var preference = preferenceMap.get(factoryId);
          if (preference && preference.autoCreate) {
            this.doCreateView(factoryId, preference);
          }
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }
  }, {
    key: "onWillStop",
    value: function onWillStop() {
      if (this.viewStorage.canStoreView) {
        this.viewStorage.saveViews();
      }
      return true;
    }
  }, {
    key: "doCreateView",
    value: function () {
      var _doCreateView = view_application_asyncToGenerator( /*#__PURE__*/view_application_regeneratorRuntime().mark(function _callee4(factoryId, preference) {
        var view;
        return view_application_regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              _context4.next = 2;
              return this.viewManager.getOrCreateView(factoryId, preference.options);
            case 2:
              view = _context4.sent;
              if (!preference.slot) {
                _context4.next = 6;
                break;
              }
              _context4.next = 6;
              return this.slotViewManager.addView(view, preference.slot, preference.openOptions);
            case 6:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function doCreateView(_x, _x2) {
        return _doCreateView.apply(this, arguments);
      }
      return doCreateView;
    }()
  }]);
  return ViewApplication;
}()) || view_application_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/view-open-handler.js
function view_open_handler_typeof(o) { "@babel/helpers - typeof"; return view_open_handler_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, view_open_handler_typeof(o); }
var _excluded = ["slot"];
var view_open_handler_dec, view_open_handler_dec2, view_open_handler_class, view_open_handler_class2;
function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }
function view_open_handler_regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ view_open_handler_regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == view_open_handler_typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw new Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(view_open_handler_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw new Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function view_open_handler_asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }
function view_open_handler_asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { view_open_handler_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { view_open_handler_asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }
function view_open_handler_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function view_open_handler_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, view_open_handler_toPropertyKey(descriptor.key), descriptor); } }
function view_open_handler_createClass(Constructor, protoProps, staticProps) { if (protoProps) view_open_handler_defineProperties(Constructor.prototype, protoProps); if (staticProps) view_open_handler_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function view_open_handler_toPropertyKey(t) { var i = view_open_handler_toPrimitive(t, "string"); return "symbol" == view_open_handler_typeof(i) ? i : String(i); }
function view_open_handler_toPrimitive(t, r) { if ("object" != view_open_handler_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != view_open_handler_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function view_open_handler_applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }





/**
 * Generic base class for {@link OpenHandler}s that are opening a View for a given {@link URI}.
 */
var ViewOpenHandler = (view_open_handler_dec = (0,mana_syringe_es/* singleton */.ri)(), view_open_handler_dec2 = (0,mana_syringe_es/* postConstruct */.zY)(), view_open_handler_dec(view_open_handler_class = (view_open_handler_class2 = /*#__PURE__*/function () {
  function ViewOpenHandler(viewManager, slotViewManager) {
    view_open_handler_classCallCheck(this, ViewOpenHandler);
    this.onCreatedEmitter = new es_event/* Emitter */.Q5();
    /**
     * Emit when a new View is created.
     */
    this.onCreated = this.onCreatedEmitter.event;
    this.viewManager = viewManager;
    this.slotViewManager = slotViewManager;
  }
  ViewOpenHandler = (0,mana_syringe_es/* inject */.f3)(slot_view_manager/* SlotViewManager */.I)(ViewOpenHandler, undefined, 1) || ViewOpenHandler;
  ViewOpenHandler = (0,mana_syringe_es/* inject */.f3)(view_manager/* ViewManager */.v)(ViewOpenHandler, undefined, 0) || ViewOpenHandler;
  view_open_handler_createClass(ViewOpenHandler, [{
    key: "init",
    value: function init() {
      var _this = this;
      this.viewManager.onDidCreateView(function (_ref) {
        var factoryId = _ref.factoryId,
          view = _ref.view;
        if (factoryId === _this.id) {
          _this.onCreatedEmitter.fire(view);
        }
      });
    }

    /**
     * The view open handler id.
     *
     * #### Implementation
     * - A view factory for this id should be registered.
     */
  }, {
    key: "open",
    value: (
    /**
     * Open a View for the given uri and options.
     * Reject if the given options are not View options or a View cannot be opened.
     * @param uri the uri of the resource that should be opened.
     * @param options the View opener options.
     *
     * @returns promise of the View that resolves when the View has been opened.
     */
    function () {
      var _open = view_open_handler_asyncToGenerator( /*#__PURE__*/view_open_handler_regeneratorRuntime().mark(function _callee(uri, options) {
        var view;
        return view_open_handler_regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return this.getOrCreateView(uri, options);
            case 2:
              view = _context.sent;
              _context.next = 5;
              return this.doOpen(view, options || {});
            case 5:
              return _context.abrupt("return", view);
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee, this);
      }));
      function open(_x, _x2) {
        return _open.apply(this, arguments);
      }
      return open;
    }())
  }, {
    key: "doOpen",
    value: function () {
      var _doOpen = view_open_handler_asyncToGenerator( /*#__PURE__*/view_open_handler_regeneratorRuntime().mark(function _callee2(view, options) {
        var _options$slot, slot, openOption;
        return view_open_handler_regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              // if (!view.isAttached) {
              _options$slot = options.slot, slot = _options$slot === void 0 ? view_protocol/* RootSlotId */.lI : _options$slot, openOption = _objectWithoutProperties(options, _excluded);
              this.slotViewManager.addView(view, slot, openOption);
              // }
            case 2:
            case "end":
              return _context2.stop();
          }
        }, _callee2, this);
      }));
      function doOpen(_x3, _x4) {
        return _doOpen.apply(this, arguments);
      }
      return doOpen;
    }()
    /**
     * Tries to get an existing View for the given uri.
     * @param uri the uri of the View.
     *
     * @returns a promise that resolves to the existing View or `undefined` if no View for the given uri exists.
     */
  }, {
    key: "getByUri",
    value: function getByUri(uri) {
      return this.getView(uri);
    }

    /**
     * Return an existing View for the given uri or creates a new one.
     *
     * It does not open a View, use {@link ViewOpenHandler#open} instead.
     * @param uri uri of the View.
     *
     * @returns a promise of the existing or newly created View.
     */
  }, {
    key: "getOrCreateByUri",
    value: function getOrCreateByUri(uri) {
      return this.getOrCreateView(uri);
    }

    /**
     * Retrieves all open Views that have been opened by this handler.
     *
     * @returns all open Views for this open handler.
     */
  }, {
    key: "all",
    get: function get() {
      var _this2 = this;
      return view_open_handler_asyncToGenerator( /*#__PURE__*/view_open_handler_regeneratorRuntime().mark(function _callee3() {
        return view_open_handler_regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) switch (_context3.prev = _context3.next) {
            case 0:
              _context3.next = 2;
              return _this2.viewManager.getViews(_this2.id);
            case 2:
              return _context3.abrupt("return", _context3.sent);
            case 3:
            case "end":
              return _context3.stop();
          }
        }, _callee3);
      }))();
    }
  }, {
    key: "getView",
    value: function () {
      var _getView = view_open_handler_asyncToGenerator( /*#__PURE__*/view_open_handler_regeneratorRuntime().mark(function _callee4(uri, options) {
        var ViewOptions;
        return view_open_handler_regeneratorRuntime().wrap(function _callee4$(_context4) {
          while (1) switch (_context4.prev = _context4.next) {
            case 0:
              ViewOptions = this.createViewOptions(uri, options);
              return _context4.abrupt("return", this.viewManager.getView(this.id, ViewOptions));
            case 2:
            case "end":
              return _context4.stop();
          }
        }, _callee4, this);
      }));
      function getView(_x5, _x6) {
        return _getView.apply(this, arguments);
      }
      return getView;
    }()
  }, {
    key: "getOrCreateView",
    value: function getOrCreateView(uri, options) {
      var ViewOptions = this.createViewOptions(uri, options);
      return this.viewManager.getOrCreateView(this.id, ViewOptions);
    }
  }, {
    key: "closeAll",
    value: (
    /**
     * Closes all Views that have been opened by this open handler.
     * @param options the close options that should be applied to all Views.
     *
     * @returns a promise of all closed Views that resolves after they have been closed.
     */
    function () {
      var _closeAll = view_open_handler_asyncToGenerator( /*#__PURE__*/view_open_handler_regeneratorRuntime().mark(function _callee5(slot) {
        var _this3 = this;
        var all;
        return view_open_handler_regeneratorRuntime().wrap(function _callee5$(_context5) {
          while (1) switch (_context5.prev = _context5.next) {
            case 0:
              _context5.next = 2;
              return this.all;
            case 2:
              all = _context5.sent;
              return _context5.abrupt("return", Promise.all(all.map(function (view) {
                return _this3.slotViewManager.removeView(view, slot);
              })));
            case 4:
            case "end":
              return _context5.stop();
          }
        }, _callee5, this);
      }));
      function closeAll(_x7) {
        return _closeAll.apply(this, arguments);
      }
      return closeAll;
    }())
  }]);
  return ViewOpenHandler;
}(), (view_open_handler_applyDecoratedDescriptor(view_open_handler_class2.prototype, "init", [view_open_handler_dec2], Object.getOwnPropertyDescriptor(view_open_handler_class2.prototype, "init"), view_open_handler_class2.prototype)), view_open_handler_class2)) || view_open_handler_class);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/module.js












var ViewModule = mana_module/* ManaModule */.R.create().contribution(view_protocol/* ViewFactory */.Pc, view_protocol/* ViewPreferenceContribution */._k, view_protocol/* SlotPreferenceContribution */.sU, OpenHandler).register(root_view/* RootView */.pT, default_slot_view/* DefaultSlotView */.W$, ViewStorage, ViewApplication, slot_view_manager/* SlotViewManager */.I, view_manager/* ViewManager */.v, DefaultOpenerService, ViewOpenHandler)
// register top level ViewInstance
// TODO: remove this when we have a better way to register top level ViewInstance
.register({
  token: view_protocol/* ViewInstance */.yd,
  useValue: {}
}).register({
  token: root_view/* RootComponents */.VH,
  useValue: {}
});
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/components/index.js + 6 modules
var components = __webpack_require__(8743);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/browser.js
var browser = __webpack_require__(78533);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/module/index.js



// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/default-view.js + 1 modules
var default_view = __webpack_require__(89864);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/slot.js
var slot = __webpack_require__(70485);
// EXTERNAL MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/decorator.js
var decorator = __webpack_require__(97754);
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/view-decoration.js
/**
 * Namespace for the decoration data and the styling refinements for the decorated widgets.
 */
var ViewDecoration;
;// CONCATENATED MODULE: ../../node_modules/.pnpm/@difizen+mana-core@0.1.19_react@18.3.1/node_modules/@difizen/mana-core/es/view/navigatable.js
function navigatable_typeof(o) { "@babel/helpers - typeof"; return navigatable_typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, navigatable_typeof(o); }
function navigatable_ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function navigatable_objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? navigatable_ownKeys(Object(t), !0).forEach(function (r) { navigatable_defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : navigatable_ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function navigatable_defineProperty(obj, key, value) { key = navigatable_toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function navigatable_classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }
function navigatable_defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, navigatable_toPropertyKey(descriptor.key), descriptor); } }
function navigatable_createClass(Constructor, protoProps, staticProps) { if (protoProps) navigatable_defineProperties(Constructor.prototype, protoProps); if (staticProps) navigatable_defineProperties(Constructor, staticProps); Object.defineProperty(Constructor, "prototype", { writable: false }); return Constructor; }
function navigatable_toPropertyKey(t) { var i = navigatable_toPrimitive(t, "string"); return "symbol" == navigatable_typeof(i) ? i : String(i); }
function navigatable_toPrimitive(t, r) { if ("object" != navigatable_typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != navigatable_typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function navigatable_inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); Object.defineProperty(subClass, "prototype", { writable: false }); if (superClass) navigatable_setPrototypeOf(subClass, superClass); }
function navigatable_setPrototypeOf(o, p) { navigatable_setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return navigatable_setPrototypeOf(o, p); }
function navigatable_createSuper(Derived) { var hasNativeReflectConstruct = navigatable_isNativeReflectConstruct(); return function _createSuperInternal() { var Super = navigatable_getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = navigatable_getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return navigatable_possibleConstructorReturn(this, result); }; }
function navigatable_possibleCon