"""ob12

Revision ID: f77200370a39
Revises: ee2869aa7c5a
Create Date: 2023-01-19 20:03:34.480753

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy import select
from sqlalchemy.orm import Session

from nonebot_plugin_wordcloud.model import Schedule

# revision identifiers, used by Alembic.
revision = "f77200370a39"
down_revision = "ee2869aa7c5a"
branch_labels = None
depends_on = None


def set_default_platform() -> None:
    """设置默认值为 qq"""
    connection = op.get_bind()
    with Session(connection) as session:
        schedules = session.scalars(select(Schedule)).all()
        for schedule in schedules:
            schedule.platform = "qq"
        session.add_all(schedules)
        session.commit()


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "nonebot_plugin_wordcloud_schedule", schema=None
    ) as batch_op:
        batch_op.add_column(sa.Column("platform", sa.String(32), nullable=True))
        batch_op.add_column(sa.Column("guild_id", sa.String(64), nullable=True))
        batch_op.add_column(sa.Column("channel_id", sa.String(64), nullable=True))
        batch_op.alter_column("group_id", existing_type=sa.String(64), nullable=True)
        batch_op.drop_constraint("unique_schedule", type_="unique")
        batch_op.create_unique_constraint(
            "unique_schedule",
            ["bot_id", "platform", "group_id", "guild_id", "channel_id"],
        )
    set_default_platform()
    with op.batch_alter_table(
        "nonebot_plugin_wordcloud_schedule", schema=None
    ) as batch_op:
        batch_op.alter_column("platform", existing_type=sa.String(32), nullable=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "nonebot_plugin_wordcloud_schedule", schema=None
    ) as batch_op:
        batch_op.drop_constraint("unique_schedule", type_="unique")
        batch_op.create_unique_constraint("unique_schedule", ["bot_id", "group_id"])
        batch_op.alter_column("group_id", existing_type=sa.String(64), nullable=False)
        batch_op.drop_column("channel_id")
        batch_op.drop_column("guild_id")
        batch_op.drop_column("platform")

    # ### end Alembic commands ###
