"""alter not null

Revision ID: f26008eae177
Revises: f77200370a39
Create Date: 2023-03-05 21:19:39.373324

"""
import sqlalchemy as sa
from alembic import op
from sqlalchemy import select
from sqlalchemy.ext.automap import automap_base
from sqlalchemy.orm import Session

# revision identifiers, used by Alembic.
revision = "f26008eae177"
down_revision = "f77200370a39"
branch_labels = None
depends_on = None


def set_default() -> None:
    Base = automap_base()
    Base.prepare(autoload_with=op.get_bind())
    Schedule = Base.classes.nonebot_plugin_wordcloud_schedule
    with Session(op.get_bind()) as session:
        schedules = session.scalars(select(Schedule)).all()
        for schedule in schedules:
            if schedule.group_id is None:
                schedule.group_id = ""
            if schedule.guild_id is None:
                schedule.guild_id = ""
            if schedule.channel_id is None:
                schedule.channel_id = ""
        session.add_all(schedules)
        session.commit()


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    set_default()
    with op.batch_alter_table(
        "nonebot_plugin_wordcloud_schedule", schema=None
    ) as batch_op:
        batch_op.alter_column("group_id", existing_type=sa.String(64), nullable=False)
        batch_op.alter_column("guild_id", existing_type=sa.String(64), nullable=False)
        batch_op.alter_column("channel_id", existing_type=sa.String(64), nullable=False)

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table(
        "nonebot_plugin_wordcloud_schedule", schema=None
    ) as batch_op:
        batch_op.alter_column("channel_id", existing_type=sa.String(64), nullable=True)
        batch_op.alter_column("guild_id", existing_type=sa.String(64), nullable=True)
        batch_op.alter_column("group_id", existing_type=sa.String(64), nullable=True)

    # ### end Alembic commands ###
