# Copyright (C) 2022 CVAT.ai Corporation
#
# SPDX-License-Identifier: MIT

# CVAT REST API
#
# REST API for Computer Vision Annotation Tool (CVAT)  # noqa: E501
#
# The version of the OpenAPI document: 2.1.0
# Contact: support@cvat.ai
# Generated by: https://openapi-generator.tech


from __future__ import annotations

import typing
import urllib3

import re  # noqa: F401

from cvat_sdk.api_client.api_client import ApiClient, Endpoint as _Endpoint
from cvat_sdk.api_client.model_utils import (  # noqa: F401
    date,
    datetime,
    file_type,
    none_type,
)
from cvat_sdk.api_client.model.annotation_file_request import AnnotationFileRequest
from cvat_sdk.api_client.model.annotations_read import AnnotationsRead
from cvat_sdk.api_client.model.data_meta_read import DataMetaRead
from cvat_sdk.api_client.model.issue_read import IssueRead
from cvat_sdk.api_client.model.job_annotations_update_request import JobAnnotationsUpdateRequest
from cvat_sdk.api_client.model.job_read import JobRead
from cvat_sdk.api_client.model.paginated_job_commit_list import PaginatedJobCommitList
from cvat_sdk.api_client.model.paginated_job_read_list import PaginatedJobReadList
from cvat_sdk.api_client.model.patched_job_write_request import PatchedJobWriteRequest
from cvat_sdk.api_client.model.patched_labeled_data_request import PatchedLabeledDataRequest

from typing import TYPE_CHECKING
if TYPE_CHECKING:
    # Enable introspection. Can't work normally due to cyclic imports
    from cvat_sdk.api_client.apis import *
    from cvat_sdk.api_client.models import *


class JobsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client
        self.create_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/annotations/',
                'operation_id': 'create_annotations',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'annotation_file_request',
                    'x_organization',
                    'cloud_storage_id',
                    'filename',
                    'format',
                    'location',
                    'org',
                    'org_id',
                    'use_default_location',
                ],
                'required': [
                    'id',
                    'annotation_file_request',
                ],
                'nullable': [
                ],
                'enum': [
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'annotation_file_request':
                        (AnnotationFileRequest,),
                    'x_organization':
                        (str,),
                    'cloud_storage_id':
                        (float,),
                    'filename':
                        (str,),
                    'format':
                        (str,),
                    'location':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'use_default_location':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'format': 'format',
                    'location': 'location',
                    'org': 'org',
                    'org_id': 'org_id',
                    'use_default_location': 'use_default_location',
                },
                'location_map': {
                    'id': 'path',
                    'annotation_file_request': 'body',
                    'x_organization': 'header',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'format': 'query',
                    'location': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'use_default_location': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )
        self.destroy_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/annotations/',
                'operation_id': 'destroy_annotations',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedJobReadList,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs',
                'operation_id': 'list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'x_organization',
                    'filter',
                    'org',
                    'org_id',
                    'page',
                    'page_size',
                    'search',
                    'sort',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'search':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'org': 'org',
                    'org_id': 'org_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'search': 'search',
                    'sort': 'sort',
                },
                'location_map': {
                    'x_organization': 'header',
                    'filter': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'search': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_commits_endpoint = _Endpoint(
            settings={
                'response_schema': (PaginatedJobCommitList,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/commits',
                'operation_id': 'list_commits',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'filter',
                    'org',
                    'org_id',
                    'page',
                    'page_size',
                    'search',
                    'sort',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'page':
                        (int,),
                    'page_size':
                        (int,),
                    'search':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'org': 'org',
                    'org_id': 'org_id',
                    'page': 'page',
                    'page_size': 'page_size',
                    'search': 'search',
                    'sort': 'sort',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'filter': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'page': 'query',
                    'page_size': 'query',
                    'search': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.list_issues_endpoint = _Endpoint(
            settings={
                'response_schema': ([IssueRead],),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/issues',
                'operation_id': 'list_issues',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'filter',
                    'org',
                    'org_id',
                    'search',
                    'sort',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'filter':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'search':
                        (str,),
                    'sort':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'filter': 'filter',
                    'org': 'org',
                    'org_id': 'org_id',
                    'search': 'search',
                    'sort': 'sort',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'filter': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'search': 'query',
                    'sort': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.partial_update_endpoint = _Endpoint(
            settings={
                'response_schema': (JobRead,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}',
                'operation_id': 'partial_update',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                    'patched_job_write_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'patched_job_write_request':
                        (PatchedJobWriteRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                    'patched_job_write_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )
        self.partial_update_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/annotations/',
                'operation_id': 'partial_update_annotations',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'action',
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                    'patched_labeled_data_request',
                ],
                'required': [
                    'action',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'action',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "CREATE": "create",
                        "DELETE": "delete",
                        "UPDATE": "update"
                    },
                },
                'openapi_types': {
                    'action':
                        (str,),
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'patched_labeled_data_request':
                        (PatchedLabeledDataRequest,),
                },
                'attribute_map': {
                    'action': 'action',
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'action': 'query',
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                    'patched_labeled_data_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )
        self.partial_update_annotations_file_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/annotations/{file_id}',
                'operation_id': 'partial_update_annotations_file',
                'http_method': 'PATCH',
                'servers': None,
            },
            params_map={
                'all': [
                    'file_id',
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                    'body',
                ],
                'required': [
                    'file_id',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                    'file_id',
                ]
            },
            root_map={
                'validations': {
                    ('file_id',): {

                        'regex': {
                            'pattern': r'^\b[0-9a-f]{8}\b-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-\b[0-9a-f]{12}\b$',  # noqa: E501
                        },
                    },
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'file_id':
                        (str,),
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'body':
                        (file_type,),
                },
                'attribute_map': {
                    'file_id': 'file_id',
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'file_id': 'path',
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                    'body': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )
        self.retrieve_endpoint = _Endpoint(
            settings={
                'response_schema': (JobRead,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}',
                'operation_id': 'retrieve',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': (AnnotationsRead,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/annotations/',
                'operation_id': 'retrieve_annotations',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'action',
                    'cloud_storage_id',
                    'filename',
                    'format',
                    'location',
                    'org',
                    'org_id',
                    'use_default_location',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'action',
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "DOWNLOAD": "download"
                    },
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'action':
                        (str,),
                    'cloud_storage_id':
                        (float,),
                    'filename':
                        (str,),
                    'format':
                        (str,),
                    'location':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'use_default_location':
                        (bool,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'action': 'action',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'format': 'format',
                    'location': 'location',
                    'org': 'org',
                    'org_id': 'org_id',
                    'use_default_location': 'use_default_location',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'action': 'query',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'format': 'query',
                    'location': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'use_default_location': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_data_endpoint = _Endpoint(
            settings={
                'response_schema': (file_type,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/data',
                'operation_id': 'retrieve_data',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'number',
                    'org',
                    'org_id',
                    'quality',
                    'type',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'quality',
                    'type',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('quality',): {

                        "COMPRESSED": "compressed",
                        "ORIGINAL": "original"
                    },
                    ('type',): {

                        "CHUNK": "chunk",
                        "CONTEXT_IMAGE": "context_image",
                        "FRAME": "frame",
                        "PREVIEW": "preview"
                    },
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'number':
                        (int,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'quality':
                        (str,),
                    'type':
                        (str,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'number': 'number',
                    'org': 'org',
                    'org_id': 'org_id',
                    'quality': 'quality',
                    'type': 'type',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'number': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'quality': 'query',
                    'type': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_data_meta_endpoint = _Endpoint(
            settings={
                'response_schema': (DataMetaRead,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/data/meta',
                'operation_id': 'retrieve_data_meta',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'org',
                    'org_id',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'org': 'query',
                    'org_id': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.retrieve_dataset_endpoint = _Endpoint(
            settings={
                'response_schema': (file_type,),
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/dataset',
                'operation_id': 'retrieve_dataset',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'format',
                    'id',
                    'x_organization',
                    'action',
                    'cloud_storage_id',
                    'filename',
                    'location',
                    'org',
                    'org_id',
                    'use_default_location',
                ],
                'required': [
                    'format',
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                    'action',
                    'location',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('action',): {

                        "DOWNLOAD": "download"
                    },
                    ('location',): {

                        "CLOUD_STORAGE": "cloud_storage",
                        "LOCAL": "local"
                    },
                },
                'openapi_types': {
                    'format':
                        (str,),
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'action':
                        (str,),
                    'cloud_storage_id':
                        (float,),
                    'filename':
                        (str,),
                    'location':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'use_default_location':
                        (bool,),
                },
                'attribute_map': {
                    'format': 'format',
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'action': 'action',
                    'cloud_storage_id': 'cloud_storage_id',
                    'filename': 'filename',
                    'location': 'location',
                    'org': 'org',
                    'org_id': 'org_id',
                    'use_default_location': 'use_default_location',
                },
                'location_map': {
                    'format': 'query',
                    'id': 'path',
                    'x_organization': 'header',
                    'action': 'query',
                    'cloud_storage_id': 'query',
                    'filename': 'query',
                    'location': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'use_default_location': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/vnd.cvat+json'
                ],
                'content_type': [],
            },
            api_client=api_client
        )
        self.update_annotations_endpoint = _Endpoint(
            settings={
                'response_schema': None,
                'auth': [
                    'SignatureAuthentication',
                    'basicAuth',
                    'cookieAuth',
                    'tokenAuth'
                ],
                'endpoint_path': '/api/jobs/{id}/annotations/',
                'operation_id': 'update_annotations',
                'http_method': 'PUT',
                'servers': None,
            },
            params_map={
                'all': [
                    'id',
                    'x_organization',
                    'format',
                    'org',
                    'org_id',
                    'job_annotations_update_request',
                ],
                'required': [
                    'id',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'id':
                        (int,),
                    'x_organization':
                        (str,),
                    'format':
                        (str,),
                    'org':
                        (str,),
                    'org_id':
                        (int,),
                    'job_annotations_update_request':
                        (JobAnnotationsUpdateRequest,),
                },
                'attribute_map': {
                    'id': 'id',
                    'x_organization': 'X-Organization',
                    'format': 'format',
                    'org': 'org',
                    'org_id': 'org_id',
                },
                'location_map': {
                    'id': 'path',
                    'x_organization': 'header',
                    'format': 'query',
                    'org': 'query',
                    'org_id': 'query',
                    'job_annotations_update_request': 'body',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [],
                'content_type': [
                    'application/json',
                    'application/x-www-form-urlencoded',
                    'multipart/form-data',
                    'application/offset+octet-stream'
                ]
            },
            api_client=api_client
        )

    def create_annotations(
        self,
        id: int,
        annotation_file_request: AnnotationFileRequest,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Method allows to upload job annotations  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.create_annotations(id, annotation_file_request, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.
            annotation_file_request (AnnotationFileRequest):

        Keyword Args:
            x_organization (str): [optional]
            cloud_storage_id (float): Storage id. [optional]
            filename (str): Annotation file name. [optional]
            format (str): Input format name You can get the list of supported formats at: /server/annotation/formats. [optional]
            location (str): where to import the annotation from. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            use_default_location (bool): Use the location that was configured in the task to import annotation. [optional] if omitted the server will use the default value of True
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        kwargs['annotation_file_request'] = annotation_file_request
        return self.create_annotations_endpoint.call_with_http_info(**kwargs)

    def destroy_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Method deletes all annotations for a specific job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.destroy_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.destroy_annotations_endpoint.call_with_http_info(**kwargs)

    def list(
        self,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[PaginatedJobReadList], urllib3.HTTPResponse]:
        """Method returns a paginated list of jobs according to query parameters  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list(_async_call=True)
        >>> result = thread.get()


        Keyword Args:
            x_organization (str): [optional]
            filter (str): A filter term. Avaliable filter_fields: ['task_name', 'project_name', 'assignee', 'state', 'stage', 'id', 'task_id', 'project_id', 'updated_date']. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            search (str): A search term. Avaliable search_fields: ('task_name', 'project_name', 'assignee', 'state', 'stage'). [optional]
            sort (str): Which field to use when ordering the results. Avaliable ordering_fields: ['task_name', 'project_name', 'assignee', 'state', 'stage', 'id', 'task_id', 'project_id', 'updated_date']. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedJobReadList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        return self.list_endpoint.call_with_http_info(**kwargs)

    def list_commits(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[PaginatedJobCommitList], urllib3.HTTPResponse]:
        """The action returns the list of tracked changes for the job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list_commits(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            filter (str): A filter term. Avaliable filter_fields: ['task_name', 'project_name', 'assignee', 'state', 'stage', 'id', 'task_id', 'project_id', 'updated_date']. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            page (int): A page number within the paginated result set.. [optional]
            page_size (int): Number of results to return per page.. [optional]
            search (str): A search term. Avaliable search_fields: ('task_name', 'project_name', 'assignee', 'state', 'stage'). [optional]
            sort (str): Which field to use when ordering the results. Avaliable ordering_fields: ['task_name', 'project_name', 'assignee', 'state', 'stage', 'id', 'task_id', 'project_id', 'updated_date']. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (PaginatedJobCommitList, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.list_commits_endpoint.call_with_http_info(**kwargs)

    def list_issues(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[typing.List[IssueRead]], urllib3.HTTPResponse]:
        """Method returns list of issues for the job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.list_issues(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            filter (str): A filter term. Avaliable filter_fields: None. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            search (str): A search term. Avaliable search_fields: None. [optional]
            sort (str): Which field to use when ordering the results. Avaliable ordering_fields: None. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            ([IssueRead], HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.list_issues_endpoint.call_with_http_info(**kwargs)

    def partial_update(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[JobRead], urllib3.HTTPResponse]:
        """Methods does a partial update of chosen fields in a job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            patched_job_write_request (PatchedJobWriteRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (JobRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.partial_update_endpoint.call_with_http_info(**kwargs)

    def partial_update_annotations(
        self,
        action: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Method performs a partial update of annotations in a specific job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update_annotations(action, id, _async_call=True)
        >>> result = thread.get()

        Args:
            action (str):
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            patched_labeled_data_request (PatchedLabeledDataRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['action'] = action
        kwargs['id'] = id
        return self.partial_update_annotations_endpoint.call_with_http_info(**kwargs)

    def partial_update_annotations_file(
        self,
        file_id: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Allows to upload an annotation file chunk. Implements TUS file uploading protocol.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.partial_update_annotations_file(file_id, id, _async_call=True)
        >>> result = thread.get()

        Args:
            file_id (str):
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            body (file_type): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['file_id'] = file_id
        kwargs['id'] = id
        return self.partial_update_annotations_file_endpoint.call_with_http_info(**kwargs)

    def retrieve(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[JobRead], urllib3.HTTPResponse]:
        """Method returns details of a job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (JobRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_endpoint.call_with_http_info(**kwargs)

    def retrieve_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[AnnotationsRead], urllib3.HTTPResponse]:
        """Method returns annotations for a specific job as a JSON document. If format is specified, a zip archive is returned.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            action (str): Used to start downloading process after annotation file had been created. [optional] if omitted the server will use the default value of "download"
            cloud_storage_id (float): Storage id. [optional]
            filename (str): Desired output file name. [optional]
            format (str): Desired output format name You can get the list of supported formats at: /server/annotation/formats. [optional]
            location (str): Where need to save downloaded annotation. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            use_default_location (bool): Use the location that was configured in the task to export annotation. [optional] if omitted the server will use the default value of True
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (AnnotationsRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_annotations_endpoint.call_with_http_info(**kwargs)

    def retrieve_data(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[file_type], urllib3.HTTPResponse]:
        """Method returns data for a specific job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_data(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            number (int): A unique number value identifying chunk or frame, doesn't matter for 'preview' type. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            quality (str): Specifies the quality level of the requested data, doesn't matter for 'preview' type. [optional]
            type (str): Specifies the type of the requested data. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (file_type, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_data_endpoint.call_with_http_info(**kwargs)

    def retrieve_data_meta(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[DataMetaRead], urllib3.HTTPResponse]:
        """Method provides a meta information about media files which are related with the job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_data_meta(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (DataMetaRead, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.retrieve_data_meta_endpoint.call_with_http_info(**kwargs)

    def retrieve_dataset(
        self,
        format: str,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[file_type], urllib3.HTTPResponse]:
        """Export job as a dataset in a specific format  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.retrieve_dataset(format, id, _async_call=True)
        >>> result = thread.get()

        Args:
            format (str): Desired output format name You can get the list of supported formats at: /server/annotation/formats
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            action (str): Used to start downloading process after annotation file had been created. [optional] if omitted the server will use the default value of "download"
            cloud_storage_id (float): Storage id. [optional]
            filename (str): Desired output file name. [optional]
            location (str): Where need to save downloaded dataset. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            use_default_location (bool): Use the location that was configured in the task to export dataset. [optional] if omitted the server will use the default value of True
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (file_type, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['format'] = format
        kwargs['id'] = id
        return self.retrieve_dataset_endpoint.call_with_http_info(**kwargs)

    def update_annotations(
        self,
        id: int,
        *,
        _parse_response: bool = True,
        _request_timeout: typing.Union[int, float, tuple] = None,
        _validate_inputs: bool = True,
        _validate_outputs: bool = True,
        _check_status: bool = True,
        _spec_property_naming: bool = False,
        _content_type: typing.Optional[str] = None,
        _host_index: typing.Optional[int] = None,
        _request_auths: typing.Optional[typing.List] = None,
        _async_call: bool = False,
        **kwargs,
    ) -> typing.Tuple[typing.Optional[None], urllib3.HTTPResponse]:
        """Method performs an update of all annotations in a specific job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass _async_call=True

        >>> thread = api.update_annotations(id, _async_call=True)
        >>> result = thread.get()

        Args:
            id (int): A unique integer value identifying this job.

        Keyword Args:
            x_organization (str): [optional]
            format (str): Input format name You can get the list of supported formats at: /server/annotation/formats. [optional]
            org (str): Organization unique slug. [optional]
            org_id (int): Organization identifier. [optional]
            job_annotations_update_request (JobAnnotationsUpdateRequest): [optional]
            _parse_response (bool): if False, the response data will not be parsed,
                None is returned for data.
                Default is True.
            _request_timeout (int/float/tuple): timeout setting for this request. If
                one number provided, it will be total request timeout. It can also
                be a pair (tuple) of (connection, read) timeouts.
                Default is None.
            _validate_inputs (bool): specifies if type checking
                should be done one the data sent to the server.
                Default is True.
            _validate_outputs (bool): specifies if type checking
                should be done one the data received from the server.
                Default is True.
            _check_status (bool): whether to check response status
                for being positive or not.
                Default is True
            _spec_property_naming (bool): True if the variable names in the input data
                are serialized names, as specified in the OpenAPI document.
                False if the variable names in the input data
                are pythonic names, e.g. snake case (default)
            _content_type (str/None): force body content-type.
                Default is None and content-type will be predicted by allowed
                content-types and body.
            _host_index (int/None): specifies the index of the server
                that we want to use.
                Default is read from the configuration.
            _request_auths (list): set to override the auth_settings for an a single
                request; this effectively ignores the authentication
                in the spec for a single request.
                Default is None
            _async_call (bool): execute request asynchronously

        Returns:
            (None, HTTPResponse)
                If the method is called asynchronously, returns the request
                thread.
        """
        kwargs['_async_call'] = _async_call
        kwargs['_parse_response'] = _parse_response
        kwargs['_request_timeout'] = _request_timeout
        kwargs['_validate_inputs'] = _validate_inputs
        kwargs['_validate_outputs'] = _validate_outputs
        kwargs['_check_status'] = _check_status
        kwargs['_spec_property_naming'] = _spec_property_naming
        kwargs['_content_type'] = _content_type
        kwargs['_host_index'] = _host_index
        kwargs['_request_auths'] = _request_auths
        kwargs['id'] = id
        return self.update_annotations_endpoint.call_with_http_info(**kwargs)

