# cvat_sdk
REST API for Computer Vision Annotation Tool (CVAT)

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.1.0
- Package version: 2.0-alpha
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/cvat-ai/cvat](https://github.com/cvat-ai/cvat)

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import cvat_sdk.api_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cvat_sdk.api_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

API includes 2 layers:
- REST API wrappers (`ApiClient`). Located in at `cvat_sdk.api_client`
- high-level tools (`core`). Located at `cvat_sdk.core`

### `ApiClient` (low level)

This layer is useful if you need to work directly with REST API, but want
to have data validation and syntax assistance from your code editor. The code
on this layer is autogenerated.

#### Example

Let's see how a task with local files can be created. We will use the basic auth
to make things simpler.

```python
from time import sleep
from cvat_sdk.api_client import Configuration, ApiClient, models, apis, exceptions

configuration = Configuration(
    host="http://localhost",
    username='YOUR_USERNAME',
    password='YOUR_PASSWORD',
)

# Enter a context with an instance of the API client
with ApiClient(configuration) as api_client:
    # Parameters can be passed as a plain dict with JSON-serialized data
    # or as model objects (from cvat_sdk.api_client.models), including
    # mixed variants.
    #
    # In case of dicts, keys must be the same as members of models.I<ModelName>
    # interfaces and values must be convertible to the corresponding member
    # value types (e.g. a date or string enum value can be parsed from a string).
    #
    # In case of model objects, data must be of the corresponding
    # models.<ModelName> types.
    #
    # Let's use a dict here. It should look like models.ITaskWriteRequest
    task_spec = {
        'name': 'example task',
        "labels": [{
            "name": "car",
            "color": "#ff00ff",
            "attributes": [
                {
                    "name": "a",
                    "mutable": True,
                    "input_type": "number",
                    "default_value": "5",
                    "values": ["4", "5", "6"]
                }
            ]
        }],
    }

    try:
        # Apis can be accessed as ApiClient class members
        # We use different models for input and output data. For input data,
        # models are typically called like "*Request". Output data models have
        # no suffix.
        (task, response) = api_client.tasks_api.create(task_spec)
    except exceptions.ApiException as e:
        # We can catch the basic exception type, or a derived type
        print("Exception when trying to create a task: %s\n" % e)

    # Here we will use models instead of a dict
    task_data = models.DataRequest(
        image_quality=75,
        start_frame=2,
        stop_frame=5,
        client_files=[
            open('image1.jpg', 'rb'),
            open('image2.jpg', 'rb'),
        ],
    )

    # If we pass binary file objects, we need to specify content type.
    # For this endpoint, we don't have response data
    (_, response) = api_client.tasks_api.create_data(task.id,
        data_request=task_data,
        _content_type="multipart/form-data",

        # we can choose to check the response status manually
        # and disable the response data parsing
        _check_status=False, _parse_response=False
    )
    assert response.status == 202, response.msg

    # Wait till task data is processed
    for _ in range(100):
        (status, _) = api_client.tasks_api.retrieve_status(task.id)
        if status.state.value in ['Finished', 'Failed']:
            break
        sleep(0.1)
    assert status.state.value == 'Finished', status.message

    # Update the task object and check the task size
    (task, _) = api_client.tasks_api.retrieve(task.id)
    assert task.size == 4
```

### `Core` (high-level)

This layer provides high-level APIs, allowing easier access to server operations.
API includes *Repositories* and *Entities*. Repositories provide management
operations for Entitites. Entitites represent separate objects on the server
(e.g. tasks, jobs etc).

#### Example

```python
from cvat_sdk import make_client, models
from cvat_sdk.core.proxies.tasks import ResourceType, Task

with make_client(host="http://localhost") as client:
    # Authorize using the basic auth
    client.login(('YOUR_USERNAME', 'YOUR_PASSWORD'))

    # Models are used the same way as in the layer 1
    task_spec = {
        "name": "example task 2",
        "labels": [
            {
                "name": "car",
                "color": "#ff00ff",
                "attributes": [
                    {
                        "name": "a",
                        "mutable": True,
                        "input_type": "number",
                        "default_value": "5",
                        "values": ["4", "5", "6"],
                    }
                ],
            }
        ],
    }

    # Different repositories can be accessed as the Client class members.
    # They may provide both simple and complex operations,
    # such as entity creation, retrieval and removal.
    task = client.tasks.create_from_data(
        spec=task_spec,
        resource_type=ResourceType.LOCAL,
        resources=['image1.jpg', 'image2.png'],
    )

    # Task object is already up-to-date with its server counterpart
    assert task.size == 2

    # An entity needs to be fetch()-ed to reflect the latest changes.
    # It can be update()-d and remove()-d depending on the entity type.
    task.update({'name': 'mytask'})
    task.remove()
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthApi* | **auth_create_login** | **POST** /api/auth/login | 
*AuthApi* | **auth_create_logout** | **POST** /api/auth/logout | 
*AuthApi* | **auth_create_password_change** | **POST** /api/auth/password/change | 
*AuthApi* | **auth_create_password_reset** | **POST** /api/auth/password/reset | 
*AuthApi* | **auth_create_password_reset_confirm** | **POST** /api/auth/password/reset/confirm | 
*AuthApi* | **auth_create_register** | **POST** /api/auth/register | 
*AuthApi* | **auth_create_signing** | **POST** /api/auth/signing | This method signs URL for access to the server
*CloudstoragesApi* | **cloudstorages_create** | **POST** /api/cloudstorages | Method creates a cloud storage with a specified characteristics
*CloudstoragesApi* | **cloudstorages_destroy** | **DELETE** /api/cloudstorages/{id} | Method deletes a specific cloud storage
*CloudstoragesApi* | **cloudstorages_list** | **GET** /api/cloudstorages | Returns a paginated list of storages according to query parameters
*CloudstoragesApi* | **cloudstorages_partial_update** | **PATCH** /api/cloudstorages/{id} | Methods does a partial update of chosen fields in a cloud storage instance
*CloudstoragesApi* | **cloudstorages_retrieve** | **GET** /api/cloudstorages/{id} | Method returns details of a specific cloud storage
*CloudstoragesApi* | **cloudstorages_retrieve_actions** | **GET** /api/cloudstorages/{id}/actions | Method returns allowed actions for the cloud storage
*CloudstoragesApi* | **cloudstorages_retrieve_content** | **GET** /api/cloudstorages/{id}/content | Method returns a manifest content
*CloudstoragesApi* | **cloudstorages_retrieve_preview** | **GET** /api/cloudstorages/{id}/preview | Method returns a preview image from a cloud storage
*CloudstoragesApi* | **cloudstorages_retrieve_status** | **GET** /api/cloudstorages/{id}/status | Method returns a cloud storage status
*CommentsApi* | **comments_create** | **POST** /api/comments | Method creates a comment
*CommentsApi* | **comments_destroy** | **DELETE** /api/comments/{id} | Method deletes a comment
*CommentsApi* | **comments_list** | **GET** /api/comments | Method returns a paginated list of comments according to query parameters
*CommentsApi* | **comments_partial_update** | **PATCH** /api/comments/{id} | Methods does a partial update of chosen fields in a comment
*CommentsApi* | **comments_retrieve** | **GET** /api/comments/{id} | Method returns details of a comment
*InvitationsApi* | **invitations_create** | **POST** /api/invitations | Method creates an invitation
*InvitationsApi* | **invitations_destroy** | **DELETE** /api/invitations/{key} | Method deletes an invitation
*InvitationsApi* | **invitations_list** | **GET** /api/invitations | Method returns a paginated list of invitations according to query parameters
*InvitationsApi* | **invitations_partial_update** | **PATCH** /api/invitations/{key} | Methods does a partial update of chosen fields in an invitation
*InvitationsApi* | **invitations_retrieve** | **GET** /api/invitations/{key} | Method returns details of an invitation
*IssuesApi* | **issues_create** | **POST** /api/issues | Method creates an issue
*IssuesApi* | **issues_destroy** | **DELETE** /api/issues/{id} | Method deletes an issue
*IssuesApi* | **issues_list** | **GET** /api/issues | Method returns a paginated list of issues according to query parameters
*IssuesApi* | **issues_list_comments** | **GET** /api/issues/{id}/comments | The action returns all comments of a specific issue
*IssuesApi* | **issues_partial_update** | **PATCH** /api/issues/{id} | Methods does a partial update of chosen fields in an issue
*IssuesApi* | **issues_retrieve** | **GET** /api/issues/{id} | Method returns details of an issue
*JobsApi* | **jobs_create_annotations** | **POST** /api/jobs/{id}/annotations/ | Method allows to upload job annotations
*JobsApi* | **jobs_destroy_annotations** | **DELETE** /api/jobs/{id}/annotations/ | Method deletes all annotations for a specific job
*JobsApi* | **jobs_list** | **GET** /api/jobs | Method returns a paginated list of jobs according to query parameters
*JobsApi* | **jobs_list_commits** | **GET** /api/jobs/{id}/commits | The action returns the list of tracked changes for the job
*JobsApi* | **jobs_list_issues** | **GET** /api/jobs/{id}/issues | Method returns list of issues for the job
*JobsApi* | **jobs_partial_update** | **PATCH** /api/jobs/{id} | Methods does a partial update of chosen fields in a job
*JobsApi* | **jobs_partial_update_annotations** | **PATCH** /api/jobs/{id}/annotations/ | Method performs a partial update of annotations in a specific job
*JobsApi* | **jobs_partial_update_annotations_file** | **PATCH** /api/jobs/{id}/annotations/{file_id} | Allows to upload an annotation file chunk. Implements TUS file uploading protocol.
*JobsApi* | **jobs_retrieve** | **GET** /api/jobs/{id} | Method returns details of a job
*JobsApi* | **jobs_retrieve_annotations** | **GET** /api/jobs/{id}/annotations/ | Method returns annotations for a specific job as a JSON document. If format is specified, a zip archive is returned.
*JobsApi* | **jobs_retrieve_data** | **GET** /api/jobs/{id}/data | Method returns data for a specific job
*JobsApi* | **jobs_retrieve_data_meta** | **GET** /api/jobs/{id}/data/meta | Method provides a meta information about media files which are related with the job
*JobsApi* | **jobs_retrieve_dataset** | **GET** /api/jobs/{id}/dataset | Export job as a dataset in a specific format
*JobsApi* | **jobs_update_annotations** | **PUT** /api/jobs/{id}/annotations/ | Method performs an update of all annotations in a specific job
*LambdaApi* | **lambda_create_functions** | **POST** /api/lambda/functions/{func_id} | 
*LambdaApi* | **lambda_create_requests** | **POST** /api/lambda/requests | Method calls the function
*LambdaApi* | **lambda_list_functions** | **GET** /api/lambda/functions | Method returns a list of functions
*LambdaApi* | **lambda_list_requests** | **GET** /api/lambda/requests | Method returns a list of requests
*LambdaApi* | **lambda_retrieve_functions** | **GET** /api/lambda/functions/{func_id} | Method returns the information about the function
*LambdaApi* | **lambda_retrieve_requests** | **GET** /api/lambda/requests/{id} | Method returns the status of the request
*MembershipsApi* | **memberships_destroy** | **DELETE** /api/memberships/{id} | Method deletes a membership
*MembershipsApi* | **memberships_list** | **GET** /api/memberships | Method returns a paginated list of memberships according to query parameters
*MembershipsApi* | **memberships_partial_update** | **PATCH** /api/memberships/{id} | Methods does a partial update of chosen fields in a membership
*MembershipsApi* | **memberships_retrieve** | **GET** /api/memberships/{id} | Method returns details of a membership
*OrganizationsApi* | **organizations_create** | **POST** /api/organizations | Method creates an organization
*OrganizationsApi* | **organizations_destroy** | **DELETE** /api/organizations/{id} | Method deletes an organization
*OrganizationsApi* | **organizations_list** | **GET** /api/organizations | Method returns a paginated list of organizatins according to query parameters
*OrganizationsApi* | **organizations_partial_update** | **PATCH** /api/organizations/{id} | Methods does a partial update of chosen fields in an organization
*OrganizationsApi* | **organizations_retrieve** | **GET** /api/organizations/{id} | Method returns details of an organization
*ProjectsApi* | **projects_create** | **POST** /api/projects | Method creates a new project
*ProjectsApi* | **projects_create_backup** | **POST** /api/projects/backup/ | Methods create a project from a backup
*ProjectsApi* | **projects_create_dataset** | **POST** /api/projects/{id}/dataset/ | Import dataset in specific format as a project
*ProjectsApi* | **projects_destroy** | **DELETE** /api/projects/{id} | Method deletes a specific project
*ProjectsApi* | **projects_list** | **GET** /api/projects | Returns a paginated list of projects according to query parameters (12 projects per page)
*ProjectsApi* | **projects_list_tasks** | **GET** /api/projects/{id}/tasks | Method returns information of the tasks of the project with the selected id
*ProjectsApi* | **projects_partial_update** | **PATCH** /api/projects/{id} | Methods does a partial update of chosen fields in a project
*ProjectsApi* | **projects_partial_update_backup_file** | **PATCH** /api/projects/backup/{file_id} | Allows to upload a file chunk. Implements TUS file uploading protocol.
*ProjectsApi* | **projects_partial_update_dataset_file** | **PATCH** /api/projects/{id}/dataset/{file_id} | Allows to upload a file chunk. Implements TUS file uploading protocol.
*ProjectsApi* | **projects_retrieve** | **GET** /api/projects/{id} | Method returns details of a specific project
*ProjectsApi* | **projects_retrieve_annotations** | **GET** /api/projects/{id}/annotations | Method allows to download project annotations
*ProjectsApi* | **projects_retrieve_backup** | **GET** /api/projects/{id}/backup | Methods creates a backup copy of a project
*ProjectsApi* | **projects_retrieve_dataset** | **GET** /api/projects/{id}/dataset/ | Export project as a dataset in a specific format
*RestrictionsApi* | **restrictions_retrieve_terms_of_use** | **GET** /api/restrictions/terms-of-use | Method provides CVAT terms of use
*RestrictionsApi* | **restrictions_retrieve_user_agreements** | **GET** /api/restrictions/user-agreements | Method provides user agreements that the user must accept to register
*SchemaApi* | **schema_retrieve** | **GET** /api/schema/ | 
*ServerApi* | **server_create_exception** | **POST** /api/server/exception | Method saves an exception from a client on the server
*ServerApi* | **server_create_logs** | **POST** /api/server/logs | Method saves logs from a client on the server
*ServerApi* | **server_list_share** | **GET** /api/server/share | Returns all files and folders that are on the server along specified path
*ServerApi* | **server_retrieve_about** | **GET** /api/server/about | Method provides basic CVAT information
*ServerApi* | **server_retrieve_annotation_formats** | **GET** /api/server/annotation/formats | Method provides the list of supported annotations formats
*ServerApi* | **server_retrieve_plugins** | **GET** /api/server/plugins | Method provides allowed plugins
*TasksApi* | **jobs_partial_update_data_meta** | **PATCH** /api/jobs/{id}/data/meta | Method provides a meta information about media files which are related with the job
*TasksApi* | **tasks_create** | **POST** /api/tasks | Method creates a new task in a database without any attached images and videos
*TasksApi* | **tasks_create_annotations** | **POST** /api/tasks/{id}/annotations/ | Method allows to upload task annotations from a local file or a cloud storage
*TasksApi* | **tasks_create_backup** | **POST** /api/tasks/backup/ | Method recreates a task from an attached task backup file
*TasksApi* | **tasks_create_data** | **POST** /api/tasks/{id}/data/ | Method permanently attaches images or video to a task. Supports tus uploads, see more https://tus.io/
*TasksApi* | **tasks_destroy** | **DELETE** /api/tasks/{id} | Method deletes a specific task, all attached jobs, annotations, and data
*TasksApi* | **tasks_destroy_annotations** | **DELETE** /api/tasks/{id}/annotations/ | Method deletes all annotations for a specific task
*TasksApi* | **tasks_list** | **GET** /api/tasks | Returns a paginated list of tasks according to query parameters (10 tasks per page)
*TasksApi* | **tasks_list_jobs** | **GET** /api/tasks/{id}/jobs | Method returns a list of jobs for a specific task
*TasksApi* | **tasks_partial_update** | **PATCH** /api/tasks/{id} | Methods does a partial update of chosen fields in a task
*TasksApi* | **tasks_partial_update_annotations** | **PATCH** /api/tasks/{id}/annotations/ | Method performs a partial update of annotations in a specific task
*TasksApi* | **tasks_partial_update_annotations_file** | **PATCH** /api/tasks/{id}/annotations/{file_id} | Allows to upload an annotation file chunk. Implements TUS file uploading protocol.
*TasksApi* | **tasks_partial_update_backup_file** | **PATCH** /api/tasks/backup/{file_id} | Allows to upload a file chunk. Implements TUS file uploading protocol.
*TasksApi* | **tasks_partial_update_data_file** | **PATCH** /api/tasks/{id}/data/{file_id} | Allows to upload a file chunk. Implements TUS file uploading protocol.
*TasksApi* | **tasks_partial_update_data_meta** | **PATCH** /api/tasks/{id}/data/meta | Method provides a meta information about media files which are related with the task
*TasksApi* | **tasks_retrieve** | **GET** /api/tasks/{id} | Method returns details of a specific task
*TasksApi* | **tasks_retrieve_annotations** | **GET** /api/tasks/{id}/annotations/ | Method allows to download task annotations
*TasksApi* | **tasks_retrieve_backup** | **GET** /api/tasks/{id}/backup | Method backup a specified task
*TasksApi* | **tasks_retrieve_data** | **GET** /api/tasks/{id}/data/ | Method returns data for a specific task
*TasksApi* | **tasks_retrieve_data_meta** | **GET** /api/tasks/{id}/data/meta | Method provides a meta information about media files which are related with the task
*TasksApi* | **tasks_retrieve_dataset** | **GET** /api/tasks/{id}/dataset | Export task as a dataset in a specific format
*TasksApi* | **tasks_retrieve_status** | **GET** /api/tasks/{id}/status | When task is being created the method returns information about a status of the creation process
*TasksApi* | **tasks_update_annotations** | **PUT** /api/tasks/{id}/annotations/ | Method allows to upload task annotations
*UsersApi* | **users_destroy** | **DELETE** /api/users/{id} | Method deletes a specific user from the server
*UsersApi* | **users_list** | **GET** /api/users | Method provides a paginated list of users registered on the server
*UsersApi* | **users_partial_update** | **PATCH** /api/users/{id} | Method updates chosen fields of a user
*UsersApi* | **users_retrieve** | **GET** /api/users/{id} | Method provides information of a specific user
*UsersApi* | **users_retrieve_self** | **GET** /api/users/self | Method returns an instance of a user who is currently authorized


## Documentation For Models

 - About
 - AnnotationFileRequest
 - AnnotationsRead
 - Attribute
 - AttributeRequest
 - AttributeVal
 - AttributeValRequest
 - BackupWriteRequest
 - BasicUser
 - BasicUserRequest
 - ChunkType
 - CloudStorageRead
 - CloudStorageWriteRequest
 - CommentRead
 - CommentReadOwner
 - CommentWriteRequest
 - CredentialsTypeEnum
 - DataMetaRead
 - DataRequest
 - DatasetFileRequest
 - DatasetFormat
 - DatasetFormats
 - DatasetWriteRequest
 - Exception
 - ExceptionRequest
 - FileInfo
 - FileInfoTypeEnum
 - FrameMeta
 - InputTypeEnum
 - InvitationRead
 - InvitationWrite
 - InvitationWriteRequest
 - IssueRead
 - IssueWriteRequest
 - JobAnnotationsUpdateRequest
 - JobCommit
 - JobRead
 - JobStage
 - JobStatus
 - Label
 - LabeledData
 - LabeledDataRequest
 - LabeledImage
 - LabeledImageRequest
 - LabeledShape
 - LabeledShapeRequest
 - LabeledTrack
 - LabeledTrackRequest
 - LocationEnum
 - LogEvent
 - LogEventRequest
 - LoginRequest
 - Manifest
 - ManifestRequest
 - MembershipRead
 - MembershipWrite
 - MetaUser
 - OperationStatus
 - OrganizationRead
 - OrganizationWrite
 - OrganizationWriteRequest
 - PaginatedCloudStorageReadList
 - PaginatedCommentReadList
 - PaginatedInvitationReadList
 - PaginatedIssueReadList
 - PaginatedJobCommitList
 - PaginatedJobReadList
 - PaginatedMembershipReadList
 - PaginatedMetaUserList
 - PaginatedPolymorphicProjectList
 - PaginatedTaskReadList
 - PasswordChangeRequest
 - PasswordResetConfirmRequest
 - PasswordResetSerializerExRequest
 - PatchedCloudStorageWriteRequest
 - PatchedCommentWriteRequest
 - PatchedDataMetaWriteRequest
 - PatchedInvitationWriteRequest
 - PatchedIssueWriteRequest
 - PatchedJobWriteRequest
 - PatchedLabelRequest
 - PatchedLabeledDataRequest
 - PatchedMembershipWriteRequest
 - PatchedOrganizationWriteRequest
 - PatchedProjectWriteRequest
 - PatchedProjectWriteRequestTargetStorage
 - PatchedTaskWriteRequest
 - PatchedTaskWriteRequestTargetStorage
 - PatchedUserRequest
 - Plugins
 - PolymorphicProject
 - ProjectFileRequest
 - ProjectRead
 - ProjectReadAssignee
 - ProjectReadOwner
 - ProjectReadTargetStorage
 - ProjectSearch
 - ProjectWriteRequest
 - ProviderTypeEnum
 - RestAuthDetail
 - RestrictedRegister
 - RestrictedRegisterRequest
 - RoleEnum
 - RqStatus
 - RqStatusStateEnum
 - Segment
 - ShapeType
 - SigningRequest
 - SimpleJob
 - SortingMethod
 - Storage
 - StorageMethod
 - StorageRequest
 - StorageType
 - SubLabeledShape
 - SubLabeledShapeRequest
 - SubLabeledTrack
 - SubLabeledTrackRequest
 - Sublabel
 - SublabelRequest
 - TaskAnnotationsUpdateRequest
 - TaskAnnotationsWriteRequest
 - TaskFileRequest
 - TaskRead
 - TaskReadTargetStorage
 - TaskWriteRequest
 - Token
 - TrackedShape
 - TrackedShapeRequest
 - User
 - UserAgreement
 - UserAgreementRequest



## Author

support@cvat.ai


