# coding: utf-8

"""
    cloudFPGA Resource Manager API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ProjectsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cf_manager_rest_api_get_project_quota(self, username, password, project_name, **kwargs):  # noqa: E501
        """Get the current quota of a project  # noqa: E501

        With this call a user can check how many FPGAs of his project are available for usage.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_project_quota(username, password, project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of a OpenStack project (required)
        :return: Quota
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_project_quota_with_http_info(username, password, project_name, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_project_quota_with_http_info(username, password, project_name, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_project_quota_with_http_info(self, username, password, project_name, **kwargs):  # noqa: E501
        """Get the current quota of a project  # noqa: E501

        With this call a user can check how many FPGAs of his project are available for usage.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_project_quota_with_http_info(username, password, project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of a OpenStack project (required)
        :return: Quota
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'project_name']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_project_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_project_quota`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_project_quota`")  # noqa: E501
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `cf_manager_rest_api_get_project_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/quota/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Quota',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_list_projects(self, username, password, **kwargs):  # noqa: E501
        """List the projects the user belongs to  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_list_projects(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_list_projects_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_list_projects_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_list_projects_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """List the projects the user belongs to  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_list_projects_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[str]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_list_projects" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_list_projects`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_list_projects`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/projects/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[str]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_project_quota(self, username, password, project_name, **kwargs):  # noqa: E501
        """Post a new (or update existent) quota of a project (admin only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_project_quota(username, password, project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of a OpenStack project (required)
        :param Quota body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_project_quota_with_http_info(username, password, project_name, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_project_quota_with_http_info(username, password, project_name, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_project_quota_with_http_info(self, username, password, project_name, **kwargs):  # noqa: E501
        """Post a new (or update existent) quota of a project (admin only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_project_quota_with_http_info(username, password, project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str project_name: Name of a OpenStack project (required)
        :param Quota body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'project_name', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_project_quota" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_project_quota`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_project_quota`")  # noqa: E501
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `cf_manager_rest_api_post_project_quota`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/quota/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
