# coding: utf-8

"""
    cloudFPGA Resource Manager API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class MantleArchitectureApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cf_manager_rest_api_get_composable_logic_all_part(self, username, password, part, **kwargs):  # noqa: E501
        """Returns all composable logics of the given part that are `IN_USE`  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_all_part(username, password, part, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str part: The part of the composable logics (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_composable_logic_all_part_with_http_info(username, password, part, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_composable_logic_all_part_with_http_info(username, password, part, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_composable_logic_all_part_with_http_info(self, username, password, part, **kwargs):  # noqa: E501
        """Returns all composable logics of the given part that are `IN_USE`  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_all_part_with_http_info(username, password, part, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str part: The part of the composable logics (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'part']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_composable_logic_all_part" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_composable_logic_all_part`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_composable_logic_all_part`")  # noqa: E501
        # verify the required parameter 'part' is set
        if ('part' not in params or
                params['part'] is None):
            raise ValueError("Missing the required parameter `part` when calling `cf_manager_rest_api_get_composable_logic_all_part`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'part' in params:
            path_params['part'] = params['part']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/composablelogic/by_part/{part}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_composable_logic_all_prp(self, username, password, prp, **kwargs):  # noqa: E501
        """Returns all composable logics of the given prp-type that are `IN_USE`  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_all_prp(username, password, prp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int prp: The prp-level of the composable logics (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_composable_logic_all_prp_with_http_info(username, password, prp, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_composable_logic_all_prp_with_http_info(username, password, prp, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_composable_logic_all_prp_with_http_info(self, username, password, prp, **kwargs):  # noqa: E501
        """Returns all composable logics of the given prp-type that are `IN_USE`  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_all_prp_with_http_info(username, password, prp, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int prp: The prp-level of the composable logics (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'prp']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_composable_logic_all_prp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_composable_logic_all_prp`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_composable_logic_all_prp`")  # noqa: E501
        # verify the required parameter 'prp' is set
        if ('prp' not in params or
                params['prp'] is None):
            raise ValueError("Missing the required parameter `prp` when calling `cf_manager_rest_api_get_composable_logic_all_prp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'prp' in params:
            path_params['prp'] = params['prp']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/composablelogic/by_prp/{prp}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_composable_logic_all_shell_type(self, username, password, shell_type, **kwargs):  # noqa: E501
        """Returns all composable logics of the given shell-type that are `IN_USE`  # noqa: E501

        If the resulting list is empty, the shell_type is invalid (or no such composalbe logics exist).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_all_shell_type(username, password, shell_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str shell_type: Name of cloudFPGA Shell (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_composable_logic_all_shell_type_with_http_info(username, password, shell_type, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_composable_logic_all_shell_type_with_http_info(username, password, shell_type, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_composable_logic_all_shell_type_with_http_info(self, username, password, shell_type, **kwargs):  # noqa: E501
        """Returns all composable logics of the given shell-type that are `IN_USE`  # noqa: E501

        If the resulting list is empty, the shell_type is invalid (or no such composalbe logics exist).  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_all_shell_type_with_http_info(username, password, shell_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str shell_type: Name of cloudFPGA Shell (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'shell_type']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_composable_logic_all_shell_type" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_composable_logic_all_shell_type`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_composable_logic_all_shell_type`")  # noqa: E501
        # verify the required parameter 'shell_type' is set
        if ('shell_type' not in params or
                params['shell_type'] is None):
            raise ValueError("Missing the required parameter `shell_type` when calling `cf_manager_rest_api_get_composable_logic_all_shell_type`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'shell_type' in params:
            path_params['shell_type'] = params['shell_type']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/composablelogic/by_shell/{shell_type}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_composable_logic_dcp(self, username, password, cl_id, **kwargs):  # noqa: E501
        """Get the dcp file of a composable logic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_dcp(username, password, cl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_composable_logic_dcp_with_http_info(username, password, cl_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_composable_logic_dcp_with_http_info(username, password, cl_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_composable_logic_dcp_with_http_info(self, username, password, cl_id, **kwargs):  # noqa: E501
        """Get the dcp file of a composable logic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_dcp_with_http_info(username, password, cl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cl_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_composable_logic_dcp" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_composable_logic_dcp`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_composable_logic_dcp`")  # noqa: E501
        # verify the required parameter 'cl_id' is set
        if ('cl_id' not in params or
                params['cl_id'] is None):
            raise ValueError("Missing the required parameter `cl_id` when calling `cf_manager_rest_api_get_composable_logic_dcp`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cl_id' in params:
            path_params['cl_id'] = params['cl_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/composablelogic/{cl_id}/dcp', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_composable_logic_meta(self, username, password, cl_id, **kwargs):  # noqa: E501
        """Get the meta data of a composable logic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_meta(username, password, cl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_composable_logic_meta_with_http_info(username, password, cl_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_composable_logic_meta_with_http_info(username, password, cl_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_composable_logic_meta_with_http_info(self, username, password, cl_id, **kwargs):  # noqa: E501
        """Get the meta data of a composable logic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_composable_logic_meta_with_http_info(username, password, cl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :return: Image
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cl_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_composable_logic_meta" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_composable_logic_meta`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_composable_logic_meta`")  # noqa: E501
        # verify the required parameter 'cl_id' is set
        if ('cl_id' not in params or
                params['cl_id'] is None):
            raise ValueError("Missing the required parameter `cl_id` when calling `cf_manager_rest_api_get_composable_logic_meta`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cl_id' in params:
            path_params['cl_id'] = params['cl_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/composablelogic/{cl_id}/meta', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Image',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
