# coding: utf-8

"""
    cloudFPGA Resource Manager API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class DebugApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cf_manager_rest_api_delete_debug_connection(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Deletes an existing connection to the `hw_server` of this instance  # noqa: E501

        This deletes the *connection to the* `hw_server`. This **does not imply** that the `hw_server` itself is stopped too. The `hw_server` is only stopped if there is no other open debug connection to the connected JTAG probe (some probes are connected to a JTAG chain).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_debug_connection(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_delete_debug_connection_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_delete_debug_connection_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_delete_debug_connection_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Deletes an existing connection to the `hw_server` of this instance  # noqa: E501

        This deletes the *connection to the* `hw_server`. This **does not imply** that the `hw_server` itself is stopped too. The `hw_server` is only stopped if there is no other open debug connection to the connected JTAG probe (some probes are connected to a JTAG chain).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_debug_connection_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_delete_debug_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_delete_debug_connection`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_delete_debug_connection`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_delete_debug_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/debug/ila_connection/{instance_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_all_debug_connections(self, username, password, **kwargs):  # noqa: E501
        """Requests a list of running `hw_server`s on all instances (admin only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_all_debug_connections(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_all_debug_connections_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_all_debug_connections_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_all_debug_connections_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Requests a list of running `hw_server`s on all instances (admin only)  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_all_debug_connections_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_all_debug_connections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_all_debug_connections`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_all_debug_connections`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/debug/open_ila_connections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2003]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_all_debug_connections_of_user(self, username, password, **kwargs):  # noqa: E501
        """Returns all open `hw_server` of a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_all_debug_connections_of_user(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_all_debug_connections_of_user_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_all_debug_connections_of_user_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_all_debug_connections_of_user_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Returns all open `hw_server` of a user  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_all_debug_connections_of_user_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[InlineResponse2003]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_all_debug_connections_of_user" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_all_debug_connections_of_user`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_all_debug_connections_of_user`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/debug/ila_connections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse2003]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_debug_connection(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Requests a connection to the `hw_server` of this instance  # noqa: E501

        This returns an IP-address and a TCP port to enter into the *remote debugging dialog* in `vivado_lab`. **Only the IP-address that issues this request will be allowed to connect (or the specified IP address).**  If there is already an open debug connection to the specified instance, the existing data will be returned. That means, to debug the same instance on a different client, the connection must be deleted first.  Due to ongoing Hardware Development it is possible that there are more than one FPGA visible in the debug connection (some FPGAs share a JTAG probe via a JTAG chain). **You are only allowed to interact with the device that is stated in the `device` value in the response from the server.** (The Resource Manager assures that the devices in a JTAG chain are only given to members of the same project, so if you interact with other devices, you will disturb your direct colleges).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_debug_connection(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :param str ip_address: IPv4 address of the Debuging client if different from requesting client (only this addres will be allowed to connect).
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_debug_connection_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_debug_connection_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_debug_connection_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Requests a connection to the `hw_server` of this instance  # noqa: E501

        This returns an IP-address and a TCP port to enter into the *remote debugging dialog* in `vivado_lab`. **Only the IP-address that issues this request will be allowed to connect (or the specified IP address).**  If there is already an open debug connection to the specified instance, the existing data will be returned. That means, to debug the same instance on a different client, the connection must be deleted first.  Due to ongoing Hardware Development it is possible that there are more than one FPGA visible in the debug connection (some FPGAs share a JTAG probe via a JTAG chain). **You are only allowed to interact with the device that is stated in the `device` value in the response from the server.** (The Resource Manager assures that the devices in a JTAG chain are only given to members of the same project, so if you interact with other devices, you will disturb your direct colleges).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_debug_connection_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :param str ip_address: IPv4 address of the Debuging client if different from requesting client (only this addres will be allowed to connect).
        :return: InlineResponse2002
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id', 'ip_address']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_debug_connection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_debug_connection`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_debug_connection`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_get_debug_connection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'ip_address' in params:
            query_params.append(('ip_address', params['ip_address']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/debug/ila_connection/{instance_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2002',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_flight_recorder_cluster(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Requests network runtime information of all instances  # noqa: E501

        Requests and returns the status information of the Network Routing Core of all instances in this cluster `Attention:` There may be a delay of a few seconds until the counters are updated after the packets were processed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_flight_recorder_cluster(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_flight_recorder_cluster_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_flight_recorder_cluster_with_http_info(username, password, cluster_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_flight_recorder_cluster_with_http_info(self, username, password, cluster_id, **kwargs):  # noqa: E501
        """Requests network runtime information of all instances  # noqa: E501

        Requests and returns the status information of the Network Routing Core of all instances in this cluster `Attention:` There may be a delay of a few seconds until the counters are updated after the packets were processed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_flight_recorder_cluster_with_http_info(username, password, cluster_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cluster_id: ID of a cluster (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cluster_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_flight_recorder_cluster" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_flight_recorder_cluster`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_flight_recorder_cluster`")  # noqa: E501
        # verify the required parameter 'cluster_id' is set
        if ('cluster_id' not in params or
                params['cluster_id'] is None):
            raise ValueError("Missing the required parameter `cluster_id` when calling `cf_manager_rest_api_get_flight_recorder_cluster`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cluster_id' in params:
            path_params['cluster_id'] = params['cluster_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/clusters/{cluster_id}/flight_recorder_data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_flight_recorder_instance(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Requests network runtime information  # noqa: E501

        Requests and returns the status information of the Network Routing Core of this FPGA instance `Attention:` There may be a delay of a few seconds until the counters are updated after the packets were processed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_flight_recorder_instance(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_flight_recorder_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_flight_recorder_instance_with_http_info(username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_flight_recorder_instance_with_http_info(self, username, password, instance_id, **kwargs):  # noqa: E501
        """Requests network runtime information  # noqa: E501

        Requests and returns the status information of the Network Routing Core of this FPGA instance `Attention:` There may be a delay of a few seconds until the counters are updated after the packets were processed.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_flight_recorder_instance_with_http_info(username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'instance_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_flight_recorder_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_flight_recorder_instance`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_flight_recorder_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_get_flight_recorder_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/instances/{instance_id}/flight_recorder_data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
