"""
Copyright (C) 2022-2024 Stella Technologies (UK) Limited.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
IN THE SOFTWARE.
"""

from typing import List, Set

from loguru import logger
from prettytable import PrettyTable

from stellanow_cli.core.helpers import ProcessedFile, SkippedFile


def log_processed_and_skipped_result(
    processed_files: List[ProcessedFile], skipped_files: List[SkippedFile], events_not_found: Set[str]
):
    if processed_files:
        logger.info("\n==============================\n      PROCESSED FILES\n==============================\n")

        table = PrettyTable(["File"])

        for processed_file in processed_files:
            table.add_row(list(processed_file))

        logger.info(table)

    if skipped_files:
        logger.info("\n==============================\n      SKIPPED FILES\n==============================\n")

        table = PrettyTable(["File", "Skipping Reason"])

        for skipped_file in skipped_files:
            table.add_row(list(skipped_file))

        for event in events_not_found:
            table.add_row([event, "Missing Event Configuration"])

        logger.info(table)

        logger.info("\nSkipped Reason - Explanation:\n")
        logger.info(
            "- File Already Exist - Existing classes can't be overridden. Use --force to override this protection."
        )
        logger.info("- Missing Event Configuration - Check if the specified event exists in the Operators Console.")
        logger.info("- No Entity Associated With Event - Event exists, but it is not attached to any entity type.")


def log_summary(skipped_files: List[SkippedFile]) -> None:
    if skipped_files:
        logger.info("\n==============================\n         SUMMARY\n==============================\n")

        table = PrettyTable(["File", "Reason for not comparing"])

        # Populate the table with data from your SkippedFile instances
        for skipped_file in skipped_files:
            table.add_row([skipped_file.filename, skipped_file.reason])

        logger.info(table)

        logger.info("\nSkipped Reason - Explanation:\n")
        logger.info("- Not Auto-Generated - It looks like the file was not generated by this CLI.")
        logger.info("- Event ID Not Found - The ID of the event is missing in the header comment.")
