"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mode = exports.StaticSiteAuthorization = exports.SpaAuthorization = exports.Authorization = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_cognito_1 = require("@aws-cdk/aws-cognito");
const core_1 = require("@aws-cdk/core");
const cdk_lambda_at_edge_pattern_1 = require("@cloudcomponents/cdk-lambda-at-edge-pattern");
const auth_flow_1 = require("./auth-flow");
const retrieve_user_pool_client_secret_1 = require("./retrieve-user-pool-client-secret");
const secret_generator_1 = require("./secret-generator");
const user_pool_client_redirects_1 = require("./user-pool-client-redirects");
const user_pool_domain_1 = require("./user-pool-domain");
class Authorization extends core_1.Construct {
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h, _j;
        super(scope, id);
        this.userPool = props.userPool;
        this.redirectPaths = (_d = props.redirectPaths) !== null && _d !== void 0 ? _d : {
            signIn: '/parseauth',
            authRefresh: '/refreshauth',
            signOut: '/',
        };
        this.signOutUrlPath = (_e = props.signOutUrl) !== null && _e !== void 0 ? _e : '/signout';
        this.httpHeaders = (_f = props.httpHeaders) !== null && _f !== void 0 ? _f : {
            'Content-Security-Policy': "default-src 'none'; img-src 'self'; script-src 'self'; style-src 'self' 'unsafe-inline'; object-src 'none'; connect-src 'self'",
            'Strict-Transport-Security': 'max-age=31536000; includeSubdomains; preload',
            'Referrer-Policy': 'same-origin',
            'X-XSS-Protection': '1; mode=block',
            'X-Frame-Options': 'DENY',
            'X-Content-Type-Options': 'nosniff',
            'Cache-Control': 'no-cache',
        };
        this.oauthScopes = (_g = props.oauthScopes) !== null && _g !== void 0 ? _g : [aws_cognito_1.OAuthScope.PHONE, aws_cognito_1.OAuthScope.EMAIL, aws_cognito_1.OAuthScope.PROFILE, aws_cognito_1.OAuthScope.OPENID, aws_cognito_1.OAuthScope.COGNITO_ADMIN];
        this.cookieSettings = props.cookieSettings;
        this.identityProviders = (_h = props.identityProviders) !== null && _h !== void 0 ? _h : [aws_cognito_1.UserPoolClientIdentityProvider.COGNITO];
        this.userPoolClient = this.createUserPoolClient();
        this.nonceSigningSecret = this.generateNonceSigningSecret();
        this.cognitoAuthDomain = this.retrieveCognitoAuthDomain();
        this.authFlow = this.createAuthFlow((_j = props.logLevel) !== null && _j !== void 0 ? _j : cdk_lambda_at_edge_pattern_1.LogLevel.WARN);
    }
    updateUserPoolClientCallbacks(redirects) {
        const { callbackUrls, logoutUrls } = redirects;
        new user_pool_client_redirects_1.UserPoolClientRedirects(this, 'UserPoolClientRedirects', {
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            callbackUrls,
            logoutUrls,
            identityProviders: this.identityProviders,
        });
    }
    createDefaultBehavior(origin, options) {
        return {
            origin,
            compress: true,
            originRequestPolicy: aws_cloudfront_1.OriginRequestPolicy.ALL_VIEWER,
            viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            edgeLambdas: [this.authFlow.checkAuth, this.authFlow.httpHeaders],
            ...options,
        };
    }
    createLegacyDefaultBehavior(options) {
        return {
            isDefaultBehavior: true,
            forwardedValues: {
                queryString: true,
            },
            compress: true,
            lambdaFunctionAssociations: [this.authFlow.checkAuth, this.authFlow.httpHeaders],
            ...options,
        };
    }
    createAdditionalBehaviors(origin, options) {
        return {
            [this.redirectPaths.signIn]: {
                origin,
                compress: true,
                originRequestPolicy: aws_cloudfront_1.OriginRequestPolicy.ALL_VIEWER,
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.parseAuth],
                ...options,
            },
            [this.redirectPaths.authRefresh]: {
                origin,
                compress: true,
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.refreshAuth],
                ...options,
            },
            [this.signOutUrlPath]: {
                origin,
                compress: true,
                originRequestPolicy: aws_cloudfront_1.OriginRequestPolicy.ALL_VIEWER,
                viewerProtocolPolicy: aws_cloudfront_1.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.signOut],
                ...options,
            },
        };
    }
    createLegacyAdditionalBehaviors(options) {
        return [
            {
                pathPattern: this.redirectPaths.signIn,
                forwardedValues: {
                    queryString: true,
                },
                lambdaFunctionAssociations: [this.authFlow.parseAuth],
                ...options,
            },
            {
                pathPattern: this.redirectPaths.authRefresh,
                forwardedValues: {
                    queryString: true,
                },
                lambdaFunctionAssociations: [this.authFlow.refreshAuth],
                ...options,
            },
            {
                pathPattern: this.signOutUrlPath,
                forwardedValues: {
                    queryString: true,
                },
                lambdaFunctionAssociations: [this.authFlow.signOut],
                ...options,
            },
        ];
    }
    generateNonceSigningSecret() {
        const { secret } = new secret_generator_1.SecretGenerator(this, 'SecretGenerator');
        return secret;
    }
    retrieveCognitoAuthDomain() {
        const userPoolDomain = new user_pool_domain_1.UserPoolDomain(this, 'UserPoolDomain', {
            userPool: this.userPool,
        });
        return userPoolDomain.cognitoAuthDomain;
    }
}
exports.Authorization = Authorization;
_a = JSII_RTTI_SYMBOL_1;
Authorization[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.Authorization", version: "1.50.0" };
class SpaAuthorization extends Authorization {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.mode = Mode.SPA;
    }
    createUserPoolClient() {
        return this.userPool.addClient('UserPoolClient', {
            generateSecret: false,
            oAuth: {
                flows: {
                    authorizationCodeGrant: true,
                },
                scopes: this.oauthScopes,
            },
            supportedIdentityProviders: this.identityProviders,
            preventUserExistenceErrors: true,
        });
    }
    createAuthFlow(logLevel) {
        var _d;
        return new auth_flow_1.AuthFlow(this, 'AuthFlow', {
            logLevel,
            httpHeaders: this.httpHeaders,
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            redirectPaths: this.redirectPaths,
            nonceSigningSecret: this.nonceSigningSecret,
            cognitoAuthDomain: this.cognitoAuthDomain,
            cookieSettings: (_d = this.cookieSettings) !== null && _d !== void 0 ? _d : {
                idToken: 'Path=/; Secure; SameSite=Lax',
                accessToken: 'Path=/; Secure; SameSite=Lax',
                refreshToken: 'Path=/; Secure; SameSite=Lax',
                nonce: 'Path=/; Secure; HttpOnly; SameSite=Lax',
            },
        });
    }
}
exports.SpaAuthorization = SpaAuthorization;
_b = JSII_RTTI_SYMBOL_1;
SpaAuthorization[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaAuthorization", version: "1.50.0" };
class StaticSiteAuthorization extends Authorization {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.mode = Mode.STATIC_SITE;
    }
    createUserPoolClient() {
        return this.userPool.addClient('UserPoolClient', {
            generateSecret: true,
            oAuth: {
                flows: {
                    authorizationCodeGrant: true,
                },
                scopes: this.oauthScopes,
            },
            supportedIdentityProviders: this.identityProviders,
            preventUserExistenceErrors: true,
        });
    }
    createAuthFlow(logLevel) {
        var _d;
        const clientSecret = this.retrieveUserPoolClientSecret();
        return new auth_flow_1.AuthFlow(this, 'AuthFlow', {
            logLevel,
            httpHeaders: this.httpHeaders,
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            redirectPaths: this.redirectPaths,
            nonceSigningSecret: this.nonceSigningSecret,
            cognitoAuthDomain: this.cognitoAuthDomain,
            clientSecret,
            cookieSettings: (_d = this.cookieSettings) !== null && _d !== void 0 ? _d : {
                idToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                accessToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                refreshToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                nonce: 'Path=/; Secure; HttpOnly; SameSite=Lax',
            },
        });
    }
    retrieveUserPoolClientSecret() {
        const { clientSecret } = new retrieve_user_pool_client_secret_1.RetrieveUserPoolClientSecret(this, 'RetrieveUserPoolClientSecret', {
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
        });
        return clientSecret;
    }
}
exports.StaticSiteAuthorization = StaticSiteAuthorization;
_c = JSII_RTTI_SYMBOL_1;
StaticSiteAuthorization[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteAuthorization", version: "1.50.0" };
var Mode;
(function (Mode) {
    Mode["SPA"] = "SPA";
    Mode["STATIC_SITE"] = "STATIC_SITE";
})(Mode = exports.Mode || (exports.Mode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0aG9yaXphdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYXV0aG9yaXphdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw0REFBNEk7QUFDNUksc0RBQThHO0FBQzlHLHdDQUEwQztBQUMxQyw0RkFBdUU7QUFFdkUsMkNBQXNEO0FBQ3RELHlGQUFrRjtBQUNsRix5REFBcUQ7QUFDckQsNkVBQXVFO0FBQ3ZFLHlEQUFvRDtBQStCcEQsTUFBc0IsYUFBYyxTQUFRLGdCQUFTO0lBY25ELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7O1FBQ2pFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUMsUUFBUSxDQUFDO1FBRS9CLElBQUksQ0FBQyxhQUFhLFNBQUcsS0FBSyxDQUFDLGFBQWEsbUNBQUk7WUFDMUMsTUFBTSxFQUFFLFlBQVk7WUFDcEIsV0FBVyxFQUFFLGNBQWM7WUFDM0IsT0FBTyxFQUFFLEdBQUc7U0FDYixDQUFDO1FBRUYsSUFBSSxDQUFDLGNBQWMsU0FBRyxLQUFLLENBQUMsVUFBVSxtQ0FBSSxVQUFVLENBQUM7UUFFckQsSUFBSSxDQUFDLFdBQVcsU0FBRyxLQUFLLENBQUMsV0FBVyxtQ0FBSTtZQUN0Qyx5QkFBeUIsRUFDdkIsZ0lBQWdJO1lBQ2xJLDJCQUEyQixFQUFFLDhDQUE4QztZQUMzRSxpQkFBaUIsRUFBRSxhQUFhO1lBQ2hDLGtCQUFrQixFQUFFLGVBQWU7WUFDbkMsaUJBQWlCLEVBQUUsTUFBTTtZQUN6Qix3QkFBd0IsRUFBRSxTQUFTO1lBQ25DLGVBQWUsRUFBRSxVQUFVO1NBQzVCLENBQUM7UUFFRixJQUFJLENBQUMsV0FBVyxTQUFHLEtBQUssQ0FBQyxXQUFXLG1DQUFJLENBQUMsd0JBQVUsQ0FBQyxLQUFLLEVBQUUsd0JBQVUsQ0FBQyxLQUFLLEVBQUUsd0JBQVUsQ0FBQyxPQUFPLEVBQUUsd0JBQVUsQ0FBQyxNQUFNLEVBQUUsd0JBQVUsQ0FBQyxhQUFhLENBQUMsQ0FBQztRQUU5SSxJQUFJLENBQUMsY0FBYyxHQUFHLEtBQUssQ0FBQyxjQUFjLENBQUM7UUFFM0MsSUFBSSxDQUFDLGlCQUFpQixTQUFHLEtBQUssQ0FBQyxpQkFBaUIsbUNBQUksQ0FBQyw0Q0FBOEIsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUU3RixJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1FBRWxELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsMEJBQTBCLEVBQUUsQ0FBQztRQUU1RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLHlCQUF5QixFQUFFLENBQUM7UUFFMUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsY0FBYyxPQUFDLEtBQUssQ0FBQyxRQUFRLG1DQUFJLHFDQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkUsQ0FBQztJQU1NLDZCQUE2QixDQUFDLFNBQXFDO1FBQ3hFLE1BQU0sRUFBRSxZQUFZLEVBQUUsVUFBVSxFQUFFLEdBQUcsU0FBUyxDQUFDO1FBRS9DLElBQUksb0RBQXVCLENBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFO1lBQzNELFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFlBQVk7WUFDWixVQUFVO1lBQ1YsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtTQUMxQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0scUJBQXFCLENBQUMsTUFBZSxFQUFFLE9BQTRCO1FBQ3hFLE9BQU87WUFDTCxNQUFNO1lBQ04sUUFBUSxFQUFFLElBQUk7WUFDZCxtQkFBbUIsRUFBRSxvQ0FBbUIsQ0FBQyxVQUFVO1lBQ25ELG9CQUFvQixFQUFFLHFDQUFvQixDQUFDLGlCQUFpQjtZQUM1RCxXQUFXLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQztZQUNqRSxHQUFHLE9BQU87U0FDWCxDQUFDO0lBQ0osQ0FBQztJQUVNLDJCQUEyQixDQUFDLE9BQWtCO1FBQ25ELE9BQU87WUFDTCxpQkFBaUIsRUFBRSxJQUFJO1lBQ3ZCLGVBQWUsRUFBRTtnQkFDZixXQUFXLEVBQUUsSUFBSTthQUNsQjtZQUNELFFBQVEsRUFBRSxJQUFJO1lBQ2QsMEJBQTBCLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQztZQUNoRixHQUFHLE9BQU87U0FDWCxDQUFDO0lBQ0osQ0FBQztJQUVNLHlCQUF5QixDQUFDLE1BQWUsRUFBRSxPQUE0QjtRQUM1RSxPQUFPO1lBQ0wsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxFQUFFO2dCQUMzQixNQUFNO2dCQUNOLFFBQVEsRUFBRSxJQUFJO2dCQUNkLG1CQUFtQixFQUFFLG9DQUFtQixDQUFDLFVBQVU7Z0JBQ25ELG9CQUFvQixFQUFFLHFDQUFvQixDQUFDLGlCQUFpQjtnQkFDNUQsV0FBVyxFQUFFLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUM7Z0JBQ3RDLEdBQUcsT0FBTzthQUNYO1lBQ0QsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FBQyxFQUFFO2dCQUNoQyxNQUFNO2dCQUNOLFFBQVEsRUFBRSxJQUFJO2dCQUNkLG9CQUFvQixFQUFFLHFDQUFvQixDQUFDLGlCQUFpQjtnQkFDNUQsV0FBVyxFQUFFLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUM7Z0JBQ3hDLEdBQUcsT0FBTzthQUNYO1lBQ0QsQ0FBQyxJQUFJLENBQUMsY0FBYyxDQUFDLEVBQUU7Z0JBQ3JCLE1BQU07Z0JBQ04sUUFBUSxFQUFFLElBQUk7Z0JBQ2QsbUJBQW1CLEVBQUUsb0NBQW1CLENBQUMsVUFBVTtnQkFDbkQsb0JBQW9CLEVBQUUscUNBQW9CLENBQUMsaUJBQWlCO2dCQUM1RCxXQUFXLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQztnQkFDcEMsR0FBRyxPQUFPO2FBQ1g7U0FDRixDQUFDO0lBQ0osQ0FBQztJQUVNLCtCQUErQixDQUFDLE9BQWtCO1FBQ3ZELE9BQU87WUFDTDtnQkFDRSxXQUFXLEVBQUUsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNO2dCQUN0QyxlQUFlLEVBQUU7b0JBQ2YsV0FBVyxFQUFFLElBQUk7aUJBQ2xCO2dCQUNELDBCQUEwQixFQUFFLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUM7Z0JBQ3JELEdBQUcsT0FBTzthQUNYO1lBQ0Q7Z0JBQ0UsV0FBVyxFQUFFLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVztnQkFDM0MsZUFBZSxFQUFFO29CQUNmLFdBQVcsRUFBRSxJQUFJO2lCQUNsQjtnQkFDRCwwQkFBMEIsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDO2dCQUN2RCxHQUFHLE9BQU87YUFDWDtZQUNEO2dCQUNFLFdBQVcsRUFBRSxJQUFJLENBQUMsY0FBYztnQkFDaEMsZUFBZSxFQUFFO29CQUNmLFdBQVcsRUFBRSxJQUFJO2lCQUNsQjtnQkFDRCwwQkFBMEIsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDO2dCQUNuRCxHQUFHLE9BQU87YUFDWDtTQUNGLENBQUM7SUFDSixDQUFDO0lBRU8sMEJBQTBCO1FBQ2hDLE1BQU0sRUFBRSxNQUFNLEVBQUUsR0FBRyxJQUFJLGtDQUFlLENBQUMsSUFBSSxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFDaEUsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUVPLHlCQUF5QjtRQUMvQixNQUFNLGNBQWMsR0FBRyxJQUFJLGlDQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO1lBQ2hFLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtTQUN4QixDQUFDLENBQUM7UUFFSCxPQUFPLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQztJQUMxQyxDQUFDOztBQWpLSCxzQ0FrS0M7OztBQVFELE1BQWEsZ0JBQWlCLFNBQVEsYUFBYTtJQUdqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBSFYsU0FBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7SUFJaEMsQ0FBQztJQUVTLG9CQUFvQjtRQUM1QixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGdCQUFnQixFQUFFO1lBQy9DLGNBQWMsRUFBRSxLQUFLO1lBQ3JCLEtBQUssRUFBRTtnQkFDTCxLQUFLLEVBQUU7b0JBQ0wsc0JBQXNCLEVBQUUsSUFBSTtpQkFDN0I7Z0JBQ0QsTUFBTSxFQUFFLElBQUksQ0FBQyxXQUFXO2FBQ3pCO1lBQ0QsMEJBQTBCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUNsRCwwQkFBMEIsRUFBRSxJQUFJO1NBQ2pDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFUyxjQUFjLENBQUMsUUFBa0I7O1FBQ3pDLE9BQU8sSUFBSSxvQkFBUSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDcEMsUUFBUTtZQUNSLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLGNBQWMsUUFBRSxJQUFJLENBQUMsY0FBYyxtQ0FBSTtnQkFDckMsT0FBTyxFQUFFLDhCQUE4QjtnQkFDdkMsV0FBVyxFQUFFLDhCQUE4QjtnQkFDM0MsWUFBWSxFQUFFLDhCQUE4QjtnQkFDNUMsS0FBSyxFQUFFLHdDQUF3QzthQUNoRDtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBdENILDRDQXVDQzs7O0FBUUQsTUFBYSx1QkFBd0IsU0FBUSxhQUFhO0lBR3hELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBbUM7UUFDM0UsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFIVixTQUFJLEdBQUcsSUFBSSxDQUFDLFdBQVcsQ0FBQztJQUl4QyxDQUFDO0lBRVMsb0JBQW9CO1FBQzVCLE9BQU8sSUFBSSxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsZ0JBQWdCLEVBQUU7WUFDL0MsY0FBYyxFQUFFLElBQUk7WUFDcEIsS0FBSyxFQUFFO2dCQUNMLEtBQUssRUFBRTtvQkFDTCxzQkFBc0IsRUFBRSxJQUFJO2lCQUM3QjtnQkFDRCxNQUFNLEVBQUUsSUFBSSxDQUFDLFdBQVc7YUFDekI7WUFDRCwwQkFBMEIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ2xELDBCQUEwQixFQUFFLElBQUk7U0FDakMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVTLGNBQWMsQ0FBQyxRQUFrQjs7UUFDekMsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLDRCQUE0QixFQUFFLENBQUM7UUFFekQsT0FBTyxJQUFJLG9CQUFRLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNwQyxRQUFRO1lBQ1IsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsWUFBWTtZQUNaLGNBQWMsUUFBRSxJQUFJLENBQUMsY0FBYyxtQ0FBSTtnQkFDckMsT0FBTyxFQUFFLHdDQUF3QztnQkFDakQsV0FBVyxFQUFFLHdDQUF3QztnQkFDckQsWUFBWSxFQUFFLHdDQUF3QztnQkFDdEQsS0FBSyxFQUFFLHdDQUF3QzthQUNoRDtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFTyw0QkFBNEI7UUFDbEMsTUFBTSxFQUFFLFlBQVksRUFBRSxHQUFHLElBQUksK0RBQTRCLENBQUMsSUFBSSxFQUFFLDhCQUE4QixFQUFFO1lBQzlGLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7U0FDcEMsQ0FBQyxDQUFDO1FBRUgsT0FBTyxZQUFZLENBQUM7SUFDdEIsQ0FBQzs7QUFsREgsMERBbURDOzs7QUFFRCxJQUFZLElBR1g7QUFIRCxXQUFZLElBQUk7SUFDZCxtQkFBVyxDQUFBO0lBQ1gsbUNBQTJCLENBQUE7QUFDN0IsQ0FBQyxFQUhXLElBQUksR0FBSixZQUFJLEtBQUosWUFBSSxRQUdmIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSU9yaWdpbiwgQmVoYXZpb3IsIEJlaGF2aW9yT3B0aW9ucywgQWRkQmVoYXZpb3JPcHRpb25zLCBWaWV3ZXJQcm90b2NvbFBvbGljeSwgT3JpZ2luUmVxdWVzdFBvbGljeSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1jbG91ZGZyb250JztcbmltcG9ydCB7IE9BdXRoU2NvcGUsIFVzZXJQb29sQ2xpZW50SWRlbnRpdHlQcm92aWRlciwgSVVzZXJQb29sLCBJVXNlclBvb2xDbGllbnQgfSBmcm9tICdAYXdzLWNkay9hd3MtY29nbml0byc7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IExvZ0xldmVsIH0gZnJvbSAnQGNsb3VkY29tcG9uZW50cy9jZGstbGFtYmRhLWF0LWVkZ2UtcGF0dGVybic7XG5cbmltcG9ydCB7IEF1dGhGbG93LCBSZWRpcmVjdFBhdGhzIH0gZnJvbSAnLi9hdXRoLWZsb3cnO1xuaW1wb3J0IHsgUmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldCB9IGZyb20gJy4vcmV0cmlldmUtdXNlci1wb29sLWNsaWVudC1zZWNyZXQnO1xuaW1wb3J0IHsgU2VjcmV0R2VuZXJhdG9yIH0gZnJvbSAnLi9zZWNyZXQtZ2VuZXJhdG9yJztcbmltcG9ydCB7IFVzZXJQb29sQ2xpZW50UmVkaXJlY3RzIH0gZnJvbSAnLi91c2VyLXBvb2wtY2xpZW50LXJlZGlyZWN0cyc7XG5pbXBvcnQgeyBVc2VyUG9vbERvbWFpbiB9IGZyb20gJy4vdXNlci1wb29sLWRvbWFpbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVXNlclBvb2xDbGllbnRDYWxsYmFja1VybHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNhbGxiYWNrVXJsczogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxvZ291dFVybHM6IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIElBdXRob3JpemF0aW9uIHtcbiAgcmVhZG9ubHkgcmVkaXJlY3RQYXRoczogUmVkaXJlY3RQYXRocztcbiAgcmVhZG9ubHkgc2lnbk91dFVybFBhdGg6IHN0cmluZztcbiAgdXBkYXRlVXNlclBvb2xDbGllbnRDYWxsYmFja3MocmVkaXJlY3RzOiBVc2VyUG9vbENsaWVudENhbGxiYWNrVXJscyk6IHZvaWQ7XG4gIGNyZWF0ZURlZmF1bHRCZWhhdmlvcihvcmlnaW46IElPcmlnaW4sIG9wdGlvbnM/OiBBZGRCZWhhdmlvck9wdGlvbnMpOiBCZWhhdmlvck9wdGlvbnM7XG4gIGNyZWF0ZUFkZGl0aW9uYWxCZWhhdmlvcnMob3JpZ2luOiBJT3JpZ2luLCBvcHRpb25zPzogQWRkQmVoYXZpb3JPcHRpb25zKTogUmVjb3JkPHN0cmluZywgQmVoYXZpb3JPcHRpb25zPjtcbiAgY3JlYXRlTGVnYWN5RGVmYXVsdEJlaGF2aW9yKCk6IEJlaGF2aW9yO1xuICBjcmVhdGVMZWdhY3lBZGRpdGlvbmFsQmVoYXZpb3JzKCk6IEJlaGF2aW9yW107XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXV0aG9yaXphdGlvblByb3BzIHtcbiAgcmVhZG9ubHkgdXNlclBvb2w6IElVc2VyUG9vbDtcbiAgcmVhZG9ubHkgcmVkaXJlY3RQYXRocz86IFJlZGlyZWN0UGF0aHM7XG4gIHJlYWRvbmx5IHNpZ25PdXRVcmw/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGh0dHBIZWFkZXJzPzogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcbiAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBMb2dMZXZlbDtcbiAgcmVhZG9ubHkgb2F1dGhTY29wZXM/OiBPQXV0aFNjb3BlW107XG4gIHJlYWRvbmx5IGNvb2tpZVNldHRpbmdzPzogUmVjb3JkPHN0cmluZywgc3RyaW5nPjtcbiAgcmVhZG9ubHkgaWRlbnRpdHlQcm92aWRlcnM/OiBVc2VyUG9vbENsaWVudElkZW50aXR5UHJvdmlkZXJbXTtcbn1cblxuZXhwb3J0IGFic3RyYWN0IGNsYXNzIEF1dGhvcml6YXRpb24gZXh0ZW5kcyBDb25zdHJ1Y3Qge1xuICBwdWJsaWMgcmVhZG9ubHkgcmVkaXJlY3RQYXRoczogUmVkaXJlY3RQYXRocztcbiAgcHVibGljIHJlYWRvbmx5IHNpZ25PdXRVcmxQYXRoOiBzdHJpbmc7XG4gIHB1YmxpYyByZWFkb25seSBhdXRoRmxvdzogQXV0aEZsb3c7XG4gIHB1YmxpYyByZWFkb25seSB1c2VyUG9vbENsaWVudDogSVVzZXJQb29sQ2xpZW50O1xuXG4gIHByb3RlY3RlZCByZWFkb25seSB1c2VyUG9vbDogSVVzZXJQb29sO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgb2F1dGhTY29wZXM6IE9BdXRoU2NvcGVbXTtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGNvb2tpZVNldHRpbmdzOiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+IHwgdW5kZWZpbmVkO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgaHR0cEhlYWRlcnM6IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG4gIHByb3RlY3RlZCByZWFkb25seSBub25jZVNpZ25pbmdTZWNyZXQ6IHN0cmluZztcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGNvZ25pdG9BdXRoRG9tYWluOiBzdHJpbmc7XG4gIHByb3RlY3RlZCByZWFkb25seSBpZGVudGl0eVByb3ZpZGVyczogVXNlclBvb2xDbGllbnRJZGVudGl0eVByb3ZpZGVyW107XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEF1dGhvcml6YXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICB0aGlzLnVzZXJQb29sID0gcHJvcHMudXNlclBvb2w7XG5cbiAgICB0aGlzLnJlZGlyZWN0UGF0aHMgPSBwcm9wcy5yZWRpcmVjdFBhdGhzID8/IHtcbiAgICAgIHNpZ25JbjogJy9wYXJzZWF1dGgnLFxuICAgICAgYXV0aFJlZnJlc2g6ICcvcmVmcmVzaGF1dGgnLFxuICAgICAgc2lnbk91dDogJy8nLFxuICAgIH07XG5cbiAgICB0aGlzLnNpZ25PdXRVcmxQYXRoID0gcHJvcHMuc2lnbk91dFVybCA/PyAnL3NpZ25vdXQnO1xuXG4gICAgdGhpcy5odHRwSGVhZGVycyA9IHByb3BzLmh0dHBIZWFkZXJzID8/IHtcbiAgICAgICdDb250ZW50LVNlY3VyaXR5LVBvbGljeSc6XG4gICAgICAgIFwiZGVmYXVsdC1zcmMgJ25vbmUnOyBpbWctc3JjICdzZWxmJzsgc2NyaXB0LXNyYyAnc2VsZic7IHN0eWxlLXNyYyAnc2VsZicgJ3Vuc2FmZS1pbmxpbmUnOyBvYmplY3Qtc3JjICdub25lJzsgY29ubmVjdC1zcmMgJ3NlbGYnXCIsXG4gICAgICAnU3RyaWN0LVRyYW5zcG9ydC1TZWN1cml0eSc6ICdtYXgtYWdlPTMxNTM2MDAwOyBpbmNsdWRlU3ViZG9tYWluczsgcHJlbG9hZCcsXG4gICAgICAnUmVmZXJyZXItUG9saWN5JzogJ3NhbWUtb3JpZ2luJyxcbiAgICAgICdYLVhTUy1Qcm90ZWN0aW9uJzogJzE7IG1vZGU9YmxvY2snLFxuICAgICAgJ1gtRnJhbWUtT3B0aW9ucyc6ICdERU5ZJyxcbiAgICAgICdYLUNvbnRlbnQtVHlwZS1PcHRpb25zJzogJ25vc25pZmYnLFxuICAgICAgJ0NhY2hlLUNvbnRyb2wnOiAnbm8tY2FjaGUnLFxuICAgIH07XG5cbiAgICB0aGlzLm9hdXRoU2NvcGVzID0gcHJvcHMub2F1dGhTY29wZXMgPz8gW09BdXRoU2NvcGUuUEhPTkUsIE9BdXRoU2NvcGUuRU1BSUwsIE9BdXRoU2NvcGUuUFJPRklMRSwgT0F1dGhTY29wZS5PUEVOSUQsIE9BdXRoU2NvcGUuQ09HTklUT19BRE1JTl07XG5cbiAgICB0aGlzLmNvb2tpZVNldHRpbmdzID0gcHJvcHMuY29va2llU2V0dGluZ3M7XG5cbiAgICB0aGlzLmlkZW50aXR5UHJvdmlkZXJzID0gcHJvcHMuaWRlbnRpdHlQcm92aWRlcnMgPz8gW1VzZXJQb29sQ2xpZW50SWRlbnRpdHlQcm92aWRlci5DT0dOSVRPXTtcblxuICAgIHRoaXMudXNlclBvb2xDbGllbnQgPSB0aGlzLmNyZWF0ZVVzZXJQb29sQ2xpZW50KCk7XG5cbiAgICB0aGlzLm5vbmNlU2lnbmluZ1NlY3JldCA9IHRoaXMuZ2VuZXJhdGVOb25jZVNpZ25pbmdTZWNyZXQoKTtcblxuICAgIHRoaXMuY29nbml0b0F1dGhEb21haW4gPSB0aGlzLnJldHJpZXZlQ29nbml0b0F1dGhEb21haW4oKTtcblxuICAgIHRoaXMuYXV0aEZsb3cgPSB0aGlzLmNyZWF0ZUF1dGhGbG93KHByb3BzLmxvZ0xldmVsID8/IExvZ0xldmVsLldBUk4pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGFic3RyYWN0IGNyZWF0ZVVzZXJQb29sQ2xpZW50KCk6IElVc2VyUG9vbENsaWVudDtcblxuICBwcm90ZWN0ZWQgYWJzdHJhY3QgY3JlYXRlQXV0aEZsb3cobG9nTGV2ZWw6IExvZ0xldmVsKTogQXV0aEZsb3c7XG5cbiAgcHVibGljIHVwZGF0ZVVzZXJQb29sQ2xpZW50Q2FsbGJhY2tzKHJlZGlyZWN0czogVXNlclBvb2xDbGllbnRDYWxsYmFja1VybHMpOiB2b2lkIHtcbiAgICBjb25zdCB7IGNhbGxiYWNrVXJscywgbG9nb3V0VXJscyB9ID0gcmVkaXJlY3RzO1xuXG4gICAgbmV3IFVzZXJQb29sQ2xpZW50UmVkaXJlY3RzKHRoaXMsICdVc2VyUG9vbENsaWVudFJlZGlyZWN0cycsIHtcbiAgICAgIHVzZXJQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgICAgdXNlclBvb2xDbGllbnQ6IHRoaXMudXNlclBvb2xDbGllbnQsXG4gICAgICBvYXV0aFNjb3BlczogdGhpcy5vYXV0aFNjb3BlcyxcbiAgICAgIGNhbGxiYWNrVXJscyxcbiAgICAgIGxvZ291dFVybHMsXG4gICAgICBpZGVudGl0eVByb3ZpZGVyczogdGhpcy5pZGVudGl0eVByb3ZpZGVycyxcbiAgICB9KTtcbiAgfVxuXG4gIHB1YmxpYyBjcmVhdGVEZWZhdWx0QmVoYXZpb3Iob3JpZ2luOiBJT3JpZ2luLCBvcHRpb25zPzogQWRkQmVoYXZpb3JPcHRpb25zKTogQmVoYXZpb3JPcHRpb25zIHtcbiAgICByZXR1cm4ge1xuICAgICAgb3JpZ2luLFxuICAgICAgY29tcHJlc3M6IHRydWUsXG4gICAgICBvcmlnaW5SZXF1ZXN0UG9saWN5OiBPcmlnaW5SZXF1ZXN0UG9saWN5LkFMTF9WSUVXRVIsXG4gICAgICB2aWV3ZXJQcm90b2NvbFBvbGljeTogVmlld2VyUHJvdG9jb2xQb2xpY3kuUkVESVJFQ1RfVE9fSFRUUFMsXG4gICAgICBlZGdlTGFtYmRhczogW3RoaXMuYXV0aEZsb3cuY2hlY2tBdXRoLCB0aGlzLmF1dGhGbG93Lmh0dHBIZWFkZXJzXSxcbiAgICAgIC4uLm9wdGlvbnMsXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyBjcmVhdGVMZWdhY3lEZWZhdWx0QmVoYXZpb3Iob3B0aW9ucz86IEJlaGF2aW9yKTogQmVoYXZpb3Ige1xuICAgIHJldHVybiB7XG4gICAgICBpc0RlZmF1bHRCZWhhdmlvcjogdHJ1ZSxcbiAgICAgIGZvcndhcmRlZFZhbHVlczoge1xuICAgICAgICBxdWVyeVN0cmluZzogdHJ1ZSxcbiAgICAgIH0sXG4gICAgICBjb21wcmVzczogdHJ1ZSxcbiAgICAgIGxhbWJkYUZ1bmN0aW9uQXNzb2NpYXRpb25zOiBbdGhpcy5hdXRoRmxvdy5jaGVja0F1dGgsIHRoaXMuYXV0aEZsb3cuaHR0cEhlYWRlcnNdLFxuICAgICAgLi4ub3B0aW9ucyxcbiAgICB9O1xuICB9XG5cbiAgcHVibGljIGNyZWF0ZUFkZGl0aW9uYWxCZWhhdmlvcnMob3JpZ2luOiBJT3JpZ2luLCBvcHRpb25zPzogQWRkQmVoYXZpb3JPcHRpb25zKTogUmVjb3JkPHN0cmluZywgQmVoYXZpb3JPcHRpb25zPiB7XG4gICAgcmV0dXJuIHtcbiAgICAgIFt0aGlzLnJlZGlyZWN0UGF0aHMuc2lnbkluXToge1xuICAgICAgICBvcmlnaW4sXG4gICAgICAgIGNvbXByZXNzOiB0cnVlLFxuICAgICAgICBvcmlnaW5SZXF1ZXN0UG9saWN5OiBPcmlnaW5SZXF1ZXN0UG9saWN5LkFMTF9WSUVXRVIsXG4gICAgICAgIHZpZXdlclByb3RvY29sUG9saWN5OiBWaWV3ZXJQcm90b2NvbFBvbGljeS5SRURJUkVDVF9UT19IVFRQUyxcbiAgICAgICAgZWRnZUxhbWJkYXM6IFt0aGlzLmF1dGhGbG93LnBhcnNlQXV0aF0sXG4gICAgICAgIC4uLm9wdGlvbnMsXG4gICAgICB9LFxuICAgICAgW3RoaXMucmVkaXJlY3RQYXRocy5hdXRoUmVmcmVzaF06IHtcbiAgICAgICAgb3JpZ2luLFxuICAgICAgICBjb21wcmVzczogdHJ1ZSxcbiAgICAgICAgdmlld2VyUHJvdG9jb2xQb2xpY3k6IFZpZXdlclByb3RvY29sUG9saWN5LlJFRElSRUNUX1RPX0hUVFBTLFxuICAgICAgICBlZGdlTGFtYmRhczogW3RoaXMuYXV0aEZsb3cucmVmcmVzaEF1dGhdLFxuICAgICAgICAuLi5vcHRpb25zLFxuICAgICAgfSxcbiAgICAgIFt0aGlzLnNpZ25PdXRVcmxQYXRoXToge1xuICAgICAgICBvcmlnaW4sXG4gICAgICAgIGNvbXByZXNzOiB0cnVlLFxuICAgICAgICBvcmlnaW5SZXF1ZXN0UG9saWN5OiBPcmlnaW5SZXF1ZXN0UG9saWN5LkFMTF9WSUVXRVIsXG4gICAgICAgIHZpZXdlclByb3RvY29sUG9saWN5OiBWaWV3ZXJQcm90b2NvbFBvbGljeS5SRURJUkVDVF9UT19IVFRQUyxcbiAgICAgICAgZWRnZUxhbWJkYXM6IFt0aGlzLmF1dGhGbG93LnNpZ25PdXRdLFxuICAgICAgICAuLi5vcHRpb25zLFxuICAgICAgfSxcbiAgICB9O1xuICB9XG5cbiAgcHVibGljIGNyZWF0ZUxlZ2FjeUFkZGl0aW9uYWxCZWhhdmlvcnMob3B0aW9ucz86IEJlaGF2aW9yKTogQmVoYXZpb3JbXSB7XG4gICAgcmV0dXJuIFtcbiAgICAgIHtcbiAgICAgICAgcGF0aFBhdHRlcm46IHRoaXMucmVkaXJlY3RQYXRocy5zaWduSW4sXG4gICAgICAgIGZvcndhcmRlZFZhbHVlczoge1xuICAgICAgICAgIHF1ZXJ5U3RyaW5nOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgICBsYW1iZGFGdW5jdGlvbkFzc29jaWF0aW9uczogW3RoaXMuYXV0aEZsb3cucGFyc2VBdXRoXSxcbiAgICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIH0sXG4gICAgICB7XG4gICAgICAgIHBhdGhQYXR0ZXJuOiB0aGlzLnJlZGlyZWN0UGF0aHMuYXV0aFJlZnJlc2gsXG4gICAgICAgIGZvcndhcmRlZFZhbHVlczoge1xuICAgICAgICAgIHF1ZXJ5U3RyaW5nOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgICBsYW1iZGFGdW5jdGlvbkFzc29jaWF0aW9uczogW3RoaXMuYXV0aEZsb3cucmVmcmVzaEF1dGhdLFxuICAgICAgICAuLi5vcHRpb25zLFxuICAgICAgfSxcbiAgICAgIHtcbiAgICAgICAgcGF0aFBhdHRlcm46IHRoaXMuc2lnbk91dFVybFBhdGgsXG4gICAgICAgIGZvcndhcmRlZFZhbHVlczoge1xuICAgICAgICAgIHF1ZXJ5U3RyaW5nOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgICBsYW1iZGFGdW5jdGlvbkFzc29jaWF0aW9uczogW3RoaXMuYXV0aEZsb3cuc2lnbk91dF0sXG4gICAgICAgIC4uLm9wdGlvbnMsXG4gICAgICB9LFxuICAgIF07XG4gIH1cblxuICBwcml2YXRlIGdlbmVyYXRlTm9uY2VTaWduaW5nU2VjcmV0KCk6IHN0cmluZyB7XG4gICAgY29uc3QgeyBzZWNyZXQgfSA9IG5ldyBTZWNyZXRHZW5lcmF0b3IodGhpcywgJ1NlY3JldEdlbmVyYXRvcicpO1xuICAgIHJldHVybiBzZWNyZXQ7XG4gIH1cblxuICBwcml2YXRlIHJldHJpZXZlQ29nbml0b0F1dGhEb21haW4oKTogc3RyaW5nIHtcbiAgICBjb25zdCB1c2VyUG9vbERvbWFpbiA9IG5ldyBVc2VyUG9vbERvbWFpbih0aGlzLCAnVXNlclBvb2xEb21haW4nLCB7XG4gICAgICB1c2VyUG9vbDogdGhpcy51c2VyUG9vbCxcbiAgICB9KTtcblxuICAgIHJldHVybiB1c2VyUG9vbERvbWFpbi5jb2duaXRvQXV0aERvbWFpbjtcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIElTcGFBdXRob3JpemF0aW9uIGV4dGVuZHMgSUF1dGhvcml6YXRpb24ge1xuICByZWFkb25seSBtb2RlOiBNb2RlLlNQQTtcbn1cblxuZXhwb3J0IHR5cGUgU3BhQXV0aG9yaXphdGlvblByb3BzID0gQXV0aG9yaXphdGlvblByb3BzO1xuXG5leHBvcnQgY2xhc3MgU3BhQXV0aG9yaXphdGlvbiBleHRlbmRzIEF1dGhvcml6YXRpb24gaW1wbGVtZW50cyBJU3BhQXV0aG9yaXphdGlvbiB7XG4gIHB1YmxpYyByZWFkb25seSBtb2RlID0gTW9kZS5TUEE7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNwYUF1dGhvcml6YXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICB9XG5cbiAgcHJvdGVjdGVkIGNyZWF0ZVVzZXJQb29sQ2xpZW50KCk6IElVc2VyUG9vbENsaWVudCB7XG4gICAgcmV0dXJuIHRoaXMudXNlclBvb2wuYWRkQ2xpZW50KCdVc2VyUG9vbENsaWVudCcsIHtcbiAgICAgIGdlbmVyYXRlU2VjcmV0OiBmYWxzZSxcbiAgICAgIG9BdXRoOiB7XG4gICAgICAgIGZsb3dzOiB7XG4gICAgICAgICAgYXV0aG9yaXphdGlvbkNvZGVHcmFudDogdHJ1ZSxcbiAgICAgICAgfSxcbiAgICAgICAgc2NvcGVzOiB0aGlzLm9hdXRoU2NvcGVzLFxuICAgICAgfSxcbiAgICAgIHN1cHBvcnRlZElkZW50aXR5UHJvdmlkZXJzOiB0aGlzLmlkZW50aXR5UHJvdmlkZXJzLFxuICAgICAgcHJldmVudFVzZXJFeGlzdGVuY2VFcnJvcnM6IHRydWUsXG4gICAgfSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlQXV0aEZsb3cobG9nTGV2ZWw6IExvZ0xldmVsKTogQXV0aEZsb3cge1xuICAgIHJldHVybiBuZXcgQXV0aEZsb3codGhpcywgJ0F1dGhGbG93Jywge1xuICAgICAgbG9nTGV2ZWwsXG4gICAgICBodHRwSGVhZGVyczogdGhpcy5odHRwSGVhZGVycyxcbiAgICAgIHVzZXJQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgICAgdXNlclBvb2xDbGllbnQ6IHRoaXMudXNlclBvb2xDbGllbnQsXG4gICAgICBvYXV0aFNjb3BlczogdGhpcy5vYXV0aFNjb3BlcyxcbiAgICAgIHJlZGlyZWN0UGF0aHM6IHRoaXMucmVkaXJlY3RQYXRocyxcbiAgICAgIG5vbmNlU2lnbmluZ1NlY3JldDogdGhpcy5ub25jZVNpZ25pbmdTZWNyZXQsXG4gICAgICBjb2duaXRvQXV0aERvbWFpbjogdGhpcy5jb2duaXRvQXV0aERvbWFpbixcbiAgICAgIGNvb2tpZVNldHRpbmdzOiB0aGlzLmNvb2tpZVNldHRpbmdzID8/IHtcbiAgICAgICAgaWRUb2tlbjogJ1BhdGg9LzsgU2VjdXJlOyBTYW1lU2l0ZT1MYXgnLFxuICAgICAgICBhY2Nlc3NUb2tlbjogJ1BhdGg9LzsgU2VjdXJlOyBTYW1lU2l0ZT1MYXgnLFxuICAgICAgICByZWZyZXNoVG9rZW46ICdQYXRoPS87IFNlY3VyZTsgU2FtZVNpdGU9TGF4JyxcbiAgICAgICAgbm9uY2U6ICdQYXRoPS87IFNlY3VyZTsgSHR0cE9ubHk7IFNhbWVTaXRlPUxheCcsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSVN0YXRpY1NpdGVBdXRob3JpemF0aW9uIGV4dGVuZHMgSUF1dGhvcml6YXRpb24ge1xuICByZWFkb25seSBtb2RlOiBNb2RlLlNUQVRJQ19TSVRFO1xufVxuXG5leHBvcnQgdHlwZSBTdGF0aWNTaXRlQXV0aG9yaXphdGlvblByb3BzID0gQXV0aG9yaXphdGlvblByb3BzO1xuXG5leHBvcnQgY2xhc3MgU3RhdGljU2l0ZUF1dGhvcml6YXRpb24gZXh0ZW5kcyBBdXRob3JpemF0aW9uIGltcGxlbWVudHMgSVN0YXRpY1NpdGVBdXRob3JpemF0aW9uIHtcbiAgcHVibGljIHJlYWRvbmx5IG1vZGUgPSBNb2RlLlNUQVRJQ19TSVRFO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdGF0aWNTaXRlQXV0aG9yaXphdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlVXNlclBvb2xDbGllbnQoKTogSVVzZXJQb29sQ2xpZW50IHtcbiAgICByZXR1cm4gdGhpcy51c2VyUG9vbC5hZGRDbGllbnQoJ1VzZXJQb29sQ2xpZW50Jywge1xuICAgICAgZ2VuZXJhdGVTZWNyZXQ6IHRydWUsXG4gICAgICBvQXV0aDoge1xuICAgICAgICBmbG93czoge1xuICAgICAgICAgIGF1dGhvcml6YXRpb25Db2RlR3JhbnQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICAgIHNjb3BlczogdGhpcy5vYXV0aFNjb3BlcyxcbiAgICAgIH0sXG4gICAgICBzdXBwb3J0ZWRJZGVudGl0eVByb3ZpZGVyczogdGhpcy5pZGVudGl0eVByb3ZpZGVycyxcbiAgICAgIHByZXZlbnRVc2VyRXhpc3RlbmNlRXJyb3JzOiB0cnVlLFxuICAgIH0pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGNyZWF0ZUF1dGhGbG93KGxvZ0xldmVsOiBMb2dMZXZlbCk6IEF1dGhGbG93IHtcbiAgICBjb25zdCBjbGllbnRTZWNyZXQgPSB0aGlzLnJldHJpZXZlVXNlclBvb2xDbGllbnRTZWNyZXQoKTtcblxuICAgIHJldHVybiBuZXcgQXV0aEZsb3codGhpcywgJ0F1dGhGbG93Jywge1xuICAgICAgbG9nTGV2ZWwsXG4gICAgICBodHRwSGVhZGVyczogdGhpcy5odHRwSGVhZGVycyxcbiAgICAgIHVzZXJQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgICAgdXNlclBvb2xDbGllbnQ6IHRoaXMudXNlclBvb2xDbGllbnQsXG4gICAgICBvYXV0aFNjb3BlczogdGhpcy5vYXV0aFNjb3BlcyxcbiAgICAgIHJlZGlyZWN0UGF0aHM6IHRoaXMucmVkaXJlY3RQYXRocyxcbiAgICAgIG5vbmNlU2lnbmluZ1NlY3JldDogdGhpcy5ub25jZVNpZ25pbmdTZWNyZXQsXG4gICAgICBjb2duaXRvQXV0aERvbWFpbjogdGhpcy5jb2duaXRvQXV0aERvbWFpbixcbiAgICAgIGNsaWVudFNlY3JldCxcbiAgICAgIGNvb2tpZVNldHRpbmdzOiB0aGlzLmNvb2tpZVNldHRpbmdzID8/IHtcbiAgICAgICAgaWRUb2tlbjogJ1BhdGg9LzsgU2VjdXJlOyBIdHRwT25seTsgU2FtZVNpdGU9TGF4JyxcbiAgICAgICAgYWNjZXNzVG9rZW46ICdQYXRoPS87IFNlY3VyZTsgSHR0cE9ubHk7IFNhbWVTaXRlPUxheCcsXG4gICAgICAgIHJlZnJlc2hUb2tlbjogJ1BhdGg9LzsgU2VjdXJlOyBIdHRwT25seTsgU2FtZVNpdGU9TGF4JyxcbiAgICAgICAgbm9uY2U6ICdQYXRoPS87IFNlY3VyZTsgSHR0cE9ubHk7IFNhbWVTaXRlPUxheCcsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSByZXRyaWV2ZVVzZXJQb29sQ2xpZW50U2VjcmV0KCk6IHN0cmluZyB7XG4gICAgY29uc3QgeyBjbGllbnRTZWNyZXQgfSA9IG5ldyBSZXRyaWV2ZVVzZXJQb29sQ2xpZW50U2VjcmV0KHRoaXMsICdSZXRyaWV2ZVVzZXJQb29sQ2xpZW50U2VjcmV0Jywge1xuICAgICAgdXNlclBvb2w6IHRoaXMudXNlclBvb2wsXG4gICAgICB1c2VyUG9vbENsaWVudDogdGhpcy51c2VyUG9vbENsaWVudCxcbiAgICB9KTtcblxuICAgIHJldHVybiBjbGllbnRTZWNyZXQ7XG4gIH1cbn1cblxuZXhwb3J0IGVudW0gTW9kZSB7XG4gIFNQQSA9ICdTUEEnLFxuICBTVEFUSUNfU0lURSA9ICdTVEFUSUNfU0lURScsXG59XG4iXX0=