# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['compile_dcm2bids_config']
entry_points = \
{'console_scripts': ['compile-dcm2bids-config = compile_dcm2bids_config:main']}

setup_kwargs = {
    'name': 'compile-dcm2bids-config',
    'version': '1.2.0.post0',
    'description': 'Compile Dcm2Bids configuration files into a single config file.',
    'long_description': '# compile-dcm2bids-config\n\nCombine [`dcm2bids`](https://github.com/unfmontreal/Dcm2Bids) config files into a single config file while preserving the integrity of each separate config file\'s various `IntendedFor` fields.\n\n[![PyPI Version](https://img.shields.io/pypi/v/compile-dcm2bids-config.svg)](https://pypi.org/project/compile-dcm2bids-config/) [![codecov](https://codecov.io/gh/andrewrosss/compile-dcm2bids-config/branch/master/graph/badge.svg?token=BrgPPqwxv4)](https://codecov.io/gh/andrewrosss/compile-dcm2bids-config)\n[![Tests](https://github.com/andrewrosss/compile-dcm2bids-config/actions/workflows/test.yaml/badge.svg)](https://github.com/andrewrosss/compile-dcm2bids-config/actions/workflows/test.yaml)\n[![Code Style](https://github.com/andrewrosss/compile-dcm2bids-config/actions/workflows/lint.yaml/badge.svg)](https://github.com/andrewrosss/compile-dcm2bids-config/actions/workflows/lint.yaml)\n[![Type Check](https://github.com/andrewrosss/compile-dcm2bids-config/actions/workflows/type-check.yaml/badge.svg)](https://github.com/andrewrosss/compile-dcm2bids-config/actions/workflows/type-check.yaml)\n\n## Usage\n\n```bash\n$ compile-dcm2bids-config --help\nusage: compile-dcm2bids-config [-h] [-o OUT_FILE] [-v] in_file [in_file ...]\n\nCombine multiple dcm2bids config files into a single config file.\n\npositional arguments:\n  in_file               The JSON config files to combine\n\noptional arguments:\n  -h, --help            show this help message and exit\n  -o OUT_FILE, --out-file OUT_FILE\n                        The file to write the combined config file to. If not specified\n                        outputs are written to stdout.\n  -v, --version         show program\'s version number and exit\n```\n\n## Getting Started\n\nSuppose you have two config files:\n\n**`example/config1.json`:**\n\n```json\n{\n  "descriptions": [\n    {\n      "dataType": "anat",\n      "modalityLabel": "SWI",\n      "criteria": {\n        "SeriesDescription": "*SWI*"\n      }\n    },\n    {\n      "dataType": "fmap",\n      "modalityLabel": "fmap",\n      "criteria": {\n        "SidecarFilename": "*echo-4*"\n      },\n      "IntendedFor": 0\n    }\n  ]\n}\n```\n\n**`example/config2.json`:**\n\n```json\n{\n  "descriptions": [\n    {\n      "dataType": "dwi",\n      "modalityLabel": "dwi",\n      "criteria": {\n        "SeriesDescription": "*DWI*"\n      }\n    },\n    {\n      "dataType": "anat",\n      "modalityLabel": "SWI",\n      "criteria": {\n        "SeriesDescription": "*SWI*"\n      }\n    },\n    {\n      "id": "my-func",\n      "dataType": "func",\n      "modalityLabel": "bold",\n      "customLabels": "task-rest",\n      "criteria": {\n        "SeriesDescription": "rs_fMRI"\n      },\n      "sidecarChanges": {\n        "SeriesDescription": "rsfMRI"\n      }\n    },\n    {\n      "dataType": "fmap",\n      "modalityLabel": "fmap",\n      "criteria": {\n        "SidecarFilename": "*echo-3*"\n      },\n      "IntendedFor": [0, "my-func"]\n    }\n  ]\n}\n```\n\nThen we can combine the two using the following command (outputs are written to stdout by default):\n\n```bash\n$ compile-dcm2bids-config example/config1.json example/config2.json\n{\n  "descriptions": [\n    {\n      "dataType": "anat",\n      "modalityLabel": "SWI",\n      "criteria": {\n        "SeriesDescription": "*SWI*"\n      }\n    },\n    {\n      "dataType": "fmap",\n      "modalityLabel": "fmap",\n      "criteria": {\n        "SidecarFilename": "*echo-4*"\n      },\n      "IntendedFor": 0\n    },\n    {\n      "dataType": "dwi",\n      "modalityLabel": "dwi",\n      "criteria": {\n        "SeriesDescription": "*DWI*"\n      }\n    },\n    {\n      "dataType": "anat",\n      "modalityLabel": "SWI",\n      "criteria": {\n        "SeriesDescription": "*SWI*"\n      }\n    },\n    {\n      "id": "my-func",\n      "dataType": "func",\n      "modalityLabel": "bold",\n      "customLabels": "task-rest",\n      "criteria": {\n        "SeriesDescription": "rs_fMRI"\n      },\n      "sidecarChanges": {\n        "SeriesDescription": "rsfMRI"\n      }\n    },\n    {\n      "dataType": "fmap",\n      "modalityLabel": "fmap",\n      "criteria": {\n        "SidecarFilename": "*echo-3*"\n      },\n      "IntendedFor": [\n        2,\n        "my-func"\n      ]\n    }\n  ]\n}\n```\n\nNotice that the `IntendedFor` fields have been updated appropriately.\n\n## Python API\n\nYou can also use this tool from within python:\n\n```python\nimport json\nfrom pathlib import Path\nfrom pprint import pp\n\nfrom compile_dcm2bids_config import combine_config\n\n\nconfig1 = json.loads(Path("example/config1.json").read_text())\nconfig2 = json.loads(Path("example/config2.json").read_text())\n\nall_together = combine_config([config1, config2])\n\npp(all_together)\n```\n\nThe result being:\n\n```python\n{\'descriptions\': [{\'dataType\': \'anat\',\n                   \'modalityLabel\': \'SWI\',\n                   \'criteria\': {\'SeriesDescription\': \'*SWI*\'}},\n                  {\'dataType\': \'fmap\',\n                   \'modalityLabel\': \'fmap\',\n                   \'criteria\': {\'SidecarFilename\': \'*echo-4*\'},\n                   \'IntendedFor\': 0},\n                  {\'dataType\': \'dwi\',\n                   \'modalityLabel\': \'dwi\',\n                   \'criteria\': {\'SeriesDescription\': \'*DWI*\'}},\n                  {\'dataType\': \'anat\',\n                   \'modalityLabel\': \'SWI\',\n                   \'criteria\': {\'SeriesDescription\': \'*SWI*\'}},\n                  {\'id\': \'my-func\',\n                   \'dataType\': \'func\',\n                   \'modalityLabel\': \'bold\',\n                   \'customLabels\': \'task-rest\',\n                   \'criteria\': {\'SeriesDescription\': \'rs_fMRI\'},\n                   \'sidecarChanges\': {\'SeriesDescription\': \'rsfMRI\'}},\n                  {\'dataType\': \'fmap\',\n                   \'modalityLabel\': \'fmap\',\n                   \'criteria\': {\'SidecarFilename\': \'*echo-3*\'},\n                   \'IntendedFor\': [2, \'my-func\']}]}\n```\n\n## Contributing\n\n1. Have or install a recent version of `poetry` (version >= 1.1)\n1. Fork the repo\n1. Setup a virtual environment (however you prefer)\n1. Run `poetry install`\n1. Run `pre-commit install`\n1. Add your changes (adding/updating tests is always nice too)\n1. Commit your changes + push to your fork\n1. Open a PR\n',
    'author': 'Andrew Ross',
    'author_email': 'andrew.ross.mail@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/andrewrosss/compile-dcm2bids-config',
    'package_dir': package_dir,
    'py_modules': modules,
    'entry_points': entry_points,
    'python_requires': '>=3.6.2,<4.0',
}


setup(**setup_kwargs)
