# coding: utf-8

"""
    Gemma RESTful API

    This website documents the usage of the [Gemma RESTful API](https://gemma.msl.ubc.ca/rest/v2/). Here you can find example script usage of the API, as well as graphical interface for each endpoint, with description of its parameters and the endpoint URL.  Use of this webpage and the Gemma Web services, including the REST API, is subject to [these terms and conditions](https://pavlidislab.github.io/Gemma/terms.html). Please read these in full before continuing to use this webpage or any other part of the Gemma system.  Fix return type for `getResultSets` which was incorrectly referring to a renamed VO.  Remove the `security` requirements by default from the specification, which forced the Python package to supply empty credentials. There is currently no privileged endpoints, although some can return additional results.  ## Updates  ### Update 2.5.1  Restore `objectClass` visibility in `AnnotationValueObject`.  Fix incorrect response types for annotations search endpoints returning datasets.  ### Update 2.5.0  Major cleanups were performed in this release in order to stabilize the specification. Numerous properties from Gemma Web that were never intended to be exposed in Gemma REST have been hidden. It's a bit too much to describe in here, but you can navigate to the schemas section below to get a good glance at the models.  Favour `numberOfSomething` instead of `somethingCount` which is clearer. The older names are kept for backward-compatibility, but should be considered deprecated.  Gene aliases and multifunctionality rank are now filled in `GeneValueObject`.  Uniformly use `TaxonValueObject` to represent taxon. This is breaking change for the `ExpressionExperimentValueObject` and `ArrayDesignValueObject` as their `taxon` property will be an `object` instead of a `string`. Properties such as `taxonId` are now deprecated and `taxon.id` should be used instead.  Entities that have IDs now all inherit from `IdentifiableValueObject`. This implies that you can assume the presence of an `id` in a search result `resultObject` attribute for example.  New `/search` endpoint! for an unified search experience. Annotation-based search endpoints under `/annotations` are now deprecated.  New API docs! While not as nice looking, the previous theme will be gradually ported to Swagger UI as we focused on functionality over prettiness for this release.  ### Update 2.4.0 through 2.4.1  Release notes for the 2.4 series were not written down, so I'll try to do my best to recall features that were introduced at that time.  An [OpenAPI](https://www.openapis.org/) specification was introduced and available under `/rest/v2/openapi.json`, although not fully stabilized.  Add a `/resultSets` endpoint to navigate result sets directly, by ID or by dataset.  Add a `/resultSets/{resultSetId}` endpoint to retrieve a specific result set by its ID. This endpoint can be negotiated with an `Accept: text/tab-separated-values` header to obtain a TSV representation.  Add a `/datasets/{dataset}/analyses/differential/resultSets` endpoint that essentially redirect to a specific `/resultSet` endpoint by dataset ID.  Add an endpoint to retrieve preferred raw expression vectors.  ### Update 2.3.4  November 6th, 2018  November 6th [2.3.4] Bug fixes in the dataset search endpoint.  November 5th [2.3.3] Added filtering parameters to dataset search.  October 25th [2.3.2] Changed behavior of the dataset search endpoint to more closely match the Gemma web interface.  October 2nd [2.3.1] Added group information to the User value object.  September 27th [2.3.0] Breaking change in Taxa: Abbreviation property has been removed and is therefore no longer an accepted identifier.  ### Update 2.2.6  June 7th, 2018  Code maintenance, bug fixes. Geeq scores stable and made public.  June 7th [2.2.6] Added: User authentication endpoint.  May 2nd [2.2.5] Fixed: Cleaned up and optimized platforms/elements endpoint, removed redundant information (recursive properties nesting).  April 12th [2.2.3] Fixed: Array arguments not handling non-string properties properly, e.g. `ncbiIds` of genes.  April 9th [2.2.1] Fixed: Filter argument not working when the filtered field was a primitive type. This most significantly allows filtering by geeq boolean and double properties.  ### Update 2.2.0  February 8th, 2018  Breaking change in the 'Dataset differential analysis' endpoint: - No longer using `qValueThreshold` parameter. - Response format changed, now using `DifferentialExpressionAnalysisValueObject` instead of `DifferentialExpressionValueObject` - [Experimental] Added Geeq (Gene Expression Experiment Quality) scores to the dataset value objects   # noqa: E501

    OpenAPI spec version: 2.5.1
    Contact: pavlab-support@msl.ubc.ca
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ArrayDesignValueObject(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'int',
        'last_updated': 'datetime',
        'troubled': 'bool',
        'last_troubled_event': 'AuditEventValueObject',
        'needs_attention': 'bool',
        'last_needs_attention_event': 'AuditEventValueObject',
        'curation_note': 'str',
        'last_note_update_event': 'AuditEventValueObject',
        'color': 'str',
        'description': 'str',
        'expression_experiment_count': 'int',
        'is_merged': 'bool',
        'is_mergee': 'bool',
        'name': 'str',
        'short_name': 'str',
        'technology_type': 'str',
        'number_of_expression_experiments': 'int',
        'taxon_id': 'int',
        'trouble_details': 'str',
        'number_of_switched_expression_experiments': 'int',
        'taxon': 'TaxonValueObject'
    }

    attribute_map = {
        'id': 'id',
        'last_updated': 'lastUpdated',
        'troubled': 'troubled',
        'last_troubled_event': 'lastTroubledEvent',
        'needs_attention': 'needsAttention',
        'last_needs_attention_event': 'lastNeedsAttentionEvent',
        'curation_note': 'curationNote',
        'last_note_update_event': 'lastNoteUpdateEvent',
        'color': 'color',
        'description': 'description',
        'expression_experiment_count': 'expressionExperimentCount',
        'is_merged': 'isMerged',
        'is_mergee': 'isMergee',
        'name': 'name',
        'short_name': 'shortName',
        'technology_type': 'technologyType',
        'number_of_expression_experiments': 'numberOfExpressionExperiments',
        'taxon_id': 'taxonID',
        'trouble_details': 'troubleDetails',
        'number_of_switched_expression_experiments': 'numberOfSwitchedExpressionExperiments',
        'taxon': 'taxon'
    }

    def __init__(self, id=None, last_updated=None, troubled=None, last_troubled_event=None, needs_attention=None, last_needs_attention_event=None, curation_note=None, last_note_update_event=None, color=None, description=None, expression_experiment_count=None, is_merged=None, is_mergee=None, name=None, short_name=None, technology_type=None, number_of_expression_experiments=None, taxon_id=None, trouble_details=None, number_of_switched_expression_experiments=None, taxon=None):  # noqa: E501
        """ArrayDesignValueObject - a model defined in Swagger"""  # noqa: E501
        self._id = None
        self._last_updated = None
        self._troubled = None
        self._last_troubled_event = None
        self._needs_attention = None
        self._last_needs_attention_event = None
        self._curation_note = None
        self._last_note_update_event = None
        self._color = None
        self._description = None
        self._expression_experiment_count = None
        self._is_merged = None
        self._is_mergee = None
        self._name = None
        self._short_name = None
        self._technology_type = None
        self._number_of_expression_experiments = None
        self._taxon_id = None
        self._trouble_details = None
        self._number_of_switched_expression_experiments = None
        self._taxon = None
        self.discriminator = None
        if id is not None:
            self.id = id
        if last_updated is not None:
            self.last_updated = last_updated
        if troubled is not None:
            self.troubled = troubled
        if last_troubled_event is not None:
            self.last_troubled_event = last_troubled_event
        if needs_attention is not None:
            self.needs_attention = needs_attention
        if last_needs_attention_event is not None:
            self.last_needs_attention_event = last_needs_attention_event
        if curation_note is not None:
            self.curation_note = curation_note
        if last_note_update_event is not None:
            self.last_note_update_event = last_note_update_event
        if color is not None:
            self.color = color
        if description is not None:
            self.description = description
        if expression_experiment_count is not None:
            self.expression_experiment_count = expression_experiment_count
        if is_merged is not None:
            self.is_merged = is_merged
        if is_mergee is not None:
            self.is_mergee = is_mergee
        if name is not None:
            self.name = name
        if short_name is not None:
            self.short_name = short_name
        if technology_type is not None:
            self.technology_type = technology_type
        if number_of_expression_experiments is not None:
            self.number_of_expression_experiments = number_of_expression_experiments
        if taxon_id is not None:
            self.taxon_id = taxon_id
        if trouble_details is not None:
            self.trouble_details = trouble_details
        if number_of_switched_expression_experiments is not None:
            self.number_of_switched_expression_experiments = number_of_switched_expression_experiments
        if taxon is not None:
            self.taxon = taxon

    @property
    def id(self):
        """Gets the id of this ArrayDesignValueObject.  # noqa: E501


        :return: The id of this ArrayDesignValueObject.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ArrayDesignValueObject.


        :param id: The id of this ArrayDesignValueObject.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def last_updated(self):
        """Gets the last_updated of this ArrayDesignValueObject.  # noqa: E501


        :return: The last_updated of this ArrayDesignValueObject.  # noqa: E501
        :rtype: datetime
        """
        return self._last_updated

    @last_updated.setter
    def last_updated(self, last_updated):
        """Sets the last_updated of this ArrayDesignValueObject.


        :param last_updated: The last_updated of this ArrayDesignValueObject.  # noqa: E501
        :type: datetime
        """

        self._last_updated = last_updated

    @property
    def troubled(self):
        """Gets the troubled of this ArrayDesignValueObject.  # noqa: E501


        :return: The troubled of this ArrayDesignValueObject.  # noqa: E501
        :rtype: bool
        """
        return self._troubled

    @troubled.setter
    def troubled(self, troubled):
        """Sets the troubled of this ArrayDesignValueObject.


        :param troubled: The troubled of this ArrayDesignValueObject.  # noqa: E501
        :type: bool
        """

        self._troubled = troubled

    @property
    def last_troubled_event(self):
        """Gets the last_troubled_event of this ArrayDesignValueObject.  # noqa: E501


        :return: The last_troubled_event of this ArrayDesignValueObject.  # noqa: E501
        :rtype: AuditEventValueObject
        """
        return self._last_troubled_event

    @last_troubled_event.setter
    def last_troubled_event(self, last_troubled_event):
        """Sets the last_troubled_event of this ArrayDesignValueObject.


        :param last_troubled_event: The last_troubled_event of this ArrayDesignValueObject.  # noqa: E501
        :type: AuditEventValueObject
        """

        self._last_troubled_event = last_troubled_event

    @property
    def needs_attention(self):
        """Gets the needs_attention of this ArrayDesignValueObject.  # noqa: E501


        :return: The needs_attention of this ArrayDesignValueObject.  # noqa: E501
        :rtype: bool
        """
        return self._needs_attention

    @needs_attention.setter
    def needs_attention(self, needs_attention):
        """Sets the needs_attention of this ArrayDesignValueObject.


        :param needs_attention: The needs_attention of this ArrayDesignValueObject.  # noqa: E501
        :type: bool
        """

        self._needs_attention = needs_attention

    @property
    def last_needs_attention_event(self):
        """Gets the last_needs_attention_event of this ArrayDesignValueObject.  # noqa: E501


        :return: The last_needs_attention_event of this ArrayDesignValueObject.  # noqa: E501
        :rtype: AuditEventValueObject
        """
        return self._last_needs_attention_event

    @last_needs_attention_event.setter
    def last_needs_attention_event(self, last_needs_attention_event):
        """Sets the last_needs_attention_event of this ArrayDesignValueObject.


        :param last_needs_attention_event: The last_needs_attention_event of this ArrayDesignValueObject.  # noqa: E501
        :type: AuditEventValueObject
        """

        self._last_needs_attention_event = last_needs_attention_event

    @property
    def curation_note(self):
        """Gets the curation_note of this ArrayDesignValueObject.  # noqa: E501


        :return: The curation_note of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._curation_note

    @curation_note.setter
    def curation_note(self, curation_note):
        """Sets the curation_note of this ArrayDesignValueObject.


        :param curation_note: The curation_note of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._curation_note = curation_note

    @property
    def last_note_update_event(self):
        """Gets the last_note_update_event of this ArrayDesignValueObject.  # noqa: E501


        :return: The last_note_update_event of this ArrayDesignValueObject.  # noqa: E501
        :rtype: AuditEventValueObject
        """
        return self._last_note_update_event

    @last_note_update_event.setter
    def last_note_update_event(self, last_note_update_event):
        """Sets the last_note_update_event of this ArrayDesignValueObject.


        :param last_note_update_event: The last_note_update_event of this ArrayDesignValueObject.  # noqa: E501
        :type: AuditEventValueObject
        """

        self._last_note_update_event = last_note_update_event

    @property
    def color(self):
        """Gets the color of this ArrayDesignValueObject.  # noqa: E501


        :return: The color of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._color

    @color.setter
    def color(self, color):
        """Sets the color of this ArrayDesignValueObject.


        :param color: The color of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._color = color

    @property
    def description(self):
        """Gets the description of this ArrayDesignValueObject.  # noqa: E501


        :return: The description of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this ArrayDesignValueObject.


        :param description: The description of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def expression_experiment_count(self):
        """Gets the expression_experiment_count of this ArrayDesignValueObject.  # noqa: E501


        :return: The expression_experiment_count of this ArrayDesignValueObject.  # noqa: E501
        :rtype: int
        """
        return self._expression_experiment_count

    @expression_experiment_count.setter
    def expression_experiment_count(self, expression_experiment_count):
        """Sets the expression_experiment_count of this ArrayDesignValueObject.


        :param expression_experiment_count: The expression_experiment_count of this ArrayDesignValueObject.  # noqa: E501
        :type: int
        """

        self._expression_experiment_count = expression_experiment_count

    @property
    def is_merged(self):
        """Gets the is_merged of this ArrayDesignValueObject.  # noqa: E501


        :return: The is_merged of this ArrayDesignValueObject.  # noqa: E501
        :rtype: bool
        """
        return self._is_merged

    @is_merged.setter
    def is_merged(self, is_merged):
        """Sets the is_merged of this ArrayDesignValueObject.


        :param is_merged: The is_merged of this ArrayDesignValueObject.  # noqa: E501
        :type: bool
        """

        self._is_merged = is_merged

    @property
    def is_mergee(self):
        """Gets the is_mergee of this ArrayDesignValueObject.  # noqa: E501


        :return: The is_mergee of this ArrayDesignValueObject.  # noqa: E501
        :rtype: bool
        """
        return self._is_mergee

    @is_mergee.setter
    def is_mergee(self, is_mergee):
        """Sets the is_mergee of this ArrayDesignValueObject.


        :param is_mergee: The is_mergee of this ArrayDesignValueObject.  # noqa: E501
        :type: bool
        """

        self._is_mergee = is_mergee

    @property
    def name(self):
        """Gets the name of this ArrayDesignValueObject.  # noqa: E501


        :return: The name of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this ArrayDesignValueObject.


        :param name: The name of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def short_name(self):
        """Gets the short_name of this ArrayDesignValueObject.  # noqa: E501


        :return: The short_name of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._short_name

    @short_name.setter
    def short_name(self, short_name):
        """Sets the short_name of this ArrayDesignValueObject.


        :param short_name: The short_name of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._short_name = short_name

    @property
    def technology_type(self):
        """Gets the technology_type of this ArrayDesignValueObject.  # noqa: E501


        :return: The technology_type of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._technology_type

    @technology_type.setter
    def technology_type(self, technology_type):
        """Sets the technology_type of this ArrayDesignValueObject.


        :param technology_type: The technology_type of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._technology_type = technology_type

    @property
    def number_of_expression_experiments(self):
        """Gets the number_of_expression_experiments of this ArrayDesignValueObject.  # noqa: E501


        :return: The number_of_expression_experiments of this ArrayDesignValueObject.  # noqa: E501
        :rtype: int
        """
        return self._number_of_expression_experiments

    @number_of_expression_experiments.setter
    def number_of_expression_experiments(self, number_of_expression_experiments):
        """Sets the number_of_expression_experiments of this ArrayDesignValueObject.


        :param number_of_expression_experiments: The number_of_expression_experiments of this ArrayDesignValueObject.  # noqa: E501
        :type: int
        """

        self._number_of_expression_experiments = number_of_expression_experiments

    @property
    def taxon_id(self):
        """Gets the taxon_id of this ArrayDesignValueObject.  # noqa: E501


        :return: The taxon_id of this ArrayDesignValueObject.  # noqa: E501
        :rtype: int
        """
        return self._taxon_id

    @taxon_id.setter
    def taxon_id(self, taxon_id):
        """Sets the taxon_id of this ArrayDesignValueObject.


        :param taxon_id: The taxon_id of this ArrayDesignValueObject.  # noqa: E501
        :type: int
        """

        self._taxon_id = taxon_id

    @property
    def trouble_details(self):
        """Gets the trouble_details of this ArrayDesignValueObject.  # noqa: E501


        :return: The trouble_details of this ArrayDesignValueObject.  # noqa: E501
        :rtype: str
        """
        return self._trouble_details

    @trouble_details.setter
    def trouble_details(self, trouble_details):
        """Sets the trouble_details of this ArrayDesignValueObject.


        :param trouble_details: The trouble_details of this ArrayDesignValueObject.  # noqa: E501
        :type: str
        """

        self._trouble_details = trouble_details

    @property
    def number_of_switched_expression_experiments(self):
        """Gets the number_of_switched_expression_experiments of this ArrayDesignValueObject.  # noqa: E501


        :return: The number_of_switched_expression_experiments of this ArrayDesignValueObject.  # noqa: E501
        :rtype: int
        """
        return self._number_of_switched_expression_experiments

    @number_of_switched_expression_experiments.setter
    def number_of_switched_expression_experiments(self, number_of_switched_expression_experiments):
        """Sets the number_of_switched_expression_experiments of this ArrayDesignValueObject.


        :param number_of_switched_expression_experiments: The number_of_switched_expression_experiments of this ArrayDesignValueObject.  # noqa: E501
        :type: int
        """

        self._number_of_switched_expression_experiments = number_of_switched_expression_experiments

    @property
    def taxon(self):
        """Gets the taxon of this ArrayDesignValueObject.  # noqa: E501


        :return: The taxon of this ArrayDesignValueObject.  # noqa: E501
        :rtype: TaxonValueObject
        """
        return self._taxon

    @taxon.setter
    def taxon(self, taxon):
        """Sets the taxon of this ArrayDesignValueObject.


        :param taxon: The taxon of this ArrayDesignValueObject.  # noqa: E501
        :type: TaxonValueObject
        """

        self._taxon = taxon

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ArrayDesignValueObject, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ArrayDesignValueObject):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
