LIGHT_MODE = 0
DARK_MODE = 1
DARK_DIMMED_MODE = 2


COLOR_SCALE_GRAY = (
    ("#fafbfc", "#f0f6fc", "#cdd9e5"),
    ("#f6f8fa", "#c9d1d9", "#adbac7"),
    ("#e1e4e8", "#b1bac4", "#909dab"),
    ("#d1d5da", "#8b949e", "#768390"),
    ("#959da5", "#6e7681", "#636e7b"),
    ("#6a737d", "#484f58", "#545d68"),
    ("#586069", "#30363d", "#444c56"),
    ("#444d56", "#21262d", "#373e47"),
    ("#2f363d", "#161b22", "#2d333b"),
    ("#24292e", "#0d1117", "#22272e"),
)

COLOR_SCALE_BLUE = (
    ("#f1f8ff", "#cae8ff", "#c6e6ff"),
    ("#dbedff", "#a5d6ff", "#96d0ff"),
    ("#c8e1ff", "#79c0ff", "#6cb6ff"),
    ("#79b8ff", "#58a6ff", "#539bf5"),
    ("#2188ff", "#388bfd", "#4184e4"),
    ("#0366d6", "#1f6feb", "#316dca"),
    ("#005cc5", "#1158c7", "#255ab2"),
    ("#044289", "#0d419d", "#1b4b91"),
    ("#032f62", "#0c2d6b", "#143d79"),
    ("#05264c", "#051d4d", "#0f2d5c"),
)


COLOR_SCHEMA = (
    {
        "fg": "#c6c8d1",
        "bg": "#161821",
        "highlight": "#1e2132",
        "bg-canvas": "#ffffff",
        "bg-canvas-mobile": "#ffffff",
        "bg-canvas-inverse": "#24292e",
        "bg-canvas-inset": "#24292e",
        "bg-primary": "#ffffff",
        "bg-secondary": "#fafbfc",
        "bg-tertiary": "#f6f8fa",
        "bg-overlay": "#ffffff",
        "bg-backdrop": "#8d8f91",
        "bg-info": "#f1f8ff",
        "bg-info-inverse": "#0366d6",
        "bg-danger": "#ffeef0",
        "bg-danger-inverse": "#d73a49",
        "bg-success": "#fff5b1",
        "bg-success-inverse": "#28a745",
        "bg-warning": "#fff5b1",
        "bg-warning-inverse": "#ffd33d",
        "text-primary": "#24292e",
        "text-secondary": "#586069",
        "text-tertiary": "#6a737d",
        "text-placeholder": "#6a737d",
        "text-disabled": "#959da5",
        "text-link": "#0366d6",
        "text-danger": "#cb2431",
        "text-success": "#22863a",
        "text-warning": "#b08800",
        "border-primary": "#e1e4e8",
        "border-secondary": "#ebedef",
        "border-tertiary": "#d1d5da",
        "border-overlay": "#e1e4e8",
        "border-inverse": "#ffffff",
        "border-info": "#0366d6",
        "border-danger": "#d73a49",
        "border-success": "#67dc82",
        "border-warning": "#f9c513",
    },
    {
        "bg-canvas": "#f0f6fc",
        "bg-canvas-mobile": "#010409",
        "bg-canvas-inverse": "#f0f6fc",
        "bg-canvas-inset": "#090c10",
        "bg-primary": "#0d1117",
        "bg-secondary": "#0d1117",
        "bg-tertiary": "#161b22",
        "bg-overlay": "#1c2128",
        "bg-backdrop": "#04060c",
        "bg-info": "#121d2f",
        "bg-info-inverse": "#388bfd",
        "bg-danger": "#25171c",
        "bg-danger-inverse": "#da3633",
        "bg-success": "#111f1c",
        "bg-success-inverse": "#2ea043",
        "bg-warning": "#1f1c16",
        "bg-warning-inverse": "#bb8009",
        "text-primary": "#c9d1d9",
        "text-secondary": "#8b949e",
        "text-tertiary": "#8b949e",
        "text-placeholder": "#484f58",
        "text-disabled": "#484f58",
        "text-link": "#166ff0",
        "text-danger": "#f85149",
        "text-success": "#169858",
        "text-warning": "#e3b341",
        "text-white": "#ffffff",
        "border-primary": "#30363d",
        "border-secondary": "#21262d",
        "border-tertiary": "#6e7681",
        "border-overlay": "#30363d",
        "border-inverse": "#f0f6fc",
        "border-info": "#1e4273",
        "border-danger": "#6b2a2b",
        "border-success": "#1c4328",
        "border-warning": "#533d12",
    },
)
