# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : October 2014
    Copyright            : (C) 2014 by Alessandro Pasotti
    Email                : elpaso at itopen dot it
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Alessandro Pasotti'
__date__ = 'October 2014'
__copyright__ = '(C) 2014, Alessandro Pasotti'

from typing import (Any, Callable, Dict, Iterable, List, Optional, Union,
                    Sequence, Tuple, overload)

from PyQt5 import QtCore, QtGui, QtXml

from .core import (Qgis, QgsCoordinateReferenceSystem, QgsDateRange,
                   QgsDateTimeRange, QgsExpression, QgsFeature,
                   QgsFeatureFilterProvider, QgsFeatureRequest, QgsGeometry,
                   QgsMapLayer, QgsMessageLogConsole, QgsProject,
                   QgsProjectBadLayerHandler, QgsRectangle, QgsVectorLayer,
                   QgsVectorLayerServerProperties)
from ._types import sip

# Convenient type aliases.
PYQT_SIGNAL = Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = Union[Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = Union[Sequence[int], Sequence[float], sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = Union[
    Sequence[int], Sequence[float], sip.Buffer, int, None]


class QgsCapabilitiesCache(QtCore.QObject):

    def __init__(self) -> None: ...
    def removeCapabilitiesDocument(self, path: str) -> None: ...
    def insertCapabilitiesDocument(self, configFilePath: str, key: str, doc: QtXml.QDomDocument) -> None: ...
    def searchCapabilitiesDocument(self, configFilePath: str, key: str) -> QtXml.QDomDocument: ...


class QgsConfigCache(QtCore.QObject):

    def project(self, path: str, settings: Optional[QgsServerSettings] = ...) -> QgsProject: ...
    def removeEntry(self, path: str) -> None: ...
    @staticmethod
    def instance() -> QgsConfigCache: ...


class QgsServerApi(sip.wrapper):

    @overload
    def __init__(self, serverIface: QgsServerInterface) -> None: ...
    @overload
    def __init__(self, a0: QgsServerApi) -> None: ...
    def serverIface(self) -> QgsServerInterface: ...
    def executeRequest(self, context: QgsServerApiContext) -> None: ...
    def accept(self, url: QtCore.QUrl) -> bool: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerApiContext(sip.wrapper):

    @overload
    def __init__(self, apiRootPath: str, request: QgsServerRequest, response: QgsServerResponse, project: QgsProject, serverInterface: QgsServerInterface) -> None: ...
    @overload
    def __init__(self, a0: QgsServerApiContext) -> None: ...
    def setRequest(self, request: QgsServerRequest) -> None: ...
    def apiRootPath(self) -> str: ...
    def matchedPath(self) -> str: ...
    def serverInterface(self) -> QgsServerInterface: ...
    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...
    def response(self) -> QgsServerResponse: ...
    def request(self) -> QgsServerRequest: ...


class QgsServerLogger(QgsMessageLogConsole):

    def __init__(self) -> None: ...
    def logMessage(self, message: str, tag: str, level: Qgis.MessageLevel) -> None: ...
    def setLogStderr(self) -> None: ...
    def setLogFile(self, filename: str = ...) -> None: ...
    def setLogLevel(self, level: Qgis.MessageLevel) -> None: ...
    def logLevel(self) -> Qgis.MessageLevel: ...
    @staticmethod
    def instance() -> QgsServerLogger: ...


class QgsServerOgcApi(QgsServerApi):

    class ContentType(int):
        ...

    GEOJSON: QgsServerOgcApi.ContentType = ...
    OPENAPI3: QgsServerOgcApi.ContentType = ...
    JSON: QgsServerOgcApi.ContentType = ...
    HTML: QgsServerOgcApi.ContentType = ...
    XML: QgsServerOgcApi.ContentType = ...

    class Rel(int):
        ...

    alternate: QgsServerOgcApi.Rel = ...
    describedBy: QgsServerOgcApi.Rel = ...
    collection: QgsServerOgcApi.Rel = ...
    item: QgsServerOgcApi.Rel = ...
    self: QgsServerOgcApi.Rel = ...
    service_desc: QgsServerOgcApi.Rel = ...
    service_doc: QgsServerOgcApi.Rel = ...
    prev: QgsServerOgcApi.Rel = ...
    next: QgsServerOgcApi.Rel = ...
    license: QgsServerOgcApi.Rel = ...
    items: QgsServerOgcApi.Rel = ...
    conformance: QgsServerOgcApi.Rel = ...
    data: QgsServerOgcApi.Rel = ...
    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, serverIface: QgsServerInterface, rootPath: str, name: str, description: str = ..., version: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsServerOgcApi) -> None: ...
    @staticmethod
    def mimeType(contentType: QgsServerOgcApi.ContentType) -> Any: ...
    @staticmethod
    def contenTypeFromExtension(extension: Any) -> QgsServerOgcApi.ContentType: ...
    @staticmethod
    def contentTypeToExtension(ct: QgsServerOgcApi.ContentType) -> str: ...
    @staticmethod
    def contentTypeToStdString(ct: QgsServerOgcApi.ContentType) -> Any: ...
    @staticmethod
    def contentTypeToString(ct: QgsServerOgcApi.ContentType) -> str: ...
    @staticmethod
    def relToString(rel: QgsServerOgcApi.Rel) -> Any: ...
    @staticmethod
    def sanitizeUrl(url: QtCore.QUrl) -> QtCore.QUrl: ...
    def registerHandler(self, handler: QgsServerOgcApiHandler) -> None: ...
    def executeRequest(self, context: QgsServerApiContext) -> None: ...
    def rootPath(self) -> str: ...
    def version(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...


class QgsServerOgcApiHandler(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsServerOgcApiHandler) -> None: ...
    def setContentTypes(self, contentTypes: Iterable[int]) -> None: ...
    @staticmethod
    def layerFromCollectionId(context: QgsServerApiContext, collectionId: str) -> QgsVectorLayer: ...
    @staticmethod
    def parentLink(url: QtCore.QUrl, levels: int = ...) -> str: ...
    def contentTypeFromRequest(self, request: QgsServerRequest) -> QgsServerOgcApi.ContentType: ...
    def staticPath(self, context: QgsServerApiContext) -> str: ...
    def templatePath(self, context: QgsServerApiContext) -> str: ...
    def href(self, context: QgsServerApiContext, extraPath: str = ..., extension: str = ...) -> Any: ...
    def write(self, data: Any, context: QgsServerApiContext, htmlMetadata: Dict[str, Any] = ...) -> None: ...
    def contentTypeForAccept(self, accept: str) -> str: ...
    def values(self, context: QgsServerApiContext) -> Dict[str, Any]: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...
    def defaultContentType(self) -> QgsServerOgcApi.ContentType: ...
    def tags(self) -> List[str]: ...
    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> Any: ...
    def description(self) -> Any: ...
    def summary(self) -> Any: ...
    def parameters(self, context: QgsServerApiContext) -> List['QgsServerQueryStringParameter']: ...
    def operationId(self) -> Any: ...
    def path(self) -> QtCore.QRegularExpression: ...


class QgsServerStaticHandler(QgsServerOgcApiHandler):

    @overload
    def __init__(self, pathRegExp: str = ..., staticPathSuffix: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsServerStaticHandler) -> None: ...
    def linkType(self) -> QgsServerOgcApi.Rel: ...
    def linkTitle(self) -> Any: ...
    def description(self) -> Any: ...
    def summary(self) -> Any: ...
    def operationId(self) -> Any: ...
    def path(self) -> QtCore.QRegularExpression: ...
    def handleRequest(self, context: QgsServerApiContext) -> None: ...


class QgsServerParameterDefinition(sip.wrapper):

    mDefaultValue: Any = ...
    mType: QtCore.QVariant.Type = ...
    mValue: Any = ...

    @overload
    def __init__(self, type: QtCore.QVariant.Type = ..., defaultValue: Any = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsServerParameterDefinition) -> None: ...
    @staticmethod
    def raiseError(msg: str) -> None: ...
    def loadUrl(self) -> Tuple[str, bool]: ...
    def toUrl(self) -> Tuple[QtCore.QUrl, bool]: ...
    def toColor(self) -> Tuple[QtGui.QColor, bool]: ...
    def toBool(self) -> bool: ...
    def toDouble(self) -> Tuple[float, bool]: ...
    def toInt(self) -> Tuple[int, bool]: ...
    def toRectangle(self) -> Tuple[QgsRectangle, bool]: ...
    def toGeomList(self, delimiter: str = ...) -> Tuple[List[QgsGeometry], bool]: ...
    def toColorList(self, delimiter: str = ...) -> Tuple[List[QtGui.QColor], bool]: ...
    def toDoubleList(self, delimiter: str = ...) -> Tuple[List[float], bool]: ...
    def toIntList(self, delimiter: str = ...) -> Tuple[List[int], bool]: ...
    def toStringList(self, delimiter: str = ..., skipEmptyParts: bool = ...) -> List[str]: ...
    def toString(self, defaultValue: bool = ...) -> str: ...
    def isValid(self) -> bool: ...
    def typeName(self) -> str: ...


class QgsServerParameter(QgsServerParameterDefinition):

    class Name(int):
        ...

    UNKNOWN: QgsServerParameter.Name = ...
    SERVICE: QgsServerParameter.Name = ...
    VERSION_SERVICE: QgsServerParameter.Name = ...
    REQUEST: QgsServerParameter.Name = ...
    MAP: QgsServerParameter.Name = ...
    FILE_NAME: QgsServerParameter.Name = ...
    mName: QgsServerParameter.Name = ...
    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, name: QgsServerParameter.Name = ..., type: QtCore.QVariant.Type = ..., defaultValue: Any = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsServerParameter) -> None: ...
    @overload
    @staticmethod
    def name(name: QgsServerParameter.Name) -> str: ...
    @overload
    @staticmethod
    def name(name: str) -> QgsServerParameter.Name: ...
    def raiseError(self) -> None: ...


class QgsServerParameters(sip.wrapper):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, query: QtCore.QUrlQuery) -> None: ...
    @overload
    def __init__(self, a0: QgsServerParameters) -> None: ...
    def loadParameter(self, name: str, value: str) -> bool: ...
    def version(self) -> str: ...
    def fileName(self) -> str: ...
    def map(self) -> str: ...
    def request(self) -> str: ...
    def service(self) -> str: ...
    def toMap(self) -> Dict[str, str]: ...
    def urlQuery(self) -> QtCore.QUrlQuery: ...
    def value(self, key: str) -> str: ...
    @overload
    def remove(self, key: str) -> None: ...
    @overload
    def remove(self, name: QgsServerParameter.Name) -> None: ...
    def add(self, key: str, value: str) -> None: ...
    def clear(self) -> None: ...
    def load(self, query: QtCore.QUrlQuery) -> None: ...


class QgsServerQueryStringParameter(sip.wrapper):

    class Type(int):
        ...

    String: QgsServerQueryStringParameter.Type = ...
    Integer: QgsServerQueryStringParameter.Type = ...
    Double: QgsServerQueryStringParameter.Type = ...
    Boolean: QgsServerQueryStringParameter.Type = ...
    List: QgsServerQueryStringParameter.Type = ...
    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, name: str, required: bool = ..., type: QgsServerQueryStringParameter.Type = ..., description: str = ..., defaultValue: Any = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsServerQueryStringParameter) -> None: ...
    def setDescription(self, description: str) -> None: ...
    def name(self) -> str: ...
    @staticmethod
    def typeName(type: QgsServerQueryStringParameter.Type) -> str: ...
    def description(self) -> str: ...
    def value(self, context: QgsServerApiContext) -> Any: ...


class QgsServerSettingsEnv(QtCore.QObject):

    class EnvVar(int):
        ...

    QGIS_OPTIONS_PATH: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_PARALLEL_RENDERING: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_MAX_THREADS: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LOG_LEVEL: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LOG_FILE: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LOG_STDERR: QgsServerSettingsEnv.EnvVar = ...
    QGIS_PROJECT_FILE: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_IGNORE_BAD_LAYERS: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_CACHE_DIRECTORY: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_CACHE_SIZE: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_SHOW_GROUP_SEPARATOR: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_OVERRIDE_SYSTEM_LOCALE: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_WMS_MAX_HEIGHT: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_WMS_MAX_WIDTH: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_API_RESOURCES_DIRECTORY: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_API_WFS3_MAX_LIMIT: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_TRUST_LAYER_METADATA: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_DISABLE_GETPRINT: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LANDING_PAGE_PROJECTS_DIRECTORIES: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LANDING_PAGE_PROJECTS_PG_CONNECTIONS: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LOG_PROFILE: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_SERVICE_URL: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_WMS_SERVICE_URL: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_WFS_SERVICE_URL: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_WCS_SERVICE_URL: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_WMTS_SERVICE_URL: QgsServerSettingsEnv.EnvVar = ...
    QGIS_SERVER_LANDING_PAGE_PREFIX: QgsServerSettingsEnv.EnvVar = ...

    class Source(int):
        ...

    DEFAULT_VALUE: QgsServerSettingsEnv.Source = ...
    ENVIRONMENT_VARIABLE: QgsServerSettingsEnv.Source = ...
    INI_FILE: QgsServerSettingsEnv.Source = ...

    def __init__(self) -> None: ...


class QgsServerSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsServerSettings) -> None: ...
    @staticmethod
    def name(env: QgsServerSettingsEnv.EnvVar) -> str: ...
    def serviceUrl(self, service: str) -> str: ...
    def getPrintDisabled(self) -> bool: ...
    def trustLayerMetadata(self) -> bool: ...
    def ignoreBadLayers(self) -> bool: ...
    def apiWfs3MaxLimit(self) -> int: ...
    def apiResourcesDirectory(self) -> str: ...
    def landingPageBaseUrlPrefix(self) -> str: ...
    def landingPageProjectsPgConnections(self) -> str: ...
    def landingPageProjectsDirectories(self) -> str: ...
    def wmsMaxWidth(self) -> int: ...
    def wmsMaxHeight(self) -> int: ...
    def showGroupSeparator(self) -> bool: ...
    def overrideSystemLocale(self) -> str: ...
    def cacheDirectory(self) -> str: ...
    def cacheSize(self) -> int: ...
    def logStderr(self) -> bool: ...
    def logFile(self) -> str: ...
    def projectFile(self) -> str: ...
    def logProfile(self) -> bool: ...
    def logLevel(self) -> Qgis.MessageLevel: ...
    def maxThreads(self) -> int: ...
    def parallelRendering(self) -> bool: ...
    def iniFile(self) -> str: ...
    def logSummary(self) -> None: ...
    @overload
    def load(self) -> None: ...
    @overload
    def load(self, envVarName: str) -> bool: ...


class QgsServiceModule(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsServiceModule) -> None: ...
    def registerSelf(self, registry: QgsServiceRegistry, serverIface: Optional['QgsServerInterface'] = ...) -> None: ...


class QgsServerRequest(sip.wrapper):

    class RequestHeader(int):
        ...

    HOST: QgsServerRequest.RequestHeader = ...
    FORWARDED: QgsServerRequest.RequestHeader = ...
    X_FORWARDED_FOR: QgsServerRequest.RequestHeader = ...
    X_FORWARDED_HOST: QgsServerRequest.RequestHeader = ...
    X_FORWARDED_PROTO: QgsServerRequest.RequestHeader = ...
    X_QGIS_SERVICE_URL: QgsServerRequest.RequestHeader = ...
    X_QGIS_WMS_SERVICE_URL: QgsServerRequest.RequestHeader = ...
    X_QGIS_WFS_SERVICE_URL: QgsServerRequest.RequestHeader = ...
    X_QGIS_WCS_SERVICE_URL: QgsServerRequest.RequestHeader = ...
    X_QGIS_WMTS_SERVICE_URL: QgsServerRequest.RequestHeader = ...

    class Method(int):
        ...

    HeadMethod: QgsServerRequest.Method = ...
    PutMethod: QgsServerRequest.Method = ...
    GetMethod: QgsServerRequest.Method = ...
    PostMethod: QgsServerRequest.Method = ...
    DeleteMethod: QgsServerRequest.Method = ...
    PatchMethod: QgsServerRequest.Method = ...
    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, url: str, method: QgsServerRequest.Method = ..., headers: Dict[str, str] = ...) -> None: ...
    @overload
    def __init__(self, url: QtCore.QUrl, method: QgsServerRequest.Method = ..., headers: Dict[str, str] = ...) -> None: ...
    @overload
    def __init__(self, other: QgsServerRequest) -> None: ...
    def setBaseUrl(self, url: QtCore.QUrl) -> None: ...
    def setOriginalUrl(self, url: QtCore.QUrl) -> None: ...
    def queryParameter(self, name: str, defaultValue: str = ...) -> str: ...
    def setMethod(self, method: QgsServerRequest.Method) -> None: ...
    def baseUrl(self) -> QtCore.QUrl: ...
    def originalUrl(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def removeHeader(self, name: str) -> None: ...
    def headers(self) -> Dict[str, str]: ...
    def setHeader(self, name: str, value: str) -> None: ...
    @overload
    def header(self, name: str) -> str: ...
    @overload
    def header(self, headerEnum: QgsServerRequest.RequestHeader) -> str: ...
    def removeParameter(self, key: str) -> None: ...
    def parameter(self, key: str, defaultValue: str = ...) -> str: ...
    def setParameter(self, key: str, value: str) -> None: ...
    def serverParameters(self) -> QgsServerParameters: ...
    def parameters(self) -> Dict[str, str]: ...
    def method(self) -> QgsServerRequest.Method: ...
    def url(self) -> QtCore.QUrl: ...
    @staticmethod
    def methodToString(method: QgsServerRequest.Method) -> str: ...


class QgsBufferServerRequest(QgsServerRequest):

    @overload
    def __init__(self, url: str, method: QgsServerRequest.Method = ..., headers: Dict[str, str] = ..., data: Optional[Union[QtCore.QByteArray, bytes, bytearray]] = ...) -> None: ...
    @overload
    def __init__(self, url: QtCore.QUrl, method: QgsServerRequest.Method = ..., headers: Dict[str, str] = ..., data: Optional[Union[QtCore.QByteArray, bytes, bytearray]] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsBufferServerRequest) -> None: ...
    def data(self) -> QtCore.QByteArray: ...


class QgsServerResponse(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsServerResponse) -> None: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> QtCore.QIODevice: ...
    @overload
    def write(self, data: str) -> None: ...
    @overload
    def write(self, byteArray: Union[QtCore.QByteArray, bytes, bytearray]) -> int: ...
    @overload
    def write(self, ex: QgsServerException) -> None: ...
    def sendError(self, code: int, message: str) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> Dict[str, str]: ...
    def header(self, key: str) -> str: ...
    def removeHeader(self, key: str) -> None: ...
    def setHeader(self, key: str, value: str) -> None: ...


class QgsBufferServerResponse(QgsServerResponse):

    def __init__(self) -> None: ...
    def body(self) -> QtCore.QByteArray: ...
    def truncate(self) -> None: ...
    def data(self) -> QtCore.QByteArray: ...
    def clear(self) -> None: ...
    def flush(self) -> None: ...
    def finish(self) -> None: ...
    def io(self) -> QtCore.QIODevice: ...
    def sendError(self, code: int, message: str) -> None: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def headersSent(self) -> bool: ...
    def headers(self) -> Dict[str, str]: ...
    def header(self, key: str) -> str: ...
    def removeHeader(self, key: str) -> None: ...
    def setHeader(self, key: str, value: str) -> None: ...


class QgsFcgiServerRequest(QgsServerRequest):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFcgiServerRequest) -> None: ...
    def header(self, name: str) -> str: ...
    def hasError(self) -> bool: ...
    def data(self) -> QtCore.QByteArray: ...


class QgsRequestHandler(sip.wrapper):

    @overload
    def __init__(self, request: QgsServerRequest, response: QgsServerResponse) -> None: ...
    @overload
    def __init__(self, a0: QgsRequestHandler) -> None: ...
    def headersSent(self) -> bool: ...
    def format(self) -> str: ...
    def removeParameter(self, key: str) -> None: ...
    def parameter(self, key: str) -> str: ...
    def setParameter(self, key: str, value: str) -> None: ...
    def parameterMap(self) -> Dict[str, str]: ...
    def statusCode(self) -> int: ...
    def setStatusCode(self, code: int) -> None: ...
    def path(self) -> str: ...
    def url(self) -> str: ...
    def data(self) -> QtCore.QByteArray: ...
    def body(self) -> QtCore.QByteArray: ...
    def clearBody(self) -> None: ...
    def exceptionRaised(self) -> bool: ...
    def appendBody(self, body: Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def clear(self) -> None: ...
    def requestHeaders(self) -> Dict[str, str]: ...
    def requestHeader(self, name: str) -> str: ...
    def removeRequestHeader(self, name: str) -> None: ...
    def setRequestHeader(self, name: str, value: str) -> None: ...
    def responseHeaders(self) -> Dict[str, str]: ...
    def responseHeader(self, name: str) -> str: ...
    def removeResponseHeader(self, name: str) -> None: ...
    def setResponseHeader(self, name: str, value: str) -> None: ...
    def sendResponse(self) -> None: ...
    def setServiceException(self, ex: QgsServerException) -> None: ...


class QgsServer(sip.wrapper):

    def __init__(self) -> None: ...
    def initPython(self) -> None: ...
    def serverInterface(self) -> QgsServerInterface: ...
    def handleRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: Optional[QgsProject] = ...) -> None: ...
    def putenv(self, var: str, val: str) -> None: ...


class QgsServerApiUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsServerApiUtils) -> None: ...
    @staticmethod
    def appendMapParameter(path: str, requestUrl: QtCore.QUrl) -> str: ...
    @staticmethod
    def crsToOgcUri(crs: QgsCoordinateReferenceSystem) -> str: ...
    @staticmethod
    def publishedCrsList(project: QgsProject) -> List[str]: ...
    @staticmethod
    def sanitizedFieldValue(value: str) -> str: ...
    @staticmethod
    def publishedWfsLayers(context: QgsServerApiContext) -> Any: ...
    @staticmethod
    def parseCrs(bboxCrs: str) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def temporalExtent(layer: QgsVectorLayer) -> List[Any]: ...
    @staticmethod
    def temporalFilterExpression(layer: QgsVectorLayer, interval: str) -> QgsExpression: ...
    @staticmethod
    def parseTemporalDateTimeInterval(interval: str) -> QgsDateTimeRange: ...
    @staticmethod
    def parseTemporalDateInterval(interval: str) -> QgsDateRange: ...
    @staticmethod
    def temporalDimensions(layer: QgsVectorLayer) -> List[QgsVectorLayerServerProperties.WmsDimensionInfo]: ...
    @staticmethod
    def parseBbox(bbox: str) -> QgsRectangle: ...


class QgsServerException(sip.wrapper):

    @overload
    def __init__(self, message: str, responseCode: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsServerException) -> None: ...
    def formatResponse(self) -> Tuple[QtCore.QByteArray, str]: ...
    def responseCode(self) -> int: ...


class QgsOgcServiceException(sip.wrapper):

    @overload
    def __init__(self, code: str, message: str, locator: str = ..., responseCode: int = ..., version: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsOgcServiceException) -> None: ...
    def formatResponse(self) -> Tuple[QtCore.QByteArray, str]: ...
    def version(self) -> str: ...
    def locator(self) -> str: ...
    def code(self) -> str: ...
    def message(self) -> str: ...


class QgsServerFilter(sip.wrapper):

    @overload
    def __init__(self, serverInterface: QgsServerInterface) -> None: ...
    @overload
    def __init__(self, a0: QgsServerFilter) -> None: ...
    def sendResponse(self) -> None: ...
    def responseComplete(self) -> None: ...
    def requestReady(self) -> None: ...
    def serverInterface(self) -> QgsServerInterface: ...


class QgsServerInterface(sip.wrapper):

    def __init__(self, a0: QgsServerInterface) -> None: ...
    def serviceRegistry(self) -> QgsServiceRegistry: ...
    def removeConfigCacheEntry(self, path: str) -> None: ...
    def setConfigFilePath(self, configFilePath: str) -> None: ...
    def configFilePath(self) -> str: ...
    def getEnv(self, name: str) -> str: ...
    def cacheManager(self) -> QgsServerCacheManager: ...
    def registerServerCache(self, serverCache: QgsServerCacheFilter, priority: int = ...) -> None: ...
    def accessControls(self) -> QgsAccessControl: ...
    def registerAccessControl(self, accessControl: QgsAccessControlFilter, priority: int = ...) -> None: ...
    def filters(self) -> Any: ...
    def setFilters(self, filters: Any) -> None: ...
    def registerFilter(self, filter: QgsServerFilter, priority: int = ...) -> None: ...
    def requestHandler(self) -> QgsRequestHandler: ...
    def capabilitiesCache(self) -> QgsCapabilitiesCache: ...


class QgsServerProjectUtils(sip.simplewrapper):

    def serviceUrl(self, service: str, request: QgsServerRequest, settings: QgsServerSettings) -> str: ...
    def wmtsServiceUrl(self, project: QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wcsLayerIds(self, project: QgsProject) -> List[str]: ...
    def wcsServiceUrl(self, project: QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wfstDeleteLayerIds(self, project: QgsProject) -> List[str]: ...
    def wfstInsertLayerIds(self, project: QgsProject) -> List[str]: ...
    def wfstUpdateLayerIds(self, project: QgsProject) -> List[str]: ...
    def wfsLayerPrecision(self, project: QgsProject, layerId: str) -> int: ...
    def wfsLayerIds(self, project: QgsProject) -> List[str]: ...
    def wfsServiceUrl(self, project: QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wmsExtent(self, project: QgsProject) -> QgsRectangle: ...
    def wmsOutputCrsList(self, project: QgsProject) -> List[str]: ...
    def wmsRestrictedLayers(self, project: QgsProject) -> List[str]: ...
    def wmsRootName(self, project: QgsProject) -> str: ...
    def wmsServiceUrl(self, project: QgsProject, request: QgsServerRequest = ..., settings: QgsServerSettings = ...) -> str: ...
    def wmsRestrictedComposers(self, project: QgsProject) -> List[str]: ...
    def wmsInspireMetadataDate(self, project: QgsProject) -> str: ...
    def wmsInspireTemporalReference(self, project: QgsProject) -> str: ...
    def wmsInspireMetadataUrlType(self, project: QgsProject) -> str: ...
    def wmsInspireMetadataUrl(self, project: QgsProject) -> str: ...
    def wmsInspireLanguage(self, project: QgsProject) -> str: ...
    def wmsInspireActivate(self, project: QgsProject) -> bool: ...
    def wmsFeatureInfoLayerAliasMap(self, project: QgsProject) -> Dict[str, str]: ...
    def wmsFeatureInfoSchema(self, project: QgsProject) -> str: ...
    def wmsFeatureInfoDocumentElementNs(self, project: QgsProject) -> str: ...
    def wmsFeatureInfoDocumentElement(self, project: QgsProject) -> str: ...
    def wmsFeatureInfoPrecision(self, project: QgsProject) -> int: ...
    def wmsFeatureInfoSegmentizeWktGeometry(self, project: QgsProject) -> bool: ...
    def wmsFeatureInfoUseAttributeFormSettings(self, project: QgsProject) -> bool: ...
    def wmsFeatureInfoAddWktGeometry(self, project: QgsProject) -> bool: ...
    def wmsInfoFormatSia2045(self, project: QgsProject) -> bool: ...
    def wmsUseLayerIds(self, project: QgsProject) -> bool: ...
    def wmsDefaultMapUnitsPerMm(self, project: QgsProject) -> float: ...
    def wmsMaxAtlasFeatures(self, project: QgsProject) -> int: ...
    def wmsRenderMapTiles(self, project: QgsProject) -> bool: ...
    def wmsTileBuffer(self, project: QgsProject) -> int: ...
    def wmsImageQuality(self, project: QgsProject) -> int: ...
    def wmsMaxHeight(self, project: QgsProject) -> int: ...
    def wmsMaxWidth(self, project: QgsProject) -> int: ...
    def owsServiceAccessConstraints(self, project: QgsProject) -> str: ...
    def owsServiceFees(self, project: QgsProject) -> str: ...
    def owsServiceContactPhone(self, project: QgsProject) -> str: ...
    def owsServiceContactMail(self, project: QgsProject) -> str: ...
    def owsServiceContactPerson(self, project: QgsProject) -> str: ...
    def owsServiceContactPosition(self, project: QgsProject) -> str: ...
    def owsServiceContactOrganization(self, project: QgsProject) -> str: ...
    def owsServiceOnlineResource(self, project: QgsProject) -> str: ...
    def owsServiceKeywords(self, project: QgsProject) -> List[str]: ...
    def owsServiceAbstract(self, project: QgsProject) -> str: ...
    def owsServiceTitle(self, project: QgsProject) -> str: ...
    def owsServiceCapabilities(self, project: QgsProject) -> bool: ...


class QgsService(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsService) -> None: ...
    def executeRequest(self, request: QgsServerRequest, response: QgsServerResponse, project: QgsProject) -> None: ...
    def version(self) -> str: ...
    def name(self) -> str: ...


class QgsServiceRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsServiceRegistry) -> None: ...
    def cleanUp(self) -> None: ...
    def init(self, nativeModulepath: str, serverIface: Optional[QgsServerInterface] = ...) -> None: ...
    def unregisterService(self, name: str, version: str = ...) -> int: ...
    def getApi(self, name: str, version: str = ...) -> QgsServerApi: ...
    def unregisterApi(self, name: str, version: str = ...) -> int: ...
    def registerApi(self, api: QgsServerApi) -> bool: ...
    def registerService(self, service: QgsService) -> None: ...
    def getService(self, name: str, version: str = ...) -> QgsService: ...


class QgsFeatureFilterProviderGroup(QgsFeatureFilterProvider):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureFilterProviderGroup) -> None: ...
    def addProvider(self, provider: QgsFeatureFilterProvider) -> QgsFeatureFilterProviderGroup: ...
    def clone(self) -> QgsFeatureFilterProvider: ...
    def layerAttributes(self, layer: QgsVectorLayer, attributes: Iterable[str]) -> List[str]: ...
    def filterFeatures(self, layer: QgsVectorLayer, filterFeatures: QgsFeatureRequest) -> None: ...


class QgsFeatureFilter(QgsFeatureFilterProvider):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureFilter) -> None: ...
    def setFilter(self, layer: QgsVectorLayer, expression: QgsExpression) -> None: ...
    def clone(self) -> QgsFeatureFilterProvider: ...
    def layerAttributes(self, layer: QgsVectorLayer, attributes: Iterable[str]) -> List[str]: ...
    def filterFeatures(self, layer: QgsVectorLayer, filterFeatures: QgsFeatureRequest) -> None: ...


class QgsStoreBadLayerInfo(QgsProjectBadLayerHandler):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsStoreBadLayerInfo) -> None: ...
    def badLayerNames(self) -> Dict[str, str]: ...
    def badLayers(self) -> List[str]: ...
    def handleBadLayers(self, layers: Iterable[QtXml.QDomNode]) -> None: ...


class QgsAccessControlFilter(sip.wrapper):

    class LayerPermissions(sip.wrapper):

        canDelete: bool = ...
        canInsert: bool = ...
        canRead: bool = ...
        canUpdate: bool = ...

        @overload
        def __init__(self) -> None: ...

        @overload
        def __init__(self, a0: QgsAccessControlFilter.LayerPermissions) -> None: ...

    @overload
    def __init__(self, serverInterface: QgsServerInterface) -> None: ...
    @overload
    def __init__(self, a0: QgsAccessControlFilter) -> None: ...
    def cacheKey(self) -> str: ...
    def allowToEdit(self, layer: QgsVectorLayer, feature: QgsFeature) -> bool: ...
    def authorizedLayerAttributes(self, layer: QgsVectorLayer, attributes: Iterable[str]) -> List[str]: ...
    def layerPermissions(self, layer: QgsMapLayer) -> QgsAccessControlFilter.LayerPermissions: ...
    def layerFilterSubsetString(self, layer: QgsVectorLayer) -> str: ...
    def layerFilterExpression(self, layer: QgsVectorLayer) -> str: ...
    def serverInterface(self) -> QgsServerInterface: ...


class QgsAccessControl(QgsFeatureFilterProvider):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, copy: QgsAccessControl) -> None: ...
    def registerAccessControl(self, accessControl: QgsAccessControlFilter, priority: int = ...) -> None: ...
    def fillCacheKey(self, cacheKey: Iterable[str]) -> bool: ...
    def allowToEdit(self, layer: QgsVectorLayer, feature: QgsFeature) -> bool: ...
    def layerAttributes(self, layer: QgsVectorLayer, attributes: Iterable[str]) -> List[str]: ...
    def layerDeletePermission(self, layer: QgsVectorLayer) -> bool: ...
    def layerUpdatePermission(self, layer: QgsVectorLayer) -> bool: ...
    def layerInsertPermission(self, layer: QgsVectorLayer) -> bool: ...
    def layerReadPermission(self, layer: QgsMapLayer) -> bool: ...
    def extraSubsetString(self, layer: QgsVectorLayer) -> str: ...
    def clone(self) -> QgsFeatureFilterProvider: ...
    def filterFeatures(self, layer: QgsVectorLayer, filterFeatures: QgsFeatureRequest) -> None: ...
    def resolveFilterFeatures(self, layers: Iterable[QgsMapLayer]) -> None: ...


class QgsServerCacheFilter(sip.wrapper):

    @overload
    def __init__(self, serverInterface: QgsServerInterface) -> None: ...
    @overload
    def __init__(self, a0: QgsServerCacheFilter) -> None: ...
    def deleteCachedImages(self, project: QgsProject) -> bool: ...
    def deleteCachedImage(self, project: QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def setCachedImage(self, img: Union[QtCore.QByteArray, bytes, bytearray], project: QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def getCachedImage(self, project: QgsProject, request: QgsServerRequest, key: str) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: QgsProject) -> bool: ...
    def deleteCachedDocument(self, project: QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def setCachedDocument(self, doc: QtXml.QDomDocument, project: QgsProject, request: QgsServerRequest, key: str) -> bool: ...
    def getCachedDocument(self, project: QgsProject, request: QgsServerRequest, key: str) -> QtCore.QByteArray: ...


class QgsServerCacheManager(sip.wrapper):

    @overload
    def __init__(self, settings: QgsServerSettings = ...) -> None: ...
    @overload
    def __init__(self, copy: QgsServerCacheManager) -> None: ...
    def registerServerCache(self, serverCache: QgsServerCacheFilter, priority: int = ...) -> None: ...
    def deleteCachedImages(self, project: QgsProject) -> bool: ...
    def deleteCachedImage(self, project: QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def setCachedImage(self, img: Union[QtCore.QByteArray, bytes, bytearray], project: QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def getCachedImage(self, project: QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> QtCore.QByteArray: ...
    def deleteCachedDocuments(self, project: QgsProject) -> bool: ...
    def deleteCachedDocument(self, project: QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def setCachedDocument(self, doc: QtXml.QDomDocument, project: QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
    def getCachedDocument(self, doc: QtXml.QDomDocument, project: QgsProject, request: QgsServerRequest, accessControl: QgsAccessControl) -> bool: ...
