# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : May 2014
    Copyright            : (C) 2014 by Nathan Woodrow
    Email                : woodrow dot nathan at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Nathan Woodrow'
__date__ = 'May 2014'
__copyright__ = '(C) 2014, Nathan Woodrow'

import typing
from typing import (Callable, Dict, Iterable, List, Optional, Sequence,
                    Tuple, Union, overload)

from PyQt5 import QtCore, QtGui, QtNetwork, QtWidgets, QtXml

from .core import (Qgis,
                   QgsAbstract3DSymbol,
                   QgsAbstractDatabaseProviderConnection,
                   QgsAbstractGeocoderLocatorFilter,
                   QgsAbstractGeometry,
                   QgsAbstractMetadataBase,
                   QgsAbstractPropertyCollection,
                   QgsAction,
                   QgsAnnotation,
                   QgsAttributeEditorRelation,
                   QgsAttributeTableConfig,
                   QgsAuthCertUtils,
                   QgsAuthConfigSslServer,
                   QgsBearingNumericFormat,
                   QgsBrowserModel,
                   QgsCallout,
                   QgsColorBrewerColorRamp,
                   QgsColorRamp,
                   QgsColorRampLegendNodeSettings,
                   QgsColorRampShader,
                   QgsColorScheme,
                   QgsColorSchemeRegistry,
                   QgsCompoundCurve,
                   QgsConditionalStyle,
                   QgsCoordinateReferenceSystem,
                   QgsCoordinateTransformContext,
                   QgsCptCityColorRamp,
                   QgsCredentials,
                   QgsCurve,
                   QgsCurveTransform,
                   QgsDataDefinedSizeLegend,
                   QgsDataItem,
                   QgsDateTimeRange,
                   QgsDistanceArea,
                   QgsDoubleRange,
                   QgsEditorWidgetSetup,
                   QgsEffectStack,
                   QgsError,
                   QgsExpression,
                   QgsExpressionContext,
                   QgsExpressionContextGenerator,
                   QgsExpressionContextScope,
                   QgsExpressionNode,
                   QgsFeature,
                   QgsFeatureRenderer,
                   QgsFeatureRequest,
                   QgsField,
                   QgsFieldConstraints,
                   QgsFieldProxyModel,
                   QgsFields,
                   QgsGeocoderInterface,
                   QgsGeometry,
                   QgsGpsConnection,
                   QgsGradientColorRamp,
                   QgsGradientStop,
                   QgsGraduatedSymbolRenderer,
                   QgsIdentifyContext,
                   QgsLabelingEngineSettings,
                   QgsLabelingResults,
                   QgsLabelLineSettings,
                   QgsLabelObstacleSettings,
                   QgsLayerItem,
                   QgsLayerTree,
                   QgsLayerTreeGroup,
                   QgsLayerTreeLayer,
                   QgsLayerTreeModel,
                   QgsLayerTreeModelLegendNode,
                   QgsLayerTreeNode,
                   QgsLayerTreeRegistryBridge,
                   QgsLayout,
                   QgsLayoutAligner,
                   QgsLayoutAtlas,
                   QgsLayoutItem,
                   QgsLayoutItemPage,
                   QgsLayoutItemRegistry,
                   QgsLayoutManager,
                   QgsLayoutManagerProxyModel,
                   QgsLayoutMeasurementConverter,
                   QgsLayoutObject,
                   QgsLayoutPoint,
                   QgsLayoutSize,
                   QgsLegendPatchShape,
                   QgsLegendSymbolItem,
                   QgsLimitedRandomColorRamp,
                   QgsLocator,
                   QgsLocatorFilter,
                   QgsMapLayer,
                   QgsMapLayerProxyModel,
                   QgsMapLayerType,
                   QgsMapSettings,
                   QgsMapToPixel,
                   QgsMapUnitScale,
                   QgsMarkerSymbol,
                   QgsMasterLayoutInterface,
                   QgsMeshLayer,
                   QgsMessageOutput,
                   QgsMimeDataUtils,
                   QgsNumericFormat,
                   QgsPaintEffect,
                   QgsPalLayerSettings,
                   QgsPkiBundle,
                   QgsPoint,
                   QgsPointCloudAttributeCollection,
                   QgsPointCloudAttributeProxyModel,
                   QgsPointCloudLayer,
                   QgsPointCloudRenderer,
                   QgsPointLocator,
                   QgsPointXY,
                   QgsPresetSchemeColorRamp,
                   QgsProcessingAlgorithm,
                   QgsProcessingAlgRunnerTask,
                   QgsProcessingContext,
                   QgsProcessingDestinationParameter,
                   QgsProcessingFeedback,
                   QgsProcessingModelAlgorithm,
                   QgsProcessingModelChildAlgorithm,
                   QgsProcessingModelChildDependency,
                   QgsProcessingModelChildParameterSource,
                   QgsProcessingModelComment,
                   QgsProcessingModelComponent,
                   QgsProcessingModelGroupBox,
                   QgsProcessingModelOutput,
                   QgsProcessingModelParameter,
                   QgsProcessingParameterDefinition,
                   QgsProcessingParameterMultipleLayers,
                   QgsProcessingProvider,
                   QgsProcessingRegistry,
                   QgsProject,
                   QgsProperty,
                   QgsPropertyCollection,
                   QgsPropertyDefinition,
                   QgsProviderRegistry,
                   QgsRaster,
                   QgsRasterDataProvider,
                   QgsRasterLayer,
                   QgsRasterMinMaxOrigin,
                   QgsRasterRange,
                   QgsRasterRenderer,
                   QgsReadWriteContext,
                   QgsRectangle,
                   QgsReferencedRectangle,
                   QgsRelation,
                   QgsRenderContext,
                   QgsRendererCategory,
                   QgsRendererRange,
                   QgsRuleBasedRenderer,
                   QgsSettings,
                   QgsSnappingUtils,
                   QgsStringReplacementCollection,
                   QgsStyle,
                   QgsSvgMarkerSymbolLayer,
                   QgsSymbol,
                   QgsSymbolLayer,
                   QgsTaskManager,
                   QgsTemporalController,
                   QgsTemporalNavigationObject,
                   QgsTextFormat,
                   QgsTracer,
                   QgsUnitTypes,
                   QgsUserColorScheme,
                   QgsValidityCheckContext,
                   QgsValidityCheckResult,
                   QgsVectorLayer,
                   QgsVectorLayerCache,
                   QgsVectorLayerTools,
                   QgsVectorTileLayer,
                   QgsVertexId,
                   QgsWkbTypes)
from ._types import Qsci, sip

# Support for QDate, QDateTime and QTime.
import datetime

# Convenient type aliases.
PYQT_SIGNAL = Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = Union[Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = Union[Sequence[int], Sequence[float], sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = Union[
    Sequence[int], Sequence[float], sip.Buffer, int, None]


class QgisInterface(QtCore.QObject):

    def __init__(self) -> None: ...

    def layerSavedAs(self, l: QgsMapLayer, path: str) -> None: ...
    def newProjectCreated(self) -> None: ...
    def projectRead(self) -> None: ...
    def initializationCompleted(self) -> None: ...
    def layoutDesignerClosed(self) -> None: ...
    def layoutDesignerWillBeClosed(self, designer: QgsLayoutDesignerInterface) -> None: ...
    def layoutDesignerOpened(self, designer: QgsLayoutDesignerInterface) -> None: ...
    def currentThemeChanged(self, theme: str) -> None: ...
    def currentLayerChanged(self, layer: QgsMapLayer) -> None: ...
    def setGpsPanelConnection(self, connection: QgsGpsConnection) -> None: ...
    def browserModel(self) -> QgsBrowserGuiModel: ...
    def askForDatumTransform(self, sourceCrs: QgsCoordinateReferenceSystem, destinationCrs: QgsCoordinateReferenceSystem) -> bool: ...
    def invalidateLocatorResults(self) -> None: ...
    def deregisterLocatorFilter(self, filter: QgsLocatorFilter) -> None: ...
    def registerLocatorFilter(self, filter: QgsLocatorFilter) -> None: ...
    def locatorSearch(self, searchText: str) -> None: ...
    def preloadForm(self, uifile: str) -> None: ...
    def getFeatureForm(self, l: QgsVectorLayer, f: QgsFeature) -> QgsAttributeDialog: ...
    def openFeatureForm(self, l: QgsVectorLayer, f: QgsFeature, updateFeatureOnly: bool = ..., showModal: bool = ...) -> bool: ...
    def openURL(self, url: str, useQgisDocDirectory: bool = ...) -> None: ...
    def unregisterCustomLayoutDropHandler(self, handler: QgsLayoutCustomDropHandler) -> None: ...
    def registerCustomLayoutDropHandler(self, handler: QgsLayoutCustomDropHandler) -> None: ...
    def unregisterCustomProjectOpenHandler(self, handler: QgsCustomProjectOpenHandler) -> None: ...
    def registerCustomProjectOpenHandler(self, handler: QgsCustomProjectOpenHandler) -> None: ...
    def unregisterCustomDropHandler(self, handler: QgsCustomDropHandler) -> None: ...
    def registerCustomDropHandler(self, handler: QgsCustomDropHandler) -> None: ...
    def unregisterMapToolHandler(self, handler: QgsAbstractMapToolHandler) -> None: ...
    def registerMapToolHandler(self, handler: QgsAbstractMapToolHandler) -> None: ...
    def unregisterApplicationExitBlocker(self, blocker: QgsApplicationExitBlockerInterface) -> None: ...
    def registerApplicationExitBlocker(self, blocker: QgsApplicationExitBlockerInterface) -> None: ...
    def unregisterDevToolWidgetFactory(self, factory: QgsDevToolWidgetFactory) -> None: ...
    def registerDevToolWidgetFactory(self, factory: QgsDevToolWidgetFactory) -> None: ...
    def unregisterProjectPropertiesWidgetFactory(self, factory: QgsOptionsWidgetFactory) -> None: ...
    def registerProjectPropertiesWidgetFactory(self, factory: QgsOptionsWidgetFactory) -> None: ...
    def unregisterOptionsWidgetFactory(self, factory: QgsOptionsWidgetFactory) -> None: ...
    def registerOptionsWidgetFactory(self, factory: QgsOptionsWidgetFactory) -> None: ...
    def unregisterMapLayerConfigWidgetFactory(self, factory: QgsMapLayerConfigWidgetFactory) -> None: ...
    def registerMapLayerConfigWidgetFactory(self, factory: QgsMapLayerConfigWidgetFactory) -> None: ...
    def unregisterMainWindowAction(self, action: QtWidgets.QAction) -> bool: ...
    def registerMainWindowAction(self, action: QtWidgets.QAction, defaultShortcut: str) -> bool: ...
    def removeWindow(self, action: QtWidgets.QAction) -> None: ...
    def addWindow(self, action: QtWidgets.QAction) -> None: ...
    def showAttributeTable(self, l: QgsVectorLayer, filterExpression: str = ...) -> QtWidgets.QDialog: ...
    def showLayerProperties(self, l: QgsMapLayer, page: str = ...) -> None: ...
    def removeDockWidget(self, dockwidget: QtWidgets.QDockWidget) -> None: ...
    def addTabifiedDockWidget(self, area: QtCore.Qt.DockWidgetArea, dockwidget: QtWidgets.QDockWidget, tabifyWith: Iterable[str] = ..., raiseTab: bool = ...) -> None: ...
    def addDockWidget(self, area: QtCore.Qt.DockWidgetArea, dockwidget: QtWidgets.QDockWidget) -> None: ...
    def removePluginWebMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def addPluginToWebMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def removePluginVectorMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def addPluginToVectorMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def removePluginRasterMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def addPluginToRasterMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def removePluginDatabaseMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def addPluginToDatabaseMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def removeAddLayerAction(self, action: QtWidgets.QAction) -> None: ...
    def insertAddLayerAction(self, action: QtWidgets.QAction) -> None: ...
    def removePluginMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def addPluginToMenu(self, name: str, action: QtWidgets.QAction) -> None: ...
    def saveStyleSheetOptions(self, opts: Dict[str, typing.Any]) -> None: ...
    def buildStyleSheet(self, opts: Dict[str, typing.Any]) -> None: ...
    def showProjectPropertiesDialog(self, currentPage: str = ...) -> None: ...
    def showOptionsDialog(self, parent: Optional[QtWidgets.QWidget] = ..., currentPage: str = ...) -> None: ...
    def openLayoutDesigner(self, layout: QgsMasterLayoutInterface) -> QgsLayoutDesignerInterface: ...
    def showLayoutManager(self) -> None: ...
    def addUserInputWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def openMessageLog(self) -> None: ...
    @overload
    def addToolBar(self, name: str) -> QtWidgets.QToolBar: ...
    @overload
    def addToolBar(self, toolbar: QtWidgets.QToolBar, area: QtCore.Qt.ToolBarArea = ...) -> None: ...
    def removeWebToolBarIcon(self, qAction: QtWidgets.QAction) -> None: ...
    def addWebToolBarWidget(self, widget: QtWidgets.QWidget) -> QtWidgets.QAction: ...
    def addWebToolBarIcon(self, qAction: QtWidgets.QAction) -> int: ...
    def removeDatabaseToolBarIcon(self, qAction: QtWidgets.QAction) -> None: ...
    def addDatabaseToolBarWidget(self, widget: QtWidgets.QWidget) -> QtWidgets.QAction: ...
    def addDatabaseToolBarIcon(self, qAction: QtWidgets.QAction) -> int: ...
    def removeVectorToolBarIcon(self, qAction: QtWidgets.QAction) -> None: ...
    def addVectorToolBarWidget(self, widget: QtWidgets.QWidget) -> QtWidgets.QAction: ...
    def addVectorToolBarIcon(self, qAction: QtWidgets.QAction) -> int: ...
    def removeRasterToolBarIcon(self, qAction: QtWidgets.QAction) -> None: ...
    def addRasterToolBarIcon(self, qAction: QtWidgets.QAction) -> int: ...
    def addRasterToolBarWidget(self, widget: QtWidgets.QWidget) -> QtWidgets.QAction: ...
    def removeToolBarIcon(self, qAction: QtWidgets.QAction) -> None: ...
    def addToolBarWidget(self, widget: QtWidgets.QWidget) -> QtWidgets.QAction: ...
    def addToolBarIcon(self, qAction: QtWidgets.QAction) -> int: ...
    def pasteFromClipboard(self, a0: QgsMapLayer) -> None: ...
    def copySelectionToClipboard(self, a0: QgsMapLayer) -> None: ...
    def setActiveLayer(self, a0: QgsMapLayer) -> bool: ...
    def reloadConnections(self) -> None: ...
    def newProject(self, promptToSaveFlag: bool = ...) -> bool: ...
    def addProject(self, project: str) -> bool: ...
    def addPointCloudLayer(self, url: str, baseName: str, providerKey: str) -> QgsPointCloudLayer: ...
    def addVectorTileLayer(self, url: str, baseName: str) -> QgsVectorTileLayer: ...
    def addMeshLayer(self, url: str, baseName: str, providerKey: str) -> QgsMeshLayer: ...
    @overload
    def addRasterLayer(self, rasterLayerPath: str, baseName: str = ...) -> QgsRasterLayer: ...
    @overload
    def addRasterLayer(self, url: str, layerName: str, providerKey: str) -> QgsRasterLayer: ...
    def addVectorLayer(self, vectorLayerPath: str, baseName: str, providerKey: str) -> QgsVectorLayer: ...
    def zoomToActiveLayer(self) -> None: ...
    def zoomToNext(self) -> None: ...
    def zoomToPrevious(self) -> None: ...
    def zoomFull(self) -> None: ...
    def layerTreeInsertionPoint(self) -> QgsLayerTreeRegistryBridge.InsertionPoint: ...
    def takeAppScreenShots(self, saveDirectory: str, categories: int = ...) -> None: ...
    def statusBarIface(self) -> QgsStatusBar: ...
    def messageTimeout(self) -> int: ...
    def vectorLayerTools(self) -> QgsVectorLayerTools: ...
    def actionRegularPolygonCenterCorner(self) -> QtWidgets.QAction: ...
    def actionRegularPolygonCenterPoint(self) -> QtWidgets.QAction: ...
    def actionRegularPolygon2Points(self) -> QtWidgets.QAction: ...
    def actionRectangle3PointsProjected(self) -> QtWidgets.QAction: ...
    def actionRectangle3PointsDistance(self) -> QtWidgets.QAction: ...
    def actionRectangleExtent(self) -> QtWidgets.QAction: ...
    def actionRectangleCenterPoint(self) -> QtWidgets.QAction: ...
    def actionEllipseFoci(self) -> QtWidgets.QAction: ...
    def actionEllipseExtent(self) -> QtWidgets.QAction: ...
    def actionEllipseCenterPoint(self) -> QtWidgets.QAction: ...
    def actionEllipseCenter2Points(self) -> QtWidgets.QAction: ...
    def actionCircleCenterPoint(self) -> QtWidgets.QAction: ...
    def actionCircle2TangentsPoint(self) -> QtWidgets.QAction: ...
    def actionCircle3Tangents(self) -> QtWidgets.QAction: ...
    def actionCircle3Points(self) -> QtWidgets.QAction: ...
    def actionCircle2Points(self) -> QtWidgets.QAction: ...
    def actionAbout(self) -> QtWidgets.QAction: ...
    def actionCheckQgisVersion(self) -> QtWidgets.QAction: ...
    def actionQgisHomePage(self) -> QtWidgets.QAction: ...
    def actionHelpContents(self) -> QtWidgets.QAction: ...
    def actionCustomProjection(self) -> QtWidgets.QAction: ...
    def actionOptions(self) -> QtWidgets.QAction: ...
    def actionToggleFullScreen(self) -> QtWidgets.QAction: ...
    def actionShowPythonDialog(self) -> QtWidgets.QAction: ...
    def actionPluginListSeparator(self) -> QtWidgets.QAction: ...
    def actionManagePlugins(self) -> QtWidgets.QAction: ...
    def actionShowSelectedLayers(self) -> QtWidgets.QAction: ...
    def actionHideDeselectedLayers(self) -> QtWidgets.QAction: ...
    def actionToggleSelectedLayersIndependently(self) -> QtWidgets.QAction: ...
    def actionToggleSelectedLayers(self) -> QtWidgets.QAction: ...
    def actionHideSelectedLayers(self) -> QtWidgets.QAction: ...
    def actionShowAllLayers(self) -> QtWidgets.QAction: ...
    def actionHideAllLayers(self) -> QtWidgets.QAction: ...
    def actionRemoveAllFromOverview(self) -> QtWidgets.QAction: ...
    def actionAddAllToOverview(self) -> QtWidgets.QAction: ...
    def actionAddToOverview(self) -> QtWidgets.QAction: ...
    def actionLayerProperties(self) -> QtWidgets.QAction: ...
    def actionDuplicateLayer(self) -> QtWidgets.QAction: ...
    def actionLayerSaveAs(self) -> QtWidgets.QAction: ...
    def actionCancelAllEdits(self) -> QtWidgets.QAction: ...
    def actionCancelEdits(self) -> QtWidgets.QAction: ...
    def actionRollbackAllEdits(self) -> QtWidgets.QAction: ...
    def actionRollbackEdits(self) -> QtWidgets.QAction: ...
    def actionSaveAllEdits(self) -> QtWidgets.QAction: ...
    def actionSaveEdits(self) -> QtWidgets.QAction: ...
    def actionAllEdits(self) -> QtWidgets.QAction: ...
    def actionSaveActiveLayerEdits(self) -> QtWidgets.QAction: ...
    def actionToggleEditing(self) -> QtWidgets.QAction: ...
    def actionOpenStatisticalSummary(self) -> QtWidgets.QAction: ...
    def actionOpenFieldCalculator(self) -> QtWidgets.QAction: ...
    def actionOpenTable(self) -> QtWidgets.QAction: ...
    def actionPasteLayerStyle(self) -> QtWidgets.QAction: ...
    def actionCopyLayerStyle(self) -> QtWidgets.QAction: ...
    def actionAddAmsLayer(self) -> QtWidgets.QAction: ...
    def actionAddAfsLayer(self) -> QtWidgets.QAction: ...
    def actionAddPointCloudLayer(self) -> QtWidgets.QAction: ...
    def actionAddVectorTileLayer(self) -> QtWidgets.QAction: ...
    def actionAddXyzLayer(self) -> QtWidgets.QAction: ...
    def actionAddWmsLayer(self) -> QtWidgets.QAction: ...
    def actionAddPgLayer(self) -> QtWidgets.QAction: ...
    def actionAddRasterLayer(self) -> QtWidgets.QAction: ...
    def actionAddOgrLayer(self) -> QtWidgets.QAction: ...
    def actionNewVectorLayer(self) -> QtWidgets.QAction: ...
    def actionDraw(self) -> QtWidgets.QAction: ...
    def actionShowBookmarks(self) -> QtWidgets.QAction: ...
    def actionNewBookmark(self) -> QtWidgets.QAction: ...
    def actionMapTips(self) -> QtWidgets.QAction: ...
    def actionZoomActualSize(self) -> QtWidgets.QAction: ...
    def actionZoomNext(self) -> QtWidgets.QAction: ...
    def actionZoomLast(self) -> QtWidgets.QAction: ...
    def actionZoomToSelected(self) -> QtWidgets.QAction: ...
    def actionZoomToLayers(self) -> QtWidgets.QAction: ...
    def actionZoomToLayer(self) -> QtWidgets.QAction: ...
    def actionZoomFullExtent(self) -> QtWidgets.QAction: ...
    def actionMeasureArea(self) -> QtWidgets.QAction: ...
    def actionMeasure(self) -> QtWidgets.QAction: ...
    def actionFeatureAction(self) -> QtWidgets.QAction: ...
    def actionIdentify(self) -> QtWidgets.QAction: ...
    def actionSelectRadius(self) -> QtWidgets.QAction: ...
    def actionSelectFreehand(self) -> QtWidgets.QAction: ...
    def actionSelectPolygon(self) -> QtWidgets.QAction: ...
    def actionSelectRectangle(self) -> QtWidgets.QAction: ...
    def actionSelect(self) -> QtWidgets.QAction: ...
    def actionZoomOut(self) -> QtWidgets.QAction: ...
    def actionZoomIn(self) -> QtWidgets.QAction: ...
    def actionPanToSelected(self) -> QtWidgets.QAction: ...
    def actionPan(self) -> QtWidgets.QAction: ...
    def mapToolActionGroup(self) -> QtWidgets.QActionGroup: ...
    def actionVertexToolActiveLayer(self) -> QtWidgets.QAction: ...
    def actionVertexTool(self) -> QtWidgets.QAction: ...
    def actionDeletePart(self) -> QtWidgets.QAction: ...
    def actionDeleteRing(self) -> QtWidgets.QAction: ...
    def actionSimplifyFeature(self) -> QtWidgets.QAction: ...
    def actionAddPart(self) -> QtWidgets.QAction: ...
    def actionAddRing(self) -> QtWidgets.QAction: ...
    def actionSplitParts(self) -> QtWidgets.QAction: ...
    def actionSplitFeatures(self) -> QtWidgets.QAction: ...
    def actionMoveFeature(self) -> QtWidgets.QAction: ...
    def actionDeleteSelected(self) -> QtWidgets.QAction: ...
    def actionAddFeature(self) -> QtWidgets.QAction: ...
    def actionPasteFeatures(self) -> QtWidgets.QAction: ...
    def actionCopyFeatures(self) -> QtWidgets.QAction: ...
    def actionCutFeatures(self) -> QtWidgets.QAction: ...
    def actionExit(self) -> QtWidgets.QAction: ...
    def actionShowLayoutManager(self) -> QtWidgets.QAction: ...
    def actionCreatePrintLayout(self) -> QtWidgets.QAction: ...
    def actionProjectProperties(self) -> QtWidgets.QAction: ...
    def actionSaveMapAsImage(self) -> QtWidgets.QAction: ...
    def actionSaveProjectAs(self) -> QtWidgets.QAction: ...
    def actionSaveProject(self) -> QtWidgets.QAction: ...
    def actionOpenProject(self) -> QtWidgets.QAction: ...
    def actionNewProject(self) -> QtWidgets.QAction: ...
    def webToolBar(self) -> QtWidgets.QToolBar: ...
    def databaseToolBar(self) -> QtWidgets.QToolBar: ...
    def vectorToolBar(self) -> QtWidgets.QToolBar: ...
    def rasterToolBar(self) -> QtWidgets.QToolBar: ...
    def helpToolBar(self) -> QtWidgets.QToolBar: ...
    def pluginToolBar(self) -> QtWidgets.QToolBar: ...
    def selectionToolBar(self) -> QtWidgets.QToolBar: ...
    def attributesToolBar(self) -> QtWidgets.QToolBar: ...
    def shapeDigitizeToolBar(self) -> QtWidgets.QToolBar: ...
    def advancedDigitizeToolBar(self) -> QtWidgets.QToolBar: ...
    def digitizeToolBar(self) -> QtWidgets.QToolBar: ...
    def mapNavToolToolBar(self) -> QtWidgets.QToolBar: ...
    def dataSourceManagerToolBar(self) -> QtWidgets.QToolBar: ...
    def layerToolBar(self) -> QtWidgets.QToolBar: ...
    def fileToolBar(self) -> QtWidgets.QToolBar: ...
    def helpMenu(self) -> QtWidgets.QMenu: ...
    def windowMenu(self) -> QtWidgets.QMenu: ...
    def firstRightStandardMenu(self) -> QtWidgets.QMenu: ...
    def webMenu(self) -> QtWidgets.QMenu: ...
    def vectorMenu(self) -> QtWidgets.QMenu: ...
    def databaseMenu(self) -> QtWidgets.QMenu: ...
    def rasterMenu(self) -> QtWidgets.QMenu: ...
    def pluginHelpMenu(self) -> QtWidgets.QMenu: ...
    def pluginMenu(self) -> QtWidgets.QMenu: ...
    def settingsMenu(self) -> QtWidgets.QMenu: ...
    def addLayerMenu(self) -> QtWidgets.QMenu: ...
    def newLayerMenu(self) -> QtWidgets.QMenu: ...
    def layerMenu(self) -> QtWidgets.QMenu: ...
    def viewMenu(self) -> QtWidgets.QMenu: ...
    def editMenu(self) -> QtWidgets.QMenu: ...
    def projectMenu(self) -> QtWidgets.QMenu: ...
    def cadDockWidget(self) -> QgsAdvancedDigitizingDockWidget: ...
    def defaultStyleSheetFont(self) -> QtGui.QFont: ...
    def defaultStyleSheetOptions(self) -> Dict[str, typing.Any]: ...
    def openLayoutDesigners(self) -> List[QgsLayoutDesignerInterface]: ...
    def messageBar(self) -> QgsMessageBar: ...
    def mainWindow(self) -> QtWidgets.QWidget: ...
    def layerTreeCanvasBridge(self) -> QgsLayerTreeMapCanvasBridge: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def activeLayer(self) -> QgsMapLayer: ...
    def editableLayers(self, modified: bool = ...) -> List[QgsMapLayer]: ...
    def iconSize(self, dockedToolbar: bool = ...) -> QtCore.QSize: ...
    def closeMapCanvas(self, name: str) -> None: ...
    def createNewMapCanvas(self, name: str) -> QgsMapCanvas: ...
    def mapCanvases(self) -> List[QgsMapCanvas]: ...
    def removeCustomActionForLayerType(self, action: QtWidgets.QAction) -> bool: ...
    def addCustomActionForLayer(self, action: QtWidgets.QAction, layer: QgsMapLayer) -> None: ...
    def addCustomActionForLayerType(self, action: QtWidgets.QAction, menu: str, type: QgsMapLayerType, allLayers: bool) -> None: ...
    def layerTreeView(self) -> QgsLayerTreeView: ...
    def pluginManagerInterface(self) -> QgsPluginManagerInterface: ...


class Qgs3DSymbolWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...

    def changed(self) -> None: ...
    def symbolType(self) -> str: ...
    def symbol(self) -> QgsAbstract3DSymbol: ...
    def setSymbol(self, symbol: QgsAbstract3DSymbol, layer: QgsVectorLayer) -> None: ...


class Qgs3DSymbolDialog(QtWidgets.QDialog):

    def __init__(self, symbol: QgsAbstract3DSymbol, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def symbol(self) -> QgsAbstract3DSymbol: ...


class QgsAbstractDataSourceWidget(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., widgetMode: QgsProviderRegistry.WidgetMode = ...) -> None: ...

    def addButton(self) -> QtWidgets.QPushButton: ...
    def setupButtons(self, buttonBox: QtWidgets.QDialogButtonBox) -> None: ...
    def browserModel(self) -> QgsBrowserModel: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def widgetMode(self) -> QgsProviderRegistry.WidgetMode: ...
    def pushMessage(self, title: str, message: str, level: Qgis.MessageLevel = ...) -> None: ...
    def enableButtons(self, enable: bool) -> None: ...
    def progressMessage(self, message: str) -> None: ...
    def progress(self, a0: int, a1: int) -> None: ...
    def replaceVectorLayer(self, oldId: str, source: str, name: str, provider: str) -> None: ...
    def addVectorLayers(self, layerList: Iterable[str], encoding: str, dataSourceType: str) -> None: ...
    def addPointCloudLayer(self, url: str, baseName: str, providerKey: str) -> None: ...
    def addVectorTileLayer(self, url: str, baseName: str) -> None: ...
    def addMeshLayer(self, url: str, baseName: str, providerKey: str) -> None: ...
    def addVectorLayer(self, uri: str, layerName: str, providerKey: str = ...) -> None: ...
    def addRasterLayers(self, layersList: Iterable[str]) -> None: ...
    def addRasterLayer(self, rasterLayerPath: str, baseName: str, providerKey: str) -> None: ...
    def addDatabaseLayers(self, paths: Iterable[str], providerKey: str) -> None: ...
    def connectionsChanged(self) -> None: ...
    def reset(self) -> None: ...
    def addButtonClicked(self) -> None: ...
    def refresh(self) -> None: ...
    def setBrowserModel(self, model: QgsBrowserModel) -> None: ...
    def setMapCanvas(self, mapCanvas: QgsMapCanvas) -> None: ...


class QgsAbstractMapToolHandler(sip.wrapper):

    class Context(sip.wrapper):

        dummy: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsAbstractMapToolHandler.Context) -> None: ...

    @overload
    def __init__(self, tool: QgsMapTool, action: QtWidgets.QAction) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractMapToolHandler) -> None: ...

    def setLayerForTool(self, layer: QgsMapLayer) -> None: ...
    def isCompatibleWithLayer(self, layer: QgsMapLayer, context: QgsAbstractMapToolHandler.Context) -> bool: ...
    def action(self) -> QtWidgets.QAction: ...
    def mapTool(self) -> QgsMapTool: ...


class QgsActionMenu(QtWidgets.QMenu):

    class ActionType(int): ...
    Invalid: QgsActionMenu.ActionType = ...
    MapLayerAction: QgsActionMenu.ActionType = ...
    AttributeAction: QgsActionMenu.ActionType = ...

    class ActionData(sip.wrapper):

        actionData: typing.Any = ...
        actionType: QgsActionMenu.ActionType = ...
        featureId: int = ...
        mapLayer: QgsMapLayer = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, action: QgsAction, featureId: int, mapLayer: QgsMapLayer) -> None: ...
        @overload
        def __init__(self, action: QgsMapLayerAction, featureId: int, mapLayer: QgsMapLayer) -> None: ...
        @overload
        def __init__(self, a0: QgsActionMenu.ActionData) -> None: ...

    @overload
    def __init__(self, layer: QgsVectorLayer, feature: QgsFeature, actionScope: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, layer: QgsVectorLayer, fid: int, actionScope: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def reinit(self) -> None: ...
    def menuActions(self) -> List[QgsAction]: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...
    def setExpressionContextScope(self, scope: QgsExpressionContextScope) -> None: ...
    def setMode(self, mode: QgsAttributeEditorContext.Mode) -> None: ...
    def setFeature(self, feature: QgsFeature) -> None: ...


class QgsDockWidget(QtWidgets.QDockWidget):

    @overload
    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def openedStateChanged(self, wasOpened: bool) -> None: ...
    def opened(self) -> None: ...
    def closedStateChanged(self, wasClosed: bool) -> None: ...
    def closed(self) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def closeEvent(self, a0: QtGui.QCloseEvent) -> None: ...
    def toggleUserVisible(self) -> None: ...
    def setUserVisible(self, visible: bool) -> None: ...
    def toggleVisibilityAction(self) -> QtWidgets.QAction: ...
    def setToggleVisibilityAction(self, action: QtWidgets.QAction) -> None: ...
    def isUserVisible(self) -> bool: ...


class QgsAdvancedDigitizingDockWidget(QgsDockWidget):

    class WidgetSetMode(int): ...
    ReturnPressed: QgsAdvancedDigitizingDockWidget.WidgetSetMode = ...

    class AdditionalConstraint(int): ...
    NoConstraint: QgsAdvancedDigitizingDockWidget.AdditionalConstraint = ...
    Perpendicular: QgsAdvancedDigitizingDockWidget.AdditionalConstraint = ...
    Parallel: QgsAdvancedDigitizingDockWidget.AdditionalConstraint = ...

    class CadCapacity(int): ...
    AbsoluteAngle: QgsAdvancedDigitizingDockWidget.CadCapacity = ...
    RelativeAngle: QgsAdvancedDigitizingDockWidget.CadCapacity = ...
    RelativeCoordinates: QgsAdvancedDigitizingDockWidget.CadCapacity = ...

    class CadCapacities(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsAdvancedDigitizingDockWidget.CadCapacities', 'QgsAdvancedDigitizingDockWidget.CadCapacity']) -> None: ...
        @overload
        def __init__(self, a0: QgsAdvancedDigitizingDockWidget.CadCapacities) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsAdvancedDigitizingDockWidget.CadCapacities': ...
        def __int__(self) -> int: ...

    class CadConstraint(sip.wrapper):

        class LockMode(int): ...
        NoLock: QgsAdvancedDigitizingDockWidget.CadConstraint.LockMode = ...
        SoftLock: QgsAdvancedDigitizingDockWidget.CadConstraint.LockMode = ...
        HardLock: QgsAdvancedDigitizingDockWidget.CadConstraint.LockMode = ...

        @overload
        def __init__(self, lineEdit: QtWidgets.QLineEdit, lockerButton: QtWidgets.QToolButton, relativeButton: Optional[QtWidgets.QToolButton] = ..., repeatingLockButton: Optional[QtWidgets.QToolButton] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsAdvancedDigitizingDockWidget.CadConstraint) -> None: ...

        def toggleRelative(self) -> None: ...
        def toggleLocked(self) -> None: ...
        def setValue(self, value: float, updateWidget: bool = ...) -> None: ...
        def setRelative(self, relative: bool) -> None: ...
        def setRepeatingLock(self, repeating: bool) -> None: ...
        def setLockMode(self, mode: QgsAdvancedDigitizingDockWidget.CadConstraint.LockMode) -> None: ...
        def lineEdit(self) -> QtWidgets.QLineEdit: ...
        def value(self) -> float: ...
        def relative(self) -> bool: ...
        def isRepeatingLock(self) -> bool: ...
        def isLocked(self) -> bool: ...
        def lockMode(self) -> 'QgsAdvancedDigitizingDockWidget.CadConstraint.LockMode': ...

    def __init__(self, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def focusOnDistanceRequested(self) -> None: ...
    def focusOnAngleRequested(self) -> None: ...
    def focusOnYRequested(self) -> None: ...
    def focusOnXRequested(self) -> None: ...
    def enabledChangedDistance(self, enabled: bool) -> None: ...
    def enabledChangedAngle(self, enabled: bool) -> None: ...
    def enabledChangedY(self, enabled: bool) -> None: ...
    def enabledChangedX(self, enabled: bool) -> None: ...
    def relativeAngleChanged(self, relative: bool) -> None: ...
    def relativeYChanged(self, relative: bool) -> None: ...
    def relativeXChanged(self, relative: bool) -> None: ...
    def lockDistanceChanged(self, locked: bool) -> None: ...
    def lockAngleChanged(self, locked: bool) -> None: ...
    def lockYChanged(self, locked: bool) -> None: ...
    def lockXChanged(self, locked: bool) -> None: ...
    def valueDistanceChanged(self, value: str) -> None: ...
    def valueAngleChanged(self, value: str) -> None: ...
    def valueYChanged(self, value: str) -> None: ...
    def valueXChanged(self, value: str) -> None: ...
    def cadEnabledChanged(self, enabled: bool) -> None: ...
    def pointChanged(self, point: QgsPointXY) -> None: ...
    def popWarning(self) -> None: ...
    def pushWarning(self, message: str) -> None: ...
    def setDistance(self, value: str, mode: QgsAdvancedDigitizingDockWidget.WidgetSetMode) -> None: ...
    def setAngle(self, value: str, mode: QgsAdvancedDigitizingDockWidget.WidgetSetMode) -> None: ...
    def setY(self, value: str, mode: QgsAdvancedDigitizingDockWidget.WidgetSetMode) -> None: ...
    def setX(self, value: str, mode: QgsAdvancedDigitizingDockWidget.WidgetSetMode) -> None: ...
    def updateCadPaintItem(self) -> None: ...
    def disable(self) -> None: ...
    def enable(self) -> None: ...
    def enableAction(self) -> QtWidgets.QAction: ...
    def snappedSegment(self) -> List[QgsPointXY]: ...
    def snappedToVertex(self) -> bool: ...
    def pointsCount(self) -> int: ...
    def penultimatePoint(self) -> Tuple[QgsPointXY, bool]: ...
    def previousPoint(self) -> Tuple[QgsPointXY, bool]: ...
    def currentPoint(self) -> Tuple[QgsPointXY, bool]: ...
    def setPoints(self, points: Iterable[QgsPointXY]) -> None: ...
    def removePreviousPoint(self) -> None: ...
    def addPoint(self, point: QgsPointXY) -> None: ...
    def clearPoints(self) -> None: ...
    def mapPointMatch(self) -> QgsPointLocator.Match: ...
    def commonAngleConstraint(self) -> bool: ...
    def constraintY(self) -> 'QgsAdvancedDigitizingDockWidget.CadConstraint': ...
    def constraintX(self) -> 'QgsAdvancedDigitizingDockWidget.CadConstraint': ...
    def constraintDistance(self) -> 'QgsAdvancedDigitizingDockWidget.CadConstraint': ...
    def constraintAngle(self) -> 'QgsAdvancedDigitizingDockWidget.CadConstraint': ...
    def additionalConstraint(self) -> 'QgsAdvancedDigitizingDockWidget.AdditionalConstraint': ...
    def constructionMode(self) -> bool: ...
    def cadEnabled(self) -> bool: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def clear(self) -> None: ...
    def releaseLocks(self, releaseRepeatingLocks: bool = ...) -> None: ...
    def alignToSegment(self, e: QgsMapMouseEvent, lockMode: QgsAdvancedDigitizingDockWidget.CadConstraint.LockMode = ...) -> bool: ...
    def applyConstraints(self, e: QgsMapMouseEvent) -> bool: ...
    def canvasKeyPressEventFilter(self, e: QtGui.QKeyEvent) -> bool: ...


class QgsAdvancedDigitizingFloater(QtWidgets.QWidget):

    def __init__(self, canvas: QgsMapCanvas, cadDockWidget: QgsAdvancedDigitizingDockWidget) -> None: ...

    def setActive(self, active: bool) -> None: ...
    def active(self) -> bool: ...


class QgsAggregateToolButton(QtWidgets.QToolButton):

    def __init__(self) -> None: ...

    def activeChanged(self) -> None: ...
    def aggregateChanged(self) -> None: ...
    def setAggregate(self, aggregate: str) -> None: ...
    def aggregate(self) -> str: ...
    def active(self) -> bool: ...
    def setActive(self, active: bool) -> None: ...
    def type(self) -> QtCore.QVariant.Type: ...
    def setType(self, type: QtCore.QVariant.Type) -> None: ...


class QgsAlignmentComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def customizeAlignmentDisplay(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag], text: str = ..., icon: QtGui.QIcon = ...) -> None: ...
    def setCurrentAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def currentAlignment(self) -> QtCore.Qt.Alignment: ...
    def setAvailableAlignments(self, alignments: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...


class QgsApplicationExitBlockerInterface(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsApplicationExitBlockerInterface) -> None: ...

    def allowExit(self) -> bool: ...


class QgsAttributeDialog(QtWidgets.QDialog):

    def __init__(self, vl: QgsVectorLayer, thepFeature: QgsFeature, featureOwner: bool, parent: Optional[QtWidgets.QWidget] = ..., showDialogButtons: bool = ..., context: QgsAttributeEditorContext = ...) -> None: ...

    def show(self) -> None: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def setExtraContextScope(self, extraScope: QgsExpressionContextScope) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def setEditCommandMessage(self, message: str) -> None: ...
    def setMode(self, mode: QgsAttributeEditorContext.Mode) -> None: ...
    def editable(self) -> bool: ...
    def feature(self) -> QgsFeature: ...
    def attributeForm(self) -> QgsAttributeForm: ...
    def setHighlight(self, h: QgsHighlight) -> None: ...


class QgsAttributeEditorContext(sip.wrapper):

    class FormMode(int): ...
    Embed: QgsAttributeEditorContext.FormMode = ...
    StandaloneDialog: QgsAttributeEditorContext.FormMode = ...
    Popup: QgsAttributeEditorContext.FormMode = ...

    class RelationMode(int): ...
    Undefined: QgsAttributeEditorContext.RelationMode = ...
    Multiple: QgsAttributeEditorContext.RelationMode = ...
    Single: QgsAttributeEditorContext.RelationMode = ...

    class Mode(int): ...
    SingleEditMode: QgsAttributeEditorContext.Mode = ...
    AddFeatureMode: QgsAttributeEditorContext.Mode = ...
    FixAttributeMode: QgsAttributeEditorContext.Mode = ...
    MultiEditMode: QgsAttributeEditorContext.Mode = ...
    SearchMode: QgsAttributeEditorContext.Mode = ...
    AggregateSearchMode: QgsAttributeEditorContext.Mode = ...
    IdentifyMode: QgsAttributeEditorContext.Mode = ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, parentContext: QgsAttributeEditorContext, formMode: QgsAttributeEditorContext.FormMode) -> None: ...
    @overload
    def __init__(self, parentContext: QgsAttributeEditorContext, relation: QgsRelation, relationMode: QgsAttributeEditorContext.RelationMode, widgetMode: QgsAttributeEditorContext.FormMode) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorContext) -> None: ...

    def mainMessageBar(self) -> QgsMessageBar: ...
    def setMainMessageBar(self, messageBar: QgsMessageBar) -> None: ...
    def attributeFormModeString(self) -> str: ...
    def setAttributeFormMode(self, attributeFormMode: QgsAttributeEditorContext.Mode) -> None: ...
    def attributeFormMode(self) -> 'QgsAttributeEditorContext.Mode': ...
    def setParentFormFeature(self, feature: QgsFeature) -> None: ...
    def parentFormFeature(self) -> QgsFeature: ...
    def setFormFeature(self, feature: QgsFeature) -> None: ...
    def formFeature(self) -> QgsFeature: ...
    def parentContext(self) -> QgsAttributeEditorContext: ...
    def setAllowCustomUi(self, allow: bool) -> None: ...
    def allowCustomUi(self) -> bool: ...
    def setFormMode(self, mode: QgsAttributeEditorContext.FormMode) -> None: ...
    def formMode(self) -> 'QgsAttributeEditorContext.FormMode': ...
    def relationMode(self) -> 'QgsAttributeEditorContext.RelationMode': ...
    def relation(self) -> QgsRelation: ...
    def setRelation(self, relation: QgsRelation, mode: QgsAttributeEditorContext.RelationMode) -> None: ...
    def vectorLayerTools(self) -> QgsVectorLayerTools: ...
    def setVectorLayerTools(self, vlTools: QgsVectorLayerTools) -> None: ...
    def cadDockWidget(self) -> QgsAdvancedDigitizingDockWidget: ...
    def setCadDockWidget(self, cadDockWidget: QgsAdvancedDigitizingDockWidget) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def setMapCanvas(self, mapCanvas: QgsMapCanvas) -> None: ...
    def distanceArea(self) -> QgsDistanceArea: ...
    def setDistanceArea(self, distanceArea: QgsDistanceArea) -> None: ...


class QgsAttributeForm(QtWidgets.QWidget):

    class FilterType(int): ...
    ReplaceFilter: QgsAttributeForm.FilterType = ...
    FilterAnd: QgsAttributeForm.FilterType = ...
    FilterOr: QgsAttributeForm.FilterType = ...

    class Mode(int): ...
    SingleEditMode: QgsAttributeForm.Mode = ...
    AddFeatureMode: QgsAttributeForm.Mode = ...
    MultiEditMode: QgsAttributeForm.Mode = ...
    SearchMode: QgsAttributeForm.Mode = ...
    AggregateSearchMode: QgsAttributeForm.Mode = ...
    IdentifyMode: QgsAttributeForm.Mode = ...

    def __init__(self, vl: QgsVectorLayer, feature: QgsFeature = ..., context: QgsAttributeEditorContext = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def parentFormValueChanged(self, attribute: str, newValue: typing.Any) -> None: ...
    def refreshFeature(self) -> None: ...
    def resetSearch(self) -> None: ...
    def resetValues(self) -> None: ...
    def saveWithDetails(self) -> Tuple[bool, str]: ...
    def save(self) -> bool: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def changeAttribute(self, field: str, value: typing.Any, hintText: str = ...) -> None: ...
    def flashFeatures(self, filter: str) -> None: ...
    def zoomToFeatures(self, filter: str) -> None: ...
    def closed(self) -> None: ...
    def modeChanged(self, mode: QgsAttributeEditorContext.Mode) -> None: ...
    def filterExpressionSet(self, expression: str, type: QgsAttributeForm.FilterType) -> None: ...
    def featureSaved(self, feature: QgsFeature) -> None: ...
    def widgetValueChanged(self, attribute: str, value: typing.Any, attributeChanged: bool) -> None: ...
    def attributeChanged(self, attribute: str, value: typing.Any) -> None: ...
    def setExtraContextScope(self, extraScope: QgsExpressionContextScope) -> None: ...
    def aggregateFilter(self) -> str: ...
    def setMessageBar(self, messageBar: QgsMessageBar) -> None: ...
    def setMultiEditFeatureIds(self, fids: typing.Any) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def setEditCommandMessage(self, message: str) -> None: ...
    def setMode(self, mode: QgsAttributeEditorContext.Mode) -> None: ...
    def mode(self) -> QgsAttributeEditorContext.Mode: ...
    def editable(self) -> bool: ...
    def layer(self) -> QgsVectorLayer: ...
    def addInterface(self, iface: QgsAttributeFormInterface) -> None: ...
    def disconnectButtonBox(self) -> None: ...
    def showButtonBox(self) -> None: ...
    def hideButtonBox(self) -> None: ...
    def displayWarning(self, message: str) -> None: ...
    def currentFormFeature(self) -> QgsFeature: ...
    def feature(self) -> QgsFeature: ...


class QgsAttributeFormWidget(QtWidgets.QWidget):

    class Mode(int): ...
    DefaultMode: QgsAttributeFormWidget.Mode = ...
    MultiEditMode: QgsAttributeFormWidget.Mode = ...
    SearchMode: QgsAttributeFormWidget.Mode = ...
    AggregateSearchMode: QgsAttributeFormWidget.Mode = ...

    def __init__(self, widget: QgsWidgetWrapper, form: QgsAttributeForm) -> None: ...

    def setSearchWidgetToolButtonVisible(self, searchWidgetToolButtonVisible: bool) -> None: ...
    def searchWidgetToolButtonVisible(self) -> bool: ...
    def resetSearch(self) -> None: ...
    def searchWidgetWrappers(self) -> List[QgsSearchWidgetWrapper]: ...
    def addAdditionalSearchWidgetWrapper(self, wrapper: QgsSearchWidgetWrapper) -> None: ...
    def setSearchWidgetWrapper(self, wrapper: QgsSearchWidgetWrapper) -> None: ...
    def form(self) -> QgsAttributeForm: ...
    def layer(self) -> QgsVectorLayer: ...
    def mode(self) -> 'QgsAttributeFormWidget.Mode': ...
    def setMode(self, mode: QgsAttributeFormWidget.Mode) -> None: ...
    def currentFilterExpression(self) -> str: ...
    def createSearchWidgetWrappers(self) -> None: ...


class QgsAttributeFormEditorWidget(QgsAttributeFormWidget):

    def __init__(self, editorWidget: QgsEditorWidgetWrapper, widgetType: str, form: QgsAttributeForm) -> None: ...

    def valuesChanged(self, value: typing.Any, additionalFieldValues: Iterable[typing.Any]) -> None: ...
    def valueChanged(self, value: typing.Any) -> None: ...
    def changesCommitted(self) -> None: ...
    def setIsMixed(self, mixed: bool) -> None: ...
    def editorWidget(self) -> QgsEditorWidgetWrapper: ...
    def setConstraintResultVisible(self, editable: bool) -> None: ...
    def setConstraintStatus(self, constraint: str, description: str, err: str, result: QgsEditorWidgetWrapper.ConstraintResult) -> None: ...
    def currentValue(self) -> typing.Any: ...
    def hasChanged(self) -> bool: ...
    def initialize(self, initialValue: typing.Any, mixedValues: bool = ..., additionalFieldValues: Iterable[typing.Any] = ...) -> None: ...
    def createSearchWidgetWrappers(self, context: QgsAttributeEditorContext = ...) -> None: ...


class QgsAttributeFormInterface(sip.wrapper):

    @overload
    def __init__(self, form: QgsAttributeForm) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeFormInterface) -> None: ...

    def feature(self) -> QgsFeature: ...
    def form(self) -> QgsAttributeForm: ...
    def featureChanged(self) -> None: ...
    def initForm(self) -> None: ...
    def acceptChanges(self, feature: QgsFeature) -> bool: ...


class QgsAttributeFormRelationEditorWidget(QgsAttributeFormWidget):

    def __init__(self, wrapper: QgsRelationWidgetWrapper, form: QgsAttributeForm) -> None: ...

    def currentFilterExpression(self) -> str: ...
    def createSearchWidgetWrappers(self, context: QgsAttributeEditorContext = ...) -> None: ...


class QgsAttributeTypeLoadDialog(QtWidgets.QDialog):

    def __init__(self, vl: QgsVectorLayer) -> None: ...

    def insertNull(self) -> bool: ...
    def valueMap(self) -> Dict[str, typing.Any]: ...
    def setVectorLayer(self, layer: QgsVectorLayer) -> None: ...
    def accept(self) -> None: ...


class QgsBlendModeComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def updateModes(self) -> None: ...
    def setBlendMode(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...


class QgsBrowserDockWidget(QgsDockWidget):

    def __init__(self, name: str, browserModel: QgsBrowserGuiModel, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def connectionsChanged(self) -> None: ...
    def handleDropUriList(self, a0: Iterable[QgsMimeDataUtils.Uri]) -> None: ...
    def openFile(self, fileName: str, fileTypeHint: str = ...) -> None: ...
    def splitterMoved(self) -> None: ...
    def selectionChanged(self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection) -> None: ...
    def toggleFastScan(self) -> None: ...
    def hideItem(self) -> None: ...
    def showProperties(self) -> None: ...
    def addSelectedLayers(self) -> None: ...
    def updateProjectHome(self) -> None: ...
    def setActiveIndex(self, index: QtCore.QModelIndex) -> None: ...
    def setFilter(self) -> None: ...
    def setCaseSensitive(self, caseSensitive: bool) -> None: ...
    def setFilterSyntax(self, a0: QtWidgets.QAction) -> None: ...
    def enablePropertiesWidget(self, enable: bool) -> None: ...
    def showFilterWidget(self, visible: bool) -> None: ...
    def refresh(self) -> None: ...
    def removeFavorite(self) -> None: ...
    def addFavorite(self) -> None: ...
    def showContextMenu(self, a0: QtCore.QPoint) -> None: ...
    def addLayerAtIndex(self, index: QtCore.QModelIndex) -> bool: ...
    def setDisabledDataItemsKeys(self, filter: Iterable[str]) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    @overload
    def addFavoriteDirectory(self, favDir: str, name: str = ...) -> None: ...
    @overload
    def addFavoriteDirectory(self) -> None: ...


class QgsBrowserGuiModel(QgsBrowserModel):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...


class QgsBrowserTreeView(QtWidgets.QTreeView):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def rowsInserted(self, parentIndex: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def setSettingsSection(self, section: str) -> None: ...
    def hasExpandedDescendant(self, index: QtCore.QModelIndex) -> bool: ...
    def hideEvent(self, e: QtGui.QHideEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def browserModel(self) -> QgsBrowserGuiModel: ...
    def setBrowserModel(self, model: QgsBrowserGuiModel) -> None: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QgsBusyIndicatorDialog(QtWidgets.QDialog):

    def __init__(self, message: str = ..., parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setMessage(self, message: str) -> None: ...
    def message(self) -> str: ...


class QgsCharacterSelectorDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def selectCharacter(self, font: QtGui.QFont, style: str, initialSelection: str = ...) -> Tuple[str, bool]: ...


class QgsCheckableComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def deselectAllOptions(self) -> None: ...
    def selectAllOptions(self) -> None: ...
    def showContextMenu(self, pos: QtCore.QPoint) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def setCheckedItems(self, items: Iterable[str]) -> None: ...
    def checkedItemsChanged(self, items: Iterable[str]) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def hidePopup(self) -> None: ...
    def toggleItemCheckState(self, index: int) -> None: ...
    def setItemCheckState(self, index: int, state: QtCore.Qt.CheckState) -> None: ...
    def itemCheckState(self, index: int) -> QtCore.Qt.CheckState: ...
    def checkedItemsData(self) -> List[typing.Any]: ...
    def checkedItems(self) -> List[str]: ...
    def addItemWithCheckState(self, text: str, state: QtCore.Qt.CheckState, userData: typing.Any = ...) -> None: ...
    def setDefaultText(self, text: str) -> None: ...
    def defaultText(self) -> str: ...
    def setSeparator(self, separator: str) -> None: ...
    def separator(self) -> str: ...


class QgsGroupBoxCollapseButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def setShiftDown(self, shiftdown: bool) -> None: ...
    def shiftDown(self) -> bool: ...
    def setAltDown(self, updown: bool) -> None: ...
    def altDown(self) -> bool: ...


class QgsCollapsibleGroupBoxBasic(QtWidgets.QGroupBox):

    @overload
    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def clearModifiers(self) -> None: ...
    def titleRect(self) -> QtCore.QRect: ...
    def updateStyle(self) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def collapseExpandFixes(self) -> None: ...
    def init(self) -> None: ...
    def setStyleSheet(self, style: str) -> None: ...
    def toggleCollapsed(self) -> None: ...
    def checkClicked(self, ckd: bool) -> None: ...
    def checkToggled(self, ckd: bool) -> None: ...
    def collapsedStateChanged(self, collapsed: bool) -> None: ...
    def scrollOnExpand(self) -> bool: ...
    def setScrollOnExpand(self, scroll: bool) -> None: ...
    def setSyncGroup(self, grp: str) -> None: ...
    def syncGroup(self) -> str: ...
    def setCollapsed(self, collapse: bool) -> None: ...
    def isCollapsed(self) -> bool: ...


class QgsCollapsibleGroupBox(QgsCollapsibleGroupBoxBasic):

    @overload
    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., settings: Optional[QgsSettings] = ...) -> None: ...
    @overload
    def __init__(self, title: str, parent: Optional[QtWidgets.QWidget] = ..., settings: Optional[QgsSettings] = ...) -> None: ...

    def saveKey(self) -> str: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def init(self) -> None: ...
    def saveState(self) -> None: ...
    def loadState(self) -> None: ...
    def settingGroup(self) -> str: ...
    def setSettingGroup(self, group: str) -> None: ...
    def saveCheckedState(self) -> bool: ...
    def saveCollapsedState(self) -> bool: ...
    def setSaveCheckedState(self, save: bool) -> None: ...
    def setSaveCollapsedState(self, save: bool) -> None: ...
    def setSettings(self, settings: QgsSettings) -> None: ...


class QgsPanelWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def acceptPanel(self) -> None: ...
    def openPanel(self, panel: QgsPanelWidget) -> None: ...
    def widgetChanged(self) -> None: ...
    def showPanel(self, panel: QgsPanelWidget) -> None: ...
    def panelAccepted(self, panel: QgsPanelWidget) -> None: ...
    def menuButtonMenu(self) -> QtWidgets.QMenu: ...
    def menuButtonTooltip(self) -> str: ...
    @staticmethod
    def findParentPanel(widget: QtWidgets.QWidget) -> QgsPanelWidget: ...
    def autoDelete(self) -> bool: ...
    def setAutoDelete(self, autoDelete: bool) -> None: ...
    def dockMode(self) -> bool: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def connectChildPanel(self, panel: QgsPanelWidget) -> None: ...
    def connectChildPanels(self, panels: Iterable[QgsPanelWidget]) -> None: ...
    def panelTitle(self) -> str: ...
    def setPanelTitle(self, panelTitle: str) -> None: ...


class QgsColorBrewerColorRampWidget(QgsPanelWidget):

    def __init__(self, ramp: QgsColorBrewerColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def setRamp(self, ramp: QgsColorBrewerColorRamp) -> None: ...
    def ramp(self) -> QgsColorBrewerColorRamp: ...


class QgsColorBrewerColorRampDialog(QtWidgets.QDialog):

    def __init__(self, ramp: QgsColorBrewerColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def setRamp(self, ramp: QgsColorBrewerColorRamp) -> None: ...
    def ramp(self) -> QgsColorBrewerColorRamp: ...


class QgsColorButton(QtWidgets.QToolButton):

    class Behavior(int): ...
    ShowDialog: QgsColorButton.Behavior = ...
    SignalOnly: QgsColorButton.Behavior = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., cdt: str = ..., registry: Optional[QgsColorSchemeRegistry] = ...) -> None: ...

    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    @staticmethod
    def transparentBackground() -> QtGui.QPixmap: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def unlinked(self) -> None: ...
    def cleared(self) -> None: ...
    def colorClicked(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def colorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def unlink(self) -> None: ...
    def setToNull(self) -> None: ...
    def setToDefaultColor(self) -> None: ...
    def setToNoColor(self) -> None: ...
    def activatePicker(self) -> None: ...
    def pasteColor(self) -> None: ...
    def copyColor(self) -> None: ...
    def setButtonBackground(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @staticmethod
    def createMenuIcon(color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], showChecks: bool = ...) -> QtGui.QPixmap: ...
    def linkedProjectColorName(self) -> str: ...
    def linkToProjectColor(self, name: str) -> None: ...
    def colorSchemeRegistry(self) -> QgsColorSchemeRegistry: ...
    def setColorSchemeRegistry(self, registry: QgsColorSchemeRegistry) -> None: ...
    def context(self) -> str: ...
    def setContext(self, context: str) -> None: ...
    def noColorString(self) -> str: ...
    def isNull(self) -> bool: ...
    def showNull(self) -> bool: ...
    def setShowNull(self, showNull: bool, nullString: str = ...) -> None: ...
    def setNoColorString(self, noColorString: str) -> None: ...
    def showNoColor(self) -> bool: ...
    def setShowNoColor(self, showNoColorOption: bool) -> None: ...
    def defaultColor(self) -> QtGui.QColor: ...
    def setDefaultColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def behavior(self) -> 'QgsColorButton.Behavior': ...
    def setBehavior(self, behavior: QgsColorButton.Behavior) -> None: ...
    def showMenu(self) -> bool: ...
    def setShowMenu(self, showMenu: bool) -> None: ...
    def colorDialogTitle(self) -> str: ...
    def setColorDialogTitle(self, title: str) -> None: ...
    def allowOpacity(self) -> bool: ...
    def setAllowOpacity(self, allowOpacity: bool) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsColorDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...

    def closeEvent(self, e: QtGui.QCloseEvent) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def currentColorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @staticmethod
    def getColor(initialColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], parent: QtWidgets.QWidget, title: str = ..., allowOpacity: bool = ...) -> QtGui.QColor: ...
    def setAllowOpacity(self, allowOpacity: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def color(self) -> QtGui.QColor: ...


class QgsColorRampButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., dialogTitle: str = ...) -> None: ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def colorRampChanged(self) -> None: ...
    def setToNull(self) -> None: ...
    def setToDefaultColorRamp(self) -> None: ...
    def setButtonBackground(self, colorramp: Optional[QgsColorRamp] = ...) -> None: ...
    def setColorRampFromName(self, name: str = ...) -> None: ...
    def setRandomColorRamp(self) -> None: ...
    def setColorRamp(self, colorramp: QgsColorRamp) -> None: ...
    def colorRampName(self) -> str: ...
    def setColorRampName(self, name: str) -> None: ...
    def showGradientOnly(self) -> bool: ...
    def setShowGradientOnly(self, gradientonly: bool) -> None: ...
    def context(self) -> str: ...
    def setContext(self, context: str) -> None: ...
    def isNull(self) -> bool: ...
    def showNull(self) -> bool: ...
    def setShowNull(self, showNull: bool) -> None: ...
    def isRandomColorRamp(self) -> bool: ...
    def showRandomColorRamp(self) -> bool: ...
    def setShowRandomColorRamp(self, showRandom: bool) -> None: ...
    def defaultColorRamp(self) -> QgsColorRamp: ...
    def setDefaultColorRamp(self, colorramp: QgsColorRamp) -> None: ...
    def showMenu(self) -> bool: ...
    def setShowMenu(self, showMenu: bool) -> None: ...
    def setAcceptLiveUpdates(self, accept: bool) -> None: ...
    def acceptLiveUpdates(self) -> bool: ...
    def colorRampDialogTitle(self) -> str: ...
    def setColorRampDialogTitle(self, title: str) -> None: ...
    def colorRamp(self) -> QgsColorRamp: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QgsColorRampLegendNodeWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setUseContinuousRampCheckBoxVisibility(self, visible: bool) -> None: ...
    def setSettings(self, settings: QgsColorRampLegendNodeSettings) -> None: ...
    def settings(self) -> QgsColorRampLegendNodeSettings: ...


class QgsColorRampLegendNodeDialog(QtWidgets.QDialog):

    def __init__(self, settings: QgsColorRampLegendNodeSettings, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setUseContinuousRampCheckBoxVisibility(self, visible: bool) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def settings(self) -> QgsColorRampLegendNodeSettings: ...


class QgsColorSwatchDelegate(QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def editorEvent(self, event: QtCore.QEvent, model: QtCore.QAbstractItemModel, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> bool: ...
    def sizeHint(self, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...


class QgsColorSchemeModel(QtCore.QAbstractItemModel):

    def __init__(self, scheme: QgsColorScheme, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def isDirty(self) -> bool: ...
    def addColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], label: str = ..., allowDuplicate: bool = ...) -> None: ...
    def baseColor(self) -> QtGui.QColor: ...
    def context(self) -> str: ...
    def setScheme(self, scheme: QgsColorScheme, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    def colors(self) -> List[Tuple[QtGui.QColor, str]]: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def mimeTypes(self) -> List[str]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...


class QgsColorSchemeList(QtWidgets.QTreeView):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., scheme: Optional[QgsColorScheme] = ..., context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def colorSelected(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def showExportColorsDialog(self) -> None: ...
    def showImportColorsDialog(self) -> None: ...
    def copyColors(self) -> None: ...
    def pasteColors(self) -> None: ...
    def addColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], label: str = ..., allowDuplicate: bool = ...) -> None: ...
    def removeSelection(self) -> None: ...
    def setScheme(self, scheme: QgsColorScheme, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    def scheme(self) -> QgsColorScheme: ...
    def isDirty(self) -> bool: ...
    def exportColorsToGpl(self, file: QtCore.QFile) -> bool: ...
    def importColorsFromGpl(self, file: QtCore.QFile) -> bool: ...
    def saveColorsToScheme(self) -> bool: ...


class QgsColorSwatchGrid(QtWidgets.QWidget):

    def __init__(self, scheme: QgsColorScheme, context: str = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def hovered(self) -> None: ...
    def colorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def refreshColors(self) -> None: ...
    def colors(self) -> List[Tuple[QtGui.QColor, str]]: ...
    def setBaseColor(self, baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def baseColor(self) -> QtGui.QColor: ...
    def setContext(self, context: str) -> None: ...
    def context(self) -> str: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsColorSwatchGridAction(QtWidgets.QWidgetAction):

    def __init__(self, scheme: QgsColorScheme, menu: Optional[QtWidgets.QMenu] = ..., context: str = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def colorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def refreshColors(self) -> None: ...
    def dismissOnColorSelection(self) -> bool: ...
    def setDismissOnColorSelection(self, dismiss: bool) -> None: ...
    def setContext(self, context: str) -> None: ...
    def context(self) -> str: ...
    def baseColor(self) -> QtGui.QColor: ...
    def setBaseColor(self, baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...


class QgsColorWidget(QtWidgets.QWidget):

    class ColorComponent(int): ...
    Multiple: QgsColorWidget.ColorComponent = ...
    Red: QgsColorWidget.ColorComponent = ...
    Green: QgsColorWidget.ColorComponent = ...
    Blue: QgsColorWidget.ColorComponent = ...
    Hue: QgsColorWidget.ColorComponent = ...
    Saturation: QgsColorWidget.ColorComponent = ...
    Value: QgsColorWidget.ColorComponent = ...
    Alpha: QgsColorWidget.ColorComponent = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., component: QgsColorWidget.ColorComponent = ...) -> None: ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    @staticmethod
    def transparentBackground() -> QtGui.QPixmap: ...
    def alterColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], component: QgsColorWidget.ColorComponent, newValue: int) -> None: ...
    def hue(self) -> int: ...
    @overload
    def componentRange(self) -> int: ...
    @overload
    def componentRange(self, component: QgsColorWidget.ColorComponent) -> int: ...
    def hovered(self) -> None: ...
    def colorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setComponentValue(self, value: int) -> None: ...
    def setComponent(self, component: QgsColorWidget.ColorComponent) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], emitSignals: bool = ...) -> None: ...
    @staticmethod
    def createDragIcon(color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> QtGui.QPixmap: ...
    @overload
    def componentValue(self) -> int: ...
    @overload
    def componentValue(self, component: QgsColorWidget.ColorComponent) -> int: ...
    def component(self) -> 'QgsColorWidget.ColorComponent': ...
    def color(self) -> QtGui.QColor: ...


class QgsColorWidgetAction(QtWidgets.QWidgetAction):

    def __init__(self, colorWidget: QgsColorWidget, menu: Optional[QtWidgets.QMenu] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def colorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def dismissOnColorSelection(self) -> bool: ...
    def setDismissOnColorSelection(self, dismiss: bool) -> None: ...
    def colorWidget(self) -> QgsColorWidget: ...


class QgsColorWheel(QgsColorWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], emitSignals: bool = ...) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QgsColorBox(QgsColorWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., component: QgsColorWidget.ColorComponent = ...) -> None: ...

    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], emitSignals: bool = ...) -> None: ...
    def setComponent(self, component: QgsColorWidget.ColorComponent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QgsColorRampWidget(QgsColorWidget):

    class Orientation(int): ...
    Horizontal: QgsColorRampWidget.Orientation = ...
    Vertical: QgsColorRampWidget.Orientation = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., component: QgsColorWidget.ColorComponent = ..., orientation: QgsColorRampWidget.Orientation = ...) -> None: ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def valueChanged(self, value: int) -> None: ...
    def setMarkerSize(self, markerSize: int) -> None: ...
    def showFrame(self) -> bool: ...
    def setShowFrame(self, showFrame: bool) -> None: ...
    def interiorMargin(self) -> int: ...
    def setInteriorMargin(self, margin: int) -> None: ...
    def orientation(self) -> 'QgsColorRampWidget.Orientation': ...
    def setOrientation(self, orientation: QgsColorRampWidget.Orientation) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QgsColorSliderWidget(QgsColorWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., component: QgsColorWidget.ColorComponent = ...) -> None: ...

    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], emitSignals: bool = ...) -> None: ...
    def setComponentValue(self, value: int) -> None: ...
    def setComponent(self, component: QgsColorWidget.ColorComponent) -> None: ...


class QgsColorTextWidget(QgsColorWidget):

    class ColorTextFormat(int): ...
    HexRgb: QgsColorTextWidget.ColorTextFormat = ...
    HexRgbA: QgsColorTextWidget.ColorTextFormat = ...
    Rgb: QgsColorTextWidget.ColorTextFormat = ...
    Rgba: QgsColorTextWidget.ColorTextFormat = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], emitSignals: bool = ...) -> None: ...


class QgsColorPreviewWidget(QgsColorWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def setColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color2(self) -> QtGui.QColor: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...


class QgsCompoundColorWidget(QgsPanelWidget):

    class Layout(int): ...
    LayoutDefault: QgsCompoundColorWidget.Layout = ...
    LayoutVertical: QgsCompoundColorWidget.Layout = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., layout: QgsCompoundColorWidget.Layout = ...) -> None: ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def hideEvent(self, e: QtGui.QHideEvent) -> None: ...
    def setPreviousColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def currentColorChanged(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @staticmethod
    def removeUserPalette(scheme: QgsUserColorScheme, parent: QtWidgets.QWidget) -> bool: ...
    @staticmethod
    def createNewUserPalette(parent: QtWidgets.QWidget) -> QgsUserColorScheme: ...
    @staticmethod
    def importUserPaletteFromFile(parent: QtWidgets.QWidget) -> QgsUserColorScheme: ...
    def setDiscarded(self, discarded: bool) -> None: ...
    def setAllowOpacity(self, allowOpacity: bool) -> None: ...
    def color(self) -> QtGui.QColor: ...


class QgsConfigureShortcutsDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., manager: Optional[QgsShortcutsManager] = ...) -> None: ...

    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...


class QgsMapCanvas(QtWidgets.QGraphicsView, QgsExpressionContextGenerator):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def updateCanvasItemPositions(self) -> None: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def moveCanvasContents(self, reset: bool = ...) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseDoubleClickEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def contextMenuAboutToShow(self, menu: QtWidgets.QMenu, event: QgsMapMouseEvent) -> None: ...
    def zRangeChanged(self) -> None: ...
    def temporalRangeChanged(self) -> None: ...
    def tapAndHoldGestureOccurred(self, mapPoint: QgsPointXY, gesture: QtWidgets.QTapAndHoldGesture) -> None: ...
    def panDistanceBearingChanged(self, distance: float, unit: QgsUnitTypes.DistanceUnit, bearing: float) -> None: ...
    def renderErrorOccurred(self, error: str, layer: QgsMapLayer) -> None: ...
    def messageEmitted(self, title: str, message: str, a2: Qgis.MessageLevel = ...) -> None: ...
    def themeChanged(self, theme: str) -> None: ...
    def layerStyleOverridesChanged(self) -> None: ...
    def currentLayerChanged(self, layer: QgsMapLayer) -> None: ...
    def transformContextChanged(self) -> None: ...
    def destinationCrsChanged(self) -> None: ...
    def zoomNextStatusChanged(self, a0: bool) -> None: ...
    def zoomLastStatusChanged(self, a0: bool) -> None: ...
    def selectionChanged(self, layer: QgsVectorLayer) -> None: ...
    def mapToolSet(self, newTool: QgsMapTool, oldTool: QgsMapTool) -> None: ...
    def keyReleased(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressed(self, e: QtGui.QKeyEvent) -> None: ...
    def layersChanged(self) -> None: ...
    def mapRefreshCanceled(self) -> None: ...
    def renderStarting(self) -> None: ...
    def mapCanvasRefreshed(self) -> None: ...
    def renderComplete(self, a0: QtGui.QPainter) -> None: ...
    def canvasColorChanged(self) -> None: ...
    def magnificationChanged(self, a0: float) -> None: ...
    def rotationChanged(self, a0: float) -> None: ...
    def extentsChanged(self) -> None: ...
    def scaleLockChanged(self, locked: bool) -> None: ...
    def scaleChanged(self, a0: float) -> None: ...
    def xyCoordinates(self, p: QgsPointXY) -> None: ...
    def setZRange(self, range: QgsDoubleRange) -> None: ...
    def zRange(self) -> QgsDoubleRange: ...
    def zoomResolutions(self) -> List[float]: ...
    def zoomOutFactor(self) -> float: ...
    def zoomInFactor(self) -> float: ...
    def setZoomResolutions(self, resolutions: Iterable[float]) -> None: ...
    @overload
    def zoomToSelected(self, layer: Optional[QgsVectorLayer] = ...) -> None: ...
    @overload
    def zoomToSelected(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def zoomOut(self) -> None: ...
    def zoomIn(self) -> None: ...
    def setScaleLocked(self, isLocked: bool) -> None: ...
    def setMagnificationFactor(self, factor: float, center: Optional[QgsPointXY] = ...) -> None: ...
    def writeProject(self, a0: QtXml.QDomDocument) -> None: ...
    def readProject(self, a0: QtXml.QDomDocument) -> None: ...
    def stopRendering(self) -> None: ...
    def setRenderFlag(self, flag: bool) -> None: ...
    def layerStateChange(self) -> None: ...
    def saveAsImage(self, fileName: str, QPixmap: Optional[QtGui.QPixmap] = ..., a2: str = ...) -> None: ...
    def selectionChangedSlot(self) -> None: ...
    def redrawAllLayers(self) -> None: ...
    def refreshAllLayers(self) -> None: ...
    def refresh(self) -> None: ...
    def allowInteraction(self, interaction: QgsMapCanvasInteractionBlocker.Interaction) -> bool: ...
    def removeInteractionBlocker(self, blocker: QgsMapCanvasInteractionBlocker) -> None: ...
    def installInteractionBlocker(self, blocker: QgsMapCanvasInteractionBlocker) -> None: ...
    def temporalRange(self) -> QgsDateTimeRange: ...
    def setTemporalRange(self, range: QgsDateTimeRange) -> None: ...
    def setPreviewJobsEnabled(self, enabled: bool) -> None: ...
    def previewJobsEnabled(self) -> bool: ...
    def labelingEngineSettings(self) -> QgsLabelingEngineSettings: ...
    def setLabelingEngineSettings(self, settings: QgsLabelingEngineSettings) -> None: ...
    def setAnnotationsVisible(self, visible: bool) -> None: ...
    def annotationsVisible(self) -> bool: ...
    def annotationItems(self) -> List[QgsMapCanvasAnnotationItem]: ...
    def setSegmentationToleranceType(self, type: QgsAbstractGeometry.SegmentationToleranceType) -> None: ...
    def setSegmentationTolerance(self, tolerance: float) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def defaultExpressionContextScope(self) -> QgsExpressionContextScope: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...
    def setExpressionContextScope(self, scope: QgsExpressionContextScope) -> None: ...
    def setSnappingUtils(self, utils: QgsSnappingUtils) -> None: ...
    def snappingUtils(self) -> QgsSnappingUtils: ...
    def previewMode(self) -> 'QgsPreviewEffect.PreviewMode': ...
    def setPreviewMode(self, mode: QgsPreviewEffect.PreviewMode) -> None: ...
    def previewModeEnabled(self) -> bool: ...
    def setPreviewModeEnabled(self, previewEnabled: bool) -> None: ...
    def mouseLastXY(self) -> QtCore.QPoint: ...
    def panAction(self, event: QtGui.QMouseEvent) -> None: ...
    def panActionEnd(self, releasePoint: QtCore.QPoint) -> None: ...
    def enableMapTileRendering(self, flag: bool) -> None: ...
    def antiAliasingEnabled(self) -> bool: ...
    def enableAntiAliasing(self, flag: bool) -> None: ...
    def scaleLocked(self) -> bool: ...
    def zoomToFeatureExtent(self, rect: QgsRectangle) -> None: ...
    def zoomWithCenter(self, x: int, y: int, zoomIn: bool) -> None: ...
    def zoomByFactor(self, scaleFactor: float, center: Optional[QgsPointXY] = ..., ignoreScaleLock: bool = ...) -> None: ...
    def zoomScale(self, scale: float, ignoreScaleLock: bool = ...) -> None: ...
    def setWheelFactor(self, factor: float) -> None: ...
    def currentLayer(self) -> QgsMapLayer: ...
    def isDrawing(self) -> bool: ...
    def getCoordinateTransform(self) -> QgsMapToPixel: ...
    def theme(self) -> str: ...
    def setTheme(self, theme: str) -> None: ...
    def setLayerStyleOverrides(self, overrides: Dict[str, str]) -> None: ...
    def layerStyleOverrides(self) -> Dict[str, str]: ...
    def mapUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def renderFlag(self) -> bool: ...
    def isFrozen(self) -> bool: ...
    def freeze(self, frozen: bool = ...) -> None: ...
    def layers(self) -> List[QgsMapLayer]: ...
    def layerCount(self) -> int: ...
    def layer(self, index: int) -> QgsMapLayer: ...
    def updateScale(self) -> None: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def setSelectionColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def canvasColor(self) -> QtGui.QColor: ...
    def setCanvasColor(self, _newVal: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def project(self) -> QgsProject: ...
    def setProject(self, project: QgsProject) -> None: ...
    def mapTool(self) -> QgsMapTool: ...
    def unsetMapTool(self, mapTool: QgsMapTool) -> None: ...
    def setMapTool(self, mapTool: QgsMapTool, clean: bool = ...) -> None: ...
    def flashGeometries(self, geometries: Iterable[QgsGeometry], crs: QgsCoordinateReferenceSystem = ..., startColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., endColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., flashes: int = ..., duration: int = ...) -> None: ...
    def flashFeatureIds(self, layer: QgsVectorLayer, ids: typing.Any, startColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., endColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., flashes: int = ..., duration: int = ...) -> None: ...
    @overload
    def panToSelected(self, layer: Optional[QgsVectorLayer] = ...) -> None: ...
    @overload
    def panToSelected(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def panToFeatureIds(self, layer: QgsVectorLayer, ids: typing.Any, alwaysRecenter: bool = ...) -> None: ...
    def zoomToFeatureIds(self, layer: QgsVectorLayer, ids: typing.Any) -> None: ...
    def clearExtentHistory(self) -> None: ...
    def zoomToNextExtent(self) -> None: ...
    def zoomToPreviousExtent(self) -> None: ...
    def zoomToProjectExtent(self) -> None: ...
    def zoomToFullExtent(self) -> None: ...
    def center(self) -> QgsPointXY: ...
    def setCenter(self, center: QgsPointXY) -> None: ...
    def setRotation(self, degrees: float) -> None: ...
    def rotation(self) -> float: ...
    def setReferencedExtent(self, extent: QgsReferencedRectangle) -> bool: ...
    def setExtent(self, r: QgsRectangle, magnified: bool = ...) -> None: ...
    def projectExtent(self) -> QgsRectangle: ...
    def fullExtent(self) -> QgsRectangle: ...
    def extent(self) -> QgsRectangle: ...
    def mapUnitsPerPixel(self) -> float: ...
    def scale(self) -> float: ...
    def mapUpdateInterval(self) -> int: ...
    def setMapUpdateInterval(self, timeMilliseconds: int) -> None: ...
    def isParallelRenderingEnabled(self) -> bool: ...
    def setParallelRenderingEnabled(self, enabled: bool) -> None: ...
    def waitWhileRendering(self) -> None: ...
    def clearCache(self) -> None: ...
    def isCachingEnabled(self) -> bool: ...
    def setCachingEnabled(self, enabled: bool) -> None: ...
    def labelingResults(self, allowOutdatedResults: bool = ...) -> QgsLabelingResults: ...
    def setMapSettingsFlags(self, flags: Union[QgsMapSettings.Flags, QgsMapSettings.Flag]) -> None: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def temporalController(self) -> QgsTemporalController: ...
    def setTemporalController(self, controller: QgsTemporalController) -> None: ...
    def mapSettings(self) -> QgsMapSettings: ...
    def setCurrentLayer(self, layer: QgsMapLayer) -> None: ...
    def setLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def magnificationFactor(self) -> float: ...


class QgsCoordinateBoundsPreviewMapWidget(QgsMapCanvas):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPreviewRect(self, rect: QgsRectangle) -> None: ...
    def canvasRect(self) -> QgsRectangle: ...
    def setCanvasRect(self, rect: QgsRectangle) -> None: ...


class QgsCoordinateOperationWidget(QtWidgets.QWidget):

    class OperationDetails(sip.wrapper):

        allowFallback: bool = ...
        destinationTransformId: int = ...
        isAvailable: bool = ...
        proj: str = ...
        sourceTransformId: int = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsCoordinateOperationWidget.OperationDetails) -> None: ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def operationDoubleClicked(self) -> None: ...
    def operationChanged(self) -> None: ...
    def setShowFallbackOption(self, visible: bool) -> None: ...
    def setSelectedOperationUsingContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def setSelectedOperation(self, operation: QgsCoordinateOperationWidget.OperationDetails) -> None: ...
    def selectedOperation(self) -> 'QgsCoordinateOperationWidget.OperationDetails': ...
    def defaultOperation(self) -> 'QgsCoordinateOperationWidget.OperationDetails': ...
    def availableOperations(self) -> List[QgsCoordinateOperationWidget.OperationDetails]: ...
    def hasSelection(self) -> bool: ...
    def makeDefaultSelected(self) -> bool: ...
    def setShowMakeDefault(self, show: bool) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setSourceCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...


class QgsCredentialDialog(QtWidgets.QDialog, QgsCredentials):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def requestMasterPassword(self, password: str, stored: bool = ...) -> Tuple[bool, str]: ...
    def request(self, realm: str, username: str, password: str, message: str = ...) -> Tuple[bool, str, str]: ...


class QgsCurveEditorWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., curve: QgsCurveTransform = ...) -> None: ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def changed(self) -> None: ...
    def setMaxHistogramValueRange(self, maxValueRange: float) -> None: ...
    def setMinHistogramValueRange(self, minValueRange: float) -> None: ...
    def maxHistogramValueRange(self) -> float: ...
    def minHistogramValueRange(self) -> float: ...
    def setHistogramSource(self, layer: QgsVectorLayer, expression: str) -> None: ...
    def setCurve(self, curve: QgsCurveTransform) -> None: ...
    def curve(self) -> QgsCurveTransform: ...


class QgsCustomDropHandler(QtCore.QObject):

    def __init__(self) -> None: ...

    def handleCustomUriCanvasDrop(self, uri: QgsMimeDataUtils.Uri, canvas: QgsMapCanvas) -> bool: ...
    def canHandleCustomUriCanvasDrop(self, uri: QgsMimeDataUtils.Uri, canvas: QgsMapCanvas) -> bool: ...
    def handleFileDrop(self, file: str) -> bool: ...
    def handleMimeDataV2(self, data: QtCore.QMimeData) -> bool: ...
    def handleMimeData(self, data: QtCore.QMimeData) -> None: ...
    def canHandleMimeData(self, data: QtCore.QMimeData) -> bool: ...
    def handleCustomUriDrop(self, uri: QgsMimeDataUtils.Uri) -> None: ...
    def customUriProviderKey(self) -> str: ...


class QgsCustomProjectOpenHandler(QtCore.QObject):

    def __init__(self) -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def createDocumentThumbnailAfterOpen(self) -> bool: ...
    def filters(self) -> List[str]: ...
    def handleProjectOpen(self, file: str) -> bool: ...


class QgsDatabaseSchemaComboBox(QtWidgets.QWidget):

    @overload
    def __init__(self, provider: str, connection: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, connection: QgsAbstractDatabaseProviderConnection, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def schemaChanged(self, schema: str) -> None: ...
    def refreshSchemas(self) -> None: ...
    def setConnectionName(self, connection: str, provider: str = ...) -> None: ...
    def setSchema(self, schema: str) -> None: ...
    def comboBox(self) -> QtWidgets.QComboBox: ...
    def currentSchema(self) -> str: ...
    def allowEmptySchema(self) -> bool: ...
    def setAllowEmptySchema(self, allowEmpty: bool) -> None: ...


class QgsDatabaseTableComboBox(QtWidgets.QWidget):

    @overload
    def __init__(self, provider: str, connection: str, schema: str = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, connection: QgsAbstractDatabaseProviderConnection, schema: str = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def tableChanged(self, table: str, schema: str = ...) -> None: ...
    def refreshTables(self) -> None: ...
    def setSchema(self, schema: str) -> None: ...
    def setConnectionName(self, connection: str, provider: str = ...) -> None: ...
    def setTable(self, table: str, schema: str = ...) -> None: ...
    def comboBox(self) -> QtWidgets.QComboBox: ...
    def currentSchema(self) -> str: ...
    def currentTable(self) -> str: ...
    def allowEmptyTable(self) -> bool: ...
    def setAllowEmptyTable(self, allowEmpty: bool) -> None: ...


class QgsDataItemGuiContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDataItemGuiContext) -> None: ...

    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...


class QgsDataItemGuiProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDataItemGuiProvider) -> None: ...

    @staticmethod
    def notify(title: str, message: str, context: QgsDataItemGuiContext, level: Qgis.MessageLevel = ..., duration: int = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    def createParamWidget(self, item: QgsDataItem, context: QgsDataItemGuiContext) -> QtWidgets.QWidget: ...
    def handleDrop(self, item: QgsDataItem, context: QgsDataItemGuiContext, data: QtCore.QMimeData, action: QtCore.Qt.DropAction) -> bool: ...
    def acceptDrop(self, item: QgsDataItem, context: QgsDataItemGuiContext) -> bool: ...
    def handleDoubleClick(self, item: QgsDataItem, context: QgsDataItemGuiContext) -> bool: ...
    def deleteLayer(self, item: QgsLayerItem, context: QgsDataItemGuiContext) -> bool: ...
    def rename(self, item: QgsDataItem, name: str, context: QgsDataItemGuiContext) -> bool: ...
    def populateContextMenu(self, item: QgsDataItem, menu: QtWidgets.QMenu, selectedItems: Iterable[QgsDataItem], context: QgsDataItemGuiContext) -> None: ...
    def name(self) -> str: ...


class QgsDataItemGuiProviderRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def initializeFromProviderGuiRegistry(self, providerGuiRegistry: QgsProviderGuiRegistry) -> None: ...
    def removeProvider(self, provider: QgsDataItemGuiProvider) -> None: ...
    def addProvider(self, provider: QgsDataItemGuiProvider) -> None: ...
    def providers(self) -> List[QgsDataItemGuiProvider]: ...


class QgsDataSourceSelectWidget(QgsPanelWidget):

    def __init__(self, browserModel: Optional[QgsBrowserGuiModel] = ..., setFilterByLayerType: bool = ..., layerType: QgsMapLayerType = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def itemTriggered(self, uri: QgsMimeDataUtils.Uri) -> None: ...
    def selectionChanged(self) -> None: ...
    def validationChanged(self, isValid: bool) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def setFilter(self) -> None: ...
    def setCaseSensitive(self, caseSensitive: bool) -> None: ...
    def setFilterSyntax(self, a0: QtWidgets.QAction) -> None: ...
    def showFilterWidget(self, visible: bool) -> None: ...
    def uri(self) -> QgsMimeDataUtils.Uri: ...
    def setDescription(self, description: str) -> None: ...
    def setLayerTypeFilter(self, layerType: QgsMapLayerType) -> None: ...


class QgsDataSourceSelectDialog(QtWidgets.QDialog):

    def __init__(self, browserModel: Optional[QgsBrowserGuiModel] = ..., setFilterByLayerType: bool = ..., layerType: QgsMapLayerType = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setFilter(self) -> None: ...
    def setCaseSensitive(self, caseSensitive: bool) -> None: ...
    def setFilterSyntax(self, a0: QtWidgets.QAction) -> None: ...
    def showFilterWidget(self, visible: bool) -> None: ...
    def uri(self) -> QgsMimeDataUtils.Uri: ...
    def setDescription(self, description: str) -> None: ...
    def setLayerTypeFilter(self, layerType: QgsMapLayerType) -> None: ...


class QgsNewDatabaseTableNameWidget(QgsPanelWidget):

    def __init__(self, browserModel: Optional[QgsBrowserGuiModel] = ..., providersFilter: Iterable[str] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def accepted(self) -> None: ...
    def uriChanged(self, uri: str) -> None: ...
    def providerKeyChanged(self, providerKey: str) -> None: ...
    def tableNameChanged(self, tableName: str) -> None: ...
    def schemaNameChanged(self, schemaName: str) -> None: ...
    def validationChanged(self, isValid: bool) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def validationError(self) -> str: ...
    def isValid(self) -> bool: ...
    def dataProviderKey(self) -> str: ...
    def table(self) -> str: ...
    def uri(self) -> str: ...
    def schema(self) -> str: ...
    def setAcceptButtonVisible(self, visible: bool) -> None: ...


class QgsNewDatabaseTableNameDialog(QtWidgets.QDialog):

    def __init__(self, browserModel: Optional[QgsBrowserGuiModel] = ..., providersFilter: Iterable[str] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def validationError(self) -> str: ...
    def isValid(self) -> bool: ...
    def dataProviderKey(self) -> str: ...
    def table(self) -> str: ...
    def uri(self) -> str: ...
    def schema(self) -> str: ...


class QgsDetailedItemData(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDetailedItemData) -> None: ...

    def isRenderedAsWidget(self) -> bool: ...
    def isEnabled(self) -> bool: ...
    def isChecked(self) -> bool: ...
    def isCheckable(self) -> bool: ...
    def icon(self) -> QtGui.QPixmap: ...
    def category(self) -> str: ...
    def detail(self) -> str: ...
    def title(self) -> str: ...
    def setRenderAsWidget(self, flag: bool) -> None: ...
    def setEnabled(self, flag: bool) -> None: ...
    def setChecked(self, flag: bool) -> None: ...
    def setCheckable(self, flag: bool) -> None: ...
    def setIcon(self, icon: QtGui.QPixmap) -> None: ...
    def setCategory(self, category: str) -> None: ...
    def setDetail(self, detail: str) -> None: ...
    def setTitle(self, title: str) -> None: ...


class QgsDetailedItemDelegate(QtWidgets.QAbstractItemDelegate):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def horizontalSpacing(self) -> int: ...
    def setHorizontalSpacing(self, value: int) -> None: ...
    def verticalSpacing(self) -> int: ...
    def setVerticalSpacing(self, value: int) -> None: ...
    def sizeHint(self, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...


class QgsDetailedItemWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setChecked(self, flag: bool) -> None: ...
    def setData(self, data: QgsDetailedItemData) -> None: ...


class QgsDial(QtWidgets.QDial):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def valueChanged(self, a0: typing.Any) -> None: ...
    def variantValue(self) -> typing.Any: ...
    def setValue(self, value: typing.Any) -> None: ...
    def setSingleStep(self, step: typing.Any) -> None: ...
    def setMaximum(self, max: typing.Any) -> None: ...
    def setMinimum(self, min: typing.Any) -> None: ...


class QgsDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., buttons: Union[QtWidgets.QDialogButtonBox.StandardButtons, QtWidgets.QDialogButtonBox.StandardButton] = ..., orientation: QtCore.Qt.Orientation = ...) -> None: ...

    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def layout(self) -> QtWidgets.QVBoxLayout: ...


class QgsDoubleValidator(QtGui.QRegularExpressionValidator):

    @overload
    def __init__(self, parent: QtCore.QObject) -> None: ...
    @overload
    def __init__(self, expression: QtCore.QRegularExpression, bottom: float, top: float, parent: QtCore.QObject) -> None: ...
    @overload
    def __init__(self, bottom: float, top: float, parent: QtCore.QObject) -> None: ...
    @overload
    def __init__(self, bottom: float, top: float, decimal: int, parent: QtCore.QObject) -> None: ...
    @overload
    def __init__(self, decimal: int, parent: QtCore.QObject) -> None: ...

    def top(self) -> float: ...
    def bottom(self) -> float: ...
    def setRange(self, bottom: float, top: float) -> None: ...
    def setTop(self, top: float) -> None: ...
    def setBottom(self, bottom: float) -> None: ...
    @staticmethod
    def toDouble(input: str) -> float: ...
    def validate(self, input: str) -> QtGui.QValidator.State: ...


class QgsEncodingFileDialog(QtWidgets.QFileDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., caption: str = ..., directory: str = ..., filter: str = ..., encoding: str = ...) -> None: ...

    def pbnCancelAll_clicked(self) -> None: ...
    def saveUsedEncoding(self) -> None: ...
    def cancelAll(self) -> bool: ...
    def addCancelAll(self) -> None: ...
    def encoding(self) -> str: ...


class QgsEncodingSelectionDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., caption: str = ..., encoding: str = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setEncoding(self, encoding: str) -> None: ...
    def encoding(self) -> str: ...


class QgsErrorDialog(QtWidgets.QDialog):

    def __init__(self, error: QgsError, title: str, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    @staticmethod
    def show(error: QgsError, title: str, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...


class QgsExpressionBuilderDialog(QtWidgets.QDialog):

    def __init__(self, layer: QgsVectorLayer, startText: str = ..., parent: Optional[QtWidgets.QWidget] = ..., key: str = ..., context: QgsExpressionContext = ...) -> None: ...

    def accept(self) -> None: ...
    def done(self, r: int) -> None: ...
    def allowEvalErrorsChanged(self) -> None: ...
    def setAllowEvalErrors(self, allowEvalErrors: bool) -> None: ...
    def allowEvalErrors(self) -> bool: ...
    def setGeomCalculator(self, da: QgsDistanceArea) -> None: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpectedOutputFormat(self, expected: str) -> None: ...
    def expectedOutputFormat(self) -> str: ...
    def expressionText(self) -> str: ...
    def setExpressionText(self, text: str) -> None: ...
    def expressionBuilder(self) -> QgsExpressionBuilderWidget: ...


class QgsExpressionStoreDialog(QtWidgets.QDialog):

    def __init__(self, label: str, expression: str, helpText: str, existingLabels: Iterable[str] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def helpText(self) -> str: ...
    def label(self) -> str: ...
    def expression(self) -> str: ...


class QgsExpressionBuilderWidget(QtWidgets.QWidget):

    class Flag(int): ...
    LoadNothing: QgsExpressionBuilderWidget.Flag = ...
    LoadRecent: QgsExpressionBuilderWidget.Flag = ...
    LoadUserExpressions: QgsExpressionBuilderWidget.Flag = ...
    LoadAll: QgsExpressionBuilderWidget.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsExpressionBuilderWidget.Flags', 'QgsExpressionBuilderWidget.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionBuilderWidget.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsExpressionBuilderWidget.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def parserErrorChanged(self) -> None: ...
    def evalErrorChanged(self) -> None: ...
    def expressionParsed(self, isValid: bool) -> None: ...
    def findExpressions(self, label: str) -> List[QgsExpressionItem]: ...
    def editSelectedUserExpression(self) -> None: ...
    def removeSelectedUserExpression(self) -> None: ...
    def storeCurrentUserExpression(self) -> None: ...
    def setAutoSave(self, enabled: bool) -> None: ...
    def autosave(self) -> None: ...
    def loadAllUsedValues(self) -> None: ...
    def loadSampleUsedValues(self) -> None: ...
    def loadAllValues(self) -> None: ...
    def loadSampleValues(self) -> None: ...
    def parserError(self) -> bool: ...
    def evalError(self) -> bool: ...
    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...
    def model(self) -> QtGui.QStandardItemModel: ...
    def updateFunctionFileList(self, path: str) -> None: ...
    def loadFunctionCode(self, code: str) -> None: ...
    def loadCodeFromFile(self, path: str) -> None: ...
    def saveFunctionFile(self, fileName: str) -> None: ...
    def newFunctionFile(self, fileName: str = ...) -> None: ...
    def removeFromUserExpressions(self, label: str) -> None: ...
    def saveToUserExpressions(self, label: str, expression: str, helpText: str) -> None: ...
    def loadUserExpressions(self) -> None: ...
    def expressionTree(self) -> QgsExpressionTreeView: ...
    def loadRecent(self, collection: str = ...) -> None: ...
    def saveToRecent(self, collection: str = ...) -> None: ...
    def isExpressionValid(self) -> bool: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpectedOutputFormat(self, expected: str) -> None: ...
    def expectedOutputFormat(self) -> str: ...
    def setExpressionText(self, expression: str) -> None: ...
    def expressionText(self) -> str: ...
    def setGeomCalculator(self, da: QgsDistanceArea) -> None: ...
    def loadFieldsAndValues(self, fieldValues: Dict[str, Iterable[str]]) -> None: ...
    @overload
    def loadFieldNames(self) -> None: ...
    @overload
    def loadFieldNames(self, fields: QgsFields) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def initWithFields(self, fields: QgsFields, context: QgsExpressionContext = ..., recentCollection: str = ..., flags: Union['QgsExpressionBuilderWidget.Flags', 'QgsExpressionBuilderWidget.Flag'] = ...) -> None: ...
    def initWithLayer(self, layer: QgsVectorLayer, context: QgsExpressionContext = ..., recentCollection: str = ..., flags: Union['QgsExpressionBuilderWidget.Flags', 'QgsExpressionBuilderWidget.Flag'] = ...) -> None: ...
    def init(self, context: QgsExpressionContext = ..., recentCollection: str = ..., flags: Union['QgsExpressionBuilderWidget.Flags', 'QgsExpressionBuilderWidget.Flag'] = ...) -> None: ...


class QgsExpressionHighlighter(QtGui.QSyntaxHighlighter):

    def __init__(self, parent: Optional[QtGui.QTextDocument] = ...) -> None: ...

    def highlightBlock(self, text: str) -> None: ...
    def addFields(self, fieldList: Iterable[str]) -> None: ...


class QgsExpressionLineEdit(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def setExpression(self, expression: str) -> None: ...
    def expressionChanged(self, expression: str) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def isValidExpression(self) -> Tuple[bool, str]: ...
    def expression(self) -> str: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def setGeomCalculator(self, distanceArea: QgsDistanceArea) -> None: ...
    def setExpectedOutputFormat(self, expected: str) -> None: ...
    def expectedOutputFormat(self) -> str: ...
    def setMultiLine(self, multiLine: bool) -> None: ...
    def expressionDialogTitle(self) -> str: ...
    def setExpressionDialogTitle(self, title: str) -> None: ...


class QgsExpressionPreviewWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setCurrentFeature(self, feature: QgsFeature) -> None: ...
    def toolTipChanged(self, toolTip: str) -> None: ...
    def parserErrorChanged(self) -> None: ...
    def evalErrorChanged(self) -> None: ...
    def expressionParsed(self, isValid: bool) -> None: ...
    def parserErrors(self) -> List[QgsExpression.ParserError]: ...
    def rootNode(self) -> QgsExpressionNode: ...
    def parserError(self) -> bool: ...
    def evalError(self) -> bool: ...
    def setGeomCalculator(self, da: QgsDistanceArea) -> None: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionText(self, expression: str) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...


class QgsExpressionSelectionDialog(QtWidgets.QDialog):

    def __init__(self, layer: QgsVectorLayer, startText: str = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def done(self, r: int) -> None: ...
    def closeEvent(self, closeEvent: QtGui.QCloseEvent) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def setMessageBar(self, messageBar: QgsMessageBar) -> None: ...
    def setGeomCalculator(self, da: QgsDistanceArea) -> None: ...
    def expressionText(self) -> str: ...
    def setExpressionText(self, text: str) -> None: ...
    def expressionBuilder(self) -> QgsExpressionBuilderWidget: ...


class QgsExpressionItem(QtGui.QStandardItem):

    class ItemType(int): ...
    Header: QgsExpressionItem.ItemType = ...
    Field: QgsExpressionItem.ItemType = ...
    ExpressionNode: QgsExpressionItem.ItemType = ...

    CUSTOM_SORT_ROLE: int = ...
    ITEM_NAME_ROLE: int = ...
    ITEM_TYPE_ROLE: int = ...
    SEARCH_TAGS_ROLE: int = ...

    @overload
    def __init__(self, label: str, expressionText: str, helpText: str, itemType: QgsExpressionItem.ItemType = ...) -> None: ...
    @overload
    def __init__(self, label: str, expressionText: str, itemType: QgsExpressionItem.ItemType = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionItem) -> None: ...

    def getItemType(self) -> 'QgsExpressionItem.ItemType': ...
    def setHelpText(self, helpText: str) -> None: ...
    def getHelpText(self) -> str: ...
    def getExpressionText(self) -> str: ...


class QgsExpressionItemSearchProxy(QtCore.QSortFilterProxyModel):

    def __init__(self) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...


class QgsExpressionTreeView(QtWidgets.QTreeView):

    class MenuProvider(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionTreeView.MenuProvider) -> None: ...

        def createContextMenu(self, item: QgsExpressionItem) -> QtWidgets.QMenu: ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setSearchText(self, text: str) -> None: ...
    def currentExpressionItemChanged(self, item: QgsExpressionItem) -> None: ...
    def expressionItemDoubleClicked(self, text: str) -> None: ...
    def loadExpressionsFromJson(self, expressionsDocument: QtCore.QJsonDocument) -> None: ...
    def exportUserExpressions(self) -> QtCore.QJsonDocument: ...
    def findExpressions(self, label: str) -> List[QgsExpressionItem]: ...
    def loadUserExpressions(self) -> None: ...
    def removeFromUserExpressions(self, label: str) -> None: ...
    def saveToUserExpressions(self, label: str, expression: str, helpText: str) -> None: ...
    def saveToRecent(self, expressionText: str, collection: str = ...) -> None: ...
    def loadRecent(self, collection: str = ...) -> None: ...
    def currentItem(self) -> QgsExpressionItem: ...
    def refresh(self) -> None: ...
    def setMenuProvider(self, provider: QgsExpressionTreeView.MenuProvider) -> None: ...
    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def loadFieldNames(self, fields: QgsFields) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...


class QgsExtentGroupBox(QgsCollapsibleGroupBox):

    class ExtentState(int): ...
    OriginalExtent: QgsExtentGroupBox.ExtentState = ...
    CurrentExtent: QgsExtentGroupBox.ExtentState = ...
    UserExtent: QgsExtentGroupBox.ExtentState = ...
    ProjectLayerExtent: QgsExtentGroupBox.ExtentState = ...
    DrawOnCanvas: QgsExtentGroupBox.ExtentState = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def extentChanged(self, r: QgsRectangle) -> None: ...
    def setRatio(self, ratio: QtCore.QSize) -> None: ...
    def setOutputExtentFromDrawOnCanvas(self) -> None: ...
    def setOutputExtentFromLayer(self, layer: QgsMapLayer) -> None: ...
    def setOutputExtentFromUser(self, extent: QgsRectangle, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setOutputExtentFromCurrent(self) -> None: ...
    def setOutputExtentFromOriginal(self) -> None: ...
    def ratio(self) -> QtCore.QSize: ...
    def setMapCanvas(self, canvas: QgsMapCanvas, drawOnCanvasOption: bool = ...) -> None: ...
    def titleBase(self) -> str: ...
    def setTitleBase(self, title: str) -> None: ...
    def extentState(self) -> 'QgsExtentGroupBox.ExtentState': ...
    def outputCrs(self) -> QgsCoordinateReferenceSystem: ...
    def outputExtent(self) -> QgsRectangle: ...
    def setOutputCrs(self, outputCrs: QgsCoordinateReferenceSystem) -> None: ...
    def currentCrs(self) -> QgsCoordinateReferenceSystem: ...
    def currentExtent(self) -> QgsRectangle: ...
    def setCurrentExtent(self, currentExtent: QgsRectangle, currentCrs: QgsCoordinateReferenceSystem) -> None: ...
    def originalCrs(self) -> QgsCoordinateReferenceSystem: ...
    def originalExtent(self) -> QgsRectangle: ...
    def setOriginalExtent(self, originalExtent: QgsRectangle, originalCrs: QgsCoordinateReferenceSystem) -> None: ...


class QgsExtentWidget(QtWidgets.QWidget):

    class WidgetStyle(int): ...
    CondensedStyle: QgsExtentWidget.WidgetStyle = ...
    ExpandedStyle: QgsExtentWidget.WidgetStyle = ...

    class ExtentState(int): ...
    OriginalExtent: QgsExtentWidget.ExtentState = ...
    CurrentExtent: QgsExtentWidget.ExtentState = ...
    UserExtent: QgsExtentWidget.ExtentState = ...
    ProjectLayerExtent: QgsExtentWidget.ExtentState = ...
    DrawOnCanvas: QgsExtentWidget.ExtentState = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., style: QgsExtentWidget.WidgetStyle = ...) -> None: ...

    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...
    def toggleDialogVisibility(self, visible: bool) -> None: ...
    def validationChanged(self, valid: bool) -> None: ...
    def extentChanged(self, r: QgsRectangle) -> None: ...
    def clear(self) -> None: ...
    def setRatio(self, ratio: QtCore.QSize) -> None: ...
    def setOutputExtentFromDrawOnCanvas(self) -> None: ...
    def setOutputExtentFromLayer(self, layer: QgsMapLayer) -> None: ...
    def setOutputExtentFromUser(self, extent: QgsRectangle, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setOutputExtentFromCurrent(self) -> None: ...
    def setOutputExtentFromOriginal(self) -> None: ...
    def setNullValueAllowed(self, allowed: bool, notSetText: str = ...) -> None: ...
    def isValid(self) -> bool: ...
    def extentLayerName(self) -> str: ...
    def ratio(self) -> QtCore.QSize: ...
    def setMapCanvas(self, canvas: QgsMapCanvas, drawOnCanvasOption: bool = ...) -> None: ...
    def extentState(self) -> 'QgsExtentWidget.ExtentState': ...
    def outputCrs(self) -> QgsCoordinateReferenceSystem: ...
    def outputExtent(self) -> QgsRectangle: ...
    def setOutputCrs(self, outputCrs: QgsCoordinateReferenceSystem) -> None: ...
    def currentCrs(self) -> QgsCoordinateReferenceSystem: ...
    def currentExtent(self) -> QgsRectangle: ...
    def setCurrentExtent(self, currentExtent: QgsRectangle, currentCrs: QgsCoordinateReferenceSystem) -> None: ...
    def originalCrs(self) -> QgsCoordinateReferenceSystem: ...
    def originalExtent(self) -> QgsRectangle: ...
    def setOriginalExtent(self, originalExtent: QgsRectangle, originalCrs: QgsCoordinateReferenceSystem) -> None: ...


class QgsExternalResourceWidget(QtWidgets.QWidget):

    class DocumentViewerContent(int): ...
    NoContent: QgsExternalResourceWidget.DocumentViewerContent = ...
    Image: QgsExternalResourceWidget.DocumentViewerContent = ...
    Web: QgsExternalResourceWidget.DocumentViewerContent = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def valueChanged(self, a0: str) -> None: ...
    def setDefaultRoot(self, defaultRoot: str) -> None: ...
    def defaultRoot(self) -> str: ...
    def setRelativeStorage(self, relativeStorage: QgsFileWidget.RelativeStorage) -> None: ...
    def relativeStorage(self) -> 'QgsFileWidget.RelativeStorage': ...
    def setReadOnly(self, readOnly: bool) -> None: ...
    def setDocumentViewerWidth(self, width: int) -> None: ...
    def documentViewerWidth(self) -> int: ...
    def setDocumentViewerHeight(self, height: int) -> None: ...
    def documentViewerHeight(self) -> int: ...
    def setDocumentViewerContent(self, content: QgsExternalResourceWidget.DocumentViewerContent) -> None: ...
    def documentViewerContent(self) -> 'QgsExternalResourceWidget.DocumentViewerContent': ...
    def setFileWidgetVisible(self, visible: bool) -> None: ...
    def fileWidgetVisible(self) -> bool: ...
    def fileWidget(self) -> QgsFileWidget: ...
    def setDocumentPath(self, documentPath: typing.Any) -> None: ...
    def documentPath(self, type: QtCore.QVariant.Type = ...) -> typing.Any: ...


class QgsFeaturePickerWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showBrowserButtonsChanged(self) -> None: ...
    def fetchLimitChanged(self) -> None: ...
    def fetchGeometryChanged(self) -> None: ...
    def allowNullChanged(self) -> None: ...
    def featureChanged(self, feature: QgsFeature) -> None: ...
    def filterExpressionChanged(self) -> None: ...
    def displayExpressionChanged(self) -> None: ...
    def layerChanged(self) -> None: ...
    def modelUpdated(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def currentModelIndex(self) -> QtCore.QModelIndex: ...
    def setShowBrowserButtons(self, showBrowserButtons: bool) -> None: ...
    def showBrowserButtons(self) -> bool: ...
    def setFetchLimit(self, fetchLimit: int) -> None: ...
    def fetchLimit(self) -> int: ...
    def setFetchGeometry(self, fetchGeometry: bool) -> None: ...
    def fetchGeometry(self) -> bool: ...
    def setAllowNull(self, allowNull: bool) -> None: ...
    def allowNull(self) -> bool: ...
    def setFilterExpression(self, filterExpression: str) -> None: ...
    def nullIndex(self) -> int: ...
    def filterExpression(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str) -> None: ...
    def displayExpression(self) -> str: ...
    def feature(self) -> QgsFeature: ...
    def setFeature(self, featureId: int) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def layer(self) -> QgsVectorLayer: ...


class QgsFeatureListComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def currentFeatureChanged(self) -> None: ...
    def allowNullChanged(self) -> None: ...
    def identifierFieldChanged(self) -> None: ...
    def identifierValueChanged(self) -> None: ...
    def filterExpressionChanged(self) -> None: ...
    def displayExpressionChanged(self) -> None: ...
    def sourceLayerChanged(self) -> None: ...
    def modelUpdated(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def currentModelIndex(self) -> QtCore.QModelIndex: ...
    def setIdentifierFields(self, identifierFields: Iterable[str]) -> None: ...
    def setIdentifierField(self, identifierField: str) -> None: ...
    def identifierFields(self) -> List[str]: ...
    def identifierField(self) -> str: ...
    def setAllowNull(self, allowNull: bool) -> None: ...
    def allowNull(self) -> bool: ...
    def currentFeatureRequest(self) -> QgsFeatureRequest: ...
    def setIdentifierValuesToNull(self) -> None: ...
    def setIdentifierValues(self, identifierValues: Iterable[typing.Any]) -> None: ...
    def setIdentifierValue(self, identifierValue: typing.Any) -> None: ...
    def identifierValues(self) -> List[typing.Any]: ...
    def identifierValue(self) -> typing.Any: ...
    def setFilterExpression(self, filterExpression: str) -> None: ...
    def nullIndex(self) -> int: ...
    def filterExpression(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str) -> None: ...
    def displayExpression(self) -> str: ...
    def setCurrentFeature(self, feature: QgsFeature) -> None: ...
    def setSourceLayer(self, sourceLayer: QgsVectorLayer) -> None: ...
    def sourceLayer(self) -> QgsVectorLayer: ...


class QgsFeatureSelectionDlg(QtWidgets.QDialog):

    def __init__(self, vl: QgsVectorLayer, context: QgsAttributeEditorContext, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def keyPressEvent(self, evt: QtGui.QKeyEvent) -> None: ...
    def setSelectedFeatures(self, ids: typing.Any) -> None: ...
    def selectedFeatures(self) -> typing.Any: ...


class QgsFieldComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def indexChanged(self, i: int) -> None: ...
    def setField(self, fieldName: str) -> None: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...
    def fieldChanged(self, fieldName: str) -> None: ...
    def fields(self) -> QgsFields: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def currentField(self) -> str: ...
    def allowEmptyFieldName(self) -> bool: ...
    def setAllowEmptyFieldName(self, allowEmpty: bool) -> None: ...
    def filters(self) -> QgsFieldProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsFieldProxyModel.Filters, QgsFieldProxyModel.Filter]) -> None: ...


class QgsFieldExpressionWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def isExpressionValid(self, expressionStr: str) -> bool: ...
    def updateLineEditStyle(self, expression: str = ...) -> None: ...
    def currentFieldChanged(self) -> None: ...
    def expressionEditingFinished(self) -> None: ...
    def expressionEdited(self, expression: str) -> None: ...
    def editExpression(self) -> None: ...
    def setExpression(self, expression: str) -> None: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def setField(self, fieldName: str) -> None: ...
    def setRow(self, row: int) -> None: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...
    def allowEvalErrorsChanged(self) -> None: ...
    @overload
    def fieldChanged(self, fieldName: str) -> None: ...
    @overload
    def fieldChanged(self, fieldName: str, isValid: bool) -> None: ...
    def setAllowEvalErrors(self, allowEvalErrors: bool) -> None: ...
    def allowEvalErrors(self) -> bool: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def expression(self) -> str: ...
    def asExpression(self) -> str: ...
    def currentText(self) -> str: ...
    def isExpression(self) -> bool: ...
    def isValidExpression(self, expressionError: Optional[str] = ...) -> bool: ...
    def currentField(self) -> Tuple[str, bool, bool]: ...
    def setGeomCalculator(self, da: QgsDistanceArea) -> None: ...
    def filters(self) -> QgsFieldProxyModel.Filters: ...
    def setLeftHandButtonStyle(self, isLeft: bool) -> None: ...
    def allowEmptyFieldName(self) -> bool: ...
    def setAllowEmptyFieldName(self, allowEmpty: bool) -> None: ...
    def setFilters(self, filters: Union[QgsFieldProxyModel.Filters, QgsFieldProxyModel.Filter]) -> None: ...
    def expressionDialogTitle(self) -> str: ...
    def appendScope(self, scope: QgsExpressionContextScope) -> None: ...
    def setExpressionDialogTitle(self, title: str) -> None: ...


class QgsFieldMappingWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., sourceFields: QgsFields = ..., destinationFields: QgsFields = ..., expressions: Dict[str, str] = ...) -> None: ...

    def moveSelectedFieldsDown(self) -> bool: ...
    def moveSelectedFieldsUp(self) -> bool: ...
    def removeSelectedFields(self) -> bool: ...
    def appendField(self, field: QgsField, expression: str = ...) -> None: ...
    def changed(self) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def scrollTo(self, index: QtCore.QModelIndex) -> None: ...
    def setDestinationFields(self, destinationFields: QgsFields, expressions: Dict[str, str] = ...) -> None: ...
    def sourceLayer(self) -> QgsVectorLayer: ...
    def setSourceLayer(self, layer: QgsVectorLayer) -> None: ...
    def setSourceFields(self, sourceFields: QgsFields) -> None: ...
    def selectionModel(self) -> QtCore.QItemSelectionModel: ...
    def setFieldPropertyMap(self, map: Dict[str, QgsProperty]) -> None: ...
    def fieldPropertyMap(self) -> Dict[str, QgsProperty]: ...
    def mapping(self) -> List[QgsFieldMappingModel.Field]: ...
    def model(self) -> QgsFieldMappingModel: ...
    def destinationEditable(self) -> bool: ...
    def setDestinationEditable(self, editable: bool) -> None: ...


class QgsFieldMappingModel(QtCore.QAbstractTableModel):

    class ColumnDataIndex(int): ...
    SourceExpression: QgsFieldMappingModel.ColumnDataIndex = ...
    DestinationName: QgsFieldMappingModel.ColumnDataIndex = ...
    DestinationType: QgsFieldMappingModel.ColumnDataIndex = ...
    DestinationLength: QgsFieldMappingModel.ColumnDataIndex = ...
    DestinationPrecision: QgsFieldMappingModel.ColumnDataIndex = ...
    DestinationConstraints: QgsFieldMappingModel.ColumnDataIndex = ...

    class Field(sip.wrapper):

        expression: str = ...
        field: QgsField = ...
        originalName: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsFieldMappingModel.Field) -> None: ...

    def __init__(self, sourceFields: QgsFields = ..., destinationFields: QgsFields = ..., expressions: Dict[str, str] = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def setDestinationFields(self, destinationFields: QgsFields, expressions: Dict[str, str] = ...) -> None: ...
    def setBaseExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def contextGenerator(self) -> QgsExpressionContextGenerator: ...
    def setSourceFields(self, sourceFields: QgsFields) -> None: ...
    def moveDown(self, index: QtCore.QModelIndex) -> bool: ...
    def moveUp(self, index: QtCore.QModelIndex) -> bool: ...
    def removeField(self, index: QtCore.QModelIndex) -> bool: ...
    def appendField(self, field: QgsField, expression: str = ...) -> None: ...
    def setFieldPropertyMap(self, map: Dict[str, QgsProperty]) -> None: ...
    def fieldPropertyMap(self) -> Dict[str, QgsProperty]: ...
    def mapping(self) -> List[QgsFieldMappingModel.Field]: ...
    def sourceFields(self) -> QgsFields: ...
    @staticmethod
    def dataTypes() -> Dict[QtCore.QVariant.Type, str]: ...
    def setDestinationEditable(self, editable: bool) -> None: ...
    def destinationEditable(self) -> bool: ...


class QgsFieldValidator(QtGui.QValidator):

    def __init__(self, parent: QtCore.QObject, field: QgsField, defaultValue: str, dateFormat: str = ...) -> None: ...

    def dateFormat(self) -> str: ...
    def fixup(self, s: typing.Any) -> None: ...
    def validate(self, s: typing.Any, i: int) -> Tuple[QtGui.QValidator.State, str, int]: ...


class QgsFilterLineEdit(QtWidgets.QLineEdit):

    class ClearMode(int): ...
    ClearToNull: QgsFilterLineEdit.ClearMode = ...
    ClearToDefault: QgsFilterLineEdit.ClearMode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., nullValue: str = ...) -> None: ...

    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def focusInEvent(self, e: QtGui.QFocusEvent) -> None: ...
    def selectOnFocusChanged(self) -> None: ...
    def showSpinnerChanged(self) -> None: ...
    def valueChanged(self, value: str) -> None: ...
    def cleared(self) -> None: ...
    def restoreState(self) -> None: ...
    def storeState(self) -> None: ...
    def clearValue(self) -> None: ...
    def hasStateStored(self) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def setSelectOnFocus(self, selectOnFocus: bool) -> None: ...
    def selectOnFocus(self) -> bool: ...
    def setShowSpinner(self, showSpinner: bool) -> None: ...
    def showSpinner(self) -> bool: ...
    def isNull(self) -> bool: ...
    def value(self) -> str: ...
    def setValue(self, value: str) -> None: ...
    def defaultValue(self) -> str: ...
    def setDefaultValue(self, defaultValue: str) -> None: ...
    def showSearchIcon(self) -> bool: ...
    def setShowSearchIcon(self, visible: bool) -> None: ...
    def nullValue(self) -> str: ...
    def setNullValue(self, nullValue: str) -> None: ...
    def setClearMode(self, mode: QgsFilterLineEdit.ClearMode) -> None: ...
    def clearMode(self) -> 'QgsFilterLineEdit.ClearMode': ...
    def setShowClearButton(self, visible: bool) -> None: ...
    def showClearButton(self) -> bool: ...


class QgsFieldValuesLineEdit(QgsFilterLineEdit):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def attributeIndexChanged(self, index: int) -> None: ...
    def layerChanged(self, layer: QgsVectorLayer) -> None: ...
    def attributeIndex(self) -> int: ...
    def setAttributeIndex(self, index: int) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...


class QgsAbstractFileContentSourceLineEdit(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def sourceChanged(self, source: str) -> None: ...
    def setSource(self, source: str) -> None: ...
    def setPropertyOverrideToolButtonVisible(self, visible: bool) -> None: ...
    def propertyOverrideToolButton(self) -> QgsPropertyOverrideButton: ...
    def setLastPathSettingsKey(self, key: str) -> None: ...
    def source(self) -> str: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...


class QgsPictureSourceLineEditBase(QgsAbstractFileContentSourceLineEdit):

    class Format(int): ...
    Svg: QgsPictureSourceLineEditBase.Format = ...
    Image: QgsPictureSourceLineEditBase.Format = ...

    @overload
    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, format: QgsPictureSourceLineEditBase.Format, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setMode(self, format: QgsPictureSourceLineEditBase.Format) -> None: ...


class QgsSvgSourceLineEdit(QgsPictureSourceLineEditBase):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsImageSourceLineEdit(QgsPictureSourceLineEditBase):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsFileDownloaderDialog(QtWidgets.QProgressDialog):

    def __init__(self, url: QtCore.QUrl, outputFileName: str, authcfg: str = ...) -> None: ...

    def downloadProgress(self, bytesReceived: int, bytesTotal: int) -> None: ...
    def downloadError(self, errorMessages: Iterable[str]) -> None: ...
    def downloadCanceled(self) -> None: ...
    def downloadExited(self) -> None: ...
    def downloadCompleted(self) -> None: ...


class QgsFileWidget(QtWidgets.QWidget):

    class RelativeStorage(int): ...
    Absolute: QgsFileWidget.RelativeStorage = ...
    RelativeProject: QgsFileWidget.RelativeStorage = ...
    RelativeDefaultPath: QgsFileWidget.RelativeStorage = ...

    class StorageMode(int): ...
    GetFile: QgsFileWidget.StorageMode = ...
    GetDirectory: QgsFileWidget.StorageMode = ...
    GetMultipleFiles: QgsFileWidget.StorageMode = ...
    SaveFile: QgsFileWidget.StorageMode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def fileChanged(self, path: str) -> None: ...
    def lineEdit(self) -> QgsFilterLineEdit: ...
    def setRelativeStorage(self, relativeStorage: QgsFileWidget.RelativeStorage) -> None: ...
    def relativeStorage(self) -> 'QgsFileWidget.RelativeStorage': ...
    def setStorageMode(self, storageMode: QgsFileWidget.StorageMode) -> None: ...
    def storageMode(self) -> 'QgsFileWidget.StorageMode': ...
    def setDefaultRoot(self, defaultRoot: str) -> None: ...
    def defaultRoot(self) -> str: ...
    def setFullUrl(self, fullUrl: bool) -> None: ...
    def fullUrl(self) -> bool: ...
    def setUseLink(self, useLink: bool) -> None: ...
    def useLink(self) -> bool: ...
    def setFileWidgetButtonVisible(self, visible: bool) -> None: ...
    def fileWidgetButtonVisible(self) -> bool: ...
    def confirmOverwrite(self) -> bool: ...
    def setConfirmOverwrite(self, confirmOverwrite: bool) -> None: ...
    def selectedFilter(self) -> str: ...
    def setSelectedFilter(self, selectedFilter: str) -> None: ...
    def setOptions(self, options: Union[QtWidgets.QFileDialog.Options, QtWidgets.QFileDialog.Option]) -> None: ...
    def options(self) -> QtWidgets.QFileDialog.Options: ...
    def setFilter(self, filter: str) -> None: ...
    def filter(self) -> str: ...
    def setDialogTitle(self, title: str) -> None: ...
    def dialogTitle(self) -> str: ...
    def setReadOnly(self, readOnly: bool) -> None: ...
    def setFilePath(self, path: str) -> None: ...
    @staticmethod
    def splitFilePaths(path: str) -> List[str]: ...
    def filePath(self) -> str: ...


class QgsFindFilesByPatternWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def findComplete(self, files: Iterable[str]) -> None: ...
    def files(self) -> List[str]: ...


class QgsFindFilesByPatternDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def files(self) -> List[str]: ...


class QgsFloatingWidget(QtWidgets.QWidget):

    class AnchorPoint(int): ...
    TopLeft: QgsFloatingWidget.AnchorPoint = ...
    TopMiddle: QgsFloatingWidget.AnchorPoint = ...
    TopRight: QgsFloatingWidget.AnchorPoint = ...
    MiddleLeft: QgsFloatingWidget.AnchorPoint = ...
    Middle: QgsFloatingWidget.AnchorPoint = ...
    MiddleRight: QgsFloatingWidget.AnchorPoint = ...
    BottomLeft: QgsFloatingWidget.AnchorPoint = ...
    BottomMiddle: QgsFloatingWidget.AnchorPoint = ...
    BottomRight: QgsFloatingWidget.AnchorPoint = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def anchorWidgetPointChanged(self, point: QgsFloatingWidget.AnchorPoint) -> None: ...
    def anchorPointChanged(self, point: QgsFloatingWidget.AnchorPoint) -> None: ...
    def anchorWidgetChanged(self, widget: QtWidgets.QWidget) -> None: ...
    def setAnchorWidgetPoint(self, point: QgsFloatingWidget.AnchorPoint) -> None: ...
    def anchorWidgetPoint(self) -> 'QgsFloatingWidget.AnchorPoint': ...
    def setAnchorPoint(self, point: QgsFloatingWidget.AnchorPoint) -> None: ...
    def anchorPoint(self) -> 'QgsFloatingWidget.AnchorPoint': ...
    def anchorWidget(self) -> QtWidgets.QWidget: ...
    def setAnchorWidget(self, widget: QtWidgets.QWidget) -> None: ...


class QgsFocusWatcher(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def focusOut(self) -> None: ...
    def focusIn(self) -> None: ...
    def focusChanged(self, focused: bool) -> None: ...
    def eventFilter(self, obj: QtCore.QObject, event: QtCore.QEvent) -> bool: ...


class QgsFontButton(QtWidgets.QToolButton):

    class Mode(int): ...
    ModeTextRenderer: QgsFontButton.Mode = ...
    ModeQFont: QgsFontButton.Mode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., dialogTitle: str = ...) -> None: ...

    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def event(self, e: QtCore.QEvent) -> bool: ...
    def changed(self) -> None: ...
    def pasteColor(self) -> None: ...
    def copyColor(self) -> None: ...
    def pasteFormat(self) -> None: ...
    def copyFormat(self) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setCurrentFont(self, font: QtGui.QFont) -> None: ...
    def setToNullFormat(self) -> None: ...
    def setTextFormat(self, format: QgsTextFormat) -> None: ...
    def showNullFormat(self) -> bool: ...
    def setNoFormatString(self, string: str) -> None: ...
    def setShowNullFormat(self, show: bool) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def currentFont(self) -> QtGui.QFont: ...
    def textFormat(self) -> QgsTextFormat: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def dialogTitle(self) -> str: ...
    def setDialogTitle(self, title: str) -> None: ...
    def setMode(self, mode: QgsFontButton.Mode) -> None: ...
    def mode(self) -> 'QgsFontButton.Mode': ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsFormAnnotation(QgsAnnotation):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> QgsFormAnnotation: ...
    def setAssociatedFeature(self, feature: QgsFeature) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def designerForm(self) -> str: ...
    def setDesignerForm(self, uiFile: str) -> None: ...
    def preferredFrameSize(self) -> QtCore.QSizeF: ...
    def minimumFrameSize(self) -> QtCore.QSizeF: ...
    def clone(self) -> QgsFormAnnotation: ...


class QgsGeocoderLocatorFilter(QgsAbstractGeocoderLocatorFilter):

    def __init__(self, name: str, displayName: str, prefix: str, geocoder: QgsGeocoderInterface, canvas: QgsMapCanvas, boundingBox: QgsRectangle = ...) -> None: ...

    def clone(self) -> QgsLocatorFilter: ...


class QgsMapCanvasItem(QtWidgets.QGraphicsItem):

    def __init__(self, mapCanvas: QgsMapCanvas) -> None: ...

    def toCanvasCoordinates(self, point: QgsPointXY) -> QtCore.QPointF: ...
    def toMapCoordinates(self, point: QtCore.QPoint) -> QgsPointXY: ...
    def setRect(self, r: QgsRectangle, resetRotation: bool = ...) -> None: ...
    def rect(self) -> QgsRectangle: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def updatePosition(self) -> None: ...
    def setRenderContextVariables(self, p: QtGui.QPainter, context: QgsRenderContext) -> bool: ...
    def updateCanvas(self) -> None: ...
    @overload
    def paint(self, painter: QtGui.QPainter) -> None: ...
    @overload
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionGraphicsItem, widget: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsGeometryRubberBand(QgsMapCanvasItem):

    class IconType(int): ...
    ICON_NONE: QgsGeometryRubberBand.IconType = ...
    ICON_CROSS: QgsGeometryRubberBand.IconType = ...
    ICON_X: QgsGeometryRubberBand.IconType = ...
    ICON_BOX: QgsGeometryRubberBand.IconType = ...
    ICON_CIRCLE: QgsGeometryRubberBand.IconType = ...
    ICON_FULL_BOX: QgsGeometryRubberBand.IconType = ...

    def __init__(self, mapCanvas: QgsMapCanvas, geomType: QgsWkbTypes.GeometryType = ...) -> None: ...

    def setGeometryType(self, geometryType: QgsWkbTypes.GeometryType) -> None: ...
    def geometryType(self) -> QgsWkbTypes.GeometryType: ...
    def paint(self, painter: QtGui.QPainter) -> None: ...
    def setVertexDrawingEnabled(self, isVerticesDrawn: bool) -> None: ...
    def setIconType(self, iconType: QgsGeometryRubberBand.IconType) -> None: ...
    def setBrushStyle(self, brushStyle: QtCore.Qt.BrushStyle) -> None: ...
    def setLineStyle(self, penStyle: QtCore.Qt.PenStyle) -> None: ...
    def setStrokeWidth(self, width: int) -> None: ...
    def setStrokeColor(self, c: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setFillColor(self, c: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def moveVertex(self, id: QgsVertexId, newPos: QgsPoint) -> None: ...
    def geometry(self) -> QgsAbstractGeometry: ...
    def setGeometry(self, geom: QgsAbstractGeometry) -> None: ...


class QgsGradientColorRampDialog(QtWidgets.QDialog):

    def __init__(self, ramp: QgsGradientColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor1(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def changed(self) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def setRamp(self, ramp: QgsGradientColorRamp) -> None: ...
    def ramp(self) -> QgsGradientColorRamp: ...


class QgsGradientStopEditor(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., ramp: Optional[QgsGradientColorRamp] = ...) -> None: ...

    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def selectedStopChanged(self, stop: QgsGradientStop) -> None: ...
    def changed(self) -> None: ...
    def setColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor1(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def deleteSelectedStop(self) -> None: ...
    def setSelectedStopDetails(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], offset: float) -> None: ...
    def setSelectedStopOffset(self, offset: float) -> None: ...
    def setSelectedStopColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def selectedStop(self) -> QgsGradientStop: ...
    def selectStop(self, index: int) -> None: ...
    def gradientRamp(self) -> QgsGradientColorRamp: ...
    def setGradientRamp(self, ramp: QgsGradientColorRamp) -> None: ...


class QgsGroupWmsDataDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setGroupAbstract(self, abstract: str) -> None: ...
    def setGroupShortName(self, shortName: str) -> None: ...
    def setGroupTitle(self, title: str) -> None: ...
    def groupAbstract(self) -> str: ...
    def groupShortName(self) -> str: ...
    def groupTitle(self) -> str: ...


class QgsGui(QtCore.QObject):

    class HigFlag(int): ...
    HigMenuTextIsTitleCase: QgsGui.HigFlag = ...
    HigDialogTitleIsTitleCase: QgsGui.HigFlag = ...

    class ProjectCrsBehavior(int): ...
    UseCrsOfFirstLayerAdded: QgsGui.ProjectCrsBehavior = ...
    UsePresetCrs: QgsGui.ProjectCrsBehavior = ...

    class HigFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsGui.HigFlags', 'QgsGui.HigFlag']) -> None: ...
        @overload
        def __init__(self, a0: QgsGui.HigFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsGui.HigFlags': ...
        def __int__(self) -> int: ...

    def optionsChanged(self) -> None: ...
    @staticmethod
    def findScreenAt(point: QtCore.QPoint) -> QtGui.QScreen: ...
    @staticmethod
    def sampleColor(point: QtCore.QPoint) -> QtGui.QColor: ...
    @staticmethod
    def higFlags() -> 'QgsGui.HigFlags': ...
    @staticmethod
    def setWindowManager(manager: QgsWindowManagerInterface) -> None: ...
    @staticmethod
    def windowManager() -> QgsWindowManagerInterface: ...
    @staticmethod
    def enableAutoGeometryRestore(widget: QtWidgets.QWidget, key: str = ...) -> None: ...
    @staticmethod
    def relationWidgetRegistry() -> QgsRelationWidgetRegistry: ...
    @staticmethod
    def sourceWidgetProviderRegistry() -> QgsProviderSourceWidgetProviderRegistry: ...
    @staticmethod
    def subsetStringEditorProviderRegistry() -> QgsSubsetStringEditorProviderRegistry: ...
    @staticmethod
    def providerGuiRegistry() -> QgsProviderGuiRegistry: ...
    @staticmethod
    def projectStorageGuiRegistry() -> QgsProjectStorageGuiRegistry: ...
    @staticmethod
    def dataItemGuiProviderRegistry() -> QgsDataItemGuiProviderRegistry: ...
    @staticmethod
    def processingRecentAlgorithmLog() -> QgsProcessingRecentAlgorithmLog: ...
    @staticmethod
    def codeEditorColorSchemeRegistry() -> QgsCodeEditorColorSchemeRegistry: ...
    @staticmethod
    def numericFormatGuiRegistry() -> QgsNumericFormatGuiRegistry: ...
    @staticmethod
    def processingGuiRegistry() -> QgsProcessingGuiRegistry: ...
    @staticmethod
    def layoutItemGuiRegistry() -> QgsLayoutItemGuiRegistry: ...
    @staticmethod
    def mapLayerActionRegistry() -> QgsMapLayerActionRegistry: ...
    @staticmethod
    def layerTreeEmbeddedWidgetRegistry() -> QgsLayerTreeEmbeddedWidgetRegistry: ...
    @staticmethod
    def shortcutsManager() -> QgsShortcutsManager: ...
    @staticmethod
    def sourceSelectProviderRegistry() -> QgsSourceSelectProviderRegistry: ...
    @staticmethod
    def editorWidgetRegistry() -> QgsEditorWidgetRegistry: ...
    @staticmethod
    def instance() -> QgsGui: ...


class QgsHelp(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsHelp) -> None: ...

    @staticmethod
    def helpUrl(key: str) -> QtCore.QUrl: ...
    @staticmethod
    def openHelp(key: str) -> None: ...


class QgsHighlight(QgsMapCanvasItem):

    @overload
    def __init__(self, mapCanvas: QgsMapCanvas, geom: QgsGeometry, layer: QgsMapLayer) -> None: ...
    @overload
    def __init__(self, mapCanvas: QgsMapCanvas, feature: QgsFeature, layer: QgsVectorLayer) -> None: ...

    def updateRect(self) -> None: ...
    def paint(self, p: QtGui.QPainter) -> None: ...
    def updatePosition(self) -> None: ...
    def layer(self) -> QgsMapLayer: ...
    def setMinWidth(self, width: float) -> None: ...
    def setBuffer(self, buffer: float) -> None: ...
    def buffer(self) -> float: ...
    def setWidth(self, width: int) -> None: ...
    def width(self) -> int: ...
    def setFillColor(self, fillColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fillColor(self) -> QtGui.QColor: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color(self) -> QtGui.QColor: ...


class QgsHighlightableLineEdit(QgsFilterLineEdit):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def setHighlighted(self, highlighted: bool) -> None: ...
    def isHighlighted(self) -> bool: ...


class QgsHistogramWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsVectorLayer] = ..., fieldOrExp: str = ...) -> None: ...

    def drawHistogram(self) -> None: ...
    def setSourceFieldExp(self, fieldOrExp: str) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def refresh(self) -> None: ...
    def refreshValues(self) -> None: ...
    def setYAxisTitle(self, title: str) -> None: ...
    def yAxisTitle(self) -> str: ...
    def setXAxisTitle(self, title: str) -> None: ...
    def xAxisTitle(self) -> str: ...
    def graduatedRanges(self) -> List[QgsRendererRange]: ...
    def setGraduatedRanges(self, ranges: Iterable[QgsRendererRange]) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def setBrush(self, brush: Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def sourceFieldExp(self) -> str: ...
    def layer(self) -> QgsVectorLayer: ...


class QgsIdentifyMenu(QtWidgets.QMenu):

    class MenuLevel(int): ...
    LayerLevel: QgsIdentifyMenu.MenuLevel = ...
    FeatureLevel: QgsIdentifyMenu.MenuLevel = ...

    class ActionData(sip.wrapper):

        mAllResults: bool = ...
        mFeatureId: int = ...
        mIsExternalAction: bool = ...
        mIsValid: bool = ...
        mLayer: QgsMapLayer = ...
        mLevel: QgsIdentifyMenu.MenuLevel = ...
        mMapLayerAction: QgsMapLayerAction = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, layer: QgsMapLayer, mapLayerAction: Optional[QgsMapLayerAction] = ...) -> None: ...
        @overload
        def __init__(self, layer: QgsMapLayer, fid: int, mapLayerAction: Optional[QgsMapLayerAction] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsIdentifyMenu.ActionData) -> None: ...

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def closeEvent(self, e: QtGui.QCloseEvent) -> None: ...
    @staticmethod
    def styleHighlight(highlight: QgsHighlight) -> None: ...
    def exec(self, idResults: Iterable[QgsMapToolIdentify.IdentifyResult], pos: QtCore.QPoint) -> List[QgsMapToolIdentify.IdentifyResult]: ...
    def removeCustomActions(self) -> None: ...
    def addCustomAction(self, action: QgsMapLayerAction) -> None: ...
    def maxFeatureDisplay(self) -> int: ...
    def setMaxFeatureDisplay(self, maxFeatureDisplay: int) -> None: ...
    def maxLayerDisplay(self) -> int: ...
    def setMaxLayerDisplay(self, maxLayerDisplay: int) -> None: ...
    def resultsIfExternalAction(self) -> bool: ...
    def setResultsIfExternalAction(self, resultsIfExternalAction: bool) -> None: ...
    def showFeatureActions(self) -> bool: ...
    def setShowFeatureActions(self, showFeatureActions: bool) -> None: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...
    def setExpressionContextScope(self, scope: QgsExpressionContextScope) -> None: ...
    def execWithSingleResult(self) -> bool: ...
    def setExecWithSingleResult(self, execWithSingleResult: bool) -> None: ...
    def allowMultipleReturn(self) -> bool: ...
    def setAllowMultipleReturn(self, multipleReturn: bool) -> None: ...


class QgsTableWidgetBase(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...

    def valueChanged(self) -> None: ...
    def init(self, model: QtCore.QAbstractTableModel) -> None: ...


class QgsKeyValueWidget(QgsTableWidgetBase):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def map(self) -> Dict[str, typing.Any]: ...
    def setMap(self, map: Dict[str, typing.Any]) -> None: ...


class QgsLegendFilterButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def expressionTextChanged(self) -> None: ...
    def setVectorLayer(self, layer: QgsVectorLayer) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def setExpressionText(self, expression: str) -> None: ...
    def expressionText(self) -> str: ...


class QgsLegendPatchShapeButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., dialogTitle: str = ...) -> None: ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def changed(self) -> None: ...
    def setToDefault(self) -> None: ...
    def setShape(self, shape: QgsLegendPatchShape) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def shape(self) -> QgsLegendPatchShape: ...
    def dialogTitle(self) -> str: ...
    def setDialogTitle(self, title: str) -> None: ...
    def setPreviewSymbol(self, symbol: QgsSymbol) -> None: ...
    def symbolType(self) -> Qgis.SymbolType: ...
    def setSymbolType(self, type: Qgis.SymbolType) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsLegendPatchShapeWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., shape: QgsLegendPatchShape = ...) -> None: ...

    def changed(self) -> None: ...
    def setShape(self, shape: QgsLegendPatchShape) -> None: ...
    def shape(self) -> QgsLegendPatchShape: ...


class QgsLegendPatchShapeDialog(QtWidgets.QDialog):

    def __init__(self, shape: QgsLegendPatchShape, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def shape(self) -> QgsLegendPatchShape: ...


class QgsLimitedRandomColorRampWidget(QgsPanelWidget):

    def __init__(self, ramp: QgsLimitedRandomColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setVal2(self, val: int) -> None: ...
    def setVal1(self, val: int) -> None: ...
    def setSat2(self, val: int) -> None: ...
    def setSat1(self, val: int) -> None: ...
    def setHue2(self, val: int) -> None: ...
    def setHue1(self, val: int) -> None: ...
    def setCount(self, val: int) -> None: ...
    def changed(self) -> None: ...
    def setRamp(self, ramp: QgsLimitedRandomColorRamp) -> None: ...
    def ramp(self) -> QgsLimitedRandomColorRamp: ...


class QgsLimitedRandomColorRampDialog(QtWidgets.QDialog):

    def __init__(self, ramp: QgsLimitedRandomColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def setRamp(self, ramp: QgsLimitedRandomColorRamp) -> None: ...
    def ramp(self) -> QgsLimitedRandomColorRamp: ...


class QgsListWidget(QgsTableWidgetBase):

    def __init__(self, subType: QtCore.QVariant.Type, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def valid(self) -> bool: ...
    def list(self) -> List[typing.Any]: ...
    def setList(self, list: Iterable[typing.Any]) -> None: ...


class QgsLongLongValidator(QtGui.QValidator):

    @overload
    def __init__(self, parent: QtCore.QObject) -> None: ...
    @overload
    def __init__(self, bottom: int, top: int, parent: QtCore.QObject) -> None: ...

    def top(self) -> int: ...
    def bottom(self) -> int: ...
    def setRange(self, bottom: int, top: int) -> None: ...
    def setTop(self, top: int) -> None: ...
    def setBottom(self, bottom: int) -> None: ...
    def validate(self, input: str) -> Tuple[QtGui.QValidator.State, int]: ...


class QgsLUDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setUpperValue(self, val: str) -> None: ...
    def upperValue(self) -> str: ...
    def setLowerValue(self, val: str) -> None: ...
    def lowerValue(self) -> str: ...


class QgsManageConnectionsDialog(QtWidgets.QDialog):

    class Type(int): ...
    WMS: QgsManageConnectionsDialog.Type = ...
    PostGIS: QgsManageConnectionsDialog.Type = ...
    WFS: QgsManageConnectionsDialog.Type = ...
    MSSQL: QgsManageConnectionsDialog.Type = ...
    DB2: QgsManageConnectionsDialog.Type = ...
    WCS: QgsManageConnectionsDialog.Type = ...
    Oracle: QgsManageConnectionsDialog.Type = ...
    HANA: QgsManageConnectionsDialog.Type = ...
    GeoNode: QgsManageConnectionsDialog.Type = ...
    XyzTiles: QgsManageConnectionsDialog.Type = ...
    ArcgisMapServer: QgsManageConnectionsDialog.Type = ...
    ArcgisFeatureServer: QgsManageConnectionsDialog.Type = ...
    VectorTile: QgsManageConnectionsDialog.Type = ...

    class Mode(int): ...
    Export: QgsManageConnectionsDialog.Mode = ...
    Import: QgsManageConnectionsDialog.Mode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., mode: QgsManageConnectionsDialog.Mode = ..., type: QgsManageConnectionsDialog.Type = ..., fileName: str = ...) -> None: ...

    def selectionChanged(self) -> None: ...
    def clearSelection(self) -> None: ...
    def selectAll(self) -> None: ...
    def doExportImport(self) -> None: ...


class QgsMapCanvasAnnotationItem(QtCore.QObject, QgsMapCanvasItem):

    class MouseMoveAction(int): ...
    NoAction: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    MoveMapPosition: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    MoveFramePosition: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameUp: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameDown: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameLeft: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameRight: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameLeftUp: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameRightUp: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameLeftDown: QgsMapCanvasAnnotationItem.MouseMoveAction = ...
    ResizeFrameRightDown: QgsMapCanvasAnnotationItem.MouseMoveAction = ...

    def __init__(self, annotation: QgsAnnotation, mapCanvas: QgsMapCanvas) -> None: ...

    def cursorShapeForAction(self, moveAction: QgsMapCanvasAnnotationItem.MouseMoveAction) -> QtCore.Qt.CursorShape: ...
    def moveActionForPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint]) -> 'QgsMapCanvasAnnotationItem.MouseMoveAction': ...
    def paint(self, painter: QtGui.QPainter) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def updatePosition(self) -> None: ...
    def annotation(self) -> QgsAnnotation: ...


class QgsMapCanvasInteractionBlocker(sip.wrapper):

    class Interaction(int): ...
    MapPanOnSingleClick: QgsMapCanvasInteractionBlocker.Interaction = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapCanvasInteractionBlocker) -> None: ...

    def blockCanvasInteraction(self, interaction: QgsMapCanvasInteractionBlocker.Interaction) -> bool: ...


class QgsMapCanvasSnappingUtils(QgsSnappingUtils):

    def __init__(self, canvas: QgsMapCanvas, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def prepareIndexProgress(self, index: int) -> None: ...
    def prepareIndexStarting(self, count: int) -> None: ...


class QgsMapCanvasTracer(QgsTracer):

    def __init__(self, canvas: QgsMapCanvas, messageBar: Optional[QgsMessageBar] = ...) -> None: ...

    def configure(self) -> None: ...
    def reportError(self, err: QgsTracer.PathError, addingVertex: bool) -> None: ...
    @staticmethod
    def tracerForCanvas(canvas: QgsMapCanvas) -> QgsMapCanvasTracer: ...
    def setActionEnableSnapping(self, action: QtWidgets.QAction) -> None: ...
    def actionEnableSnapping(self) -> QtWidgets.QAction: ...
    def setActionEnableTracing(self, action: QtWidgets.QAction) -> None: ...
    def actionEnableTracing(self) -> QtWidgets.QAction: ...


class QgsMapCanvasUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapCanvasUtils) -> None: ...

    @staticmethod
    def flashMatchingFeatures(canvas: QgsMapCanvas, layer: QgsVectorLayer, filter: str) -> int: ...
    @staticmethod
    def zoomToMatchingFeatures(canvas: QgsMapCanvas, layer: QgsVectorLayer, filter: str) -> int: ...


class QgsMapLayerAction(QtWidgets.QAction):

    class Flag(int): ...
    EnabledOnlyWhenEditable: QgsMapLayerAction.Flag = ...

    class Target(int): ...
    Layer: QgsMapLayerAction.Target = ...
    SingleFeature: QgsMapLayerAction.Target = ...
    MultipleFeatures: QgsMapLayerAction.Target = ...
    AllActions: QgsMapLayerAction.Target = ...

    class Targets(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsMapLayerAction.Targets', 'QgsMapLayerAction.Target']) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayerAction.Targets) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsMapLayerAction.Targets': ...
        def __int__(self) -> int: ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsMapLayerAction.Flags', 'QgsMapLayerAction.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayerAction.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsMapLayerAction.Flags': ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, name: str, parent: QtCore.QObject, targets: Union['QgsMapLayerAction.Targets', 'QgsMapLayerAction.Target'] = ..., icon: QtGui.QIcon = ..., flags: Union['QgsMapLayerAction.Flags', 'QgsMapLayerAction.Flag'] = ...) -> None: ...
    @overload
    def __init__(self, name: str, parent: QtCore.QObject, layer: QgsMapLayer, targets: Union['QgsMapLayerAction.Targets', 'QgsMapLayerAction.Target'] = ..., icon: QtGui.QIcon = ..., flags: Union['QgsMapLayerAction.Flags', 'QgsMapLayerAction.Flag'] = ...) -> None: ...
    @overload
    def __init__(self, name: str, parent: QtCore.QObject, layerType: QgsMapLayerType, targets: Union['QgsMapLayerAction.Targets', 'QgsMapLayerAction.Target'] = ..., icon: QtGui.QIcon = ..., flags: Union['QgsMapLayerAction.Flags', 'QgsMapLayerAction.Flag'] = ...) -> None: ...

    def triggeredForLayer(self, layer: QgsMapLayer) -> None: ...
    def triggeredForFeature(self, layer: QgsMapLayer, feature: QgsFeature) -> None: ...
    def triggeredForFeatures(self, layer: QgsMapLayer, featureList: Iterable[QgsFeature]) -> None: ...
    def isEnabledOnlyWhenEditable(self) -> bool: ...
    def targets(self) -> 'QgsMapLayerAction.Targets': ...
    def setTargets(self, targets: Union['QgsMapLayerAction.Targets', 'QgsMapLayerAction.Target']) -> None: ...
    def triggerForLayer(self, layer: QgsMapLayer) -> None: ...
    def triggerForFeature(self, layer: QgsMapLayer, feature: QgsFeature) -> None: ...
    def triggerForFeatures(self, layer: QgsMapLayer, featureList: Iterable[QgsFeature]) -> None: ...
    def canRunUsingLayer(self, layer: QgsMapLayer) -> bool: ...
    def flags(self) -> 'QgsMapLayerAction.Flags': ...


class QgsMapLayerActionRegistry(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def changed(self) -> None: ...
    def defaultActionForLayer(self, layer: QgsMapLayer) -> QgsMapLayerAction: ...
    def setDefaultActionForLayer(self, layer: QgsMapLayer, action: QgsMapLayerAction) -> None: ...
    def removeMapLayerAction(self, action: QgsMapLayerAction) -> bool: ...
    def mapLayerActions(self, layer: QgsMapLayer, targets: Union[QgsMapLayerAction.Targets, QgsMapLayerAction.Target] = ...) -> List[QgsMapLayerAction]: ...
    def addMapLayerAction(self, action: QgsMapLayerAction) -> None: ...


class QgsMapLayerComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def rowsChanged(self) -> None: ...
    def indexChanged(self, i: int) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...
    def layerChanged(self, layer: QgsMapLayer) -> None: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...
    def layer(self, layerIndex: int) -> QgsMapLayer: ...
    def currentLayer(self) -> QgsMapLayer: ...
    def additionalItems(self) -> List[str]: ...
    def setAdditionalItems(self, items: Iterable[str]) -> None: ...
    def showCrs(self) -> bool: ...
    def setShowCrs(self, showCrs: bool) -> None: ...
    def allowEmptyLayer(self) -> bool: ...
    def setAllowEmptyLayer(self, allowEmpty: bool, text: str = ..., icon: QtGui.QIcon = ...) -> None: ...
    def excludedProviders(self) -> List[str]: ...
    def setExcludedProviders(self, providers: Iterable[str]) -> None: ...
    def exceptedLayerList(self) -> List[QgsMapLayer]: ...
    def setExceptedLayerList(self, layerList: Iterable[QgsMapLayer]) -> None: ...
    def filters(self) -> QgsMapLayerProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsMapLayerProxyModel.Filters, QgsMapLayerProxyModel.Filter]) -> None: ...


class QgsMapLayerConfigWidget(QgsPanelWidget):

    def __init__(self, layer: QgsMapLayer, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def apply(self) -> None: ...
    def syncToLayer(self, layer: QgsMapLayer) -> None: ...
    def shouldTriggerLayerRepaint(self) -> bool: ...


class QgsMapLayerConfigWidgetFactory(sip.wrapper):

    class ParentPage(int): ...
    NoParent: QgsMapLayerConfigWidgetFactory.ParentPage = ...
    Temporal: QgsMapLayerConfigWidgetFactory.ParentPage = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, title: str, icon: QtGui.QIcon) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerConfigWidgetFactory) -> None: ...

    def createWidget(self, layer: QgsMapLayer, canvas: QgsMapCanvas, dockWidget: bool = ..., parent: Optional[QtWidgets.QWidget] = ...) -> QgsMapLayerConfigWidget: ...
    def parentPage(self) -> 'QgsMapLayerConfigWidgetFactory.ParentPage': ...
    def supportsLayer(self, layer: QgsMapLayer) -> bool: ...
    def setSupportLayerPropertiesDialog(self, supports: bool) -> None: ...
    def layerPropertiesPagePositionHint(self) -> str: ...
    def supportLayerPropertiesDialog(self) -> bool: ...
    def setSupportsStyleDock(self, supports: bool) -> None: ...
    def supportsStyleDock(self) -> bool: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsMapLayerStyleManagerWidget(QgsMapLayerConfigWidget):

    def __init__(self, layer: QgsMapLayer, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def apply(self) -> None: ...


class QgsMapMouseEvent(QtGui.QMouseEvent):

    @overload
    def __init__(self, mapCanvas: QgsMapCanvas, event: QtGui.QMouseEvent) -> None: ...
    @overload
    def __init__(self, mapCanvas: QgsMapCanvas, type: QtCore.QEvent.Type, pos: QtCore.QPoint, button: QtCore.Qt.MouseButton = ..., buttons: Union[QtCore.Qt.MouseButtons, QtCore.Qt.MouseButton] = ..., modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsMapMouseEvent) -> None: ...

    def snapToGrid(self, precision: float, crs: QgsCoordinateReferenceSystem) -> None: ...
    def originalPixelPoint(self) -> QtCore.QPoint: ...
    def pixelPoint(self) -> QtCore.QPoint: ...
    def originalMapPoint(self) -> QgsPointXY: ...
    def setMapPoint(self, point: QgsPointXY) -> None: ...
    def mapPointMatch(self) -> QgsPointLocator.Match: ...
    def mapPoint(self) -> QgsPointXY: ...
    def isSnapped(self) -> bool: ...
    def snapPoint(self) -> QgsPointXY: ...


class QgsMapOverviewCanvas(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., mapCanvas: Optional[QgsMapCanvas] = ...) -> None: ...

    def updatePanningWidget(self, pos: QtCore.QPoint) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, e: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def paintEvent(self, pe: QtGui.QPaintEvent) -> None: ...
    def transformContextChanged(self) -> None: ...
    def destinationCrsChanged(self) -> None: ...
    def drawExtentRect(self) -> None: ...
    def layerRepaintRequested(self, deferred: bool = ...) -> None: ...
    def mapRenderingFinished(self) -> None: ...
    def updateFullExtent(self) -> None: ...
    def enableAntiAliasing(self, flag: bool) -> None: ...
    def layers(self) -> List[QgsMapLayer]: ...
    def setLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def setBackgroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def refresh(self) -> None: ...


class QgsMapTip(QtWidgets.QWidget):

    def __init__(self) -> None: ...

    def applyFontSettings(self) -> None: ...
    def clear(self, mpMapCanvas: Optional[QgsMapCanvas] = ...) -> None: ...
    def showMapTip(self, thepLayer: QgsMapLayer, mapPosition: QgsPointXY, pixelPosition: QtCore.QPoint, mpMapCanvas: QgsMapCanvas) -> None: ...


class QgsMapTool(QtCore.QObject):

    class Flag(int): ...
    Transient: QgsMapTool.Flag = ...
    EditTool: QgsMapTool.Flag = ...
    AllowZoomRect: QgsMapTool.Flag = ...
    ShowContextMenu: QgsMapTool.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsMapTool.Flags', 'QgsMapTool.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsMapTool.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsMapTool.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def toCanvasCoordinates(self, point: QgsPointXY) -> QtCore.QPoint: ...
    def toMapCoordinatesV2(self, layer: QgsMapLayer, point: QgsPoint) -> QgsPoint: ...
    @overload
    def toLayerCoordinates(self, layer: QgsMapLayer, point: QtCore.QPoint) -> QgsPointXY: ...
    @overload
    def toLayerCoordinates(self, layer: QgsMapLayer, point: QgsPointXY) -> QgsPointXY: ...
    @overload
    def toLayerCoordinates(self, layer: QgsMapLayer, rect: QgsRectangle) -> QgsRectangle: ...
    @overload
    def toMapCoordinates(self, point: QtCore.QPoint) -> QgsPointXY: ...
    @overload
    def toMapCoordinates(self, layer: QgsMapLayer, point: QgsPointXY) -> QgsPointXY: ...
    def deactivated(self) -> None: ...
    def activated(self) -> None: ...
    def messageDiscarded(self) -> None: ...
    def messageEmitted(self, message: str, a1: Qgis.MessageLevel = ...) -> None: ...
    def populateContextMenuWithEvent(self, menu: QtWidgets.QMenu, event: QgsMapMouseEvent) -> bool: ...
    def populateContextMenu(self, menu: QtWidgets.QMenu) -> None: ...
    @overload
    @staticmethod
    def searchRadiusMU(context: QgsRenderContext) -> float: ...
    @overload
    @staticmethod
    def searchRadiusMU(canvas: QgsMapCanvas) -> float: ...
    @staticmethod
    def searchRadiusMM() -> float: ...
    def toolName(self) -> str: ...
    def canvas(self) -> QgsMapCanvas: ...
    def clean(self) -> None: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def setCursor(self, cursor: Union[QtGui.QCursor, QtCore.Qt.CursorShape]) -> None: ...
    def button(self) -> QtWidgets.QAbstractButton: ...
    def setButton(self, button: QtWidgets.QAbstractButton) -> None: ...
    def isActive(self) -> bool: ...
    def action(self) -> QtWidgets.QAction: ...
    def setAction(self, action: QtWidgets.QAction) -> None: ...
    def gestureEvent(self, e: QtWidgets.QGestureEvent) -> bool: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, e: QtGui.QWheelEvent) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasDoubleClickEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def flags(self) -> 'QgsMapTool.Flags': ...


class QgsMapToolEdit(QgsMapTool):

    class TopologicalResult(int): ...
    Success: QgsMapToolEdit.TopologicalResult = ...
    InvalidCanvas: QgsMapToolEdit.TopologicalResult = ...
    InvalidLayer: QgsMapToolEdit.TopologicalResult = ...

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def notifyNotEditableLayer(self) -> None: ...
    def notifyNotVectorLayer(self) -> None: ...
    @overload
    def addTopologicalPoints(self, vertices: Iterable[QgsPointXY]) -> 'QgsMapToolEdit.TopologicalResult': ...
    @overload
    def addTopologicalPoints(self, vertices: Iterable[QgsPoint]) -> 'QgsMapToolEdit.TopologicalResult': ...
    def currentVectorLayer(self) -> QgsVectorLayer: ...
    def createGeometryRubberBand(self, geometryType: QgsWkbTypes.GeometryType = ..., alternativeBand: bool = ...) -> QgsGeometryRubberBand: ...
    def createRubberBand(self, geometryType: QgsWkbTypes.GeometryType = ..., alternativeBand: bool = ...) -> QgsRubberBand: ...
    @staticmethod
    def digitizingFillColor() -> QtGui.QColor: ...
    @staticmethod
    def digitizingStrokeWidth() -> int: ...
    @staticmethod
    def digitizingStrokeColor() -> QtGui.QColor: ...
    def defaultMValue(self) -> float: ...
    def defaultZValue(self) -> float: ...
    def flags(self) -> QgsMapTool.Flags: ...


class QgsMapToolAdvancedDigitizing(QgsMapToolEdit):

    def __init__(self, canvas: QgsMapCanvas, cadDockWidget: QgsAdvancedDigitizingDockWidget) -> None: ...

    def setSnapToLayerGridEnabled(self, snapToLayerGridEnabled: bool) -> None: ...
    def snapToLayerGridEnabled(self) -> bool: ...
    def cadCanvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def cadCanvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def cadCanvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def setAutoSnapEnabled(self, enabled: bool) -> None: ...
    def setAdvancedDigitizingAllowed(self, allowed: bool) -> None: ...
    def isAutoSnapEnabled(self) -> bool: ...
    def isAdvancedDigitizingAllowed(self) -> bool: ...
    def cadDockWidget(self) -> QgsAdvancedDigitizingDockWidget: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...


class QgsMapToolCapture(QgsMapToolAdvancedDigitizing):

    class Capability(int): ...
    NoCapabilities: QgsMapToolCapture.Capability = ...
    SupportsCurves: QgsMapToolCapture.Capability = ...

    class CaptureTechnique(int): ...
    StraightSegments: QgsMapToolCapture.CaptureTechnique = ...
    CircularString: QgsMapToolCapture.CaptureTechnique = ...
    Streaming: QgsMapToolCapture.CaptureTechnique = ...

    class CaptureMode(int): ...
    CaptureNone: QgsMapToolCapture.CaptureMode = ...
    CapturePoint: QgsMapToolCapture.CaptureMode = ...
    CaptureLine: QgsMapToolCapture.CaptureMode = ...
    CapturePolygon: QgsMapToolCapture.CaptureMode = ...

    class Capabilities(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsMapToolCapture.Capabilities', 'QgsMapToolCapture.Capability']) -> None: ...
        @overload
        def __init__(self, a0: QgsMapToolCapture.Capabilities) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsMapToolCapture.Capabilities': ...
        def __int__(self) -> int: ...

    def __init__(self, canvas: QgsMapCanvas, cadDockWidget: QgsAdvancedDigitizingDockWidget, mode: QgsMapToolCapture.CaptureMode) -> None: ...

    def stopCapturing(self) -> None: ...
    def closePolygon(self) -> None: ...
    @overload
    def setPoints(self, pointList: Iterable[QgsPointXY]) -> None: ...
    @overload
    def setPoints(self, pointList: Iterable[QgsPoint]) -> None: ...
    def pointsZM(self) -> List[QgsPoint]: ...
    def points(self) -> List[QgsPointXY]: ...
    def size(self) -> int: ...
    def isCapturing(self) -> bool: ...
    def startCapturing(self) -> None: ...
    def undo(self, isAutoRepeat: bool = ...) -> None: ...
    @overload
    def addVertex(self, point: QgsPointXY) -> int: ...
    @overload
    def addVertex(self, mapPoint: QgsPointXY, match: QgsPointLocator.Match) -> int: ...
    @overload
    def mapPoint(self, e: QgsMapMouseEvent) -> QgsPoint: ...
    @overload
    def mapPoint(self, point: QgsPointXY) -> QgsPoint: ...
    def fetchLayerPoint(self, match: QgsPointLocator.Match, layerPoint: QgsPoint) -> int: ...
    @overload
    def nextPoint(self, mapPoint: QgsPoint, layerPoint: QgsPoint) -> int: ...
    @overload
    def nextPoint(self, p: QtCore.QPoint, layerPoint: QgsPoint, mapPoint: QgsPoint) -> int: ...
    def setStreamDigitizingEnabled(self, enable: bool) -> None: ...
    def setCircularDigitizingEnabled(self, enable: bool) -> None: ...
    def takeRubberBand(self) -> QgsRubberBand: ...
    def clean(self) -> None: ...
    def deleteTempRubberBand(self) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def cadCanvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def snappingMatches(self) -> List[QgsPointLocator.Match]: ...
    def captureCurve(self) -> QgsCompoundCurve: ...
    def clearCurve(self) -> None: ...
    def addCurve(self, c: QgsCurve) -> int: ...
    def mode(self) -> 'QgsMapToolCapture.CaptureMode': ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def supportsTechnique(self, technique: QgsMapToolCapture.CaptureTechnique) -> bool: ...
    def capabilities(self) -> 'QgsMapToolCapture.Capabilities': ...


class QgsMapToolDigitizeFeature(QgsMapToolCapture):

    def __init__(self, canvas: QgsMapCanvas, cadDockWidget: QgsAdvancedDigitizingDockWidget, mode: QgsMapToolCapture.CaptureMode = ...) -> None: ...

    def setCheckGeometryType(self, checkGeometryType: bool) -> None: ...
    def checkGeometryType(self) -> bool: ...
    def digitizingFinished(self) -> None: ...
    def digitizingCompleted(self, feature: QgsFeature) -> None: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def setLayer(self, vl: QgsMapLayer) -> None: ...
    def cadCanvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def supportsTechnique(self, technique: QgsMapToolCapture.CaptureTechnique) -> bool: ...
    def capabilities(self) -> QgsMapToolCapture.Capabilities: ...


class QgsMapToolEmitPoint(QgsMapTool):

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def canvasClicked(self, point: QgsPointXY, button: QtCore.Qt.MouseButton) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def flags(self) -> QgsMapTool.Flags: ...


class QgsMapToolExtent(QgsMapTool):

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def extentChanged(self, extent: QgsRectangle) -> None: ...
    def clearRubberBand(self) -> None: ...
    def extent(self) -> QgsRectangle: ...
    def ratio(self) -> QtCore.QSize: ...
    def setRatio(self, ratio: QtCore.QSize) -> None: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def flags(self) -> QgsMapTool.Flags: ...


class QgsMapToolIdentify(QgsMapTool):

    class Type(int): ...
    VectorLayer: QgsMapToolIdentify.Type = ...
    RasterLayer: QgsMapToolIdentify.Type = ...
    MeshLayer: QgsMapToolIdentify.Type = ...
    VectorTileLayer: QgsMapToolIdentify.Type = ...
    PointCloudLayer: QgsMapToolIdentify.Type = ...
    AllLayers: QgsMapToolIdentify.Type = ...

    class IdentifyMode(int): ...
    DefaultQgsSetting: QgsMapToolIdentify.IdentifyMode = ...
    ActiveLayer: QgsMapToolIdentify.IdentifyMode = ...
    TopDownStopAtFirst: QgsMapToolIdentify.IdentifyMode = ...
    TopDownAll: QgsMapToolIdentify.IdentifyMode = ...
    LayerSelection: QgsMapToolIdentify.IdentifyMode = ...

    class LayerType(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsMapToolIdentify.LayerType', 'QgsMapToolIdentify.Type']) -> None: ...
        @overload
        def __init__(self, a0: QgsMapToolIdentify.LayerType) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsMapToolIdentify.LayerType': ...
        def __int__(self) -> int: ...

    class IdentifyResult(sip.wrapper):

        mAttributes: Dict[str, str] = ...
        mDerivedAttributes: Dict[str, str] = ...
        mFeature: QgsFeature = ...
        mFields: QgsFields = ...
        mLabel: str = ...
        mLayer: QgsMapLayer = ...
        mParams: Dict[str, typing.Any] = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, layer: QgsMapLayer, feature: QgsFeature, derivedAttributes: Dict[str, str]) -> None: ...
        @overload
        def __init__(self, layer: QgsMapLayer, label: str, attributes: Dict[str, str], derivedAttributes: Dict[str, str]) -> None: ...
        @overload
        def __init__(self, layer: QgsMapLayer, label: str, fields: QgsFields, feature: QgsFeature, derivedAttributes: Dict[str, str]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapToolIdentify.IdentifyResult) -> None: ...

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def restoreCanvasPropertiesOverrides(self) -> None: ...
    def setCanvasPropertiesOverrides(self, searchRadiusMapUnits: float) -> None: ...
    def derivedAttributesForPoint(self, point: QgsPoint) -> Dict[str, str]: ...
    def identifyMeshLayer(self, results: Iterable[QgsMapToolIdentify.IdentifyResult], layer: QgsMeshLayer, point: QgsPointXY, identifyContext: QgsIdentifyContext = ...) -> bool: ...
    def identifyVectorLayer(self, results: Iterable[QgsMapToolIdentify.IdentifyResult], layer: QgsVectorLayer, point: QgsPointXY, identifyContext: QgsIdentifyContext = ...) -> bool: ...
    def identifyRasterLayer(self, results: Iterable[QgsMapToolIdentify.IdentifyResult], layer: QgsRasterLayer, point: QgsPointXY, viewExtent: QgsRectangle, mapUnitsPerPixel: float, identifyContext: QgsIdentifyContext = ...) -> bool: ...
    def identifyLayer(self, results: Iterable[QgsMapToolIdentify.IdentifyResult], layer: QgsMapLayer, point: QgsPointXY, viewExtent: QgsRectangle, mapUnitsPerPixel: float, layerType: Union['QgsMapToolIdentify.LayerType', 'QgsMapToolIdentify.Type'] = ..., identifyContext: QgsIdentifyContext = ...) -> bool: ...
    def changedRasterResults(self, a0: Iterable[QgsMapToolIdentify.IdentifyResult]) -> None: ...
    def identifyMessage(self, a0: str) -> None: ...
    def identifyProgress(self, a0: int, a1: int) -> None: ...
    def formatChanged(self, layer: QgsRasterLayer) -> None: ...
    def identifyMenu(self) -> QgsIdentifyMenu: ...
    @overload
    def identify(self, x: int, y: int, layerList: Iterable[QgsMapLayer] = ..., mode: QgsMapToolIdentify.IdentifyMode = ..., identifyContext: QgsIdentifyContext = ...) -> List[QgsMapToolIdentify.IdentifyResult]: ...
    @overload
    def identify(self, x: int, y: int, mode: QgsMapToolIdentify.IdentifyMode, layerType: Union['QgsMapToolIdentify.LayerType', 'QgsMapToolIdentify.Type'] = ..., identifyContext: QgsIdentifyContext = ...) -> List[QgsMapToolIdentify.IdentifyResult]: ...
    @overload
    def identify(self, geometry: QgsGeometry, mode: QgsMapToolIdentify.IdentifyMode, layerType: Union['QgsMapToolIdentify.LayerType', 'QgsMapToolIdentify.Type'], identifyContext: QgsIdentifyContext = ...) -> List[QgsMapToolIdentify.IdentifyResult]: ...
    @overload
    def identify(self, geometry: QgsGeometry, mode: QgsMapToolIdentify.IdentifyMode, layerList: Iterable[QgsMapLayer], layerType: Union['QgsMapToolIdentify.LayerType', 'QgsMapToolIdentify.Type'], identifyContext: QgsIdentifyContext = ...) -> List[QgsMapToolIdentify.IdentifyResult]: ...
    @overload
    def identify(self, x: int, y: int, mode: QgsMapToolIdentify.IdentifyMode, layerList: Iterable[QgsMapLayer], layerType: Union['QgsMapToolIdentify.LayerType', 'QgsMapToolIdentify.Type'] = ..., identifyContext: QgsIdentifyContext = ...) -> List[QgsMapToolIdentify.IdentifyResult]: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def flags(self) -> QgsMapTool.Flags: ...


class QgsMapToolIdentifyFeature(QgsMapToolIdentify):

    def __init__(self, canvas: QgsMapCanvas, vl: Optional[QgsVectorLayer] = ...) -> None: ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    @overload
    def featureIdentified(self, a0: QgsFeature) -> None: ...
    @overload
    def featureIdentified(self, a0: int) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def setLayer(self, vl: QgsVectorLayer) -> None: ...


class QgsMapToolPan(QgsMapTool):

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def panDistanceBearingChanged(self, distance: float, unit: QgsUnitTypes.DistanceUnit, bearing: float) -> None: ...
    def isDragging(self) -> bool: ...
    def gestureEvent(self, e: QtWidgets.QGestureEvent) -> bool: ...
    def canvasDoubleClickEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def flags(self) -> QgsMapTool.Flags: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...


class QgsMapToolZoom(QgsMapTool):

    def __init__(self, canvas: QgsMapCanvas, zoomOut: bool) -> None: ...

    def deactivate(self) -> None: ...
    def keyReleaseEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def canvasReleaseEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasPressEvent(self, e: QgsMapMouseEvent) -> None: ...
    def canvasMoveEvent(self, e: QgsMapMouseEvent) -> None: ...
    def flags(self) -> QgsMapTool.Flags: ...


class QgsMenuHeader(QtWidgets.QWidget):

    def __init__(self, text: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsMenuHeaderWidgetAction(QtWidgets.QWidgetAction):

    def __init__(self, text: str, parent: Optional[QtCore.QObject] = ...) -> None: ...


class QgsMessageBar(QtWidgets.QFrame):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def pushCritical(self, title: str, message: str) -> None: ...
    def pushWarning(self, title: str, message: str) -> None: ...
    def pushInfo(self, title: str, message: str) -> None: ...
    def pushSuccess(self, title: str, message: str) -> None: ...
    def clearWidgets(self) -> bool: ...
    def widgetRemoved(self, item: QgsMessageBarItem) -> None: ...
    def widgetAdded(self, item: QgsMessageBarItem) -> None: ...
    @staticmethod
    def defaultMessageTimeout(level: Qgis.MessageLevel = ...) -> int: ...
    def items(self) -> List[QgsMessageBarItem]: ...
    def currentItem(self) -> QgsMessageBarItem: ...
    @overload
    def pushMessage(self, text: str, level: Qgis.MessageLevel = ..., duration: int = ...) -> None: ...
    @overload
    def pushMessage(self, title: str, text: str, level: Qgis.MessageLevel = ..., duration: int = ...) -> None: ...
    @overload
    def pushMessage(self, title: str, text: str, showMore: str, level: Qgis.MessageLevel = ..., duration: int = ...) -> None: ...
    @overload
    @staticmethod
    def createMessage(text: str, parent: Optional[QtWidgets.QWidget] = ...) -> QgsMessageBarItem: ...
    @overload
    @staticmethod
    def createMessage(title: str, text: str, parent: Optional[QtWidgets.QWidget] = ...) -> QgsMessageBarItem: ...
    @overload
    @staticmethod
    def createMessage(widget: QtWidgets.QWidget, parent: Optional[QtWidgets.QWidget] = ...) -> QgsMessageBarItem: ...
    @overload
    def popWidget(self, item: QgsMessageBarItem) -> bool: ...
    @overload
    def popWidget(self) -> bool: ...
    def pushWidget(self, widget: QtWidgets.QWidget, level: Qgis.MessageLevel = ..., duration: int = ...) -> QgsMessageBarItem: ...
    def pushItem(self, item: QgsMessageBarItem) -> None: ...


class QgsMessageBarItem(QtWidgets.QWidget):

    @overload
    def __init__(self, text: str, level: Qgis.MessageLevel = ..., duration: int = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, title: str, text: str, level: Qgis.MessageLevel = ..., duration: int = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, title: str, text: str, widget: QtWidgets.QWidget, level: Qgis.MessageLevel = ..., duration: int = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, widget: QtWidgets.QWidget, level: Qgis.MessageLevel = ..., duration: int = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def styleChanged(self, styleSheet: str) -> None: ...
    def dismiss(self) -> None: ...
    def getStyleSheet(self) -> str: ...
    def duration(self) -> int: ...
    def setDuration(self, duration: int) -> QgsMessageBarItem: ...
    def icon(self) -> QtGui.QIcon: ...
    def setIcon(self, icon: QtGui.QIcon) -> QgsMessageBarItem: ...
    def widget(self) -> QtWidgets.QWidget: ...
    def setWidget(self, widget: QtWidgets.QWidget) -> QgsMessageBarItem: ...
    def level(self) -> Qgis.MessageLevel: ...
    def setLevel(self, level: Qgis.MessageLevel) -> QgsMessageBarItem: ...
    def title(self) -> str: ...
    def setTitle(self, title: str) -> QgsMessageBarItem: ...
    def text(self) -> str: ...
    def setText(self, text: str) -> QgsMessageBarItem: ...


class QgsMessageLogViewer(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def eventFilter(self, obj: QtCore.QObject, ev: QtCore.QEvent) -> bool: ...
    def reject(self) -> None: ...
    def closeEvent(self, e: QtGui.QCloseEvent) -> None: ...
    def logMessage(self, message: str, tag: str, level: Qgis.MessageLevel) -> None: ...


class QgsMessageViewer(QtWidgets.QDialog, QgsMessageOutput):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., deleteOnClose: bool = ...) -> None: ...

    def setCheckBoxQgsSettingsLabel(self, label: str) -> None: ...
    def checkBoxState(self) -> QtCore.Qt.CheckState: ...
    def setCheckBoxState(self, state: QtCore.Qt.CheckState) -> None: ...
    def setCheckBoxVisible(self, visible: bool) -> None: ...
    def setCheckBoxText(self, text: str) -> None: ...
    def setMessageAsPlainText(self, msg: str) -> None: ...
    def setMessageAsHtml(self, msg: str) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def showMessage(self, blocking: bool = ...) -> None: ...
    def appendMessage(self, message: str) -> None: ...
    def setMessage(self, message: str, msgType: QgsMessageOutput.MessageType) -> None: ...


class QgsMetadataWidget(QtWidgets.QWidget):

    class Mode(int): ...
    LayerMetadata: QgsMetadataWidget.Mode = ...
    ProjectMetadata: QgsMetadataWidget.Mode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsMapLayer] = ...) -> None: ...

    def titleChanged(self, title: str) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    @staticmethod
    def parseTypes() -> Dict[str, str]: ...
    @staticmethod
    def parseMimeTypes() -> List[str]: ...
    @staticmethod
    def parseLinkTypes() -> List[str]: ...
    @staticmethod
    def parseLicenses() -> List[str]: ...
    @staticmethod
    def parseLanguages() -> Dict[str, str]: ...
    def acceptMetadata(self) -> None: ...
    def crsChanged(self) -> None: ...
    def checkMetadata(self) -> bool: ...
    def saveMetadata(self, metadata: QgsAbstractMetadataBase) -> None: ...
    def metadata(self) -> QgsAbstractMetadataBase: ...
    def setMetadata(self, metadata: QgsAbstractMetadataBase) -> None: ...
    def mode(self) -> 'QgsMetadataWidget.Mode': ...
    def setMode(self, mode: QgsMetadataWidget.Mode) -> None: ...


class QgsNewAuxiliaryFieldDialog(QtWidgets.QDialog):

    def __init__(self, definition: QgsPropertyDefinition, layer: QgsVectorLayer, nameOnly: bool = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def accept(self) -> None: ...
    def propertyDefinition(self) -> QgsPropertyDefinition: ...


class QgsNewAuxiliaryLayerDialog(QtWidgets.QDialog):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def accept(self) -> None: ...


class QgsNewGeoPackageLayerDialog(QtWidgets.QDialog):

    class OverwriteBehavior(int): ...
    Prompt: QgsNewGeoPackageLayerDialog.OverwriteBehavior = ...
    Overwrite: QgsNewGeoPackageLayerDialog.OverwriteBehavior = ...
    AddNewLayer: QgsNewGeoPackageLayerDialog.OverwriteBehavior = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setAddToProject(self, addToProject: bool) -> None: ...
    def setOverwriteBehavior(self, behavior: QgsNewGeoPackageLayerDialog.OverwriteBehavior) -> None: ...
    def lockDatabasePath(self) -> None: ...
    def setDatabasePath(self, path: str) -> None: ...
    def databasePath(self) -> str: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...


class QgsNewVectorTableDialog(QtWidgets.QDialog):

    def __init__(self, conn: QgsAbstractDatabaseProviderConnection, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def validationErrors(self) -> List[str]: ...
    def createSpatialIndex(self) -> bool: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def geometryType(self) -> QgsWkbTypes.Type: ...
    def fields(self) -> QgsFields: ...
    def geometryColumnName(self) -> str: ...
    def schemaName(self) -> str: ...
    def tableName(self) -> str: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setGeometryType(self, type: QgsWkbTypes.Type) -> None: ...
    def setTableName(self, name: str) -> None: ...
    def setSchemaName(self, name: str) -> None: ...


class QgsNewHttpConnection(QtWidgets.QDialog):

    class WfsVersionIndex(int): ...
    WFS_VERSION_MAX: QgsNewHttpConnection.WfsVersionIndex = ...
    WFS_VERSION_1_0: QgsNewHttpConnection.WfsVersionIndex = ...
    WFS_VERSION_1_1: QgsNewHttpConnection.WfsVersionIndex = ...
    WFS_VERSION_2_0: QgsNewHttpConnection.WfsVersionIndex = ...
    WFS_VERSION_API_FEATURES_1_0: QgsNewHttpConnection.WfsVersionIndex = ...

    class Flag(int): ...
    FlagShowTestConnection: QgsNewHttpConnection.Flag = ...
    FlagHideAuthenticationGroup: QgsNewHttpConnection.Flag = ...
    FlagShowHttpSettings: QgsNewHttpConnection.Flag = ...

    class ConnectionType(int): ...
    ConnectionWfs: QgsNewHttpConnection.ConnectionType = ...
    ConnectionWms: QgsNewHttpConnection.ConnectionType = ...
    ConnectionWcs: QgsNewHttpConnection.ConnectionType = ...
    ConnectionOther: QgsNewHttpConnection.ConnectionType = ...

    class ConnectionTypes(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsNewHttpConnection.ConnectionTypes', 'QgsNewHttpConnection.ConnectionType']) -> None: ...
        @overload
        def __init__(self, a0: QgsNewHttpConnection.ConnectionTypes) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsNewHttpConnection.ConnectionTypes': ...
        def __int__(self) -> int: ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsNewHttpConnection.Flags', 'QgsNewHttpConnection.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsNewHttpConnection.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsNewHttpConnection.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., types: Union['QgsNewHttpConnection.ConnectionTypes', 'QgsNewHttpConnection.ConnectionType'] = ..., baseKey: str = ..., connectionName: str = ..., flags: Union['QgsNewHttpConnection.Flags', 'QgsNewHttpConnection.Flag'] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def updateServiceSpecificSettings(self) -> None: ...
    def wmsSettingsKey(self, base: str, connectionName: str) -> str: ...
    def wfsSettingsKey(self, base: str, connectionName: str) -> str: ...
    def testConnectButton(self) -> QtWidgets.QPushButton: ...
    def validate(self) -> bool: ...
    def accept(self) -> None: ...
    def url(self) -> str: ...
    def name(self) -> str: ...


class QgsNewMemoryLayerDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def fields(self) -> QgsFields: ...
    def layerName(self) -> str: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def selectedType(self) -> QgsWkbTypes.Type: ...
    @staticmethod
    def runAndCreateLayer(parent: Optional[QtWidgets.QWidget] = ..., defaultCrs: QgsCoordinateReferenceSystem = ...) -> QgsVectorLayer: ...


class QgsNewNameDialog(QgsDialog):

    def __init__(self, source: str = ..., initial: str = ..., extensions: Iterable[str] = ..., existing: Iterable[str] = ..., regexp: QtCore.QRegExp = ..., cs: QtCore.Qt.CaseSensitivity = ..., parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    @staticmethod
    def matching(newNames: Iterable[str], existingNames: Iterable[str], cs: QtCore.Qt.CaseSensitivity = ...) -> List[str]: ...
    @staticmethod
    def fullNames(name: str, extensions: Iterable[str]) -> List[str]: ...
    def highlightText(self, text: str) -> str: ...
    def nameChanged(self) -> None: ...
    def newNameChanged(self) -> None: ...
    @staticmethod
    def exists(name: str, extensions: Iterable[str], existing: Iterable[str], cs: QtCore.Qt.CaseSensitivity = ...) -> bool: ...
    def name(self) -> str: ...
    def conflictingNameWarning(self) -> str: ...
    def setConflictingNameWarning(self, string: str) -> None: ...
    def allowEmptyName(self) -> bool: ...
    def setAllowEmptyName(self, allowed: bool) -> None: ...
    def overwriteEnabled(self) -> bool: ...
    def setOverwriteEnabled(self, enabled: bool) -> None: ...
    def hintString(self) -> str: ...
    def setHintString(self, hintString: str) -> None: ...


class QgsNewVectorLayerDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setFilename(self, filename: str) -> None: ...
    def filename(self) -> str: ...
    def selectedFileEncoding(self) -> str: ...
    def selectedFileFormat(self) -> str: ...
    def attributes(self, at: Iterable[Tuple[str, str]]) -> None: ...
    def selectedType(self) -> QgsWkbTypes.Type: ...
    @staticmethod
    def execAndCreateLayer(parent: Optional[QtWidgets.QWidget] = ..., initialPath: str = ..., crs: QgsCoordinateReferenceSystem = ...) -> Tuple[str, str, str]: ...
    @staticmethod
    def runAndCreateLayer(parent: Optional[QtWidgets.QWidget] = ..., enc: Optional[str] = ..., crs: QgsCoordinateReferenceSystem = ..., initialPath: str = ...) -> str: ...


class QgsOpacityWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def opacityChanged(self, opacity: float) -> None: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacity(self) -> float: ...


class QgsOptionsDialogBase(QtWidgets.QDialog):

    def __init__(self, settingsKey: str, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., settings: Optional[QgsSettings] = ...) -> None: ...

    def registerTextSearchWidgets(self) -> None: ...
    def updateWindowTitle(self) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def warnAboutMissingObjects(self) -> None: ...
    def optionsStackedWidget_WidgetRemoved(self, index: int) -> None: ...
    def optionsStackedWidget_CurrentChanged(self, index: int) -> None: ...
    def updateOptionsListVerticalTabs(self) -> None: ...
    def searchText(self, text: str) -> None: ...
    def insertPage(self, title: str, tooltip: str, icon: QtGui.QIcon, widget: QtWidgets.QWidget, before: str) -> None: ...
    def addPage(self, title: str, tooltip: str, icon: QtGui.QIcon, widget: QtWidgets.QWidget) -> None: ...
    def setCurrentPage(self, page: str) -> None: ...
    def iconOnly(self) -> bool: ...
    def resizeAlltabs(self, index: int) -> None: ...
    def restoreLastPage(self) -> None: ...
    def restoreOptionsBaseUi(self, title: str = ...) -> None: ...
    def setSettings(self, settings: QgsSettings) -> None: ...
    def initOptionsBase(self, restoreUi: bool = ..., title: str = ...) -> None: ...


class QgsOptionsDialogHighlightWidget(QtCore.QObject):

    def __init__(self, widget: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def reset(self) -> None: ...
    def highlightText(self, text: str) -> bool: ...
    def searchText(self, text: str) -> bool: ...
    def eventFilter(self, obj: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def widget(self) -> QtWidgets.QWidget: ...
    def searchHighlight(self, text: str) -> bool: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def createWidget(widget: QtWidgets.QWidget) -> QgsOptionsDialogHighlightWidget: ...


class QgsOptionsDialogHighlightLabel(QgsOptionsDialogHighlightWidget):

    def __init__(self, label: QtWidgets.QLabel) -> None: ...

    def reset(self) -> None: ...
    def highlightText(self, text: str) -> bool: ...
    def searchText(self, text: str) -> bool: ...


class QgsOptionsDialogHighlightCheckBox(QgsOptionsDialogHighlightWidget):

    def __init__(self, checkBox: QtWidgets.QCheckBox) -> None: ...

    def reset(self) -> None: ...
    def highlightText(self, text: str) -> bool: ...
    def searchText(self, text: str) -> bool: ...


class QgsOptionsDialogHighlightButton(QgsOptionsDialogHighlightWidget):

    def __init__(self, button: QtWidgets.QAbstractButton) -> None: ...

    def reset(self) -> None: ...
    def highlightText(self, text: str) -> bool: ...
    def searchText(self, text: str) -> bool: ...


class QgsOptionsDialogHighlightGroupBox(QgsOptionsDialogHighlightWidget):

    def __init__(self, groupBox: QtWidgets.QGroupBox) -> None: ...

    def reset(self) -> None: ...
    def highlightText(self, text: str) -> bool: ...
    def searchText(self, text: str) -> bool: ...


class QgsOptionsDialogHighlightTree(QgsOptionsDialogHighlightWidget):

    def __init__(self, treeView: QtWidgets.QTreeView) -> None: ...

    def reset(self) -> None: ...
    def highlightText(self, text: str) -> bool: ...
    def searchText(self, text: str) -> bool: ...


class QgsOptionsPageWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def registerHighlightWidget(self, highlightWidget: QgsOptionsDialogHighlightWidget) -> None: ...
    def apply(self) -> None: ...
    def helpKey(self) -> str: ...


class QgsOptionsWidgetFactory(QtCore.QObject):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, title: str, icon: QtGui.QIcon) -> None: ...

    def createWidget(self, parent: Optional[QtWidgets.QWidget] = ...) -> QgsOptionsPageWidget: ...
    def pagePositionHint(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsOrderByDialog(QtWidgets.QDialog):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def eventFilter(self, obj: QtCore.QObject, e: QtCore.QEvent) -> bool: ...
    def orderBy(self) -> QgsFeatureRequest.OrderBy: ...
    def setOrderBy(self, orderBy: QgsFeatureRequest.OrderBy) -> None: ...


class QgsOWSSourceSelect(QgsAbstractDataSourceWidget):

    class SupportedFormat(sip.wrapper):

        format: str = ...
        label: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsOWSSourceSelect.SupportedFormat) -> None: ...

    def __init__(self, service: str, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., widgetMode: QgsProviderRegistry.WidgetMode = ...) -> None: ...

    def selectedCacheLoadControl(self) -> QtNetwork.QNetworkRequest.CacheLoadControl: ...
    def selectedTime(self) -> str: ...
    def selectedCrs(self) -> str: ...
    def selectedFormat(self) -> str: ...
    def enableLayersForCrs(self, item: QtWidgets.QTreeWidgetItem) -> None: ...
    def descriptionForAuthId(self, authId: str) -> str: ...
    def populateLayerList(self) -> None: ...
    def addDefaultServers(self) -> None: ...
    def setConnectionListPosition(self) -> None: ...
    def connectionInfo(self) -> str: ...
    def connName(self) -> str: ...
    def clearTimes(self) -> None: ...
    def populateTimes(self) -> None: ...
    def clearCrs(self) -> None: ...
    def populateCrs(self) -> None: ...
    def clearFormats(self) -> None: ...
    def populateFormats(self) -> None: ...
    def populateConnectionList(self) -> None: ...
    def selectedLayersTimes(self) -> List[str]: ...
    def selectedLayersCrses(self) -> List[str]: ...
    def selectedLayersFormats(self) -> List[str]: ...
    def providerFormats(self) -> List[QgsOWSSourceSelect.SupportedFormat]: ...
    def showStatusMessage(self, message: str) -> None: ...
    def showError(self, title: str, format: str, error: str) -> None: ...
    def reset(self) -> None: ...
    def refresh(self) -> None: ...


class QgsPanelWidgetWrapper(QgsPanelWidget):

    def __init__(self, widget: QtWidgets.QWidget, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def widget(self) -> QtWidgets.QWidget: ...


class QgsPanelWidgetStack(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def closePanel(self, panel: QgsPanelWidget) -> None: ...
    def showPanel(self, panel: QgsPanelWidget) -> None: ...
    def acceptAllPanels(self) -> None: ...
    def acceptCurrentPanel(self) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def currentPanel(self) -> QgsPanelWidget: ...
    def clear(self) -> None: ...
    def takeMainPanel(self) -> QgsPanelWidget: ...
    def mainPanel(self) -> QgsPanelWidget: ...
    def setMainPanel(self, panel: QgsPanelWidget) -> None: ...


class QgsPasswordLineEdit(QtWidgets.QLineEdit):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., passwordVisible: bool = ...) -> None: ...

    def setPasswordVisibility(self, visible: bool) -> None: ...
    def showLockIcon(self) -> bool: ...
    def setShowLockIcon(self, visible: bool) -> None: ...


class QgsPixmapLabel(QtWidgets.QLabel):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def clear(self) -> None: ...
    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None: ...
    def setPixmap(self, a0: QtGui.QPixmap) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def heightForWidth(self, width: int) -> int: ...


class QgsPluginManagerInterface(QtCore.QObject):

    def __init__(self) -> None: ...

    def pushMessage(self, text: str, level: Qgis.MessageLevel = ..., duration: int = ...) -> None: ...
    def showPluginManager(self, tabIndex: int = ...) -> None: ...
    def addToRepositoryList(self, repository: Dict[str, str]) -> None: ...
    def clearRepositoryList(self) -> None: ...
    def pluginMetadata(self, key: str) -> Dict[str, str]: ...
    def reloadModel(self) -> None: ...
    def addPluginMetadata(self, metadata: Dict[str, str]) -> None: ...
    def clearPythonPluginMetadata(self) -> None: ...


class QgsPointCloudAttributeComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setAttribute(self, name: str) -> None: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...
    def attributeChanged(self, name: str) -> None: ...
    def attributes(self) -> QgsPointCloudAttributeCollection: ...
    def setAttributes(self, attributes: QgsPointCloudAttributeCollection) -> None: ...
    def layer(self) -> QgsPointCloudLayer: ...
    def currentAttribute(self) -> str: ...
    def allowEmptyAttributeName(self) -> bool: ...
    def setAllowEmptyAttributeName(self, allowEmpty: bool) -> None: ...
    def filters(self) -> QgsPointCloudAttributeProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsPointCloudAttributeProxyModel.Filters, QgsPointCloudAttributeProxyModel.Filter]) -> None: ...


class QgsPresetColorRampWidget(QgsPanelWidget):

    def __init__(self, ramp: QgsPresetSchemeColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def setRamp(self, ramp: QgsPresetSchemeColorRamp) -> None: ...
    def ramp(self) -> QgsPresetSchemeColorRamp: ...


class QgsPresetColorRampDialog(QtWidgets.QDialog):

    def __init__(self, ramp: QgsPresetSchemeColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def setRamp(self, ramp: QgsPresetSchemeColorRamp) -> None: ...
    def ramp(self) -> QgsPresetSchemeColorRamp: ...


class QgsPreviewEffect(QtWidgets.QGraphicsEffect):

    class PreviewMode(int): ...
    PreviewGrayscale: QgsPreviewEffect.PreviewMode = ...
    PreviewMono: QgsPreviewEffect.PreviewMode = ...
    PreviewProtanope: QgsPreviewEffect.PreviewMode = ...
    PreviewDeuteranope: QgsPreviewEffect.PreviewMode = ...
    PreviewTritanope: QgsPreviewEffect.PreviewMode = ...

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def draw(self, painter: QtGui.QPainter) -> None: ...
    def mode(self) -> 'QgsPreviewEffect.PreviewMode': ...
    def setMode(self, mode: QgsPreviewEffect.PreviewMode) -> None: ...


class QgsProjectionSelectionDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setOgcWmsCrsFilter(self, crsFilter: Iterable[str]) -> None: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setRequireValidSelection(self) -> None: ...
    def setNotSetText(self, text: str) -> None: ...
    def showNoProjection(self) -> bool: ...
    def setShowNoProjection(self, show: bool) -> None: ...
    def showNoCrsForLayerMessage(self) -> None: ...
    def setMessage(self, message: str) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...


class QgsProjectionSelectionTreeWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def hasValidSelectionChanged(self, isValid: bool) -> None: ...
    def projectionDoubleClicked(self) -> None: ...
    def initialized(self) -> None: ...
    def crsSelected(self) -> None: ...
    def pushProjectionToFront(self) -> None: ...
    def setOgcWmsCrsFilter(self, crsFilter: Iterable[str]) -> None: ...
    def previewRect(self) -> QgsRectangle: ...
    def setPreviewRect(self, rect: QgsRectangle) -> None: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def hasValidSelection(self) -> bool: ...
    def showBoundsMap(self) -> bool: ...
    def setNotSetText(self, text: str) -> None: ...
    def showNoProjection(self) -> bool: ...
    def setShowBoundsMap(self, show: bool) -> None: ...
    def setShowNoProjection(self, show: bool) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...


class QgsProjectionSelectionWidget(QtWidgets.QWidget):

    class CrsOption(int): ...
    LayerCrs: QgsProjectionSelectionWidget.CrsOption = ...
    ProjectCrs: QgsProjectionSelectionWidget.CrsOption = ...
    CurrentCrs: QgsProjectionSelectionWidget.CrsOption = ...
    DefaultCrs: QgsProjectionSelectionWidget.CrsOption = ...
    RecentCrs: QgsProjectionSelectionWidget.CrsOption = ...
    CrsNotSet: QgsProjectionSelectionWidget.CrsOption = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...
    def selectCrs(self) -> None: ...
    def setLayerCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def cleared(self) -> None: ...
    def crsChanged(self, a0: QgsCoordinateReferenceSystem) -> None: ...
    def sourceEnsemble(self) -> str: ...
    def setSourceEnsemble(self, ensemble: str) -> None: ...
    def setShowAccuracyWarnings(self, show: bool) -> None: ...
    def showAccuracyWarnings(self) -> bool: ...
    def setMessage(self, text: str) -> None: ...
    def setNotSetText(self, text: str) -> None: ...
    def optionVisible(self, option: QgsProjectionSelectionWidget.CrsOption) -> bool: ...
    def setOptionVisible(self, option: QgsProjectionSelectionWidget.CrsOption, visible: bool) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...


class QgsProjectStorageGuiProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjectStorageGuiProvider) -> None: ...

    def showSaveGui(self) -> str: ...
    def showLoadGui(self) -> str: ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class QgsProjectStorageGuiRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def initializeFromProviderGuiRegistry(self, providerGuiRegistry: QgsProviderGuiRegistry) -> None: ...
    def unregisterProjectStorage(self, storage: QgsProjectStorageGuiProvider) -> None: ...
    def registerProjectStorage(self, storage: QgsProjectStorageGuiProvider) -> None: ...
    def projectStorages(self) -> List[QgsProjectStorageGuiProvider]: ...
    def projectStorageFromUri(self, uri: str) -> QgsProjectStorageGuiProvider: ...
    def projectStorageFromType(self, type: str) -> QgsProjectStorageGuiProvider: ...


class QgsPropertyAssistantWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., definition: QgsPropertyDefinition = ..., initialState: QgsProperty = ..., layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def setDockMode(self, dockMode: bool) -> None: ...
    def updateProperty(self, property: QgsProperty) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...


class QgsPropertyOverrideButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def createAuxiliaryField(self) -> None: ...
    def activated(self, isActive: bool) -> None: ...
    def changed(self) -> None: ...
    def menuActionTriggered(self, action: QtWidgets.QAction) -> None: ...
    def aboutToShowMenu(self) -> None: ...
    def setActive(self, active: bool) -> None: ...
    def updateFieldLists(self) -> None: ...
    def registerLinkedWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def registerExpressionWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def registerVisibleWidget(self, widget: QtWidgets.QWidget, natural: bool = ...) -> None: ...
    def registerEnabledWidget(self, widget: QtWidgets.QWidget, natural: bool = ...) -> None: ...
    def registerCheckedWidget(self, widget: QtWidgets.QWidget, natural: bool = ...) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def setVectorLayer(self, layer: QgsVectorLayer) -> None: ...
    def setUsageInfo(self, info: str) -> None: ...
    def usageInfo(self) -> str: ...
    def fullDescription(self) -> str: ...
    def validDataType(self) -> QgsPropertyDefinition.DataType: ...
    def isActive(self) -> bool: ...
    def propertyKey(self) -> int: ...
    def setToProperty(self, property: QgsProperty) -> None: ...
    def toProperty(self) -> QgsProperty: ...
    @overload
    def init(self, propertyKey: int, property: QgsProperty, definitions: Dict[int, QgsPropertyDefinition], layer: Optional[QgsVectorLayer] = ..., auxiliaryStorageEnabled: bool = ...) -> None: ...
    @overload
    def init(self, propertyKey: int, property: QgsProperty, definition: QgsPropertyDefinition, layer: Optional[QgsVectorLayer] = ..., auxiliaryStorageEnabled: bool = ...) -> None: ...
    @overload
    def init(self, propertyKey: int, collection: QgsAbstractPropertyCollection, definitions: Dict[int, QgsPropertyDefinition], layer: Optional[QgsVectorLayer] = ..., auxiliaryStorageEnabled: bool = ...) -> None: ...


class QgsProviderConnectionComboBox(QtWidgets.QComboBox):

    def __init__(self, provider: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def connectionChanged(self, connection: str) -> None: ...
    def setConnection(self, connection: str) -> None: ...
    def currentConnectionUri(self) -> str: ...
    def currentConnection(self) -> str: ...
    def allowEmptyConnection(self) -> bool: ...
    def setAllowEmptyConnection(self, allowEmpty: bool) -> None: ...
    def setProvider(self, provider: str) -> None: ...


class QgsProviderGuiMetadata(sip.wrapper):

    @overload
    def __init__(self, key: str) -> None: ...
    @overload
    def __init__(self, a0: QgsProviderGuiMetadata) -> None: ...

    def key(self) -> str: ...
    def mapLayerConfigWidgetFactories(self) -> List[QgsMapLayerConfigWidgetFactory]: ...
    def sourceWidgetProviders(self) -> List[QgsProviderSourceWidgetProvider]: ...
    def subsetStringEditorProviders(self) -> List[QgsSubsetStringEditorProvider]: ...
    def sourceSelectProviders(self) -> List[QgsSourceSelectProvider]: ...
    def projectStorageGuiProviders(self) -> List[QgsProjectStorageGuiProvider]: ...
    def dataItemGuiProviders(self) -> List[QgsDataItemGuiProvider]: ...
    def registerGui(self, widget: QtWidgets.QMainWindow) -> None: ...


class QgsProviderGuiRegistry(sip.wrapper):

    @overload
    def __init__(self, pluginPath: str) -> None: ...
    @overload
    def __init__(self, a0: QgsProviderGuiRegistry) -> None: ...

    def mapLayerConfigWidgetFactories(self, layer: Optional[QgsMapLayer] = ...) -> List[QgsMapLayerConfigWidgetFactory]: ...
    def sourceWidgetProviders(self, providerKey: str) -> List[QgsProviderSourceWidgetProvider]: ...
    def subsetStringEditorProviders(self, providerKey: str) -> List[QgsSubsetStringEditorProvider]: ...
    def projectStorageGuiProviders(self, providerKey: str) -> List[QgsProjectStorageGuiProvider]: ...
    def sourceSelectProviders(self, providerKey: str) -> List[QgsSourceSelectProvider]: ...
    def dataItemGuiProviders(self, providerKey: str) -> List[QgsDataItemGuiProvider]: ...
    def registerGuis(self, widget: QtWidgets.QMainWindow) -> None: ...
    def providerMetadata(self, providerKey: str) -> QgsProviderGuiMetadata: ...
    def providerList(self) -> List[str]: ...


class QgsProviderSourceWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def validChanged(self, isValid: bool) -> None: ...
    def sourceUri(self) -> str: ...
    def setSourceUri(self, uri: str) -> None: ...


class QgsProviderSourceWidgetProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProviderSourceWidgetProvider) -> None: ...

    def createWidget(self, layer: QgsMapLayer, parent: Optional[QtWidgets.QWidget] = ...) -> QgsProviderSourceWidget: ...
    def canHandleLayer(self, layer: QgsMapLayer) -> bool: ...
    def name(self) -> str: ...
    def providerKey(self) -> str: ...


class QgsProviderSourceWidgetProviderRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def createWidget(self, layer: QgsMapLayer, parent: Optional[QtWidgets.QWidget] = ...) -> QgsProviderSourceWidget: ...
    def providersByKey(self, providerKey: str) -> List[QgsProviderSourceWidgetProvider]: ...
    def providerByName(self, name: str) -> QgsProviderSourceWidgetProvider: ...
    def initializeFromProviderGuiRegistry(self, providerGuiRegistry: QgsProviderGuiRegistry) -> None: ...
    def removeProvider(self, provider: QgsProviderSourceWidgetProvider) -> bool: ...
    def addProvider(self, provider: QgsProviderSourceWidgetProvider) -> None: ...
    def providers(self) -> List[QgsProviderSourceWidgetProvider]: ...


class QgsProxyStyle(QtWidgets.QProxyStyle):

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...


class QgsSubsetStringEditorInterface(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setSubsetString(self, subsetString: str) -> None: ...
    def subsetString(self) -> str: ...


class QgsQueryBuilder(QgsSubsetStringEditorInterface):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setDatasourceDescription(self, uri: str) -> None: ...
    def loadQuery(self) -> None: ...
    def saveQuery(self) -> None: ...
    def test(self) -> None: ...
    def clear(self) -> None: ...
    def reject(self) -> None: ...
    def accept(self) -> None: ...
    def codeEditorWidget(self) -> QgsCodeEditor: ...
    def setSubsetString(self, subsetString: str) -> None: ...
    def subsetString(self) -> str: ...
    def setSql(self, sqlStatement: str) -> None: ...
    def sql(self) -> str: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...


class QgsRangeSlider(QtWidgets.QWidget):

    @overload
    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def rangeLimitsChanged(self, minimum: int, maximum: int) -> None: ...
    def rangeChanged(self, minimum: int, maximum: int) -> None: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    def setPageStep(self, step: int) -> None: ...
    def setSingleStep(self, step: int) -> None: ...
    def setRange(self, lower: int, upper: int) -> None: ...
    def setUpperValue(self, value: int) -> None: ...
    def setLowerValue(self, value: int) -> None: ...
    def setRangeLimits(self, minimum: int, maximum: int) -> None: ...
    def setMinimum(self, minimum: int) -> None: ...
    def setMaximum(self, maximum: int) -> None: ...
    def pageStep(self) -> int: ...
    def singleStep(self) -> int: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def setFlippedDirection(self, flipped: bool) -> None: ...
    def flippedDirection(self) -> bool: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def tickInterval(self) -> int: ...
    def setTickInterval(self, interval: int) -> None: ...
    def tickPosition(self) -> QtWidgets.QSlider.TickPosition: ...
    def setTickPosition(self, position: QtWidgets.QSlider.TickPosition) -> None: ...
    def upperValue(self) -> int: ...
    def lowerValue(self) -> int: ...
    def maximum(self) -> int: ...
    def minimum(self) -> int: ...


class QgsRasterFormatSaveOptionsWidget(QtWidgets.QWidget):

    class Type(int): ...
    Default: QgsRasterFormatSaveOptionsWidget.Type = ...
    Full: QgsRasterFormatSaveOptionsWidget.Type = ...
    Table: QgsRasterFormatSaveOptionsWidget.Type = ...
    LineEdit: QgsRasterFormatSaveOptionsWidget.Type = ...
    ProfileLineEdit: QgsRasterFormatSaveOptionsWidget.Type = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., format: str = ..., type: QgsRasterFormatSaveOptionsWidget.Type = ..., provider: str = ...) -> None: ...

    def optionsChanged(self) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def updateProfiles(self) -> None: ...
    def validateOptions(self, gui: bool = ..., reportOk: bool = ...) -> str: ...
    def helpOptions(self) -> None: ...
    def apply(self) -> None: ...
    def setPyramidsFormat(self, format: QgsRaster.RasterPyramidsFormat) -> None: ...
    def setType(self, type: QgsRasterFormatSaveOptionsWidget.Type = ...) -> None: ...
    def setOptions(self, options: str) -> None: ...
    def options(self) -> List[str]: ...
    def setRasterFileName(self, file: str) -> None: ...
    def setRasterLayer(self, rasterLayer: QgsRasterLayer) -> None: ...
    def setProvider(self, provider: str) -> None: ...
    def setFormat(self, format: str) -> None: ...


class QgsRasterLayerSaveAsDialog(QtWidgets.QDialog):

    class ResolutionState(int): ...
    OriginalResolution: QgsRasterLayerSaveAsDialog.ResolutionState = ...
    UserResolution: QgsRasterLayerSaveAsDialog.ResolutionState = ...

    class CrsState(int): ...
    OriginalCrs: QgsRasterLayerSaveAsDialog.CrsState = ...
    CurrentCrs: QgsRasterLayerSaveAsDialog.CrsState = ...
    UserCrs: QgsRasterLayerSaveAsDialog.CrsState = ...

    class Mode(int): ...
    RawDataMode: QgsRasterLayerSaveAsDialog.Mode = ...
    RenderedImageMode: QgsRasterLayerSaveAsDialog.Mode = ...

    def __init__(self, rasterLayer: QgsRasterLayer, sourceProvider: QgsRasterDataProvider, currentExtent: QgsRectangle, layerCrs: QgsCoordinateReferenceSystem, currentCrs: QgsCoordinateReferenceSystem, parent: Optional[QtWidgets.QWidget] = ..., f: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def accept(self) -> None: ...
    def hideOutput(self) -> None: ...
    def hideFormat(self) -> None: ...
    def pyramidsConfigOptions(self) -> List[str]: ...
    def pyramidsFormat(self) -> QgsRaster.RasterPyramidsFormat: ...
    def pyramidsResamplingMethod(self) -> str: ...
    def buildPyramidsFlag(self) -> QgsRaster.RasterBuildPyramids: ...
    def pyramidsList(self) -> List[int]: ...
    def noData(self) -> List[QgsRasterRange]: ...
    def outputRectangle(self) -> QgsRectangle: ...
    def createOptions(self) -> List[str]: ...
    def outputCrs(self) -> QgsCoordinateReferenceSystem: ...
    def outputFormat(self) -> str: ...
    def outputLayerName(self) -> str: ...
    def outputFileName(self) -> str: ...
    def setAddToCanvas(self, checked: bool) -> None: ...
    def addToCanvas(self) -> bool: ...
    def tileMode(self) -> bool: ...
    def maximumTileSizeY(self) -> int: ...
    def maximumTileSizeX(self) -> int: ...
    def yResolution(self) -> float: ...
    def xResolution(self) -> float: ...
    def nRows(self) -> int: ...
    def nColumns(self) -> int: ...
    def mode(self) -> 'QgsRasterLayerSaveAsDialog.Mode': ...


class QgsRasterPyramidsOptionsWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., provider: str = ...) -> None: ...

    def someValueChanged(self) -> None: ...
    def overviewListChanged(self) -> None: ...
    def checkAllLevels(self, checked: bool) -> None: ...
    def apply(self) -> None: ...
    def setRasterFileName(self, file: str) -> None: ...
    def setRasterLayer(self, rasterLayer: QgsRasterLayer) -> None: ...
    def resamplingMethod(self) -> str: ...
    def pyramidsFormat(self) -> QgsRaster.RasterPyramidsFormat: ...
    def overviewList(self) -> List[int]: ...
    def createOptionsWidget(self) -> QgsRasterFormatSaveOptionsWidget: ...
    def configOptions(self) -> List[str]: ...


class QgsRatioLockButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def lockChanged(self, locked: bool) -> None: ...
    def resetRatio(self) -> None: ...
    def setHeightSpinBox(self, widget: QtWidgets.QDoubleSpinBox) -> None: ...
    def setWidthSpinBox(self, widget: QtWidgets.QDoubleSpinBox) -> None: ...
    def locked(self) -> bool: ...
    def setLocked(self, locked: bool) -> None: ...


class QgsAbstractRelationEditorWidget(QtWidgets.QWidget):

    def __init__(self, config: Dict[str, typing.Any], parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def afterSetRelations(self) -> None: ...
    def beforeSetRelations(self, newRelation: QgsRelation, newNmRelation: QgsRelation) -> None: ...
    def afterSetRelationFeature(self) -> None: ...
    def beforeSetRelationFeature(self, newRelation: QgsRelation, newFeature: QgsFeature) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def updateUi(self) -> None: ...
    def unlinkFeatures(self, fids: typing.Any) -> None: ...
    def deleteFeatures(self, fids: typing.Any) -> None: ...
    def updateTitle(self) -> None: ...
    def showEvent(self, a0: QtGui.QShowEvent) -> None: ...
    def duplicateFeatures(self, fids: typing.Any) -> None: ...
    def duplicateFeature(self, fid: int) -> None: ...
    def unlinkFeature(self, fid: int = ...) -> None: ...
    def onLinkFeatureDlgAccepted(self) -> None: ...
    def linkFeature(self) -> None: ...
    def deleteFeature(self, fid: int = ...) -> None: ...
    def addFeature(self, geometry: QgsGeometry = ...) -> None: ...
    def saveEdits(self) -> None: ...
    def toggleEditing(self, state: bool) -> None: ...
    def parentFormValueChanged(self, attribute: str, newValue: typing.Any) -> None: ...
    def setConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def config(self) -> Dict[str, typing.Any]: ...
    def setForceSuppressFormPopup(self, forceSuppressFormPopup: bool) -> None: ...
    def forceSuppressFormPopup(self) -> bool: ...
    def feature(self) -> QgsFeature: ...
    def setLabel(self, label: str = ...) -> None: ...
    def label(self) -> str: ...
    def setNmRelationId(self, nmRelationId: typing.Any = ...) -> None: ...
    def nmRelationId(self) -> typing.Any: ...
    def setShowLabel(self, showLabel: bool) -> None: ...
    def showLabel(self) -> bool: ...
    def editorContext(self) -> QgsAttributeEditorContext: ...
    def setEditorContext(self, context: QgsAttributeEditorContext) -> None: ...
    def setFeature(self, feature: QgsFeature, update: bool = ...) -> None: ...
    def nmRelation(self) -> QgsRelation: ...
    def relation(self) -> QgsRelation: ...
    def setRelations(self, relation: QgsRelation, nmrelation: QgsRelation) -> None: ...
    def setRelationFeature(self, relation: QgsRelation, feature: QgsFeature) -> None: ...


class QgsRelationEditorWidget(QgsAbstractRelationEditorWidget):

    class Button(int): ...
    NoButton: QgsRelationEditorWidget.Button = ...
    Link: QgsRelationEditorWidget.Button = ...
    Unlink: QgsRelationEditorWidget.Button = ...
    SaveChildEdits: QgsRelationEditorWidget.Button = ...
    AddChildFeature: QgsRelationEditorWidget.Button = ...
    DuplicateChildFeature: QgsRelationEditorWidget.Button = ...
    DeleteChildFeature: QgsRelationEditorWidget.Button = ...
    ZoomToChildFeature: QgsRelationEditorWidget.Button = ...
    AllButtons: QgsRelationEditorWidget.Button = ...

    class Buttons(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsRelationEditorWidget.Buttons', 'QgsRelationEditorWidget.Button']) -> None: ...
        @overload
        def __init__(self, a0: QgsRelationEditorWidget.Buttons) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsRelationEditorWidget.Buttons': ...
        def __int__(self) -> int: ...

    def __init__(self, config: Dict[str, typing.Any], parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def afterSetRelations(self) -> None: ...
    def beforeSetRelations(self, newRelation: QgsRelation, newNmRelation: QgsRelation) -> None: ...
    def afterSetRelationFeature(self) -> None: ...
    def beforeSetRelationFeature(self, newRelation: QgsRelation, newFeature: QgsFeature) -> None: ...
    def updateUi(self) -> None: ...
    def parentFormValueChanged(self, attribute: str, newValue: typing.Any) -> None: ...
    def setConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def config(self) -> Dict[str, typing.Any]: ...
    def zoomToSelectedFeatures(self) -> None: ...
    def deleteSelectedFeatures(self) -> None: ...
    def unlinkSelectedFeatures(self) -> None: ...
    def duplicateSelectedFeatures(self) -> None: ...
    def duplicateFeature(self) -> None: ...
    def visibleButtons(self) -> 'QgsRelationEditorWidget.Buttons': ...
    def setVisibleButtons(self, buttons: Union['QgsRelationEditorWidget.Buttons', 'QgsRelationEditorWidget.Button']) -> None: ...
    def setEditorContext(self, context: QgsAttributeEditorContext) -> None: ...
    def featureSelectionManager(self) -> QgsIFeatureSelectionManager: ...
    def viewMode(self) -> 'QgsDualView.ViewMode': ...
    def setViewMode(self, mode: QgsDualView.ViewMode) -> None: ...


class QgsAbstractRelationEditorConfigWidget(QtWidgets.QWidget):

    def __init__(self, relation: QgsRelation, parent: QtWidgets.QWidget) -> None: ...

    def nmRelation(self) -> QgsRelation: ...
    def setNmRelation(self, nmRelation: QgsRelation) -> None: ...
    def relation(self) -> QgsRelation: ...
    def layer(self) -> QgsVectorLayer: ...
    def setConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def config(self) -> Dict[str, typing.Any]: ...


class QgsRelationEditorConfigWidget(QgsAbstractRelationEditorConfigWidget):

    def __init__(self, relation: QgsRelation, parent: QtWidgets.QWidget) -> None: ...

    def setConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def config(self) -> Dict[str, typing.Any]: ...


class QgsAbstractRelationEditorWidgetFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractRelationEditorWidgetFactory) -> None: ...

    def configWidget(self, relation: QgsRelation, parent: QtWidgets.QWidget) -> QgsAbstractRelationEditorConfigWidget: ...
    def create(self, config: Dict[str, typing.Any], parent: Optional[QtWidgets.QWidget] = ...) -> QgsAbstractRelationEditorWidget: ...
    def name(self) -> str: ...
    def type(self) -> str: ...


class QgsRelationWidgetRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRelationWidgetRegistry) -> None: ...

    def defaultWidgetType(self) -> str: ...
    def setDefaultWidgetType(self, widgetType: str) -> None: ...
    def createConfigWidget(self, widgetType: str, relation: QgsRelation, parent: Optional[QtWidgets.QWidget] = ...) -> QgsAbstractRelationEditorConfigWidget: ...
    def create(self, widgetType: str, config: Dict[str, typing.Any], parent: Optional[QtWidgets.QWidget] = ...) -> QgsAbstractRelationEditorWidget: ...
    def factories(self) -> typing.Any: ...
    def relationWidgetNames(self) -> List[str]: ...
    def removeRelationWidget(self, widgetType: str) -> None: ...
    def addRelationWidget(self, widgetFactory: QgsAbstractRelationEditorWidgetFactory) -> None: ...


class QgsRichTextEditor(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def clearSource(self) -> None: ...
    def setText(self, text: str) -> None: ...
    def setTextCursor(self, cursor: QtGui.QTextCursor) -> None: ...
    def textCursor(self) -> QtGui.QTextCursor: ...
    def document(self) -> QtGui.QTextDocument: ...
    def toHtml(self) -> str: ...
    def toPlainText(self) -> str: ...


class QgsRubberBand(QgsMapCanvasItem):

    class IconType(int): ...
    ICON_NONE: QgsRubberBand.IconType = ...
    ICON_CROSS: QgsRubberBand.IconType = ...
    ICON_X: QgsRubberBand.IconType = ...
    ICON_BOX: QgsRubberBand.IconType = ...
    ICON_CIRCLE: QgsRubberBand.IconType = ...
    ICON_FULL_BOX: QgsRubberBand.IconType = ...
    ICON_DIAMOND: QgsRubberBand.IconType = ...
    ICON_FULL_DIAMOND: QgsRubberBand.IconType = ...
    ICON_SVG: QgsRubberBand.IconType = ...

    def __init__(self, mapCanvas: QgsMapCanvas, geometryType: QgsWkbTypes.GeometryType = ...) -> None: ...

    def updateRect(self) -> None: ...
    @overload
    def drawShape(self, p: QtGui.QPainter, pts: Iterable[Union[QtCore.QPointF, QtCore.QPoint]]) -> None: ...
    @overload
    def drawShape(self, p: QtGui.QPainter, rings: Iterable[QtGui.QPolygonF]) -> None: ...
    def paint(self, p: QtGui.QPainter) -> None: ...
    def setSymbol(self, symbol: QgsSymbol) -> None: ...
    def symbol(self) -> QgsSymbol: ...
    def updatePosition(self) -> None: ...
    def asGeometry(self) -> QgsGeometry: ...
    def getPoint(self, i: int, j: int = ..., ringIndex: int = ...) -> QgsPointXY: ...
    def numberOfVertices(self) -> int: ...
    def size(self) -> int: ...
    def setTranslationOffset(self, dx: float, dy: float) -> None: ...
    @overload
    def addGeometry(self, geometry: QgsGeometry, layer: QgsVectorLayer, doUpdate: bool = ...) -> None: ...
    @overload
    def addGeometry(self, geometry: QgsGeometry, crs: QgsCoordinateReferenceSystem = ..., doUpdate: bool = ...) -> None: ...
    def setToCanvasRectangle(self, rect: QtCore.QRect) -> None: ...
    @overload
    def setToGeometry(self, geom: QgsGeometry, layer: QgsVectorLayer) -> None: ...
    @overload
    def setToGeometry(self, geometry: QgsGeometry, crs: QgsCoordinateReferenceSystem = ...) -> None: ...
    def partSize(self, geometryIndex: int) -> int: ...
    @overload
    def movePoint(self, p: QgsPointXY, geometryIndex: int = ..., ringIndex: int = ...) -> None: ...
    @overload
    def movePoint(self, index: int, p: QgsPointXY, geometryIndex: int = ..., ringIndex: int = ...) -> None: ...
    def removeLastPoint(self, geometryIndex: int = ..., doUpdate: bool = ..., ringIndex: int = ...) -> None: ...
    def removePoint(self, index: int = ..., doUpdate: bool = ..., geometryIndex: int = ..., ringIndex: int = ...) -> None: ...
    def closePoints(self, doUpdate: bool = ..., geometryIndex: int = ..., ringIndex: int = ...) -> None: ...
    def addPoint(self, p: QgsPointXY, doUpdate: bool = ..., geometryIndex: int = ..., ringIndex: int = ...) -> None: ...
    def reset(self, geometryType: QgsWkbTypes.GeometryType = ...) -> None: ...
    def setBrushStyle(self, brushStyle: QtCore.Qt.BrushStyle) -> None: ...
    def setLineStyle(self, penStyle: QtCore.Qt.PenStyle) -> None: ...
    def iconSize(self) -> int: ...
    def setIconSize(self, iconSize: int) -> None: ...
    def icon(self) -> 'QgsRubberBand.IconType': ...
    def setSvgIcon(self, path: str, drawOffset: QtCore.QPoint) -> None: ...
    def setIcon(self, icon: QgsRubberBand.IconType) -> None: ...
    def width(self) -> int: ...
    def setWidth(self, width: int) -> None: ...
    def secondaryStrokeColor(self) -> QtGui.QColor: ...
    def setSecondaryStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def strokeColor(self) -> QtGui.QColor: ...
    def setStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fillColor(self) -> QtGui.QColor: ...
    def setFillColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...


class QgsScaleComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showPopup(self) -> None: ...
    def setNull(self) -> None: ...
    def setMinScale(self, scale: float) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def updateScales(self, scales: Iterable[str] = ...) -> None: ...
    def scaleChanged(self, scale: float) -> None: ...
    def allowNull(self) -> bool: ...
    def setAllowNull(self, allowNull: bool) -> None: ...
    @staticmethod
    def toDouble(string: str) -> Tuple[float, bool]: ...
    @staticmethod
    def toString(scale: float) -> str: ...
    def minScale(self) -> float: ...
    def isNull(self) -> bool: ...
    def scale(self) -> float: ...
    def setScaleString(self, string: str) -> bool: ...
    def scaleString(self) -> str: ...


class QgsScaleRangeWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def rangeChanged(self, min: float, max: float) -> None: ...
    def setScaleRange(self, min: float, max: float) -> None: ...
    def setMaximumScale(self, scale: float) -> None: ...
    def setMinimumScale(self, scale: float) -> None: ...
    def reloadProjectScales(self) -> None: ...
    def maximumScale(self) -> float: ...
    def minimumScale(self) -> float: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...


class QgsScaleVisibilityDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., title: str = ..., mapCanvas: Optional[QgsMapCanvas] = ...) -> None: ...

    def setMaximumScale(self, scale: float) -> None: ...
    def setMinimumScale(self, scale: float) -> None: ...
    def setScaleVisiblity(self, hasScaleVisibility: bool) -> None: ...
    def maximumScale(self) -> float: ...
    def minimumScale(self) -> float: ...
    def hasScaleVisibility(self) -> bool: ...


class QgsScaleWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def scaleChanged(self, scale: float) -> None: ...
    def setNull(self) -> None: ...
    def setMinScale(self, scale: float) -> None: ...
    def setScaleFromCanvas(self) -> None: ...
    def updateScales(self, scales: Iterable[str] = ...) -> None: ...
    def setScale(self, scale: float) -> None: ...
    def allowNull(self) -> bool: ...
    def setAllowNull(self, allowNull: bool) -> None: ...
    @staticmethod
    def toDouble(scaleString: str) -> Tuple[float, bool]: ...
    @staticmethod
    def toString(scale: float) -> str: ...
    def minScale(self) -> float: ...
    def isNull(self) -> bool: ...
    def scale(self) -> float: ...
    def setScaleString(self, string: str) -> bool: ...
    def scaleString(self) -> str: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def showCurrentScaleButton(self) -> bool: ...
    def setShowCurrentScaleButton(self, showCurrentScaleButton: bool) -> None: ...


class QgsScrollArea(QtWidgets.QScrollArea):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def setVerticalOnly(self, verticalOnly: bool) -> None: ...
    def hasScrolled(self) -> bool: ...
    def scrollOccurred(self) -> None: ...


class QgsSearchQueryBuilder(QtWidgets.QDialog):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def loadQuery(self) -> None: ...
    def saveQuery(self) -> None: ...
    def setSearchString(self, searchString: str) -> None: ...
    def searchString(self) -> str: ...


class QgsSubsetStringEditorProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSubsetStringEditorProvider) -> None: ...

    def createDialog(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> QgsSubsetStringEditorInterface: ...
    def canHandleLayerStorageType(self, layer: QgsVectorLayer) -> bool: ...
    def canHandleLayer(self, layer: QgsVectorLayer) -> bool: ...
    def name(self) -> str: ...
    def providerKey(self) -> str: ...


class QgsSubsetStringEditorProviderRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def createDialog(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> QgsSubsetStringEditorInterface: ...
    def providersByKey(self, providerKey: str) -> List[QgsSubsetStringEditorProvider]: ...
    def providerByName(self, name: str) -> QgsSubsetStringEditorProvider: ...
    def initializeFromProviderGuiRegistry(self, providerGuiRegistry: QgsProviderGuiRegistry) -> None: ...
    def removeProvider(self, provider: QgsSubsetStringEditorProvider) -> bool: ...
    def addProvider(self, provider: QgsSubsetStringEditorProvider) -> None: ...
    def providers(self) -> List[QgsSubsetStringEditorProvider]: ...


class QgsShortcutsManager(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ..., settingsRoot: str = ...) -> None: ...

    def settingsPath(self) -> str: ...
    def shortcutByName(self, name: str) -> QtWidgets.QShortcut: ...
    def actionByName(self, name: str) -> QtWidgets.QAction: ...
    def shortcutForSequence(self, sequence: Union[QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int]) -> QtWidgets.QShortcut: ...
    def actionForSequence(self, sequence: Union[QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int]) -> QtWidgets.QAction: ...
    def objectForSequence(self, sequence: Union[QtGui.QKeySequence, QtGui.QKeySequence.StandardKey, str, int]) -> QtCore.QObject: ...
    def setObjectKeySequence(self, object: QtCore.QObject, sequence: str) -> bool: ...
    @overload
    def setKeySequence(self, name: str, sequence: str) -> bool: ...
    @overload
    def setKeySequence(self, action: QtWidgets.QAction, sequence: str) -> bool: ...
    @overload
    def setKeySequence(self, shortcut: QtWidgets.QShortcut, sequence: str) -> bool: ...
    @overload
    def defaultKeySequence(self, action: QtWidgets.QAction) -> str: ...
    @overload
    def defaultKeySequence(self, shortcut: QtWidgets.QShortcut) -> str: ...
    def objectDefaultKeySequence(self, object: QtCore.QObject) -> str: ...
    def listAll(self) -> List[QtCore.QObject]: ...
    def listShortcuts(self) -> List[QtWidgets.QShortcut]: ...
    def listActions(self) -> List[QtWidgets.QAction]: ...
    def unregisterShortcut(self, shortcut: QtWidgets.QShortcut) -> bool: ...
    def unregisterAction(self, action: QtWidgets.QAction) -> bool: ...
    def registerShortcut(self, shortcut: QtWidgets.QShortcut, defaultSequence: str = ...) -> bool: ...
    def registerAction(self, action: QtWidgets.QAction, defaultShortcut: str = ...) -> bool: ...
    def registerAllChildShortcuts(self, object: QtCore.QObject, recursive: bool = ...) -> None: ...
    def registerAllChildActions(self, object: QtCore.QObject, recursive: bool = ...) -> None: ...
    def registerAllChildren(self, object: QtCore.QObject, recursive: bool = ...) -> None: ...


class QgsSlider(QtWidgets.QSlider):

    @overload
    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, orientation: QtCore.Qt.Orientation, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def valueChanged(self, a0: typing.Any) -> None: ...
    def variantValue(self) -> typing.Any: ...
    def setValue(self, value: typing.Any) -> None: ...
    def setSingleStep(self, step: typing.Any) -> None: ...
    def setMaximum(self, max: typing.Any) -> None: ...
    def setMinimum(self, min: typing.Any) -> None: ...


class QgsSnapIndicator(sip.wrapper):

    def __init__(self, canvas: QgsMapCanvas) -> None: ...

    def isVisible(self) -> bool: ...
    def setVisible(self, visible: bool = ...) -> None: ...
    def match(self) -> QgsPointLocator.Match: ...
    def setMatch(self, match: QgsPointLocator.Match) -> None: ...


class QgsSnapToGridCanvasItem(QgsMapCanvasItem):

    def __init__(self, mapCanvas: QgsMapCanvas) -> None: ...

    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setPrecision(self, precision: float) -> None: ...
    def precision(self) -> float: ...
    def setPoint(self, point: QgsPointXY) -> None: ...
    def point(self) -> QgsPointXY: ...
    def paint(self, painter: QtGui.QPainter) -> None: ...


class QgsSourceSelectProvider(sip.wrapper):

    class Ordering(int): ...
    OrderLocalProvider: QgsSourceSelectProvider.Ordering = ...
    OrderDatabaseProvider: QgsSourceSelectProvider.Ordering = ...
    OrderRemoteProvider: QgsSourceSelectProvider.Ordering = ...
    OrderGeoCmsProvider: QgsSourceSelectProvider.Ordering = ...
    OrderOtherProvider: QgsSourceSelectProvider.Ordering = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSourceSelectProvider) -> None: ...

    def createDataSourceWidget(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., widgetMode: QgsProviderRegistry.WidgetMode = ...) -> QgsAbstractDataSourceWidget: ...
    def ordering(self) -> int: ...
    def icon(self) -> QtGui.QIcon: ...
    def toolTip(self) -> str: ...
    def text(self) -> str: ...
    def name(self) -> str: ...
    def providerKey(self) -> str: ...


class QgsSourceSelectProviderRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def createSelectionWidget(self, name: str, parent: QtWidgets.QWidget, fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType], widgetMode: QgsProviderRegistry.WidgetMode) -> QgsAbstractDataSourceWidget: ...
    def providersByKey(self, providerKey: str) -> List[QgsSourceSelectProvider]: ...
    def providerByName(self, name: str) -> QgsSourceSelectProvider: ...
    def initializeFromProviderGuiRegistry(self, providerGuiRegistry: QgsProviderGuiRegistry) -> None: ...
    def removeProvider(self, provider: QgsSourceSelectProvider) -> bool: ...
    def addProvider(self, provider: QgsSourceSelectProvider) -> None: ...
    def providers(self) -> List[QgsSourceSelectProvider]: ...


class QgsStatusBar(QtWidgets.QWidget):

    class Anchor(int): ...
    AnchorLeft: QgsStatusBar.Anchor = ...
    AnchorRight: QgsStatusBar.Anchor = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def setParentStatusBar(self, statusBar: QtWidgets.QStatusBar) -> None: ...
    def clearMessage(self) -> None: ...
    def showMessage(self, message: str, timeout: int = ...) -> None: ...
    def currentMessage(self) -> str: ...
    def removeWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def addPermanentWidget(self, widget: QtWidgets.QWidget, stretch: int = ..., anchor: QgsStatusBar.Anchor = ...) -> None: ...


class QgsStyleItemsListWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...

    def saveEntity(self) -> None: ...
    def selectionChanged(self, name: str, type: QgsStyle.StyleEntity) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def currentEntityType(self) -> QgsStyle.StyleEntity: ...
    def currentItemName(self) -> str: ...
    def currentTagFilter(self) -> str: ...
    def setLayerType(self, type: QgsWkbTypes.GeometryType) -> None: ...
    def setSymbolType(self, type: Qgis.SymbolType) -> None: ...
    def setEntityType(self, type: QgsStyle.StyleEntity) -> None: ...
    def setStyle(self, style: QgsStyle) -> None: ...


class QgsSublayersDialog(QtWidgets.QDialog):

    class ProviderType(int): ...
    Ogr: QgsSublayersDialog.ProviderType = ...
    Gdal: QgsSublayersDialog.ProviderType = ...
    Vsifile: QgsSublayersDialog.ProviderType = ...
    Mdal: QgsSublayersDialog.ProviderType = ...

    class PromptMode(int): ...
    PromptAlways: QgsSublayersDialog.PromptMode = ...
    PromptIfNeeded: QgsSublayersDialog.PromptMode = ...
    PromptNever: QgsSublayersDialog.PromptMode = ...
    PromptLoadAll: QgsSublayersDialog.PromptMode = ...

    class LayerDefinition(sip.wrapper):

        count: int = ...
        description: str = ...
        layerId: int = ...
        layerName: str = ...
        type: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsSublayersDialog.LayerDefinition) -> None: ...

    def __init__(self, providerType: QgsSublayersDialog.ProviderType, name: str, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., dataSourceUri: str = ...) -> None: ...

    def exec(self) -> int: ...
    def countColumn(self) -> int: ...
    def addToGroupCheckbox(self) -> bool: ...
    def showAddToGroupCheckbox(self) -> bool: ...
    def setShowAddToGroupCheckbox(self, showAddToGroupCheckbox: bool) -> None: ...
    def selection(self) -> List[QgsSublayersDialog.LayerDefinition]: ...
    def populateLayerTable(self, list: Iterable[QgsSublayersDialog.LayerDefinition]) -> None: ...


class QgsSubstitutionListWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def substitutionsChanged(self, substitutions: QgsStringReplacementCollection) -> None: ...
    def substitutions(self) -> QgsStringReplacementCollection: ...
    def setSubstitutions(self, substitutions: QgsStringReplacementCollection) -> None: ...


class QgsSubstitutionListDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def substitutions(self) -> QgsStringReplacementCollection: ...
    def setSubstitutions(self, substitutions: QgsStringReplacementCollection) -> None: ...


class QgsSymbolButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., dialogTitle: str = ...) -> None: ...

    def dropEvent(self, e: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, e: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, e: QtGui.QMouseEvent) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def changeEvent(self, e: QtCore.QEvent) -> None: ...
    def changed(self) -> None: ...
    def pasteColor(self) -> None: ...
    def copyColor(self) -> None: ...
    def pasteSymbol(self) -> None: ...
    def copySymbol(self) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setSymbol(self, symbol: QgsSymbol) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def symbol(self) -> QgsSymbol: ...
    def dialogTitle(self) -> str: ...
    def setDialogTitle(self, title: str) -> None: ...
    def symbolType(self) -> Qgis.SymbolType: ...
    def setSymbolType(self, type: Qgis.SymbolType) -> None: ...
    def sizeHint(self) -> QtCore.QSize: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsTableWidgetItem(QtWidgets.QTableWidgetItem):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, text: str) -> None: ...
    @overload
    def __init__(self, a0: QgsTableWidgetItem) -> None: ...

    def sortRole(self) -> int: ...
    def setSortRole(self, role: int) -> None: ...


class QgsTabWidget(QtWidgets.QTabWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def tabRemoved(self, index: int) -> None: ...
    def tabInserted(self, index: int) -> None: ...
    def realTabIndex(self, widget: QtWidgets.QWidget) -> int: ...
    def setTabVisible(self, tab: QtWidgets.QWidget, visible: bool) -> None: ...
    def showTab(self, tab: QtWidgets.QWidget) -> None: ...
    def hideTab(self, tab: QtWidgets.QWidget) -> None: ...


class QgsTaskManagerWidget(QtWidgets.QWidget):

    def __init__(self, manager: QgsTaskManager, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsTemporalControllerWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def temporalController(self) -> QgsTemporalNavigationObject: ...


class QgsTextFormatWidget(QtWidgets.QWidget, QgsExpressionContextGenerator):

    class Mode(int): ...
    Text: QgsTextFormatWidget.Mode = ...
    Labeling: QgsTextFormatWidget.Mode = ...

    @overload
    def __init__(self, format: QgsTextFormat = ..., mapCanvas: Optional[QgsMapCanvas] = ..., parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsVectorLayer] = ...) -> None: ...
    @overload
    def __init__(self, mapCanvas: QgsMapCanvas, parent: QtWidgets.QWidget, mode: QgsTextFormatWidget.Mode, layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def updatePreview(self) -> None: ...
    def saveFormat(self) -> None: ...
    def setFormatFromStyle(self, name: str, type: QgsStyle.StyleEntity) -> None: ...
    def updatePlacementWidgets(self) -> None: ...
    def updateLinePlacementOptions(self) -> None: ...
    def labelGeometryType(self) -> QgsWkbTypes.GeometryType: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def enableDataDefinedAlignment(self, enable: bool) -> None: ...
    def setPreviewBackground(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def updateWidgetForFormat(self, format: QgsTextFormat) -> None: ...
    def auxiliaryFieldCreated(self) -> None: ...
    def widgetChanged(self) -> None: ...
    def setDockMode(self, enabled: bool) -> None: ...
    def deactivateField(self, key: QgsPalLayerSettings.Property) -> None: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def setFormat(self, format: QgsTextFormat) -> None: ...
    def format(self, includeDataDefinedProperties: bool = ...) -> QgsTextFormat: ...


class QgsTextFormatDialog(QtWidgets.QDialog):

    def __init__(self, format: QgsTextFormat, mapCanvas: Optional[QgsMapCanvas] = ..., parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def format(self) -> QgsTextFormat: ...


class QgsTextFormatPanelWidget(QgsPanelWidgetWrapper):

    def __init__(self, format: QgsTextFormat, mapCanvas: Optional[QgsMapCanvas] = ..., parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def setDockMode(self, dockMode: bool) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def setFormat(self, format: QgsTextFormat) -> None: ...
    def format(self) -> QgsTextFormat: ...


class QgsTextPreview(QtWidgets.QLabel):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def mapUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def setMapUnits(self, unit: QgsUnitTypes.DistanceUnit) -> None: ...
    def scale(self) -> float: ...
    def setScale(self, scale: float) -> None: ...
    def format(self) -> QgsTextFormat: ...
    def setFormat(self, format: QgsTextFormat) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...


class QgsTreeWidgetItem(QtWidgets.QTreeWidgetItem):

    @overload
    def __init__(self, view: QtWidgets.QTreeWidget, type: int = ...) -> None: ...
    @overload
    def __init__(self, type: int = ...) -> None: ...
    @overload
    def __init__(self, strings: Iterable[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, view: QtWidgets.QTreeWidget, strings: Iterable[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, view: QtWidgets.QTreeWidget, after: QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QtWidgets.QTreeWidgetItem, strings: Iterable[str], type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QtWidgets.QTreeWidgetItem, after: QtWidgets.QTreeWidgetItem, type: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsTreeWidgetItem) -> None: ...

    def alwaysOnTopPriority(self) -> int: ...
    def setAlwaysOnTopPriority(self, priority: int) -> None: ...
    def sortData(self, column: int) -> typing.Any: ...
    def setSortData(self, column: int, value: typing.Any) -> None: ...


class QgsTreeWidgetItemObject(QtCore.QObject, QgsTreeWidgetItem):

    @overload
    def __init__(self, type: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QtWidgets.QTreeWidget, type: int = ...) -> None: ...

    def itemEdited(self, item: QtWidgets.QTreeWidgetItem, column: int) -> None: ...
    def setData(self, column: int, role: int, value: typing.Any) -> None: ...


class QgsMapUnitScaleWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def mapUnitScaleChanged(self, scale: QgsMapUnitScale) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def setMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def mapUnitScale(self) -> QgsMapUnitScale: ...


class QgsMapUnitScaleDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def setMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def getMapUnitScale(self) -> QgsMapUnitScale: ...


class QgsUnitSelectionWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def setMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def getMapUnitScale(self) -> QgsMapUnitScale: ...
    def setUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setUnitIndex(self, unitIndex: int) -> None: ...
    def unit(self) -> QgsUnitTypes.RenderUnit: ...
    def getUnit(self) -> int: ...
    @overload
    def setUnits(self, units: Iterable[str], mapUnitIdx: int) -> None: ...
    @overload
    def setUnits(self, units: Iterable[QgsUnitTypes.RenderUnit]) -> None: ...


class QgsUserInputWidget(QgsFloatingWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def addUserInputWidget(self, widget: QtWidgets.QWidget) -> None: ...


class QgsValidityCheckResultsModel(QtCore.QAbstractItemModel):

    class Roles(int): ...
    DescriptionRole: QgsValidityCheckResultsModel.Roles = ...

    def __init__(self, results: Iterable[QgsValidityCheckResult], parent: Optional[QtCore.QObject] = ...) -> None: ...

    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...


class QgsValidityCheckResultsWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...

    @staticmethod
    def runChecks(type: int, context: QgsValidityCheckContext, title: str, description: str, parent: Optional[QtWidgets.QWidget] = ...) -> bool: ...
    def setResults(self, results: Iterable[QgsValidityCheckResult]) -> None: ...
    def setDescription(self, description: str) -> None: ...


class QgsVariableEditorWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def scopeChanged(self) -> None: ...
    def reloadContext(self) -> None: ...
    def variablesInActiveScope(self) -> Dict[str, typing.Any]: ...
    def settingGroup(self) -> str: ...
    def setSettingGroup(self, group: str) -> None: ...
    def editableScope(self) -> QgsExpressionContextScope: ...
    def setEditableScopeIndex(self, scopeIndex: int) -> None: ...
    def context(self) -> QgsExpressionContext: ...
    def setContext(self, context: QgsExpressionContext) -> None: ...


class QgsVectorLayerTemporalPropertiesWidget(QtWidgets.QWidget, QgsExpressionContextGenerator):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def syncToLayer(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def saveTemporalProperties(self) -> None: ...


class QgsVertexMarker(QgsMapCanvasItem):

    class IconType(int): ...
    ICON_NONE: QgsVertexMarker.IconType = ...
    ICON_CROSS: QgsVertexMarker.IconType = ...
    ICON_X: QgsVertexMarker.IconType = ...
    ICON_BOX: QgsVertexMarker.IconType = ...
    ICON_CIRCLE: QgsVertexMarker.IconType = ...
    ICON_DOUBLE_TRIANGLE: QgsVertexMarker.IconType = ...
    ICON_TRIANGLE: QgsVertexMarker.IconType = ...
    ICON_RHOMBUS: QgsVertexMarker.IconType = ...
    ICON_INVERTED_TRIANGLE: QgsVertexMarker.IconType = ...

    def __init__(self, mapCanvas: QgsMapCanvas) -> None: ...

    def updatePosition(self) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def paint(self, p: QtGui.QPainter) -> None: ...
    def setPenWidth(self, width: int) -> None: ...
    def fillColor(self) -> QtGui.QColor: ...
    def setFillColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setIconSize(self, iconSize: int) -> None: ...
    def setIconType(self, iconType: int) -> None: ...
    def center(self) -> QgsPointXY: ...
    def setCenter(self, point: QgsPointXY) -> None: ...


class QgsVScrollArea(QgsScrollArea):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def eventFilter(self, o: QtCore.QObject, e: QtCore.QEvent) -> bool: ...


class QgsWindowManagerInterface(sip.wrapper):

    class StandardDialog(int): ...
    DialogStyleManager: QgsWindowManagerInterface.StandardDialog = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsWindowManagerInterface) -> None: ...

    def openStandardDialog(self, dialog: QgsWindowManagerInterface.StandardDialog) -> QtWidgets.QWidget: ...


class QgsAttributeTableDelegate(QtWidgets.QItemDelegate):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def actionColumnItemPainted(self, index: QtCore.QModelIndex) -> None: ...
    def setFeatureSelectionModel(self, featureSelectionModel: QgsFeatureSelectionModel) -> None: ...
    def setEditorData(self, editor: QtWidgets.QWidget, index: QtCore.QModelIndex) -> None: ...
    def setModelData(self, editor: QtWidgets.QWidget, model: QtCore.QAbstractItemModel, index: QtCore.QModelIndex) -> None: ...
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def createEditor(self, parent: QtWidgets.QWidget, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtWidgets.QWidget: ...


class QgsFeatureModel(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureModel) -> None: ...

    def fidToIndex(self, fid: int) -> QtCore.QModelIndex: ...


class QgsAttributeTableFilterModel(QtCore.QSortFilterProxyModel, QgsFeatureModel):

    class Role(int): ...
    TypeRole: QgsAttributeTableFilterModel.Role = ...

    class ColumnType(int): ...
    ColumnTypeField: QgsAttributeTableFilterModel.ColumnType = ...
    ColumnTypeActionButton: QgsAttributeTableFilterModel.ColumnType = ...

    class FilterMode(int): ...
    ShowAll: QgsAttributeTableFilterModel.FilterMode = ...
    ShowSelected: QgsAttributeTableFilterModel.FilterMode = ...
    ShowVisible: QgsAttributeTableFilterModel.FilterMode = ...
    ShowFilteredList: QgsAttributeTableFilterModel.FilterMode = ...
    ShowEdited: QgsAttributeTableFilterModel.FilterMode = ...

    def __init__(self, canvas: QgsMapCanvas, sourceModel: QgsAttributeTableModel, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def filterFeatures(self) -> None: ...
    def extentsChanged(self) -> None: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def generateListOfVisibleFeatures(self) -> None: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def filterError(self, errorMessage: str) -> None: ...
    def visibleReloaded(self) -> None: ...
    def featuresFiltered(self) -> None: ...
    def sortColumnChanged(self, column: int, order: QtCore.Qt.SortOrder) -> None: ...
    def setFilterExpression(self, expression: QgsExpression, context: QgsExpressionContext) -> None: ...
    def setAttributeTableConfig(self, config: QgsAttributeTableConfig) -> None: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def actionColumnIndex(self) -> int: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def sortExpression(self) -> str: ...
    @overload
    def sort(self, column: int, order: QtCore.Qt.SortOrder = ...) -> None: ...
    @overload
    def sort(self, expression: str, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def mapFromSource(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapFromMaster(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToMaster(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def fidToIndexList(self, fid: int) -> List[QtCore.QModelIndex]: ...
    def fidToIndex(self, fid: int) -> QtCore.QModelIndex: ...
    def rowToId(self, row: QtCore.QModelIndex) -> int: ...
    def masterModel(self) -> QgsAttributeTableModel: ...
    def layerCache(self) -> QgsVectorLayerCache: ...
    def layer(self) -> QgsVectorLayer: ...
    def filterMode(self) -> 'QgsAttributeTableFilterModel.FilterMode': ...
    def connectFilterModeConnections(self, filterMode: QgsAttributeTableFilterModel.FilterMode) -> None: ...
    def disconnectFilterModeConnections(self) -> None: ...
    def setFilterMode(self, filterMode: QgsAttributeTableFilterModel.FilterMode) -> None: ...
    def filteredFeatures(self) -> typing.Any: ...
    def setFilteredFeatures(self, ids: typing.Any) -> None: ...
    def selectedOnTop(self) -> bool: ...
    def setSelectedOnTop(self, selectedOnTop: bool) -> None: ...
    def setSourceModel(self, sourceModel: QgsAttributeTableModel) -> None: ...


class QgsAttributeTableModel(QtCore.QAbstractTableModel):

    class Role(int): ...
    FeatureIdRole: QgsAttributeTableModel.Role = ...
    FieldIndexRole: QgsAttributeTableModel.Role = ...
    UserRole: QgsAttributeTableModel.Role = ...
    SortRole: QgsAttributeTableModel.Role = ...

    def __init__(self, layerCache: QgsVectorLayerCache, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def finished(self) -> None: ...
    def modelChanged(self) -> None: ...
    def fieldConditionalStyleChanged(self, fieldName: str) -> None: ...
    def loadLayer(self) -> None: ...
    def setExtraColumns(self, extraColumns: int) -> None: ...
    def extraColumns(self) -> int: ...
    def editorContext(self) -> QgsAttributeEditorContext: ...
    def setEditorContext(self, context: QgsAttributeEditorContext) -> None: ...
    def request(self) -> QgsFeatureRequest: ...
    def setRequest(self, request: QgsFeatureRequest) -> None: ...
    def sortCacheExpression(self, cacheIndex: int = ...) -> str: ...
    def prefetchSortData(self, expression: str, cacheIndex: int = ...) -> None: ...
    def prefetchColumnData(self, column: int) -> None: ...
    def feature(self, idx: QtCore.QModelIndex) -> QgsFeature: ...
    def executeMapLayerAction(self, action: QgsMapLayerAction, idx: QtCore.QModelIndex) -> None: ...
    def executeAction(self, action: QtCore.QUuid, idx: QtCore.QModelIndex) -> None: ...
    def layerCache(self) -> QgsVectorLayerCache: ...
    def layer(self) -> QgsVectorLayer: ...
    def swapRows(self, a: int, b: int) -> None: ...
    def rowToId(self, row: int) -> int: ...
    def fieldCol(self, idx: int) -> int: ...
    def fieldIdx(self, col: int) -> int: ...
    def idToIndexList(self, id: int) -> List[QtCore.QModelIndex]: ...
    def idToIndex(self, id: int) -> QtCore.QModelIndex: ...
    def idToRow(self, id: int) -> int: ...
    def resetModel(self) -> None: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def reload(self, index1: QtCore.QModelIndex, index2: QtCore.QModelIndex) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QgsAttributeTableView(QtWidgets.QTableView):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def _q_selectRow(self, row: int) -> None: ...
    def selectRow(self, row: int) -> None: ...
    def selectAll(self) -> None: ...
    @overload
    def repaintRequested(self, indexes: Iterable[QtCore.QModelIndex]) -> None: ...
    @overload
    def repaintRequested(self) -> None: ...
    def finished(self) -> None: ...
    def columnResized(self, column: int, width: int) -> None: ...
    def willShowContextMenu(self, menu: QtWidgets.QMenu, atIndex: QtCore.QModelIndex) -> None: ...
    def closeEvent(self, event: QtGui.QCloseEvent) -> None: ...
    def contextMenuEvent(self, event: QtGui.QContextMenuEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def scrollToFeature(self, fid: int, column: int = ...) -> None: ...
    def selectedFeaturesIds(self) -> typing.Any: ...
    def setAttributeTableConfig(self, config: QgsAttributeTableConfig) -> None: ...
    def eventFilter(self, object: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def setFeatureSelectionManager(self, featureSelectionManager: QgsIFeatureSelectionManager) -> None: ...
    def setModel(self, filterModel: QgsAttributeTableFilterModel) -> None: ...


class QgsDualView(QtWidgets.QStackedWidget):

    class FeatureListBrowsingAction(int): ...
    NoAction: QgsDualView.FeatureListBrowsingAction = ...
    PanToFeature: QgsDualView.FeatureListBrowsingAction = ...
    ZoomToFeature: QgsDualView.FeatureListBrowsingAction = ...

    class ViewMode(int): ...
    AttributeTable: QgsDualView.ViewMode = ...
    AttributeEditor: QgsDualView.ViewMode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def hideEvent(self, event: QtGui.QHideEvent) -> None: ...
    def showContextMenuExternally(self, menu: QgsActionMenu, fid: int) -> None: ...
    def formModeChanged(self, mode: QgsAttributeEditorContext.Mode) -> None: ...
    def filterExpressionSet(self, expression: str, type: QgsAttributeForm.FilterType) -> None: ...
    def filterChanged(self) -> None: ...
    def displayExpressionChanged(self, expression: str) -> None: ...
    def parentFormValueChanged(self, attribute: str, value: typing.Any) -> None: ...
    def cancelProgress(self) -> None: ...
    def copyCellContent(self) -> None: ...
    def toggleSearchMode(self, enabled: bool) -> None: ...
    def setMultiEditEnabled(self, enabled: bool) -> None: ...
    def openConditionalStyles(self) -> None: ...
    def saveEditChanges(self) -> bool: ...
    def setCurrentEditSelection(self, fids: typing.Any) -> None: ...
    def attributeTableConfig(self) -> QgsAttributeTableConfig: ...
    def sortExpression(self) -> str: ...
    def setSortExpression(self, sortExpression: str, sortOrder: QtCore.Qt.SortOrder = ...) -> None: ...
    def setAttributeTableConfig(self, config: QgsAttributeTableConfig) -> None: ...
    def tableView(self) -> QgsAttributeTableView: ...
    def setFeatureSelectionManager(self, featureSelectionManager: QgsIFeatureSelectionManager) -> None: ...
    def setRequest(self, request: QgsFeatureRequest) -> None: ...
    def masterModel(self) -> QgsAttributeTableModel: ...
    def filteredFeatures(self) -> typing.Any: ...
    def filterFeatures(self, filterExpression: QgsExpression, context: QgsExpressionContext) -> None: ...
    def setFilteredFeatures(self, filteredFeatures: typing.Any) -> None: ...
    def filteredFeatureCount(self) -> int: ...
    def featureCount(self) -> int: ...
    def setSelectedOnTop(self, selectedOnTop: bool) -> None: ...
    def filterMode(self) -> QgsAttributeTableFilterModel.FilterMode: ...
    def setFilterMode(self, filterMode: QgsAttributeTableFilterModel.FilterMode) -> None: ...
    def view(self) -> 'QgsDualView.ViewMode': ...
    def setView(self, view: QgsDualView.ViewMode) -> None: ...
    def init(self, layer: QgsVectorLayer, mapCanvas: QgsMapCanvas, request: QgsFeatureRequest = ..., context: QgsAttributeEditorContext = ..., loadFeatures: bool = ...) -> None: ...


class QgsAttributeTableAction(QtWidgets.QAction):

    def __init__(self, name: str, dualView: QgsDualView, action: QtCore.QUuid, fieldIdx: QtCore.QModelIndex) -> None: ...

    def featureForm(self) -> None: ...
    def execute(self) -> None: ...


class QgsAttributeTableMapLayerAction(QtWidgets.QAction):

    def __init__(self, name: str, dualView: QgsDualView, action: QgsMapLayerAction, fieldIdx: QtCore.QModelIndex) -> None: ...

    def execute(self) -> None: ...


class QgsFeatureListModel(QtCore.QSortFilterProxyModel, QgsFeatureModel):

    class Role(int): ...
    FeatureInfoRole: QgsFeatureListModel.Role = ...
    FeatureRole: QgsFeatureListModel.Role = ...

    class FeatureInfo(sip.wrapper):

        isEdited: bool = ...
        isNew: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsFeatureListModel.FeatureInfo) -> None: ...

    def __init__(self, sourceModel: QgsAttributeTableFilterModel, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def onEndInsertRows(self, parent: QtCore.QModelIndex, first: int, last: int) -> None: ...
    def onBeginInsertRows(self, parent: QtCore.QModelIndex, first: int, last: int) -> None: ...
    def onEndRemoveRows(self, parent: QtCore.QModelIndex, first: int, last: int) -> None: ...
    def onBeginRemoveRows(self, parent: QtCore.QModelIndex, first: int, last: int) -> None: ...
    def setSortByDisplayExpression(self, sortByDisplayExpression: bool, order: QtCore.Qt.SortOrder = ...) -> None: ...
    def sortByDisplayExpression(self) -> bool: ...
    def fidToIndexList(self, fid: int) -> List[QtCore.QModelIndex]: ...
    def fidToIndex(self, fid: int) -> QtCore.QModelIndex: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapSelectionToMaster(self, selection: QtCore.QItemSelection) -> QtCore.QItemSelection: ...
    def mapSelectionFromMaster(self, selection: QtCore.QItemSelection) -> QtCore.QItemSelection: ...
    def mapFromMaster(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToMaster(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapFromSource(self, sourceIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def mapToSource(self, proxyIndex: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def fidToIdx(self, fid: int) -> QtCore.QModelIndex: ...
    def idxToFid(self, index: QtCore.QModelIndex) -> int: ...
    def featureByIndex(self, index: QtCore.QModelIndex, feat: QgsFeature) -> bool: ...
    def displayExpression(self) -> str: ...
    def parserErrorString(self) -> str: ...
    def setDisplayExpression(self, expression: str) -> bool: ...
    def masterModel(self) -> QgsAttributeTableModel: ...
    def injectNull(self) -> bool: ...
    def setInjectNull(self, injectNull: bool) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def layerCache(self) -> QgsVectorLayerCache: ...
    def setSourceModel(self, sourceModel: QgsAttributeTableFilterModel) -> None: ...


class QgsFeatureListView(QtWidgets.QListView):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def editLastFeature(self) -> None: ...
    def editPreviousFeature(self) -> None: ...
    def editNextFeature(self) -> None: ...
    def editFirstFeature(self) -> None: ...
    @overload
    def repaintRequested(self, indexes: Iterable[QtCore.QModelIndex]) -> None: ...
    @overload
    def repaintRequested(self) -> None: ...
    def selectAll(self) -> None: ...
    @overload
    def setEditSelection(self, fids: typing.Any) -> None: ...
    @overload
    def setEditSelection(self, index: QtCore.QModelIndex, command: Union[QtCore.QItemSelectionModel.SelectionFlags, QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    def willShowContextMenu(self, menu: QgsActionMenu, atIndex: QtCore.QModelIndex) -> None: ...
    def displayExpressionChanged(self, expression: str) -> None: ...
    def currentEditSelectionProgressChanged(self, progress: int, count: int) -> None: ...
    def currentEditSelectionChanged(self, feat: QgsFeature) -> None: ...
    def contextMenuEvent(self, event: QtGui.QContextMenuEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def setFeatureSelectionManager(self, featureSelectionManager: QgsIFeatureSelectionManager) -> None: ...
    def setCurrentFeatureEdited(self, state: bool) -> None: ...
    def currentEditSelection(self) -> typing.Any: ...
    def parserErrorString(self) -> str: ...
    def displayExpression(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str) -> bool: ...
    def featureListModel(self) -> QgsFeatureListModel: ...
    def setModel(self, featureListModel: QgsFeatureListModel) -> None: ...
    def layerCache(self) -> QgsVectorLayerCache: ...


class QgsFeatureListViewDelegate(QtWidgets.QItemDelegate):

    class Element(int): ...
    EditElement: QgsFeatureListViewDelegate.Element = ...
    SelectionElement: QgsFeatureListViewDelegate.Element = ...

    ICON_SIZE: int = ...

    def __init__(self, listModel: QgsFeatureListModel, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> None: ...
    def sizeHint(self, option: QtWidgets.QStyleOptionViewItem, index: QtCore.QModelIndex) -> QtCore.QSize: ...
    def editButtonClicked(self, index: QtCore.QModelIndex) -> None: ...
    def setCurrentFeatureEdited(self, state: bool) -> None: ...
    def setFeatureSelectionModel(self, featureSelectionModel: QgsFeatureSelectionModel) -> None: ...
    def positionToElement(self, pos: QtCore.QPoint) -> 'QgsFeatureListViewDelegate.Element': ...
    def setEditSelectionModel(self, editSelectionModel: QtCore.QItemSelectionModel) -> None: ...


class QgsFeatureSelectionModel(QtCore.QItemSelectionModel):

    def __init__(self, model: QtCore.QAbstractItemModel, featureModel: QgsFeatureModel, featureSelectionHandler: QgsIFeatureSelectionManager, parent: QtCore.QObject) -> None: ...

    def setFeatureSelectionManager(self, featureSelectionManager: QgsIFeatureSelectionManager) -> None: ...
    def selectFeatures(self, selection: QtCore.QItemSelection, command: Union[QtCore.QItemSelectionModel.SelectionFlags, QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    @overload
    def select(self, index: QtCore.QModelIndex, command: Union[QtCore.QItemSelectionModel.SelectionFlags, QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    @overload
    def select(self, selection: QtCore.QItemSelection, command: Union[QtCore.QItemSelectionModel.SelectionFlags, QtCore.QItemSelectionModel.SelectionFlag]) -> None: ...
    @overload
    def requestRepaint(self, indexes: Iterable[QtCore.QModelIndex]) -> None: ...
    @overload
    def requestRepaint(self) -> None: ...
    @overload
    def isSelected(self, fid: int) -> bool: ...
    @overload
    def isSelected(self, index: QtCore.QModelIndex) -> bool: ...
    def enableSync(self, enable: bool) -> None: ...


class QgsFieldConditionalFormatWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def rulesUpdated(self, fieldName: str) -> None: ...
    @staticmethod
    def defaultPresets() -> List[QgsConditionalStyle]: ...
    def setPresets(self, styles: Iterable[QgsConditionalStyle]) -> None: ...
    def reset(self) -> None: ...
    def loadStyle(self, style: QgsConditionalStyle) -> None: ...
    def editStyle(self, index: int, style: QgsConditionalStyle) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def viewRules(self) -> None: ...


class QgsEditConditionalFormatRuleWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def canceled(self) -> None: ...
    def ruleDeleted(self) -> None: ...
    def ruleSaved(self) -> None: ...
    def setRule(self, rule: str) -> None: ...
    def currentStyle(self) -> QgsConditionalStyle: ...
    def loadStyle(self, style: QgsConditionalStyle) -> None: ...
    def setPresets(self, styles: Iterable[QgsConditionalStyle]) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...


class QgsIFeatureSelectionManager(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def selectionChanged(self, selected: typing.Any, deselected: typing.Any, clearAndSelect: bool) -> None: ...
    def selectedFeatureIds(self) -> typing.Any: ...
    def setSelectedFeatures(self, ids: typing.Any) -> None: ...
    def deselect(self, ids: typing.Any) -> None: ...
    def select(self, ids: typing.Any) -> None: ...
    def selectedFeatureCount(self) -> int: ...


class QgsOrganizeTableColumnsDialog(QtWidgets.QDialog):

    @overload
    def __init__(self, vl: QgsVectorLayer, config: QgsAttributeTableConfig, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...
    @overload
    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def hideAll(self) -> None: ...
    def showAll(self) -> None: ...
    def config(self) -> QgsAttributeTableConfig: ...


class QgsAuthAuthoritiesEditor(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, e: QtGui.QShowEvent) -> None: ...


class QgsAuthCertInfo(QtWidgets.QWidget):

    def __init__(self, cert: QtNetwork.QSslCertificate, manageCertTrust: bool = ..., parent: Optional[QtWidgets.QWidget] = ..., connectionCAs: Iterable[QtNetwork.QSslCertificate] = ...) -> None: ...

    def trustCacheRebuilt(self) -> bool: ...


class QgsAuthCertInfoDialog(QtWidgets.QDialog):

    def __init__(self, cert: QtNetwork.QSslCertificate, manageCertTrust: bool, parent: Optional[QtWidgets.QWidget] = ..., connectionCAs: Iterable[QtNetwork.QSslCertificate] = ...) -> None: ...

    def trustCacheRebuilt(self) -> bool: ...
    def certInfoWidget(self) -> QgsAuthCertInfo: ...


class QgsAuthCertEditors(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsAuthCertManager(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def certEditorsWidget(self) -> QgsAuthCertEditors: ...


class QgsAuthCertTrustPolicyComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., policy: QgsAuthCertUtils.CertTrustPolicy = ..., defaultpolicy: QgsAuthCertUtils.CertTrustPolicy = ...) -> None: ...

    def setDefaultTrustPolicy(self, defaultpolicy: QgsAuthCertUtils.CertTrustPolicy) -> None: ...
    def setTrustPolicy(self, policy: QgsAuthCertUtils.CertTrustPolicy) -> None: ...
    def trustPolicyForIndex(self, indx: int) -> QgsAuthCertUtils.CertTrustPolicy: ...
    def trustPolicy(self) -> QgsAuthCertUtils.CertTrustPolicy: ...


class QgsAuthConfigEditor(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., showUtilities: bool = ..., relayMessages: bool = ...) -> None: ...

    def setRelayMessages(self, relay: bool = ...) -> None: ...
    def setShowUtilitiesButton(self, show: bool = ...) -> None: ...
    def selectedAuthenticationConfigIds(self) -> List[str]: ...
    def toggleTitleVisibility(self, visible: bool) -> None: ...


class QgsAuthConfigSelect(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., dataprovider: str = ...) -> None: ...

    def clearMessage(self) -> None: ...
    def showMessage(self, msg: str) -> None: ...
    def selectedConfigIdRemoved(self, authcfg: str) -> None: ...
    def selectedConfigIdChanged(self, authcfg: str) -> None: ...
    def setDataProviderKey(self, key: str) -> None: ...
    def configId(self) -> str: ...
    def setConfigId(self, authcfg: str) -> None: ...


class QgsAuthConfigUriEdit(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., datauri: str = ..., dataprovider: str = ...) -> None: ...

    @staticmethod
    def hasConfigId(txt: str) -> bool: ...
    def dataSourceUri(self) -> str: ...
    def setDataSourceUri(self, datauri: str) -> None: ...


class QgsAuthMethodPlugins(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsAuthEditorWidgets(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsAuthIdentitiesEditor(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, e: QtGui.QShowEvent) -> None: ...


class QgsAuthImportCertDialog(QtWidgets.QDialog):

    class CertInput(int): ...
    AllInputs: QgsAuthImportCertDialog.CertInput = ...
    FileInput: QgsAuthImportCertDialog.CertInput = ...
    TextInput: QgsAuthImportCertDialog.CertInput = ...

    class CertFilter(int): ...
    NoFilter: QgsAuthImportCertDialog.CertFilter = ...
    CaFilter: QgsAuthImportCertDialog.CertFilter = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., filter: QgsAuthImportCertDialog.CertFilter = ..., input: QgsAuthImportCertDialog.CertInput = ...) -> None: ...

    def certTrustPolicy(self) -> QgsAuthCertUtils.CertTrustPolicy: ...
    def allowInvalidCerts(self) -> bool: ...
    def certTextToImport(self) -> str: ...
    def certFileToImport(self) -> str: ...
    def certificatesToImport(self) -> List[QtNetwork.QSslCertificate]: ...


class QgsAuthImportIdentityDialog(QtWidgets.QDialog):

    class Validity(int): ...
    Valid: QgsAuthImportIdentityDialog.Validity = ...
    Invalid: QgsAuthImportIdentityDialog.Validity = ...
    Unknown: QgsAuthImportIdentityDialog.Validity = ...

    class BundleTypes(int): ...
    PkiPaths: QgsAuthImportIdentityDialog.BundleTypes = ...
    PkiPkcs12: QgsAuthImportIdentityDialog.BundleTypes = ...

    class IdentityType(int): ...
    CertIdentity: QgsAuthImportIdentityDialog.IdentityType = ...

    def __init__(self, identitytype: QgsAuthImportIdentityDialog.IdentityType, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def pkiBundleToImport(self) -> QgsPkiBundle: ...
    def identityType(self) -> 'QgsAuthImportIdentityDialog.IdentityType': ...


class QgsAuthMethodEdit(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def clearConfig(self) -> None: ...
    def resetConfig(self) -> None: ...
    def loadConfig(self, configmap: Dict[str, str]) -> None: ...
    def validityChanged(self, valid: bool) -> None: ...
    def configMap(self) -> Dict[str, str]: ...
    def validateConfig(self) -> bool: ...


class QgsAuthServersEditor(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showEvent(self, e: QtGui.QShowEvent) -> None: ...


class QgsAuthSettingsWidget(QtWidgets.QWidget):

    class WarningType(int): ...
    ProjectFile: QgsAuthSettingsWidget.WarningType = ...
    UserSettings: QgsAuthSettingsWidget.WarningType = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., configId: str = ..., username: str = ..., password: str = ..., dataprovider: str = ...) -> None: ...

    def convertToEncrypted(self) -> bool: ...
    def configurationTabIsSelected(self) -> bool: ...
    def storeUsernameIsChecked(self) -> bool: ...
    def storePasswordIsChecked(self) -> bool: ...
    def setStorePasswordChecked(self, checked: bool) -> None: ...
    def setStoreUsernameChecked(self, checked: bool) -> None: ...
    def showStoreCheckboxes(self, enabled: bool) -> None: ...
    def btnConvertToEncryptedIsEnabled(self) -> bool: ...
    @staticmethod
    def formattedWarning(warning: QgsAuthSettingsWidget.WarningType) -> str: ...
    def dataprovider(self) -> str: ...
    def setDataprovider(self, dataprovider: str) -> None: ...
    def setConfigId(self, configId: str) -> None: ...
    def configId(self) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def password(self) -> str: ...
    def setUsername(self, username: str) -> None: ...
    def username(self) -> str: ...
    def setBasicText(self, basicText: str) -> None: ...
    def setWarningText(self, warningText: str) -> None: ...


class QgsAuthSslConfigWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., cert: QtNetwork.QSslCertificate = ..., hostport: str = ..., connectionCAs: Iterable[QtNetwork.QSslCertificate] = ...) -> None: ...

    def readyToSaveChanged(self, cansave: bool) -> None: ...
    def hostPortValidityChanged(self, valid: bool) -> None: ...
    def certFoundInAuthDatabase(self, found: bool) -> None: ...
    def configEnabledChanged(self, enabled: bool) -> None: ...
    def readyToSave(self) -> bool: ...
    def validateHostPortText(self, txt: str) -> None: ...
    def setConfigCheckable(self, checkable: bool) -> None: ...
    def setSslHost(self, host: str) -> None: ...
    def resetSslPeerVerify(self) -> None: ...
    def setSslPeerVerify(self, mode: QtNetwork.QSslSocket.PeerVerifyMode, modedepth: int) -> None: ...
    def resetSslIgnoreErrors(self) -> None: ...
    def setSslIgnoreErrors(self, errors: Iterable[QtNetwork.QSslError]) -> None: ...
    def setSslIgnoreErrorEnums(self, errorenums: typing.Any) -> None: ...
    def appendSslIgnoreErrors(self, errors: Iterable[QtNetwork.QSslError]) -> None: ...
    def resetSslProtocol(self) -> None: ...
    def setSslProtocol(self, protocol: QtNetwork.QSsl.SslProtocol) -> None: ...
    def resetSslCertConfig(self) -> None: ...
    def saveSslCertConfig(self) -> None: ...
    def loadSslCustomConfig(self, config: QgsAuthConfigSslServer = ...) -> None: ...
    def setSslCertificate(self, cert: QtNetwork.QSslCertificate, hostport: str = ...) -> None: ...
    def enableSslCustomOptions(self, enable: bool) -> None: ...
    def sslPeerVerifyDepth(self) -> int: ...
    def sslPeerVerifyMode(self) -> QtNetwork.QSslSocket.PeerVerifyMode: ...
    def sslIgnoreErrorEnums(self) -> typing.Any: ...
    def sslProtocol(self) -> QtNetwork.QSsl.SslProtocol: ...
    def sslHost(self) -> str: ...
    def sslCertificate(self) -> QtNetwork.QSslCertificate: ...
    def sslCustomConfig(self) -> QgsAuthConfigSslServer: ...
    def sslConfigGroupBox(self) -> QtWidgets.QGroupBox: ...
    def certificateGroupBox(self) -> QtWidgets.QGroupBox: ...


class QgsAuthSslConfigDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., cert: QtNetwork.QSslCertificate = ..., hostport: str = ...) -> None: ...

    def accept(self) -> None: ...
    def sslCustomConfigWidget(self) -> QgsAuthSslConfigWidget: ...


class QgsAuthSslErrorsDialog(QtWidgets.QDialog):

    def __init__(self, reply: QtNetwork.QNetworkReply, sslErrors: Iterable[QtNetwork.QSslError], parent: Optional[QtWidgets.QWidget] = ..., digest: str = ..., hostport: str = ...) -> None: ...


class QgsAuthSslImportDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def accept(self) -> None: ...


class QgsAuthTrustedCAsDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., trustedCAs: Iterable[QtNetwork.QSslCertificate] = ...) -> None: ...

    def showEvent(self, e: QtGui.QShowEvent) -> None: ...


class QgsCalloutWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget, vl: Optional[QgsVectorLayer] = ...) -> None: ...

    def changed(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def registerDataDefinedButton(self, button: QgsPropertyOverrideButton, key: QgsCallout.Property) -> None: ...
    def setGeometryType(self, type: QgsWkbTypes.GeometryType) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def callout(self) -> QgsCallout: ...
    def setCallout(self, callout: QgsCallout) -> None: ...


class QgsCodeEditor(Qsci.QsciScintilla):

    class MarginRole(int): ...
    LineNumbers: QgsCodeEditor.MarginRole = ...
    ErrorIndicators: QgsCodeEditor.MarginRole = ...
    FoldingControls: QgsCodeEditor.MarginRole = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., title: str = ..., folding: bool = ..., margin: bool = ...) -> None: ...

    def runPostLexerConfigurationTasks(self) -> None: ...
    def lexerFont(self) -> QtGui.QFont: ...
    def lexerColor(self, role: QgsCodeEditorColorScheme.ColorRole) -> QtGui.QColor: ...
    def initializeLexer(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def isFixedPitch(self, font: QtGui.QFont) -> bool: ...
    def clearWarnings(self) -> None: ...
    def addWarning(self, lineNumber: int, warning: str) -> None: ...
    @staticmethod
    def getMonospaceFont() -> QtGui.QFont: ...
    @staticmethod
    def setColor(role: QgsCodeEditorColorScheme.ColorRole, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @staticmethod
    def color(role: QgsCodeEditorColorScheme.ColorRole) -> QtGui.QColor: ...
    @staticmethod
    def defaultColor(role: QgsCodeEditorColorScheme.ColorRole, theme: str = ...) -> QtGui.QColor: ...
    def insertText(self, text: str) -> None: ...
    def foldingVisible(self) -> bool: ...
    def setFoldingVisible(self, folding: bool) -> None: ...
    def lineNumbersVisible(self) -> bool: ...
    def setLineNumbersVisible(self, visible: bool) -> None: ...
    def marginVisible(self) -> bool: ...
    def setMarginVisible(self, margin: bool) -> None: ...
    def setTitle(self, title: str) -> None: ...


class QgsCodeEditorColorScheme(sip.wrapper):

    class ColorRole(int): ...
    Default: QgsCodeEditorColorScheme.ColorRole = ...
    Keyword: QgsCodeEditorColorScheme.ColorRole = ...
    Class: QgsCodeEditorColorScheme.ColorRole = ...
    Method: QgsCodeEditorColorScheme.ColorRole = ...
    Decoration: QgsCodeEditorColorScheme.ColorRole = ...
    Number: QgsCodeEditorColorScheme.ColorRole = ...
    Comment: QgsCodeEditorColorScheme.ColorRole = ...
    CommentLine: QgsCodeEditorColorScheme.ColorRole = ...
    CommentBlock: QgsCodeEditorColorScheme.ColorRole = ...
    Background: QgsCodeEditorColorScheme.ColorRole = ...
    Cursor: QgsCodeEditorColorScheme.ColorRole = ...
    CaretLine: QgsCodeEditorColorScheme.ColorRole = ...
    SingleQuote: QgsCodeEditorColorScheme.ColorRole = ...
    DoubleQuote: QgsCodeEditorColorScheme.ColorRole = ...
    TripleSingleQuote: QgsCodeEditorColorScheme.ColorRole = ...
    TripleDoubleQuote: QgsCodeEditorColorScheme.ColorRole = ...
    Operator: QgsCodeEditorColorScheme.ColorRole = ...
    QuotedOperator: QgsCodeEditorColorScheme.ColorRole = ...
    Identifier: QgsCodeEditorColorScheme.ColorRole = ...
    QuotedIdentifier: QgsCodeEditorColorScheme.ColorRole = ...
    Tag: QgsCodeEditorColorScheme.ColorRole = ...
    UnknownTag: QgsCodeEditorColorScheme.ColorRole = ...
    MarginBackground: QgsCodeEditorColorScheme.ColorRole = ...
    MarginForeground: QgsCodeEditorColorScheme.ColorRole = ...
    SelectionBackground: QgsCodeEditorColorScheme.ColorRole = ...
    SelectionForeground: QgsCodeEditorColorScheme.ColorRole = ...
    MatchedBraceBackground: QgsCodeEditorColorScheme.ColorRole = ...
    MatchedBraceForeground: QgsCodeEditorColorScheme.ColorRole = ...
    Edge: QgsCodeEditorColorScheme.ColorRole = ...
    Fold: QgsCodeEditorColorScheme.ColorRole = ...
    Error: QgsCodeEditorColorScheme.ColorRole = ...
    ErrorBackground: QgsCodeEditorColorScheme.ColorRole = ...
    FoldIconForeground: QgsCodeEditorColorScheme.ColorRole = ...
    FoldIconHalo: QgsCodeEditorColorScheme.ColorRole = ...
    IndentationGuide: QgsCodeEditorColorScheme.ColorRole = ...

    @overload
    def __init__(self, id: str = ..., name: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsCodeEditorColorScheme) -> None: ...

    def setColor(self, role: QgsCodeEditorColorScheme.ColorRole, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color(self, role: QgsCodeEditorColorScheme.ColorRole) -> QtGui.QColor: ...
    def name(self) -> str: ...
    def id(self) -> str: ...


class QgsCodeEditorColorSchemeRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCodeEditorColorSchemeRegistry) -> None: ...

    def scheme(self, id: str) -> QgsCodeEditorColorScheme: ...
    def schemes(self) -> List[str]: ...
    def removeColorScheme(self, id: str) -> bool: ...
    def addColorScheme(self, scheme: QgsCodeEditorColorScheme) -> bool: ...


class QgsCodeEditorCSS(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def initializeLexer(self) -> None: ...


class QgsCodeEditorExpression(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def initializeLexer(self) -> None: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...


class QgsCodeEditorHTML(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def initializeLexer(self) -> None: ...


class QgsCodeEditorJavascript(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def initializeLexer(self) -> None: ...


class QgsCodeEditorJson(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def initializeLexer(self) -> None: ...


class QgsCodeEditorPython(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., filenames: Iterable[str] = ...) -> None: ...

    def autoComplete(self) -> None: ...
    def initializeLexer(self) -> None: ...
    def searchSelectedTextInPyQGISDocs(self) -> None: ...
    def loadScript(self, script: str) -> bool: ...
    def loadAPIs(self, filenames: Iterable[str]) -> None: ...


class QgsCodeEditorSQL(QgsCodeEditor):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def initializeLexer(self) -> None: ...
    def setFields(self, fields: QgsFields) -> None: ...


class QgsDevToolWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsDevToolWidgetFactory(sip.wrapper):

    @overload
    def __init__(self, title: str = ..., icon: QtGui.QIcon = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsDevToolWidgetFactory) -> None: ...

    def createWidget(self, parent: Optional[QtWidgets.QWidget] = ...) -> QgsDevToolWidget: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsEditorConfigWidget(QtWidgets.QWidget, QgsExpressionContextGenerator):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: QtWidgets.QWidget) -> None: ...

    def updateDataDefinedButton(self, button: QgsPropertyOverrideButton) -> None: ...
    def updateDataDefinedButtons(self) -> None: ...
    def initializeDataDefinedButton(self, button: QgsPropertyOverrideButton, key: QgsWidgetWrapper.Property) -> None: ...
    def changed(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def layer(self) -> QgsVectorLayer: ...
    def field(self) -> int: ...
    def setConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def config(self) -> Dict[str, typing.Any]: ...


class QgsEditorWidgetAutoConfPlugin(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsEditorWidgetAutoConfPlugin) -> None: ...

    def editorWidgetSetup(self, vl: QgsVectorLayer, fieldName: str) -> Tuple[QgsEditorWidgetSetup, int]: ...


class QgsEditorWidgetFactory(sip.wrapper):

    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, a0: QgsEditorWidgetFactory) -> None: ...

    def fieldScore(self, vl: QgsVectorLayer, fieldIdx: int) -> int: ...
    def supportsField(self, vl: QgsVectorLayer, fieldIdx: int) -> bool: ...
    def configWidget(self, vl: QgsVectorLayer, fieldIdx: int, parent: QtWidgets.QWidget) -> QgsEditorConfigWidget: ...
    def name(self) -> str: ...
    def createSearchWidget(self, vl: QgsVectorLayer, fieldIdx: int, parent: QtWidgets.QWidget) -> QgsSearchWidgetWrapper: ...
    def create(self, vl: QgsVectorLayer, fieldIdx: int, editor: QtWidgets.QWidget, parent: QtWidgets.QWidget) -> QgsEditorWidgetWrapper: ...


class QgsEditorWidgetRegistry(QtCore.QObject):

    def __init__(self) -> None: ...

    def registerAutoConfPlugin(self, plugin: QgsEditorWidgetAutoConfPlugin) -> None: ...
    def registerWidget(self, widgetId: str, widgetFactory: QgsEditorWidgetFactory) -> bool: ...
    def factory(self, widgetId: str) -> QgsEditorWidgetFactory: ...
    def factories(self) -> typing.Any: ...
    def name(self, widgetId: str) -> str: ...
    def createConfigWidget(self, widgetId: str, vl: QgsVectorLayer, fieldIdx: int, parent: QtWidgets.QWidget) -> QgsEditorConfigWidget: ...
    def createSearchWidget(self, widgetId: str, vl: QgsVectorLayer, fieldIdx: int, config: Dict[str, typing.Any], parent: QtWidgets.QWidget) -> QgsSearchWidgetWrapper: ...
    @overload
    def create(self, widgetId: str, vl: QgsVectorLayer, fieldIdx: int, config: Dict[str, typing.Any], editor: QtWidgets.QWidget, parent: QtWidgets.QWidget) -> QgsEditorWidgetWrapper: ...
    @overload
    def create(self, vl: QgsVectorLayer, fieldIdx: int, editor: QtWidgets.QWidget, parent: QtWidgets.QWidget) -> QgsEditorWidgetWrapper: ...
    def findBest(self, vl: QgsVectorLayer, fieldName: str) -> QgsEditorWidgetSetup: ...
    def initEditors(self, mapCanvas: Optional[QgsMapCanvas] = ..., messageBar: Optional[QgsMessageBar] = ...) -> None: ...


class QgsWidgetWrapper(QtCore.QObject):

    class Property(int): ...
    RootPath: QgsWidgetWrapper.Property = ...
    DocumentViewerContent: QgsWidgetWrapper.Property = ...

    def __init__(self, vl: QgsVectorLayer, editor: Optional[QtWidgets.QWidget] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setEnabled(self, enabled: bool) -> None: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def contextChanged(self) -> None: ...
    def notifyAboutToSave(self) -> None: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def valid(self) -> bool: ...
    @staticmethod
    def fromWidget(widget: QtWidgets.QWidget) -> QgsWidgetWrapper: ...
    def layer(self) -> QgsVectorLayer: ...
    def context(self) -> QgsAttributeEditorContext: ...
    @overload
    def config(self, key: str, defaultVal: typing.Any = ...) -> typing.Any: ...
    @overload
    def config(self) -> Dict[str, typing.Any]: ...
    def setContext(self, context: QgsAttributeEditorContext) -> None: ...
    def setConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def widget(self) -> QtWidgets.QWidget: ...
    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...


class QgsEditorWidgetWrapper(QgsWidgetWrapper):

    class ConstraintResult(int): ...
    ConstraintResultPass: QgsEditorWidgetWrapper.ConstraintResult = ...
    ConstraintResultFailHard: QgsEditorWidgetWrapper.ConstraintResult = ...
    ConstraintResultFailSoft: QgsEditorWidgetWrapper.ConstraintResult = ...

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, editor: Optional[QtWidgets.QWidget] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setFormFeatureAttribute(self, attributeName: str, attributeValue: typing.Any) -> bool: ...
    def setFormFeature(self, feature: QgsFeature) -> None: ...
    def formFeature(self) -> QgsFeature: ...
    def updateConstraintWidgetStatus(self) -> None: ...
    def parentFormValueChanged(self, attribute: str, value: typing.Any) -> None: ...
    def emitValueChanged(self) -> None: ...
    def setValues(self, value: typing.Any, additionalValues: Iterable[typing.Any]) -> None: ...
    def setValue(self, value: typing.Any) -> None: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def constraintResultVisibleChanged(self, visible: bool) -> None: ...
    def constraintStatusChanged(self, constraint: str, desc: str, err: str, status: QgsEditorWidgetWrapper.ConstraintResult) -> None: ...
    def valuesChanged(self, value: typing.Any, additionalFieldValues: Iterable[typing.Any] = ...) -> None: ...
    def valueChanged(self, value: typing.Any) -> None: ...
    def setConstraintResultVisible(self, constraintResultVisible: bool) -> None: ...
    def constraintResultVisible(self) -> bool: ...
    def constraintResult(self) -> 'QgsEditorWidgetWrapper.ConstraintResult': ...
    def setHint(self, hintText: str) -> None: ...
    def constraintFailureReason(self) -> str: ...
    def isBlockingCommit(self) -> bool: ...
    def isValidConstraint(self) -> bool: ...
    @overload
    def updateConstraint(self, featureContext: QgsFeature, constraintOrigin: QgsFieldConstraints.ConstraintOrigin = ...) -> None: ...
    @overload
    def updateConstraint(self, layer: QgsVectorLayer, index: int, feature: QgsFeature, constraintOrigin: QgsFieldConstraints.ConstraintOrigin = ...) -> None: ...
    def showIndeterminateState(self) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    @staticmethod
    def isInTable(parent: QtWidgets.QWidget) -> bool: ...
    @staticmethod
    def fromWidget(widget: QtWidgets.QWidget) -> QgsEditorWidgetWrapper: ...
    def defaultValue(self) -> typing.Any: ...
    def field(self) -> QgsField: ...
    def fieldIdx(self) -> int: ...
    def additionalFieldValues(self) -> List[typing.Any]: ...
    def additionalFields(self) -> List[str]: ...
    def value(self) -> typing.Any: ...


class QgsSearchWidgetWrapper(QgsWidgetWrapper):

    class FilterFlag(int): ...
    EqualTo: QgsSearchWidgetWrapper.FilterFlag = ...
    NotEqualTo: QgsSearchWidgetWrapper.FilterFlag = ...
    GreaterThan: QgsSearchWidgetWrapper.FilterFlag = ...
    LessThan: QgsSearchWidgetWrapper.FilterFlag = ...
    GreaterThanOrEqualTo: QgsSearchWidgetWrapper.FilterFlag = ...
    LessThanOrEqualTo: QgsSearchWidgetWrapper.FilterFlag = ...
    Between: QgsSearchWidgetWrapper.FilterFlag = ...
    CaseInsensitive: QgsSearchWidgetWrapper.FilterFlag = ...
    Contains: QgsSearchWidgetWrapper.FilterFlag = ...
    DoesNotContain: QgsSearchWidgetWrapper.FilterFlag = ...
    IsNull: QgsSearchWidgetWrapper.FilterFlag = ...
    IsNotBetween: QgsSearchWidgetWrapper.FilterFlag = ...
    IsNotNull: QgsSearchWidgetWrapper.FilterFlag = ...
    StartsWith: QgsSearchWidgetWrapper.FilterFlag = ...
    EndsWith: QgsSearchWidgetWrapper.FilterFlag = ...

    class FilterFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsSearchWidgetWrapper.FilterFlags', 'QgsSearchWidgetWrapper.FilterFlag']) -> None: ...
        @overload
        def __init__(self, a0: QgsSearchWidgetWrapper.FilterFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsSearchWidgetWrapper.FilterFlags': ...
        def __int__(self) -> int: ...

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def clearExpression(self) -> None: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def setExpression(self, expression: str) -> None: ...
    def valueCleared(self) -> None: ...
    def valueChanged(self) -> None: ...
    def expressionChanged(self, exp: str) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def fieldIndex(self) -> int: ...
    def setAggregate(self, aggregate: str) -> None: ...
    def aggregate(self) -> str: ...
    def createFieldIdentifier(self) -> str: ...
    def createExpression(self, flags: Union['QgsSearchWidgetWrapper.FilterFlags', 'QgsSearchWidgetWrapper.FilterFlag']) -> str: ...
    def applyDirectly(self) -> bool: ...
    def expression(self) -> str: ...
    def defaultFlags(self) -> 'QgsSearchWidgetWrapper.FilterFlags': ...
    def supportedFlags(self) -> 'QgsSearchWidgetWrapper.FilterFlags': ...
    @staticmethod
    def toString(flag: QgsSearchWidgetWrapper.FilterFlag) -> str: ...
    @staticmethod
    def nonExclusiveFilterFlags() -> typing.Any: ...
    @staticmethod
    def exclusiveFilterFlags() -> typing.Any: ...


class QgsCheckboxSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setExpression(self, expression: str) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def createExpression(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> str: ...
    def defaultFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def supportedFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def valid(self) -> bool: ...
    def expression(self) -> str: ...
    def applyDirectly(self) -> bool: ...
    def value(self) -> typing.Any: ...


class QgsDateTimeEdit(QtWidgets.QDateTimeEdit):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def isNull(self) -> bool: ...
    def emitValueChanged(self, value: typing.Any) -> None: ...
    def displayNull(self, updateCalendar: bool = ...) -> None: ...
    def showEvent(self, event: QtGui.QShowEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def focusInEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def focusOutEvent(self, event: QtGui.QFocusEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def valueChanged(self, date: Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def setNullRepresentation(self, null: str) -> None: ...
    def nullRepresentation(self) -> str: ...
    def setEmpty(self) -> None: ...
    def clear(self) -> None: ...
    def date(self) -> QtCore.QDate: ...
    def time(self) -> QtCore.QTime: ...
    def dateTime(self) -> QtCore.QDateTime: ...
    def setDateTime(self, dateTime: Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def allowNull(self) -> bool: ...
    def setAllowNull(self, allowNull: bool) -> None: ...


class QgsTimeEdit(QgsDateTimeEdit):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def emitValueChanged(self, value: typing.Any) -> None: ...
    def timeValueChanged(self, time: Union[QtCore.QTime, datetime.time]) -> None: ...
    def setTime(self, time: Union[QtCore.QTime, datetime.time]) -> None: ...


class QgsDateEdit(QgsDateTimeEdit):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def emitValueChanged(self, value: typing.Any) -> None: ...
    def dateValueChanged(self, date: Union[QtCore.QDate, datetime.date]) -> None: ...
    def setDate(self, date: Union[QtCore.QDate, datetime.date]) -> None: ...


class QgsDateTimeSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setExpression(self, exp: str) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def createExpression(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> str: ...
    def defaultFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def supportedFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def valid(self) -> bool: ...
    def expression(self) -> str: ...
    def applyDirectly(self) -> bool: ...
    def value(self) -> typing.Any: ...


class QgsDefaultSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def caseSensitiveCheckBox(self) -> QtWidgets.QCheckBox: ...
    def lineEdit(self) -> QgsFilterLineEdit: ...
    def valid(self) -> bool: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def setExpression(self, exp: str) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def createExpression(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> str: ...
    def defaultFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def supportedFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def applyDirectly(self) -> bool: ...
    def expression(self) -> str: ...


class QgsDoubleSpinBox(QtWidgets.QDoubleSpinBox):

    class ClearValueMode(int): ...
    MinimumValue: QgsDoubleSpinBox.ClearValueMode = ...
    MaximumValue: QgsDoubleSpinBox.ClearValueMode = ...
    CustomValue: QgsDoubleSpinBox.ClearValueMode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def paintEvent(self, e: QtGui.QPaintEvent) -> None: ...
    def validate(self, input: str) -> Tuple[QtGui.QValidator.State, int]: ...
    def valueFromText(self, text: str) -> float: ...
    def setSpecialValueText(self, txt: str) -> None: ...
    def setLineEditAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def clearValue(self) -> float: ...
    def setClearValueMode(self, mode: QgsDoubleSpinBox.ClearValueMode, clearValueText: str = ...) -> None: ...
    def setClearValue(self, customValue: float, clearValueText: str = ...) -> None: ...
    def clear(self) -> None: ...
    def expressionsEnabled(self) -> bool: ...
    def setExpressionsEnabled(self, enabled: bool) -> None: ...
    def showClearButton(self) -> bool: ...
    def setShowClearButton(self, showClearButton: bool) -> None: ...


class QgsHtmlWidgetWrapper(QgsWidgetWrapper):

    def __init__(self, layer: QgsVectorLayer, editor: QtWidgets.QWidget, parent: QtWidgets.QWidget) -> None: ...

    def setFeature(self, feature: QgsFeature) -> None: ...
    def setHtmlCode(self, htmlCode: str) -> None: ...
    def reinitWidget(self) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def valid(self) -> bool: ...


class QgsJsonEditWidget(QtWidgets.QWidget):

    class FormatJson(int): ...
    Indented: QgsJsonEditWidget.FormatJson = ...
    Compact: QgsJsonEditWidget.FormatJson = ...
    Disabled: QgsJsonEditWidget.FormatJson = ...

    class View(int): ...
    Text: QgsJsonEditWidget.View = ...
    Tree: QgsJsonEditWidget.View = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setControlsVisible(self, visible: bool) -> None: ...
    def setFormatJsonMode(self, formatJson: QgsJsonEditWidget.FormatJson) -> None: ...
    def setView(self, view: QgsJsonEditWidget.View) -> None: ...
    def jsonText(self) -> str: ...
    def setJsonText(self, jsonText: str) -> None: ...


class QgsMultiEditToolButton(QtWidgets.QToolButton):

    class State(int): ...
    Default: QgsMultiEditToolButton.State = ...
    MixedValues: QgsMultiEditToolButton.State = ...
    Changed: QgsMultiEditToolButton.State = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resetFieldValueTriggered(self) -> None: ...
    def setFieldValueTriggered(self) -> None: ...
    def changesCommitted(self) -> None: ...
    def resetChanges(self) -> None: ...
    def setIsChanged(self, changed: bool) -> None: ...
    def setIsMixed(self, mixed: bool) -> None: ...
    def setField(self, field: QgsField) -> None: ...
    def state(self) -> 'QgsMultiEditToolButton.State': ...


class QgsRelationAggregateSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, layer: QgsVectorLayer, wrapper: QgsRelationWidgetWrapper, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def eventFilter(self, watched: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def setExpression(self, value: str) -> None: ...
    def applyDirectly(self) -> bool: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def valid(self) -> bool: ...
    def expression(self) -> str: ...


class QgsRelationReferenceSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setExpression(self, exp: str) -> None: ...
    def onValueChanged(self, value: typing.Any) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def createExpression(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> str: ...
    def defaultFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def supportedFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def valid(self) -> bool: ...
    def expression(self) -> str: ...
    def applyDirectly(self) -> bool: ...
    def value(self) -> typing.Any: ...


class QgsRelationReferenceWidget(QtWidgets.QWidget):

    class CanvasExtent(int): ...
    Fixed: QgsRelationReferenceWidget.CanvasExtent = ...
    Pan: QgsRelationReferenceWidget.CanvasExtent = ...
    Scale: QgsRelationReferenceWidget.CanvasExtent = ...

    def __init__(self, parent: QtWidgets.QWidget) -> None: ...

    def foreignKeysChanged(self, a0: Iterable[typing.Any]) -> None: ...
    def foreignKeyChanged(self, a0: typing.Any) -> None: ...
    def init(self) -> None: ...
    def showEvent(self, e: QtGui.QShowEvent) -> None: ...
    def deleteForeignKeys(self) -> None: ...
    def mapIdentification(self) -> None: ...
    def openForm(self) -> None: ...
    def setReferencedLayerName(self, referencedLayerName: str) -> None: ...
    def referencedLayerName(self) -> str: ...
    def setReferencedLayerId(self, referencedLayerId: str) -> None: ...
    def referencedLayerId(self) -> str: ...
    def setReferencedLayerProviderKey(self, referencedLayerProviderKey: str) -> None: ...
    def referencedLayerProviderKey(self) -> str: ...
    def setReferencedLayerDataSource(self, referencedLayerDataSource: str) -> None: ...
    def referencedLayerDataSource(self) -> str: ...
    def setFormFeature(self, formFeature: QgsFeature) -> None: ...
    def relation(self) -> QgsRelation: ...
    def setAllowAddFeatures(self, allowAddFeatures: bool) -> None: ...
    def allowAddFeatures(self) -> bool: ...
    def showIndeterminateState(self) -> None: ...
    def referencedFeature(self) -> QgsFeature: ...
    def setFilterExpression(self, filterExpression: str) -> None: ...
    def filterExpression(self) -> str: ...
    def setChainFilters(self, chainFilters: bool) -> None: ...
    def chainFilters(self) -> bool: ...
    def setOpenFormButtonVisible(self, openFormButtonVisible: bool) -> None: ...
    def openFormButtonVisible(self) -> bool: ...
    def setFilterFields(self, filterFields: Iterable[str]) -> None: ...
    def setOrderByValue(self, orderByValue: bool) -> None: ...
    def orderByValue(self) -> bool: ...
    def setAllowMapIdentification(self, allowMapIdentification: bool) -> None: ...
    def allowMapIdentification(self) -> bool: ...
    def setReadOnlySelector(self, readOnly: bool) -> None: ...
    def readOnlySelector(self) -> bool: ...
    def setEmbedForm(self, display: bool) -> None: ...
    def embedForm(self) -> bool: ...
    def setEditorContext(self, context: QgsAttributeEditorContext, canvas: QgsMapCanvas, messageBar: QgsMessageBar) -> None: ...
    def foreignKeys(self) -> List[typing.Any]: ...
    def foreignKey(self) -> typing.Any: ...
    def setForeignKeys(self, values: Iterable[typing.Any]) -> None: ...
    def setForeignKey(self, value: typing.Any) -> None: ...
    def setRelationEditable(self, editable: bool) -> None: ...
    def setRelation(self, relation: QgsRelation, allowNullValue: bool) -> None: ...


class QgsRelationReferenceWidgetWrapper(QgsEditorWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, editor: QtWidgets.QWidget, canvas: QgsMapCanvas, messageBar: QgsMessageBar, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def updateConstraintWidgetStatus(self) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def additionalFields(self) -> List[str]: ...
    def additionalFieldValues(self) -> List[typing.Any]: ...
    def showIndeterminateState(self) -> None: ...
    def valid(self) -> bool: ...
    def value(self) -> typing.Any: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...


class QgsRelationWidgetWrapper(QgsWidgetWrapper):

    @overload
    def __init__(self, vl: QgsVectorLayer, relation: QgsRelation, editor: Optional[QtWidgets.QWidget] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, relationEditorName: str, vl: QgsVectorLayer, relation: QgsRelation, editor: Optional[QtWidgets.QWidget] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setVisible(self, visible: bool) -> None: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def valid(self) -> bool: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def widgetValueChanged(self, attribute: str, newValue: typing.Any, attributeChanged: bool) -> None: ...
    def relation(self) -> QgsRelation: ...
    def setLabel(self, label: str = ...) -> None: ...
    def label(self) -> str: ...
    def setNmRelationId(self, nmRelationId: typing.Any = ...) -> None: ...
    def nmRelationId(self) -> typing.Any: ...
    def setForceSuppressFormPopup(self, forceSuppressFormPopup: bool) -> None: ...
    def forceSuppressFormPopup(self) -> bool: ...
    def widgetConfig(self) -> Dict[str, typing.Any]: ...
    def setWidgetConfig(self, config: Dict[str, typing.Any]) -> None: ...
    def visibleButtons(self) -> QgsAttributeEditorRelation.Buttons: ...
    def setVisibleButtons(self, buttons: Union[QgsAttributeEditorRelation.Buttons, QgsAttributeEditorRelation.Button]) -> None: ...
    def showSaveChildEditsButton(self) -> bool: ...
    def setShowSaveChildEditsButton(self, showChildEdits: bool) -> None: ...
    def setShowUnlinkButton(self, showUnlinkButton: bool) -> None: ...
    def showUnlinkButton(self) -> bool: ...
    def setShowLinkButton(self, showLinkButton: bool) -> None: ...
    def showLinkButton(self) -> bool: ...
    def setShowLabel(self, showLabel: bool) -> None: ...
    def showLabel(self) -> bool: ...


class QgsSearchWidgetToolButton(QtWidgets.QToolButton):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def activeFlagsChanged(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> None: ...
    def setActive(self) -> None: ...
    def setInactive(self) -> None: ...
    def isActive(self) -> bool: ...
    def activeFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def toggleFlag(self, flag: QgsSearchWidgetWrapper.FilterFlag) -> None: ...
    def setActiveFlags(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> None: ...
    def availableFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def setDefaultFlags(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> None: ...
    def setAvailableFlags(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> None: ...


class QgsSpinBox(QtWidgets.QSpinBox):

    class ClearValueMode(int): ...
    MinimumValue: QgsSpinBox.ClearValueMode = ...
    MaximumValue: QgsSpinBox.ClearValueMode = ...
    CustomValue: QgsSpinBox.ClearValueMode = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def timerEvent(self, event: QtCore.QTimerEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def changeEvent(self, event: QtCore.QEvent) -> None: ...
    def validate(self, input: str) -> Tuple[QtGui.QValidator.State, int]: ...
    def valueFromText(self, text: str) -> int: ...
    def setSpecialValueText(self, txt: str) -> None: ...
    def setLineEditAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def clearValue(self) -> int: ...
    def setClearValueMode(self, mode: QgsSpinBox.ClearValueMode, clearValueText: str = ...) -> None: ...
    def setClearValue(self, customValue: int, clearValueText: str = ...) -> None: ...
    def clear(self) -> None: ...
    def expressionsEnabled(self) -> bool: ...
    def setExpressionsEnabled(self, enabled: bool) -> None: ...
    def showClearButton(self) -> bool: ...
    def setShowClearButton(self, showClearButton: bool) -> None: ...


class QgsValueMapSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setExpression(self, exp: str) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def createExpression(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> str: ...
    def defaultFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def supportedFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def valid(self) -> bool: ...
    def expression(self) -> str: ...
    def applyDirectly(self) -> bool: ...


class QgsValueRelationSearchWidgetWrapper(QgsSearchWidgetWrapper):

    def __init__(self, vl: QgsVectorLayer, fieldIdx: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setExpression(self, exp: str) -> None: ...
    def onValueChanged(self) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def clearWidget(self) -> None: ...
    def createExpression(self, flags: Union[QgsSearchWidgetWrapper.FilterFlags, QgsSearchWidgetWrapper.FilterFlag]) -> str: ...
    def defaultFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def supportedFlags(self) -> QgsSearchWidgetWrapper.FilterFlags: ...
    def value(self) -> typing.Any: ...
    def valid(self) -> bool: ...
    def expression(self) -> str: ...
    def applyDirectly(self) -> bool: ...


class QgsEffectDrawModeComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setDrawMode(self, drawMode: QgsPaintEffect.DrawMode) -> None: ...
    def drawMode(self) -> QgsPaintEffect.DrawMode: ...


class QgsEffectStackPropertiesWidget(QgsPanelWidget):

    def __init__(self, stack: QgsEffectStack, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def moveEffectByOffset(self, offset: int) -> None: ...
    def updateUi(self) -> None: ...
    @overload
    def loadStack(self) -> None: ...
    @overload
    def loadStack(self, stack: QgsEffectStack) -> None: ...
    def changeEffect(self, newEffect: QgsPaintEffect) -> None: ...
    def updatePreview(self) -> None: ...
    def effectChanged(self) -> None: ...
    def removeEffect(self) -> None: ...
    def addEffect(self) -> None: ...
    def moveEffectUp(self) -> None: ...
    def moveEffectDown(self) -> None: ...
    def setPreviewPicture(self, picture: QtGui.QPicture) -> None: ...
    def stack(self) -> QgsEffectStack: ...


class QgsEffectStackPropertiesDialog(QgsDialog):

    def __init__(self, stack: QgsEffectStack, parent: Optional[QtWidgets.QWidget] = ..., f: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setPreviewPicture(self, picture: QtGui.QPicture) -> None: ...
    def stack(self) -> QgsEffectStack: ...


class QgsEffectStackCompactWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., effect: Optional[QgsPaintEffect] = ...) -> None: ...

    def changed(self) -> None: ...
    def setPreviewPicture(self, picture: QtGui.QPicture) -> None: ...
    def paintEffect(self) -> QgsPaintEffect: ...
    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...


class QgsPaintEffectPropertiesWidget(QtWidgets.QWidget):

    def __init__(self, effect: QgsPaintEffect, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changeEffect(self, effect: QgsPaintEffect) -> None: ...
    def changed(self) -> None: ...
    def emitSignalChanged(self) -> None: ...
    def effectTypeChanged(self) -> None: ...


class QgsPaintEffectWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...


class QgsDrawSourceWidget(QgsPaintEffectWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    @staticmethod
    def create() -> QgsPaintEffectWidget: ...


class QgsBlurWidget(QgsPaintEffectWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    @staticmethod
    def create() -> QgsPaintEffectWidget: ...


class QgsShadowEffectWidget(QgsPaintEffectWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    @staticmethod
    def create() -> QgsPaintEffectWidget: ...


class QgsGlowWidget(QgsPaintEffectWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    @staticmethod
    def create() -> QgsPaintEffectWidget: ...


class QgsTransformWidget(QgsPaintEffectWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    @staticmethod
    def create() -> QgsPaintEffectWidget: ...


class QgsColorEffectWidget(QgsPaintEffectWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    @staticmethod
    def create() -> QgsPaintEffectWidget: ...


class QgsLabelSettingsWidgetBase(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., vl: Optional[QgsVectorLayer] = ...) -> None: ...

    def registerDataDefinedButton(self, button: QgsPropertyOverrideButton, key: QgsPalLayerSettings.Property) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def auxiliaryFieldCreated(self) -> None: ...
    def changed(self) -> None: ...
    def updateDataDefinedProperties(self, properties: QgsPropertyCollection) -> None: ...
    def setDataDefinedProperties(self, dataDefinedProperties: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def setGeometryType(self, type: QgsWkbTypes.GeometryType) -> None: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...


class QgsLabelLineAnchorWidget(QgsLabelSettingsWidgetBase):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., vl: Optional[QgsVectorLayer] = ...) -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection) -> None: ...
    def settings(self) -> QgsLabelLineSettings: ...
    def setSettings(self, settings: QgsLabelLineSettings) -> None: ...


class QgsLabelObstacleSettingsWidget(QgsLabelSettingsWidgetBase):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., vl: Optional[QgsVectorLayer] = ...) -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection) -> None: ...
    def setGeometryType(self, type: QgsWkbTypes.GeometryType) -> None: ...
    def settings(self) -> QgsLabelObstacleSettings: ...
    def setSettings(self, settings: QgsLabelObstacleSettings) -> None: ...


class QgsLabelSettingsWidgetDialog(QtWidgets.QDialog):

    def __init__(self, widget: QgsLabelSettingsWidgetBase, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...


class QgsCustomLayerOrderWidget(QtWidgets.QWidget):

    def __init__(self, bridge: QgsLayerTreeMapCanvasBridge, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsLayerTreeEmbeddedConfigWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def applyToLayer(self) -> None: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...


class QgsLayerTreeEmbeddedWidgetProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerTreeEmbeddedWidgetProvider) -> None: ...

    def supportsLayer(self, layer: QgsMapLayer) -> bool: ...
    def createWidget(self, layer: QgsMapLayer, widgetIndex: int) -> QtWidgets.QWidget: ...
    def name(self) -> str: ...
    def id(self) -> str: ...


class QgsLayerTreeEmbeddedWidgetRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def removeProvider(self, providerId: str) -> bool: ...
    def addProvider(self, provider: QgsLayerTreeEmbeddedWidgetProvider) -> bool: ...
    def provider(self, providerId: str) -> QgsLayerTreeEmbeddedWidgetProvider: ...
    def providers(self) -> List[str]: ...


class QgsLayerTreeMapCanvasBridge(QtCore.QObject):

    def __init__(self, root: QgsLayerTree, canvas: QgsMapCanvas, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def canvasLayersChanged(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def setCanvasLayers(self) -> None: ...
    def autoSetupOnFirstLayer(self) -> bool: ...
    def setAutoSetupOnFirstLayer(self, enabled: bool) -> None: ...
    def overviewCanvas(self) -> QgsMapOverviewCanvas: ...
    def setOvervewCanvas(self, overviewCanvas: QgsMapOverviewCanvas) -> None: ...
    def setOverviewCanvas(self, overviewCanvas: QgsMapOverviewCanvas) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def rootGroup(self) -> QgsLayerTree: ...


class QgsLayerTreeProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, treeModel: QgsLayerTreeModel, parent: QtCore.QObject) -> None: ...

    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def setShowPrivateLayers(self, showPrivate: bool) -> None: ...
    def showPrivateLayers(self) -> bool: ...
    def setFilterText(self, filterText: str = ...) -> None: ...


class QgsLayerTreeView(QtWidgets.QTreeView):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def onModelReset(self) -> None: ...
    def onExpandedChanged(self, node: QgsLayerTreeNode, expanded: bool) -> None: ...
    def onCurrentChanged(self) -> None: ...
    def updateExpandedStateToNode(self, index: QtCore.QModelIndex) -> None: ...
    def modelRowsRemoved(self) -> None: ...
    def modelRowsInserted(self, index: QtCore.QModelIndex, start: int, end: int) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def layerForIndex(self, index: QtCore.QModelIndex) -> QgsMapLayer: ...
    def updateExpandedStateFromNode(self, node: QgsLayerTreeNode) -> None: ...
    def contextMenuEvent(self, event: QtGui.QContextMenuEvent) -> None: ...
    def currentLayerChanged(self, layer: QgsMapLayer) -> None: ...
    def showPrivateLayers(self) -> bool: ...
    def setShowPrivateLayers(self, showPrivate: bool) -> None: ...
    def setMessageBar(self, messageBar: QgsMessageBar) -> None: ...
    def setLayerMarkWidth(self, width: int) -> None: ...
    def collapseAllNodes(self) -> None: ...
    def expandAllNodes(self) -> None: ...
    def refreshLayerSymbology(self, layerId: str) -> None: ...
    def layerMarkWidth(self) -> int: ...
    def indicators(self, node: QgsLayerTreeNode) -> List[QgsLayerTreeViewIndicator]: ...
    def removeIndicator(self, node: QgsLayerTreeNode, indicator: QgsLayerTreeViewIndicator) -> None: ...
    def addIndicator(self, node: QgsLayerTreeNode, indicator: QgsLayerTreeViewIndicator) -> None: ...
    def selectedLayersRecursive(self) -> List[QgsMapLayer]: ...
    def selectedLayers(self) -> List[QgsMapLayer]: ...
    def selectedLayerNodes(self) -> List[QgsLayerTreeLayer]: ...
    def selectedNodes(self, skipInternal: bool = ...) -> List[QgsLayerTreeNode]: ...
    def currentLegendNode(self) -> QgsLayerTreeModelLegendNode: ...
    def currentGroupNode(self) -> QgsLayerTreeGroup: ...
    def currentNode(self) -> QgsLayerTreeNode: ...
    def setCurrentLayer(self, layer: QgsMapLayer) -> None: ...
    def setLayerVisible(self, layer: QgsMapLayer, visible: bool) -> None: ...
    def currentLayer(self) -> QgsMapLayer: ...
    def menuProvider(self) -> QgsLayerTreeViewMenuProvider: ...
    def setMenuProvider(self, menuProvider: QgsLayerTreeViewMenuProvider) -> None: ...
    def defaultActions(self) -> QgsLayerTreeViewDefaultActions: ...
    def legendNode2sourceIndex(self, legendNode: QgsLayerTreeModelLegendNode) -> QtCore.QModelIndex: ...
    def legendNode2index(self, legendNode: QgsLayerTreeModelLegendNode) -> QtCore.QModelIndex: ...
    def index2legendNode(self, index: QtCore.QModelIndex) -> QgsLayerTreeModelLegendNode: ...
    def node2sourceIndex(self, node: QgsLayerTreeNode) -> QtCore.QModelIndex: ...
    def node2index(self, node: QgsLayerTreeNode) -> QtCore.QModelIndex: ...
    def index2node(self, index: QtCore.QModelIndex) -> QgsLayerTreeNode: ...
    def proxyModel(self) -> QgsLayerTreeProxyModel: ...
    def layerTreeModel(self) -> QgsLayerTreeModel: ...
    def setModel(self, model: QtCore.QAbstractItemModel) -> None: ...


class QgsLayerTreeViewMenuProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerTreeViewMenuProvider) -> None: ...

    def createContextMenu(self) -> QtWidgets.QMenu: ...


class QgsLayerTreeViewDefaultActions(QtCore.QObject):

    def __init__(self, view: QgsLayerTreeView) -> None: ...

    def uniqueGroupName(self, parentGroup: QgsLayerTreeGroup) -> str: ...
    def mutuallyExclusiveGroup(self) -> None: ...
    def groupSelected(self) -> None: ...
    def moveToBottom(self) -> None: ...
    def moveToTop(self) -> None: ...
    def moveOutOfGroup(self) -> None: ...
    def makeTopLevel(self) -> None: ...
    def showFeatureCount(self) -> None: ...
    def renameGroupOrLayer(self) -> None: ...
    def removeGroupOrLayer(self) -> None: ...
    def addGroup(self) -> None: ...
    def showInOverview(self) -> None: ...
    @overload
    def zoomToGroup(self, canvas: QgsMapCanvas) -> None: ...
    @overload
    def zoomToGroup(self) -> None: ...
    @overload
    def zoomToSelection(self, canvas: QgsMapCanvas) -> None: ...
    @overload
    def zoomToSelection(self) -> None: ...
    @overload
    def zoomToLayers(self, canvas: QgsMapCanvas) -> None: ...
    @overload
    def zoomToLayers(self) -> None: ...
    @overload
    def zoomToLayers(self, canvas: QgsMapCanvas, layers: Iterable[QgsMapLayer]) -> None: ...
    @overload
    def zoomToLayer(self, canvas: QgsMapCanvas) -> None: ...
    @overload
    def zoomToLayer(self) -> None: ...
    def actionMutuallyExclusiveGroup(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionGroupSelected(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionMoveToBottom(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionMoveToTop(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionMoveOutOfGroup(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionMakeTopLevel(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionZoomToGroup(self, canvas: QgsMapCanvas, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionZoomToSelection(self, canvas: QgsMapCanvas, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionZoomToLayers(self, canvas: QgsMapCanvas, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionZoomToLayer(self, canvas: QgsMapCanvas, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionCheckAndAllParents(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionUncheckAndAllChildren(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionCheckAndAllChildren(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionShowFeatureCount(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionRenameGroupOrLayer(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionShowInOverview(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionRemoveGroupOrLayer(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...
    def actionAddGroup(self, parent: Optional[QtCore.QObject] = ...) -> QtWidgets.QAction: ...


class QgsLayerTreeViewIndicator(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def changed(self) -> None: ...
    def clicked(self, index: QtCore.QModelIndex) -> None: ...
    def setToolTip(self, tip: str) -> None: ...
    def toolTip(self) -> str: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsLayoutComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., manager: Optional[QgsLayoutManager] = ...) -> None: ...

    def layoutChanged(self, layout: QgsMasterLayoutInterface) -> None: ...
    def setCurrentLayout(self, layout: QgsMasterLayoutInterface) -> None: ...
    def layout(self, index: int) -> QgsMasterLayoutInterface: ...
    def currentLayout(self) -> QgsMasterLayoutInterface: ...
    def allowEmptyLayout(self) -> bool: ...
    def setAllowEmptyLayout(self, allowEmpty: bool) -> None: ...
    def setFilters(self, filters: Union[QgsLayoutManagerProxyModel.Filters, QgsLayoutManagerProxyModel.Filter]) -> None: ...
    def filters(self) -> QgsLayoutManagerProxyModel.Filters: ...
    def setLayoutManager(self, manager: QgsLayoutManager) -> None: ...


class QgsLayoutCustomDropHandler(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def handlePaste(self, iface: QgsLayoutDesignerInterface, pastePoint: Union[QtCore.QPointF, QtCore.QPoint], data: QtCore.QMimeData) -> Tuple[bool, List[QgsLayoutItem]]: ...
    @overload
    def handleFileDrop(self, iface: QgsLayoutDesignerInterface, file: str) -> bool: ...
    @overload
    def handleFileDrop(self, iface: QgsLayoutDesignerInterface, dropPoint: Union[QtCore.QPointF, QtCore.QPoint], file: str) -> bool: ...


class QgsLayoutDesignerInterface(QtCore.QObject):

    class StandardTool(int): ...
    ToolMoveItemContent: QgsLayoutDesignerInterface.StandardTool = ...
    ToolMoveItemNodes: QgsLayoutDesignerInterface.StandardTool = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def showRulers(self, visible: bool) -> None: ...
    def close(self) -> None: ...
    def activateTool(self, tool: QgsLayoutDesignerInterface.StandardTool) -> None: ...
    def removeDockWidget(self, dock: QtWidgets.QDockWidget) -> None: ...
    def addDockWidget(self, area: QtCore.Qt.DockWidgetArea, dock: QtWidgets.QDockWidget) -> None: ...
    def atlasToolbar(self) -> QtWidgets.QToolBar: ...
    def actionsToolbar(self) -> QtWidgets.QToolBar: ...
    def navigationToolbar(self) -> QtWidgets.QToolBar: ...
    def layoutToolbar(self) -> QtWidgets.QToolBar: ...
    def settingsMenu(self) -> QtWidgets.QMenu: ...
    def reportMenu(self) -> QtWidgets.QMenu: ...
    def atlasMenu(self) -> QtWidgets.QMenu: ...
    def itemsMenu(self) -> QtWidgets.QMenu: ...
    def viewMenu(self) -> QtWidgets.QMenu: ...
    def editMenu(self) -> QtWidgets.QMenu: ...
    def layoutMenu(self) -> QtWidgets.QMenu: ...
    def showItemOptions(self, item: QgsLayoutItem, bringPanelToFront: bool = ...) -> None: ...
    def setAtlasFeature(self, feature: QgsFeature) -> None: ...
    def atlasPreviewEnabled(self) -> bool: ...
    def setAtlasPreviewEnabled(self, enabled: bool) -> None: ...
    def selectItems(self, items: Iterable[QgsLayoutItem]) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def view(self) -> QgsLayoutView: ...
    def window(self) -> QtWidgets.QWidget: ...
    def masterLayout(self) -> QgsMasterLayoutInterface: ...
    def layout(self) -> QgsLayout: ...


class QgsLayoutItemComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., layout: Optional[QgsLayout] = ...) -> None: ...

    def itemChanged(self, item: QgsLayoutItem) -> None: ...
    def setItem(self, item: QgsLayoutItem) -> None: ...
    def currentItem(self) -> QgsLayoutItem: ...
    def item(self, index: int) -> QgsLayoutItem: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def setItemFlags(self, flags: Union[QgsLayoutItem.Flags, QgsLayoutItem.Flag]) -> None: ...
    def allowEmptyItem(self) -> bool: ...
    def setAllowEmptyItem(self, allowEmpty: bool) -> None: ...
    def exceptedItemList(self) -> List[QgsLayoutItem]: ...
    def setExceptedItemList(self, exceptList: Iterable[QgsLayoutItem]) -> None: ...
    def itemType(self) -> QgsLayoutItemRegistry.ItemType: ...
    def setItemType(self, itemType: QgsLayoutItemRegistry.ItemType) -> None: ...
    def currentLayout(self) -> QgsLayout: ...
    def setCurrentLayout(self, layout: QgsLayout) -> None: ...


class QgsLayoutItemAbstractGuiMetadata(sip.wrapper):

    class Flag(int): ...
    FlagNoCreationTools: QgsLayoutItemAbstractGuiMetadata.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsLayoutItemAbstractGuiMetadata.Flags', 'QgsLayoutItemAbstractGuiMetadata.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutItemAbstractGuiMetadata.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsLayoutItemAbstractGuiMetadata.Flags': ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, type: int, visibleName: str, groupId: str = ..., isNodeBased: bool = ..., flags: Union['QgsLayoutItemAbstractGuiMetadata.Flags', 'QgsLayoutItemAbstractGuiMetadata.Flag'] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutItemAbstractGuiMetadata) -> None: ...

    def newItemAddedToLayout(self, item: QgsLayoutItem) -> None: ...
    def createItem(self, layout: QgsLayout) -> QgsLayoutItem: ...
    def createNodeRubberBand(self, view: QgsLayoutView) -> QtWidgets.QAbstractGraphicsShapeItem: ...
    def createRubberBand(self, view: QgsLayoutView) -> QgsLayoutViewRubberBand: ...
    def createItemWidget(self, item: QgsLayoutItem) -> QgsLayoutItemBaseWidget: ...
    def creationIcon(self) -> QtGui.QIcon: ...
    def visibleName(self) -> str: ...
    def isNodeBased(self) -> bool: ...
    def groupId(self) -> str: ...
    def flags(self) -> 'QgsLayoutItemAbstractGuiMetadata.Flags': ...
    def type(self) -> int: ...


class QgsLayoutItemGuiGroup(sip.wrapper):

    icon: QtGui.QIcon = ...
    id: str = ...
    name: str = ...

    @overload
    def __init__(self, id: str = ..., name: str = ..., icon: QtGui.QIcon = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutItemGuiGroup) -> None: ...


class QgsLayoutItemGuiRegistry(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def typeAdded(self, metadataId: int) -> None: ...
    def itemMetadataIds(self) -> List[int]: ...
    def createItemWidget(self, item: QgsLayoutItem) -> QgsLayoutItemBaseWidget: ...
    def newItemAddedToLayout(self, metadataId: int, item: QgsLayoutItem, properties: Dict[str, typing.Any] = ...) -> None: ...
    def createItem(self, metadataId: int, layout: QgsLayout) -> QgsLayoutItem: ...
    def itemGroup(self, id: str) -> QgsLayoutItemGuiGroup: ...
    def addItemGroup(self, group: QgsLayoutItemGuiGroup) -> bool: ...
    def addLayoutItemGuiMetadata(self, metadata: QgsLayoutItemAbstractGuiMetadata) -> bool: ...
    def metadataIdForItemType(self, type: int) -> int: ...
    def itemMetadata(self, metadataId: int) -> QgsLayoutItemAbstractGuiMetadata: ...


class QgsLayoutConfigObject(QtCore.QObject):

    def __init__(self, parent: QtWidgets.QWidget, layoutObject: QgsLayoutObject) -> None: ...

    def layoutAtlas(self) -> QgsLayoutAtlas: ...
    def coverageLayer(self) -> QgsVectorLayer: ...
    def updateDataDefinedButton(self, button: QgsPropertyOverrideButton) -> None: ...
    def initializeDataDefinedButton(self, button: QgsPropertyOverrideButton, key: QgsLayoutObject.DataDefinedProperty) -> None: ...


class QgsLayoutItemBaseWidget(QgsPanelWidget):

    def __init__(self, parent: QtWidgets.QWidget, layoutObject: QgsLayoutObject) -> None: ...

    def layoutAtlas(self) -> QgsLayoutAtlas: ...
    def setNewItem(self, item: QgsLayoutItem) -> bool: ...
    def coverageLayer(self) -> QgsVectorLayer: ...
    def updateDataDefinedButton(self, button: QgsPropertyOverrideButton) -> None: ...
    def registerDataDefinedButton(self, button: QgsPropertyOverrideButton, property: QgsLayoutObject.DataDefinedProperty) -> None: ...
    def setMasterLayout(self, masterLayout: QgsMasterLayoutInterface) -> None: ...
    def setDesignerInterface(self, iface: QgsLayoutDesignerInterface) -> None: ...
    def setReportTypeString(self, string: str) -> None: ...
    def setItem(self, item: QgsLayoutItem) -> bool: ...
    def layoutObject(self) -> QgsLayoutObject: ...


class QgsLayoutItemPropertiesWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget, item: QgsLayoutItem) -> None: ...

    def populateDataDefinedButtons(self) -> None: ...
    def initializeDataDefinedButtons(self) -> None: ...
    def updateVariables(self) -> None: ...
    def setMasterLayout(self, masterLayout: QgsMasterLayoutInterface) -> None: ...
    def setItem(self, item: QgsLayoutItem) -> None: ...
    def showFrameGroup(self, showGroup: bool) -> None: ...
    def showBackgroundGroup(self, showGroup: bool) -> None: ...
    def positionMode(self) -> QgsLayoutItem.ReferencePoint: ...


class QgsLayoutItemPropertiesDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setLayout(self, layout: QgsLayout) -> None: ...
    def setReferencePoint(self, point: QgsLayoutItem.ReferencePoint) -> None: ...
    def referencePoint(self) -> QgsLayoutItem.ReferencePoint: ...
    def itemSize(self) -> QgsLayoutSize: ...
    def setItemSize(self, size: QgsLayoutSize) -> None: ...
    def page(self) -> int: ...
    def itemPosition(self) -> QgsLayoutPoint: ...
    def setItemPosition(self, position: QgsLayoutPoint) -> None: ...


class QgsLayoutRuler(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., orientation: QtCore.Qt.Orientation = ...) -> None: ...

    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def cursorPosChanged(self, a0: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setCursorPosition(self, position: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def setContextMenu(self, menu: QtWidgets.QMenu) -> None: ...
    def rulerSize(self) -> int: ...
    def setLayoutView(self, view: QgsLayoutView) -> None: ...
    def layoutView(self) -> QgsLayoutView: ...
    def setSceneTransform(self, transform: QtGui.QTransform) -> None: ...
    def minimumSizeHint(self) -> QtCore.QSize: ...


class QgsLayoutUnitsComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self, unit: QgsUnitTypes.LayoutUnit) -> None: ...
    def setConverter(self, converter: QgsLayoutMeasurementConverter) -> None: ...
    def converter(self) -> QgsLayoutMeasurementConverter: ...
    def linkToWidget(self, widget: QtWidgets.QDoubleSpinBox) -> None: ...
    def setUnit(self, unit: QgsUnitTypes.LayoutUnit) -> None: ...
    def unit(self) -> QgsUnitTypes.LayoutUnit: ...


class QgsLayoutView(QtWidgets.QGraphicsView):

    class PasteMode(int): ...
    PasteModeCursor: QgsLayoutView.PasteMode = ...
    PasteModeCenter: QgsLayoutView.PasteMode = ...
    PasteModeInPlace: QgsLayoutView.PasteMode = ...

    class ClipboardOperation(int): ...
    ClipboardCut: QgsLayoutView.ClipboardOperation = ...
    ClipboardCopy: QgsLayoutView.ClipboardOperation = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def dragEnterEvent(self, e: QtGui.QDragEnterEvent) -> None: ...
    def scrollContentsBy(self, dx: int, dy: int) -> None: ...
    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def willBeDeleted(self) -> None: ...
    def itemFocused(self, item: QgsLayoutItem) -> None: ...
    def statusMessage(self, message: str) -> None: ...
    def pageChanged(self, page: int) -> None: ...
    def cursorPosChanged(self, layoutPoint: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def zoomLevelChanged(self) -> None: ...
    def toolSet(self, tool: QgsLayoutViewTool) -> None: ...
    def layoutSet(self, layout: QgsLayout) -> None: ...
    def pushStatusMessage(self, message: str) -> None: ...
    def viewChanged(self) -> None: ...
    def ungroupSelectedItems(self) -> None: ...
    def groupSelectedItems(self) -> None: ...
    def deleteItems(self, items: Iterable[QgsLayoutItem]) -> None: ...
    def deleteSelectedItems(self) -> None: ...
    def unlockAllItems(self) -> None: ...
    def lockSelectedItems(self) -> None: ...
    def moveSelectedItemsToBottom(self) -> None: ...
    def moveSelectedItemsToTop(self) -> None: ...
    def lowerSelectedItems(self) -> None: ...
    def raiseSelectedItems(self) -> None: ...
    def selectNextItemBelow(self) -> None: ...
    def selectNextItemAbove(self) -> None: ...
    def invertSelection(self) -> None: ...
    def deselectAll(self) -> None: ...
    def selectAll(self) -> None: ...
    def emitZoomLevelChanged(self) -> None: ...
    def zoomActual(self) -> None: ...
    def zoomOut(self) -> None: ...
    def zoomIn(self) -> None: ...
    def zoomWidth(self) -> None: ...
    def zoomFull(self) -> None: ...
    def setSectionLabel(self, label: str) -> None: ...
    def deltaForKeyEvent(self, event: QtGui.QKeyEvent) -> QtCore.QPointF: ...
    def hasItemsInClipboard(self) -> bool: ...
    @overload
    def pasteItems(self, mode: QgsLayoutView.PasteMode) -> List[QgsLayoutItem]: ...
    @overload
    def pasteItems(self, layoutPoint: Union[QtCore.QPointF, QtCore.QPoint]) -> List[QgsLayoutItem]: ...
    def copyItems(self, items: Iterable[QgsLayoutItem], operation: QgsLayoutView.ClipboardOperation) -> None: ...
    def copySelectedItems(self, operation: QgsLayoutView.ClipboardOperation) -> None: ...
    def resizeSelectedItems(self, resize: QgsLayoutAligner.Resize) -> None: ...
    def distributeSelectedItems(self, distribution: QgsLayoutAligner.Distribution) -> None: ...
    def alignSelectedItems(self, alignment: QgsLayoutAligner.Alignment) -> None: ...
    def visiblePageNumbers(self) -> List[int]: ...
    def visiblePages(self) -> List[QgsLayoutItemPage]: ...
    def currentPage(self) -> int: ...
    def menuProvider(self) -> QgsLayoutViewMenuProvider: ...
    def setMenuProvider(self, provider: QgsLayoutViewMenuProvider) -> None: ...
    def setVerticalRuler(self, ruler: QgsLayoutRuler) -> None: ...
    def setHorizontalRuler(self, ruler: QgsLayoutRuler) -> None: ...
    def setZoomLevel(self, level: float) -> None: ...
    def scaleSafe(self, scale: float) -> None: ...
    def previewMode(self) -> QgsPreviewEffect.PreviewMode: ...
    def setPreviewMode(self, mode: QgsPreviewEffect.PreviewMode) -> None: ...
    def previewModeEnabled(self) -> bool: ...
    def setPreviewModeEnabled(self, enabled: bool) -> None: ...
    def unsetTool(self, tool: QgsLayoutViewTool) -> None: ...
    def setTool(self, tool: QgsLayoutViewTool) -> None: ...
    def tool(self) -> QgsLayoutViewTool: ...
    def setCurrentLayout(self, layout: QgsLayout) -> None: ...
    def currentLayout(self) -> QgsLayout: ...


class QgsLayoutViewMenuProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutViewMenuProvider) -> None: ...

    def createContextMenu(self, parent: QtWidgets.QWidget, layout: QgsLayout, layoutPoint: Union[QtCore.QPointF, QtCore.QPoint]) -> QtWidgets.QMenu: ...


class QgsLayoutViewMouseEvent(QtGui.QMouseEvent):

    @overload
    def __init__(self, view: QgsLayoutView, event: QtGui.QMouseEvent, snap: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutViewMouseEvent) -> None: ...

    def isSnapped(self) -> bool: ...
    def snappedPoint(self) -> QtCore.QPointF: ...
    def layoutPoint(self) -> QtCore.QPointF: ...
    def snapPoint(self, horizontalSnapLine: Optional[QtWidgets.QGraphicsLineItem] = ..., verticalSnapLine: Optional[QtWidgets.QGraphicsLineItem] = ..., ignoreItems: Iterable[QgsLayoutItem] = ...) -> None: ...


class QgsLayoutViewRubberBand(QtCore.QObject):

    def __init__(self, view: Optional[QgsLayoutView] = ...) -> None: ...

    def updateRect(self, start: Union[QtCore.QPointF, QtCore.QPoint], position: Union[QtCore.QPointF, QtCore.QPoint], constrainSquare: bool, fromCenter: bool) -> QtCore.QRectF: ...
    def sizeChanged(self, size: str) -> None: ...
    def setPen(self, pen: Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setBrush(self, brush: Union[QtGui.QBrush, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def brush(self) -> QtGui.QBrush: ...
    def layout(self) -> QgsLayout: ...
    def view(self) -> QgsLayoutView: ...
    def finish(self, position: Union[QtCore.QPointF, QtCore.QPoint] = ..., modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> QtCore.QRectF: ...
    def update(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def start(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def create(self, view: QgsLayoutView) -> QgsLayoutViewRubberBand: ...


class QgsLayoutViewRectangularRubberBand(QgsLayoutViewRubberBand):

    def __init__(self, view: Optional[QgsLayoutView] = ...) -> None: ...

    def finish(self, position: Union[QtCore.QPointF, QtCore.QPoint] = ..., modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> QtCore.QRectF: ...
    def update(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def start(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def create(self, view: QgsLayoutView) -> QgsLayoutViewRectangularRubberBand: ...


class QgsLayoutViewEllipticalRubberBand(QgsLayoutViewRubberBand):

    def __init__(self, view: Optional[QgsLayoutView] = ...) -> None: ...

    def finish(self, position: Union[QtCore.QPointF, QtCore.QPoint] = ..., modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> QtCore.QRectF: ...
    def update(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def start(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def create(self, view: QgsLayoutView) -> QgsLayoutViewEllipticalRubberBand: ...


class QgsLayoutViewTriangleRubberBand(QgsLayoutViewRubberBand):

    def __init__(self, view: Optional[QgsLayoutView] = ...) -> None: ...

    def finish(self, position: Union[QtCore.QPointF, QtCore.QPoint] = ..., modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier] = ...) -> QtCore.QRectF: ...
    def update(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def start(self, position: Union[QtCore.QPointF, QtCore.QPoint], modifiers: Union[QtCore.Qt.KeyboardModifiers, QtCore.Qt.KeyboardModifier]) -> None: ...
    def create(self, view: QgsLayoutView) -> QgsLayoutViewTriangleRubberBand: ...


class QgsLayoutViewTool(QtCore.QObject):

    class Flag(int): ...
    FlagSnaps: QgsLayoutViewTool.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsLayoutViewTool.Flags', 'QgsLayoutViewTool.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutViewTool.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsLayoutViewTool.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self, view: QgsLayoutView, name: str) -> None: ...

    def isClickAndDrag(self, startViewPoint: QtCore.QPoint, endViewPoint: QtCore.QPoint) -> bool: ...
    def setFlags(self, flags: Union['QgsLayoutViewTool.Flags', 'QgsLayoutViewTool.Flag']) -> None: ...
    def itemFocused(self, item: QgsLayoutItem) -> None: ...
    def deactivated(self) -> None: ...
    def activated(self) -> None: ...
    def ignoredSnapItems(self) -> List[QgsLayoutItem]: ...
    def layout(self) -> QgsLayout: ...
    def view(self) -> QgsLayoutView: ...
    def toolName(self) -> str: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def setCursor(self, cursor: Union[QtGui.QCursor, QtCore.Qt.CursorShape]) -> None: ...
    def action(self) -> QtWidgets.QAction: ...
    def setAction(self, action: QtWidgets.QAction) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutDoubleClickEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def flags(self) -> 'QgsLayoutViewTool.Flags': ...


class QgsLayoutViewToolAddItem(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def createdItem(self) -> None: ...
    def setCustomProperties(self, properties: Dict[str, typing.Any]) -> None: ...
    def customProperties(self) -> Dict[str, typing.Any]: ...
    def deactivate(self) -> None: ...
    def activate(self) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def setItemMetadataId(self, metadataId: int) -> None: ...
    def itemMetadataId(self) -> int: ...


class QgsLayoutViewToolAddNodeItem(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def createdItem(self) -> None: ...
    def deactivate(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def setItemMetadataId(self, metadataId: int) -> None: ...
    def itemMetadataId(self) -> int: ...


class QgsLayoutViewToolEditNodes(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def ignoredSnapItems(self) -> List[QgsLayoutItem]: ...
    def deactivate(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def layoutDoubleClickEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def activate(self) -> None: ...
    def deleteSelectedNode(self) -> None: ...


class QgsLayoutViewToolMoveItemContent(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLayoutViewToolPan(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def deactivate(self) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLayoutViewToolSelect(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def setLayout(self, layout: QgsLayout) -> None: ...
    def deactivate(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLayoutViewToolTemporaryKeyPan(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def activate(self) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLayoutViewToolZoom(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def deactivate(self) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutPressEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLayoutViewToolTemporaryKeyZoom(QgsLayoutViewToolZoom):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def activate(self) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLayoutViewToolTemporaryMousePan(QgsLayoutViewTool):

    def __init__(self, view: QgsLayoutView) -> None: ...

    def activate(self) -> None: ...
    def layoutReleaseEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...
    def layoutMoveEvent(self, event: QgsLayoutViewMouseEvent) -> None: ...


class QgsLocatorWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def eventFilter(self, obj: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def configTriggered(self) -> None: ...
    def invalidateResults(self) -> None: ...
    def search(self, string: str) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def locator(self) -> QgsLocator: ...


class QgsMeshLayerProperties(QgsOptionsDialogBase):

    def __init__(self, lyr: QgsMapLayer, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ..., a3: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def addPropertiesPageFactory(self, factory: QgsMapLayerConfigWidgetFactory) -> None: ...


class QgsNumericFormatSelectorWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsNumericFormatWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsBasicNumericFormatWidget(QgsNumericFormatWidget):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsBearingNumericFormatWidget(QgsNumericFormatWidget):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsBearingNumericFormatDialog(QtWidgets.QDialog):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsBearingNumericFormat: ...


class QgsCurrencyNumericFormatWidget(QgsNumericFormatWidget):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsPercentageNumericFormatWidget(QgsNumericFormatWidget):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsScientificNumericFormatWidget(QgsNumericFormatWidget):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsFractionNumericFormatWidget(QgsNumericFormatWidget):

    def __init__(self, format: QgsNumericFormat, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def format(self) -> QgsNumericFormat: ...
    def setFormat(self, format: QgsNumericFormat) -> None: ...


class QgsNumericFormatConfigurationWidgetFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNumericFormatConfigurationWidgetFactory) -> None: ...

    def create(self, format: QgsNumericFormat) -> QgsNumericFormatWidget: ...


class QgsNumericFormatGuiRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNumericFormatGuiRegistry) -> None: ...

    def formatConfigurationWidget(self, format: QgsNumericFormat) -> QgsNumericFormatWidget: ...
    def removeFormatConfigurationWidgetFactory(self, id: str) -> None: ...
    def addFormatConfigurationWidgetFactory(self, id: str, factory: QgsNumericFormatConfigurationWidgetFactory) -> None: ...


class QgsPointCloudRendererWidget(QgsPanelWidget):

    def __init__(self, layer: QgsPointCloudLayer, style: QgsStyle) -> None: ...

    def layer(self) -> QgsPointCloudLayer: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsPointCloudRenderer: ...


class QgsPointCloudRendererPropertiesWidget(QgsMapLayerConfigWidget):

    def __init__(self, layer: QgsPointCloudLayer, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def apply(self) -> None: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def syncToLayer(self, layer: QgsMapLayer) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...


class QgsAggregateMappingModel(QtCore.QAbstractTableModel):

    class ColumnDataIndex(int): ...
    SourceExpression: QgsAggregateMappingModel.ColumnDataIndex = ...
    Aggregate: QgsAggregateMappingModel.ColumnDataIndex = ...  # type: ignore
    Delimiter: QgsAggregateMappingModel.ColumnDataIndex = ...
    DestinationName: QgsAggregateMappingModel.ColumnDataIndex = ...
    DestinationType: QgsAggregateMappingModel.ColumnDataIndex = ...
    DestinationLength: QgsAggregateMappingModel.ColumnDataIndex = ...
    DestinationPrecision: QgsAggregateMappingModel.ColumnDataIndex = ...

    class Aggregate(sip.wrapper):

        aggregate: str = ...
        delimiter: str = ...
        field: QgsField = ...
        source: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsAggregateMappingModel.Aggregate) -> None: ...

    def __init__(self, sourceFields: QgsFields = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def setBaseExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def contextGenerator(self) -> QgsExpressionContextGenerator: ...
    def setSourceFields(self, sourceFields: QgsFields) -> None: ...
    def moveDown(self, index: QtCore.QModelIndex) -> bool: ...
    def moveUp(self, index: QtCore.QModelIndex) -> bool: ...
    def removeField(self, index: QtCore.QModelIndex) -> bool: ...
    def appendField(self, field: QgsField, source: str = ..., aggregate: str = ...) -> None: ...
    def setMapping(self, mapping: Iterable[QgsAggregateMappingModel.Aggregate]) -> None: ...
    def mapping(self) -> List[QgsAggregateMappingModel.Aggregate]: ...
    def sourceFields(self) -> QgsFields: ...


class QgsAggregateMappingWidget(QgsPanelWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., sourceFields: QgsFields = ...) -> None: ...

    def moveSelectedFieldsDown(self) -> bool: ...
    def moveSelectedFieldsUp(self) -> bool: ...
    def removeSelectedFields(self) -> bool: ...
    def appendField(self, field: QgsField, source: str = ..., aggregate: str = ...) -> None: ...
    def changed(self) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def scrollTo(self, index: QtCore.QModelIndex) -> None: ...
    def sourceLayer(self) -> QgsVectorLayer: ...
    def setSourceLayer(self, layer: QgsVectorLayer) -> None: ...
    def setSourceFields(self, sourceFields: QgsFields) -> None: ...
    def selectionModel(self) -> QtCore.QItemSelectionModel: ...
    def setMapping(self, mapping: Iterable[QgsAggregateMappingModel.Aggregate]) -> None: ...
    def mapping(self) -> List[QgsAggregateMappingModel.Aggregate]: ...
    def model(self) -> QgsAggregateMappingModel: ...


class QgsProcessingAlgorithmConfigurationWidget(QtWidgets.QWidget, QgsExpressionContextGenerator):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def registerProcessingContextGenerator(self, generator: QgsProcessingContextGenerator) -> None: ...
    def algorithm(self) -> QgsProcessingAlgorithm: ...
    def setAlgorithm(self, algorithm: QgsProcessingAlgorithm) -> None: ...
    def widgetContext(self) -> QgsProcessingParameterWidgetContext: ...
    def setWidgetContext(self, context: QgsProcessingParameterWidgetContext) -> None: ...
    def setConfiguration(self, configuration: Dict[str, typing.Any]) -> None: ...
    def configuration(self) -> Dict[str, typing.Any]: ...


class QgsProcessingAlgorithmConfigurationWidgetFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingAlgorithmConfigurationWidgetFactory) -> None: ...

    def canCreateFor(self, algorithm: QgsProcessingAlgorithm) -> bool: ...
    def create(self, algorithm: QgsProcessingAlgorithm) -> QgsProcessingAlgorithmConfigurationWidget: ...


class QgsProcessingParametersGenerator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingParametersGenerator) -> None: ...

    def createProcessingParameters(self) -> Dict[str, typing.Any]: ...


class QgsProcessingAlgorithmDialogBase(QtWidgets.QDialog, QgsProcessingParametersGenerator):

    class LogFormat(int): ...
    FormatPlainText: QgsProcessingAlgorithmDialogBase.LogFormat = ...
    FormatHtml: QgsProcessingAlgorithmDialogBase.LogFormat = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def runAlgorithm(self) -> None: ...
    def finished(self, successful: bool, result: Dict[str, typing.Any], context: QgsProcessingContext, feedback: QgsProcessingFeedback) -> None: ...
    def algorithmFinished(self, successful: bool, result: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def formatStringForLog(string: str) -> str: ...
    def setCurrentTask(self, task: QgsProcessingAlgRunnerTask) -> None: ...
    def hideShortHelp(self) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def blockAdditionalControlsWhileRunning(self) -> None: ...
    def blockControlsWhileRunning(self) -> None: ...
    def updateRunButtonVisibility(self) -> None: ...
    def resetAdditionalGui(self) -> None: ...
    def resetGui(self) -> None: ...
    def setInfo(self, message: str, isError: bool = ..., escapeHtml: bool = ..., isWarning: bool = ...) -> None: ...
    def setResults(self, results: Dict[str, typing.Any]) -> None: ...
    def setExecutedAnyResult(self, executedAnyResult: bool) -> None: ...
    def setExecuted(self, executed: bool) -> None: ...
    def clearProgress(self) -> None: ...
    def tabWidget(self) -> QtWidgets.QTabWidget: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def changeParametersButton(self) -> QtWidgets.QPushButton: ...
    def cancelButton(self) -> QtWidgets.QPushButton: ...
    def runButton(self) -> QtWidgets.QPushButton: ...
    def closeEvent(self, e: QtGui.QCloseEvent) -> None: ...
    def reject(self) -> None: ...
    def showParameters(self) -> None: ...
    def copyLogToClipboard(self) -> None: ...
    def saveLog(self) -> None: ...
    def clearLog(self) -> None: ...
    def createProgressDialog(self) -> QtWidgets.QDialog: ...
    def pushConsoleInfo(self, info: str) -> None: ...
    def setProgressText(self, text: str) -> None: ...
    def setPercentage(self, percent: float) -> None: ...
    def pushCommandInfo(self, info: str) -> None: ...
    def pushDebugInfo(self, message: str) -> None: ...
    def pushInfo(self, info: str) -> None: ...
    def pushWarning(self, warning: str) -> None: ...
    def reportError(self, error: str, fatalError: bool) -> None: ...
    def setLogLevel(self, level: QgsProcessingContext.LogLevel) -> None: ...
    def logLevel(self) -> QgsProcessingContext.LogLevel: ...
    def saveLogToFile(self, path: str, format: QgsProcessingAlgorithmDialogBase.LogFormat = ...) -> None: ...
    def createFeedback(self) -> QgsProcessingFeedback: ...
    def results(self) -> Dict[str, typing.Any]: ...
    def wasExecuted(self) -> bool: ...
    def showLog(self) -> None: ...
    def mainWidget(self) -> QgsPanelWidget: ...
    def setMainWidget(self, widget: QgsPanelWidget) -> None: ...
    def algorithm(self) -> QgsProcessingAlgorithm: ...
    def setAlgorithm(self, algorithm: QgsProcessingAlgorithm) -> None: ...


class QgsProcessingGui(sip.wrapper):

    class WidgetType(int): ...
    Standard: QgsProcessingGui.WidgetType = ...
    Batch: QgsProcessingGui.WidgetType = ...
    Modeler: QgsProcessingGui.WidgetType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingGui) -> None: ...


class QgsProcessingGuiRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingGuiRegistry) -> None: ...

    def createParameterDefinitionWidget(self, type: str, context: QgsProcessingContext, widgetContext: QgsProcessingParameterWidgetContext, definition: Optional[QgsProcessingParameterDefinition] = ..., algorithm: Optional[QgsProcessingAlgorithm] = ...) -> QgsProcessingAbstractParameterDefinitionWidget: ...
    def createModelerParameterWidget(self, model: QgsProcessingModelAlgorithm, childId: str, parameter: QgsProcessingParameterDefinition, context: QgsProcessingContext) -> QgsProcessingModelerParameterWidget: ...
    def createParameterWidgetWrapper(self, parameter: QgsProcessingParameterDefinition, type: QgsProcessingGui.WidgetType) -> QgsAbstractProcessingParameterWidgetWrapper: ...
    def removeParameterWidgetFactory(self, factory: QgsProcessingParameterWidgetFactoryInterface) -> None: ...
    def addParameterWidgetFactory(self, factory: QgsProcessingParameterWidgetFactoryInterface) -> bool: ...
    def algorithmConfigurationWidget(self, algorithm: QgsProcessingAlgorithm) -> QgsProcessingAlgorithmConfigurationWidget: ...
    def removeAlgorithmConfigurationWidgetFactory(self, factory: QgsProcessingAlgorithmConfigurationWidgetFactory) -> None: ...
    def addAlgorithmConfigurationWidgetFactory(self, factory: QgsProcessingAlgorithmConfigurationWidgetFactory) -> None: ...


class QgsProcessingMapLayerComboBox(QtWidgets.QWidget):

    def __init__(self, parameter: QgsProcessingParameterDefinition, type: QgsProcessingGui.WidgetType = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...
    def valueChanged(self) -> None: ...
    def isEditable(self) -> bool: ...
    def setEditable(self, editable: bool) -> None: ...
    def setWidgetContext(self, context: QgsProcessingParameterWidgetContext) -> None: ...
    def value(self) -> typing.Any: ...
    def setValue(self, value: typing.Any, context: QgsProcessingContext) -> None: ...
    def currentText(self) -> str: ...
    def currentLayer(self) -> QgsMapLayer: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...


class QgsProcessingModelerParameterWidget(QtWidgets.QWidget, QgsExpressionContextGenerator):

    def __init__(self, model: QgsProcessingModelAlgorithm, childId: str, parameter: QgsProcessingParameterDefinition, context: QgsProcessingContext, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def setDialog(self, dialog: QtWidgets.QDialog) -> None: ...
    def value(self) -> typing.Any: ...
    def modelOutputName(self) -> str: ...
    def isModelOutput(self) -> bool: ...
    def setToModelOutput(self, value: str) -> None: ...
    @overload
    def setWidgetValue(self, value: QgsProcessingModelChildParameterSource) -> None: ...
    @overload
    def setWidgetValue(self, values: Iterable[QgsProcessingModelChildParameterSource]) -> None: ...
    def createLabel(self) -> QtWidgets.QLabel: ...
    def parameterDefinition(self) -> QgsProcessingParameterDefinition: ...
    def setExpressionHelpText(self, text: str) -> None: ...
    def populateSources(self, compatibleParameterTypes: Iterable[str], compatibleOutputTypes: Iterable[str], compatibleDataTypes: Iterable[int]) -> None: ...
    def registerProcessingContextGenerator(self, generator: QgsProcessingContextGenerator) -> None: ...
    def setWidgetContext(self, context: QgsProcessingParameterWidgetContext) -> None: ...


class QgsProcessingMultipleSelectionPanelWidget(QgsPanelWidget):

    def __init__(self, availableOptions: Iterable[typing.Any] = ..., selectedOptions: Iterable[typing.Any] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def listView(self) -> QtWidgets.QListView: ...
    def addOption(self, value: typing.Any, title: str, selected: bool, updateExistingTitle: bool = ...) -> None: ...
    def selectionChanged(self) -> None: ...
    def acceptClicked(self) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def selectedOptions(self) -> List[typing.Any]: ...
    def setValueFormatter(self, a0: Callable[..., None]) -> None: ...


class QgsProcessingMultipleSelectionDialog(QtWidgets.QDialog):

    def __init__(self, availableOptions: Iterable[typing.Any] = ..., selectedOptions: Iterable[typing.Any] = ..., parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def selectedOptions(self) -> List[typing.Any]: ...
    def setValueFormatter(self, a0: Callable[..., None]) -> None: ...


class QgsProcessingMultipleInputPanelWidget(QgsProcessingMultipleSelectionPanelWidget):

    def __init__(self, parameter: QgsProcessingParameterMultipleLayers, selectedOptions: Iterable[typing.Any], modelSources: Iterable[QgsProcessingModelChildParameterSource], model: Optional[QgsProcessingModelAlgorithm] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setProject(self, project: QgsProject) -> None: ...


class QgsProcessingMultipleInputDialog(QtWidgets.QDialog):

    def __init__(self, parameter: QgsProcessingParameterMultipleLayers, selectedOptions: Iterable[typing.Any], modelSources: Iterable[QgsProcessingModelChildParameterSource], model: Optional[QgsProcessingModelAlgorithm] = ..., parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setProject(self, project: QgsProject) -> None: ...
    def selectedOptions(self) -> List[typing.Any]: ...


class QgsProcessingLayerOutputDestinationWidget(QtWidgets.QWidget):

    def __init__(self, parameter: QgsProcessingDestinationParameter, defaultSelection: bool, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragLeaveEvent(self, event: QtGui.QDragLeaveEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...
    def destinationChanged(self) -> None: ...
    def skipOutputChanged(self, skipped: bool) -> None: ...
    def openAfterRunning(self) -> bool: ...
    def addOpenAfterRunningOption(self) -> None: ...
    def registerProcessingParametersGenerator(self, generator: QgsProcessingParametersGenerator) -> None: ...
    def setContext(self, context: QgsProcessingContext) -> None: ...
    def setWidgetContext(self, context: QgsProcessingParameterWidgetContext) -> None: ...
    def value(self) -> typing.Any: ...
    def setValue(self, value: typing.Any) -> None: ...
    def outputIsSkipped(self) -> bool: ...


class QgsProcessingAbstractParameterDefinitionWidget(QtWidgets.QWidget, QgsExpressionContextGenerator):

    def __init__(self, context: QgsProcessingContext, widgetContext: QgsProcessingParameterWidgetContext, definition: Optional[QgsProcessingParameterDefinition] = ..., algorithm: Optional[QgsProcessingAlgorithm] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def registerProcessingContextGenerator(self, generator: QgsProcessingContextGenerator) -> None: ...
    def widgetContext(self) -> QgsProcessingParameterWidgetContext: ...
    def setWidgetContext(self, context: QgsProcessingParameterWidgetContext) -> None: ...
    def createParameter(self, name: str, description: str, flags: Union[QgsProcessingParameterDefinition.Flags, QgsProcessingParameterDefinition.Flag]) -> QgsProcessingParameterDefinition: ...


class QgsProcessingParameterDefinitionWidget(QtWidgets.QWidget):

    def __init__(self, type: str, context: QgsProcessingContext, widgetContext: QgsProcessingParameterWidgetContext, definition: Optional[QgsProcessingParameterDefinition] = ..., algorithm: Optional[QgsProcessingAlgorithm] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def registerProcessingContextGenerator(self, generator: QgsProcessingContextGenerator) -> None: ...
    def createParameter(self, name: str = ...) -> QgsProcessingParameterDefinition: ...


class QgsProcessingParameterDefinitionDialog(QtWidgets.QDialog):

    def __init__(self, type: str, context: QgsProcessingContext, widgetContext: QgsProcessingParameterWidgetContext, definition: Optional[QgsProcessingParameterDefinition] = ..., algorithm: Optional[QgsProcessingAlgorithm] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def accept(self) -> None: ...
    def registerProcessingContextGenerator(self, generator: QgsProcessingContextGenerator) -> None: ...
    def switchToCommentTab(self) -> None: ...
    def commentColor(self) -> QtGui.QColor: ...
    def setCommentColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def comments(self) -> str: ...
    def setComments(self, comments: str) -> None: ...
    def createParameter(self, name: str = ...) -> QgsProcessingParameterDefinition: ...


class QgsProcessingParametersWidget(QgsPanelWidget, QgsProcessingParametersGenerator):

    def __init__(self, algorithm: QgsProcessingAlgorithm, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def addExtraWidget(self, widget: QtWidgets.QWidget) -> None: ...
    def addOutputWidget(self, widget: QtWidgets.QWidget, stretch: int = ...) -> None: ...
    def addOutputLabel(self, label: QtWidgets.QWidget) -> None: ...
    def addParameterLabel(self, parameter: QgsProcessingParameterDefinition, label: QtWidgets.QWidget) -> None: ...
    def addParameterWidget(self, parameter: QgsProcessingParameterDefinition, widget: QtWidgets.QWidget, stretch: int = ...) -> None: ...
    def initWidgets(self) -> None: ...
    def algorithm(self) -> QgsProcessingAlgorithm: ...


class QgsProcessingRecentAlgorithmLog(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def changed(self) -> None: ...
    def push(self, id: str) -> None: ...
    def recentAlgorithmIds(self) -> List[str]: ...


class QgsProcessingToolboxModelNode(QtCore.QObject):

    class NodeType(int): ...
    NodeProvider: QgsProcessingToolboxModelNode.NodeType = ...
    NodeGroup: QgsProcessingToolboxModelNode.NodeType = ...
    NodeAlgorithm: QgsProcessingToolboxModelNode.NodeType = ...
    NodeRecent: QgsProcessingToolboxModelNode.NodeType = ...

    def __init__(self) -> None: ...

    def deleteChildren(self) -> None: ...
    def addChildNode(self, node: QgsProcessingToolboxModelNode) -> None: ...
    def getChildGroupNode(self, id: str) -> QgsProcessingToolboxModelGroupNode: ...
    def takeChild(self, node: QgsProcessingToolboxModelNode) -> QgsProcessingToolboxModelNode: ...
    def children(self) -> List[QgsProcessingToolboxModelNode]: ...
    def parent(self) -> QgsProcessingToolboxModelNode: ...
    def nodeType(self) -> 'QgsProcessingToolboxModelNode.NodeType': ...


class QgsProcessingToolboxModelRecentNode(QgsProcessingToolboxModelNode):

    def __init__(self) -> None: ...

    def nodeType(self) -> QgsProcessingToolboxModelNode.NodeType: ...


class QgsProcessingToolboxModelProviderNode(QgsProcessingToolboxModelNode):

    def __init__(self, provider: QgsProcessingProvider) -> None: ...

    def providerId(self) -> str: ...
    def provider(self) -> QgsProcessingProvider: ...
    def nodeType(self) -> QgsProcessingToolboxModelNode.NodeType: ...


class QgsProcessingToolboxModelGroupNode(QgsProcessingToolboxModelNode):

    def __init__(self, id: str, name: str) -> None: ...

    def name(self) -> str: ...
    def id(self) -> str: ...
    def nodeType(self) -> QgsProcessingToolboxModelNode.NodeType: ...


class QgsProcessingToolboxModelAlgorithmNode(QgsProcessingToolboxModelNode):

    def __init__(self, algorithm: QgsProcessingAlgorithm) -> None: ...

    def algorithm(self) -> QgsProcessingAlgorithm: ...
    def nodeType(self) -> QgsProcessingToolboxModelNode.NodeType: ...


class QgsProcessingToolboxModel(QtCore.QAbstractItemModel):

    class Roles(int): ...
    RoleNodeType: QgsProcessingToolboxModel.Roles = ...
    RoleAlgorithmFlags: QgsProcessingToolboxModel.Roles = ...
    RoleAlgorithmId: QgsProcessingToolboxModel.Roles = ...
    RoleAlgorithmName: QgsProcessingToolboxModel.Roles = ...
    RoleAlgorithmShortDescription: QgsProcessingToolboxModel.Roles = ...
    RoleAlgorithmTags: QgsProcessingToolboxModel.Roles = ...
    RoleProviderFlags: QgsProcessingToolboxModel.Roles = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ..., registry: Optional[QgsProcessingRegistry] = ..., recentLog: Optional[QgsProcessingRecentAlgorithmLog] = ...) -> None: ...

    def recentAlgorithmAdded(self) -> None: ...
    def indexOfParentTreeNode(self, parentNode: QgsProcessingToolboxModelNode) -> QtCore.QModelIndex: ...
    def indexForProvider(self, providerId: str) -> QtCore.QModelIndex: ...
    def isAlgorithm(self, index: QtCore.QModelIndex) -> bool: ...
    def algorithmForIndex(self, index: QtCore.QModelIndex) -> QgsProcessingAlgorithm: ...
    def providerIdForIndex(self, index: QtCore.QModelIndex) -> str: ...
    def providerForIndex(self, index: QtCore.QModelIndex) -> QgsProcessingProvider: ...
    def node2index(self, node: QgsProcessingToolboxModelNode) -> QtCore.QModelIndex: ...
    def index2node(self, index: QtCore.QModelIndex) -> QgsProcessingToolboxModelNode: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, a0: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...


class QgsProcessingToolboxProxyModel(QtCore.QSortFilterProxyModel):

    class Filter(int): ...
    FilterToolbox: QgsProcessingToolboxProxyModel.Filter = ...
    FilterModeler: QgsProcessingToolboxProxyModel.Filter = ...
    FilterInPlace: QgsProcessingToolboxProxyModel.Filter = ...
    FilterShowKnownIssues: QgsProcessingToolboxProxyModel.Filter = ...

    class Filters(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsProcessingToolboxProxyModel.Filters', 'QgsProcessingToolboxProxyModel.Filter']) -> None: ...
        @overload
        def __init__(self, a0: QgsProcessingToolboxProxyModel.Filters) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsProcessingToolboxProxyModel.Filters': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ..., registry: Optional[QgsProcessingRegistry] = ..., recentLog: Optional[QgsProcessingRecentAlgorithmLog] = ...) -> None: ...

    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def filterString(self) -> str: ...
    def setFilterString(self, filter: str) -> None: ...
    def setInPlaceLayer(self, layer: QgsVectorLayer) -> None: ...
    def filters(self) -> 'QgsProcessingToolboxProxyModel.Filters': ...
    def setFilters(self, filters: Union['QgsProcessingToolboxProxyModel.Filters', 'QgsProcessingToolboxProxyModel.Filter']) -> None: ...
    def toolboxModel(self) -> QgsProcessingToolboxModel: ...


class QgsProcessingToolboxTreeView(QtWidgets.QTreeView):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., registry: Optional[QgsProcessingRegistry] = ..., recentLog: Optional[QgsProcessingRecentAlgorithmLog] = ...) -> None: ...

    def setFilterString(self, filter: str) -> None: ...
    def setInPlaceLayer(self, layer: QgsVectorLayer) -> None: ...
    def filters(self) -> QgsProcessingToolboxProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsProcessingToolboxProxyModel.Filters, QgsProcessingToolboxProxyModel.Filter]) -> None: ...
    def selectedAlgorithm(self) -> QgsProcessingAlgorithm: ...
    def algorithmForIndex(self, index: QtCore.QModelIndex) -> QgsProcessingAlgorithm: ...
    def setToolboxProxyModel(self, model: QgsProcessingToolboxProxyModel) -> None: ...
    def setRegistry(self, registry: QgsProcessingRegistry, recentLog: Optional[QgsProcessingRecentAlgorithmLog] = ...) -> None: ...


class QgsProcessingContextGenerator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingContextGenerator) -> None: ...

    def processingContext(self) -> QgsProcessingContext: ...


class QgsProcessingParameterWidgetContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingParameterWidgetContext) -> None: ...

    def setActiveLayer(self, layer: QgsMapLayer) -> None: ...
    def activeLayer(self) -> QgsMapLayer: ...
    def setModelChildAlgorithmId(self, id: str) -> None: ...
    def modelChildAlgorithmId(self) -> str: ...
    def setModel(self, model: QgsProcessingModelAlgorithm) -> None: ...
    def model(self) -> QgsProcessingModelAlgorithm: ...
    def project(self) -> QgsProject: ...
    def setProject(self, project: QgsProject) -> None: ...
    def browserModel(self) -> QgsBrowserGuiModel: ...
    def setBrowserModel(self, model: QgsBrowserGuiModel) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...


class QgsAbstractProcessingParameterWidgetWrapper(QtCore.QObject, QgsExpressionContextGenerator):

    def __init__(self, parameter: Optional[QgsProcessingParameterDefinition] = ..., type: QgsProcessingGui.WidgetType = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def linkedVectorLayer(self) -> QgsVectorLayer: ...
    def widgetValue(self) -> typing.Any: ...
    def setWidgetValue(self, value: typing.Any, context: QgsProcessingContext) -> None: ...
    def createLabel(self) -> QtWidgets.QLabel: ...
    def createWidget(self) -> QtWidgets.QWidget: ...
    def widgetValueHasChanged(self, wrapper: QgsAbstractProcessingParameterWidgetWrapper) -> None: ...
    def setDialog(self, dialog: QtWidgets.QDialog) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def stretch(self) -> int: ...
    def postInitialize(self, wrappers: Iterable[QgsAbstractProcessingParameterWidgetWrapper]) -> None: ...
    def registerProcessingParametersGenerator(self, generator: QgsProcessingParametersGenerator) -> None: ...
    def registerProcessingContextGenerator(self, generator: QgsProcessingContextGenerator) -> None: ...
    def customProperties(self) -> Dict[str, typing.Any]: ...
    def parameterValue(self) -> typing.Any: ...
    def setParameterValue(self, value: typing.Any, context: QgsProcessingContext) -> None: ...
    def parameterDefinition(self) -> QgsProcessingParameterDefinition: ...
    def wrappedLabel(self) -> QtWidgets.QLabel: ...
    def wrappedWidget(self) -> QtWidgets.QWidget: ...
    def createWrappedLabel(self) -> QtWidgets.QLabel: ...
    def createWrappedWidget(self, context: QgsProcessingContext) -> QtWidgets.QWidget: ...
    def widgetContext(self) -> QgsProcessingParameterWidgetContext: ...
    def setWidgetContext(self, context: QgsProcessingParameterWidgetContext) -> None: ...
    def type(self) -> QgsProcessingGui.WidgetType: ...
    @property
    def param(self) -> QgsProcessingParameterDefinition: ...


class QgsProcessingParameterWidgetFactoryInterface(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProcessingParameterWidgetFactoryInterface) -> None: ...

    def modelerExpressionFormatString(self) -> str: ...
    def compatibleDataTypes(self, parameter: QgsProcessingParameterDefinition) -> List[int]: ...
    def compatibleOutputTypes(self) -> List[str]: ...
    def compatibleParameterTypes(self) -> List[str]: ...
    def createParameterDefinitionWidget(self, context: QgsProcessingContext, widgetContext: QgsProcessingParameterWidgetContext, definition: Optional[QgsProcessingParameterDefinition] = ..., algorithm: Optional[QgsProcessingAlgorithm] = ...) -> QgsProcessingAbstractParameterDefinitionWidget: ...
    def createModelerWidgetWrapper(self, model: QgsProcessingModelAlgorithm, childId: str, parameter: QgsProcessingParameterDefinition, context: QgsProcessingContext) -> QgsProcessingModelerParameterWidget: ...
    def createWidgetWrapper(self, parameter: QgsProcessingParameterDefinition, type: QgsProcessingGui.WidgetType) -> QgsAbstractProcessingParameterWidgetWrapper: ...
    def parameterType(self) -> str: ...


class QgsProcessingHiddenWidgetWrapper(QgsAbstractProcessingParameterWidgetWrapper):

    def __init__(self, parameter: Optional[QgsProcessingParameterDefinition] = ..., type: QgsProcessingGui.WidgetType = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def createLabel(self) -> QtWidgets.QLabel: ...
    def createWidget(self) -> QtWidgets.QWidget: ...
    def setLinkedVectorLayer(self, layer: QgsVectorLayer) -> None: ...
    def linkedVectorLayer(self) -> QgsVectorLayer: ...
    def widgetValue(self) -> typing.Any: ...
    def setWidgetValue(self, value: typing.Any, context: QgsProcessingContext) -> None: ...


class QgsModelArrowItem(QtCore.QObject, QtWidgets.QGraphicsPathItem):

    class Marker(int): ...
    Circle: QgsModelArrowItem.Marker = ...
    ArrowHead: QgsModelArrowItem.Marker = ...

    @overload
    def __init__(self, startItem: QgsModelComponentGraphicItem, startEdge: QtCore.Qt.Edge, startIndex: int, startIsOutgoing: bool, startMarker: QgsModelArrowItem.Marker, endItem: QgsModelComponentGraphicItem, endEdge: QtCore.Qt.Edge, endIndex: int, endIsIncoming: bool, endMarker: QgsModelArrowItem.Marker) -> None: ...
    @overload
    def __init__(self, startItem: QgsModelComponentGraphicItem, startEdge: QtCore.Qt.Edge, startIndex: int, startMarker: QgsModelArrowItem.Marker, endItem: QgsModelComponentGraphicItem, endMarker: QgsModelArrowItem.Marker) -> None: ...
    @overload
    def __init__(self, startItem: QgsModelComponentGraphicItem, startMarker: QgsModelArrowItem.Marker, endItem: QgsModelComponentGraphicItem, endEdge: QtCore.Qt.Edge, endIndex: int, endMarker: QgsModelArrowItem.Marker) -> None: ...
    @overload
    def __init__(self, startItem: QgsModelComponentGraphicItem, startMarker: QgsModelArrowItem.Marker, endItem: QgsModelComponentGraphicItem, endMarker: QgsModelArrowItem.Marker) -> None: ...

    def updatePath(self) -> None: ...
    def setPenStyle(self, style: QtCore.Qt.PenStyle) -> None: ...
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionGraphicsItem, widget: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsModelComponentGraphicItem(QtWidgets.QGraphicsObject):

    class Flag(int): ...

    class State(int): ...
    Normal: QgsModelComponentGraphicItem.State = ...
    Selected: QgsModelComponentGraphicItem.State = ...
    Hover: QgsModelComponentGraphicItem.State = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsModelComponentGraphicItem.Flags', 'QgsModelComponentGraphicItem.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsModelComponentGraphicItem.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsModelComponentGraphicItem.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self, component: QgsProcessingModelComponent, model: QgsProcessingModelAlgorithm, parent: QtWidgets.QGraphicsItem) -> None: ...

    def updateButtonPositions(self) -> None: ...
    def updateStoredComponentPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF) -> None: ...
    def iconPixmap(self) -> QtGui.QPixmap: ...
    def iconPicture(self) -> QtGui.QPicture: ...
    def titleAlignment(self) -> QtCore.Qt.Alignment: ...
    def strokeStyle(self, state: QgsModelComponentGraphicItem.State) -> QtCore.Qt.PenStyle: ...
    def textColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def strokeColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def fillColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def truncatedTextForItem(self, text: str) -> str: ...
    def editComponent(self) -> None: ...
    def sizePositionChanged(self) -> None: ...
    def updateArrowPaths(self) -> None: ...
    def repaintArrows(self) -> None: ...
    def changed(self) -> None: ...
    def aboutToChange(self, text: str, id: int = ...) -> None: ...
    def requestModelRepaint(self) -> None: ...
    def deleteComponent(self) -> None: ...
    def canDeleteComponent(self) -> bool: ...
    def editComment(self) -> None: ...
    @overload
    def calculateAutomaticLinkPoint(self, other: QgsModelComponentGraphicItem) -> Tuple[QtCore.QPointF, QtCore.Qt.Edge]: ...
    @overload
    def calculateAutomaticLinkPoint(self, point: Union[QtCore.QPointF, QtCore.QPoint]) -> Tuple[QtCore.QPointF, QtCore.Qt.Edge]: ...
    def linkPoint(self, edge: QtCore.Qt.Edge, index: int, incoming: bool) -> QtCore.QPointF: ...
    def linkPointText(self, edge: QtCore.Qt.Edge, index: int) -> str: ...
    def linkPointCount(self, edge: QtCore.Qt.Edge) -> int: ...
    def state(self) -> 'QgsModelComponentGraphicItem.State': ...
    def setLabel(self, label: str) -> None: ...
    def label(self) -> str: ...
    def itemRect(self, storedRect: bool = ...) -> QtCore.QRectF: ...
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionGraphicsItem, widget: Optional[QtWidgets.QWidget] = ...) -> None: ...
    def contains(self, point: Union[QtCore.QPointF, QtCore.QPoint]) -> bool: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def itemChange(self, change: QtWidgets.QGraphicsItem.GraphicsItemChange, value: typing.Any) -> typing.Any: ...
    def hoverLeaveEvent(self, event: QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverMoveEvent(self, event: QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverEnterEvent(self, event: QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def setItemRect(self, rect: QtCore.QRectF) -> None: ...
    def previewItemMove(self, dx: float, dy: float) -> None: ...
    def moveComponentBy(self, dx: float, dy: float) -> None: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def view(self) -> QgsModelGraphicsView: ...
    def model(self) -> QgsProcessingModelAlgorithm: ...
    def component(self) -> QgsProcessingModelComponent: ...
    def flags(self) -> 'QgsModelComponentGraphicItem.Flags': ...


class QgsModelParameterGraphicItem(QgsModelComponentGraphicItem):

    def __init__(self, parameter: QgsProcessingModelParameter, model: QgsProcessingModelAlgorithm, parent: QtWidgets.QGraphicsItem) -> None: ...

    def deleteComponent(self) -> None: ...
    def updateStoredComponentPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF) -> None: ...
    def iconPicture(self) -> QtGui.QPicture: ...
    def textColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def strokeColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def fillColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def canDeleteComponent(self) -> bool: ...
    def contextMenuEvent(self, event: QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...


class QgsModelChildAlgorithmGraphicItem(QgsModelComponentGraphicItem):

    def __init__(self, child: QgsProcessingModelChildAlgorithm, model: QgsProcessingModelAlgorithm, parent: QtWidgets.QGraphicsItem) -> None: ...

    def deleteComponent(self) -> None: ...
    def updateStoredComponentPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF) -> None: ...
    def linkPointText(self, edge: QtCore.Qt.Edge, index: int) -> str: ...
    def linkPointCount(self, edge: QtCore.Qt.Edge) -> int: ...
    def iconPicture(self) -> QtGui.QPicture: ...
    def iconPixmap(self) -> QtGui.QPixmap: ...
    def textColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def strokeColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def fillColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def setInputs(self, inputs: Dict[str, typing.Any]) -> None: ...
    def setResults(self, results: Dict[str, typing.Any]) -> None: ...
    def canDeleteComponent(self) -> bool: ...
    def contextMenuEvent(self, event: QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...


class QgsModelOutputGraphicItem(QgsModelComponentGraphicItem):

    def __init__(self, output: QgsProcessingModelOutput, model: QgsProcessingModelAlgorithm, parent: QtWidgets.QGraphicsItem) -> None: ...

    def deleteComponent(self) -> None: ...
    def updateStoredComponentPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF) -> None: ...
    def iconPicture(self) -> QtGui.QPicture: ...
    def textColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def strokeColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def fillColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def canDeleteComponent(self) -> bool: ...


class QgsModelCommentGraphicItem(QgsModelComponentGraphicItem):

    def __init__(self, comment: QgsProcessingModelComment, parentItem: QgsModelComponentGraphicItem, model: QgsProcessingModelAlgorithm, parent: QtWidgets.QGraphicsItem) -> None: ...

    def editComponent(self) -> None: ...
    def deleteComponent(self) -> None: ...
    def updateStoredComponentPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF) -> None: ...
    def strokeStyle(self, state: QgsModelComponentGraphicItem.State) -> QtCore.Qt.PenStyle: ...
    def textColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def strokeColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def fillColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def parentComponentItem(self) -> QgsModelComponentGraphicItem: ...
    def canDeleteComponent(self) -> bool: ...
    def contextMenuEvent(self, event: QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...


class QgsModelGroupBoxGraphicItem(QgsModelComponentGraphicItem):

    def __init__(self, box: QgsProcessingModelGroupBox, model: QgsProcessingModelAlgorithm, parent: QtWidgets.QGraphicsItem) -> None: ...

    def editComponent(self) -> None: ...
    def deleteComponent(self) -> None: ...
    def updateStoredComponentPosition(self, pos: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF) -> None: ...
    def titleAlignment(self) -> QtCore.Qt.Alignment: ...
    def strokeStyle(self, state: QgsModelComponentGraphicItem.State) -> QtCore.Qt.PenStyle: ...
    def textColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def strokeColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def fillColor(self, state: QgsModelComponentGraphicItem.State) -> QtGui.QColor: ...
    def canDeleteComponent(self) -> bool: ...
    def contextMenuEvent(self, event: QtWidgets.QGraphicsSceneContextMenuEvent) -> None: ...


class QgsModelDesignerDialog(QtWidgets.QMainWindow):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setLastRunChildAlgorithmInputs(self, inputs: Dict[str, typing.Any]) -> None: ...
    def setLastRunChildAlgorithmResults(self, results: Dict[str, typing.Any]) -> None: ...
    def checkForUnsavedChanges(self) -> bool: ...
    def validateSave(self) -> bool: ...
    def setDirty(self, dirty: bool) -> None: ...
    def view(self) -> QtWidgets.QGraphicsView: ...
    def messageBar(self) -> QgsMessageBar: ...
    def actionRun(self) -> QtWidgets.QAction: ...
    def actionEditHelp(self) -> QtWidgets.QAction: ...
    def actionSaveInProject(self) -> QtWidgets.QAction: ...
    def actionOpen(self) -> QtWidgets.QAction: ...
    def toolbar(self) -> QtWidgets.QToolBar: ...
    def saveModel(self, saveAs: bool = ...) -> None: ...
    def exportAsScriptAlgorithm(self) -> None: ...
    def addInput(self, inputId: str, pos: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def addAlgorithm(self, algorithmId: str, pos: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def repaintModel(self, showControls: bool = ...) -> None: ...
    def setModelScene(self, scene: QgsModelGraphicsScene) -> None: ...
    def loadModel(self, path: str) -> None: ...
    def setModel(self, model: QgsProcessingModelAlgorithm) -> None: ...
    def model(self) -> QgsProcessingModelAlgorithm: ...
    def endUndoCommand(self) -> None: ...
    def beginUndoCommand(self, text: str, id: int = ...) -> None: ...
    def closeEvent(self, event: QtGui.QCloseEvent) -> None: ...


class QgsModelChildDependenciesWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget, model: QgsProcessingModelAlgorithm, childId: str) -> None: ...

    def setValue(self, value: Iterable[QgsProcessingModelChildDependency]) -> None: ...
    def value(self) -> List[QgsProcessingModelChildDependency]: ...


class QgsModelDesignerFlatButtonGraphicItem(QtWidgets.QGraphicsObject):

    def __init__(self, parent: QtWidgets.QGraphicsItem, picture: QtGui.QPicture, position: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF = ...) -> None: ...

    def setPicture(self, picture: QtGui.QPicture) -> None: ...
    def clicked(self) -> None: ...
    def view(self) -> QgsModelGraphicsView: ...
    def setPosition(self, position: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def mousePressEvent(self, event: QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def hoverLeaveEvent(self, event: QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def hoverEnterEvent(self, event: QtWidgets.QGraphicsSceneHoverEvent) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionGraphicsItem, widget: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsModelDesignerFoldButtonGraphicItem(QgsModelDesignerFlatButtonGraphicItem):

    def __init__(self, parent: QtWidgets.QGraphicsItem, folded: bool, position: Union[QtCore.QPointF, QtCore.QPoint], size: QtCore.QSizeF = ...) -> None: ...

    def folded(self, folded: bool) -> None: ...
    def mousePressEvent(self, event: QtWidgets.QGraphicsSceneMouseEvent) -> None: ...


class QgsModelGraphicsScene(QtWidgets.QGraphicsScene):

    class Flag(int): ...
    FlagHideControls: QgsModelGraphicsScene.Flag = ...
    FlagHideComments: QgsModelGraphicsScene.Flag = ...

    class ZValues(int): ...
    GroupBox: QgsModelGraphicsScene.ZValues = ...
    ArrowLink: QgsModelGraphicsScene.ZValues = ...
    ModelComponent: QgsModelGraphicsScene.ZValues = ...
    MouseHandles: QgsModelGraphicsScene.ZValues = ...
    RubberBand: QgsModelGraphicsScene.ZValues = ...
    ZSnapIndicator: QgsModelGraphicsScene.ZValues = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union['QgsModelGraphicsScene.Flags', 'QgsModelGraphicsScene.Flag']) -> None: ...
        @overload
        def __init__(self, a0: QgsModelGraphicsScene.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> 'QgsModelGraphicsScene.Flags': ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def createGroupBoxGraphicItem(self, model: QgsProcessingModelAlgorithm, box: QgsProcessingModelGroupBox) -> QgsModelComponentGraphicItem: ...
    def createCommentGraphicItem(self, model: QgsProcessingModelAlgorithm, comment: QgsProcessingModelComment, parentItem: QgsModelComponentGraphicItem) -> QgsModelComponentGraphicItem: ...
    def createOutputGraphicItem(self, model: QgsProcessingModelAlgorithm, output: QgsProcessingModelOutput) -> QgsModelComponentGraphicItem: ...
    def createChildAlgGraphicItem(self, model: QgsProcessingModelAlgorithm, child: QgsProcessingModelChildAlgorithm) -> QgsModelChildAlgorithmGraphicItem: ...
    def createParameterGraphicItem(self, model: QgsProcessingModelAlgorithm, param: QgsProcessingModelParameter) -> QgsModelComponentGraphicItem: ...
    def selectedItemChanged(self, selected: QgsModelComponentGraphicItem) -> None: ...
    def componentChanged(self) -> None: ...
    def componentAboutToChange(self, text: str, id: int = ...) -> None: ...
    def rebuildRequired(self) -> None: ...
    def showWarning(self, shortMessage: str, title: str, longMessage: str, level: Qgis.MessageLevel = ...) -> None: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setChildAlgorithmInputs(self, inputs: Dict[str, typing.Any]) -> None: ...
    def setChildAlgorithmResults(self, results: Dict[str, typing.Any]) -> None: ...
    def setSelectedItem(self, item: QgsModelComponentGraphicItem) -> None: ...
    def deselectAll(self) -> None: ...
    def selectAll(self) -> None: ...
    def groupBoxItem(self, uuid: str) -> QgsModelComponentGraphicItem: ...
    def componentItemAt(self, position: Union[QtCore.QPointF, QtCore.QPoint]) -> QgsModelComponentGraphicItem: ...
    def selectedComponentItems(self) -> List[QgsModelComponentGraphicItem]: ...
    def createItems(self, model: QgsProcessingModelAlgorithm, context: QgsProcessingContext) -> None: ...
    def mousePressEvent(self, event: QtWidgets.QGraphicsSceneMouseEvent) -> None: ...
    def flags(self) -> 'QgsModelGraphicsScene.Flags': ...
    def setFlag(self, flag: QgsModelGraphicsScene.Flag, on: bool = ...) -> None: ...
    def setFlags(self, flags: Union['QgsModelGraphicsScene.Flags', 'QgsModelGraphicsScene.Flag']) -> None: ...
    def setModel(self, model: QgsProcessingModelAlgorithm) -> None: ...
    def model(self) -> QgsProcessingModelAlgorithm: ...


class QgsModelGraphicsView(QtWidgets.QGraphicsView):

    class PasteMode(int): ...
    PasteModeCursor: QgsModelGraphicsView.PasteMode = ...
    PasteModeCenter: QgsModelGraphicsView.PasteMode = ...
    PasteModeInPlace: QgsModelGraphicsView.PasteMode = ...

    class ClipboardOperation(int): ...
    ClipboardCut: QgsModelGraphicsView.ClipboardOperation = ...
    ClipboardCopy: QgsModelGraphicsView.ClipboardOperation = ...

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def deleteSelectedItems(self) -> None: ...
    def endCommand(self) -> None: ...
    def beginCommand(self, text: str) -> None: ...
    def macroCommandEnded(self) -> None: ...
    def macroCommandStarted(self, text: str) -> None: ...
    def willBeDeleted(self) -> None: ...
    def itemFocused(self, item: QgsModelComponentGraphicItem) -> None: ...
    def inputDropped(self, inputId: str, pos: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def algorithmDropped(self, algorithmId: str, pos: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def snapSelected(self) -> None: ...
    def pasteItems(self, mode: QgsModelGraphicsView.PasteMode) -> None: ...
    def copyItems(self, items: Iterable[QgsModelComponentGraphicItem], operation: QgsModelGraphicsView.ClipboardOperation) -> None: ...
    def copySelectedItems(self, operation: QgsModelGraphicsView.ClipboardOperation) -> None: ...
    def endMacroCommand(self) -> None: ...
    def startMacroCommand(self, text: str) -> None: ...
    def modelScene(self) -> QgsModelGraphicsScene: ...
    def setModelScene(self, scene: QgsModelGraphicsScene) -> None: ...
    def keyReleaseEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def mouseDoubleClickEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseReleaseEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def wheelEvent(self, event: QtGui.QWheelEvent) -> None: ...
    def dragMoveEvent(self, event: QtGui.QDragMoveEvent) -> None: ...
    def dropEvent(self, event: QtGui.QDropEvent) -> None: ...
    def dragEnterEvent(self, event: QtGui.QDragEnterEvent) -> None: ...


class QgsModelViewSnapMarker(QtWidgets.QGraphicsRectItem):

    def __init__(self) -> None: ...

    def paint(self, painter: QtGui.QPainter, option: QtWidgets.QStyleOptionGraphicsItem, widget: Optional[QtWidgets.QWidget] = ...) -> None: ...


class QgsColorRampShaderWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def populateColormapTreeWidget(self, colorRampItems: Iterable[QgsColorRampShader.ColorRampItem]) -> None: ...
    def loadMinimumMaximumFromTree(self) -> None: ...
    def classify(self) -> None: ...
    def classificationModeChanged(self, mode: QgsColorRampShader.ClassificationMode) -> None: ...
    def widgetChanged(self) -> None: ...
    def minimumMaximumChangedFromTree(self, minimum: float, maximum: float) -> None: ...
    def setFromShader(self, colorRampShader: QgsColorRampShader) -> None: ...
    def shader(self) -> QgsColorRampShader: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def setMinimumMaximum(self, minimum: float, maximum: float) -> None: ...
    def setMinimumMaximumAndClassify(self, minimum: float, maximum: float) -> None: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def setRasterBand(self, band: int) -> None: ...
    def setRasterDataProvider(self, dp: QgsRasterDataProvider) -> None: ...
    def initializeForUseWithRasterLayer(self) -> None: ...


class QgsRasterRendererWidget(QtWidgets.QWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle) -> None: ...

    def widgetChanged(self) -> None: ...
    def minMaxWidget(self) -> QgsRasterMinMaxWidget: ...
    def doComputations(self) -> None: ...
    def selectedBand(self, index: int = ...) -> int: ...
    def setStdDev(self, value: str) -> None: ...
    def stdDev(self) -> str: ...
    def setMax(self, value: str, index: int = ...) -> None: ...
    def setMin(self, value: str, index: int = ...) -> None: ...
    def max(self, index: int = ...) -> str: ...
    def min(self, index: int = ...) -> str: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def rasterLayer(self) -> QgsRasterLayer: ...
    def setRasterLayer(self, layer: QgsRasterLayer) -> None: ...
    def renderer(self) -> QgsRasterRenderer: ...


class QgsHillshadeRendererWidget(QgsRasterRendererWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle = ...) -> None: ...

    def setMultiDirectional(self, isMultiDirectional: bool) -> None: ...
    def setZFactor(self, zfactor: float) -> None: ...
    def setAzimuth(self, azimuth: float) -> None: ...
    def setAltitude(self, altitude: float) -> None: ...
    def multiDirectional(self) -> bool: ...
    def zFactor(self) -> float: ...
    def altitude(self) -> float: ...
    def azimuth(self) -> float: ...
    def setFromRenderer(self, renderer: QgsRasterRenderer) -> None: ...
    def renderer(self) -> QgsRasterRenderer: ...
    @staticmethod
    def create(layer: QgsRasterLayer, extent: QgsRectangle) -> QgsRasterRendererWidget: ...


class QgsMultiBandColorRendererWidget(QgsRasterRendererWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle = ...) -> None: ...

    def loadMinMax(self, bandNo: int, min: float, max: float) -> None: ...
    def minMaxWidget(self) -> QgsRasterMinMaxWidget: ...
    def doComputations(self) -> None: ...
    def selectedBand(self, index: int = ...) -> int: ...
    def setMax(self, value: str, index: int = ...) -> None: ...
    def setMin(self, value: str, index: int = ...) -> None: ...
    def max(self, index: int = ...) -> str: ...
    def min(self, index: int = ...) -> str: ...
    def setFromRenderer(self, r: QgsRasterRenderer) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def renderer(self) -> QgsRasterRenderer: ...
    @staticmethod
    def create(layer: QgsRasterLayer, extent: QgsRectangle) -> QgsRasterRendererWidget: ...


class QgsPalettedRendererWidget(QgsRasterRendererWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle = ...) -> None: ...

    def setFromRenderer(self, r: QgsRasterRenderer) -> None: ...
    def renderer(self) -> QgsRasterRenderer: ...
    @staticmethod
    def create(layer: QgsRasterLayer, extent: QgsRectangle) -> QgsRasterRendererWidget: ...


class QgsRasterBandComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def bandChanged(self, band: int) -> None: ...
    def setBand(self, band: int) -> None: ...
    def setLayer(self, layer: QgsMapLayer) -> None: ...
    @staticmethod
    def displayBandName(provider: QgsRasterDataProvider, band: int) -> str: ...
    def setShowNotSetOption(self, show: bool, string: str = ...) -> None: ...
    def isShowingNotSetOption(self) -> bool: ...
    def currentBand(self) -> int: ...
    def layer(self) -> QgsRasterLayer: ...


class QgsRasterContourRendererWidget(QgsRasterRendererWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle = ...) -> None: ...

    def renderer(self) -> QgsRasterRenderer: ...
    @staticmethod
    def create(layer: QgsRasterLayer, extent: QgsRectangle) -> QgsRasterRendererWidget: ...


class QgsRasterHistogramWidget(QgsMapLayerConfigWidget):

    def __init__(self, layer: QgsRasterLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def apply(self) -> None: ...
    def refreshHistogram(self) -> None: ...
    def setSelectedBand(self, index: int) -> None: ...
    def histoAction(self, actionName: str, actionFlag: bool = ...) -> None: ...
    def computeHistogram(self, forceComputeFlag: bool) -> bool: ...
    def setActive(self, activeFlag: bool) -> None: ...
    def setRendererWidget(self, name: str, rendererWidget: Optional[QgsRasterRendererWidget] = ...) -> None: ...
    def histoSaveAsImage(self, filename: str, width: int = ..., height: int = ..., quality: int = ...) -> bool: ...


class QgsRasterMinMaxWidget(QtWidgets.QWidget):

    def __init__(self, layer: QgsRasterLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def load(self, bandNo: int, min: float, max: float) -> None: ...
    def widgetChanged(self) -> None: ...
    def setCollapsed(self, b: bool) -> None: ...
    def isCollapsed(self) -> bool: ...
    def userHasSetManualMinMaxValues(self) -> None: ...
    def doComputations(self) -> None: ...
    def hideUpdatedExtent(self) -> None: ...
    def minMaxOrigin(self) -> QgsRasterMinMaxOrigin: ...
    def setFromMinMaxOrigin(self, a0: QgsRasterMinMaxOrigin) -> None: ...
    def sampleSize(self) -> int: ...
    def extent(self) -> QgsRectangle: ...
    def setBands(self, bands: Iterable[int]) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...


class QgsRasterTransparencyWidget(QgsMapLayerConfigWidget):

    def __init__(self, layer: QgsRasterLayer, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def apply(self) -> None: ...
    def syncToLayer(self) -> None: ...


class QgsRendererRasterPropertiesWidget(QgsMapLayerConfigWidget):

    def __init__(self, layer: QgsMapLayer, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def syncToLayer(self, layer: QgsRasterLayer) -> None: ...
    def apply(self) -> None: ...
    def rendererChanged(self) -> None: ...
    def currentRenderWidget(self) -> QgsRasterRendererWidget: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...


class QgsSingleBandGrayRendererWidget(QgsRasterRendererWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle = ...) -> None: ...

    def loadMinMax(self, bandNo: int, min: float, max: float) -> None: ...
    def minMaxWidget(self) -> QgsRasterMinMaxWidget: ...
    def doComputations(self) -> None: ...
    def selectedBand(self, index: int = ...) -> int: ...
    def setMax(self, value: str, index: int = ...) -> None: ...
    def setMin(self, value: str, index: int = ...) -> None: ...
    def max(self, index: int = ...) -> str: ...
    def min(self, index: int = ...) -> str: ...
    def setFromRenderer(self, r: QgsRasterRenderer) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def renderer(self) -> QgsRasterRenderer: ...
    @staticmethod
    def create(layer: QgsRasterLayer, extent: QgsRectangle) -> QgsRasterRendererWidget: ...


class QgsSingleBandPseudoColorRendererWidget(QgsRasterRendererWidget):

    def __init__(self, layer: QgsRasterLayer, extent: QgsRectangle = ...) -> None: ...

    def loadMinMaxFromTree(self, min: float, max: float) -> None: ...
    def loadMinMax(self, bandNo: int, min: float, max: float) -> None: ...
    def setFromRenderer(self, r: QgsRasterRenderer) -> None: ...
    def currentBand(self) -> int: ...
    def minMaxWidget(self) -> QgsRasterMinMaxWidget: ...
    def doComputations(self) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...
    def renderer(self) -> QgsRasterRenderer: ...
    @staticmethod
    def create(layer: QgsRasterLayer, extent: QgsRectangle) -> QgsRasterRendererWidget: ...


class QgsRasterLayerProperties(QgsOptionsDialogBase):

    def __init__(self, lyr: QgsMapLayer, canvas: QgsMapCanvas, parent: Optional[QtWidgets.QWidget] = ..., a3: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def addPropertiesPageFactory(self, factory: QgsMapLayerConfigWidgetFactory) -> None: ...


class QgsRasterLayerTemporalPropertiesWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., layer: Optional[QgsRasterLayer] = ...) -> None: ...

    def addWidget(self, widget: QgsMapLayerConfigWidget) -> None: ...
    def syncToLayer(self) -> None: ...
    def saveTemporalProperties(self) -> None: ...


class QgsVectorLayerProperties(QgsOptionsDialogBase):

    def __init__(self, canvas: QgsMapCanvas, messageBar: QgsMessageBar, lyr: Optional[QgsVectorLayer] = ..., parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def addPropertiesPageFactory(self, factory: QgsMapLayerConfigWidgetFactory) -> None: ...


class CharacterWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def paintEvent(self, event: QtGui.QPaintEvent) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def mouseMoveEvent(self, event: QtGui.QMouseEvent) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def characterSelected(self, character: str) -> None: ...
    def clearCharacter(self) -> None: ...
    def setCharacter(self, character: str) -> None: ...
    def setColumns(self, columns: int) -> None: ...
    def updateFontMerging(self, enable: bool) -> None: ...
    def setFontStyle(self, fontStyle: str) -> None: ...
    def setFontSize(self, fontSize: float) -> None: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def character(self) -> str: ...
    def squareSize(self) -> int: ...
    def columns(self) -> int: ...
    def sizeHint(self) -> QtCore.QSize: ...


class QgsRendererWidget(QgsPanelWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle) -> None: ...

    def pasteSymbolToSelection(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def changeSymbolAngle(self) -> None: ...
    def changeSymbolSize(self) -> None: ...
    def changeSymbolWidth(self) -> None: ...
    def changeSymbolUnit(self) -> None: ...
    def changeSymbolOpacity(self) -> None: ...
    def changeSymbolColor(self) -> None: ...
    def contextMenuViewCategories(self, p: QtCore.QPoint) -> None: ...
    def setSymbolLevels(self, levels: Iterable[QgsLegendSymbolItem], enabled: bool) -> None: ...
    def createDataDefinedSizeLegendWidget(self, symbol: QgsMarkerSymbol, ddsLegend: QgsDataDefinedSizeLegend) -> QgsDataDefinedSizeLegendWidget: ...
    def refreshSymbolView(self) -> None: ...
    def selectedSymbols(self) -> List[QgsSymbol]: ...
    def symbolLevelsChanged(self) -> None: ...
    def layerVariablesChanged(self) -> None: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def applyChanges(self) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def showSymbolLevelsDialog(self, r: QgsFeatureRenderer) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...


class Qgs25DRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsSymbolLayerWidget(QtWidgets.QWidget):

    def __init__(self, parent: QtWidgets.QWidget, vl: Optional[QgsVectorLayer] = ...) -> None: ...

    def updateDataDefinedProperty(self) -> None: ...
    def symbolChanged(self) -> None: ...
    def changed(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def registerDataDefinedButton(self, button: QgsPropertyOverrideButton, key: QgsSymbolLayer.Property) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...


class QgsArrowSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(layer: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsBrushStyleComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def iconForBrush(self, style: QtCore.Qt.BrushStyle) -> QtGui.QIcon: ...
    def setBrushStyle(self, style: QtCore.Qt.BrushStyle) -> None: ...
    def brushStyle(self) -> QtCore.Qt.BrushStyle: ...


class QgsCategorizedSymbolRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def refreshSymbolView(self) -> None: ...
    def selectedCategoryList(self) -> List[QgsRendererCategory]: ...
    def selectedSymbols(self) -> List[QgsSymbol]: ...
    def applyChangeToSymbol(self) -> None: ...
    def changeCategorySymbol(self) -> None: ...
    def changeSelectedSymbols(self) -> None: ...
    def selectedCategories(self) -> List[int]: ...
    def currentCategoryRow(self) -> int: ...
    def populateCategories(self) -> None: ...
    def updateUiFromRenderer(self) -> None: ...
    def pasteSymbolToSelection(self) -> None: ...
    def setSymbolLevels(self, levels: Iterable[QgsLegendSymbolItem], enabled: bool) -> None: ...
    def matchToSymbolsFromXml(self) -> None: ...
    def matchToSymbolsFromLibrary(self) -> None: ...
    def rowsMoved(self) -> None: ...
    def showSymbolLevels(self) -> None: ...
    def deleteAllCategories(self) -> None: ...
    def deleteCategories(self) -> None: ...
    def applyColorRamp(self) -> None: ...
    def addCategories(self) -> None: ...
    def addCategory(self) -> None: ...
    def categoriesDoubleClicked(self, idx: QtCore.QModelIndex) -> None: ...
    def categoryColumnChanged(self, field: str) -> None: ...
    def changeCategorizedSymbol(self) -> None: ...
    def matchToSymbols(self, style: QgsStyle) -> int: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsCptCityColorRampDialog(QtWidgets.QDialog):

    def __init__(self, ramp: QgsCptCityColorRamp, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def changed(self) -> None: ...
    def eventFilter(self, obj: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def saveAsGradientRamp(self) -> bool: ...
    def selectedName(self) -> str: ...
    def setRamp(self, ramp: QgsCptCityColorRamp) -> None: ...
    def ramp(self) -> QgsCptCityColorRamp: ...


class QgsDashSpaceWidget(QgsPanelWidget):

    def __init__(self, vectorPattern: Iterable[float], parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def dashDotVector(self) -> List[float]: ...


class QgsDashSpaceDialog(QtWidgets.QDialog):

    def __init__(self, v: Iterable[float], parent: Optional[QtWidgets.QWidget] = ..., f: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ...) -> None: ...

    def setUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def dashDotVector(self) -> List[float]: ...


class QgsDataDefinedSizeLegendWidget(QgsPanelWidget):

    def __init__(self, ddsLegend: QgsDataDefinedSizeLegend, ddSize: QgsProperty, overrideSymbol: QgsMarkerSymbol, canvas: Optional[QgsMapCanvas] = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def dataDefinedSizeLegend(self) -> QgsDataDefinedSizeLegend: ...


class QgsEllipseSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsEmbeddedSymbolRendererWidget(QgsRendererWidget, QgsExpressionContextGenerator):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsGraduatedHistogramWidget(QgsHistogramWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def drawHistogram(self) -> None: ...
    def rangesModified(self, rangesAdded: bool) -> None: ...
    def setRenderer(self, renderer: QgsGraduatedSymbolRenderer) -> None: ...


class QgsGraduatedSymbolRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def refreshSymbolView(self) -> None: ...
    def findSymbolForRange(self, lowerBound: float, upperBound: float, ranges: Iterable[QgsRendererRange]) -> QgsSymbol: ...
    def selectedSymbols(self) -> List[QgsSymbol]: ...
    def applyChangeToSymbol(self) -> None: ...
    def changeSelectedSymbols(self) -> None: ...
    def changeRange(self, rangeIdx: int) -> None: ...
    def changeRangeSymbol(self, rangeIdx: int) -> None: ...
    def selectedRanges(self) -> List[QgsRendererRange]: ...
    def selectedClasses(self) -> List[int]: ...
    def rowsOrdered(self) -> bool: ...
    def disconnectUpdateHandlers(self) -> None: ...
    def connectUpdateHandlers(self) -> None: ...
    def updateUiFromRenderer(self, updateCount: bool = ...) -> None: ...
    def pasteSymbolToSelection(self) -> None: ...
    def setSymbolLevels(self, levels: Iterable[QgsLegendSymbolItem], enabled: bool) -> None: ...
    def refreshRanges(self, reset: bool) -> None: ...
    def modelDataChanged(self) -> None: ...
    def rowsMoved(self) -> None: ...
    def showSymbolLevels(self) -> None: ...
    def labelFormatChanged(self) -> None: ...
    def toggleBoundariesLink(self, linked: bool) -> None: ...
    def deleteAllClasses(self) -> None: ...
    def deleteClasses(self) -> None: ...
    def addClass(self) -> None: ...
    def changeCurrentValue(self, item: QtGui.QStandardItem) -> None: ...
    def rangesClicked(self, idx: QtCore.QModelIndex) -> None: ...
    def rangesDoubleClicked(self, idx: QtCore.QModelIndex) -> None: ...
    def reapplySizes(self) -> None: ...
    def reapplyColorRamp(self) -> None: ...
    def classifyGraduated(self) -> None: ...
    def graduatedColumnChanged(self, field: str) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsHeatmapRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsInterpolatedLineSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(layer: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsInvertedPolygonRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def setDockMode(self, dockMode: bool) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsLayerPropertiesWidget(QgsPanelWidget, QgsExpressionContextGenerator):

    def __init__(self, layer: QgsSymbolLayer, symbol: QgsSymbol, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def registerDataDefinedButton(self, button: QgsPropertyOverrideButton, key: QgsSymbolLayer.Property) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def updateSymbolLayerWidget(self, layer: QgsSymbolLayer) -> None: ...
    def populateLayerTypes(self) -> None: ...
    def changeLayer(self, a0: QgsSymbolLayer) -> None: ...
    def changed(self) -> None: ...
    def emitSignalChanged(self) -> None: ...
    def layerTypeChanged(self) -> None: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...


class QgsMergedFeatureRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def setDockMode(self, dockMode: bool) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsNullSymbolRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsMaskMarkerSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, layer: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(layer: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsPenStyleComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def iconForPen(self, style: QtCore.Qt.PenStyle) -> QtGui.QIcon: ...
    def setPenStyle(self, style: QtCore.Qt.PenStyle) -> None: ...
    def penStyle(self) -> QtCore.Qt.PenStyle: ...


class QgsPenJoinStyleComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPenJoinStyle(self, style: QtCore.Qt.PenJoinStyle) -> None: ...
    def penJoinStyle(self) -> QtCore.Qt.PenJoinStyle: ...


class QgsPenCapStyleComboBox(QtWidgets.QComboBox):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setPenCapStyle(self, style: QtCore.Qt.PenCapStyle) -> None: ...
    def penCapStyle(self) -> QtCore.Qt.PenCapStyle: ...


class QgsPointClusterRendererWidget(QgsRendererWidget, QgsExpressionContextGenerator):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsPointDisplacementRendererWidget(QgsRendererWidget, QgsExpressionContextGenerator):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsRendererPropertiesDialog(QtWidgets.QDialog):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, embedded: bool = ..., parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def connectValueChanged(self, widgets: Iterable[QtWidgets.QWidget], slot: str) -> None: ...
    def openPanel(self, panel: QgsPanelWidget) -> None: ...
    def onOK(self) -> None: ...
    def apply(self) -> None: ...
    def rendererChanged(self) -> None: ...
    def showPanel(self, panel: QgsPanelWidget) -> None: ...
    def widgetChanged(self) -> None: ...
    def layerVariablesChanged(self) -> None: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...


class QgsDataDefinedValueDialog(QtWidgets.QDialog):

    def __init__(self, symbolList: Iterable[QgsSymbol], layer: QgsVectorLayer, label: str) -> None: ...

    def init(self, propertyKey: int) -> None: ...
    def dataDefinedChanged(self) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...


class QgsDataDefinedSizeDialog(QgsDataDefinedValueDialog):

    def __init__(self, symbolList: Iterable[QgsSymbol], layer: QgsVectorLayer) -> None: ...

    def setDataDefined(self, symbol: QgsSymbol, dd: QgsProperty) -> None: ...
    def value(self, symbol: QgsSymbol) -> float: ...
    def symbolDataDefined(self, symbol: QgsSymbol) -> QgsProperty: ...


class QgsDataDefinedRotationDialog(QgsDataDefinedValueDialog):

    def __init__(self, symbolList: Iterable[QgsSymbol], layer: QgsVectorLayer) -> None: ...

    def setDataDefined(self, symbol: QgsSymbol, dd: QgsProperty) -> None: ...
    def value(self, symbol: QgsSymbol) -> float: ...
    def symbolDataDefined(self, symbol: QgsSymbol) -> QgsProperty: ...


class QgsDataDefinedWidthDialog(QgsDataDefinedValueDialog):

    def __init__(self, symbolList: Iterable[QgsSymbol], layer: QgsVectorLayer) -> None: ...

    def setDataDefined(self, symbol: QgsSymbol, dd: QgsProperty) -> None: ...
    def value(self, symbol: QgsSymbol) -> float: ...
    def symbolDataDefined(self, symbol: QgsSymbol) -> QgsProperty: ...


class QgsRuleBasedRendererModel(QtCore.QAbstractItemModel):

    def __init__(self, renderer: QgsRuleBasedRenderer, parent: QtCore.QObject) -> None: ...

    def clearFeatureCounts(self) -> None: ...
    def finishedAddingRules(self) -> None: ...
    def willAddRules(self, parent: QtCore.QModelIndex, count: int) -> None: ...
    def setSymbol(self, index: QtCore.QModelIndex, symbol: QgsSymbol) -> None: ...
    def removeRule(self, index: QtCore.QModelIndex) -> None: ...
    @overload
    def updateRule(self, parent: QtCore.QModelIndex, row: int) -> None: ...
    @overload
    def updateRule(self, index: QtCore.QModelIndex) -> None: ...
    def insertRule(self, parent: QtCore.QModelIndex, before: int, newrule: QgsRuleBasedRenderer.Rule) -> None: ...
    def ruleForIndex(self, index: QtCore.QModelIndex) -> QgsRuleBasedRenderer.Rule: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, a0: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...


class QgsRuleBasedRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def pasteSymbolToSelection(self) -> None: ...
    def paste(self) -> None: ...
    def copy(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def refreshSymbolView(self) -> None: ...
    def selectedRules(self) -> List[QgsRuleBasedRenderer.Rule]: ...
    def selectedSymbols(self) -> List[QgsSymbol]: ...
    def currentRule(self) -> QgsRuleBasedRenderer.Rule: ...
    def setSymbolLevels(self, levels: Iterable[QgsLegendSymbolItem], enabled: bool) -> None: ...
    def refineRuleScalesGui(self, index: Iterable[QtCore.QModelIndex]) -> None: ...
    def refineRuleRangesGui(self) -> None: ...
    def refineRuleCategoriesGui(self) -> None: ...
    def refineRule(self, type: int) -> None: ...
    def restoreSectionWidths(self) -> None: ...
    def saveSectionWidth(self, section: int, oldSize: int, newSize: int) -> None: ...
    def selectedRulesChanged(self) -> None: ...
    def currentRuleChanged(self, current: QtCore.QModelIndex = ..., previous: QtCore.QModelIndex = ...) -> None: ...
    def setRenderingOrder(self) -> None: ...
    def refineRuleRanges(self) -> None: ...
    def refineRuleCategories(self) -> None: ...
    def refineRuleScales(self) -> None: ...
    def clearFeatureCounts(self) -> None: ...
    def countFeatures(self) -> None: ...
    def removeRule(self) -> None: ...
    @overload
    def editRule(self) -> None: ...
    @overload
    def editRule(self, index: QtCore.QModelIndex) -> None: ...
    def addRule(self) -> None: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsRendererRulePropsWidget(QgsPanelWidget):

    def __init__(self, rule: QgsRuleBasedRenderer.Rule, layer: QgsVectorLayer, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ..., context: QgsSymbolWidgetContext = ...) -> None: ...

    def setDockMode(self, dockMode: bool) -> None: ...
    def apply(self) -> None: ...
    def buildExpression(self) -> None: ...
    def testFilter(self) -> None: ...
    def rule(self) -> QgsRuleBasedRenderer.Rule: ...


class QgsRendererRulePropsDialog(QtWidgets.QDialog):

    def __init__(self, rule: QgsRuleBasedRenderer.Rule, layer: QgsVectorLayer, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ..., context: QgsSymbolWidgetContext = ...) -> None: ...

    def accept(self) -> None: ...
    def buildExpression(self) -> None: ...
    def testFilter(self) -> None: ...
    def rule(self) -> QgsRuleBasedRenderer.Rule: ...


class QgsSingleSymbolRendererWidget(QgsRendererWidget):

    def __init__(self, layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> None: ...

    def setSymbolLevels(self, levels: Iterable[QgsLegendSymbolItem], enabled: bool) -> None: ...
    def setDockMode(self, dockMode: bool) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    @staticmethod
    def create(layer: QgsVectorLayer, style: QgsStyle, renderer: QgsFeatureRenderer) -> QgsRendererWidget: ...


class QgsSmartGroupCondition(QtWidgets.QWidget):

    def __init__(self, id: int, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def removed(self, a0: int) -> None: ...
    def destruct(self) -> None: ...
    def hideRemoveButton(self, hide: bool) -> None: ...
    def setParameter(self, param: str) -> None: ...
    def setConstraint(self, constraint: str) -> None: ...
    def parameter(self) -> str: ...
    def constraint(self) -> str: ...


class QgsSmartGroupEditorDialog(QtWidgets.QDialog):

    def __init__(self, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def removeCondition(self, a0: int) -> None: ...
    def addCondition(self) -> None: ...
    def setSmartgroupName(self, a0: str) -> None: ...
    def setOperator(self, a0: str) -> None: ...
    def conditionOperator(self) -> str: ...
    def smartgroupName(self) -> str: ...


class QgsStyleExportImportDialog(QtWidgets.QDialog):

    class Mode(int): ...
    Export: QgsStyleExportImportDialog.Mode = ...
    Import: QgsStyleExportImportDialog.Mode = ...

    def __init__(self, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ..., mode: QgsStyleExportImportDialog.Mode = ...) -> None: ...

    def importTypeChanged(self, a0: int) -> None: ...
    def deselectSmartgroup(self, groupName: str) -> None: ...
    def selectSmartgroup(self, groupName: str) -> None: ...
    def deselectTag(self, tagName: str) -> None: ...
    def selectTag(self, tagName: str) -> None: ...
    def deselectFavorites(self) -> None: ...
    def selectFavorites(self) -> None: ...
    def clearSelection(self) -> None: ...
    def selectAll(self) -> None: ...
    def selectByGroup(self) -> None: ...
    def doExportImport(self) -> None: ...
    def deselectSymbols(self, symbolNames: Iterable[str]) -> None: ...
    def selectSymbols(self, symbolNames: Iterable[str]) -> None: ...
    def setImportFilePath(self, path: str) -> None: ...


class QgsStyleGroupSelectionDialog(QtWidgets.QDialog):

    def __init__(self, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def favoritesSelected(self) -> None: ...
    def favoritesDeselected(self) -> None: ...
    def allSelected(self) -> None: ...
    def allDeselected(self) -> None: ...
    def smartgroupDeselected(self, groupName: str) -> None: ...
    def smartgroupSelected(self, groupName: str) -> None: ...
    def tagDeselected(self, tagName: str) -> None: ...
    def tagSelected(self, tagName: str) -> None: ...
    def setBold(self, item: QtGui.QStandardItem) -> None: ...


class QgsStyleManagerDialog(QtWidgets.QDialog):

    def __init__(self, style: QgsStyle, parent: Optional[QtWidgets.QWidget] = ..., flags: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., readOnly: bool = ...) -> None: ...

    def setBold(self, a0: QtGui.QStandardItem) -> None: ...
    def enableItemsForGroupingMode(self, a0: bool) -> None: ...
    def enableGroupInputs(self, a0: bool) -> None: ...
    def enableSymbolInputs(self, a0: bool) -> None: ...
    def removeColorRamp(self) -> bool: ...
    def removeSymbol(self) -> bool: ...
    def editColorRamp(self) -> bool: ...
    def editSymbol(self) -> bool: ...
    def addSymbol(self, symbolType: int = ...) -> bool: ...
    def currentItemName(self) -> str: ...
    def currentItemType(self) -> int: ...
    def populateColorRamps(self, colorRamps: Iterable[str], checkable: bool = ...) -> None: ...
    def populateSymbols(self, symbolNames: Iterable[str], checkable: bool = ...) -> None: ...
    def setSymbolsChecked(self, a0: Iterable[str]) -> None: ...
    def populateGroups(self) -> None: ...
    def populateTypes(self) -> None: ...
    def detagSelectedSymbols(self) -> None: ...
    def tagSelectedSymbols(self, newTag: bool = ...) -> None: ...
    def removeFavoriteSelectedSymbols(self) -> None: ...
    def addFavoriteSelectedSymbols(self) -> None: ...
    def addColorRamp(self, type: str = ...) -> bool: ...
    def listitemsContextMenu(self, a0: QtCore.QPoint) -> None: ...
    def grouptreeContextMenu(self, a0: QtCore.QPoint) -> None: ...
    def selectedSymbolsChanged(self, selected: QtCore.QItemSelection, deselected: QtCore.QItemSelection) -> None: ...
    def symbolSelected(self, a0: QtCore.QModelIndex) -> None: ...
    def filterSymbols(self, filter: str) -> None: ...
    def regrouped(self, a0: QtGui.QStandardItem) -> None: ...
    def editSmartgroupAction(self) -> None: ...
    def tagSymbolsAction(self) -> None: ...
    def removeGroup(self) -> None: ...
    def addSmartgroup(self) -> int: ...
    def addTag(self) -> int: ...
    def groupRenamed(self, item: QtGui.QStandardItem) -> None: ...
    def groupChanged(self, a0: QtCore.QModelIndex) -> None: ...
    def itemChanged(self, item: QtGui.QStandardItem) -> None: ...
    def showHelp(self) -> None: ...
    def onClose(self) -> None: ...
    def onFinished(self) -> None: ...
    def populateList(self) -> None: ...
    def importItems(self) -> None: ...
    def exportItems(self) -> None: ...
    def exportSelectedItemsImages(self, dir: str, format: str, size: QtCore.QSize) -> None: ...
    def exportItemsPNG(self) -> None: ...
    def exportItemsSVG(self) -> None: ...
    def removeItem(self) -> None: ...
    def editItem(self) -> None: ...
    def addItem(self) -> None: ...
    def activate(self) -> None: ...
    def setBaseStyleName(self, name: str) -> None: ...
    def setSmartGroupsVisible(self, show: bool) -> None: ...
    def setFavoritesGroupVisible(self, show: bool) -> None: ...
    @staticmethod
    def addColorRampStatic(parent: QtWidgets.QWidget, style: QgsStyle, RampType: str = ...) -> str: ...


class QgsStyleSaveDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., type: QgsStyle.StyleEntity = ...) -> None: ...

    def selectedType(self) -> QgsStyle.StyleEntity: ...
    def isFavorite(self) -> bool: ...
    def tags(self) -> str: ...
    def setDefaultTags(self, tags: str) -> None: ...
    def name(self) -> str: ...


class QgsSvgSelectorFilterModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: QtCore.QObject, path: str = ..., iconSize: int = ...) -> None: ...


class QgsSvgSelectorListModel(QtCore.QAbstractListModel):

    @overload
    def __init__(self, parent: QtCore.QObject, iconSize: int = ...) -> None: ...
    @overload
    def __init__(self, parent: QtCore.QObject, path: str, iconSize: int = ...) -> None: ...

    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QgsSvgSelectorGroupsModel(QtGui.QStandardItemModel):

    def __init__(self, parent: QtCore.QObject) -> None: ...


class QgsSvgSelectorWidget(QtWidgets.QWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def populateList(self) -> None: ...
    def svgParametersChanged(self, parameters: Dict[str, QgsProperty]) -> None: ...
    def svgSelected(self, path: str) -> None: ...
    def setSvgParameters(self, parameters: Dict[str, QgsProperty]) -> None: ...
    def setSvgPath(self, svgPath: str) -> None: ...
    def propertyOverrideToolButton(self) -> QgsPropertyOverrideButton: ...
    def browserVisible(self) -> bool: ...
    def setBrowserVisible(self, visible: bool) -> None: ...
    def allowParamerters(self) -> bool: ...
    def setAllowParameters(self, allow: bool) -> None: ...
    def sourceLineEdit(self) -> QgsPictureSourceLineEditBase: ...
    def currentSvgPath(self) -> str: ...
    def initParametersModel(self, generator: QgsExpressionContextGenerator, layer: Optional[QgsVectorLayer] = ...) -> None: ...


class QgsSvgSelectorDialog(QtWidgets.QDialog):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ..., fl: Union[QtCore.Qt.WindowFlags, QtCore.Qt.WindowType] = ..., buttons: Union[QtWidgets.QDialogButtonBox.StandardButtons, QtWidgets.QDialogButtonBox.StandardButton] = ..., orientation: QtCore.Qt.Orientation = ...) -> None: ...

    def svgSelector(self) -> QgsSvgSelectorWidget: ...


class QgsSimpleLineSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def resizeEvent(self, event: QtGui.QResizeEvent) -> None: ...
    def updatePatternIcon(self) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsSimpleMarkerSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setColorFill(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColorStroke(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsSimpleFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsFilledMarkerSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsGradientFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setGradientSpread(self, index: int) -> None: ...
    def setCoordinateMode(self, index: int) -> None: ...
    def setGradientType(self, index: int) -> None: ...
    def applyColorRamp(self) -> None: ...
    def setColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsShapeburstFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsMarkerLineSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setOffsetAlongLine(self, val: float) -> None: ...
    def setInterval(self, val: float) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsHashedLineSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsSvgMarkerSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setGuiForSvg(self, layer: QgsSvgMarkerSymbolLayer, skipDefaultColors: bool = ...) -> None: ...
    def populateList(self) -> None: ...
    def setSvgParameters(self, parameters: Dict[str, QgsProperty]) -> None: ...
    def setSvgPath(self, name: str) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsRasterMarkerSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsRasterFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsSVGFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def updateParamGui(self, resetValues: bool = ...) -> None: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsLinePatternFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsPointPatternFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsRandomMarkerFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsFontMarkerSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def setCharacterFromText(self, text: str) -> None: ...
    def setCharacter(self, chr: str) -> None: ...
    def setAngle(self, angle: float) -> None: ...
    def setSize(self, size: float) -> None: ...
    def setColorStroke(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setFontFamily(self, font: QtGui.QFont) -> None: ...
    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsCentroidFillSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsGeometryGeneratorSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsSymbolLevelsWidget(QgsPanelWidget):

    @overload
    def __init__(self, renderer: QgsFeatureRenderer, usingSymbolLevels: bool, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    @overload
    def __init__(self, symbols: Iterable[QgsLegendSymbolItem], usingSymbolLevels: bool, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def apply(self) -> None: ...
    def setForceOrderingEnabled(self, enabled: bool) -> None: ...
    def symbolLevels(self) -> List[QgsLegendSymbolItem]: ...
    def usingLevels(self) -> bool: ...


class QgsSymbolLevelsDialog(QtWidgets.QDialog):

    def __init__(self, renderer: QgsFeatureRenderer, usingSymbolLevels: bool, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLevels(self) -> List[QgsLegendSymbolItem]: ...
    def usingLevels(self) -> bool: ...
    def setForceOrderingEnabled(self, enabled: bool) -> None: ...


class QgsSymbolSelectorWidget(QgsPanelWidget):

    def __init__(self, symbol: QgsSymbol, style: QgsStyle, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolModified(self) -> None: ...
    def changeLayer(self, layer: QgsSymbolLayer) -> None: ...
    def symbolChanged(self) -> None: ...
    def updatePreview(self) -> None: ...
    def updateLayerPreview(self) -> None: ...
    def layerChanged(self) -> None: ...
    def duplicateLayer(self) -> None: ...
    def lockLayer(self) -> None: ...
    def removeLayer(self) -> None: ...
    def addLayer(self) -> None: ...
    def moveLayerUp(self) -> None: ...
    def moveLayerDown(self) -> None: ...
    def symbol(self) -> QgsSymbol: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def advancedMenu(self) -> QtWidgets.QMenu: ...


class QgsSymbolSelectorDialog(QtWidgets.QDialog):

    def __init__(self, symbol: QgsSymbol, style: QgsStyle, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ..., embedded: bool = ...) -> None: ...

    def symbolModified(self) -> None: ...
    def keyPressEvent(self, e: QtGui.QKeyEvent) -> None: ...
    def changeLayer(self, layer: QgsSymbolLayer) -> None: ...
    def symbolChanged(self) -> None: ...
    def updatePreview(self) -> None: ...
    def updateLayerPreview(self) -> None: ...
    def layerChanged(self) -> None: ...
    def duplicateLayer(self) -> None: ...
    def lockLayer(self) -> None: ...
    def removeLayer(self) -> None: ...
    def addLayer(self) -> None: ...
    def moveLayerUp(self) -> None: ...
    def moveLayerDown(self) -> None: ...
    def buttonBox(self) -> QtWidgets.QDialogButtonBox: ...
    def symbol(self) -> QgsSymbol: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...
    def advancedMenu(self) -> QtWidgets.QMenu: ...


class QgsSymbolsListWidget(QtWidgets.QWidget):

    def __init__(self, symbol: QgsSymbol, style: QgsStyle, menu: QtWidgets.QMenu, parent: QtWidgets.QWidget, layer: Optional[QgsVectorLayer] = ...) -> None: ...

    def changed(self) -> None: ...
    def updateDataDefinedLineWidth(self) -> None: ...
    def updateDataDefinedMarkerAngle(self) -> None: ...
    def updateDataDefinedMarkerSize(self) -> None: ...
    def clipFeaturesToggled(self, checked: bool) -> None: ...
    def setLineWidth(self, width: float) -> None: ...
    def setMarkerSize(self, size: float) -> None: ...
    def setMarkerAngle(self, angle: float) -> None: ...
    def setSymbolColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def context(self) -> QgsSymbolWidgetContext: ...
    def setContext(self, context: QgsSymbolWidgetContext) -> None: ...


class QgsSymbolWidgetContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsSymbolWidgetContext) -> None: ...

    def setSymbolType(self, type: Qgis.SymbolType) -> None: ...
    def symbolType(self) -> Qgis.SymbolType: ...
    def globalProjectAtlasMapLayerScopes(self, layer: QgsMapLayer) -> List[QgsExpressionContextScope]: ...
    def additionalExpressionContextScopes(self) -> List[QgsExpressionContextScope]: ...
    def setAdditionalExpressionContextScopes(self, scopes: Iterable[QgsExpressionContextScope]) -> None: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def messageBar(self) -> QgsMessageBar: ...
    def setMessageBar(self, bar: QgsMessageBar) -> None: ...
    def mapCanvas(self) -> QgsMapCanvas: ...
    def setMapCanvas(self, canvas: QgsMapCanvas) -> None: ...


class QgsVectorFieldSymbolLayerWidget(QgsSymbolLayerWidget):

    def __init__(self, vl: QgsVectorLayer, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def symbolLayer(self) -> QgsSymbolLayer: ...
    def setSymbolLayer(self, layer: QgsSymbolLayer) -> None: ...
    @staticmethod
    def create(vl: QgsVectorLayer) -> QgsSymbolLayerWidget: ...


class QgsTableEditorDialog(QtWidgets.QMainWindow):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def closeEvent(self, a0: QtGui.QCloseEvent) -> None: ...
    def includeHeaderChanged(self, included: bool) -> None: ...
    def tableChanged(self) -> None: ...
    def registerExpressionContextGenerator(self, generator: QgsExpressionContextGenerator) -> None: ...
    def setTableHeaders(self, headers: Iterable[typing.Any]) -> None: ...
    def tableHeaders(self) -> List[typing.Any]: ...
    def setIncludeTableHeader(self, included: bool) -> None: ...
    def includeTableHeader(self) -> bool: ...
    def setTableColumnWidth(self, column: int, width: float) -> None: ...
    def setTableRowHeight(self, row: int, height: float) -> None: ...
    def tableColumnWidth(self, column: int) -> float: ...
    def tableRowHeight(self, row: int) -> float: ...
    def tableContents(self) -> typing.Any: ...
    def setTableContentsFromClipboard(self) -> bool: ...
    def setTableContents(self, contents: typing.Any) -> None: ...


class QgsTableEditorWidget(QtWidgets.QTableWidget):

    def __init__(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def activeCellChanged(self) -> None: ...
    def tableChanged(self) -> None: ...
    def keyPressEvent(self, event: QtGui.QKeyEvent) -> None: ...
    def setTableHeaders(self, headers: Iterable[typing.Any]) -> None: ...
    def setIncludeTableHeader(self, included: bool) -> None: ...
    def setSelectionColumnWidth(self, height: float) -> None: ...
    def setSelectionRowHeight(self, height: float) -> None: ...
    def setSelectionTextFormat(self, format: QgsTextFormat) -> None: ...
    def setSelectionCellProperty(self, property: QgsProperty) -> None: ...
    def setSelectionVerticalAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setSelectionHorizontalAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def setSelectionBackgroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setSelectionForegroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def clearSelectedCells(self) -> None: ...
    def expandColumnSelection(self) -> None: ...
    def expandRowSelection(self) -> None: ...
    def deleteColumns(self) -> None: ...
    def deleteRows(self) -> None: ...
    def insertColumnsAfter(self) -> None: ...
    def insertColumnsBefore(self) -> None: ...
    def insertRowsAbove(self) -> None: ...
    def insertRowsBelow(self) -> None: ...
    def isHeaderCellSelected(self) -> bool: ...
    def tableHeaders(self) -> List[typing.Any]: ...
    def columnsAssociatedWithSelection(self) -> List[int]: ...
    def rowsAssociatedWithSelection(self) -> List[int]: ...
    def setTableColumnWidth(self, column: int, width: float) -> None: ...
    def setTableRowHeight(self, row: int, height: float) -> None: ...
    def tableColumnWidth(self, column: int) -> float: ...
    def tableRowHeight(self, row: int) -> float: ...
    def selectionColumnWidth(self) -> float: ...
    def selectionRowHeight(self) -> float: ...
    def selectionTextFormat(self) -> QgsTextFormat: ...
    def selectionCellProperty(self) -> QgsProperty: ...
    def selectionVerticalAlignment(self) -> QtCore.Qt.Alignment: ...
    def selectionHorizontalAlignment(self) -> QtCore.Qt.Alignment: ...
    def selectionBackgroundColor(self) -> QtGui.QColor: ...
    def selectionForegroundColor(self) -> QtGui.QColor: ...
    def hasMixedSelectionNumericFormat(self) -> bool: ...
    def selectionNumericFormat(self) -> QgsNumericFormat: ...
    def setSelectionNumericFormat(self, format: QgsNumericFormat) -> None: ...
    def tableContents(self) -> typing.Any: ...
    def setTableContents(self, contents: typing.Any) -> None: ...


class QgsQmlWidgetWrapper(QgsWidgetWrapper):

    def __init__(self, layer: QgsVectorLayer, editor: QtWidgets.QWidget, parent: QtWidgets.QWidget) -> None: ...

    def setFeature(self, feature: QgsFeature) -> None: ...
    def setQmlCode(self, qmlCode: str) -> None: ...
    def reinitWidget(self) -> None: ...
    def initWidget(self, editor: QtWidgets.QWidget) -> None: ...
    def createWidget(self, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def valid(self) -> bool: ...


class QgsAdvancedDigitizingCanvasItem(QgsMapCanvasItem):

    def __init__(self, canvas: QgsMapCanvas, cadDockWidget: QgsAdvancedDigitizingDockWidget) -> None: ...

    def paint(self, painter: QtGui.QPainter) -> None: ...
