# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : May 2014
    Copyright            : (C) 2014 by Nathan Woodrow
    Email                : woodrow dot nathan at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Nathan Woodrow'
__date__ = 'May 2014'
__copyright__ = '(C) 2014, Nathan Woodrow'

import datetime
import typing
from typing import (Callable, Dict, Iterable, List, Optional, Sequence,
                    Set, Tuple, Union, overload)

from PyQt5 import (QtCore, QtGui, QtNetwork, QtPrintSupport, QtSql, QtWidgets,
                   QtXml)

from ._types import sip


class QgsProcessingException(Exception):
    ...


# NOTE: Unknown external widgets - probably more monkey-patching involved?
class QgsCalloutWidget(QtWidgets.QWidget):
    ...


class QgsPaintEffectWidget(QtWidgets.QWidget):
    ...


class QgsRendererWidget(QtWidgets.QWidget):
    ...


class QgsSymbolLayerWidget(QtWidgets.QWidget):
    ...


QgsMultiPolygonXY: typing.Any
QgsMultiPointXY: typing.Any
QgsMultiPolylineXY: typing.Any
QgsPolygonXY: typing.Any
QgsPolylineXY: typing.Any


# Convenient type aliases.
PYQT_SIGNAL = Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = Union[Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = Union[Sequence[int], Sequence[float], sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = Union[
    Sequence[int], Sequence[float], sip.Buffer, int, None]


class SmartgroupTable(int):
    ...


SmartgroupId: SmartgroupTable = ...
SmartgroupName: SmartgroupTable = ...
SmartgroupXML: SmartgroupTable = ...


class LabelSettingsTable(int):
    ...


LabelSettingsId: LabelSettingsTable = ...
LabelSettingsName: LabelSettingsTable = ...
LabelSettingsXML: LabelSettingsTable = ...
LabelSettingsFavoriteId: LabelSettingsTable = ...


class TextFormatTable(int):
    ...


TextFormatId: TextFormatTable = ...
TextFormatName: TextFormatTable = ...
TextFormatXML: TextFormatTable = ...
TextFormatFavoriteId: TextFormatTable = ...


class ColorrampTable(int):
    ...


ColorrampId: ColorrampTable = ...
ColorrampName: ColorrampTable = ...
ColorrampXML: ColorrampTable = ...
ColorrampFavoriteId: ColorrampTable = ...


class TagmapTable(int):
    ...


TagmapTagId: TagmapTable = ...
TagmapSymbolId: TagmapTable = ...


class TagTable(int):
    ...


TagId: TagTable = ...
TagName: TagTable = ...


class SymbolTable(int):
    ...


SymbolId: SymbolTable = ...
SymbolName: SymbolTable = ...
SymbolXML: SymbolTable = ...
SymbolFavoriteId: SymbolTable = ...


class QgsMapLayerType(int):
    ...


VectorLayer: QgsMapLayerType = ...
RasterLayer: QgsMapLayerType = ...
PluginLayer: QgsMapLayerType = ...
MeshLayer: QgsMapLayerType = ...
VectorTileLayer: QgsMapLayerType = ...
AnnotationLayer: QgsMapLayerType = ...
PointCloudLayer: QgsMapLayerType = ...


class Qgis(sip.wrapper):

    class UnplacedLabelVisibility(int):
        ...
    FollowEngineSetting: Qgis.UnplacedLabelVisibility = ...
    NeverShow: Qgis.UnplacedLabelVisibility = ...

    class DriveType(int):
        ...
    Unknown: Qgis.DriveType = ...
    Invalid: Qgis.DriveType = ...
    Removable: Qgis.DriveType = ...
    Fixed: Qgis.DriveType = ...
    Remote: Qgis.DriveType = ...
    CdRom: Qgis.DriveType = ...
    RamDisk: Qgis.DriveType = ...

    class VectorExportResult(int):
        ...
    Success: Qgis.VectorExportResult = ...  # type: ignore
    ErrorCreatingDataSource: Qgis.VectorExportResult = ...
    ErrorCreatingLayer: Qgis.VectorExportResult = ...
    ErrorAttributeTypeUnsupported: Qgis.VectorExportResult = ...
    ErrorAttributeCreationFailed: Qgis.VectorExportResult = ...
    ErrorProjectingFeatures: Qgis.VectorExportResult = ...
    ErrorFeatureWriteFailed: Qgis.VectorExportResult = ...
    ErrorInvalidLayer: Qgis.VectorExportResult = ...
    ErrorInvalidProvider: Qgis.VectorExportResult = ...
    ErrorProviderUnsupportedFeature: Qgis.VectorExportResult = ...
    ErrorConnectionFailed: Qgis.VectorExportResult = ...
    UserCanceled: Qgis.VectorExportResult = ...

    class BrowserDirectoryMonitoring(int):
        ...
    Default: Qgis.BrowserDirectoryMonitoring = ...
    NeverMonitor: Qgis.BrowserDirectoryMonitoring = ...
    AlwaysMonitor: Qgis.BrowserDirectoryMonitoring = ...

    class BrowserLayerType(int):
        ...
    NoType: Qgis.BrowserLayerType = ...
    Vector: Qgis.BrowserLayerType = ...
    Raster: Qgis.BrowserLayerType = ...
    Point: Qgis.BrowserLayerType = ...
    Line: Qgis.BrowserLayerType = ...  # type: ignore
    Polygon: Qgis.BrowserLayerType = ...
    TableLayer: Qgis.BrowserLayerType = ...
    Database: Qgis.BrowserLayerType = ...
    Table: Qgis.BrowserLayerType = ...
    Plugin: Qgis.BrowserLayerType = ...
    Mesh: Qgis.BrowserLayerType = ...
    VectorTile: Qgis.BrowserLayerType = ...
    PointCloud: Qgis.BrowserLayerType = ...

    class BrowserItemCapability(int):
        ...
    NoCapabilities: Qgis.BrowserItemCapability = ...
    SetCrs: Qgis.BrowserItemCapability = ...
    Fertile: Qgis.BrowserItemCapability = ...
    Fast: Qgis.BrowserItemCapability = ...
    Collapse: Qgis.BrowserItemCapability = ...
    Rename: Qgis.BrowserItemCapability = ...
    Delete: Qgis.BrowserItemCapability = ...

    class BrowserItemState(int):
        ...
    NotPopulated: Qgis.BrowserItemState = ...
    Populating: Qgis.BrowserItemState = ...
    Populated: Qgis.BrowserItemState = ...

    class BrowserItemType(int):
        ...
    Collection: Qgis.BrowserItemType = ...
    Directory: Qgis.BrowserItemType = ...
    Layer: Qgis.BrowserItemType = ...
    Error: Qgis.BrowserItemType = ...
    Favorites: Qgis.BrowserItemType = ...
    Project: Qgis.BrowserItemType = ...
    Custom: Qgis.BrowserItemType = ...
    Fields: Qgis.BrowserItemType = ...
    Field: Qgis.BrowserItemType = ...

    class SymbolPreviewFlag(int):
        ...
    FlagIncludeCrosshairsForMarkerSymbols: Qgis.SymbolPreviewFlag = ...

    class SymbolFlag(int):
        ...
    RendererShouldUseSymbolLevels: Qgis.SymbolFlag = ...

    class SymbolRenderHint(int):
        ...
    DynamicRotation: Qgis.SymbolRenderHint = ...

    class ScaleMethod(int):
        ...
    ScaleArea: Qgis.ScaleMethod = ...
    ScaleDiameter: Qgis.ScaleMethod = ...

    class SymbolType(int):
        ...
    Marker: Qgis.SymbolType = ...
    Line: Qgis.SymbolType = ...
    Fill: Qgis.SymbolType = ...
    Hybrid: Qgis.SymbolType = ...

    class FeatureCountState(int):
        ...
    Uncounted: Qgis.FeatureCountState = ...
    UnknownCount: Qgis.FeatureCountState = ...

    class PythonMacroMode(int):
        ...
    Never: Qgis.PythonMacroMode = ...
    Ask: Qgis.PythonMacroMode = ...
    SessionOnly: Qgis.PythonMacroMode = ...
    Always: Qgis.PythonMacroMode = ...
    NotForThisSession: Qgis.PythonMacroMode = ...

    class DataType(int):
        ...
    UnknownDataType: Qgis.DataType = ...
    Byte: Qgis.DataType = ...
    UInt16: Qgis.DataType = ...
    Int16: Qgis.DataType = ...
    UInt32: Qgis.DataType = ...
    Int32: Qgis.DataType = ...
    Float32: Qgis.DataType = ...
    Float64: Qgis.DataType = ...
    CInt16: Qgis.DataType = ...
    CInt32: Qgis.DataType = ...
    CFloat32: Qgis.DataType = ...
    CFloat64: Qgis.DataType = ...
    ARGB32: Qgis.DataType = ...
    ARGB32_Premultiplied: Qgis.DataType = ...

    class MessageLevel(int):
        ...
    Info: Qgis.MessageLevel = ...
    Warning: Qgis.MessageLevel = ...
    Critical: Qgis.MessageLevel = ...
    Success: Qgis.MessageLevel = ...
    NoLevel: Qgis.MessageLevel = ...

    class SymbolRenderHints(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[Qgis.SymbolRenderHints, Qgis.SymbolRenderHint]) -> None: ...
        @overload
        def __init__(self, a0: Qgis.SymbolRenderHints) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> Qgis.SymbolRenderHints: ...
        def __int__(self) -> int: ...

    class SymbolFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[Qgis.SymbolFlags, Qgis.SymbolFlag]) -> None: ...
        @overload
        def __init__(self, a0: Qgis.SymbolFlags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> Qgis.SymbolFlags: ...
        def __int__(self) -> int: ...

    class SymbolPreviewFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[Qgis.SymbolPreviewFlags, Qgis.SymbolPreviewFlag]) -> None: ...
        @overload
        def __init__(self, a0: Qgis.SymbolPreviewFlags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> Qgis.SymbolPreviewFlags: ...
        def __int__(self) -> int: ...

    class BrowserItemCapabilities(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[Qgis.BrowserItemCapabilities, Qgis.BrowserItemCapability]) -> None: ...
        @overload
        def __init__(self, a0: Qgis.BrowserItemCapabilities) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> Qgis.BrowserItemCapabilities: ...
        def __int__(self) -> int: ...

    DEFAULT_HIGHLIGHT_BUFFER_MM: float = ...
    DEFAULT_HIGHLIGHT_COLOR: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...
    DEFAULT_HIGHLIGHT_MIN_WIDTH_MM: float = ...
    DEFAULT_MAPTOPIXEL_THRESHOLD: float = ...
    DEFAULT_M_COORDINATE: float = ...
    DEFAULT_SEARCH_RADIUS_MM: float = ...
    DEFAULT_SNAP_TOLERANCE: float = ...
    DEFAULT_SNAP_UNITS: QgsTolerance.UnitType = ...
    DEFAULT_Z_COORDINATE: float = ...
    QGIS_DEV_VERSION: str = ...
    SCALE_PRECISION: float = ...
    UI_SCALE_FACTOR: float = ...
    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: Qgis) -> None: ...
    @staticmethod
    def geosVersion() -> str: ...
    @staticmethod
    def geosVersionPatch() -> int: ...
    @staticmethod
    def geosVersionMinor() -> int: ...
    @staticmethod
    def geosVersionMajor() -> int: ...
    @staticmethod
    def geosVersionInt() -> int: ...
    @staticmethod
    def defaultProjectScales() -> str: ...
    @staticmethod
    def devVersion() -> str: ...
    @staticmethod
    def releaseName() -> str: ...
    @staticmethod
    def versionInt() -> int: ...
    @staticmethod
    def version() -> str: ...


class QgsAbstractContentCacheEntry(sip.wrapper):

    fileModified: Union[QtCore.QDateTime, datetime.datetime] = ...
    fileModifiedLastCheckTimer: QtCore.QElapsedTimer = ...
    mFileModifiedCheckTimeout: int = ...
    nextEntry: QgsAbstractContentCacheEntry = ...
    path: str = ...
    previousEntry: QgsAbstractContentCacheEntry = ...

    def __init__(self, path: str) -> None: ...
    def isEqual(self, other: QgsAbstractContentCacheEntry) -> bool: ...
    def dump(self) -> None: ...
    def dataSize(self) -> int: ...


class QgsAbstractContentCacheBase(QtCore.QObject):

    def __init__(self, parent: QtCore.QObject) -> None: ...
    def onRemoteContentFetched(self, url: str, success: bool) -> None: ...
    def checkReply(self, reply: QtNetwork.QNetworkReply, path: str) -> bool: ...
    def remoteContentFetched(self, url: str) -> None: ...


class QgsAction(sip.wrapper):

    class ActionType(int):
        ...
    Generic: QgsAction.ActionType = ...
    GenericPython: QgsAction.ActionType = ...
    Mac: QgsAction.ActionType = ...
    Windows: QgsAction.ActionType = ...
    Unix: QgsAction.ActionType = ...
    OpenUrl: QgsAction.ActionType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: QgsAction.ActionType, description: str, command: str, capture: bool = ...) -> None: ...
    @overload
    def __init__(self, type: QgsAction.ActionType, description: str, action: str, icon: str, capture: bool, shortTitle: str = ..., actionScopes: Iterable[str] = ..., notificationMessage: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAction) -> None: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...
    def setExpressionContextScope(self, scope: QgsExpressionContextScope) -> None: ...
    def writeXml(self, actionsNode: QtXml.QDomNode) -> None: ...
    def readXml(self, actionNode: QtXml.QDomNode) -> None: ...
    def setActionScopes(self, actionScopes: Iterable[str]) -> None: ...
    def actionScopes(self) -> Set[str]: ...
    @overload
    def run(self, layer: QgsVectorLayer, feature: QgsFeature, expressionContext: QgsExpressionContext) -> None: ...
    @overload
    def run(self, expressionContext: QgsExpressionContext) -> None: ...
    def runable(self) -> bool: ...
    def setEnabledOnlyWhenEditable(self, enable: bool) -> None: ...
    def isEnabledOnlyWhenEditable(self) -> bool: ...
    def capture(self) -> bool: ...
    def type(self) -> QgsAction.ActionType: ...
    def notificationMessage(self) -> str: ...
    def command(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def iconPath(self) -> str: ...
    def isValid(self) -> bool: ...
    def id(self) -> QtCore.QUuid: ...
    def shortTitle(self) -> str: ...
    def name(self) -> str: ...


class QgsActionManager(QtCore.QObject):

    def __init__(self, layer: QgsVectorLayer) -> None: ...
    def defaultAction(self, actionScope: str) -> QgsAction: ...
    def setDefaultAction(self, actionScope: str, actionId: QtCore.QUuid) -> None: ...
    def action(self, id: QtCore.QUuid) -> QgsAction: ...
    def readXml(self, layer_node: QtXml.QDomNode) -> bool: ...
    def writeXml(self, layer_node: QtXml.QDomNode) -> bool: ...
    def layer(self) -> QgsVectorLayer: ...
    def actions(self, actionScope: str = ...) -> List[QgsAction]: ...
    def clearActions(self) -> None: ...
    def doAction(self, actionId: QtCore.QUuid, feature: QgsFeature, context: QgsExpressionContext) -> None: ...
    def doActionFeature(self, actionId: QtCore.QUuid, feature: QgsFeature, defaultValueIndex: int = ..., scope: QgsExpressionContextScope = ...) -> None: ...
    def removeAction(self, actionId: QtCore.QUuid) -> None: ...
    @overload
    def addAction(self, type: QgsAction.ActionType, name: str, command: str, capture: bool = ...) -> QtCore.QUuid: ...
    @overload
    def addAction(self, type: QgsAction.ActionType, name: str, command: str, icon: str, capture: bool = ...) -> QtCore.QUuid: ...
    @overload
    def addAction(self, action: QgsAction) -> None: ...


class QgsActionScope(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, id: str, title: str, description: str, expressionContextScope: QgsExpressionContextScope = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsActionScope) -> None: ...
    def __hash__(self) -> int: ...
    def isValid(self) -> bool: ...
    def setDescription(self, description: str) -> None: ...
    def description(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def setId(self, id: str) -> None: ...
    def id(self) -> str: ...
    def setExpressionContextScope(self, expressionContextScope: QgsExpressionContextScope) -> None: ...
    def expressionContextScope(self) -> QgsExpressionContextScope: ...


class QgsActionScopeRegistry(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...
    def actionScopesChanged(self) -> None: ...
    def actionScope(self, id: str) -> QgsActionScope: ...
    def unregisterActionScope(self, actionScope: QgsActionScope) -> None: ...
    def registerActionScope(self, actionScope: QgsActionScope) -> None: ...
    def actionScopes(self) -> Set[QgsActionScope]: ...


class QgsAggregateCalculator(sip.wrapper):

    class Aggregate(int):
        ...
    Count: QgsAggregateCalculator.Aggregate = ...
    CountDistinct: QgsAggregateCalculator.Aggregate = ...
    CountMissing: QgsAggregateCalculator.Aggregate = ...
    Min: QgsAggregateCalculator.Aggregate = ...
    Max: QgsAggregateCalculator.Aggregate = ...
    Sum: QgsAggregateCalculator.Aggregate = ...
    Mean: QgsAggregateCalculator.Aggregate = ...
    Median: QgsAggregateCalculator.Aggregate = ...
    StDev: QgsAggregateCalculator.Aggregate = ...
    StDevSample: QgsAggregateCalculator.Aggregate = ...
    Range: QgsAggregateCalculator.Aggregate = ...
    Minority: QgsAggregateCalculator.Aggregate = ...
    Majority: QgsAggregateCalculator.Aggregate = ...
    FirstQuartile: QgsAggregateCalculator.Aggregate = ...
    ThirdQuartile: QgsAggregateCalculator.Aggregate = ...
    InterQuartileRange: QgsAggregateCalculator.Aggregate = ...
    StringMinimumLength: QgsAggregateCalculator.Aggregate = ...
    StringMaximumLength: QgsAggregateCalculator.Aggregate = ...
    StringConcatenate: QgsAggregateCalculator.Aggregate = ...
    GeometryCollect: QgsAggregateCalculator.Aggregate = ...
    ArrayAggregate: QgsAggregateCalculator.Aggregate = ...
    StringConcatenateUnique: QgsAggregateCalculator.Aggregate = ...

    class AggregateInfo(sip.wrapper):

        function: str = ...
        name: str = ...
        supportedTypes: Iterable[QtCore.QVariant.Type] = ...
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsAggregateCalculator.AggregateInfo) -> None: ...

    class AggregateParameters(sip.wrapper):

        delimiter: str = ...
        filter: str = ...
        orderBy: QgsFeatureRequest.OrderBy = ...
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsAggregateCalculator.AggregateParameters) -> None: ...

    @overload
    def __init__(self, layer: QgsVectorLayer) -> None: ...
    @overload
    def __init__(self, a0: QgsAggregateCalculator) -> None: ...
    @staticmethod
    def aggregates() -> List[QgsAggregateCalculator.AggregateInfo]: ...
    @staticmethod
    def stringToAggregate(string: str) -> Tuple[QgsAggregateCalculator.Aggregate, bool]: ...
    def calculate(self, aggregate: QgsAggregateCalculator.Aggregate, fieldOrExpression: str, context: Optional[QgsExpressionContext] = ...) -> Tuple[typing.Any, bool]: ...
    def delimiter(self) -> str: ...
    def setDelimiter(self, delimiter: str) -> None: ...
    def filter(self) -> str: ...
    def setFidsFilter(self, fids: typing.Any) -> None: ...
    def setFilter(self, filterExpression: str) -> None: ...
    def setParameters(self, parameters: QgsAggregateCalculator.AggregateParameters) -> None: ...
    def layer(self) -> QgsVectorLayer: ...


class QgsAnimatedIcon(QtCore.QObject):

    def __init__(self, iconPath: str = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...
    def frameChanged(self) -> None: ...
    def height(self) -> int: ...
    def width(self) -> int: ...
    def disconnectFrameChanged(self, receiver: QtCore.QObject, method: str) -> bool: ...
    def connectFrameChanged(self, receiver: QtCore.QObject, method: str) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def setIconPath(self, iconPath: str) -> None: ...
    def iconPath(self) -> str: ...


class QgsApplication(QtWidgets.QApplication):

    class endian_t(int):
        ...
    XDR: QgsApplication.endian_t = ...
    NDR: QgsApplication.endian_t = ...

    class Cursor(int):
        ...
    ZoomIn: QgsApplication.Cursor = ...
    ZoomOut: QgsApplication.Cursor = ...
    Identify: QgsApplication.Cursor = ...
    CrossHair: QgsApplication.Cursor = ...
    CapturePoint: QgsApplication.Cursor = ...
    Select: QgsApplication.Cursor = ...
    Sampler: QgsApplication.Cursor = ...

    class StyleSheetType(int):
        ...
    Qt: QgsApplication.StyleSheetType = ...
    WebBrowser: QgsApplication.StyleSheetType = ...

    QGIS_APPLICATION_NAME: str = ...
    QGIS_ORGANIZATION_DOMAIN: str = ...
    QGIS_ORGANIZATION_NAME: str = ...

    def __init__(self, argv: List[str], GUIenabled: bool, profileFolder: str = ..., platformName: str = ...) -> None: ...
    def requestForTranslatableObjects(self, translationContext: QgsTranslationContext) -> None: ...
    def nullRepresentationChanged(self) -> None: ...
    def customVariablesChanged(self) -> None: ...
    def collectTranslatableObjects(self, translationContext: QgsTranslationContext) -> None: ...
    @staticmethod
    def setTranslation(translation: str) -> None: ...
    def maxConcurrentConnectionsPerPool(self) -> int: ...
    @staticmethod
    def scaleIconSize(standardSize: int, applyDevicePixelRatio: bool = ...) -> int: ...
    @staticmethod
    def setCustomVariable(name: str, value: typing.Any) -> None: ...
    @staticmethod
    def setCustomVariables(customVariables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def customVariables() -> Dict[str, typing.Any]: ...
    @staticmethod
    def setNullRepresentation(nullRepresentation: str) -> None: ...
    @staticmethod
    def nullRepresentation() -> str: ...
    @staticmethod
    def localizedDataPathRegistry() -> QgsLocalizedDataPathRegistry: ...
    @staticmethod
    def projectStorageRegistry() -> QgsProjectStorageRegistry: ...
    @staticmethod
    def scaleBarRendererRegistry() -> QgsScaleBarRendererRegistry: ...
    @staticmethod
    def symbol3DRegistry() -> Qgs3DSymbolRegistry: ...
    @staticmethod
    def renderer3DRegistry() -> Qgs3DRendererRegistry: ...
    @staticmethod
    def fieldFormatterRegistry() -> QgsFieldFormatterRegistry: ...
    @staticmethod
    def numericFormatRegistry() -> QgsNumericFormatRegistry: ...
    @staticmethod
    def profiler() -> QgsRuntimeProfiler: ...
    @staticmethod
    def connectionRegistry() -> QgsConnectionRegistry: ...
    @staticmethod
    def actionScopeRegistry() -> QgsActionScopeRegistry: ...
    @staticmethod
    def pageSizeRegistry() -> QgsPageSizeRegistry: ...
    @staticmethod
    def processingRegistry() -> QgsProcessingRegistry: ...
    @staticmethod
    def authManager() -> QgsAuthManager: ...
    @staticmethod
    def messageLog() -> QgsMessageLog: ...
    @staticmethod
    def defaultStyleModel() -> QgsStyleModel: ...
    @staticmethod
    def bookmarkManager() -> QgsBookmarkManager: ...
    @staticmethod
    def classificationMethodRegistry() -> QgsClassificationMethodRegistry: ...
    @staticmethod
    def pluginLayerRegistry() -> QgsPluginLayerRegistry: ...
    @staticmethod
    def gpsConnectionRegistry() -> QgsGpsConnectionRegistry: ...
    @staticmethod
    def annotationItemRegistry() -> QgsAnnotationItemRegistry: ...
    @staticmethod
    def layoutItemRegistry() -> QgsLayoutItemRegistry: ...
    @staticmethod
    def calloutRegistry() -> QgsCalloutRegistry: ...
    @staticmethod
    def symbolLayerRegistry() -> QgsSymbolLayerRegistry: ...
    @staticmethod
    def validityCheckRegistry() -> QgsValidityCheckRegistry: ...
    @staticmethod
    def networkContentFetcherRegistry() -> QgsNetworkContentFetcherRegistry: ...
    @staticmethod
    def sourceCache() -> QgsSourceCache: ...
    @staticmethod
    def imageCache() -> QgsImageCache: ...
    @staticmethod
    def svgCache() -> QgsSvgCache: ...
    @staticmethod
    def coordinateReferenceSystemRegistry() -> QgsCoordinateReferenceSystemRegistry: ...
    @staticmethod
    def dataItemProviderRegistry() -> QgsDataItemProviderRegistry: ...
    @staticmethod
    def pointCloudRendererRegistry() -> QgsPointCloudRendererRegistry: ...
    @staticmethod
    def rendererRegistry() -> QgsRendererRegistry: ...
    @staticmethod
    def paintEffectRegistry() -> QgsPaintEffectRegistry: ...
    @staticmethod
    def colorSchemeRegistry() -> QgsColorSchemeRegistry: ...
    @staticmethod
    def settingsRegistryCore() -> QgsSettingsRegistryCore: ...
    @staticmethod
    def taskManager() -> QgsTaskManager: ...
    @staticmethod
    def setMaxThreads(maxThreads: int) -> None: ...
    @staticmethod
    def maxThreads() -> int: ...
    @staticmethod
    def setSkippedGdalDrivers(skippedGdalDrivers: Iterable[str], deferredSkippedGdalDrivers: Iterable[str]) -> None: ...
    @staticmethod
    def deferredSkippedGdalDrivers() -> List[str]: ...
    @staticmethod
    def registerGdalDriversFromSettings() -> None: ...
    @staticmethod
    def applyGdalSkippedDrivers() -> None: ...
    @staticmethod
    def skippedGdalDrivers() -> List[str]: ...
    @staticmethod
    def restoreGdalDriver(driver: str) -> None: ...
    @staticmethod
    def skipGdalDriver(driver: str) -> None: ...
    @staticmethod
    def buildOutputPath() -> str: ...
    @staticmethod
    def buildSourcePath() -> str: ...
    @staticmethod
    def isRunningFromBuildDir() -> bool: ...
    @staticmethod
    def relativePathToAbsolutePath(rpath: str, targetPath: str) -> str: ...
    @staticmethod
    def absolutePathToRelativePath(apath: str, targetPath: str) -> str: ...
    @staticmethod
    def registerOgrDrivers() -> None: ...
    @staticmethod
    def showSettings() -> str: ...
    @staticmethod
    def reportStyleSheet(styleSheetType: QgsApplication.StyleSheetType = ...) -> str: ...
    @staticmethod
    def endian() -> QgsApplication.endian_t: ...
    @staticmethod
    def appIconPath() -> str: ...
    @staticmethod
    def exitQgis() -> None: ...
    @staticmethod
    def createThemeFolder() -> bool: ...
    @staticmethod
    def createDatabase(errorMessage: Optional[str] = ...) -> bool: ...
    @staticmethod
    def initQgis() -> None: ...
    @staticmethod
    def setAuthDatabaseDirPath(authDbDirPath: str) -> None: ...
    @staticmethod
    def setDefaultSvgPaths(pathList: Iterable[str]) -> None: ...
    @staticmethod
    def setPkgDataPath(pkgDataPath: str) -> None: ...
    @staticmethod
    def setPluginPath(pluginPath: str) -> None: ...
    @staticmethod
    def setPrefixPath(prefixPath: str, useDefaultPaths: bool = ...) -> None: ...
    @staticmethod
    def qmlImportPath() -> str: ...
    @staticmethod
    def libexecPath() -> str: ...
    @staticmethod
    def libraryPath() -> str: ...
    @staticmethod
    def defaultThemesFolder() -> str: ...
    @staticmethod
    def defaultStylePath() -> str: ...
    @staticmethod
    def userThemesFolder() -> str: ...
    @staticmethod
    def locale() -> str: ...
    @staticmethod
    def platform() -> str: ...
    @staticmethod
    def osName() -> str: ...
    @staticmethod
    def userFullName() -> str: ...
    @staticmethod
    def userLoginName() -> str: ...
    @staticmethod
    def shortNameRegExp() -> QtCore.QRegExp: ...
    @staticmethod
    def userStylePath() -> str: ...
    @staticmethod
    def getThemePixmap(name: str, foreColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., backColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., size: int = ...) -> QtGui.QPixmap: ...
    @staticmethod
    def getThemeCursor(cursor: QgsApplication.Cursor) -> QtGui.QCursor: ...
    @staticmethod
    def getThemeIcon(name: str, fillColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., strokeColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> QtGui.QIcon: ...
    @staticmethod
    def iconPath(iconFile: str) -> str: ...
    @staticmethod
    def defaultThemePath() -> str: ...
    @staticmethod
    def activeThemePath() -> str: ...
    @staticmethod
    def pkgDataPath() -> str: ...
    @staticmethod
    def pluginPath() -> str: ...
    @staticmethod
    def prefixPath() -> str: ...
    @staticmethod
    def systemEnvVars() -> Dict[str, str]: ...
    @staticmethod
    def layoutTemplatePaths() -> List[str]: ...
    @staticmethod
    def svgPaths() -> List[str]: ...
    @staticmethod
    def setSvgPaths(svgPaths: Iterable[str]) -> None: ...
    @staticmethod
    def srsDatabaseFilePath() -> str: ...
    @staticmethod
    def iconsPath() -> str: ...
    @staticmethod
    def splashPath() -> str: ...
    @staticmethod
    def qgisAuthDatabaseFilePath() -> str: ...
    @staticmethod
    def qgisUserDatabaseFilePath() -> str: ...
    @staticmethod
    def qgisSettingsDirPath() -> str: ...
    @staticmethod
    def qgisMasterDatabaseFilePath() -> str: ...
    @staticmethod
    def metadataPath() -> str: ...
    @staticmethod
    def i18nPath() -> str: ...
    @staticmethod
    def licenceFilePath() -> str: ...
    @staticmethod
    def translatorsFilePath() -> str: ...
    @staticmethod
    def serverResourcesPath() -> str: ...
    @staticmethod
    def donorsFilePath() -> str: ...
    @staticmethod
    def sponsorsFilePath() -> str: ...
    @staticmethod
    def developersMapFilePath() -> str: ...
    @staticmethod
    def contributorsFilePath() -> str: ...
    @staticmethod
    def authorsFilePath() -> str: ...
    @staticmethod
    def uiThemes() -> Dict[str, str]: ...
    @staticmethod
    def setUITheme(themeName: str) -> None: ...
    @staticmethod
    def themeName() -> str: ...
    @staticmethod
    def resolvePkgPath() -> str: ...
    @staticmethod
    def setThemeName(themeName: str) -> None: ...
    @staticmethod
    def setFileOpenEventReceiver(receiver: QtCore.QObject) -> None: ...
    def notify(self, receiver: QtCore.QObject, event: QtCore.QEvent) -> bool: ...
    def event(self, event: QtCore.QEvent) -> bool: ...
    @staticmethod
    def instance() -> QgsApplication: ...


class QgsArchive(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsArchive) -> None: ...
    def dir(self) -> str: ...
    def files(self) -> List[str]: ...
    def removeFile(self, filename: str) -> bool: ...
    def addFile(self, filename: str) -> None: ...
    def clear(self) -> None: ...
    def unzip(self, zipFilename: str) -> bool: ...
    def zip(self, zipFilename: str) -> bool: ...


class QgsProjectArchive(QgsArchive):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjectArchive) -> None: ...
    def auxiliaryStorageFile(self) -> str: ...
    def clearProjectFile(self) -> bool: ...
    def projectFile(self) -> str: ...
    def unzip(self, zipFilename: str) -> bool: ...


class QgsAttributeTableConfig(sip.wrapper):

    class ActionWidgetStyle(int):
        ...
    ButtonList: QgsAttributeTableConfig.ActionWidgetStyle = ...
    DropDown: QgsAttributeTableConfig.ActionWidgetStyle = ...

    class Type(int):
        ...
    Field: QgsAttributeTableConfig.Type = ...
    Action: QgsAttributeTableConfig.Type = ...

    class ColumnConfig(sip.wrapper):

        hidden: bool = ...
        name: str = ...
        type: QgsAttributeTableConfig.Type = ...
        width: int = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsAttributeTableConfig.ColumnConfig) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeTableConfig) -> None: ...
    def hasSameColumns(self, other: QgsAttributeTableConfig) -> bool: ...
    def setSortOrder(self, sortOrder: QtCore.Qt.SortOrder) -> None: ...
    def sortOrder(self) -> QtCore.Qt.SortOrder: ...
    def setColumnHidden(self, column: int, hidden: bool) -> None: ...
    def columnHidden(self, column: int) -> bool: ...
    def setColumnWidth(self, column: int, width: int) -> None: ...
    def columnWidth(self, column: int) -> int: ...
    def setSortExpression(self, sortExpression: str) -> None: ...
    def sortExpression(self) -> str: ...
    def readXml(self, node: QtXml.QDomNode) -> None: ...
    def writeXml(self, node: QtXml.QDomNode) -> None: ...
    def setActionWidgetStyle(self, actionWidgetStyle: QgsAttributeTableConfig.ActionWidgetStyle) -> None: ...
    def actionWidgetStyle(self) -> QgsAttributeTableConfig.ActionWidgetStyle: ...
    def setActionWidgetVisible(self, visible: bool) -> None: ...
    def actionWidgetVisible(self) -> bool: ...
    def update(self, fields: QgsFields) -> None: ...
    def setColumns(self, columns: Iterable[QgsAttributeTableConfig.ColumnConfig]) -> None: ...
    def mapVisibleColumnToIndex(self, visibleColumn: int) -> int: ...
    def isEmpty(self) -> bool: ...
    def columns(self) -> List[QgsAttributeTableConfig.ColumnConfig]: ...


class QgsMapLayer(QtCore.QObject):

    class ReadFlag(int):
        ...
    FlagDontResolveLayers: QgsMapLayer.ReadFlag = ...
    FlagTrustLayerMetadata: QgsMapLayer.ReadFlag = ...
    FlagReadExtentFromXml: QgsMapLayer.ReadFlag = ...

    class StyleCategory(int):
        ...
    LayerConfiguration: QgsMapLayer.StyleCategory = ...
    Symbology: QgsMapLayer.StyleCategory = ...
    Symbology3D: QgsMapLayer.StyleCategory = ...
    Labeling: QgsMapLayer.StyleCategory = ...
    Fields: QgsMapLayer.StyleCategory = ...
    Forms: QgsMapLayer.StyleCategory = ...
    Actions: QgsMapLayer.StyleCategory = ...
    MapTips: QgsMapLayer.StyleCategory = ...
    Diagrams: QgsMapLayer.StyleCategory = ...
    AttributeTable: QgsMapLayer.StyleCategory = ...
    Rendering: QgsMapLayer.StyleCategory = ...
    CustomProperties: QgsMapLayer.StyleCategory = ...
    GeometryOptions: QgsMapLayer.StyleCategory = ...
    Relations: QgsMapLayer.StyleCategory = ...
    Temporal: QgsMapLayer.StyleCategory = ...
    Legend: QgsMapLayer.StyleCategory = ...
    Elevation: QgsMapLayer.StyleCategory = ...
    Notes: QgsMapLayer.StyleCategory = ...
    AllStyleCategories: QgsMapLayer.StyleCategory = ...

    class LayerFlag(int):
        ...
    Identifiable: QgsMapLayer.LayerFlag = ...
    Removable: QgsMapLayer.LayerFlag = ...
    Searchable: QgsMapLayer.LayerFlag = ...
    Private: QgsMapLayer.LayerFlag = ...

    class PropertyType(int):
        ...
    Style: QgsMapLayer.PropertyType = ...
    Metadata: QgsMapLayer.PropertyType = ...

    class LayerFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapLayer.LayerFlags, QgsMapLayer.LayerFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayer.LayerFlags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapLayer.LayerFlags: ...
        def __int__(self) -> int: ...

    class StyleCategories(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayer.StyleCategories) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapLayer.StyleCategories: ...
        def __int__(self) -> int: ...

    class ReadFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapLayer.ReadFlags, QgsMapLayer.ReadFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayer.ReadFlags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapLayer.ReadFlags: ...
        def __int__(self) -> int: ...

    def __init__(self, type: QgsMapLayerType = ..., name: str = ..., source: str = ...) -> None: ...

    def hasDependencyCycle(self, a0: Iterable[QgsMapLayerDependency]) -> bool: ...
    def invalidateWgs84Extent(self) -> None: ...
    def setError(self, error: QgsError) -> None: ...
    def appendError(self, error: QgsErrorMessage) -> None: ...
    def setProviderType(self, providerType: str) -> None: ...
    def readCommonStyle(self, layerElement: QtXml.QDomElement, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> None: ...
    def writeCommonStyle(self, layerElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> None: ...
    def writeStyleManager(self, layerNode: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readStyleManager(self, layerNode: QtXml.QDomNode) -> None: ...
    def writeCustomProperties(self, layerNode: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readCustomProperties(self, layerNode: QtXml.QDomNode, keyStartsWith: str = ...) -> None: ...
    def decodedSource(self, source: str, dataProvider: str, context: QgsReadWriteContext) -> str: ...
    def encodedSource(self, source: str, context: QgsReadWriteContext) -> str: ...
    def writeXml(self, layer_node: QtXml.QDomNode, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, layer_node: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def setValid(self, valid: bool) -> None: ...
    def setExtent(self, rect: QgsRectangle) -> None: ...
    def customPropertyChanged(self, key: str) -> None: ...
    def isValidChanged(self) -> None: ...
    def styleLoaded(self, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory]) -> None: ...
    def dataSourceChanged(self) -> None: ...
    def flagsChanged(self) -> None: ...
    def metadataChanged(self) -> None: ...
    def autoRefreshIntervalChanged(self, interval: int) -> None: ...
    def willBeDeleted(self) -> None: ...
    def dependenciesChanged(self) -> None: ...
    def configChanged(self) -> None: ...
    def request3DUpdate(self) -> None: ...
    def renderer3DChanged(self) -> None: ...
    def legendChanged(self) -> None: ...
    def styleChanged(self) -> None: ...
    def rendererChanged(self) -> None: ...
    def opacityChanged(self, opacity: float) -> None: ...
    def blendModeChanged(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    def dataChanged(self) -> None: ...
    def recalculateExtents(self) -> None: ...
    def repaintRequested(self, deferredUpdate: bool = ...) -> None: ...
    def crsChanged(self) -> None: ...
    def nameChanged(self) -> None: ...
    def statusChanged(self, status: str) -> None: ...
    def beforeResolveReferences(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...
    def __repr__(self) -> typing.Any: ...
    def setTransformContext(self, transformContext: QgsCoordinateTransformContext) -> None: ...
    def setRefreshOnNofifyMessage(self, message: str) -> None: ...
    def setRefreshOnNotifyEnabled(self, enabled: bool) -> None: ...
    def setDependencies(self, layers: Iterable[QgsMapLayerDependency]) -> bool: ...
    def emitStyleChanged(self) -> None: ...
    def trigger3DUpdate(self) -> None: ...
    def triggerRepaint(self, deferredUpdate: bool = ...) -> None: ...
    def setScaleBasedVisibility(self, enabled: bool) -> None: ...
    def setMaximumScale(self, scale: float) -> None: ...
    def setMinimumScale(self, scale: float) -> None: ...
    def elevationProperties(self) -> QgsMapLayerElevationProperties: ...
    def temporalProperties(self) -> QgsMapLayerTemporalProperties: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    @staticmethod
    def generateId(layerName: str) -> str: ...
    def setOriginalXmlProperties(self, originalXmlProperties: str) -> None: ...
    def originalXmlProperties(self) -> str: ...
    def isRefreshOnNotifyEnabled(self) -> bool: ...
    def refreshOnNotifyMessage(self) -> str: ...
    def dependencies(self) -> Set[QgsMapLayerDependency]: ...
    def timestamp(self) -> QtCore.QDateTime: ...
    def htmlMetadata(self) -> str: ...
    def setMetadata(self, metadata: QgsLayerMetadata) -> None: ...
    def metadata(self) -> QgsLayerMetadata: ...
    def setAutoRefreshEnabled(self, enabled: bool) -> None: ...
    def setAutoRefreshInterval(self, interval: int) -> None: ...
    def autoRefreshInterval(self) -> int: ...
    def hasAutoRefreshEnabled(self) -> bool: ...
    def hasScaleBasedVisibility(self) -> bool: ...
    def maximumScale(self) -> float: ...
    def minimumScale(self) -> float: ...
    def isInScaleRange(self, scale: float) -> bool: ...
    def renderer3D(self) -> QgsAbstract3DRenderer: ...
    def setRenderer3D(self, renderer: QgsAbstract3DRenderer) -> None: ...
    def styleManager(self) -> QgsMapLayerStyleManager: ...
    def legend(self) -> QgsMapLayerLegend: ...
    def setLegend(self, legend: QgsMapLayerLegend) -> None: ...
    def legendUrlFormat(self) -> str: ...
    def setLegendUrlFormat(self, legendUrlFormat: str) -> None: ...
    def legendUrl(self) -> str: ...
    def setLegendUrl(self, legendUrl: str) -> None: ...
    def undoStackStyles(self) -> QtWidgets.QUndoStack: ...
    def undoStack(self) -> QtWidgets.QUndoStack: ...
    def providerType(self) -> str: ...
    @overload
    def setDataSource(self, dataSource: str, baseName: str, provider: str, loadDefaultStyleFlag: bool = ...) -> None: ...
    @overload
    def setDataSource(self, dataSource: str, baseName: str, provider: str, options: QgsDataProvider.ProviderOptions, loadDefaultStyleFlag: bool = ...) -> None: ...
    @overload
    def setDataSource(self, dataSource: str, baseName: str, provider: str, options: QgsDataProvider.ProviderOptions, flags: Union[QgsDataProvider.ReadFlags, QgsDataProvider.ReadFlag]) -> None: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readSld(self, node: QtXml.QDomNode, errorMessage: str) -> bool: ...
    def loadSldStyle(self, uri: str) -> Tuple[str, bool]: ...
    def saveSldStyle(self, uri: str) -> Tuple[str, bool]: ...
    def saveNamedStyle(self, uri: str, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> Tuple[str, bool]: ...
    def saveDefaultStyle(self) -> Tuple[str, bool]: ...
    def exportSldStyle(self, doc: QtXml.QDomDocument, errorMsg: str) -> None: ...
    def exportNamedStyle(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ..., categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> str: ...
    def importNamedStyle(self, doc: QtXml.QDomDocument, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> Tuple[bool, str]: ...
    def loadNamedStyleFromDatabase(self, db: str, uri: str) -> Tuple[bool, str]: ...
    def loadNamedStyle(self, uri: str, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> Tuple[str, bool]: ...
    def loadDefaultStyle(self) -> Tuple[str, bool]: ...
    def styleURI(self) -> str: ...
    def importNamedMetadata(self, document: QtXml.QDomDocument, errorMessage: str) -> bool: ...
    def loadNamedMetadataFromDatabase(self, db: str, uri: str, qmd: str) -> bool: ...
    def loadDefaultMetadata(self) -> Tuple[str, bool]: ...
    def loadNamedMetadata(self, uri: str) -> Tuple[str, bool]: ...
    def saveNamedMetadata(self, uri: str) -> Tuple[str, bool]: ...
    def saveDefaultMetadata(self) -> Tuple[str, bool]: ...
    def exportNamedMetadata(self, doc: QtXml.QDomDocument, errorMsg: str) -> None: ...
    def metadataUri(self) -> str: ...
    @staticmethod
    def formatLayerName(name: str) -> str: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...
    def setCrs(self, srs: QgsCoordinateReferenceSystem, emitSignal: bool = ...) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def error(self) -> QgsError: ...
    def removeCustomProperty(self, key: str) -> None: ...
    def customProperties(self) -> QgsObjectCustomProperties: ...
    def setCustomProperties(self, properties: QgsObjectCustomProperties) -> None: ...
    def customProperty(self, value: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setCustomProperty(self, key: str, value: typing.Any) -> None: ...
    def customPropertyKeys(self) -> List[str]: ...
    def resolveReferences(self, project: QgsProject) -> None: ...
    def writeLayerXml(self, layerElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readLayerXml(self, layerElement: QtXml.QDomElement, context: QgsReadWriteContext, flags: Union[QgsMapLayer.ReadFlags, QgsMapLayer.ReadFlag] = ...) -> bool: ...
    def isTemporary(self) -> bool: ...
    def isSpatial(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def setSubLayerVisibility(self, name: str, visible: bool) -> None: ...
    def setLayerOrder(self, layers: Iterable[str]) -> None: ...
    def subLayers(self) -> List[str]: ...
    def source(self) -> str: ...
    def publicSource(self) -> str: ...
    def isValid(self) -> bool: ...
    def wgs84Extent(self, forceRecalculate: bool = ...) -> QgsRectangle: ...
    def extent(self) -> QgsRectangle: ...
    def createMapRenderer(self, rendererContext: QgsRenderContext) -> QgsMapLayerRenderer: ...
    def reload(self) -> None: ...
    def readOnly(self) -> bool: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    def metadataUrlFormat(self) -> str: ...
    def setMetadataUrlFormat(self, metaUrlFormat: str) -> None: ...
    def metadataUrlType(self) -> str: ...
    def setMetadataUrlType(self, metaUrlType: str) -> None: ...
    def metadataUrl(self) -> str: ...
    def setMetadataUrl(self, metaUrl: str) -> None: ...
    def attributionUrl(self) -> str: ...
    def setAttributionUrl(self, attribUrl: str) -> None: ...
    def attribution(self) -> str: ...
    def setAttribution(self, attrib: str) -> None: ...
    def dataUrlFormat(self) -> str: ...
    def setDataUrlFormat(self, dataUrlFormat: str) -> None: ...
    def dataUrl(self) -> str: ...
    def setDataUrl(self, dataUrl: str) -> None: ...
    def keywordList(self) -> str: ...
    def setKeywordList(self, keywords: str) -> None: ...
    def abstract(self) -> str: ...
    def setAbstract(self, abstract: str) -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def shortName(self) -> str: ...
    def setShortName(self, shortName: str) -> None: ...
    def dataProvider(self) -> QgsDataProvider: ...
    def name(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def id(self) -> str: ...
    @staticmethod
    def extensionPropertyType(type: QgsMapLayer.PropertyType) -> str: ...
    def setFlags(self, flags: Union[QgsMapLayer.LayerFlags, QgsMapLayer.LayerFlag]) -> None: ...
    def flags(self) -> QgsMapLayer.LayerFlags: ...
    def type(self) -> QgsMapLayerType: ...
    @overload
    def clone(self) -> QgsMapLayer: ...
    @overload
    def clone(self, layer: QgsMapLayer) -> None: ...


class QgsExpressionContextGenerator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionContextGenerator) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...


class QgsExpressionContextScopeGenerator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionContextScopeGenerator) -> None: ...
    def createExpressionContextScope(self) -> QgsExpressionContextScope: ...


class QgsFeatureSink(sip.wrapper):

    class Flag(int):
        ...
    FastInsert: QgsFeatureSink.Flag = ...
    RollBackOnErrors: QgsFeatureSink.Flag = ...

    class SinkFlag(int):
        ...
    RegeneratePrimaryKey: QgsFeatureSink.SinkFlag = ...

    class SinkFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsFeatureSink.SinkFlags, QgsFeatureSink.SinkFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsFeatureSink.SinkFlags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsFeatureSink.SinkFlags: ...
        def __int__(self) -> int: ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsFeatureSink.Flags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsFeatureSink.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureSink) -> None: ...
    def lastError(self) -> str: ...
    def flushBuffer(self) -> bool: ...
    @overload
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    @overload
    def addFeatures(self, iterator: QgsFeatureIterator, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...


class QgsFeatureSource(sip.wrapper):

    class SpatialIndexPresence(int):
        ...
    SpatialIndexUnknown: QgsFeatureSource.SpatialIndexPresence = ...
    SpatialIndexNotPresent: QgsFeatureSource.SpatialIndexPresence = ...
    SpatialIndexPresent: QgsFeatureSource.SpatialIndexPresence = ...

    class FeatureAvailability(int):
        ...
    NoFeaturesAvailable: QgsFeatureSource.FeatureAvailability = ...
    FeaturesAvailable: QgsFeatureSource.FeatureAvailability = ...
    FeaturesMaybeAvailable: QgsFeatureSource.FeatureAvailability = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureSource) -> None: ...
    def hasSpatialIndex(self) -> QgsFeatureSource.SpatialIndexPresence: ...
    def materialize(self, request: QgsFeatureRequest, feedback: Optional[QgsFeedback] = ...) -> QgsVectorLayer: ...
    def allFeatureIds(self) -> typing.Any: ...
    def sourceExtent(self) -> QgsRectangle: ...
    def maximumValue(self, fieldIndex: int) -> typing.Any: ...
    def minimumValue(self, fieldIndex: int) -> typing.Any: ...
    def uniqueValues(self, fieldIndex: int, limit: int = ...) -> Set[typing.Any]: ...
    def hasFeatures(self) -> QgsFeatureSource.FeatureAvailability: ...
    def featureCount(self) -> int: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def fields(self) -> QgsFields: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...
    def sourceName(self) -> str: ...
    def getFeatures(self, request: QgsFeatureRequest = ...) -> QgsFeatureIterator: ...


class QgsVectorLayer(QgsMapLayer, QgsExpressionContextGenerator, QgsExpressionContextScopeGenerator, QgsFeatureSink, QgsFeatureSource):

    class VertexMarkerType(int):
        ...
    SemiTransparentCircle: QgsVectorLayer.VertexMarkerType = ...
    Cross: QgsVectorLayer.VertexMarkerType = ...
    NoMarker: QgsVectorLayer.VertexMarkerType = ...

    class SelectBehavior(int):
        ...
    SetSelection: QgsVectorLayer.SelectBehavior = ...
    AddToSelection: QgsVectorLayer.SelectBehavior = ...
    IntersectSelection: QgsVectorLayer.SelectBehavior = ...
    RemoveFromSelection: QgsVectorLayer.SelectBehavior = ...

    class EditResult(int):
        ...
    Success: QgsVectorLayer.EditResult = ...
    EmptyGeometry: QgsVectorLayer.EditResult = ...
    EditFailed: QgsVectorLayer.EditResult = ...
    FetchFeatureFailed: QgsVectorLayer.EditResult = ...
    InvalidLayer: QgsVectorLayer.EditResult = ...

    class LayerOptions(sip.wrapper):

        fallbackCrs: QgsCoordinateReferenceSystem = ...
        fallbackWkbType: QgsWkbTypes.Type = ...
        loadDefaultStyle: bool = ...
        readExtentFromXml: bool = ...
        skipCrsValidation: bool = ...
        transformContext: QgsCoordinateTransformContext = ...

        @overload
        def __init__(self, loadDefaultStyle: bool = ..., readExtentFromXml: bool = ...) -> None: ...
        @overload
        def __init__(self, transformContext: QgsCoordinateTransformContext, loadDefaultStyle: bool = ..., readExtentFromXml: bool = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorLayer.LayerOptions) -> None: ...

    class DeleteContext(sip.wrapper):

        cascade: bool = ...
        project: QgsProject = ...

        @overload
        def __init__(self, cascade: bool = ..., project: Optional[QgsProject] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorLayer.DeleteContext) -> None: ...
        def handledFeatures(self, layer: QgsVectorLayer) -> typing.Any: ...
        def handledLayers(self, includeAuxiliaryLayers: bool = ...) -> List[QgsVectorLayer]: ...

    def __init__(self, path: str = ..., baseName: str = ..., providerLib: str = ..., options: QgsVectorLayer.LayerOptions = ...) -> None: ...

    def setExtent(self, rect: QgsRectangle) -> None: ...
    def symbolFeatureCountMapChanged(self) -> None: ...
    def supportsEditingChanged(self) -> None: ...
    def readOnlyChanged(self) -> None: ...
    def editFormConfigChanged(self) -> None: ...
    def raiseError(self, msg: str) -> None: ...
    def displayExpressionChanged(self) -> None: ...
    def mapTipTemplateChanged(self) -> None: ...
    def writeCustomSymbology(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, errorMessage: str) -> None: ...
    def readCustomSymbology(self, element: QtXml.QDomElement, errorMessage: str) -> None: ...
    def editCommandDestroyed(self) -> None: ...
    def editCommandEnded(self) -> None: ...
    def editCommandStarted(self, text: str) -> None: ...
    def featureBlendModeChanged(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    def labelingFontNotFound(self, layer: QgsVectorLayer, fontfamily: str) -> None: ...
    def committedGeometriesChanges(self, layerId: str, changedGeometries: typing.Any) -> None: ...
    def committedAttributeValuesChanges(self, layerId: str, changedAttributesValues: typing.Any) -> None: ...
    def committedFeaturesRemoved(self, layerId: str, deletedFeatureIds: typing.Any) -> None: ...
    def committedFeaturesAdded(self, layerId: str, addedFeatures: Iterable[QgsFeature]) -> None: ...
    def committedAttributesAdded(self, layerId: str, addedAttributes: typing.Any) -> None: ...
    def committedAttributesDeleted(self, layerId: str, deletedAttributes: Iterable[int]) -> None: ...
    def geometryChanged(self, fid: int, geometry: QgsGeometry) -> None: ...
    def attributeValueChanged(self, fid: int, idx: int, value: typing.Any) -> None: ...
    def subsetStringChanged(self) -> None: ...
    def updatedFields(self) -> None: ...
    def featuresDeleted(self, fids: typing.Any) -> None: ...
    def featureDeleted(self, fid: int) -> None: ...
    def featureAdded(self, fid: int) -> None: ...
    def beforeRemovingExpressionField(self, idx: int) -> None: ...
    def attributeDeleted(self, idx: int) -> None: ...
    def beforeAddingExpressionField(self, fieldName: str) -> None: ...
    def attributeAdded(self, idx: int) -> None: ...
    def afterRollBack(self) -> None: ...
    def afterCommitChanges(self) -> None: ...
    def beforeRollBack(self) -> None: ...
    def beforeCommitChanges(self, stopEditing: bool) -> None: ...
    def editingStopped(self) -> None: ...
    def editingStarted(self) -> None: ...
    def beforeEditingStarted(self) -> None: ...
    def beforeModifiedCheck(self) -> None: ...
    def allowCommitChanged(self) -> None: ...
    def layerModified(self) -> None: ...
    def selectionChanged(self, selected: typing.Any, deselected: typing.Any, clearAndSelect: bool) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def hasSpatialIndex(self) -> QgsFeatureSource.SpatialIndexPresence: ...
    def setTransformContext(self, transformContext: QgsCoordinateTransformContext) -> None: ...
    def startEditing(self) -> bool: ...
    def updateExtents(self, force: bool = ...) -> None: ...
    def reselect(self) -> None: ...
    def removeSelection(self) -> None: ...
    @overload
    def deselect(self, featureId: int) -> None: ...
    @overload
    def deselect(self, featureIds: typing.Any) -> None: ...
    @overload
    def select(self, featureId: int) -> None: ...
    @overload
    def select(self, featureIds: typing.Any) -> None: ...
    def storedExpressionManager(self) -> QgsStoredExpressionManager: ...
    def geometryOptions(self) -> QgsGeometryOptions: ...
    def isEditCommandActive(self) -> bool: ...
    def readExtentFromXml(self) -> bool: ...
    def setReadExtentFromXml(self, readExtentFromXml: bool) -> None: ...
    def setEditFormConfig(self, editFormConfig: QgsEditFormConfig) -> None: ...
    def editFormConfig(self) -> QgsEditFormConfig: ...
    def createExpressionContextScope(self) -> QgsExpressionContextScope: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def setMapTipTemplate(self, mapTipTemplate: str) -> None: ...
    def mapTipTemplate(self) -> str: ...
    def setAttributeTableConfig(self, attributeTableConfig: QgsAttributeTableConfig) -> None: ...
    def attributeTableConfig(self) -> QgsAttributeTableConfig: ...
    def conditionalStyles(self) -> QgsConditionalLayerStyles: ...
    def simplifyDrawingCanbeApplied(self, renderContext: QgsRenderContext, simplifyHint: QgsVectorSimplifyMethod.SimplifyHint) -> bool: ...
    def simplifyMethod(self) -> QgsVectorSimplifyMethod: ...
    def setSimplifyMethod(self, simplifyMethod: QgsVectorSimplifyMethod) -> None: ...
    def htmlMetadata(self) -> str: ...
    def featureBlendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setFeatureBlendMode(self, blendMode: QtGui.QPainter.CompositionMode) -> None: ...
    def aggregate(self, aggregate: QgsAggregateCalculator.Aggregate, fieldOrExpression: str, parameters: QgsAggregateCalculator.AggregateParameters = ..., context: Optional[QgsExpressionContext] = ..., fids: Optional[typing.Any] = ...) -> Tuple[typing.Any, bool]: ...
    def minimumAndMaximumValue(self, index: int) -> Tuple[typing.Any, typing.Any]: ...
    def maximumValue(self, index: int) -> typing.Any: ...
    def minimumValue(self, index: int) -> typing.Any: ...
    def uniqueStringsMatching(self, index: int, substring: str, limit: int = ..., feedback: Optional[QgsFeedback] = ...) -> List[str]: ...
    def uniqueValues(self, fieldIndex: int, limit: int = ...) -> Set[typing.Any]: ...
    def editorWidgetSetup(self, index: int) -> QgsEditorWidgetSetup: ...
    def setEditorWidgetSetup(self, index: int, setup: QgsEditorWidgetSetup) -> None: ...
    def setConstraintExpression(self, index: int, expression: str, description: str = ...) -> None: ...
    def constraintDescription(self, index: int) -> str: ...
    def constraintExpression(self, index: int) -> str: ...
    def removeFieldConstraint(self, index: int, constraint: QgsFieldConstraints.Constraint) -> None: ...
    def setFieldConstraint(self, index: int, constraint: QgsFieldConstraints.Constraint, strength: QgsFieldConstraints.ConstraintStrength = ...) -> None: ...
    def fieldConstraintsAndStrength(self, fieldIndex: int) -> Dict[QgsFieldConstraints.Constraint, QgsFieldConstraints.ConstraintStrength]: ...
    def fieldConstraints(self, fieldIndex: int) -> QgsFieldConstraints.Constraints: ...
    def defaultValueDefinition(self, index: int) -> QgsDefaultValue: ...
    def setDefaultValueDefinition(self, index: int, definition: QgsDefaultValue) -> None: ...
    def defaultValue(self, index: int, feature: QgsFeature = ..., context: Optional[QgsExpressionContext] = ...) -> typing.Any: ...
    def updateFields(self) -> None: ...
    @staticmethod
    def drawVertexMarker(x: float, y: float, p: QtGui.QPainter, type: QgsVectorLayer.VertexMarkerType, vertexSize: int) -> None: ...
    def destroyEditCommand(self) -> None: ...
    def endEditCommand(self) -> None: ...
    def beginEditCommand(self, text: str) -> None: ...
    def editBuffer(self) -> QgsVectorLayerEditBuffer: ...
    def referencingRelations(self, idx: int) -> List[QgsRelation]: ...
    def rollBack(self, deleteBuffer: bool = ...) -> bool: ...
    def commitErrors(self) -> List[str]: ...
    def commitChanges(self, stopEditing: bool = ...) -> bool: ...
    def deleteFeatures(self, fids: typing.Any, context: Optional[QgsVectorLayer.DeleteContext] = ...) -> bool: ...
    def deleteFeature(self, fid: int, context: Optional[QgsVectorLayer.DeleteContext] = ...) -> bool: ...
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def deleteAttributes(self, attrs: Iterable[int]) -> bool: ...
    def deleteAttribute(self, attr: int) -> bool: ...
    def setExcludeAttributesWfs(self, att: Iterable[str]) -> None: ...
    def excludeAttributesWfs(self) -> Set[str]: ...
    def setExcludeAttributesWms(self, att: Iterable[str]) -> None: ...
    def excludeAttributesWms(self) -> Set[str]: ...
    def attributeAliases(self) -> Dict[str, str]: ...
    def attributeDisplayName(self, index: int) -> str: ...
    def attributeAlias(self, index: int) -> str: ...
    def renameAttribute(self, index: int, newName: str) -> bool: ...
    def removeFieldAlias(self, index: int) -> None: ...
    def setFieldAlias(self, index: int, aliasString: str) -> None: ...
    def addAttribute(self, field: QgsField) -> bool: ...
    def changeAttributeValues(self, fid: int, newValues: Dict[int, typing.Any], oldValues: Dict[int, typing.Any] = ..., skipDefaultValues: bool = ...) -> bool: ...
    def changeAttributeValue(self, fid: int, field: int, newValue: typing.Any, oldValue: typing.Any = ..., skipDefaultValues: bool = ...) -> bool: ...
    def changeGeometry(self, fid: int, geometry: QgsGeometry, skipDefaultValue: bool = ...) -> bool: ...
    def supportsEditing(self) -> bool: ...
    def setReadOnly(self, readonly: bool = ...) -> bool: ...
    def primaryKeyAttributes(self) -> List[int]: ...
    def attributeList(self) -> List[int]: ...
    def fields(self) -> QgsFields: ...
    def sourceExtent(self) -> QgsRectangle: ...
    def extent(self) -> QgsRectangle: ...
    def createMapRenderer(self, rendererContext: QgsRenderContext) -> QgsMapLayerRenderer: ...
    def reload(self) -> None: ...
    def isAuxiliaryField(self, index: int) -> Tuple[bool, int]: ...
    def isModified(self) -> bool: ...
    def isSpatial(self) -> bool: ...
    def isEditable(self) -> bool: ...
    def setLabeling(self, labeling: QgsAbstractVectorLayerLabeling) -> None: ...
    def labeling(self) -> QgsAbstractVectorLayerLabeling: ...
    @overload
    def addTopologicalPoints(self, geom: QgsGeometry) -> int: ...
    @overload
    def addTopologicalPoints(self, p: QgsPointXY) -> int: ...
    @overload
    def addTopologicalPoints(self, p: QgsPoint) -> int: ...
    @overload
    def addTopologicalPoints(self, ps: Iterable[QgsPoint]) -> int: ...
    @overload
    def splitFeatures(self, splitLine: Iterable[QgsPointXY], topologicalEditing: bool = ...) -> QgsGeometry.OperationResult: ...
    @overload
    def splitFeatures(self, splitLine: Iterable[QgsPoint], topologicalEditing: bool = ...) -> QgsGeometry.OperationResult: ...
    @overload
    def splitFeatures(self, curve: QgsCurve, preserveCircular: bool = ..., topologicalEditing: bool = ...) -> Tuple[QgsGeometry.OperationResult, List[QgsPoint]]: ...
    @overload
    def splitParts(self, splitLine: Iterable[QgsPointXY], topologicalEditing: bool = ...) -> QgsGeometry.OperationResult: ...
    @overload
    def splitParts(self, splitLine: Iterable[QgsPoint], topologicalEditing: bool = ...) -> QgsGeometry.OperationResult: ...
    def translateFeature(self, featureId: int, dx: float, dy: float) -> int: ...
    def addCurvedPart(self, ring: QgsCurve) -> QgsGeometry.OperationResult: ...
    @overload
    def addPartV2(self, ring: Iterable[QgsPointXY]) -> QgsGeometry.OperationResult: ...
    @overload
    def addPartV2(self, ring: Iterable[QgsPoint]) -> QgsGeometry.OperationResult: ...
    def addPart(self, ring: Iterable[QgsPointXY]) -> QgsGeometry.OperationResult: ...
    def addCurvedRing(self, ring: QgsCurve) -> Tuple[QgsGeometry.OperationResult, int]: ...
    @overload
    def addRing(self, ring: Iterable[QgsPointXY]) -> Tuple[QgsGeometry.OperationResult, int]: ...
    @overload
    def addRing(self, ring: Iterable[QgsPoint]) -> Tuple[QgsGeometry.OperationResult, int]: ...
    def deleteSelectedFeatures(self, context: Optional[QgsVectorLayer.DeleteContext] = ...) -> Tuple[bool, int]: ...
    def deleteVertex(self, featureId: int, vertex: int) -> QgsVectorLayer.EditResult: ...
    def moveVertexV2(self, p: QgsPoint, atFeatureId: int, atVertex: int) -> bool: ...
    def moveVertex(self, x: float, y: float, atFeatureId: int, atVertex: int) -> bool: ...
    @overload
    def insertVertex(self, x: float, y: float, atFeatureId: int, beforeVertex: int) -> bool: ...
    @overload
    def insertVertex(self, point: QgsPoint, atFeatureId: int, beforeVertex: int) -> bool: ...
    def updateFeature(self, feature: QgsFeature, skipDefaultValues: bool = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def getGeometry(self, fid: int) -> QgsGeometry: ...
    def getFeature(self, fid: int) -> QgsFeature: ...
    @overload
    def getFeatures(self, request: QgsFeatureRequest = ...) -> QgsFeatureIterator: ...
    @overload
    def getFeatures(self, expression: str) -> QgsFeatureIterator: ...
    @overload
    def getFeatures(self, fids: typing.Any) -> QgsFeatureIterator: ...
    @overload
    def getFeatures(self, rectangle: QgsRectangle) -> QgsFeatureIterator: ...
    def subsetString(self) -> str: ...
    def setSubsetString(self, subset: str) -> bool: ...
    def countSymbolFeatures(self, storeSymbolFids: bool = ...) -> QgsVectorLayerFeatureCounter: ...
    def loadDefaultStyle(self) -> Tuple[str, bool]: ...
    def hasFeatures(self) -> QgsFeatureSource.FeatureAvailability: ...
    def symbolFeatureIds(self, legendKey: str) -> typing.Any: ...
    @overload
    def featureCount(self, legendKey: str) -> int: ...
    @overload
    def featureCount(self) -> int: ...
    def readSld(self, node: QtXml.QDomNode, errorMessage: str) -> bool: ...
    def writeSld(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, props: Dict[str, typing.Any] = ...) -> bool: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readSymbology(self, layerNode: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def auxiliaryLayer(self) -> QgsAuxiliaryLayer: ...
    def setAuxiliaryLayer(self, layer: Optional[QgsAuxiliaryLayer] = ...) -> None: ...
    def loadAuxiliaryLayer(self, storage: QgsAuxiliaryStorage, key: str = ...) -> bool: ...
    @overload
    def loadNamedStyle(self, theURI: str, loadFromLocalDb: bool, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> Tuple[str, bool]: ...
    @overload
    def loadNamedStyle(self, theURI: str, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> Tuple[str, bool]: ...
    def deleteStyleFromDatabase(self, styleId: str) -> Tuple[bool, str]: ...
    def getStyleFromDatabase(self, styleId: str) -> Tuple[str, str]: ...
    def listStylesInDatabase(self) -> Tuple[int, List[str], List[str], List[str], str]: ...
    def saveStyleToDatabase(self, name: str, description: str, useAsDefault: bool, uiFileContent: str) -> str: ...
    def resolveReferences(self, project: QgsProject) -> None: ...
    def decodedSource(self, source: str, provider: str, context: QgsReadWriteContext) -> str: ...
    def encodedSource(self, source: str, context: QgsReadWriteContext) -> str: ...
    def writeXml(self, layer_node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, layer_node: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def sourceName(self) -> str: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def geometryType(self) -> QgsWkbTypes.GeometryType: ...
    def featureRendererGenerators(self) -> List[QgsFeatureRendererGenerator]: ...
    def removeFeatureRendererGenerator(self, id: str) -> None: ...
    def addFeatureRendererGenerator(self, generator: QgsFeatureRendererGenerator) -> None: ...
    def setRenderer(self, r: QgsFeatureRenderer) -> None: ...
    def renderer(self) -> QgsFeatureRenderer: ...
    def diagramLayerSettings(self) -> QgsDiagramLayerSettings: ...
    def setDiagramLayerSettings(self, s: QgsDiagramLayerSettings) -> None: ...
    def diagramRenderer(self) -> QgsDiagramRenderer: ...
    def setDiagramRenderer(self, r: QgsDiagramRenderer) -> None: ...
    def diagramsEnabled(self) -> bool: ...
    def setLabelsEnabled(self, enabled: bool) -> None: ...
    def labelsEnabled(self) -> bool: ...
    def boundingBoxOfSelected(self) -> QgsRectangle: ...
    def selectedFeatureIds(self) -> typing.Any: ...
    def getSelectedFeatures(self, request: QgsFeatureRequest = ...) -> QgsFeatureIterator: ...
    def selectedFeatures(self) -> List[QgsFeature]: ...
    def invertSelectionInRectangle(self, rect: QgsRectangle) -> None: ...
    def selectAll(self) -> None: ...
    def invertSelection(self) -> None: ...
    def modifySelection(self, selectIds: typing.Any, deselectIds: typing.Any) -> None: ...
    def selectByIds(self, ids: typing.Any, behavior: QgsVectorLayer.SelectBehavior = ...) -> None: ...
    def selectByExpression(self, expression: str, behavior: QgsVectorLayer.SelectBehavior = ...) -> None: ...
    def selectByRect(self, rect: QgsRectangle, behavior: QgsVectorLayer.SelectBehavior = ...) -> None: ...
    def selectedFeatureCount(self) -> int: ...
    def serverProperties(self) -> QgsVectorLayerServerProperties: ...
    def actions(self) -> QgsActionManager: ...
    def updateExpressionField(self, index: int, exp: str) -> None: ...
    def expressionField(self, index: int) -> str: ...
    def removeExpressionField(self, index: int) -> None: ...
    def addExpressionField(self, exp: str, fld: QgsField) -> int: ...
    def dependencies(self) -> Set[QgsMapLayerDependency]: ...
    def setDependencies(self, layers: Iterable[QgsMapLayerDependency]) -> bool: ...
    def vectorJoins(self) -> List[QgsVectorLayerJoinInfo]: ...
    def joinBuffer(self) -> QgsVectorLayerJoinBuffer: ...
    def removeJoin(self, joinLayerId: str) -> bool: ...
    def addJoin(self, joinInfo: QgsVectorLayerJoinInfo) -> bool: ...
    def setCoordinateSystem(self) -> None: ...
    def setProviderEncoding(self, encoding: str) -> None: ...
    def temporalProperties(self) -> QgsMapLayerTemporalProperties: ...
    def dataProvider(self) -> QgsVectorDataProvider: ...
    def displayExpression(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str) -> None: ...
    def displayField(self) -> str: ...
    def dataComment(self) -> str: ...
    def capabilitiesString(self) -> str: ...
    def storageType(self) -> str: ...
    def clone(self) -> QgsVectorLayer: ...
    def __repr__(self) -> typing.Any: ...


class QgsAuxiliaryLayer(QgsVectorLayer):

    def __init__(self, pkField: str, filename: str, table: str, vlayer: QgsVectorLayer) -> None: ...

    @staticmethod
    def propertyDefinitionFromField(field: QgsField) -> QgsPropertyDefinition: ...
    @staticmethod
    def nameFromProperty(def_: QgsPropertyDefinition, joined: bool = ...) -> str: ...
    @overload
    @staticmethod
    def createAuxiliaryField(definition: QgsPropertyDefinition) -> QgsField: ...
    @overload
    @staticmethod
    def createAuxiliaryField(field: QgsField) -> QgsField: ...
    @overload
    @staticmethod
    def createProperty(property: QgsPalLayerSettings.Property, vlayer: QgsVectorLayer) -> int: ...
    @overload
    @staticmethod
    def createProperty(property: QgsDiagramLayerSettings.Property, vlayer: QgsVectorLayer) -> int: ...
    @overload
    @staticmethod
    def createProperty(property: QgsCallout.Property, vlayer: QgsVectorLayer) -> int: ...
    def propertyDefinitionFromIndex(self, index: int) -> QgsPropertyDefinition: ...
    def propertyFromIndex(self, index: int) -> int: ...
    def indexOfPropertyDefinition(self, definition: QgsPropertyDefinition) -> int: ...
    def isHiddenProperty(self, index: int) -> bool: ...
    def deleteAttribute(self, attr: int) -> bool: ...
    def save(self) -> bool: ...
    def auxiliaryFields(self) -> QgsFields: ...
    def addAuxiliaryField(self, definition: QgsPropertyDefinition) -> bool: ...
    def exists(self, definition: QgsPropertyDefinition) -> bool: ...
    def joinInfo(self) -> QgsVectorLayerJoinInfo: ...
    def clear(self) -> bool: ...
    def toSpatialLayer(self) -> QgsVectorLayer: ...
    def clone(self, layer: QgsVectorLayer) -> QgsAuxiliaryLayer: ...
    def __repr__(self) -> typing.Any: ...


class QgsAuxiliaryStorage(sip.wrapper):

    @overload
    def __init__(self, project: QgsProject, copy: bool = ...) -> None: ...
    @overload
    def __init__(self, filename: str = ..., copy: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAuxiliaryStorage) -> None: ...

    @staticmethod
    def exists(project: QgsProject) -> bool: ...
    @staticmethod
    def extension() -> str: ...
    @staticmethod
    def duplicateTable(uri: QgsDataSourceUri, newTable: str) -> bool: ...
    @staticmethod
    def deleteTable(uri: QgsDataSourceUri) -> bool: ...
    def createAuxiliaryLayer(self, field: QgsField, layer: QgsVectorLayer) -> QgsAuxiliaryLayer: ...
    def save(self) -> bool: ...
    @overload
    def saveAs(self, filename: str) -> bool: ...
    @overload
    def saveAs(self, project: QgsProject) -> bool: ...
    def errorString(self) -> str: ...
    def currentFileName(self) -> str: ...
    def fileName(self) -> str: ...
    def isValid(self) -> bool: ...


class QgsBearingUtils(sip.wrapper):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsBearingUtils) -> None: ...
    @staticmethod
    def bearingTrueNorth(crs: QgsCoordinateReferenceSystem, transformContext: QgsCoordinateTransformContext, point: QgsPointXY) -> float: ...


class QgsBookmark(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsBookmark) -> None: ...
    def __repr__(self) -> typing.Any: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @staticmethod
    def fromXml(element: QtXml.QDomElement, doc: QtXml.QDomDocument) -> QgsBookmark: ...
    def setExtent(self, extent: QgsReferencedRectangle) -> None: ...
    def extent(self) -> QgsReferencedRectangle: ...
    def setGroup(self, group: str) -> None: ...
    def group(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def setId(self, id: str) -> None: ...
    def id(self) -> str: ...


class QgsBookmarkManager(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...
    def bookmarkChanged(self, id: str) -> None: ...
    def bookmarkAboutToBeRemoved(self, id: str) -> None: ...
    def bookmarkRemoved(self, id: str) -> None: ...
    def bookmarkAdded(self, id: str) -> None: ...
    def bookmarkAboutToBeAdded(self, id: str) -> None: ...
    def importFromFile(self, path: str) -> bool: ...
    @staticmethod
    def exportToFile(path: str, managers: Iterable[QgsBookmarkManager], group: str = ...) -> bool: ...
    def moveBookmark(self, id: str, destination: QgsBookmarkManager) -> bool: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    def bookmarksByGroup(self, group: str) -> List[QgsBookmark]: ...
    def bookmarkById(self, id: str) -> QgsBookmark: ...
    def bookmarks(self) -> List[QgsBookmark]: ...
    def renameGroup(self, oldName: str, newName: str) -> None: ...
    def groups(self) -> List[str]: ...
    def clear(self) -> None: ...
    def updateBookmark(self, bookmark: QgsBookmark) -> bool: ...
    def removeBookmark(self, id: str) -> bool: ...
    def addBookmark(self, bookmark: QgsBookmark) -> Tuple[str, bool]: ...
    def initialize(self, filePath: str) -> None: ...
    @staticmethod
    def createProjectBasedManager(project: QgsProject) -> QgsBookmarkManager: ...


class QgsBookmarkManagerModel(QtCore.QAbstractTableModel):

    class Columns(int):
        ...
    ColumnName: QgsBookmarkManagerModel.Columns = ...
    ColumnGroup: QgsBookmarkManagerModel.Columns = ...
    ColumnXMin: QgsBookmarkManagerModel.Columns = ...
    ColumnYMin: QgsBookmarkManagerModel.Columns = ...
    ColumnXMax: QgsBookmarkManagerModel.Columns = ...
    ColumnYMax: QgsBookmarkManagerModel.Columns = ...
    ColumnCrs: QgsBookmarkManagerModel.Columns = ...
    ColumnStore: QgsBookmarkManagerModel.Columns = ...

    class CustomRoles(int):
        ...
    RoleExtent: QgsBookmarkManagerModel.CustomRoles = ...
    RoleName: QgsBookmarkManagerModel.CustomRoles = ...
    RoleId: QgsBookmarkManagerModel.CustomRoles = ...
    RoleGroup: QgsBookmarkManagerModel.CustomRoles = ...

    def __init__(self, manager: QgsBookmarkManager, projectManager: Optional[QgsBookmarkManager] = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QgsBookmarkManagerProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, manager: QgsBookmarkManager, projectManager: Optional[QgsBookmarkManager] = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...


class QgsAbstractFeatureIterator(sip.wrapper):

    class CompileStatus(int):
        ...
    NoCompilation: QgsAbstractFeatureIterator.CompileStatus = ...
    PartiallyCompiled: QgsAbstractFeatureIterator.CompileStatus = ...
    Compiled: QgsAbstractFeatureIterator.CompileStatus = ...

    @overload
    def __init__(self, request: QgsFeatureRequest) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractFeatureIterator) -> None: ...
    def prepareSimplification(self, simplifyMethod: QgsSimplifyMethod) -> bool: ...
    def deref(self) -> None: ...
    def ref(self) -> None: ...
    def filterRectToSourceCrs(self, transform: QgsCoordinateTransform) -> QgsRectangle: ...
    def geometryToDestinationCrs(self, feature: QgsFeature, transform: QgsCoordinateTransform) -> None: ...
    def nextFeatureFilterFids(self, f: QgsFeature) -> bool: ...
    def nextFeatureFilterExpression(self, f: QgsFeature) -> bool: ...
    def fetchFeature(self, f: QgsFeature) -> bool: ...
    def compileFailed(self) -> bool: ...
    def isValid(self) -> bool: ...
    def compileStatus(self) -> QgsAbstractFeatureIterator.CompileStatus: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...
    def nextFeature(self, f: QgsFeature) -> bool: ...


class QgsCachedFeatureIterator(QgsAbstractFeatureIterator):

    @overload
    def __init__(self, vlCache: QgsVectorLayerCache, featureRequest: QgsFeatureRequest) -> None: ...
    @overload
    def __init__(self, a0: QgsCachedFeatureIterator) -> None: ...
    def nextFeatureFilterFids(self, f: QgsFeature) -> bool: ...
    def fetchFeature(self, f: QgsFeature) -> bool: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...


class QgsCachedFeatureWriterIterator(QgsAbstractFeatureIterator):

    @overload
    def __init__(self, vlCache: QgsVectorLayerCache, featureRequest: QgsFeatureRequest) -> None: ...
    @overload
    def __init__(self, a0: QgsCachedFeatureWriterIterator) -> None: ...

    def fetchFeature(self, f: QgsFeature) -> bool: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...


class QgsAbstractCacheIndex(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractCacheIndex) -> None: ...
    def getCacheIterator(self, featureIterator: QgsFeatureIterator, featureRequest: QgsFeatureRequest) -> bool: ...
    def requestCompleted(self, featureRequest: QgsFeatureRequest, fids: typing.Any) -> None: ...
    def flush(self) -> None: ...
    def flushFeature(self, fid: int) -> None: ...


class QgsCacheIndexFeatureId(QgsAbstractCacheIndex):

    @overload
    def __init__(self, a0: QgsVectorLayerCache) -> None: ...
    @overload
    def __init__(self, a0: QgsCacheIndexFeatureId) -> None: ...

    def getCacheIterator(self, featureIterator: QgsFeatureIterator, featureRequest: QgsFeatureRequest) -> bool: ...
    def requestCompleted(self, featureRequest: QgsFeatureRequest, fids: typing.Any) -> None: ...
    def flush(self) -> None: ...
    def flushFeature(self, fid: int) -> None: ...


class QgsCadUtils(sip.wrapper):

    class AlignMapPointConstraint(sip.wrapper):

        locked: bool = ...
        relative: bool = ...
        value: float = ...

        @overload
        def __init__(self, locked: bool = ..., relative: bool = ..., value: float = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsCadUtils.AlignMapPointConstraint) -> None: ...

    class AlignMapPointContext(sip.wrapper):

        angleConstraint: QgsCadUtils.AlignMapPointConstraint = ...
        cadPointList: Iterable[QgsPointXY] = ...
        commonAngleConstraint: QgsCadUtils.AlignMapPointConstraint = ...
        distanceConstraint: QgsCadUtils.AlignMapPointConstraint = ...
        mapUnitsPerPixel: float = ...
        snappingUtils: QgsSnappingUtils = ...
        xConstraint: QgsCadUtils.AlignMapPointConstraint = ...
        yConstraint: QgsCadUtils.AlignMapPointConstraint = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsCadUtils.AlignMapPointContext) -> None: ...

    class AlignMapPointOutput(sip.wrapper):

        edgeMatch: QgsPointLocator.Match = ...
        finalMapPoint: QgsPointXY = ...
        snapMatch: QgsPointLocator.Match = ...
        softLockCommonAngle: float = ...
        valid: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsCadUtils.AlignMapPointOutput) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCadUtils) -> None: ...

    @staticmethod
    def alignMapPoint(originalMapPoint: QgsPointXY, ctx: QgsCadUtils.AlignMapPointContext) -> QgsCadUtils.AlignMapPointOutput: ...


class QgsClipper(sip.wrapper):

    class Boundary(int):
        ...
    XMax: QgsClipper.Boundary = ...
    XMin: QgsClipper.Boundary = ...
    YMax: QgsClipper.Boundary = ...
    YMin: QgsClipper.Boundary = ...

    MAX_X: float = ...
    MAX_Y: float = ...
    MIN_X: float = ...
    MIN_Y: float = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClipper) -> None: ...

    @overload
    @staticmethod
    def clippedLine(curve: QgsCurve, clipExtent: QgsRectangle) -> QtGui.QPolygonF: ...
    @overload
    @staticmethod
    def clippedLine(curve: QtGui.QPolygonF, clipExtent: QgsRectangle) -> QtGui.QPolygonF: ...
    @staticmethod
    def trimPolygon(pts: QtGui.QPolygonF, clipRect: QgsRectangle) -> None: ...
    @staticmethod
    def trimFeature(x: Iterable[float], y: Iterable[float], shapeOpen: bool) -> None: ...


class QgsColorRamp(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsColorRamp) -> None: ...
    @staticmethod
    def rampTypes() -> List[Tuple[str, str]]: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsColorRamp: ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def count(self) -> int: ...


class QgsGradientStop(sip.wrapper):

    color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...
    offset: float = ...

    @overload
    def __init__(self, offset: float, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @overload
    def __init__(self, a0: QgsGradientStop) -> None: ...


class QgsGradientColorRamp(QgsColorRamp):

    @overload
    def __init__(self, color1: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., color2: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., discrete: bool = ..., stops: Iterable[QgsGradientStop] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsGradientColorRamp) -> None: ...
    def addStopsToGradient(self, gradient: QtGui.QGradient, opacity: float = ...) -> None: ...
    def setInfo(self, info: Dict[str, str]) -> None: ...
    def info(self) -> Dict[str, str]: ...
    def stops(self) -> List[QgsGradientStop]: ...
    def setStops(self, stops: Iterable[QgsGradientStop]) -> None: ...
    def convertToDiscrete(self, discrete: bool) -> None: ...
    def setDiscrete(self, discrete: bool) -> None: ...
    def isDiscrete(self) -> bool: ...
    def setColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setColor1(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color2(self) -> QtGui.QColor: ...
    def color1(self) -> QtGui.QColor: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsGradientColorRamp: ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def count(self) -> int: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ...) -> QgsColorRamp: ...


class QgsLimitedRandomColorRamp(QgsColorRamp):

    @overload
    def __init__(self, count: int = ..., hueMin: int = ..., hueMax: int = ..., satMin: int = ..., satMax: int = ..., valMin: int = ..., valMax: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLimitedRandomColorRamp) -> None: ...
    def setValMax(self, val: int) -> None: ...
    def setValMin(self, val: int) -> None: ...
    def setSatMax(self, val: int) -> None: ...
    def setSatMin(self, val: int) -> None: ...
    def setHueMax(self, val: int) -> None: ...
    def setHueMin(self, val: int) -> None: ...
    def setCount(self, val: int) -> None: ...
    def valMax(self) -> int: ...
    def valMin(self) -> int: ...
    def satMax(self) -> int: ...
    def satMin(self) -> int: ...
    def hueMax(self) -> int: ...
    def hueMin(self) -> int: ...
    def updateColors(self) -> None: ...
    @staticmethod
    def randomColors(count: int, hueMax: int = ..., hueMin: int = ..., satMax: int = ..., satMin: int = ..., valMax: int = ..., valMin: int = ...) -> List[QtGui.QColor]: ...
    def count(self) -> int: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsLimitedRandomColorRamp: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ...) -> QgsColorRamp: ...


class QgsRandomColorRamp(QgsColorRamp):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRandomColorRamp) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsRandomColorRamp: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def setTotalColorCount(self, colorCount: int) -> None: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def count(self) -> int: ...


class QgsColorScheme(sip.wrapper):

    class SchemeFlag(int):
        ...
    ShowInColorDialog: QgsColorScheme.SchemeFlag = ...
    ShowInColorButtonMenu: QgsColorScheme.SchemeFlag = ...
    ShowInAllContexts: QgsColorScheme.SchemeFlag = ...

    class SchemeFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsColorScheme.SchemeFlags, QgsColorScheme.SchemeFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsColorScheme.SchemeFlags) -> None: ...
        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsColorScheme.SchemeFlags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsColorScheme) -> None: ...
    def clone(self) -> QgsColorScheme: ...
    def setColors(self, colors: Iterable[Tuple[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], str]], context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> bool: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> List[Tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlags: ...
    def schemeName(self) -> str: ...


class QgsPresetSchemeColorRamp(QgsColorRamp, QgsColorScheme):

    @overload
    def __init__(self, colors: Iterable[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]] = ...) -> None: ...
    @overload
    def __init__(self, colors: Iterable[Tuple[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], str]]) -> None: ...
    @overload
    def __init__(self, a0: QgsPresetSchemeColorRamp) -> None: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> List[Tuple[QtGui.QColor, str]]: ...
    def schemeName(self) -> str: ...
    def count(self) -> int: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsPresetSchemeColorRamp: ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    def colors(self) -> List[QtGui.QColor]: ...
    def setColors(self, colors: Iterable[Tuple[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], str]], a1: str = ..., a2: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> bool: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ...) -> QgsColorRamp: ...


class QgsColorBrewerColorRamp(QgsColorRamp):

    @overload
    def __init__(self, schemeName: str = ..., colors: int = ..., inverted: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsColorBrewerColorRamp) -> None: ...
    def loadPalette(self) -> None: ...
    @staticmethod
    def listSchemeVariants(schemeName: str) -> List[int]: ...
    @staticmethod
    def listSchemeNames() -> List[str]: ...
    def setColors(self, colors: int) -> None: ...
    def setSchemeName(self, schemeName: str) -> None: ...
    def colors(self) -> int: ...
    def schemeName(self) -> str: ...
    def count(self) -> int: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsColorBrewerColorRamp: ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def value(self, index: int) -> float: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ...) -> QgsColorRamp: ...


class QgsCptCityColorRamp(QgsGradientColorRamp):

    @overload
    def __init__(self, schemeName: str = ..., variantName: str = ..., inverted: bool = ..., doLoadFile: bool = ...) -> None: ...
    @overload
    def __init__(self, schemeName: str, variantList: Iterable[str], variantName: str = ..., inverted: bool = ..., doLoadFile: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsCptCityColorRamp) -> None: ...

    def copyingInfo(self) -> Dict[str, str]: ...
    def descFileName(self) -> str: ...
    def copyingFileName(self) -> str: ...
    def fileLoaded(self) -> bool: ...
    def loadFile(self) -> bool: ...
    def fileName(self) -> str: ...
    def hasMultiStops(self) -> bool: ...
    def loadPalette(self) -> None: ...
    def setName(self, schemeName: str, variantName: str = ..., variantList: Iterable[str] = ...) -> None: ...
    def setVariantList(self, variantList: Iterable[str]) -> None: ...
    def setVariantName(self, variantName: str) -> None: ...
    def setSchemeName(self, schemeName: str) -> None: ...
    def variantList(self) -> List[str]: ...
    def variantName(self) -> str: ...
    def schemeName(self) -> str: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def cloneGradientRamp(self) -> QgsGradientColorRamp: ...
    def copy(self, other: QgsCptCityColorRamp) -> None: ...
    def clone(self) -> QgsCptCityColorRamp: ...
    def invert(self) -> None: ...
    def type(self) -> str: ...
    @staticmethod
    def typeString() -> str: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ...) -> QgsColorRamp: ...


class QgsGplColorScheme(QgsColorScheme):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGplColorScheme) -> None: ...

    def gplFilePath(self) -> str: ...
    def setColors(self, colors: Iterable[Tuple[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], str]], context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> bool: ...
    def fetchColors(self, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> List[Tuple[QtGui.QColor, str]]: ...


class QgsUserColorScheme(QgsGplColorScheme):

    @overload
    def __init__(self, filename: str) -> None: ...
    @overload
    def __init__(self, a0: QgsUserColorScheme) -> None: ...
    def gplFilePath(self) -> str: ...
    def setShowSchemeInMenu(self, show: bool) -> None: ...
    def erase(self) -> bool: ...
    def setName(self, name: str) -> None: ...
    def flags(self) -> QgsColorScheme.SchemeFlags: ...
    def isEditable(self) -> bool: ...
    def clone(self) -> QgsUserColorScheme: ...
    def schemeName(self) -> str: ...


class QgsRecentColorScheme(QgsColorScheme):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRecentColorScheme) -> None: ...
    @staticmethod
    def lastUsedColor() -> QtGui.QColor: ...
    @staticmethod
    def addRecentColor(color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def clone(self) -> QgsRecentColorScheme: ...
    def fetchColors(self, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> List[Tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlags: ...
    def schemeName(self) -> str: ...


class QgsCustomColorScheme(QgsColorScheme):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCustomColorScheme) -> None: ...

    def clone(self) -> QgsCustomColorScheme: ...
    def setColors(self, colors: Iterable[Tuple[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], str]], context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> bool: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> List[Tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlags: ...
    def schemeName(self) -> str: ...


class QgsProjectColorScheme(QgsColorScheme):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjectColorScheme) -> None: ...

    def clone(self) -> QgsProjectColorScheme: ...
    def setColors(self, colors: Iterable[Tuple[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], str]], context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> bool: ...
    def isEditable(self) -> bool: ...
    def fetchColors(self, context: str = ..., baseColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> List[Tuple[QtGui.QColor, str]]: ...
    def flags(self) -> QgsColorScheme.SchemeFlags: ...
    def schemeName(self) -> str: ...


class QgsColorSchemeRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsColorSchemeRegistry) -> None: ...

    def fetchRandomStyleColor(self) -> QtGui.QColor: ...
    def randomStyleColorScheme(self) -> QgsColorScheme: ...
    def setRandomStyleColorScheme(self, scheme: QgsColorScheme) -> None: ...
    @overload
    def schemes(self) -> List[QgsColorScheme]: ...
    @overload
    def schemes(self, flag: QgsColorScheme.SchemeFlag) -> List[QgsColorScheme]: ...
    def removeColorScheme(self, scheme: QgsColorScheme) -> bool: ...
    def addColorScheme(self, scheme: QgsColorScheme) -> None: ...
    def addUserSchemes(self) -> None: ...
    def initStyleScheme(self) -> None: ...
    def addDefaultSchemes(self) -> None: ...
    def populateFromInstance(self) -> None: ...


class QgsConditionalLayerStyles(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def changed(self) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, node: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def fieldStyles(self, fieldName: str) -> List[QgsConditionalStyle]: ...
    def setFieldStyles(self, fieldName: str, styles: Iterable[QgsConditionalStyle]) -> None: ...
    def setRowStyles(self, styles: Iterable[QgsConditionalStyle]) -> None: ...
    def rowStyles(self) -> List[QgsConditionalStyle]: ...


class QgsConditionalStyle(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsConditionalStyle) -> None: ...
    @overload
    def __init__(self, rule: str) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, node: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def compressStyles(styles: Iterable[QgsConditionalStyle]) -> QgsConditionalStyle: ...
    @staticmethod
    def matchingConditionalStyle(styles: Iterable[QgsConditionalStyle], value: typing.Any, context: QgsExpressionContext) -> QgsConditionalStyle: ...
    @staticmethod
    def matchingConditionalStyles(styles: Iterable[QgsConditionalStyle], value: typing.Any, context: QgsExpressionContext) -> List[QgsConditionalStyle]: ...
    def isValid(self) -> bool: ...
    def rule(self) -> str: ...
    def font(self) -> QtGui.QFont: ...
    def validBackgroundColor(self) -> bool: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def validTextColor(self) -> bool: ...
    def textColor(self) -> QtGui.QColor: ...
    def symbol(self) -> QgsSymbol: ...
    def icon(self) -> QtGui.QPixmap: ...
    def name(self) -> str: ...
    def displayText(self) -> str: ...
    def setSymbol(self, value: QgsSymbol) -> None: ...
    def setFont(self, value: QtGui.QFont) -> None: ...
    def setTextColor(self, value: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setBackgroundColor(self, value: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setRule(self, value: str) -> None: ...
    def setName(self, value: str) -> None: ...
    def renderPreview(self, size: QtCore.QSize = ...) -> QtGui.QPixmap: ...
    def matches(self, value: typing.Any, context: QgsExpressionContext) -> bool: ...


class QgsConnectionRegistry(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def createConnection(self, name: str) -> QgsAbstractProviderConnection: ...


class QgsCoordinateFormatter(sip.wrapper):

    class FormatFlag(int):
        ...
    FlagDegreesUseStringSuffix: QgsCoordinateFormatter.FormatFlag = ...
    FlagDegreesPadMinutesSeconds: QgsCoordinateFormatter.FormatFlag = ...

    class Format(int):
        ...
    FormatPair: QgsCoordinateFormatter.Format = ...
    FormatDegreesMinutesSeconds: QgsCoordinateFormatter.Format = ...
    FormatDegreesMinutes: QgsCoordinateFormatter.Format = ...
    FormatDecimalDegrees: QgsCoordinateFormatter.Format = ...

    class FormatFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsCoordinateFormatter.FormatFlags, QgsCoordinateFormatter.FormatFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsCoordinateFormatter.FormatFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsCoordinateFormatter.FormatFlags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCoordinateFormatter) -> None: ...

    @staticmethod
    def asPair(x: float, y: float, precision: int = ...) -> str: ...
    @staticmethod
    def format(point: QgsPointXY, format: QgsCoordinateFormatter.Format, precision: int = ..., flags: Union[QgsCoordinateFormatter.FormatFlags, QgsCoordinateFormatter.FormatFlag] = ...) -> str: ...
    @staticmethod
    def formatY(y: float, format: QgsCoordinateFormatter.Format, precision: int = ..., flags: Union[QgsCoordinateFormatter.FormatFlags, QgsCoordinateFormatter.FormatFlag] = ...) -> str: ...
    @staticmethod
    def formatX(x: float, format: QgsCoordinateFormatter.Format, precision: int = ..., flags: Union[QgsCoordinateFormatter.FormatFlags, QgsCoordinateFormatter.FormatFlag] = ...) -> str: ...


class QgsCredentials(sip.wrapper):

    def __init__(self) -> None: ...

    def setInstance(self, instance: QgsCredentials) -> None: ...
    def requestMasterPassword(self, password: str, stored: bool = ...) -> Tuple[bool, str]: ...
    def request(self, realm: str, username: str, password: str, message: str = ...) -> Tuple[bool, str, str]: ...
    def mutex(self) -> QtCore.QMutex: ...
    def unlock(self) -> None: ...
    def lock(self) -> None: ...
    @staticmethod
    def instance() -> QgsCredentials: ...
    def getMasterPassword(self, password: str, stored: bool = ...) -> Tuple[bool, str]: ...
    def put(self, realm: str, username: str, password: str) -> None: ...
    def get(self, realm: str, username: str, password: str, message: str = ...) -> Tuple[bool, str, str]: ...


class QgsCredentialsNone(QtCore.QObject, QgsCredentials):

    def __init__(self) -> None: ...

    def requestMasterPassword(self, password: str, stored: bool = ...) -> Tuple[bool, str]: ...
    def request(self, realm: str, username: str, password: str, message: str = ...) -> Tuple[bool, str, str]: ...
    def destroyed(self) -> None: ...


class QgsCredentialsConsole(QtCore.QObject, QgsCredentials):

    def __init__(self) -> None: ...

    def requestMasterPassword(self, password: str, stored: bool = ...) -> Tuple[bool, str]: ...
    def request(self, realm: str, username: str, password: str, message: str = ...) -> Tuple[bool, str, str]: ...
    def destroyed(self) -> None: ...


class QgsDartMeasurement(sip.wrapper):

    class Type(int):
        ...
    Text: QgsDartMeasurement.Type = ...
    ImagePng: QgsDartMeasurement.Type = ...
    Integer: QgsDartMeasurement.Type = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, type: QgsDartMeasurement.Type, value: str) -> None: ...
    @overload
    def __init__(self, a0: QgsDartMeasurement) -> None: ...

    @staticmethod
    def typeToString(type: QgsDartMeasurement.Type) -> str: ...
    def send(self) -> None: ...
    def toString(self) -> str: ...


class QgsDatabaseSchemaModel(QtCore.QAbstractItemModel):

    class Role(int):
        ...
    RoleEmpty: QgsDatabaseSchemaModel.Role = ...

    @overload
    def __init__(self, provider: str, connection: str, parent: Optional[QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, connection: QgsAbstractDatabaseProviderConnection, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def refresh(self) -> None: ...
    def allowEmptySchema(self) -> bool: ...
    def setAllowEmptySchema(self, allowEmpty: bool) -> None: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...


class QgsDatabaseTableModel(QtCore.QAbstractItemModel):

    class Role(int):
        ...
    RoleTableName: QgsDatabaseTableModel.Role = ...
    RoleSchema: QgsDatabaseTableModel.Role = ...
    RoleTableFlags: QgsDatabaseTableModel.Role = ...
    RoleComment: QgsDatabaseTableModel.Role = ...
    RoleCustomInfo: QgsDatabaseTableModel.Role = ...
    RoleWkbType: QgsDatabaseTableModel.Role = ...
    RoleCrs: QgsDatabaseTableModel.Role = ...
    RoleEmpty: QgsDatabaseTableModel.Role = ...

    @overload
    def __init__(self, provider: str, connection: str, schema: str = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, connection: QgsAbstractDatabaseProviderConnection, schema: str = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def refresh(self) -> None: ...
    def allowEmptyTable(self) -> bool: ...
    def setAllowEmptyTable(self, allowEmpty: bool) -> None: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...


class QgsDataDefinedSizeLegend(sip.wrapper):

    class VerticalAlignment(int):
        ...
    AlignCenter: QgsDataDefinedSizeLegend.VerticalAlignment = ...
    AlignBottom: QgsDataDefinedSizeLegend.VerticalAlignment = ...

    class LegendType(int):
        ...
    LegendSeparated: QgsDataDefinedSizeLegend.LegendType = ...
    LegendCollapsed: QgsDataDefinedSizeLegend.LegendType = ...

    class SizeClass(sip.wrapper):

        label: str = ...
        size: float = ...

        @overload
        def __init__(self, size: float, label: str) -> None: ...
        @overload
        def __init__(self, a0: QgsDataDefinedSizeLegend.SizeClass) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsDataDefinedSizeLegend) -> None: ...

    def writeXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @staticmethod
    def readXml(elem: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsDataDefinedSizeLegend: ...
    def collapsedLegendImage(self, context: QgsRenderContext, backgroundColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., paddingMM: float = ...) -> QtGui.QImage: ...
    def drawCollapsedLegend(self, context: QgsRenderContext) -> Tuple[QtCore.QSizeF, float]: ...
    def legendSymbolList(self) -> List[QgsLegendSymbolItem]: ...
    def updateFromSymbolAndProperty(self, symbol: QgsMarkerSymbol, ddSize: QgsProperty) -> None: ...
    def textAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setTextAlignment(self, flag: QtCore.Qt.AlignmentFlag) -> None: ...
    def textColor(self) -> QtGui.QColor: ...
    def setTextColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def verticalAlignment(self) -> QgsDataDefinedSizeLegend.VerticalAlignment: ...
    def setVerticalAlignment(self, vAlign: QgsDataDefinedSizeLegend.VerticalAlignment) -> None: ...
    def title(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def classes(self) -> List[QgsDataDefinedSizeLegend.SizeClass]: ...
    def setClasses(self, classes: Iterable[QgsDataDefinedSizeLegend.SizeClass]) -> None: ...
    def sizeScaleTransformer(self) -> QgsSizeScaleTransformer: ...
    def setSizeScaleTransformer(self, transformer: QgsSizeScaleTransformer) -> None: ...
    def lineSymbol(self) -> QgsLineSymbol: ...
    def setLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def symbol(self) -> QgsMarkerSymbol: ...
    def setSymbol(self, symbol: QgsMarkerSymbol) -> None: ...
    def legendType(self) -> QgsDataDefinedSizeLegend.LegendType: ...
    def setLegendType(self, type: QgsDataDefinedSizeLegend.LegendType) -> None: ...


class QgsDataProviderTemporalCapabilities(sip.wrapper):

    @overload
    def __init__(self, available: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsDataProviderTemporalCapabilities) -> None: ...

    def setHasTemporalCapabilities(self, available: bool) -> None: ...
    def hasTemporalCapabilities(self) -> bool: ...


class QgsDataSourceUri(sip.wrapper):

    class SslMode(int):
        ...
    SslPrefer: QgsDataSourceUri.SslMode = ...
    SslDisable: QgsDataSourceUri.SslMode = ...
    SslAllow: QgsDataSourceUri.SslMode = ...
    SslRequire: QgsDataSourceUri.SslMode = ...
    SslVerifyCa: QgsDataSourceUri.SslMode = ...
    SslVerifyFull: QgsDataSourceUri.SslMode = ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, uri: str) -> None: ...
    @overload
    def __init__(self, a0: QgsDataSourceUri) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def setGeometryColumn(self, geometryColumn: str) -> None: ...
    def setTable(self, table: str) -> None: ...
    @staticmethod
    def encodeSslMode(sslMode: QgsDataSourceUri.SslMode) -> str: ...
    @staticmethod
    def decodeSslMode(sslMode: str) -> QgsDataSourceUri.SslMode: ...
    def setSrid(self, srid: str) -> None: ...
    def srid(self) -> str: ...
    def setWkbType(self, type: QgsWkbTypes.Type) -> None: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def setKeyColumn(self, column: str) -> None: ...
    def keyColumn(self) -> str: ...
    def service(self) -> str: ...
    def sslMode(self) -> QgsDataSourceUri.SslMode: ...
    def password(self) -> str: ...
    def setDriver(self, driver: str) -> None: ...
    def driver(self) -> str: ...
    def port(self) -> str: ...
    def database(self) -> str: ...
    def host(self) -> str: ...
    def setSql(self, sql: str) -> None: ...
    def setSchema(self, schema: str) -> None: ...
    def clearSchema(self) -> None: ...
    def selectAtIdDisabled(self) -> bool: ...
    def disableSelectAtId(self, flag: bool) -> None: ...
    def useEstimatedMetadata(self) -> bool: ...
    def setUseEstimatedMetadata(self, flag: bool) -> None: ...
    def geometryColumn(self) -> str: ...
    def sql(self) -> str: ...
    def table(self) -> str: ...
    def schema(self) -> str: ...
    def username(self) -> str: ...
    def authConfigId(self) -> str: ...
    @staticmethod
    def removePassword(aUri: str) -> str: ...
    def setPassword(self, password: str) -> None: ...
    def setUsername(self, username: str) -> None: ...
    def setAuthConfigId(self, authcfg: str) -> None: ...
    def setDataSource(self, aSchema: str, aTable: str, aGeometryColumn: str, aSql: str = ..., aKeyColumn: str = ...) -> None: ...
    def setDatabase(self, database: str) -> None: ...
    @overload
    def setConnection(self, aHost: str, aPort: str, aDatabase: str, aUsername: str, aPassword: str, sslmode: QgsDataSourceUri.SslMode = ..., authConfigId: str = ...) -> None: ...
    @overload
    def setConnection(self, aService: str, aDatabase: str, aUsername: str, aPassword: str, sslmode: QgsDataSourceUri.SslMode = ..., authConfigId: str = ...) -> None: ...
    def hasParam(self, key: str) -> bool: ...
    def params(self, key: str) -> List[str]: ...
    def param(self, key: str) -> str: ...
    def removeParam(self, key: str) -> int: ...
    def setParamList(self, key: str, value: Iterable[str]) -> None: ...
    def setParam(self, key: str, value: str) -> None: ...
    def quotedTablename(self) -> str: ...
    def setEncodedUri(self, uri: str) -> None: ...
    def encodedUri(self) -> QtCore.QByteArray: ...
    def uri(self, expandAuthConfig: bool = ...) -> str: ...
    def connectionInfo(self, expandAuthConfig: bool = ...) -> str: ...


class QgsDateTimeStatisticalSummary(sip.wrapper):

    class Statistic(int):
        ...
    Count: QgsDateTimeStatisticalSummary.Statistic = ...
    CountDistinct: QgsDateTimeStatisticalSummary.Statistic = ...
    CountMissing: QgsDateTimeStatisticalSummary.Statistic = ...
    Min: QgsDateTimeStatisticalSummary.Statistic = ...
    Max: QgsDateTimeStatisticalSummary.Statistic = ...
    Range: QgsDateTimeStatisticalSummary.Statistic = ...
    All: QgsDateTimeStatisticalSummary.Statistic = ...

    class Statistics(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsDateTimeStatisticalSummary.Statistics, QgsDateTimeStatisticalSummary.Statistic]) -> None: ...
        @overload
        def __init__(self, a0: QgsDateTimeStatisticalSummary.Statistics) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsDateTimeStatisticalSummary.Statistics: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, stats: Union[QgsDateTimeStatisticalSummary.Statistics, QgsDateTimeStatisticalSummary.Statistic] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsDateTimeStatisticalSummary) -> None: ...

    @staticmethod
    def displayName(statistic: QgsDateTimeStatisticalSummary.Statistic) -> str: ...
    def range(self) -> QgsInterval: ...
    def max(self) -> QtCore.QDateTime: ...
    def min(self) -> QtCore.QDateTime: ...
    def countMissing(self) -> int: ...
    def distinctValues(self) -> Set[QtCore.QDateTime]: ...
    def countDistinct(self) -> int: ...
    def count(self) -> int: ...
    def statistic(self, stat: QgsDateTimeStatisticalSummary.Statistic) -> typing.Any: ...
    def finalize(self) -> None: ...
    def addValue(self, value: typing.Any) -> None: ...
    def calculate(self, values: Iterable[typing.Any]) -> None: ...
    def reset(self) -> None: ...
    def setStatistics(self, stats: Union[QgsDateTimeStatisticalSummary.Statistics, QgsDateTimeStatisticalSummary.Statistic]) -> None: ...
    def statistics(self) -> QgsDateTimeStatisticalSummary.Statistics: ...


class QgsDatabaseFilterProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def filterAcceptsRow(self, row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def _setFilterRegExp(self, pattern: str) -> None: ...
    def _setFilterWildcard(self, pattern: str) -> None: ...


class QgsDefaultValue(sip.wrapper):

    @overload
    def __init__(self, expression: str = ..., applyOnUpdate: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsDefaultValue) -> None: ...

    def isValid(self) -> bool: ...
    def setApplyOnUpdate(self, applyOnUpdate: bool) -> None: ...
    def applyOnUpdate(self) -> bool: ...
    def setExpression(self, expression: str) -> None: ...
    def expression(self) -> str: ...


class QgsDiagramLayerSettings(sip.wrapper):

    class Property(int):
        ...
    BackgroundColor: QgsDiagramLayerSettings.Property = ...
    StrokeColor: QgsDiagramLayerSettings.Property = ...
    StrokeWidth: QgsDiagramLayerSettings.Property = ...
    PositionX: QgsDiagramLayerSettings.Property = ...
    PositionY: QgsDiagramLayerSettings.Property = ...
    Distance: QgsDiagramLayerSettings.Property = ...
    Priority: QgsDiagramLayerSettings.Property = ...
    ZIndex: QgsDiagramLayerSettings.Property = ...
    IsObstacle: QgsDiagramLayerSettings.Property = ...
    Show: QgsDiagramLayerSettings.Property = ...
    AlwaysShow: QgsDiagramLayerSettings.Property = ...
    StartAngle: QgsDiagramLayerSettings.Property = ...

    class LinePlacementFlag(int):
        ...
    OnLine: QgsDiagramLayerSettings.LinePlacementFlag = ...
    AboveLine: QgsDiagramLayerSettings.LinePlacementFlag = ...
    BelowLine: QgsDiagramLayerSettings.LinePlacementFlag = ...
    MapOrientation: QgsDiagramLayerSettings.LinePlacementFlag = ...

    class Placement(int):
        ...
    AroundPoint: QgsDiagramLayerSettings.Placement = ...
    OverPoint: QgsDiagramLayerSettings.Placement = ...
    Line: QgsDiagramLayerSettings.Placement = ...
    Curved: QgsDiagramLayerSettings.Placement = ...
    Horizontal: QgsDiagramLayerSettings.Placement = ...
    Free: QgsDiagramLayerSettings.Placement = ...

    class LinePlacementFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsDiagramLayerSettings.LinePlacementFlags, QgsDiagramLayerSettings.LinePlacementFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsDiagramLayerSettings.LinePlacementFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsDiagramLayerSettings.LinePlacementFlags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rh: QgsDiagramLayerSettings) -> None: ...

    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def referencedFields(self, context: QgsExpressionContext = ...) -> Set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def setShowAllDiagrams(self, showAllDiagrams: bool) -> None: ...
    def showAllDiagrams(self) -> bool: ...
    def setCoordinateTransform(self, transform: QgsCoordinateTransform) -> None: ...
    def coordinateTransform(self) -> QgsCoordinateTransform: ...
    def setRenderer(self, diagramRenderer: QgsDiagramRenderer) -> None: ...
    def renderer(self) -> QgsDiagramRenderer: ...
    def setDistance(self, distance: float) -> None: ...
    def distance(self) -> float: ...
    def setIsObstacle(self, isObstacle: bool) -> None: ...
    def isObstacle(self) -> bool: ...
    def setZIndex(self, index: float) -> None: ...
    def zIndex(self) -> float: ...
    def setPriority(self, value: int) -> None: ...
    def priority(self) -> int: ...
    def setLinePlacementFlags(self, flags: Union[QgsDiagramLayerSettings.LinePlacementFlags, QgsDiagramLayerSettings.LinePlacementFlag]) -> None: ...
    def linePlacementFlags(self) -> QgsDiagramLayerSettings.LinePlacementFlags: ...
    def setPlacement(self, value: QgsDiagramLayerSettings.Placement) -> None: ...
    def placement(self) -> QgsDiagramLayerSettings.Placement: ...
    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...


class QgsDiagramSettings(sip.wrapper):

    class Direction(int):
        ...
    Clockwise: QgsDiagramSettings.Direction = ...
    Counterclockwise: QgsDiagramSettings.Direction = ...

    class DiagramOrientation(int):
        ...
    Up: QgsDiagramSettings.DiagramOrientation = ...
    Down: QgsDiagramSettings.DiagramOrientation = ...
    Left: QgsDiagramSettings.DiagramOrientation = ...
    Right: QgsDiagramSettings.DiagramOrientation = ...

    class LabelPlacementMethod(int):
        ...
    Height: QgsDiagramSettings.LabelPlacementMethod = ...
    XHeight: QgsDiagramSettings.LabelPlacementMethod = ...

    backgroundColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...
    barWidth: float = ...
    categoryAttributes: Iterable[str] = ...
    categoryColors: Iterable[Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]] = ...
    categoryLabels: Iterable[str] = ...
    diagramOrientation: QgsDiagramSettings.DiagramOrientation = ...
    enabled: bool = ...
    font: QtGui.QFont = ...
    labelPlacementMethod: QgsDiagramSettings.LabelPlacementMethod = ...
    lineSizeScale: QgsMapUnitScale = ...
    lineSizeUnit: QgsUnitTypes.RenderUnit = ...
    maximumScale: float = ...
    minimumScale: float = ...
    minimumSize: float = ...
    opacity: float = ...
    penColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...
    penWidth: float = ...
    rotationOffset: float = ...
    scaleBasedVisibility: bool = ...
    scaleByArea: bool = ...
    size: QtCore.QSizeF = ...
    sizeScale: QgsMapUnitScale = ...
    sizeType: QgsUnitTypes.RenderUnit = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsDiagramSettings) -> None: ...

    def setPaintEffect(self, effect: QgsPaintEffect) -> None: ...
    def paintEffect(self) -> QgsPaintEffect: ...
    def setShowAxis(self, showAxis: bool) -> None: ...
    def showAxis(self) -> bool: ...
    def setAxisLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def axisLineSymbol(self) -> QgsLineSymbol: ...
    def legendItems(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def writeXml(self, rendererElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ...) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext = ...) -> None: ...
    def setDirection(self, direction: QgsDiagramSettings.Direction) -> None: ...
    def direction(self) -> QgsDiagramSettings.Direction: ...
    def spacingMapUnitScale(self) -> QgsMapUnitScale: ...
    def setSpacingMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def spacingUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setSpacingUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setSpacing(self, spacing: float) -> None: ...
    def spacing(self) -> float: ...


class QgsDiagramInterpolationSettings(sip.wrapper):

    classificationAttributeExpression: str = ...
    classificationAttributeIsExpression: bool = ...
    classificationField: str = ...
    lowerSize: QtCore.QSizeF = ...
    lowerValue: float = ...
    upperSize: QtCore.QSizeF = ...
    upperValue: float = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDiagramInterpolationSettings) -> None: ...


class QgsDiagramRenderer(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsDiagramRenderer) -> None: ...

    def _writeXml(self, rendererElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def _readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @staticmethod
    def dpiPaintDevice(a0: QtGui.QPainter) -> int: ...
    def convertSizeToMapUnits(self, size: QtCore.QSizeF, context: QgsRenderContext) -> None: ...
    def diagramSize(self, features: QgsFeature, c: QgsRenderContext) -> QtCore.QSizeF: ...
    def setAttributeLegend(self, enabled: bool) -> None: ...
    def attributeLegend(self) -> bool: ...
    def legendItems(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    def diagramSettings(self) -> List[QgsDiagramSettings]: ...
    @overload
    def diagramSettings(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings) -> bool: ...
    def diagram(self) -> QgsDiagram: ...
    def setDiagram(self, d: QgsDiagram) -> None: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, pos: Union[QtCore.QPointF, QtCore.QPoint, float], properties: QgsPropertyCollection = ...) -> None: ...
    def referencedFields(self, context: QgsExpressionContext = ...) -> Set[str]: ...
    def diagramAttributes(self) -> List[str]: ...
    def rendererName(self) -> str: ...
    def sizeMapUnits(self, feature: QgsFeature, c: QgsRenderContext) -> QtCore.QSizeF: ...
    def clone(self) -> QgsDiagramRenderer: ...


class QgsSingleCategoryDiagramRenderer(QgsDiagramRenderer):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSingleCategoryDiagramRenderer) -> None: ...

    def diagramSize(self, a0: QgsFeature, c: QgsRenderContext) -> QtCore.QSizeF: ...
    def legendItems(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    def diagramSettings(self) -> List[QgsDiagramSettings]: ...
    @overload
    def diagramSettings(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings) -> bool: ...
    def setDiagramSettings(self, s: QgsDiagramSettings) -> None: ...
    def diagramAttributes(self) -> List[str]: ...
    def rendererName(self) -> str: ...
    def clone(self) -> QgsSingleCategoryDiagramRenderer: ...


class QgsLinearlyInterpolatedDiagramRenderer(QgsDiagramRenderer):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsLinearlyInterpolatedDiagramRenderer) -> None: ...

    def diagramSize(self, a0: QgsFeature, c: QgsRenderContext) -> QtCore.QSizeF: ...
    def dataDefinedSizeLegend(self) -> QgsDataDefinedSizeLegend: ...
    def setDataDefinedSizeLegend(self, settings: QgsDataDefinedSizeLegend) -> None: ...
    def legendItems(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def writeXml(self, layerElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def setClassificationAttributeIsExpression(self, isExpression: bool) -> None: ...
    def classificationAttributeIsExpression(self) -> bool: ...
    def setClassificationAttributeExpression(self, expression: str) -> None: ...
    def classificationAttributeExpression(self) -> str: ...
    def setClassificationField(self, field: str) -> None: ...
    def classificationField(self) -> str: ...
    def upperSize(self) -> QtCore.QSizeF: ...
    def setUpperSize(self, s: QtCore.QSizeF) -> None: ...
    def lowerSize(self) -> QtCore.QSizeF: ...
    def setLowerSize(self, s: QtCore.QSizeF) -> None: ...
    def upperValue(self) -> float: ...
    def setUpperValue(self, val: float) -> None: ...
    def lowerValue(self) -> float: ...
    def setLowerValue(self, val: float) -> None: ...
    def rendererName(self) -> str: ...
    def referencedFields(self, context: QgsExpressionContext = ...) -> Set[str]: ...
    def diagramAttributes(self) -> List[str]: ...
    def setDiagramSettings(self, s: QgsDiagramSettings) -> None: ...
    @overload
    def diagramSettings(self) -> List[QgsDiagramSettings]: ...
    @overload
    def diagramSettings(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings) -> bool: ...
    def clone(self) -> QgsLinearlyInterpolatedDiagramRenderer: ...


class QgsDistanceArea(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsDistanceArea) -> None: ...

    def splitGeometryAtAntimeridian(self, geometry: QgsGeometry) -> QgsGeometry: ...
    def latitudeGeodesicCrossesAntimeridian(self, p1: QgsPointXY, p2: QgsPointXY) -> Tuple[float, float]: ...
    def geodesicLine(self, p1: QgsPointXY, p2: QgsPointXY, interval: float, breakLine: bool = ...) -> typing.Any: ...
    def computeSpheroidProject(self, p1: QgsPointXY, distance: float = ..., azimuth: float = ...) -> QgsPointXY: ...
    def convertAreaMeasurement(self, area: float, toUnits: QgsUnitTypes.AreaUnit) -> float: ...
    def convertLengthMeasurement(self, length: float, toUnits: QgsUnitTypes.DistanceUnit) -> float: ...
    @staticmethod
    def formatArea(area: float, decimals: int, unit: QgsUnitTypes.AreaUnit, keepBaseUnit: bool = ...) -> str: ...
    @staticmethod
    def formatDistance(distance: float, decimals: int, unit: QgsUnitTypes.DistanceUnit, keepBaseUnit: bool = ...) -> str: ...
    def bearing(self, p1: QgsPointXY, p2: QgsPointXY) -> float: ...
    def measurePolygon(self, points: Iterable[QgsPointXY]) -> float: ...
    def areaUnits(self) -> QgsUnitTypes.AreaUnit: ...
    def lengthUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def measureLineProjected(self, p1: QgsPointXY, distance: float = ..., azimuth: float = ...) -> Tuple[float, QgsPointXY]: ...
    @overload
    def measureLine(self, points: Iterable[QgsPointXY]) -> float: ...
    @overload
    def measureLine(self, p1: QgsPointXY, p2: QgsPointXY) -> float: ...
    def measurePerimeter(self, geometry: QgsGeometry) -> float: ...
    def measureLength(self, geometry: QgsGeometry) -> float: ...
    def measureArea(self, geometry: QgsGeometry) -> float: ...
    def ellipsoidInverseFlattening(self) -> float: ...
    def ellipsoidSemiMinor(self) -> float: ...
    def ellipsoidSemiMajor(self) -> float: ...
    def ellipsoid(self) -> str: ...
    @overload
    def setEllipsoid(self, ellipsoid: str) -> bool: ...
    @overload
    def setEllipsoid(self, semiMajor: float, semiMinor: float) -> bool: ...
    def ellipsoidCrs(self) -> QgsCoordinateReferenceSystem: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setSourceCrs(self, crs: QgsCoordinateReferenceSystem, context: QgsCoordinateTransformContext) -> None: ...
    def willUseEllipsoid(self) -> bool: ...


class QgsEditorWidgetSetup(sip.wrapper):

    @overload
    def __init__(self, type: str, config: Dict[str, typing.Any]) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsEditorWidgetSetup) -> None: ...

    def isNull(self) -> bool: ...
    def config(self) -> Dict[str, typing.Any]: ...
    def type(self) -> str: ...


class QgsElevationUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsElevationUtils) -> None: ...

    @staticmethod
    def calculateZRangeForProject(project: QgsProject) -> QgsDoubleRange: ...


class QgsErrorMessage(sip.wrapper):

    class Format(int):
        ...
    Text: QgsErrorMessage.Format = ...
    Html: QgsErrorMessage.Format = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, message: str, tag: str = ..., file: str = ..., function: str = ..., line: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsErrorMessage) -> None: ...

    def line(self) -> int: ...
    def function(self) -> str: ...
    def file(self) -> str: ...
    def tag(self) -> str: ...
    def message(self) -> str: ...


class QgsError(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, message: str, tag: str) -> None: ...
    @overload
    def __init__(self, a0: QgsError) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def messageList(self) -> List[QgsErrorMessage]: ...
    def clear(self) -> None: ...
    def summary(self) -> str: ...
    def message(self, format: QgsErrorMessage.Format = ...) -> str: ...
    def isEmpty(self) -> bool: ...
    @overload
    def append(self, message: str, tag: str) -> None: ...
    @overload
    def append(self, message: QgsErrorMessage) -> None: ...


class QgsExpressionFunction(sip.wrapper):

    class Parameter(sip.wrapper):

        @overload
        def __init__(self, name: str, optional: bool = ..., defaultValue: typing.Any = ..., isSubExpression: bool = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionFunction.Parameter) -> None: ...

        def isSubExpression(self) -> bool: ...
        def defaultValue(self) -> typing.Any: ...
        def optional(self) -> bool: ...
        def name(self) -> str: ...

    @overload
    def __init__(self, fnname: str, params: int, group: str, helpText: str = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @overload
    def __init__(self, fnname: str, params: int, groups: Iterable[str], helpText: str = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @overload
    def __init__(self, fnname: str, params: Iterable[QgsExpressionFunction.Parameter], group: str, helpText: str = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @overload
    def __init__(self, fnname: str, params: Iterable[QgsExpressionFunction.Parameter], groups: Iterable[str], helpText: str = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionFunction) -> None: ...

    @staticmethod
    def allParamsStatic(node: QgsExpressionNodeFunction, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def handlesNull(self) -> bool: ...
    def run(self, args: QgsExpressionNode.NodeList, context: QgsExpressionContext, parent: QgsExpression, node: QgsExpressionNodeFunction) -> typing.Any: ...
    def func(self, values: Iterable[typing.Any], context: QgsExpressionContext, parent: QgsExpression, node: QgsExpressionNodeFunction) -> typing.Any: ...
    def helpText(self) -> str: ...
    def groups(self) -> List[str]: ...
    def group(self) -> str: ...
    def isDeprecated(self) -> bool: ...
    def isContextual(self) -> bool: ...
    def referencedColumns(self, node: QgsExpressionNodeFunction) -> Set[str]: ...
    def prepare(self, node: QgsExpressionNodeFunction, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def isStatic(self, node: QgsExpressionNodeFunction, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def lazyEval(self) -> bool: ...
    def aliases(self) -> List[str]: ...
    def usesGeometry(self, node: QgsExpressionNodeFunction) -> bool: ...
    def parameters(self) -> List[QgsExpressionFunction.Parameter]: ...
    def minParams(self) -> int: ...
    def params(self) -> int: ...
    def name(self) -> str: ...


class QgsScopedExpressionFunction(QgsExpressionFunction):

    @overload
    def __init__(self, fnname: str, params: int, group: str, helpText: str = ..., usesGeometry: bool = ..., referencedColumns: Iterable[str] = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @overload
    def __init__(self, fnname: str, params: Iterable[QgsExpressionFunction.Parameter], group: str, helpText: str = ..., usesGeometry: bool = ..., referencedColumns: Iterable[str] = ..., lazyEval: bool = ..., handlesNull: bool = ..., isContextual: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsScopedExpressionFunction) -> None: ...

    def isStatic(self, node: QgsExpressionNodeFunction, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def referencedColumns(self, node: QgsExpressionNodeFunction) -> Set[str]: ...
    def usesGeometry(self, node: QgsExpressionNodeFunction) -> bool: ...
    def clone(self) -> QgsScopedExpressionFunction: ...
    def func(self, values: Iterable[typing.Any], context: QgsExpressionContext, parent: QgsExpression, node: QgsExpressionNodeFunction) -> typing.Any: ...


class QgsExpressionContextScope(sip.wrapper):

    class StaticVariable(sip.wrapper):

        description: str = ...
        isStatic: bool = ...
        name: str = ...
        readOnly: bool = ...
        value: typing.Any = ...

        @overload
        def __init__(self, name: str = ..., value: typing.Any = ..., readOnly: bool = ..., isStatic: bool = ..., description: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionContextScope.StaticVariable) -> None: ...

    @overload
    def __init__(self, name: str = ...) -> None: ...
    @overload
    def __init__(self, other: QgsExpressionContextScope) -> None: ...

    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def removeFeature(self) -> None: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def feature(self) -> QgsFeature: ...
    def hasFeature(self) -> bool: ...
    def addFunction(self, name: str, function: QgsScopedExpressionFunction) -> None: ...
    def functionNames(self) -> List[str]: ...
    def function(self, name: str) -> QgsExpressionFunction: ...
    def hasFunction(self, name: str) -> bool: ...
    def variableCount(self) -> int: ...
    def description(self, name: str) -> str: ...
    def isStatic(self, name: str) -> bool: ...
    def isReadOnly(self, name: str) -> bool: ...
    def filteredVariableNames(self) -> List[str]: ...
    def variableNames(self) -> List[str]: ...
    def variable(self, name: str) -> typing.Any: ...
    def hasVariable(self, name: str) -> bool: ...
    def removeVariable(self, name: str) -> bool: ...
    def addVariable(self, variable: QgsExpressionContextScope.StaticVariable) -> None: ...
    def setVariable(self, name: str, value: typing.Any, isStatic: bool = ...) -> None: ...
    def name(self) -> str: ...


class QgsExpressionContext(sip.wrapper):

    EXPR_CLUSTER_COLOR: str = ...
    EXPR_CLUSTER_SIZE: str = ...
    EXPR_FIELDS: str = ...
    EXPR_GEOMETRY_PART_COUNT: str = ...
    EXPR_GEOMETRY_PART_NUM: str = ...
    EXPR_GEOMETRY_POINT_COUNT: str = ...
    EXPR_GEOMETRY_POINT_NUM: str = ...
    EXPR_GEOMETRY_RING_NUM: str = ...
    EXPR_ORIGINAL_VALUE: str = ...
    EXPR_SYMBOL_ANGLE: str = ...
    EXPR_SYMBOL_COLOR: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, scopes: Iterable[QgsExpressionContextScope]) -> None: ...
    @overload
    def __init__(self, other: QgsExpressionContext) -> None: ...

    def clearCachedValues(self) -> None: ...
    def cachedValue(self, key: str) -> typing.Any: ...
    def hasCachedValue(self, key: str) -> bool: ...
    def setCachedValue(self, key: str, value: typing.Any) -> None: ...
    def setOriginalValueVariable(self, value: typing.Any) -> None: ...
    def fields(self) -> QgsFields: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def feature(self) -> QgsFeature: ...
    def hasFeature(self) -> bool: ...
    def setFeature(self, feature: QgsFeature) -> None: ...
    def popScope(self) -> QgsExpressionContextScope: ...
    def appendScopes(self, scopes: Iterable[QgsExpressionContextScope]) -> None: ...
    def appendScope(self, scope: QgsExpressionContextScope) -> None: ...
    def scopeCount(self) -> int: ...
    def function(self, name: str) -> QgsExpressionFunction: ...
    def functionNames(self) -> List[str]: ...
    def hasFunction(self, name: str) -> bool: ...
    def description(self, name: str) -> str: ...
    def isReadOnly(self, name: str) -> bool: ...
    def filteredVariableNames(self) -> List[str]: ...
    def variableNames(self) -> List[str]: ...
    @overload
    def indexOfScope(self, scope: QgsExpressionContextScope) -> int: ...
    @overload
    def indexOfScope(self, scopeName: str) -> int: ...
    def scopes(self) -> List[QgsExpressionContextScope]: ...
    def lastScope(self) -> QgsExpressionContextScope: ...
    def scope(self, index: int) -> QgsExpressionContextScope: ...
    def activeScopeForVariable(self, name: str) -> QgsExpressionContextScope: ...
    def setHighlightedFunctions(self, names: Iterable[str]) -> None: ...
    def isHighlightedFunction(self, name: str) -> bool: ...
    def setHighlightedVariables(self, variableNames: Iterable[str]) -> None: ...
    def highlightedVariables(self) -> List[str]: ...
    def isHighlightedVariable(self, name: str) -> bool: ...
    def variablesToMap(self) -> Dict[str, typing.Any]: ...
    def variable(self, name: str) -> typing.Any: ...
    def hasVariable(self, name: str) -> bool: ...


class QgsExpressionFieldBuffer(sip.wrapper):

    class ExpressionField(sip.wrapper):

        cachedExpression: QgsExpression = ...
        field: QgsField = ...

        @overload
        def __init__(self, exp: str, fld: QgsField) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionFieldBuffer.ExpressionField) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionFieldBuffer) -> None: ...

    def expressions(self) -> List[QgsExpressionFieldBuffer.ExpressionField]: ...
    def updateFields(self, flds: QgsFields) -> None: ...
    def readXml(self, layer_node: QtXml.QDomNode) -> None: ...
    def writeXml(self, layer_node: QtXml.QDomNode, document: QtXml.QDomDocument) -> None: ...
    def updateExpression(self, index: int, exp: str) -> None: ...
    def renameExpression(self, index: int, name: str) -> None: ...
    def removeExpression(self, index: int) -> None: ...
    def addExpression(self, exp: str, fld: QgsField) -> None: ...


class QgsFeature(sip.wrapper):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, id: int = ...) -> None: ...
    @overload
    def __init__(self, fields: QgsFields, id: int = ...) -> None: ...
    @overload
    def __init__(self, rhs: QgsFeature) -> None: ...

    def approximateMemoryUsage(self) -> int: ...
    def fieldNameIndex(self, fieldName: str) -> int: ...
    def setEmbeddedSymbol(self, symbol: QgsSymbol) -> None: ...
    def embeddedSymbol(self) -> QgsSymbol: ...
    @overload
    def attribute(self, name: str) -> typing.Any: ...
    @overload
    def attribute(self, fieldIdx: int) -> typing.Any: ...
    def fields(self) -> QgsFields: ...
    def setFields(self, fields: QgsFields, initAttributes: bool = ...) -> None: ...
    def clearGeometry(self) -> None: ...
    @overload
    def setGeometry(self, geometry: QgsGeometry) -> None: ...
    @overload
    def setGeometry(self, geometry: QgsAbstractGeometry) -> None: ...
    def geometry(self) -> QgsGeometry: ...
    def hasGeometry(self) -> bool: ...
    def setValid(self, validity: bool) -> None: ...
    def isValid(self) -> bool: ...
    @overload
    def deleteAttribute(self, field: int) -> None: ...
    @overload
    def deleteAttribute(self, name: str) -> bool: ...
    def padAttributes(self, count: int) -> None: ...
    def resizeAttributes(self, fieldCount: int) -> None: ...
    def initAttributes(self, fieldCount: int) -> None: ...
    @overload
    def setAttribute(self, field: int, attr: typing.Any) -> bool: ...
    @overload
    def setAttribute(self, name: str, value: typing.Any) -> None: ...
    def setAttributes(self, attrs: typing.Any) -> None: ...
    def attributeCount(self) -> int: ...
    def attributes(self) -> typing.Any: ...
    def setId(self, id: int) -> None: ...
    def id(self) -> int: ...
    @overload
    def __delitem__(self, key: int) -> None: ...
    @overload
    def __delitem__(self, name: str) -> None: ...
    @overload
    def __setitem__(self, key: int, value: typing.Any) -> None: ...
    @overload
    def __setitem__(self, key: str, value: typing.Any) -> None: ...
    @overload
    def __getitem__(self, key: int) -> typing.Any: ...
    @overload
    def __getitem__(self, name: str) -> typing.Any: ...
    def __iter__(self) -> typing.Any: ...


class QgsFeaturePickerModelBase(QtCore.QAbstractItemModel):

    class Role(int):
        ...
    IdentifierValueRole: QgsFeaturePickerModelBase.Role = ...
    IdentifierValuesRole: QgsFeaturePickerModelBase.Role = ...
    ValueRole: QgsFeaturePickerModelBase.Role = ...
    FeatureRole: QgsFeaturePickerModelBase.Role = ...
    FeatureIdRole: QgsFeaturePickerModelBase.Role = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setExtraIdentifierValueUnguarded(self, identifierValue: typing.Any) -> None: ...
    def requestToReloadCurrentFeature(self, request: QgsFeatureRequest) -> None: ...
    def setExtraIdentifierValue(self, extraIdentifierValue: typing.Any) -> None: ...
    def extraIdentifierValue(self) -> typing.Any: ...
    def fetchLimitChanged(self) -> None: ...
    def fetchGeometryChanged(self) -> None: ...
    def allowNullChanged(self) -> None: ...
    def endUpdate(self) -> None: ...
    def beginUpdate(self) -> None: ...
    def extraValueDoesNotExistChanged(self) -> None: ...
    def extraIdentifierValueIndexChanged(self, index: int) -> None: ...
    def extraIdentifierValueChanged(self) -> None: ...
    def filterJobCompleted(self) -> None: ...
    def isLoadingChanged(self) -> None: ...
    def filterExpressionChanged(self) -> None: ...
    def filterValueChanged(self) -> None: ...
    def displayExpressionChanged(self) -> None: ...
    def sourceLayerChanged(self) -> None: ...
    def currentFeatureChanged(self) -> None: ...
    def setFetchLimit(self, fetchLimit: int) -> None: ...
    def fetchLimit(self) -> int: ...
    def setFetchGeometry(self, fetchGeometry: bool) -> None: ...
    def fetchGeometry(self) -> bool: ...
    def setAllowNull(self, allowNull: bool) -> None: ...
    def allowNull(self) -> bool: ...
    def extraValueDoesNotExist(self) -> bool: ...
    def extraIdentifierValueIndex(self) -> int: ...
    def setExtraIdentifierValueToNull(self) -> None: ...
    def isLoading(self) -> bool: ...
    def setFilterExpression(self, filterExpression: str) -> None: ...
    def filterExpression(self) -> str: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def setFilterValue(self, filterValue: str) -> None: ...
    def filterValue(self) -> str: ...
    def setDisplayExpression(self, displayExpression: str) -> None: ...
    def displayExpression(self) -> str: ...
    def setSourceLayer(self, sourceLayer: QgsVectorLayer) -> None: ...
    def sourceLayer(self) -> QgsVectorLayer: ...


class QgsFeaturePickerModel(QgsFeaturePickerModelBase):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def featureChanged(self, feature: QgsFeature) -> None: ...
    def feature(self) -> QgsFeature: ...
    def setFeature(self, fid: int) -> None: ...
    def setExtraIdentifierValueToNull(self) -> None: ...


class QgsFeatureFilterModel(QgsFeaturePickerModelBase):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def extraIdentifierValuesChanged(self) -> None: ...
    def identifierFieldsChanged(self) -> None: ...
    def setExtraIdentifierValues(self, extraIdentifierValues: Iterable[typing.Any]) -> None: ...
    def extraIdentifierValues(self) -> List[typing.Any]: ...
    def setExtraIdentifierValueToNull(self) -> None: ...
    def setIdentifierFields(self, identifierFields: Iterable[str]) -> None: ...
    def identifierFields(self) -> List[str]: ...
    def identifierField(self) -> str: ...


class QgsFeatureFilterProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureFilterProvider) -> None: ...

    def clone(self) -> QgsFeatureFilterProvider: ...
    def layerAttributes(self, layer: QgsVectorLayer, attributes: Iterable[str]) -> List[str]: ...
    def filterFeatures(self, layer: QgsVectorLayer, featureRequest: QgsFeatureRequest) -> None: ...


class QgsFeatureIterator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, iter: QgsAbstractFeatureIterator) -> None: ...
    @overload
    def __init__(self, fi: QgsFeatureIterator) -> None: ...

    def compileFailed(self) -> bool: ...
    def compileStatus(self) -> QgsAbstractFeatureIterator.CompileStatus: ...
    def isClosed(self) -> bool: ...
    def isValid(self) -> bool: ...
    def close(self) -> bool: ...
    def rewind(self) -> bool: ...
    def nextFeature(self, f: QgsFeature) -> bool: ...
    def __next__(self) -> QgsFeature: ...
    def __iter__(self) -> QgsFeatureIterator: ...


class QgsFeatureRequest(sip.wrapper):

    class InvalidGeometryCheck(int):
        ...
    GeometryNoCheck: QgsFeatureRequest.InvalidGeometryCheck = ...
    GeometrySkipInvalid: QgsFeatureRequest.InvalidGeometryCheck = ...
    GeometryAbortOnInvalid: QgsFeatureRequest.InvalidGeometryCheck = ...

    class FilterType(int):
        ...
    FilterNone: QgsFeatureRequest.FilterType = ...
    FilterFid: QgsFeatureRequest.FilterType = ...
    FilterExpression: QgsFeatureRequest.FilterType = ...
    FilterFids: QgsFeatureRequest.FilterType = ...

    class Flag(int):
        ...
    NoFlags: QgsFeatureRequest.Flag = ...
    NoGeometry: QgsFeatureRequest.Flag = ...
    SubsetOfAttributes: QgsFeatureRequest.Flag = ...
    ExactIntersect: QgsFeatureRequest.Flag = ...
    IgnoreStaticNodesDuringExpressionCompilation: QgsFeatureRequest.Flag = ...
    EmbeddedSymbols: QgsFeatureRequest.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsFeatureRequest.Flags, QgsFeatureRequest.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsFeatureRequest.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsFeatureRequest.Flags: ...
        def __int__(self) -> int: ...

    class OrderByClause(sip.wrapper):

        @overload
        def __init__(self, expression: str, ascending: bool = ...) -> None: ...
        @overload
        def __init__(self, expression: str, ascending: bool, nullsfirst: bool) -> None: ...
        @overload
        def __init__(self, expression: QgsExpression, ascending: bool = ...) -> None: ...
        @overload
        def __init__(self, expression: QgsExpression, ascending: bool, nullsfirst: bool) -> None: ...
        @overload
        def __init__(self, a0: QgsFeatureRequest.OrderByClause) -> None: ...

        def dump(self) -> str: ...
        def setNullsFirst(self, nullsFirst: bool) -> None: ...
        def nullsFirst(self) -> bool: ...
        def setAscending(self, ascending: bool) -> None: ...
        def ascending(self) -> bool: ...
        def prepare(self, context: QgsExpressionContext) -> bool: ...
        def expression(self) -> QgsExpression: ...

    class OrderBy(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, other: Iterable[QgsFeatureRequest.OrderByClause]) -> None: ...
        @overload
        def __init__(self, a0: QgsFeatureRequest.OrderBy) -> None: ...

        def dump(self) -> str: ...
        def usedAttributeIndices(self, fields: QgsFields) -> typing.Any: ...
        def usedAttributes(self) -> Set[str]: ...
        def load(self, elem: QtXml.QDomElement) -> None: ...
        def save(self, elem: QtXml.QDomElement) -> None: ...
        def list(self) -> List[QgsFeatureRequest.OrderByClause]: ...

    ALL_ATTRIBUTES: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, fid: int) -> None: ...
    @overload
    def __init__(self, fids: typing.Any) -> None: ...
    @overload
    def __init__(self, rectangle: QgsRectangle) -> None: ...
    @overload
    def __init__(self, expr: QgsExpression, context: QgsExpressionContext = ...) -> None: ...
    @overload
    def __init__(self, rh: QgsFeatureRequest) -> None: ...

    def setRequestMayBeNested(self, requestMayBeNested: bool) -> QgsFeatureRequest: ...
    def requestMayBeNested(self) -> bool: ...
    def setTimeout(self, timeout: int) -> QgsFeatureRequest: ...
    def timeout(self) -> int: ...
    def setConnectionTimeout(self, connectionTimeout: int) -> QgsFeatureRequest: ...
    def connectionTimeout(self) -> int: ...
    def acceptFeature(self, feature: QgsFeature) -> bool: ...
    def setTransformErrorCallback(self, a0: Callable[..., None]) -> QgsFeatureRequest: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem, context: QgsCoordinateTransformContext) -> QgsFeatureRequest: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def simplifyMethod(self) -> QgsSimplifyMethod: ...
    def setSimplifyMethod(self, simplifyMethod: QgsSimplifyMethod) -> QgsFeatureRequest: ...
    def subsetOfAttributes(self) -> List[int]: ...
    def setNoAttributes(self) -> QgsFeatureRequest: ...
    @overload
    def setSubsetOfAttributes(self, attrs: Iterable[int]) -> QgsFeatureRequest: ...
    @overload
    def setSubsetOfAttributes(self, attrNames: Iterable[str], fields: QgsFields) -> QgsFeatureRequest: ...
    def flags(self) -> QgsFeatureRequest.Flags: ...
    def setFlags(self, flags: Union[QgsFeatureRequest.Flags, QgsFeatureRequest.Flag]) -> QgsFeatureRequest: ...
    def limit(self) -> int: ...
    def setLimit(self, limit: int) -> QgsFeatureRequest: ...
    def setOrderBy(self, orderBy: QgsFeatureRequest.OrderBy) -> QgsFeatureRequest: ...
    def orderBy(self) -> QgsFeatureRequest.OrderBy: ...
    @overload
    def addOrderBy(self, expression: str, ascending: bool = ...) -> QgsFeatureRequest: ...
    @overload
    def addOrderBy(self, expression: str, ascending: bool, nullsfirst: bool) -> QgsFeatureRequest: ...
    def disableFilter(self) -> QgsFeatureRequest: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> QgsFeatureRequest: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def combineFilterExpression(self, expression: str) -> QgsFeatureRequest: ...
    def filterExpression(self) -> QgsExpression: ...
    def setFilterExpression(self, expression: str) -> QgsFeatureRequest: ...
    def setInvalidGeometryCallback(self, a0: Callable[..., None]) -> QgsFeatureRequest: ...
    def invalidGeometryCheck(self) -> QgsFeatureRequest.InvalidGeometryCheck: ...
    def setInvalidGeometryCheck(self, check: QgsFeatureRequest.InvalidGeometryCheck) -> QgsFeatureRequest: ...
    def filterFids(self) -> typing.Any: ...
    def setFilterFids(self, fids: typing.Any) -> QgsFeatureRequest: ...
    def filterFid(self) -> int: ...
    def setFilterFid(self, fid: int) -> QgsFeatureRequest: ...
    def filterRect(self) -> QgsRectangle: ...
    def setFilterRect(self, rectangle: QgsRectangle) -> QgsFeatureRequest: ...
    def filterType(self) -> QgsFeatureRequest.FilterType: ...


class QgsAbstractFeatureSource(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractFeatureSource) -> None: ...

    def iteratorClosed(self, it: QgsAbstractFeatureIterator) -> None: ...
    def iteratorOpened(self, it: QgsAbstractFeatureIterator) -> None: ...
    def getFeatures(self, request: QgsFeatureRequest = ...) -> QgsFeatureIterator: ...


class QgsFeatureStore(QgsFeatureSink):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, fields: QgsFields, crs: QgsCoordinateReferenceSystem) -> None: ...
    @overload
    def __init__(self, a0: QgsFeatureStore) -> None: ...

    def params(self) -> Dict[str, typing.Any]: ...
    def setParams(self, parameters: Dict[str, typing.Any]) -> None: ...
    def features(self) -> List[QgsFeature]: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def fields(self) -> QgsFields: ...


class QgsFeedback(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def progressChanged(self, progress: float) -> None: ...
    def canceled(self) -> None: ...
    def cancel(self) -> None: ...
    def progress(self) -> float: ...
    def setProgress(self, progress: float) -> None: ...
    def isCanceled(self) -> bool: ...


class QgsField(sip.wrapper):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, name: str = ..., type: QtCore.QVariant.Type = ..., typeName: str = ..., len: int = ..., prec: int = ..., comment: str = ..., subType: QtCore.QVariant.Type = ...) -> None: ...
    @overload
    def __init__(self, other: QgsField) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def isReadOnly(self) -> bool: ...
    def setReadOnly(self, readOnly: bool) -> None: ...
    def editorWidgetSetup(self) -> QgsEditorWidgetSetup: ...
    def setEditorWidgetSetup(self, v: QgsEditorWidgetSetup) -> None: ...
    def convertCompatible(self, v: typing.Any) -> bool: ...
    def displayString(self, v: typing.Any) -> str: ...
    def setAlias(self, alias: str) -> None: ...
    def alias(self) -> str: ...
    def setConstraints(self, constraints: QgsFieldConstraints) -> None: ...
    def constraints(self) -> QgsFieldConstraints: ...
    def setDefaultValueDefinition(self, defaultValueDefinition: QgsDefaultValue) -> None: ...
    def defaultValueDefinition(self) -> QgsDefaultValue: ...
    def setComment(self, comment: str) -> None: ...
    def setPrecision(self, precision: int) -> None: ...
    def setLength(self, len: int) -> None: ...
    def setTypeName(self, typeName: str) -> None: ...
    def setSubType(self, subType: QtCore.QVariant.Type) -> None: ...
    def setType(self, type: QtCore.QVariant.Type) -> None: ...
    def setName(self, name: str) -> None: ...
    def isDateOrTime(self) -> bool: ...
    def isNumeric(self) -> bool: ...
    def comment(self) -> str: ...
    def precision(self) -> int: ...
    def length(self) -> int: ...
    def typeName(self) -> str: ...
    def subType(self) -> QtCore.QVariant.Type: ...
    def type(self) -> QtCore.QVariant.Type: ...
    def displayType(self, showConstraints: bool = ...) -> str: ...
    def displayNameWithAlias(self) -> str: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...


class QgsFieldConstraints(sip.wrapper):

    class ConstraintStrength(int):
        ...
    ConstraintStrengthNotSet: QgsFieldConstraints.ConstraintStrength = ...
    ConstraintStrengthHard: QgsFieldConstraints.ConstraintStrength = ...
    ConstraintStrengthSoft: QgsFieldConstraints.ConstraintStrength = ...

    class ConstraintOrigin(int):
        ...
    ConstraintOriginNotSet: QgsFieldConstraints.ConstraintOrigin = ...
    ConstraintOriginProvider: QgsFieldConstraints.ConstraintOrigin = ...
    ConstraintOriginLayer: QgsFieldConstraints.ConstraintOrigin = ...

    class Constraint(int):
        ...
    ConstraintNotNull: QgsFieldConstraints.Constraint = ...
    ConstraintUnique: QgsFieldConstraints.Constraint = ...
    ConstraintExpression: QgsFieldConstraints.Constraint = ...

    class Constraints(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsFieldConstraints.Constraints, QgsFieldConstraints.Constraint]) -> None: ...
        @overload
        def __init__(self, a0: QgsFieldConstraints.Constraints) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsFieldConstraints.Constraints: ...
        def __int__(self) -> int: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFieldConstraints) -> None: ...

    def setConstraintExpression(self, expression: str, description: str = ...) -> None: ...
    def constraintDescription(self) -> str: ...
    def constraintExpression(self) -> str: ...
    def removeConstraint(self, constraint: QgsFieldConstraints.Constraint) -> None: ...
    def setConstraint(self, constraint: QgsFieldConstraints.Constraint, origin: QgsFieldConstraints.ConstraintOrigin = ...) -> None: ...
    def setConstraintStrength(self, constraint: QgsFieldConstraints.Constraint, strength: QgsFieldConstraints.ConstraintStrength) -> None: ...
    def constraintStrength(self, constraint: QgsFieldConstraints.Constraint) -> QgsFieldConstraints.ConstraintStrength: ...
    def constraintOrigin(self, constraint: QgsFieldConstraints.Constraint) -> QgsFieldConstraints.ConstraintOrigin: ...
    def constraints(self) -> QgsFieldConstraints.Constraints: ...


class QgsFieldFormatterContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFieldFormatterContext) -> None: ...

    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...


class QgsFieldFormatter(sip.wrapper):

    class Flag(int):
        ...
    CanProvideAvailableValues: QgsFieldFormatter.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsFieldFormatter.Flags, QgsFieldFormatter.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsFieldFormatter.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsFieldFormatter.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFieldFormatter) -> None: ...

    def setFlags(self, flags: Union[QgsFieldFormatter.Flags, QgsFieldFormatter.Flag]) -> None: ...
    def flags(self) -> QgsFieldFormatter.Flags: ...
    def availableValues(self, config: Dict[str, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> List[typing.Any]: ...
    def createCache(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any]) -> typing.Any: ...
    def alignmentFlag(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any]) -> QtCore.Qt.AlignmentFlag: ...
    def sortValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsFieldFormatterRegistry(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def fieldFormatterRemoved(self, formatter: QgsFieldFormatter) -> None: ...
    def fieldFormatterAdded(self, formatter: QgsFieldFormatter) -> None: ...
    def fallbackFieldFormatter(self) -> QgsFieldFormatter: ...
    def fieldFormatter(self, id: str) -> QgsFieldFormatter: ...
    @overload
    def removeFieldFormatter(self, formatter: QgsFieldFormatter) -> None: ...
    @overload
    def removeFieldFormatter(self, id: str) -> None: ...
    def addFieldFormatter(self, formatter: QgsFieldFormatter) -> None: ...


class QgsFieldModel(QtCore.QAbstractItemModel):

    class FieldRoles(int):
        ...
    FieldNameRole: QgsFieldModel.FieldRoles = ...
    FieldIndexRole: QgsFieldModel.FieldRoles = ...
    ExpressionRole: QgsFieldModel.FieldRoles = ...
    IsExpressionRole: QgsFieldModel.FieldRoles = ...
    ExpressionValidityRole: QgsFieldModel.FieldRoles = ...
    FieldTypeRole: QgsFieldModel.FieldRoles = ...
    FieldOriginRole: QgsFieldModel.FieldRoles = ...
    IsEmptyRole: QgsFieldModel.FieldRoles = ...
    EditorWidgetType: QgsFieldModel.FieldRoles = ...
    JoinedFieldIsEditable: QgsFieldModel.FieldRoles = ...
    FieldIsWidgetEditable: QgsFieldModel.FieldRoles = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def updateModel(self) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def fields(self) -> QgsFields: ...
    def setFields(self, fields: QgsFields) -> None: ...
    @staticmethod
    def fieldToolTipExtended(field: QgsField, layer: QgsVectorLayer) -> str: ...
    @staticmethod
    def fieldToolTip(field: QgsField) -> str: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def layer(self) -> QgsVectorLayer: ...
    def removeExpression(self) -> None: ...
    def setExpression(self, expression: str) -> None: ...
    def isField(self, expression: str) -> bool: ...
    def allowEmptyFieldName(self) -> bool: ...
    def setAllowEmptyFieldName(self, allowEmpty: bool) -> None: ...
    def allowExpression(self) -> bool: ...
    def setAllowExpression(self, allowExpression: bool) -> None: ...
    def indexFromName(self, fieldName: str) -> QtCore.QModelIndex: ...


class QgsFieldProxyModel(QtCore.QSortFilterProxyModel):

    class Filter(int):
        ...
    String: QgsFieldProxyModel.Filter = ...
    Int: QgsFieldProxyModel.Filter = ...
    LongLong: QgsFieldProxyModel.Filter = ...
    Double: QgsFieldProxyModel.Filter = ...
    Numeric: QgsFieldProxyModel.Filter = ...
    Date: QgsFieldProxyModel.Filter = ...
    Time: QgsFieldProxyModel.Filter = ...
    HideReadOnly: QgsFieldProxyModel.Filter = ...
    DateTime: QgsFieldProxyModel.Filter = ...
    AllTypes: QgsFieldProxyModel.Filter = ...

    class Filters(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsFieldProxyModel.Filters, QgsFieldProxyModel.Filter]) -> None: ...
        @overload
        def __init__(self, a0: QgsFieldProxyModel.Filters) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsFieldProxyModel.Filters: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def filters(self) -> QgsFieldProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsFieldProxyModel.Filters, QgsFieldProxyModel.Filter]) -> QgsFieldProxyModel: ...
    def sourceFieldModel(self) -> QgsFieldModel: ...


class QgsFields(sip.wrapper):

    class FieldOrigin(int):
        ...
    OriginUnknown: QgsFields.FieldOrigin = ...
    OriginProvider: QgsFields.FieldOrigin = ...
    OriginJoin: QgsFields.FieldOrigin = ...
    OriginEdit: QgsFields.FieldOrigin = ...
    OriginExpression: QgsFields.FieldOrigin = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsFields) -> None: ...

    def __setitem__(self, key: int, field: QgsField) -> None: ...
    @staticmethod
    def iconForFieldType(type: QtCore.QVariant.Type) -> QtGui.QIcon: ...
    def iconForField(self, fieldIdx: int, considerOrigin: bool = ...) -> QtGui.QIcon: ...
    def toList(self) -> typing.Any: ...
    def allAttributesList(self) -> List[int]: ...
    def lookupField(self, fieldName: str) -> int: ...
    def indexOf(self, fieldName: str) -> int: ...
    def indexFromName(self, fieldName: str) -> int: ...
    def fieldOriginIndex(self, fieldIdx: int) -> int: ...
    def fieldOrigin(self, fieldIdx: int) -> QgsFields.FieldOrigin: ...
    @overload
    def field(self, fieldIdx: int) -> QgsField: ...
    @overload
    def field(self, name: str) -> QgsField: ...
    def at(self, i: int) -> QgsField: ...
    def __getitem__(self, i: int) -> QgsField: ...
    def exists(self, i: int) -> bool: ...
    def names(self) -> List[str]: ...
    def size(self) -> int: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def count(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def extend(self, other: QgsFields) -> None: ...
    def remove(self, fieldIdx: int) -> None: ...
    def appendExpressionField(self, field: QgsField, originIndex: int) -> bool: ...
    def rename(self, fieldIdx: int, name: str) -> bool: ...
    def append(self, field: QgsField, origin: QgsFields.FieldOrigin = ..., originIndex: int = ...) -> bool: ...
    def clear(self) -> None: ...


class QgsFileFilterGenerator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFileFilterGenerator) -> None: ...

    def createFileFilter(self) -> str: ...


class QgsFileUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFileUtils) -> None: ...

    @staticmethod
    def pathIsSlowDevice(path: str) -> bool: ...
    @staticmethod
    def driveType(path: str) -> Qgis.DriveType: ...
    @staticmethod
    def findFile(file: str, basepath: str = ..., maxClimbs: int = ..., searchCeiling: int = ..., currentDir: str = ...) -> List[str]: ...
    @staticmethod
    def findClosestExistingPath(path: str) -> str: ...
    @staticmethod
    def stringToSafeFilename(string: str) -> str: ...
    @staticmethod
    def addExtensionFromFilter(fileName: str, filter: str) -> str: ...
    @staticmethod
    def ensureFileNameHasExtension(fileName: str, extensions: Iterable[str]) -> str: ...
    @staticmethod
    def fileMatchesFilter(fileName: str, filter: str) -> bool: ...
    @staticmethod
    def wildcardsFromFilter(filter: str) -> str: ...
    @staticmethod
    def extensionsFromFilter(filter: str) -> List[str]: ...
    @staticmethod
    def representFileSize(bytes: int) -> str: ...


class QgsFontUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFontUtils) -> None: ...

    @staticmethod
    def recentFontFamilies() -> List[str]: ...
    @staticmethod
    def addRecentFontFamily(family: str) -> None: ...
    @staticmethod
    def asCSS(font: QtGui.QFont, pointToPixelMultiplier: float = ...) -> str: ...
    @staticmethod
    def untranslateNamedStyle(namedStyle: str) -> str: ...
    @staticmethod
    def translateNamedStyle(namedStyle: str) -> str: ...
    @staticmethod
    def fromMimeData(data: QtCore.QMimeData) -> Tuple[QtGui.QFont, bool]: ...
    @staticmethod
    def toMimeData(font: QtGui.QFont) -> QtCore.QMimeData: ...
    @staticmethod
    def setFromXmlChildNode(font: QtGui.QFont, element: QtXml.QDomElement, childNode: str) -> bool: ...
    @staticmethod
    def setFromXmlElement(font: QtGui.QFont, element: QtXml.QDomElement) -> bool: ...
    @staticmethod
    def toXmlElement(font: QtGui.QFont, document: QtXml.QDomDocument, elementName: str) -> QtXml.QDomElement: ...
    @staticmethod
    def getStandardTestFont(style: str = ..., pointsize: int = ...) -> QtGui.QFont: ...
    @staticmethod
    def loadStandardTestFonts(loadstyles: Iterable[str]) -> bool: ...
    @staticmethod
    def standardTestFontFamily() -> str: ...
    @staticmethod
    def updateFontViaStyle(f: QtGui.QFont, fontstyle: str, fallback: bool = ...) -> bool: ...
    @staticmethod
    def fontFamilyMatchOnSystem(family: str, chosen: Optional[str] = ...) -> Tuple[bool, bool]: ...
    @staticmethod
    def fontFamilyHasStyle(family: str, style: str) -> bool: ...
    @staticmethod
    def fontFamilyOnSystem(family: str) -> bool: ...
    @staticmethod
    def fontMatchOnSystem(f: QtGui.QFont) -> bool: ...


class QgsGeometryOptions(QtCore.QObject):

    def __init__(self) -> None: ...

    def geometryPrecisionChanged(self) -> None: ...
    def removeDuplicateNodesChanged(self) -> None: ...
    def geometryChecksChanged(self) -> None: ...
    def checkConfigurationChanged(self) -> None: ...
    def readXml(self, node: QtXml.QDomNode) -> None: ...
    def writeXml(self, node: QtXml.QDomNode) -> None: ...
    def setCheckConfiguration(self, checkId: str, checkConfiguration: Dict[str, typing.Any]) -> None: ...
    def checkConfiguration(self, checkId: str) -> Dict[str, typing.Any]: ...
    def setGeometryChecks(self, geometryChecks: Iterable[str]) -> None: ...
    def geometryChecks(self) -> List[str]: ...
    def apply(self, geometry: QgsGeometry) -> None: ...
    def isActive(self) -> bool: ...
    def setGeometryPrecision(self, value: float) -> None: ...
    def geometryPrecision(self) -> float: ...
    def setRemoveDuplicateNodes(self, value: bool) -> None: ...
    def removeDuplicateNodes(self) -> bool: ...


class QgsAbstractGeometrySimplifier(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractGeometrySimplifier) -> None: ...

    @overload
    @staticmethod
    def isGeneralizableByDeviceBoundingBox(envelope: QgsRectangle, mapToPixelTol: float = ...) -> bool: ...
    @overload
    @staticmethod
    def isGeneralizableByDeviceBoundingBox(points: Iterable[Union[QtCore.QPointF, QtCore.QPoint, float]], mapToPixelTol: float = ...) -> bool: ...
    @overload
    def simplify(self, geometry: QgsGeometry) -> QgsGeometry: ...
    @overload
    def simplify(self, geometry: QgsAbstractGeometry) -> QgsAbstractGeometry: ...


class QgsTopologyPreservingSimplifier(QgsAbstractGeometrySimplifier):

    @overload
    def __init__(self, tolerance: float) -> None: ...
    @overload
    def __init__(self, a0: QgsTopologyPreservingSimplifier) -> None: ...

    @overload
    def simplify(self, geometry: QgsGeometry) -> QgsGeometry: ...
    @overload
    def simplify(self, geometry: QgsAbstractGeometry) -> QgsAbstractGeometry: ...


class QgsGeometryValidator(QtCore.QThread):

    def __init__(self, geometry: QgsGeometry, errors: Optional[Iterable[QgsGeometry.Error]] = ..., method: QgsGeometry.ValidationMethod = ...) -> None: ...

    def addError(self, a0: QgsGeometry.Error) -> None: ...
    def validationFinished(self, summary: str) -> None: ...
    def errorFound(self, error: QgsGeometry.Error) -> None: ...
    @staticmethod
    def validateGeometry(geometry: QgsGeometry, method: QgsGeometry.ValidationMethod = ...) -> List[QgsGeometry.Error]: ...
    def stop(self) -> None: ...
    def run(self) -> None: ...


class QgsGml(QtCore.QObject):

    def __init__(self, typeName: str, geometryAttribute: str, fields: QgsFields) -> None: ...

    def dataProgressAndSteps(self, progress: int, totalSteps: int) -> None: ...
    def totalStepsUpdate(self, totalSteps: int) -> None: ...
    def dataReadProgress(self, progress: int) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def idsMap(self) -> typing.Any: ...
    def featuresMap(self) -> typing.Any: ...
    def getFeatures(self, data: Union[QtCore.QByteArray, bytes, bytearray], extent: Optional[QgsRectangle] = ...) -> Tuple[int, QgsWkbTypes.Type]: ...
    def getFeaturesUri(self, uri: str, extent: Optional[QgsRectangle] = ..., userName: str = ..., password: str = ..., authcfg: str = ...) -> Tuple[int, QgsWkbTypes.Type]: ...


class QgsGmlFeatureClass(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, path: str) -> None: ...
    @overload
    def __init__(self, a0: QgsGmlFeatureClass) -> None: ...

    def geometryAttributes(self) -> List[str]: ...
    def path(self) -> str: ...
    def fieldIndex(self, name: str) -> int: ...
    def fields(self) -> typing.Any: ...


class QgsGmlSchema(QtCore.QObject):

    def __init__(self) -> None: ...

    def error(self) -> QgsError: ...
    def geometryAttributes(self, typeName: str) -> List[str]: ...
    def fields(self, typeName: str) -> typing.Any: ...
    def typeNames(self) -> List[str]: ...
    def guessSchema(self, data: Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def parseXSD(self, xml: Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...


class QgsHistogram(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsHistogram) -> None: ...

    def counts(self, bins: int) -> List[int]: ...
    def binEdges(self, bins: int) -> List[float]: ...
    def optimalNumberBins(self) -> int: ...
    def optimalBinWidth(self) -> float: ...
    @overload
    def setValues(self, values: Iterable[float]) -> None: ...
    @overload
    def setValues(self, layer: QgsVectorLayer, fieldOrExpression: str, feedback: Optional[QgsFeedback] = ...) -> bool: ...


class QgsHstoreUtils(sip.simplewrapper):

    def build(self, map: Dict[str, typing.Any]) -> str: ...
    def parse(self, string: str) -> Dict[str, typing.Any]: ...


class QgsHtmlUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsHtmlUtils) -> None: ...

    @staticmethod
    def buildBulletList(values: Iterable[str]) -> str: ...


class QgsIconUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsIconUtils) -> None: ...

    @staticmethod
    def iconForLayer(layer: QgsMapLayer) -> QtGui.QIcon: ...
    @staticmethod
    def iconPointCloud() -> QtGui.QIcon: ...
    @staticmethod
    def iconVectorTile() -> QtGui.QIcon: ...
    @staticmethod
    def iconMesh() -> QtGui.QIcon: ...
    @staticmethod
    def iconDefaultLayer() -> QtGui.QIcon: ...
    @staticmethod
    def iconRaster() -> QtGui.QIcon: ...
    @staticmethod
    def iconTable() -> QtGui.QIcon: ...
    @staticmethod
    def iconPolygon() -> QtGui.QIcon: ...
    @staticmethod
    def iconLine() -> QtGui.QIcon: ...
    @staticmethod
    def iconPoint() -> QtGui.QIcon: ...
    @staticmethod
    def iconForWkbType(type: QgsWkbTypes.Type) -> QtGui.QIcon: ...


class QgsIdentifyContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsIdentifyContext) -> None: ...

    def isTemporal(self) -> bool: ...
    def temporalRange(self) -> QgsDateTimeRange: ...
    def setTemporalRange(self, range: QgsDateTimeRange) -> None: ...


class QgsImageCache(QgsAbstractContentCacheBase):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def remoteImageFetched(self, url: str) -> None: ...
    def originalSize(self, path: str, blocking: bool = ...) -> QtCore.QSize: ...
    def pathAsImage(self, path: str, size: QtCore.QSize, keepAspectRatio: bool, opacity: float, blocking: bool = ...) -> Tuple[QtGui.QImage, bool]: ...


class QgsInterval(sip.wrapper):

    DAY: int = ...
    HOUR: int = ...
    MINUTE: int = ...
    MONTHS: int = ...
    WEEKS: int = ...
    YEARS: int = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, seconds: float) -> None: ...
    @overload
    def __init__(self, duration: float, unit: QgsUnitTypes.TemporalUnit) -> None: ...
    @overload
    def __init__(self, years: float, months: float, weeks: float, days: float, hours: float, minutes: float, seconds: float) -> None: ...
    @overload
    def __init__(self, a0: QgsInterval) -> None: ...

    @staticmethod
    def fromString(string: str) -> QgsInterval: ...
    def originalUnit(self) -> QgsUnitTypes.TemporalUnit: ...
    def originalDuration(self) -> float: ...
    def setValid(self, valid: bool) -> None: ...
    def isValid(self) -> bool: ...
    def setSeconds(self, seconds: float) -> None: ...
    def seconds(self) -> float: ...
    def setMinutes(self, minutes: float) -> None: ...
    def minutes(self) -> float: ...
    def setHours(self, hours: float) -> None: ...
    def hours(self) -> float: ...
    def setDays(self, days: float) -> None: ...
    def days(self) -> float: ...
    def setWeeks(self, weeks: float) -> None: ...
    def weeks(self) -> float: ...
    def setMonths(self, months: float) -> None: ...
    def months(self) -> float: ...
    def setYears(self, years: float) -> None: ...
    def years(self) -> float: ...


class QgsJsonExporter(sip.wrapper):

    @overload
    def __init__(self, vectorLayer: Optional[QgsVectorLayer] = ..., precision: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsJsonExporter) -> None: ...

    def exportFeatures(self, features: Iterable[QgsFeature], indent: int = ...) -> str: ...
    def exportFeature(self, feature: QgsFeature, extraProperties: Dict[str, typing.Any] = ..., id: typing.Any = ..., indent: int = ...) -> str: ...
    def excludedAttributes(self) -> List[int]: ...
    def setExcludedAttributes(self, attributes: Iterable[int]) -> None: ...
    def attributes(self) -> List[int]: ...
    def setAttributes(self, attributes: Iterable[int]) -> None: ...
    def setTransformGeometries(self, activate: bool) -> None: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setSourceCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def setVectorLayer(self, vectorLayer: QgsVectorLayer) -> None: ...
    def attributeDisplayName(self) -> bool: ...
    def setAttributeDisplayName(self, displayName: bool) -> None: ...
    def includeRelated(self) -> bool: ...
    def setIncludeRelated(self, includeRelated: bool) -> None: ...
    def includeAttributes(self) -> bool: ...
    def setIncludeAttributes(self, includeAttributes: bool) -> None: ...
    def includeGeometry(self) -> bool: ...
    def setIncludeGeometry(self, includeGeometry: bool) -> None: ...
    def precision(self) -> int: ...
    def setPrecision(self, precision: int) -> None: ...


class QgsJsonUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsJsonUtils) -> None: ...

    @staticmethod
    def parseArray(json: str, type: QtCore.QVariant.Type = ...) -> List[typing.Any]: ...
    @staticmethod
    def exportAttributes(feature: QgsFeature, layer: Optional[QgsVectorLayer] = ..., attributeWidgetCaches: Iterable[typing.Any] = ...) -> str: ...
    @staticmethod
    def encodeValue(value: typing.Any) -> str: ...
    @staticmethod
    def stringToFields(string: str, encoding: Optional[QtCore.QTextCodec] = ...) -> QgsFields: ...
    @staticmethod
    def stringToFeatureList(string: str, fields: QgsFields = ..., encoding: Optional[QtCore.QTextCodec] = ...) -> List[QgsFeature]: ...


class QgsLayerDefinition(sip.wrapper):

    class DependencySorter(sip.wrapper):

        @overload
        def __init__(self, doc: QtXml.QDomDocument) -> None: ...
        @overload
        def __init__(self, fileName: str) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerDefinition.DependencySorter) -> None: ...

        def hasMissingDependency(self) -> bool: ...
        def hasCycle(self) -> bool: ...
        def sortedLayerIds(self) -> List[str]: ...
        def sortedLayerNodes(self) -> List[QtXml.QDomNode]: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerDefinition) -> None: ...

    @overload
    @staticmethod
    def loadLayerDefinitionLayers(document: QtXml.QDomDocument, context: QgsReadWriteContext) -> List[QgsMapLayer]: ...
    @overload
    @staticmethod
    def loadLayerDefinitionLayers(qlrfile: str) -> List[QgsMapLayer]: ...
    @staticmethod
    def exportLayerDefinitionLayers(layers: Iterable[QgsMapLayer], context: QgsReadWriteContext) -> QtXml.QDomDocument: ...
    @overload
    @staticmethod
    def exportLayerDefinition(path: str, selectedTreeNodes: Iterable[QgsLayerTreeNode]) -> Tuple[bool, str]: ...
    @overload
    @staticmethod
    def exportLayerDefinition(doc: QtXml.QDomDocument, selectedTreeNodes: Iterable[QgsLayerTreeNode], context: QgsReadWriteContext) -> Tuple[bool, str]: ...
    @overload
    @staticmethod
    def loadLayerDefinition(path: str, project: QgsProject, rootGroup: QgsLayerTreeGroup) -> Tuple[bool, str]: ...
    @overload
    @staticmethod
    def loadLayerDefinition(doc: QtXml.QDomDocument, project: QgsProject, rootGroup: QgsLayerTreeGroup, context: QgsReadWriteContext) -> Tuple[bool, str]: ...


class QgsLayerNotesUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerNotesUtils) -> None: ...

    @staticmethod
    def removeNotes(layer: QgsMapLayer) -> None: ...
    @staticmethod
    def layerHasNotes(layer: QgsMapLayer) -> bool: ...
    @staticmethod
    def setLayerNotes(layer: QgsMapLayer, notes: str) -> None: ...
    @staticmethod
    def layerNotes(layer: QgsMapLayer) -> str: ...


class QgsLegendRenderer(sip.wrapper):

    @overload
    def __init__(self, legendModel: QgsLayerTreeModel, settings: QgsLegendSettings) -> None: ...
    @overload
    def __init__(self, a0: QgsLegendRenderer) -> None: ...

    @staticmethod
    def nodeLegendStyle(node: QgsLayerTreeNode, model: QgsLayerTreeModel) -> QgsLegendStyle.Style: ...
    @staticmethod
    def setNodeLegendStyle(node: QgsLayerTreeNode, style: QgsLegendStyle.Style) -> None: ...
    def exportLegendToJson(self, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    @overload
    def drawLegend(self, painter: QtGui.QPainter) -> None: ...
    @overload
    def drawLegend(self, context: QgsRenderContext) -> None: ...
    def legendSize(self) -> QtCore.QSizeF: ...
    def setLegendSize(self, s: QtCore.QSizeF) -> None: ...
    def minimumSize(self, renderContext: Optional[QgsRenderContext] = ...) -> QtCore.QSizeF: ...


class QgsLegendSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLegendSettings) -> None: ...

    def fontDescentMillimeters(self, font: QtGui.QFont) -> float: ...
    def fontAscentMillimeters(self, font: QtGui.QFont) -> float: ...
    def fontHeightCharacterMM(self, font: QtGui.QFont, c: str) -> float: ...
    def textWidthMillimeters(self, font: QtGui.QFont, text: str) -> float: ...
    def pixelFontSize(self, pointSize: float) -> float: ...
    def scaledFontPixelSize(self, font: QtGui.QFont) -> QtGui.QFont: ...
    @overload
    def drawText(self, p: QtGui.QPainter, x: float, y: float, text: str, font: QtGui.QFont) -> None: ...
    @overload
    def drawText(self, p: QtGui.QPainter, rect: QtCore.QRectF, text: str, font: QtGui.QFont, halignment: QtCore.Qt.AlignmentFlag = ..., valignment: QtCore.Qt.AlignmentFlag = ..., flags: int = ...) -> None: ...
    def splitStringForWrapping(self, stringToSplt: str) -> List[str]: ...
    def evaluateItemText(self, text: str, context: QgsExpressionContext) -> List[str]: ...
    def setDpi(self, dpi: int) -> None: ...
    def dpi(self) -> int: ...
    def setMapUnitsPerPixel(self, mapUnitsPerPixel: float) -> None: ...
    def mapUnitsPerPixel(self) -> float: ...
    def setMapScale(self, scale: float) -> None: ...
    def mapScale(self) -> float: ...
    def setUseAdvancedEffects(self, use: bool) -> None: ...
    def useAdvancedEffects(self) -> bool: ...
    def setMmPerMapUnit(self, mmPerMapUnit: float) -> None: ...
    def mmPerMapUnit(self) -> float: ...
    def setLineSpacing(self, s: float) -> None: ...
    def lineSpacing(self) -> float: ...
    def setWmsLegendSize(self, s: QtCore.QSizeF) -> None: ...
    def wmsLegendSize(self) -> QtCore.QSizeF: ...
    def setRasterStrokeWidth(self, width: float) -> None: ...
    def rasterStrokeWidth(self) -> float: ...
    def setRasterStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def rasterStrokeColor(self) -> QtGui.QColor: ...
    def setDrawRasterStroke(self, enabled: bool) -> None: ...
    def drawRasterStroke(self) -> bool: ...
    def symbolAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setSymbolAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def setMinimumSymbolSize(self, size: float) -> None: ...
    def minimumSymbolSize(self) -> float: ...
    def setMaximumSymbolSize(self, size: float) -> None: ...
    def maximumSymbolSize(self) -> float: ...
    def setSymbolSize(self, s: QtCore.QSizeF) -> None: ...
    def symbolSize(self) -> QtCore.QSizeF: ...
    def setLayerFontColor(self, fontColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def layerFontColor(self) -> QtGui.QColor: ...
    def setFontColor(self, c: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fontColor(self) -> QtGui.QColor: ...
    def setEqualColumnWidth(self, s: bool) -> None: ...
    def equalColumnWidth(self) -> bool: ...
    def setSplitLayer(self, s: bool) -> None: ...
    def splitLayer(self) -> bool: ...
    def setColumnCount(self, c: int) -> None: ...
    def columnCount(self) -> int: ...
    def setColumnSpace(self, s: float) -> None: ...
    def columnSpace(self) -> float: ...
    def wrapChar(self) -> str: ...
    def setWrapChar(self, t: str) -> None: ...
    def setBoxSpace(self, s: float) -> None: ...
    def boxSpace(self) -> float: ...
    def setStyle(self, s: QgsLegendStyle.Style, style: QgsLegendStyle) -> None: ...
    def style(self, s: QgsLegendStyle.Style) -> QgsLegendStyle: ...
    def setTitleAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def titleAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def title(self) -> str: ...
    def setTitle(self, t: str) -> None: ...


class QgsLegendStyle(sip.wrapper):

    class Side(int):
        ...
    Top: QgsLegendStyle.Side = ...
    Bottom: QgsLegendStyle.Side = ...
    Left: QgsLegendStyle.Side = ...
    Right: QgsLegendStyle.Side = ...

    class Style(int):
        ...
    Undefined: QgsLegendStyle.Style = ...
    Hidden: QgsLegendStyle.Style = ...
    Title: QgsLegendStyle.Style = ...
    Group: QgsLegendStyle.Style = ...
    Subgroup: QgsLegendStyle.Style = ...
    Symbol: QgsLegendStyle.Style = ...
    SymbolLabel: QgsLegendStyle.Style = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLegendStyle) -> None: ...

    @staticmethod
    def styleLabel(s: QgsLegendStyle.Style) -> str: ...
    @staticmethod
    def styleFromName(styleName: str) -> QgsLegendStyle.Style: ...
    @staticmethod
    def styleName(s: QgsLegendStyle.Style) -> str: ...
    def readXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, name: str, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ...) -> None: ...
    def setAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    @overload
    def setMargin(self, side: QgsLegendStyle.Side, margin: float) -> None: ...
    @overload
    def setMargin(self, margin: float) -> None: ...
    def margin(self, side: QgsLegendStyle.Side) -> float: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...


class QgsLocalDefaultSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLocalDefaultSettings) -> None: ...

    @staticmethod
    def bearingFormat() -> QgsBearingNumericFormat: ...
    @staticmethod
    def setBearingFormat(format: QgsBearingNumericFormat) -> None: ...


class QgsLocalizedDataPathRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def unregisterPath(self, path: str) -> None: ...
    def registerPath(self, path: str, position: int = ...) -> None: ...
    def paths(self) -> List[str]: ...
    def localizedPath(self, globalPath: str) -> str: ...
    def globalPath(self, localizedPath: str) -> str: ...


class QgsLogger(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLogger) -> None: ...

    @staticmethod
    def logFile() -> str: ...
    @staticmethod
    def logMessageToFile(message: str) -> None: ...
    @staticmethod
    def debugLevel() -> int: ...
    @staticmethod
    def fatal(msg: str) -> None: ...
    @staticmethod
    def critical(msg: str) -> None: ...
    @staticmethod
    def warning(msg: str) -> None: ...
    @overload
    @staticmethod
    def debug(msg: str, debuglevel: int = ..., file: Optional[str] = ..., function: Optional[str] = ..., line: int = ...) -> None: ...
    @overload
    @staticmethod
    def debug(var: str, val: int, debuglevel: int = ..., file: Optional[str] = ..., function: Optional[str] = ..., line: int = ...) -> None: ...


class QgsScopeLogger(sip.wrapper):

    @overload
    def __init__(self, file: str, func: str, line: int) -> None: ...
    @overload
    def __init__(self, a0: QgsScopeLogger) -> None: ...


class QgsMapClippingRegion(sip.wrapper):

    class FeatureClippingType(int):
        ...
    ClipToIntersection: QgsMapClippingRegion.FeatureClippingType = ...
    ClipPainterOnly: QgsMapClippingRegion.FeatureClippingType = ...
    NoClipping: QgsMapClippingRegion.FeatureClippingType = ...

    @overload
    def __init__(self, geometry: QgsGeometry) -> None: ...
    @overload
    def __init__(self, a0: QgsMapClippingRegion) -> None: ...

    def appliesToLayer(self, layer: QgsMapLayer) -> bool: ...
    def restrictedLayers(self) -> List[QgsMapLayer]: ...
    def setRestrictedLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def setRestrictToLayers(self, enabled: bool) -> None: ...
    def restrictToLayers(self) -> bool: ...
    def setFeatureClip(self, type: QgsMapClippingRegion.FeatureClippingType) -> None: ...
    def featureClip(self) -> QgsMapClippingRegion.FeatureClippingType: ...
    def setGeometry(self, geometry: QgsGeometry) -> None: ...
    def geometry(self) -> QgsGeometry: ...


class QgsMapClippingUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapClippingUtils) -> None: ...

    @staticmethod
    def calculateLabelIntersectionGeometry(regions: Iterable[QgsMapClippingRegion], context: QgsRenderContext) -> Tuple[QgsGeometry, bool]: ...
    @staticmethod
    def calculatePainterClipRegion(regions: Iterable[QgsMapClippingRegion], context: QgsRenderContext, layerType: QgsMapLayerType) -> Tuple[QtGui.QPainterPath, bool]: ...
    @staticmethod
    def calculateFeatureIntersectionGeometry(regions: Iterable[QgsMapClippingRegion], context: QgsRenderContext) -> Tuple[QgsGeometry, bool]: ...
    @staticmethod
    def calculateFeatureRequestGeometry(regions: Iterable[QgsMapClippingRegion], context: QgsRenderContext) -> Tuple[QgsGeometry, bool]: ...
    @staticmethod
    def collectClippingRegionsForLayer(context: QgsRenderContext, layer: QgsMapLayer) -> List[QgsMapClippingRegion]: ...


class QgsMapDecoration(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapDecoration) -> None: ...

    def setDisplayName(self, name: str) -> None: ...
    def displayName(self) -> str: ...
    def render(self, mapSettings: QgsMapSettings, context: QgsRenderContext) -> None: ...


class QgsMapHitTest(sip.wrapper):

    @overload
    def __init__(self, settings: QgsMapSettings, polygon: QgsGeometry = ..., layerFilterExpression: Dict[str, str] = ...) -> None: ...
    @overload
    def __init__(self, settings: QgsMapSettings, layerFilterExpression: Dict[str, str]) -> None: ...
    @overload
    def __init__(self, a0: QgsMapHitTest) -> None: ...

    def legendKeyVisible(self, ruleKey: str, layer: QgsVectorLayer) -> bool: ...
    def symbolVisible(self, symbol: QgsSymbol, layer: QgsVectorLayer) -> bool: ...
    def run(self) -> None: ...


class QgsMapLayerDependency(sip.wrapper):

    class Origin(int):
        ...
    FromProvider: QgsMapLayerDependency.Origin = ...
    FromUser: QgsMapLayerDependency.Origin = ...

    class Type(int):
        ...
    PresenceDependency: QgsMapLayerDependency.Type = ...
    DataDependency: QgsMapLayerDependency.Type = ...

    @overload
    def __init__(self, layerId: str, type: QgsMapLayerDependency.Type = ..., origin: QgsMapLayerDependency.Origin = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerDependency) -> None: ...

    def __hash__(self) -> int: ...
    def layerId(self) -> str: ...
    def origin(self) -> QgsMapLayerDependency.Origin: ...
    def type(self) -> QgsMapLayerDependency.Type: ...


class QgsMapLayerFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerFactory) -> None: ...

    @staticmethod
    def typeToString(type: QgsMapLayerType) -> str: ...
    @staticmethod
    def typeFromString(string: str) -> Tuple[QgsMapLayerType, bool]: ...


class QgsMapLayerLegend(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def itemsChanged(self) -> None: ...
    @staticmethod
    def defaultPointCloudLegend(layer: QgsPointCloudLayer) -> QgsMapLayerLegend: ...
    @staticmethod
    def defaultMeshLegend(ml: QgsMeshLayer) -> QgsMapLayerLegend: ...
    @staticmethod
    def defaultRasterLegend(rl: QgsRasterLayer) -> QgsMapLayerLegend: ...
    @staticmethod
    def defaultVectorLegend(vl: QgsVectorLayer) -> QgsMapLayerLegend: ...
    def createLayerTreeModelLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...


class QgsMapLayerLegendUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerLegendUtils) -> None: ...

    @staticmethod
    def applyLayerNodeProperties(nodeLayer: QgsLayerTreeLayer, nodes: Iterable[QgsLayerTreeModelLegendNode]) -> None: ...
    @staticmethod
    def legendNodeColumnBreak(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> bool: ...
    @staticmethod
    def setLegendNodeColumnBreak(nodeLayer: QgsLayerTreeLayer, originalIndex: int, columnBreakBeforeNode: bool) -> None: ...
    @staticmethod
    def legendNodeColorRampSettings(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> QgsColorRampLegendNodeSettings: ...
    @staticmethod
    def setLegendNodeColorRampSettings(nodeLayer: QgsLayerTreeLayer, originalIndex: int, settings: QgsColorRampLegendNodeSettings) -> None: ...
    @staticmethod
    def legendNodeCustomSymbol(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> QgsSymbol: ...
    @staticmethod
    def setLegendNodeCustomSymbol(nodeLayer: QgsLayerTreeLayer, originalIndex: int, symbol: QgsSymbol) -> None: ...
    @staticmethod
    def legendNodeSymbolSize(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> QtCore.QSizeF: ...
    @staticmethod
    def setLegendNodeSymbolSize(nodeLayer: QgsLayerTreeLayer, originalIndex: int, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def legendNodePatchShape(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> QgsLegendPatchShape: ...
    @staticmethod
    def setLegendNodePatchShape(nodeLayer: QgsLayerTreeLayer, originalIndex: int, shape: QgsLegendPatchShape) -> None: ...
    @staticmethod
    def hasLegendNodeUserLabel(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> bool: ...
    @staticmethod
    def legendNodeUserLabel(nodeLayer: QgsLayerTreeLayer, originalIndex: int) -> str: ...
    @staticmethod
    def setLegendNodeUserLabel(nodeLayer: QgsLayerTreeLayer, originalIndex: int, newLabel: str) -> None: ...
    @staticmethod
    def hasLegendNodeOrder(nodeLayer: QgsLayerTreeLayer) -> bool: ...
    @staticmethod
    def legendNodeOrder(nodeLayer: QgsLayerTreeLayer) -> List[int]: ...
    @staticmethod
    def setLegendNodeOrder(nodeLayer: QgsLayerTreeLayer, order: Iterable[int]) -> None: ...


class QgsDefaultVectorLayerLegend(QgsMapLayerLegend):

    def __init__(self, vl: QgsVectorLayer) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def createLayerTreeModelLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def setTextOnSymbolContent(self, content: Dict[str, str]) -> None: ...
    def textOnSymbolContent(self) -> Dict[str, str]: ...
    def setTextOnSymbolTextFormat(self, format: QgsTextFormat) -> None: ...
    def textOnSymbolTextFormat(self) -> QgsTextFormat: ...
    def setShowLabelLegend(self, enabled: bool) -> None: ...
    def showLabelLegend(self) -> bool: ...
    def setTextOnSymbolEnabled(self, enabled: bool) -> None: ...
    def textOnSymbolEnabled(self) -> bool: ...


class QgsDefaultRasterLayerLegend(QgsMapLayerLegend):

    def __init__(self, rl: QgsRasterLayer) -> None: ...

    def createLayerTreeModelLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...


class QgsDefaultMeshLayerLegend(QgsMapLayerLegend):

    def __init__(self, ml: QgsMeshLayer) -> None: ...

    def createLayerTreeModelLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...


class QgsDefaultPointCloudLayerLegend(QgsMapLayerLegend):

    def __init__(self, layer: QgsPointCloudLayer) -> None: ...

    def createLayerTreeModelLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...


class QgsMapLayerModel(QtCore.QAbstractItemModel):

    class ItemDataRole(int):
        ...
    LayerIdRole: QgsMapLayerModel.ItemDataRole = ...
    LayerRole: QgsMapLayerModel.ItemDataRole = ...
    EmptyRole: QgsMapLayerModel.ItemDataRole = ...
    AdditionalRole: QgsMapLayerModel.ItemDataRole = ...

    @overload
    def __init__(self, parent: Optional[QtCore.QObject] = ..., project: Optional[QgsProject] = ...) -> None: ...
    @overload
    def __init__(self, layers: Iterable[QgsMapLayer], parent: Optional[QtCore.QObject] = ..., project: Optional[QgsProject] = ...) -> None: ...

    def addLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def removeLayers(self, layerIds: Iterable[str]) -> None: ...
    @staticmethod
    def iconForLayer(layer: QgsMapLayer) -> QtGui.QIcon: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def canDropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeTypes(self) -> List[str]: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def insertRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def additionalItems(self) -> List[str]: ...
    def setAdditionalItems(self, items: Iterable[str]) -> None: ...
    def layerFromIndex(self, index: QtCore.QModelIndex) -> QgsMapLayer: ...
    def indexFromLayer(self, layer: QgsMapLayer) -> QtCore.QModelIndex: ...
    def itemsCheckable(self) -> bool: ...
    def setLayersChecked(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def layersChecked(self, checkState: QtCore.Qt.CheckState = ...) -> List[QgsMapLayer]: ...
    def showCrs(self) -> bool: ...
    def setShowCrs(self, showCrs: bool) -> None: ...
    def allowEmptyLayer(self) -> bool: ...
    def setAllowEmptyLayer(self, allowEmpty: bool, text: str = ..., icon: QtGui.QIcon = ...) -> None: ...
    def checkAll(self, checkState: QtCore.Qt.CheckState) -> None: ...
    def itemsCanBeReordered(self) -> bool: ...
    def setItemsCanBeReordered(self, allow: bool) -> None: ...
    def setItemsCheckable(self, checkable: bool) -> None: ...


class QgsMapLayerProxyModel(QtCore.QSortFilterProxyModel):

    class Filter(int):
        ...
    RasterLayer: QgsMapLayerProxyModel.Filter = ...
    NoGeometry: QgsMapLayerProxyModel.Filter = ...
    PointLayer: QgsMapLayerProxyModel.Filter = ...
    LineLayer: QgsMapLayerProxyModel.Filter = ...
    PolygonLayer: QgsMapLayerProxyModel.Filter = ...
    HasGeometry: QgsMapLayerProxyModel.Filter = ...
    VectorLayer: QgsMapLayerProxyModel.Filter = ...
    PluginLayer: QgsMapLayerProxyModel.Filter = ...
    WritableLayer: QgsMapLayerProxyModel.Filter = ...
    MeshLayer: QgsMapLayerProxyModel.Filter = ...
    VectorTileLayer: QgsMapLayerProxyModel.Filter = ...
    PointCloudLayer: QgsMapLayerProxyModel.Filter = ...
    All: QgsMapLayerProxyModel.Filter = ...

    class Filters(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapLayerProxyModel.Filters, QgsMapLayerProxyModel.Filter]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayerProxyModel.Filters) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapLayerProxyModel.Filters: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setFilterString(self, filter: str) -> None: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def acceptsLayer(self, layer: QgsMapLayer) -> bool: ...
    def filterString(self) -> str: ...
    def excludedProviders(self) -> List[str]: ...
    def setExcludedProviders(self, providers: Iterable[str]) -> None: ...
    def exceptedLayerIds(self) -> List[str]: ...
    def setExceptedLayerIds(self, ids: Iterable[str]) -> None: ...
    def exceptedLayerList(self) -> List[QgsMapLayer]: ...
    def setExceptedLayerList(self, exceptList: Iterable[QgsMapLayer]) -> None: ...
    def layerAllowlist(self) -> List[QgsMapLayer]: ...
    def layerWhitelist(self) -> List[QgsMapLayer]: ...
    def setLayerAllowlist(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def setLayerWhitelist(self, layers: Iterable[QgsMapLayer]) -> None: ...
    @staticmethod
    def layerMatchesFilters(layer: QgsMapLayer, filters: Union[QgsMapLayerProxyModel.Filters, QgsMapLayerProxyModel.Filter]) -> bool: ...
    def filters(self) -> QgsMapLayerProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsMapLayerProxyModel.Filters, QgsMapLayerProxyModel.Filter]) -> QgsMapLayerProxyModel: ...
    def sourceLayerModel(self) -> QgsMapLayerModel: ...


class QgsMapLayerRenderer(sip.wrapper):

    @overload
    def __init__(self, layerID: str, context: Optional[QgsRenderContext] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerRenderer) -> None: ...

    def isReadyToCompose(self) -> bool: ...
    def renderContext(self) -> QgsRenderContext: ...
    def layerId(self) -> str: ...
    def errors(self) -> List[str]: ...
    def feedback(self) -> QgsFeedback: ...
    def forceRasterRender(self) -> bool: ...
    def render(self) -> bool: ...


class QgsMapLayerStore(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def layerWasAdded(self, layer: QgsMapLayer) -> None: ...
    def layersAdded(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def allLayersRemoved(self) -> None: ...
    def layerRemoved(self, layerId: str) -> None: ...
    def layersRemoved(self, layerIds: Iterable[str]) -> None: ...
    @overload
    def layerWillBeRemoved(self, layerId: str) -> None: ...
    @overload
    def layerWillBeRemoved(self, layer: QgsMapLayer) -> None: ...
    @overload
    def layersWillBeRemoved(self, layerIds: Iterable[str]) -> None: ...
    @overload
    def layersWillBeRemoved(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def transferLayersFromStore(self, other: QgsMapLayerStore) -> None: ...
    def removeAllMapLayers(self) -> None: ...
    def takeMapLayer(self, layer: QgsMapLayer) -> QgsMapLayer: ...
    @overload
    def removeMapLayer(self, id: str) -> None: ...
    @overload
    def removeMapLayer(self, layer: QgsMapLayer) -> None: ...
    def removeMapLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def removeMapLayersById(self, layerIds: Iterable[str]) -> None: ...
    def addMapLayer(self, layer: QgsMapLayer) -> QgsMapLayer: ...
    def addMapLayers(self, layers: Iterable[QgsMapLayer]) -> List[QgsMapLayer]: ...
    def validMapLayers(self) -> typing.Any: ...
    def mapLayers(self) -> typing.Any: ...
    def mapLayersByName(self, name: str) -> List[QgsMapLayer]: ...
    def mapLayer(self, id: str) -> QgsMapLayer: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def validCount(self) -> int: ...
    def count(self) -> int: ...


class QgsMapLayerStyle(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xmlData: str) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerStyle) -> None: ...

    def writeXml(self, styleElement: QtXml.QDomElement) -> None: ...
    def readXml(self, styleElement: QtXml.QDomElement) -> None: ...
    def writeToLayer(self, layer: QgsMapLayer) -> None: ...
    def readFromLayer(self, layer: QgsMapLayer) -> None: ...
    def xmlData(self) -> str: ...
    def clear(self) -> None: ...
    def isValid(self) -> bool: ...


class QgsMapLayerStyleOverride(sip.wrapper):

    @overload
    def __init__(self, layer: QgsMapLayer) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerStyleOverride) -> None: ...

    def setOverrideStyle(self, style: str) -> None: ...


class QgsMapLayerStyleManager(QtCore.QObject):

    def __init__(self, layer: QgsMapLayer) -> None: ...

    def currentStyleChanged(self, currentName: str) -> None: ...
    def styleRenamed(self, oldName: str, newName: str) -> None: ...
    def styleRemoved(self, name: str) -> None: ...
    def styleAdded(self, name: str) -> None: ...
    def copyStylesFrom(self, other: QgsMapLayerStyleManager) -> None: ...
    def isDefault(self, styleName: str) -> bool: ...
    def restoreOverrideStyle(self) -> bool: ...
    def setOverrideStyle(self, styleDef: str) -> bool: ...
    def setCurrentStyle(self, name: str) -> bool: ...
    def currentStyle(self) -> str: ...
    def renameStyle(self, name: str, newName: str) -> bool: ...
    def removeStyle(self, name: str) -> bool: ...
    def addStyleFromLayer(self, name: str) -> bool: ...
    def addStyle(self, name: str, style: QgsMapLayerStyle) -> bool: ...
    def style(self, name: str) -> QgsMapLayerStyle: ...
    def mapLayerStyles(self) -> Dict[str, QgsMapLayerStyle]: ...
    def styles(self) -> List[str]: ...
    def writeXml(self, mgrElement: QtXml.QDomElement) -> None: ...
    def readXml(self, mgrElement: QtXml.QDomElement) -> None: ...
    def reset(self) -> None: ...
    def layer(self) -> QgsMapLayer: ...


class QgsMapLayerElevationProperties(QtCore.QObject):

    class Flag(int):
        ...
    FlagDontInvalidateCachedRendersWhenRangeChanges: QgsMapLayerElevationProperties.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapLayerElevationProperties.Flags, QgsMapLayerElevationProperties.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapLayerElevationProperties.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapLayerElevationProperties.Flags: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def changed(self) -> None: ...
    def calculateZRange(self, layer: QgsMapLayer) -> QgsDoubleRange: ...
    def flags(self) -> QgsMapLayerElevationProperties.Flags: ...
    def isVisibleInZRange(self, range: QgsDoubleRange) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def hasElevation(self) -> bool: ...


class QgsTemporalProperty(QtCore.QObject):

    class Flag(int):
        ...
    FlagDontInvalidateCachedRendersWhenRangeChanges: QgsTemporalProperty.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsTemporalProperty.Flags, QgsTemporalProperty.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsTemporalProperty.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsTemporalProperty.Flags: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ..., enabled: bool = ...) -> None: ...

    def changed(self) -> None: ...
    def flags(self) -> QgsTemporalProperty.Flags: ...
    def isActive(self) -> bool: ...
    def setIsActive(self, active: bool) -> None: ...


class QgsMapLayerTemporalProperties(QgsTemporalProperty):

    def __init__(self, parent: QtCore.QObject, enabled: bool = ...) -> None: ...

    def allTemporalRanges(self, layer: QgsMapLayer) -> List[QgsDateTimeRange]: ...
    def setDefaultsFromDataProviderTemporalCapabilities(self, capabilities: QgsDataProviderTemporalCapabilities) -> None: ...
    def isVisibleInTemporalRange(self, range: QgsDateTimeRange) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...


class QgsMapLayerUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapLayerUtils) -> None: ...

    @staticmethod
    def combinedExtent(layers: Iterable[QgsMapLayer], crs: QgsCoordinateReferenceSystem, transformContext: QgsCoordinateTransformContext) -> QgsRectangle: ...


class QgsLabelBlockingRegion(sip.wrapper):

    geometry: QgsGeometry = ...

    @overload
    def __init__(self, geometry: QgsGeometry) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelBlockingRegion) -> None: ...


class QgsTemporalRangeObject(sip.wrapper):

    @overload
    def __init__(self, enabled: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsTemporalRangeObject) -> None: ...

    def temporalRange(self) -> QgsDateTimeRange: ...
    def setTemporalRange(self, range: QgsDateTimeRange) -> None: ...
    def isTemporal(self) -> bool: ...
    def setIsTemporal(self, enabled: bool) -> None: ...


class QgsMapSettings(QgsTemporalRangeObject):

    class Flag(int):
        ...
    Antialiasing: QgsMapSettings.Flag = ...
    DrawEditingInfo: QgsMapSettings.Flag = ...
    ForceVectorOutput: QgsMapSettings.Flag = ...
    UseAdvancedEffects: QgsMapSettings.Flag = ...
    DrawLabeling: QgsMapSettings.Flag = ...
    UseRenderingOptimization: QgsMapSettings.Flag = ...
    DrawSelection: QgsMapSettings.Flag = ...
    DrawSymbolBounds: QgsMapSettings.Flag = ...
    RenderMapTile: QgsMapSettings.Flag = ...
    RenderPartialOutput: QgsMapSettings.Flag = ...
    RenderPreviewJob: QgsMapSettings.Flag = ...
    RenderBlocking: QgsMapSettings.Flag = ...
    LosslessImageRendering: QgsMapSettings.Flag = ...
    Render3DMap: QgsMapSettings.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapSettings.Flags, QgsMapSettings.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapSettings.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapSettings.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapSettings) -> None: ...

    def updateDerived(self) -> None: ...
    def setZRange(self, range: QgsDoubleRange) -> None: ...
    def zRange(self) -> QgsDoubleRange: ...
    def renderedFeatureHandlers(self) -> List[QgsRenderedFeatureHandlerInterface]: ...
    def addRenderedFeatureHandler(self, handler: QgsRenderedFeatureHandlerInterface) -> None: ...
    def simplifyMethod(self) -> QgsVectorSimplifyMethod: ...
    def setSimplifyMethod(self, method: QgsVectorSimplifyMethod) -> None: ...
    def clippingRegions(self) -> List[QgsMapClippingRegion]: ...
    def setClippingRegions(self, regions: Iterable[QgsMapClippingRegion]) -> None: ...
    def addClippingRegion(self, region: QgsMapClippingRegion) -> None: ...
    def labelBlockingRegions(self) -> List[QgsLabelBlockingRegion]: ...
    def setLabelBlockingRegions(self, regions: Iterable[QgsLabelBlockingRegion]) -> None: ...
    def setLabelBoundaryGeometry(self, boundary: QgsGeometry) -> None: ...
    def labelBoundaryGeometry(self) -> QgsGeometry: ...
    def labelingEngineSettings(self) -> QgsLabelingEngineSettings: ...
    def setLabelingEngineSettings(self, settings: QgsLabelingEngineSettings) -> None: ...
    def segmentationToleranceType(self) -> QgsAbstractGeometry.SegmentationToleranceType: ...
    def setSegmentationToleranceType(self, type: QgsAbstractGeometry.SegmentationToleranceType) -> None: ...
    def segmentationTolerance(self) -> float: ...
    def setSegmentationTolerance(self, tolerance: float) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, node: QtXml.QDomNode) -> None: ...
    def fullExtent(self) -> QgsRectangle: ...
    def layerTransform(self, layer: QgsMapLayer) -> QgsCoordinateTransform: ...
    @overload
    def mapToLayerCoordinates(self, layer: QgsMapLayer, point: QgsPointXY) -> QgsPointXY: ...
    @overload
    def mapToLayerCoordinates(self, layer: QgsMapLayer, point: QgsPoint) -> QgsPoint: ...
    @overload
    def mapToLayerCoordinates(self, layer: QgsMapLayer, rect: QgsRectangle) -> QgsRectangle: ...
    @overload
    def layerToMapCoordinates(self, layer: QgsMapLayer, point: QgsPointXY) -> QgsPointXY: ...
    @overload
    def layerToMapCoordinates(self, layer: QgsMapLayer, point: QgsPoint) -> QgsPoint: ...
    @overload
    def layerToMapCoordinates(self, layer: QgsMapLayer, rect: QgsRectangle) -> QgsRectangle: ...
    def outputExtentToLayerExtent(self, layer: QgsMapLayer, extent: QgsRectangle) -> QgsRectangle: ...
    def layerExtentToOutputExtent(self, layer: QgsMapLayer, extent: QgsRectangle) -> QgsRectangle: ...
    def layerToMapUnits(self, layer: QgsMapLayer, referenceExtent: QgsRectangle = ...) -> float: ...
    def mapToPixel(self) -> QgsMapToPixel: ...
    def setPathResolver(self, resolver: QgsPathResolver) -> None: ...
    def pathResolver(self) -> QgsPathResolver: ...
    def setTransformContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def scale(self) -> float: ...
    def mapUnitsPerPixel(self) -> float: ...
    def visiblePolygon(self) -> QtGui.QPolygonF: ...
    def visibleExtent(self) -> QgsRectangle: ...
    def hasValidSettings(self) -> bool: ...
    def outputImageFormat(self) -> QtGui.QImage.Format: ...
    def setOutputImageFormat(self, format: QtGui.QImage.Format) -> None: ...
    def setTextRenderFormat(self, format: QgsRenderContext.TextRenderFormat) -> None: ...
    def textRenderFormat(self) -> QgsRenderContext.TextRenderFormat: ...
    def testFlag(self, flag: QgsMapSettings.Flag) -> bool: ...
    def flags(self) -> QgsMapSettings.Flags: ...
    def setFlag(self, flag: QgsMapSettings.Flag, on: bool = ...) -> None: ...
    def setFlags(self, flags: Union[QgsMapSettings.Flags, QgsMapSettings.Flag]) -> None: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def setSelectionColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def ellipsoid(self) -> str: ...
    def setEllipsoid(self, ellipsoid: str) -> bool: ...
    def mapUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def clearCustomRenderingFlag(self, flag: str) -> None: ...
    def setCustomRenderingFlag(self, flag: str, value: typing.Any) -> None: ...
    def customRenderingFlags(self) -> Dict[str, typing.Any]: ...
    def setCustomRenderFlags(self, customRenderFlags: str) -> None: ...
    def customRenderFlags(self) -> str: ...
    def setLayerStyleOverrides(self, overrides: Dict[str, str]) -> None: ...
    def layerStyleOverrides(self) -> Dict[str, str]: ...
    def setLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def layers(self) -> List[QgsMapLayer]: ...
    def layerIds(self) -> List[str]: ...
    def magnificationFactor(self) -> float: ...
    def setMagnificationFactor(self, factor: float, center: Optional[QgsPointXY] = ...) -> None: ...
    def setDpiTarget(self, dpi: float) -> None: ...
    def dpiTarget(self) -> float: ...
    def setOutputDpi(self, dpi: float) -> None: ...
    def outputDpi(self) -> float: ...
    def setRotation(self, rotation: float) -> None: ...
    def rotation(self) -> float: ...
    def deviceOutputSize(self) -> QtCore.QSize: ...
    def setDevicePixelRatio(self, dpr: float) -> None: ...
    def devicePixelRatio(self) -> float: ...
    def setOutputSize(self, size: QtCore.QSize) -> None: ...
    def outputSize(self) -> QtCore.QSize: ...
    def setExtentBuffer(self, buffer: float) -> None: ...
    def extentBuffer(self) -> float: ...
    def setExtent(self, rect: QgsRectangle, magnified: bool = ...) -> None: ...
    def extent(self) -> QgsRectangle: ...


class QgsMapSettingsUtils(sip.wrapper):

    class EffectsCheckFlag(int):
        ...
    IgnoreGeoPdfSupportedEffects: QgsMapSettingsUtils.EffectsCheckFlag = ...

    class EffectsCheckFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsMapSettingsUtils.EffectsCheckFlags, QgsMapSettingsUtils.EffectsCheckFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsMapSettingsUtils.EffectsCheckFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsMapSettingsUtils.EffectsCheckFlags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapSettingsUtils) -> None: ...

    @staticmethod
    def worldFileContent(mapSettings: QgsMapSettings) -> str: ...
    @staticmethod
    def worldFileParameters(mapSettings: QgsMapSettings) -> Tuple[float, float, float, float, float, float]: ...
    @staticmethod
    def containsAdvancedEffects(mapSettings: QgsMapSettings, flags: Union[QgsMapSettingsUtils.EffectsCheckFlags, QgsMapSettingsUtils.EffectsCheckFlag] = ...) -> List[str]: ...


class QgsMapThemeCollection(QtCore.QObject):

    class MapThemeLayerRecord(sip.wrapper):

        checkedLegendItems: Iterable[str] = ...
        currentStyle: str = ...
        expandedLayerNode: bool = ...
        expandedLegendItems: Iterable[str] = ...
        isVisible: bool = ...
        usingCurrentStyle: bool = ...
        usingLegendItems: bool = ...

        @overload
        def __init__(self, l: Optional[QgsMapLayer] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsMapThemeCollection.MapThemeLayerRecord) -> None: ...

        def setLayer(self, layer: QgsMapLayer) -> None: ...
        def layer(self) -> QgsMapLayer: ...

    class MapThemeRecord(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsMapThemeCollection.MapThemeRecord) -> None: ...

        def setCheckedGroupNodes(self, checkedGroupNodes: Iterable[str]) -> None: ...
        def setExpandedGroupNodes(self, expandedGroupNodes: Iterable[str]) -> None: ...
        def checkedGroupNodes(self) -> Set[str]: ...
        def expandedGroupNodes(self) -> Set[str]: ...
        def setHasExpandedStateInfo(self, hasInfo: bool) -> None: ...
        def hasExpandedStateInfo(self) -> bool: ...
        def addLayerRecord(self, record: QgsMapThemeCollection.MapThemeLayerRecord) -> None: ...
        def removeLayerRecord(self, layer: QgsMapLayer) -> None: ...
        def setLayerRecords(self, records: Iterable[QgsMapThemeCollection.MapThemeLayerRecord]) -> None: ...
        def layerRecords(self) -> List[QgsMapThemeCollection.MapThemeLayerRecord]: ...

    def __init__(self, project: Optional[QgsProject] = ...) -> None: ...

    def projectChanged(self) -> None: ...
    def mapThemeRenamed(self, name: str, newName: str) -> None: ...
    def mapThemeChanged(self, theme: str) -> None: ...
    def mapThemesChanged(self) -> None: ...
    def masterVisibleLayers(self) -> List[QgsMapLayer]: ...
    def masterLayerOrder(self) -> List[QgsMapLayer]: ...
    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...
    def applyTheme(self, name: str, root: QgsLayerTreeGroup, model: QgsLayerTreeModel) -> None: ...
    @staticmethod
    def createThemeFromCurrentState(root: QgsLayerTreeGroup, model: QgsLayerTreeModel) -> QgsMapThemeCollection.MapThemeRecord: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, doc: QtXml.QDomDocument) -> None: ...
    def mapThemeStyleOverrides(self, name: str) -> Dict[str, str]: ...
    def mapThemeVisibleLayers(self, name: str) -> List[QgsMapLayer]: ...
    def mapThemeVisibleLayerIds(self, name: str) -> List[str]: ...
    def mapThemeState(self, name: str) -> QgsMapThemeCollection.MapThemeRecord: ...
    def mapThemes(self) -> List[str]: ...
    def clear(self) -> None: ...
    def renameMapTheme(self, name: str, newName: str) -> bool: ...
    def removeMapTheme(self, name: str) -> None: ...
    def update(self, name: str, state: QgsMapThemeCollection.MapThemeRecord) -> None: ...
    def insert(self, name: str, state: QgsMapThemeCollection.MapThemeRecord) -> None: ...
    def hasMapTheme(self, name: str) -> bool: ...


class QgsMapToPixel(sip.wrapper):

    @overload
    def __init__(self, mapUnitsPerPixel: float, centerX: float, centerY: float, widthPixels: int, heightPixels: int, rotation: float) -> None: ...
    @overload
    def __init__(self, mapUnitsPerPixel: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMapToPixel) -> None: ...

    def yCenter(self) -> float: ...
    def xCenter(self) -> float: ...
    def showParameters(self) -> str: ...
    def setParameters(self, mapUnitsPerPixel: float, centerX: float, centerY: float, widthPixels: int, heightPixels: int, rotation: float) -> None: ...
    def mapRotation(self) -> float: ...
    def setMapRotation(self, degrees: float, cx: float, cy: float) -> None: ...
    def mapHeight(self) -> int: ...
    def mapWidth(self) -> int: ...
    def mapUnitsPerPixel(self) -> float: ...
    def setMapUnitsPerPixel(self, mapUnitsPerPixel: float) -> None: ...
    def toMapPoint(self, x: float, y: float) -> QgsPointXY: ...
    def toMapCoordinatesF(self, x: float, y: float) -> QgsPointXY: ...
    @overload
    def toMapCoordinates(self, x: int, y: int) -> QgsPointXY: ...
    @overload
    def toMapCoordinates(self, p: QtCore.QPoint) -> QgsPointXY: ...
    def transformInPlace(self) -> Tuple[float, float]: ...
    @overload
    def transform(self, p: QgsPointXY) -> QgsPointXY: ...
    @overload
    def transform(self, x: float, y: float) -> QgsPointXY: ...
    @overload
    def transform(self) -> QtGui.QTransform: ...
    @staticmethod
    def fromScale(scale: float, mapUnits: QgsUnitTypes.DistanceUnit, dpi: float = ...) -> QgsMapToPixel: ...


class QgsMapToPixelSimplifier(QgsAbstractGeometrySimplifier):

    class SimplifyFlag(int):
        ...
    NoFlags: QgsMapToPixelSimplifier.SimplifyFlag = ...
    SimplifyGeometry: QgsMapToPixelSimplifier.SimplifyFlag = ...
    SimplifyEnvelope: QgsMapToPixelSimplifier.SimplifyFlag = ...

    class SimplifyAlgorithm(int):
        ...
    Distance: QgsMapToPixelSimplifier.SimplifyAlgorithm = ...
    SnapToGrid: QgsMapToPixelSimplifier.SimplifyAlgorithm = ...
    Visvalingam: QgsMapToPixelSimplifier.SimplifyAlgorithm = ...
    SnappedToGridGlobal: QgsMapToPixelSimplifier.SimplifyAlgorithm = ...

    @overload
    def __init__(self, simplifyFlags: int, tolerance: float, simplifyAlgorithm: QgsMapToPixelSimplifier.SimplifyAlgorithm = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsMapToPixelSimplifier) -> None: ...

    @overload
    @staticmethod
    def isGeneralizableByMapBoundingBox(envelope: QgsRectangle, map2pixelTol: float) -> bool: ...
    @overload
    def isGeneralizableByMapBoundingBox(self, envelope: QgsRectangle) -> bool: ...
    def setTolerance(self, value: float) -> None: ...
    @overload
    def simplify(self, geometry: QgsGeometry) -> QgsGeometry: ...
    @overload
    def simplify(self, geometry: QgsAbstractGeometry) -> QgsAbstractGeometry: ...
    def setSimplifyAlgorithm(self, simplifyAlgorithm: QgsMapToPixelSimplifier.SimplifyAlgorithm) -> None: ...
    def simplifyAlgorithm(self) -> QgsMapToPixelSimplifier.SimplifyAlgorithm: ...
    def setSimplifyFlags(self, simplifyFlags: int) -> None: ...
    def simplifyFlags(self) -> int: ...
    @staticmethod
    def equalSnapToGrid(x1: float, y1: float, x2: float, y2: float, gridOriginX: float, gridOriginY: float, gridInverseSizeXY: float) -> bool: ...
    @staticmethod
    def calculateLengthSquared2D(x1: float, y1: float, x2: float, y2: float) -> float: ...


class QgsMapUnitScale(sip.wrapper):

    maxScale: float = ...
    maxSizeMM: float = ...
    maxSizeMMEnabled: bool = ...
    minScale: float = ...
    minSizeMM: float = ...
    minSizeMMEnabled: bool = ...

    @overload
    def __init__(self, minScale: float = ..., maxScale: float = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsMapUnitScale) -> None: ...

    def computeMapUnitsPerPixel(self, c: QgsRenderContext) -> float: ...


class QgsMargins(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, left: float, top: float, right: float, bottom: float) -> None: ...
    @overload
    def __init__(self, a0: QgsMargins) -> None: ...

    def __pos__(self) -> QgsMargins: ...
    def __neg__(self) -> QgsMargins: ...
    @staticmethod
    def fromString(string: str) -> QgsMargins: ...
    def toString(self) -> str: ...
    def setBottom(self, bottom: float) -> None: ...
    def setRight(self, right: float) -> None: ...
    def setTop(self, top: float) -> None: ...
    def setLeft(self, left: float) -> None: ...
    def bottom(self) -> float: ...
    def right(self) -> float: ...
    def top(self) -> float: ...
    def left(self) -> float: ...
    def isNull(self) -> bool: ...


class QgsMaskIdProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMaskIdProvider) -> None: ...

    def size(self) -> int: ...
    def maskId(self, labelLayerId: str = ..., labelRuleId: str = ...) -> int: ...
    def insertLabelLayer(self, layerId: str, ruleId: str, maskedSymbolLayers: Iterable[QgsSymbolLayerReference]) -> int: ...


class QgsMessageLog(QtCore.QObject):

    def __init__(self) -> None: ...

    @overload
    def messageReceived(self, message: str, tag: str, level: Qgis.MessageLevel) -> None: ...
    @overload
    def messageReceived(self, received: bool) -> None: ...
    @staticmethod
    def logMessage(message: str, tag: str = ..., level: Qgis.MessageLevel = ..., notifyUser: bool = ...) -> None: ...


class QgsMessageLogNotifyBlocker(sip.wrapper):

    def __init__(self) -> None: ...


class QgsMessageLogConsole(QtCore.QObject):

    def __init__(self) -> None: ...

    def logMessage(self, message: str, tag: str, level: Qgis.MessageLevel) -> None: ...
    def formatLogMessage(self, message: str, tag: str, level: Qgis.MessageLevel = ...) -> str: ...


class QgsMessageOutput(sip.wrapper):

    class MessageType(int):
        ...
    MessageText: QgsMessageOutput.MessageType = ...
    MessageHtml: QgsMessageOutput.MessageType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMessageOutput) -> None: ...

    @staticmethod
    def createMessageOutput() -> QgsMessageOutput: ...
    @overload
    def showMessage(self, blocking: bool = ...) -> None: ...
    @overload
    @staticmethod
    def showMessage(title: str, message: str, msgType: QgsMessageOutput.MessageType) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def appendMessage(self, message: str) -> None: ...
    def setMessage(self, message: str, msgType: QgsMessageOutput.MessageType) -> None: ...


class QgsMessageOutputConsole(QtCore.QObject, QgsMessageOutput):

    def __init__(self) -> None: ...

    def destroyed(self) -> None: ...
    def showMessage(self, blocking: bool = ...) -> None: ...
    def setTitle(self, title: str) -> None: ...
    def appendMessage(self, message: str) -> None: ...
    def setMessage(self, message: str, msgType: QgsMessageOutput.MessageType) -> None: ...


class QgsMimeDataUtils(sip.wrapper):

    class Uri(sip.wrapper):

        layerId: str = ...
        layerType: str = ...
        name: str = ...
        pId: str = ...
        providerKey: str = ...
        supportedCrs: Iterable[str] = ...
        supportedFormats: Iterable[str] = ...
        uri: str = ...
        wkbType: QgsWkbTypes.Type = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, encData: str) -> None: ...
        @overload
        def __init__(self, layer: QgsMapLayer) -> None: ...
        @overload
        def __init__(self, a0: QgsMimeDataUtils.Uri) -> None: ...

        def __repr__(self) -> typing.Any: ...
        def mapLayer(self) -> QgsMapLayer: ...
        def meshLayer(self, error: str) -> Tuple[QgsMeshLayer, bool]: ...
        def rasterLayer(self, error: str) -> Tuple[QgsRasterLayer, bool]: ...
        def vectorLayer(self, error: str) -> Tuple[QgsVectorLayer, bool]: ...
        def data(self) -> str: ...
        def isValid(self) -> bool: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMimeDataUtils) -> None: ...

    @staticmethod
    def hasOriginatedFromCurrentAppInstance(uri: QgsMimeDataUtils.Uri) -> bool: ...
    @staticmethod
    def layerTreeNodesToUriList(nodes: Iterable[QgsLayerTreeNode]) -> QtCore.QByteArray: ...
    @staticmethod
    def decodeUriList(data: QtCore.QMimeData) -> List[QgsMimeDataUtils.Uri]: ...
    @staticmethod
    def isUriList(data: QtCore.QMimeData) -> bool: ...
    @staticmethod
    def encodeUriList(layers: Iterable[QgsMimeDataUtils.Uri]) -> QtCore.QMimeData: ...


class QgsMultiRenderChecker(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMultiRenderChecker) -> None: ...

    @staticmethod
    def drawBackground(image: QtGui.QImage) -> None: ...
    def controlImagePath(self) -> str: ...
    def report(self) -> str: ...
    def runTest(self, testName: str, mismatchCount: int = ...) -> bool: ...
    def setSizeTolerance(self, xTolerance: int, yTolerance: int) -> None: ...
    def setColorTolerance(self, colorTolerance: int) -> None: ...
    def setMapSettings(self, mapSettings: QgsMapSettings) -> None: ...
    def setRenderedImage(self, renderedImagePath: str) -> None: ...
    def setControlPathPrefix(self, prefix: str) -> None: ...
    def setControlName(self, name: str) -> None: ...


class QgsObjectCustomProperties(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsObjectCustomProperties) -> None: ...

    def writeXml(self, parentNode: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    def readXml(self, parentNode: QtXml.QDomNode, keyStartsWith: str = ...) -> None: ...
    def contains(self, key: str) -> bool: ...
    def remove(self, key: str) -> None: ...
    def value(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setValue(self, key: str, value: typing.Any) -> None: ...
    def keys(self) -> List[str]: ...


class QgsOfflineEditing(QtCore.QObject):

    class ContainerType(int):
        ...
    SpatiaLite: QgsOfflineEditing.ContainerType = ...
    GPKG: QgsOfflineEditing.ContainerType = ...

    class ProgressMode(int):
        ...
    CopyFeatures: QgsOfflineEditing.ProgressMode = ...
    ProcessFeatures: QgsOfflineEditing.ProgressMode = ...
    AddFields: QgsOfflineEditing.ProgressMode = ...
    AddFeatures: QgsOfflineEditing.ProgressMode = ...
    RemoveFeatures: QgsOfflineEditing.ProgressMode = ...
    UpdateFeatures: QgsOfflineEditing.ProgressMode = ...
    UpdateGeometries: QgsOfflineEditing.ProgressMode = ...

    def __init__(self) -> None: ...

    def warning(self, title: str, message: str) -> None: ...
    def progressStopped(self) -> None: ...
    def progressUpdated(self, progress: int) -> None: ...
    def progressModeSet(self, mode: QgsOfflineEditing.ProgressMode, maximum: int) -> None: ...
    def layerProgressUpdated(self, layer: int, numLayers: int) -> None: ...
    def progressStarted(self) -> None: ...
    def synchronize(self) -> None: ...
    def isOfflineProject(self) -> bool: ...
    def convertToOfflineProject(self, offlineDataPath: str, offlineDbFile: str, layerIds: Iterable[str], onlySelected: bool = ..., containerType: QgsOfflineEditing.ContainerType = ..., layerNameSuffix: str = ...) -> bool: ...


class QgsOgcUtils(sip.wrapper):

    class FilterVersion(int):
        ...
    FILTER_OGC_1_0: QgsOgcUtils.FilterVersion = ...
    FILTER_OGC_1_1: QgsOgcUtils.FilterVersion = ...
    FILTER_FES_2_0: QgsOgcUtils.FilterVersion = ...

    class GMLVersion(int):
        ...
    GML_2_1_2: QgsOgcUtils.GMLVersion = ...
    GML_3_1_0: QgsOgcUtils.GMLVersion = ...
    GML_3_2_1: QgsOgcUtils.GMLVersion = ...

    class Context(sip.wrapper):

        layer: QgsMapLayer = ...
        transformContext: QgsCoordinateTransformContext = ...

        @overload
        def __init__(self, layer: Optional[QgsMapLayer] = ..., transformContext: QgsCoordinateTransformContext = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsOgcUtils.Context) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsOgcUtils) -> None: ...

    @overload
    @staticmethod
    def expressionToOgcExpression(exp: QgsExpression, doc: QtXml.QDomDocument, errorMessage: Optional[str] = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def expressionToOgcExpression(exp: QgsExpression, doc: QtXml.QDomDocument, gmlVersion: QgsOgcUtils.GMLVersion, filterVersion: QgsOgcUtils.FilterVersion, geometryName: str, srsName: str, honourAxisOrientation: bool, invertAxisOrientation: bool, errorMessage: Optional[str] = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def expressionToOgcFilter(exp: QgsExpression, doc: QtXml.QDomDocument, errorMessage: Optional[str] = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def expressionFromOgcFilter(element: QtXml.QDomElement, layer: Optional[QgsVectorLayer] = ...) -> QgsExpression: ...
    @overload
    @staticmethod
    def expressionFromOgcFilter(element: QtXml.QDomElement, version: QgsOgcUtils.FilterVersion, layer: Optional[QgsVectorLayer] = ...) -> QgsExpression: ...
    @staticmethod
    def colorFromOgcFill(fillElement: QtXml.QDomElement) -> QtGui.QColor: ...
    @overload
    @staticmethod
    def rectangleToGMLEnvelope(env: QgsRectangle, doc: QtXml.QDomDocument, precision: int = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def rectangleToGMLEnvelope(env: QgsRectangle, doc: QtXml.QDomDocument, srsName: str, invertAxisOrientation: bool, precision: int = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def rectangleToGMLBox(box: QgsRectangle, doc: QtXml.QDomDocument, precision: int = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def rectangleToGMLBox(box: QgsRectangle, doc: QtXml.QDomDocument, srsName: str, invertAxisOrientation: bool, precision: int = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def geometryToGML(geometry: QgsGeometry, doc: QtXml.QDomDocument, gmlVersion: QgsOgcUtils.GMLVersion, srsName: str, invertAxisOrientation: bool, gmlIdBase: str, precision: int = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def geometryToGML(geometry: QgsGeometry, doc: QtXml.QDomDocument, format: str, precision: int = ...) -> QtXml.QDomElement: ...
    @overload
    @staticmethod
    def geometryToGML(geometry: QgsGeometry, doc: QtXml.QDomDocument, precision: int = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def rectangleFromGMLEnvelope(envelopeNode: QtXml.QDomNode) -> QgsRectangle: ...
    @staticmethod
    def rectangleFromGMLBox(boxNode: QtXml.QDomNode) -> QgsRectangle: ...
    @overload
    @staticmethod
    def geometryFromGML(xmlString: str, context: QgsOgcUtils.Context = ...) -> QgsGeometry: ...
    @overload
    @staticmethod
    def geometryFromGML(geometryNode: QtXml.QDomNode, context: QgsOgcUtils.Context = ...) -> QgsGeometry: ...


class QgsOptionalQgsExpressionBase(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, data: QgsExpression) -> None: ...
    @overload
    def __init__(self, data: QgsExpression, enabled: bool) -> None: ...
    @overload
    def __init__(self, a0: QgsOptionalQgsExpressionBase) -> None: ...

    def setData(self, data: QgsExpression) -> None: ...
    def data(self) -> QgsExpression: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def __int__(self) -> bool: ...


class QgsOptionalExpression(QgsOptionalQgsExpressionBase):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, expression: QgsExpression) -> None: ...
    @overload
    def __init__(self, expression: QgsExpression, enabled: bool) -> None: ...
    @overload
    def __init__(self, a0: QgsOptionalExpression) -> None: ...

    def readXml(self, element: QtXml.QDomElement) -> None: ...
    def writeXml(self, element: QtXml.QDomElement) -> None: ...


class QgsOwsConnection(QtCore.QObject):

    def __init__(self, service: str, connName: str) -> None: ...

    @staticmethod
    def setSelectedConnection(service: str, name: str) -> None: ...
    @staticmethod
    def selectedConnection(service: str) -> str: ...
    @staticmethod
    def deleteConnection(service: str, name: str) -> None: ...
    @staticmethod
    def connectionList(service: str) -> List[str]: ...
    @staticmethod
    def addWfsConnectionSettings(uri: QgsDataSourceUri, settingsKey: str) -> QgsDataSourceUri: ...
    @staticmethod
    def addWmsWcsConnectionSettings(uri: QgsDataSourceUri, settingsKey: str) -> QgsDataSourceUri: ...
    def uri(self) -> QgsDataSourceUri: ...
    def service(self) -> str: ...
    def connectionInfo(self) -> str: ...
    def connectionName(self) -> str: ...


class QgsPaintEngineHack(QtGui.QPaintEngine):

    def __init__(self) -> None: ...

    @staticmethod
    def fixEngineFlags(engine: QtGui.QPaintEngine) -> None: ...
    def fixFlags(self) -> None: ...


class QgsPainting(sip.wrapper):

    class BlendMode(int):
        ...
    BlendNormal: QgsPainting.BlendMode = ...
    BlendLighten: QgsPainting.BlendMode = ...
    BlendScreen: QgsPainting.BlendMode = ...
    BlendDodge: QgsPainting.BlendMode = ...
    BlendAddition: QgsPainting.BlendMode = ...
    BlendDarken: QgsPainting.BlendMode = ...
    BlendMultiply: QgsPainting.BlendMode = ...
    BlendBurn: QgsPainting.BlendMode = ...
    BlendOverlay: QgsPainting.BlendMode = ...
    BlendSoftLight: QgsPainting.BlendMode = ...
    BlendHardLight: QgsPainting.BlendMode = ...
    BlendDifference: QgsPainting.BlendMode = ...
    BlendSubtract: QgsPainting.BlendMode = ...
    BlendSource: QgsPainting.BlendMode = ...
    BlendDestinationOver: QgsPainting.BlendMode = ...
    BlendClear: QgsPainting.BlendMode = ...
    BlendDestination: QgsPainting.BlendMode = ...
    BlendSourceIn: QgsPainting.BlendMode = ...
    BlendDestinationIn: QgsPainting.BlendMode = ...
    BlendSourceOut: QgsPainting.BlendMode = ...
    BlendDestinationOut: QgsPainting.BlendMode = ...
    BlendSourceAtop: QgsPainting.BlendMode = ...
    BlendDestinationAtop: QgsPainting.BlendMode = ...
    BlendXor: QgsPainting.BlendMode = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsPainting) -> None: ...

    @staticmethod
    def getBlendModeEnum(blendMode: QtGui.QPainter.CompositionMode) -> QgsPainting.BlendMode: ...
    @staticmethod
    def getCompositionMode(blendMode: QgsPainting.BlendMode) -> QtGui.QPainter.CompositionMode: ...


class QgsPathResolver(sip.wrapper):

    @overload
    def __init__(self, baseFileName: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPathResolver) -> None: ...

    @staticmethod
    def removePathPreprocessor(id: str) -> None: ...
    @staticmethod
    def setPathPreprocessor(a0: Callable[..., None]) -> str: ...
    def readPath(self, filename: str) -> str: ...
    def writePath(self, filename: str) -> str: ...


class QgsPluginLayer(QgsMapLayer):

    def __init__(self, layerType: str, layerName: str = ...) -> None: ...

    def dataProvider(self) -> QgsDataProvider: ...
    def setSource(self, source: str) -> None: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def pluginLayerType(self) -> str: ...
    def clone(self) -> QgsPluginLayer: ...
    def __repr__(self) -> typing.Any: ...


class QgsPluginLayerType(sip.wrapper):

    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, a0: QgsPluginLayerType) -> None: ...

    def showLayerProperties(self, layer: QgsPluginLayer) -> bool: ...
    @overload
    def createLayer(self) -> QgsPluginLayer: ...
    @overload
    def createLayer(self, uri: str) -> QgsPluginLayer: ...
    def name(self) -> str: ...


class QgsPluginLayerRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def createLayer(self, typeName: str, uri: str = ...) -> QgsPluginLayer: ...
    def pluginLayerType(self, typeName: str) -> QgsPluginLayerType: ...
    def removePluginLayerType(self, typeName: str) -> bool: ...
    def addPluginLayerType(self, pluginLayerType: QgsPluginLayerType) -> bool: ...
    def pluginLayerTypes(self) -> List[str]: ...


class QgsPointLocator(QtCore.QObject):

    class Type(int):
        ...
    Invalid: QgsPointLocator.Type = ...
    Vertex: QgsPointLocator.Type = ...
    Edge: QgsPointLocator.Type = ...
    Area: QgsPointLocator.Type = ...
    Centroid: QgsPointLocator.Type = ...
    MiddleOfSegment: QgsPointLocator.Type = ...
    LineEndpoint: QgsPointLocator.Type = ...
    All: QgsPointLocator.Type = ...

    class Types(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsPointLocator.Types, QgsPointLocator.Type]) -> None: ...
        @overload
        def __init__(self, a0: QgsPointLocator.Types) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsPointLocator.Types: ...
        def __int__(self) -> int: ...

    class Match(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, t: QgsPointLocator.Type, vl: QgsVectorLayer, fid: int, dist: float, pt: QgsPointXY, vertexIndex: int = ..., edgePoints: Optional[QgsPointXY] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsPointLocator.Match) -> None: ...

        def interpolatedPoint(self) -> QgsPoint: ...
        def edgePoints(self) -> Tuple[QgsPointXY, QgsPointXY]: ...
        def featureId(self) -> int: ...
        def layer(self) -> QgsVectorLayer: ...
        def vertexIndex(self) -> int: ...
        def point(self) -> QgsPointXY: ...
        def distance(self) -> float: ...
        def hasLineEndpoint(self) -> bool: ...
        def hasMiddleSegment(self) -> bool: ...
        def hasArea(self) -> bool: ...
        def hasCentroid(self) -> bool: ...
        def hasEdge(self) -> bool: ...
        def hasVertex(self) -> bool: ...
        def isValid(self) -> bool: ...
        def type(self) -> QgsPointLocator.Type: ...

    class MatchFilter(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsPointLocator.MatchFilter) -> None: ...

        def acceptMatch(self, match: QgsPointLocator.Match) -> bool: ...

    def __init__(self, layer: QgsVectorLayer, destinationCrs: QgsCoordinateReferenceSystem = ..., transformContext: QgsCoordinateTransformContext = ..., extent: Optional[QgsRectangle] = ...) -> None: ...

    def destroyIndex(self) -> None: ...
    def rebuildIndex(self, maxFeaturesToIndex: int = ...) -> bool: ...
    def initFinished(self, ok: bool) -> None: ...
    def waitForIndexingFinished(self) -> None: ...
    def isIndexing(self) -> bool: ...
    def cachedGeometryCount(self) -> int: ...
    def pointInPolygon(self, point: QgsPointXY, relaxed: bool = ...) -> List[QgsPointLocator.Match]: ...
    @overload
    def verticesInRect(self, rect: QgsRectangle, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> List[QgsPointLocator.Match]: ...
    @overload
    def verticesInRect(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> List[QgsPointLocator.Match]: ...
    @overload
    def edgesInRect(self, rect: QgsRectangle, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> List[QgsPointLocator.Match]: ...
    @overload
    def edgesInRect(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> List[QgsPointLocator.Match]: ...
    def nearestArea(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def nearestEdge(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def nearestLineEndpoints(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def nearestMiddleOfSegment(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def nearestCentroid(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def nearestVertex(self, point: QgsPointXY, tolerance: float, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def hasIndex(self) -> bool: ...
    def init(self, maxFeaturesToIndex: int = ..., relaxed: bool = ...) -> bool: ...
    def setRenderContext(self, context: QgsRenderContext) -> None: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def extent(self) -> QgsRectangle: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def layer(self) -> QgsVectorLayer: ...


class QgsPointXY(sip.wrapper):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p: QgsPointXY) -> None: ...
    @overload
    def __init__(self, x: float, y: float) -> None: ...
    @overload
    def __init__(self, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    @overload
    def __init__(self, point: QgsPoint) -> None: ...

    def __hash__(self) -> int: ...
    def __getitem__(self, a0: int) -> typing.Any: ...
    def __len__(self) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def multiply(self, scalar: float) -> None: ...
    def compare(self, other: QgsPointXY, epsilon: float = ...) -> bool: ...
    def isEmpty(self) -> bool: ...
    def project(self, distance: float, bearing: float) -> QgsPointXY: ...
    def azimuth(self, other: QgsPointXY) -> float: ...
    def sqrDistToSegment(self, x1: float, y1: float, x2: float, y2: float, epsilon: float = ...) -> Tuple[float, QgsPointXY]: ...
    @overload
    def distance(self, x: float, y: float) -> float: ...
    @overload
    def distance(self, other: QgsPointXY) -> float: ...
    @overload
    def sqrDist(self, x: float, y: float) -> float: ...
    @overload
    def sqrDist(self, other: QgsPointXY) -> float: ...
    def asWkt(self) -> str: ...
    def toString(self, precision: int = ...) -> str: ...
    def toQPointF(self) -> QtCore.QPointF: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def set(self, x: float, y: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...


class QgsPostgresStringUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsPostgresStringUtils) -> None: ...

    @staticmethod
    def buildArray(list: Iterable[typing.Any]) -> str: ...
    @staticmethod
    def parseArray(string: str) -> List[typing.Any]: ...


class QgsPropertyDefinition(sip.wrapper):

    class DataType(int):
        ...
    DataTypeString: QgsPropertyDefinition.DataType = ...
    DataTypeNumeric: QgsPropertyDefinition.DataType = ...
    DataTypeBoolean: QgsPropertyDefinition.DataType = ...

    class StandardPropertyTemplate(int):
        ...
    Boolean: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Integer: QgsPropertyDefinition.StandardPropertyTemplate = ...
    IntegerPositive: QgsPropertyDefinition.StandardPropertyTemplate = ...
    IntegerPositiveGreaterZero: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Double: QgsPropertyDefinition.StandardPropertyTemplate = ...
    DoublePositive: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Double0To1: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Rotation: QgsPropertyDefinition.StandardPropertyTemplate = ...
    String: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Opacity: QgsPropertyDefinition.StandardPropertyTemplate = ...
    RenderUnits: QgsPropertyDefinition.StandardPropertyTemplate = ...
    ColorWithAlpha: QgsPropertyDefinition.StandardPropertyTemplate = ...
    ColorNoAlpha: QgsPropertyDefinition.StandardPropertyTemplate = ...
    PenJoinStyle: QgsPropertyDefinition.StandardPropertyTemplate = ...
    BlendMode: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Point: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Size: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Size2D: QgsPropertyDefinition.StandardPropertyTemplate = ...
    LineStyle: QgsPropertyDefinition.StandardPropertyTemplate = ...
    StrokeWidth: QgsPropertyDefinition.StandardPropertyTemplate = ...
    FillStyle: QgsPropertyDefinition.StandardPropertyTemplate = ...
    CapStyle: QgsPropertyDefinition.StandardPropertyTemplate = ...
    HorizontalAnchor: QgsPropertyDefinition.StandardPropertyTemplate = ...
    VerticalAnchor: QgsPropertyDefinition.StandardPropertyTemplate = ...
    SvgPath: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Offset: QgsPropertyDefinition.StandardPropertyTemplate = ...
    DateTime: QgsPropertyDefinition.StandardPropertyTemplate = ...
    Custom: QgsPropertyDefinition.StandardPropertyTemplate = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, description: str, type: QgsPropertyDefinition.StandardPropertyTemplate, origin: str = ..., comment: str = ...) -> None: ...
    @overload
    def __init__(self, name: str, dataType: QgsPropertyDefinition.DataType, description: str, helpText: str, origin: str = ..., comment: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPropertyDefinition) -> None: ...

    def supportsAssistant(self) -> bool: ...
    def standardTemplate(self) -> QgsPropertyDefinition.StandardPropertyTemplate: ...
    def dataType(self) -> QgsPropertyDefinition.DataType: ...
    def setDataType(self, type: QgsPropertyDefinition.DataType) -> None: ...
    def helpText(self) -> str: ...
    def setComment(self, comment: str) -> None: ...
    def comment(self) -> str: ...
    def description(self) -> str: ...
    def setOrigin(self, origin: str) -> None: ...
    def origin(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...


class QgsProperty(sip.wrapper):

    class Type(int):
        ...
    InvalidProperty: QgsProperty.Type = ...
    StaticProperty: QgsProperty.Type = ...
    FieldBasedProperty: QgsProperty.Type = ...
    ExpressionBasedProperty: QgsProperty.Type = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsProperty) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def convertToTransformer(self) -> bool: ...
    def transformer(self) -> QgsPropertyTransformer: ...
    def setTransformer(self, transformer: QgsPropertyTransformer) -> None: ...
    def loadVariant(self, property: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def valueAsBool(self, context: QgsExpressionContext, defaultValue: bool = ...) -> Tuple[bool, bool]: ...
    def valueAsInt(self, context: QgsExpressionContext, defaultValue: int = ...) -> Tuple[int, bool]: ...
    def valueAsDouble(self, context: QgsExpressionContext, defaultValue: float = ...) -> Tuple[float, bool]: ...
    def valueAsColor(self, context: QgsExpressionContext, defaultColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> Tuple[QtGui.QColor, bool]: ...
    def valueAsString(self, context: QgsExpressionContext, defaultString: str = ...) -> Tuple[str, bool]: ...
    def valueAsDateTime(self, context: QgsExpressionContext, defaultDateTime: Union[QtCore.QDateTime, datetime.datetime] = ...) -> Tuple[QtCore.QDateTime, bool]: ...
    def value(self, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> Tuple[typing.Any, bool]: ...
    def isProjectColor(self) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> Set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def asExpression(self) -> str: ...
    def expressionString(self) -> str: ...
    def setExpressionString(self, expression: str) -> None: ...
    def field(self) -> str: ...
    def setField(self, field: str) -> None: ...
    def staticValue(self) -> typing.Any: ...
    def setStaticValue(self, value: typing.Any) -> None: ...
    def setActive(self, active: bool) -> None: ...
    def isActive(self) -> bool: ...
    def propertyType(self) -> QgsProperty.Type: ...
    def __int__(self) -> bool: ...
    @staticmethod
    def fromValue(value: typing.Any, isActive: bool = ...) -> QgsProperty: ...
    @staticmethod
    def fromField(fieldName: str, isActive: bool = ...) -> QgsProperty: ...
    @staticmethod
    def fromExpression(expression: str, isActive: bool = ...) -> QgsProperty: ...
    @staticmethod
    def variantMapToPropertyMap(variantMap: Dict[str, typing.Any]) -> Dict[str, QgsProperty]: ...
    @staticmethod
    def propertyMapToVariantMap(propertyMap: Dict[str, QgsProperty]) -> Dict[str, typing.Any]: ...


class QgsAbstractPropertyCollection(sip.wrapper):

    @overload
    def __init__(self, name: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractPropertyCollection) -> None: ...

    def loadVariant(self, configuration: typing.Any, definitions: Dict[int, QgsPropertyDefinition]) -> bool: ...
    def toVariant(self, definitions: Dict[int, QgsPropertyDefinition]) -> typing.Any: ...
    def readXml(self, collectionElem: QtXml.QDomElement, definitions: Dict[int, QgsPropertyDefinition]) -> bool: ...
    def writeXml(self, collectionElem: QtXml.QDomElement, definitions: Dict[int, QgsPropertyDefinition]) -> bool: ...
    def hasDynamicProperties(self) -> bool: ...
    def hasActiveProperties(self) -> bool: ...
    def isActive(self, key: int) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> Set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def valueAsBool(self, key: int, context: QgsExpressionContext, defaultValue: bool = ...) -> Tuple[bool, bool]: ...
    def valueAsInt(self, key: int, context: QgsExpressionContext, defaultValue: int = ...) -> Tuple[int, bool]: ...
    def valueAsDouble(self, key: int, context: QgsExpressionContext, defaultValue: float = ...) -> Tuple[float, bool]: ...
    def valueAsColor(self, key: int, context: QgsExpressionContext, defaultColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> Tuple[QtGui.QColor, bool]: ...
    def valueAsString(self, key: int, context: QgsExpressionContext, defaultString: str = ...) -> Tuple[str, bool]: ...
    def valueAsDateTime(self, key: int, context: QgsExpressionContext, defaultDateTime: Union[QtCore.QDateTime, datetime.datetime] = ...) -> Tuple[QtCore.QDateTime, bool]: ...
    def value(self, key: int, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Any: ...
    def property(self, key: int) -> QgsProperty: ...
    def hasProperty(self, key: int) -> bool: ...
    def clear(self) -> None: ...
    def propertyKeys(self) -> typing.Any: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...


class QgsPropertyCollection(QgsAbstractPropertyCollection):

    @overload
    def __init__(self, name: str = ...) -> None: ...
    @overload
    def __init__(self, other: QgsPropertyCollection) -> None: ...

    @overload
    def setProperty(self, key: int, property: QgsProperty) -> None: ...
    @overload
    def setProperty(self, key: int, value: typing.Any) -> None: ...
    def loadVariant(self, configuration: typing.Any, definitions: Dict[int, QgsPropertyDefinition]) -> bool: ...
    def toVariant(self, definitions: Dict[int, QgsPropertyDefinition]) -> typing.Any: ...
    def hasDynamicProperties(self) -> bool: ...
    def hasActiveProperties(self) -> bool: ...
    def isActive(self, key: int) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> Set[str]: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def value(self, key: int, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Any: ...
    def property(self, key: int) -> QgsProperty: ...
    def hasProperty(self, key: int) -> bool: ...
    def clear(self) -> None: ...
    def propertyKeys(self) -> typing.Any: ...
    def count(self) -> int: ...


class QgsPropertyCollectionStack(QgsAbstractPropertyCollection):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsPropertyCollectionStack) -> None: ...

    def loadVariant(self, collection: typing.Any, definitions: Dict[int, QgsPropertyDefinition]) -> bool: ...
    def toVariant(self, definitions: Dict[int, QgsPropertyDefinition]) -> typing.Any: ...
    def hasProperty(self, key: int) -> bool: ...
    def propertyKeys(self) -> typing.Any: ...
    def prepare(self, context: QgsExpressionContext = ...) -> bool: ...
    def referencedFields(self, context: QgsExpressionContext = ..., ignoreContext: bool = ...) -> Set[str]: ...
    def value(self, key: int, context: QgsExpressionContext, defaultValue: typing.Any = ...) -> typing.Any: ...
    def property(self, key: int) -> QgsProperty: ...
    def isActive(self, key: int) -> bool: ...
    def hasDynamicProperties(self) -> bool: ...
    def hasActiveProperties(self) -> bool: ...
    def collection(self, name: str) -> QgsPropertyCollection: ...
    def at(self, index: int) -> QgsPropertyCollection: ...
    def appendCollection(self, collection: QgsPropertyCollection) -> None: ...
    def clear(self) -> None: ...
    def count(self) -> int: ...


class QgsCurveTransform(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, controlPoints: Iterable[QgsPointXY]) -> None: ...
    @overload
    def __init__(self, other: QgsCurveTransform) -> None: ...

    def loadVariant(self, transformer: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def writeXml(self, transformElem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    @overload
    def y(self, x: float) -> float: ...
    @overload
    def y(self, x: Iterable[float]) -> List[float]: ...
    def removeControlPoint(self, x: float, y: float) -> None: ...
    def addControlPoint(self, x: float, y: float) -> None: ...
    def setControlPoints(self, points: Iterable[QgsPointXY]) -> None: ...
    def controlPoints(self) -> List[QgsPointXY]: ...


class QgsPropertyTransformer(sip.wrapper):

    class Type(int):
        ...
    GenericNumericTransformer: QgsPropertyTransformer.Type = ...
    SizeScaleTransformer: QgsPropertyTransformer.Type = ...
    ColorRampTransformer: QgsPropertyTransformer.Type = ...

    @overload
    def __init__(self, minValue: float = ..., maxValue: float = ...) -> None: ...
    @overload
    def __init__(self, other: QgsPropertyTransformer) -> None: ...

    def transformNumeric(self, input: float) -> float: ...
    @staticmethod
    def fromExpression(expression: str) -> Tuple[QgsPropertyTransformer, str, str]: ...
    def toExpression(self, baseExpression: str) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def setCurveTransform(self, transform: QgsCurveTransform) -> None: ...
    def curveTransform(self) -> QgsCurveTransform: ...
    def setMaxValue(self, max: float) -> None: ...
    def maxValue(self) -> float: ...
    def setMinValue(self, min: float) -> None: ...
    def minValue(self) -> float: ...
    def toVariant(self) -> typing.Any: ...
    def loadVariant(self, transformer: typing.Any) -> bool: ...
    def clone(self) -> QgsPropertyTransformer: ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...
    @staticmethod
    def create(type: QgsPropertyTransformer.Type) -> QgsPropertyTransformer: ...


class QgsGenericNumericTransformer(QgsPropertyTransformer):

    @overload
    def __init__(self, minValue: float = ..., maxValue: float = ..., minOutput: float = ..., maxOutput: float = ..., nullOutput: float = ..., exponent: float = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsGenericNumericTransformer) -> None: ...

    def setExponent(self, exponent: float) -> None: ...
    def exponent(self) -> float: ...
    def setNullOutputValue(self, size: float) -> None: ...
    def nullOutputValue(self) -> float: ...
    def setMaxOutputValue(self, size: float) -> None: ...
    def maxOutputValue(self) -> float: ...
    def setMinOutputValue(self, size: float) -> None: ...
    def minOutputValue(self) -> float: ...
    def value(self, input: float) -> float: ...
    @staticmethod
    def fromExpression(expression: str) -> Tuple[QgsGenericNumericTransformer, str, str]: ...
    def toExpression(self, baseExpression: str) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def loadVariant(self, definition: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def clone(self) -> QgsGenericNumericTransformer: ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...


class QgsSizeScaleTransformer(QgsPropertyTransformer):

    class ScaleType(int):
        ...
    Linear: QgsSizeScaleTransformer.ScaleType = ...
    Area: QgsSizeScaleTransformer.ScaleType = ...
    Flannery: QgsSizeScaleTransformer.ScaleType = ...
    Exponential: QgsSizeScaleTransformer.ScaleType = ...

    @overload
    def __init__(self, type: QgsSizeScaleTransformer.ScaleType = ..., minValue: float = ..., maxValue: float = ..., minSize: float = ..., maxSize: float = ..., nullSize: float = ..., exponent: float = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsSizeScaleTransformer) -> None: ...

    def setType(self, type: QgsSizeScaleTransformer.ScaleType) -> None: ...
    def type(self) -> QgsSizeScaleTransformer.ScaleType: ...
    def setExponent(self, exponent: float) -> None: ...
    def exponent(self) -> float: ...
    def setNullSize(self, size: float) -> None: ...
    def nullSize(self) -> float: ...
    def setMaxSize(self, size: float) -> None: ...
    def maxSize(self) -> float: ...
    def setMinSize(self, size: float) -> None: ...
    def minSize(self) -> float: ...
    def size(self, value: float) -> float: ...
    @staticmethod
    def fromExpression(expression: str) -> Tuple[QgsSizeScaleTransformer, str, str]: ...
    def toExpression(self, baseExpression: str) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def loadVariant(self, definition: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def clone(self) -> QgsSizeScaleTransformer: ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...


class QgsColorRampTransformer(QgsPropertyTransformer):

    @overload
    def __init__(self, minValue: float = ..., maxValue: float = ..., ramp: Optional[QgsColorRamp] = ..., nullColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    @overload
    def __init__(self, other: QgsColorRampTransformer) -> None: ...

    def setRampName(self, name: str) -> None: ...
    def rampName(self) -> str: ...
    def setNullColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def nullColor(self) -> QtGui.QColor: ...
    def setColorRamp(self, ramp: QgsColorRamp) -> None: ...
    def colorRamp(self) -> QgsColorRamp: ...
    def color(self, value: float) -> QtGui.QColor: ...
    def toExpression(self, baseExpression: str) -> str: ...
    def transform(self, context: QgsExpressionContext, value: typing.Any) -> typing.Any: ...
    def loadVariant(self, definition: typing.Any) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def clone(self) -> QgsColorRampTransformer: ...
    def transformerType(self) -> QgsPropertyTransformer.Type: ...


class QgsProviderConnectionModel(QtCore.QAbstractItemModel):

    class Role(int):
        ...
    RoleConnectionName: QgsProviderConnectionModel.Role = ...
    RoleUri: QgsProviderConnectionModel.Role = ...
    RoleConfiguration: QgsProviderConnectionModel.Role = ...
    RoleEmpty: QgsProviderConnectionModel.Role = ...

    def __init__(self, provider: str, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def index(self, row: int, column: int, parent: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def allowEmptyConnection(self) -> bool: ...
    def setAllowEmptyConnection(self, allowEmpty: bool) -> None: ...


class QgsProxyFeatureSink(QgsFeatureSink):

    @overload
    def __init__(self, sink: QgsFeatureSink) -> None: ...
    @overload
    def __init__(self, a0: QgsProxyFeatureSink) -> None: ...

    def destinationSink(self) -> QgsFeatureSink: ...
    def lastError(self) -> str: ...
    @overload
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    @overload
    def addFeatures(self, iterator: QgsFeatureIterator, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...


class QgsTask(QtCore.QObject):

    class SubTaskDependency(int):
        ...
    SubTaskIndependent: QgsTask.SubTaskDependency = ...
    ParentDependsOnSubTask: QgsTask.SubTaskDependency = ...

    class Flag(int):
        ...
    CanCancel: QgsTask.Flag = ...
    CancelWithoutPrompt: QgsTask.Flag = ...
    AllFlags: QgsTask.Flag = ...

    class TaskStatus(int):
        ...
    Queued: QgsTask.TaskStatus = ...
    OnHold: QgsTask.TaskStatus = ...
    Running: QgsTask.TaskStatus = ...
    Complete: QgsTask.TaskStatus = ...
    Terminated: QgsTask.TaskStatus = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsTask.Flags, QgsTask.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsTask.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsTask.Flags: ...
        def __int__(self) -> int: ...

    def __init__(self, description: str = ..., flags: Union[QgsTask.Flags, QgsTask.Flag] = ...) -> None: ...

    def setProgress(self, progress: float) -> None: ...
    def isCanceled(self) -> bool: ...
    def finished(self, result: bool) -> None: ...
    def run(self) -> bool: ...
    def taskTerminated(self) -> None: ...
    def taskCompleted(self) -> None: ...
    def begun(self) -> None: ...
    def statusChanged(self, status: int) -> None: ...
    def progressChanged(self, progress: float) -> None: ...
    def waitForFinished(self, timeout: int = ...) -> bool: ...
    def dependentLayers(self) -> List[QgsMapLayer]: ...
    def setDependentLayers(self, dependentLayers: Iterable[QgsMapLayer]) -> None: ...
    def addSubTask(self, subTask: QgsTask, dependencies: Iterable[QgsTask] = ..., subTaskDependency: QgsTask.SubTaskDependency = ...) -> None: ...
    def unhold(self) -> None: ...
    def hold(self) -> None: ...
    def cancel(self) -> None: ...
    def elapsedTime(self) -> int: ...
    def progress(self) -> float: ...
    def description(self) -> str: ...
    def status(self) -> QgsTask.TaskStatus: ...
    def isActive(self) -> bool: ...
    def canCancel(self) -> bool: ...
    def setDescription(self, description: str) -> None: ...
    def flags(self) -> QgsTask.Flags: ...


class QgsProxyProgressTask(QgsTask):

    def __init__(self, description: str) -> None: ...

    def setProxyProgress(self, progress: float) -> None: ...
    def run(self) -> bool: ...
    def finalize(self, result: bool) -> None: ...


class QgsScopedProxyProgressTask(sip.wrapper):

    @overload
    def __init__(self, description: str) -> None: ...
    @overload
    def __init__(self, a0: QgsScopedProxyProgressTask) -> None: ...

    def setProgress(self, progress: float) -> None: ...


class QgsPythonRunner(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsPythonRunner) -> None: ...

    def evalCommand(self, command: str, result: str) -> bool: ...
    def runCommand(self, command: str, messageOnError: str = ...) -> bool: ...
    @staticmethod
    def setInstance(runner: QgsPythonRunner) -> None: ...
    @staticmethod
    def eval(command: str) -> Tuple[bool, str]: ...
    @staticmethod
    def run(command: str, messageOnError: str = ...) -> bool: ...
    @staticmethod
    def isValid() -> bool: ...


class QgsQueryResultModel(QtCore.QAbstractTableModel):

    def __init__(self, queryResult: QgsAbstractDatabaseProviderConnection.QueryResult, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def cancel(self) -> None: ...
    def rowsReady(self, rows: typing.Any) -> None: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex) -> int: ...


class QgsRangedoubleBase(sip.wrapper):

    @overload
    def __init__(self, lower: float, upper: float, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsRangedoubleBase) -> None: ...

    def overlaps(self, other: QgsRangedoubleBase) -> bool: ...
    @overload
    def contains(self, other: QgsRangedoubleBase) -> bool: ...
    @overload
    def contains(self, element: float) -> bool: ...
    def isSingleton(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def includeUpper(self) -> bool: ...
    def includeLower(self) -> bool: ...
    def upper(self) -> float: ...
    def lower(self) -> float: ...


class QgsDoubleRange(QgsRangedoubleBase):

    @overload
    def __init__(self, lower: float, upper: float, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDoubleRange) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def isInfinite(self) -> bool: ...


class QgsRangeintBase(sip.wrapper):

    @overload
    def __init__(self, lower: int, upper: int, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsRangeintBase) -> None: ...

    def overlaps(self, other: QgsRangeintBase) -> bool: ...
    @overload
    def contains(self, other: QgsRangeintBase) -> bool: ...
    @overload
    def contains(self, element: int) -> bool: ...
    def isSingleton(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def includeUpper(self) -> bool: ...
    def includeLower(self) -> bool: ...
    def upper(self) -> int: ...
    def lower(self) -> int: ...


class QgsIntRange(QgsRangeintBase):

    @overload
    def __init__(self, lower: int, upper: int, includeLower: bool = ..., includeUpper: bool = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsIntRange) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def isInfinite(self) -> bool: ...


class QgsDateRange(sip.wrapper):

    @overload
    def __init__(self, begin: Union[QtCore.QDate, datetime.date], end: Union[QtCore.QDate, datetime.date], includeBeginning: bool = ..., includeEnd: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsDateRange) -> None: ...

    def extend(self, other: QgsDateRange) -> bool: ...
    def overlaps(self, other: QgsDateRange) -> bool: ...
    @overload
    def contains(self, other: QgsDateRange) -> bool: ...
    @overload
    def contains(self, element: Union[QtCore.QDate, datetime.date]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isInfinite(self) -> bool: ...
    def isInstant(self) -> bool: ...
    def includeEnd(self) -> bool: ...
    def includeBeginning(self) -> bool: ...
    def end(self) -> QtCore.QDate: ...
    def begin(self) -> QtCore.QDate: ...


class QgsDateTimeRange(sip.wrapper):

    @overload
    def __init__(self, begin: Union[QtCore.QDateTime, datetime.datetime], end: Union[QtCore.QDateTime, datetime.datetime], includeBeginning: bool = ..., includeEnd: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsDateTimeRange) -> None: ...

    def extend(self, other: QgsDateTimeRange) -> bool: ...
    def overlaps(self, other: QgsDateTimeRange) -> bool: ...
    @overload
    def contains(self, other: QgsDateTimeRange) -> bool: ...
    @overload
    def contains(self, element: Union[QtCore.QDateTime, datetime.datetime]) -> bool: ...
    def isEmpty(self) -> bool: ...
    def isInfinite(self) -> bool: ...
    def isInstant(self) -> bool: ...
    def includeEnd(self) -> bool: ...
    def includeBeginning(self) -> bool: ...
    def end(self) -> QtCore.QDateTime: ...
    def begin(self) -> QtCore.QDateTime: ...


class QgsReadWriteContext(sip.wrapper):

    class ReadWriteMessage(sip.wrapper):

        @overload
        def __init__(self, message: str = ..., level: Qgis.MessageLevel = ..., categories: Iterable[str] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsReadWriteContext.ReadWriteMessage) -> None: ...

        def __repr__(self) -> typing.Any: ...
        def categories(self) -> List[str]: ...
        def level(self) -> Qgis.MessageLevel: ...
        def message(self) -> str: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsReadWriteContext) -> None: ...

    def setTransformContext(self, transformContext: QgsCoordinateTransformContext) -> None: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...
    def setProjectTranslator(self, projectTranslator: QgsProjectTranslator) -> None: ...
    def projectTranslator(self) -> QgsProjectTranslator: ...
    def takeMessages(self) -> List[QgsReadWriteContext.ReadWriteMessage]: ...
    def _enterCategory(self, category: str, details: str = ...) -> QgsReadWriteContextCategoryPopper: ...
    def pushMessage(self, message: str, level: Qgis.MessageLevel = ...) -> None: ...
    def setPathResolver(self, resolver: QgsPathResolver) -> None: ...
    def pathResolver(self) -> QgsPathResolver: ...


class QgsReadWriteContextCategoryPopper(sip.wrapper):

    @overload
    def __init__(self, context: QgsReadWriteContext) -> None: ...
    @overload
    def __init__(self, a0: QgsReadWriteContextCategoryPopper) -> None: ...


class QgsReadWriteLocker(sip.wrapper):

    class Mode(int):
        ...
    Read: QgsReadWriteLocker.Mode = ...
    Write: QgsReadWriteLocker.Mode = ...
    Unlocked: QgsReadWriteLocker.Mode = ...

    @overload
    def __init__(self, lock: QtCore.QReadWriteLock, mode: QgsReadWriteLocker.Mode) -> None: ...
    @overload
    def __init__(self, a0: QgsReadWriteLocker) -> None: ...

    def unlock(self) -> None: ...
    def changeMode(self, mode: QgsReadWriteLocker.Mode) -> None: ...


class QgsRelation(sip.wrapper):

    class RelationStrength(int):
        ...
    Association: QgsRelation.RelationStrength = ...
    Composition: QgsRelation.RelationStrength = ...

    class RelationType(int):
        ...
    Normal: QgsRelation.RelationType = ...
    Generated: QgsRelation.RelationType = ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, context: QgsRelationContext) -> None: ...
    @overload
    def __init__(self, other: QgsRelation) -> None: ...

    def type(self) -> QgsRelation.RelationType: ...
    def polymorphicRelation(self) -> QgsPolymorphicRelation: ...
    def polymorphicRelationId(self) -> str: ...
    def setPolymorphicRelationId(self, polymorphicRelationId: str) -> None: ...
    def updateRelationStatus(self) -> None: ...
    def resolveReferencingField(self, referencedField: str) -> str: ...
    def resolveReferencedField(self, referencingField: str) -> str: ...
    def hasEqualDefinition(self, other: QgsRelation) -> bool: ...
    def isValid(self) -> bool: ...
    def referencingFields(self) -> List[int]: ...
    def referencedFields(self) -> List[int]: ...
    def fieldPairs(self) -> Dict[str, str]: ...
    def referencedLayer(self) -> QgsVectorLayer: ...
    def referencedLayerId(self) -> str: ...
    def referencingLayer(self) -> QgsVectorLayer: ...
    def referencingLayerId(self) -> str: ...
    def generateId(self) -> None: ...
    def id(self) -> str: ...
    def strength(self) -> QgsRelation.RelationStrength: ...
    def name(self) -> str: ...
    def getReferencedFeature(self, feature: QgsFeature) -> QgsFeature: ...
    @overload
    def getReferencedFeatureRequest(self, attributes: typing.Any) -> QgsFeatureRequest: ...
    @overload
    def getReferencedFeatureRequest(self, feature: QgsFeature) -> QgsFeatureRequest: ...
    def getRelatedFeaturesFilter(self, feature: QgsFeature) -> str: ...
    def getRelatedFeaturesRequest(self, feature: QgsFeature) -> QgsFeatureRequest: ...
    def getRelatedFeatures(self, feature: QgsFeature) -> QgsFeatureIterator: ...
    def addFieldPair(self, referencingField: str, referencedField: str) -> None: ...
    def setReferencedLayer(self, id: str) -> None: ...
    def setReferencingLayer(self, id: str) -> None: ...
    def setStrength(self, strength: QgsRelation.RelationStrength) -> None: ...
    def setName(self, name: str) -> None: ...
    def setId(self, id: str) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    @staticmethod
    def createFromXml(node: QtXml.QDomNode, context: QgsReadWriteContext, relationContext: QgsRelationContext = ...) -> QgsRelation: ...


class QgsPolymorphicRelation(sip.wrapper):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, context: QgsRelationContext) -> None: ...
    @overload
    def __init__(self, other: QgsPolymorphicRelation) -> None: ...

    def setRelationStrength(self, relationStrength: QgsRelation.RelationStrength) -> None: ...
    def strength(self) -> QgsRelation.RelationStrength: ...
    def layerRepresentation(self, layer: QgsVectorLayer) -> str: ...
    def generateRelations(self) -> List[QgsRelation]: ...
    def referencedLayerIds(self) -> List[str]: ...
    def setReferencedLayerIds(self, childRelationIds: Iterable[str]) -> None: ...
    def referencedLayerExpression(self) -> str: ...
    def setReferencedLayerExpression(self, expression: str) -> None: ...
    def referencedLayerField(self) -> str: ...
    def setReferencedLayerField(self, referencedLayerField: str) -> None: ...
    def updateRelationStatus(self) -> None: ...
    def hasEqualDefinition(self, other: QgsPolymorphicRelation) -> bool: ...
    def isValid(self) -> bool: ...
    def referencingFields(self) -> List[int]: ...
    def referencedFields(self, layerId: str) -> List[int]: ...
    def fieldPairs(self) -> Dict[str, str]: ...
    def referencingLayer(self) -> QgsVectorLayer: ...
    def referencingLayerId(self) -> str: ...
    def generateId(self) -> None: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def addFieldPair(self, referencingField: str, referencedField: str) -> None: ...
    def setReferencingLayer(self, id: str) -> None: ...
    def setName(self, name: str) -> None: ...
    def setId(self, id: str) -> None: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> None: ...
    @staticmethod
    def createFromXml(node: QtXml.QDomNode, context: QgsReadWriteContext, relationContext: QgsRelationContext = ...) -> QgsPolymorphicRelation: ...


class QgsRelationContext(sip.wrapper):

    @overload
    def __init__(self, project: Optional[QgsProject] = ...) -> None: ...
    @overload
    def __init__(self, other: QgsRelationContext) -> None: ...

    def project(self) -> QgsProject: ...


class QgsRemappingSinkDefinition(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRemappingSinkDefinition) -> None: ...

    def loadVariant(self, map: Dict[str, typing.Any]) -> bool: ...
    def toVariant(self) -> typing.Any: ...
    def setDestinationFields(self, fields: QgsFields) -> None: ...
    def destinationFields(self) -> QgsFields: ...
    def setDestinationWkbType(self, type: QgsWkbTypes.Type) -> None: ...
    def destinationWkbType(self) -> QgsWkbTypes.Type: ...
    def setDestinationCrs(self, destination: QgsCoordinateReferenceSystem) -> None: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setSourceCrs(self, source: QgsCoordinateReferenceSystem) -> None: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...
    def addMappedField(self, destinationField: str, property: QgsProperty) -> None: ...
    def setFieldMap(self, map: Dict[str, QgsProperty]) -> None: ...
    def fieldMap(self) -> Dict[str, QgsProperty]: ...


class QgsRemappingProxyFeatureSink(QgsFeatureSink):

    @overload
    def __init__(self, mappingDefinition: QgsRemappingSinkDefinition, sink: QgsFeatureSink) -> None: ...
    @overload
    def __init__(self, a0: QgsRemappingProxyFeatureSink) -> None: ...

    def destinationSink(self) -> QgsFeatureSink: ...
    def lastError(self) -> str: ...
    @overload
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    @overload
    def addFeatures(self, iterator: QgsFeatureIterator, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def remapFeature(self, feature: QgsFeature) -> List[QgsFeature]: ...
    def setTransformContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...


class QgsRelationManager(QtCore.QObject):

    def __init__(self, project: Optional[QgsProject] = ...) -> None: ...

    def updateRelationsStatus(self) -> None: ...
    def changed(self) -> None: ...
    def relationsLoaded(self) -> None: ...
    def setPolymorphicRelations(self, relations: Iterable[QgsPolymorphicRelation]) -> None: ...
    def removePolymorphicRelation(self, polymorphicRelationId: str) -> None: ...
    def addPolymorphicRelation(self, polymorphicRelation: QgsPolymorphicRelation) -> None: ...
    def polymorphicRelation(self, polymorphicRelationId: str) -> QgsPolymorphicRelation: ...
    def polymorphicRelations(self) -> Dict[str, QgsPolymorphicRelation]: ...
    @staticmethod
    def discoverRelations(existingRelations: Iterable[QgsRelation], layers: Iterable[QgsVectorLayer]) -> List[QgsRelation]: ...
    def referencedRelations(self, layer: Optional[QgsVectorLayer] = ...) -> List[QgsRelation]: ...
    def referencingRelations(self, layer: Optional[QgsVectorLayer] = ..., fieldIdx: int = ...) -> List[QgsRelation]: ...
    def clear(self) -> None: ...
    def relationsByName(self, name: str) -> List[QgsRelation]: ...
    def relation(self, id: str) -> QgsRelation: ...
    @overload
    def removeRelation(self, id: str) -> None: ...
    @overload
    def removeRelation(self, relation: QgsRelation) -> None: ...
    def addRelation(self, relation: QgsRelation) -> None: ...
    def relations(self) -> Dict[str, QgsRelation]: ...
    def setRelations(self, relations: Iterable[QgsRelation]) -> None: ...
    def context(self) -> QgsRelationContext: ...


class QgsRenderChecker(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRenderChecker) -> None: ...

    def dartMeasurements(self) -> List[QgsDartMeasurement]: ...
    def enableDashBuffering(self, enable: bool) -> None: ...
    def expectedImageFile(self) -> str: ...
    @staticmethod
    def drawBackground(image: QtGui.QImage) -> None: ...
    def isKnownAnomaly(self, diffImageFile: str) -> bool: ...
    @overload
    def compareImages(self, testName: str, mismatchCount: int = ..., renderedImageFile: str = ...) -> bool: ...
    @overload
    def compareImages(self, testName: str, referenceImageFile: str, renderedImageFile: str, mismatchCount: int = ...) -> bool: ...
    def runTest(self, testName: str, mismatchCount: int = ...) -> bool: ...
    def setSizeTolerance(self, xTolerance: int, yTolerance: int) -> None: ...
    def setColorTolerance(self, colorTolerance: int) -> None: ...
    def setMapSettings(self, mapSettings: QgsMapSettings) -> None: ...
    def renderedImage(self) -> str: ...
    def setRenderedImage(self, imageFileName: str) -> None: ...
    def imageToHash(self, imageFile: str) -> str: ...
    def setControlPathSuffix(self, name: str) -> None: ...
    def setControlPathPrefix(self, name: str) -> None: ...
    def setControlExtension(self, extension: str) -> None: ...
    def setControlName(self, name: str) -> None: ...
    def setElapsedTimeTarget(self, target: int) -> None: ...
    def elapsedTime(self) -> int: ...
    def matchTarget(self) -> int: ...
    def mismatchCount(self) -> int: ...
    def matchPercent(self) -> float: ...
    def report(self) -> str: ...
    def setControlImagePath(self, path: str) -> None: ...
    def controlImagePath(self) -> str: ...


class QgsRenderContext(QgsTemporalRangeObject):

    class TextRenderFormat(int):
        ...
    TextFormatAlwaysOutlines: QgsRenderContext.TextRenderFormat = ...
    TextFormatAlwaysText: QgsRenderContext.TextRenderFormat = ...

    class Flag(int):
        ...
    DrawEditingInfo: QgsRenderContext.Flag = ...
    ForceVectorOutput: QgsRenderContext.Flag = ...
    UseAdvancedEffects: QgsRenderContext.Flag = ...
    UseRenderingOptimization: QgsRenderContext.Flag = ...
    DrawSelection: QgsRenderContext.Flag = ...
    DrawSymbolBounds: QgsRenderContext.Flag = ...
    RenderMapTile: QgsRenderContext.Flag = ...
    Antialiasing: QgsRenderContext.Flag = ...
    RenderPartialOutput: QgsRenderContext.Flag = ...
    RenderPreviewJob: QgsRenderContext.Flag = ...
    RenderBlocking: QgsRenderContext.Flag = ...
    RenderSymbolPreview: QgsRenderContext.Flag = ...
    LosslessImageRendering: QgsRenderContext.Flag = ...
    ApplyScalingWorkaroundForTextRendering: QgsRenderContext.Flag = ...
    Render3DMap: QgsRenderContext.Flag = ...
    ApplyClipAfterReprojection: QgsRenderContext.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsRenderContext.Flags, QgsRenderContext.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsRenderContext.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsRenderContext.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rh: QgsRenderContext) -> None: ...

    def setZRange(self, range: QgsDoubleRange) -> None: ...
    def zRange(self) -> QgsDoubleRange: ...
    def setTextureOrigin(self, origin: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def textureOrigin(self) -> QtCore.QPointF: ...
    def setFeatureClipGeometry(self, geometry: QgsGeometry) -> None: ...
    def featureClipGeometry(self) -> QgsGeometry: ...
    def clippingRegions(self) -> List[QgsMapClippingRegion]: ...
    def clearCustomRenderingFlag(self, flag: str) -> None: ...
    def setCustomRenderingFlag(self, flag: str, value: typing.Any) -> None: ...
    def customRenderingFlags(self) -> Dict[str, typing.Any]: ...
    def isGuiPreview(self) -> bool: ...
    def setIsGuiPreview(self, preview: bool) -> None: ...
    def currentMaskId(self) -> int: ...
    def setCurrentMaskId(self, id: int) -> None: ...
    def maskIdProvider(self) -> QgsMaskIdProvider: ...
    def setMaskIdProvider(self, provider: QgsMaskIdProvider) -> None: ...
    def hasRenderedFeatureHandlers(self) -> bool: ...
    def renderedFeatureHandlers(self) -> List[QgsRenderedFeatureHandlerInterface]: ...
    def setTextRenderFormat(self, format: QgsRenderContext.TextRenderFormat) -> None: ...
    def textRenderFormat(self) -> QgsRenderContext.TextRenderFormat: ...
    def convertMetersToMapUnits(self, meters: float) -> float: ...
    def convertFromMapUnits(self, sizeInMapUnits: float, outputUnit: QgsUnitTypes.RenderUnit) -> float: ...
    def convertToMapUnits(self, size: float, unit: QgsUnitTypes.RenderUnit, scale: QgsMapUnitScale = ...) -> float: ...
    def convertToPainterUnits(self, size: float, unit: QgsUnitTypes.RenderUnit, scale: QgsMapUnitScale = ...) -> float: ...
    def segmentationToleranceType(self) -> QgsAbstractGeometry.SegmentationToleranceType: ...
    def setSegmentationToleranceType(self, type: QgsAbstractGeometry.SegmentationToleranceType) -> None: ...
    def segmentationTolerance(self) -> float: ...
    def setSegmentationTolerance(self, tolerance: float) -> None: ...
    def featureFilterProvider(self) -> QgsFeatureFilterProvider: ...
    def setFeatureFilterProvider(self, ffp: QgsFeatureFilterProvider) -> None: ...
    def setGeometry(self, geometry: QgsAbstractGeometry) -> None: ...
    def geometry(self) -> QgsAbstractGeometry: ...
    def expressionContext(self) -> QgsExpressionContext: ...
    def setExpressionContext(self, context: QgsExpressionContext) -> None: ...
    def setVectorSimplifyMethod(self, simplifyMethod: QgsVectorSimplifyMethod) -> None: ...
    def vectorSimplifyMethod(self) -> QgsVectorSimplifyMethod: ...
    def setUseRenderingOptimization(self, enabled: bool) -> None: ...
    def useRenderingOptimization(self) -> bool: ...
    def setShowSelection(self, showSelection: bool) -> None: ...
    def setSelectionColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setForceVectorOutput(self, force: bool) -> None: ...
    def setDisabledSymbolLayers(self, symbolLayers: Iterable[QgsSymbolLayer]) -> None: ...
    def setMaskPainter(self, p: QtGui.QPainter, id: int = ...) -> None: ...
    def setPainter(self, p: QtGui.QPainter) -> None: ...
    def setRendererScale(self, scale: float) -> None: ...
    def setDpiTarget(self, dpi: float) -> None: ...
    def setScaleFactor(self, factor: float) -> None: ...
    def setDistanceArea(self, distanceArea: QgsDistanceArea) -> None: ...
    def setRenderingStopped(self, stopped: bool) -> None: ...
    def setDrawEditingInformation(self, b: bool) -> None: ...
    def setMapExtent(self, extent: QgsRectangle) -> None: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def setMapToPixel(self, mtp: QgsMapToPixel) -> None: ...
    def setCoordinateTransform(self, t: QgsCoordinateTransform) -> None: ...
    def showSelection(self) -> bool: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def rendererScale(self) -> float: ...
    def drawEditingInformation(self) -> bool: ...
    def setUseAdvancedEffects(self, enabled: bool) -> None: ...
    def useAdvancedEffects(self) -> bool: ...
    def forceVectorOutput(self) -> bool: ...
    def renderingStopped(self) -> bool: ...
    def dpiTarget(self) -> float: ...
    def scaleFactor(self) -> float: ...
    def mapToPixel(self) -> QgsMapToPixel: ...
    def mapExtent(self) -> QgsRectangle: ...
    def extent(self) -> QgsRectangle: ...
    def setPathResolver(self, resolver: QgsPathResolver) -> None: ...
    def pathResolver(self) -> QgsPathResolver: ...
    def setTransformContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...
    def distanceArea(self) -> QgsDistanceArea: ...
    def coordinateTransform(self) -> QgsCoordinateTransform: ...
    def isSymbolLayerEnabled(self, layer: QgsSymbolLayer) -> bool: ...
    def disabledSymbolLayers(self) -> Set[QgsSymbolLayer]: ...
    def maskPainter(self, id: int = ...) -> QtGui.QPainter: ...
    def setPainterFlagsUsingContext(self, painter: Optional[QtGui.QPainter] = ...) -> None: ...
    def painter(self) -> QtGui.QPainter: ...
    @staticmethod
    def fromQPainter(painter: QtGui.QPainter) -> QgsRenderContext: ...
    @staticmethod
    def fromMapSettings(mapSettings: QgsMapSettings) -> QgsRenderContext: ...
    def testFlag(self, flag: QgsRenderContext.Flag) -> bool: ...
    def flags(self) -> QgsRenderContext.Flags: ...
    def setFlag(self, flag: QgsRenderContext.Flag, on: bool = ...) -> None: ...
    def setFlags(self, flags: Union[QgsRenderContext.Flags, QgsRenderContext.Flag]) -> None: ...


class QgsRenderedFeatureHandlerInterface(sip.wrapper):

    class RenderedFeatureContext(sip.wrapper):

        renderContext: QgsRenderContext = ...

        @overload
        def __init__(self, renderContext: QgsRenderContext) -> None: ...
        @overload
        def __init__(self, a0: QgsRenderedFeatureHandlerInterface.RenderedFeatureContext) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRenderedFeatureHandlerInterface) -> None: ...

    def usedAttributes(self, layer: QgsVectorLayer, context: QgsRenderContext) -> Set[str]: ...
    def handleRenderedFeature(self, feature: QgsFeature, renderedBounds: QgsGeometry, context: QgsRenderedFeatureHandlerInterface.RenderedFeatureContext) -> None: ...


class QgsRunProcess(QtCore.QObject):

    def dialogGone(self) -> None: ...
    def processExit(self, a0: int, a1: QtCore.QProcess.ExitStatus) -> None: ...
    def processError(self, a0: QtCore.QProcess.ProcessError) -> None: ...
    def stderrAvailable(self) -> None: ...
    def stdoutAvailable(self) -> None: ...
    @staticmethod
    def splitCommand(command: str) -> List[str]: ...
    @staticmethod
    def create(action: str, capture: bool) -> QgsRunProcess: ...


class QgsBlockingProcess(QtCore.QObject):

    def __init__(self, program: str, arguments: Iterable[str]) -> None: ...

    def processError(self) -> QtCore.QProcess.ProcessError: ...
    def exitStatus(self) -> QtCore.QProcess.ExitStatus: ...
    def run(self, feedback: Optional[QgsFeedback] = ...) -> int: ...
    def setStdErrHandler(self, a0: Callable[..., None]) -> None: ...
    def setStdOutHandler(self, a0: Callable[..., None]) -> None: ...


class QgsRuntimeProfiler(QtCore.QAbstractItemModel):

    def __init__(self) -> None: ...

    def groupAdded(self, group: str) -> None: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    @staticmethod
    def translateGroupName(group: str) -> str: ...
    def groupIsActive(self, group: str) -> bool: ...
    def groups(self) -> Set[str]: ...
    def totalTime(self, group: str = ...) -> float: ...
    def clear(self, group: str = ...) -> None: ...
    def profileTime(self, name: str, group: str = ...) -> float: ...
    def end(self, group: str = ...) -> None: ...
    def start(self, name: str, group: str = ...) -> None: ...
    def childGroups(self, parent: str = ..., group: str = ...) -> List[str]: ...
    def endGroup(self) -> None: ...
    def beginGroup(self, name: str) -> None: ...


class QgsScopedRuntimeProfile(sip.wrapper):

    @overload
    def __init__(self, name: str, group: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsScopedRuntimeProfile) -> None: ...

    def switchTask(self, name: str) -> None: ...


class QgsScaleCalculator(sip.wrapper):

    @overload
    def __init__(self, dpi: float = ..., mapUnits: QgsUnitTypes.DistanceUnit = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsScaleCalculator) -> None: ...

    def calculateGeographicDistance(self, mapExtent: QgsRectangle) -> float: ...
    def calculate(self, mapExtent: QgsRectangle, canvasWidth: float) -> float: ...
    def mapUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def setMapUnits(self, mapUnits: QgsUnitTypes.DistanceUnit) -> None: ...
    def dpi(self) -> float: ...
    def setDpi(self, dpi: float) -> None: ...


class QgsScaleUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsScaleUtils) -> None: ...

    @staticmethod
    def loadScaleList(fileName: str, scales: Iterable[str], errorMessage: str) -> bool: ...
    @staticmethod
    def saveScaleList(fileName: str, scales: Iterable[str], errorMessage: str) -> bool: ...


class QgsSimplifyMethod(sip.wrapper):

    class MethodType(int):
        ...
    NoSimplification: QgsSimplifyMethod.MethodType = ...
    OptimizeForRendering: QgsSimplifyMethod.MethodType = ...
    PreserveTopology: QgsSimplifyMethod.MethodType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSimplifyMethod) -> None: ...

    @staticmethod
    def createGeometrySimplifier(simplifyMethod: QgsSimplifyMethod) -> QgsAbstractGeometrySimplifier: ...
    def forceLocalOptimization(self) -> bool: ...
    def setForceLocalOptimization(self, localOptimization: bool) -> None: ...
    def threshold(self) -> float: ...
    def setThreshold(self, threshold: float) -> None: ...
    def tolerance(self) -> float: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def methodType(self) -> QgsSimplifyMethod.MethodType: ...
    def setMethodType(self, methodType: QgsSimplifyMethod.MethodType) -> None: ...


class QgsSnappingConfig(sip.wrapper):

    class ScaleDependencyMode(int):
        ...
    Disabled: QgsSnappingConfig.ScaleDependencyMode = ...
    Global: QgsSnappingConfig.ScaleDependencyMode = ...
    PerLayer: QgsSnappingConfig.ScaleDependencyMode = ...

    class SnappingTypes(int):
        ...
    NoSnapFlag: QgsSnappingConfig.SnappingTypes = ...
    VertexFlag: QgsSnappingConfig.SnappingTypes = ...
    SegmentFlag: QgsSnappingConfig.SnappingTypes = ...
    AreaFlag: QgsSnappingConfig.SnappingTypes = ...
    CentroidFlag: QgsSnappingConfig.SnappingTypes = ...
    MiddleOfSegmentFlag: QgsSnappingConfig.SnappingTypes = ...
    LineEndpointFlag: QgsSnappingConfig.SnappingTypes = ...

    class SnappingType(int):
        ...
    Vertex: QgsSnappingConfig.SnappingType = ...
    VertexAndSegment: QgsSnappingConfig.SnappingType = ...
    Segment: QgsSnappingConfig.SnappingType = ...

    class SnappingMode(int):
        ...
    ActiveLayer: QgsSnappingConfig.SnappingMode = ...
    AllLayers: QgsSnappingConfig.SnappingMode = ...
    AdvancedConfiguration: QgsSnappingConfig.SnappingMode = ...

    class SnappingTypeFlag(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsSnappingConfig.SnappingTypeFlag, QgsSnappingConfig.SnappingTypes]) -> None: ...
        @overload
        def __init__(self, a0: QgsSnappingConfig.SnappingTypeFlag) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsSnappingConfig.SnappingTypeFlag: ...
        def __int__(self) -> int: ...

    class IndividualLayerSettings(sip.wrapper):

        @overload
        def __init__(self, enabled: bool, type: QgsSnappingConfig.SnappingType, tolerance: float, units: QgsTolerance.UnitType) -> None: ...
        @overload
        def __init__(self, enabled: bool, type: Union[QgsSnappingConfig.SnappingTypeFlag, QgsSnappingConfig.SnappingTypes], tolerance: float, units: QgsTolerance.UnitType, minScale: float = ..., maxScale: float = ...) -> None: ...
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsSnappingConfig.IndividualLayerSettings) -> None: ...

        def setMaximumScale(self, maxScale: float) -> None: ...
        def maximumScale(self) -> float: ...
        def setMinimumScale(self, minScale: float) -> None: ...
        def minimumScale(self) -> float: ...
        def setUnits(self, units: QgsTolerance.UnitType) -> None: ...
        def units(self) -> QgsTolerance.UnitType: ...
        def setTolerance(self, tolerance: float) -> None: ...
        def tolerance(self) -> float: ...
        def setTypeFlag(self, type: Union[QgsSnappingConfig.SnappingTypeFlag, QgsSnappingConfig.SnappingTypes]) -> None: ...
        def setType(self, type: QgsSnappingConfig.SnappingType) -> None: ...
        def type(self) -> QgsSnappingConfig.SnappingType: ...
        def typeFlag(self) -> QgsSnappingConfig.SnappingTypeFlag: ...
        def setEnabled(self, enabled: bool) -> None: ...
        def enabled(self) -> bool: ...
        def valid(self) -> bool: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, project: Optional[QgsProject] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsSnappingConfig) -> None: ...

    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...
    def removeLayers(self, layers: Iterable[QgsMapLayer]) -> bool: ...
    def addLayers(self, layers: Iterable[QgsMapLayer]) -> bool: ...
    def writeProject(self, doc: QtXml.QDomDocument) -> None: ...
    def readProject(self, doc: QtXml.QDomDocument) -> None: ...
    def clearIndividualLayerSettings(self) -> None: ...
    def setIndividualLayerSettings(self, vl: QgsVectorLayer, individualLayerSettings: QgsSnappingConfig.IndividualLayerSettings) -> None: ...
    @overload
    def individualLayerSettings(self) -> Dict[QgsVectorLayer, QgsSnappingConfig.IndividualLayerSettings]: ...
    @overload
    def individualLayerSettings(self, vl: QgsVectorLayer) -> QgsSnappingConfig.IndividualLayerSettings: ...
    def setSelfSnapping(self, enabled: bool) -> None: ...
    def selfSnapping(self) -> bool: ...
    def setIntersectionSnapping(self, enabled: bool) -> None: ...
    def intersectionSnapping(self) -> bool: ...
    def setUnits(self, units: QgsTolerance.UnitType) -> None: ...
    def units(self) -> QgsTolerance.UnitType: ...
    def scaleDependencyMode(self) -> QgsSnappingConfig.ScaleDependencyMode: ...
    def setScaleDependencyMode(self, mode: QgsSnappingConfig.ScaleDependencyMode) -> None: ...
    def setMaximumScale(self, maxScale: float) -> None: ...
    def maximumScale(self) -> float: ...
    def setMinimumScale(self, minScale: float) -> None: ...
    def minimumScale(self) -> float: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def tolerance(self) -> float: ...
    def setTypeFlag(self, type: Union[QgsSnappingConfig.SnappingTypeFlag, QgsSnappingConfig.SnappingTypes]) -> None: ...
    def setType(self, type: QgsSnappingConfig.SnappingType) -> None: ...
    def type(self) -> QgsSnappingConfig.SnappingType: ...
    def typeFlag(self) -> QgsSnappingConfig.SnappingTypeFlag: ...
    def setMode(self, mode: QgsSnappingConfig.SnappingMode) -> None: ...
    def mode(self) -> QgsSnappingConfig.SnappingMode: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def reset(self) -> None: ...
    @staticmethod
    def snappingTypeFlagToIcon(type: Union[QgsSnappingConfig.SnappingTypeFlag, QgsSnappingConfig.SnappingTypes]) -> QtGui.QIcon: ...
    @staticmethod
    def snappingTypeFlagToString(type: Union[QgsSnappingConfig.SnappingTypeFlag, QgsSnappingConfig.SnappingTypes]) -> str: ...


class QgsSnappingUtils(QtCore.QObject):

    class IndexingStrategy(int):
        ...
    IndexAlwaysFull: QgsSnappingUtils.IndexingStrategy = ...
    IndexNeverFull: QgsSnappingUtils.IndexingStrategy = ...
    IndexHybrid: QgsSnappingUtils.IndexingStrategy = ...
    IndexExtent: QgsSnappingUtils.IndexingStrategy = ...

    class LayerConfig(sip.wrapper):

        layer: QgsVectorLayer = ...
        tolerance: float = ...
        type: Union[QgsPointLocator.Types, QgsPointLocator.Type] = ...
        unit: QgsTolerance.UnitType = ...

        @overload
        def __init__(self, l: QgsVectorLayer, t: Union[QgsPointLocator.Types, QgsPointLocator.Type], tol: float, u: QgsTolerance.UnitType) -> None: ...
        @overload
        def __init__(self, a0: QgsSnappingUtils.LayerConfig) -> None: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ..., enableSnappingForInvisibleFeature: bool = ...) -> None: ...

    def clearAllLocators(self) -> None: ...
    def prepareIndexProgress(self, index: int) -> None: ...
    def prepareIndexStarting(self, count: int) -> None: ...
    def configChanged(self, snappingConfig: QgsSnappingConfig) -> None: ...
    def toggleEnabled(self) -> None: ...
    def setConfig(self, snappingConfig: QgsSnappingConfig) -> None: ...
    def getExtraSnapLayers(self) -> Set[QgsVectorLayer]: ...
    def removeExtraSnapLayer(self, vl: QgsVectorLayer) -> None: ...
    def addExtraSnapLayer(self, vl: QgsVectorLayer) -> None: ...
    def setEnableSnappingForInvisibleFeature(self, enable: bool) -> None: ...
    def config(self) -> QgsSnappingConfig: ...
    def dump(self) -> str: ...
    def layers(self) -> List[QgsSnappingUtils.LayerConfig]: ...
    def indexingStrategy(self) -> QgsSnappingUtils.IndexingStrategy: ...
    def setIndexingStrategy(self, strategy: QgsSnappingUtils.IndexingStrategy) -> None: ...
    def currentLayer(self) -> QgsVectorLayer: ...
    def setCurrentLayer(self, layer: QgsVectorLayer) -> None: ...
    def mapSettings(self) -> QgsMapSettings: ...
    def setMapSettings(self, settings: QgsMapSettings) -> None: ...
    def snapToCurrentLayer(self, point: QtCore.QPoint, type: Union[QgsPointLocator.Types, QgsPointLocator.Type], filter: Optional[QgsPointLocator.MatchFilter] = ...) -> QgsPointLocator.Match: ...
    @overload
    def snapToMap(self, point: QtCore.QPoint, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    @overload
    def snapToMap(self, pointMap: QgsPointXY, filter: Optional[QgsPointLocator.MatchFilter] = ..., relaxed: bool = ...) -> QgsPointLocator.Match: ...
    def locatorForLayer(self, vl: QgsVectorLayer) -> QgsPointLocator: ...


class QgsSpatialIndex(QgsFeatureSink):

    class Flag(int):
        ...
    FlagStoreFeatureGeometries: QgsSpatialIndex.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsSpatialIndex.Flags, QgsSpatialIndex.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsSpatialIndex.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsSpatialIndex.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, flags: Union[QgsSpatialIndex.Flags, QgsSpatialIndex.Flag] = ...) -> None: ...
    @overload
    def __init__(self, fi: QgsFeatureIterator, feedback: Optional[QgsFeedback] = ..., flags: Union[QgsSpatialIndex.Flags, QgsSpatialIndex.Flag] = ...) -> None: ...
    @overload
    def __init__(self, source: QgsFeatureSource, feedback: Optional[QgsFeedback] = ..., flags: Union[QgsSpatialIndex.Flags, QgsSpatialIndex.Flag] = ...) -> None: ...
    @overload
    def __init__(self, other: QgsSpatialIndex) -> None: ...

    def refs(self) -> int: ...
    def geometry(self, id: int) -> QgsGeometry: ...
    @overload
    def nearestNeighbor(self, point: QgsPointXY, neighbors: int = ..., maxDistance: float = ...) -> typing.Any: ...
    @overload
    def nearestNeighbor(self, geometry: QgsGeometry, neighbors: int = ..., maxDistance: float = ...) -> typing.Any: ...
    def intersects(self, rectangle: QgsRectangle) -> typing.Any: ...
    def deleteFeature(self, feature: QgsFeature) -> bool: ...
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    @overload
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    @overload
    def addFeature(self, id: int, bounds: QgsRectangle) -> bool: ...
    @overload
    def insertFeature(self, feature: QgsFeature) -> bool: ...
    @overload
    def insertFeature(self, id: int, bounds: QgsRectangle) -> bool: ...


class QgsSpatialIndexKDBush(sip.wrapper):

    @overload
    def __init__(self, fi: QgsFeatureIterator, feedback: Optional[QgsFeedback] = ...) -> None: ...
    @overload
    def __init__(self, source: QgsFeatureSource, feedback: Optional[QgsFeedback] = ...) -> None: ...
    @overload
    def __init__(self, other: QgsSpatialIndexKDBush) -> None: ...

    def size(self) -> int: ...
    def within(self, point: QgsPointXY, radius: float) -> List[QgsSpatialIndexKDBushData]: ...
    def intersects(self, rectangle: QgsRectangle) -> List[QgsSpatialIndexKDBushData]: ...


class QgsSpatialIndexKDBushData(sip.wrapper):

    id: int = ...

    @overload
    def __init__(self, id: int, x: float, y: float) -> None: ...
    @overload
    def __init__(self, a0: QgsSpatialIndexKDBushData) -> None: ...

    def point(self) -> QgsPointXY: ...


class QgsSourceCache(QgsAbstractContentCacheBase):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def remoteSourceFetched(self, url: str) -> None: ...
    def localFilePath(self, path: str, blocking: bool = ...) -> str: ...


class QgsSqliteUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSqliteUtils) -> None: ...

    @staticmethod
    def systemTables() -> List[str]: ...
    @staticmethod
    def quotedValue(value: typing.Any) -> str: ...
    @staticmethod
    def quotedIdentifier(identifier: str) -> str: ...
    @staticmethod
    def quotedString(value: str) -> str: ...


class QgsSQLStatement(sip.wrapper):

    class NodeType(int):
        ...
    ntUnaryOperator: QgsSQLStatement.NodeType = ...
    ntBinaryOperator: QgsSQLStatement.NodeType = ...
    ntInOperator: QgsSQLStatement.NodeType = ...
    ntBetweenOperator: QgsSQLStatement.NodeType = ...
    ntFunction: QgsSQLStatement.NodeType = ...
    ntLiteral: QgsSQLStatement.NodeType = ...
    ntColumnRef: QgsSQLStatement.NodeType = ...
    ntSelectedColumn: QgsSQLStatement.NodeType = ...
    ntSelect: QgsSQLStatement.NodeType = ...
    ntTableDef: QgsSQLStatement.NodeType = ...
    ntJoin: QgsSQLStatement.NodeType = ...
    ntColumnSorted: QgsSQLStatement.NodeType = ...
    ntCast: QgsSQLStatement.NodeType = ...

    class JoinType(int):
        ...
    jtDefault: QgsSQLStatement.JoinType = ...
    jtLeft: QgsSQLStatement.JoinType = ...
    jtLeftOuter: QgsSQLStatement.JoinType = ...
    jtRight: QgsSQLStatement.JoinType = ...
    jtRightOuter: QgsSQLStatement.JoinType = ...
    jtCross: QgsSQLStatement.JoinType = ...
    jtInner: QgsSQLStatement.JoinType = ...
    jtFull: QgsSQLStatement.JoinType = ...

    class BinaryOperator(int):
        ...
    boOr: QgsSQLStatement.BinaryOperator = ...
    boAnd: QgsSQLStatement.BinaryOperator = ...
    boEQ: QgsSQLStatement.BinaryOperator = ...
    boNE: QgsSQLStatement.BinaryOperator = ...
    boLE: QgsSQLStatement.BinaryOperator = ...
    boGE: QgsSQLStatement.BinaryOperator = ...
    boLT: QgsSQLStatement.BinaryOperator = ...
    boGT: QgsSQLStatement.BinaryOperator = ...
    boLike: QgsSQLStatement.BinaryOperator = ...
    boNotLike: QgsSQLStatement.BinaryOperator = ...
    boILike: QgsSQLStatement.BinaryOperator = ...
    boNotILike: QgsSQLStatement.BinaryOperator = ...
    boIs: QgsSQLStatement.BinaryOperator = ...
    boIsNot: QgsSQLStatement.BinaryOperator = ...
    boPlus: QgsSQLStatement.BinaryOperator = ...
    boMinus: QgsSQLStatement.BinaryOperator = ...
    boMul: QgsSQLStatement.BinaryOperator = ...
    boDiv: QgsSQLStatement.BinaryOperator = ...
    boIntDiv: QgsSQLStatement.BinaryOperator = ...
    boMod: QgsSQLStatement.BinaryOperator = ...
    boPow: QgsSQLStatement.BinaryOperator = ...
    boConcat: QgsSQLStatement.BinaryOperator = ...

    class UnaryOperator(int):
        ...
    uoNot: QgsSQLStatement.UnaryOperator = ...
    uoMinus: QgsSQLStatement.UnaryOperator = ...

    class Node(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.Node) -> None: ...

        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...

    class NodeList(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeList) -> None: ...

        def dump(self) -> str: ...
        def clone(self) -> QgsSQLStatement.NodeList: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def count(self) -> int: ...
        def list(self) -> List[QgsSQLStatement.Node]: ...
        def append(self, node: QgsSQLStatement.Node) -> None: ...

    class NodeUnaryOperator(QgsSQLStatement.Node):

        @overload
        def __init__(self, op: QgsSQLStatement.UnaryOperator, operand: QgsSQLStatement.Node) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeUnaryOperator) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def operand(self) -> QgsSQLStatement.Node: ...
        def op(self) -> QgsSQLStatement.UnaryOperator: ...

    class NodeBinaryOperator(QgsSQLStatement.Node):

        @overload
        def __init__(self, op: QgsSQLStatement.BinaryOperator, opLeft: QgsSQLStatement.Node, opRight: QgsSQLStatement.Node) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeBinaryOperator) -> None: ...

        def leftAssociative(self) -> bool: ...
        def precedence(self) -> int: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def opRight(self) -> QgsSQLStatement.Node: ...
        def opLeft(self) -> QgsSQLStatement.Node: ...
        def op(self) -> QgsSQLStatement.BinaryOperator: ...

    class NodeInOperator(QgsSQLStatement.Node):

        @overload
        def __init__(self, node: QgsSQLStatement.Node, list: QgsSQLStatement.NodeList, notin: bool = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeInOperator) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def list(self) -> QgsSQLStatement.NodeList: ...
        def isNotIn(self) -> bool: ...
        def node(self) -> QgsSQLStatement.Node: ...

    class NodeBetweenOperator(QgsSQLStatement.Node):

        @overload
        def __init__(self, node: QgsSQLStatement.Node, minVal: QgsSQLStatement.Node, maxVal: QgsSQLStatement.Node, notBetween: bool = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeBetweenOperator) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def maxVal(self) -> QgsSQLStatement.Node: ...
        def minVal(self) -> QgsSQLStatement.Node: ...
        def isNotBetween(self) -> bool: ...
        def node(self) -> QgsSQLStatement.Node: ...

    class NodeFunction(QgsSQLStatement.Node):

        @overload
        def __init__(self, name: str, args: QgsSQLStatement.NodeList) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeFunction) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def args(self) -> QgsSQLStatement.NodeList: ...
        def name(self) -> str: ...

    class NodeLiteral(QgsSQLStatement.Node):

        @overload
        def __init__(self, value: typing.Any) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeLiteral) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def value(self) -> typing.Any: ...

    class NodeColumnRef(QgsSQLStatement.Node):

        @overload
        def __init__(self, name: str, star: bool) -> None: ...
        @overload
        def __init__(self, tableName: str, name: str, star: bool) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeColumnRef) -> None: ...

        def cloneThis(self) -> QgsSQLStatement.NodeColumnRef: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def distinct(self) -> bool: ...
        def star(self) -> bool: ...
        def name(self) -> str: ...
        def tableName(self) -> str: ...
        def setDistinct(self, distinct: bool = ...) -> None: ...

    class NodeSelectedColumn(QgsSQLStatement.Node):

        @overload
        def __init__(self, node: QgsSQLStatement.Node) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeSelectedColumn) -> None: ...

        def cloneThis(self) -> QgsSQLStatement.NodeSelectedColumn: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def alias(self) -> str: ...
        def column(self) -> QgsSQLStatement.Node: ...
        def setAlias(self, alias: str) -> None: ...

    class NodeCast(QgsSQLStatement.Node):

        @overload
        def __init__(self, node: QgsSQLStatement.Node, type: str) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeCast) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def type(self) -> str: ...
        def node(self) -> QgsSQLStatement.Node: ...

    class NodeTableDef(QgsSQLStatement.Node):

        @overload
        def __init__(self, name: str) -> None: ...
        @overload
        def __init__(self, name: str, alias: str) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeTableDef) -> None: ...

        def cloneThis(self) -> QgsSQLStatement.NodeTableDef: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def alias(self) -> str: ...
        def name(self) -> str: ...

    class NodeJoin(QgsSQLStatement.Node):

        @overload
        def __init__(self, tabledef: QgsSQLStatement.NodeTableDef, onExpr: QgsSQLStatement.Node, type: QgsSQLStatement.JoinType) -> None: ...
        @overload
        def __init__(self, tabledef: QgsSQLStatement.NodeTableDef, usingColumns: Iterable[str], type: QgsSQLStatement.JoinType) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeJoin) -> None: ...

        def cloneThis(self) -> QgsSQLStatement.NodeJoin: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def type(self) -> QgsSQLStatement.JoinType: ...
        def usingColumns(self) -> List[str]: ...
        def onExpr(self) -> QgsSQLStatement.Node: ...
        def tableDef(self) -> QgsSQLStatement.NodeTableDef: ...

    class NodeColumnSorted(QgsSQLStatement.Node):

        @overload
        def __init__(self, column: QgsSQLStatement.NodeColumnRef, asc: bool) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeColumnSorted) -> None: ...

        def cloneThis(self) -> QgsSQLStatement.NodeColumnSorted: ...
        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def ascending(self) -> bool: ...
        def column(self) -> QgsSQLStatement.NodeColumnRef: ...

    class NodeSelect(QgsSQLStatement.Node):

        @overload
        def __init__(self, tableList: Iterable[QgsSQLStatement.NodeTableDef], columns: Iterable[QgsSQLStatement.NodeSelectedColumn], distinct: bool) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.NodeSelect) -> None: ...

        def clone(self) -> QgsSQLStatement.Node: ...
        def accept(self, v: QgsSQLStatement.Visitor) -> None: ...
        def dump(self) -> str: ...
        def nodeType(self) -> QgsSQLStatement.NodeType: ...
        def orderBy(self) -> List[QgsSQLStatement.NodeColumnSorted]: ...
        def where(self) -> QgsSQLStatement.Node: ...
        def joins(self) -> List[QgsSQLStatement.NodeJoin]: ...
        def distinct(self) -> bool: ...
        def columns(self) -> List[QgsSQLStatement.NodeSelectedColumn]: ...
        def tables(self) -> List[QgsSQLStatement.NodeTableDef]: ...
        def setOrderBy(self, orderBy: Iterable[QgsSQLStatement.NodeColumnSorted]) -> None: ...
        def setWhere(self, where: QgsSQLStatement.Node) -> None: ...
        def appendJoin(self, join: QgsSQLStatement.NodeJoin) -> None: ...
        def setJoins(self, joins: Iterable[QgsSQLStatement.NodeJoin]) -> None: ...

    class Visitor(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.Visitor) -> None: ...

        @overload
        def visit(self, n: QgsSQLStatement.NodeUnaryOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeBinaryOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeInOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeBetweenOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeFunction) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeLiteral) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeColumnRef) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeSelectedColumn) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeTableDef) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeSelect) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeJoin) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeColumnSorted) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeCast) -> None: ...

    class RecursiveVisitor(QgsSQLStatement.Visitor):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsSQLStatement.RecursiveVisitor) -> None: ...

        @overload
        def visit(self, n: QgsSQLStatement.NodeUnaryOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeBinaryOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeInOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeBetweenOperator) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeFunction) -> None: ...
        @overload
        def visit(self, a0: QgsSQLStatement.NodeLiteral) -> None: ...
        @overload
        def visit(self, a0: QgsSQLStatement.NodeColumnRef) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeSelectedColumn) -> None: ...
        @overload
        def visit(self, a0: QgsSQLStatement.NodeTableDef) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeSelect) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeJoin) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeColumnSorted) -> None: ...
        @overload
        def visit(self, n: QgsSQLStatement.NodeCast) -> None: ...

    @overload
    def __init__(self, statement: str) -> None: ...
    @overload
    def __init__(self, other: QgsSQLStatement) -> None: ...
    @overload
    def __init__(self, statement: str, allowFragments: bool) -> None: ...

    def acceptVisitor(self, v: QgsSQLStatement.Visitor) -> None: ...
    @staticmethod
    def quotedString(text: str) -> str: ...
    @staticmethod
    def stripMsQuotedIdentifier(text: str) -> str: ...
    @staticmethod
    def stripQuotedIdentifier(text: str) -> str: ...
    @staticmethod
    def quotedIdentifierIfNeeded(name: str) -> str: ...
    @staticmethod
    def quotedIdentifier(name: str) -> str: ...
    def dump(self) -> str: ...
    def statement(self) -> str: ...
    def rootNode(self) -> QgsSQLStatement.Node: ...
    def doBasicValidationChecks(self) -> Tuple[bool, str]: ...
    def parserErrorString(self) -> str: ...
    def hasParserError(self) -> bool: ...


class QgsSQLStatementFragment(QgsSQLStatement):

    @overload
    def __init__(self, fragment: str) -> None: ...
    @overload
    def __init__(self, a0: QgsSQLStatementFragment) -> None: ...


class QgsStatisticalSummary(sip.wrapper):

    class Statistic(int):
        ...
    Count: QgsStatisticalSummary.Statistic = ...
    CountMissing: QgsStatisticalSummary.Statistic = ...
    Sum: QgsStatisticalSummary.Statistic = ...
    Mean: QgsStatisticalSummary.Statistic = ...
    Median: QgsStatisticalSummary.Statistic = ...
    StDev: QgsStatisticalSummary.Statistic = ...
    StDevSample: QgsStatisticalSummary.Statistic = ...
    Min: QgsStatisticalSummary.Statistic = ...
    Max: QgsStatisticalSummary.Statistic = ...
    Range: QgsStatisticalSummary.Statistic = ...
    Minority: QgsStatisticalSummary.Statistic = ...
    Majority: QgsStatisticalSummary.Statistic = ...
    Variety: QgsStatisticalSummary.Statistic = ...
    FirstQuartile: QgsStatisticalSummary.Statistic = ...
    ThirdQuartile: QgsStatisticalSummary.Statistic = ...
    InterQuartileRange: QgsStatisticalSummary.Statistic = ...
    First: QgsStatisticalSummary.Statistic = ...
    Last: QgsStatisticalSummary.Statistic = ...
    All: QgsStatisticalSummary.Statistic = ...

    class Statistics(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsStatisticalSummary.Statistics, QgsStatisticalSummary.Statistic]) -> None: ...
        @overload
        def __init__(self, a0: QgsStatisticalSummary.Statistics) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsStatisticalSummary.Statistics: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, stats: Union[QgsStatisticalSummary.Statistics, QgsStatisticalSummary.Statistic] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsStatisticalSummary) -> None: ...

    @staticmethod
    def shortName(statistic: QgsStatisticalSummary.Statistic) -> str: ...
    @staticmethod
    def displayName(statistic: QgsStatisticalSummary.Statistic) -> str: ...
    def interQuartileRange(self) -> float: ...
    def thirdQuartile(self) -> float: ...
    def firstQuartile(self) -> float: ...
    def majority(self) -> float: ...
    def minority(self) -> float: ...
    def variety(self) -> int: ...
    def sampleStDev(self) -> float: ...
    def stDev(self) -> float: ...
    def last(self) -> float: ...
    def first(self) -> float: ...
    def range(self) -> float: ...
    def max(self) -> float: ...
    def min(self) -> float: ...
    def median(self) -> float: ...
    def mean(self) -> float: ...
    def sum(self) -> float: ...
    def countMissing(self) -> int: ...
    def count(self) -> int: ...
    def statistic(self, stat: QgsStatisticalSummary.Statistic) -> float: ...
    def finalize(self) -> None: ...
    def addVariant(self, value: typing.Any) -> None: ...
    def addValue(self, value: float) -> None: ...
    def calculate(self, values: Iterable[float]) -> None: ...
    def reset(self) -> None: ...
    def setStatistics(self, stats: Union[QgsStatisticalSummary.Statistics, QgsStatisticalSummary.Statistic]) -> None: ...
    def statistics(self) -> QgsStatisticalSummary.Statistics: ...


class QgsStoredExpression(sip.wrapper):

    class Category(int):
        ...
    FilterExpression: QgsStoredExpression.Category = ...
    DefaultValueExpression: QgsStoredExpression.Category = ...
    All: QgsStoredExpression.Category = ...

    expression: str = ...
    id: str = ...
    name: str = ...
    tag: QgsStoredExpression.Category = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsStoredExpression) -> None: ...


class QgsStoredExpressionManager(QtCore.QObject):

    def __init__(self) -> None: ...

    def readXml(self, layerNode: QtXml.QDomNode) -> bool: ...
    def writeXml(self, layerNode: QtXml.QDomNode) -> bool: ...
    def clearStoredExpressions(self) -> None: ...
    def findStoredExpressionByExpression(self, expression: str, tag: QgsStoredExpression.Category = ...) -> QgsStoredExpression: ...
    def storedExpression(self, id: str) -> QgsStoredExpression: ...
    def storedExpressions(self, tag: QgsStoredExpression.Category = ...) -> List[QgsStoredExpression]: ...
    def addStoredExpressions(self, storedExpressions: Iterable[QgsStoredExpression]) -> None: ...
    def updateStoredExpression(self, id: str, name: str, expression: str, tag: QgsStoredExpression.Category) -> None: ...
    def removeStoredExpression(self, id: str) -> None: ...
    def addStoredExpression(self, name: str, expression: str, tag: QgsStoredExpression.Category = ...) -> str: ...


class QgsStringStatisticalSummary(sip.wrapper):

    class Statistic(int):
        ...
    Count: QgsStringStatisticalSummary.Statistic = ...
    CountDistinct: QgsStringStatisticalSummary.Statistic = ...
    CountMissing: QgsStringStatisticalSummary.Statistic = ...
    Min: QgsStringStatisticalSummary.Statistic = ...
    Max: QgsStringStatisticalSummary.Statistic = ...
    MinimumLength: QgsStringStatisticalSummary.Statistic = ...
    MaximumLength: QgsStringStatisticalSummary.Statistic = ...
    MeanLength: QgsStringStatisticalSummary.Statistic = ...
    Minority: QgsStringStatisticalSummary.Statistic = ...
    Majority: QgsStringStatisticalSummary.Statistic = ...
    All: QgsStringStatisticalSummary.Statistic = ...

    class Statistics(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsStringStatisticalSummary.Statistics, QgsStringStatisticalSummary.Statistic]) -> None: ...
        @overload
        def __init__(self, a0: QgsStringStatisticalSummary.Statistics) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsStringStatisticalSummary.Statistics: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, stats: Union[QgsStringStatisticalSummary.Statistics, QgsStringStatisticalSummary.Statistic] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsStringStatisticalSummary) -> None: ...

    @staticmethod
    def displayName(statistic: QgsStringStatisticalSummary.Statistic) -> str: ...
    def majority(self) -> str: ...
    def minority(self) -> str: ...
    def meanLength(self) -> float: ...
    def maxLength(self) -> int: ...
    def minLength(self) -> int: ...
    def max(self) -> str: ...
    def min(self) -> str: ...
    def countMissing(self) -> int: ...
    def distinctValues(self) -> Set[str]: ...
    def countDistinct(self) -> int: ...
    def count(self) -> int: ...
    def statistic(self, stat: QgsStringStatisticalSummary.Statistic) -> typing.Any: ...
    def finalize(self) -> None: ...
    def addValue(self, value: typing.Any) -> None: ...
    def addString(self, string: str) -> None: ...
    def calculateFromVariants(self, values: Iterable[typing.Any]) -> None: ...
    def calculate(self, values: Iterable[str]) -> None: ...
    def reset(self) -> None: ...
    def setStatistics(self, stats: Union[QgsStringStatisticalSummary.Statistics, QgsStringStatisticalSummary.Statistic]) -> None: ...
    def statistics(self) -> QgsStringStatisticalSummary.Statistics: ...


class QgsStringReplacement(sip.wrapper):

    @overload
    def __init__(self, match: str, replacement: str, caseSensitive: bool = ..., wholeWordOnly: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsStringReplacement) -> None: ...

    @staticmethod
    def fromProperties(properties: Dict[str, str]) -> QgsStringReplacement: ...
    def properties(self) -> Dict[str, str]: ...
    def process(self, input: str) -> str: ...
    def wholeWordOnly(self) -> bool: ...
    def caseSensitive(self) -> bool: ...
    def replacement(self) -> str: ...
    def match(self) -> str: ...


class QgsStringReplacementCollection(sip.wrapper):

    @overload
    def __init__(self, replacements: Iterable[QgsStringReplacement] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsStringReplacementCollection) -> None: ...

    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> None: ...
    def process(self, input: str) -> str: ...
    def setReplacements(self, replacements: Iterable[QgsStringReplacement]) -> None: ...
    def replacements(self) -> List[QgsStringReplacement]: ...


class QgsStringUtils(sip.wrapper):

    class Capitalization(int):
        ...
    MixedCase: QgsStringUtils.Capitalization = ...
    AllUppercase: QgsStringUtils.Capitalization = ...
    AllLowercase: QgsStringUtils.Capitalization = ...
    ForceFirstLetterToCapital: QgsStringUtils.Capitalization = ...
    TitleCase: QgsStringUtils.Capitalization = ...
    UpperCamelCase: QgsStringUtils.Capitalization = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsStringUtils) -> None: ...

    @staticmethod
    def htmlToMarkdown(html: str) -> str: ...
    @staticmethod
    def substituteVerticalCharacters(string: str) -> str: ...
    @staticmethod
    def wordWrap(string: str, length: int, useMaxLineLength: bool = ..., customDelimiter: str = ...) -> str: ...
    @staticmethod
    def insertLinks(string: str) -> Tuple[str, bool]: ...
    @staticmethod
    def fuzzyScore(candidate: str, search: str) -> float: ...
    @staticmethod
    def soundex(string: str) -> str: ...
    @staticmethod
    def hammingDistance(string1: str, string2: str, caseSensitive: bool = ...) -> int: ...
    @staticmethod
    def longestCommonSubstring(string1: str, string2: str, caseSensitive: bool = ...) -> str: ...
    @staticmethod
    def levenshteinDistance(string1: str, string2: str, caseSensitive: bool = ...) -> int: ...
    @staticmethod
    def ampersandEncode(string: str) -> str: ...
    @staticmethod
    def capitalize(string: str, capitalization: QgsStringUtils.Capitalization) -> str: ...


class QgsTableCell(sip.wrapper):

    @overload
    def __init__(self, content: typing.Any = ...) -> None: ...
    @overload
    def __init__(self, other: QgsTableCell) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def setProperties(self, properties: Dict[str, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def setVerticalAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def verticalAlignment(self) -> QtCore.Qt.Alignment: ...
    def setHorizontalAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def horizontalAlignment(self) -> QtCore.Qt.Alignment: ...
    def setNumericFormat(self, format: QgsNumericFormat) -> None: ...
    def numericFormat(self) -> QgsNumericFormat: ...
    def setTextFormat(self, format: QgsTextFormat) -> None: ...
    def textFormat(self) -> QgsTextFormat: ...
    def setForegroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def foregroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setContent(self, content: typing.Any) -> None: ...
    def content(self) -> typing.Any: ...


class QgsTaskManager(QtCore.QObject):

    class TaskDefinition(sip.wrapper):

        dependentTasks: Iterable[QgsTask] = ...
        task: QgsTask = ...

        @overload
        def __init__(self, task: QgsTask, dependentTasks: Iterable[QgsTask] = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsTaskManager.TaskDefinition) -> None: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def taskTriggered(self, task: QgsTask) -> None: ...
    def countActiveTasksChanged(self, count: int) -> None: ...
    def allTasksFinished(self) -> None: ...
    def taskAboutToBeDeleted(self, taskId: int) -> None: ...
    def taskAdded(self, taskId: int) -> None: ...
    def statusChanged(self, taskId: int, status: int) -> None: ...
    def finalTaskProgressChanged(self, progress: float) -> None: ...
    def progressChanged(self, taskId: int, progress: float) -> None: ...
    def triggerTask(self, task: QgsTask) -> None: ...
    def countActiveTasks(self) -> int: ...
    def activeTasks(self) -> List[QgsTask]: ...
    def tasksDependentOnLayer(self, layer: QgsMapLayer) -> List[QgsTask]: ...
    def dependentLayers(self, taskId: int) -> List[QgsMapLayer]: ...
    def dependenciesSatisfied(self, taskId: int) -> bool: ...
    def cancelAll(self) -> None: ...
    def taskId(self, task: QgsTask) -> int: ...
    def count(self) -> int: ...
    def tasks(self) -> List[QgsTask]: ...
    def task(self, id: int) -> QgsTask: ...
    @overload
    def addTask(self, task: QgsTask, priority: int = ...) -> int: ...
    @overload
    def addTask(self, task: QgsTaskManager.TaskDefinition, priority: int = ...) -> int: ...


class QgsTemporalController(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def updateTemporalRange(self, range: QgsDateTimeRange) -> None: ...


class QgsTemporalNavigationObject(QgsTemporalController, QgsExpressionContextScopeGenerator):

    class AnimationState(int):
        ...
    Forward: QgsTemporalNavigationObject.AnimationState = ...
    Reverse: QgsTemporalNavigationObject.AnimationState = ...
    Idle: QgsTemporalNavigationObject.AnimationState = ...

    class NavigationMode(int):
        ...
    NavigationOff: QgsTemporalNavigationObject.NavigationMode = ...
    Animated: QgsTemporalNavigationObject.NavigationMode = ...
    FixedRange: QgsTemporalNavigationObject.NavigationMode = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def skipToEnd(self) -> None: ...
    def rewindToStart(self) -> None: ...
    def previous(self) -> None: ...
    def next(self) -> None: ...
    def playBackward(self) -> None: ...
    def playForward(self) -> None: ...
    def pause(self) -> None: ...
    def play(self) -> None: ...
    def temporalFrameDurationChanged(self, interval: QgsInterval) -> None: ...
    def temporalExtentsChanged(self, extent: QgsDateTimeRange) -> None: ...
    def navigationModeChanged(self, mode: QgsTemporalNavigationObject.NavigationMode) -> None: ...
    def stateChanged(self, state: QgsTemporalNavigationObject.AnimationState) -> None: ...
    def createExpressionContextScope(self) -> QgsExpressionContextScope: ...
    def findBestFrameNumberForFrameStart(self, frameStart: Union[QtCore.QDateTime, datetime.datetime]) -> int: ...
    def setLooping(self, loop: bool) -> None: ...
    def isLooping(self) -> bool: ...
    def totalFrameCount(self) -> int: ...
    def temporalRangeCumulative(self) -> bool: ...
    def setTemporalRangeCumulative(self, state: bool) -> None: ...
    def framesPerSecond(self) -> float: ...
    def setFramesPerSecond(self, rate: float) -> None: ...
    def dateTimeRangeForFrameNumber(self, frame: int) -> QgsDateTimeRange: ...
    def frameDuration(self) -> QgsInterval: ...
    def setFrameDuration(self, duration: QgsInterval) -> None: ...
    def currentFrameNumber(self) -> int: ...
    def setCurrentFrameNumber(self, frame: int) -> None: ...
    def availableTemporalRanges(self) -> List[QgsDateTimeRange]: ...
    def setAvailableTemporalRanges(self, ranges: Iterable[QgsDateTimeRange]) -> None: ...
    def temporalExtents(self) -> QgsDateTimeRange: ...
    def setTemporalExtents(self, extents: QgsDateTimeRange) -> None: ...
    def navigationMode(self) -> QgsTemporalNavigationObject.NavigationMode: ...
    def setNavigationMode(self, mode: QgsTemporalNavigationObject.NavigationMode) -> None: ...
    def animationState(self) -> QgsTemporalNavigationObject.AnimationState: ...
    def setAnimationState(self, state: QgsTemporalNavigationObject.AnimationState) -> None: ...


class QgsTemporalUtils(sip.wrapper):

    class AnimationExportSettings(sip.wrapper):

        animationRange: QgsDateTimeRange = ...
        decorations: Iterable[QgsMapDecoration] = ...
        fileNameTemplate: str = ...
        frameDuration: QgsInterval = ...
        outputDirectory: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsTemporalUtils.AnimationExportSettings) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsTemporalUtils) -> None: ...

    @staticmethod
    def calculateDateTimesFromISO8601(string: str, maxValues: int = ...) -> Tuple[List[QtCore.QDateTime], bool, bool]: ...
    @staticmethod
    def calculateDateTimesUsingDuration(start: Union[QtCore.QDateTime, datetime.datetime], end: Union[QtCore.QDateTime, datetime.datetime], duration: str, maxValues: int = ...) -> Tuple[List[QtCore.QDateTime], bool, bool]: ...
    @staticmethod
    def calculateFrameTime(start: Union[QtCore.QDateTime, datetime.datetime], frame: int, interval: QgsInterval) -> QtCore.QDateTime: ...
    @staticmethod
    def exportAnimation(mapSettings: QgsMapSettings, settings: QgsTemporalUtils.AnimationExportSettings, feedback: Optional[QgsFeedback] = ...) -> Tuple[bool, str]: ...
    @staticmethod
    def usedTemporalRangesForProject(project: QgsProject) -> List[QgsDateTimeRange]: ...
    @staticmethod
    def calculateTemporalRangeForProject(project: QgsProject) -> QgsDateTimeRange: ...


class QgsTessellator(sip.wrapper):

    @overload
    def __init__(self, originX: float, originY: float, addNormals: bool, invertNormals: bool = ..., addBackFaces: bool = ..., noZ: bool = ..., addTextureCoords: bool = ..., facade: int = ..., textureRotation: float = ...) -> None: ...
    @overload
    def __init__(self, bounds: QgsRectangle, addNormals: bool, invertNormals: bool = ..., addBackFaces: bool = ..., noZ: bool = ..., addTextureCoords: bool = ..., facade: int = ..., textureRotation: float = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsTessellator) -> None: ...

    def zMaximum(self) -> float: ...
    def zMinimum(self) -> float: ...
    def stride(self) -> int: ...
    def dataVerticesCount(self) -> int: ...
    def data(self) -> List[float]: ...
    def addPolygon(self, polygon: QgsPolygon, extrusionHeight: float) -> None: ...


class QgsTestUtils(sip.simplewrapper):

    def testProviderIteratorThreadSafety(self, provider: QgsVectorDataProvider, request: QgsFeatureRequest = ...) -> bool: ...


class QgsTileXYZ(sip.wrapper):

    @overload
    def __init__(self, tc: int = ..., tr: int = ..., tz: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsTileXYZ) -> None: ...

    def toString(self) -> str: ...
    def zoomLevel(self) -> int: ...
    def row(self) -> int: ...
    def column(self) -> int: ...


class QgsTileRange(sip.wrapper):

    @overload
    def __init__(self, c1: int = ..., c2: int = ..., r1: int = ..., r2: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsTileRange) -> None: ...

    def endRow(self) -> int: ...
    def startRow(self) -> int: ...
    def endColumn(self) -> int: ...
    def startColumn(self) -> int: ...
    def isValid(self) -> bool: ...


class QgsTileMatrix(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsTileMatrix) -> None: ...

    def mapToTileCoordinates(self, mapPoint: QgsPointXY) -> QtCore.QPointF: ...
    def tileRangeFromExtent(self, mExtent: QgsRectangle) -> QgsTileRange: ...
    def tileCenter(self, id: QgsTileXYZ) -> QgsPointXY: ...
    def tileExtent(self, id: QgsTileXYZ) -> QgsRectangle: ...
    def scale(self) -> float: ...
    def extent(self) -> QgsRectangle: ...
    def matrixHeight(self) -> int: ...
    def matrixWidth(self) -> int: ...
    def zoomLevel(self) -> int: ...
    @staticmethod
    def fromWebMercator(mZoomLevel: int) -> QgsTileMatrix: ...


class QgsTolerance(sip.wrapper):

    class UnitType(int):
        ...
    LayerUnits: QgsTolerance.UnitType = ...
    Pixels: QgsTolerance.UnitType = ...
    ProjectUnits: QgsTolerance.UnitType = ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsTolerance) -> None: ...

    @staticmethod
    def toleranceInMapUnits(tolerance: float, layer: QgsMapLayer, mapSettings: QgsMapSettings, units: QgsTolerance.UnitType = ...) -> float: ...
    @staticmethod
    def toleranceInProjectUnits(tolerance: float, layer: QgsMapLayer, mapSettings: QgsMapSettings, units: QgsTolerance.UnitType) -> float: ...
    @staticmethod
    def defaultTolerance(layer: QgsMapLayer, mapSettings: QgsMapSettings) -> float: ...
    @overload
    @staticmethod
    def vertexSearchRadius(mapSettings: QgsMapSettings) -> float: ...
    @overload
    @staticmethod
    def vertexSearchRadius(layer: QgsMapLayer, mapSettings: QgsMapSettings) -> float: ...


class QgsTracer(QtCore.QObject):

    class PathError(int):
        ...
    ErrNone: QgsTracer.PathError = ...
    ErrTooManyFeatures: QgsTracer.PathError = ...
    ErrPoint1: QgsTracer.PathError = ...
    ErrPoint2: QgsTracer.PathError = ...
    ErrNoPath: QgsTracer.PathError = ...

    def __init__(self) -> None: ...

    def invalidateGraph(self) -> None: ...
    def configure(self) -> None: ...
    def isPointSnapped(self, pt: QgsPointXY) -> bool: ...
    def findShortestPath(self, p1: QgsPointXY, p2: QgsPointXY) -> Tuple[List[QgsPointXY], QgsTracer.PathError]: ...
    def hasTopologyProblem(self) -> bool: ...
    def isInitialized(self) -> bool: ...
    def init(self) -> bool: ...
    def setMaxFeatureCount(self, count: int) -> None: ...
    def maxFeatureCount(self) -> int: ...
    def setOffsetParameters(self, quadSegments: int, joinStyle: int, miterLimit: float) -> None: ...
    def offsetParameters(self) -> Tuple[int, int, float]: ...
    def setOffset(self, offset: float) -> None: ...
    def offset(self) -> float: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def extent(self) -> QgsRectangle: ...
    def setRenderContext(self, renderContext: QgsRenderContext) -> None: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem, context: QgsCoordinateTransformContext) -> None: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setLayers(self, layers: Iterable[QgsVectorLayer]) -> None: ...
    def layers(self) -> List[QgsVectorLayer]: ...


class QgsVectorLayerTools(QtCore.QObject):

    def __init__(self) -> None: ...

    def setForceSuppressFormPopup(self, forceSuppressFormPopup: bool) -> None: ...
    def forceSuppressFormPopup(self) -> bool: ...
    def copyMoveFeatures(self, layer: QgsVectorLayer, request: QgsFeatureRequest, dx: float = ..., dy: float = ..., topologicalEditing: bool = ..., topologicalLayer: Optional[QgsVectorLayer] = ...) -> Tuple[bool, QgsFeatureRequest, str]: ...
    def saveEdits(self, layer: QgsVectorLayer) -> bool: ...
    def stopEditing(self, layer: QgsVectorLayer, allowCancel: bool = ...) -> bool: ...
    def startEditing(self, layer: QgsVectorLayer) -> bool: ...
    def addFeature(self, layer: QgsVectorLayer, defaultValues: Dict[int, typing.Any] = ..., defaultGeometry: QgsGeometry = ...) -> Tuple[bool, QgsFeature]: ...


class QgsTrackedVectorLayerTools(QgsVectorLayerTools):

    def __init__(self) -> None: ...

    def rollback(self) -> None: ...
    def setVectorLayerTools(self, tools: QgsVectorLayerTools) -> None: ...
    def copyMoveFeatures(self, layer: QgsVectorLayer, request: QgsFeatureRequest, dx: float = ..., dy: float = ..., errorMsg: Optional[str] = ..., topologicalEditing: bool = ..., topologicalLayer: Optional[QgsVectorLayer] = ...) -> bool: ...
    def saveEdits(self, layer: QgsVectorLayer) -> bool: ...
    def stopEditing(self, layer: QgsVectorLayer, allowCancel: bool) -> bool: ...
    def startEditing(self, layer: QgsVectorLayer) -> bool: ...
    def addFeature(self, layer: QgsVectorLayer, defaultValues: Dict[int, typing.Any], defaultGeometry: QgsGeometry, feature: QgsFeature) -> bool: ...


class QgsTransaction(QtCore.QObject):

    def __init__(self) -> None: ...

    def dirtied(self, sql: str, name: str) -> None: ...
    def afterRollback(self) -> None: ...
    def lastSavePointIsDirty(self) -> bool: ...
    def savePoints(self) -> List[str]: ...
    def dirtyLastSavePoint(self) -> None: ...
    def rollbackToSavepoint(self, name: str) -> Tuple[bool, str]: ...
    @overload
    def createSavepoint(self) -> Tuple[str, str]: ...
    @overload
    def createSavepoint(self, savePointId: str) -> Tuple[str, str]: ...
    @staticmethod
    def supportsTransaction(layer: QgsVectorLayer) -> bool: ...
    def executeSql(self, sql: str, isDirty: bool = ..., name: str = ...) -> Tuple[bool, str]: ...
    def rollback(self) -> Tuple[bool, str]: ...
    def commit(self) -> Tuple[bool, str]: ...
    def begin(self, statementTimeout: int = ...) -> Tuple[bool, str]: ...
    def addLayer(self, layer: QgsVectorLayer) -> bool: ...
    @overload
    @staticmethod
    def create(connString: str, providerKey: str) -> QgsTransaction: ...
    @overload
    @staticmethod
    def create(layers: Iterable[QgsVectorLayer]) -> QgsTransaction: ...


class QgsTransactionGroup(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def commitError(self, msg: str) -> None: ...
    def isEmpty(self) -> bool: ...
    def providerKey(self) -> str: ...
    def connString(self) -> str: ...
    def modified(self) -> bool: ...
    def layers(self) -> Set[QgsVectorLayer]: ...
    def addLayer(self, layer: QgsVectorLayer) -> bool: ...


class QgsTranslationContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsTranslationContext) -> None: ...

    def writeTsFile(self, locale: str) -> None: ...
    def registerTranslation(self, context: str, source: str) -> None: ...
    def setFileName(self, fileName: str) -> None: ...
    def fileName(self) -> str: ...
    def setProject(self, project: QgsProject) -> None: ...
    def project(self) -> QgsProject: ...


class QgsUnitTypes(sip.wrapper):

    class LayoutUnitType(int):
        ...
    LayoutPaperUnits: QgsUnitTypes.LayoutUnitType = ...
    LayoutScreenUnits: QgsUnitTypes.LayoutUnitType = ...

    class LayoutUnit(int):
        ...
    LayoutMillimeters: QgsUnitTypes.LayoutUnit = ...
    LayoutCentimeters: QgsUnitTypes.LayoutUnit = ...
    LayoutMeters: QgsUnitTypes.LayoutUnit = ...
    LayoutInches: QgsUnitTypes.LayoutUnit = ...
    LayoutFeet: QgsUnitTypes.LayoutUnit = ...
    LayoutPoints: QgsUnitTypes.LayoutUnit = ...
    LayoutPicas: QgsUnitTypes.LayoutUnit = ...
    LayoutPixels: QgsUnitTypes.LayoutUnit = ...

    class RenderUnit(int):
        ...
    RenderMillimeters: QgsUnitTypes.RenderUnit = ...
    RenderMapUnits: QgsUnitTypes.RenderUnit = ...
    RenderPixels: QgsUnitTypes.RenderUnit = ...
    RenderPercentage: QgsUnitTypes.RenderUnit = ...
    RenderPoints: QgsUnitTypes.RenderUnit = ...
    RenderInches: QgsUnitTypes.RenderUnit = ...
    RenderUnknownUnit: QgsUnitTypes.RenderUnit = ...
    RenderMetersInMapUnits: QgsUnitTypes.RenderUnit = ...

    class TemporalUnit(int):
        ...
    TemporalMilliseconds: QgsUnitTypes.TemporalUnit = ...
    TemporalSeconds: QgsUnitTypes.TemporalUnit = ...
    TemporalMinutes: QgsUnitTypes.TemporalUnit = ...
    TemporalHours: QgsUnitTypes.TemporalUnit = ...
    TemporalDays: QgsUnitTypes.TemporalUnit = ...
    TemporalWeeks: QgsUnitTypes.TemporalUnit = ...
    TemporalMonths: QgsUnitTypes.TemporalUnit = ...
    TemporalYears: QgsUnitTypes.TemporalUnit = ...
    TemporalDecades: QgsUnitTypes.TemporalUnit = ...
    TemporalCenturies: QgsUnitTypes.TemporalUnit = ...
    TemporalIrregularStep: QgsUnitTypes.TemporalUnit = ...
    TemporalUnknownUnit: QgsUnitTypes.TemporalUnit = ...

    class AngleUnit(int):
        ...
    AngleDegrees: QgsUnitTypes.AngleUnit = ...
    AngleRadians: QgsUnitTypes.AngleUnit = ...
    AngleGon: QgsUnitTypes.AngleUnit = ...
    AngleMinutesOfArc: QgsUnitTypes.AngleUnit = ...
    AngleSecondsOfArc: QgsUnitTypes.AngleUnit = ...
    AngleTurn: QgsUnitTypes.AngleUnit = ...
    AngleMilliradiansSI: QgsUnitTypes.AngleUnit = ...
    AngleMilNATO: QgsUnitTypes.AngleUnit = ...
    AngleUnknownUnit: QgsUnitTypes.AngleUnit = ...

    class VolumeUnit(int):
        ...
    VolumeCubicMeters: QgsUnitTypes.VolumeUnit = ...
    VolumeCubicFeet: QgsUnitTypes.VolumeUnit = ...
    VolumeCubicYards: QgsUnitTypes.VolumeUnit = ...
    VolumeBarrel: QgsUnitTypes.VolumeUnit = ...
    VolumeCubicDecimeter: QgsUnitTypes.VolumeUnit = ...
    VolumeLiters: QgsUnitTypes.VolumeUnit = ...
    VolumeGallonUS: QgsUnitTypes.VolumeUnit = ...
    VolumeCubicInch: QgsUnitTypes.VolumeUnit = ...
    VolumeCubicCentimeter: QgsUnitTypes.VolumeUnit = ...
    VolumeCubicDegrees: QgsUnitTypes.VolumeUnit = ...
    VolumeUnknownUnit: QgsUnitTypes.VolumeUnit = ...

    class AreaUnit(int):
        ...
    AreaSquareMeters: QgsUnitTypes.AreaUnit = ...
    AreaSquareKilometers: QgsUnitTypes.AreaUnit = ...
    AreaSquareFeet: QgsUnitTypes.AreaUnit = ...
    AreaSquareYards: QgsUnitTypes.AreaUnit = ...
    AreaSquareMiles: QgsUnitTypes.AreaUnit = ...
    AreaHectares: QgsUnitTypes.AreaUnit = ...
    AreaAcres: QgsUnitTypes.AreaUnit = ...
    AreaSquareNauticalMiles: QgsUnitTypes.AreaUnit = ...
    AreaSquareDegrees: QgsUnitTypes.AreaUnit = ...
    AreaSquareCentimeters: QgsUnitTypes.AreaUnit = ...
    AreaSquareMillimeters: QgsUnitTypes.AreaUnit = ...
    AreaUnknownUnit: QgsUnitTypes.AreaUnit = ...

    class DistanceUnitType(int):
        ...
    Standard: QgsUnitTypes.DistanceUnitType = ...
    Geographic: QgsUnitTypes.DistanceUnitType = ...
    UnknownType: QgsUnitTypes.DistanceUnitType = ...

    class DistanceUnit(int):
        ...
    DistanceMeters: QgsUnitTypes.DistanceUnit = ...
    DistanceKilometers: QgsUnitTypes.DistanceUnit = ...
    DistanceFeet: QgsUnitTypes.DistanceUnit = ...
    DistanceNauticalMiles: QgsUnitTypes.DistanceUnit = ...
    DistanceYards: QgsUnitTypes.DistanceUnit = ...
    DistanceMiles: QgsUnitTypes.DistanceUnit = ...
    DistanceDegrees: QgsUnitTypes.DistanceUnit = ...
    DistanceCentimeters: QgsUnitTypes.DistanceUnit = ...
    DistanceMillimeters: QgsUnitTypes.DistanceUnit = ...
    DistanceUnknownUnit: QgsUnitTypes.DistanceUnit = ...

    class UnitType(int):
        ...
    TypeDistance: QgsUnitTypes.UnitType = ...
    TypeArea: QgsUnitTypes.UnitType = ...
    TypeVolume: QgsUnitTypes.UnitType = ...
    TypeUnknown: QgsUnitTypes.UnitType = ...
    TypeTemporal: QgsUnitTypes.UnitType = ...

    class SystemOfMeasurement(int):
        ...
    UnknownSystem: QgsUnitTypes.SystemOfMeasurement = ...
    MetricSystem: QgsUnitTypes.SystemOfMeasurement = ...
    ImperialSystem: QgsUnitTypes.SystemOfMeasurement = ...
    USCSSystem: QgsUnitTypes.SystemOfMeasurement = ...

    class DistanceValue(sip.wrapper):

        unit: QgsUnitTypes.DistanceUnit = ...
        value: float = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsUnitTypes.DistanceValue) -> None: ...

    class AreaValue(sip.wrapper):

        unit: QgsUnitTypes.AreaUnit = ...
        value: float = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsUnitTypes.AreaValue) -> None: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsUnitTypes) -> None: ...

    @staticmethod
    def decodeLayoutUnit(string: str) -> Tuple[QgsUnitTypes.LayoutUnit, bool]: ...
    @staticmethod
    def decodeRenderUnit(string: str) -> Tuple[QgsUnitTypes.RenderUnit, bool]: ...
    @staticmethod
    def formatArea(area: float, decimals: int, unit: QgsUnitTypes.AreaUnit, keepBaseUnit: bool = ...) -> str: ...
    @staticmethod
    def formatDistance(distance: float, decimals: int, unit: QgsUnitTypes.DistanceUnit, keepBaseUnit: bool = ...) -> str: ...
    @staticmethod
    def scaledArea(area: float, unit: QgsUnitTypes.AreaUnit, decimals: int, keepBaseUnit: bool = ...) -> QgsUnitTypes.AreaValue: ...
    @staticmethod
    def scaledDistance(distance: float, unit: QgsUnitTypes.DistanceUnit, decimals: int, keepBaseUnit: bool = ...) -> QgsUnitTypes.DistanceValue: ...
    @staticmethod
    def formatAngle(angle: float, decimals: int, unit: QgsUnitTypes.AngleUnit) -> str: ...
    @staticmethod
    def decodeAngleUnit(string: str) -> Tuple[QgsUnitTypes.AngleUnit, bool]: ...
    @staticmethod
    def volumeToDistanceUnit(volumeUnit: QgsUnitTypes.VolumeUnit) -> QgsUnitTypes.DistanceUnit: ...
    @staticmethod
    def distanceToVolumeUnit(distanceUnit: QgsUnitTypes.DistanceUnit) -> QgsUnitTypes.VolumeUnit: ...
    @staticmethod
    def stringToVolumeUnit(string: str) -> Tuple[QgsUnitTypes.VolumeUnit, bool]: ...
    @staticmethod
    def decodeVolumeUnit(string: str) -> Tuple[QgsUnitTypes.VolumeUnit, bool]: ...
    @staticmethod
    def stringToTemporalUnit(string: str) -> Tuple[QgsUnitTypes.TemporalUnit, bool]: ...
    @staticmethod
    def decodeTemporalUnit(string: str) -> Tuple[QgsUnitTypes.TemporalUnit, bool]: ...
    @staticmethod
    def areaToDistanceUnit(areaUnit: QgsUnitTypes.AreaUnit) -> QgsUnitTypes.DistanceUnit: ...
    @staticmethod
    def distanceToAreaUnit(distanceUnit: QgsUnitTypes.DistanceUnit) -> QgsUnitTypes.AreaUnit: ...
    @staticmethod
    def stringToAreaUnit(string: str) -> Tuple[QgsUnitTypes.AreaUnit, bool]: ...
    @staticmethod
    def decodeAreaUnit(string: str) -> Tuple[QgsUnitTypes.AreaUnit, bool]: ...
    @overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: QgsUnitTypes.DistanceUnit, toUnit: QgsUnitTypes.DistanceUnit) -> float: ...
    @overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: QgsUnitTypes.AreaUnit, toUnit: QgsUnitTypes.AreaUnit) -> float: ...
    @overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: QgsUnitTypes.TemporalUnit, toUnit: QgsUnitTypes.TemporalUnit) -> float: ...
    @overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: QgsUnitTypes.VolumeUnit, toUnit: QgsUnitTypes.VolumeUnit) -> float: ...
    @overload
    @staticmethod
    def fromUnitToUnitFactor(fromUnit: QgsUnitTypes.AngleUnit, toUnit: QgsUnitTypes.AngleUnit) -> float: ...
    @staticmethod
    def stringToDistanceUnit(string: str) -> Tuple[QgsUnitTypes.DistanceUnit, bool]: ...
    @overload
    @staticmethod
    def toAbbreviatedString(unit: QgsUnitTypes.DistanceUnit) -> str: ...
    @overload
    @staticmethod
    def toAbbreviatedString(unit: QgsUnitTypes.AreaUnit) -> str: ...
    @overload
    @staticmethod
    def toAbbreviatedString(unit: QgsUnitTypes.TemporalUnit) -> str: ...
    @overload
    @staticmethod
    def toAbbreviatedString(unit: QgsUnitTypes.VolumeUnit) -> str: ...
    @overload
    @staticmethod
    def toAbbreviatedString(unit: QgsUnitTypes.RenderUnit) -> str: ...
    @overload
    @staticmethod
    def toAbbreviatedString(unit: QgsUnitTypes.LayoutUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.DistanceUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.AreaUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.TemporalUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.VolumeUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.AngleUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.RenderUnit) -> str: ...
    @overload
    @staticmethod
    def toString(unit: QgsUnitTypes.LayoutUnit) -> str: ...
    @staticmethod
    def decodeDistanceUnit(string: str) -> Tuple[QgsUnitTypes.DistanceUnit, bool]: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.DistanceUnit) -> str: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.AreaUnit) -> str: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.TemporalUnit) -> str: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.VolumeUnit) -> str: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.AngleUnit) -> str: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.RenderUnit) -> str: ...
    @overload
    @staticmethod
    def encodeUnit(unit: QgsUnitTypes.LayoutUnit) -> str: ...
    @overload
    @staticmethod
    def unitType(unit: QgsUnitTypes.DistanceUnit) -> QgsUnitTypes.DistanceUnitType: ...
    @overload
    @staticmethod
    def unitType(unit: QgsUnitTypes.AreaUnit) -> QgsUnitTypes.DistanceUnitType: ...
    @overload
    @staticmethod
    def unitType(unit: QgsUnitTypes.VolumeUnit) -> QgsUnitTypes.DistanceUnitType: ...
    @overload
    @staticmethod
    def unitType(units: QgsUnitTypes.LayoutUnit) -> QgsUnitTypes.LayoutUnitType: ...
    @staticmethod
    def decodeUnitType(string: str) -> Tuple[QgsUnitTypes.UnitType, bool]: ...
    @staticmethod
    def encodeUnitType(type: QgsUnitTypes.UnitType) -> str: ...


class QgsUserProfileManager(QtCore.QObject):

    def __init__(self, rootLocation: str = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def profilesChanged(self) -> None: ...
    def loadUserProfile(self, name: str) -> None: ...
    def setActiveUserProfile(self, profile: str) -> None: ...
    def userProfile(self) -> QgsUserProfile: ...
    def deleteProfile(self, name: str) -> QgsError: ...
    def createUserProfile(self, name: str) -> QgsError: ...
    def profileForName(self, name: str) -> QgsUserProfile: ...
    def setDefaultFromActive(self) -> None: ...
    def setDefaultProfileName(self, name: str) -> None: ...
    def defaultProfileName(self) -> str: ...
    def profileExists(self, name: str) -> bool: ...
    def allProfiles(self) -> List[str]: ...
    def rootLocationIsSet(self) -> bool: ...
    def isNewProfileNotificationEnabled(self) -> bool: ...
    def setNewProfileNotificationEnabled(self, enabled: bool) -> None: ...
    def rootLocation(self) -> str: ...
    def setRootLocation(self, rootProfileLocation: str) -> None: ...
    def getProfile(self, defaultProfile: str = ..., createNew: bool = ..., initSettings: bool = ...) -> QgsUserProfile: ...
    @staticmethod
    def resolveProfilesFolder(basePath: str = ...) -> str: ...


class QgsVector(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float) -> None: ...
    @overload
    def __init__(self, a0: QgsVector) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def toString(self, precision: int = ...) -> str: ...
    def normalized(self) -> QgsVector: ...
    def rotateBy(self, rot: float) -> QgsVector: ...
    def crossProduct(self, v: QgsVector) -> float: ...
    @overload
    def angle(self) -> float: ...
    @overload
    def angle(self, v: QgsVector) -> float: ...
    def perpVector(self) -> QgsVector: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...
    def __neg__(self) -> QgsVector: ...


class QgsVector3D(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @overload
    def __init__(self, v: QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, a0: QgsVector3D) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def toString(self, precision: int = ...) -> str: ...
    @staticmethod
    def perpendicularPoint(v1: QgsVector3D, v2: QgsVector3D, vp: QgsVector3D) -> QgsVector3D: ...
    def distance(self, other: QgsVector3D) -> float: ...
    def normalize(self) -> None: ...
    def length(self) -> float: ...
    @staticmethod
    def crossProduct(v1: QgsVector3D, v2: QgsVector3D) -> QgsVector3D: ...
    @staticmethod
    def dotProduct(v1: QgsVector3D, v2: QgsVector3D) -> float: ...
    def set(self, x: float, y: float, z: float) -> None: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...
    def isNull(self) -> bool: ...


class QgsVectorFileWriter(QgsFeatureSink):

    class ActionOnExistingFile(int):
        ...
    CreateOrOverwriteFile: QgsVectorFileWriter.ActionOnExistingFile = ...
    CreateOrOverwriteLayer: QgsVectorFileWriter.ActionOnExistingFile = ...
    AppendToLayerNoNewFields: QgsVectorFileWriter.ActionOnExistingFile = ...
    AppendToLayerAddFields: QgsVectorFileWriter.ActionOnExistingFile = ...

    class EditionCapability(int):
        ...
    CanAddNewLayer: QgsVectorFileWriter.EditionCapability = ...
    CanAppendToExistingLayer: QgsVectorFileWriter.EditionCapability = ...
    CanAddNewFieldsToExistingLayer: QgsVectorFileWriter.EditionCapability = ...
    CanDeleteLayer: QgsVectorFileWriter.EditionCapability = ...

    class VectorFormatOption(int):
        ...
    SortRecommended: QgsVectorFileWriter.VectorFormatOption = ...
    SkipNonSpatialFormats: QgsVectorFileWriter.VectorFormatOption = ...

    class FieldNameSource(int):
        ...
    Original: QgsVectorFileWriter.FieldNameSource = ...
    PreferAlias: QgsVectorFileWriter.FieldNameSource = ...

    class SymbologyExport(int):
        ...
    NoSymbology: QgsVectorFileWriter.SymbologyExport = ...
    FeatureSymbology: QgsVectorFileWriter.SymbologyExport = ...
    SymbolLayerSymbology: QgsVectorFileWriter.SymbologyExport = ...

    class WriterError(int):
        ...
    NoError: QgsVectorFileWriter.WriterError = ...
    ErrDriverNotFound: QgsVectorFileWriter.WriterError = ...
    ErrCreateDataSource: QgsVectorFileWriter.WriterError = ...
    ErrCreateLayer: QgsVectorFileWriter.WriterError = ...
    ErrAttributeTypeUnsupported: QgsVectorFileWriter.WriterError = ...
    ErrAttributeCreationFailed: QgsVectorFileWriter.WriterError = ...
    ErrProjection: QgsVectorFileWriter.WriterError = ...
    ErrFeatureWriteFailed: QgsVectorFileWriter.WriterError = ...
    ErrInvalidLayer: QgsVectorFileWriter.WriterError = ...
    ErrSavingMetadata: QgsVectorFileWriter.WriterError = ...
    Canceled: QgsVectorFileWriter.WriterError = ...

    class OptionType(int):
        ...
    Set: QgsVectorFileWriter.OptionType = ...
    String: QgsVectorFileWriter.OptionType = ...
    Int: QgsVectorFileWriter.OptionType = ...
    Hidden: QgsVectorFileWriter.OptionType = ...

    class Option(sip.wrapper):

        docString: str = ...
        type: QgsVectorFileWriter.OptionType = ...

        @overload
        def __init__(self, docString: str, type: QgsVectorFileWriter.OptionType) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.Option) -> None: ...

    class SetOption(QgsVectorFileWriter.Option):

        allowNone: bool = ...
        defaultValue: str = ...
        values: Iterable[str] = ...

        @overload
        def __init__(self, docString: str, values: Iterable[str], defaultValue: str, allowNone: bool = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.SetOption) -> None: ...

    class StringOption(QgsVectorFileWriter.Option):

        defaultValue: str = ...

        @overload
        def __init__(self, docString: str, defaultValue: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.StringOption) -> None: ...

    class IntOption(QgsVectorFileWriter.Option):

        defaultValue: int = ...

        @overload
        def __init__(self, docString: str, defaultValue: int) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.IntOption) -> None: ...

    class BoolOption(QgsVectorFileWriter.SetOption):

        @overload
        def __init__(self, docString: str, defaultValue: bool) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.BoolOption) -> None: ...

    class HiddenOption(QgsVectorFileWriter.Option):

        mValue: str = ...

        @overload
        def __init__(self, value: str) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.HiddenOption) -> None: ...

    class MetaData(sip.wrapper):

        compulsoryEncoding: str = ...
        driverOptions: typing.Any = ...
        ext: str = ...
        glob: str = ...
        layerOptions: typing.Any = ...
        longName: str = ...
        trLongName: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, longName: str, trLongName: str, glob: str, ext: str, driverOptions: typing.Any, layerOptions: typing.Any, compulsoryEncoding: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.MetaData) -> None: ...

    class VectorFormatOptions(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsVectorFileWriter.VectorFormatOptions, QgsVectorFileWriter.VectorFormatOption]) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.VectorFormatOptions) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsVectorFileWriter.VectorFormatOptions: ...
        def __int__(self) -> int: ...

    class FieldValueConverter(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.FieldValueConverter) -> None: ...

        def clone(self) -> QgsVectorFileWriter.FieldValueConverter: ...
        def convert(self, fieldIdxInLayer: int, value: typing.Any) -> typing.Any: ...
        def fieldDefinition(self, field: QgsField) -> QgsField: ...

    class EditionCapabilities(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsVectorFileWriter.EditionCapabilities, QgsVectorFileWriter.EditionCapability]) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.EditionCapabilities) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsVectorFileWriter.EditionCapabilities: ...
        def __int__(self) -> int: ...

    class SaveVectorOptions(sip.wrapper):

        actionOnExistingFile: QgsVectorFileWriter.ActionOnExistingFile = ...
        attributes: Iterable[int] = ...
        ct: QgsCoordinateTransform = ...
        datasourceOptions: Iterable[str] = ...
        driverName: str = ...
        feedback: QgsFeedback = ...
        fieldNameSource: QgsVectorFileWriter.FieldNameSource = ...
        fieldValueConverter: QgsVectorFileWriter.FieldValueConverter = ...
        fileEncoding: str = ...
        filterExtent: QgsRectangle = ...
        forceMulti: bool = ...
        includeZ: bool = ...
        layerMetadata: QgsLayerMetadata = ...
        layerName: str = ...
        layerOptions: Iterable[str] = ...
        onlySelectedFeatures: bool = ...
        overrideGeometryType: QgsWkbTypes.Type = ...
        saveMetadata: bool = ...
        skipAttributeCreation: bool = ...
        symbologyExport: QgsVectorFileWriter.SymbologyExport = ...
        symbologyScale: float = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.SaveVectorOptions) -> None: ...

    class FilterFormatDetails(sip.wrapper):

        driverName: str = ...
        filterString: str = ...
        globs: Iterable[str] = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.FilterFormatDetails) -> None: ...

    class DriverDetails(sip.wrapper):

        driverName: str = ...
        longName: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorFileWriter.DriverDetails) -> None: ...

    def __init__(self, vectorFileName: str, fileEncoding: str, fields: QgsFields, geometryType: QgsWkbTypes.Type, srs: QgsCoordinateReferenceSystem = ..., driverName: str = ..., datasourceOptions: Iterable[str] = ..., layerOptions: Iterable[str] = ..., newFilename: Optional[str] = ..., symbologyExport: QgsVectorFileWriter.SymbologyExport = ..., sinkFlags: Union[QgsFeatureSink.SinkFlags, QgsFeatureSink.SinkFlag] = ...) -> None: ...

    @staticmethod
    def areThereNewFieldsToCreate(datasetName: str, layerName: str, layer: QgsVectorLayer, attributes: Iterable[int]) -> bool: ...
    @staticmethod
    def targetLayerExists(datasetName: str, layerName: str) -> bool: ...
    @staticmethod
    def editionCapabilities(datasetName: str) -> QgsVectorFileWriter.EditionCapabilities: ...
    @staticmethod
    def defaultLayerOptions(driverName: str) -> List[str]: ...
    @staticmethod
    def defaultDatasetOptions(driverName: str) -> List[str]: ...
    @staticmethod
    def driverMetadata(driverName: str, driverMetadata: QgsVectorFileWriter.MetaData) -> bool: ...
    def setSymbologyScale(self, scale: float) -> None: ...
    def symbologyScale(self) -> float: ...
    def setSymbologyExport(self, symExport: QgsVectorFileWriter.SymbologyExport) -> None: ...
    def symbologyExport(self) -> QgsVectorFileWriter.SymbologyExport: ...
    @staticmethod
    def deleteShapeFile(fileName: str) -> bool: ...
    def addFeatureWithStyle(self, feature: QgsFeature, renderer: QgsFeatureRenderer, outputUnit: QgsUnitTypes.DistanceUnit = ...) -> bool: ...
    def lastError(self) -> str: ...
    def addFeatures(self, features: Iterable[QgsFeature], flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def addFeature(self, feature: QgsFeature, flags: Union[QgsFeatureSink.Flags, QgsFeatureSink.Flag] = ...) -> bool: ...
    def errorMessage(self) -> str: ...
    def hasError(self) -> QgsVectorFileWriter.WriterError: ...
    @staticmethod
    def convertCodecNameForEncodingOption(codecName: str) -> str: ...
    @staticmethod
    def filterForDriver(driverName: str) -> str: ...
    @staticmethod
    def fileFilterString(options: Union[QgsVectorFileWriter.VectorFormatOptions, QgsVectorFileWriter.VectorFormatOption] = ...) -> str: ...
    @staticmethod
    def driverForExtension(extension: str) -> str: ...
    @staticmethod
    def ogrDriverList(options: Union[QgsVectorFileWriter.VectorFormatOptions, QgsVectorFileWriter.VectorFormatOption] = ...) -> List[QgsVectorFileWriter.DriverDetails]: ...
    @staticmethod
    def supportsFeatureStyles(driverName: str) -> bool: ...
    @staticmethod
    def supportedFormatExtensions(options: Union[QgsVectorFileWriter.VectorFormatOptions, QgsVectorFileWriter.VectorFormatOption] = ...) -> List[str]: ...
    @staticmethod
    def supportedFiltersAndFormats(options: Union[QgsVectorFileWriter.VectorFormatOptions, QgsVectorFileWriter.VectorFormatOption] = ...) -> List[QgsVectorFileWriter.FilterFormatDetails]: ...
    @staticmethod
    def writeAsVectorFormatV3(layer: QgsVectorLayer, fileName: str, transformContext: QgsCoordinateTransformContext, options: QgsVectorFileWriter.SaveVectorOptions) -> Tuple[QgsVectorFileWriter.WriterError, str, str, str]: ...
    @staticmethod
    def writeAsVectorFormatV2(layer: QgsVectorLayer, fileName: str, transformContext: QgsCoordinateTransformContext, options: QgsVectorFileWriter.SaveVectorOptions, newFilename: Optional[str] = ..., newLayer: Optional[str] = ...) -> Tuple[QgsVectorFileWriter.WriterError, str]: ...
    @staticmethod
    def create(fileName: str, fields: QgsFields, geometryType: QgsWkbTypes.Type, srs: QgsCoordinateReferenceSystem, transformContext: QgsCoordinateTransformContext, options: QgsVectorFileWriter.SaveVectorOptions, sinkFlags: Union[QgsFeatureSink.SinkFlags, QgsFeatureSink.SinkFlag] = ..., newFilename: Optional[str] = ..., newLayer: Optional[str] = ...) -> QgsVectorFileWriter: ...
    @overload
    @staticmethod
    def writeAsVectorFormat(layer: QgsVectorLayer, fileName: str, fileEncoding: str, destCRS: QgsCoordinateReferenceSystem = ..., driverName: str = ..., onlySelected: bool = ..., datasourceOptions: Iterable[str] = ..., layerOptions: Iterable[str] = ..., skipAttributeCreation: bool = ..., newFilename: Optional[str] = ..., symbologyExport: QgsVectorFileWriter.SymbologyExport = ..., symbologyScale: float = ..., filterExtent: Optional[QgsRectangle] = ..., overrideGeometryType: QgsWkbTypes.Type = ..., forceMulti: bool = ..., includeZ: bool = ..., attributes: Iterable[int] = ..., fieldValueConverter: Optional[QgsVectorFileWriter.FieldValueConverter] = ...) -> Tuple[QgsVectorFileWriter.WriterError, str]: ...
    @overload
    @staticmethod
    def writeAsVectorFormat(layer: QgsVectorLayer, fileName: str, fileEncoding: str, ct: QgsCoordinateTransform, driverName: str = ..., onlySelected: bool = ..., datasourceOptions: Iterable[str] = ..., layerOptions: Iterable[str] = ..., skipAttributeCreation: bool = ..., newFilename: Optional[str] = ..., symbologyExport: QgsVectorFileWriter.SymbologyExport = ..., symbologyScale: float = ..., filterExtent: Optional[QgsRectangle] = ..., overrideGeometryType: QgsWkbTypes.Type = ..., forceMulti: bool = ..., includeZ: bool = ..., attributes: Iterable[int] = ..., fieldValueConverter: Optional[QgsVectorFileWriter.FieldValueConverter] = ...) -> Tuple[QgsVectorFileWriter.WriterError, str]: ...
    @overload
    @staticmethod
    def writeAsVectorFormat(layer: QgsVectorLayer, fileName: str, options: QgsVectorFileWriter.SaveVectorOptions, newFilename: Optional[str] = ...) -> Tuple[QgsVectorFileWriter.WriterError, str]: ...


class QgsVectorFileWriterTask(QgsTask):

    def __init__(self, layer: QgsVectorLayer, fileName: str, options: QgsVectorFileWriter.SaveVectorOptions) -> None: ...

    def finished(self, result: bool) -> None: ...
    def run(self) -> bool: ...
    def errorOccurred(self, error: int, errorMessage: str) -> None: ...
    def writeComplete(self, newFilename: str) -> None: ...
    def cancel(self) -> None: ...


class QgsVectorSimplifyMethod(sip.wrapper):

    class SimplifyAlgorithm(int):
        ...
    Distance: QgsVectorSimplifyMethod.SimplifyAlgorithm = ...
    SnapToGrid: QgsVectorSimplifyMethod.SimplifyAlgorithm = ...
    Visvalingam: QgsVectorSimplifyMethod.SimplifyAlgorithm = ...
    SnappedToGridGlobal: QgsVectorSimplifyMethod.SimplifyAlgorithm = ...

    class SimplifyHint(int):
        ...
    NoSimplification: QgsVectorSimplifyMethod.SimplifyHint = ...
    GeometrySimplification: QgsVectorSimplifyMethod.SimplifyHint = ...
    AntialiasingSimplification: QgsVectorSimplifyMethod.SimplifyHint = ...
    FullSimplification: QgsVectorSimplifyMethod.SimplifyHint = ...

    class SimplifyHints(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsVectorSimplifyMethod.SimplifyHints, QgsVectorSimplifyMethod.SimplifyHint]) -> None: ...
        @overload
        def __init__(self, a0: QgsVectorSimplifyMethod.SimplifyHints) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsVectorSimplifyMethod.SimplifyHints: ...
        def __int__(self) -> int: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsVectorSimplifyMethod) -> None: ...

    def maximumScale(self) -> float: ...
    def setMaximumScale(self, maximumScale: float) -> None: ...
    def forceLocalOptimization(self) -> bool: ...
    def setForceLocalOptimization(self, localOptimization: bool) -> None: ...
    def threshold(self) -> float: ...
    def setThreshold(self, threshold: float) -> None: ...
    def tolerance(self) -> float: ...
    def setTolerance(self, tolerance: float) -> None: ...
    def simplifyAlgorithm(self) -> QgsVectorSimplifyMethod.SimplifyAlgorithm: ...
    def setSimplifyAlgorithm(self, simplifyAlgorithm: QgsVectorSimplifyMethod.SimplifyAlgorithm) -> None: ...
    def simplifyHints(self) -> QgsVectorSimplifyMethod.SimplifyHints: ...
    def setSimplifyHints(self, simplifyHints: Union[QgsVectorSimplifyMethod.SimplifyHints, QgsVectorSimplifyMethod.SimplifyHint]) -> None: ...


class QgsVirtualLayerDefinition(sip.wrapper):

    class SourceLayer(sip.wrapper):

        @overload
        def __init__(self, name: str, ref: str) -> None: ...
        @overload
        def __init__(self, name: str, source: str, provider: str, encoding: str) -> None: ...
        @overload
        def __init__(self, a0: QgsVirtualLayerDefinition.SourceLayer) -> None: ...

        def encoding(self) -> str: ...
        def source(self) -> str: ...
        def provider(self) -> str: ...
        def name(self) -> str: ...
        def reference(self) -> str: ...
        def isReferenced(self) -> bool: ...

    @overload
    def __init__(self, filePath: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsVirtualLayerDefinition) -> None: ...

    def setSubsetString(self, subsetString: str) -> None: ...
    def subsetString(self) -> str: ...
    def hasDefinedGeometry(self) -> bool: ...
    def hasReferencedLayers(self) -> bool: ...
    def hasSourceLayer(self, name: str) -> bool: ...
    def setFields(self, fields: QgsFields) -> None: ...
    def fields(self) -> QgsFields: ...
    def setGeometrySrid(self, srid: int) -> None: ...
    def geometrySrid(self) -> int: ...
    def setGeometryWkbType(self, t: QgsWkbTypes.Type) -> None: ...
    def geometryWkbType(self) -> QgsWkbTypes.Type: ...
    def setGeometryField(self, geometryField: str) -> None: ...
    def geometryField(self) -> str: ...
    def isLazy(self) -> bool: ...
    def setLazy(self, lazy: bool) -> None: ...
    def setUid(self, uid: str) -> None: ...
    def uid(self) -> str: ...
    def setFilePath(self, filePath: str) -> None: ...
    def filePath(self) -> str: ...
    def setQuery(self, query: str) -> None: ...
    def query(self) -> str: ...
    def sourceLayers(self) -> List[QgsVirtualLayerDefinition.SourceLayer]: ...
    @overload
    def addSource(self, name: str, ref: str) -> None: ...
    @overload
    def addSource(self, name: str, source: str, provider: str, encoding: str = ...) -> None: ...
    def toString(self) -> str: ...
    def toUrl(self) -> QtCore.QUrl: ...
    @staticmethod
    def fromUrl(url: QtCore.QUrl) -> QgsVirtualLayerDefinition: ...


class QgsVirtualLayerDefinitionUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsVirtualLayerDefinitionUtils) -> None: ...

    @staticmethod
    def fromJoinedLayer(joinedLayer: QgsVectorLayer) -> QgsVirtualLayerDefinition: ...


class QgsVirtualLayerTask(QgsTask):

    def __init__(self, definition: QgsVirtualLayerDefinition) -> None: ...

    def setExceptionText(self, exceptionText: str) -> None: ...
    def exceptionText(self) -> str: ...
    def cancel(self) -> None: ...
    def run(self) -> bool: ...
    def definition(self) -> QgsVirtualLayerDefinition: ...
    def takeLayer(self) -> QgsVectorLayer: ...
    def layer(self) -> QgsVectorLayer: ...


class QgsXmlUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsXmlUtils) -> None: ...

    @staticmethod
    def readVariant(element: QtXml.QDomElement) -> typing.Any: ...
    @staticmethod
    def writeVariant(value: typing.Any, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @staticmethod
    def writeRectangle(rect: QgsRectangle, doc: QtXml.QDomDocument, elementName: str = ...) -> QtXml.QDomElement: ...
    @staticmethod
    def writeMapUnits(units: QgsUnitTypes.DistanceUnit, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    @staticmethod
    def readRectangle(element: QtXml.QDomElement) -> QgsRectangle: ...
    @staticmethod
    def readMapUnits(element: QtXml.QDomElement) -> QgsUnitTypes.DistanceUnit: ...


class QgsZipUtils(sip.simplewrapper):

    def zip(self, zip: str, files: Iterable[str]) -> bool: ...
    def unzip(self, zip: str, dir: str) -> Tuple[bool, List[str]]: ...
    def isZipFile(self, filename: str) -> bool: ...


class Qgs3DRendererAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, type: str) -> None: ...
    @overload
    def __init__(self, a0: Qgs3DRendererAbstractMetadata) -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsAbstract3DRenderer: ...
    def type(self) -> str: ...


class Qgs3DRendererRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: Qgs3DRendererRegistry) -> None: ...

    def renderersList(self) -> List[str]: ...
    def rendererMetadata(self, type: str) -> Qgs3DRendererAbstractMetadata: ...
    def removeRenderer(self, type: str) -> None: ...
    def addRenderer(self, metadata: Qgs3DRendererAbstractMetadata) -> None: ...


class Qgs3DSymbolAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, type: str, visibleName: str) -> None: ...
    @overload
    def __init__(self, a0: Qgs3DSymbolAbstractMetadata) -> None: ...

    def create(self) -> QgsAbstract3DSymbol: ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class Qgs3DSymbolRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    def defaultSymbolForGeometryType(self, type: QgsWkbTypes.GeometryType) -> QgsAbstract3DSymbol: ...
    def createSymbol(self, type: str) -> QgsAbstract3DSymbol: ...
    def addSymbolType(self, metadata: Qgs3DSymbolAbstractMetadata) -> bool: ...
    def symbolTypes(self) -> List[str]: ...
    def symbolMetadata(self, type: str) -> Qgs3DSymbolAbstractMetadata: ...


class QgsAbstract3DSymbol(sip.wrapper):

    class Property(int):
        ...
    PropertyHeight: QgsAbstract3DSymbol.Property = ...
    PropertyExtrusionHeight: QgsAbstract3DSymbol.Property = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstract3DSymbol) -> None: ...

    def copyBaseSettings(self, destination: QgsAbstract3DSymbol) -> None: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...
    def compatibleGeometryTypes(self) -> typing.Any: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def clone(self) -> QgsAbstract3DSymbol: ...
    def type(self) -> str: ...


class QgsAbstract3DRenderer(sip.wrapper):

    def __init__(self) -> None: ...

    def resolveReferences(self, project: QgsProject) -> None: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def clone(self) -> QgsAbstract3DRenderer: ...
    def type(self) -> str: ...


class QgsAnnotation(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def copyCommonProperties(self, target: QgsAnnotation) -> None: ...
    def _readXml(self, annotationElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _writeXml(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def minimumFrameSize(self) -> QtCore.QSizeF: ...
    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    def mapLayerChanged(self) -> None: ...
    def moved(self) -> None: ...
    def appearanceChanged(self) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def setAssociatedFeature(self, feature: QgsFeature) -> None: ...
    def associatedFeature(self) -> QgsFeature: ...
    def setMapLayer(self, layer: QgsMapLayer) -> None: ...
    def mapLayer(self) -> QgsMapLayer: ...
    def markerSymbol(self) -> QgsMarkerSymbol: ...
    def setMarkerSymbol(self, symbol: QgsMarkerSymbol) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def render(self, context: QgsRenderContext) -> None: ...
    def fillSymbol(self) -> QgsFillSymbol: ...
    def setFillSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def contentsMargin(self) -> QgsMargins: ...
    def setContentsMargin(self, margins: QgsMargins) -> None: ...
    def frameSizeMm(self) -> QtCore.QSizeF: ...
    def setFrameSizeMm(self, size: QtCore.QSizeF) -> None: ...
    def frameSize(self) -> QtCore.QSizeF: ...
    def setFrameSize(self, size: QtCore.QSizeF) -> None: ...
    def frameOffsetFromReferencePointMm(self) -> QtCore.QPointF: ...
    def setFrameOffsetFromReferencePointMm(self, offset: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def frameOffsetFromReferencePoint(self) -> QtCore.QPointF: ...
    def setFrameOffsetFromReferencePoint(self, offset: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def setRelativePosition(self, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def relativePosition(self) -> QtCore.QPointF: ...
    def setMapPositionCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def mapPositionCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setMapPosition(self, position: QgsPointXY) -> None: ...
    def mapPosition(self) -> QgsPointXY: ...
    def setHasFixedMapPosition(self, fixed: bool) -> None: ...
    def hasFixedMapPosition(self) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def isVisible(self) -> bool: ...
    def clone(self) -> QgsAnnotation: ...


class QgsAnnotationItem(sip.wrapper):

    def __init__(self) -> None: ...

    def setZIndex(self, index: int) -> None: ...
    def zIndex(self) -> int: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback) -> None: ...
    def boundingBox(self) -> QgsRectangle: ...
    def type(self) -> str: ...
    def clone(self) -> QgsAnnotationItem: ...


class QgsAnnotationItemAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, type: str, visibleName: str, visiblePluralName: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAnnotationItemAbstractMetadata) -> None: ...

    def createItem(self) -> QgsAnnotationItem: ...
    def visiblePluralName(self) -> str: ...
    def visibleName(self) -> str: ...
    def type(self) -> str: ...


class QgsAnnotationItemRegistry(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def typeAdded(self, type: str, name: str) -> None: ...
    def itemTypes(self) -> Dict[str, str]: ...
    def createItem(self, type: str) -> QgsAnnotationItem: ...
    def addItemType(self, metadata: QgsAnnotationItemAbstractMetadata) -> bool: ...
    def itemMetadata(self, type: str) -> QgsAnnotationItemAbstractMetadata: ...
    def populate(self) -> bool: ...


class QgsAnnotationLayer(QgsMapLayer):

    class LayerOptions(sip.wrapper):

        transformContext: QgsCoordinateTransformContext = ...

        @overload
        def __init__(self, transformContext: QgsCoordinateTransformContext) -> None: ...
        @overload
        def __init__(self, a0: QgsAnnotationLayer.LayerOptions) -> None: ...

    def __init__(self, name: str, options: QgsAnnotationLayer.LayerOptions) -> None: ...

    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, a3: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeXml(self, layer_node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, layerNode: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def setTransformContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def extent(self) -> QgsRectangle: ...
    def createMapRenderer(self, rendererContext: QgsRenderContext) -> QgsMapLayerRenderer: ...
    def clone(self) -> QgsAnnotationLayer: ...
    def items(self) -> typing.Any: ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    def removeItem(self, id: str) -> bool: ...
    def addItem(self, item: QgsAnnotationItem) -> str: ...
    def reset(self) -> None: ...
    def __repr__(self) -> typing.Any: ...


class QgsAnnotationLineItem(QgsAnnotationItem):

    def __init__(self, curve: QgsCurve) -> None: ...

    def setSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def symbol(self) -> QgsLineSymbol: ...
    def setGeometry(self, geometry: QgsCurve) -> None: ...
    def geometry(self) -> QgsCurve: ...
    def clone(self) -> QgsAnnotationLineItem: ...
    def boundingBox(self) -> QgsRectangle: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> QgsAnnotationLineItem: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback) -> None: ...
    def type(self) -> str: ...


class QgsAnnotationMarkerItem(QgsAnnotationItem):

    def __init__(self, point: QgsPoint) -> None: ...

    def setSymbol(self, symbol: QgsMarkerSymbol) -> None: ...
    def symbol(self) -> QgsMarkerSymbol: ...
    def setGeometry(self, geometry: QgsPoint) -> None: ...
    def geometry(self) -> QgsPointXY: ...
    def boundingBox(self) -> QgsRectangle: ...
    def clone(self) -> QgsAnnotationMarkerItem: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> QgsAnnotationMarkerItem: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback) -> None: ...
    def type(self) -> str: ...


class QgsAnnotationManager(QtCore.QObject):

    def __init__(self, project: Optional[QgsProject] = ...) -> None: ...

    def annotationAboutToBeRemoved(self, annotation: QgsAnnotation) -> None: ...
    def annotationRemoved(self) -> None: ...
    def annotationAdded(self, annotation: QgsAnnotation) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def cloneAnnotations(self) -> List[QgsAnnotation]: ...
    def annotations(self) -> List[QgsAnnotation]: ...
    def clear(self) -> None: ...
    def removeAnnotation(self, annotation: QgsAnnotation) -> bool: ...
    def addAnnotation(self, annotation: QgsAnnotation) -> bool: ...


class QgsAnnotationPointTextItem(QgsAnnotationItem):

    def __init__(self, text: str, point: QgsPointXY) -> None: ...

    def setAlignment(self, alignment: Union[QtCore.Qt.Alignment, QtCore.Qt.AlignmentFlag]) -> None: ...
    def alignment(self) -> QtCore.Qt.Alignment: ...
    def setAngle(self, angle: float) -> None: ...
    def angle(self) -> float: ...
    def setFormat(self, format: QgsTextFormat) -> None: ...
    def format(self) -> QgsTextFormat: ...
    def setText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def setPoint(self, point: QgsPointXY) -> None: ...
    def point(self) -> QgsPointXY: ...
    def boundingBox(self) -> QgsRectangle: ...
    def clone(self) -> QgsAnnotationPointTextItem: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> QgsAnnotationPointTextItem: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback) -> None: ...
    def type(self) -> str: ...


class QgsAnnotationPolygonItem(QgsAnnotationItem):

    def __init__(self, polygon: QgsCurvePolygon) -> None: ...

    def setSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def symbol(self) -> QgsFillSymbol: ...
    def setGeometry(self, geometry: QgsCurvePolygon) -> None: ...
    def geometry(self) -> QgsCurvePolygon: ...
    def boundingBox(self) -> QgsRectangle: ...
    def clone(self) -> QgsAnnotationPolygonItem: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    @staticmethod
    def create() -> QgsAnnotationPolygonItem: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def render(self, context: QgsRenderContext, feedback: QgsFeedback) -> None: ...
    def type(self) -> str: ...


class QgsHtmlAnnotation(QgsAnnotation):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> QgsHtmlAnnotation: ...
    def setAssociatedFeature(self, feature: QgsFeature) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def sourceFile(self) -> str: ...
    def setSourceFile(self, htmlFile: str) -> None: ...
    def minimumFrameSize(self) -> QtCore.QSizeF: ...
    def clone(self) -> QgsHtmlAnnotation: ...


class QgsSvgAnnotation(QgsAnnotation):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> QgsSvgAnnotation: ...
    def filePath(self) -> str: ...
    def setFilePath(self, file: str) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def clone(self) -> QgsSvgAnnotation: ...


class QgsTextAnnotation(QgsAnnotation):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def renderAnnotation(self, context: QgsRenderContext, size: QtCore.QSizeF) -> None: ...
    @staticmethod
    def create() -> QgsTextAnnotation: ...
    def readXml(self, itemElem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def setDocument(self, doc: QtGui.QTextDocument) -> None: ...
    def document(self) -> QtGui.QTextDocument: ...
    def clone(self) -> QgsTextAnnotation: ...


class QgsAuthCertUtils(sip.wrapper):

    class ConstraintGroup(int):
        ...
    KeyUsage: QgsAuthCertUtils.ConstraintGroup = ...
    ExtendedKeyUsage: QgsAuthCertUtils.ConstraintGroup = ...

    class CertUsageType(int):
        ...
    UndeterminedUsage: QgsAuthCertUtils.CertUsageType = ...
    AnyOrUnspecifiedUsage: QgsAuthCertUtils.CertUsageType = ...
    CertAuthorityUsage: QgsAuthCertUtils.CertUsageType = ...
    CertIssuerUsage: QgsAuthCertUtils.CertUsageType = ...
    TlsServerUsage: QgsAuthCertUtils.CertUsageType = ...
    TlsServerEvUsage: QgsAuthCertUtils.CertUsageType = ...
    TlsClientUsage: QgsAuthCertUtils.CertUsageType = ...
    CodeSigningUsage: QgsAuthCertUtils.CertUsageType = ...
    EmailProtectionUsage: QgsAuthCertUtils.CertUsageType = ...
    TimeStampingUsage: QgsAuthCertUtils.CertUsageType = ...
    CRLSigningUsage: QgsAuthCertUtils.CertUsageType = ...

    class CertTrustPolicy(int):
        ...
    DefaultTrust: QgsAuthCertUtils.CertTrustPolicy = ...
    Trusted: QgsAuthCertUtils.CertTrustPolicy = ...
    Untrusted: QgsAuthCertUtils.CertTrustPolicy = ...
    NoPolicy: QgsAuthCertUtils.CertTrustPolicy = ...

    class CaCertSource(int):
        ...
    SystemRoot: QgsAuthCertUtils.CaCertSource = ...
    FromFile: QgsAuthCertUtils.CaCertSource = ...
    InDatabase: QgsAuthCertUtils.CaCertSource = ...
    Connection: QgsAuthCertUtils.CaCertSource = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAuthCertUtils) -> None: ...

    @staticmethod
    def validatePKIBundle(bundle: QgsPkiBundle, useIntermediates: bool = ..., trustRootCa: bool = ...) -> List[str]: ...
    @staticmethod
    def validateCertChain(certificateChain: Iterable[QtNetwork.QSslCertificate], hostName: str = ..., trustRootCa: bool = ...) -> List[QtNetwork.QSslError]: ...
    @staticmethod
    def certIsViable(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def certViabilityErrors(cert: QtNetwork.QSslCertificate) -> List[QtNetwork.QSslError]: ...
    @staticmethod
    def certIsCurrent(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def sslErrorEnumString(errenum: QtNetwork.QSslError.SslError) -> str: ...
    @staticmethod
    def certificateIsSslClient(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def certificateIsSslServer(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def certificateIsAuthorityOrIssuer(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def certificateIsIssuer(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def certificateIsAuthority(cert: QtNetwork.QSslCertificate) -> bool: ...
    @staticmethod
    def certificateUsageTypes(cert: QtNetwork.QSslCertificate) -> List[QgsAuthCertUtils.CertUsageType]: ...
    @staticmethod
    def shaHexForCert(cert: QtNetwork.QSslCertificate, formatted: bool = ...) -> str: ...
    @staticmethod
    def getColonDelimited(txt: str) -> str: ...
    @staticmethod
    def getCertTrustName(trust: QgsAuthCertUtils.CertTrustPolicy) -> str: ...
    @staticmethod
    def resolvedCertName(cert: QtNetwork.QSslCertificate, issuer: bool = ...) -> str: ...
    @staticmethod
    def getCaSourceName(source: QgsAuthCertUtils.CaCertSource, single: bool = ...) -> str: ...
    @staticmethod
    def pemTextToTempFile(name: str, pemtext: Union[QtCore.QByteArray, bytes, bytearray]) -> str: ...
    @staticmethod
    def certsToPemText(certs: Iterable[QtNetwork.QSslCertificate]) -> QtCore.QByteArray: ...
    @staticmethod
    def pkcs12BundleCas(bundlepath: str, bundlepass: str = ...) -> List[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def pkcs12BundleToPem(bundlepath: str, bundlepass: str = ..., reencrypt: bool = ...) -> List[str]: ...
    @staticmethod
    def pemIsPkcs8(keyPemTxt: str) -> bool: ...
    @staticmethod
    def certKeyBundleToPem(certpath: str, keypath: str, keypass: str = ..., reencrypt: bool = ...) -> List[str]: ...
    @staticmethod
    def casRemoveSelfSigned(caList: Iterable[QtNetwork.QSslCertificate]) -> List[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def certsFromString(pemtext: str) -> List[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def keyFromFile(keypath: str, keypass: str = ..., algtype: Optional[str] = ...) -> QtNetwork.QSslKey: ...
    @staticmethod
    def casMerge(bundle1: Iterable[QtNetwork.QSslCertificate], bundle2: Iterable[QtNetwork.QSslCertificate]) -> List[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def certFromFile(certpath: str) -> QtNetwork.QSslCertificate: ...
    @staticmethod
    def casFromFile(certspath: str) -> List[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def certsFromFile(certspath: str) -> List[QtNetwork.QSslCertificate]: ...
    @staticmethod
    def fileData(path: str) -> QtCore.QByteArray: ...
    @staticmethod
    def mapDigestToSslConfigs(configs: Iterable[QgsAuthConfigSslServer]) -> Dict[str, QgsAuthConfigSslServer]: ...
    @staticmethod
    def mapDigestToCerts(certs: Iterable[QtNetwork.QSslCertificate]) -> Dict[str, QtNetwork.QSslCertificate]: ...
    @staticmethod
    def getSslProtocolName(protocol: QtNetwork.QSsl.SslProtocol) -> str: ...


class QgsAuthMethodConfig(sip.wrapper):

    @overload
    def __init__(self, method: str = ..., version: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAuthMethodConfig) -> None: ...

    def readXml(self, element: QtXml.QDomElement) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument) -> bool: ...
    @staticmethod
    def uriToResource(accessurl: str, resource: str, withpath: bool = ...) -> bool: ...
    def clearConfigMap(self) -> None: ...
    def hasConfig(self, key: str) -> bool: ...
    def configList(self, key: str) -> List[str]: ...
    def config(self, key: str, defaultvalue: str = ...) -> str: ...
    def removeConfig(self, key: str) -> int: ...
    def setConfigList(self, key: str, value: Iterable[str]) -> None: ...
    def setConfig(self, key: str, value: str) -> None: ...
    def setConfigMap(self, map: Dict[str, str]) -> None: ...
    def configMap(self) -> Dict[str, str]: ...
    def loadConfigString(self, configstr: str) -> None: ...
    def configString(self) -> str: ...
    def isValid(self, validateid: bool = ...) -> bool: ...
    def setVersion(self, version: int) -> None: ...
    def version(self) -> int: ...
    def setMethod(self, method: str) -> None: ...
    def method(self) -> str: ...
    def setUri(self, uri: str) -> None: ...
    def uri(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def setId(self, id: str) -> None: ...
    def id(self) -> str: ...


class QgsPkiBundle(sip.wrapper):

    @overload
    def __init__(self, clientCert: QtNetwork.QSslCertificate = ..., clientKey: QtNetwork.QSslKey = ..., caChain: Iterable[QtNetwork.QSslCertificate] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPkiBundle) -> None: ...

    def setCaChain(self, cachain: Iterable[QtNetwork.QSslCertificate]) -> None: ...
    def caChain(self) -> List[QtNetwork.QSslCertificate]: ...
    def setClientKey(self, certkey: QtNetwork.QSslKey) -> None: ...
    def clientKey(self) -> QtNetwork.QSslKey: ...
    def setClientCert(self, cert: QtNetwork.QSslCertificate) -> None: ...
    def clientCert(self) -> QtNetwork.QSslCertificate: ...
    def certId(self) -> str: ...
    def isValid(self) -> bool: ...
    def isNull(self) -> bool: ...
    @staticmethod
    def fromPkcs12Paths(bundlepath: str, bundlepass: str = ...) -> QgsPkiBundle: ...
    @staticmethod
    def fromPemPaths(certPath: str, keyPath: str, keyPass: str = ..., caChain: Iterable[QtNetwork.QSslCertificate] = ...) -> QgsPkiBundle: ...


class QgsPkiConfigBundle(sip.wrapper):

    @overload
    def __init__(self, config: QgsAuthMethodConfig, cert: QtNetwork.QSslCertificate, certkey: QtNetwork.QSslKey, cachain: Iterable[QtNetwork.QSslCertificate] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPkiConfigBundle) -> None: ...

    def setCaChain(self, caChain: Iterable[QtNetwork.QSslCertificate]) -> None: ...
    def caChain(self) -> List[QtNetwork.QSslCertificate]: ...
    def setClientCertKey(self, certkey: QtNetwork.QSslKey) -> None: ...
    def clientCertKey(self) -> QtNetwork.QSslKey: ...
    def setClientCert(self, cert: QtNetwork.QSslCertificate) -> None: ...
    def clientCert(self) -> QtNetwork.QSslCertificate: ...
    def setConfig(self, config: QgsAuthMethodConfig) -> None: ...
    def config(self) -> QgsAuthMethodConfig: ...
    def isValid(self) -> bool: ...


class QgsAuthConfigSslServer(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAuthConfigSslServer) -> None: ...

    def isNull(self) -> bool: ...
    def loadConfigString(self, config: str = ...) -> None: ...
    def configString(self) -> str: ...
    def setQtVersion(self, version: int) -> None: ...
    def qtVersion(self) -> int: ...
    def setVersion(self, version: int) -> None: ...
    def version(self) -> int: ...
    def setSslPeerVerifyDepth(self, depth: int) -> None: ...
    def sslPeerVerifyDepth(self) -> int: ...
    def setSslPeerVerifyMode(self, mode: QtNetwork.QSslSocket.PeerVerifyMode) -> None: ...
    def sslPeerVerifyMode(self) -> QtNetwork.QSslSocket.PeerVerifyMode: ...
    def setSslIgnoredErrorEnums(self, errors: typing.Any) -> None: ...
    def sslIgnoredErrorEnums(self) -> typing.Any: ...
    def sslIgnoredErrors(self) -> List[QtNetwork.QSslError]: ...
    def setSslProtocol(self, protocol: QtNetwork.QSsl.SslProtocol) -> None: ...
    def sslProtocol(self) -> QtNetwork.QSsl.SslProtocol: ...
    def setSslHostPort(self, hostport: str) -> None: ...
    def sslHostPort(self) -> str: ...
    def setSslCertificate(self, cert: QtNetwork.QSslCertificate) -> None: ...
    def sslCertificate(self) -> QtNetwork.QSslCertificate: ...


class QgsAuthManager(QtCore.QObject):

    class MessageLevel(int):
        ...
    INFO: QgsAuthManager.MessageLevel = ...
    WARNING: QgsAuthManager.MessageLevel = ...
    CRITICAL: QgsAuthManager.MessageLevel = ...

    AUTH_MAN_TAG: str = ...
    AUTH_PASSWORD_HELPER_DISPLAY_NAME: str = ...

    def __init__(self) -> None: ...

    def clearCachedConfig(self, authcfg: str) -> None: ...
    def clearAllCachedConfigs(self) -> None: ...
    def authDatabaseChanged(self) -> None: ...
    def authDatabaseEraseRequested(self) -> None: ...
    def masterPasswordVerified(self, verified: bool) -> None: ...
    def passwordHelperMessageOut(self, message: str, tag: str = ..., level: QgsAuthManager.MessageLevel = ...) -> None: ...
    def messageOut(self, message: str, tag: str = ..., level: QgsAuthManager.MessageLevel = ...) -> None: ...
    def passwordHelperSuccess(self) -> None: ...
    def passwordHelperFailure(self) -> None: ...
    def passwordHelperSync(self) -> bool: ...
    def setPasswordHelperEnabled(self, enabled: bool) -> None: ...
    def passwordHelperEnabled(self) -> bool: ...
    def trustedCaCertsPemText(self) -> QtCore.QByteArray: ...
    def trustedCaCertsCache(self) -> List[QtNetwork.QSslCertificate]: ...
    def rebuildTrustedCaCertsCache(self) -> bool: ...
    def untrustedCaCerts(self, trustedCAs: Iterable[QtNetwork.QSslCertificate] = ...) -> List[QtNetwork.QSslCertificate]: ...
    def trustedCaCerts(self, includeinvalid: bool = ...) -> List[QtNetwork.QSslCertificate]: ...
    def rebuildCertTrustCache(self) -> bool: ...
    def certTrustCache(self) -> Dict[QgsAuthCertUtils.CertTrustPolicy, List[str]]: ...
    def defaultCertTrustPolicy(self) -> QgsAuthCertUtils.CertTrustPolicy: ...
    def setDefaultCertTrustPolicy(self, policy: QgsAuthCertUtils.CertTrustPolicy) -> bool: ...
    def certificateTrustPolicy(self, cert: QtNetwork.QSslCertificate) -> QgsAuthCertUtils.CertTrustPolicy: ...
    def removeCertTrustPolicy(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def removeCertTrustPolicies(self, certs: Iterable[QtNetwork.QSslCertificate]) -> bool: ...
    def certTrustPolicy(self, cert: QtNetwork.QSslCertificate) -> QgsAuthCertUtils.CertTrustPolicy: ...
    def storeCertTrustPolicy(self, cert: QtNetwork.QSslCertificate, policy: QgsAuthCertUtils.CertTrustPolicy) -> bool: ...
    def rebuildCaCertsCache(self) -> bool: ...
    def mappedDatabaseCAs(self) -> Dict[str, QtNetwork.QSslCertificate]: ...
    def databaseCAs(self) -> List[QtNetwork.QSslCertificate]: ...
    def extraFileCAs(self) -> List[QtNetwork.QSslCertificate]: ...
    def systemRootCAs(self) -> List[QtNetwork.QSslCertificate]: ...
    def removeCertAuthority(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def existsCertAuthority(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def certAuthority(self, id: str) -> QtNetwork.QSslCertificate: ...
    def storeCertAuthority(self, cert: QtNetwork.QSslCertificate) -> bool: ...
    def storeCertAuthorities(self, certs: Iterable[QtNetwork.QSslCertificate]) -> bool: ...
    def rebuildIgnoredSslErrorCache(self) -> bool: ...
    def updateIgnoredSslErrorsCache(self, shahostport: str, errors: Iterable[QtNetwork.QSslError]) -> bool: ...
    def updateIgnoredSslErrorsCacheFromConfig(self, config: QgsAuthConfigSslServer) -> bool: ...
    def dumpIgnoredSslErrorsCache_(self) -> None: ...
    def removeSslCertCustomConfig(self, id: str, hostport: str) -> bool: ...
    def existsSslCertCustomConfig(self, id: str, hostport: str) -> bool: ...
    def sslCertCustomConfigs(self) -> List[QgsAuthConfigSslServer]: ...
    def sslCertCustomConfigByHost(self, hostport: str) -> QgsAuthConfigSslServer: ...
    def sslCertCustomConfig(self, id: str, hostport: str) -> QgsAuthConfigSslServer: ...
    def storeSslCertCustomConfig(self, config: QgsAuthConfigSslServer) -> bool: ...
    def removeCertIdentity(self, id: str) -> bool: ...
    def existsCertIdentity(self, id: str) -> bool: ...
    def certIdentityIds(self) -> List[str]: ...
    def certIdentities(self) -> List[QtNetwork.QSslCertificate]: ...
    def certIdentityBundleToPem(self, id: str) -> List[str]: ...
    def certIdentity(self, id: str) -> QtNetwork.QSslCertificate: ...
    def storeCertIdentity(self, cert: QtNetwork.QSslCertificate, key: QtNetwork.QSslKey) -> bool: ...
    def initSslCaches(self) -> bool: ...
    def removeAuthSetting(self, key: str) -> bool: ...
    def existsAuthSetting(self, key: str) -> bool: ...
    def authSetting(self, key: str, defaultValue: typing.Any = ..., decrypt: bool = ...) -> typing.Any: ...
    def storeAuthSetting(self, key: str, value: typing.Any, encrypt: bool = ...) -> bool: ...
    def updateNetworkProxy(self, proxy: QtNetwork.QNetworkProxy, authcfg: str, dataprovider: str = ...) -> Tuple[bool, QtNetwork.QNetworkProxy]: ...
    def updateDataSourceUriItems(self, connectionItems: Iterable[str], authcfg: str, dataprovider: str = ...) -> Tuple[bool, List[str]]: ...
    def updateNetworkReply(self, reply: QtNetwork.QNetworkReply, authcfg: str, dataprovider: str = ...) -> bool: ...
    def updateNetworkRequest(self, request: QtNetwork.QNetworkRequest, authcfg: str, dataprovider: str = ...) -> Tuple[bool, QtNetwork.QNetworkRequest]: ...
    def eraseAuthenticationDatabase(self, backup: bool, backuppath: Optional[str] = ...) -> Tuple[bool, str]: ...
    def backupAuthenticationDatabase(self, backuppath: Optional[str] = ...) -> Tuple[bool, str]: ...
    def removeAllAuthenticationConfigs(self) -> bool: ...
    def importAuthenticationConfigsFromXml(self, filename: str, password: str = ..., overwrite: bool = ...) -> bool: ...
    def exportAuthenticationConfigsToXml(self, filename: str, authcfgs: Iterable[str], password: str = ...) -> bool: ...
    def removeAuthenticationConfig(self, authcfg: str) -> bool: ...
    def loadAuthenticationConfig(self, authcfg: str, mconfig: QgsAuthMethodConfig, full: bool = ...) -> Tuple[bool, QgsAuthMethodConfig]: ...
    def updateAuthenticationConfig(self, config: QgsAuthMethodConfig) -> bool: ...
    def storeAuthenticationConfig(self, mconfig: QgsAuthMethodConfig, overwrite: bool = ...) -> Tuple[bool, QgsAuthMethodConfig]: ...
    def configIds(self) -> List[str]: ...
    def configIdRegex(self) -> str: ...
    def hasConfigId(self, txt: str) -> bool: ...
    def configIdUnique(self, id: str) -> bool: ...
    def uniqueConfigId(self) -> str: ...
    def supportedAuthMethodExpansions(self, authcfg: str) -> QgsAuthMethod.Expansions: ...
    def authMethodEditWidget(self, authMethodKey: str, parent: QtWidgets.QWidget) -> QtWidgets.QWidget: ...
    def authMethod(self, authMethodKey: str) -> QgsAuthMethod: ...
    def authMethodsKeys(self, dataprovider: str = ...) -> List[str]: ...
    def configAuthMethodKey(self, authcfg: str) -> str: ...
    def configAuthMethod(self, authcfg: str) -> QgsAuthMethod: ...
    def updateConfigAuthMethods(self) -> None: ...
    def availableAuthMethodConfigs(self, dataprovider: str = ...) -> Dict[str, QgsAuthMethodConfig]: ...
    def registerCoreAuthMethods(self) -> bool: ...
    def authManTag(self) -> str: ...
    def setScheduledAuthDatabaseEraseRequestEmitted(self, emitted: bool) -> None: ...
    def resetMasterPassword(self, newpass: str, oldpass: str, keepbackup: bool, backuppath: Optional[str] = ...) -> Tuple[bool, str]: ...
    def masterPasswordSame(self, pass_: str) -> bool: ...
    def clearMasterPassword(self) -> None: ...
    def masterPasswordHashInDatabase(self) -> bool: ...
    def masterPasswordIsSet(self) -> bool: ...
    def verifyMasterPassword(self, compare: str = ...) -> bool: ...
    @overload
    def setMasterPassword(self, verify: bool = ...) -> bool: ...
    @overload
    def setMasterPassword(self, pass_: str, verify: bool = ...) -> bool: ...
    def authenticationDatabasePath(self) -> str: ...
    def disabledMessage(self) -> str: ...
    def isDisabled(self) -> bool: ...
    def authDatabaseServersTable(self) -> str: ...
    def authDatabaseConfigTable(self) -> str: ...
    def authDatabaseConnection(self) -> QtSql.QSqlDatabase: ...
    def init(self, pluginPath: str = ..., authDatabasePath: str = ...) -> bool: ...


class QgsAuthMethod(QtCore.QObject):

    class Expansion(int):
        ...
    NetworkRequest: QgsAuthMethod.Expansion = ...
    NetworkReply: QgsAuthMethod.Expansion = ...
    DataSourceUri: QgsAuthMethod.Expansion = ...
    GenericDataSourceUri: QgsAuthMethod.Expansion = ...
    NetworkProxy: QgsAuthMethod.Expansion = ...
    All: QgsAuthMethod.Expansion = ...

    class Expansions(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsAuthMethod.Expansions, QgsAuthMethod.Expansion]) -> None: ...
        @overload
        def __init__(self, a0: QgsAuthMethod.Expansions) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsAuthMethod.Expansions: ...
        def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def setDataProviders(self, dataproviders: Iterable[str]) -> None: ...
    def setExpansions(self, expansions: Union[QgsAuthMethod.Expansions, QgsAuthMethod.Expansion]) -> None: ...
    def setVersion(self, version: int) -> None: ...
    @staticmethod
    def authMethodTag() -> str: ...
    def updateMethodConfig(self, mconfig: QgsAuthMethodConfig) -> None: ...
    def clearCachedConfig(self, authcfg: str) -> None: ...
    def updateNetworkProxy(self, proxy: QtNetwork.QNetworkProxy, authcfg: str, dataprovider: str = ...) -> bool: ...
    def updateDataSourceUriItems(self, connectionItems: Iterable[str], authcfg: str, dataprovider: str = ...) -> bool: ...
    def updateNetworkReply(self, reply: QtNetwork.QNetworkReply, authcfg: str, dataprovider: str = ...) -> bool: ...
    def updateNetworkRequest(self, request: QtNetwork.QNetworkRequest, authcfg: str, dataprovider: str = ...) -> bool: ...
    def supportedDataProviders(self) -> List[str]: ...
    def supportedExpansions(self) -> QgsAuthMethod.Expansions: ...
    def version(self) -> int: ...
    def displayDescription(self) -> str: ...
    def description(self) -> str: ...
    def key(self) -> str: ...


class QgsBrowserModel(QtCore.QAbstractItemModel):

    class ItemDataRole(int):
        ...
    PathRole: QgsBrowserModel.ItemDataRole = ...
    CommentRole: QgsBrowserModel.ItemDataRole = ...
    SortRole: QgsBrowserModel.ItemDataRole = ...
    ProviderKeyRole: QgsBrowserModel.ItemDataRole = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def removeRootItems(self) -> None: ...
    def addRootItems(self) -> None: ...
    def initialize(self) -> None: ...
    def hidePath(self, item: QgsDataItem) -> None: ...
    def updateProjectHome(self) -> None: ...
    def removeFavorite(self, index: QtCore.QModelIndex) -> None: ...
    def addFavoriteDirectory(self, directory: str, name: str = ...) -> None: ...
    def itemStateChanged(self, item: QgsDataItem, oldState: Qgis.BrowserItemState) -> None: ...
    def itemDataChanged(self, item: QgsDataItem) -> None: ...
    def endRemoveItems(self) -> None: ...
    def beginRemoveItems(self, parent: QgsDataItem, first: int, last: int) -> None: ...
    def endInsertItems(self) -> None: ...
    def beginInsertItems(self, parent: QgsDataItem, first: int, last: int) -> None: ...
    def refreshDrives(self) -> None: ...
    def reload(self) -> None: ...
    def connectionsChanged(self, providerKey: str) -> None: ...
    def stateChanged(self, index: QtCore.QModelIndex, oldState: Qgis.BrowserItemState) -> None: ...
    def driveItems(self) -> typing.Any: ...
    def initialized(self) -> bool: ...
    def connectItem(self, item: QgsDataItem) -> None: ...
    def findUri(self, uri: str, index: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def findPath(self, path: str, matchFlag: QtCore.Qt.MatchFlag = ...) -> QtCore.QModelIndex: ...
    @overload
    def refresh(self, path: str) -> None: ...
    @overload
    def refresh(self, index: QtCore.QModelIndex = ...) -> None: ...
    def dataItem(self, idx: QtCore.QModelIndex) -> QgsDataItem: ...
    def findItem(self, item: QgsDataItem, parent: Optional[QgsDataItem] = ...) -> QtCore.QModelIndex: ...
    def fetchMore(self, parent: QtCore.QModelIndex) -> None: ...
    def canFetchMore(self, parent: QtCore.QModelIndex) -> bool: ...
    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...


class QgsBrowserProxyModel(QtCore.QSortFilterProxyModel):

    class FilterSyntax(int):
        ...
    Normal: QgsBrowserProxyModel.FilterSyntax = ...
    Wildcards: QgsBrowserProxyModel.FilterSyntax = ...
    RegularExpression: QgsBrowserProxyModel.FilterSyntax = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def hasChildren(self, parent: QtCore.QModelIndex = ...) -> bool: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def setShowLayers(self, showLayers: bool) -> None: ...
    def showLayers(self) -> bool: ...
    def setShownDataItemProviderKeyFilter(self, shownItemsFilter: Iterable[str]) -> None: ...
    def setHiddenDataItemProviderKeyFilter(self, hiddenItemsFilter: Iterable[str]) -> None: ...
    def setLayerType(self, type: QgsMapLayerType) -> None: ...
    def layerType(self) -> QgsMapLayerType: ...
    def setFilterByLayerType(self, enabled: bool) -> None: ...
    def filterByLayerType(self) -> bool: ...
    def caseSensitivity(self) -> QtCore.Qt.CaseSensitivity: ...
    def setFilterCaseSensitivity(self, sensitivity: QtCore.Qt.CaseSensitivity) -> None: ...
    def filterString(self) -> str: ...
    def setFilterString(self, filter: str) -> None: ...
    def filterSyntax(self) -> QgsBrowserProxyModel.FilterSyntax: ...
    def setFilterSyntax(self, syntax: QgsBrowserProxyModel.FilterSyntax) -> None: ...
    def dataItem(self, index: QtCore.QModelIndex) -> QgsDataItem: ...
    def browserModel(self) -> QgsBrowserModel: ...
    def setBrowserModel(self, model: QgsBrowserModel) -> None: ...


class QgsDataItem(QtCore.QObject):

    def __init__(self, type: Qgis.BrowserItemType, parent: QgsDataItem, name: str, path: str, providerKey: str = ...) -> None: ...

    def updateIcon(self) -> None: ...
    def connectionsChanged(self, providerKey: str = ...) -> None: ...
    def stateChanged(self, item: QgsDataItem, oldState: Qgis.BrowserItemState) -> None: ...
    def dataChanged(self, item: QgsDataItem) -> None: ...
    def endRemoveItems(self) -> None: ...
    def beginRemoveItems(self, parent: QgsDataItem, first: int, last: int) -> None: ...
    def endInsertItems(self) -> None: ...
    def beginInsertItems(self, parent: QgsDataItem, first: int, last: int) -> None: ...
    def childrenCreated(self) -> None: ...
    def refreshConnections(self, providerKey: str = ...) -> None: ...
    def depopulate(self) -> None: ...
    def deferredDelete(self) -> bool: ...
    @overload
    def refresh(self, children: typing.Any) -> None: ...
    @overload
    def refresh(self) -> None: ...
    @overload
    def populate(self, children: typing.Any) -> None: ...
    @overload
    def populate(self, foreground: bool = ...) -> None: ...
    def databaseConnection(self) -> QgsAbstractDatabaseProviderConnection: ...
    def moveToThread(self, targetThread: QtCore.QThread) -> None: ...
    @overload
    @staticmethod
    def deleteLater(items: typing.Any) -> None: ...
    @overload
    def deleteLater(self) -> None: ...
    def toolTip(self) -> str: ...
    def setToolTip(self, msg: str) -> None: ...
    def setIconName(self, iconName: str) -> None: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def setSortKey(self, key: typing.Any) -> None: ...
    def sortKey(self) -> typing.Any: ...
    @staticmethod
    def pathComponent(component: str) -> str: ...
    def setProviderKey(self, value: str) -> None: ...
    def providerKey(self) -> str: ...
    def setPath(self, path: str) -> None: ...
    def path(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def children(self) -> typing.Any: ...
    def setParent(self, parent: QgsDataItem) -> None: ...
    def parent(self) -> QgsDataItem: ...
    def type(self) -> Qgis.BrowserItemType: ...
    @staticmethod
    def findItem(items: typing.Any, item: QgsDataItem) -> int: ...
    def setCapabilities(self, capabilities: int) -> None: ...
    def setCapabilitiesV2(self, capabilities: Union[Qgis.BrowserItemCapabilities, Qgis.BrowserItemCapability]) -> None: ...
    def capabilities2(self) -> Qgis.BrowserItemCapabilities: ...
    def rename(self, name: str) -> bool: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> bool: ...
    def mimeUris(self) -> List[QgsMimeDataUtils.Uri]: ...
    def mimeUri(self) -> QgsMimeDataUtils.Uri: ...
    def hasDragEnabled(self) -> bool: ...
    def handleDoubleClick(self) -> bool: ...
    def handleDrop(self, a0: QtCore.QMimeData, a1: QtCore.Qt.DropAction) -> bool: ...
    def acceptDrop(self) -> bool: ...
    def menus(self, parent: QtWidgets.QWidget) -> List[QtWidgets.QMenu]: ...
    def actions(self, parent: QtWidgets.QWidget) -> List[QtWidgets.QAction]: ...
    def paramWidget(self) -> QtWidgets.QWidget: ...
    def equal(self, other: QgsDataItem) -> bool: ...
    def removeChildItem(self, child: QgsDataItem) -> QgsDataItem: ...
    def deleteChildItem(self, child: QgsDataItem) -> None: ...
    def addChildItem(self, child: QgsDataItem, refresh: bool = ...) -> None: ...
    def setState(self, state: Qgis.BrowserItemState) -> None: ...
    def state(self) -> Qgis.BrowserItemState: ...
    def createChildren(self) -> typing.Any: ...
    def rowCount(self) -> int: ...
    def layerCollection(self) -> bool: ...
    def hasChildren(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...


class QgsDataCollectionItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem, name: str, path: str = ..., providerKey: str = ...) -> None: ...

    @staticmethod
    def homeDirIcon(fillColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., strokeColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> QtGui.QIcon: ...
    @staticmethod
    def openDirIcon(fillColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., strokeColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> QtGui.QIcon: ...
    def databaseConnection(self) -> QgsAbstractDatabaseProviderConnection: ...
    @staticmethod
    def iconDataCollection() -> QtGui.QIcon: ...
    @staticmethod
    def iconDir(fillColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., strokeColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> QtGui.QIcon: ...
    def addChild(self, item: QgsDataItem) -> None: ...
    def __repr__(self) -> typing.Any: ...


class QgsConnectionsRootItem(QgsDataCollectionItem):

    def __init__(self, parent: QgsDataItem, name: str, path: str = ..., providerKey: str = ...) -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsDatabaseSchemaItem(QgsDataCollectionItem):

    def __init__(self, parent: QgsDataItem, name: str, path: str = ..., providerKey: str = ...) -> None: ...

    @staticmethod
    def iconDataCollection() -> QtGui.QIcon: ...
    def databaseConnection(self) -> QgsAbstractDatabaseProviderConnection: ...
    def __repr__(self) -> typing.Any: ...


class QgsErrorItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem, error: str, path: str) -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsDataItemProvider(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDataItemProvider) -> None: ...

    def handlesDirectoryPath(self, path: str) -> bool: ...
    def createDataItems(self, path: str, parentItem: QgsDataItem) -> typing.Any: ...
    def createDataItem(self, path: str, parentItem: QgsDataItem) -> QgsDataItem: ...
    def capabilities(self) -> int: ...
    def dataProviderKey(self) -> str: ...
    def name(self) -> str: ...


class QgsDataItemProviderRegistry(QtCore.QObject):

    def __init__(self) -> None: ...

    def providerWillBeRemoved(self, provider: QgsDataItemProvider) -> None: ...
    def providerAdded(self, provider: QgsDataItemProvider) -> None: ...
    def dataProviderKey(self, dataItemProviderName: str) -> str: ...
    def removeProvider(self, provider: QgsDataItemProvider) -> None: ...
    def addProvider(self, provider: QgsDataItemProvider) -> None: ...
    def provider(self, providerName: str) -> QgsDataItemProvider: ...
    def providers(self) -> List[QgsDataItemProvider]: ...


class QgsDirectoryItem(QgsDataCollectionItem):

    @overload
    def __init__(self, parent: QgsDataItem, name: str, path: str) -> None: ...
    @overload
    def __init__(self, parent: QgsDataItem, name: str, dirPath: str, path: str, providerKey: str = ...) -> None: ...

    def init(self) -> None: ...
    def directoryChanged(self) -> None: ...
    def childrenCreated(self) -> None: ...
    def setMonitoring(self, monitoring: Qgis.BrowserDirectoryMonitoring) -> None: ...
    def monitoring(self) -> Qgis.BrowserDirectoryMonitoring: ...
    def isMonitored(self) -> bool: ...
    @staticmethod
    def pathShouldByMonitoredByDefault(path: str) -> bool: ...
    @staticmethod
    def monitoringForPath(path: str) -> Qgis.BrowserDirectoryMonitoring: ...
    @staticmethod
    def hiddenPath(path: str) -> bool: ...
    def mimeUris(self) -> List[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    def paramWidget(self) -> QtWidgets.QWidget: ...
    @staticmethod
    def setCustomColor(directory: str, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setIconColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def iconColor(self) -> QtGui.QColor: ...
    def icon(self) -> QtGui.QIcon: ...
    def equal(self, other: QgsDataItem) -> bool: ...
    def dirPath(self) -> str: ...
    def createChildren(self) -> typing.Any: ...
    def setState(self, state: Qgis.BrowserItemState) -> None: ...
    def __repr__(self) -> typing.Any: ...


class QgsDirectoryParamWidget(QtWidgets.QTreeWidget):

    def __init__(self, path: str, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...

    def showHideColumn(self) -> None: ...
    def mousePressEvent(self, event: QtGui.QMouseEvent) -> None: ...


class QgsFavoritesItem(QgsDataCollectionItem):

    def __init__(self, parent: QgsDataItem, name: str, path: str = ...) -> None: ...

    def sortKey(self) -> typing.Any: ...
    @staticmethod
    def iconFavorites() -> QtGui.QIcon: ...
    def renameFavorite(self, path: str, name: str) -> None: ...
    def removeDirectory(self, item: QgsDirectoryItem) -> None: ...
    def addDirectory(self, directory: str, name: str = ...) -> None: ...
    def createChildren(self) -> typing.Any: ...
    def __repr__(self) -> typing.Any: ...


class QgsFieldsItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem, path: str, connectionUri: str, providerKey: str, schema: str, tableName: str) -> None: ...

    def tableProperty(self) -> QgsAbstractDatabaseProviderConnection.TableProperty: ...
    def layer(self) -> QgsVectorLayer: ...
    def connectionUri(self) -> str: ...
    def tableName(self) -> str: ...
    def schema(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def createChildren(self) -> typing.Any: ...
    def __repr__(self) -> typing.Any: ...


class QgsFieldItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem, field: QgsField) -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def __repr__(self) -> typing.Any: ...


class QgsLayerItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem, name: str, path: str, uri: str, layerType: Qgis.BrowserLayerType, providerKey: str) -> None: ...

    def layerName(self) -> str: ...
    @staticmethod
    def iconPointCloud() -> QtGui.QIcon: ...
    @staticmethod
    def iconVectorTile() -> QtGui.QIcon: ...
    @staticmethod
    def iconMesh() -> QtGui.QIcon: ...
    @staticmethod
    def iconDefault() -> QtGui.QIcon: ...
    @staticmethod
    def iconRaster() -> QtGui.QIcon: ...
    @staticmethod
    def iconTable() -> QtGui.QIcon: ...
    @staticmethod
    def iconPolygon() -> QtGui.QIcon: ...
    @staticmethod
    def iconLine() -> QtGui.QIcon: ...
    @staticmethod
    def iconPoint() -> QtGui.QIcon: ...
    @staticmethod
    def iconForWkbType(type: QgsWkbTypes.Type) -> QtGui.QIcon: ...
    def deleteLayer(self) -> bool: ...
    @staticmethod
    def iconName(layerType: Qgis.BrowserLayerType) -> str: ...
    @staticmethod
    def layerTypeAsString(layerType: Qgis.BrowserLayerType) -> str: ...
    def comments(self) -> str: ...
    def supportedFormats(self) -> List[str]: ...
    def supportedCrs(self) -> List[str]: ...
    def providerKey(self) -> str: ...
    def uri(self) -> str: ...
    @staticmethod
    def typeFromMapLayer(layer: QgsMapLayer) -> Qgis.BrowserLayerType: ...
    def mapLayerType(self) -> QgsMapLayerType: ...
    def mimeUris(self) -> List[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    def equal(self, other: QgsDataItem) -> bool: ...
    def __repr__(self) -> typing.Any: ...


class QgsProjectItem(QgsDataItem):

    def __init__(self, parent: QgsDataItem, name: str, path: str, providerKey: str = ...) -> None: ...

    def mimeUris(self) -> List[QgsMimeDataUtils.Uri]: ...
    def hasDragEnabled(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...


class QgsZipItem(QgsDataCollectionItem):

    sProviderNames: Iterable[str] = ...

    @overload
    def __init__(self, parent: QgsDataItem, name: str, path: str) -> None: ...
    @overload
    def __init__(self, parent: QgsDataItem, name: str, filePath: str, path: str, providerKey: str = ...) -> None: ...

    @staticmethod
    def iconZip() -> QtGui.QIcon: ...
    @staticmethod
    def itemFromFilePath(parent: QgsDataItem, filePath: str, name: str, path: str) -> QgsDataItem: ...
    @staticmethod
    def itemFromPath(parent: QgsDataItem, path: str, name: str) -> QgsDataItem: ...
    @staticmethod
    def vsiPrefix(uri: str) -> str: ...
    def getZipFileList(self) -> List[str]: ...
    def createChildren(self) -> typing.Any: ...
    def __repr__(self) -> typing.Any: ...


class QgsCallout(sip.wrapper):

    class LabelAnchorPoint(int):
        ...
    LabelPointOnExterior: QgsCallout.LabelAnchorPoint = ...
    LabelCentroid: QgsCallout.LabelAnchorPoint = ...
    LabelTopLeft: QgsCallout.LabelAnchorPoint = ...
    LabelTopMiddle: QgsCallout.LabelAnchorPoint = ...
    LabelTopRight: QgsCallout.LabelAnchorPoint = ...
    LabelMiddleLeft: QgsCallout.LabelAnchorPoint = ...
    LabelMiddleRight: QgsCallout.LabelAnchorPoint = ...
    LabelBottomLeft: QgsCallout.LabelAnchorPoint = ...
    LabelBottomMiddle: QgsCallout.LabelAnchorPoint = ...
    LabelBottomRight: QgsCallout.LabelAnchorPoint = ...

    class AnchorPoint(int):
        ...
    PoleOfInaccessibility: QgsCallout.AnchorPoint = ...
    PointOnExterior: QgsCallout.AnchorPoint = ...
    PointOnSurface: QgsCallout.AnchorPoint = ...
    Centroid: QgsCallout.AnchorPoint = ...

    class DrawOrder(int):
        ...
    OrderBelowAllLabels: QgsCallout.DrawOrder = ...
    OrderBelowIndividualLabels: QgsCallout.DrawOrder = ...

    class Property(int):
        ...
    MinimumCalloutLength: QgsCallout.Property = ...
    OffsetFromAnchor: QgsCallout.Property = ...
    OffsetFromLabel: QgsCallout.Property = ...
    DrawCalloutToAllParts: QgsCallout.Property = ...
    AnchorPointPosition: QgsCallout.Property = ...
    LabelAnchorPointPosition: QgsCallout.Property = ...
    OriginX: QgsCallout.Property = ...
    OriginY: QgsCallout.Property = ...
    DestinationX: QgsCallout.Property = ...
    DestinationY: QgsCallout.Property = ...
    Curvature: QgsCallout.Property = ...
    Orientation: QgsCallout.Property = ...
    Margins: QgsCallout.Property = ...
    WedgeWidth: QgsCallout.Property = ...
    CornerRadius: QgsCallout.Property = ...
    BlendMode: QgsCallout.Property = ...

    class QgsCalloutContext(sip.wrapper):

        allFeaturePartsLabeled: bool = ...
        originalFeatureCrs: QgsCoordinateReferenceSystem = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsCallout.QgsCalloutContext) -> None: ...

        def positions(self) -> List[QgsCalloutPosition]: ...
        def addCalloutPosition(self, position: QgsCalloutPosition) -> None: ...
        def originalFeatureToMapTransform(self, renderContext: QgsRenderContext) -> QgsCoordinateTransform: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCallout) -> None: ...

    def calloutLineToPart(self, labelGeometry: QgsGeometry, partGeometry: QgsAbstractGeometry, context: QgsRenderContext, calloutContext: QgsCallout.QgsCalloutContext) -> Tuple[QgsGeometry, bool]: ...
    def calloutLabelPoint(self, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsCallout.LabelAnchorPoint, context: QgsRenderContext, calloutContext: QgsCallout.QgsCalloutContext) -> Tuple[QgsGeometry, bool]: ...
    def labelAnchorGeometry(self, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsCallout.LabelAnchorPoint) -> QgsGeometry: ...
    def draw(self, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> None: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    @staticmethod
    def decodeLabelAnchorPoint(name: str) -> Tuple[QgsCallout.LabelAnchorPoint, bool]: ...
    @staticmethod
    def encodeLabelAnchorPoint(anchor: QgsCallout.LabelAnchorPoint) -> str: ...
    def setLabelAnchorPoint(self, anchor: QgsCallout.LabelAnchorPoint) -> None: ...
    def labelAnchorPoint(self) -> QgsCallout.LabelAnchorPoint: ...
    @staticmethod
    def decodeAnchorPoint(name: str) -> Tuple[QgsCallout.AnchorPoint, bool]: ...
    @staticmethod
    def encodeAnchorPoint(anchor: QgsCallout.AnchorPoint) -> str: ...
    def setAnchorPoint(self, anchor: QgsCallout.AnchorPoint) -> None: ...
    def anchorPoint(self) -> QgsCallout.AnchorPoint: ...
    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def render(self, context: QgsRenderContext, rect: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> None: ...
    def drawOrder(self) -> QgsCallout.DrawOrder: ...
    def referencedFields(self, context: QgsRenderContext) -> Set[str]: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def containsAdvancedEffects(self) -> bool: ...
    def restoreProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def saveProperties(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def readProperties(self, props: Dict[str, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsCallout: ...
    def type(self) -> str: ...


class QgsSimpleLineCallout(QgsCallout):

    def __init__(self) -> None: ...

    def createCalloutLine(self, start: QgsPoint, end: QgsPoint, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> QgsCurve: ...
    def draw(self, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> None: ...
    def setDrawCalloutToAllParts(self, drawToAllParts: bool) -> None: ...
    def drawCalloutToAllParts(self) -> bool: ...
    def offsetFromLabelMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromLabelMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromLabelUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setOffsetFromLabelUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setOffsetFromLabel(self, distance: float) -> None: ...
    def offsetFromLabel(self) -> float: ...
    def offsetFromAnchorMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromAnchorMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromAnchorUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setOffsetFromAnchorUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setOffsetFromAnchor(self, distance: float) -> None: ...
    def offsetFromAnchor(self) -> float: ...
    def minimumLengthMapUnitScale(self) -> QgsMapUnitScale: ...
    def setMinimumLengthMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def minimumLengthUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setMinimumLengthUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setMinimumLength(self, length: float) -> None: ...
    def minimumLength(self) -> float: ...
    def setLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def lineSymbol(self) -> QgsLineSymbol: ...
    def referencedFields(self, context: QgsRenderContext) -> Set[str]: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def readProperties(self, props: Dict[str, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsSimpleLineCallout: ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout: ...


class QgsManhattanLineCallout(QgsSimpleLineCallout):

    def __init__(self) -> None: ...

    def createCalloutLine(self, start: QgsPoint, end: QgsPoint, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> QgsCurve: ...
    def clone(self) -> QgsManhattanLineCallout: ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout: ...


class QgsCurvedLineCallout(QgsSimpleLineCallout):

    class Orientation(int):
        ...
    Automatic: QgsCurvedLineCallout.Orientation = ...
    Clockwise: QgsCurvedLineCallout.Orientation = ...
    CounterClockwise: QgsCurvedLineCallout.Orientation = ...

    def __init__(self) -> None: ...

    def createCalloutLine(self, start: QgsPoint, end: QgsPoint, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> QgsCurve: ...
    def setOrientation(self, orientation: QgsCurvedLineCallout.Orientation) -> None: ...
    def orientation(self) -> QgsCurvedLineCallout.Orientation: ...
    def setCurvature(self, curvature: float) -> None: ...
    def curvature(self) -> float: ...
    def properties(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsCurvedLineCallout: ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout: ...


class QgsBalloonCallout(QgsCallout):

    def __init__(self) -> None: ...

    def draw(self, context: QgsRenderContext, bodyBoundingBox: QtCore.QRectF, angle: float, anchor: QgsGeometry, calloutContext: QgsCallout.QgsCalloutContext) -> None: ...
    def cornerRadiusMapUnitScale(self) -> QgsMapUnitScale: ...
    def setCornerRadiusMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def cornerRadiusUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setCornerRadiusUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setCornerRadius(self, radius: float) -> None: ...
    def cornerRadius(self) -> float: ...
    def wedgeWidthMapUnitScale(self) -> QgsMapUnitScale: ...
    def setWedgeWidthMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def wedgeWidthUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setWedgeWidthUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setWedgeWidth(self, width: float) -> None: ...
    def wedgeWidth(self) -> float: ...
    def marginsUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setMarginsUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setMargins(self, margins: QgsMargins) -> None: ...
    def margins(self) -> QgsMargins: ...
    def offsetFromAnchorMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetFromAnchorMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetFromAnchorUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setOffsetFromAnchorUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def setOffsetFromAnchor(self, distance: float) -> None: ...
    def offsetFromAnchor(self) -> float: ...
    def setFillSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def fillSymbol(self) -> QgsFillSymbol: ...
    def referencedFields(self, context: QgsRenderContext) -> Set[str]: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def readProperties(self, props: Dict[str, typing.Any], context: QgsReadWriteContext) -> None: ...
    def properties(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsBalloonCallout: ...
    def type(self) -> str: ...
    @staticmethod
    def create(properties: Dict[str, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout: ...


class QgsCalloutAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, name: str, visibleName: str, icon: QtGui.QIcon = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsCalloutAbstractMetadata) -> None: ...

    def createCalloutWidget(self, a0: QgsVectorLayer) -> QgsCalloutWidget: ...
    def createCallout(self, properties: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsCallout: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def visibleName(self) -> str: ...
    def name(self) -> str: ...


class QgsCalloutMetadata(QgsCalloutAbstractMetadata):

    def __init__(self, a0: QgsCalloutMetadata) -> None: ...

    def createCalloutWidget(self, vl: QgsVectorLayer) -> QgsCalloutWidget: ...
    def createCallout(self, properties: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsCallout: ...


class QgsCalloutRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    @staticmethod
    def defaultCallout() -> QgsCallout: ...
    def calloutTypes(self) -> List[str]: ...
    @overload
    def createCallout(self, type: str, properties: Dict[str, typing.Any] = ..., context: QgsReadWriteContext = ...) -> QgsCallout: ...
    @overload
    def createCallout(self, type: str, element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsCallout: ...
    def addCalloutType(self, metadata: QgsCalloutAbstractMetadata) -> bool: ...
    def calloutMetadata(self, type: str) -> QgsCalloutAbstractMetadata: ...


class QgsClassificationMethod(sip.wrapper):

    class ClassPosition(int):
        ...
    LowerBound: QgsClassificationMethod.ClassPosition = ...
    Inner: QgsClassificationMethod.ClassPosition = ...
    UpperBound: QgsClassificationMethod.ClassPosition = ...

    class MethodProperty(int):
        ...
    NoFlag: QgsClassificationMethod.MethodProperty = ...
    ValuesNotRequired: QgsClassificationMethod.MethodProperty = ...
    SymmetricModeAvailable: QgsClassificationMethod.MethodProperty = ...

    class MethodProperties(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsClassificationMethod.MethodProperties, QgsClassificationMethod.MethodProperty]) -> None: ...
        @overload
        def __init__(self, a0: QgsClassificationMethod.MethodProperties) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsClassificationMethod.MethodProperties: ...
        def __int__(self) -> int: ...

    MAX_PRECISION: int = ...
    MIN_PRECISION: int = ...

    @overload
    def __init__(self, properties: Union[QgsClassificationMethod.MethodProperties, QgsClassificationMethod.MethodProperty] = ..., codeComplexity: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationMethod) -> None: ...

    def addParameter(self, definition: QgsProcessingParameterDefinition) -> None: ...
    def formatNumber(self, value: float) -> str: ...
    def copyBase(self, c: QgsClassificationMethod) -> None: ...
    def parameterValues(self) -> Dict[str, typing.Any]: ...
    def setParameterValues(self, values: Dict[str, typing.Any]) -> None: ...
    def parameterDefinitions(self) -> List[QgsProcessingParameterDefinition]: ...
    def parameterDefinition(self, parameterName: str) -> QgsProcessingParameterDefinition: ...
    @staticmethod
    def makeBreaksSymmetric(breaks: Iterable[float], symmetryPoint: float, astride: bool) -> List[float]: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsClassificationMethod: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    @overload
    def classes(self, layer: QgsVectorLayer, expression: str, nclasses: int) -> List[QgsClassificationRange]: ...
    @overload
    def classes(self, values: Iterable[float], nclasses: int) -> List[QgsClassificationRange]: ...
    @overload
    def classes(self, minimum: float, maximum: float, nclasses: int) -> List[QgsClassificationRange]: ...
    @staticmethod
    def rangesToBreaks(classes: Iterable[QgsClassificationRange]) -> List[float]: ...
    def setLabelTrimTrailingZeroes(self, trimTrailingZeroes: bool) -> None: ...
    def labelTrimTrailingZeroes(self) -> bool: ...
    def setLabelPrecision(self, labelPrecision: int) -> None: ...
    def labelPrecision(self) -> int: ...
    def setLabelFormat(self, format: str) -> None: ...
    def labelFormat(self) -> str: ...
    def setSymmetricMode(self, enabled: bool, symmetryPoint: float = ..., symmetryAstride: bool = ...) -> None: ...
    def symmetryAstride(self) -> bool: ...
    def symmetryPoint(self) -> float: ...
    def symmetricModeEnabled(self) -> bool: ...
    def symmetricModeAvailable(self) -> bool: ...
    def codeComplexity(self) -> int: ...
    def valuesRequired(self) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    def labelForRange(self, lowerValue: float, upperValue: float, position: QgsClassificationMethod.ClassPosition = ...) -> str: ...
    @overload
    def labelForRange(self, range: QgsRendererRange, position: QgsClassificationMethod.ClassPosition = ...) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsClassificationMethod: ...


class QgsClassificationCustom(QgsClassificationMethod):

    METHOD_ID: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationCustom) -> None: ...

    def valuesRequired(self) -> bool: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsClassificationMethod: ...


class QgsClassificationEqualInterval(QgsClassificationMethod):

    METHOD_ID: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationEqualInterval) -> None: ...

    def valuesRequired(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationJenks(QgsClassificationMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationJenks) -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationLogarithmic(QgsClassificationMethod):

    class NegativeValueHandling(int):
        ...
    NoHandling: QgsClassificationLogarithmic.NegativeValueHandling = ...
    Discard: QgsClassificationLogarithmic.NegativeValueHandling = ...
    PrependBreak: QgsClassificationLogarithmic.NegativeValueHandling = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationLogarithmic) -> None: ...

    def valuesRequired(self) -> bool: ...
    def labelForRange(self, lowerValue: float, upperValue: float, position: QgsClassificationMethod.ClassPosition) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def id(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsClassificationMethod: ...


class QgsClassificationRange(sip.wrapper):

    @overload
    def __init__(self, label: str, lowerBound: float, upperBound: float) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationRange) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def label(self) -> str: ...
    def upperBound(self) -> float: ...
    def lowerBound(self) -> float: ...


class QgsClassificationMethodRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationMethodRegistry) -> None: ...

    def icon(self, id: str) -> QtGui.QIcon: ...
    def methodNames(self) -> Dict[str, str]: ...
    def method(self, id: str) -> QgsClassificationMethod: ...
    def addMethod(self, method: QgsClassificationMethod) -> bool: ...


class QgsClassificationPrettyBreaks(QgsClassificationMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationPrettyBreaks) -> None: ...

    def valuesRequired(self) -> bool: ...
    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationQuantile(QgsClassificationMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationQuantile) -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsClassificationStandardDeviation(QgsClassificationMethod):

    METHOD_ID: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsClassificationStandardDeviation) -> None: ...

    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def labelForRange(self, lowerValue: float, upperValue: float, position: QgsClassificationMethod.ClassPosition) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def clone(self) -> QgsClassificationMethod: ...
    def id(self) -> str: ...
    def name(self) -> str: ...


class QgsDiagram(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsDiagram) -> None: ...

    def sizeForValue(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def scaledFont(self, s: QgsDiagramSettings, c: QgsRenderContext) -> QtGui.QFont: ...
    @overload
    def sizePainterUnits(self, size: QtCore.QSizeF, s: QgsDiagramSettings, c: QgsRenderContext) -> QtCore.QSizeF: ...
    @overload
    def sizePainterUnits(self, l: float, s: QgsDiagramSettings, c: QgsRenderContext) -> float: ...
    def setPenWidth(self, pen: Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], s: QgsDiagramSettings, c: QgsRenderContext) -> None: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> float: ...
    @overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def diagramName(self) -> str: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def getExpression(self, expression: str, context: QgsExpressionContext) -> QgsExpression: ...
    def clearCache(self) -> None: ...
    def clone(self) -> QgsDiagram: ...


class QgsHistogramDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> float: ...
    @overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def clone(self) -> QgsHistogramDiagram: ...


class QgsPieDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> float: ...
    @overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def clone(self) -> QgsPieDiagram: ...


class QgsStackedBarDiagram(QgsDiagram):

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> float: ...
    @overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def clone(self) -> QgsStackedBarDiagram: ...


class QgsTextDiagram(QgsDiagram):

    class Orientation(int):
        ...
    Horizontal: QgsTextDiagram.Orientation = ...
    Vertical: QgsTextDiagram.Orientation = ...

    class Shape(int):
        ...
    Circle: QgsTextDiagram.Shape = ...
    Rectangle: QgsTextDiagram.Shape = ...
    Triangle: QgsTextDiagram.Shape = ...

    def __init__(self) -> None: ...

    def diagramName(self) -> str: ...
    def legendSize(self, value: float, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> float: ...
    @overload
    def diagramSize(self, attributes: typing.Any, c: QgsRenderContext, s: QgsDiagramSettings) -> QtCore.QSizeF: ...
    @overload
    def diagramSize(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, is_: QgsDiagramInterpolationSettings) -> QtCore.QSizeF: ...
    def renderDiagram(self, feature: QgsFeature, c: QgsRenderContext, s: QgsDiagramSettings, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def clone(self) -> QgsTextDiagram: ...


class QgsDxfExport(sip.wrapper):

    class DxfPolylineFlag(int):
        ...
    Closed: QgsDxfExport.DxfPolylineFlag = ...
    Curve: QgsDxfExport.DxfPolylineFlag = ...
    Spline: QgsDxfExport.DxfPolylineFlag = ...
    Is3DPolyline: QgsDxfExport.DxfPolylineFlag = ...
    Is3DPolygonMesh: QgsDxfExport.DxfPolylineFlag = ...
    PolygonMesh: QgsDxfExport.DxfPolylineFlag = ...
    PolyfaceMesh: QgsDxfExport.DxfPolylineFlag = ...
    ContinuousPattern: QgsDxfExport.DxfPolylineFlag = ...

    class HAlign(int):
        ...
    HLeft: QgsDxfExport.HAlign = ...
    HCenter: QgsDxfExport.HAlign = ...
    HRight: QgsDxfExport.HAlign = ...
    HAligned: QgsDxfExport.HAlign = ...
    HMiddle: QgsDxfExport.HAlign = ...
    HFit: QgsDxfExport.HAlign = ...
    Undefined: QgsDxfExport.HAlign = ...  # type: ignore

    class VAlign(int):
        ...
    VBaseLine: QgsDxfExport.VAlign = ...
    VBottom: QgsDxfExport.VAlign = ...
    VMiddle: QgsDxfExport.VAlign = ...
    VTop: QgsDxfExport.VAlign = ...
    Undefined: QgsDxfExport.VAlign = ...

    class ExportResult(int):
        ...
    Success: QgsDxfExport.ExportResult = ...
    InvalidDeviceError: QgsDxfExport.ExportResult = ...
    DeviceNotWritableError: QgsDxfExport.ExportResult = ...
    EmptyExtentError: QgsDxfExport.ExportResult = ...

    class Flag(int):
        ...
    FlagNoMText: QgsDxfExport.Flag = ...

    class SymbologyExport(int):
        ...
    NoSymbology: QgsDxfExport.SymbologyExport = ...
    FeatureSymbology: QgsDxfExport.SymbologyExport = ...
    SymbolLayerSymbology: QgsDxfExport.SymbologyExport = ...

    class DxfLayer(sip.wrapper):

        @overload
        def __init__(self, vl: QgsVectorLayer, layerOutputAttributeIndex: int = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsDxfExport.DxfLayer) -> None: ...

        def splitLayerAttribute(self) -> str: ...
        def layerOutputAttributeIndex(self) -> int: ...
        def layer(self) -> QgsVectorLayer: ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsDxfExport.Flags, QgsDxfExport.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsDxfExport.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsDxfExport.Flags: ...
        def __int__(self) -> int: ...

    class DxfPolylineFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsDxfExport.DxfPolylineFlags, QgsDxfExport.DxfPolylineFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsDxfExport.DxfPolylineFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsDxfExport.DxfPolylineFlags: ...
        def __int__(self) -> int: ...

    def __init__(self) -> None: ...

    def registerDxfLayer(self, layerId: str, fid: int, layer: str) -> None: ...
    @staticmethod
    def encodings() -> List[str]: ...
    @staticmethod
    def dxfEncoding(name: str) -> str: ...
    @staticmethod
    def dxfLayerName(name: str) -> str: ...
    def clipValueToMapUnitScale(self, scale: QgsMapUnitScale, pixelToMMFactor: float) -> float: ...
    @staticmethod
    def mapUnitScaleFactor(scale: float, symbolUnits: QgsUnitTypes.RenderUnit, mapUnits: QgsUnitTypes.DistanceUnit, mapUnitsPerPixel: float = ...) -> float: ...
    def writeMText(self, layer: str, text: str, pt: QgsPoint, width: float, angle: float, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def writeTextV2(self, layer: str, text: str, pt: QgsPoint, size: float, angle: float, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], hali: QgsDxfExport.HAlign = ..., vali: QgsDxfExport.VAlign = ...) -> None: ...
    def writeCircleV2(self, layer: str, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], pt: QgsPoint, radius: float, lineStyleName: str, width: float) -> None: ...
    def writeFillCircleV2(self, layer: str, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], pt: QgsPoint, radius: float) -> None: ...
    def writePointV2(self, layer: str, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], pt: QgsPoint) -> None: ...
    def writeLine(self, pt1: QgsPoint, pt2: QgsPoint, layer: str, lineStyleName: str, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], width: float = ...) -> None: ...
    def writeHandle(self, code: int = ..., handle: int = ...) -> int: ...
    def writeString(self, s: str) -> None: ...
    def writeDouble(self, d: float) -> None: ...
    def writeInt(self, i: int) -> None: ...
    def writeGroupCode(self, code: int) -> None: ...
    def writeGroupPointV2(self, code: int, p: QgsPoint) -> None: ...
    @overload
    def writeGroup(self, code: int, s: str) -> None: ...
    @overload
    def writeGroup(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], exactMatch: int = ..., rgbCode: int = ..., transparencyCode: int = ...) -> None: ...
    def writeGroupDouble(self, code: int, d: float) -> None: ...
    def writeGroupLong(self, code: int, i: int) -> None: ...
    def writeGroupInt(self, code: int, i: int) -> None: ...
    @overload
    def layerName(self, id: str, f: QgsFeature) -> str: ...
    @overload
    def layerName(self, vl: QgsVectorLayer) -> str: ...
    @staticmethod
    def closestColorMatch(color: int) -> int: ...
    def force2d(self) -> bool: ...
    def setForce2d(self, force2d: bool) -> None: ...
    def layerTitleAsName(self) -> bool: ...
    def setLayerTitleAsName(self, layerTitleAsName: bool) -> None: ...
    def extent(self) -> QgsRectangle: ...
    def setExtent(self, r: QgsRectangle) -> None: ...
    def symbologyExport(self) -> QgsDxfExport.SymbologyExport: ...
    def setSymbologyExport(self, e: QgsDxfExport.SymbologyExport) -> None: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def mapUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def symbologyScale(self) -> float: ...
    def setSymbologyScale(self, scale: float) -> None: ...
    def writeToFile(self, d: QtCore.QIODevice, codec: str) -> QgsDxfExport.ExportResult: ...
    def addLayers(self, layers: Iterable[QgsDxfExport.DxfLayer]) -> None: ...
    def flags(self) -> QgsDxfExport.Flags: ...
    def setFlags(self, flags: Union[QgsDxfExport.Flags, QgsDxfExport.Flag]) -> None: ...
    def setMapSettings(self, settings: QgsMapSettings) -> None: ...


class QgsEditFormConfig(sip.wrapper):

    class DataDefinedProperty(int):
        ...
    NoProperty: QgsEditFormConfig.DataDefinedProperty = ...
    AllProperties: QgsEditFormConfig.DataDefinedProperty = ...
    Alias: QgsEditFormConfig.DataDefinedProperty = ...

    class PythonInitCodeSource(int):
        ...
    CodeSourceNone: QgsEditFormConfig.PythonInitCodeSource = ...
    CodeSourceFile: QgsEditFormConfig.PythonInitCodeSource = ...
    CodeSourceDialog: QgsEditFormConfig.PythonInitCodeSource = ...
    CodeSourceEnvironment: QgsEditFormConfig.PythonInitCodeSource = ...

    class FeatureFormSuppress(int):
        ...
    SuppressDefault: QgsEditFormConfig.FeatureFormSuppress = ...
    SuppressOn: QgsEditFormConfig.FeatureFormSuppress = ...
    SuppressOff: QgsEditFormConfig.FeatureFormSuppress = ...

    class EditorLayout(int):
        ...
    GeneratedLayout: QgsEditFormConfig.EditorLayout = ...
    TabLayout: QgsEditFormConfig.EditorLayout = ...
    UiFileLayout: QgsEditFormConfig.EditorLayout = ...

    class GroupData(sip.wrapper):

        mFields: Iterable[str] = ...
        mName: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, name: str, fields: Iterable[str]) -> None: ...
        @overload
        def __init__(self, a0: QgsEditFormConfig.GroupData) -> None: ...

    class TabData(sip.wrapper):

        mFields: Iterable[str] = ...
        mGroups: Iterable[QgsEditFormConfig.GroupData] = ...
        mName: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, name: str, fields: Iterable[str], groups: Iterable[QgsEditFormConfig.GroupData]) -> None: ...
        @overload
        def __init__(self, a0: QgsEditFormConfig.TabData) -> None: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, o: QgsEditFormConfig) -> None: ...
    @overload
    def __init__(self) -> None: ...

    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...
    def dataDefinedFieldProperties(self, fieldName: str) -> QgsPropertyCollection: ...
    def setDataDefinedFieldProperties(self, fieldName: str, properties: QgsPropertyCollection) -> None: ...
    def attributeEditorElementFromDomElement(self, elem: QtXml.QDomElement, parent: QgsAttributeEditorElement, layerId: str = ..., context: QgsReadWriteContext = ...) -> QgsAttributeEditorElement: ...
    def writeXml(self, node: QtXml.QDomNode, context: QgsReadWriteContext) -> None: ...
    def readXml(self, node: QtXml.QDomNode, context: QgsReadWriteContext) -> None: ...
    def setSuppress(self, s: QgsEditFormConfig.FeatureFormSuppress) -> None: ...
    def suppress(self) -> QgsEditFormConfig.FeatureFormSuppress: ...
    def setInitCodeSource(self, initCodeSource: QgsEditFormConfig.PythonInitCodeSource) -> None: ...
    def initCodeSource(self) -> QgsEditFormConfig.PythonInitCodeSource: ...
    def setInitFilePath(self, filePath: str) -> None: ...
    def initFilePath(self) -> str: ...
    def setInitCode(self, code: str) -> None: ...
    def initCode(self) -> str: ...
    def setInitFunction(self, function: str) -> None: ...
    def initFunction(self) -> str: ...
    def setReuseLastValue(self, index: int, reuse: bool) -> None: ...
    def reuseLastValue(self, index: int) -> bool: ...
    def setLabelOnTop(self, idx: int, onTop: bool) -> None: ...
    def labelOnTop(self, idx: int) -> bool: ...
    def setReadOnly(self, idx: int, readOnly: bool = ...) -> None: ...
    def readOnly(self, idx: int) -> bool: ...
    def removeWidgetConfig(self, widgetName: str) -> bool: ...
    def widgetConfig(self, widgetName: str) -> Dict[str, typing.Any]: ...
    def setWidgetConfig(self, widgetName: str, config: Dict[str, typing.Any]) -> bool: ...
    def setUiForm(self, ui: str) -> None: ...
    def uiForm(self) -> str: ...
    def setLayout(self, editorLayout: QgsEditFormConfig.EditorLayout) -> None: ...
    def layout(self) -> QgsEditFormConfig.EditorLayout: ...
    def invisibleRootContainer(self) -> QgsAttributeEditorContainer: ...
    def clearTabs(self) -> None: ...
    def tabs(self) -> List[QgsAttributeEditorElement]: ...
    def addTab(self, data: QgsAttributeEditorElement) -> None: ...


class QgsAttributeEditorElement(sip.wrapper):

    class AttributeEditorType(int):
        ...
    AeTypeContainer: QgsAttributeEditorElement.AttributeEditorType = ...
    AeTypeField: QgsAttributeEditorElement.AttributeEditorType = ...
    AeTypeRelation: QgsAttributeEditorElement.AttributeEditorType = ...
    AeTypeInvalid: QgsAttributeEditorElement.AttributeEditorType = ...
    AeTypeQmlElement: QgsAttributeEditorElement.AttributeEditorType = ...
    AeTypeHtmlElement: QgsAttributeEditorElement.AttributeEditorType = ...

    @overload
    def __init__(self, type: QgsAttributeEditorElement.AttributeEditorType, name: str, parent: Optional[QgsAttributeEditorElement] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorElement) -> None: ...

    def setShowLabel(self, showLabel: bool) -> None: ...
    def showLabel(self) -> bool: ...
    def clone(self, parent: QgsAttributeEditorElement) -> QgsAttributeEditorElement: ...
    def toDomElement(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def parent(self) -> QgsAttributeEditorElement: ...
    def type(self) -> QgsAttributeEditorElement.AttributeEditorType: ...
    def name(self) -> str: ...
    @staticmethod
    def create(element: QtXml.QDomElement, layerId: str, fields: QgsFields, context: QgsReadWriteContext, parent: Optional[QgsAttributeEditorElement] = ...) -> QgsAttributeEditorElement: ...


class QgsAttributeEditorContainer(QgsAttributeEditorElement):

    @overload
    def __init__(self, name: str, parent: QgsAttributeEditorElement, backgroundColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorContainer) -> None: ...

    def setBackgroundColor(self, backgroundColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setVisibilityExpression(self, visibilityExpression: QgsOptionalExpression) -> None: ...
    def visibilityExpression(self) -> QgsOptionalExpression: ...
    def clone(self, parent: QgsAttributeEditorElement) -> QgsAttributeEditorElement: ...
    def setColumnCount(self, columnCount: int) -> None: ...
    def columnCount(self) -> int: ...
    def setName(self, name: str) -> None: ...
    def clear(self) -> None: ...
    def findElements(self, type: QgsAttributeEditorElement.AttributeEditorType) -> List[QgsAttributeEditorElement]: ...
    def children(self) -> List[QgsAttributeEditorElement]: ...
    def isGroupBox(self) -> bool: ...
    def setIsGroupBox(self, isGroupBox: bool) -> None: ...
    def addChildElement(self, element: QgsAttributeEditorElement) -> None: ...


class QgsAttributeEditorField(QgsAttributeEditorElement):

    @overload
    def __init__(self, name: str, idx: int, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorField) -> None: ...

    def clone(self, parent: QgsAttributeEditorElement) -> QgsAttributeEditorElement: ...
    def idx(self) -> int: ...


class QgsAttributeEditorRelation(QgsAttributeEditorElement):

    class Button(int):
        ...
    Link: QgsAttributeEditorRelation.Button = ...
    Unlink: QgsAttributeEditorRelation.Button = ...
    SaveChildEdits: QgsAttributeEditorRelation.Button = ...
    AddChildFeature: QgsAttributeEditorRelation.Button = ...
    DuplicateChildFeature: QgsAttributeEditorRelation.Button = ...
    DeleteChildFeature: QgsAttributeEditorRelation.Button = ...
    ZoomToChildFeature: QgsAttributeEditorRelation.Button = ...
    AllButtons: QgsAttributeEditorRelation.Button = ...

    class Buttons(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsAttributeEditorRelation.Buttons, QgsAttributeEditorRelation.Button]) -> None: ...
        @overload
        def __init__(self, a0: QgsAttributeEditorRelation.Buttons) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsAttributeEditorRelation.Buttons: ...
        def __int__(self) -> int: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, name: str, relationId: str, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, name: str, relation: QgsRelation, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, relationId: str, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, relation: QgsRelation, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorRelation) -> None: ...

    def setRelationEditorConfiguration(self, config: Dict[str, typing.Any]) -> None: ...
    def relationEditorConfiguration(self) -> Dict[str, typing.Any]: ...
    def setRelationWidgetTypeId(self, relationWidgetTypeId: str) -> None: ...
    def relationWidgetTypeId(self) -> str: ...
    def setLabel(self, label: str = ...) -> None: ...
    def label(self) -> str: ...
    def setNmRelationId(self, nmRelationId: typing.Any = ...) -> None: ...
    def nmRelationId(self) -> typing.Any: ...
    def setForceSuppressFormPopup(self, forceSuppressFormPopup: bool) -> None: ...
    def forceSuppressFormPopup(self) -> bool: ...
    def clone(self, parent: QgsAttributeEditorElement) -> QgsAttributeEditorElement: ...
    def init(self, relManager: QgsRelationManager) -> bool: ...
    def relation(self) -> QgsRelation: ...


class QgsAttributeEditorHtmlElement(QgsAttributeEditorElement):

    @overload
    def __init__(self, name: str, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorHtmlElement) -> None: ...

    def setHtmlCode(self, htmlCode: str) -> None: ...
    def htmlCode(self) -> str: ...
    def clone(self, parent: QgsAttributeEditorElement) -> QgsAttributeEditorElement: ...


class QgsAttributeEditorQmlElement(QgsAttributeEditorElement):

    @overload
    def __init__(self, name: str, parent: QgsAttributeEditorElement) -> None: ...
    @overload
    def __init__(self, a0: QgsAttributeEditorQmlElement) -> None: ...

    def setQmlCode(self, qmlCode: str) -> None: ...
    def qmlCode(self) -> str: ...
    def clone(self, parent: QgsAttributeEditorElement) -> QgsAttributeEditorElement: ...


class QgsPaintEffect(sip.wrapper):

    class DrawMode(int):
        ...
    Modifier: QgsPaintEffect.DrawMode = ...
    Render: QgsPaintEffect.DrawMode = ...
    ModifyAndRender: QgsPaintEffect.DrawMode = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsPaintEffect) -> None: ...

    def fixQPictureDpi(self, painter: QtGui.QPainter) -> None: ...
    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def imageOffset(self, context: QgsRenderContext) -> QtCore.QPointF: ...
    def sourceAsImage(self, context: QgsRenderContext) -> QtGui.QImage: ...
    def source(self) -> QtGui.QPicture: ...
    def drawSource(self, painter: QtGui.QPainter) -> None: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def setDrawMode(self, drawMode: QgsPaintEffect.DrawMode) -> None: ...
    def drawMode(self) -> QgsPaintEffect.DrawMode: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def end(self, context: QgsRenderContext) -> None: ...
    def begin(self, context: QgsRenderContext) -> None: ...
    def render(self, picture: QtGui.QPicture, context: QgsRenderContext) -> None: ...
    def saveProperties(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement) -> bool: ...
    @overload
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    @overload
    def readProperties(self, element: QtXml.QDomElement) -> bool: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsPaintEffect: ...
    def type(self) -> str: ...


class QgsBlurEffect(QgsPaintEffect):

    class BlurMethod(int):
        ...
    StackBlur: QgsBlurEffect.BlurMethod = ...
    GaussianBlur: QgsBlurEffect.BlurMethod = ...

    def __init__(self) -> None: ...

    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def blurMethod(self) -> QgsBlurEffect.BlurMethod: ...
    def setBlurMethod(self, method: QgsBlurEffect.BlurMethod) -> None: ...
    def blurMapUnitScale(self) -> QgsMapUnitScale: ...
    def setBlurMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def blurUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setBlurUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def blurLevel(self) -> float: ...
    def setBlurLevel(self, level: float) -> None: ...
    def clone(self) -> QgsBlurEffect: ...
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsColorEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def draw(self, context: QgsRenderContext) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def colorizeStrength(self) -> int: ...
    def setColorizeStrength(self, colorizeStrength: int) -> None: ...
    def colorizeColor(self) -> QtGui.QColor: ...
    def setColorizeColor(self, colorizeColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def colorizeOn(self) -> bool: ...
    def setColorizeOn(self, colorizeOn: bool) -> None: ...
    def grayscaleMode(self) -> QgsImageOperation.GrayscaleMode: ...
    def setGrayscaleMode(self, grayscaleMode: QgsImageOperation.GrayscaleMode) -> None: ...
    def saturation(self) -> float: ...
    def setSaturation(self, saturation: float) -> None: ...
    def contrast(self) -> int: ...
    def setContrast(self, contrast: int) -> None: ...
    def brightness(self) -> int: ...
    def setBrightness(self, brightness: int) -> None: ...
    def clone(self) -> QgsColorEffect: ...
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsEffectStack(QgsPaintEffect):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsEffectStack) -> None: ...
    @overload
    def __init__(self, effect: QgsPaintEffect) -> None: ...

    def draw(self, context: QgsRenderContext) -> None: ...
    def effect(self, index: int) -> QgsPaintEffect: ...
    def count(self) -> int: ...
    def effectList(self) -> List[QgsPaintEffect]: ...
    def takeEffect(self, index: int) -> QgsPaintEffect: ...
    def changeEffect(self, index: int, effect: QgsPaintEffect) -> bool: ...
    def insertEffect(self, index: int, effect: QgsPaintEffect) -> bool: ...
    def appendEffect(self, effect: QgsPaintEffect) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    @overload
    def readProperties(self, element: QtXml.QDomElement) -> bool: ...
    @overload
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def saveProperties(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement) -> bool: ...
    def clone(self) -> QgsEffectStack: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsGlowEffect(QgsPaintEffect):

    class GlowColorType(int):
        ...
    SingleColor: QgsGlowEffect.GlowColorType = ...
    ColorRamp: QgsGlowEffect.GlowColorType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsGlowEffect) -> None: ...

    def shadeExterior(self) -> bool: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def colorType(self) -> QgsGlowEffect.GlowColorType: ...
    def setColorType(self, colorType: QgsGlowEffect.GlowColorType) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def ramp(self) -> QgsColorRamp: ...
    def setRamp(self, ramp: QgsColorRamp) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def blurMapUnitScale(self) -> QgsMapUnitScale: ...
    def setBlurMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def blurUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setBlurUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def blurLevel(self) -> float: ...
    def setBlurLevel(self, level: float) -> None: ...
    def spreadMapUnitScale(self) -> QgsMapUnitScale: ...
    def setSpreadMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def spreadUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setSpreadUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def spread(self) -> float: ...
    def setSpread(self, spread: float) -> None: ...
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...


class QgsOuterGlowEffect(QgsGlowEffect):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsOuterGlowEffect) -> None: ...

    def shadeExterior(self) -> bool: ...
    def clone(self) -> QgsOuterGlowEffect: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsInnerGlowEffect(QgsGlowEffect):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsInnerGlowEffect) -> None: ...

    def shadeExterior(self) -> bool: ...
    def clone(self) -> QgsInnerGlowEffect: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsImageOperation(sip.wrapper):

    class FlipType(int):
        ...
    FlipHorizontal: QgsImageOperation.FlipType = ...
    FlipVertical: QgsImageOperation.FlipType = ...

    class GrayscaleMode(int):
        ...
    GrayscaleLightness: QgsImageOperation.GrayscaleMode = ...
    GrayscaleLuminosity: QgsImageOperation.GrayscaleMode = ...
    GrayscaleAverage: QgsImageOperation.GrayscaleMode = ...
    GrayscaleOff: QgsImageOperation.GrayscaleMode = ...

    class DistanceTransformProperties(sip.wrapper):

        ramp: QgsColorRamp = ...
        shadeExterior: bool = ...
        spread: float = ...
        useMaxDistance: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsImageOperation.DistanceTransformProperties) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsImageOperation) -> None: ...

    @staticmethod
    def cropTransparent(image: QtGui.QImage, minSize: QtCore.QSize = ..., center: bool = ...) -> QtGui.QImage: ...
    @staticmethod
    def nonTransparentImageRect(image: QtGui.QImage, minSize: QtCore.QSize = ..., center: bool = ...) -> QtCore.QRect: ...
    @staticmethod
    def flipImage(image: QtGui.QImage, type: QgsImageOperation.FlipType) -> None: ...
    @staticmethod
    def gaussianBlur(image: QtGui.QImage, radius: int) -> QtGui.QImage: ...
    @staticmethod
    def stackBlur(image: QtGui.QImage, radius: int, alphaOnly: bool = ...) -> None: ...
    @staticmethod
    def distanceTransform(image: QtGui.QImage, properties: QgsImageOperation.DistanceTransformProperties) -> None: ...
    @staticmethod
    def overlayColor(image: QtGui.QImage, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    @staticmethod
    def multiplyOpacity(image: QtGui.QImage, factor: float) -> None: ...
    @staticmethod
    def adjustHueSaturation(image: QtGui.QImage, saturation: float, colorizeColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., colorizeStrength: float = ...) -> None: ...
    @staticmethod
    def adjustBrightnessContrast(image: QtGui.QImage, brightness: int, contrast: float) -> None: ...
    @staticmethod
    def convertToGrayscale(image: QtGui.QImage, mode: QgsImageOperation.GrayscaleMode = ...) -> None: ...


class QgsDrawSourceEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def draw(self, context: QgsRenderContext) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def clone(self) -> QgsDrawSourceEffect: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsEffectPainter(sip.wrapper):

    @overload
    def __init__(self, renderContext: QgsRenderContext) -> None: ...
    @overload
    def __init__(self, renderContext: QgsRenderContext, effect: QgsPaintEffect) -> None: ...
    @overload
    def __init__(self, a0: QgsEffectPainter) -> None: ...

    def setEffect(self, effect: QgsPaintEffect) -> None: ...


class QgsPaintEffectAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, name: str, visibleName: str) -> None: ...
    @overload
    def __init__(self, a0: QgsPaintEffectAbstractMetadata) -> None: ...

    def createWidget(self) -> QgsPaintEffectWidget: ...
    def createPaintEffect(self, map: Dict[str, typing.Any]) -> QgsPaintEffect: ...
    def visibleName(self) -> str: ...
    def name(self) -> str: ...


class QgsPaintEffectRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    @staticmethod
    def isDefaultStack(effect: QgsPaintEffect) -> bool: ...
    @staticmethod
    def defaultStack() -> QgsPaintEffect: ...
    def effects(self) -> List[str]: ...
    @overload
    def createEffect(self, name: str, properties: Dict[str, typing.Any] = ...) -> QgsPaintEffect: ...
    @overload
    def createEffect(self, element: QtXml.QDomElement) -> QgsPaintEffect: ...
    def addEffectType(self, metadata: QgsPaintEffectAbstractMetadata) -> bool: ...
    def effectMetadata(self, name: str) -> QgsPaintEffectAbstractMetadata: ...


class QgsShadowEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def exteriorShadow(self) -> bool: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def opacity(self) -> float: ...
    def setOpacity(self, opacity: float) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def offsetMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOffsetMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def offsetUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setOffsetUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def offsetDistance(self) -> float: ...
    def setOffsetDistance(self, distance: float) -> None: ...
    def offsetAngle(self) -> int: ...
    def setOffsetAngle(self, angle: int) -> None: ...
    def blurMapUnitScale(self) -> QgsMapUnitScale: ...
    def setBlurMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def blurUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setBlurUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def blurLevel(self) -> float: ...
    def setBlurLevel(self, level: float) -> None: ...
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...


class QgsDropShadowEffect(QgsShadowEffect):

    def __init__(self) -> None: ...

    def exteriorShadow(self) -> bool: ...
    def clone(self) -> QgsDropShadowEffect: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsInnerShadowEffect(QgsShadowEffect):

    def __init__(self) -> None: ...

    def exteriorShadow(self) -> bool: ...
    def clone(self) -> QgsInnerShadowEffect: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsTransformEffect(QgsPaintEffect):

    def __init__(self) -> None: ...

    def boundingRect(self, rect: QtCore.QRectF, context: QgsRenderContext) -> QtCore.QRectF: ...
    def draw(self, context: QgsRenderContext) -> None: ...
    def reflectY(self) -> bool: ...
    def setReflectY(self, reflectY: bool) -> None: ...
    def reflectX(self) -> bool: ...
    def setReflectX(self, reflectX: bool) -> None: ...
    def shearY(self) -> float: ...
    def setShearY(self, shearY: float) -> None: ...
    def shearX(self) -> float: ...
    def setShearX(self, shearX: float) -> None: ...
    def rotation(self) -> float: ...
    def setRotation(self, rotation: float) -> None: ...
    def scaleY(self) -> float: ...
    def setScaleY(self, scaleY: float) -> None: ...
    def scaleX(self) -> float: ...
    def setScaleX(self, scaleX: float) -> None: ...
    def translateMapUnitScale(self) -> QgsMapUnitScale: ...
    def setTranslateMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def translateUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setTranslateUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def translateY(self) -> float: ...
    def setTranslateY(self, translateY: float) -> None: ...
    def translateX(self) -> float: ...
    def setTranslateX(self, translateX: float) -> None: ...
    def clone(self) -> QgsTransformEffect: ...
    def readProperties(self, props: Dict[str, typing.Any]) -> None: ...
    def properties(self) -> Dict[str, typing.Any]: ...
    def type(self) -> str: ...
    @staticmethod
    def create(map: Dict[str, typing.Any]) -> QgsPaintEffect: ...


class QgsExpression(sip.wrapper):

    class SpatialOperator(int):
        ...
    soBbox: QgsExpression.SpatialOperator = ...
    soIntersects: QgsExpression.SpatialOperator = ...
    soContains: QgsExpression.SpatialOperator = ...
    soCrosses: QgsExpression.SpatialOperator = ...
    soEquals: QgsExpression.SpatialOperator = ...
    soDisjoint: QgsExpression.SpatialOperator = ...
    soOverlaps: QgsExpression.SpatialOperator = ...
    soTouches: QgsExpression.SpatialOperator = ...
    soWithin: QgsExpression.SpatialOperator = ...

    class ParserError(sip.wrapper):

        class ParserErrorType(int):
            ...
        Unknown: QgsExpression.ParserError.ParserErrorType = ...
        FunctionUnknown: QgsExpression.ParserError.ParserErrorType = ...
        FunctionWrongArgs: QgsExpression.ParserError.ParserErrorType = ...
        FunctionInvalidParams: QgsExpression.ParserError.ParserErrorType = ...
        FunctionNamedArgsError: QgsExpression.ParserError.ParserErrorType = ...

        errorMsg: str = ...
        errorType: QgsExpression.ParserError.ParserErrorType = ...
        firstColumn: int = ...
        firstLine: int = ...
        lastColumn: int = ...
        lastLine: int = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsExpression.ParserError) -> None: ...

    @overload
    def __init__(self, expr: str) -> None: ...
    @overload
    def __init__(self, other: QgsExpression) -> None: ...
    @overload
    def __init__(self) -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def attemptReduceToInClause(expressions: Iterable[str]) -> Tuple[bool, str]: ...
    @staticmethod
    def isFieldEqualityExpression(expression: str) -> Tuple[bool, str, typing.Any]: ...
    @staticmethod
    def createFieldEqualityExpression(fieldName: str, value: typing.Any) -> str: ...
    @staticmethod
    def formatPreviewString(value: typing.Any, htmlOutput: bool = ..., maximumPreviewLength: int = ...) -> str: ...
    @staticmethod
    def group(group: str) -> str: ...
    @staticmethod
    def formatVariableHelp(description: str, showValue: bool = ..., value: typing.Any = ...) -> str: ...
    @staticmethod
    def variableHelpText(variableName: str) -> str: ...
    @staticmethod
    def tags(name: str) -> List[str]: ...
    @staticmethod
    def helpText(name: str) -> str: ...
    @overload
    @staticmethod
    def quotedValue(value: typing.Any) -> str: ...
    @overload
    @staticmethod
    def quotedValue(value: typing.Any, type: QtCore.QVariant.Type) -> str: ...
    @staticmethod
    def quotedString(text: str) -> str: ...
    @staticmethod
    def quotedColumnRef(name: str) -> str: ...
    @staticmethod
    def functionCount() -> int: ...
    @staticmethod
    def functionIndex(name: str) -> int: ...
    @staticmethod
    def isFunctionName(name: str) -> bool: ...
    @staticmethod
    def cleanRegisteredFunctions() -> None: ...
    @staticmethod
    def unregisterFunction(name: str) -> bool: ...
    @staticmethod
    def registerFunction(function: QgsExpressionFunction, transferOwnership: bool = ...) -> bool: ...
    @staticmethod
    def BuiltinFunctions() -> List[str]: ...
    @staticmethod
    def Functions() -> List[QgsExpressionFunction]: ...
    @staticmethod
    def evaluateToDouble(text: str, fallbackValue: float) -> float: ...
    @staticmethod
    def replaceExpressionText(action: str, context: QgsExpressionContext, distanceArea: Optional[QgsDistanceArea] = ...) -> str: ...
    def setAreaUnits(self, unit: QgsUnitTypes.AreaUnit) -> None: ...
    def areaUnits(self) -> QgsUnitTypes.AreaUnit: ...
    def setDistanceUnits(self, unit: QgsUnitTypes.DistanceUnit) -> None: ...
    def distanceUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def setGeomCalculator(self, calc: QgsDistanceArea) -> None: ...
    def geomCalculator(self) -> QgsDistanceArea: ...
    def dump(self) -> str: ...
    def expression(self) -> str: ...
    def setExpression(self, expression: str) -> None: ...
    @staticmethod
    def checkExpression(text: str, context: QgsExpressionContext) -> Tuple[bool, str]: ...
    def isField(self) -> bool: ...
    def setEvalErrorString(self, str: str) -> None: ...
    def evalErrorString(self) -> str: ...
    def hasEvalError(self) -> bool: ...
    @overload
    def evaluate(self) -> typing.Any: ...
    @overload
    def evaluate(self, context: QgsExpressionContext) -> typing.Any: ...
    def needsGeometry(self) -> bool: ...
    def referencedAttributeIndexes(self, fields: QgsFields) -> typing.Any: ...
    def referencedFunctions(self) -> Set[str]: ...
    @overload
    def referencedVariables(self) -> Set[str]: ...
    @overload
    @staticmethod
    def referencedVariables(text: str) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def prepare(self, context: QgsExpressionContext) -> bool: ...
    def rootNode(self) -> QgsExpressionNode: ...
    def parserErrors(self) -> List[QgsExpression.ParserError]: ...
    def parserErrorString(self) -> str: ...
    def hasParserError(self) -> bool: ...
    def isValid(self) -> bool: ...


class QgsExpressionContextUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionContextUtils) -> None: ...

    @staticmethod
    def registerContextFunctions() -> None: ...
    @staticmethod
    def notificationScope(message: str = ...) -> QgsExpressionContextScope: ...
    @staticmethod
    def processingModelAlgorithmScope(model: QgsProcessingModelAlgorithm, parameters: Dict[str, typing.Any], context: QgsProcessingContext) -> QgsExpressionContextScope: ...
    @staticmethod
    def processingAlgorithmScope(algorithm: QgsProcessingAlgorithm, parameters: Dict[str, typing.Any], context: QgsProcessingContext) -> QgsExpressionContextScope: ...
    @staticmethod
    def createFeatureBasedContext(feature: QgsFeature, fields: QgsFields) -> QgsExpressionContext: ...
    @staticmethod
    def setLayoutMultiFrameVariables(frame: QgsLayoutMultiFrame, variables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def setLayoutMultiFrameVariable(frame: QgsLayoutMultiFrame, name: str, value: typing.Any) -> None: ...
    @staticmethod
    def multiFrameScope(frame: QgsLayoutMultiFrame) -> QgsExpressionContextScope: ...
    @staticmethod
    def setLayoutItemVariables(item: QgsLayoutItem, variables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def setLayoutItemVariable(item: QgsLayoutItem, name: str, value: typing.Any) -> None: ...
    @staticmethod
    def layoutItemScope(item: QgsLayoutItem) -> QgsExpressionContextScope: ...
    @staticmethod
    def atlasScope(atlas: QgsLayoutAtlas) -> QgsExpressionContextScope: ...
    @staticmethod
    def setLayoutVariables(layout: QgsLayout, variables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def setLayoutVariable(layout: QgsLayout, name: str, value: typing.Any) -> None: ...
    @staticmethod
    def layoutScope(layout: QgsLayout) -> QgsExpressionContextScope: ...
    @staticmethod
    def updateSymbolScope(symbol: QgsSymbol, symbolScope: Optional[QgsExpressionContextScope] = ...) -> QgsExpressionContextScope: ...
    @staticmethod
    def mapToolCaptureScope(matches: Iterable[QgsPointLocator.Match]) -> QgsExpressionContextScope: ...
    @staticmethod
    def mapSettingsScope(mapSettings: QgsMapSettings) -> QgsExpressionContextScope: ...
    @staticmethod
    def setLayerVariables(layer: QgsMapLayer, variables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def setLayerVariable(layer: QgsMapLayer, name: str, value: typing.Any) -> None: ...
    @staticmethod
    def globalProjectLayerScopes(layer: QgsMapLayer) -> List[QgsExpressionContextScope]: ...
    @staticmethod
    def layerScope(layer: QgsMapLayer) -> QgsExpressionContextScope: ...
    @staticmethod
    def removeProjectVariable(project: QgsProject, name: str) -> None: ...
    @staticmethod
    def setProjectVariables(project: QgsProject, variables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def setProjectVariable(project: QgsProject, name: str, value: typing.Any) -> None: ...
    @staticmethod
    def projectScope(project: QgsProject) -> QgsExpressionContextScope: ...
    @staticmethod
    def removeGlobalVariable(name: str) -> None: ...
    @staticmethod
    def setGlobalVariables(variables: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def setGlobalVariable(name: str, value: typing.Any) -> None: ...
    @staticmethod
    def parentFormScope(formFeature: QgsFeature = ..., formMode: str = ...) -> QgsExpressionContextScope: ...
    @staticmethod
    def formScope(formFeature: QgsFeature = ..., formMode: str = ...) -> QgsExpressionContextScope: ...
    @staticmethod
    def globalScope() -> QgsExpressionContextScope: ...


class QgsExpressionNode(sip.wrapper):

    class NodeType(int):
        ...
    ntUnaryOperator: QgsExpressionNode.NodeType = ...
    ntBinaryOperator: QgsExpressionNode.NodeType = ...
    ntInOperator: QgsExpressionNode.NodeType = ...
    ntFunction: QgsExpressionNode.NodeType = ...
    ntLiteral: QgsExpressionNode.NodeType = ...
    ntColumnRef: QgsExpressionNode.NodeType = ...
    ntCondition: QgsExpressionNode.NodeType = ...
    ntIndexOperator: QgsExpressionNode.NodeType = ...

    class NamedNode(sip.wrapper):

        name: str = ...
        node: QgsExpressionNode = ...

        @overload
        def __init__(self, name: str, node: QgsExpressionNode) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionNode.NamedNode) -> None: ...

    class NodeList(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsExpressionNode.NodeList) -> None: ...

        def dump(self) -> str: ...
        def clone(self) -> QgsExpressionNode.NodeList: ...
        def names(self) -> List[str]: ...
        def at(self, i: int) -> QgsExpressionNode: ...
        def list(self) -> List[QgsExpressionNode]: ...
        def hasNamedNodes(self) -> bool: ...
        def count(self) -> int: ...
        @overload
        def append(self, node: QgsExpressionNode) -> None: ...
        @overload
        def append(self, node: QgsExpressionNode.NamedNode) -> None: ...

    parserFirstColumn: int = ...
    parserFirstLine: int = ...
    parserLastColumn: int = ...
    parserLastLine: int = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNode) -> None: ...

    def cachedStaticValue(self) -> typing.Any: ...
    def hasCachedStaticValue(self) -> bool: ...
    def prepare(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def clone(self) -> QgsExpressionNode: ...
    def eval(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def dump(self) -> str: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...


class QgsExpressionNodeUnaryOperator(QgsExpressionNode):

    class UnaryOperator(int):
        ...
    uoNot: QgsExpressionNodeUnaryOperator.UnaryOperator = ...
    uoMinus: QgsExpressionNodeUnaryOperator.UnaryOperator = ...

    @overload
    def __init__(self, op: QgsExpressionNodeUnaryOperator.UnaryOperator, operand: QgsExpressionNode) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeUnaryOperator) -> None: ...

    def text(self) -> str: ...
    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def operand(self) -> QgsExpressionNode: ...
    def op(self) -> QgsExpressionNodeUnaryOperator.UnaryOperator: ...


class QgsExpressionNodeBinaryOperator(QgsExpressionNode):

    class BinaryOperator(int):
        ...
    boOr: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boAnd: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boEQ: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boNE: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boLE: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boGE: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boLT: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boGT: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boRegexp: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boLike: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boNotLike: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boILike: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boNotILike: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boIs: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boIsNot: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boPlus: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boMinus: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boMul: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boDiv: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boIntDiv: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boMod: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boPow: QgsExpressionNodeBinaryOperator.BinaryOperator = ...
    boConcat: QgsExpressionNodeBinaryOperator.BinaryOperator = ...

    @overload
    def __init__(self, op: QgsExpressionNodeBinaryOperator.BinaryOperator, opLeft: QgsExpressionNode, opRight: QgsExpressionNode) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeBinaryOperator) -> None: ...

    def text(self) -> str: ...
    def leftAssociative(self) -> bool: ...
    def precedence(self) -> int: ...
    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def opRight(self) -> QgsExpressionNode: ...
    def opLeft(self) -> QgsExpressionNode: ...
    def op(self) -> QgsExpressionNodeBinaryOperator.BinaryOperator: ...


class QgsExpressionNodeIndexOperator(QgsExpressionNode):

    @overload
    def __init__(self, container: QgsExpressionNode, index: QgsExpressionNode) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeIndexOperator) -> None: ...

    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def index(self) -> QgsExpressionNode: ...
    def container(self) -> QgsExpressionNode: ...


class QgsExpressionNodeInOperator(QgsExpressionNode):

    @overload
    def __init__(self, node: QgsExpressionNode, list: QgsExpressionNode.NodeList, notin: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeInOperator) -> None: ...

    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def list(self) -> QgsExpressionNode.NodeList: ...
    def isNotIn(self) -> bool: ...
    def node(self) -> QgsExpressionNode: ...


class QgsExpressionNodeFunction(QgsExpressionNode):

    @overload
    def __init__(self, fnIndex: int, args: QgsExpressionNode.NodeList) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeFunction) -> None: ...

    @staticmethod
    def validateParams(fnIndex: int, args: QgsExpressionNode.NodeList, error: str) -> bool: ...
    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def args(self) -> QgsExpressionNode.NodeList: ...
    def fnIndex(self) -> int: ...


class QgsExpressionNodeLiteral(QgsExpressionNode):

    @overload
    def __init__(self, value: typing.Any) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeLiteral) -> None: ...

    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def value(self) -> typing.Any: ...


class QgsExpressionNodeColumnRef(QgsExpressionNode):

    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeColumnRef) -> None: ...

    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def dump(self) -> str: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...
    def name(self) -> str: ...


class QgsExpressionNodeCondition(QgsExpressionNode):

    class WhenThen(sip.wrapper):

        def __init__(self, whenExp: QgsExpressionNode, thenExp: QgsExpressionNode) -> None: ...

        def thenExp(self) -> QgsExpressionNode: ...
        def whenExp(self) -> QgsExpressionNode: ...
        def clone(self) -> QgsExpressionNodeCondition.WhenThen: ...

    @overload
    def __init__(self, conditions: Iterable[QgsExpressionNodeCondition.WhenThen], elseExp: Optional[QgsExpressionNode] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsExpressionNodeCondition) -> None: ...

    def isStatic(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def clone(self) -> QgsExpressionNode: ...
    def needsGeometry(self) -> bool: ...
    def referencedFunctions(self) -> Set[str]: ...
    def referencedVariables(self) -> Set[str]: ...
    def referencedColumns(self) -> Set[str]: ...
    def elseExp(self) -> QgsExpressionNode: ...
    def conditions(self) -> List[QgsExpressionNodeCondition.WhenThen]: ...
    def dump(self) -> str: ...
    def prepareNode(self, parent: QgsExpression, context: QgsExpressionContext) -> bool: ...
    def evalNode(self, parent: QgsExpression, context: QgsExpressionContext) -> typing.Any: ...
    def nodeType(self) -> QgsExpressionNode.NodeType: ...


class QgsCheckBoxFieldFormatter(QgsFieldFormatter):

    class TextDisplayMethod(int):
        ...
    ShowTrueFalse: QgsCheckBoxFieldFormatter.TextDisplayMethod = ...
    ShowStoredValues: QgsCheckBoxFieldFormatter.TextDisplayMethod = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCheckBoxFieldFormatter) -> None: ...

    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsDateTimeFieldFormatter(QgsFieldFormatter):

    DATETIME_FORMAT: str = ...
    DATE_FORMAT: str = ...
    DISPLAY_FOR_ISO_FORMAT: str = ...
    QT_ISO_FORMAT: str = ...
    TIME_FORMAT: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDateTimeFieldFormatter) -> None: ...

    @staticmethod
    def defaultFormat(type: QtCore.QVariant.Type) -> str: ...
    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsFallbackFieldFormatter(QgsFieldFormatter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFallbackFieldFormatter) -> None: ...

    def id(self) -> str: ...


class QgsKeyValueFieldFormatter(QgsFieldFormatter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsKeyValueFieldFormatter) -> None: ...

    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsListFieldFormatter(QgsFieldFormatter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsListFieldFormatter) -> None: ...

    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsRangeFieldFormatter(QgsFieldFormatter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRangeFieldFormatter) -> None: ...

    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsRelationReferenceFieldFormatter(QgsFieldFormatter):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRelationReferenceFieldFormatter) -> None: ...

    def availableValues(self, config: Dict[str, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> List[typing.Any]: ...
    def createCache(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any]) -> typing.Any: ...
    def sortValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsValueMapFieldFormatter(QgsFieldFormatter):

    NULL_VALUE: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsValueMapFieldFormatter) -> None: ...

    def availableValues(self, config: Dict[str, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> List[typing.Any]: ...
    def sortValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsValueRelationFieldFormatter(QgsFieldFormatter):

    class ValueRelationItem(sip.wrapper):

        description: str = ...
        key: typing.Any = ...
        value: str = ...

        @overload
        def __init__(self, key: typing.Any, value: str, description: str = ...) -> None: ...
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsValueRelationFieldFormatter.ValueRelationItem) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsValueRelationFieldFormatter) -> None: ...

    def availableValues(self, config: Dict[str, typing.Any], countLimit: int, context: QgsFieldFormatterContext) -> List[typing.Any]: ...
    @staticmethod
    def resolveLayer(config: Dict[str, typing.Any], project: QgsProject) -> QgsVectorLayer: ...
    @staticmethod
    def expressionIsUsable(expression: str, feature: QgsFeature, parentFeature: QgsFeature = ...) -> bool: ...
    @staticmethod
    def expressionParentFormVariables(expression: str) -> Set[str]: ...
    @staticmethod
    def expressionParentFormAttributes(expression: str) -> Set[str]: ...
    @staticmethod
    def expressionRequiresParentFormScope(expression: str) -> bool: ...
    @staticmethod
    def expressionFormVariables(expression: str) -> Set[str]: ...
    @staticmethod
    def expressionFormAttributes(expression: str) -> Set[str]: ...
    @staticmethod
    def expressionRequiresFormScope(expression: str) -> bool: ...
    @staticmethod
    def valueToStringList(value: typing.Any) -> List[str]: ...
    @overload
    def createCache(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any]) -> typing.Any: ...
    @overload
    @staticmethod
    def createCache(config: Dict[str, typing.Any], formFeature: QgsFeature = ..., parentFormFeature: QgsFeature = ...) -> List[QgsValueRelationFieldFormatter.ValueRelationItem]: ...
    def sortValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> typing.Any: ...
    def representValue(self, layer: QgsVectorLayer, fieldIndex: int, config: Dict[str, typing.Any], cache: typing.Any, value: typing.Any) -> str: ...
    def id(self) -> str: ...


class QgsGeoNodeConnection(sip.wrapper):

    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, a0: QgsGeoNodeConnection) -> None: ...

    def addWcsConnectionSettings(self, uri: QgsDataSourceUri) -> QgsDataSourceUri: ...
    def addWfsConnectionSettings(self, uri: QgsDataSourceUri) -> QgsDataSourceUri: ...
    def addWmsConnectionSettings(self, uri: QgsDataSourceUri) -> QgsDataSourceUri: ...
    def setUri(self, uri: QgsDataSourceUri) -> None: ...
    def uri(self) -> QgsDataSourceUri: ...
    def setConnectionName(self, connectionName: str) -> None: ...
    def connectionName(self) -> str: ...


class QgsGeoNodeConnectionUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeoNodeConnectionUtils) -> None: ...

    @staticmethod
    def pathGeoNodeConnectionDetails() -> str: ...
    @staticmethod
    def pathGeoNodeConnection() -> str: ...
    @staticmethod
    def deleteConnection(name: str) -> None: ...
    @staticmethod
    def connectionList() -> List[str]: ...


class QgsGeoNodeStyle(sip.wrapper):

    body: QtXml.QDomDocument = ...
    id: str = ...
    name: str = ...
    styleUrl: str = ...
    title: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeoNodeStyle) -> None: ...


class QgsGeoNodeRequest(QtCore.QObject):

    class BackendServer(int):
        ...
    Unknown: QgsGeoNodeRequest.BackendServer = ...
    QgisServer: QgsGeoNodeRequest.BackendServer = ...
    Geoserver: QgsGeoNodeRequest.BackendServer = ...

    class ServiceLayerDetail(sip.wrapper):

        id: str = ...
        name: str = ...
        server: QgsGeoNodeRequest.BackendServer = ...
        title: str = ...
        typeName: str = ...
        uuid: QtCore.QUuid = ...
        wcsURL: str = ...
        wfsURL: str = ...
        wmsURL: str = ...
        xyzURL: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsGeoNodeRequest.ServiceLayerDetail) -> None: ...

    def __init__(self, baseUrl: str, forceRefresh: bool, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def layersFetched(self, layers: Iterable[QgsGeoNodeRequest.ServiceLayerDetail]) -> None: ...
    def requestFinished(self) -> None: ...
    def statusChanged(self, statusQString: str) -> None: ...
    def abort(self) -> None: ...
    def parseOwsUrl(self, layerStruct: QgsGeoNodeRequest.ServiceLayerDetail, layerLinks: Iterable[typing.Any]) -> QgsGeoNodeRequest.ServiceLayerDetail: ...
    def setProtocol(self, protocol: str) -> None: ...
    def protocol(self) -> str: ...
    def lastResponse(self) -> QtCore.QByteArray: ...
    def lastError(self) -> str: ...
    def fetchServiceUrlDataBlocking(self, serviceType: str) -> Dict[str, str]: ...
    def fetchServiceUrlsBlocking(self, serviceType: str) -> List[str]: ...
    def fetchStyleBlocking(self, styleId: str) -> QgsGeoNodeStyle: ...
    def fetchDefaultStyleBlocking(self, layerName: str) -> QgsGeoNodeStyle: ...
    def fetchStylesBlocking(self, layerName: str) -> List[QgsGeoNodeStyle]: ...
    def fetchLayersBlocking(self) -> List[QgsGeoNodeRequest.ServiceLayerDetail]: ...
    def fetchLayers(self) -> None: ...
    def requestBlocking(self, endPoint: str) -> bool: ...
    def request(self, endPoint: str) -> None: ...


class QgsLocatorFilter(QtCore.QObject):

    class Flag(int):
        ...
    FlagFast: QgsLocatorFilter.Flag = ...

    class Priority(int):
        ...
    Highest: QgsLocatorFilter.Priority = ...
    High: QgsLocatorFilter.Priority = ...
    Medium: QgsLocatorFilter.Priority = ...
    Low: QgsLocatorFilter.Priority = ...
    Lowest: QgsLocatorFilter.Priority = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLocatorFilter.Flags, QgsLocatorFilter.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLocatorFilter.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLocatorFilter.Flags: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def resultFetched(self, result: QgsLocatorResult) -> None: ...
    def finished(self) -> None: ...
    def setFetchResultsDelay(self, delay: int) -> None: ...
    def fetchResultsDelay(self) -> int: ...
    def logMessage(self, message: str, level: Qgis.MessageLevel = ...) -> None: ...
    def openConfigWidget(self, parent: Optional[QtWidgets.QWidget] = ...) -> None: ...
    def hasConfigWidget(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    @staticmethod
    def fuzzyScore(candidate: str, search: str) -> float: ...
    @staticmethod
    def stringMatches(candidate: str, search: str) -> bool: ...
    def activePrefix(self) -> str: ...
    def setUseWithoutPrefix(self, useWithoutPrefix: bool) -> None: ...
    def useWithoutPrefix(self) -> bool: ...
    def clearPreviousResults(self) -> None: ...
    def triggerResultFromAction(self, result: QgsLocatorResult, actionId: int) -> None: ...
    def triggerResult(self, result: QgsLocatorResult) -> None: ...
    def fetchResults(self, string: str, context: QgsLocatorContext, feedback: QgsFeedback) -> None: ...
    def prepare(self, string: str, context: QgsLocatorContext) -> List[str]: ...
    def prefix(self) -> str: ...
    def priority(self) -> QgsLocatorFilter.Priority: ...
    def flags(self) -> QgsLocatorFilter.Flags: ...
    def description(self) -> str: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...
    def clone(self) -> QgsLocatorFilter: ...


class QgsAbstractGeocoderLocatorFilter(QgsLocatorFilter):

    def __init__(self, name: str, displayName: str, prefix: str, geocoder: QgsGeocoderInterface, boundingBox: QgsRectangle = ...) -> None: ...

    def geocoderResultToLocatorResult(self, result: QgsGeocoderResult) -> QgsLocatorResult: ...
    def locatorResultToGeocoderResult(self, result: QgsLocatorResult) -> QgsGeocoderResult: ...
    def boundingBox(self) -> QgsRectangle: ...
    def geocoder(self) -> QgsGeocoderInterface: ...
    def triggerResult(self, result: QgsLocatorResult) -> None: ...
    def fetchResults(self, string: str, context: QgsLocatorContext, feedback: QgsFeedback) -> None: ...
    def prefix(self) -> str: ...
    def displayName(self) -> str: ...
    def name(self) -> str: ...


class QgsGeocoderInterface(sip.wrapper):

    class Flag(int):
        ...
    GeocodesStrings: QgsGeocoderInterface.Flag = ...
    GeocodesFeatures: QgsGeocoderInterface.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsGeocoderInterface.Flags, QgsGeocoderInterface.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsGeocoderInterface.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsGeocoderInterface.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeocoderInterface) -> None: ...

    def geocodeString(self, string: str, context: QgsGeocoderContext, feedback: Optional[QgsFeedback] = ...) -> List[QgsGeocoderResult]: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def appendedFields(self) -> QgsFields: ...
    def geocodeFeature(self, feature: QgsFeature, context: QgsGeocoderContext, feedback: Optional[QgsFeedback] = ...) -> List[QgsGeocoderResult]: ...
    def flags(self) -> QgsGeocoderInterface.Flags: ...


class QgsGeocoderContext(sip.wrapper):

    @overload
    def __init__(self, transformContext: QgsCoordinateTransformContext) -> None: ...
    @overload
    def __init__(self, a0: QgsGeocoderContext) -> None: ...

    def setAreaOfInterestCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def areaOfInterestCrs(self) -> QgsCoordinateReferenceSystem: ...
    def setAreaOfInterest(self, area: QgsGeometry) -> None: ...
    def areaOfInterest(self) -> QgsGeometry: ...
    def setTransformContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...


class QgsGeocoderResult(sip.wrapper):

    @overload
    def __init__(self, identifier: str, geometry: QgsGeometry, crs: QgsCoordinateReferenceSystem) -> None: ...
    @overload
    def __init__(self, a0: QgsGeocoderResult) -> None: ...

    def setDescription(self, description: str) -> None: ...
    def description(self) -> str: ...
    def setGroup(self, group: str) -> None: ...
    def group(self) -> str: ...
    def setAdditionalAttributes(self, attributes: Dict[str, typing.Any]) -> None: ...
    def additionalAttributes(self) -> Dict[str, typing.Any]: ...
    def setViewport(self, viewport: QgsRectangle) -> None: ...
    def viewport(self) -> QgsRectangle: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setGeometry(self, geometry: QgsGeometry) -> None: ...
    def geometry(self) -> QgsGeometry: ...
    def identifier(self) -> str: ...
    def error(self) -> str: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def errorResult(errorMessage: str) -> QgsGeocoderResult: ...


class QgsNominatimGeocoder(QgsGeocoderInterface):

    @overload
    def __init__(self, countryCodes: str = ..., endpoint: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsNominatimGeocoder) -> None: ...

    def setCountryCodes(self, countryCodes: str) -> None: ...
    def countryCodes(self) -> str: ...
    def setRequestsPerSecond(self, number: float) -> None: ...
    def requestsPerSecond(self) -> float: ...
    def setEndpoint(self, endpoint: str) -> None: ...
    def endpoint(self) -> str: ...
    def jsonToResult(self, json: Dict[str, typing.Any]) -> QgsGeocoderResult: ...
    def requestUrl(self, address: str, bounds: QgsRectangle = ...) -> QtCore.QUrl: ...
    def geocodeString(self, string: str, context: QgsGeocoderContext, feedback: Optional[QgsFeedback] = ...) -> List[QgsGeocoderResult]: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def appendedFields(self) -> QgsFields: ...
    def flags(self) -> QgsGeocoderInterface.Flags: ...


class QgsGoogleMapsGeocoder(QgsGeocoderInterface):

    @overload
    def __init__(self, apiKey: str, regionBias: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsGoogleMapsGeocoder) -> None: ...

    def setRegion(self, region: str) -> None: ...
    def region(self) -> str: ...
    def setApiKey(self, key: str) -> None: ...
    def apiKey(self) -> str: ...
    def setEndpoint(self, endpoint: str) -> None: ...
    def jsonToResult(self, json: Dict[str, typing.Any]) -> QgsGeocoderResult: ...
    def requestUrl(self, address: str, bounds: QgsRectangle = ...) -> QtCore.QUrl: ...
    def geocodeString(self, string: str, context: QgsGeocoderContext, feedback: Optional[QgsFeedback] = ...) -> List[QgsGeocoderResult]: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def appendedFields(self) -> QgsFields: ...
    def flags(self) -> QgsGeocoderInterface.Flags: ...


class QgsAbstractGeometry(sip.wrapper):

    class WkbFlag(int):
        ...
    FlagExportTrianglesAsPolygons: QgsAbstractGeometry.WkbFlag = ...

    class AxisOrder(int):
        ...
    XY: QgsAbstractGeometry.AxisOrder = ...
    YX: QgsAbstractGeometry.AxisOrder = ...

    class SegmentationToleranceType(int):
        ...
    MaximumAngle: QgsAbstractGeometry.SegmentationToleranceType = ...
    MaximumDifference: QgsAbstractGeometry.SegmentationToleranceType = ...

    class WkbFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsAbstractGeometry.WkbFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsAbstractGeometry.WkbFlags: ...
        def __int__(self) -> int: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, geom: QgsAbstractGeometry) -> None: ...

    def clearCache(self) -> None: ...
    def calculateBoundingBox(self) -> QgsRectangle: ...
    def setZMTypeFromSubGeometry(self, subggeom: QgsAbstractGeometry, baseGeomType: QgsWkbTypes.Type) -> None: ...
    def childPoint(self, index: int) -> QgsPoint: ...
    def childGeometry(self, index: int) -> QgsAbstractGeometry: ...
    def childCount(self) -> int: ...
    def hasChildGeometries(self) -> bool: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def sortIndex(self) -> int: ...
    def createEmptyWithSameType(self) -> QgsAbstractGeometry: ...
    def vertices(self) -> QgsVertexIterator: ...
    def parts(self) -> QgsGeometryPartIterator: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def simplifiedTypeRef(self) -> QgsAbstractGeometry: ...
    def convertTo(self, type: QgsWkbTypes.Type) -> bool: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsAbstractGeometry: ...
    def toCurveType(self) -> QgsAbstractGeometry: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsAbstractGeometry: ...
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    def hasCurvedSegments(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def centroid(self) -> QgsPoint: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def area(self) -> float: ...
    def perimeter(self) -> float: ...
    def length(self) -> float: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def vertexAt(self, id: QgsVertexId) -> QgsPoint: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def adjacentVertices(self, vertex: QgsVertexId) -> Tuple[QgsVertexId, QgsVertexId]: ...
    def nextVertex(self, id: QgsVertexId) -> Tuple[bool, QgsPoint]: ...
    def vertexNumberFromVertexId(self, id: QgsVertexId) -> int: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asJson(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def normalize(self) -> None: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def isMeasure(self) -> bool: ...
    def is3D(self) -> bool: ...
    def wktTypeStr(self) -> str: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def geometryType(self) -> str: ...
    def dimension(self) -> int: ...
    def boundingBox(self) -> QgsRectangle: ...
    def clear(self) -> None: ...
    def compareTo(self, other: QgsAbstractGeometry) -> int: ...
    def clone(self) -> QgsAbstractGeometry: ...


class QgsVertexId(sip.wrapper):

    class VertexType(int):
        ...
    SegmentVertex: QgsVertexId.VertexType = ...
    CurveVertex: QgsVertexId.VertexType = ...

    part: int = ...
    ring: int = ...
    type: QgsVertexId.VertexType = ...
    vertex: int = ...

    @overload
    def __init__(self, _part: int = ..., _ring: int = ..., _vertex: int = ..., _type: QgsVertexId.VertexType = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsVertexId) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def vertexEqual(self, o: QgsVertexId) -> bool: ...
    def ringEqual(self, o: QgsVertexId) -> bool: ...
    def partEqual(self, o: QgsVertexId) -> bool: ...
    @overload
    def isValid(self) -> bool: ...
    @overload
    def isValid(self, geom: QgsAbstractGeometry) -> bool: ...


class QgsVertexIterator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, geometry: QgsAbstractGeometry) -> None: ...
    @overload
    def __init__(self, a0: QgsVertexIterator) -> None: ...

    def __next__(self) -> QgsPoint: ...
    def __iter__(self) -> QgsVertexIterator: ...
    def next(self) -> QgsPoint: ...
    def hasNext(self) -> bool: ...


class QgsGeometryPartIterator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, geometry: QgsAbstractGeometry) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryPartIterator) -> None: ...

    def __next__(self) -> QgsAbstractGeometry: ...
    def __iter__(self) -> QgsGeometryPartIterator: ...
    def next(self) -> QgsAbstractGeometry: ...
    def hasNext(self) -> bool: ...


class QgsGeometryConstPartIterator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, geometry: QgsAbstractGeometry) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryConstPartIterator) -> None: ...

    def __next__(self) -> QgsAbstractGeometry: ...
    def __iter__(self) -> QgsGeometryConstPartIterator: ...
    def next(self) -> QgsAbstractGeometry: ...
    def hasNext(self) -> bool: ...


class QgsBox3d(sip.wrapper):

    @overload
    def __init__(self, xmin: float = ..., ymin: float = ..., zmin: float = ..., xmax: float = ..., ymax: float = ..., zmax: float = ...) -> None: ...
    @overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint) -> None: ...
    @overload
    def __init__(self, rect: QgsRectangle) -> None: ...
    @overload
    def __init__(self, a0: QgsBox3d) -> None: ...

    def distanceTo(self, point: QtGui.QVector3D) -> float: ...
    def toRectangle(self) -> QgsRectangle: ...
    @overload
    def contains(self, other: QgsBox3d) -> bool: ...
    @overload
    def contains(self, point: QgsPoint) -> bool: ...
    def intersects(self, other: QgsBox3d) -> bool: ...
    def is2d(self) -> bool: ...
    def intersect(self, other: QgsBox3d) -> QgsBox3d: ...
    def volume(self) -> float: ...
    def depth(self) -> float: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def normalize(self) -> None: ...
    def zMaximum(self) -> float: ...
    def zMinimum(self) -> float: ...
    def setZMaximum(self, z: float) -> None: ...
    def setZMinimum(self, z: float) -> None: ...
    def yMaximum(self) -> float: ...
    def yMinimum(self) -> float: ...
    def setYMaximum(self, y: float) -> None: ...
    def setYMinimum(self, y: float) -> None: ...
    def xMaximum(self) -> float: ...
    def xMinimum(self) -> float: ...
    def setXMaximum(self, x: float) -> None: ...
    def setXMinimum(self, x: float) -> None: ...


class QgsEllipse(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, center: QgsPoint, semiMajorAxis: float, semiMinorAxis: float, azimuth: float = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsEllipse) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def toString(self, pointPrecision: int = ..., axisPrecision: int = ..., azimuthPrecision: int = ...) -> str: ...
    def boundingBox(self) -> QgsRectangle: ...
    def orientedBoundingBox(self) -> QgsPolygon: ...
    def toLineString(self, segments: int = ...) -> QgsLineString: ...
    def toPolygon(self, segments: int = ...) -> QgsPolygon: ...
    def points(self, segments: int = ...) -> List[QgsPoint]: ...
    def quadrant(self) -> List[QgsPoint]: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def eccentricity(self) -> float: ...
    def foci(self) -> List[QgsPoint]: ...
    def focusDistance(self) -> float: ...
    def setAzimuth(self, azimuth: float) -> None: ...
    def setSemiMinorAxis(self, semiMinorAxis: float) -> None: ...
    def setSemiMajorAxis(self, semiMajorAxis: float) -> None: ...
    def setCenter(self, center: QgsPoint) -> None: ...
    def azimuth(self) -> float: ...
    def semiMinorAxis(self) -> float: ...
    def semiMajorAxis(self) -> float: ...
    def center(self) -> QgsPoint: ...
    def isEmpty(self) -> bool: ...
    @staticmethod
    def fromCenter2Points(ptc: QgsPoint, pt1: QgsPoint, pt2: QgsPoint) -> QgsEllipse: ...
    @staticmethod
    def fromCenterPoint(ptc: QgsPoint, pt1: QgsPoint) -> QgsEllipse: ...
    @staticmethod
    def fromExtent(pt1: QgsPoint, pt2: QgsPoint) -> QgsEllipse: ...
    @staticmethod
    def fromFoci(pt1: QgsPoint, pt2: QgsPoint, pt3: QgsPoint) -> QgsEllipse: ...


class QgsCircle(QgsEllipse):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, center: QgsPoint, radius: float, azimuth: float = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsCircle) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def toString(self, pointPrecision: int = ..., radiusPrecision: int = ..., azimuthPrecision: int = ...) -> str: ...
    def boundingBox(self) -> QgsRectangle: ...
    def contains(self, point: QgsPoint, epsilon: float = ...) -> bool: ...
    def toCircularString(self, oriented: bool = ...) -> QgsCircularString: ...
    def northQuadrant(self) -> List[QgsPoint]: ...
    def setRadius(self, radius: float) -> None: ...
    def radius(self) -> float: ...
    def setSemiMinorAxis(self, semiMinorAxis: float) -> None: ...
    def setSemiMajorAxis(self, semiMajorAxis: float) -> None: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def innerTangents(self, other: QgsCircle) -> Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    def outerTangents(self, other: QgsCircle) -> Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    def tangentToPoint(self, p: QgsPointXY) -> Tuple[bool, QgsPointXY, QgsPointXY]: ...
    def intersections(self, other: QgsCircle, useZ: bool = ...) -> Tuple[int, QgsPoint, QgsPoint]: ...
    @staticmethod
    def minimalCircleFrom3Points(pt1: QgsPoint, pt2: QgsPoint, pt3: QgsPoint, epsilon: float = ...) -> QgsCircle: ...
    @staticmethod
    def fromExtent(pt1: QgsPoint, pt2: QgsPoint) -> QgsCircle: ...
    @staticmethod
    def from3TangentsMulti(pt1_tg1: QgsPoint, pt2_tg1: QgsPoint, pt1_tg2: QgsPoint, pt2_tg2: QgsPoint, pt1_tg3: QgsPoint, pt2_tg3: QgsPoint, epsilon: float = ..., pos: QgsPoint = ...) -> List[QgsCircle]: ...
    @staticmethod
    def from3Tangents(pt1_tg1: QgsPoint, pt2_tg1: QgsPoint, pt1_tg2: QgsPoint, pt2_tg2: QgsPoint, pt1_tg3: QgsPoint, pt2_tg3: QgsPoint, epsilon: float = ..., pos: QgsPoint = ...) -> QgsCircle: ...
    @staticmethod
    def fromCenterPoint(center: QgsPoint, pt1: QgsPoint) -> QgsCircle: ...
    @staticmethod
    def fromCenterDiameter(center: QgsPoint, diameter: float, azimuth: float = ...) -> QgsCircle: ...
    @staticmethod
    def from3Points(pt1: QgsPoint, pt2: QgsPoint, pt3: QgsPoint, epsilon: float = ...) -> QgsCircle: ...
    @staticmethod
    def from2Points(pt1: QgsPoint, pt2: QgsPoint) -> QgsCircle: ...


class QgsCurve(QgsAbstractGeometry):

    class Orientation(int):
        ...
    Clockwise: QgsCurve.Orientation = ...
    CounterClockwise: QgsCurve.Orientation = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCurve) -> None: ...

    def childPoint(self, index: int) -> QgsPoint: ...
    def childCount(self) -> int: ...
    def clearCache(self) -> None: ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def orientation(self) -> QgsCurve.Orientation: ...
    def sinuosity(self) -> float: ...
    def straightDistance2d(self) -> float: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> QgsCurve: ...
    def interpolatePoint(self, distance: float) -> QgsPoint: ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def boundingBox(self) -> QgsRectangle: ...
    def normalize(self) -> None: ...
    def toCurveType(self) -> QgsCurve: ...
    def vertexAt(self, id: QgsVertexId) -> QgsPoint: ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsCurve: ...
    def asKml(self, precision: int = ...) -> str: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def reversed(self) -> QgsCurve: ...
    def indexOf(self, point: QgsPoint) -> int: ...
    def pointAt(self, node: int) -> Tuple[bool, QgsPoint, QgsVertexId.VertexType]: ...
    def vertexNumberFromVertexId(self, id: QgsVertexId) -> int: ...
    def adjacentVertices(self, vertex: QgsVertexId) -> Tuple[QgsVertexId, QgsVertexId]: ...
    def nextVertex(self, id: QgsVertexId) -> Tuple[bool, QgsPoint]: ...
    def coordinateSequence(self) -> typing.Any: ...
    def sumUpArea(self) -> float: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def numPoints(self) -> int: ...
    def points(self) -> List[QgsPoint]: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsLineString: ...
    def isRing(self) -> bool: ...
    def isClosed(self) -> bool: ...
    def endPoint(self) -> QgsPoint: ...
    def startPoint(self) -> QgsPoint: ...
    def clone(self) -> QgsCurve: ...
    def equals(self, other: QgsCurve) -> bool: ...


class QgsCircularString(QgsCurve):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint) -> None: ...
    @overload
    def __init__(self, x: Iterable[float], y: Iterable[float], z: Iterable[float] = ..., m: Iterable[float] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsCircularString) -> None: ...

    def calculateBoundingBox(self) -> QgsRectangle: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsCircularString: ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> QgsCircularString: ...
    def interpolatePoint(self, distance: float) -> QgsPoint: ...
    def reversed(self) -> QgsCircularString: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def hasCurvedSegments(self) -> bool: ...
    def sumUpArea(self) -> float: ...
    def pointAt(self, node: int, point: QgsPoint) -> Tuple[bool, QgsVertexId.VertexType]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsCircularString: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsLineString: ...
    def endPoint(self) -> QgsPoint: ...
    def startPoint(self) -> QgsPoint: ...
    def length(self) -> float: ...
    def append(self, string: QgsCircularString) -> None: ...
    def setPoints(self, points: Iterable[QgsPoint]) -> None: ...
    def points(self) -> List[QgsPoint]: ...
    def pointN(self, i: int) -> QgsPoint: ...
    def indexOf(self, point: QgsPoint) -> int: ...
    def numPoints(self) -> int: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def isEmpty(self) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsCircularString: ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def equals(self, other: QgsCurve) -> bool: ...
    @staticmethod
    def fromTwoPointsAndCenter(p1: QgsPoint, p2: QgsPoint, center: QgsPoint, useShortestArc: bool = ...) -> QgsCircularString: ...


class QgsCompoundCurve(QgsCurve):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, curve: QgsCompoundCurve) -> None: ...

    def calculateBoundingBox(self) -> QgsRectangle: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsCompoundCurve: ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> QgsCompoundCurve: ...
    def interpolatePoint(self, distance: float) -> QgsPoint: ...
    def reversed(self) -> QgsCompoundCurve: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def hasCurvedSegments(self) -> bool: ...
    def close(self) -> None: ...
    def sumUpArea(self) -> float: ...
    def pointAt(self, node: int, point: QgsPoint) -> Tuple[bool, QgsVertexId.VertexType]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def condenseCurves(self) -> None: ...
    def addVertex(self, pt: QgsPoint) -> None: ...
    def removeCurve(self, i: int) -> None: ...
    def addCurve(self, c: QgsCurve, extendPrevious: bool = ...) -> None: ...
    def curveAt(self, i: int) -> QgsCurve: ...
    def nCurves(self) -> int: ...
    def simplifiedTypeRef(self) -> QgsAbstractGeometry: ...
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsCompoundCurve: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsLineString: ...
    def indexOf(self, point: QgsPoint) -> int: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def isEmpty(self) -> bool: ...
    def numPoints(self) -> int: ...
    def points(self) -> List[QgsPoint]: ...
    def endPoint(self) -> QgsPoint: ...
    def startPoint(self) -> QgsPoint: ...
    def length(self) -> float: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsCompoundCurve: ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def equals(self, other: QgsCurve) -> bool: ...


class QgsSurface(QgsAbstractGeometry):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSurface) -> None: ...

    def clearCache(self) -> None: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def boundingBox(self) -> QgsRectangle: ...
    def surfaceToPolygon(self) -> QgsPolygon: ...


class QgsCurvePolygon(QgsSurface):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p: QgsCurvePolygon) -> None: ...

    def calculateBoundingBox(self) -> QgsRectangle: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def childGeometry(self, index: int) -> QgsAbstractGeometry: ...
    def childCount(self) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsCurvePolygon: ...
    def toCurveType(self) -> QgsCurvePolygon: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def vertexAt(self, id: QgsVertexId) -> QgsPoint: ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsAbstractGeometry: ...
    def hasCurvedSegments(self) -> bool: ...
    def adjacentVertices(self, vertex: QgsVertexId) -> Tuple[QgsVertexId, QgsVertexId]: ...
    def nextVertex(self, id: QgsVertexId) -> Tuple[bool, QgsPoint]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def isEmpty(self) -> bool: ...
    def vertexNumberFromVertexId(self, id: QgsVertexId) -> int: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def forceRHR(self) -> None: ...
    def removeInvalidRings(self) -> None: ...
    def removeInteriorRings(self, minimumAllowedArea: float = ...) -> None: ...
    def removeInteriorRing(self, i: int) -> bool: ...
    def addInteriorRing(self, ring: QgsCurve) -> None: ...
    def setInteriorRings(self, rings: typing.Any) -> None: ...
    def setExteriorRing(self, ring: QgsCurve) -> None: ...
    def toPolygon(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsPolygon: ...
    def interiorRing(self, i: int) -> QgsCurve: ...
    def exteriorRing(self) -> QgsCurve: ...
    def numInteriorRings(self) -> int: ...
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsCurvePolygon: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def surfaceToPolygon(self) -> QgsPolygon: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def normalize(self) -> None: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsCurvePolygon: ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...


class QgsGeometry(sip.wrapper):

    class ValidationMethod(int):
        ...
    ValidatorQgisInternal: QgsGeometry.ValidationMethod = ...
    ValidatorGeos: QgsGeometry.ValidationMethod = ...

    class JoinStyle(int):
        ...
    JoinStyleRound: QgsGeometry.JoinStyle = ...
    JoinStyleMiter: QgsGeometry.JoinStyle = ...
    JoinStyleBevel: QgsGeometry.JoinStyle = ...

    class EndCapStyle(int):
        ...
    CapRound: QgsGeometry.EndCapStyle = ...
    CapFlat: QgsGeometry.EndCapStyle = ...
    CapSquare: QgsGeometry.EndCapStyle = ...

    class BufferSide(int):
        ...
    SideLeft: QgsGeometry.BufferSide = ...
    SideRight: QgsGeometry.BufferSide = ...

    class ValidityFlag(int):
        ...
    FlagAllowSelfTouchingHoles: QgsGeometry.ValidityFlag = ...

    class OperationResult(int):
        ...
    Success: QgsGeometry.OperationResult = ...
    NothingHappened: QgsGeometry.OperationResult = ...
    InvalidBaseGeometry: QgsGeometry.OperationResult = ...
    InvalidInputGeometryType: QgsGeometry.OperationResult = ...
    SelectionIsEmpty: QgsGeometry.OperationResult = ...
    SelectionIsGreaterThanOne: QgsGeometry.OperationResult = ...
    GeometryEngineError: QgsGeometry.OperationResult = ...
    LayerNotEditable: QgsGeometry.OperationResult = ...
    AddPartSelectedGeometryNotFound: QgsGeometry.OperationResult = ...
    AddPartNotMultiGeometry: QgsGeometry.OperationResult = ...
    AddRingNotClosed: QgsGeometry.OperationResult = ...
    AddRingNotValid: QgsGeometry.OperationResult = ...
    AddRingCrossesExistingRings: QgsGeometry.OperationResult = ...
    AddRingNotInExistingFeature: QgsGeometry.OperationResult = ...
    SplitCannotSplitPoint: QgsGeometry.OperationResult = ...

    class ValidityFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsGeometry.ValidityFlags, QgsGeometry.ValidityFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsGeometry.ValidityFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsGeometry.ValidityFlags: ...
        def __int__(self) -> int: ...

    class Error(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, m: str) -> None: ...
        @overload
        def __init__(self, m: str, p: QgsPointXY) -> None: ...
        @overload
        def __init__(self, a0: QgsGeometry.Error) -> None: ...

        def __repr__(self) -> typing.Any: ...
        def hasWhere(self) -> bool: ...
        def where(self) -> QgsPointXY: ...
        def what(self) -> str: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometry) -> None: ...
    @overload
    def __init__(self, geom: QgsAbstractGeometry) -> None: ...

    @overload
    @staticmethod
    def convertPointList(input: Iterable[QgsPointXY], output: Iterable[QgsPoint]) -> None: ...
    @overload
    @staticmethod
    def convertPointList(input: Iterable[QgsPoint], output: Iterable[QgsPointXY]) -> None: ...
    @staticmethod
    def createGeometryEngine(geometry: QgsAbstractGeometry) -> QgsGeometryEngine: ...
    def smooth(self, iterations: int = ..., offset: float = ..., minimumDistance: float = ..., maxAngle: float = ...) -> QgsGeometry: ...
    @staticmethod
    def compare(obj1: typing.Any, obj2: typing.Any, epsilon: float = ...) -> bool: ...
    @staticmethod
    def createPolygonFromQPolygonF(polygon: QtGui.QPolygonF) -> typing.Any: ...
    @staticmethod
    def createPolylineFromQPolygonF(polygon: QtGui.QPolygonF) -> List[QgsPointXY]: ...
    @staticmethod
    def fromQPolygonF(polygon: QtGui.QPolygonF) -> QgsGeometry: ...
    @staticmethod
    def fromQPointF(point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> QgsGeometry: ...
    def lastError(self) -> str: ...
    def vertexNrFromVertexId(self, id: QgsVertexId) -> int: ...
    def vertexIdFromVertexNr(self, number: int) -> Tuple[bool, QgsVertexId]: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def mapToPixel(self, mtp: QgsMapToPixel) -> None: ...
    def requiresConversionToStraightSegments(self) -> bool: ...
    def convertToStraightSegment(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> None: ...
    @staticmethod
    def polygonize(geometries: Iterable[QgsGeometry]) -> QgsGeometry: ...
    @staticmethod
    def unaryUnion(geometries: Iterable[QgsGeometry]) -> QgsGeometry: ...
    def normalize(self) -> None: ...
    def validateGeometry(self, method: QgsGeometry.ValidationMethod = ..., flags: Union[QgsGeometry.ValidityFlags, QgsGeometry.ValidityFlag] = ...) -> List[QgsGeometry.Error]: ...
    def forceRHR(self) -> QgsGeometry: ...
    def makeValid(self) -> QgsGeometry: ...
    def avoidIntersections(self, avoidIntersectionsLayers: Iterable[QgsVectorLayer]) -> int: ...
    def convertGeometryCollectionToSubclass(self, geomType: QgsWkbTypes.GeometryType) -> bool: ...
    def convertToSingleType(self) -> bool: ...
    def convertToMultiType(self) -> bool: ...
    def deletePart(self, partNum: int) -> bool: ...
    def deleteRing(self, ringNum: int, partNum: int = ...) -> bool: ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def asQPointF(self) -> QtCore.QPointF: ...
    def asGeometryCollection(self) -> List[QgsGeometry]: ...
    def asMultiPolygon(self) -> QgsMultiPolygonXY: ...
    def asMultiPolyline(self) -> QgsMultiPolylineXY: ...
    def asMultiPoint(self) -> QgsMultiPointXY: ...
    def asPolygon(self) -> QgsPolygonXY: ...
    def asPolyline(self) -> QgsPolylineXY: ...
    def asPoint(self) -> QgsPointXY: ...
    def convertToType(self, destType: QgsWkbTypes.GeometryType, destMultipart: bool = ...) -> QgsGeometry: ...
    def coerceToType(self, type: QgsWkbTypes.Type) -> List[QgsGeometry]: ...
    def asJson(self, precision: int = ...) -> str: ...
    def __repr__(self) -> typing.Any: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def randomPointsInPolygon(self, count: int, seed: int = ...) -> QgsPolylineXY: ...
    def extrude(self, x: float, y: float) -> QgsGeometry: ...
    def symDifference(self, geometry: QgsGeometry) -> QgsGeometry: ...
    def difference(self, geometry: QgsGeometry) -> QgsGeometry: ...
    def mergeLines(self) -> QgsGeometry: ...
    def combine(self, geometry: QgsGeometry) -> QgsGeometry: ...
    def clipped(self, rectangle: QgsRectangle) -> QgsGeometry: ...
    def intersection(self, geometry: QgsGeometry) -> QgsGeometry: ...
    def interpolateAngle(self, distance: float) -> float: ...
    def lineLocatePoint(self, point: QgsGeometry) -> float: ...
    def interpolate(self, distance: float) -> QgsGeometry: ...
    def subdivide(self, maxNodes: int = ...) -> QgsGeometry: ...
    def sharedPaths(self, other: QgsGeometry) -> QgsGeometry: ...
    def node(self) -> QgsGeometry: ...
    def delaunayTriangulation(self, tolerance: float = ..., edgesOnly: bool = ...) -> QgsGeometry: ...
    def voronoiDiagram(self, extent: QgsGeometry = ..., tolerance: float = ..., edgesOnly: bool = ...) -> QgsGeometry: ...
    def convexHull(self) -> QgsGeometry: ...
    def minimumClearanceLine(self) -> QgsGeometry: ...
    def minimumClearance(self) -> float: ...
    def minimumWidth(self) -> QgsGeometry: ...
    def largestEmptyCircle(self, tolerance: float, boundary: QgsGeometry = ...) -> QgsGeometry: ...
    def poleOfInaccessibility(self, precision: float) -> Tuple[QgsGeometry, float]: ...
    def pointOnSurface(self) -> QgsGeometry: ...
    def centroid(self) -> QgsGeometry: ...
    def convertToCurves(self, distanceTolerance: float = ..., angleTolerance: float = ...) -> QgsGeometry: ...
    def densifyByDistance(self, distance: float) -> QgsGeometry: ...
    def densifyByCount(self, extraNodesPerSegment: int) -> QgsGeometry: ...
    def simplify(self, tolerance: float) -> QgsGeometry: ...
    def extendLine(self, startDistance: float, endDistance: float) -> QgsGeometry: ...
    def variableWidthBufferByM(self, segments: int) -> QgsGeometry: ...
    def taperedBuffer(self, startWidth: float, endWidth: float, segments: int) -> QgsGeometry: ...
    def singleSidedBuffer(self, distance: float, segments: int, side: QgsGeometry.BufferSide, joinStyle: QgsGeometry.JoinStyle = ..., miterLimit: float = ...) -> QgsGeometry: ...
    def offsetCurve(self, distance: float, segments: int, joinStyle: QgsGeometry.JoinStyle, miterLimit: float) -> QgsGeometry: ...
    @overload
    def buffer(self, distance: float, segments: int) -> QgsGeometry: ...
    @overload
    def buffer(self, distance: float, segments: int, endCapStyle: QgsGeometry.EndCapStyle, joinStyle: QgsGeometry.JoinStyle, miterLimit: float) -> QgsGeometry: ...
    def crosses(self, geometry: QgsGeometry) -> bool: ...
    def within(self, geometry: QgsGeometry) -> bool: ...
    def overlaps(self, geometry: QgsGeometry) -> bool: ...
    def touches(self, geometry: QgsGeometry) -> bool: ...
    def disjoint(self, geometry: QgsGeometry) -> bool: ...
    @overload
    def contains(self, p: QgsPointXY) -> bool: ...
    @overload
    def contains(self, geometry: QgsGeometry) -> bool: ...
    @overload
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    @overload
    def boundingBoxIntersects(self, geometry: QgsGeometry) -> bool: ...
    @overload
    def intersects(self, rectangle: QgsRectangle) -> bool: ...
    @overload
    def intersects(self, geometry: QgsGeometry) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsGeometry: ...
    def orthogonalize(self, tolerance: float = ..., maxIterations: int = ..., angleThreshold: float = ...) -> QgsGeometry: ...
    def minimalEnclosingCircle(self, segments: int = ...) -> Tuple[QgsGeometry, QgsPointXY, float]: ...
    def orientedMinimumBoundingBox(self) -> Tuple[QgsGeometry, float, float, float, float]: ...
    def boundingBox(self) -> QgsRectangle: ...
    def makeDifference(self, other: QgsGeometry) -> QgsGeometry: ...
    def reshapeGeometry(self, reshapeLineString: QgsLineString) -> QgsGeometry.OperationResult: ...
    @overload
    def splitGeometry(self, splitLine: Iterable[QgsPointXY], topological: bool, splitFeature: bool = ...) -> Tuple[QgsGeometry.OperationResult, List[QgsGeometry], List[QgsPointXY]]: ...
    @overload
    def splitGeometry(self, splitLine: Iterable[QgsPoint], topological: bool, splitFeature: bool = ...) -> Tuple[QgsGeometry.OperationResult, List[QgsGeometry], List[QgsPoint]]: ...
    @overload
    def splitGeometry(self, curve: QgsCurve, preserveCircular: bool, topological: bool, splitFeature: bool = ...) -> Tuple[QgsGeometry.OperationResult, List[QgsGeometry], List[QgsPoint]]: ...
    def rotate(self, rotation: float, center: QgsPointXY) -> QgsGeometry.OperationResult: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, direction: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> QgsGeometry.OperationResult: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> QgsGeometry.OperationResult: ...
    def translate(self, dx: float, dy: float, dz: float = ..., dm: float = ...) -> QgsGeometry.OperationResult: ...
    def removeInteriorRings(self, minimumAllowedArea: float = ...) -> QgsGeometry: ...
    def addPartGeometry(self, newPart: QgsGeometry) -> QgsGeometry.OperationResult: ...
    def addPart(self, part: QgsAbstractGeometry, geomType: QgsWkbTypes.GeometryType = ...) -> QgsGeometry.OperationResult: ...
    def addPoints(self, points: Iterable[QgsPoint], geomType: QgsWkbTypes.GeometryType = ...) -> QgsGeometry.OperationResult: ...
    def addPointsXY(self, points: Iterable[QgsPointXY], geomType: QgsWkbTypes.GeometryType = ...) -> QgsGeometry.OperationResult: ...
    @overload
    def addRing(self, ring: Iterable[QgsPointXY]) -> QgsGeometry.OperationResult: ...
    @overload
    def addRing(self, ring: QgsCurve) -> QgsGeometry.OperationResult: ...
    def closestSegmentWithContext(self, point: QgsPointXY, epsilon: float = ...) -> Tuple[float, QgsPointXY, int, int]: ...
    def closestVertexWithContext(self, point: QgsPointXY) -> Tuple[float, int]: ...
    def shortestLine(self, other: QgsGeometry) -> QgsGeometry: ...
    def nearestPoint(self, other: QgsGeometry) -> QgsGeometry: ...
    def sqrDistToVertexAt(self, point: QgsPointXY, atVertex: int) -> float: ...
    def vertexAt(self, atVertex: int) -> QgsPoint: ...
    def deleteVertex(self, atVertex: int) -> bool: ...
    @overload
    def moveVertex(self, x: float, y: float, atVertex: int) -> bool: ...
    @overload
    def moveVertex(self, p: QgsPoint, atVertex: int) -> bool: ...
    @overload
    def insertVertex(self, x: float, y: float, beforeVertex: int) -> bool: ...
    @overload
    def insertVertex(self, point: QgsPoint, beforeVertex: int) -> bool: ...
    def adjacentVertices(self, atVertex: int) -> Tuple[int, int]: ...
    def angleAtVertex(self, vertex: int) -> float: ...
    def distanceToVertex(self, vertex: int) -> float: ...
    def closestVertex(self, point: QgsPointXY) -> Tuple[QgsPointXY, int, int, int, float]: ...
    def frechetDistanceDensify(self, geom: QgsGeometry, densifyFraction: float) -> float: ...
    def frechetDistance(self, geom: QgsGeometry) -> float: ...
    def hausdorffDistanceDensify(self, geom: QgsGeometry, densifyFraction: float) -> float: ...
    def hausdorffDistance(self, geom: QgsGeometry) -> float: ...
    def constParts(self) -> QgsGeometryConstPartIterator: ...
    def parts(self) -> QgsGeometryPartIterator: ...
    def vertices(self) -> QgsVertexIterator: ...
    def distance(self, geom: QgsGeometry) -> float: ...
    def length(self) -> float: ...
    def area(self) -> float: ...
    def isAxisParallelRectangle(self, maximumDeviation: float, simpleRectanglesOnly: bool = ...) -> bool: ...
    def isSimple(self) -> bool: ...
    def isGeosValid(self, flags: Union[QgsGeometry.ValidityFlags, QgsGeometry.ValidityFlag] = ...) -> bool: ...
    def isGeosEqual(self, a0: QgsGeometry) -> bool: ...
    def equals(self, geometry: QgsGeometry) -> bool: ...
    def isMultipart(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def type(self) -> QgsWkbTypes.GeometryType: ...
    def wkbType(self) -> QgsWkbTypes.Type: ...
    def fromWkb(self, wkb: Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    @staticmethod
    def createWedgeBuffer(center: QgsPoint, azimuth: float, angularWidth: float, outerRadius: float, innerRadius: float = ...) -> QgsGeometry: ...
    @staticmethod
    def collectGeometry(geometries: Iterable[QgsGeometry]) -> QgsGeometry: ...
    @staticmethod
    def fromRect(rect: QgsRectangle) -> QgsGeometry: ...
    @staticmethod
    def fromMultiPolygonXY(multipoly: typing.Any) -> QgsGeometry: ...
    @staticmethod
    def fromPolygonXY(polygon: typing.Any) -> QgsGeometry: ...
    @staticmethod
    def fromMultiPolylineXY(multiline: typing.Any) -> QgsGeometry: ...
    @staticmethod
    def fromPolyline(polyline: Iterable[QgsPoint]) -> QgsGeometry: ...
    @staticmethod
    def fromPolylineXY(polyline: Iterable[QgsPointXY]) -> QgsGeometry: ...
    @staticmethod
    def fromMultiPointXY(multipoint: Iterable[QgsPointXY]) -> QgsGeometry: ...
    @staticmethod
    def fromPointXY(point: QgsPointXY) -> QgsGeometry: ...
    @staticmethod
    def fromWkt(wkt: str) -> QgsGeometry: ...
    def isNull(self) -> bool: ...
    def set(self, geometry: QgsAbstractGeometry) -> None: ...
    def get(self) -> QgsAbstractGeometry: ...
    def constGet(self) -> QgsAbstractGeometry: ...


class QgsGeometryCollection(QgsAbstractGeometry):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, c: QgsGeometryCollection) -> None: ...

    def clearCache(self) -> None: ...
    def calculateBoundingBox(self) -> QgsRectangle: ...
    def fromCollectionWkt(self, wkt: str, subtypes: typing.Any, defaultChildWkbType: str = ...) -> bool: ...
    def wktOmitChildType(self) -> bool: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def childGeometry(self, index: int) -> QgsAbstractGeometry: ...
    def childCount(self) -> int: ...
    def createEmptyWithSameType(self) -> QgsGeometryCollection: ...
    def __iter__(self) -> QgsGeometryPartIterator: ...
    def __delitem__(self, index: int) -> None: ...
    def __getitem__(self, index: int) -> QgsAbstractGeometry: ...
    def simplifiedTypeRef(self) -> QgsAbstractGeometry: ...
    def toCurveType(self) -> QgsGeometryCollection: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def vertexAt(self, id: QgsVertexId) -> QgsPoint: ...
    def partCount(self) -> int: ...
    def ringCount(self, part: int = ...) -> int: ...
    def vertexCount(self, part: int = ..., ring: int = ...) -> int: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def segmentize(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsAbstractGeometry: ...
    def hasCurvedSegments(self) -> bool: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def length(self) -> float: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def nextVertex(self, id: QgsVertexId) -> Tuple[bool, QgsPoint]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    def boundingBox(self) -> QgsRectangle: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def normalize(self) -> None: ...
    def removeGeometry(self, nr: int) -> bool: ...
    def insertGeometry(self, g: QgsAbstractGeometry, index: int) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry) -> bool: ...
    def reserve(self, size: int) -> None: ...
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    def vertexNumberFromVertexId(self, id: QgsVertexId) -> int: ...
    def adjacentVertices(self, vertex: QgsVertexId) -> Tuple[QgsVertexId, QgsVertexId]: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsGeometryCollection: ...
    def clear(self) -> None: ...
    def geometryType(self) -> str: ...
    def dimension(self) -> int: ...
    def isEmpty(self) -> bool: ...
    def geometryN(self, n: int) -> QgsAbstractGeometry: ...
    def __bool__(self) -> int: ...
    def __len__(self) -> int: ...
    def numGeometries(self) -> int: ...
    def clone(self) -> QgsGeometryCollection: ...


class QgsGeometryEngine(sip.wrapper):

    class EngineOperationResult(int):
        ...
    Success: QgsGeometryEngine.EngineOperationResult = ...
    NothingHappened: QgsGeometryEngine.EngineOperationResult = ...
    MethodNotImplemented: QgsGeometryEngine.EngineOperationResult = ...
    EngineError: QgsGeometryEngine.EngineOperationResult = ...
    NodedGeometryError: QgsGeometryEngine.EngineOperationResult = ...
    InvalidBaseGeometry: QgsGeometryEngine.EngineOperationResult = ...
    InvalidInput: QgsGeometryEngine.EngineOperationResult = ...
    SplitCannotSplitPoint: QgsGeometryEngine.EngineOperationResult = ...

    @overload
    def __init__(self, geometry: QgsAbstractGeometry) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryEngine) -> None: ...

    def logError(self, engineName: str, message: str) -> None: ...
    def setLogErrors(self, enabled: bool) -> None: ...
    def offsetCurve(self, distance: float, segments: int, joinStyle: int, miterLimit: float, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def splitGeometry(self, splitLine: QgsLineString, topological: bool, topologyTestPoints: Iterable[QgsPoint], errorMsg: Optional[str] = ..., skipIntersectionCheck: bool = ...) -> Tuple[QgsGeometryEngine.EngineOperationResult, List[QgsGeometry]]: ...
    def isSimple(self, errorMsg: Optional[str] = ...) -> bool: ...
    def isEmpty(self, errorMsg: str) -> bool: ...
    def isEqual(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def isValid(self, errorMsg: Optional[str] = ..., allowSelfTouchingHoles: bool = ..., errorLoc: Optional[QgsGeometry] = ...) -> bool: ...
    def length(self, errorMsg: Optional[str] = ...) -> float: ...
    def area(self, errorMsg: Optional[str] = ...) -> float: ...
    def relatePattern(self, geom: QgsAbstractGeometry, pattern: str, errorMsg: Optional[str] = ...) -> bool: ...
    def relate(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> str: ...
    def disjoint(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def contains(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def overlaps(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def within(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def crosses(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def touches(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def intersects(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> bool: ...
    def distance(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> float: ...
    def convexHull(self, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def pointOnSurface(self, errorMsg: Optional[str] = ...) -> QgsPoint: ...
    def centroid(self, errorMsg: Optional[str] = ...) -> QgsPoint: ...
    def envelope(self, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def interpolate(self, distance: float, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def simplify(self, tolerance: float, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    @overload
    def buffer(self, distance: float, segments: int, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    @overload
    def buffer(self, distance: float, segments: int, endCapStyle: int, joinStyle: int, miterLimit: float, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def symDifference(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    @overload
    def combine(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    @overload
    def combine(self, geomList: typing.Any, errorMsg: str) -> QgsAbstractGeometry: ...
    @overload
    def combine(self, geometries: Iterable[QgsGeometry], errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def difference(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def intersection(self, geom: QgsAbstractGeometry, errorMsg: Optional[str] = ...) -> QgsAbstractGeometry: ...
    def prepareGeometry(self) -> None: ...
    def geometryChanged(self) -> None: ...


class QgsAbstractGeometryTransformer(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractGeometryTransformer) -> None: ...

    def transformPoint(self, x: float, y: float, z: float, m: float) -> Tuple[bool, float, float, float, float]: ...


class QgsGeometryUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryUtils) -> None: ...

    @staticmethod
    def bisector(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float) -> Tuple[bool, float, float]: ...
    @staticmethod
    def angleBisector(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float, dX: float, dY: float) -> Tuple[bool, float, float, float]: ...
    @staticmethod
    def transferFirstMValueToPoint(points: Iterable[QgsPoint], point: QgsPoint) -> bool: ...
    @staticmethod
    def transferFirstZValueToPoint(points: Iterable[QgsPoint], point: QgsPoint) -> bool: ...
    @staticmethod
    def setZValueFromPoints(points: Iterable[QgsPoint], point: QgsPoint) -> bool: ...
    @staticmethod
    def weightedPointInTriangle(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float, weightB: float, weightC: float) -> Tuple[float, float]: ...
    @staticmethod
    def triangleArea(aX: float, aY: float, bX: float, bY: float, cX: float, cY: float) -> float: ...
    @staticmethod
    def linesIntersection3D(La1: QgsVector3D, La2: QgsVector3D, Lb1: QgsVector3D, Lb2: QgsVector3D) -> Tuple[bool, QgsVector3D]: ...
    @staticmethod
    def skewLinesProjection(P1: QgsVector3D, P12: QgsVector3D, P2: QgsVector3D, P22: QgsVector3D, epsilon: float = ...) -> Tuple[bool, QgsVector3D]: ...
    @staticmethod
    def skewLinesDistance(P1: QgsVector3D, P12: QgsVector3D, P2: QgsVector3D, P22: QgsVector3D) -> float: ...
    @staticmethod
    def perpendicularSegment(p: QgsPoint, s1: QgsPoint, s2: QgsPoint) -> QgsLineString: ...
    @staticmethod
    def coefficients(pt1: QgsPoint, pt2: QgsPoint) -> Tuple[float, float, float]: ...
    @staticmethod
    def gradient(pt1: QgsPoint, pt2: QgsPoint) -> float: ...
    @staticmethod
    def interpolatePointOnLineByValue(x1: float, y1: float, v1: float, x2: float, y2: float, v2: float, value: float) -> QgsPointXY: ...
    @overload
    @staticmethod
    def interpolatePointOnLine(x1: float, y1: float, x2: float, y2: float, fraction: float) -> QgsPointXY: ...
    @overload
    @staticmethod
    def interpolatePointOnLine(p1: QgsPoint, p2: QgsPoint, fraction: float) -> QgsPoint: ...
    @staticmethod
    def midpoint(pt1: QgsPoint, pt2: QgsPoint) -> QgsPoint: ...
    @staticmethod
    def closestSideOfRectangle(right: float, bottom: float, left: float, top: float, x: float, y: float) -> int: ...
    @overload
    @staticmethod
    def averageAngle(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @overload
    @staticmethod
    def averageAngle(a1: float, a2: float) -> float: ...
    @staticmethod
    def linePerpendicularAngle(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    def angleBetweenThreePoints(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    def lineAngle(x1: float, y1: float, x2: float, y2: float) -> float: ...
    @staticmethod
    def normalizedAngle(angle: float) -> float: ...
    @staticmethod
    def interpolateArcValue(angle: float, a1: float, a2: float, a3: float, zm1: float, zm2: float, zm3: float) -> float: ...
    @staticmethod
    def segmentSide(pt1: QgsPoint, pt3: QgsPoint, pt2: QgsPoint) -> int: ...
    @staticmethod
    def pointContinuesArc(a1: QgsPoint, a2: QgsPoint, a3: QgsPoint, b: QgsPoint, distanceTolerance: float, pointSpacingAngleTolerance: float) -> bool: ...
    @staticmethod
    def segmentizeArc(p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ..., hasZ: bool = ..., hasM: bool = ...) -> List[QgsPoint]: ...
    @staticmethod
    def circleTangentDirection(tangentPoint: QgsPoint, cp1: QgsPoint, cp2: QgsPoint, cp3: QgsPoint) -> float: ...
    @staticmethod
    def segmentMidPointFromCenter(p1: QgsPoint, p2: QgsPoint, center: QgsPoint, useShortestArc: bool = ...) -> QgsPoint: ...
    @staticmethod
    def segmentMidPoint(p1: QgsPoint, p2: QgsPoint, radius: float, mousePos: QgsPoint) -> Tuple[bool, QgsPoint]: ...
    @staticmethod
    def sweepAngle(centerX: float, centerY: float, x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    def circleLength(x1: float, y1: float, x2: float, y2: float, x3: float, y3: float) -> float: ...
    @staticmethod
    def angleOnCircle(angle: float, angle1: float, angle2: float, angle3: float) -> bool: ...
    @staticmethod
    def circleAngleBetween(angle: float, angle1: float, angle2: float, clockwise: bool) -> bool: ...
    @staticmethod
    def circleClockwise(angle1: float, angle2: float, angle3: float) -> bool: ...
    @staticmethod
    def circleCenterRadius(pt1: QgsPoint, pt2: QgsPoint, pt3: QgsPoint) -> Tuple[float, float, float]: ...
    @staticmethod
    def ccwAngle(dy: float, dx: float) -> float: ...
    @staticmethod
    def interpolatePointOnArc(pt1: QgsPoint, pt2: QgsPoint, pt3: QgsPoint, distance: float) -> QgsPoint: ...
    @staticmethod
    def perpendicularOffsetPointAlongSegment(x1: float, y1: float, x2: float, y2: float, proportion: float, offset: float) -> Tuple[float, float]: ...
    @staticmethod
    def pointOnLineWithDistance(startPoint: QgsPoint, directionPoint: QgsPoint, distance: float) -> QgsPoint: ...
    @overload
    @staticmethod
    def leftOfLine(x: float, y: float, x1: float, y1: float, x2: float, y2: float) -> int: ...
    @overload
    @staticmethod
    def leftOfLine(point: QgsPoint, p1: QgsPoint, p2: QgsPoint) -> int: ...
    @staticmethod
    def projectPointOnSegment(p: QgsPoint, s1: QgsPoint, s2: QgsPoint) -> QgsPoint: ...
    @staticmethod
    def circleCircleInnerTangents(center1: QgsPointXY, radius1: float, center2: QgsPointXY, radius2: float) -> Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def circleCircleOuterTangents(center1: QgsPointXY, radius1: float, center2: QgsPointXY, radius2: float) -> Tuple[int, QgsPointXY, QgsPointXY, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def tangentPointAndCircle(center: QgsPointXY, radius: float, p: QgsPointXY) -> Tuple[bool, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def circleCircleIntersections(center1: QgsPointXY, radius1: float, center2: QgsPointXY, radius2: float) -> Tuple[int, QgsPointXY, QgsPointXY]: ...
    @staticmethod
    def lineCircleIntersection(center: QgsPointXY, radius: float, linePoint1: QgsPointXY, linePoint2: QgsPointXY, intersection: QgsPointXY) -> Tuple[bool, QgsPointXY]: ...
    @staticmethod
    def segmentIntersection(p1: QgsPoint, p2: QgsPoint, q1: QgsPoint, q2: QgsPoint, tolerance: float = ..., acceptImproperIntersection: bool = ...) -> Tuple[bool, QgsPoint, bool]: ...
    @staticmethod
    def lineIntersection(p1: QgsPoint, v1: QgsVector, p2: QgsPoint, v2: QgsVector) -> Tuple[bool, QgsPoint]: ...
    @staticmethod
    def sqrDistToLine(ptX: float, ptY: float, x1: float, y1: float, x2: float, y2: float, epsilon: float) -> Tuple[float, float, float]: ...
    @staticmethod
    def sqrDistance2D(pt1: QgsPoint, pt2: QgsPoint) -> float: ...
    @staticmethod
    def verticesAtDistance(geometry: QgsAbstractGeometry, distance: float) -> Tuple[bool, QgsVertexId, QgsVertexId]: ...
    @staticmethod
    def distanceToVertex(geom: QgsAbstractGeometry, id: QgsVertexId) -> float: ...
    @staticmethod
    def closestPoint(geometry: QgsAbstractGeometry, point: QgsPoint) -> QgsPoint: ...
    @staticmethod
    def closestVertex(geom: QgsAbstractGeometry, pt: QgsPoint) -> Tuple[QgsPoint, QgsVertexId]: ...
    @staticmethod
    def extractLineStrings(geom: QgsAbstractGeometry) -> typing.Any: ...


class QgsLineSegment2D(sip.wrapper):

    @overload
    def __init__(self, start: QgsPointXY, end: QgsPointXY) -> None: ...
    @overload
    def __init__(self, x1: float, y1: float, x2: float, y2: float) -> None: ...
    @overload
    def __init__(self, a0: QgsLineSegment2D) -> None: ...

    def reverse(self) -> None: ...
    def pointLeftOfLine(self, point: QgsPointXY) -> int: ...
    def setEnd(self, end: QgsPointXY) -> None: ...
    def setStart(self, start: QgsPointXY) -> None: ...
    def setEndY(self, y: float) -> None: ...
    def setEndX(self, x: float) -> None: ...
    def setStartY(self, y: float) -> None: ...
    def setStartX(self, x: float) -> None: ...
    def end(self) -> QgsPointXY: ...
    def start(self) -> QgsPointXY: ...
    def endY(self) -> float: ...
    def endX(self) -> float: ...
    def startY(self) -> float: ...
    def startX(self) -> float: ...
    def lengthSquared(self) -> float: ...
    def length(self) -> float: ...


class QgsLineString(QgsCurve):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, points: Sequence[Union[QgsPoint, QgsPointXY, Sequence[float]]]) -> None: ...
    @overload
    def __init__(self, segment: QgsLineSegment2D) -> None: ...
    @overload
    def __init__(self, x: Iterable[float], y: Iterable[float], z: Iterable[float] = ..., m: Iterable[float] = ..., is25DType: bool = ...) -> None: ...
    @overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint) -> None: ...
    @overload
    def __init__(self, a0: QgsLineString) -> None: ...

    def calculateBoundingBox(self) -> QgsRectangle: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def __delitem__(self, index: int) -> None: ...
    def __setitem__(self, index: int, point: QgsPoint) -> None: ...
    def __getitem__(self, index: int) -> QgsPoint: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsLineString: ...
    def scroll(self, firstVertexIndex: int) -> None: ...
    def convertTo(self, type: QgsWkbTypes.Type) -> bool: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def sumUpArea(self) -> float: ...
    def centroid(self) -> QgsPoint: ...
    def pointAt(self, node: int, point: QgsPoint) -> Tuple[bool, QgsVertexId.VertexType]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def curveSubstring(self, startDistance: float, endDistance: float) -> QgsLineString: ...
    def interpolatePoint(self, distance: float) -> QgsPoint: ...
    def reversed(self) -> QgsLineString: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def drawAsPolygon(self, p: QtGui.QPainter) -> None: ...
    def addToPainterPath(self, path: QtGui.QPainterPath) -> None: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def points(self) -> List[QgsPoint]: ...
    def nCoordinates(self) -> int: ...
    def numPoints(self) -> int: ...
    def curveToLine(self, tolerance: float = ..., toleranceType: QgsAbstractGeometry.SegmentationToleranceType = ...) -> QgsLineString: ...
    def endPoint(self) -> QgsPoint: ...
    def startPoint(self) -> QgsPoint: ...
    def length3D(self) -> float: ...
    def length(self) -> float: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def asQPolygonF(self) -> QtGui.QPolygonF: ...
    def collectDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> List[QgsVertexId]: ...
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    def isClosed(self) -> bool: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsLineString: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def indexOf(self, point: QgsPoint) -> int: ...
    def isEmpty(self) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsLineString: ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def extend(self, startDistance: float, endDistance: float) -> None: ...
    def toCurveType(self) -> QgsCompoundCurve: ...
    def close(self) -> None: ...
    def addVertex(self, pt: QgsPoint) -> None: ...
    def append(self, line: QgsLineString) -> None: ...
    def setPoints(self, points: Iterable[QgsPoint]) -> None: ...
    def setMAt(self, index: int, m: float) -> None: ...
    def setZAt(self, index: int, z: float) -> None: ...
    def setYAt(self, index: int, y: float) -> None: ...
    def setXAt(self, index: int, x: float) -> None: ...
    def mAt(self, index: int) -> float: ...
    def zAt(self, index: int) -> float: ...
    def yAt(self, index: int) -> float: ...
    def xAt(self, index: int) -> float: ...
    def pointN(self, i: int) -> QgsPoint: ...
    def equals(self, other: QgsCurve) -> bool: ...
    @staticmethod
    def fromQPolygonF(polygon: QtGui.QPolygonF) -> QgsLineString: ...
    @staticmethod
    def fromBezierCurve(start: QgsPoint, controlPoint1: QgsPoint, controlPoint2: QgsPoint, end: QgsPoint, segments: int = ...) -> QgsLineString: ...


class QgsMultiCurve(QgsGeometryCollection):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMultiCurve) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsMultiCurve: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def reversed(self) -> QgsMultiCurve: ...
    def insertGeometry(self, g: QgsAbstractGeometry, index: int) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def toCurveType(self) -> QgsMultiCurve: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsMultiCurve: ...
    def geometryType(self) -> str: ...
    def curveN(self, index: int) -> QgsCurve: ...


class QgsMultiLineString(QgsMultiCurve):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMultiLineString) -> None: ...

    def wktOmitChildType(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsMultiLineString: ...
    def toCurveType(self) -> QgsMultiCurve: ...
    def insertGeometry(self, g: QgsAbstractGeometry, index: int) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsMultiLineString: ...
    def geometryType(self) -> str: ...
    def lineStringN(self, index: int) -> QgsLineString: ...


class QgsMultiPoint(QgsGeometryCollection):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMultiPoint) -> None: ...

    def wktOmitChildType(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsMultiPoint: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def vertexNumberFromVertexId(self, id: QgsVertexId) -> int: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def insertGeometry(self, g: QgsAbstractGeometry, index: int) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry) -> bool: ...
    def nCoordinates(self) -> int: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def clear(self) -> None: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def toCurveType(self) -> QgsMultiPoint: ...
    def clone(self) -> QgsMultiPoint: ...
    def geometryType(self) -> str: ...
    def pointN(self, index: int) -> QgsPoint: ...


class QgsMultiSurface(QgsGeometryCollection):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMultiSurface) -> None: ...

    def createEmptyWithSameType(self) -> QgsMultiSurface: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def insertGeometry(self, g: QgsAbstractGeometry, index: int) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def toCurveType(self) -> QgsMultiSurface: ...
    def clone(self) -> QgsMultiSurface: ...
    def clear(self) -> None: ...
    def geometryType(self) -> str: ...
    def surfaceN(self, index: int) -> QgsSurface: ...


class QgsMultiPolygon(QgsMultiSurface):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMultiPolygon) -> None: ...

    def wktOmitChildType(self) -> bool: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsMultiPolygon: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def toCurveType(self) -> QgsMultiSurface: ...
    def insertGeometry(self, g: QgsAbstractGeometry, index: int) -> bool: ...
    def addGeometry(self, g: QgsAbstractGeometry) -> bool: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def clone(self) -> QgsMultiPolygon: ...
    def clear(self) -> None: ...
    def geometryType(self) -> str: ...
    def polygonN(self, index: int) -> QgsPolygon: ...


class QgsPoint(QgsAbstractGeometry):

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, x: Optional[Union[QgsPoint, QtCore.QPointF, QtCore.QPoint, float]] = ..., y: Optional[float] = ..., z: Optional[float] = ..., m: Optional[float] = ..., wkbType: Optional[int] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPoint) -> None: ...

    def childPoint(self, index: int) -> QgsPoint: ...
    def childCount(self) -> int: ...
    def compareToSameClass(self, other: QgsAbstractGeometry) -> int: ...
    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsPoint: ...
    def convertTo(self, type: QgsWkbTypes.Type) -> bool: ...
    def swapXy(self) -> None: ...
    def dropMValue(self) -> bool: ...
    def dropZValue(self) -> bool: ...
    def addMValue(self, mValue: float = ...) -> bool: ...
    def addZValue(self, zValue: float = ...) -> bool: ...
    def boundingBoxIntersects(self, rectangle: QgsRectangle) -> bool: ...
    def segmentLength(self, startVertex: QgsVertexId) -> float: ...
    def toCurveType(self) -> QgsPoint: ...
    def vertexAt(self, a0: QgsVertexId) -> QgsPoint: ...
    def partCount(self) -> int: ...
    def ringCount(self, a0: int = ...) -> int: ...
    def vertexCount(self, a0: int = ..., a1: int = ...) -> int: ...
    def vertexAngle(self, vertex: QgsVertexId) -> float: ...
    def adjacentVertices(self, vertex: QgsVertexId) -> Tuple[QgsVertexId, QgsVertexId]: ...
    def nextVertex(self, id: QgsVertexId) -> Tuple[bool, QgsPoint]: ...
    def closestSegment(self, pt: QgsPoint, epsilon: float = ...) -> Tuple[float, QgsPoint, QgsVertexId, int]: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def moveVertex(self, position: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def isValid(self, flags: int = ...) -> Tuple[bool, str]: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def vertexNumberFromVertexId(self, id: QgsVertexId) -> int: ...
    def nCoordinates(self) -> int: ...
    def coordinateSequence(self) -> typing.Any: ...
    @overload
    def transform(self, ct: QgsCoordinateTransform, d: QgsCoordinateTransform.TransformDirection = ..., transformZ: bool = ...) -> None: ...
    @overload
    def transform(self, t: QtGui.QTransform, zTranslate: float = ..., zScale: float = ..., mTranslate: float = ..., mScale: float = ...) -> None: ...
    @overload
    def transform(self, transformer: QgsAbstractGeometryTransformer, feedback: Optional[QgsFeedback] = ...) -> bool: ...
    def asQPainterPath(self) -> QtGui.QPainterPath: ...
    def draw(self, p: QtGui.QPainter) -> None: ...
    def asKml(self, precision: int = ...) -> str: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asGml2(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def asWkt(self, precision: int = ...) -> str: ...
    def asWkb(self, a0: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def clear(self) -> None: ...
    def removeDuplicateNodes(self, epsilon: float = ..., useZValues: bool = ...) -> bool: ...
    def snappedToGrid(self, hSpacing: float, vSpacing: float, dSpacing: float = ..., mSpacing: float = ...) -> QgsPoint: ...
    def clone(self) -> QgsPoint: ...
    def dimension(self) -> int: ...
    def geometryType(self) -> str: ...
    def boundingBox(self) -> QgsRectangle: ...
    def isEmpty(self) -> bool: ...
    def normalize(self) -> None: ...
    def project(self, distance: float, azimuth: float, inclination: float = ...) -> QgsPoint: ...
    def inclination(self, other: QgsPoint) -> float: ...
    def azimuth(self, other: QgsPoint) -> float: ...
    @overload
    def distanceSquared3D(self, x: float, y: float, z: float) -> float: ...
    @overload
    def distanceSquared3D(self, other: QgsPoint) -> float: ...
    @overload
    def distance3D(self, x: float, y: float, z: float) -> float: ...
    @overload
    def distance3D(self, other: QgsPoint) -> float: ...
    @overload
    def distanceSquared(self, x: float, y: float) -> float: ...
    @overload
    def distanceSquared(self, other: QgsPoint) -> float: ...
    @overload
    def distance(self, x: float, y: float) -> float: ...
    @overload
    def distance(self, other: QgsPoint) -> float: ...
    def toQPointF(self) -> QtCore.QPointF: ...
    def setM(self, m: float) -> None: ...
    def setZ(self, z: float) -> None: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def m(self) -> float: ...
    def z(self) -> float: ...
    def y(self) -> float: ...
    def x(self) -> float: ...


class QgsPolygon(QgsCurvePolygon):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, exterior: QgsLineString, rings: Iterable[QgsLineString] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPolygon) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def createEmptyWithSameType(self) -> QgsPolygon: ...
    def pointDistanceToBoundary(self, x: float, y: float) -> float: ...
    def boundary(self) -> QgsAbstractGeometry: ...
    def setExteriorRing(self, ring: QgsCurve) -> None: ...
    def addInteriorRing(self, ring: QgsCurve) -> None: ...
    def toCurveType(self) -> QgsCurvePolygon: ...
    def surfaceToPolygon(self) -> QgsPolygon: ...
    def asWkb(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> QtCore.QByteArray: ...
    def wkbSize(self, flags: Union[QgsAbstractGeometry.WkbFlags, QgsAbstractGeometry.WkbFlag] = ...) -> int: ...
    def fromWkb(self, wkb: QgsConstWkbPtr) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsPolygon: ...
    def geometryType(self) -> str: ...


class QgsQuadrilateral(sip.wrapper):

    class Point(int):
        ...
    Point1: QgsQuadrilateral.Point = ...
    Point2: QgsQuadrilateral.Point = ...
    Point3: QgsQuadrilateral.Point = ...
    Point4: QgsQuadrilateral.Point = ...

    class ConstructionOption(int):
        ...
    Distance: QgsQuadrilateral.ConstructionOption = ...
    Projected: QgsQuadrilateral.ConstructionOption = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, p4: QgsPoint) -> None: ...
    @overload
    def __init__(self, p1: QgsPointXY, p2: QgsPointXY, p3: QgsPointXY, p4: QgsPointXY) -> None: ...
    @overload
    def __init__(self, a0: QgsQuadrilateral) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def toString(self, pointPrecision: int = ...) -> str: ...
    def toLineString(self, force2D: bool = ...) -> QgsLineString: ...
    def toPolygon(self, force2D: bool = ...) -> QgsPolygon: ...
    def points(self) -> List[QgsPoint]: ...
    def setPoints(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, p4: QgsPoint) -> bool: ...
    def setPoint(self, newPoint: QgsPoint, index: QgsQuadrilateral.Point) -> bool: ...
    def isValid(self) -> bool: ...
    def equals(self, other: QgsQuadrilateral, epsilon: float = ...) -> bool: ...
    @staticmethod
    def fromRectangle(rectangle: QgsRectangle) -> QgsQuadrilateral: ...
    @staticmethod
    def rectangleFromCenterPoint(center: QgsPoint, point: QgsPoint) -> QgsQuadrilateral: ...
    @staticmethod
    def squareFromDiagonal(p1: QgsPoint, p2: QgsPoint) -> QgsQuadrilateral: ...
    @staticmethod
    def rectangleFromExtent(p1: QgsPoint, p2: QgsPoint) -> QgsQuadrilateral: ...
    @staticmethod
    def rectangleFrom3Points(p1: QgsPoint, p2: QgsPoint, p3: QgsPoint, mode: QgsQuadrilateral.ConstructionOption) -> QgsQuadrilateral: ...


class QgsRectangle(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, xMin: float, yMin: float = ..., xMax: float = ..., yMax: float = ..., normalize: bool = ...) -> None: ...
    @overload
    def __init__(self, p1: QgsPointXY, p2: QgsPointXY, normalize: bool = ...) -> None: ...
    @overload
    def __init__(self, qRectF: QtCore.QRectF) -> None: ...
    @overload
    def __init__(self, other: QgsRectangle) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def snappedToGrid(self, spacing: float) -> QgsRectangle: ...
    def toBox3d(self, zMin: float, zMax: float) -> QgsBox3d: ...
    def invert(self) -> None: ...
    def isFinite(self) -> bool: ...
    def asPolygon(self) -> str: ...
    def toString(self, precision: int = ...) -> str: ...
    def toRectF(self) -> QtCore.QRectF: ...
    def asWktPolygon(self) -> str: ...
    def asWktCoordinates(self) -> str: ...
    def isNull(self) -> bool: ...
    def isEmpty(self) -> bool: ...
    def distance(self, point: QgsPointXY) -> float: ...
    @overload
    def combineExtentWith(self, rect: QgsRectangle) -> None: ...
    @overload
    def combineExtentWith(self, x: float, y: float) -> None: ...
    @overload
    def combineExtentWith(self, point: QgsPointXY) -> None: ...
    @overload
    def contains(self, rect: QgsRectangle) -> bool: ...
    @overload
    def contains(self, p: QgsPointXY) -> bool: ...
    @overload
    def contains(self, x: float, y: float) -> bool: ...
    def intersects(self, rect: QgsRectangle) -> bool: ...
    def intersect(self, rect: QgsRectangle) -> QgsRectangle: ...
    def buffered(self, width: float) -> QgsRectangle: ...
    def include(self, p: QgsPointXY) -> None: ...
    def grow(self, delta: float) -> None: ...
    def scaled(self, scaleFactor: float, center: Optional[QgsPointXY] = ...) -> QgsRectangle: ...
    @overload
    def scale(self, scaleFactor: float, c: Optional[QgsPointXY] = ...) -> None: ...
    @overload
    def scale(self, scaleFactor: float, centerX: float, centerY: float) -> None: ...
    def center(self) -> QgsPointXY: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def height(self) -> float: ...
    def width(self) -> float: ...
    def normalize(self) -> None: ...
    def yMinimum(self) -> float: ...
    def yMaximum(self) -> float: ...
    def xMinimum(self) -> float: ...
    def xMaximum(self) -> float: ...
    def setMinimal(self) -> None: ...
    def setYMaximum(self, y: float) -> None: ...
    def setYMinimum(self, y: float) -> None: ...
    def setXMaximum(self, x: float) -> None: ...
    def setXMinimum(self, x: float) -> None: ...
    @overload
    def set(self, p1: QgsPointXY, p2: QgsPointXY, normalize: bool = ...) -> None: ...
    @overload
    def set(self, xMin: float, yMin: float, xMax: float, yMax: float, normalize: bool = ...) -> None: ...
    @staticmethod
    def fromCenterAndSize(center: QgsPointXY, width: float, height: float) -> QgsRectangle: ...
    @staticmethod
    def fromWkt(wkt: str) -> QgsRectangle: ...


class QgsReferencedGeometryBase(sip.wrapper):

    @overload
    def __init__(self, crs: QgsCoordinateReferenceSystem = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsReferencedGeometryBase) -> None: ...

    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...


class QgsReferencedRectangle(QgsRectangle, QgsReferencedGeometryBase):

    @overload
    def __init__(self, rectangle: QgsRectangle, crs: QgsCoordinateReferenceSystem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsReferencedRectangle) -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsReferencedPointXY(QgsPointXY, QgsReferencedGeometryBase):

    @overload
    def __init__(self, point: QgsPointXY, crs: QgsCoordinateReferenceSystem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsReferencedPointXY) -> None: ...

    def __repr__(self) -> typing.Any: ...


class QgsReferencedGeometry(QgsGeometry, QgsReferencedGeometryBase):

    @overload
    def __init__(self, geometry: QgsGeometry, crs: QgsCoordinateReferenceSystem) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsReferencedGeometry) -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def fromReferencedRect(rectangle: QgsReferencedRectangle) -> QgsReferencedGeometry: ...
    @staticmethod
    def fromReferencedPointXY(point: QgsReferencedPointXY) -> QgsReferencedGeometry: ...


class QgsRegularPolygon(sip.wrapper):

    class ConstructionOption(int):
        ...
    InscribedCircle: QgsRegularPolygon.ConstructionOption = ...
    CircumscribedCircle: QgsRegularPolygon.ConstructionOption = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, center: QgsPoint, radius: float, azimuth: float, numberSides: int, circle: QgsRegularPolygon.ConstructionOption) -> None: ...
    @overload
    def __init__(self, center: QgsPoint, pt1: QgsPoint, numberSides: int, circle: QgsRegularPolygon.ConstructionOption) -> None: ...
    @overload
    def __init__(self, pt1: QgsPoint, pt2: QgsPoint, numberSides: int) -> None: ...
    @overload
    def __init__(self, a0: QgsRegularPolygon) -> None: ...

    def length(self) -> float: ...
    def perimeter(self) -> float: ...
    def area(self) -> float: ...
    def centralAngle(self) -> float: ...
    def interiorAngle(self) -> float: ...
    def toString(self, pointPrecision: int = ..., radiusPrecision: int = ..., anglePrecision: int = ...) -> str: ...
    def circumscribedCircle(self) -> QgsCircle: ...
    def inscribedCircle(self) -> QgsCircle: ...
    def triangulate(self) -> List[QgsTriangle]: ...
    def toTriangle(self) -> QgsTriangle: ...
    def toLineString(self) -> QgsLineString: ...
    def toPolygon(self) -> QgsPolygon: ...
    def points(self) -> List[QgsPoint]: ...
    def setNumberSides(self, numberSides: int) -> None: ...
    def setFirstVertex(self, firstVertex: QgsPoint) -> None: ...
    def setRadius(self, radius: float) -> None: ...
    def setCenter(self, center: QgsPoint) -> None: ...
    def numberSides(self) -> int: ...
    def apothem(self) -> float: ...
    def firstVertex(self) -> QgsPoint: ...
    def radius(self) -> float: ...
    def center(self) -> QgsPoint: ...
    def isEmpty(self) -> bool: ...


class QgsTriangle(QgsPolygon):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, p1: QgsPoint, p2: QgsPoint, p3: QgsPoint) -> None: ...
    @overload
    def __init__(self, p1: QgsPointXY, p2: QgsPointXY, p3: QgsPointXY) -> None: ...
    @overload
    def __init__(self, p1: Union[QtCore.QPointF, QtCore.QPoint, float], p2: Union[QtCore.QPointF, QtCore.QPoint, float], p3: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    @overload
    def __init__(self, a0: QgsTriangle) -> None: ...

    def createEmptyWithSameType(self) -> QgsTriangle: ...
    def inscribedCircle(self) -> QgsCircle: ...
    def inscribedRadius(self) -> float: ...
    def inscribedCenter(self) -> QgsPoint: ...
    def circumscribedCircle(self) -> QgsCircle: ...
    def circumscribedRadius(self) -> float: ...
    def circumscribedCenter(self) -> QgsPoint: ...
    def orthocenter(self, lengthTolerance: float = ...) -> QgsPoint: ...
    def medial(self) -> QgsTriangle: ...
    def bisectors(self, lengthTolerance: float = ...) -> List[QgsLineString]: ...
    def medians(self) -> List[QgsLineString]: ...
    def altitudes(self) -> List[QgsLineString]: ...
    def isScalene(self, lengthTolerance: float = ...) -> bool: ...
    def isRight(self, angleTolerance: float = ...) -> bool: ...
    def isEquilateral(self, lengthTolerance: float = ...) -> bool: ...
    def isIsocele(self, lengthTolerance: float = ...) -> bool: ...
    def isDegenerate(self) -> bool: ...
    def angles(self) -> List[float]: ...
    def lengths(self) -> List[float]: ...
    def vertexAt(self, atVertex: int) -> QgsPoint: ...
    def boundary(self) -> QgsCurve: ...
    def setExteriorRing(self, ring: QgsCurve) -> None: ...
    def moveVertex(self, vId: QgsVertexId, newPos: QgsPoint) -> bool: ...
    def insertVertex(self, position: QgsVertexId, vertex: QgsPoint) -> bool: ...
    def deleteVertex(self, position: QgsVertexId) -> bool: ...
    def addInteriorRing(self, ring: QgsCurve) -> None: ...
    def toCurveType(self) -> QgsCurvePolygon: ...
    def surfaceToPolygon(self) -> QgsPolygon: ...
    def asGml3(self, doc: QtXml.QDomDocument, precision: int = ..., ns: str = ..., axisOrder: QgsAbstractGeometry.AxisOrder = ...) -> QtXml.QDomElement: ...
    def fromWkt(self, wkt: str) -> bool: ...
    def fromWkb(self, wkbPtr: QgsConstWkbPtr) -> bool: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsTriangle: ...
    def geometryType(self) -> str: ...


class QgsWkbPtr(sip.wrapper):

    @overload
    def __init__(self, p: bytes) -> None: ...
    @overload
    def __init__(self, a0: QgsWkbPtr) -> None: ...


class QgsConstWkbPtr(sip.wrapper):

    @overload
    def __init__(self, p: bytes) -> None: ...
    @overload
    def __init__(self, a0: QgsConstWkbPtr) -> None: ...


class QgsWkbTypes(sip.wrapper):

    class GeometryType(int):
        ...
    PointGeometry: QgsWkbTypes.GeometryType = ...
    LineGeometry: QgsWkbTypes.GeometryType = ...
    PolygonGeometry: QgsWkbTypes.GeometryType = ...
    UnknownGeometry: QgsWkbTypes.GeometryType = ...
    NullGeometry: QgsWkbTypes.GeometryType = ...

    class Type(int):
        ...
    Unknown: QgsWkbTypes.Type = ...
    Point: QgsWkbTypes.Type = ...
    LineString: QgsWkbTypes.Type = ...
    Polygon: QgsWkbTypes.Type = ...
    Triangle: QgsWkbTypes.Type = ...
    MultiPoint: QgsWkbTypes.Type = ...
    MultiLineString: QgsWkbTypes.Type = ...
    MultiPolygon: QgsWkbTypes.Type = ...
    GeometryCollection: QgsWkbTypes.Type = ...
    CircularString: QgsWkbTypes.Type = ...
    CompoundCurve: QgsWkbTypes.Type = ...
    CurvePolygon: QgsWkbTypes.Type = ...
    MultiCurve: QgsWkbTypes.Type = ...
    MultiSurface: QgsWkbTypes.Type = ...
    NoGeometry: QgsWkbTypes.Type = ...
    PointZ: QgsWkbTypes.Type = ...
    LineStringZ: QgsWkbTypes.Type = ...
    PolygonZ: QgsWkbTypes.Type = ...
    TriangleZ: QgsWkbTypes.Type = ...
    MultiPointZ: QgsWkbTypes.Type = ...
    MultiLineStringZ: QgsWkbTypes.Type = ...
    MultiPolygonZ: QgsWkbTypes.Type = ...
    GeometryCollectionZ: QgsWkbTypes.Type = ...
    CircularStringZ: QgsWkbTypes.Type = ...
    CompoundCurveZ: QgsWkbTypes.Type = ...
    CurvePolygonZ: QgsWkbTypes.Type = ...
    MultiCurveZ: QgsWkbTypes.Type = ...
    MultiSurfaceZ: QgsWkbTypes.Type = ...
    PointM: QgsWkbTypes.Type = ...
    LineStringM: QgsWkbTypes.Type = ...
    PolygonM: QgsWkbTypes.Type = ...
    TriangleM: QgsWkbTypes.Type = ...
    MultiPointM: QgsWkbTypes.Type = ...
    MultiLineStringM: QgsWkbTypes.Type = ...
    MultiPolygonM: QgsWkbTypes.Type = ...
    GeometryCollectionM: QgsWkbTypes.Type = ...
    CircularStringM: QgsWkbTypes.Type = ...
    CompoundCurveM: QgsWkbTypes.Type = ...
    CurvePolygonM: QgsWkbTypes.Type = ...
    MultiCurveM: QgsWkbTypes.Type = ...
    MultiSurfaceM: QgsWkbTypes.Type = ...
    PointZM: QgsWkbTypes.Type = ...
    LineStringZM: QgsWkbTypes.Type = ...
    PolygonZM: QgsWkbTypes.Type = ...
    MultiPointZM: QgsWkbTypes.Type = ...
    MultiLineStringZM: QgsWkbTypes.Type = ...
    MultiPolygonZM: QgsWkbTypes.Type = ...
    GeometryCollectionZM: QgsWkbTypes.Type = ...
    CircularStringZM: QgsWkbTypes.Type = ...
    CompoundCurveZM: QgsWkbTypes.Type = ...
    CurvePolygonZM: QgsWkbTypes.Type = ...
    MultiCurveZM: QgsWkbTypes.Type = ...
    MultiSurfaceZM: QgsWkbTypes.Type = ...
    TriangleZM: QgsWkbTypes.Type = ...
    Point25D: QgsWkbTypes.Type = ...
    LineString25D: QgsWkbTypes.Type = ...
    Polygon25D: QgsWkbTypes.Type = ...
    MultiPoint25D: QgsWkbTypes.Type = ...
    MultiLineString25D: QgsWkbTypes.Type = ...
    MultiPolygon25D: QgsWkbTypes.Type = ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsWkbTypes) -> None: ...

    @staticmethod
    def to25D(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def dropM(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def dropZ(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def addM(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def addZ(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def hasM(type: QgsWkbTypes.Type) -> bool: ...
    @staticmethod
    def hasZ(type: QgsWkbTypes.Type) -> bool: ...
    @staticmethod
    def geometryDisplayString(type: QgsWkbTypes.GeometryType) -> str: ...
    @staticmethod
    def translatedDisplayString(type: QgsWkbTypes.Type) -> str: ...
    @staticmethod
    def displayString(type: QgsWkbTypes.Type) -> str: ...
    @staticmethod
    def geometryType(type: QgsWkbTypes.Type) -> QgsWkbTypes.GeometryType: ...
    @staticmethod
    def coordDimensions(type: QgsWkbTypes.Type) -> int: ...
    @staticmethod
    def wkbDimensions(type: QgsWkbTypes.Type) -> int: ...
    @staticmethod
    def isCurvedType(type: QgsWkbTypes.Type) -> bool: ...
    @staticmethod
    def isMultiType(type: QgsWkbTypes.Type) -> bool: ...
    @staticmethod
    def isSingleType(type: QgsWkbTypes.Type) -> bool: ...
    @staticmethod
    def parseType(wktStr: str) -> QgsWkbTypes.Type: ...
    @staticmethod
    def zmType(type: QgsWkbTypes.Type, hasZ: bool, hasM: bool) -> QgsWkbTypes.Type: ...
    @staticmethod
    def flatType(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def linearType(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def curveType(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def multiType(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    @staticmethod
    def singleType(type: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...


class QgsRay3D(sip.wrapper):

    @overload
    def __init__(self, origin: QtGui.QVector3D, direction: QtGui.QVector3D) -> None: ...
    @overload
    def __init__(self, a0: QgsRay3D) -> None: ...

    def angleToPoint(self, point: QtGui.QVector3D) -> float: ...
    def isInFront(self, point: QtGui.QVector3D) -> bool: ...
    def projectedPoint(self, point: QtGui.QVector3D) -> QtGui.QVector3D: ...
    def setDirection(self, direction: QtGui.QVector3D) -> None: ...
    def setOrigin(self, origin: QtGui.QVector3D) -> None: ...
    def direction(self) -> QtGui.QVector3D: ...
    def origin(self) -> QtGui.QVector3D: ...


class QgsSatelliteInfo(sip.wrapper):

    azimuth: float = ...
    elevation: float = ...
    id: int = ...
    inUse: bool = ...
    signal: int = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsSatelliteInfo) -> None: ...


class QgsGpsInformation(sip.wrapper):

    class FixStatus(int):
        ...
    NoData: QgsGpsInformation.FixStatus = ...
    NoFix: QgsGpsInformation.FixStatus = ...
    Fix2D: QgsGpsInformation.FixStatus = ...
    Fix3D: QgsGpsInformation.FixStatus = ...

    direction: float = ...
    elevation: float = ...
    elevation_diff: float = ...
    fixMode: str = ...
    fixType: int = ...
    hacc: float = ...
    hdop: float = ...
    hvacc: float = ...
    latitude: float = ...
    longitude: float = ...
    pdop: float = ...
    quality: int = ...
    satInfoComplete: bool = ...
    satPrn: Iterable[int] = ...
    satellitesInView: Iterable[QgsSatelliteInfo] = ...
    satellitesUsed: int = ...
    speed: float = ...
    status: str = ...
    utcDateTime: Union[QtCore.QDateTime, datetime.datetime] = ...
    vacc: float = ...
    vdop: float = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGpsInformation) -> None: ...

    def qualityDescription(self) -> str: ...
    def fixStatus(self) -> QgsGpsInformation.FixStatus: ...
    def isValid(self) -> bool: ...


class QgsGpsConnection(QtCore.QObject):

    class Status(int):
        ...
    NotConnected: QgsGpsConnection.Status = ...
    Connected: QgsGpsConnection.Status = ...
    DataReceived: QgsGpsConnection.Status = ...
    GPSDataReceived: QgsGpsConnection.Status = ...

    def __init__(self, dev: QtCore.QIODevice) -> None: ...

    def parseData(self) -> None: ...
    def nmeaSentenceReceived(self, substring: str) -> None: ...
    def stateChanged(self, info: QgsGpsInformation) -> None: ...
    def currentGPSInformation(self) -> QgsGpsInformation: ...
    def status(self) -> QgsGpsConnection.Status: ...
    def setSource(self, source: QtCore.QIODevice) -> None: ...
    def close(self) -> bool: ...
    def connect(self) -> bool: ...


class QgsNmeaConnection(QgsGpsConnection):

    def __init__(self, device: QtCore.QIODevice) -> None: ...

    def processHchdtSentence(self, data: str, len: int) -> None: ...
    def processHchdgSentence(self, data: str, len: int) -> None: ...
    def processHdtSentence(self, data: str, len: int) -> None: ...
    def processGstSentence(self, data: str, len: int) -> None: ...
    def processGsaSentence(self, data: str, len: int) -> None: ...
    def processVtgSentence(self, data: str, len: int) -> None: ...
    def processGsvSentence(self, data: str, len: int) -> None: ...
    def processRmcSentence(self, data: str, len: int) -> None: ...
    def processGgaSentence(self, data: str, len: int) -> None: ...
    def processStringBuffer(self) -> None: ...
    def parseData(self) -> None: ...


class QgsGpsdConnection(QgsNmeaConnection):

    def __init__(self, host: str, port: int, device: str) -> None: ...


class QgsGpsDetector(QtCore.QObject):

    def __init__(self, portName: str) -> None: ...

    def detectionFailed(self) -> None: ...
    def connDestroyed(self, a0: QtCore.QObject) -> None: ...
    @overload
    def detected(self, a0: QgsGpsInformation) -> None: ...
    @overload
    def detected(self, connection: QgsGpsConnection) -> None: ...
    def advance(self) -> None: ...
    @staticmethod
    def availablePorts() -> List[Tuple[str, str]]: ...


class QgsCalloutPosition(sip.wrapper):

    featureId: int = ...
    layerID: str = ...
    providerID: str = ...

    @overload
    def __init__(self, id: int, layer: str, providerId: str = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCalloutPosition) -> None: ...

    def setDestinationIsPinned(self, pinned: bool) -> None: ...
    def destinationIsPinned(self) -> bool: ...
    def setOriginIsPinned(self, pinned: bool) -> None: ...
    def originIsPinned(self) -> bool: ...
    def setDestination(self, destination: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def destination(self) -> QtCore.QPointF: ...
    def setOrigin(self, origin: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def origin(self) -> QtCore.QPointF: ...


class QgsLabeling(sip.wrapper):

    class PolygonPlacementFlag(int):
        ...
    AllowPlacementOutsideOfPolygon: QgsLabeling.PolygonPlacementFlag = ...
    AllowPlacementInsideOfPolygon: QgsLabeling.PolygonPlacementFlag = ...

    class LinePlacementFlag(int):
        ...
    OnLine: QgsLabeling.LinePlacementFlag = ...
    AboveLine: QgsLabeling.LinePlacementFlag = ...
    BelowLine: QgsLabeling.LinePlacementFlag = ...
    MapOrientation: QgsLabeling.LinePlacementFlag = ...

    class LinePlacementFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLabeling.LinePlacementFlags, QgsLabeling.LinePlacementFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLabeling.LinePlacementFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLabeling.LinePlacementFlags: ...
        def __int__(self) -> int: ...

    class PolygonPlacementFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLabeling.PolygonPlacementFlags, QgsLabeling.PolygonPlacementFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLabeling.PolygonPlacementFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLabeling.PolygonPlacementFlags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLabeling) -> None: ...


class QgsLabelingEngineSettings(sip.wrapper):

    class PlacementEngineVersion(int):
        ...
    PlacementEngineVersion1: QgsLabelingEngineSettings.PlacementEngineVersion = ...
    PlacementEngineVersion2: QgsLabelingEngineSettings.PlacementEngineVersion = ...

    class Search(int):
        ...
    Chain: QgsLabelingEngineSettings.Search = ...
    Popmusic_Tabu: QgsLabelingEngineSettings.Search = ...
    Popmusic_Chain: QgsLabelingEngineSettings.Search = ...
    Popmusic_Tabu_Chain: QgsLabelingEngineSettings.Search = ...
    Falp: QgsLabelingEngineSettings.Search = ...

    class Flag(int):
        ...
    UseAllLabels: QgsLabelingEngineSettings.Flag = ...
    UsePartialCandidates: QgsLabelingEngineSettings.Flag = ...
    RenderOutlineLabels: QgsLabelingEngineSettings.Flag = ...
    DrawLabelRectOnly: QgsLabelingEngineSettings.Flag = ...
    DrawCandidates: QgsLabelingEngineSettings.Flag = ...
    DrawUnplacedLabels: QgsLabelingEngineSettings.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLabelingEngineSettings.Flags, QgsLabelingEngineSettings.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLabelingEngineSettings.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLabelingEngineSettings.Flags: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelingEngineSettings) -> None: ...

    def setPlacementVersion(self, version: QgsLabelingEngineSettings.PlacementEngineVersion) -> None: ...
    def placementVersion(self) -> QgsLabelingEngineSettings.PlacementEngineVersion: ...
    def setUnplacedLabelColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def unplacedLabelColor(self) -> QtGui.QColor: ...
    def setDefaultTextRenderFormat(self, format: QgsRenderContext.TextRenderFormat) -> None: ...
    def defaultTextRenderFormat(self) -> QgsRenderContext.TextRenderFormat: ...
    def writeSettingsToProject(self, project: QgsProject) -> None: ...
    def readSettingsFromProject(self, project: QgsProject) -> None: ...
    def searchMethod(self) -> QgsLabelingEngineSettings.Search: ...
    def setSearchMethod(self, s: QgsLabelingEngineSettings.Search) -> None: ...
    def setNumCandidatePositions(self, candPoint: int, candLine: int, candPolygon: int) -> None: ...
    def numCandidatePositions(self) -> Tuple[int, int, int]: ...
    def setMaximumPolygonCandidatesPerCmSquared(self, candidates: float) -> None: ...
    def maximumPolygonCandidatesPerCmSquared(self) -> float: ...
    def setMaximumLineCandidatesPerCm(self, candidates: float) -> None: ...
    def maximumLineCandidatesPerCm(self) -> float: ...
    def setFlag(self, f: QgsLabelingEngineSettings.Flag, enabled: bool = ...) -> None: ...
    def testFlag(self, f: QgsLabelingEngineSettings.Flag) -> bool: ...
    def flags(self) -> QgsLabelingEngineSettings.Flags: ...
    def setFlags(self, flags: Union[QgsLabelingEngineSettings.Flags, QgsLabelingEngineSettings.Flag]) -> None: ...
    def clear(self) -> None: ...


class QgsLabelingResults(sip.wrapper):

    def __init__(self) -> None: ...

    def setMapSettings(self, settings: QgsMapSettings) -> None: ...
    def calloutsWithinRectangle(self, rectangle: QgsRectangle) -> List[QgsCalloutPosition]: ...
    def labelsWithinRect(self, r: QgsRectangle) -> List[QgsLabelPosition]: ...
    def labelsAtPosition(self, p: QgsPointXY) -> List[QgsLabelPosition]: ...


class QgsLabelLineSettings(sip.wrapper):

    class AnchorClipping(int):
        ...
    UseVisiblePartsOfLine: QgsLabelLineSettings.AnchorClipping = ...
    UseEntireLine: QgsLabelLineSettings.AnchorClipping = ...

    class AnchorType(int):
        ...
    HintOnly: QgsLabelLineSettings.AnchorType = ...
    Strict: QgsLabelLineSettings.AnchorType = ...

    class DirectionSymbolPlacement(int):
        ...
    SymbolLeftRight: QgsLabelLineSettings.DirectionSymbolPlacement = ...
    SymbolAbove: QgsLabelLineSettings.DirectionSymbolPlacement = ...
    SymbolBelow: QgsLabelLineSettings.DirectionSymbolPlacement = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelLineSettings) -> None: ...

    def setAnchorClipping(self, clipping: QgsLabelLineSettings.AnchorClipping) -> None: ...
    def anchorClipping(self) -> QgsLabelLineSettings.AnchorClipping: ...
    def setAnchorType(self, type: QgsLabelLineSettings.AnchorType) -> None: ...
    def anchorType(self) -> QgsLabelLineSettings.AnchorType: ...
    def setLineAnchorPercent(self, percent: float) -> None: ...
    def lineAnchorPercent(self) -> float: ...
    def setOverrunDistanceMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def overrunDistanceMapUnitScale(self) -> QgsMapUnitScale: ...
    def setOverrunDistanceUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def overrunDistanceUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setOverrunDistance(self, distance: float) -> None: ...
    def overrunDistance(self) -> float: ...
    def setDirectionSymbolPlacement(self, placement: QgsLabelLineSettings.DirectionSymbolPlacement) -> None: ...
    def directionSymbolPlacement(self) -> QgsLabelLineSettings.DirectionSymbolPlacement: ...
    def setReverseDirectionSymbol(self, reversed: bool) -> None: ...
    def reverseDirectionSymbol(self) -> bool: ...
    def setRightDirectionSymbol(self, symbol: str) -> None: ...
    def rightDirectionSymbol(self) -> str: ...
    def setLeftDirectionSymbol(self, symbol: str) -> None: ...
    def leftDirectionSymbol(self) -> str: ...
    def setAddDirectionSymbol(self, enabled: bool) -> None: ...
    def addDirectionSymbol(self) -> bool: ...
    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def setMergeLines(self, merge: bool) -> None: ...
    def mergeLines(self) -> bool: ...
    def setPlacementFlags(self, flags: Union[QgsLabeling.LinePlacementFlags, QgsLabeling.LinePlacementFlag]) -> None: ...
    def placementFlags(self) -> QgsLabeling.LinePlacementFlags: ...


class QgsLabelObstacleSettings(sip.wrapper):

    class ObstacleType(int):
        ...
    PolygonInterior: QgsLabelObstacleSettings.ObstacleType = ...
    PolygonBoundary: QgsLabelObstacleSettings.ObstacleType = ...
    PolygonWhole: QgsLabelObstacleSettings.ObstacleType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelObstacleSettings) -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def obstacleGeometry(self) -> QgsGeometry: ...
    def setObstacleGeometry(self, obstacleGeom: QgsGeometry) -> None: ...
    def setType(self, type: QgsLabelObstacleSettings.ObstacleType) -> None: ...
    def type(self) -> QgsLabelObstacleSettings.ObstacleType: ...
    def setFactor(self, factor: float) -> None: ...
    def factor(self) -> float: ...
    def setIsObstacle(self, isObstacle: bool) -> None: ...
    def isObstacle(self) -> bool: ...


class QgsLabelPosition(sip.wrapper):

    cornerPoints: Iterable[QgsPointXY] = ...
    featureId: int = ...
    height: float = ...
    isDiagram: bool = ...
    isPinned: bool = ...
    isUnplaced: bool = ...
    labelFont: QtGui.QFont = ...
    labelGeometry: QgsGeometry = ...
    labelRect: QgsRectangle = ...
    labelText: str = ...
    layerID: str = ...
    providerID: str = ...
    rotation: float = ...
    upsideDown: bool = ...
    width: float = ...

    @overload
    def __init__(self, id: int, r: float, corners: Iterable[QgsPointXY], rect: QgsRectangle, w: float, h: float, layer: str, labeltext: str, labelfont: QtGui.QFont, upside_down: bool, diagram: bool = ..., pinned: bool = ..., providerId: str = ..., labelGeometry: QgsGeometry = ..., isUnplaced: bool = ...) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelPosition) -> None: ...


class QgsLabelSearchTree(sip.wrapper):

    def __init__(self) -> None: ...

    def setMapSettings(self, settings: QgsMapSettings) -> None: ...
    def calloutsInRectangle(self, rectangle: QgsRectangle) -> List[QgsCalloutPosition]: ...
    def clear(self) -> None: ...


class QgsLabelThinningSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelThinningSettings) -> None: ...

    def updateDataDefinedProperties(self, properties: QgsPropertyCollection, context: QgsExpressionContext) -> None: ...
    def setMinimumFeatureSize(self, size: float) -> None: ...
    def minimumFeatureSize(self) -> float: ...
    def setMaximumNumberLabels(self, number: int) -> None: ...
    def maximumNumberLabels(self) -> int: ...
    def setLimitNumberLabelsEnabled(self, enabled: bool) -> None: ...
    def limitNumberOfLabelsEnabled(self) -> bool: ...


class QgsPalLayerSettings(sip.wrapper):

    class Property(int):
        ...
    Size: QgsPalLayerSettings.Property = ...
    Bold: QgsPalLayerSettings.Property = ...
    Italic: QgsPalLayerSettings.Property = ...
    Underline: QgsPalLayerSettings.Property = ...
    Color: QgsPalLayerSettings.Property = ...
    Strikeout: QgsPalLayerSettings.Property = ...
    Family: QgsPalLayerSettings.Property = ...
    FontStyle: QgsPalLayerSettings.Property = ...
    FontSizeUnit: QgsPalLayerSettings.Property = ...
    FontTransp: QgsPalLayerSettings.Property = ...
    FontOpacity: QgsPalLayerSettings.Property = ...
    FontCase: QgsPalLayerSettings.Property = ...
    FontLetterSpacing: QgsPalLayerSettings.Property = ...
    FontWordSpacing: QgsPalLayerSettings.Property = ...
    FontBlendMode: QgsPalLayerSettings.Property = ...
    MultiLineWrapChar: QgsPalLayerSettings.Property = ...
    AutoWrapLength: QgsPalLayerSettings.Property = ...
    MultiLineHeight: QgsPalLayerSettings.Property = ...
    MultiLineAlignment: QgsPalLayerSettings.Property = ...
    TextOrientation: QgsPalLayerSettings.Property = ...
    DirSymbDraw: QgsPalLayerSettings.Property = ...
    DirSymbLeft: QgsPalLayerSettings.Property = ...
    DirSymbRight: QgsPalLayerSettings.Property = ...
    DirSymbPlacement: QgsPalLayerSettings.Property = ...
    DirSymbReverse: QgsPalLayerSettings.Property = ...
    NumFormat: QgsPalLayerSettings.Property = ...
    NumDecimals: QgsPalLayerSettings.Property = ...
    NumPlusSign: QgsPalLayerSettings.Property = ...
    BufferDraw: QgsPalLayerSettings.Property = ...
    BufferSize: QgsPalLayerSettings.Property = ...
    BufferUnit: QgsPalLayerSettings.Property = ...
    BufferColor: QgsPalLayerSettings.Property = ...
    BufferTransp: QgsPalLayerSettings.Property = ...
    BufferOpacity: QgsPalLayerSettings.Property = ...
    BufferJoinStyle: QgsPalLayerSettings.Property = ...
    BufferBlendMode: QgsPalLayerSettings.Property = ...
    MaskEnabled: QgsPalLayerSettings.Property = ...
    MaskBufferSize: QgsPalLayerSettings.Property = ...
    MaskBufferUnit: QgsPalLayerSettings.Property = ...
    MaskOpacity: QgsPalLayerSettings.Property = ...
    MaskJoinStyle: QgsPalLayerSettings.Property = ...
    ShapeDraw: QgsPalLayerSettings.Property = ...
    ShapeKind: QgsPalLayerSettings.Property = ...
    ShapeSVGFile: QgsPalLayerSettings.Property = ...
    ShapeSizeType: QgsPalLayerSettings.Property = ...
    ShapeSizeX: QgsPalLayerSettings.Property = ...
    ShapeSizeY: QgsPalLayerSettings.Property = ...
    ShapeSizeUnits: QgsPalLayerSettings.Property = ...
    ShapeRotationType: QgsPalLayerSettings.Property = ...
    ShapeRotation: QgsPalLayerSettings.Property = ...
    ShapeOffset: QgsPalLayerSettings.Property = ...
    ShapeOffsetUnits: QgsPalLayerSettings.Property = ...
    ShapeRadii: QgsPalLayerSettings.Property = ...
    ShapeRadiiUnits: QgsPalLayerSettings.Property = ...
    ShapeTransparency: QgsPalLayerSettings.Property = ...
    ShapeOpacity: QgsPalLayerSettings.Property = ...
    ShapeBlendMode: QgsPalLayerSettings.Property = ...
    ShapeFillColor: QgsPalLayerSettings.Property = ...
    ShapeStrokeColor: QgsPalLayerSettings.Property = ...
    ShapeStrokeWidth: QgsPalLayerSettings.Property = ...
    ShapeStrokeWidthUnits: QgsPalLayerSettings.Property = ...
    ShapeJoinStyle: QgsPalLayerSettings.Property = ...
    ShadowDraw: QgsPalLayerSettings.Property = ...
    ShadowUnder: QgsPalLayerSettings.Property = ...
    ShadowOffsetAngle: QgsPalLayerSettings.Property = ...
    ShadowOffsetDist: QgsPalLayerSettings.Property = ...
    ShadowOffsetUnits: QgsPalLayerSettings.Property = ...
    ShadowRadius: QgsPalLayerSettings.Property = ...
    ShadowRadiusUnits: QgsPalLayerSettings.Property = ...
    ShadowTransparency: QgsPalLayerSettings.Property = ...
    ShadowOpacity: QgsPalLayerSettings.Property = ...
    ShadowScale: QgsPalLayerSettings.Property = ...
    ShadowColor: QgsPalLayerSettings.Property = ...
    ShadowBlendMode: QgsPalLayerSettings.Property = ...
    CentroidWhole: QgsPalLayerSettings.Property = ...
    OffsetQuad: QgsPalLayerSettings.Property = ...
    OffsetXY: QgsPalLayerSettings.Property = ...
    OffsetUnits: QgsPalLayerSettings.Property = ...
    LabelDistance: QgsPalLayerSettings.Property = ...
    DistanceUnits: QgsPalLayerSettings.Property = ...
    OffsetRotation: QgsPalLayerSettings.Property = ...
    CurvedCharAngleInOut: QgsPalLayerSettings.Property = ...
    PositionX: QgsPalLayerSettings.Property = ...
    PositionY: QgsPalLayerSettings.Property = ...
    Hali: QgsPalLayerSettings.Property = ...
    Vali: QgsPalLayerSettings.Property = ...
    Rotation: QgsPalLayerSettings.Property = ...
    LabelRotation: QgsPalLayerSettings.Property = ...
    RepeatDistance: QgsPalLayerSettings.Property = ...
    RepeatDistanceUnit: QgsPalLayerSettings.Property = ...
    Priority: QgsPalLayerSettings.Property = ...
    PredefinedPositionOrder: QgsPalLayerSettings.Property = ...
    LinePlacementOptions: QgsPalLayerSettings.Property = ...
    OverrunDistance: QgsPalLayerSettings.Property = ...
    LabelAllParts: QgsPalLayerSettings.Property = ...
    PolygonLabelOutside: QgsPalLayerSettings.Property = ...
    LineAnchorPercent: QgsPalLayerSettings.Property = ...
    LineAnchorClipping: QgsPalLayerSettings.Property = ...
    ScaleVisibility: QgsPalLayerSettings.Property = ...
    MinScale: QgsPalLayerSettings.Property = ...
    MinimumScale: QgsPalLayerSettings.Property = ...
    MaxScale: QgsPalLayerSettings.Property = ...
    MaximumScale: QgsPalLayerSettings.Property = ...
    FontLimitPixel: QgsPalLayerSettings.Property = ...
    FontMinPixel: QgsPalLayerSettings.Property = ...
    FontMaxPixel: QgsPalLayerSettings.Property = ...
    IsObstacle: QgsPalLayerSettings.Property = ...
    ObstacleFactor: QgsPalLayerSettings.Property = ...
    ZIndex: QgsPalLayerSettings.Property = ...
    CalloutDraw: QgsPalLayerSettings.Property = ...
    Show: QgsPalLayerSettings.Property = ...
    AlwaysShow: QgsPalLayerSettings.Property = ...

    class ObstacleType(int):
        ...
    PolygonInterior: QgsPalLayerSettings.ObstacleType = ...
    PolygonBoundary: QgsPalLayerSettings.ObstacleType = ...
    PolygonWhole: QgsPalLayerSettings.ObstacleType = ...

    class MultiLineAlign(int):
        ...
    MultiLeft: QgsPalLayerSettings.MultiLineAlign = ...
    MultiCenter: QgsPalLayerSettings.MultiLineAlign = ...
    MultiRight: QgsPalLayerSettings.MultiLineAlign = ...
    MultiFollowPlacement: QgsPalLayerSettings.MultiLineAlign = ...
    MultiJustify: QgsPalLayerSettings.MultiLineAlign = ...

    class DirectionSymbols(int):
        ...
    SymbolLeftRight: QgsPalLayerSettings.DirectionSymbols = ...
    SymbolAbove: QgsPalLayerSettings.DirectionSymbols = ...
    SymbolBelow: QgsPalLayerSettings.DirectionSymbols = ...

    class UpsideDownLabels(int):
        ...
    Upright: QgsPalLayerSettings.UpsideDownLabels = ...
    ShowDefined: QgsPalLayerSettings.UpsideDownLabels = ...
    ShowAll: QgsPalLayerSettings.UpsideDownLabels = ...

    class QuadrantPosition(int):
        ...
    QuadrantAboveLeft: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantAbove: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantAboveRight: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantLeft: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantOver: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantRight: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantBelowLeft: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantBelow: QgsPalLayerSettings.QuadrantPosition = ...
    QuadrantBelowRight: QgsPalLayerSettings.QuadrantPosition = ...

    class LinePlacementFlags(int):
        ...
    OnLine: QgsPalLayerSettings.LinePlacementFlags = ...
    AboveLine: QgsPalLayerSettings.LinePlacementFlags = ...
    BelowLine: QgsPalLayerSettings.LinePlacementFlags = ...
    MapOrientation: QgsPalLayerSettings.LinePlacementFlags = ...

    class OffsetType(int):
        ...
    FromPoint: QgsPalLayerSettings.OffsetType = ...
    FromSymbolBounds: QgsPalLayerSettings.OffsetType = ...

    class PredefinedPointPosition(int):
        ...
    TopLeft: QgsPalLayerSettings.PredefinedPointPosition = ...
    TopSlightlyLeft: QgsPalLayerSettings.PredefinedPointPosition = ...
    TopMiddle: QgsPalLayerSettings.PredefinedPointPosition = ...
    TopSlightlyRight: QgsPalLayerSettings.PredefinedPointPosition = ...
    TopRight: QgsPalLayerSettings.PredefinedPointPosition = ...
    MiddleLeft: QgsPalLayerSettings.PredefinedPointPosition = ...
    MiddleRight: QgsPalLayerSettings.PredefinedPointPosition = ...
    BottomLeft: QgsPalLayerSettings.PredefinedPointPosition = ...
    BottomSlightlyLeft: QgsPalLayerSettings.PredefinedPointPosition = ...
    BottomMiddle: QgsPalLayerSettings.PredefinedPointPosition = ...
    BottomSlightlyRight: QgsPalLayerSettings.PredefinedPointPosition = ...
    BottomRight: QgsPalLayerSettings.PredefinedPointPosition = ...

    class Placement(int):
        ...
    AroundPoint: QgsPalLayerSettings.Placement = ...
    OverPoint: QgsPalLayerSettings.Placement = ...
    Line: QgsPalLayerSettings.Placement = ...
    Curved: QgsPalLayerSettings.Placement = ...
    Horizontal: QgsPalLayerSettings.Placement = ...
    Free: QgsPalLayerSettings.Placement = ...
    OrderedPositionsAroundPoint: QgsPalLayerSettings.Placement = ...
    PerimeterCurved: QgsPalLayerSettings.Placement = ...
    OutsidePolygons: QgsPalLayerSettings.Placement = ...

    angleOffset: float = ...
    autoWrapLength: int = ...
    centroidInside: bool = ...
    centroidWhole: bool = ...
    ct: QgsCoordinateTransform = ...
    decimals: int = ...
    displayAll: bool = ...
    dist: float = ...
    distMapUnitScale: QgsMapUnitScale = ...
    distUnits: QgsUnitTypes.RenderUnit = ...
    drawLabels: bool = ...
    extentGeom: QgsGeometry = ...
    fieldIndex: int = ...
    fieldName: str = ...
    fitInPolygonOnly: bool = ...
    fontLimitPixelSize: bool = ...
    fontMaxPixelSize: int = ...
    fontMinPixelSize: int = ...
    formatNumbers: bool = ...
    geometryGenerator: str = ...
    geometryGeneratorEnabled: bool = ...
    geometryGeneratorType: QgsWkbTypes.GeometryType = ...
    isExpression: bool = ...
    labelOffsetMapUnitScale: QgsMapUnitScale = ...
    labelPerPart: bool = ...
    layerType: QgsWkbTypes.GeometryType = ...
    mCurFeat: QgsFeature = ...
    mCurFields: QgsFields = ...
    mFeatsRegPal: int = ...
    mFeatsSendingToPal: int = ...
    mFeaturesToLabel: int = ...
    maxCurvedCharAngleIn: float = ...
    maxCurvedCharAngleOut: float = ...
    maximumScale: float = ...
    minimumScale: float = ...
    multilineAlign: QgsPalLayerSettings.MultiLineAlign = ...
    offsetType: QgsPalLayerSettings.OffsetType = ...
    offsetUnits: QgsUnitTypes.RenderUnit = ...
    placement: QgsPalLayerSettings.Placement = ...
    plusSign: bool = ...
    preserveRotation: bool = ...
    previewBkgrdColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...
    priority: int = ...
    ptOne: QgsPointXY = ...
    ptZero: QgsPointXY = ...
    quadOffset: QgsPalLayerSettings.QuadrantPosition = ...
    repeatDistance: float = ...
    repeatDistanceMapUnitScale: QgsMapUnitScale = ...
    repeatDistanceUnit: QgsUnitTypes.RenderUnit = ...
    scaleVisibility: bool = ...
    substitutions: QgsStringReplacementCollection = ...
    upsidedownLabels: QgsPalLayerSettings.UpsideDownLabels = ...
    useMaxLineLengthForAutoWrap: bool = ...
    useSubstitutions: bool = ...
    wrapChar: str = ...
    xOffset: float = ...
    xform: QgsMapToPixel = ...
    yOffset: float = ...
    zIndex: float = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, s: QgsPalLayerSettings) -> None: ...

    def setUnplacedVisibility(self, visibility: Qgis.UnplacedLabelVisibility) -> None: ...
    def unplacedVisibility(self) -> Qgis.UnplacedLabelVisibility: ...
    @staticmethod
    def labelSettingsPreviewPixmap(settings: QgsPalLayerSettings, size: QtCore.QSize, previewText: str = ..., padding: int = ...) -> QtGui.QPixmap: ...
    def setThinningSettings(self, settings: QgsLabelThinningSettings) -> None: ...
    def thinningSettings(self) -> QgsLabelThinningSettings: ...
    def setObstacleSettings(self, settings: QgsLabelObstacleSettings) -> None: ...
    def obstacleSettings(self) -> QgsLabelObstacleSettings: ...
    def setLineSettings(self, settings: QgsLabelLineSettings) -> None: ...
    def lineSettings(self) -> QgsLabelLineSettings: ...
    def setCallout(self, callout: QgsCallout) -> None: ...
    def callout(self) -> QgsCallout: ...
    def setFormat(self, format: QgsTextFormat) -> None: ...
    def format(self) -> QgsTextFormat: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def registerFeature(self, f: QgsFeature, context: QgsRenderContext) -> None: ...
    def calculateLabelSize(self, fm: QtGui.QFontMetricsF, text: str, f: Optional[QgsFeature] = ..., context: Optional[QgsRenderContext] = ...) -> Tuple[float, float, float, float]: ...
    def legendString(self) -> str: ...
    def setLegendString(self, legendString: str) -> None: ...
    def _setOverrunDistanceMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def _getOverrunDistanceMapUnitScale(self) -> QgsMapUnitScale: ...
    def _setOverrunDistanceUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def _getOverrunDistanceUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def _setOverrunDistance(self, distance: float) -> None: ...
    def _getOverrunDistance(self) -> float: ...
    def _setPlaceDirectionSymbol(self, placement: QgsPalLayerSettings.DirectionSymbols) -> None: ...
    def _getPlaceDirectionSymbol(self) -> QgsPalLayerSettings.DirectionSymbols: ...
    def _setReverseDirectionSymbol(self, reverse: bool) -> None: ...
    def _getReverseDirectionSymbol(self) -> bool: ...
    def _setRightDirectionSymbol(self, symbol: str) -> None: ...
    def _getRightDirectionSymbol(self) -> str: ...
    def _setLeftDirectionSymbol(self, symbol: str) -> None: ...
    def _getLeftDirectionSymbol(self) -> str: ...
    def _setAddDirectionSymbol(self, add: bool) -> None: ...
    def _getAddDirectionSymbol(self) -> bool: ...
    def _setMergeLines(self, merge: bool) -> None: ...
    def _getMergeLines(self) -> bool: ...
    def _setLinePlacementFlags(self, flags: int) -> None: ...
    def _getLinePlacementFlags(self) -> int: ...
    def _setObstacleType(self, type: QgsPalLayerSettings.ObstacleType) -> None: ...
    def _getObstacleType(self) -> QgsPalLayerSettings.ObstacleType: ...
    def _setObstacleFactor(self, factor: float) -> None: ...
    def _getObstacleFactor(self) -> float: ...
    def _setIsObstacle(self, obstacle: bool) -> None: ...
    def _getIsObstacle(self) -> bool: ...
    def _setMinFeatureSize(self, size: float) -> None: ...
    def _minFeatureSize(self) -> float: ...
    def _setMaxNumLabels(self, max: int) -> None: ...
    def _maxNumLabels(self) -> int: ...
    def _setLimitNumLabels(self, limit: bool) -> None: ...
    def _limitNumLabels(self) -> bool: ...
    def setPolygonPlacementFlags(self, flags: Union[QgsLabeling.PolygonPlacementFlags, QgsLabeling.PolygonPlacementFlag]) -> None: ...
    def polygonPlacementFlags(self) -> QgsLabeling.PolygonPlacementFlags: ...
    def getLabelExpression(self) -> QgsExpression: ...
    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...
    def containsAdvancedEffects(self) -> bool: ...
    def stopRender(self, context: QgsRenderContext) -> None: ...
    def startRender(self, context: QgsRenderContext) -> None: ...
    def referencedFields(self, context: QgsRenderContext) -> Set[str]: ...
    def prepare(self, context: QgsRenderContext, attributeNames: Iterable[str], fields: QgsFields, mapSettings: QgsMapSettings, crs: QgsCoordinateReferenceSystem) -> Tuple[bool, Set[str]]: ...
    @property
    def overrunDistanceMapUnitScale(self) -> QgsMapUnitScale: ...
    @overrunDistanceMapUnitScale.setter
    def overrunDistanceMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    @property
    def overrunDistanceUnit(self) -> QgsUnitTypes.RenderUnit: ...
    @overrunDistanceUnit.setter
    def overrunDistanceUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    @property
    def overrunDistance(self) -> float: ...
    @overrunDistance.setter
    def overrunDistance(self, distance: float) -> None: ...
    @property
    def placeDirectionSymbol(self) -> QgsPalLayerSettings.DirectionSymbols: ...
    @placeDirectionSymbol.setter
    def placeDirectionSymbol(self, placement: QgsPalLayerSettings.DirectionSymbols) -> None: ...
    @property
    def reverseDirectionSymbol(self) -> bool: ...
    @reverseDirectionSymbol.setter
    def reverseDirectionSymbol(self, reverse: bool) -> None: ...
    @property
    def rightDirectionSymbol(self) -> str: ...
    @rightDirectionSymbol.setter
    def rightDirectionSymbol(self, symbol: str) -> None: ...
    @property
    def leftDirectionSymbol(self) -> str: ...
    @leftDirectionSymbol.setter
    def leftDirectionSymbol(self, symbol: str) -> None: ...
    @property
    def addDirectionSymbol(self) -> bool: ...
    @addDirectionSymbol.setter
    def addDirectionSymbol(self, add: bool) -> None: ...
    @property
    def mergeLines(self) -> bool: ...
    @mergeLines.setter
    def mergeLines(self, merge: bool) -> None: ...
    @property
    def placementFlags(self) -> int: ...
    @placementFlags.setter
    def placementFlags(self, flags: int) -> None: ...
    @property
    def obstacleType(self) -> QgsPalLayerSettings.ObstacleType: ...
    @obstacleType.setter
    def obstacleType(self, type: QgsPalLayerSettings.ObstacleType) -> None: ...
    @property
    def obstacleFactor(self) -> float: ...
    @obstacleFactor.setter
    def obstacleFactor(self, factor: float) -> None: ...
    @property
    def obstacle(self) -> bool: ...
    @obstacle.setter
    def obstacle(self, obstacle: bool) -> None: ...
    @property
    def minFeatureSize(self) -> float: ...
    @minFeatureSize.setter
    def minFeatureSize(self, size: float) -> None: ...
    @property
    def maxNumLabels(self) -> int: ...
    @maxNumLabels.setter
    def maxNumLabels(self, max: int) -> None: ...
    @property
    def limitNumLabels(self) -> bool: ...
    @limitNumLabels.setter
    def limitNumLabels(self, limit: bool) -> None: ...


class QgsLabelCandidate(sip.wrapper):

    cost: float = ...
    rect: QtCore.QRectF = ...

    @overload
    def __init__(self, r: QtCore.QRectF, c: float) -> None: ...
    @overload
    def __init__(self, a0: QgsLabelCandidate) -> None: ...


class QgsPalLabeling(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsPalLabeling) -> None: ...

    @staticmethod
    def splitToGraphemes(text: str) -> List[str]: ...
    @staticmethod
    def splitToLines(text: str, wrapCharacter: str, autoWrapLength: int = ..., useMaxLineLengthWhenAutoWrapping: bool = ...) -> List[str]: ...
    @staticmethod
    def geometryRequiresPreparation(geometry: QgsGeometry, context: QgsRenderContext, ct: QgsCoordinateTransform, clipGeometry: QgsGeometry = ..., mergeLines: bool = ...) -> bool: ...
    @staticmethod
    def prepareGeometry(geometry: QgsGeometry, context: QgsRenderContext, ct: QgsCoordinateTransform, clipGeometry: QgsGeometry = ..., mergeLines: bool = ...) -> QgsGeometry: ...
    @staticmethod
    def staticWillUseLayer(layer: QgsMapLayer) -> bool: ...


class QgsAbstractVectorLayerLabeling(sip.wrapper):

    def __init__(self) -> None: ...

    def writeTextSymbolizer(self, parent: QtXml.QDomNode, settings: QgsPalLayerSettings, props: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def defaultSettingsForLayer(layer: QgsVectorLayer) -> QgsPalLayerSettings: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def toSld(self, parent: QtXml.QDomNode, props: Dict[str, typing.Any]) -> None: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsAbstractVectorLayerLabeling: ...
    def requiresAdvancedEffects(self) -> bool: ...
    def setSettings(self, settings: QgsPalLayerSettings, providerId: str = ...) -> None: ...
    def settings(self, providerId: str = ...) -> QgsPalLayerSettings: ...
    def subProviders(self) -> List[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def clone(self) -> QgsAbstractVectorLayerLabeling: ...
    def type(self) -> str: ...


class QgsRuleBasedLabeling(QgsAbstractVectorLayerLabeling):

    class Rule(sip.wrapper):

        class RegisterResult(int):
            ...
        Filtered: QgsRuleBasedLabeling.Rule.RegisterResult = ...
        Inactive: QgsRuleBasedLabeling.Rule.RegisterResult = ...
        Registered: QgsRuleBasedLabeling.Rule.RegisterResult = ...

        def __init__(self, settings: QgsPalLayerSettings, maximumScale: float = ..., minimumScale: float = ..., filterExp: str = ..., description: str = ..., elseRule: bool = ...) -> None: ...

        def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
        def requiresAdvancedEffects(self) -> bool: ...
        def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
        @staticmethod
        def create(ruleElem: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsRuleBasedLabeling.Rule: ...
        def clone(self) -> QgsRuleBasedLabeling.Rule: ...
        def findRuleByKey(self, key: str) -> QgsRuleBasedLabeling.Rule: ...
        def removeChildAt(self, i: int) -> None: ...
        def insertChild(self, i: int, rule: QgsRuleBasedLabeling.Rule) -> None: ...
        def appendChild(self, rule: QgsRuleBasedLabeling.Rule) -> None: ...
        def parent(self) -> QgsRuleBasedLabeling.Rule: ...
        def descendants(self) -> List[QgsRuleBasedLabeling.Rule]: ...
        def children(self) -> List[QgsRuleBasedLabeling.Rule]: ...
        def setRuleKey(self, key: str) -> None: ...
        def setIsElse(self, iselse: bool) -> None: ...
        def setActive(self, state: bool) -> None: ...
        def setDescription(self, description: str) -> None: ...
        def setFilterExpression(self, filterExp: str) -> None: ...
        def setMaximumScale(self, scale: float) -> None: ...
        def setMinimumScale(self, scale: float) -> None: ...
        def setSettings(self, settings: QgsPalLayerSettings) -> None: ...
        def ruleKey(self) -> str: ...
        def isElse(self) -> bool: ...
        def active(self) -> bool: ...
        def description(self) -> str: ...
        def filterExpression(self) -> str: ...
        def minimumScale(self) -> float: ...
        def maximumScale(self) -> float: ...
        def dependsOnScale(self) -> bool: ...
        def settings(self) -> QgsPalLayerSettings: ...

    def __init__(self, root: QgsRuleBasedLabeling.Rule) -> None: ...

    def toSld(self, parent: QtXml.QDomNode, props: Dict[str, typing.Any]) -> None: ...
    def requiresAdvancedEffects(self) -> bool: ...
    def setSettings(self, settings: QgsPalLayerSettings, providerId: str = ...) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def settings(self, providerId: str = ...) -> QgsPalLayerSettings: ...
    def subProviders(self) -> List[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def clone(self) -> QgsRuleBasedLabeling: ...
    def type(self) -> str: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsRuleBasedLabeling: ...
    def rootRule(self) -> QgsRuleBasedLabeling.Rule: ...


class QgsVectorLayerSimpleLabeling(QgsAbstractVectorLayerLabeling):

    def __init__(self, settings: QgsPalLayerSettings) -> None: ...

    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsVectorLayerSimpleLabeling: ...
    def toSld(self, parent: QtXml.QDomNode, props: Dict[str, typing.Any]) -> None: ...
    def requiresAdvancedEffects(self) -> bool: ...
    def setSettings(self, settings: QgsPalLayerSettings, providerId: str = ...) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def settings(self, providerId: str = ...) -> QgsPalLayerSettings: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def clone(self) -> QgsAbstractVectorLayerLabeling: ...
    def type(self) -> str: ...


class QgsLayerTreeModelLegendNode(QtCore.QObject):

    class NodeTypes(int):
        ...
    SimpleLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...
    SymbolLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...
    RasterSymbolLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...
    ImageLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...
    WmsLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...
    DataDefinedSizeLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...
    EmbeddedWidget: QgsLayerTreeModelLegendNode.NodeTypes = ...
    ColorRampLegend: QgsLayerTreeModelLegendNode.NodeTypes = ...

    class LegendNodeRoles(int):
        ...
    RuleKeyRole: QgsLayerTreeModelLegendNode.LegendNodeRoles = ...
    ParentRuleKeyRole: QgsLayerTreeModelLegendNode.LegendNodeRoles = ...
    NodeTypeRole: QgsLayerTreeModelLegendNode.LegendNodeRoles = ...

    class ItemContext(sip.wrapper):

        columnLeft: float = ...
        columnRight: float = ...
        context: QgsRenderContext = ...
        labelXOffset: float = ...
        maxSiblingSymbolWidth: float = ...
        painter: QtGui.QPainter = ...
        patchShape: QgsLegendPatchShape = ...
        patchSize: QtCore.QSizeF = ...
        point: Union[QtCore.QPointF, QtCore.QPoint, float] = ...
        top: float = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerTreeModelLegendNode.ItemContext) -> None: ...

    class ItemMetrics(sip.wrapper):

        labelSize: QtCore.QSizeF = ...
        symbolSize: QtCore.QSizeF = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerTreeModelLegendNode.ItemMetrics) -> None: ...

    def __init__(self, nodeL: QgsLayerTreeLayer, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def createTemporaryRenderContext(self) -> QgsRenderContext: ...
    def sizeChanged(self) -> None: ...
    def dataChanged(self) -> None: ...
    def toggleAllItems(self) -> None: ...
    def uncheckAllItems(self) -> None: ...
    def checkAllItems(self) -> None: ...
    def drawSymbolText(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, symbolSize: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def exportToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def draw(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext) -> QgsLayerTreeModelLegendNode.ItemMetrics: ...
    def invalidateMapBasedData(self) -> None: ...
    def isScaleOK(self, scale: float) -> bool: ...
    def columnBreak(self) -> bool: ...
    def setColumnBreak(self, breakBeforeNode: bool) -> None: ...
    def setUserPatchSize(self, size: QtCore.QSizeF) -> None: ...
    def userPatchSize(self) -> QtCore.QSizeF: ...
    def setUserLabel(self, userLabel: str) -> None: ...
    def userLabel(self) -> str: ...
    def setEmbeddedInParent(self, embedded: bool) -> None: ...
    def isEmbeddedInParent(self) -> bool: ...
    def setData(self, value: typing.Any, role: int) -> bool: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...
    def model(self) -> QgsLayerTreeModel: ...
    def layerNode(self) -> QgsLayerTreeLayer: ...


class QgsColorRampLegendNode(QgsLayerTreeModelLegendNode):

    @overload
    def __init__(self, nodeLayer: QgsLayerTreeLayer, ramp: QgsColorRamp, minimumLabel: str, maximumLabel: str, parent: Optional[QtCore.QObject] = ...) -> None: ...
    @overload
    def __init__(self, nodeLayer: QgsLayerTreeLayer, ramp: QgsColorRamp, settings: QgsColorRampLegendNodeSettings, minimumValue: float, maximumValue: float, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setSettings(self, settings: QgsColorRampLegendNodeSettings) -> None: ...
    def settings(self) -> QgsColorRampLegendNodeSettings: ...
    def ramp(self) -> QgsColorRamp: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setIconSize(self, size: QtCore.QSize) -> None: ...
    def drawSymbolText(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, symbolSize: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def data(self, role: int) -> typing.Any: ...


class QgsColorRampLegendNodeSettings(sip.wrapper):

    class Direction(int):
        ...
    MinimumToMaximum: QgsColorRampLegendNodeSettings.Direction = ...
    MaximumToMinimum: QgsColorRampLegendNodeSettings.Direction = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, other: QgsColorRampLegendNodeSettings) -> None: ...

    def setUseContinuousLegend(self, useContinuousLegend: bool) -> None: ...
    def useContinuousLegend(self) -> bool: ...
    def setOrientation(self, orientation: QtCore.Qt.Orientation) -> None: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setTextFormat(self, format: QgsTextFormat) -> None: ...
    def textFormat(self) -> QgsTextFormat: ...
    def setSuffix(self, suffix: str) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, prefix: str) -> None: ...
    def prefix(self) -> str: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def setNumericFormat(self, format: QgsNumericFormat) -> None: ...
    def numericFormat(self) -> QgsNumericFormat: ...
    def setMaximumLabel(self, label: str) -> None: ...
    def maximumLabel(self) -> str: ...
    def setMinimumLabel(self, label: str) -> None: ...
    def minimumLabel(self) -> str: ...
    def setDirection(self, direction: QgsColorRampLegendNodeSettings.Direction) -> None: ...
    def direction(self) -> QgsColorRampLegendNodeSettings.Direction: ...


class QgsLayerTreeNode(QtCore.QObject):

    class NodeType(int):
        ...
    NodeGroup: QgsLayerTreeNode.NodeType = ...
    NodeLayer: QgsLayerTreeNode.NodeType = ...

    @overload
    def __init__(self, t: QgsLayerTreeNode.NodeType, checked: bool = ...) -> None: ...
    @overload
    def __init__(self, other: QgsLayerTreeNode) -> None: ...

    def removeChildrenPrivate(self, from_: int, count: int, destroy: bool = ...) -> None: ...
    def insertChildrenPrivate(self, index: int, nodes: Iterable[QgsLayerTreeNode]) -> None: ...
    def writeCommonXml(self, element: QtXml.QDomElement) -> None: ...
    def readCommonXml(self, element: QtXml.QDomElement) -> None: ...
    def nameChanged(self, node: QgsLayerTreeNode, name: str) -> None: ...
    def expandedChanged(self, node: QgsLayerTreeNode, expanded: bool) -> None: ...
    def customPropertyChanged(self, node: QgsLayerTreeNode, key: str) -> None: ...
    def visibilityChanged(self, node: QgsLayerTreeNode) -> None: ...
    def removedChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def willRemoveChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def addedChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def willAddChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def takeChild(self, node: QgsLayerTreeNode) -> bool: ...
    def customProperties(self) -> List[str]: ...
    def removeCustomProperty(self, key: str) -> None: ...
    def customProperty(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setCustomProperty(self, key: str, value: typing.Any) -> None: ...
    def setExpanded(self, expanded: bool) -> None: ...
    def isExpanded(self) -> bool: ...
    def depth(self) -> int: ...
    def checkedLayers(self) -> List[QgsMapLayer]: ...
    def isItemVisibilityUncheckedRecursive(self) -> bool: ...
    def isItemVisibilityCheckedRecursive(self) -> bool: ...
    def setItemVisibilityCheckedParentRecursive(self, checked: bool) -> None: ...
    def setItemVisibilityCheckedRecursive(self, checked: bool) -> None: ...
    def setItemVisibilityChecked(self, checked: bool) -> None: ...
    def itemVisibilityChecked(self) -> bool: ...
    def isVisible(self) -> bool: ...
    def resolveReferences(self, project: QgsProject, looseMatching: bool = ...) -> None: ...
    def clone(self) -> QgsLayerTreeNode: ...
    def dump(self) -> str: ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsLayerTreeNode: ...
    @overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, project: QgsProject) -> QgsLayerTreeNode: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def children(self) -> List[QgsLayerTreeNode]: ...
    def parent(self) -> QgsLayerTreeNode: ...
    def nodeType(self) -> QgsLayerTreeNode.NodeType: ...


class QgsLayerTreeGroup(QgsLayerTreeNode):

    def __init__(self, name: str = ..., checked: bool = ...) -> None: ...

    def updateChildVisibilityMutuallyExclusive(self) -> None: ...
    def nodeVisibilityChanged(self, node: QgsLayerTreeNode) -> None: ...
    def setIsMutuallyExclusive(self, enabled: bool, initialChildIndex: int = ...) -> None: ...
    def isMutuallyExclusive(self) -> bool: ...
    def setItemVisibilityCheckedRecursive(self, checked: bool) -> None: ...
    def resolveReferences(self, project: QgsProject, looseMatching: bool = ...) -> None: ...
    def clone(self) -> QgsLayerTreeGroup: ...
    def dump(self) -> str: ...
    def readChildrenFromXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsLayerTreeGroup: ...
    @overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, project: QgsProject, context: QgsReadWriteContext) -> QgsLayerTreeGroup: ...
    def findGroups(self, recursive: bool = ...) -> List[QgsLayerTreeGroup]: ...
    def findGroup(self, name: str) -> QgsLayerTreeGroup: ...
    def findLayerIds(self) -> List[str]: ...
    def findLayers(self) -> List[QgsLayerTreeLayer]: ...
    @overload
    def findLayer(self, layer: QgsMapLayer) -> QgsLayerTreeLayer: ...
    @overload
    def findLayer(self, layerId: str) -> QgsLayerTreeLayer: ...
    def removeAllChildren(self) -> None: ...
    def removeChildrenGroupWithoutLayers(self) -> None: ...
    def removeChildren(self, from_: int, count: int) -> None: ...
    def removeLayer(self, layer: QgsMapLayer) -> None: ...
    def removeChildNode(self, node: QgsLayerTreeNode) -> None: ...
    def addChildNode(self, node: QgsLayerTreeNode) -> None: ...
    def insertChildNode(self, index: int, node: QgsLayerTreeNode) -> None: ...
    def insertChildNodes(self, index: int, nodes: Iterable[QgsLayerTreeNode]) -> None: ...
    def addLayer(self, layer: QgsMapLayer) -> QgsLayerTreeLayer: ...
    def insertLayer(self, index: int, layer: QgsMapLayer) -> QgsLayerTreeLayer: ...
    def addGroup(self, name: str) -> QgsLayerTreeGroup: ...
    def insertGroup(self, index: int, name: str) -> QgsLayerTreeGroup: ...
    def setName(self, n: str) -> None: ...
    def name(self) -> str: ...


class QgsLayerTree(QgsLayerTreeGroup):

    def __init__(self) -> None: ...

    def hasCustomLayerOrderChanged(self, hasCustomLayerOrder: bool) -> None: ...
    def layerOrderChanged(self) -> None: ...
    def customLayerOrderChanged(self) -> None: ...
    def clear(self) -> None: ...
    def clone(self) -> QgsLayerTree: ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def readLayerOrderFromXml(self, doc: QtXml.QDomElement) -> None: ...
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsLayerTree: ...
    def setHasCustomLayerOrder(self, hasCustomLayerOrder: bool) -> None: ...
    def hasCustomLayerOrder(self) -> bool: ...
    def layerOrder(self) -> List[QgsMapLayer]: ...
    def setCustomLayerOrderByIds(self, customLayerOrder: Iterable[str]) -> None: ...
    def setCustomLayerOrder(self, customLayerOrder: Iterable[QgsMapLayer]) -> None: ...
    def customLayerOrder(self) -> List[QgsMapLayer]: ...
    @staticmethod
    def isLayer(node: QgsLayerTreeNode) -> bool: ...
    @staticmethod
    def isGroup(node: QgsLayerTreeNode) -> bool: ...


class QgsLayerTreeLayer(QgsLayerTreeNode):

    class LegendNodesSplitBehavior(int):
        ...
    UseDefaultLegendSetting: QgsLayerTreeLayer.LegendNodesSplitBehavior = ...
    AllowSplittingLegendNodesOverMultipleColumns: QgsLayerTreeLayer.LegendNodesSplitBehavior = ...
    PreventSplittingLegendNodesOverMultipleColumns: QgsLayerTreeLayer.LegendNodesSplitBehavior = ...

    @overload
    def __init__(self, layer: QgsMapLayer) -> None: ...
    @overload
    def __init__(self, layerId: str, name: str = ..., source: str = ..., provider: str = ...) -> None: ...

    def attachToLayer(self) -> None: ...
    def layerWillBeUnloaded(self) -> None: ...
    def layerLoaded(self) -> None: ...
    def setLegendSplitBehavior(self, behavior: QgsLayerTreeLayer.LegendNodesSplitBehavior) -> None: ...
    def legendSplitBehavior(self) -> QgsLayerTreeLayer.LegendNodesSplitBehavior: ...
    def setPatchSize(self, size: QtCore.QSizeF) -> None: ...
    def patchSize(self) -> QtCore.QSizeF: ...
    def setPatchShape(self, shape: QgsLegendPatchShape) -> None: ...
    def patchShape(self) -> QgsLegendPatchShape: ...
    def labelExpression(self) -> str: ...
    def setLabelExpression(self, expression: str) -> None: ...
    def resolveReferences(self, project: QgsProject, looseMatching: bool = ...) -> None: ...
    def clone(self) -> QgsLayerTreeLayer: ...
    def dump(self) -> str: ...
    def writeXml(self, parentElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsLayerTreeLayer: ...
    @overload
    @staticmethod
    def readXml(element: QtXml.QDomElement, project: QgsProject, context: QgsReadWriteContext) -> QgsLayerTreeLayer: ...
    def useLayerName(self) -> bool: ...
    def setUseLayerName(self, use: bool = ...) -> None: ...
    def setName(self, n: str) -> None: ...
    def name(self) -> str: ...
    def layer(self) -> QgsMapLayer: ...
    def layerId(self) -> str: ...


class QgsLayerTreeModel(QtCore.QAbstractItemModel):

    class Flag(int):
        ...
    ShowLegend: QgsLayerTreeModel.Flag = ...
    ShowLegendAsTree: QgsLayerTreeModel.Flag = ...
    DeferredLegendInvalidation: QgsLayerTreeModel.Flag = ...
    UseEmbeddedWidgets: QgsLayerTreeModel.Flag = ...
    UseTextFormatting: QgsLayerTreeModel.Flag = ...
    AllowNodeReorder: QgsLayerTreeModel.Flag = ...
    AllowNodeRename: QgsLayerTreeModel.Flag = ...
    AllowNodeChangeVisibility: QgsLayerTreeModel.Flag = ...
    AllowLegendChangeState: QgsLayerTreeModel.Flag = ...
    ActionHierarchical: QgsLayerTreeModel.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLayerTreeModel.Flags, QgsLayerTreeModel.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerTreeModel.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLayerTreeModel.Flags: ...
        def __int__(self) -> int: ...

    def __init__(self, rootNode: QgsLayerTree, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def legendInvalidateMapBasedData(self) -> None: ...
    def legendCleanup(self) -> None: ...
    def legendIconEmbeddedInParent(self, nodeLayer: QgsLayerTreeLayer) -> QtGui.QIcon: ...
    def legendEmbeddedInParent(self, nodeLayer: QgsLayerTreeLayer) -> bool: ...
    def legendNodeFlags(self, node: QgsLayerTreeModelLegendNode) -> QtCore.Qt.ItemFlags: ...
    def legendNodeData(self, node: QgsLayerTreeModelLegendNode, role: int) -> typing.Any: ...
    def legendParent(self, legendNode: QgsLayerTreeModelLegendNode) -> QtCore.QModelIndex: ...
    def legendNodeIndex(self, row: int, column: int, node: QgsLayerTreeModelLegendNode) -> QtCore.QModelIndex: ...
    def legendRootIndex(self, row: int, column: int, nL: QgsLayerTreeLayer) -> QtCore.QModelIndex: ...
    def legendNodeRowCount(self, node: QgsLayerTreeModelLegendNode) -> int: ...
    def legendRootRowCount(self, nL: QgsLayerTreeLayer) -> int: ...
    def indexOfParentLayerTreeNode(self, parentNode: QgsLayerTreeNode) -> QtCore.QModelIndex: ...
    def filterLegendNodes(self, nodes: Iterable[QgsLayerTreeModelLegendNode]) -> List[QgsLayerTreeModelLegendNode]: ...
    @staticmethod
    def iconGroup() -> QtGui.QIcon: ...
    def refreshScaleBasedLayers(self, index: QtCore.QModelIndex = ..., previousScale: float = ...) -> None: ...
    def recursivelyEmitDataChanged(self, index: QtCore.QModelIndex = ...) -> None: ...
    def disconnectFromRootNode(self) -> None: ...
    def connectToRootNode(self) -> None: ...
    def disconnectFromLayers(self, parentGroup: QgsLayerTreeGroup) -> None: ...
    def connectToLayers(self, parentGroup: QgsLayerTreeGroup) -> None: ...
    def disconnectFromLayer(self, nodeLayer: QgsLayerTreeLayer) -> None: ...
    def connectToLayer(self, nodeLayer: QgsLayerTreeLayer) -> None: ...
    def addLegendToLayer(self, nodeL: QgsLayerTreeLayer) -> None: ...
    def removeLegendFromLayer(self, nodeLayer: QgsLayerTreeLayer) -> None: ...
    def invalidateLegendMapBasedData(self) -> None: ...
    def legendNodeDataChanged(self) -> None: ...
    def layerNeedsUpdate(self) -> None: ...
    def layerFlagsChanged(self) -> None: ...
    def layerLegendChanged(self) -> None: ...
    def nodeLayerWillBeUnloaded(self) -> None: ...
    def nodeLayerLoaded(self) -> None: ...
    def nodeCustomPropertyChanged(self, node: QgsLayerTreeNode, key: str) -> None: ...
    def nodeNameChanged(self, node: QgsLayerTreeNode, name: str) -> None: ...
    def nodeVisibilityChanged(self, node: QgsLayerTreeNode) -> None: ...
    def nodeRemovedChildren(self) -> None: ...
    def nodeWillRemoveChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def nodeAddedChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def nodeWillAddChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def messageEmitted(self, message: str, level: Qgis.MessageLevel = ..., duration: int = ...) -> None: ...
    @staticmethod
    def scaleIconSize(standardSize: int) -> int: ...
    def setLayerStyleOverrides(self, overrides: Dict[str, str]) -> None: ...
    def layerStyleOverrides(self) -> Dict[str, str]: ...
    def legendMapViewData(self) -> Tuple[float, int, float]: ...
    def setLegendMapViewData(self, mapUnitsPerPixel: float, dpi: int, scale: float) -> None: ...
    def legendFilterMapSettings(self) -> QgsMapSettings: ...
    def setLegendFilter(self, settings: QgsMapSettings, useExtent: bool = ..., polygon: QgsGeometry = ..., useExpressions: bool = ...) -> None: ...
    def setLegendFilterByMap(self, settings: QgsMapSettings) -> None: ...
    def legendFilterByScale(self) -> float: ...
    def setLegendFilterByScale(self, scale: float) -> None: ...
    def autoCollapseLegendNodes(self) -> int: ...
    def setAutoCollapseLegendNodes(self, nodeCount: int) -> None: ...
    def layerTreeNodeFont(self, nodeType: int) -> QtGui.QFont: ...
    def setLayerTreeNodeFont(self, nodeType: int, font: QtGui.QFont) -> None: ...
    def setCurrentIndex(self, currentIndex: QtCore.QModelIndex) -> None: ...
    def currentIndex(self) -> QtCore.QModelIndex: ...
    def refreshLayerLegend(self, nodeLayer: QgsLayerTreeLayer) -> None: ...
    def setRootGroup(self, newRootGroup: QgsLayerTree) -> None: ...
    def rootGroup(self) -> QgsLayerTree: ...
    def findLegendNode(self, layerId: str, ruleKey: str) -> QgsLayerTreeModelLegendNode: ...
    def legendNodeEmbeddedInParent(self, nodeLayer: QgsLayerTreeLayer) -> QgsLayerTreeModelLegendNode: ...
    def layerOriginalLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def layerLegendNodes(self, nodeLayer: QgsLayerTreeLayer, skipNodeEmbeddedInParent: bool = ...) -> List[QgsLayerTreeModelLegendNode]: ...
    def legendNode2index(self, legendNode: QgsLayerTreeModelLegendNode) -> QtCore.QModelIndex: ...
    @staticmethod
    def index2legendNode(index: QtCore.QModelIndex) -> QgsLayerTreeModelLegendNode: ...
    def indexes2nodes(self, list: Iterable[QtCore.QModelIndex], skipInternal: bool = ...) -> List[QgsLayerTreeNode]: ...
    def node2index(self, node: QgsLayerTreeNode) -> QtCore.QModelIndex: ...
    def index2node(self, index: QtCore.QModelIndex) -> QgsLayerTreeNode: ...
    def testFlag(self, f: QgsLayerTreeModel.Flag) -> bool: ...
    def setFlag(self, f: QgsLayerTreeModel.Flag, on: bool = ...) -> None: ...
    def setFlags(self, f: Union[QgsLayerTreeModel.Flags, QgsLayerTreeModel.Flag]) -> None: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    @overload
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    @overload
    def flags(self) -> QgsLayerTreeModel.Flags: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...


class QgsSymbolLegendNode(QgsLayerTreeModelLegendNode):

    MAXIMUM_SIZE: float = ...
    MINIMUM_SIZE: float = ...

    def __init__(self, nodeLayer: QgsLayerTreeLayer, item: QgsLegendSymbolItem, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def evaluateLabel(self, context: QgsExpressionContext = ..., label: str = ...) -> str: ...
    def setCustomSymbol(self, symbol: QgsSymbol) -> None: ...
    def customSymbol(self) -> QgsSymbol: ...
    def setPatchShape(self, shape: QgsLegendPatchShape) -> None: ...
    def patchShape(self) -> QgsLegendPatchShape: ...
    def symbolLabel(self) -> str: ...
    def setTextOnSymbolTextFormat(self, format: QgsTextFormat) -> None: ...
    def textOnSymbolTextFormat(self) -> QgsTextFormat: ...
    def setTextOnSymbolLabel(self, label: str) -> None: ...
    def textOnSymbolLabel(self) -> str: ...
    def setSymbol(self, symbol: QgsSymbol) -> None: ...
    def symbol(self) -> QgsSymbol: ...
    @overload
    def minimumIconSize(self) -> QtCore.QSize: ...
    @overload
    def minimumIconSize(self, context: QgsRenderContext) -> QtCore.QSize: ...
    def iconSize(self) -> QtCore.QSize: ...
    def setIconSize(self, sz: QtCore.QSize) -> None: ...
    def invalidateMapBasedData(self) -> None: ...
    def isScaleOK(self, scale: float) -> bool: ...
    def setUserLabel(self, userLabel: str) -> None: ...
    def setEmbeddedInParent(self, embedded: bool) -> None: ...
    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def setData(self, value: typing.Any, role: int) -> bool: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...


class QgsSimpleLegendNode(QgsLayerTreeModelLegendNode):

    def __init__(self, nodeLayer: QgsLayerTreeLayer, label: str, icon: QtGui.QIcon = ..., parent: Optional[QtCore.QObject] = ..., key: str = ...) -> None: ...

    def data(self, role: int) -> typing.Any: ...


class QgsImageLegendNode(QgsLayerTreeModelLegendNode):

    def __init__(self, nodeLayer: QgsLayerTreeLayer, img: QtGui.QImage, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def data(self, role: int) -> typing.Any: ...


class QgsRasterSymbolLegendNode(QgsLayerTreeModelLegendNode):

    def __init__(self, nodeLayer: QgsLayerTreeLayer, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], label: str, parent: Optional[QtCore.QObject] = ..., isCheckable: bool = ..., ruleKey: str = ...) -> None: ...

    def isCheckable(self) -> bool: ...
    def ruleKey(self) -> str: ...
    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def setData(self, value: typing.Any, role: int) -> bool: ...
    def data(self, role: int) -> typing.Any: ...
    def flags(self) -> QtCore.Qt.ItemFlags: ...


class QgsWmsLegendNode(QgsLayerTreeModelLegendNode):

    def __init__(self, nodeLayer: QgsLayerTreeLayer, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def invalidateMapBasedData(self) -> None: ...
    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def data(self, role: int) -> typing.Any: ...


class QgsDataDefinedSizeLegendNode(QgsLayerTreeModelLegendNode):

    def __init__(self, nodeLayer: QgsLayerTreeLayer, settings: QgsDataDefinedSizeLegend, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def draw(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext) -> QgsLayerTreeModelLegendNode.ItemMetrics: ...
    def data(self, role: int) -> typing.Any: ...


class QgsVectorLabelLegendNode(QgsLayerTreeModelLegendNode):

    def __init__(self, nodeLayer: QgsLayerTreeLayer, labelSettings: QgsPalLayerSettings, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def exportSymbolToJson(self, settings: QgsLegendSettings, context: QgsRenderContext) -> Dict[str, QtCore.QJsonValue]: ...
    def drawSymbol(self, settings: QgsLegendSettings, ctx: QgsLayerTreeModelLegendNode.ItemContext, itemHeight: float) -> QtCore.QSizeF: ...
    def data(self, role: int) -> typing.Any: ...


class QgsLayerTreeRegistryBridge(QtCore.QObject):

    class InsertionPoint(sip.wrapper):

        group: QgsLayerTreeGroup = ...
        position: int = ...

        @overload
        def __init__(self, group: QgsLayerTreeGroup, position: int) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerTreeRegistryBridge.InsertionPoint) -> None: ...

    def __init__(self, root: QgsLayerTreeGroup, project: QgsProject, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def removeLayersFromRegistry(self, layerIds: Iterable[str]) -> None: ...
    def groupRemovedChildren(self) -> None: ...
    def groupWillRemoveChildren(self, node: QgsLayerTreeNode, indexFrom: int, indexTo: int) -> None: ...
    def layersWillBeRemoved(self, layerIds: Iterable[str]) -> None: ...
    def layersAdded(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def addedLayersToLayerTree(self, layers: Iterable[QgsMapLayer]) -> None: ...
    @overload
    def setLayerInsertionPoint(self, parentGroup: QgsLayerTreeGroup, index: int) -> None: ...
    @overload
    def setLayerInsertionPoint(self, insertionPoint: QgsLayerTreeRegistryBridge.InsertionPoint) -> None: ...
    def newLayersVisible(self) -> bool: ...
    def setNewLayersVisible(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...


class QgsLayerTreeFilterProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def setLayerChecked(self, layer: QgsMapLayer, checked: bool) -> None: ...
    def isLayerChecked(self, layer: QgsMapLayer) -> bool: ...
    def setFilterText(self, filterText: str = ...) -> None: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def sibling(self, row: int, column: int, idx: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def flags(self, idx: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def setFilters(self, filters: Union[QgsMapLayerProxyModel.Filters, QgsMapLayerProxyModel.Filter]) -> None: ...
    def setLayerTreeModel(self, layerTreeModel: QgsLayerTreeModel) -> None: ...
    def layerTreeModel(self) -> QgsLayerTreeModel: ...
    def mapLayer(self, idx: QtCore.QModelIndex) -> QgsMapLayer: ...
    def checkedLayers(self) -> List[QgsMapLayer]: ...
    def setCheckedLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...


class QgsLayerTreeUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerTreeUtils) -> None: ...

    @staticmethod
    def firstGroupWithoutCustomProperty(group: QgsLayerTreeGroup, property: str) -> QgsLayerTreeGroup: ...
    @staticmethod
    def countMapLayerInTree(tree: QgsLayerTreeNode, layer: QgsMapLayer) -> int: ...
    @staticmethod
    def collectMapLayersRecursive(nodes: Iterable[QgsLayerTreeNode]) -> Set[QgsMapLayer]: ...
    @staticmethod
    def insertLayerBelow(group: QgsLayerTreeGroup, refLayer: QgsMapLayer, layerToInsert: QgsMapLayer) -> QgsLayerTreeLayer: ...
    @staticmethod
    def hasLegendFilterExpression(group: QgsLayerTreeGroup) -> bool: ...
    @staticmethod
    def legendFilterByExpression(layer: QgsLayerTreeLayer) -> Tuple[str, bool]: ...
    @staticmethod
    def setLegendFilterByExpression(layer: QgsLayerTreeLayer, expr: str, enabled: bool = ...) -> None: ...
    @staticmethod
    def invisibleLayerList(node: QgsLayerTreeNode) -> List[str]: ...
    @staticmethod
    def updateEmbeddedGroupsProjectPath(group: QgsLayerTreeGroup, project: QgsProject) -> None: ...
    @staticmethod
    def replaceChildrenOfEmbeddedGroups(group: QgsLayerTreeGroup) -> None: ...
    @staticmethod
    def storeOriginalLayersProperties(group: QgsLayerTreeGroup, doc: QtXml.QDomDocument) -> None: ...
    @staticmethod
    def removeInvalidLayers(group: QgsLayerTreeGroup) -> None: ...
    @staticmethod
    def layersModified(layerNodes: Iterable[QgsLayerTreeLayer]) -> bool: ...
    @staticmethod
    def layersEditable(layerNodes: Iterable[QgsLayerTreeLayer]) -> bool: ...
    @staticmethod
    def checkStateFromXml(txt: str) -> QtCore.Qt.CheckState: ...
    @staticmethod
    def checkStateToXml(state: QtCore.Qt.CheckState) -> str: ...
    @staticmethod
    def writeOldLegend(doc: QtXml.QDomDocument, root: QgsLayerTreeGroup, hasCustomOrder: bool, order: Iterable[QgsMapLayer]) -> QtXml.QDomElement: ...
    @staticmethod
    def readOldLegendLayerOrder(legendElem: QtXml.QDomElement, order: Iterable[str]) -> Tuple[bool, bool]: ...
    @staticmethod
    def readOldLegend(root: QgsLayerTreeGroup, legendElem: QtXml.QDomElement) -> bool: ...


class QgsLegendPatchShape(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: Qgis.SymbolType, geometry: QgsGeometry, preserveAspectRatio: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLegendPatchShape) -> None: ...

    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def toQPolygonF(self, type: Qgis.SymbolType, size: QtCore.QSizeF) -> typing.Any: ...
    def setPreserveAspectRatio(self, preserve: bool) -> None: ...
    def preserveAspectRatio(self) -> bool: ...
    def setGeometry(self, geometry: QgsGeometry) -> None: ...
    def geometry(self) -> QgsGeometry: ...
    def setSymbolType(self, type: Qgis.SymbolType) -> None: ...
    def symbolType(self) -> Qgis.SymbolType: ...
    def isNull(self) -> bool: ...


class QgsAbstractLayoutIterator(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractLayoutIterator) -> None: ...

    def filePath(self, baseFilePath: str, extension: str) -> str: ...
    def next(self) -> bool: ...
    def count(self) -> int: ...
    def endRender(self) -> bool: ...
    def beginRender(self) -> bool: ...
    def layout(self) -> QgsLayout: ...


class QgsReportSectionContext(sip.wrapper):

    currentLayer: QgsVectorLayer = ...
    feature: QgsFeature = ...
    fieldFilters: Dict[str, typing.Any] = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsReportSectionContext) -> None: ...


class QgsAbstractReportSection(QgsAbstractLayoutIterator):

    class SubSection(int):
        ...
    Header: QgsAbstractReportSection.SubSection = ...
    Body: QgsAbstractReportSection.SubSection = ...
    Children: QgsAbstractReportSection.SubSection = ...
    Footer: QgsAbstractReportSection.SubSection = ...
    End: QgsAbstractReportSection.SubSection = ...

    def __init__(self, parentSection: Optional[QgsAbstractReportSection] = ...) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def setParentSection(self, parent: QgsAbstractReportSection) -> None: ...
    def copyCommonProperties(self, destination: QgsAbstractReportSection) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def reloadSettings(self) -> None: ...
    def readXml(self, sectionElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def context(self) -> QgsReportSectionContext: ...
    def setContext(self, context: QgsReportSectionContext) -> None: ...
    def removeChildAt(self, index: int) -> None: ...
    def removeChild(self, section: QgsAbstractReportSection) -> None: ...
    def insertChild(self, index: int, section: QgsAbstractReportSection) -> None: ...
    def appendChild(self, section: QgsAbstractReportSection) -> None: ...
    def childSection(self, index: int) -> QgsAbstractReportSection: ...
    def childSections(self) -> List[QgsAbstractReportSection]: ...
    def row(self) -> int: ...
    def childCount(self) -> int: ...
    def setFooter(self, footer: QgsLayout) -> None: ...
    def footer(self) -> QgsLayout: ...
    def setFooterEnabled(self, enabled: bool) -> None: ...
    def footerEnabled(self) -> bool: ...
    def setHeader(self, header: QgsLayout) -> None: ...
    def header(self) -> QgsLayout: ...
    def setHeaderEnabled(self, enabled: bool) -> None: ...
    def headerEnabled(self) -> bool: ...
    def nextBody(self) -> Tuple[QgsLayout, bool]: ...
    def prepareFooter(self) -> bool: ...
    def prepareHeader(self) -> bool: ...
    def reset(self) -> None: ...
    def endRender(self) -> bool: ...
    def next(self) -> bool: ...
    def beginRender(self) -> bool: ...
    def layout(self) -> QgsLayout: ...
    def filePath(self, baseFilePath: str, extension: str) -> str: ...
    def count(self) -> int: ...
    def project(self) -> QgsProject: ...
    def parentSection(self) -> QgsAbstractReportSection: ...
    def clone(self) -> QgsAbstractReportSection: ...
    def icon(self) -> QtGui.QIcon: ...
    def description(self) -> str: ...
    def type(self) -> str: ...


class QgsLayoutUndoObjectInterface(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutUndoObjectInterface) -> None: ...

    def createCommand(self, text: str, id: int = ..., parent: Optional[QtWidgets.QUndoCommand] = ...) -> QgsAbstractLayoutUndoCommand: ...


class QgsLayout(QtWidgets.QGraphicsScene, QgsExpressionContextGenerator, QgsLayoutUndoObjectInterface):

    class UndoCommand(int):
        ...
    UndoLayoutDpi: QgsLayout.UndoCommand = ...
    UndoNone: QgsLayout.UndoCommand = ...

    class ZValues(int):
        ...
    ZPage: QgsLayout.ZValues = ...
    ZItem: QgsLayout.ZValues = ...
    ZGrid: QgsLayout.ZValues = ...
    ZGuide: QgsLayout.ZValues = ...
    ZSmartGuide: QgsLayout.ZValues = ...
    ZMouseHandles: QgsLayout.ZValues = ...
    ZViewTool: QgsLayout.ZValues = ...
    ZSnapIndicator: QgsLayout.ZValues = ...

    def __init__(self, project: QgsProject) -> None: ...

    def backgroundTaskCountChanged(self, total: int) -> None: ...
    def refreshed(self) -> None: ...
    def selectedItemChanged(self, selected: QgsLayoutItem) -> None: ...
    def variablesChanged(self) -> None: ...
    def changed(self) -> None: ...
    def updateBounds(self) -> None: ...
    def refresh(self) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def ungroupItems(self, group: QgsLayoutItemGroup) -> List[QgsLayoutItem]: ...
    def groupItems(self, items: Iterable[QgsLayoutItem]) -> QgsLayoutItemGroup: ...
    def createCommand(self, text: str, id: int = ..., parent: Optional[QtWidgets.QUndoCommand] = ...) -> QgsAbstractLayoutUndoCommand: ...
    def undoStack(self) -> QgsLayoutUndoStack: ...
    def addItemsFromXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext, position: Optional[Union[QtCore.QPointF, QtCore.QPoint, float]] = ..., pasteInPlace: bool = ...) -> List[QgsLayoutItem]: ...
    def readXml(self, layoutElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def loadFromTemplate(self, document: QtXml.QDomDocument, context: QgsReadWriteContext, clearExisting: bool = ...) -> Tuple[List[QgsLayoutItem], bool]: ...
    def saveAsTemplate(self, path: str, context: QgsReadWriteContext) -> bool: ...
    def multiFrames(self) -> List[QgsLayoutMultiFrame]: ...
    def removeMultiFrame(self, multiFrame: QgsLayoutMultiFrame) -> None: ...
    def addMultiFrame(self, multiFrame: QgsLayoutMultiFrame) -> None: ...
    def removeLayoutItem(self, item: QgsLayoutItem) -> None: ...
    def addLayoutItem(self, item: QgsLayoutItem) -> None: ...
    def pageItemBounds(self, page: int, visibleOnly: bool = ...) -> QtCore.QRectF: ...
    def layoutBounds(self, ignorePages: bool = ..., margin: float = ...) -> QtCore.QRectF: ...
    def pageCollection(self) -> QgsLayoutPageCollection: ...
    def setReferenceMap(self, map: QgsLayoutItemMap) -> None: ...
    def referenceMap(self) -> QgsLayoutItemMap: ...
    def customProperties(self) -> List[str]: ...
    def removeCustomProperty(self, key: str) -> None: ...
    def customProperty(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setCustomProperty(self, key: str, value: typing.Any) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def guides(self) -> QgsLayoutGuideCollection: ...
    def reloadSettings(self) -> None: ...
    def gridSettings(self) -> QgsLayoutGridSettings: ...
    def snapper(self) -> QgsLayoutSnapper: ...
    def reportContext(self) -> QgsLayoutReportContext: ...
    def renderContext(self) -> QgsLayoutRenderContext: ...
    @overload
    def convertFromLayoutUnits(self, length: float, unit: QgsUnitTypes.LayoutUnit) -> QgsLayoutMeasurement: ...
    @overload
    def convertFromLayoutUnits(self, size: QtCore.QSizeF, unit: QgsUnitTypes.LayoutUnit) -> QgsLayoutSize: ...
    @overload
    def convertFromLayoutUnits(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], unit: QgsUnitTypes.LayoutUnit) -> QgsLayoutPoint: ...
    @overload
    def convertToLayoutUnits(self, measurement: QgsLayoutMeasurement) -> float: ...
    @overload
    def convertToLayoutUnits(self, size: QgsLayoutSize) -> QtCore.QSizeF: ...
    @overload
    def convertToLayoutUnits(self, point: QgsLayoutPoint) -> QtCore.QPointF: ...
    def units(self) -> QgsUnitTypes.LayoutUnit: ...
    def setUnits(self, units: QgsUnitTypes.LayoutUnit) -> None: ...
    @overload
    def layoutItemAt(self, position: Union[QtCore.QPointF, QtCore.QPoint, float], ignoreLocked: bool = ...) -> QgsLayoutItem: ...
    @overload
    def layoutItemAt(self, position: Union[QtCore.QPointF, QtCore.QPoint, float], belowItem: QgsLayoutItem, ignoreLocked: bool = ...) -> QgsLayoutItem: ...
    def multiFrameByUuid(self, uuid: str, includeTemplateUuids: bool = ...) -> QgsLayoutMultiFrame: ...
    def itemById(self, id: str) -> QgsLayoutItem: ...
    def itemByTemplateUuid(self, uuid: str) -> QgsLayoutItem: ...
    def itemByUuid(self, uuid: str, includeTemplateUuids: bool = ...) -> QgsLayoutItem: ...
    def updateZValues(self, addUndoCommands: bool = ...) -> None: ...
    def moveItemToBottom(self, item: QgsLayoutItem, deferUpdate: bool = ...) -> bool: ...
    def moveItemToTop(self, item: QgsLayoutItem, deferUpdate: bool = ...) -> bool: ...
    def lowerItem(self, item: QgsLayoutItem, deferUpdate: bool = ...) -> bool: ...
    def raiseItem(self, item: QgsLayoutItem, deferUpdate: bool = ...) -> bool: ...
    def deselectAll(self) -> None: ...
    def setSelectedItem(self, item: QgsLayoutItem) -> None: ...
    def selectedLayoutItems(self, includeLockedItems: bool = ...) -> List[QgsLayoutItem]: ...
    def itemsModel(self) -> QgsLayoutModel: ...
    def project(self) -> QgsProject: ...
    def clear(self) -> None: ...
    def initializeDefaults(self) -> None: ...
    def clone(self) -> QgsLayout: ...


class QgsLayoutAligner(sip.wrapper):

    class Resize(int):
        ...
    ResizeNarrowest: QgsLayoutAligner.Resize = ...
    ResizeWidest: QgsLayoutAligner.Resize = ...
    ResizeShortest: QgsLayoutAligner.Resize = ...
    ResizeTallest: QgsLayoutAligner.Resize = ...
    ResizeToSquare: QgsLayoutAligner.Resize = ...

    class Distribution(int):
        ...
    DistributeLeft: QgsLayoutAligner.Distribution = ...
    DistributeHCenter: QgsLayoutAligner.Distribution = ...
    DistributeHSpace: QgsLayoutAligner.Distribution = ...
    DistributeRight: QgsLayoutAligner.Distribution = ...
    DistributeTop: QgsLayoutAligner.Distribution = ...
    DistributeVCenter: QgsLayoutAligner.Distribution = ...
    DistributeVSpace: QgsLayoutAligner.Distribution = ...
    DistributeBottom: QgsLayoutAligner.Distribution = ...

    class Alignment(int):
        ...
    AlignLeft: QgsLayoutAligner.Alignment = ...
    AlignHCenter: QgsLayoutAligner.Alignment = ...
    AlignRight: QgsLayoutAligner.Alignment = ...
    AlignTop: QgsLayoutAligner.Alignment = ...
    AlignVCenter: QgsLayoutAligner.Alignment = ...
    AlignBottom: QgsLayoutAligner.Alignment = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutAligner) -> None: ...

    @staticmethod
    def resizeItems(layout: QgsLayout, items: Iterable[QgsLayoutItem], resize: QgsLayoutAligner.Resize) -> None: ...
    @staticmethod
    def distributeItems(layout: QgsLayout, items: Iterable[QgsLayoutItem], distribution: QgsLayoutAligner.Distribution) -> None: ...
    @staticmethod
    def alignItems(layout: QgsLayout, items: Iterable[QgsLayoutItem], alignment: QgsLayoutAligner.Alignment) -> None: ...


class QgsLayoutSerializableObject(QgsLayoutUndoObjectInterface):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutSerializableObject) -> None: ...

    def createCommand(self, text: str, id: int, parent: Optional[QtWidgets.QUndoCommand] = ...) -> QgsAbstractLayoutUndoCommand: ...
    def readXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def layout(self) -> QgsLayout: ...
    def stringType(self) -> str: ...


class QgsLayoutAtlas(QtCore.QObject, QgsAbstractLayoutIterator, QgsLayoutSerializableObject, QgsExpressionContextGenerator):

    def __init__(self, layout: QgsLayout) -> None: ...

    def renderEnded(self) -> None: ...
    def renderBegun(self) -> None: ...
    def featureChanged(self, feature: QgsFeature) -> None: ...
    def numberFeaturesChanged(self, numFeatures: int) -> None: ...
    def messagePushed(self, message: str) -> None: ...
    def coverageLayerChanged(self, layer: QgsVectorLayer) -> None: ...
    def toggled(self, a0: bool) -> None: ...
    def changed(self) -> None: ...
    def refreshCurrentFeature(self) -> None: ...
    @overload
    def seekTo(self, feature: int) -> bool: ...
    @overload
    def seekTo(self, feature: QgsFeature) -> bool: ...
    def first(self) -> bool: ...
    def last(self) -> bool: ...
    def previous(self) -> bool: ...
    def next(self) -> bool: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def currentFeatureNumber(self) -> int: ...
    def filePath(self, baseFilePath: str, extension: str) -> str: ...
    def count(self) -> int: ...
    def endRender(self) -> bool: ...
    def beginRender(self) -> bool: ...
    def updateFeatures(self) -> int: ...
    def setFilterExpression(self, expression: str) -> Tuple[bool, str]: ...
    def filterExpression(self) -> str: ...
    def setFilterFeatures(self, filtered: bool) -> None: ...
    def filterFeatures(self) -> bool: ...
    def setSortExpression(self, expression: str) -> None: ...
    def sortExpression(self) -> str: ...
    def setSortAscending(self, ascending: bool) -> None: ...
    def sortAscending(self) -> bool: ...
    def setSortFeatures(self, enabled: bool) -> None: ...
    def sortFeatures(self) -> bool: ...
    def nameForPage(self, page: int) -> str: ...
    def setPageNameExpression(self, expression: str) -> None: ...
    def pageNameExpression(self) -> str: ...
    def setCoverageLayer(self, layer: QgsVectorLayer) -> None: ...
    def coverageLayer(self) -> QgsVectorLayer: ...
    def currentFilename(self) -> str: ...
    def setFilenameExpression(self, expression: str) -> Tuple[bool, str]: ...
    def filenameExpression(self) -> str: ...
    def setHideCoverage(self, hide: bool) -> None: ...
    def hideCoverage(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def layout(self) -> QgsLayout: ...
    def stringType(self) -> str: ...


class QgsLayoutEffect(QtWidgets.QGraphicsEffect):

    def __init__(self) -> None: ...

    def draw(self, painter: QtGui.QPainter) -> None: ...
    def compositionMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setCompositionMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...


class QgsLayoutExporter(sip.wrapper):

    class ExportResult(int):
        ...
    Success: QgsLayoutExporter.ExportResult = ...
    Canceled: QgsLayoutExporter.ExportResult = ...
    MemoryError: QgsLayoutExporter.ExportResult = ...
    FileError: QgsLayoutExporter.ExportResult = ...
    PrintError: QgsLayoutExporter.ExportResult = ...
    SvgLayerError: QgsLayoutExporter.ExportResult = ...
    IteratorError: QgsLayoutExporter.ExportResult = ...

    class PageExportDetails(sip.wrapper):

        baseName: str = ...
        directory: str = ...
        extension: str = ...
        page: int = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutExporter.PageExportDetails) -> None: ...

    class ImageExportSettings(sip.wrapper):

        cropMargins: QgsMargins = ...
        cropToContents: bool = ...
        dpi: float = ...
        exportMetadata: bool = ...
        flags: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag] = ...
        generateWorldFile: bool = ...
        imageSize: QtCore.QSize = ...
        pages: Iterable[int] = ...
        predefinedMapScales: Iterable[float] = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutExporter.ImageExportSettings) -> None: ...

    class PdfExportSettings(sip.wrapper):

        appendGeoreference: bool = ...
        dpi: float = ...
        exportLayersAsSeperateFiles: bool = ...
        exportMetadata: bool = ...
        exportThemes: Iterable[str] = ...
        flags: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag] = ...
        forceVectorOutput: bool = ...
        includeGeoPdfFeatures: bool = ...
        predefinedMapScales: Iterable[float] = ...
        rasterizeWholeImage: bool = ...
        simplifyGeometries: bool = ...
        textRenderFormat: QgsRenderContext.TextRenderFormat = ...
        useIso32000ExtensionFormatGeoreferencing: bool = ...
        useOgcBestPracticeFormatGeoreferencing: bool = ...
        writeGeoPdf: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutExporter.PdfExportSettings) -> None: ...

    class PrintExportSettings(sip.wrapper):

        dpi: float = ...
        flags: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag] = ...
        predefinedMapScales: Iterable[float] = ...
        rasterizeWholeImage: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutExporter.PrintExportSettings) -> None: ...

    class SvgExportSettings(sip.wrapper):

        cropMargins: QgsMargins = ...
        cropToContents: bool = ...
        dpi: float = ...
        exportAsLayers: bool = ...
        exportLabelsToSeparateLayers: bool = ...
        exportMetadata: bool = ...
        flags: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag] = ...
        forceVectorOutput: bool = ...
        predefinedMapScales: Iterable[float] = ...
        simplifyGeometries: bool = ...
        textRenderFormat: QgsRenderContext.TextRenderFormat = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutExporter.SvgExportSettings) -> None: ...

    @overload
    def __init__(self, layout: QgsLayout) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutExporter) -> None: ...

    def generateFileName(self, details: QgsLayoutExporter.PageExportDetails) -> str: ...
    @staticmethod
    def containsAdvancedEffects(layout: QgsLayout) -> bool: ...
    @staticmethod
    def requiresRasterization(layout: QgsLayout) -> bool: ...
    @overload
    def computeWorldFileParameters(self, dpi: float = ...) -> Tuple[float, float, float, float, float, float]: ...
    @overload
    def computeWorldFileParameters(self, region: QtCore.QRectF, dpi: float = ...) -> Tuple[float, float, float, float, float, float]: ...
    def georeferenceOutput(self, file: str, referenceMap: Optional[QgsLayoutItemMap] = ..., exportRegion: QtCore.QRectF = ..., dpi: float = ...) -> bool: ...
    def errorFile(self) -> str: ...
    @overload
    def exportToSvg(self, filePath: str, settings: QgsLayoutExporter.SvgExportSettings) -> QgsLayoutExporter.ExportResult: ...
    @overload
    @staticmethod
    def exportToSvg(iterator: QgsAbstractLayoutIterator, baseFilePath: str, settings: QgsLayoutExporter.SvgExportSettings, feedback: Optional[QgsFeedback] = ...) -> Tuple[QgsLayoutExporter.ExportResult, str]: ...
    @overload
    def print(self, printer: QtPrintSupport.QPrinter, settings: QgsLayoutExporter.PrintExportSettings) -> QgsLayoutExporter.ExportResult: ...
    @overload
    @staticmethod
    def print(iterator: QgsAbstractLayoutIterator, printer: QtPrintSupport.QPrinter, settings: QgsLayoutExporter.PrintExportSettings, feedback: Optional[QgsFeedback] = ...) -> Tuple[QgsLayoutExporter.ExportResult, str]: ...
    @staticmethod
    def exportToPdfs(iterator: QgsAbstractLayoutIterator, baseFilePath: str, settings: QgsLayoutExporter.PdfExportSettings, feedback: Optional[QgsFeedback] = ...) -> Tuple[QgsLayoutExporter.ExportResult, str]: ...
    @overload
    def exportToPdf(self, filePath: str, settings: QgsLayoutExporter.PdfExportSettings) -> QgsLayoutExporter.ExportResult: ...
    @overload
    @staticmethod
    def exportToPdf(iterator: QgsAbstractLayoutIterator, fileName: str, settings: QgsLayoutExporter.PdfExportSettings, feedback: Optional[QgsFeedback] = ...) -> Tuple[QgsLayoutExporter.ExportResult, str]: ...
    @overload
    def exportToImage(self, filePath: str, settings: QgsLayoutExporter.ImageExportSettings) -> QgsLayoutExporter.ExportResult: ...
    @overload
    @staticmethod
    def exportToImage(iterator: QgsAbstractLayoutIterator, baseFilePath: str, extension: str, settings: QgsLayoutExporter.ImageExportSettings, feedback: Optional[QgsFeedback] = ...) -> Tuple[QgsLayoutExporter.ExportResult, str]: ...
    def renderRegionToImage(self, region: QtCore.QRectF, imageSize: QtCore.QSize = ..., dpi: float = ...) -> QtGui.QImage: ...
    def renderRegion(self, painter: QtGui.QPainter, region: QtCore.QRectF) -> None: ...
    def renderPageToImage(self, page: int, imageSize: QtCore.QSize = ..., dpi: float = ...) -> QtGui.QImage: ...
    def renderPage(self, painter: QtGui.QPainter, page: int) -> None: ...
    def layout(self) -> QgsLayout: ...


class QgsLayoutObject(QtCore.QObject, QgsExpressionContextGenerator):

    class PropertyValueType(int):
        ...
    EvaluatedValue: QgsLayoutObject.PropertyValueType = ...
    OriginalValue: QgsLayoutObject.PropertyValueType = ...

    class DataDefinedProperty(int):
        ...
    NoProperty: QgsLayoutObject.DataDefinedProperty = ...
    AllProperties: QgsLayoutObject.DataDefinedProperty = ...
    TestProperty: QgsLayoutObject.DataDefinedProperty = ...
    PresetPaperSize: QgsLayoutObject.DataDefinedProperty = ...
    PaperWidth: QgsLayoutObject.DataDefinedProperty = ...
    PaperHeight: QgsLayoutObject.DataDefinedProperty = ...
    NumPages: QgsLayoutObject.DataDefinedProperty = ...
    PaperOrientation: QgsLayoutObject.DataDefinedProperty = ...
    PageNumber: QgsLayoutObject.DataDefinedProperty = ...
    PositionX: QgsLayoutObject.DataDefinedProperty = ...
    PositionY: QgsLayoutObject.DataDefinedProperty = ...
    ItemWidth: QgsLayoutObject.DataDefinedProperty = ...
    ItemHeight: QgsLayoutObject.DataDefinedProperty = ...
    ItemRotation: QgsLayoutObject.DataDefinedProperty = ...
    Transparency: QgsLayoutObject.DataDefinedProperty = ...
    Opacity: QgsLayoutObject.DataDefinedProperty = ...
    BlendMode: QgsLayoutObject.DataDefinedProperty = ...
    ExcludeFromExports: QgsLayoutObject.DataDefinedProperty = ...
    FrameColor: QgsLayoutObject.DataDefinedProperty = ...
    BackgroundColor: QgsLayoutObject.DataDefinedProperty = ...
    MapRotation: QgsLayoutObject.DataDefinedProperty = ...
    MapScale: QgsLayoutObject.DataDefinedProperty = ...
    MapXMin: QgsLayoutObject.DataDefinedProperty = ...
    MapYMin: QgsLayoutObject.DataDefinedProperty = ...
    MapXMax: QgsLayoutObject.DataDefinedProperty = ...
    MapYMax: QgsLayoutObject.DataDefinedProperty = ...
    MapAtlasMargin: QgsLayoutObject.DataDefinedProperty = ...
    MapLayers: QgsLayoutObject.DataDefinedProperty = ...
    MapStylePreset: QgsLayoutObject.DataDefinedProperty = ...
    MapLabelMargin: QgsLayoutObject.DataDefinedProperty = ...
    MapGridEnabled: QgsLayoutObject.DataDefinedProperty = ...
    MapGridIntervalX: QgsLayoutObject.DataDefinedProperty = ...
    MapGridIntervalY: QgsLayoutObject.DataDefinedProperty = ...
    MapGridOffsetX: QgsLayoutObject.DataDefinedProperty = ...
    MapGridOffsetY: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameSize: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameMargin: QgsLayoutObject.DataDefinedProperty = ...
    MapGridLabelDistance: QgsLayoutObject.DataDefinedProperty = ...
    MapGridCrossSize: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameLineThickness: QgsLayoutObject.DataDefinedProperty = ...
    MapGridAnnotationDisplayLeft: QgsLayoutObject.DataDefinedProperty = ...
    MapGridAnnotationDisplayRight: QgsLayoutObject.DataDefinedProperty = ...
    MapGridAnnotationDisplayTop: QgsLayoutObject.DataDefinedProperty = ...
    MapGridAnnotationDisplayBottom: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameDivisionsLeft: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameDivisionsRight: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameDivisionsTop: QgsLayoutObject.DataDefinedProperty = ...
    MapGridFrameDivisionsBottom: QgsLayoutObject.DataDefinedProperty = ...
    PictureSource: QgsLayoutObject.DataDefinedProperty = ...
    PictureSvgBackgroundColor: QgsLayoutObject.DataDefinedProperty = ...
    PictureSvgStrokeColor: QgsLayoutObject.DataDefinedProperty = ...
    PictureSvgStrokeWidth: QgsLayoutObject.DataDefinedProperty = ...
    SourceUrl: QgsLayoutObject.DataDefinedProperty = ...
    LegendTitle: QgsLayoutObject.DataDefinedProperty = ...
    LegendColumnCount: QgsLayoutObject.DataDefinedProperty = ...
    ScalebarFillColor: QgsLayoutObject.DataDefinedProperty = ...
    ScalebarFillColor2: QgsLayoutObject.DataDefinedProperty = ...
    ScalebarLineColor: QgsLayoutObject.DataDefinedProperty = ...
    ScalebarLineWidth: QgsLayoutObject.DataDefinedProperty = ...
    AttributeTableSourceLayer: QgsLayoutObject.DataDefinedProperty = ...
    MapCrs: QgsLayoutObject.DataDefinedProperty = ...
    StartDateTime: QgsLayoutObject.DataDefinedProperty = ...
    EndDateTime: QgsLayoutObject.DataDefinedProperty = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readObjectPropertiesFromElement(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeObjectPropertiesToElement(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def changed(self) -> None: ...
    def refresh(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def customProperties(self) -> List[str]: ...
    def removeCustomProperty(self, key: str) -> None: ...
    def customProperty(self, key: str, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setCustomProperty(self, key: str, value: typing.Any) -> None: ...
    def setDataDefinedProperties(self, collection: QgsPropertyCollection) -> None: ...
    def dataDefinedProperties(self) -> QgsPropertyCollection: ...
    def layout(self) -> QgsLayout: ...
    @staticmethod
    def propertyAssociatesWithParentMultiframe(property: QgsLayoutObject.DataDefinedProperty) -> bool: ...
    @staticmethod
    def propertyDefinitions() -> Dict[int, QgsPropertyDefinition]: ...


class QgsLayoutItem(QgsLayoutObject, QtWidgets.QGraphicsRectItem, QgsLayoutUndoObjectInterface):

    class ExportLayerBehavior(int):
        ...
    CanGroupWithAnyOtherItem: QgsLayoutItem.ExportLayerBehavior = ...
    CanGroupWithItemsOfSameType: QgsLayoutItem.ExportLayerBehavior = ...
    MustPlaceInOwnLayer: QgsLayoutItem.ExportLayerBehavior = ...
    ItemContainsSubLayers: QgsLayoutItem.ExportLayerBehavior = ...

    class Flag(int):
        ...
    FlagOverridesPaint: QgsLayoutItem.Flag = ...
    FlagProvidesClipPath: QgsLayoutItem.Flag = ...

    class UndoCommand(int):
        ...
    UndoNone: QgsLayoutItem.UndoCommand = ...
    UndoIncrementalMove: QgsLayoutItem.UndoCommand = ...
    UndoIncrementalResize: QgsLayoutItem.UndoCommand = ...
    UndoStrokeColor: QgsLayoutItem.UndoCommand = ...
    UndoStrokeWidth: QgsLayoutItem.UndoCommand = ...
    UndoBackgroundColor: QgsLayoutItem.UndoCommand = ...
    UndoOpacity: QgsLayoutItem.UndoCommand = ...
    UndoSetId: QgsLayoutItem.UndoCommand = ...
    UndoRotation: QgsLayoutItem.UndoCommand = ...
    UndoShapeStyle: QgsLayoutItem.UndoCommand = ...
    UndoShapeCornerRadius: QgsLayoutItem.UndoCommand = ...
    UndoNodeMove: QgsLayoutItem.UndoCommand = ...
    UndoAtlasMargin: QgsLayoutItem.UndoCommand = ...
    UndoMapRotation: QgsLayoutItem.UndoCommand = ...
    UndoZoomContent: QgsLayoutItem.UndoCommand = ...
    UndoOverviewStyle: QgsLayoutItem.UndoCommand = ...
    UndoGridFramePenColor: QgsLayoutItem.UndoCommand = ...
    UndoMapGridFrameFill1Color: QgsLayoutItem.UndoCommand = ...
    UndoMapGridFrameFill2Color: QgsLayoutItem.UndoCommand = ...
    UndoMapAnnotationDistance: QgsLayoutItem.UndoCommand = ...
    UndoMapGridAnnotationFontColor: QgsLayoutItem.UndoCommand = ...
    UndoMapGridLineSymbol: QgsLayoutItem.UndoCommand = ...
    UndoMapGridMarkerSymbol: QgsLayoutItem.UndoCommand = ...
    UndoMapGridIntervalRange: QgsLayoutItem.UndoCommand = ...
    UndoMapLabelMargin: QgsLayoutItem.UndoCommand = ...
    UndoPictureRotation: QgsLayoutItem.UndoCommand = ...
    UndoPictureFillColor: QgsLayoutItem.UndoCommand = ...
    UndoPictureStrokeColor: QgsLayoutItem.UndoCommand = ...
    UndoPictureStrokeWidth: QgsLayoutItem.UndoCommand = ...
    UndoPictureNorthOffset: QgsLayoutItem.UndoCommand = ...
    UndoLabelText: QgsLayoutItem.UndoCommand = ...
    UndoLabelFont: QgsLayoutItem.UndoCommand = ...
    UndoLabelMargin: QgsLayoutItem.UndoCommand = ...
    UndoLabelFontColor: QgsLayoutItem.UndoCommand = ...
    UndoLegendText: QgsLayoutItem.UndoCommand = ...
    UndoLegendColumnCount: QgsLayoutItem.UndoCommand = ...
    UndoLegendSymbolWidth: QgsLayoutItem.UndoCommand = ...
    UndoLegendSymbolHeight: QgsLayoutItem.UndoCommand = ...
    UndoLegendMaxSymbolSize: QgsLayoutItem.UndoCommand = ...
    UndoLegendMinSymbolSize: QgsLayoutItem.UndoCommand = ...
    UndoLegendWmsLegendWidth: QgsLayoutItem.UndoCommand = ...
    UndoLegendWmsLegendHeight: QgsLayoutItem.UndoCommand = ...
    UndoLegendTitleSpaceBottom: QgsLayoutItem.UndoCommand = ...
    UndoLegendGroupSpace: QgsLayoutItem.UndoCommand = ...
    UndoLegendLayerSpace: QgsLayoutItem.UndoCommand = ...
    UndoLegendSymbolSpace: QgsLayoutItem.UndoCommand = ...
    UndoLegendIconSymbolSpace: QgsLayoutItem.UndoCommand = ...
    UndoLegendFontColor: QgsLayoutItem.UndoCommand = ...
    UndoLegendBoxSpace: QgsLayoutItem.UndoCommand = ...
    UndoLegendColumnSpace: QgsLayoutItem.UndoCommand = ...
    UndoLegendLineSpacing: QgsLayoutItem.UndoCommand = ...
    UndoLegendRasterStrokeWidth: QgsLayoutItem.UndoCommand = ...
    UndoLegendRasterStrokeColor: QgsLayoutItem.UndoCommand = ...
    UndoLegendTitleFont: QgsLayoutItem.UndoCommand = ...
    UndoLegendGroupFont: QgsLayoutItem.UndoCommand = ...
    UndoLegendLayerFont: QgsLayoutItem.UndoCommand = ...
    UndoLegendItemFont: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarLineWidth: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarSegmentSize: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarSegmentsLeft: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarSegments: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarHeight: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarSubdivisions: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarSubdivisionsHeight: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarFontColor: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarFillColor: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarFillColor2: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarStrokeColor: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarUnitText: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarMapUnitsSegment: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarLabelBarSize: QgsLayoutItem.UndoCommand = ...
    UndoScaleBarBoxContentSpace: QgsLayoutItem.UndoCommand = ...
    UndoArrowStrokeWidth: QgsLayoutItem.UndoCommand = ...
    UndoArrowHeadWidth: QgsLayoutItem.UndoCommand = ...
    UndoArrowHeadFillColor: QgsLayoutItem.UndoCommand = ...
    UndoArrowHeadStrokeColor: QgsLayoutItem.UndoCommand = ...
    UndoCustomCommand: QgsLayoutItem.UndoCommand = ...

    class ReferencePoint(int):
        ...
    UpperLeft: QgsLayoutItem.ReferencePoint = ...
    UpperMiddle: QgsLayoutItem.ReferencePoint = ...
    UpperRight: QgsLayoutItem.ReferencePoint = ...
    MiddleLeft: QgsLayoutItem.ReferencePoint = ...
    Middle: QgsLayoutItem.ReferencePoint = ...
    MiddleRight: QgsLayoutItem.ReferencePoint = ...
    LowerLeft: QgsLayoutItem.ReferencePoint = ...
    LowerMiddle: QgsLayoutItem.ReferencePoint = ...
    LowerRight: QgsLayoutItem.ReferencePoint = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLayoutItem.Flags, QgsLayoutItem.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutItem.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLayoutItem.Flags: ...
        def __int__(self) -> int: ...

    class ExportLayerDetail(sip.wrapper):

        compositionMode: QtGui.QPainter.CompositionMode = ...
        mapLayerId: str = ...
        mapTheme: str = ...
        name: str = ...
        opacity: float = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutItem.ExportLayerDetail) -> None: ...

    def __init__(self, layout: QgsLayout, manageZValue: bool = ...) -> None: ...

    def applyDataDefinedSize(self, size: QgsLayoutSize) -> QgsLayoutSize: ...
    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def topLeftToReferencePoint(self, point: QgsLayoutPoint) -> QgsLayoutPoint: ...
    def positionAtReferencePoint(self, reference: QgsLayoutItem.ReferencePoint) -> QtCore.QPointF: ...
    def adjustPointForReferencePosition(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], size: QtCore.QSizeF, reference: QgsLayoutItem.ReferencePoint) -> QtCore.QPointF: ...
    def refreshBlendMode(self) -> None: ...
    def refreshBackgroundColor(self, updateItem: bool = ...) -> None: ...
    def refreshFrame(self, updateItem: bool = ...) -> None: ...
    def refreshOpacity(self, updateItem: bool = ...) -> None: ...
    def refreshItemRotation(self, origin: Optional[Union[QtCore.QPointF, QtCore.QPoint, float]] = ...) -> None: ...
    def refreshItemPosition(self) -> None: ...
    def refreshItemSize(self) -> None: ...
    def applyItemSizeConstraint(self, targetSize: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def setMinimumSize(self, size: QgsLayoutSize) -> None: ...
    def setFixedSize(self, size: QgsLayoutSize) -> None: ...
    def drawBackground(self, context: QgsRenderContext) -> None: ...
    def drawFrame(self, context: QgsRenderContext) -> None: ...
    def framePath(self) -> QtGui.QPainterPath: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def drawDebugRect(self, painter: QtGui.QPainter) -> None: ...
    def clipPathChanged(self) -> None: ...
    def backgroundTaskCountChanged(self, count: int) -> None: ...
    def sizePositionChanged(self) -> None: ...
    def rotationChanged(self, newRotation: float) -> None: ...
    def lockChanged(self) -> None: ...
    def frameChanged(self) -> None: ...
    def rotateItem(self, angle: float, transformOrigin: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def setItemRotation(self, rotation: float, adjustPosition: bool = ...) -> None: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def redraw(self) -> None: ...
    def invalidateCache(self) -> None: ...
    def refresh(self) -> None: ...
    def clipPath(self) -> QgsGeometry: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def shouldDrawItem(self) -> bool: ...
    def cancelCommand(self) -> None: ...
    def endCommand(self) -> None: ...
    def beginCommand(self, commandText: str, command: QgsLayoutItem.UndoCommand = ...) -> None: ...
    def zoomContent(self, factor: float, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def setMoveContentPreviewOffset(self, dx: float, dy: float) -> None: ...
    def moveContent(self, dx: float, dy: float) -> None: ...
    def rectWithFrame(self) -> QtCore.QRectF: ...
    def estimatedFrameBleed(self) -> float: ...
    def requiresRasterization(self) -> bool: ...
    def containsAdvancedEffects(self) -> bool: ...
    def setExcludeFromExports(self, exclude: bool) -> None: ...
    def excludeFromExports(self) -> bool: ...
    def setItemOpacity(self, opacity: float) -> None: ...
    def itemOpacity(self) -> float: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBackgroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundEnabled(self, drawBackground: bool) -> None: ...
    def hasBackground(self) -> bool: ...
    def setFrameJoinStyle(self, style: QtCore.Qt.PenJoinStyle) -> None: ...
    def frameJoinStyle(self) -> QtCore.Qt.PenJoinStyle: ...
    def frameStrokeWidth(self) -> QgsLayoutMeasurement: ...
    def setFrameStrokeWidth(self, width: QgsLayoutMeasurement) -> None: ...
    def frameStrokeColor(self) -> QtGui.QColor: ...
    def setFrameStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setFrameEnabled(self, drawFrame: bool) -> None: ...
    def frameEnabled(self) -> bool: ...
    def createCommand(self, text: str, id: int, parent: Optional[QtWidgets.QUndoCommand] = ...) -> QgsAbstractLayoutUndoCommand: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def readXml(self, itemElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def itemRotation(self) -> float: ...
    def sizeWithUnits(self) -> QgsLayoutSize: ...
    def pagePositionWithUnits(self) -> QgsLayoutPoint: ...
    def pagePos(self) -> QtCore.QPointF: ...
    def page(self) -> int: ...
    def positionWithUnits(self) -> QgsLayoutPoint: ...
    def attemptMoveBy(self, deltaX: float, deltaY: float) -> None: ...
    def attemptSetSceneRect(self, rect: QtCore.QRectF, includesFrame: bool = ...) -> None: ...
    def attemptMove(self, point: QgsLayoutPoint, useReferencePoint: bool = ..., includesFrame: bool = ..., page: int = ...) -> None: ...
    def attemptResize(self, size: QgsLayoutSize, includesFrame: bool = ...) -> None: ...
    def minimumSize(self) -> QgsLayoutSize: ...
    def fixedSize(self) -> QgsLayoutSize: ...
    def referencePoint(self) -> QgsLayoutItem.ReferencePoint: ...
    def setReferencePoint(self, point: QgsLayoutItem.ReferencePoint) -> None: ...
    def paint(self, painter: QtGui.QPainter, itemStyle: QtWidgets.QStyleOptionGraphicsItem, pWidget: QtWidgets.QWidget) -> None: ...
    def exportLayerDetails(self) -> QgsLayoutItem.ExportLayerDetail: ...
    def nextExportPart(self) -> bool: ...
    def stopLayeredExport(self) -> None: ...
    def startLayeredExport(self) -> None: ...
    def numberExportLayers(self) -> int: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def setParentGroup(self, group: QgsLayoutItemGroup) -> None: ...
    def parentGroup(self) -> QgsLayoutItemGroup: ...
    def isGroupMember(self) -> bool: ...
    def isLocked(self) -> bool: ...
    def setLocked(self, locked: bool) -> None: ...
    def setVisibility(self, visible: bool) -> None: ...
    def setSelected(self, selected: bool) -> None: ...
    def displayName(self) -> str: ...
    def setId(self, id: str) -> None: ...
    def id(self) -> str: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def uuid(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    def cleanup(self) -> None: ...


class QgsLayoutFrame(QgsLayoutItem):

    def __init__(self, layout: QgsLayout, multiFrame: QgsLayoutMultiFrame) -> None: ...

    def readPropertiesFromElement(self, itemElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def drawBackground(self, context: QgsRenderContext) -> None: ...
    def drawFrame(self, context: QgsRenderContext) -> None: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def isEmpty(self) -> bool: ...
    def setHideBackgroundIfEmpty(self, hideBackgroundIfEmpty: bool) -> None: ...
    def hideBackgroundIfEmpty(self) -> bool: ...
    def setHidePageIfEmpty(self, hidePageIfEmpty: bool) -> None: ...
    def hidePageIfEmpty(self) -> bool: ...
    def extent(self) -> QtCore.QRectF: ...
    def fixedSize(self) -> QgsLayoutSize: ...
    def minimumSize(self) -> QgsLayoutSize: ...
    def multiFrame(self) -> QgsLayoutMultiFrame: ...
    def setContentSection(self, section: QtCore.QRectF) -> None: ...
    def cleanup(self) -> None: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutFrame: ...


class QgsLayoutGridSettings(QgsLayoutSerializableObject):

    class Style(int):
        ...
    StyleLines: QgsLayoutGridSettings.Style = ...
    StyleDots: QgsLayoutGridSettings.Style = ...
    StyleCrosses: QgsLayoutGridSettings.Style = ...

    @overload
    def __init__(self, layout: QgsLayout) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutGridSettings) -> None: ...

    def readXml(self, gridElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def loadFromSettings(self) -> None: ...
    def style(self) -> QgsLayoutGridSettings.Style: ...
    def setStyle(self, style: QgsLayoutGridSettings.Style) -> None: ...
    def pen(self) -> QtGui.QPen: ...
    def setPen(self, pen: Union[QtGui.QPen, QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def offset(self) -> QgsLayoutPoint: ...
    def setOffset(self, offset: QgsLayoutPoint) -> None: ...
    def resolution(self) -> QgsLayoutMeasurement: ...
    def setResolution(self, resolution: QgsLayoutMeasurement) -> None: ...
    def layout(self) -> QgsLayout: ...
    def stringType(self) -> str: ...


class QgsLayoutGuide(QtCore.QObject):

    def __init__(self, orientation: QtCore.Qt.Orientation, position: QgsLayoutMeasurement, page: QgsLayoutItemPage) -> None: ...

    def positionChanged(self) -> None: ...
    def setLayoutPosition(self, position: float) -> None: ...
    def layoutPosition(self) -> float: ...
    def item(self) -> QtWidgets.QGraphicsLineItem: ...
    def update(self) -> None: ...
    def setPage(self, page: QgsLayoutItemPage) -> None: ...
    def page(self) -> QgsLayoutItemPage: ...
    def setPosition(self, position: QgsLayoutMeasurement) -> None: ...
    def position(self) -> QgsLayoutMeasurement: ...
    def orientation(self) -> QtCore.Qt.Orientation: ...
    def setLayout(self, layout: QgsLayout) -> None: ...
    def layout(self) -> QgsLayout: ...


class QgsLayoutGuideCollection(QtCore.QAbstractTableModel, QgsLayoutSerializableObject):

    class Roles(int):
        ...
    OrientationRole: QgsLayoutGuideCollection.Roles = ...
    PositionRole: QgsLayoutGuideCollection.Roles = ...
    UnitsRole: QgsLayoutGuideCollection.Roles = ...
    PageRole: QgsLayoutGuideCollection.Roles = ...
    LayoutPositionRole: QgsLayoutGuideCollection.Roles = ...

    def __init__(self, layout: QgsLayout, pageCollection: QgsLayoutPageCollection) -> None: ...

    def readXml(self, collectionElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def setVisible(self, visible: bool) -> None: ...
    def visible(self) -> bool: ...
    def guidesOnPage(self, page: int) -> List[QgsLayoutGuide]: ...
    @overload
    def guides(self) -> List[QgsLayoutGuide]: ...
    @overload
    def guides(self, orientation: QtCore.Qt.Orientation, page: int = ...) -> List[QgsLayoutGuide]: ...
    def update(self) -> None: ...
    def applyGuidesToAllOtherPages(self, sourcePage: int) -> None: ...
    def clear(self) -> None: ...
    def setGuideLayoutPosition(self, guide: QgsLayoutGuide, position: float) -> None: ...
    def removeGuide(self, guide: QgsLayoutGuide) -> None: ...
    def addGuide(self, guide: QgsLayoutGuide) -> None: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, a0: QtCore.QModelIndex) -> int: ...
    def rowCount(self, a0: QtCore.QModelIndex) -> int: ...
    def layout(self) -> QgsLayout: ...
    def stringType(self) -> str: ...


class QgsLayoutGuideProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: QtCore.QObject, orientation: QtCore.Qt.Orientation, page: int) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def setPage(self, page: int) -> None: ...


class QgsLayoutItemRenderContext(sip.wrapper):

    def __init__(self, context: QgsRenderContext, viewScaleFactor: float = ...) -> None: ...

    def viewScaleFactor(self) -> float: ...
    def renderContext(self) -> QgsRenderContext: ...


class QgsLayoutMultiFrame(QgsLayoutObject, QgsLayoutUndoObjectInterface):

    class UndoCommand(int):
        ...
    UndoHtmlBreakDistance: QgsLayoutMultiFrame.UndoCommand = ...
    UndoHtmlSource: QgsLayoutMultiFrame.UndoCommand = ...
    UndoHtmlStylesheet: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableCellStyle: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableMaximumFeatures: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableMargin: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableHeaderFontColor: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableContentFontColor: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableGridStrokeWidth: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableGridColor: QgsLayoutMultiFrame.UndoCommand = ...
    UndoTableBackgroundColor: QgsLayoutMultiFrame.UndoCommand = ...
    UndoNone: QgsLayoutMultiFrame.UndoCommand = ...

    class ResizeMode(int):
        ...
    UseExistingFrames: QgsLayoutMultiFrame.ResizeMode = ...
    ExtendToNextPage: QgsLayoutMultiFrame.ResizeMode = ...
    RepeatOnEveryPage: QgsLayoutMultiFrame.ResizeMode = ...
    RepeatUntilFinished: QgsLayoutMultiFrame.ResizeMode = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def contentsChanged(self) -> None: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def recalculateFrameRects(self) -> None: ...
    def recalculateFrameSizes(self) -> None: ...
    def update(self) -> None: ...
    def refresh(self) -> None: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def cancelCommand(self) -> None: ...
    def endCommand(self) -> None: ...
    def beginCommand(self, commandText: str, command: QgsLayoutMultiFrame.UndoCommand = ...) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def createCommand(self, text: str, id: int, parent: Optional[QtWidgets.QUndoCommand] = ...) -> QgsAbstractLayoutUndoCommand: ...
    def displayName(self) -> str: ...
    def createNewFrame(self, currentFrame: QgsLayoutFrame, pos: Union[QtCore.QPointF, QtCore.QPoint, float], size: QtCore.QSizeF) -> QgsLayoutFrame: ...
    def frameIndex(self, frame: QgsLayoutFrame) -> int: ...
    def frame(self, index: int) -> QgsLayoutFrame: ...
    def frameCount(self) -> int: ...
    def frames(self) -> List[QgsLayoutFrame]: ...
    def readXml(self, itemElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext, includeFrames: bool = ...) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext, includeFrames: bool = ...) -> bool: ...
    def resizeMode(self) -> QgsLayoutMultiFrame.ResizeMode: ...
    def setResizeMode(self, mode: QgsLayoutMultiFrame.ResizeMode) -> None: ...
    def deleteFrames(self) -> None: ...
    def removeFrame(self, index: int, removeEmptyPages: bool = ...) -> None: ...
    def findNearbyPageBreak(self, yPos: float) -> float: ...
    def addFrame(self, frame: QgsLayoutFrame, recalcFrameSizes: bool = ...) -> None: ...
    def render(self, context: QgsLayoutItemRenderContext, renderExtent: QtCore.QRectF, frameIndex: int) -> None: ...
    def minFrameSize(self, frameIndex: int = ...) -> QtCore.QSizeF: ...
    def fixedFrameSize(self, frameIndex: int = ...) -> QtCore.QSizeF: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    def totalSize(self) -> QtCore.QSizeF: ...
    def uuid(self) -> str: ...


class QgsLayoutTable(QgsLayoutMultiFrame):

    class CellStyleGroup(int):
        ...
    OddColumns: QgsLayoutTable.CellStyleGroup = ...
    EvenColumns: QgsLayoutTable.CellStyleGroup = ...
    OddRows: QgsLayoutTable.CellStyleGroup = ...
    EvenRows: QgsLayoutTable.CellStyleGroup = ...
    FirstColumn: QgsLayoutTable.CellStyleGroup = ...
    LastColumn: QgsLayoutTable.CellStyleGroup = ...
    HeaderRow: QgsLayoutTable.CellStyleGroup = ...
    FirstRow: QgsLayoutTable.CellStyleGroup = ...
    LastRow: QgsLayoutTable.CellStyleGroup = ...

    class WrapBehavior(int):
        ...
    TruncateText: QgsLayoutTable.WrapBehavior = ...
    WrapText: QgsLayoutTable.WrapBehavior = ...

    class EmptyTableMode(int):
        ...
    HeadersOnly: QgsLayoutTable.EmptyTableMode = ...
    HideTable: QgsLayoutTable.EmptyTableMode = ...
    ShowMessage: QgsLayoutTable.EmptyTableMode = ...

    class HeaderMode(int):
        ...
    FirstFrame: QgsLayoutTable.HeaderMode = ...
    AllFrames: QgsLayoutTable.HeaderMode = ...
    NoHeaders: QgsLayoutTable.HeaderMode = ...

    class HeaderHAlignment(int):
        ...
    FollowColumn: QgsLayoutTable.HeaderHAlignment = ...
    HeaderLeft: QgsLayoutTable.HeaderHAlignment = ...
    HeaderCenter: QgsLayoutTable.HeaderHAlignment = ...
    HeaderRight: QgsLayoutTable.HeaderHAlignment = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def verticalAlignmentForCell(self, row: int, column: int) -> QtCore.Qt.Alignment: ...
    def horizontalAlignmentForCell(self, row: int, column: int) -> QtCore.Qt.Alignment: ...
    def textFormatForHeader(self, column: int) -> QgsTextFormat: ...
    def textFormatForCell(self, row: int, column: int) -> QgsTextFormat: ...
    def contentsContainsRow(self, contents: typing.Any, row: Iterable[typing.Any]) -> bool: ...
    def recalculateTableSize(self) -> None: ...
    def drawHorizontalGridLines(self, context: QgsLayoutItemRenderContext, firstRow: int, lastRow: int, drawHeaderLines: bool) -> None: ...
    def rowRange(self, context: QgsRenderContext, frameIndex: int) -> Tuple[int, int]: ...
    @overload
    def rowsVisible(self, context: QgsRenderContext, frameHeight: float, firstRow: int, includeHeader: bool, includeEmptyRows: bool) -> int: ...
    @overload
    def rowsVisible(self, context: QgsRenderContext, frameIndex: int, firstRow: int, includeEmptyRows: bool) -> int: ...
    def totalHeight(self) -> float: ...
    def totalWidth(self) -> float: ...
    def calculateMaxRowHeights(self) -> bool: ...
    def calculateMaxColumnWidths(self) -> bool: ...
    def recalculateFrameSizes(self) -> None: ...
    def refreshAttributes(self) -> None: ...
    def refresh(self) -> None: ...
    def render(self, context: QgsLayoutItemRenderContext, renderExtent: QtCore.QRectF, frameIndex: int) -> None: ...
    def totalSize(self) -> QtCore.QSizeF: ...
    def readPropertiesFromElement(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def minFrameSize(self, frameIndex: int = ...) -> QtCore.QSizeF: ...
    def fixedFrameSize(self, frameIndex: int = ...) -> QtCore.QSizeF: ...
    def contents(self) -> typing.Any: ...
    def scopeForCell(self, row: int, column: int) -> QgsExpressionContextScope: ...
    def conditionalCellStyle(self, row: int, column: int) -> QgsConditionalStyle: ...
    def getTableContents(self, contents: typing.Any) -> bool: ...
    def cellStyle(self, group: QgsLayoutTable.CellStyleGroup) -> QgsLayoutTableStyle: ...
    def setCellStyle(self, group: QgsLayoutTable.CellStyleGroup, style: QgsLayoutTableStyle) -> None: ...
    def setSortColumns(self, sortColumns: Iterable[QgsLayoutTableColumn]) -> None: ...
    def sortColumns(self) -> List[QgsLayoutTableColumn]: ...
    def setColumns(self, columns: Iterable[QgsLayoutTableColumn]) -> None: ...
    def columns(self) -> List[QgsLayoutTableColumn]: ...
    def wrapBehavior(self) -> QgsLayoutTable.WrapBehavior: ...
    def setWrapBehavior(self, behavior: QgsLayoutTable.WrapBehavior) -> None: ...
    def backgroundColor(self) -> QtGui.QColor: ...
    def setBackgroundColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def verticalGrid(self) -> bool: ...
    def setVerticalGrid(self, verticalGrid: bool) -> None: ...
    def horizontalGrid(self) -> bool: ...
    def setHorizontalGrid(self, horizontalGrid: bool) -> None: ...
    def gridColor(self) -> QtGui.QColor: ...
    def setGridColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def gridStrokeWidth(self) -> float: ...
    def setGridStrokeWidth(self, width: float) -> None: ...
    def showGrid(self) -> bool: ...
    def setShowGrid(self, showGrid: bool) -> None: ...
    def contentTextFormat(self) -> QgsTextFormat: ...
    def setContentTextFormat(self, format: QgsTextFormat) -> None: ...
    def contentFontColor(self) -> QtGui.QColor: ...
    def setContentFontColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def contentFont(self) -> QtGui.QFont: ...
    def setContentFont(self, font: QtGui.QFont) -> None: ...
    def headerMode(self) -> QgsLayoutTable.HeaderMode: ...
    def setHeaderMode(self, mode: QgsLayoutTable.HeaderMode) -> None: ...
    def headerHAlignment(self) -> QgsLayoutTable.HeaderHAlignment: ...
    def setHeaderHAlignment(self, alignment: QgsLayoutTable.HeaderHAlignment) -> None: ...
    def headerTextFormat(self) -> QgsTextFormat: ...
    def setHeaderTextFormat(self, format: QgsTextFormat) -> None: ...
    def headerFontColor(self) -> QtGui.QColor: ...
    def setHeaderFontColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def headerFont(self) -> QtGui.QFont: ...
    def setHeaderFont(self, font: QtGui.QFont) -> None: ...
    def showEmptyRows(self) -> bool: ...
    def setShowEmptyRows(self, showEmpty: bool) -> None: ...
    def emptyTableMessage(self) -> str: ...
    def setEmptyTableMessage(self, message: str) -> None: ...
    def emptyTableBehavior(self) -> QgsLayoutTable.EmptyTableMode: ...
    def setEmptyTableBehavior(self, mode: QgsLayoutTable.EmptyTableMode) -> None: ...
    def cellMargin(self) -> float: ...
    def setCellMargin(self, margin: float) -> None: ...


class QgsLayoutItemAttributeTable(QgsLayoutTable):

    class ContentSource(int):
        ...
    LayerAttributes: QgsLayoutItemAttributeTable.ContentSource = ...
    AtlasFeature: QgsLayoutItemAttributeTable.ContentSource = ...
    RelationChildren: QgsLayoutItemAttributeTable.ContentSource = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def setUseConditionalStyling(self, enabled: bool) -> None: ...
    def useConditionalStyling(self) -> bool: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def scopeForCell(self, row: int, column: int) -> QgsExpressionContextScope: ...
    def conditionalCellStyle(self, row: int, column: int) -> QgsConditionalStyle: ...
    def getTableContents(self, contents: typing.Any) -> bool: ...
    def wrapString(self) -> str: ...
    def setWrapString(self, wrapString: str) -> None: ...
    def setDisplayedFields(self, fields: Iterable[str], refresh: bool = ...) -> None: ...
    def setFeatureFilter(self, expression: str) -> None: ...
    def featureFilter(self) -> str: ...
    def setFilterFeatures(self, filter: bool) -> None: ...
    def filterFeatures(self) -> bool: ...
    def filterToAtlasFeature(self) -> bool: ...
    def setFilterToAtlasFeature(self, filterToAtlas: bool) -> None: ...
    def displayOnlyVisibleFeatures(self) -> bool: ...
    def setDisplayOnlyVisibleFeatures(self, visibleOnly: bool) -> None: ...
    def uniqueRowsOnly(self) -> bool: ...
    def setUniqueRowsOnly(self, uniqueOnly: bool) -> None: ...
    def maximumNumberOfFeatures(self) -> int: ...
    def setMaximumNumberOfFeatures(self, features: int) -> None: ...
    def map(self) -> QgsLayoutItemMap: ...
    def setMap(self, map: QgsLayoutItemMap) -> None: ...
    def resetColumns(self) -> None: ...
    def relationId(self) -> str: ...
    def setRelationId(self, id: str) -> None: ...
    def vectorLayer(self) -> QgsVectorLayer: ...
    def setVectorLayer(self, layer: QgsVectorLayer) -> None: ...
    def sourceLayer(self) -> QgsVectorLayer: ...
    def source(self) -> QgsLayoutItemAttributeTable.ContentSource: ...
    def setSource(self, source: QgsLayoutItemAttributeTable.ContentSource) -> None: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemAttributeTable: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemGroup(QgsLayoutItem):

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, itemElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def paint(self, painter: QtGui.QPainter, itemStyle: QtWidgets.QStyleOptionGraphicsItem, pWidget: QtWidgets.QWidget) -> None: ...
    def attemptResize(self, size: QgsLayoutSize, includesFrame: bool = ...) -> None: ...
    def attemptMove(self, point: QgsLayoutPoint, useReferencePoint: bool = ..., includesFrame: bool = ..., page: int = ...) -> None: ...
    def setVisibility(self, visible: bool) -> None: ...
    def items(self) -> List[QgsLayoutItem]: ...
    def removeItems(self) -> None: ...
    def addItem(self, item: QgsLayoutItem) -> None: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemGroup: ...
    def displayName(self) -> str: ...
    def type(self) -> int: ...
    def cleanup(self) -> None: ...


class QgsLayoutItemHtml(QgsLayoutMultiFrame):

    class ContentMode(int):
        ...
    Url: QgsLayoutItemHtml.ContentMode = ...
    ManualHtml: QgsLayoutItemHtml.ContentMode = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def recalculateFrameSizes(self) -> None: ...
    def loadHtml(self, useCache: bool = ..., context: Optional[QgsExpressionContext] = ...) -> None: ...
    def findNearbyPageBreak(self, yPos: float) -> float: ...
    def render(self, context: QgsLayoutItemRenderContext, renderExtent: QtCore.QRectF, frameIndex: int) -> None: ...
    def totalSize(self) -> QtCore.QSizeF: ...
    def displayName(self) -> str: ...
    def userStylesheetEnabled(self) -> bool: ...
    def setUserStylesheetEnabled(self, enabled: bool) -> None: ...
    def userStylesheet(self) -> str: ...
    def setUserStylesheet(self, stylesheet: str) -> None: ...
    def maxBreakDistance(self) -> float: ...
    def setMaxBreakDistance(self, distance: float) -> None: ...
    def setUseSmartBreaks(self, useSmartBreaks: bool) -> None: ...
    def useSmartBreaks(self) -> bool: ...
    def setEvaluateExpressions(self, evaluateExpressions: bool) -> None: ...
    def evaluateExpressions(self) -> bool: ...
    def html(self) -> str: ...
    def setHtml(self, html: str) -> None: ...
    def url(self) -> QtCore.QUrl: ...
    def setUrl(self, url: QtCore.QUrl) -> None: ...
    def contentMode(self) -> QgsLayoutItemHtml.ContentMode: ...
    def setContentMode(self, mode: QgsLayoutItemHtml.ContentMode) -> None: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemHtml: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemLabel(QgsLayoutItem):

    class Mode(int):
        ...
    ModeFont: QgsLayoutItemLabel.Mode = ...
    ModeHtml: QgsLayoutItemLabel.Mode = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def convertToStaticText(self) -> None: ...
    def refresh(self) -> None: ...
    def setFrameStrokeWidth(self, strokeWidth: QgsLayoutMeasurement) -> None: ...
    def setFrameEnabled(self, drawFrame: bool) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def fontColor(self) -> QtGui.QColor: ...
    def setFontColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setMarginY(self, margin: float) -> None: ...
    def setMarginX(self, margin: float) -> None: ...
    def setMargin(self, margin: float) -> None: ...
    def marginY(self) -> float: ...
    def marginX(self) -> float: ...
    def setVAlign(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def setHAlign(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def hAlign(self) -> QtCore.Qt.AlignmentFlag: ...
    def vAlign(self) -> QtCore.Qt.AlignmentFlag: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setMode(self, mode: QgsLayoutItemLabel.Mode) -> None: ...
    def mode(self) -> QgsLayoutItemLabel.Mode: ...
    def currentText(self) -> str: ...
    def setText(self, text: str) -> None: ...
    def text(self) -> str: ...
    def sizeForText(self) -> QtCore.QSizeF: ...
    def adjustSizeToText(self) -> None: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemLabel: ...


class QgsLegendModel(QgsLayerTreeModel):

    @overload
    def __init__(self, rootNode: QgsLayerTree, parent: Optional[QtCore.QObject] = ..., layout: Optional[QgsLayoutItemLegend] = ...) -> None: ...
    @overload
    def __init__(self, rootNode: QgsLayerTree, layout: QgsLayoutItemLegend) -> None: ...

    def refreshLegend(self) -> None: ...
    def clearCachedData(self, node: QgsLayerTreeNode) -> None: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...


class QgsLayoutItemLegend(QgsLayoutItem):

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def refresh(self) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def paint(self, painter: QtGui.QPainter, itemStyle: QtWidgets.QStyleOptionGraphicsItem, pWidget: QtWidgets.QWidget) -> None: ...
    def legendSettings(self) -> QgsLegendSettings: ...
    def updateFilterByMap(self, redraw: bool = ...) -> None: ...
    def updateLegend(self) -> None: ...
    def themeName(self) -> str: ...
    def linkedMap(self) -> QgsLayoutItemMap: ...
    def setLinkedMap(self, map: QgsLayoutItemMap) -> None: ...
    def setRasterStrokeWidth(self, width: float) -> None: ...
    def rasterStrokeWidth(self) -> float: ...
    def setRasterStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def rasterStrokeColor(self) -> QtGui.QColor: ...
    def setDrawRasterStroke(self, enabled: bool) -> None: ...
    def drawRasterStroke(self) -> bool: ...
    def setEqualColumnWidth(self, equalize: bool) -> None: ...
    def equalColumnWidth(self) -> bool: ...
    def setSplitLayer(self, enabled: bool) -> None: ...
    def splitLayer(self) -> bool: ...
    def setColumnCount(self, count: int) -> None: ...
    def columnCount(self) -> int: ...
    def wrapString(self) -> str: ...
    def setWrapString(self, string: str) -> None: ...
    def setWmsLegendHeight(self, height: float) -> None: ...
    def wmsLegendHeight(self) -> float: ...
    def setWmsLegendWidth(self, width: float) -> None: ...
    def wmsLegendWidth(self) -> float: ...
    def setSymbolHeight(self, height: float) -> None: ...
    def symbolHeight(self) -> float: ...
    def symbolAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setSymbolAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def setMinimumSymbolSize(self, size: float) -> None: ...
    def minimumSymbolSize(self) -> float: ...
    def setMaximumSymbolSize(self, size: float) -> None: ...
    def maximumSymbolSize(self) -> float: ...
    def setSymbolWidth(self, width: float) -> None: ...
    def symbolWidth(self) -> float: ...
    def setFontColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fontColor(self) -> QtGui.QColor: ...
    def setColumnSpace(self, spacing: float) -> None: ...
    def columnSpace(self) -> float: ...
    def setBoxSpace(self, space: float) -> None: ...
    def boxSpace(self) -> float: ...
    def setLineSpacing(self, spacing: float) -> None: ...
    def lineSpacing(self) -> float: ...
    @overload
    def setStyleMargin(self, component: QgsLegendStyle.Style, margin: float) -> None: ...
    @overload
    def setStyleMargin(self, component: QgsLegendStyle.Style, side: QgsLegendStyle.Side, margin: float) -> None: ...
    def setStyleFont(self, component: QgsLegendStyle.Style, font: QtGui.QFont) -> None: ...
    def styleFont(self, component: QgsLegendStyle.Style) -> QtGui.QFont: ...
    def setStyle(self, component: QgsLegendStyle.Style, style: QgsLegendStyle) -> None: ...
    def style(self, s: QgsLegendStyle.Style) -> QgsLegendStyle: ...
    def rstyle(self, s: QgsLegendStyle.Style) -> QgsLegendStyle: ...
    def setTitleAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def titleAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def title(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def legendFilterOutAtlas(self) -> bool: ...
    def setLegendFilterOutAtlas(self, doFilter: bool) -> None: ...
    def legendFilterByMapEnabled(self) -> bool: ...
    def setLegendFilterByMapEnabled(self, enabled: bool) -> None: ...
    def autoUpdateModel(self) -> bool: ...
    def setAutoUpdateModel(self, autoUpdate: bool) -> None: ...
    def model(self) -> QgsLegendModel: ...
    def resizeToContents(self) -> bool: ...
    def setResizeToContents(self, enabled: bool) -> None: ...
    def adjustBoxSize(self) -> None: ...
    def displayName(self) -> str: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemLegend: ...


class QgsLayoutItemManualTable(QgsLayoutTable):

    def __init__(self, layout: QgsLayout) -> None: ...

    def verticalAlignmentForCell(self, row: int, column: int) -> QtCore.Qt.Alignment: ...
    def horizontalAlignmentForCell(self, row: int, column: int) -> QtCore.Qt.Alignment: ...
    def textFormatForCell(self, row: int, column: int) -> QgsTextFormat: ...
    def textFormatForHeader(self, column: int) -> QgsTextFormat: ...
    def calculateMaxRowHeights(self) -> bool: ...
    def readPropertiesFromElement(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def setHeaders(self, headers: Iterable[QgsLayoutTableColumn]) -> None: ...
    def headers(self) -> List[QgsLayoutTableColumn]: ...
    def setIncludeTableHeader(self, included: bool) -> None: ...
    def includeTableHeader(self) -> bool: ...
    def setColumnWidths(self, widths: Iterable[float]) -> None: ...
    def columnWidths(self) -> List[float]: ...
    def setRowHeights(self, heights: Iterable[float]) -> None: ...
    def rowHeights(self) -> List[float]: ...
    def tableContents(self) -> typing.Any: ...
    def setTableContents(self, contents: typing.Any) -> None: ...
    def conditionalCellStyle(self, row: int, column: int) -> QgsConditionalStyle: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemManualTable: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemMapAtlasClippingSettings(QtCore.QObject):

    def __init__(self, map: Optional[QgsLayoutItemMap] = ...) -> None: ...

    def changed(self) -> None: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def setLayersToClip(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def layersToClip(self) -> List[QgsMapLayer]: ...
    def setRestrictToLayers(self, enabled: bool) -> None: ...
    def restrictToLayers(self) -> bool: ...
    def setForceLabelsInsideFeature(self, forceInside: bool) -> None: ...
    def forceLabelsInsideFeature(self) -> bool: ...
    def setFeatureClippingType(self, type: QgsMapClippingRegion.FeatureClippingType) -> None: ...
    def featureClippingType(self) -> QgsMapClippingRegion.FeatureClippingType: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...


class QgsLayoutItemMapItemClipPathSettings(QtCore.QObject):

    def __init__(self, map: Optional[QgsLayoutItemMap] = ...) -> None: ...

    def changed(self) -> None: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def setForceLabelsInsideClipPath(self, forceInside: bool) -> None: ...
    def forceLabelsInsideClipPath(self) -> bool: ...
    def setFeatureClippingType(self, type: QgsMapClippingRegion.FeatureClippingType) -> None: ...
    def featureClippingType(self) -> QgsMapClippingRegion.FeatureClippingType: ...
    def sourceItem(self) -> QgsLayoutItem: ...
    def setSourceItem(self, item: QgsLayoutItem) -> None: ...
    def toMapClippingRegion(self) -> QgsMapClippingRegion: ...
    def clipPathInMapItemCoordinates(self) -> QgsGeometry: ...
    def clippedMapExtent(self) -> QgsGeometry: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def enabled(self) -> bool: ...
    def isActive(self) -> bool: ...


class QgsLayoutItemMap(QgsLayoutItem, QgsTemporalRangeObject):

    class MapItemFlag(int):
        ...
    ShowPartialLabels: QgsLayoutItemMap.MapItemFlag = ...
    ShowUnplacedLabels: QgsLayoutItemMap.MapItemFlag = ...

    class AtlasScalingMode(int):
        ...
    Fixed: QgsLayoutItemMap.AtlasScalingMode = ...
    Predefined: QgsLayoutItemMap.AtlasScalingMode = ...
    Auto: QgsLayoutItemMap.AtlasScalingMode = ...

    class MapItemFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLayoutItemMap.MapItemFlags, QgsLayoutItemMap.MapItemFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutItemMap.MapItemFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLayoutItemMap.MapItemFlags: ...
        def __int__(self) -> int: ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def updateBoundingRect(self) -> None: ...
    def invalidateCache(self) -> None: ...
    def refresh(self) -> None: ...
    def crsChanged(self) -> None: ...
    def themeChanged(self, theme: str) -> None: ...
    def layerStyleOverridesChanged(self) -> None: ...
    def preparedForAtlas(self) -> None: ...
    def mapRotationChanged(self, newRotation: float) -> None: ...
    def extentChanged(self) -> None: ...
    def requestedExtent(self) -> QgsRectangle: ...
    def mapToItemCoords(self, mapCoords: Union[QtCore.QPointF, QtCore.QPoint, float]) -> QtCore.QPointF: ...
    def transformedMapPolygon(self) -> QtGui.QPolygonF: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def isDrawing(self) -> bool: ...
    def framePath(self) -> QtGui.QPainterPath: ...
    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def itemClippingSettings(self) -> QgsLayoutItemMapItemClipPathSettings: ...
    def atlasClippingSettings(self) -> QgsLayoutItemMapAtlasClippingSettings: ...
    def layoutToMapCoordsTransform(self) -> QtGui.QTransform: ...
    def removeRenderedFeatureHandler(self, handler: QgsRenderedFeatureHandlerInterface) -> None: ...
    def addRenderedFeatureHandler(self, handler: QgsRenderedFeatureHandlerInterface) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def renderingErrors(self) -> List[QgsMapRendererJob.Error]: ...
    def isLabelBlockingItem(self, item: QgsLayoutItem) -> bool: ...
    def removeLabelBlockingItem(self, item: QgsLayoutItem) -> None: ...
    def addLabelBlockingItem(self, item: QgsLayoutItem) -> None: ...
    def layersToRender(self, context: Optional[QgsExpressionContext] = ...) -> List[QgsMapLayer]: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def mapSettings(self, extent: QgsRectangle, size: QtCore.QSizeF, dpi: float, includeLayerSettings: bool) -> QgsMapSettings: ...
    def mapUnitsToLayoutUnits(self) -> float: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def setLabelMargin(self, margin: QgsLayoutMeasurement) -> None: ...
    def labelMargin(self) -> QgsLayoutMeasurement: ...
    def overview(self) -> QgsLayoutItemMapOverview: ...
    def overviews(self) -> QgsLayoutItemMapOverviewStack: ...
    def grid(self) -> QgsLayoutItemMapGrid: ...
    def grids(self) -> QgsLayoutItemMapGridStack: ...
    def setAtlasMargin(self, margin: float) -> None: ...
    def atlasMargin(self, valueType: QgsLayoutObject.PropertyValueType = ...) -> float: ...
    def setAtlasScalingMode(self, mode: QgsLayoutItemMap.AtlasScalingMode) -> None: ...
    def atlasScalingMode(self) -> QgsLayoutItemMap.AtlasScalingMode: ...
    def setAtlasDriven(self, enabled: bool) -> None: ...
    def atlasDriven(self) -> bool: ...
    def drawAnnotations(self) -> bool: ...
    def setDrawAnnotations(self, draw: bool) -> None: ...
    def mapRotation(self, valueType: QgsLayoutObject.PropertyValueType = ...) -> float: ...
    def setMapRotation(self, rotation: float) -> None: ...
    def containsAdvancedEffects(self) -> bool: ...
    def requiresRasterization(self) -> bool: ...
    def containsWmsLayer(self) -> bool: ...
    def zoomContent(self, factor: float, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> None: ...
    def setMoveContentPreviewOffset(self, dx: float, dy: float) -> None: ...
    def moveContent(self, dx: float, dy: float) -> None: ...
    def setFollowVisibilityPresetName(self, name: str) -> None: ...
    def followVisibilityPresetName(self) -> str: ...
    def setFollowVisibilityPreset(self, follow: bool) -> None: ...
    def followVisibilityPreset(self) -> bool: ...
    def storeCurrentLayerStyles(self) -> None: ...
    def setLayerStyleOverrides(self, overrides: Dict[str, str]) -> None: ...
    def layerStyleOverrides(self) -> Dict[str, str]: ...
    def setKeepLayerStyles(self, enabled: bool) -> None: ...
    def keepLayerStyles(self) -> bool: ...
    def setLayers(self, layers: Iterable[QgsMapLayer]) -> None: ...
    def layers(self) -> List[QgsMapLayer]: ...
    def setKeepLayerSet(self, enabled: bool) -> None: ...
    def keepLayerSet(self) -> bool: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def presetCrs(self) -> QgsCoordinateReferenceSystem: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def visibleExtentPolygon(self) -> QtGui.QPolygonF: ...
    def extent(self) -> QgsRectangle: ...
    def zoomToExtent(self, extent: QgsRectangle) -> None: ...
    def setExtent(self, extent: QgsRectangle) -> None: ...
    def setScale(self, scale: float, forceUpdate: bool = ...) -> None: ...
    def scale(self) -> float: ...
    def setFrameStrokeWidth(self, width: QgsLayoutMeasurement) -> None: ...
    def exportLayerDetails(self) -> QgsLayoutItem.ExportLayerDetail: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def nextExportPart(self) -> bool: ...
    def stopLayeredExport(self) -> None: ...
    def startLayeredExport(self) -> None: ...
    def numberExportLayers(self) -> int: ...
    def paint(self, painter: QtGui.QPainter, itemStyle: QtWidgets.QStyleOptionGraphicsItem, pWidget: QtWidgets.QWidget) -> None: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemMap: ...
    def displayName(self) -> str: ...
    def assignFreeId(self) -> None: ...
    def setMapFlags(self, flags: Union[QgsLayoutItemMap.MapItemFlags, QgsLayoutItemMap.MapItemFlag]) -> None: ...
    def mapFlags(self) -> QgsLayoutItemMap.MapItemFlags: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemMapItemStack(sip.wrapper):

    @overload
    def __init__(self, map: QgsLayoutItemMap) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutItemMapItemStack) -> None: ...

    def removeItems(self) -> None: ...
    def asList(self) -> List[QgsLayoutItemMapItem]: ...
    def moveItemDown(self, itemId: str) -> None: ...
    def moveItemUp(self, itemId: str) -> None: ...
    def removeItem(self, itemId: str) -> None: ...
    def addItem(self, item: QgsLayoutItemMapItem) -> None: ...
    @overload
    def item(self, index: int) -> QgsLayoutItemMapItem: ...
    @overload
    def item(self, itemId: str) -> QgsLayoutItemMapItem: ...
    def hasEnabledItems(self) -> bool: ...
    def containsAdvancedEffects(self) -> bool: ...
    def drawItems(self, painter: QtGui.QPainter, ignoreStacking: bool = ...) -> None: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def size(self) -> int: ...


class QgsLayoutItemMapGridStack(QgsLayoutItemMapItemStack):

    @overload
    def __init__(self, map: QgsLayoutItemMap) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutItemMapGridStack) -> None: ...

    def calculateMaxGridExtension(self) -> Tuple[float, float, float, float]: ...
    def maxGridExtension(self) -> float: ...
    def readXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def asList(self) -> List[QgsLayoutItemMapGrid]: ...
    def __getitem__(self, index: int) -> QgsLayoutItemMapGrid: ...
    @overload
    def grid(self, gridId: str) -> QgsLayoutItemMapGrid: ...
    @overload
    def grid(self, index: int) -> QgsLayoutItemMapGrid: ...
    def moveGridDown(self, gridId: str) -> None: ...
    def moveGridUp(self, gridId: str) -> None: ...
    def removeGrid(self, gridId: str) -> None: ...
    def addGrid(self, grid: QgsLayoutItemMapGrid) -> None: ...


class QgsLayoutItemMapItem(QgsLayoutObject):

    class StackingPosition(int):
        ...
    StackBelowMap: QgsLayoutItemMapItem.StackingPosition = ...
    StackBelowMapLayer: QgsLayoutItemMapItem.StackingPosition = ...
    StackAboveMapLayer: QgsLayoutItemMapItem.StackingPosition = ...
    StackBelowMapLabels: QgsLayoutItemMapItem.StackingPosition = ...
    StackAboveMapLabels: QgsLayoutItemMapItem.StackingPosition = ...

    def __init__(self, name: str, map: QgsLayoutItemMap) -> None: ...

    def createExpressionContext(self) -> QgsExpressionContext: ...
    def mapLayer(self) -> QgsMapLayer: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def setStackingLayer(self, layer: QgsMapLayer) -> None: ...
    def stackingLayer(self) -> QgsMapLayer: ...
    def setStackingPosition(self, position: QgsLayoutItemMapItem.StackingPosition) -> None: ...
    def stackingPosition(self) -> QgsLayoutItemMapItem.StackingPosition: ...
    def usesAdvancedEffects(self) -> bool: ...
    def enabled(self) -> bool: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def name(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def id(self) -> str: ...
    def map(self) -> QgsLayoutItemMap: ...
    def setMap(self, map: QgsLayoutItemMap) -> None: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, painter: QtGui.QPainter) -> None: ...


class QgsLayoutItemMapGrid(QgsLayoutItemMapItem):

    class AnnotationCoordinate(int):
        ...
    Longitude: QgsLayoutItemMapGrid.AnnotationCoordinate = ...
    Latitude: QgsLayoutItemMapGrid.AnnotationCoordinate = ...

    class FrameSideFlag(int):
        ...
    FrameLeft: QgsLayoutItemMapGrid.FrameSideFlag = ...
    FrameRight: QgsLayoutItemMapGrid.FrameSideFlag = ...
    FrameTop: QgsLayoutItemMapGrid.FrameSideFlag = ...
    FrameBottom: QgsLayoutItemMapGrid.FrameSideFlag = ...

    class TickLengthMode(int):
        ...
    OrthogonalTicks: QgsLayoutItemMapGrid.TickLengthMode = ...
    NormalizedTicks: QgsLayoutItemMapGrid.TickLengthMode = ...

    class FrameStyle(int):
        ...
    NoFrame: QgsLayoutItemMapGrid.FrameStyle = ...
    Zebra: QgsLayoutItemMapGrid.FrameStyle = ...
    InteriorTicks: QgsLayoutItemMapGrid.FrameStyle = ...
    ExteriorTicks: QgsLayoutItemMapGrid.FrameStyle = ...
    InteriorExteriorTicks: QgsLayoutItemMapGrid.FrameStyle = ...
    LineBorder: QgsLayoutItemMapGrid.FrameStyle = ...
    LineBorderNautical: QgsLayoutItemMapGrid.FrameStyle = ...
    ZebraNautical: QgsLayoutItemMapGrid.FrameStyle = ...

    class BorderSide(int):
        ...
    Left: QgsLayoutItemMapGrid.BorderSide = ...
    Right: QgsLayoutItemMapGrid.BorderSide = ...
    Bottom: QgsLayoutItemMapGrid.BorderSide = ...
    Top: QgsLayoutItemMapGrid.BorderSide = ...

    class AnnotationFormat(int):
        ...
    Decimal: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DegreeMinute: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DegreeMinuteSecond: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DecimalWithSuffix: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DegreeMinuteNoSuffix: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DegreeMinutePadded: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DegreeMinuteSecondNoSuffix: QgsLayoutItemMapGrid.AnnotationFormat = ...
    DegreeMinuteSecondPadded: QgsLayoutItemMapGrid.AnnotationFormat = ...
    CustomFormat: QgsLayoutItemMapGrid.AnnotationFormat = ...

    class AnnotationDirection(int):
        ...
    Horizontal: QgsLayoutItemMapGrid.AnnotationDirection = ...
    Vertical: QgsLayoutItemMapGrid.AnnotationDirection = ...
    VerticalDescending: QgsLayoutItemMapGrid.AnnotationDirection = ...
    BoundaryDirection: QgsLayoutItemMapGrid.AnnotationDirection = ...
    AboveTick: QgsLayoutItemMapGrid.AnnotationDirection = ...
    OnTick: QgsLayoutItemMapGrid.AnnotationDirection = ...
    UnderTick: QgsLayoutItemMapGrid.AnnotationDirection = ...

    class AnnotationPosition(int):
        ...
    InsideMapFrame: QgsLayoutItemMapGrid.AnnotationPosition = ...
    OutsideMapFrame: QgsLayoutItemMapGrid.AnnotationPosition = ...

    class DisplayMode(int):
        ...
    ShowAll: QgsLayoutItemMapGrid.DisplayMode = ...
    LatitudeOnly: QgsLayoutItemMapGrid.DisplayMode = ...
    LongitudeOnly: QgsLayoutItemMapGrid.DisplayMode = ...
    HideAll: QgsLayoutItemMapGrid.DisplayMode = ...

    class GridStyle(int):
        ...
    Solid: QgsLayoutItemMapGrid.GridStyle = ...
    Cross: QgsLayoutItemMapGrid.GridStyle = ...
    Markers: QgsLayoutItemMapGrid.GridStyle = ...
    FrameAnnotationsOnly: QgsLayoutItemMapGrid.GridStyle = ...

    class GridUnit(int):
        ...
    MapUnit: QgsLayoutItemMapGrid.GridUnit = ...
    MM: QgsLayoutItemMapGrid.GridUnit = ...
    CM: QgsLayoutItemMapGrid.GridUnit = ...
    DynamicPageSizeBased: QgsLayoutItemMapGrid.GridUnit = ...

    class FrameSideFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLayoutItemMapGrid.FrameSideFlags, QgsLayoutItemMapGrid.FrameSideFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutItemMapGrid.FrameSideFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLayoutItemMapGrid.FrameSideFlags: ...
        def __int__(self) -> int: ...

    def __init__(self, name: str, map: QgsLayoutItemMap) -> None: ...

    def crsChanged(self) -> None: ...
    def refresh(self) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def frameFillColor2(self) -> QtGui.QColor: ...
    def setFrameFillColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def frameFillColor1(self) -> QtGui.QColor: ...
    def setFrameFillColor1(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def framePenColor(self) -> QtGui.QColor: ...
    def setFramePenColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def framePenSize(self) -> float: ...
    def setFramePenSize(self, width: float) -> None: ...
    def frameMargin(self) -> float: ...
    def setFrameMargin(self, margin: float) -> None: ...
    def rotatedAnnotationsMarginToCorner(self) -> float: ...
    def setRotatedAnnotationsMarginToCorner(self, margin: float) -> None: ...
    def rotatedAnnotationsMinimumAngle(self) -> float: ...
    def setRotatedAnnotationsMinimumAngle(self, angle: float) -> None: ...
    def rotatedAnnotationsLengthMode(self) -> QgsLayoutItemMapGrid.TickLengthMode: ...
    def setRotatedAnnotationsLengthMode(self, mode: QgsLayoutItemMapGrid.TickLengthMode) -> None: ...
    def rotatedAnnotationsEnabled(self) -> float: ...
    def setRotatedAnnotationsEnabled(self, state: bool) -> None: ...
    def rotatedTicksMarginToCorner(self) -> float: ...
    def setRotatedTicksMarginToCorner(self, margin: float) -> None: ...
    def rotatedTicksMinimumAngle(self) -> float: ...
    def setRotatedTicksMinimumAngle(self, angle: float) -> None: ...
    def rotatedTicksLengthMode(self) -> QgsLayoutItemMapGrid.TickLengthMode: ...
    def setRotatedTicksLengthMode(self, mode: QgsLayoutItemMapGrid.TickLengthMode) -> None: ...
    def rotatedTicksEnabled(self) -> float: ...
    def setRotatedTicksEnabled(self, state: bool) -> None: ...
    def frameWidth(self) -> float: ...
    def setFrameWidth(self, width: float) -> None: ...
    def testFrameSideFlag(self, flag: QgsLayoutItemMapGrid.FrameSideFlag) -> bool: ...
    def frameSideFlags(self) -> QgsLayoutItemMapGrid.FrameSideFlags: ...
    def setFrameSideFlag(self, flag: QgsLayoutItemMapGrid.FrameSideFlag, on: bool = ...) -> None: ...
    def setFrameSideFlags(self, flags: Union[QgsLayoutItemMapGrid.FrameSideFlags, QgsLayoutItemMapGrid.FrameSideFlag]) -> None: ...
    def frameDivisions(self, side: QgsLayoutItemMapGrid.BorderSide) -> QgsLayoutItemMapGrid.DisplayMode: ...
    def setFrameDivisions(self, divisions: QgsLayoutItemMapGrid.DisplayMode, side: QgsLayoutItemMapGrid.BorderSide) -> None: ...
    def frameStyle(self) -> QgsLayoutItemMapGrid.FrameStyle: ...
    def setFrameStyle(self, style: QgsLayoutItemMapGrid.FrameStyle) -> None: ...
    def annotationExpression(self) -> str: ...
    def setAnnotationExpression(self, expression: str) -> None: ...
    def annotationFormat(self) -> QgsLayoutItemMapGrid.AnnotationFormat: ...
    def setAnnotationFormat(self, format: QgsLayoutItemMapGrid.AnnotationFormat) -> None: ...
    def annotationDirection(self, border: QgsLayoutItemMapGrid.BorderSide) -> QgsLayoutItemMapGrid.AnnotationDirection: ...
    @overload
    def setAnnotationDirection(self, direction: QgsLayoutItemMapGrid.AnnotationDirection, side: QgsLayoutItemMapGrid.BorderSide) -> None: ...
    @overload
    def setAnnotationDirection(self, direction: QgsLayoutItemMapGrid.AnnotationDirection) -> None: ...
    def annotationFrameDistance(self) -> float: ...
    def setAnnotationFrameDistance(self, distance: float) -> None: ...
    def annotationPosition(self, side: QgsLayoutItemMapGrid.BorderSide) -> QgsLayoutItemMapGrid.AnnotationPosition: ...
    def setAnnotationPosition(self, position: QgsLayoutItemMapGrid.AnnotationPosition, side: QgsLayoutItemMapGrid.BorderSide) -> None: ...
    def annotationDisplay(self, border: QgsLayoutItemMapGrid.BorderSide) -> QgsLayoutItemMapGrid.DisplayMode: ...
    def setAnnotationDisplay(self, display: QgsLayoutItemMapGrid.DisplayMode, border: QgsLayoutItemMapGrid.BorderSide) -> None: ...
    def annotationPrecision(self) -> int: ...
    def setAnnotationPrecision(self, precision: int) -> None: ...
    def annotationFontColor(self) -> QtGui.QColor: ...
    def setAnnotationFontColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def annotationFont(self) -> QtGui.QFont: ...
    def setAnnotationFont(self, font: QtGui.QFont) -> None: ...
    def annotationTextFormat(self) -> QgsTextFormat: ...
    def setAnnotationTextFormat(self, format: QgsTextFormat) -> None: ...
    def annotationEnabled(self) -> bool: ...
    def setAnnotationEnabled(self, enabled: bool) -> None: ...
    def markerSymbol(self) -> QgsMarkerSymbol: ...
    def setMarkerSymbol(self, symbol: QgsMarkerSymbol) -> None: ...
    def lineSymbol(self) -> QgsLineSymbol: ...
    def setLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def setGridLineColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setGridLineWidth(self, width: float) -> None: ...
    def crossLength(self) -> float: ...
    def setCrossLength(self, length: float) -> None: ...
    def style(self) -> QgsLayoutItemMapGrid.GridStyle: ...
    def setStyle(self, style: QgsLayoutItemMapGrid.GridStyle) -> None: ...
    def setMaximumIntervalWidth(self, width: float) -> None: ...
    def maximumIntervalWidth(self) -> float: ...
    def setMinimumIntervalWidth(self, width: float) -> None: ...
    def minimumIntervalWidth(self) -> float: ...
    def offsetY(self) -> float: ...
    def setOffsetY(self, offset: float) -> None: ...
    def offsetX(self) -> float: ...
    def setOffsetX(self, offset: float) -> None: ...
    def intervalY(self) -> float: ...
    def setIntervalY(self, interval: float) -> None: ...
    def intervalX(self) -> float: ...
    def setIntervalX(self, interval: float) -> None: ...
    def units(self) -> QgsLayoutItemMapGrid.GridUnit: ...
    def setUnits(self, unit: QgsLayoutItemMapGrid.GridUnit) -> None: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def calculateMaxExtension(self) -> Tuple[float, float, float, float]: ...
    def maxExtension(self) -> float: ...
    def usesAdvancedEffects(self) -> bool: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, painter: QtGui.QPainter) -> None: ...


class QgsLayoutItemMapOverviewStack(QgsLayoutItemMapItemStack):

    @overload
    def __init__(self, map: QgsLayoutItemMap) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutItemMapOverviewStack) -> None: ...

    def modifyMapLayerList(self, layers: Iterable[QgsMapLayer]) -> List[QgsMapLayer]: ...
    def readXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def asList(self) -> List[QgsLayoutItemMapOverview]: ...
    def __getitem__(self, index: int) -> QgsLayoutItemMapOverview: ...
    @overload
    def overview(self, overviewId: str) -> QgsLayoutItemMapOverview: ...
    @overload
    def overview(self, index: int) -> QgsLayoutItemMapOverview: ...
    def moveOverviewDown(self, overviewId: str) -> None: ...
    def moveOverviewUp(self, overviewId: str) -> None: ...
    def removeOverview(self, overviewId: str) -> None: ...
    def addOverview(self, overview: QgsLayoutItemMapOverview) -> None: ...


class QgsLayoutItemMapOverview(QgsLayoutItemMapItem):

    def __init__(self, name: str, map: QgsLayoutItemMap) -> None: ...

    def overviewExtentChanged(self) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def mapLayer(self) -> QgsMapLayer: ...
    def asMapLayer(self) -> QgsVectorLayer: ...
    def connectSignals(self) -> None: ...
    def setCentered(self, centered: bool) -> None: ...
    def centered(self) -> bool: ...
    def setInverted(self, inverted: bool) -> None: ...
    def inverted(self) -> bool: ...
    def setBlendMode(self, mode: QtGui.QPainter.CompositionMode) -> None: ...
    def blendMode(self) -> QtGui.QPainter.CompositionMode: ...
    def frameSymbol(self) -> QgsFillSymbol: ...
    def setFrameSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def linkedMap(self) -> QgsLayoutItemMap: ...
    def setLinkedMap(self, map: QgsLayoutItemMap) -> None: ...
    def usesAdvancedEffects(self) -> bool: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def readXml(self, itemElem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, elem: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, painter: QtGui.QPainter) -> None: ...


class QgsLayoutItemMarker(QgsLayoutItem):

    def __init__(self, layout: QgsLayout) -> None: ...

    def finalizeRestoreFromXml(self) -> None: ...
    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def fixedSize(self) -> QgsLayoutSize: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def setNorthOffset(self, offset: float) -> None: ...
    def northOffset(self) -> float: ...
    def setNorthMode(self, mode: QgsLayoutNorthArrowHandler.NorthMode) -> None: ...
    def northMode(self) -> QgsLayoutNorthArrowHandler.NorthMode: ...
    def northArrowRotation(self) -> float: ...
    def linkedMap(self) -> QgsLayoutItemMap: ...
    def setLinkedMap(self, map: QgsLayoutItemMap) -> None: ...
    def symbol(self) -> QgsMarkerSymbol: ...
    def setSymbol(self, symbol: QgsMarkerSymbol) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemMarker: ...


class QgsLayoutNodesItem(QgsLayoutItem):

    @overload
    def __init__(self, layout: QgsLayout) -> None: ...
    @overload
    def __init__(self, polygon: QtGui.QPolygonF, layout: QgsLayout) -> None: ...

    def updateBoundingRect(self) -> None: ...
    def updateSceneRect(self) -> None: ...
    def computeDistance(self, pt1: Union[QtCore.QPointF, QtCore.QPoint, float], pt2: Union[QtCore.QPointF, QtCore.QPoint, float]) -> float: ...
    def rescaleToFitBoundingBox(self) -> None: ...
    def _writeXmlStyle(self, doc: QtXml.QDomDocument, elmt: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _readXmlStyle(self, elmt: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _draw(self, context: QgsLayoutItemRenderContext, itemStyle: Optional[QtWidgets.QStyleOptionGraphicsItem] = ...) -> None: ...
    def _removeNode(self, nodeIndex: int) -> bool: ...
    def _addNode(self, nodeIndex: int, newNode: Union[QtCore.QPointF, QtCore.QPoint, float], radius: float) -> bool: ...
    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def estimatedFrameBleed(self) -> float: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def deselectNode(self) -> None: ...
    def selectedNode(self) -> int: ...
    def setSelectedNode(self, index: int) -> bool: ...
    def nodesSize(self) -> int: ...
    def removeNode(self, index: int) -> bool: ...
    def nodePosition(self, index: int, position: Union[QtCore.QPointF, QtCore.QPoint, float]) -> bool: ...
    def nodeAtPosition(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], searchInRadius: bool = ..., radius: float = ...) -> int: ...
    def moveNode(self, index: int, node: Union[QtCore.QPointF, QtCore.QPoint, float]) -> bool: ...
    def setDisplayNodes(self, display: bool = ...) -> None: ...
    def addNode(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], checkArea: bool = ..., radius: float = ...) -> bool: ...
    def nodes(self) -> QtGui.QPolygonF: ...
    def setNodes(self, nodes: QtGui.QPolygonF) -> None: ...


class QgsLayoutItemPage(QgsLayoutItem):

    class UndoCommand(int):
        ...
    UndoPageSymbol: QgsLayoutItemPage.UndoCommand = ...

    class Orientation(int):
        ...
    Portrait: QgsLayoutItemPage.Orientation = ...
    Landscape: QgsLayoutItemPage.Orientation = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, itemElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def drawBackground(self, context: QgsRenderContext) -> None: ...
    def drawFrame(self, context: QgsRenderContext) -> None: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def redraw(self) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def createCommand(self, text: str, id: int, parent: Optional[QtWidgets.QUndoCommand] = ...) -> QgsAbstractLayoutUndoCommand: ...
    def attemptResize(self, size: QgsLayoutSize, includesFrame: bool = ...) -> None: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    @staticmethod
    def decodePageOrientation(string: str) -> Tuple[QgsLayoutItemPage.Orientation, bool]: ...
    def pageStyleSymbol(self) -> QgsFillSymbol: ...
    def setPageStyleSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def orientation(self) -> QgsLayoutItemPage.Orientation: ...
    def pageSize(self) -> QgsLayoutSize: ...
    @overload
    def setPageSize(self, size: QgsLayoutSize) -> None: ...
    @overload
    def setPageSize(self, size: str, orientation: QgsLayoutItemPage.Orientation = ...) -> bool: ...
    def displayName(self) -> str: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemPage: ...


class QgsLayoutItemPicture(QgsLayoutItem):

    class NorthMode(int):
        ...
    GridNorth: QgsLayoutItemPicture.NorthMode = ...
    TrueNorth: QgsLayoutItemPicture.NorthMode = ...

    class Format(int):
        ...
    FormatSVG: QgsLayoutItemPicture.Format = ...
    FormatRaster: QgsLayoutItemPicture.Format = ...
    FormatUnknown: QgsLayoutItemPicture.Format = ...

    class ResizeMode(int):
        ...
    Zoom: QgsLayoutItemPicture.ResizeMode = ...
    Stretch: QgsLayoutItemPicture.ResizeMode = ...
    Clip: QgsLayoutItemPicture.ResizeMode = ...
    ZoomResizeFrame: QgsLayoutItemPicture.ResizeMode = ...
    FrameToImageSize: QgsLayoutItemPicture.ResizeMode = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def applyItemSizeConstraint(self, targetSize: QtCore.QSizeF) -> QtCore.QSizeF: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def pictureRotationChanged(self, newRotation: float) -> None: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def recalculateSize(self) -> None: ...
    def refreshPicture(self, context: Optional[QgsExpressionContext] = ...) -> None: ...
    def setResizeMode(self, mode: QgsLayoutItemPicture.ResizeMode) -> None: ...
    def setPictureRotation(self, rotation: float) -> None: ...
    def setSvgDynamicParameters(self, parameters: Dict[str, QgsProperty]) -> None: ...
    def svgDynamicParameters(self) -> Dict[str, QgsProperty]: ...
    def evaluatedPath(self) -> str: ...
    def isMissingImage(self) -> bool: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def setMode(self, mode: QgsLayoutItemPicture.Format) -> None: ...
    def mode(self) -> QgsLayoutItemPicture.Format: ...
    def setSvgStrokeWidth(self, width: float) -> None: ...
    def svgStrokeWidth(self) -> float: ...
    def setSvgStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def svgStrokeColor(self) -> QtGui.QColor: ...
    def setSvgFillColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def svgFillColor(self) -> QtGui.QColor: ...
    def pictureAnchor(self) -> QgsLayoutItem.ReferencePoint: ...
    def setPictureAnchor(self, anchor: QgsLayoutItem.ReferencePoint) -> None: ...
    def resizeMode(self) -> QgsLayoutItemPicture.ResizeMode: ...
    def setNorthOffset(self, offset: float) -> None: ...
    def northOffset(self) -> float: ...
    def setNorthMode(self, mode: QgsLayoutItemPicture.NorthMode) -> None: ...
    def northMode(self) -> QgsLayoutItemPicture.NorthMode: ...
    def linkedMap(self) -> QgsLayoutItemMap: ...
    def setLinkedMap(self, map: QgsLayoutItemMap) -> None: ...
    def pictureRotation(self) -> float: ...
    def picturePath(self) -> str: ...
    def setPicturePath(self, path: str, format: QgsLayoutItemPicture.Format = ...) -> None: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemPicture: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemPolygon(QgsLayoutNodesItem):

    @overload
    def __init__(self, layout: QgsLayout) -> None: ...
    @overload
    def __init__(self, polygon: QtGui.QPolygonF, layout: QgsLayout) -> None: ...

    def _writeXmlStyle(self, doc: QtXml.QDomDocument, elmt: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _readXmlStyle(self, elmt: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _draw(self, context: QgsLayoutItemRenderContext, itemStyle: Optional[QtWidgets.QStyleOptionGraphicsItem] = ...) -> None: ...
    def _removeNode(self, nodeIndex: int) -> bool: ...
    def _addNode(self, indexPoint: int, newPoint: Union[QtCore.QPointF, QtCore.QPoint, float], radius: float) -> bool: ...
    def setSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def symbol(self) -> QgsFillSymbol: ...
    def clipPath(self) -> QgsGeometry: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemPolygon: ...


class QgsLayoutItemPolyline(QgsLayoutNodesItem):

    class MarkerMode(int):
        ...
    NoMarker: QgsLayoutItemPolyline.MarkerMode = ...
    ArrowHead: QgsLayoutItemPolyline.MarkerMode = ...
    SvgMarker: QgsLayoutItemPolyline.MarkerMode = ...

    @overload
    def __init__(self, layout: QgsLayout) -> None: ...
    @overload
    def __init__(self, polyline: QtGui.QPolygonF, layout: QgsLayout) -> None: ...

    def updateBoundingRect(self) -> None: ...
    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def _writeXmlStyle(self, doc: QtXml.QDomDocument, elmt: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _readXmlStyle(self, elmt: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def _draw(self, context: QgsLayoutItemRenderContext, itemStyle: Optional[QtWidgets.QStyleOptionGraphicsItem] = ...) -> None: ...
    def _removeNode(self, nodeIndex: int) -> bool: ...
    def _addNode(self, indexPoint: int, newPoint: Union[QtCore.QPointF, QtCore.QPoint, float], radius: float) -> bool: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def arrowHeadStrokeWidth(self) -> float: ...
    def setArrowHeadStrokeWidth(self, width: float) -> None: ...
    def setArrowHeadFillColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def arrowHeadFillColor(self) -> QtGui.QColor: ...
    def setArrowHeadStrokeColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def arrowHeadStrokeColor(self) -> QtGui.QColor: ...
    def endSvgMarkerPath(self) -> str: ...
    def setEndSvgMarkerPath(self, path: str) -> None: ...
    def startSvgMarkerPath(self) -> str: ...
    def setStartSvgMarkerPath(self, path: str) -> None: ...
    def arrowHeadWidth(self) -> float: ...
    def setArrowHeadWidth(self, width: float) -> None: ...
    def setEndMarker(self, mode: QgsLayoutItemPolyline.MarkerMode) -> None: ...
    def endMarker(self) -> QgsLayoutItemPolyline.MarkerMode: ...
    def setStartMarker(self, mode: QgsLayoutItemPolyline.MarkerMode) -> None: ...
    def startMarker(self) -> QgsLayoutItemPolyline.MarkerMode: ...
    def setSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def symbol(self) -> QgsLineSymbol: ...
    def shape(self) -> QtGui.QPainterPath: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemPolyline: ...


class QgsLayoutItemAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, type: int, visibleName: str, visiblePluralName: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutItemAbstractMetadata) -> None: ...

    def resolvePaths(self, properties: Dict[str, typing.Any], pathResolver: QgsPathResolver, saving: bool) -> None: ...
    def createItem(self, layout: QgsLayout) -> QgsLayoutItem: ...
    def visiblePluralName(self) -> str: ...
    def visibleName(self) -> str: ...
    def type(self) -> int: ...


class QgsLayoutMultiFrameAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, type: int, visibleName: str) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutMultiFrameAbstractMetadata) -> None: ...

    def resolvePaths(self, properties: Dict[str, typing.Any], pathResolver: QgsPathResolver, saving: bool) -> None: ...
    def createMultiFrame(self, layout: QgsLayout) -> QgsLayoutMultiFrame: ...
    def visibleName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemRegistry(QtCore.QObject):

    class ItemType(int):
        ...
    LayoutItem: QgsLayoutItemRegistry.ItemType = ...
    LayoutGroup: QgsLayoutItemRegistry.ItemType = ...
    LayoutPage: QgsLayoutItemRegistry.ItemType = ...
    LayoutMap: QgsLayoutItemRegistry.ItemType = ...
    LayoutPicture: QgsLayoutItemRegistry.ItemType = ...
    LayoutLabel: QgsLayoutItemRegistry.ItemType = ...
    LayoutLegend: QgsLayoutItemRegistry.ItemType = ...
    LayoutShape: QgsLayoutItemRegistry.ItemType = ...
    LayoutPolygon: QgsLayoutItemRegistry.ItemType = ...
    LayoutPolyline: QgsLayoutItemRegistry.ItemType = ...
    LayoutScaleBar: QgsLayoutItemRegistry.ItemType = ...
    LayoutFrame: QgsLayoutItemRegistry.ItemType = ...
    LayoutHtml: QgsLayoutItemRegistry.ItemType = ...
    LayoutAttributeTable: QgsLayoutItemRegistry.ItemType = ...
    LayoutTextTable: QgsLayoutItemRegistry.ItemType = ...
    Layout3DMap: QgsLayoutItemRegistry.ItemType = ...
    LayoutManualTable: QgsLayoutItemRegistry.ItemType = ...
    LayoutMarker: QgsLayoutItemRegistry.ItemType = ...
    PluginItem: QgsLayoutItemRegistry.ItemType = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def multiFrameTypeAdded(self, type: int, name: str) -> None: ...
    def typeAdded(self, type: int, name: str) -> None: ...
    def itemTypes(self) -> Dict[int, str]: ...
    def resolvePaths(self, type: int, properties: Dict[str, typing.Any], pathResolver: QgsPathResolver, saving: bool) -> None: ...
    def createMultiFrame(self, type: int, layout: QgsLayout) -> QgsLayoutMultiFrame: ...
    def createItem(self, type: int, layout: QgsLayout) -> QgsLayoutItem: ...
    def addLayoutMultiFrameType(self, metadata: QgsLayoutMultiFrameAbstractMetadata) -> bool: ...
    def addLayoutItemType(self, metadata: QgsLayoutItemAbstractMetadata) -> bool: ...
    def multiFrameMetadata(self, type: int) -> QgsLayoutMultiFrameAbstractMetadata: ...
    def itemMetadata(self, type: int) -> QgsLayoutItemAbstractMetadata: ...
    def populate(self) -> bool: ...


class QgsLayoutItemScaleBar(QgsLayoutItem):

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def exportLayerBehavior(self) -> QgsLayoutItem.ExportLayerBehavior: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def finalizeRestoreFromXml(self) -> None: ...
    def refreshDataDefinedProperty(self, property: QgsLayoutObject.DataDefinedProperty = ...) -> None: ...
    def update(self) -> None: ...
    def setNumericFormat(self, format: QgsNumericFormat) -> None: ...
    def numericFormat(self) -> QgsNumericFormat: ...
    def style(self) -> str: ...
    def setStyle(self, name: str) -> None: ...
    def resizeToMinimumWidth(self) -> None: ...
    def applyDefaultSize(self, units: QgsUnitTypes.DistanceUnit = ...) -> None: ...
    def guessUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def applyDefaultRendererSettings(self, renderer: QgsScaleBarRenderer) -> bool: ...
    def applyDefaultSettings(self) -> None: ...
    def setLineCapStyle(self, style: QtCore.Qt.PenCapStyle) -> None: ...
    def lineCapStyle(self) -> QtCore.Qt.PenCapStyle: ...
    def setLineJoinStyle(self, style: QtCore.Qt.PenJoinStyle) -> None: ...
    def lineJoinStyle(self) -> QtCore.Qt.PenJoinStyle: ...
    def setUnits(self, units: QgsUnitTypes.DistanceUnit) -> None: ...
    def units(self) -> QgsUnitTypes.DistanceUnit: ...
    def setAlignment(self, alignment: QgsScaleBarSettings.Alignment) -> None: ...
    def alignment(self) -> QgsScaleBarSettings.Alignment: ...
    def setLabelHorizontalPlacement(self, placement: QgsScaleBarSettings.LabelHorizontalPlacement) -> None: ...
    def labelHorizontalPlacement(self) -> QgsScaleBarSettings.LabelHorizontalPlacement: ...
    def setLabelVerticalPlacement(self, placement: QgsScaleBarSettings.LabelVerticalPlacement) -> None: ...
    def labelVerticalPlacement(self) -> QgsScaleBarSettings.LabelVerticalPlacement: ...
    def setBoxContentSpace(self, space: float) -> None: ...
    def boxContentSpace(self) -> float: ...
    def setLabelBarSpace(self, space: float) -> None: ...
    def labelBarSpace(self) -> float: ...
    def linkedMap(self) -> QgsLayoutItemMap: ...
    def setLinkedMap(self, map: QgsLayoutItemMap) -> None: ...
    def setHeight(self, height: float) -> None: ...
    def height(self) -> float: ...
    def brush2(self) -> QtGui.QBrush: ...
    def brush(self) -> QtGui.QBrush: ...
    def pen(self) -> QtGui.QPen: ...
    def setLineWidth(self, width: float) -> None: ...
    def lineWidth(self) -> float: ...
    def setLineColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def lineColor(self) -> QtGui.QColor: ...
    def setFillColor2(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fillColor2(self) -> QtGui.QColor: ...
    def setFillColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fillColor(self) -> QtGui.QColor: ...
    def setFontColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def fontColor(self) -> QtGui.QColor: ...
    def setFont(self, font: QtGui.QFont) -> None: ...
    def font(self) -> QtGui.QFont: ...
    def setAlternateFillSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def alternateFillSymbol(self) -> QgsFillSymbol: ...
    def setFillSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def fillSymbol(self) -> QgsFillSymbol: ...
    def setSubdivisionLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def subdivisionLineSymbol(self) -> QgsLineSymbol: ...
    def setDivisionLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def divisionLineSymbol(self) -> QgsLineSymbol: ...
    def setLineSymbol(self, symbol: QgsLineSymbol) -> None: ...
    def lineSymbol(self) -> QgsLineSymbol: ...
    def setTextFormat(self, format: QgsTextFormat) -> None: ...
    def textFormat(self) -> QgsTextFormat: ...
    def setUnitLabel(self, label: str) -> None: ...
    def unitLabel(self) -> str: ...
    def setMapUnitsPerScaleBarUnit(self, units: float) -> None: ...
    def mapUnitsPerScaleBarUnit(self) -> float: ...
    def setMaximumBarWidth(self, maxWidth: float) -> None: ...
    def maximumBarWidth(self) -> float: ...
    def setMinimumBarWidth(self, minWidth: float) -> None: ...
    def minimumBarWidth(self) -> float: ...
    def setSegmentSizeMode(self, mode: QgsScaleBarSettings.SegmentSizeMode) -> None: ...
    def segmentSizeMode(self) -> QgsScaleBarSettings.SegmentSizeMode: ...
    def setUnitsPerSegment(self, units: float) -> None: ...
    def unitsPerSegment(self) -> float: ...
    def setSubdivisionsHeight(self, height: float) -> None: ...
    def subdivisionsHeight(self) -> float: ...
    def setNumberOfSubdivisions(self, subdivisions: int) -> None: ...
    def numberOfSubdivisions(self) -> int: ...
    def setNumberOfSegmentsLeft(self, segments: int) -> None: ...
    def numberOfSegmentsLeft(self) -> int: ...
    def setNumberOfSegments(self, segments: int) -> None: ...
    def numberOfSegments(self) -> int: ...
    def minimumSize(self) -> QgsLayoutSize: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemScaleBar: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...


class QgsLayoutItemShape(QgsLayoutItem):

    class Shape(int):
        ...
    Ellipse: QgsLayoutItemShape.Shape = ...
    Rectangle: QgsLayoutItemShape.Shape = ...
    Triangle: QgsLayoutItemShape.Shape = ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def draw(self, context: QgsLayoutItemRenderContext) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def estimatedFrameBleed(self) -> float: ...
    def boundingRect(self) -> QtCore.QRectF: ...
    def clipPath(self) -> QgsGeometry: ...
    def cornerRadius(self) -> QgsLayoutMeasurement: ...
    def setCornerRadius(self, radius: QgsLayoutMeasurement) -> None: ...
    def symbol(self) -> QgsFillSymbol: ...
    def setSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def setShapeType(self, type: QgsLayoutItemShape.Shape) -> None: ...
    def shapeType(self) -> QgsLayoutItemShape.Shape: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def displayName(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...
    def type(self) -> int: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemShape: ...


class QgsLayoutItemTextTable(QgsLayoutTable):

    def __init__(self, layout: QgsLayout) -> None: ...

    def getTableContents(self, contents: typing.Any) -> bool: ...
    def setContents(self, contents: Iterable[Iterable[str]]) -> None: ...
    def addRow(self, row: Iterable[str]) -> None: ...
    @staticmethod
    def create(layout: QgsLayout) -> QgsLayoutItemTextTable: ...
    def displayName(self) -> str: ...
    def type(self) -> int: ...


class QgsLayoutManager(QtCore.QObject):

    def __init__(self, project: Optional[QgsProject] = ...) -> None: ...

    def layoutRenamed(self, layout: QgsMasterLayoutInterface, newName: str) -> None: ...
    def layoutAboutToBeRemoved(self, name: str) -> None: ...
    def layoutRemoved(self, name: str) -> None: ...
    def layoutAdded(self, name: str) -> None: ...
    def layoutAboutToBeAdded(self, name: str) -> None: ...
    def accept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def generateUniqueTitle(self, type: QgsMasterLayoutInterface.Type = ...) -> str: ...
    def duplicateLayout(self, layout: QgsMasterLayoutInterface, newName: str) -> QgsMasterLayoutInterface: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def readXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...
    def layoutByName(self, name: str) -> QgsMasterLayoutInterface: ...
    def printLayouts(self) -> List[QgsPrintLayout]: ...
    def layouts(self) -> List[QgsMasterLayoutInterface]: ...
    def clear(self) -> None: ...
    def removeLayout(self, layout: QgsMasterLayoutInterface) -> bool: ...
    def addLayout(self, layout: QgsMasterLayoutInterface) -> bool: ...


class QgsLayoutManagerModel(QtCore.QAbstractListModel):

    class Role(int):
        ...
    LayoutRole: QgsLayoutManagerModel.Role = ...

    def __init__(self, manager: QgsLayoutManager, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def allowEmptyLayout(self) -> bool: ...
    def setAllowEmptyLayout(self, allowEmpty: bool) -> None: ...
    def indexFromLayout(self, layout: QgsMasterLayoutInterface) -> QtCore.QModelIndex: ...
    def layoutFromIndex(self, index: QtCore.QModelIndex) -> QgsMasterLayoutInterface: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int = ...) -> bool: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def rowCount(self, parent: QtCore.QModelIndex) -> int: ...


class QgsLayoutManagerProxyModel(QtCore.QSortFilterProxyModel):

    class Filter(int):
        ...
    FilterPrintLayouts: QgsLayoutManagerProxyModel.Filter = ...
    FilterReports: QgsLayoutManagerProxyModel.Filter = ...

    class Filters(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLayoutManagerProxyModel.Filters, QgsLayoutManagerProxyModel.Filter]) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutManagerProxyModel.Filters) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLayoutManagerProxyModel.Filters: ...
        def __int__(self) -> int: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def setFilterString(self, filter: str) -> None: ...
    def filterString(self) -> str: ...
    def setFilters(self, filters: Union[QgsLayoutManagerProxyModel.Filters, QgsLayoutManagerProxyModel.Filter]) -> None: ...
    def filters(self) -> QgsLayoutManagerProxyModel.Filters: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...


class QgsLayoutMeasurement(sip.wrapper):

    @overload
    def __init__(self, length: float, units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutMeasurement) -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def decodeMeasurement(string: str) -> QgsLayoutMeasurement: ...
    def encodeMeasurement(self) -> str: ...
    def setUnits(self, units: QgsUnitTypes.LayoutUnit) -> None: ...
    def units(self) -> QgsUnitTypes.LayoutUnit: ...
    def setLength(self, length: float) -> None: ...
    def length(self) -> float: ...


class QgsLayoutMeasurementConverter(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutMeasurementConverter) -> None: ...

    @overload
    def convert(self, measurement: QgsLayoutMeasurement, targetUnits: QgsUnitTypes.LayoutUnit) -> QgsLayoutMeasurement: ...
    @overload
    def convert(self, size: QgsLayoutSize, targetUnits: QgsUnitTypes.LayoutUnit) -> QgsLayoutSize: ...
    @overload
    def convert(self, point: QgsLayoutPoint, targetUnits: QgsUnitTypes.LayoutUnit) -> QgsLayoutPoint: ...
    def dpi(self) -> float: ...
    def setDpi(self, dpi: float) -> None: ...


class QgsLayoutModel(QtCore.QAbstractItemModel):

    class Columns(int):
        ...
    Visibility: QgsLayoutModel.Columns = ...
    LockStatus: QgsLayoutModel.Columns = ...
    ItemId: QgsLayoutModel.Columns = ...

    def __init__(self, layout: QgsLayout, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def indexForItem(self, item: QgsLayoutItem, column: int = ...) -> QtCore.QModelIndex: ...
    def itemFromIndex(self, index: QtCore.QModelIndex) -> QgsLayoutItem: ...
    def removeRows(self, row: int, count: int, parent: QtCore.QModelIndex = ...) -> bool: ...
    def dropMimeData(self, data: QtCore.QMimeData, action: QtCore.Qt.DropAction, row: int, column: int, parent: QtCore.QModelIndex) -> bool: ...
    def mimeData(self, indexes: Iterable[QtCore.QModelIndex]) -> QtCore.QMimeData: ...
    def mimeTypes(self) -> List[str]: ...
    def supportedDropActions(self) -> QtCore.Qt.DropActions: ...
    def headerData(self, section: int, orientation: QtCore.Qt.Orientation, role: int = ...) -> typing.Any: ...
    def setData(self, index: QtCore.QModelIndex, value: typing.Any, role: int) -> bool: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...


class QgsLayoutProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, layout: QgsLayout, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, sourceRow: int, sourceParent: QtCore.QModelIndex) -> bool: ...
    def itemFlags(self) -> QgsLayoutItem.Flags: ...
    def setItemFlags(self, flags: Union[QgsLayoutItem.Flags, QgsLayoutItem.Flag]) -> None: ...
    def allowEmptyItem(self) -> bool: ...
    def setAllowEmptyItem(self, allowEmpty: bool) -> None: ...
    def layout(self) -> QgsLayout: ...
    def itemFromSourceIndex(self, sourceIndex: QtCore.QModelIndex) -> QgsLayoutItem: ...
    def sourceLayerModel(self) -> QgsLayoutModel: ...
    def exceptedItemList(self) -> List[QgsLayoutItem]: ...
    def setExceptedItemList(self, items: Iterable[QgsLayoutItem]) -> None: ...
    def setFilterType(self, filter: QgsLayoutItemRegistry.ItemType) -> None: ...
    def filterType(self) -> QgsLayoutItemRegistry.ItemType: ...


class QgsLayoutNorthArrowHandler(QtCore.QObject):

    class NorthMode(int):
        ...
    GridNorth: QgsLayoutNorthArrowHandler.NorthMode = ...
    TrueNorth: QgsLayoutNorthArrowHandler.NorthMode = ...

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def arrowRotationChanged(self, newRotation: float) -> None: ...
    def setNorthOffset(self, offset: float) -> None: ...
    def northOffset(self) -> float: ...
    def setNorthMode(self, mode: QgsLayoutNorthArrowHandler.NorthMode) -> None: ...
    def northMode(self) -> QgsLayoutNorthArrowHandler.NorthMode: ...
    def linkedMap(self) -> QgsLayoutItemMap: ...
    def setLinkedMap(self, map: QgsLayoutItemMap) -> None: ...
    def arrowRotation(self) -> float: ...


class QgsLayoutPageCollection(QtCore.QObject, QgsLayoutSerializableObject):

    def __init__(self, layout: QgsLayout) -> None: ...

    def pageAboutToBeRemoved(self, pageNumber: int) -> None: ...
    def changed(self) -> None: ...
    def redraw(self) -> None: ...
    def guides(self) -> QgsLayoutGuideCollection: ...
    def readXml(self, collectionElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def resizeToContents(self, margins: QgsMargins, marginUnits: QgsUnitTypes.LayoutUnit) -> None: ...
    def pageShadowWidth(self) -> float: ...
    def spaceBetweenPages(self) -> float: ...
    def positionOnPage(self, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> QtCore.QPointF: ...
    def pagePositionToAbsolute(self, page: int, position: QgsLayoutPoint) -> QgsLayoutPoint: ...
    def pagePositionToLayoutPosition(self, page: int, position: QgsLayoutPoint) -> QtCore.QPointF: ...
    def pageAtPoint(self, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> QgsLayoutItemPage: ...
    def predictPageNumberForPoint(self, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> int: ...
    def pageNumberForPoint(self, point: Union[QtCore.QPointF, QtCore.QPoint, float]) -> int: ...
    def hasUniformPageSizes(self) -> bool: ...
    def maximumPageSize(self) -> QtCore.QSizeF: ...
    def maximumPageWidth(self) -> float: ...
    def reflow(self) -> None: ...
    def endPageSizeChange(self) -> None: ...
    def beginPageSizeChange(self) -> None: ...
    def pageStyleSymbol(self) -> QgsFillSymbol: ...
    def setPageStyleSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def takePage(self, page: QgsLayoutItemPage) -> QgsLayoutItemPage: ...
    def clear(self) -> None: ...
    @overload
    def deletePage(self, pageNumber: int) -> None: ...
    @overload
    def deletePage(self, page: QgsLayoutItemPage) -> None: ...
    def insertPage(self, page: QgsLayoutItemPage, beforePage: int) -> None: ...
    def extendByNewPage(self) -> QgsLayoutItemPage: ...
    def addPage(self, page: QgsLayoutItemPage) -> None: ...
    def shouldExportPage(self, page: int) -> bool: ...
    def itemsOnPage(self, page: int) -> List[QgsLayoutItem]: ...
    def pageIsEmpty(self, page: int) -> bool: ...
    def visiblePageNumbers(self, region: QtCore.QRectF) -> List[int]: ...
    def visiblePages(self, region: QtCore.QRectF) -> List[QgsLayoutItemPage]: ...
    def pageNumber(self, page: QgsLayoutItemPage) -> int: ...
    def page(self, pageNumber: int) -> QgsLayoutItemPage: ...
    def pageCount(self) -> int: ...
    def pages(self) -> List[QgsLayoutItemPage]: ...
    def layout(self) -> QgsLayout: ...
    def stringType(self) -> str: ...


class QgsLayoutPoint(sip.wrapper):

    @overload
    def __init__(self, x: float, y: float, units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutPoint) -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def decodePoint(string: str) -> QgsLayoutPoint: ...
    def encodePoint(self) -> str: ...
    def toQPointF(self) -> QtCore.QPointF: ...
    def isNull(self) -> bool: ...
    def setUnits(self, units: QgsUnitTypes.LayoutUnit) -> None: ...
    def units(self) -> QgsUnitTypes.LayoutUnit: ...
    def setY(self, y: float) -> None: ...
    def y(self) -> float: ...
    def setX(self, x: float) -> None: ...
    def x(self) -> float: ...
    def setPoint(self, x: float, y: float) -> None: ...


class QgsLayoutRenderContext(QtCore.QObject):

    class Flag(int):
        ...
    FlagDebug: QgsLayoutRenderContext.Flag = ...
    FlagOutlineOnly: QgsLayoutRenderContext.Flag = ...
    FlagAntialiasing: QgsLayoutRenderContext.Flag = ...
    FlagUseAdvancedEffects: QgsLayoutRenderContext.Flag = ...
    FlagForceVectorOutput: QgsLayoutRenderContext.Flag = ...
    FlagHideCoverageLayer: QgsLayoutRenderContext.Flag = ...
    FlagDrawSelection: QgsLayoutRenderContext.Flag = ...
    FlagDisableTiledRasterLayerRenders: QgsLayoutRenderContext.Flag = ...
    FlagRenderLabelsByMapLayer: QgsLayoutRenderContext.Flag = ...
    FlagLosslessImageRendering: QgsLayoutRenderContext.Flag = ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsLayoutRenderContext.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsLayoutRenderContext.Flags: ...
        def __int__(self) -> int: ...

    def __init__(self, layout: QgsLayout) -> None: ...

    def predefinedScalesChanged(self) -> None: ...
    def dpiChanged(self) -> None: ...
    def flagsChanged(self, flags: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag]) -> None: ...
    def setFeatureFilterProvider(self, featureFilterProvider: QgsFeatureFilterProvider) -> None: ...
    def featureFilterProvider(self) -> QgsFeatureFilterProvider: ...
    def predefinedScales(self) -> List[float]: ...
    def setPredefinedScales(self, scales: Iterable[float]) -> None: ...
    def setExportThemes(self, themes: Iterable[str]) -> None: ...
    def exportThemes(self) -> List[str]: ...
    def simplifyMethod(self) -> QgsVectorSimplifyMethod: ...
    def setSimplifyMethod(self, method: QgsVectorSimplifyMethod) -> None: ...
    def setTextRenderFormat(self, format: QgsRenderContext.TextRenderFormat) -> None: ...
    def textRenderFormat(self) -> QgsRenderContext.TextRenderFormat: ...
    def currentExportLayer(self) -> int: ...
    def setCurrentExportLayer(self, layer: int = ...) -> None: ...
    def pagesVisible(self) -> bool: ...
    def setPagesVisible(self, visible: bool) -> None: ...
    def setBoundingBoxesVisible(self, visible: bool) -> None: ...
    def boundingBoxesVisible(self) -> bool: ...
    def setGridVisible(self, visible: bool) -> None: ...
    def gridVisible(self) -> bool: ...
    def isPreviewRender(self) -> bool: ...
    def measurementConverter(self) -> QgsLayoutMeasurementConverter: ...
    def selectionColor(self) -> QtGui.QColor: ...
    def setSelectionColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def dpi(self) -> float: ...
    def setDpi(self, dpi: float) -> None: ...
    def renderContextFlags(self) -> QgsRenderContext.Flags: ...
    def testFlag(self, flag: QgsLayoutRenderContext.Flag) -> bool: ...
    def flags(self) -> QgsLayoutRenderContext.Flags: ...
    def setFlag(self, flag: QgsLayoutRenderContext.Flag, on: bool = ...) -> None: ...
    def setFlags(self, flags: Union[QgsLayoutRenderContext.Flags, QgsLayoutRenderContext.Flag]) -> None: ...


class QgsLayoutReportContext(QtCore.QObject):

    def __init__(self, layout: QgsLayout) -> None: ...

    def changed(self) -> None: ...
    def layerChanged(self, layer: QgsVectorLayer) -> None: ...
    def predefinedScales(self) -> List[float]: ...
    def setPredefinedScales(self, scales: Iterable[float]) -> None: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def currentGeometry(self, crs: QgsCoordinateReferenceSystem = ...) -> QgsGeometry: ...
    def feature(self) -> QgsFeature: ...
    def setFeature(self, feature: QgsFeature) -> None: ...


class QgsLayoutSize(sip.wrapper):

    @overload
    def __init__(self, width: float, height: float, units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, size: QtCore.QSizeF, units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, units: QgsUnitTypes.LayoutUnit = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutSize) -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def decodeSize(string: str) -> QgsLayoutSize: ...
    def encodeSize(self) -> str: ...
    def toQSizeF(self) -> QtCore.QSizeF: ...
    def isEmpty(self) -> bool: ...
    def setUnits(self, units: QgsUnitTypes.LayoutUnit) -> None: ...
    def units(self) -> QgsUnitTypes.LayoutUnit: ...
    def setHeight(self, height: float) -> None: ...
    def height(self) -> float: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...
    def setSize(self, width: float, height: float) -> None: ...


class QgsLayoutSnapper(QgsLayoutSerializableObject):

    @overload
    def __init__(self, layout: QgsLayout) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutSnapper) -> None: ...

    def readXml(self, gridElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, parentElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def snapPointsToItems(self, points: Iterable[float], orientation: QtCore.Qt.Orientation, scaleFactor: float, ignoreItems: Iterable[QgsLayoutItem], snapLine: Optional[QtWidgets.QGraphicsLineItem] = ...) -> Tuple[float, bool]: ...
    def snapPointToItems(self, original: float, orientation: QtCore.Qt.Orientation, scaleFactor: float, ignoreItems: Iterable[QgsLayoutItem], snapLine: Optional[QtWidgets.QGraphicsLineItem] = ...) -> Tuple[float, bool]: ...
    def snapPointsToGuides(self, points: Iterable[float], orientation: QtCore.Qt.Orientation, scaleFactor: float) -> Tuple[float, bool]: ...
    def snapPointToGuides(self, original: float, orientation: QtCore.Qt.Orientation, scaleFactor: float) -> Tuple[float, bool]: ...
    def snapPointsToGrid(self, points: Iterable[Union[QtCore.QPointF, QtCore.QPoint, float]], scaleFactor: float) -> Tuple[QtCore.QPointF, bool, bool]: ...
    def snapPointToGrid(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], scaleFactor: float) -> Tuple[QtCore.QPointF, bool, bool]: ...
    def snapRect(self, rect: QtCore.QRectF, scaleFactor: float, horizontalSnapLine: Optional[QtWidgets.QGraphicsLineItem] = ..., verticalSnapLine: Optional[QtWidgets.QGraphicsLineItem] = ..., ignoreItems: Optional[Iterable[QgsLayoutItem]] = ...) -> Tuple[QtCore.QRectF, bool]: ...
    def snapPoint(self, point: Union[QtCore.QPointF, QtCore.QPoint, float], scaleFactor: float, horizontalSnapLine: Optional[QtWidgets.QGraphicsLineItem] = ..., verticalSnapLine: Optional[QtWidgets.QGraphicsLineItem] = ..., ignoreItems: Optional[Iterable[QgsLayoutItem]] = ...) -> Tuple[QtCore.QPointF, bool]: ...
    def setSnapToItems(self, enabled: bool) -> None: ...
    def snapToItems(self) -> bool: ...
    def setSnapToGuides(self, enabled: bool) -> None: ...
    def snapToGuides(self) -> bool: ...
    def setSnapToGrid(self, enabled: bool) -> None: ...
    def snapToGrid(self) -> bool: ...
    def snapTolerance(self) -> int: ...
    def setSnapTolerance(self, snapTolerance: int) -> None: ...
    def layout(self) -> QgsLayout: ...
    def stringType(self) -> str: ...


class QgsLayoutTableStyle(sip.wrapper):

    cellBackgroundColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...
    enabled: bool = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutTableStyle) -> None: ...

    def readXml(self, styleElem: QtXml.QDomElement) -> bool: ...
    def writeXml(self, styleElem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...


class QgsLayoutTableColumn(sip.wrapper):

    @overload
    def __init__(self, heading: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutTableColumn) -> None: ...

    def clone(self) -> QgsLayoutTableColumn: ...
    def setSortByRank(self, rank: int) -> None: ...
    def sortByRank(self) -> int: ...
    def setSortOrder(self, order: QtCore.Qt.SortOrder) -> None: ...
    def sortOrder(self) -> QtCore.Qt.SortOrder: ...
    def setAttribute(self, attribute: str) -> None: ...
    def attribute(self) -> str: ...
    def setVAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def vAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setHAlignment(self, alignment: QtCore.Qt.AlignmentFlag) -> None: ...
    def hAlignment(self) -> QtCore.Qt.AlignmentFlag: ...
    def setHeading(self, heading: str) -> None: ...
    def heading(self) -> str: ...
    def setWidth(self, width: float) -> None: ...
    def width(self) -> float: ...
    def readXml(self, columnElem: QtXml.QDomElement) -> bool: ...
    def writeXml(self, columnElem: QtXml.QDomElement, doc: QtXml.QDomDocument) -> bool: ...


class QgsAbstractLayoutUndoCommand(QtWidgets.QUndoCommand):

    def __init__(self, text: str, id: int = ..., parent: Optional[QtWidgets.QUndoCommand] = ...) -> None: ...

    def setAfterState(self, stateDoc: QtXml.QDomDocument) -> None: ...
    def restoreState(self, stateDoc: QtXml.QDomDocument) -> None: ...
    def saveState(self, stateDoc: QtXml.QDomDocument) -> None: ...
    def containsChange(self) -> bool: ...
    def afterState(self) -> QtXml.QDomDocument: ...
    def beforeState(self) -> QtXml.QDomDocument: ...
    def saveAfterState(self) -> None: ...
    def saveBeforeState(self) -> None: ...
    def id(self) -> int: ...
    def redo(self) -> None: ...
    def undo(self) -> None: ...


class QgsLayoutUndoStack(QtCore.QObject):

    def __init__(self, layout: QgsLayout) -> None: ...

    def undoRedoOccurredForItems(self, itemUuids: Iterable[str]) -> None: ...
    def push(self, command: QtWidgets.QUndoCommand) -> None: ...
    def isBlocked(self) -> bool: ...
    def blockCommands(self, blocked: bool) -> None: ...
    def notifyUndoRedoOccurred(self, item: QgsLayoutItem) -> None: ...
    def stack(self) -> QtWidgets.QUndoStack: ...
    def cancelCommand(self) -> None: ...
    def endCommand(self) -> None: ...
    def beginCommand(self, object: QgsLayoutUndoObjectInterface, commandText: str, id: int = ...) -> None: ...
    def endMacro(self) -> None: ...
    def beginMacro(self, commandText: str) -> None: ...


class QgsLayoutUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayoutUtils) -> None: ...

    @staticmethod
    def predefinedScales(layout: QgsLayout) -> List[float]: ...
    @staticmethod
    def itemIsAClippingSource(item: QgsLayoutItem) -> bool: ...
    @staticmethod
    def calculatePrettySize(minimumSize: float, maximumSize: float) -> float: ...
    @staticmethod
    def mapLayerFromString(string: str, project: QgsProject) -> QgsMapLayer: ...
    @overload
    @staticmethod
    def scaleFactorFromItemStyle(style: QtWidgets.QStyleOptionGraphicsItem) -> float: ...
    @overload
    @staticmethod
    def scaleFactorFromItemStyle(style: QtWidgets.QStyleOptionGraphicsItem, painter: QtGui.QPainter) -> float: ...
    @staticmethod
    def decodePaperOrientation(string: str) -> Tuple[QgsLayoutItemPage.Orientation, bool]: ...
    @staticmethod
    def largestRotatedRectWithinBounds(originalRect: QtCore.QRectF, boundsRect: QtCore.QRectF, rotation: float) -> QtCore.QRectF: ...
    @overload
    @staticmethod
    def drawText(painter: QtGui.QPainter, position: Union[QtCore.QPointF, QtCore.QPoint, float], text: str, font: QtGui.QFont, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...
    @overload
    @staticmethod
    def drawText(painter: QtGui.QPainter, rectangle: QtCore.QRectF, text: str, font: QtGui.QFont, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ..., halignment: QtCore.Qt.AlignmentFlag = ..., valignment: QtCore.Qt.AlignmentFlag = ..., flags: int = ...) -> None: ...
    @staticmethod
    def textHeightMM(font: QtGui.QFont, text: str, multiLineHeight: float = ...) -> float: ...
    @staticmethod
    def textWidthMM(font: QtGui.QFont, text: str) -> float: ...
    @staticmethod
    def fontHeightCharacterMM(font: QtGui.QFont, character: str) -> float: ...
    @staticmethod
    def fontHeightMM(font: QtGui.QFont) -> float: ...
    @staticmethod
    def fontDescentMM(font: QtGui.QFont) -> float: ...
    @staticmethod
    def fontAscentMM(font: QtGui.QFont) -> float: ...
    @staticmethod
    def scaledFontPixelSize(font: QtGui.QFont) -> QtGui.QFont: ...
    @staticmethod
    def relativePosition(position: float, beforeMin: float, beforeMax: float, afterMin: float, afterMax: float) -> float: ...
    @staticmethod
    def relativeResizeRect(rectToResize: QtCore.QRectF, boundsBefore: QtCore.QRectF, boundsAfter: QtCore.QRectF) -> None: ...
    @staticmethod
    def createRenderContextForLayout(layout: QgsLayout, painter: QtGui.QPainter, dpi: float = ...) -> QgsRenderContext: ...
    @staticmethod
    def createRenderContextForMap(map: QgsLayoutItemMap, painter: QtGui.QPainter, dpi: float = ...) -> QgsRenderContext: ...
    @staticmethod
    def snappedAngle(angle: float) -> float: ...
    @staticmethod
    def normalizedAngle(angle: float, allowNegative: bool = ...) -> float: ...
    @staticmethod
    def rotate(angle: float) -> Tuple[float, float]: ...


class QgsMasterLayoutInterface(sip.wrapper):

    class Type(int):
        ...
    PrintLayout: QgsMasterLayoutInterface.Type = ...
    Report: QgsMasterLayoutInterface.Type = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMasterLayoutInterface) -> None: ...

    def layoutAccept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def updateSettings(self) -> None: ...
    def readLayoutXml(self, layoutElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeLayoutXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def layoutProject(self) -> QgsProject: ...
    def setName(self, name: str) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def name(self) -> str: ...
    def layoutType(self) -> QgsMasterLayoutInterface.Type: ...
    def clone(self) -> QgsMasterLayoutInterface: ...


class QgsPageSize(sip.wrapper):

    displayName: str = ...
    name: str = ...
    size: QgsLayoutSize = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, size: QgsLayoutSize, displayName: str = ...) -> None: ...
    @overload
    def __init__(self, size: QgsLayoutSize) -> None: ...
    @overload
    def __init__(self, a0: QgsPageSize) -> None: ...


class QgsPageSizeRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsPageSizeRegistry) -> None: ...

    def decodePageSize(self, string: str, size: QgsPageSize) -> bool: ...
    @overload
    def find(self, name: str) -> List[QgsPageSize]: ...
    @overload
    def find(self, size: QgsLayoutSize) -> str: ...
    def entries(self) -> List[QgsPageSize]: ...
    def add(self, size: QgsPageSize) -> None: ...


class QgsPrintLayout(QgsLayout, QgsMasterLayoutInterface):

    def __init__(self, project: QgsProject) -> None: ...

    def nameChanged(self, name: str) -> None: ...
    def layoutAccept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def updateSettings(self) -> None: ...
    def createExpressionContext(self) -> QgsExpressionContext: ...
    def readLayoutXml(self, layoutElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeLayoutXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def readXml(self, layoutElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def atlas(self) -> QgsLayoutAtlas: ...
    def icon(self) -> QtGui.QIcon: ...
    def layoutType(self) -> QgsMasterLayoutInterface.Type: ...
    def layoutProject(self) -> QgsProject: ...
    def clone(self) -> QgsPrintLayout: ...


class QgsReport(QtCore.QObject, QgsAbstractReportSection, QgsMasterLayoutInterface):

    def __init__(self, project: QgsProject) -> None: ...

    def nameChanged(self, name: str) -> None: ...
    def layoutAccept(self, visitor: QgsStyleEntityVisitorInterface) -> bool: ...
    def updateSettings(self) -> None: ...
    def readLayoutXml(self, layoutElement: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writeLayoutXml(self, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def clone(self) -> QgsReport: ...
    def layoutProject(self) -> QgsProject: ...
    def icon(self) -> QtGui.QIcon: ...
    def description(self) -> str: ...
    def type(self) -> str: ...
    def layoutType(self) -> QgsMasterLayoutInterface.Type: ...


class QgsReportSectionFieldGroup(QgsAbstractReportSection):

    class SectionVisibility(int):
        ...
    IncludeWhenFeaturesFound: QgsReportSectionFieldGroup.SectionVisibility = ...
    AlwaysInclude: QgsReportSectionFieldGroup.SectionVisibility = ...

    def __init__(self, parentSection: Optional[QgsAbstractReportSection] = ...) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def reloadSettings(self) -> None: ...
    def setParentSection(self, parentSection: QgsAbstractReportSection) -> None: ...
    def reset(self) -> None: ...
    def nextBody(self) -> Tuple[QgsLayout, bool]: ...
    def prepareFooter(self) -> bool: ...
    def prepareHeader(self) -> bool: ...
    def beginRender(self) -> bool: ...
    def clone(self) -> QgsReportSectionFieldGroup: ...
    def setFooterVisibility(self, visibility: QgsReportSectionFieldGroup.SectionVisibility) -> None: ...
    def footerVisibility(self) -> QgsReportSectionFieldGroup.SectionVisibility: ...
    def setHeaderVisibility(self, visibility: QgsReportSectionFieldGroup.SectionVisibility) -> None: ...
    def headerVisibility(self) -> QgsReportSectionFieldGroup.SectionVisibility: ...
    def setSortAscending(self, sortAscending: bool) -> None: ...
    def sortAscending(self) -> bool: ...
    def setField(self, field: str) -> None: ...
    def field(self) -> str: ...
    def setLayer(self, layer: QgsVectorLayer) -> None: ...
    def layer(self) -> QgsVectorLayer: ...
    def setBodyEnabled(self, enabled: bool) -> None: ...
    def bodyEnabled(self) -> bool: ...
    def setBody(self, body: QgsLayout) -> None: ...
    def body(self) -> QgsLayout: ...
    def icon(self) -> QtGui.QIcon: ...
    def description(self) -> str: ...
    def type(self) -> str: ...


class QgsReportSectionLayout(QgsAbstractReportSection):

    def __init__(self, parentSection: Optional[QgsAbstractReportSection] = ...) -> None: ...

    def readPropertiesFromElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def writePropertiesToElement(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def reloadSettings(self) -> None: ...
    def nextBody(self) -> Tuple[QgsLayout, bool]: ...
    def beginRender(self) -> bool: ...
    def clone(self) -> QgsReportSectionLayout: ...
    def setBodyEnabled(self, enabled: bool) -> None: ...
    def bodyEnabled(self) -> bool: ...
    def setBody(self, body: QgsLayout) -> None: ...
    def body(self) -> QgsLayout: ...
    def icon(self) -> QtGui.QIcon: ...
    def description(self) -> str: ...
    def type(self) -> str: ...


class QgsLocator(QtCore.QObject):

    CORE_FILTERS: Iterable[str] = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def finished(self) -> None: ...
    def searchPrepared(self) -> None: ...
    def foundResult(self, result: QgsLocatorResult) -> None: ...
    def completionList(self) -> List[str]: ...
    def clearPreviousResults(self) -> None: ...
    def isRunning(self) -> bool: ...
    def cancelWithoutBlocking(self) -> None: ...
    def cancel(self) -> None: ...
    def fetchResults(self, string: str, context: QgsLocatorContext, feedback: Optional[QgsFeedback] = ...) -> None: ...
    def prefixedFilters(self) -> typing.Any: ...
    def filters(self, prefix: str = ...) -> List[QgsLocatorFilter]: ...
    def deregisterFilter(self, filter: QgsLocatorFilter) -> None: ...
    def registerFilter(self, filter: QgsLocatorFilter) -> None: ...


class QgsLocatorContext(sip.wrapper):

    targetExtent: QgsRectangle = ...
    targetExtentCrs: QgsCoordinateReferenceSystem = ...
    transformContext: QgsCoordinateTransformContext = ...
    usingPrefix: bool = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLocatorContext) -> None: ...


class QgsLocatorResult(sip.wrapper):

    class ResultAction(sip.wrapper):

        iconPath: str = ...
        id: int = ...
        text: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, id: int, text: str, iconPath: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsLocatorResult.ResultAction) -> None: ...

    actions: Iterable[QgsLocatorResult.ResultAction] = ...
    description: str = ...
    displayString: str = ...
    filter: QgsLocatorFilter = ...
    group: str = ...
    icon: QtGui.QIcon = ...
    score: float = ...
    userData: typing.Any = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, filter: QgsLocatorFilter, displayString: str, userData: typing.Any = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsLocatorResult) -> None: ...

    def getUserData(self) -> typing.Any: ...


class QgsLocatorModel(QtCore.QAbstractTableModel):

    class Role(int):
        ...
    ResultDataRole: QgsLocatorModel.Role = ...
    ResultTypeRole: QgsLocatorModel.Role = ...
    ResultFilterPriorityRole: QgsLocatorModel.Role = ...
    ResultScoreRole: QgsLocatorModel.Role = ...
    ResultFilterNameRole: QgsLocatorModel.Role = ...
    ResultFilterGroupSortingRole: QgsLocatorModel.Role = ...
    ResultActionsRole: QgsLocatorModel.Role = ...

    NoGroup: int = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def addResult(self, result: QgsLocatorResult) -> None: ...
    def roleNames(self) -> Dict[int, QtCore.QByteArray]: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int = ...) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def deferredClear(self) -> None: ...
    def clear(self) -> None: ...


class QgsLocatorAutomaticModel(QgsLocatorModel):

    def __init__(self, locator: QgsLocator) -> None: ...

    def createContext(self) -> QgsLocatorContext: ...
    def search(self, string: str) -> None: ...
    def locator(self) -> QgsLocator: ...


class QgsLocatorProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...


class QgsLocatorModelBridge(QtCore.QObject):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def updateCanvasCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def updateCanvasExtent(self, extent: QgsRectangle) -> None: ...
    def invalidateResults(self) -> None: ...
    def resultsCleared(self) -> None: ...
    def isRunningChanged(self) -> None: ...
    def resultAdded(self) -> None: ...
    def setTransformContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def transformContext(self) -> QgsCoordinateTransformContext: ...
    def triggerResult(self, index: QtCore.QModelIndex, actionId: int = ...) -> None: ...
    def isRunning(self) -> bool: ...
    def hasQueueRequested(self) -> bool: ...
    def proxyModel(self) -> QgsLocatorProxyModel: ...
    def locator(self) -> QgsLocator: ...
    def performSearch(self, text: str) -> None: ...


class QgsMapRendererCache(QtCore.QObject):

    def __init__(self) -> None: ...

    def invalidateCacheForLayer(self, layer: QgsMapLayer) -> None: ...
    def clearCacheImage(self, cacheKey: str) -> None: ...
    def dependentLayers(self, cacheKey: str) -> List[QgsMapLayer]: ...
    def transformedCacheImage(self, cacheKey: str, mtp: QgsMapToPixel) -> QtGui.QImage: ...
    def cacheImage(self, cacheKey: str) -> QtGui.QImage: ...
    def hasAnyCacheImage(self, cacheKey: str, minimumScaleThreshold: float = ..., maximumScaleThreshold: float = ...) -> bool: ...
    def hasCacheImage(self, cacheKey: str) -> bool: ...
    def setCacheImageWithParameters(self, cacheKey: str, image: QtGui.QImage, extent: QgsRectangle, mapToPixel: QgsMapToPixel, dependentLayers: Iterable[QgsMapLayer] = ...) -> None: ...
    def setCacheImage(self, cacheKey: str, image: QtGui.QImage, dependentLayers: Iterable[QgsMapLayer] = ...) -> None: ...
    def updateParameters(self, extent: QgsRectangle, mtp: QgsMapToPixel) -> bool: ...
    def init(self, extent: QgsRectangle, scale: float) -> bool: ...
    def clear(self) -> None: ...


class QgsMapRendererJob(QtCore.QObject):

    class Error(sip.wrapper):

        layerID: str = ...
        message: str = ...

        @overload
        def __init__(self, lid: str, msg: str) -> None: ...
        @overload
        def __init__(self, a0: QgsMapRendererJob.Error) -> None: ...

    def __init__(self, settings: QgsMapSettings) -> None: ...

    def finished(self) -> None: ...
    def renderingLayersFinished(self) -> None: ...
    def mapSettings(self) -> QgsMapSettings: ...
    def renderingTime(self) -> int: ...
    def setCache(self, cache: QgsMapRendererCache) -> None: ...
    def errors(self) -> List[QgsMapRendererJob.Error]: ...
    def featureFilterProvider(self) -> QgsFeatureFilterProvider: ...
    def setFeatureFilterProvider(self, f: QgsFeatureFilterProvider) -> None: ...
    def takeLabelingResults(self) -> QgsLabelingResults: ...
    def usedCachedLabels(self) -> bool: ...
    def isActive(self) -> bool: ...
    def waitForFinished(self) -> None: ...
    def cancelWithoutBlocking(self) -> None: ...
    def cancel(self) -> None: ...
    def start(self) -> None: ...


class QgsMapRendererAbstractCustomPainterJob(QgsMapRendererJob):

    def __init__(self, settings: QgsMapSettings) -> None: ...

    def preparePainter(self, painter: QtGui.QPainter, backgroundColor: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient] = ...) -> None: ...


class QgsMapRendererCustomPainterJob(QgsMapRendererAbstractCustomPainterJob):

    def __init__(self, settings: QgsMapSettings, painter: QtGui.QPainter) -> None: ...

    def renderPrepared(self) -> None: ...
    def prepare(self) -> None: ...
    def renderSynchronously(self) -> None: ...
    def waitForFinishedWithEventLoop(self, flags: Union[QtCore.QEventLoop.ProcessEventsFlags, QtCore.QEventLoop.ProcessEventsFlag] = ...) -> None: ...
    def takeLabelingResults(self) -> QgsLabelingResults: ...
    def usedCachedLabels(self) -> bool: ...
    def isActive(self) -> bool: ...
    def waitForFinished(self) -> None: ...
    def cancelWithoutBlocking(self) -> None: ...
    def cancel(self) -> None: ...


class QgsMapRendererQImageJob(QgsMapRendererJob):

    def __init__(self, settings: QgsMapSettings) -> None: ...

    def renderedImage(self) -> QtGui.QImage: ...


class QgsMapRendererParallelJob(QgsMapRendererQImageJob):

    def __init__(self, settings: QgsMapSettings) -> None: ...

    def renderedImage(self) -> QtGui.QImage: ...
    def takeLabelingResults(self) -> QgsLabelingResults: ...
    def usedCachedLabels(self) -> bool: ...
    def isActive(self) -> bool: ...
    def waitForFinished(self) -> None: ...
    def cancelWithoutBlocking(self) -> None: ...
    def cancel(self) -> None: ...


class QgsMapRendererSequentialJob(QgsMapRendererQImageJob):

    def __init__(self, settings: QgsMapSettings) -> None: ...

    def internalFinished(self) -> None: ...
    def renderedImage(self) -> QtGui.QImage: ...
    def takeLabelingResults(self) -> QgsLabelingResults: ...
    def usedCachedLabels(self) -> bool: ...
    def isActive(self) -> bool: ...
    def waitForFinished(self) -> None: ...
    def cancelWithoutBlocking(self) -> None: ...
    def cancel(self) -> None: ...


class QgsMapRendererTask(QgsTask):

    class ErrorType(int):
        ...
    ImageAllocationFail: QgsMapRendererTask.ErrorType = ...
    ImageSaveFail: QgsMapRendererTask.ErrorType = ...
    ImageUnsupportedFormat: QgsMapRendererTask.ErrorType = ...

    @overload
    def __init__(self, ms: QgsMapSettings, fileName: str, fileFormat: str = ..., forceRaster: bool = ...) -> None: ...
    @overload
    def __init__(self, ms: QgsMapSettings, p: QtGui.QPainter) -> None: ...

    def finished(self, result: bool) -> None: ...
    def run(self) -> bool: ...
    def errorOccurred(self, error: int) -> None: ...
    def renderingComplete(self) -> None: ...
    def cancel(self) -> None: ...
    def setExportMetadata(self, exportMetadata: bool) -> None: ...
    def setSaveWorldFile(self, save: bool) -> None: ...
    def addDecorations(self, decorations: Iterable[QgsMapDecoration]) -> None: ...
    def addAnnotations(self, annotations: Iterable[QgsAnnotation]) -> None: ...


class QgsMesh3dAveragingMethod(sip.wrapper):

    class Method(int):
        ...
    MultiLevelsAveragingMethod: QgsMesh3dAveragingMethod.Method = ...
    SigmaAveragingMethod: QgsMesh3dAveragingMethod.Method = ...
    RelativeHeightAveragingMethod: QgsMesh3dAveragingMethod.Method = ...
    ElevationAveragingMethod: QgsMesh3dAveragingMethod.Method = ...

    @overload
    def __init__(self, method: QgsMesh3dAveragingMethod.Method) -> None: ...
    @overload
    def __init__(self, a0: QgsMesh3dAveragingMethod) -> None: ...

    def method(self) -> QgsMesh3dAveragingMethod.Method: ...
    def clone(self) -> QgsMesh3dAveragingMethod: ...
    @overload
    @staticmethod
    def equals(a: QgsMesh3dAveragingMethod, b: QgsMesh3dAveragingMethod) -> bool: ...
    @overload
    def equals(self, other: QgsMesh3dAveragingMethod) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    @staticmethod
    def createFromXml(elem: QtXml.QDomElement) -> QgsMesh3dAveragingMethod: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def calculate(self, block3d: QgsMesh3dDataBlock, feedback: Optional[QgsFeedback] = ...) -> QgsMeshDataBlock: ...


class QgsMeshMultiLevelsAveragingMethod(QgsMesh3dAveragingMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, startLevel: int, endLevel: int, countedFromTop: bool) -> None: ...
    @overload
    def __init__(self, verticalLevel: int, countedFromTop: bool) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshMultiLevelsAveragingMethod) -> None: ...

    def isSingleLevel(self) -> bool: ...
    def countedFromTop(self) -> bool: ...
    def endVerticalLevel(self) -> int: ...
    def startVerticalLevel(self) -> int: ...
    def clone(self) -> QgsMesh3dAveragingMethod: ...
    def equals(self, other: QgsMesh3dAveragingMethod) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...


class QgsMeshSigmaAveragingMethod(QgsMesh3dAveragingMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, startFraction: float, endFraction: float) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshSigmaAveragingMethod) -> None: ...

    def endFraction(self) -> float: ...
    def startFraction(self) -> float: ...
    def clone(self) -> QgsMesh3dAveragingMethod: ...
    def equals(self, other: QgsMesh3dAveragingMethod) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...


class QgsMeshRelativeHeightAveragingMethod(QgsMesh3dAveragingMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, startHeight: float, endHeight: float, countedFromTop: bool) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRelativeHeightAveragingMethod) -> None: ...

    def countedFromTop(self) -> bool: ...
    def endHeight(self) -> float: ...
    def startHeight(self) -> float: ...
    def clone(self) -> QgsMesh3dAveragingMethod: ...
    def equals(self, other: QgsMesh3dAveragingMethod) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...


class QgsMeshElevationAveragingMethod(QgsMesh3dAveragingMethod):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, startElevation: float, endElevation: float) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshElevationAveragingMethod) -> None: ...

    def endElevation(self) -> float: ...
    def startElevation(self) -> float: ...
    def clone(self) -> QgsMesh3dAveragingMethod: ...
    def equals(self, other: QgsMesh3dAveragingMethod) -> bool: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...


class QgsMesh(sip.wrapper):

    class ElementType(int):
        ...
    Vertex: QgsMesh.ElementType = ...
    Edge: QgsMesh.ElementType = ...
    Face: QgsMesh.ElementType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMesh) -> None: ...

    @staticmethod
    def compareFaces(face1: Iterable[int], face2: Iterable[int]) -> bool: ...
    def clear(self) -> None: ...
    def edge(self, index: int) -> Tuple[int, int]: ...
    def face(self, index: int) -> List[int]: ...
    def vertex(self, index: int) -> QgsPoint: ...
    def edgeCount(self) -> int: ...
    def faceCount(self) -> int: ...
    def vertexCount(self) -> int: ...
    def contains(self, type: QgsMesh.ElementType) -> bool: ...


class QgsMeshDataSourceInterface(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDataSourceInterface) -> None: ...

    def populateMesh(self, mesh: QgsMesh) -> None: ...
    def edgeCount(self) -> int: ...
    def faceCount(self) -> int: ...
    def vertexCount(self) -> int: ...
    def contains(self, type: QgsMesh.ElementType) -> bool: ...


class QgsMeshDatasetSourceInterface(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetSourceInterface) -> None: ...

    def datasetIndexAtTime(self, referenceTime: Union[QtCore.QDateTime, datetime.datetime], groupIndex: int, time: int, method: QgsMeshDataProviderTemporalCapabilities.MatchingTemporalDatasetMethod) -> QgsMeshDatasetIndex: ...
    @overload
    def persistDatasetGroup(self, path: str, meta: QgsMeshDatasetGroupMetadata, datasetValues: Iterable[QgsMeshDataBlock], datasetActive: Iterable[QgsMeshDataBlock], times: Iterable[float]) -> bool: ...
    @overload
    def persistDatasetGroup(self, outputFilePath: str, outputDriver: str, meta: QgsMeshDatasetGroupMetadata, datasetValues: Iterable[QgsMeshDataBlock], datasetActive: Iterable[QgsMeshDataBlock], times: Iterable[float]) -> bool: ...
    @overload
    def persistDatasetGroup(self, outputFilePath: str, outputDriver: str, source: QgsMeshDatasetSourceInterface, datasetGroupIndex: int) -> bool: ...
    def areFacesActive(self, index: QgsMeshDatasetIndex, faceIndex: int, count: int) -> QgsMeshDataBlock: ...
    def isFaceActive(self, index: QgsMeshDatasetIndex, faceIndex: int) -> bool: ...
    def dataset3dValues(self, index: QgsMeshDatasetIndex, faceIndex: int, count: int) -> QgsMesh3dDataBlock: ...
    def datasetValues(self, index: QgsMeshDatasetIndex, valueIndex: int, count: int) -> QgsMeshDataBlock: ...
    def datasetValue(self, index: QgsMeshDatasetIndex, valueIndex: int) -> QgsMeshDatasetValue: ...
    def datasetMetadata(self, index: QgsMeshDatasetIndex) -> QgsMeshDatasetMetadata: ...
    @overload
    def datasetGroupMetadata(self, groupIndex: int) -> QgsMeshDatasetGroupMetadata: ...
    @overload
    def datasetGroupMetadata(self, index: QgsMeshDatasetIndex) -> QgsMeshDatasetGroupMetadata: ...
    @overload
    def datasetCount(self, groupIndex: int) -> int: ...
    @overload
    def datasetCount(self, index: QgsMeshDatasetIndex) -> int: ...
    def datasetGroupCount(self) -> int: ...
    def extraDatasets(self) -> List[str]: ...
    def addDataset(self, uri: str) -> bool: ...


class QgsDataProvider(QtCore.QObject):

    class ReadFlag(int):
        ...
    FlagTrustDataSource: QgsDataProvider.ReadFlag = ...
    SkipFeatureCount: QgsDataProvider.ReadFlag = ...
    FlagLoadDefaultStyle: QgsDataProvider.ReadFlag = ...
    SkipGetExtent: QgsDataProvider.ReadFlag = ...

    class ProviderProperty(int):
        ...
    EvaluateDefaultValues: QgsDataProvider.ProviderProperty = ...
    CustomData: QgsDataProvider.ProviderProperty = ...

    class DataCapability(int):
        ...
    NoDataCapabilities: QgsDataProvider.DataCapability = ...
    File: QgsDataProvider.DataCapability = ...
    Dir: QgsDataProvider.DataCapability = ...
    Database: QgsDataProvider.DataCapability = ...
    Net: QgsDataProvider.DataCapability = ...

    class DataCapabilities(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsDataProvider.DataCapabilities, QgsDataProvider.DataCapability]) -> None: ...
        @overload
        def __init__(self, a0: QgsDataProvider.DataCapabilities) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsDataProvider.DataCapabilities: ...
        def __int__(self) -> int: ...

    class ProviderOptions(sip.wrapper):

        transformContext: QgsCoordinateTransformContext = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsDataProvider.ProviderOptions) -> None: ...

    class ReadFlags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsDataProvider.ReadFlags, QgsDataProvider.ReadFlag]) -> None: ...
        @overload
        def __init__(self, a0: QgsDataProvider.ReadFlags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsDataProvider.ReadFlags: ...
        def __int__(self) -> int: ...

    def __init__(self, uri: str = ..., providerOptions: QgsDataProvider.ProviderOptions = ..., flags: Union[QgsDataProvider.ReadFlags, QgsDataProvider.ReadFlag] = ...) -> None: ...

    def setError(self, error: QgsError) -> None: ...
    def appendError(self, message: QgsErrorMessage) -> None: ...
    def notify(self, msg: str) -> None: ...
    def dataChanged(self) -> None: ...
    def fullExtentCalculated(self) -> None: ...
    @staticmethod
    def sublayerSeparator() -> str: ...
    def writeLayerMetadata(self, metadata: QgsLayerMetadata) -> bool: ...
    def layerMetadata(self) -> QgsLayerMetadata: ...
    def setListening(self, isListening: bool) -> None: ...
    def providerProperty(self, property: QgsDataProvider.ProviderProperty, defaultValue: typing.Any = ...) -> typing.Any: ...
    def setProviderProperty(self, property: QgsDataProvider.ProviderProperty, value: typing.Any) -> None: ...
    def leaveUpdateMode(self) -> bool: ...
    def enterUpdateMode(self) -> bool: ...
    def invalidateConnections(self, connection: str) -> None: ...
    def error(self) -> QgsError: ...
    def dataTimestamp(self) -> QtCore.QDateTime: ...
    def timestamp(self) -> QtCore.QDateTime: ...
    def reloadData(self) -> None: ...
    def fileRasterFilters(self) -> str: ...
    def fileVectorFilters(self) -> str: ...
    def description(self) -> str: ...
    def name(self) -> str: ...
    def setSubLayerVisibility(self, name: str, vis: bool) -> None: ...
    def setLayerOrder(self, layers: Iterable[str]) -> None: ...
    def subLayerCount(self) -> int: ...
    def subLayerStyles(self) -> List[str]: ...
    def subLayers(self) -> List[str]: ...
    def subsetString(self) -> str: ...
    def supportsSubsetString(self) -> bool: ...
    def setSubsetString(self, subset: str, updateFeatureCount: bool = ...) -> bool: ...
    def updateExtents(self) -> None: ...
    def isValid(self) -> bool: ...
    def extent(self) -> QgsRectangle: ...
    def temporalCapabilities(self) -> QgsDataProviderTemporalCapabilities: ...
    def uri(self) -> QgsDataSourceUri: ...
    def setUri(self, uri: QgsDataSourceUri) -> None: ...
    def dataComment(self) -> str: ...
    def dataSourceUri(self, expandAuthConfig: bool = ...) -> str: ...
    def setDataSourceUri(self, uri: str) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...


class QgsMeshDataProvider(QgsDataProvider, QgsMeshDataSourceInterface, QgsMeshDatasetSourceInterface):

    def __init__(self, uri: str, providerOptions: QgsDataProvider.ProviderOptions, flags: Union[QgsDataProvider.ReadFlags, QgsDataProvider.ReadFlag] = ...) -> None: ...

    def datasetGroupsAdded(self, count: int) -> None: ...
    def setTemporalUnit(self, unit: QgsUnitTypes.TemporalUnit) -> None: ...
    def temporalCapabilities(self) -> QgsMeshDataProviderTemporalCapabilities: ...


class QgsMeshDataProviderTemporalCapabilities(QgsDataProviderTemporalCapabilities):

    class MatchingTemporalDatasetMethod(int):
        ...
    FindClosestDatasetBeforeStartRangeTime: QgsMeshDataProviderTemporalCapabilities.MatchingTemporalDatasetMethod = ...
    FindClosestDatasetFromStartRangeTime: QgsMeshDataProviderTemporalCapabilities.MatchingTemporalDatasetMethod = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDataProviderTemporalCapabilities) -> None: ...

    def firstTimeStepDuration(self, group: int) -> int: ...
    def clear(self) -> None: ...
    def datasetTime(self, index: QgsMeshDatasetIndex) -> int: ...
    def temporalUnit(self) -> QgsUnitTypes.TemporalUnit: ...
    def setTemporalUnit(self, temporalUnit: QgsUnitTypes.TemporalUnit) -> None: ...
    @overload
    def timeExtent(self) -> QgsDateTimeRange: ...
    @overload
    def timeExtent(self, reference: Union[QtCore.QDateTime, datetime.datetime]) -> QgsDateTimeRange: ...
    def referenceTime(self) -> QtCore.QDateTime: ...
    def hasReferenceTime(self) -> bool: ...
    def datasetIndexClosestFromRelativeTime(self, group: int, timeSinceGlobalReference: int) -> QgsMeshDatasetIndex: ...
    def datasetIndexClosestBeforeRelativeTime(self, group: int, timeSinceGlobalReference: int) -> QgsMeshDatasetIndex: ...


class QgsMeshDatasetIndex(sip.wrapper):

    @overload
    def __init__(self, group: int = ..., dataset: int = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetIndex) -> None: ...

    def isValid(self) -> bool: ...
    def dataset(self) -> int: ...
    def group(self) -> int: ...


class QgsMeshDatasetValue(sip.wrapper):

    @overload
    def __init__(self, x: float, y: float) -> None: ...
    @overload
    def __init__(self, scalar: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetValue) -> None: ...

    def y(self) -> float: ...
    def x(self) -> float: ...
    def scalar(self) -> float: ...
    def setY(self, y: float) -> None: ...
    def setX(self, x: float) -> None: ...
    def set(self, scalar: float) -> None: ...


class QgsMeshDataBlock(sip.wrapper):

    class DataType(int):
        ...
    ActiveFlagInteger: QgsMeshDataBlock.DataType = ...
    ScalarDouble: QgsMeshDataBlock.DataType = ...
    Vector2DDouble: QgsMeshDataBlock.DataType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, type: QgsMeshDataBlock.DataType, count: int) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDataBlock) -> None: ...

    def setValid(self, valid: bool) -> None: ...
    def setValues(self, vals: Iterable[float]) -> None: ...
    def values(self) -> List[float]: ...
    def setActive(self, vals: Iterable[int]) -> None: ...
    @overload
    def active(self, index: int) -> bool: ...
    @overload
    def active(self) -> List[int]: ...
    def value(self, index: int) -> QgsMeshDatasetValue: ...
    def isValid(self) -> bool: ...
    def count(self) -> int: ...
    def type(self) -> QgsMeshDataBlock.DataType: ...


class QgsMesh3dDataBlock(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, count: int, isVector: bool) -> None: ...
    @overload
    def __init__(self, a0: QgsMesh3dDataBlock) -> None: ...

    def setValues(self, doubleBuffer: Iterable[float]) -> None: ...
    def value(self, volumeIndex: int) -> QgsMeshDatasetValue: ...
    def values(self) -> List[float]: ...
    def setFaceToVolumeIndex(self, faceToVolumeIndex: Iterable[int]) -> None: ...
    def faceToVolumeIndex(self) -> List[int]: ...
    def setVerticalLevels(self, verticalLevels: Iterable[float]) -> None: ...
    def verticalLevels(self) -> List[float]: ...
    def setVerticalLevelsCount(self, verticalLevelsCount: Iterable[int]) -> None: ...
    def verticalLevelsCount(self) -> List[int]: ...
    def volumesCount(self) -> int: ...
    def lastVolumeIndex(self) -> int: ...
    def firstVolumeIndex(self) -> int: ...
    def count(self) -> int: ...
    def isVector(self) -> bool: ...
    def isValid(self) -> bool: ...
    def setValid(self, valid: bool) -> None: ...


class QgsMeshDatasetGroupMetadata(sip.wrapper):

    class DataType(int):
        ...
    DataOnFaces: QgsMeshDatasetGroupMetadata.DataType = ...
    DataOnVertices: QgsMeshDatasetGroupMetadata.DataType = ...
    DataOnVolumes: QgsMeshDatasetGroupMetadata.DataType = ...
    DataOnEdges: QgsMeshDatasetGroupMetadata.DataType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, uri: str, isScalar: bool, dataType: QgsMeshDatasetGroupMetadata.DataType, minimum: float, maximum: float, maximumVerticalLevels: int, referenceTime: Union[QtCore.QDateTime, datetime.datetime], isTemporal: bool, extraOptions: Dict[str, str]) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetGroupMetadata) -> None: ...

    def referenceTime(self) -> QtCore.QDateTime: ...
    def maximumVerticalLevelsCount(self) -> int: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def dataType(self) -> QgsMeshDatasetGroupMetadata.DataType: ...
    def isTemporal(self) -> bool: ...
    def isScalar(self) -> bool: ...
    def isVector(self) -> bool: ...
    def extraOptions(self) -> Dict[str, str]: ...
    def uri(self) -> str: ...
    def name(self) -> str: ...


class QgsMeshDatasetMetadata(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, time: float, isValid: bool, minimum: float, maximum: float, maximumVerticalLevels: int) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetMetadata) -> None: ...

    def maximumVerticalLevelsCount(self) -> int: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def isValid(self) -> bool: ...
    def time(self) -> float: ...


class QgsMeshDataset(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDataset) -> None: ...

    def valuesCount(self) -> int: ...
    def metadata(self) -> QgsMeshDatasetMetadata: ...
    def isActive(self, faceIndex: int) -> bool: ...
    def areFacesActive(self, faceIndex: int, count: int) -> QgsMeshDataBlock: ...
    def datasetValues(self, isScalar: bool, valueIndex: int, count: int) -> QgsMeshDataBlock: ...
    def datasetValue(self, valueIndex: int) -> QgsMeshDatasetValue: ...


class QgsMeshDatasetGroup(sip.wrapper):

    class Type(int):
        ...
    # None: QgsMeshDatasetGroup.Type = ...
    Persistent: QgsMeshDatasetGroup.Type = ...
    Memory: QgsMeshDatasetGroup.Type = ...
    Virtual: QgsMeshDatasetGroup.Type = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str) -> None: ...
    @overload
    def __init__(self, name: str, dataType: QgsMeshDatasetGroupMetadata.DataType) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetGroup) -> None: ...

    def setReferenceTime(self, referenceTime: Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def description(self) -> str: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def datasetGroupNamesDependentOn(self) -> List[str]: ...
    def calculateStatistic(self) -> None: ...
    def checkValueCountPerDataset(self, count: int) -> bool: ...
    def setIsScalar(self, isScalar: bool) -> None: ...
    def isScalar(self) -> bool: ...
    def extraMetadata(self) -> Dict[str, str]: ...
    def addExtraMetadata(self, key: str, value: str) -> None: ...
    def setDataType(self, dataType: QgsMeshDatasetGroupMetadata.DataType) -> None: ...
    def dataType(self) -> QgsMeshDatasetGroupMetadata.DataType: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def setMinimumMaximum(self, min: float, max: float) -> None: ...
    def maximum(self) -> float: ...
    def minimum(self) -> float: ...
    def type(self) -> QgsMeshDatasetGroup.Type: ...
    def dataset(self, index: int) -> QgsMeshDataset: ...
    def datasetCount(self) -> int: ...
    def datasetMetadata(self, datasetIndex: int) -> QgsMeshDatasetMetadata: ...
    def groupMetadata(self) -> QgsMeshDatasetGroupMetadata: ...
    def initialize(self) -> None: ...


class QgsMeshDatasetGroupTreeItem(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, defaultName: str, sourceName: str, isVector: bool, index: int) -> None: ...
    @overload
    def __init__(self, itemElement: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshDatasetGroupTreeItem) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def setPersistentDatasetGroup(self, uri: str) -> None: ...
    def setDatasetGroup(self, datasetGroup: QgsMeshDatasetGroup) -> None: ...
    def description(self) -> str: ...
    def groupIndexDependencies(self) -> List[int]: ...
    def datasetGroupType(self) -> QgsMeshDatasetGroup.Type: ...
    def defaultName(self) -> str: ...
    def setIsEnabled(self, isEnabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...
    def datasetGroupIndex(self) -> int: ...
    def isVector(self) -> bool: ...
    def providerName(self) -> str: ...
    def setName(self, name: str) -> None: ...
    def name(self) -> str: ...
    def row(self) -> int: ...
    def parentItem(self) -> QgsMeshDatasetGroupTreeItem: ...
    def enabledDatasetGroupIndexes(self) -> List[int]: ...
    def totalChildCount(self) -> int: ...
    def childCount(self) -> int: ...
    def childFromDatasetGroupIndex(self, index: int) -> QgsMeshDatasetGroupTreeItem: ...
    def child(self, row: int) -> QgsMeshDatasetGroupTreeItem: ...
    def removeChild(self, item: QgsMeshDatasetGroupTreeItem) -> None: ...
    def appendChild(self, item: QgsMeshDatasetGroupTreeItem) -> None: ...
    def clone(self) -> QgsMeshDatasetGroupTreeItem: ...


class QgsMeshLayer(QgsMapLayer):

    class LayerOptions(sip.wrapper):

        skipCrsValidation: bool = ...
        transformContext: QgsCoordinateTransformContext = ...

        @overload
        def __init__(self, transformContext: QgsCoordinateTransformContext = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsMeshLayer.LayerOptions) -> None: ...

    def __init__(self, path: str = ..., baseName: str = ..., providerLib: str = ..., options: QgsMeshLayer.LayerOptions = ...) -> None: ...

    def timeSettingsChanged(self) -> None: ...
    def activeVectorDatasetGroupChanged(self, index: int) -> None: ...
    def activeScalarDatasetGroupChanged(self, index: int) -> None: ...
    def setTransformContext(self, transformContext: QgsCoordinateTransformContext) -> None: ...
    def datasetRelativeTimeInMilliseconds(self, index: QgsMeshDatasetIndex) -> int: ...
    def datasetRelativeTime(self, index: QgsMeshDatasetIndex) -> QgsInterval: ...
    def firstValidTimeStep(self) -> QgsInterval: ...
    def resetDatasetGroupTreeItem(self) -> None: ...
    def setDatasetGroupTreeRootItem(self, rootItem: QgsMeshDatasetGroupTreeItem) -> None: ...
    def datasetGroupTreeRootItem(self) -> QgsMeshDatasetGroupTreeItem: ...
    def snapOnElement(self, elementType: QgsMesh.ElementType, point: QgsPointXY, searchRadius: float) -> QgsPointXY: ...
    def setTemporalMatchingMethod(self, matchingMethod: QgsMeshDataProviderTemporalCapabilities.MatchingTemporalDatasetMethod) -> None: ...
    def setReferenceTime(self, referenceTime: Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def staticVectorDatasetIndex(self) -> QgsMeshDatasetIndex: ...
    def staticScalarDatasetIndex(self) -> QgsMeshDatasetIndex: ...
    def activeVectorDatasetAtTime(self, timeRange: QgsDateTimeRange) -> QgsMeshDatasetIndex: ...
    def activeScalarDatasetAtTime(self, timeRange: QgsDateTimeRange) -> QgsMeshDatasetIndex: ...
    def datasetIndexAtRelativeTime(self, relativeTime: QgsInterval, datasetGroupIndex: int) -> QgsMeshDatasetIndex: ...
    def datasetIndexAtTime(self, timeRange: QgsDateTimeRange, datasetGroupIndex: int) -> QgsMeshDatasetIndex: ...
    def dataset1dValue(self, index: QgsMeshDatasetIndex, point: QgsPointXY, searchRadius: float) -> QgsMeshDatasetValue: ...
    def dataset3dValue(self, index: QgsMeshDatasetIndex, point: QgsPointXY) -> QgsMesh3dDataBlock: ...
    def areFacesActive(self, index: QgsMeshDatasetIndex, faceIndex: int, count: int) -> QgsMeshDataBlock: ...
    def isFaceActive(self, index: QgsMeshDatasetIndex, faceIndex: int) -> bool: ...
    def dataset3dValues(self, index: QgsMeshDatasetIndex, faceIndex: int, count: int) -> QgsMesh3dDataBlock: ...
    def datasetValues(self, index: QgsMeshDatasetIndex, valueIndex: int, count: int) -> QgsMeshDataBlock: ...
    @overload
    def datasetValue(self, index: QgsMeshDatasetIndex, valueIndex: int) -> QgsMeshDatasetValue: ...
    @overload
    def datasetValue(self, index: QgsMeshDatasetIndex, point: QgsPointXY, searchRadius: float = ...) -> QgsMeshDatasetValue: ...
    def datasetMetadata(self, index: QgsMeshDatasetIndex) -> QgsMeshDatasetMetadata: ...
    def datasetCount(self, index: QgsMeshDatasetIndex) -> int: ...
    def datasetGroupMetadata(self, index: QgsMeshDatasetIndex) -> QgsMeshDatasetGroupMetadata: ...
    def enabledDatasetGroupsIndexes(self) -> List[int]: ...
    def datasetGroupsIndexes(self) -> List[int]: ...
    def extraDatasetGroupCount(self) -> int: ...
    def datasetGroupCount(self) -> int: ...
    def formatTime(self, hours: float) -> str: ...
    def setTimeSettings(self, settings: QgsMeshTimeSettings) -> None: ...
    def timeSettings(self) -> QgsMeshTimeSettings: ...
    def setRendererSettings(self, settings: QgsMeshRendererSettings) -> None: ...
    def rendererSettings(self) -> QgsMeshRendererSettings: ...
    def updateTriangularMesh(self, transform: QgsCoordinateTransform = ...) -> None: ...
    def saveDataset(self, path: str, datasetGroupIndex: int, driver: str) -> bool: ...
    @overload
    def addDatasets(self, path: str, defaultReferenceTime: Union[QtCore.QDateTime, datetime.datetime] = ...) -> bool: ...
    @overload
    def addDatasets(self, datasetGroup: QgsMeshDatasetGroup) -> bool: ...
    def providerType(self) -> str: ...
    def htmlMetadata(self) -> str: ...
    def subLayers(self) -> List[str]: ...
    def reload(self) -> None: ...
    def temporalProperties(self) -> QgsMapLayerTemporalProperties: ...
    def writeXml(self, layer_node: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, layer_node: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def decodedSource(self, source: str, provider: str, context: QgsReadWriteContext) -> str: ...
    def encodedSource(self, source: str, context: QgsReadWriteContext) -> str: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def createMapRenderer(self, rendererContext: QgsRenderContext) -> QgsMapLayerRenderer: ...
    def extent(self) -> QgsRectangle: ...
    def clone(self) -> QgsMeshLayer: ...
    def dataProvider(self) -> QgsMeshDataProvider: ...
    def __repr__(self) -> typing.Any: ...


class QgsMeshUtils(sip.simplewrapper):

    def exportRasterBlock(self, layer: QgsMeshLayer, datasetIndex: QgsMeshDatasetIndex, destinationCrs: QgsCoordinateReferenceSystem, transformContext: QgsCoordinateTransformContext, mapUnitsPerPixel: float, extent: QgsRectangle, feedback: Optional[QgsRasterBlockFeedback] = ...) -> QgsRasterBlock: ...


class QgsMeshLayerTemporalProperties(QgsMapLayerTemporalProperties):

    def __init__(self, parent: Optional[QtCore.QObject] = ..., enabled: bool = ...) -> None: ...

    def setMatchingMethod(self, matchingMethod: QgsMeshDataProviderTemporalCapabilities.MatchingTemporalDatasetMethod) -> None: ...
    def matchingMethod(self) -> QgsMeshDataProviderTemporalCapabilities.MatchingTemporalDatasetMethod: ...
    def setReferenceTime(self, referenceTime: Union[QtCore.QDateTime, datetime.datetime], capabilities: QgsDataProviderTemporalCapabilities) -> None: ...
    def referenceTime(self) -> QtCore.QDateTime: ...
    def timeExtent(self) -> QgsDateTimeRange: ...
    def setDefaultsFromDataProviderTemporalCapabilities(self, capabilities: QgsDataProviderTemporalCapabilities) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...


class QgsMeshRendererMeshSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererMeshSettings) -> None: ...

    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def setLineWidthUnit(self, lineWidthUnit: QgsUnitTypes.RenderUnit) -> None: ...
    def lineWidthUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setLineWidth(self, lineWidth: float) -> None: ...
    def lineWidth(self) -> float: ...
    def setEnabled(self, enabled: bool) -> None: ...
    def isEnabled(self) -> bool: ...


class QgsMeshRendererScalarSettings(sip.wrapper):

    class DataResamplingMethod(int):
        ...
    # None: QgsMeshRendererScalarSettings.DataResamplingMethod = ...
    NeighbourAverage: QgsMeshRendererScalarSettings.DataResamplingMethod = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererScalarSettings) -> None: ...

    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ...) -> QtXml.QDomElement: ...
    def setEdgeStrokeWidthUnit(self, edgeStrokeWidthUnit: QgsUnitTypes.RenderUnit) -> None: ...
    def edgeStrokeWidthUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setEdgeStrokeWidth(self, strokeWidth: QgsInterpolatedLineWidth) -> None: ...
    def edgeStrokeWidth(self) -> QgsInterpolatedLineWidth: ...
    def setDataResamplingMethod(self, dataResamplingMethod: QgsMeshRendererScalarSettings.DataResamplingMethod) -> None: ...
    def dataResamplingMethod(self) -> QgsMeshRendererScalarSettings.DataResamplingMethod: ...
    def setOpacity(self, opacity: float) -> None: ...
    def opacity(self) -> float: ...
    def setClassificationMinimumMaximum(self, minimum: float, maximum: float) -> None: ...
    def classificationMaximum(self) -> float: ...
    def classificationMinimum(self) -> float: ...
    def setColorRampShader(self, shader: QgsColorRampShader) -> None: ...
    def colorRampShader(self) -> QgsColorRampShader: ...


class QgsMeshRendererVectorArrowSettings(sip.wrapper):

    class ArrowScalingMethod(int):
        ...
    MinMax: QgsMeshRendererVectorArrowSettings.ArrowScalingMethod = ...
    Scaled: QgsMeshRendererVectorArrowSettings.ArrowScalingMethod = ...
    Fixed: QgsMeshRendererVectorArrowSettings.ArrowScalingMethod = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererVectorArrowSettings) -> None: ...

    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def setArrowHeadLengthRatio(self, arrowHeadLengthRatio: float) -> None: ...
    def arrowHeadLengthRatio(self) -> float: ...
    def setArrowHeadWidthRatio(self, arrowHeadWidthRatio: float) -> None: ...
    def arrowHeadWidthRatio(self) -> float: ...
    def setFixedShaftLength(self, fixedShaftLength: float) -> None: ...
    def fixedShaftLength(self) -> float: ...
    def setScaleFactor(self, scaleFactor: float) -> None: ...
    def scaleFactor(self) -> float: ...
    def setMaxShaftLength(self, maxShaftLength: float) -> None: ...
    def maxShaftLength(self) -> float: ...
    def setMinShaftLength(self, minShaftLength: float) -> None: ...
    def minShaftLength(self) -> float: ...
    def setShaftLengthMethod(self, shaftLengthMethod: QgsMeshRendererVectorArrowSettings.ArrowScalingMethod) -> None: ...
    def shaftLengthMethod(self) -> QgsMeshRendererVectorArrowSettings.ArrowScalingMethod: ...


class QgsMeshRendererVectorStreamlineSettings(sip.wrapper):

    class SeedingStartPointsMethod(int):
        ...
    MeshGridded: QgsMeshRendererVectorStreamlineSettings.SeedingStartPointsMethod = ...
    Random: QgsMeshRendererVectorStreamlineSettings.SeedingStartPointsMethod = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererVectorStreamlineSettings) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def setSeedingDensity(self, seedingDensity: float) -> None: ...
    def seedingDensity(self) -> float: ...
    def setSeedingMethod(self, seedingMethod: QgsMeshRendererVectorStreamlineSettings.SeedingStartPointsMethod) -> None: ...
    def seedingMethod(self) -> QgsMeshRendererVectorStreamlineSettings.SeedingStartPointsMethod: ...


class QgsMeshRendererVectorTracesSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererVectorTracesSettings) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument) -> QtXml.QDomElement: ...
    def readXml(self, elem: QtXml.QDomElement) -> None: ...
    def setMaximumTailLengthUnit(self, maximumTailLengthUnit: QgsUnitTypes.RenderUnit) -> None: ...
    def maximumTailLengthUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setParticlesCount(self, value: int) -> None: ...
    def particlesCount(self) -> int: ...
    def setMaximumTailLength(self, maximumTailLength: float) -> None: ...
    def maximumTailLength(self) -> float: ...


class QgsMeshRendererVectorSettings(sip.wrapper):

    class Symbology(int):
        ...
    Arrows: QgsMeshRendererVectorSettings.Symbology = ...
    Streamlines: QgsMeshRendererVectorSettings.Symbology = ...
    Traces: QgsMeshRendererVectorSettings.Symbology = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererVectorSettings) -> None: ...

    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ...) -> QtXml.QDomElement: ...
    def setTracesSettings(self, tracesSettings: QgsMeshRendererVectorTracesSettings) -> None: ...
    def tracesSettings(self) -> QgsMeshRendererVectorTracesSettings: ...
    def setStreamLinesSettings(self, streamLinesSettings: QgsMeshRendererVectorStreamlineSettings) -> None: ...
    def streamLinesSettings(self) -> QgsMeshRendererVectorStreamlineSettings: ...
    def setArrowsSettings(self, arrowSettings: QgsMeshRendererVectorArrowSettings) -> None: ...
    def arrowSettings(self) -> QgsMeshRendererVectorArrowSettings: ...
    def vectorStrokeColoring(self) -> QgsInterpolatedLineColor: ...
    def setColorRampShader(self, colorRampShader: QgsColorRampShader) -> None: ...
    def colorRampShader(self) -> QgsColorRampShader: ...
    def setColoringMethod(self, coloringMethod: QgsInterpolatedLineColor.ColoringMethod) -> None: ...
    def coloringMethod(self) -> QgsInterpolatedLineColor.ColoringMethod: ...
    def setSymbology(self, symbology: QgsMeshRendererVectorSettings.Symbology) -> None: ...
    def symbology(self) -> QgsMeshRendererVectorSettings.Symbology: ...
    def setUserGridCellHeight(self, height: int) -> None: ...
    def userGridCellHeight(self) -> int: ...
    def setUserGridCellWidth(self, width: int) -> None: ...
    def userGridCellWidth(self) -> int: ...
    def setOnUserDefinedGrid(self, enabled: bool) -> None: ...
    def isOnUserDefinedGrid(self) -> bool: ...
    def setFilterMax(self, filterMax: float) -> None: ...
    def filterMax(self) -> float: ...
    def setFilterMin(self, filterMin: float) -> None: ...
    def filterMin(self) -> float: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def color(self) -> QtGui.QColor: ...
    def setLineWidth(self, lineWidth: float) -> None: ...
    def lineWidth(self) -> float: ...


class QgsMeshRendererSettings(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshRendererSettings) -> None: ...

    def setActiveVectorDatasetGroup(self, activeVectorDatasetGroup: int) -> None: ...
    def activeVectorDatasetGroup(self) -> int: ...
    def setActiveScalarDatasetGroup(self, activeScalarDatasetGroup: int) -> None: ...
    def activeScalarDatasetGroup(self) -> int: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext = ...) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext = ...) -> QtXml.QDomElement: ...
    def setAveragingMethod(self, method: QgsMesh3dAveragingMethod) -> None: ...
    def averagingMethod(self) -> QgsMesh3dAveragingMethod: ...
    def setVectorSettings(self, groupIndex: int, settings: QgsMeshRendererVectorSettings) -> None: ...
    def vectorSettings(self, groupIndex: int) -> QgsMeshRendererVectorSettings: ...
    def setScalarSettings(self, groupIndex: int, settings: QgsMeshRendererScalarSettings) -> None: ...
    def scalarSettings(self, groupIndex: int) -> QgsMeshRendererScalarSettings: ...
    def setEdgeMeshSettings(self, settings: QgsMeshRendererMeshSettings) -> None: ...
    def edgeMeshSettings(self) -> QgsMeshRendererMeshSettings: ...
    def setTriangularMeshSettings(self, settings: QgsMeshRendererMeshSettings) -> None: ...
    def triangularMeshSettings(self) -> QgsMeshRendererMeshSettings: ...
    def setNativeMeshSettings(self, settings: QgsMeshRendererMeshSettings) -> None: ...
    def nativeMeshSettings(self) -> QgsMeshRendererMeshSettings: ...


class QgsMeshSpatialIndex(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, mesh: QgsMesh, feedback: Optional[QgsFeedback] = ..., elementType: QgsMesh.ElementType = ...) -> None: ...
    @overload
    def __init__(self, other: QgsMeshSpatialIndex) -> None: ...

    def elementType(self) -> QgsMesh.ElementType: ...
    def nearestNeighbor(self, point: QgsPointXY, neighbors: int) -> List[int]: ...
    def intersects(self, rectangle: QgsRectangle) -> List[int]: ...


class QgsMeshTimeSettings(sip.wrapper):

    class TimeUnit(int):
        ...
    seconds: QgsMeshTimeSettings.TimeUnit = ...
    minutes: QgsMeshTimeSettings.TimeUnit = ...
    hours: QgsMeshTimeSettings.TimeUnit = ...
    days: QgsMeshTimeSettings.TimeUnit = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshTimeSettings) -> None: ...

    def setAbsoluteTimeFormat(self, absoluteTimeFormat: str) -> None: ...
    def absoluteTimeFormat(self) -> str: ...
    def setRelativeTimeFormat(self, relativeTimeFormat: str) -> None: ...
    def relativeTimeFormat(self) -> str: ...
    def readXml(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...


class QgsMeshVectorTraceAnimationGenerator(sip.wrapper):

    @overload
    def __init__(self, layer: QgsMeshLayer, rendererContext: QgsRenderContext) -> None: ...
    @overload
    def __init__(self, other: QgsMeshVectorTraceAnimationGenerator) -> None: ...

    def setTailPersitence(self, p: float) -> None: ...
    def setMinimumTailLength(self, l: int) -> None: ...
    def setTailFactor(self, fct: float) -> None: ...
    def setParticlesSize(self, width: float) -> None: ...
    def setParticlesColor(self, c: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setParticlesLifeTime(self, particleLifeTime: float) -> None: ...
    def setMaxSpeedPixel(self, max: int) -> None: ...
    def setFPS(self, FPS: int) -> None: ...
    def imageRendered(self) -> QtGui.QImage: ...
    def seedRandomParticles(self, count: int) -> None: ...


class QgsMeshCalculator(sip.wrapper):

    class Result(int):
        ...
    Success: QgsMeshCalculator.Result = ...
    Canceled: QgsMeshCalculator.Result = ...
    CreateOutputError: QgsMeshCalculator.Result = ...
    InputLayerError: QgsMeshCalculator.Result = ...
    ParserError: QgsMeshCalculator.Result = ...
    InvalidDatasets: QgsMeshCalculator.Result = ...
    EvaluateError: QgsMeshCalculator.Result = ...
    MemoryError: QgsMeshCalculator.Result = ...

    @overload
    def __init__(self, formulaString: str, outputFile: str, outputExtent: QgsRectangle, startTime: float, endTime: float, layer: QgsMeshLayer) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputFile: str, outputMask: QgsGeometry, startTime: float, endTime: float, layer: QgsMeshLayer) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputDriver: str, outputGroupName: str, outputFile: str, outputExtent: QgsRectangle, startTime: float, endTime: float, layer: QgsMeshLayer) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputDriver: str, outputGroupName: str, outputFile: str, outputMask: QgsGeometry, startTime: float, endTime: float, layer: QgsMeshLayer) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputGroupName: str, outputExtent: QgsRectangle, destination: QgsMeshDatasetGroup.Type, layer: QgsMeshLayer, startTime: float, endTime: float) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputGroupName: str, outputMask: QgsGeometry, destination: QgsMeshDatasetGroup.Type, layer: QgsMeshLayer, startTime: float, endTime: float) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshCalculator) -> None: ...

    @staticmethod
    def expressionIsValid(formulaString: str, layer: QgsMeshLayer) -> Tuple[QgsMeshCalculator.Result, QgsMeshDriverMetadata.MeshDriverCapability]: ...
    @staticmethod
    def expression_valid(formulaString: str, layer: QgsMeshLayer) -> QgsMeshCalculator.Result: ...
    def processCalculation(self, feedback: Optional[QgsFeedback] = ...) -> QgsMeshCalculator.Result: ...


class QgsPointCloudAttribute(sip.wrapper):

    class DataType(int):
        ...
    Char: QgsPointCloudAttribute.DataType = ...
    Short: QgsPointCloudAttribute.DataType = ...
    UShort: QgsPointCloudAttribute.DataType = ...
    Int32: QgsPointCloudAttribute.DataType = ...
    Float: QgsPointCloudAttribute.DataType = ...
    Double: QgsPointCloudAttribute.DataType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, type: QgsPointCloudAttribute.DataType) -> None: ...
    @overload
    def __init__(self, a0: QgsPointCloudAttribute) -> None: ...

    def __repr__(self) -> typing.Any: ...
    @staticmethod
    def isNumeric(type: QgsPointCloudAttribute.DataType) -> bool: ...
    def displayType(self) -> str: ...
    def variantType(self) -> QtCore.QVariant.Type: ...
    def type(self) -> QgsPointCloudAttribute.DataType: ...
    def size(self) -> int: ...
    def name(self) -> str: ...


class QgsPointCloudAttributeCollection(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, attributes: Iterable[QgsPointCloudAttribute]) -> None: ...
    @overload
    def __init__(self, a0: QgsPointCloudAttributeCollection) -> None: ...

    def toFields(self) -> QgsFields: ...
    def pointRecordSize(self) -> int: ...
    def indexOf(self, name: str) -> int: ...
    def find(self, attributeName: str) -> Tuple[QgsPointCloudAttribute, int]: ...
    def at(self, index: int) -> QgsPointCloudAttribute: ...
    def count(self) -> int: ...
    def attributes(self) -> List[QgsPointCloudAttribute]: ...
    def push_back(self, attribute: QgsPointCloudAttribute) -> None: ...


class QgsPointCloudRenderer(sip.wrapper):

    class PointSymbol(int):
        ...
    Square: QgsPointCloudRenderer.PointSymbol = ...
    Circle: QgsPointCloudRenderer.PointSymbol = ...

    def __init__(self) -> None: ...

    def saveCommonProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def restoreCommonProperties(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def copyCommonProperties(self, destination: QgsPointCloudRenderer) -> None: ...
    def drawPoint(self, x: float, y: float, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], context: QgsPointCloudRenderContext) -> None: ...
    @staticmethod
    def pointZ(context: QgsPointCloudRenderContext, ptr: str, i: int) -> float: ...
    @staticmethod
    def pointXY(context: QgsPointCloudRenderContext, ptr: str, i: int) -> Tuple[float, float]: ...
    def legendRuleKeys(self) -> List[str]: ...
    def createLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def setMaximumScreenErrorUnit(self, unit: QgsUnitTypes.RenderUnit) -> None: ...
    def maximumScreenErrorUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setMaximumScreenError(self, error: float) -> None: ...
    def maximumScreenError(self) -> float: ...
    def setPointSymbol(self, symbol: QgsPointCloudRenderer.PointSymbol) -> None: ...
    def pointSymbol(self) -> QgsPointCloudRenderer.PointSymbol: ...
    def pointSizeMapUnitScale(self) -> QgsMapUnitScale: ...
    def setPointSizeMapUnitScale(self, scale: QgsMapUnitScale) -> None: ...
    def pointSizeUnit(self) -> QgsUnitTypes.RenderUnit: ...
    def setPointSizeUnit(self, units: QgsUnitTypes.RenderUnit) -> None: ...
    def pointSize(self) -> float: ...
    def setPointSize(self, size: float) -> None: ...
    def checkLegendItem(self, key: str, state: bool = ...) -> None: ...
    def legendItemChecked(self, key: str) -> bool: ...
    def stopRender(self, context: QgsPointCloudRenderContext) -> None: ...
    def startRender(self, context: QgsPointCloudRenderContext) -> None: ...
    def usedAttributes(self, context: QgsPointCloudRenderContext) -> Set[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    @staticmethod
    def load(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...
    def willRenderPoint(self, pointAttributes: Dict[str, typing.Any]) -> bool: ...
    def renderBlock(self, block: QgsPointCloudBlock, context: QgsPointCloudRenderContext) -> None: ...
    def clone(self) -> QgsPointCloudRenderer: ...
    def type(self) -> str: ...


class QgsPointCloudAttributeByRampRenderer(QgsPointCloudRenderer):

    def __init__(self) -> None: ...

    def setMaximum(self, maximum: float) -> None: ...
    def maximum(self) -> float: ...
    def setMinimum(self, minimum: float) -> None: ...
    def minimum(self) -> float: ...
    def setColorRampShader(self, shader: QgsColorRampShader) -> None: ...
    def colorRampShader(self) -> QgsColorRampShader: ...
    def setAttribute(self, attribute: str) -> None: ...
    def attribute(self) -> str: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...
    def createLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def usedAttributes(self, context: QgsPointCloudRenderContext) -> Set[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def renderBlock(self, block: QgsPointCloudBlock, context: QgsPointCloudRenderContext) -> None: ...
    def clone(self) -> QgsPointCloudRenderer: ...
    def type(self) -> str: ...


class QgsPointCloudAttributeModel(QtCore.QAbstractItemModel):

    class FieldRoles(int):
        ...
    AttributeNameRole: QgsPointCloudAttributeModel.FieldRoles = ...
    AttributeIndexRole: QgsPointCloudAttributeModel.FieldRoles = ...
    AttributeSizeRole: QgsPointCloudAttributeModel.FieldRoles = ...
    AttributeTypeRole: QgsPointCloudAttributeModel.FieldRoles = ...
    IsEmptyRole: QgsPointCloudAttributeModel.FieldRoles = ...
    IsNumericRole: QgsPointCloudAttributeModel.FieldRoles = ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    @staticmethod
    def iconForAttributeType(type: QgsPointCloudAttribute.DataType) -> QtGui.QIcon: ...
    @staticmethod
    def attributeToolTip(attribute: QgsPointCloudAttribute) -> str: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...
    def columnCount(self, parent: QtCore.QModelIndex) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, child: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def allowEmptyAttributeName(self) -> bool: ...
    def indexFromName(self, name: str) -> QtCore.QModelIndex: ...
    def setAllowEmptyAttributeName(self, allowEmpty: bool) -> None: ...
    def attributes(self) -> QgsPointCloudAttributeCollection: ...
    def setAttributes(self, attributes: QgsPointCloudAttributeCollection) -> None: ...
    def layer(self) -> QgsPointCloudLayer: ...
    def setLayer(self, layer: QgsPointCloudLayer) -> None: ...


class QgsPointCloudAttributeProxyModel(QtCore.QSortFilterProxyModel):

    class Filter(int):
        ...
    Char: QgsPointCloudAttributeProxyModel.Filter = ...
    Short: QgsPointCloudAttributeProxyModel.Filter = ...
    Int32: QgsPointCloudAttributeProxyModel.Filter = ...
    Float: QgsPointCloudAttributeProxyModel.Filter = ...
    Double: QgsPointCloudAttributeProxyModel.Filter = ...
    Numeric: QgsPointCloudAttributeProxyModel.Filter = ...
    AllTypes: QgsPointCloudAttributeProxyModel.Filter = ...

    class Filters(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsPointCloudAttributeProxyModel.Filters, QgsPointCloudAttributeProxyModel.Filter]) -> None: ...
        @overload
        def __init__(self, a0: QgsPointCloudAttributeProxyModel.Filters) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsPointCloudAttributeProxyModel.Filters: ...
        def __int__(self) -> int: ...

    def __init__(self, source: QgsPointCloudAttributeModel, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...
    def filterAcceptsRow(self, source_row: int, source_parent: QtCore.QModelIndex) -> bool: ...
    def filters(self) -> QgsPointCloudAttributeProxyModel.Filters: ...
    def setFilters(self, filters: Union[QgsPointCloudAttributeProxyModel.Filters, QgsPointCloudAttributeProxyModel.Filter]) -> QgsPointCloudAttributeProxyModel: ...
    def sourceAttributeModel(self) -> QgsPointCloudAttributeModel: ...


class QgsPointCloudCategory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, value: int, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient], label: str, render: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPointCloudCategory) -> None: ...

    def setRenderState(self, render: bool) -> None: ...
    def renderState(self) -> bool: ...
    def setLabel(self, label: str) -> None: ...
    def setColor(self, color: Union[QtGui.QColor, QtCore.Qt.GlobalColor, QtGui.QGradient]) -> None: ...
    def setValue(self, value: int) -> None: ...
    def label(self) -> str: ...
    def color(self) -> QtGui.QColor: ...
    def value(self) -> int: ...


class QgsPointCloudClassifiedRenderer(QgsPointCloudRenderer):

    def __init__(self) -> None: ...

    def addCategory(self, category: QgsPointCloudCategory) -> None: ...
    def setCategories(self, categories: Iterable[QgsPointCloudCategory]) -> None: ...
    def categories(self) -> List[QgsPointCloudCategory]: ...
    def setAttribute(self, attribute: str) -> None: ...
    def attribute(self) -> str: ...
    @staticmethod
    def defaultCategories() -> List[QgsPointCloudCategory]: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...
    def checkLegendItem(self, key: str, state: bool = ...) -> None: ...
    def legendItemChecked(self, key: str) -> bool: ...
    def legendRuleKeys(self) -> List[str]: ...
    def createLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def usedAttributes(self, context: QgsPointCloudRenderContext) -> Set[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def willRenderPoint(self, pointAttributes: Dict[str, typing.Any]) -> bool: ...
    def renderBlock(self, block: QgsPointCloudBlock, context: QgsPointCloudRenderContext) -> None: ...
    def clone(self) -> QgsPointCloudRenderer: ...
    def type(self) -> str: ...


class QgsPointCloudExtentRenderer(QgsPointCloudRenderer):

    def __init__(self, symbol: Optional[QgsFillSymbol] = ...) -> None: ...

    def setFillSymbol(self, symbol: QgsFillSymbol) -> None: ...
    def fillSymbol(self) -> QgsFillSymbol: ...
    @staticmethod
    def defaultFillSymbol() -> QgsFillSymbol: ...
    def renderExtent(self, extent: QgsGeometry, context: QgsPointCloudRenderContext) -> None: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...
    def createLegendNodes(self, nodeLayer: QgsLayerTreeLayer) -> List[QgsLayerTreeModelLegendNode]: ...
    def stopRender(self, context: QgsPointCloudRenderContext) -> None: ...
    def startRender(self, context: QgsPointCloudRenderContext) -> None: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def renderBlock(self, block: QgsPointCloudBlock, context: QgsPointCloudRenderContext) -> None: ...
    def clone(self) -> QgsPointCloudRenderer: ...
    def type(self) -> str: ...


class QgsPointCloudBlock(sip.wrapper):

    @overload
    def __init__(self, count: int, attributes: QgsPointCloudAttributeCollection, data: Union[QtCore.QByteArray, bytes, bytearray], scale: QgsVector3D, offset: QgsVector3D) -> None: ...
    @overload
    def __init__(self, a0: QgsPointCloudBlock) -> None: ...

    def offset(self) -> QgsVector3D: ...
    def scale(self) -> QgsVector3D: ...
    def attributes(self) -> QgsPointCloudAttributeCollection: ...
    def pointCount(self) -> int: ...
    def data(self) -> str: ...


class QgsPointCloudLayer(QgsMapLayer):

    class LayerOptions(sip.wrapper):

        loadDefaultStyle: bool = ...
        skipCrsValidation: bool = ...
        skipIndexGeneration: bool = ...
        transformContext: QgsCoordinateTransformContext = ...

        @overload
        def __init__(self, transformContext: QgsCoordinateTransformContext = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsPointCloudLayer.LayerOptions) -> None: ...

    def __init__(self, uri: str = ..., baseName: str = ..., providerLib: str = ..., options: QgsPointCloudLayer.LayerOptions = ...) -> None: ...

    def setRenderer(self, renderer: QgsPointCloudRenderer) -> None: ...
    def renderer(self) -> QgsPointCloudRenderer: ...
    def pointCount(self) -> int: ...
    def attributes(self) -> QgsPointCloudAttributeCollection: ...
    def elevationProperties(self) -> QgsMapLayerElevationProperties: ...
    def htmlMetadata(self) -> str: ...
    def loadDefaultStyle(self) -> Tuple[str, bool]: ...
    def decodedSource(self, source: str, dataProvider: str, context: QgsReadWriteContext) -> str: ...
    def encodedSource(self, source: str, context: QgsReadWriteContext) -> str: ...
    def setTransformContext(self, transformContext: QgsCoordinateTransformContext) -> None: ...
    def writeStyle(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeSymbology(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readStyle(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def readSymbology(self, node: QtXml.QDomNode, errorMessage: str, context: QgsReadWriteContext, categories: Union[QgsMapLayer.StyleCategories, QgsMapLayer.StyleCategory] = ...) -> bool: ...
    def writeXml(self, layerNode: QtXml.QDomNode, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> bool: ...
    def readXml(self, layerNode: QtXml.QDomNode, context: QgsReadWriteContext) -> bool: ...
    def dataProvider(self) -> QgsPointCloudDataProvider: ...
    def createMapRenderer(self, rendererContext: QgsRenderContext) -> QgsMapLayerRenderer: ...
    def extent(self) -> QgsRectangle: ...
    def clone(self) -> QgsPointCloudLayer: ...
    def __repr__(self) -> typing.Any: ...


class QgsPointCloudLayerElevationProperties(QgsMapLayerElevationProperties):

    def __init__(self, parent: QtCore.QObject) -> None: ...

    def setZScale(self, scale: float) -> None: ...
    def zScale(self) -> float: ...
    def setZOffset(self, offset: float) -> None: ...
    def zOffset(self) -> float: ...
    def calculateZRange(self, layer: QgsMapLayer) -> QgsDoubleRange: ...
    def isVisibleInZRange(self, range: QgsDoubleRange) -> bool: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> bool: ...
    def writeXml(self, element: QtXml.QDomElement, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def hasElevation(self) -> bool: ...


class QgsPointCloudDataProvider(QgsDataProvider):

    class PointCloudIndexGenerationState(int):
        ...
    NotIndexed: QgsPointCloudDataProvider.PointCloudIndexGenerationState = ...
    Indexing: QgsPointCloudDataProvider.PointCloudIndexGenerationState = ...
    Indexed: QgsPointCloudDataProvider.PointCloudIndexGenerationState = ...

    class Capability(int):
        ...
    NoCapabilities: QgsPointCloudDataProvider.Capability = ...
    ReadLayerMetadata: QgsPointCloudDataProvider.Capability = ...
    WriteLayerMetadata: QgsPointCloudDataProvider.Capability = ...
    CreateRenderer: QgsPointCloudDataProvider.Capability = ...

    class Capabilities(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsPointCloudDataProvider.Capabilities, QgsPointCloudDataProvider.Capability]) -> None: ...
        @overload
        def __init__(self, a0: QgsPointCloudDataProvider.Capabilities) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsPointCloudDataProvider.Capabilities: ...
        def __int__(self) -> int: ...

    def __init__(self, uri: str, providerOptions: QgsDataProvider.ProviderOptions, flags: Union[QgsDataProvider.ReadFlags, QgsDataProvider.ReadFlag] = ...) -> None: ...

    def indexGenerationStateChanged(self, state: QgsPointCloudDataProvider.PointCloudIndexGenerationState) -> None: ...
    @staticmethod
    def translatedDataFormatIds() -> Dict[int, str]: ...
    @staticmethod
    def dataFormatIds() -> Dict[int, str]: ...
    @staticmethod
    def translatedLasClassificationCodes() -> Dict[int, str]: ...
    @staticmethod
    def lasClassificationCodes() -> Dict[int, str]: ...
    def metadataClassStatistic(self, attribute: str, value: typing.Any, statistic: QgsStatisticalSummary.Statistic) -> typing.Any: ...
    def metadataClasses(self, attribute: str) -> List[typing.Any]: ...
    def metadataStatistic(self, attribute: str, statistic: QgsStatisticalSummary.Statistic) -> typing.Any: ...
    def createRenderer(self, configuration: Dict[str, typing.Any] = ...) -> QgsPointCloudRenderer: ...
    def originalMetadata(self) -> Dict[str, typing.Any]: ...
    def polygonBounds(self) -> QgsGeometry: ...
    def pointCount(self) -> int: ...
    def hasValidIndex(self) -> bool: ...
    def indexingState(self) -> QgsPointCloudDataProvider.PointCloudIndexGenerationState: ...
    def generateIndex(self) -> None: ...
    def loadIndex(self) -> None: ...
    def attributes(self) -> QgsPointCloudAttributeCollection: ...
    def capabilities(self) -> QgsPointCloudDataProvider.Capabilities: ...
    def identify(self, maxErrorInMapCoords: float, extentGeometry: QgsGeometry, extentZRange: QgsDoubleRange = ..., pointsLimit: int = ...) -> List[typing.Any]: ...


class QgsPointCloudRenderContext(sip.wrapper):

    def __init__(self, context: QgsRenderContext, scale: QgsVector3D, offset: QgsVector3D, zValueScale: float, zValueFixedOffset: float, feedback: Optional[QgsFeedback] = ...) -> None: ...

    def feedback(self) -> QgsFeedback: ...
    def zValueFixedOffset(self) -> float: ...
    def zValueScale(self) -> float: ...
    def zOffset(self) -> int: ...
    def yOffset(self) -> int: ...
    def xOffset(self) -> int: ...
    def pointRecordSize(self) -> int: ...
    def setAttributes(self, attributes: QgsPointCloudAttributeCollection) -> None: ...
    def attributes(self) -> QgsPointCloudAttributeCollection: ...
    def incrementPointsRendered(self, count: int) -> None: ...
    def pointsRendered(self) -> int: ...
    def setOffset(self, offset: QgsVector3D) -> None: ...
    def offset(self) -> QgsVector3D: ...
    def setScale(self, scale: QgsVector3D) -> None: ...
    def scale(self) -> QgsVector3D: ...
    def renderContext(self) -> QgsRenderContext: ...


class QgsPointCloudRendererAbstractMetadata(sip.wrapper):

    @overload
    def __init__(self, name: str, visibleName: str, icon: QtGui.QIcon = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsPointCloudRendererAbstractMetadata) -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...
    def setIcon(self, icon: QtGui.QIcon) -> None: ...
    def icon(self) -> QtGui.QIcon: ...
    def visibleName(self) -> str: ...
    def name(self) -> str: ...


class QgsPointCloudRendererMetadata(QgsPointCloudRendererAbstractMetadata):

    def __init__(self, a0: QgsPointCloudRendererMetadata) -> None: ...

    def createRenderer(self, elem: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...


class QgsPointCloudRendererRegistry(sip.wrapper):

    def __init__(self) -> None: ...

    @staticmethod
    def defaultRenderer(provider: QgsPointCloudDataProvider) -> QgsPointCloudRenderer: ...
    def renderersList(self) -> List[str]: ...
    def rendererMetadata(self, rendererName: str) -> QgsPointCloudRendererAbstractMetadata: ...
    def removeRenderer(self, rendererName: str) -> bool: ...
    def addRenderer(self, metadata: QgsPointCloudRendererAbstractMetadata) -> bool: ...


class QgsPointCloudRgbRenderer(QgsPointCloudRenderer):

    def __init__(self) -> None: ...

    def setBlueContrastEnhancement(self, enhancement: QgsContrastEnhancement) -> None: ...
    def blueContrastEnhancement(self) -> QgsContrastEnhancement: ...
    def setGreenContrastEnhancement(self, enhancement: QgsContrastEnhancement) -> None: ...
    def greenContrastEnhancement(self) -> QgsContrastEnhancement: ...
    def setRedContrastEnhancement(self, enhancement: QgsContrastEnhancement) -> None: ...
    def redContrastEnhancement(self) -> QgsContrastEnhancement: ...
    def setBlueAttribute(self, attribute: str) -> None: ...
    def blueAttribute(self) -> str: ...
    def setGreenAttribute(self, attribute: str) -> None: ...
    def greenAttribute(self) -> str: ...
    def setRedAttribute(self, attribute: str) -> None: ...
    def redAttribute(self) -> str: ...
    @staticmethod
    def create(element: QtXml.QDomElement, context: QgsReadWriteContext) -> QgsPointCloudRenderer: ...
    def usedAttributes(self, context: QgsPointCloudRenderContext) -> Set[str]: ...
    def save(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def renderBlock(self, block: QgsPointCloudBlock, context: QgsPointCloudRenderContext) -> None: ...
    def clone(self) -> QgsPointCloudRenderer: ...
    def type(self) -> str: ...


class QgsCelestialBody(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCelestialBody) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def authority(self) -> str: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QgsCoordinateReferenceSystem(sip.wrapper):

    class WktVariant(int):
        ...
    WKT1_GDAL: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT1_ESRI: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT2_2015: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT2_2015_SIMPLIFIED: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT2_2018: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT2_2018_SIMPLIFIED: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT2_2019: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT2_2019_SIMPLIFIED: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT_PREFERRED: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT_PREFERRED_SIMPLIFIED: QgsCoordinateReferenceSystem.WktVariant = ...
    WKT_PREFERRED_GDAL: QgsCoordinateReferenceSystem.WktVariant = ...

    class IdentifierType(int):
        ...
    ShortString: QgsCoordinateReferenceSystem.IdentifierType = ...
    MediumString: QgsCoordinateReferenceSystem.IdentifierType = ...
    FullString: QgsCoordinateReferenceSystem.IdentifierType = ...

    class Format(int):
        ...
    FormatWkt: QgsCoordinateReferenceSystem.Format = ...
    FormatProj: QgsCoordinateReferenceSystem.Format = ...

    class CrsType(int):
        ...
    InternalCrsId: QgsCoordinateReferenceSystem.CrsType = ...
    PostgisCrsId: QgsCoordinateReferenceSystem.CrsType = ...
    EpsgCrsId: QgsCoordinateReferenceSystem.CrsType = ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, definition: str) -> None: ...
    @overload
    def __init__(self, id: int, type: QgsCoordinateReferenceSystem.CrsType = ...) -> None: ...
    @overload
    def __init__(self, srs: QgsCoordinateReferenceSystem) -> None: ...

    @staticmethod
    def invalidateCache() -> None: ...
    @staticmethod
    def pushRecentCoordinateReferenceSystem(crs: QgsCoordinateReferenceSystem) -> None: ...
    @staticmethod
    def recentCoordinateReferenceSystems() -> List[QgsCoordinateReferenceSystem]: ...
    @staticmethod
    def recentProjections() -> List[str]: ...
    def __repr__(self) -> typing.Any: ...
    def geographicCrsAuthId(self) -> str: ...
    def saveAsUserCrs(self, name: str, nativeFormat: QgsCoordinateReferenceSystem.Format = ...) -> int: ...
    @staticmethod
    def syncDatabase() -> int: ...
    def validationHint(self) -> str: ...
    def setValidationHint(self, html: str) -> None: ...
    def updateDefinition(self) -> None: ...
    def bounds(self) -> QgsRectangle: ...
    def mapUnits(self) -> QgsUnitTypes.DistanceUnit: ...
    def hasAxisInverted(self) -> bool: ...
    def operation(self) -> QgsProjOperation: ...
    def factors(self, point: QgsPoint) -> QgsProjectionFactors: ...
    def coordinateEpoch(self) -> float: ...
    def setCoordinateEpoch(self, epoch: float) -> None: ...
    def celestialBodyName(self) -> str: ...
    def datumEnsemble(self) -> QgsDatumEnsemble: ...
    def isDynamic(self) -> bool: ...
    def isGeographic(self) -> bool: ...
    def toProj(self) -> str: ...
    def toProj4(self) -> str: ...
    def toWkt(self, variant: QgsCoordinateReferenceSystem.WktVariant = ..., multiline: bool = ..., indentationWidth: int = ...) -> str: ...
    def ellipsoidAcronym(self) -> str: ...
    def projectionAcronym(self) -> str: ...
    def userFriendlyIdentifier(self, type: QgsCoordinateReferenceSystem.IdentifierType = ...) -> str: ...
    def description(self) -> str: ...
    def authid(self) -> str: ...
    def postgisSrid(self) -> int: ...
    def srsid(self) -> int: ...
    def writeXml(self, node: QtXml.QDomNode, doc: QtXml.QDomDocument) -> bool: ...
    def readXml(self, node: QtXml.QDomNode) -> bool: ...
    def findMatchingProj(self) -> int: ...
    def validate(self) -> None: ...
    def isValid(self) -> bool: ...
    @staticmethod
    def setupESRIWktFix() -> None: ...
    def createFromUserInput(self, definition: str) -> bool: ...
    def createFromString(self, definition: str) -> bool: ...
    def createFromProj(self, projString: str) -> bool: ...
    def createFromProj4(self, projString: str) -> bool: ...
    def createFromSrsId(self, srsId: int) -> bool: ...
    def createFromWkt(self, wkt: str) -> bool: ...
    def createFromSrid(self, srid: int) -> bool: ...
    def createFromOgcWmsCrs(self, crs: str) -> bool: ...
    def createFromId(self, id: int, type: QgsCoordinateReferenceSystem.CrsType = ...) -> bool: ...
    @staticmethod
    def fromSrsId(srsId: int) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def fromWkt(wkt: str) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def fromProj(proj: str) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def fromProj4(proj4: str) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def fromEpsgId(epsg: int) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def fromOgcWmsCrs(ogcCrs: str) -> QgsCoordinateReferenceSystem: ...
    @staticmethod
    def validSrsIds() -> typing.Any: ...


class QgsCoordinateReferenceSystemRegistry(QtCore.QObject):

    class UserCrsDetails(sip.wrapper):

        crs: QgsCoordinateReferenceSystem = ...
        id: int = ...
        name: str = ...
        proj: str = ...
        wkt: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsCoordinateReferenceSystemRegistry.UserCrsDetails) -> None: ...

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def crsDefinitionsChanged(self) -> None: ...
    def userCrsRemoved(self, id: int) -> None: ...
    def userCrsAdded(self, id: str) -> None: ...
    def userCrsChanged(self, id: str) -> None: ...
    def celestialBodies(self) -> List[QgsCelestialBody]: ...
    def projOperations(self) -> Dict[str, QgsProjOperation]: ...
    def removeUserCrs(self, id: int) -> bool: ...
    def updateUserCrs(self, id: int, crs: QgsCoordinateReferenceSystem, name: str, nativeFormat: QgsCoordinateReferenceSystem.Format = ...) -> bool: ...
    def addUserCrs(self, crs: QgsCoordinateReferenceSystem, name: str, nativeFormat: QgsCoordinateReferenceSystem.Format = ...) -> int: ...
    def userCrsList(self) -> List[QgsCoordinateReferenceSystemRegistry.UserCrsDetails]: ...


class QgsCoordinateTransform(sip.wrapper):

    class TransformDirection(int):
        ...
    ForwardTransform: QgsCoordinateTransform.TransformDirection = ...
    ReverseTransform: QgsCoordinateTransform.TransformDirection = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem, context: QgsCoordinateTransformContext) -> None: ...
    @overload
    def __init__(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem, project: QgsProject) -> None: ...
    @overload
    def __init__(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem, sourceDatumTransformId: int, destinationDatumTransformId: int) -> None: ...
    @overload
    def __init__(self, o: QgsCoordinateTransform) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def scaleFactor(self, referenceExtent: QgsRectangle) -> float: ...
    @staticmethod
    def invalidateCache() -> None: ...
    def setDestinationDatumTransformId(self, datumId: int) -> None: ...
    def destinationDatumTransformId(self) -> int: ...
    def setSourceDatumTransformId(self, datumId: int) -> None: ...
    def sourceDatumTransformId(self) -> int: ...
    def fallbackOperationOccurred(self) -> bool: ...
    def disableFallbackOperationHandler(self, disabled: bool) -> None: ...
    def setBallparkTransformsAreAppropriate(self, appropriate: bool) -> None: ...
    def allowFallbackTransforms(self) -> bool: ...
    def setAllowFallbackTransforms(self, allowed: bool) -> None: ...
    def setCoordinateOperation(self, operation: str) -> None: ...
    def instantiatedCoordinateOperationDetails(self) -> QgsDatumTransform.TransformDetails: ...
    def coordinateOperation(self) -> str: ...
    def isShortCircuited(self) -> bool: ...
    def transformCoords(self, numPoint: int, direction: QgsCoordinateTransform.TransformDirection = ...) -> Tuple[float, float, float]: ...
    def transformPolygon(self, polygon: QtGui.QPolygonF, direction: QgsCoordinateTransform.TransformDirection = ...) -> None: ...
    def transformInPlace(self, direction: QgsCoordinateTransform.TransformDirection = ...) -> Tuple[float, float, float]: ...
    def transformBoundingBox(self, rectangle: QgsRectangle, direction: QgsCoordinateTransform.TransformDirection = ..., handle180Crossover: bool = ...) -> QgsRectangle: ...
    @overload
    def transform(self, point: QgsPointXY, direction: QgsCoordinateTransform.TransformDirection = ...) -> QgsPointXY: ...
    @overload
    def transform(self, x: float, y: float, direction: QgsCoordinateTransform.TransformDirection = ...) -> QgsPointXY: ...
    @overload
    def transform(self, point: QgsVector3D, direction: QgsCoordinateTransform.TransformDirection = ...) -> QgsVector3D: ...
    @overload
    def transform(self, rectangle: QgsRectangle, direction: QgsCoordinateTransform.TransformDirection = ...) -> QgsRectangle: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...
    def sourceCrs(self) -> QgsCoordinateReferenceSystem: ...
    def context(self) -> QgsCoordinateTransformContext: ...
    def setContext(self, context: QgsCoordinateTransformContext) -> None: ...
    def setDestinationCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def setSourceCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def isValid(self) -> bool: ...


class QgsCoordinateTransformContext(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, rhs: QgsCoordinateTransformContext) -> None: ...

    def writeSettings(self) -> None: ...
    def readSettings(self) -> None: ...
    def writeXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> None: ...
    def readXml(self, element: QtXml.QDomElement, context: QgsReadWriteContext) -> Tuple[bool, List[str]]: ...
    def mustReverseCoordinateOperation(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem) -> bool: ...
    def allowFallbackTransform(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem) -> bool: ...
    def calculateCoordinateOperation(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem) -> str: ...
    def calculateDatumTransforms(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem) -> QgsDatumTransform.TransformPair: ...
    def hasTransform(self, source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem) -> bool: ...
    def removeCoordinateOperation(self, sourceCrs: QgsCoordinateReferenceSystem, destinationCrs: QgsCoordinateReferenceSystem) -> None: ...
    def removeSourceDestinationDatumTransform(self, sourceCrs: QgsCoordinateReferenceSystem, destinationCrs: QgsCoordinateReferenceSystem) -> None: ...
    def addCoordinateOperation(self, sourceCrs: QgsCoordinateReferenceSystem, destinationCrs: QgsCoordinateReferenceSystem, coordinateOperationProjString: str, allowFallback: bool = ...) -> bool: ...
    def addSourceDestinationDatumTransform(self, sourceCrs: QgsCoordinateReferenceSystem, destinationCrs: QgsCoordinateReferenceSystem, sourceTransformId: int, destinationTransformId: int) -> bool: ...
    def coordinateOperations(self) -> typing.Any: ...
    def sourceDestinationDatumTransforms(self) -> typing.Any: ...
    def clear(self) -> None: ...


class QgsDatumEnsembleMember(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDatumEnsembleMember) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def code(self) -> str: ...
    def authority(self) -> str: ...
    def remarks(self) -> str: ...
    def scope(self) -> str: ...
    def name(self) -> str: ...


class QgsDatumEnsemble(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDatumEnsemble) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def members(self) -> List[QgsDatumEnsembleMember]: ...
    def remarks(self) -> str: ...
    def scope(self) -> str: ...
    def code(self) -> str: ...
    def authority(self) -> str: ...
    def accuracy(self) -> float: ...
    def name(self) -> str: ...
    def isValid(self) -> bool: ...


class QgsDatumTransform(sip.wrapper):

    class TransformPair(sip.wrapper):

        destinationTransformId: int = ...
        sourceTransformId: int = ...

        @overload
        def __init__(self, sourceTransformId: int = ..., destinationTransformId: int = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsDatumTransform.TransformPair) -> None: ...

    class TransformInfo(sip.wrapper):

        datumTransformId: int = ...
        deprecated: bool = ...
        destinationCrsAuthId: str = ...
        destinationCrsDescription: str = ...
        epsgCode: int = ...
        preferred: bool = ...
        remarks: str = ...
        scope: str = ...
        sourceCrsAuthId: str = ...
        sourceCrsDescription: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsDatumTransform.TransformInfo) -> None: ...

    class GridDetails(sip.wrapper):

        directDownload: bool = ...
        fullName: str = ...
        isAvailable: bool = ...
        openLicense: bool = ...
        packageName: str = ...
        shortName: str = ...
        url: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsDatumTransform.GridDetails) -> None: ...

    class SingleOperationDetails(sip.wrapper):

        areaOfUse: str = ...
        authority: str = ...
        code: str = ...
        remarks: str = ...
        scope: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsDatumTransform.SingleOperationDetails) -> None: ...

    class TransformDetails(sip.wrapper):

        accuracy: float = ...
        areaOfUse: str = ...
        authority: str = ...
        bounds: QgsRectangle = ...
        code: str = ...
        grids: Iterable[QgsDatumTransform.GridDetails] = ...
        isAvailable: bool = ...
        name: str = ...
        operationDetails: Iterable[QgsDatumTransform.SingleOperationDetails] = ...
        proj: str = ...
        remarks: str = ...
        scope: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsDatumTransform.TransformDetails) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsDatumTransform) -> None: ...

    @staticmethod
    def datumTransformInfo(datumTransformId: int) -> QgsDatumTransform.TransformInfo: ...
    @staticmethod
    def projStringToDatumTransformId(string: str) -> int: ...
    @staticmethod
    def datumTransformToProj(datumTransformId: int) -> str: ...
    @staticmethod
    def datumTransformations(source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem) -> List[QgsDatumTransform.TransformPair]: ...
    @staticmethod
    def operations(source: QgsCoordinateReferenceSystem, destination: QgsCoordinateReferenceSystem, includeSuperseded: bool = ...) -> List[QgsDatumTransform.TransformDetails]: ...


class QgsEllipsoidUtils(sip.wrapper):

    class EllipsoidParameters(sip.wrapper):

        crs: QgsCoordinateReferenceSystem = ...
        inverseFlattening: float = ...
        semiMajor: float = ...
        semiMinor: float = ...
        useCustomParameters: bool = ...
        valid: bool = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsEllipsoidUtils.EllipsoidParameters) -> None: ...

    class EllipsoidDefinition(sip.wrapper):

        acronym: str = ...
        celestialBodyName: str = ...
        description: str = ...
        parameters: QgsEllipsoidUtils.EllipsoidParameters = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsEllipsoidUtils.EllipsoidDefinition) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsEllipsoidUtils) -> None: ...

    @staticmethod
    def celestialBodies() -> List[QgsCelestialBody]: ...
    @staticmethod
    def acronyms() -> List[str]: ...
    @staticmethod
    def definitions() -> List[QgsEllipsoidUtils.EllipsoidDefinition]: ...
    @staticmethod
    def ellipsoidParameters(ellipsoid: str) -> QgsEllipsoidUtils.EllipsoidParameters: ...


class QgsProjOperation(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjOperation) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def details(self) -> str: ...
    def description(self) -> str: ...
    def id(self) -> str: ...
    def isValid(self) -> bool: ...


class QgsProjUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjUtils) -> None: ...

    @staticmethod
    def searchPaths() -> List[str]: ...
    @staticmethod
    def ignfDatabaseDate() -> QtCore.QDate: ...
    @staticmethod
    def ignfDatabaseVersion() -> str: ...
    @staticmethod
    def esriDatabaseDate() -> QtCore.QDate: ...
    @staticmethod
    def esriDatabaseVersion() -> str: ...
    @staticmethod
    def epsgRegistryDate() -> QtCore.QDate: ...
    @staticmethod
    def epsgRegistryVersion() -> str: ...
    @staticmethod
    def projVersionMinor() -> int: ...
    @staticmethod
    def projVersionMajor() -> int: ...


class QgsProjectionFactors(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjectionFactors) -> None: ...

    def __repr__(self) -> typing.Any: ...
    def dyDphi(self) -> float: ...
    def dyDlam(self) -> float: ...
    def dxDphi(self) -> float: ...
    def dxDlam(self) -> float: ...
    def tissotSemiminor(self) -> float: ...
    def tissotSemimajor(self) -> float: ...
    def meridianConvergence(self) -> float: ...
    def meridianParallelAngle(self) -> float: ...
    def angularDistortion(self) -> float: ...
    def arealScale(self) -> float: ...
    def parallelScale(self) -> float: ...
    def meridionalScale(self) -> float: ...
    def isValid(self) -> bool: ...


class QgsAbstractMetadataBase(sip.wrapper):

    class Address(sip.wrapper):

        address: str = ...
        administrativeArea: str = ...
        city: str = ...
        country: str = ...
        postalCode: str = ...
        type: str = ...

        @overload
        def __init__(self, type: str = ..., address: str = ..., city: str = ..., administrativeArea: str = ..., postalCode: str = ..., country: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsAbstractMetadataBase.Address) -> None: ...

    class Contact(sip.wrapper):

        addresses: Iterable[QgsAbstractMetadataBase.Address] = ...
        email: str = ...
        fax: str = ...
        name: str = ...
        organization: str = ...
        position: str = ...
        role: str = ...
        voice: str = ...

        @overload
        def __init__(self, name: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsAbstractMetadataBase.Contact) -> None: ...

    class Link(sip.wrapper):

        description: str = ...
        format: str = ...
        mimeType: str = ...
        name: str = ...
        size: str = ...
        type: str = ...
        url: str = ...

        @overload
        def __init__(self, name: str = ..., type: str = ..., url: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsAbstractMetadataBase.Link) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractMetadataBase) -> None: ...

    def equals(self, other: QgsAbstractMetadataBase) -> bool: ...
    def combine(self, other: QgsAbstractMetadataBase) -> None: ...
    def writeMetadataXml(self, metadataElement: QtXml.QDomElement, document: QtXml.QDomDocument) -> bool: ...
    def readMetadataXml(self, metadataElement: QtXml.QDomElement) -> bool: ...
    def addLink(self, link: QgsAbstractMetadataBase.Link) -> None: ...
    def setLinks(self, links: Iterable[QgsAbstractMetadataBase.Link]) -> None: ...
    def links(self) -> List[QgsAbstractMetadataBase.Link]: ...
    def addContact(self, contact: QgsAbstractMetadataBase.Contact) -> None: ...
    def setContacts(self, contacts: Iterable[QgsAbstractMetadataBase.Contact]) -> None: ...
    def contacts(self) -> List[QgsAbstractMetadataBase.Contact]: ...
    def setCategories(self, categories: Iterable[str]) -> None: ...
    def categories(self) -> List[str]: ...
    def keywordVocabularies(self) -> List[str]: ...
    def removeKeywords(self, vocabulary: str) -> bool: ...
    def addKeywords(self, vocabulary: str, keywords: Iterable[str]) -> None: ...
    def setKeywords(self, keywords: Dict[str, Iterable[str]]) -> None: ...
    @overload
    def keywords(self) -> Dict[str, List[str]]: ...
    @overload
    def keywords(self, vocabulary: str) -> List[str]: ...
    def addHistoryItem(self, text: str) -> None: ...
    def setHistory(self, history: Iterable[str]) -> None: ...
    def history(self) -> List[str]: ...
    def setAbstract(self, abstract: str) -> None: ...
    def abstract(self) -> str: ...
    def setTitle(self, title: str) -> None: ...
    def title(self) -> str: ...
    def setType(self, type: str) -> None: ...
    def type(self) -> str: ...
    def setLanguage(self, language: str) -> None: ...
    def language(self) -> str: ...
    def setParentIdentifier(self, parentIdentifier: str) -> None: ...
    def parentIdentifier(self) -> str: ...
    def setIdentifier(self, identifier: str) -> None: ...
    def identifier(self) -> str: ...
    def clone(self) -> QgsAbstractMetadataBase: ...


class QgsLayerMetadata(QgsAbstractMetadataBase):

    class SpatialExtent(sip.wrapper):

        bounds: QgsBox3d = ...
        extentCrs: QgsCoordinateReferenceSystem = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerMetadata.SpatialExtent) -> None: ...

    class Extent(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerMetadata.Extent) -> None: ...

        def setTemporalExtents(self, extents: Iterable[QgsDateTimeRange]) -> None: ...
        def temporalExtents(self) -> List[QgsDateTimeRange]: ...
        def setSpatialExtents(self, extents: Iterable[QgsLayerMetadata.SpatialExtent]) -> None: ...
        def spatialExtents(self) -> List[QgsLayerMetadata.SpatialExtent]: ...

    class Constraint(sip.wrapper):

        constraint: str = ...
        type: str = ...

        @overload
        def __init__(self, constraint: str = ..., type: str = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsLayerMetadata.Constraint) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerMetadata) -> None: ...

    def combine(self, other: QgsAbstractMetadataBase) -> None: ...
    def writeMetadataXml(self, metadataElement: QtXml.QDomElement, document: QtXml.QDomDocument) -> bool: ...
    def readMetadataXml(self, metadataElement: QtXml.QDomElement) -> bool: ...
    def readFromLayer(self, layer: QgsMapLayer) -> None: ...
    def saveToLayer(self, layer: QgsMapLayer) -> None: ...
    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def setExtent(self, extent: QgsLayerMetadata.Extent) -> None: ...
    def extent(self) -> QgsLayerMetadata.Extent: ...
    def setEncoding(self, encoding: str) -> None: ...
    def encoding(self) -> str: ...
    def setLicenses(self, licenses: Iterable[str]) -> None: ...
    def licenses(self) -> List[str]: ...
    def setRights(self, rights: Iterable[str]) -> None: ...
    def rights(self) -> List[str]: ...
    def setConstraints(self, constraints: Iterable[QgsLayerMetadata.Constraint]) -> None: ...
    def addConstraint(self, constraint: QgsLayerMetadata.Constraint) -> None: ...
    def constraints(self) -> List[QgsLayerMetadata.Constraint]: ...
    def setFees(self, fees: str) -> None: ...
    def fees(self) -> str: ...
    def clone(self) -> QgsLayerMetadata: ...


class QgsLayerMetadataFormatter(sip.wrapper):

    @overload
    def __init__(self, metadata: QgsLayerMetadata) -> None: ...
    @overload
    def __init__(self, a0: QgsLayerMetadataFormatter) -> None: ...

    def linksSectionHtml(self) -> str: ...
    def historySectionHtml(self) -> str: ...
    def identificationSectionHtml(self) -> str: ...
    def extentSectionHtml(self, showSpatialExtent: bool = ...) -> str: ...
    def contactsSectionHtml(self) -> str: ...
    def accessSectionHtml(self) -> str: ...


class QgsAbstractMetadataBaseValidator(sip.wrapper):

    class ValidationResult(sip.wrapper):

        note: str = ...
        section: str = ...

        @overload
        def __init__(self, section: str, note: str, identifier: typing.Any = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsAbstractMetadataBaseValidator.ValidationResult) -> None: ...

        def _setIdentifier(self, identifier: typing.Any) -> None: ...
        def _identifier(self) -> typing.Any: ...
        @property
        def identifier(self) -> typing.Any: ...
        @identifier.setter
        def identifier(self, identifier: typing.Any) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAbstractMetadataBaseValidator) -> None: ...

    def validate(self, metadata: QgsAbstractMetadataBase) -> Tuple[bool, List[QgsAbstractMetadataBaseValidator.ValidationResult]]: ...


class QgsNativeMetadataBaseValidator(QgsAbstractMetadataBaseValidator):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNativeMetadataBaseValidator) -> None: ...

    def validate(self, metadata: QgsAbstractMetadataBase) -> Tuple[bool, List[QgsAbstractMetadataBaseValidator.ValidationResult]]: ...


class QgsNativeMetadataValidator(QgsNativeMetadataBaseValidator):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNativeMetadataValidator) -> None: ...

    def validate(self, metadata: QgsAbstractMetadataBase) -> Tuple[bool, List[QgsAbstractMetadataBaseValidator.ValidationResult]]: ...


class QgsNativeProjectMetadataValidator(QgsNativeMetadataBaseValidator):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNativeProjectMetadataValidator) -> None: ...

    def validate(self, metadata: QgsAbstractMetadataBase) -> Tuple[bool, List[QgsAbstractMetadataBaseValidator.ValidationResult]]: ...


class QgsMetadataUtils(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsMetadataUtils) -> None: ...

    @staticmethod
    def convertFromEsri(document: QtXml.QDomDocument) -> QgsLayerMetadata: ...


class QgsProjectMetadata(QgsAbstractMetadataBase):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsProjectMetadata) -> None: ...

    def combine(self, other: QgsAbstractMetadataBase) -> None: ...
    def writeMetadataXml(self, metadataElement: QtXml.QDomElement, document: QtXml.QDomDocument) -> bool: ...
    def readMetadataXml(self, metadataElement: QtXml.QDomElement) -> bool: ...
    def setCreationDateTime(self, creationDateTime: Union[QtCore.QDateTime, datetime.datetime]) -> None: ...
    def creationDateTime(self) -> QtCore.QDateTime: ...
    def setAuthor(self, author: str) -> None: ...
    def author(self) -> str: ...
    def clone(self) -> QgsProjectMetadata: ...


class QgsBlockingNetworkRequest(QtCore.QObject):

    class ErrorCode(int):
        ...
    NoError: QgsBlockingNetworkRequest.ErrorCode = ...
    NetworkError: QgsBlockingNetworkRequest.ErrorCode = ...
    TimeoutError: QgsBlockingNetworkRequest.ErrorCode = ...
    ServerExceptionError: QgsBlockingNetworkRequest.ErrorCode = ...

    def __init__(self) -> None: ...

    def downloadFinished(self) -> None: ...
    def downloadProgress(self, a0: int, a1: int) -> None: ...
    def abort(self) -> None: ...
    def setAuthCfg(self, authCfg: str) -> None: ...
    def authCfg(self) -> str: ...
    def reply(self) -> QgsNetworkReplyContent: ...
    def errorMessage(self) -> str: ...
    def deleteResource(self, request: QtNetwork.QNetworkRequest, feedback: Optional[QgsFeedback] = ...) -> QgsBlockingNetworkRequest.ErrorCode: ...
    def put(self, request: QtNetwork.QNetworkRequest, data: Union[QtCore.QByteArray, bytes, bytearray], feedback: Optional[QgsFeedback] = ...) -> QgsBlockingNetworkRequest.ErrorCode: ...
    def head(self, request: QtNetwork.QNetworkRequest, forceRefresh: bool = ..., feedback: Optional[QgsFeedback] = ...) -> QgsBlockingNetworkRequest.ErrorCode: ...
    def post(self, request: QtNetwork.QNetworkRequest, data: Union[QtCore.QByteArray, bytes, bytearray], forceRefresh: bool = ..., feedback: Optional[QgsFeedback] = ...) -> QgsBlockingNetworkRequest.ErrorCode: ...
    def get(self, request: QtNetwork.QNetworkRequest, forceRefresh: bool = ..., feedback: Optional[QgsFeedback] = ...) -> QgsBlockingNetworkRequest.ErrorCode: ...


class QgsFileDownloader(QtCore.QObject):

    def __init__(self, url: QtCore.QUrl, outputFileName: str, authcfg: str = ..., delayStart: bool = ...) -> None: ...

    def startDownload(self) -> None: ...
    def cancelDownload(self) -> None: ...
    def downloadProgress(self, bytesReceived: int, bytesTotal: int) -> None: ...
    def downloadError(self, errorMessages: Iterable[str]) -> None: ...
    def downloadCanceled(self) -> None: ...
    def downloadExited(self) -> None: ...
    def downloadCompleted(self, url: QtCore.QUrl) -> None: ...


class QgsNetworkRequestParameters(sip.wrapper):

    class RequestAttributes(int):
        ...
    AttributeInitiatorClass: QgsNetworkRequestParameters.RequestAttributes = ...
    AttributeInitiatorRequestId: QgsNetworkRequestParameters.RequestAttributes = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, operation: QtNetwork.QNetworkAccessManager.Operation, request: QtNetwork.QNetworkRequest, requestId: int, content: Union[QtCore.QByteArray, bytes, bytearray] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsNetworkRequestParameters) -> None: ...

    def initiatorRequestId(self) -> typing.Any: ...
    def initiatorClassName(self) -> str: ...
    def content(self) -> QtCore.QByteArray: ...
    def requestId(self) -> int: ...
    def originatingThreadId(self) -> str: ...
    def request(self) -> QtNetwork.QNetworkRequest: ...
    def operation(self) -> QtNetwork.QNetworkAccessManager.Operation: ...


class QgsNetworkAccessManager(QtNetwork.QNetworkAccessManager):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def createRequest(self, op: QtNetwork.QNetworkAccessManager.Operation, req: QtNetwork.QNetworkRequest, outgoingData: Optional[QtCore.QIODevice] = ...) -> QtNetwork.QNetworkReply: ...
    def authBrowserAborted(self) -> None: ...
    def requestCreated(self, a0: QtNetwork.QNetworkReply) -> None: ...
    def requestEncounteredSslErrors(self, requestId: int, errors: Iterable[QtNetwork.QSslError]) -> None: ...
    def requestAuthDetailsAdded(self, requestId: int, realm: str, user: str, password: str) -> None: ...
    def requestRequiresAuth(self, requestId: int, realm: str) -> None: ...
    def downloadProgress(self, requestId: int, bytesReceived: int, bytesTotal: int) -> None: ...
    @overload
    def requestTimedOut(self, request: QgsNetworkRequestParameters) -> None: ...
    @overload
    def requestTimedOut(self, a0: QtNetwork.QNetworkReply) -> None: ...
    def finished(self, reply: QgsNetworkReplyContent) -> None: ...
    @overload
    def requestAboutToBeCreated(self, a0: QtNetwork.QNetworkAccessManager.Operation, a1: QtNetwork.QNetworkRequest, a2: QtCore.QIODevice) -> None: ...
    @overload
    def requestAboutToBeCreated(self, request: QgsNetworkRequestParameters) -> None: ...
    def abortAuthBrowser(self) -> None: ...
    def requestAuthCloseBrowser(self) -> None: ...
    def requestAuthOpenBrowser(self, url: QtCore.QUrl) -> None: ...
    @staticmethod
    def blockingPost(request: QtNetwork.QNetworkRequest, data: Union[QtCore.QByteArray, bytes, bytearray], authCfg: str = ..., forceRefresh: bool = ..., feedback: Optional[QgsFeedback] = ...) -> QgsNetworkReplyContent: ...
    @staticmethod
    def blockingGet(request: QtNetwork.QNetworkRequest, authCfg: str = ..., forceRefresh: bool = ..., feedback: Optional[QgsFeedback] = ...) -> QgsNetworkReplyContent: ...
    @staticmethod
    def setTimeout(time: int) -> None: ...
    @staticmethod
    def timeout() -> int: ...
    def useSystemProxy(self) -> bool: ...
    def setupDefaultProxyAndCache(self, connectionType: QtCore.Qt.ConnectionType = ...) -> None: ...
    @staticmethod
    def cacheLoadControlFromName(name: str) -> QtNetwork.QNetworkRequest.CacheLoadControl: ...
    @staticmethod
    def cacheLoadControlName(control: QtNetwork.QNetworkRequest.CacheLoadControl) -> str: ...
    def setFallbackProxyAndExcludes(self, proxy: QtNetwork.QNetworkProxy, excludes: Iterable[str], noProxyURLs: Iterable[str]) -> None: ...
    def noProxyList(self) -> List[str]: ...
    def excludeList(self) -> List[str]: ...
    def fallbackProxy(self) -> QtNetwork.QNetworkProxy: ...
    def proxyFactories(self) -> List[QtNetwork.QNetworkProxyFactory]: ...
    def removeProxyFactory(self, factory: QtNetwork.QNetworkProxyFactory) -> None: ...
    def insertProxyFactory(self, factory: QtNetwork.QNetworkProxyFactory) -> None: ...
    @staticmethod
    def instance(connectionType: QtCore.Qt.ConnectionType = ...) -> QgsNetworkAccessManager: ...


class QgsNetworkContentFetcher(QtCore.QObject):

    def __init__(self) -> None: ...

    def downloadProgress(self, bytesReceived: int, bytesTotal: int) -> None: ...
    def finished(self) -> None: ...
    def wasCanceled(self) -> bool: ...
    def cancel(self) -> None: ...
    def contentAsString(self) -> str: ...
    def reply(self) -> QtNetwork.QNetworkReply: ...
    @overload
    def fetchContent(self, url: QtCore.QUrl, authcfg: str = ...) -> None: ...
    @overload
    def fetchContent(self, request: QtNetwork.QNetworkRequest, authcfg: str = ...) -> None: ...


class QgsFetchedContent(QtCore.QObject):

    class ContentStatus(int):
        ...
    NotStarted: QgsFetchedContent.ContentStatus = ...
    Downloading: QgsFetchedContent.ContentStatus = ...
    Finished: QgsFetchedContent.ContentStatus = ...
    Failed: QgsFetchedContent.ContentStatus = ...

    def __init__(self, url: str, file: Optional[QtCore.QTemporaryFile] = ..., status: QgsFetchedContent.ContentStatus = ...) -> None: ...

    def fetched(self) -> None: ...
    def cancel(self) -> None: ...
    def download(self, redownload: bool = ...) -> None: ...
    def error(self) -> QtNetwork.QNetworkReply.NetworkError: ...
    def status(self) -> QgsFetchedContent.ContentStatus: ...
    def filePath(self) -> str: ...


class QgsNetworkContentFetcherRegistry(QtCore.QObject):

    class FetchingMode(int):
        ...
    DownloadLater: QgsNetworkContentFetcherRegistry.FetchingMode = ...
    DownloadImmediately: QgsNetworkContentFetcherRegistry.FetchingMode = ...

    def __init__(self) -> None: ...

    def localPath(self, filePathOrUrl: str) -> str: ...
    def fetch(self, url: str, fetchingMode: QgsNetworkContentFetcherRegistry.FetchingMode = ...) -> QgsFetchedContent: ...


class QgsNetworkContentFetcherTask(QgsTask):

    @overload
    def __init__(self, url: QtCore.QUrl, authcfg: str = ..., flags: Union[QgsTask.Flags, QgsTask.Flag] = ...) -> None: ...
    @overload
    def __init__(self, request: QtNetwork.QNetworkRequest, authcfg: str = ..., flags: Union[QgsTask.Flags, QgsTask.Flag] = ...) -> None: ...

    def fetched(self) -> None: ...
    def contentAsString(self) -> str: ...
    def reply(self) -> QtNetwork.QNetworkReply: ...
    def cancel(self) -> None: ...
    def run(self) -> bool: ...


class QgsNetworkReplyContent(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, reply: QtNetwork.QNetworkReply) -> None: ...
    @overload
    def __init__(self, a0: QgsNetworkReplyContent) -> None: ...

    def content(self) -> QtCore.QByteArray: ...
    def setContent(self, content: Union[QtCore.QByteArray, bytes, bytearray]) -> None: ...
    def request(self) -> QtNetwork.QNetworkRequest: ...
    def requestId(self) -> int: ...
    def rawHeader(self, headerName: Union[QtCore.QByteArray, bytes, bytearray]) -> QtCore.QByteArray: ...
    def rawHeaderList(self) -> List[QtCore.QByteArray]: ...
    def hasRawHeader(self, headerName: Union[QtCore.QByteArray, bytes, bytearray]) -> bool: ...
    def errorString(self) -> str: ...
    def error(self) -> QtNetwork.QNetworkReply.NetworkError: ...
    def attribute(self, code: QtNetwork.QNetworkRequest.Attribute) -> typing.Any: ...
    def clear(self) -> None: ...


class QgsNewsFeedModel(QtCore.QAbstractItemModel):

    class Role(int):
        ...
    Key: QgsNewsFeedModel.Role = ...
    Title: QgsNewsFeedModel.Role = ...
    Content: QgsNewsFeedModel.Role = ...
    ImageUrl: QgsNewsFeedModel.Role = ...
    Image: QgsNewsFeedModel.Role = ...
    Link: QgsNewsFeedModel.Role = ...
    Sticky: QgsNewsFeedModel.Role = ...

    def __init__(self, parser: QgsNewsFeedParser, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def columnCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def rowCount(self, parent: QtCore.QModelIndex = ...) -> int: ...
    def parent(self, index: QtCore.QModelIndex) -> QtCore.QModelIndex: ...
    def index(self, row: int, column: int, parent: QtCore.QModelIndex = ...) -> QtCore.QModelIndex: ...
    def flags(self, index: QtCore.QModelIndex) -> QtCore.Qt.ItemFlags: ...
    def data(self, index: QtCore.QModelIndex, role: int) -> typing.Any: ...


class QgsNewsFeedProxyModel(QtCore.QSortFilterProxyModel):

    def __init__(self, parser: QgsNewsFeedParser, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def lessThan(self, left: QtCore.QModelIndex, right: QtCore.QModelIndex) -> bool: ...


class QgsNewsFeedParser(QtCore.QObject):

    class Entry(sip.wrapper):

        content: str = ...
        expiry: Union[QtCore.QDateTime, datetime.datetime] = ...
        image: QtGui.QPixmap = ...
        imageUrl: str = ...
        key: int = ...
        link: QtCore.QUrl = ...
        sticky: bool = ...
        title: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsNewsFeedParser.Entry) -> None: ...

    def __init__(self, feedUrl: QtCore.QUrl, authcfg: str = ..., parent: Optional[QtCore.QObject] = ...) -> None: ...

    def imageFetched(self, key: int, pixmap: QtGui.QPixmap) -> None: ...
    def entryDismissed(self, entry: QgsNewsFeedParser.Entry) -> None: ...
    def entryAdded(self, entry: QgsNewsFeedParser.Entry) -> None: ...
    def fetched(self, entries: Iterable[QgsNewsFeedParser.Entry]) -> None: ...
    def fetch(self) -> None: ...
    @staticmethod
    def keyForFeed(baseUrl: str) -> str: ...
    def authcfg(self) -> str: ...
    def dismissAll(self) -> None: ...
    def dismissEntry(self, key: int) -> None: ...
    def entries(self) -> List[QgsNewsFeedParser.Entry]: ...


class QgsNumericFormat(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNumericFormat) -> None: ...

    def writeXml(self, element: QtXml.QDomElement, document: QtXml.QDomDocument, context: QgsReadWriteContext) -> None: ...
    def configuration(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def create(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsNumericFormat: ...
    def clone(self) -> QgsNumericFormat: ...
    def formatDouble(self, value: float, context: QgsNumericFormatContext) -> str: ...
    def suggestSampleValue(self) -> float: ...
    def sortKey(self) -> int: ...
    def visibleName(self) -> str: ...
    def id(self) -> str: ...


class QgsBasicNumericFormat(QgsNumericFormat):

    class RoundingType(int):
        ...
    DecimalPlaces: QgsBasicNumericFormat.RoundingType = ...
    SignificantFigures: QgsBasicNumericFormat.RoundingType = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsBasicNumericFormat) -> None: ...

    def setConfiguration(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> None: ...
    def setDecimalSeparator(self, character: str) -> None: ...
    def decimalSeparator(self) -> str: ...
    def setThousandsSeparator(self, character: str) -> None: ...
    def thousandsSeparator(self) -> str: ...
    def setRoundingType(self, type: QgsBasicNumericFormat.RoundingType) -> None: ...
    def roundingType(self) -> QgsBasicNumericFormat.RoundingType: ...
    def setShowTrailingZeros(self, show: bool) -> None: ...
    def showTrailingZeros(self) -> bool: ...
    def setShowPlusSign(self, show: bool) -> None: ...
    def showPlusSign(self) -> bool: ...
    def setShowThousandsSeparator(self, show: bool) -> None: ...
    def showThousandsSeparator(self) -> bool: ...
    def setNumberDecimalPlaces(self, places: int) -> None: ...
    def numberDecimalPlaces(self) -> int: ...
    def configuration(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def create(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsNumericFormat: ...
    def clone(self) -> QgsNumericFormat: ...
    def formatDouble(self, value: float, context: QgsNumericFormatContext) -> str: ...
    def sortKey(self) -> int: ...
    def visibleName(self) -> str: ...
    def id(self) -> str: ...


class QgsBearingNumericFormat(QgsBasicNumericFormat):

    class FormatDirectionOption(int):
        ...
    UseRange0To180WithEWDirectionalSuffix: QgsBearingNumericFormat.FormatDirectionOption = ...
    UseRangeNegative180ToPositive180: QgsBearingNumericFormat.FormatDirectionOption = ...
    UseRange0To360: QgsBearingNumericFormat.FormatDirectionOption = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsBearingNumericFormat) -> None: ...

    def setConfiguration(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> None: ...
    def setDirectionFormat(self, format: QgsBearingNumericFormat.FormatDirectionOption) -> None: ...
    def directionFormat(self) -> QgsBearingNumericFormat.FormatDirectionOption: ...
    def configuration(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def create(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsNumericFormat: ...
    def clone(self) -> QgsBearingNumericFormat: ...
    def formatDouble(self, value: float, context: QgsNumericFormatContext) -> str: ...
    def suggestSampleValue(self) -> float: ...
    def sortKey(self) -> int: ...
    def visibleName(self) -> str: ...
    def id(self) -> str: ...


class QgsCurrencyNumericFormat(QgsBasicNumericFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsCurrencyNumericFormat) -> None: ...

    def setSuffix(self, suffix: str) -> None: ...
    def suffix(self) -> str: ...
    def setPrefix(self, prefix: str) -> None: ...
    def prefix(self) -> str: ...
    def configuration(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def create(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsNumericFormat: ...
    def clone(self) -> QgsNumericFormat: ...
    def formatDouble(self, value: float, context: QgsNumericFormatContext) -> str: ...
    def suggestSampleValue(self) -> float: ...
    def sortKey(self) -> int: ...
    def visibleName(self) -> str: ...
    def id(self) -> str: ...


class QgsFallbackNumericFormat(QgsNumericFormat):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsFallbackNumericFormat) -> None: ...

    def configuration(self, context: QgsReadWriteContext) -> Dict[str, typing.Any]: ...
    def create(self, configuration: Dict[str, typing.Any], context: QgsReadWriteContext) -> QgsNumericFormat