# -*- coding: utf-8 -*-

"""
***************************************************************************
    __init__.py
    ---------------------
    Date                 : May 2014
    Copyright            : (C) 2014 by Nathan Woodrow
    Email                : woodrow dot nathan at gmail dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Nathan Woodrow'
__date__ = 'May 2014'
__copyright__ = '(C) 2014, Nathan Woodrow'

from typing import (Any, Callable, Dict, Iterable, List, Optional, Sequence,
                    Tuple, Union, overload)

from PyQt5 import QtCore, QtGui, QtXml

from .core import (QgsAbstractGeometryTransformer,
                   QgsCoordinateReferenceSystem,
                   QgsCoordinateTransform,
                   QgsCoordinateTransformContext,
                   QgsDistanceArea,
                   QgsFeature,
                   QgsFeatureIterator,
                   QgsFeatureSink,
                   QgsFeatureSource,
                   QgsFeedback,
                   QgsFields,
                   QgsGeocoderInterface,
                   QgsGeometry,
                   QgsMapLayer,
                   QgsMesh,
                   QgsMeshDataset,
                   QgsMeshDatasetGroup,
                   QgsMeshDatasetIndex,
                   QgsMeshDatasetMetadata,
                   QgsMeshLayer,
                   QgsMeshRendererScalarSettings,
                   QgsPoint,
                   QgsPointXY,
                   QgsProcessingContext,
                   QgsProcessingFeatureBasedAlgorithm,
                   QgsProcessingFeedback,
                   QgsProcessingProvider,
                   QgsProject,
                   QgsRasterInterface,
                   QgsRasterLayer,
                   QgsReadWriteContext,
                   QgsRectangle,
                   QgsVectorLayer,
                   QgsVertexId,
                   QgsWkbTypes)
from ._types import sip

# Convenient type aliases.
PYQT_SIGNAL = Union[QtCore.pyqtSignal, QtCore.pyqtBoundSignal]
PYQT_SLOT = Union[Callable[..., None], QtCore.pyqtBoundSignal]

# Convenient aliases for complicated OpenGL types.
PYQT_OPENGL_ARRAY = Union[Sequence[int], Sequence[float], sip.Buffer, None]
PYQT_OPENGL_BOUND_ARRAY = Union[
    Sequence[int], Sequence[float], sip.Buffer, int, None]


class QgsAnalysis(sip.wrapper):

    @staticmethod
    def geometryCheckRegistry() -> QgsGeometryCheckRegistry: ...
    @staticmethod
    def instance() -> QgsAnalysis: ...


class QgsGcpGeometryTransformer(QgsAbstractGeometryTransformer):

    @overload
    def __init__(
        self, gcpTransformer: QgsGcpTransformerInterface) -> None: ...

    @overload
    def __init__(self, method: QgsGcpTransformerInterface.TransformMethod, sourceCoordinates:
                 Iterable[QgsPointXY], destinationCoordinates: Iterable[QgsPointXY]) -> None: ...

    def setGcpTransformer(
        self, transformer: QgsGcpTransformerInterface) -> None: ...

    def gcpTransformer(self) -> QgsGcpTransformerInterface: ...

    def transform(self, geometry: QgsGeometry,
                  feedback: Optional[QgsFeedback] = ...) -> Tuple[QgsGeometry, bool]: ...
    def transformPoint(self, x: float, y: float, z: float,
                       m: float) -> Tuple[bool, float, float, float, float]: ...


class QgsGcpTransformerInterface(sip.wrapper):

    class TransformMethod(int):
        ...
    Linear: QgsGcpTransformerInterface.TransformMethod = ...
    Helmert: QgsGcpTransformerInterface.TransformMethod = ...
    PolynomialOrder1: QgsGcpTransformerInterface.TransformMethod = ...
    PolynomialOrder2: QgsGcpTransformerInterface.TransformMethod = ...
    PolynomialOrder3: QgsGcpTransformerInterface.TransformMethod = ...
    ThinPlateSpline: QgsGcpTransformerInterface.TransformMethod = ...
    Projective: QgsGcpTransformerInterface.TransformMethod = ...
    InvalidTransform: QgsGcpTransformerInterface.TransformMethod = ...

    def __init__(self) -> None: ...
    @staticmethod
    def createFromParameters(method: QgsGcpTransformerInterface.TransformMethod, sourceCoordinates: Iterable[QgsPointXY], destinationCoordinates: Iterable[QgsPointXY]) -> QgsGcpTransformerInterface: ...
    @staticmethod
    def create(method: QgsGcpTransformerInterface.TransformMethod) -> QgsGcpTransformerInterface: ...
    @staticmethod
    def methodToString(method: QgsGcpTransformerInterface.TransformMethod) -> str: ...
    def transform(self, x: float, y: float, inverseTransform: bool = ...) -> Tuple[bool, float, float]: ...
    def method(self) -> QgsGcpTransformerInterface.TransformMethod: ...
    def minimumGcpCount(self) -> int: ...
    def updateParametersFromGcps(self, sourceCoordinates: Iterable[QgsPointXY], destinationCoordinates: Iterable[QgsPointXY], invertYAxis: bool = ...) -> bool: ...
    def clone(self) -> QgsGcpTransformerInterface: ...


class QgsGridFileWriter(sip.wrapper):

    @overload
    def __init__(self, interpolator: QgsInterpolator, outputPath: str, extent: QgsRectangle, nCols: int, nRows: int) -> None: ...
    @overload
    def __init__(self, a0: QgsGridFileWriter) -> None: ...
    def writeFile(self, feedback: Optional[QgsFeedback] = ...) -> int: ...


class QgsInterpolator(sip.wrapper):

    class Result(int):
        ...
    Success: QgsInterpolator.Result = ...
    Canceled: QgsInterpolator.Result = ...
    InvalidSource: QgsInterpolator.Result = ...
    FeatureGeometryError: QgsInterpolator.Result = ...

    class ValueSource(int):
        ...
    ValueAttribute: QgsInterpolator.ValueSource = ...
    ValueZ: QgsInterpolator.ValueSource = ...
    ValueM: QgsInterpolator.ValueSource = ...

    class SourceType(int):
        ...
    SourcePoints: QgsInterpolator.SourceType = ...
    SourceStructureLines: QgsInterpolator.SourceType = ...
    SourceBreakLines: QgsInterpolator.SourceType = ...

    class LayerData(sip.wrapper):

        interpolationAttribute: int = ...
        source: QgsFeatureSource = ...
        sourceType: QgsInterpolator.SourceType = ...
        transformContext: QgsCoordinateTransformContext = ...
        valueSource: QgsInterpolator.ValueSource = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsInterpolator.LayerData) -> None: ...

    @overload
    def __init__(self, layerData: Iterable[QgsInterpolator.LayerData]) -> None: ...

    @overload
    def __init__(self, a0: QgsInterpolator) -> None: ...
    def cacheBaseData(self, feedback: Optional[QgsFeedback] = ...) -> QgsInterpolator.Result: ...
    def interpolatePoint(self, x: float, y: float, feedback: Optional[QgsFeedback] = ...) -> Tuple[int, float]: ...


class QgsIDWInterpolator(QgsInterpolator):

    @overload
    def __init__(self, layerData: Iterable[QgsInterpolator.LayerData]) -> None: ...
    @overload
    def __init__(self, a0: QgsIDWInterpolator) -> None: ...
    def distanceCoefficient(self) -> float: ...
    def setDistanceCoefficient(self, coefficient: float) -> None: ...
    def interpolatePoint(self, x: float, y: float, feedback: Optional[QgsFeedback] = ...) -> Tuple[int, float]: ...


class QgsInterpolatorVertexData(sip.wrapper):

    x: float = ...
    y: float = ...
    z: float = ...

    @overload
    def __init__(self, x: float, y: float, z: float) -> None: ...
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsInterpolatorVertexData) -> None: ...


class QgsTinInterpolator(QgsInterpolator):

    class TinInterpolation(int):
        ...
    Linear: QgsTinInterpolator.TinInterpolation = ...
    CloughTocher: QgsTinInterpolator.TinInterpolation = ...

    @overload
    def __init__(self, inputData: Iterable[QgsInterpolator.LayerData], interpolation: QgsTinInterpolator.TinInterpolation = ..., feedback: Optional[QgsFeedback] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsTinInterpolator) -> None: ...
    def setTriangulationSink(self, sink: QgsFeatureSink) -> None: ...
    @staticmethod
    def triangulationFields() -> QgsFields: ...
    def interpolatePoint(self, x: float, y: float, feedback: QgsFeedback) -> Tuple[int, float]: ...


class QgsMeshContours(sip.wrapper):

    @overload
    def __init__(self, layer: QgsMeshLayer) -> None: ...
    @overload
    def __init__(self, a0: QgsMeshContours) -> None: ...

    def exportPolygons(self, index: QgsMeshDatasetIndex, min_value: float, max_value: float,
                       method: QgsMeshRendererScalarSettings.DataResamplingMethod, feedback: Optional[QgsFeedback] = ...) -> QgsGeometry: ...
    def exportLines(self, index: QgsMeshDatasetIndex, value: float, method: QgsMeshRendererScalarSettings.DataResamplingMethod,
                    feedback: Optional[QgsFeedback] = ...) -> QgsGeometry: ...


class QgsMeshTriangulation(QtCore.QObject):

    def __init__(self) -> None: ...

    def setCrs(self, crs: QgsCoordinateReferenceSystem) -> None: ...
    def triangulatedMesh(self, feedback: Optional[QgsFeedback] = ...) -> QgsMesh: ...
    def addBreakLines(self, lineFeatureIterator: QgsFeatureIterator, valueAttribute: int, transformContext: QgsCoordinateTransform, feedback: Optional[QgsFeedback] = ..., featureCount: int = ...) -> bool: ...
    def addVertices(self, vertexFeatureIterator: QgsFeatureIterator, valueAttribute: int, transform: QgsCoordinateTransform, feedback: Optional[QgsFeedback] = ..., featureCount: int = ...) -> bool: ...


class QgsMeshZValueDatasetGroup(QgsMeshDatasetGroup):

    def __init__(self, datasetGroupName: str, mesh: QgsMesh) -> None: ...

    def writeXml(self, doc: QtXml.QDomDocument, context: QgsReadWriteContext) -> QtXml.QDomElement: ...
    def type(self) -> QgsMeshDatasetGroup.Type: ...
    def dataset(self, index: int) -> QgsMeshDataset: ...
    def datasetCount(self) -> int: ...
    def datasetMetadata(self, datasetIndex: int) -> QgsMeshDatasetMetadata: ...
    def initialize(self) -> None: ...


class QgsGraphEdge(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGraphEdge) -> None: ...

    def fromVertex(self) -> int: ...
    def toVertex(self) -> int: ...
    def strategies(self) -> List[Any]: ...
    def cost(self, strategyIndex: int) -> Any: ...


class QgsGraphVertex(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, point: QgsPointXY) -> None: ...
    @overload
    def __init__(self, a0: QgsGraphVertex) -> None: ...

    def point(self) -> QgsPointXY: ...
    def outgoingEdges(self) -> List[int]: ...
    def incomingEdges(self) -> List[int]: ...


class QgsGraph(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGraph) -> None: ...

    def findVertex(self, pt: QgsPointXY) -> int: ...
    def edge(self, idx: int) -> QgsGraphEdge: ...
    def edgeCount(self) -> int: ...
    def vertex(self, idx: int) -> QgsGraphVertex: ...
    def vertexCount(self) -> int: ...
    def addEdge(self, fromVertexIdx: int, toVertexIdx: int, strategies: Iterable[Any]) -> int: ...
    def addVertex(self, pt: QgsPointXY) -> int: ...


class QgsGraphAnalyzer(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGraphAnalyzer) -> None: ...
    @staticmethod
    def shortestTree(source: QgsGraph, startVertexIdx: int, criterionNum: int) -> QgsGraph: ...
    @staticmethod
    def dijkstra(source: QgsGraph, startVertexIdx: int, criterionNum: int, resultTree: Optional[Iterable[int]] = ..., resultCost: Optional[Iterable[float]] = ...) -> List[int]: ...


class QgsGraphBuilderInterface(sip.wrapper):

    @overload
    def __init__(self, crs: QgsCoordinateReferenceSystem, ctfEnabled: bool = ..., topologyTolerance: float = ..., ellipsoidID: str = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsGraphBuilderInterface) -> None: ...
    def addEdge(self, pt1id: int, pt1: QgsPointXY, pt2id: int, pt2: QgsPointXY, strategies: Iterable[Any]) -> None: ...
    def addVertex(self, id: int, pt: QgsPointXY) -> None: ...
    def distanceArea(self) -> QgsDistanceArea: ...
    def topologyTolerance(self) -> float: ...
    def coordinateTransformationEnabled(self) -> bool: ...
    def destinationCrs(self) -> QgsCoordinateReferenceSystem: ...


class QgsGraphBuilder(QgsGraphBuilderInterface):

    def __init__(self, crs: QgsCoordinateReferenceSystem, otfEnabled: bool = ..., topologyTolerance: float = ..., ellipsoidID: str = ...) -> None: ...

    def graph(self) -> QgsGraph: ...
    def addEdge(self, pt1id: int, pt1: QgsPointXY, pt2id: int, pt2: QgsPointXY, prop: Iterable[Any]) -> None: ...
    def addVertex(self, id: int, pt: QgsPointXY) -> None: ...


class QgsGraphDirector(QtCore.QObject):

    def __init__(self) -> None: ...

    def name(self) -> str: ...
    def addStrategy(self, prop: QgsNetworkStrategy) -> None: ...
    def makeGraph(self, builder: QgsGraphBuilderInterface, additionalPoints: Iterable[QgsPointXY], feedback: Optional[QgsFeedback] = ...) -> List[QgsPointXY]: ...


class QgsNetworkStrategy(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNetworkStrategy) -> None: ...

    def cost(self, distance: float, f: QgsFeature) -> Any: ...
    def requiredAttributes(self) -> Any: ...


class QgsNetworkDistanceStrategy(QgsNetworkStrategy):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsNetworkDistanceStrategy) -> None: ...

    def cost(self, distance: float, a1: QgsFeature) -> Any: ...


class QgsNetworkSpeedStrategy(QgsNetworkStrategy):

    @overload
    def __init__(self, attributeId: int, defaultValue: float, toMetricFactor: float) -> None: ...
    @overload
    def __init__(self, a0: QgsNetworkSpeedStrategy) -> None: ...
    def requiredAttributes(self) -> Any: ...
    def cost(self, distance: float, f: QgsFeature) -> Any: ...


class QgsVectorLayerDirector(QgsGraphDirector):

    class Direction(int):
        ...
    DirectionForward: QgsVectorLayerDirector.Direction = ...
    DirectionBackward: QgsVectorLayerDirector.Direction = ...
    DirectionBoth: QgsVectorLayerDirector.Direction = ...

    def __init__(self, source: QgsFeatureSource, directionFieldId: int, directDirectionValue: str, reverseDirectionValue: str, bothDirectionValue: str, defaultDirection: QgsVectorLayerDirector.Direction) -> None: ...

    def name(self) -> str: ...
    def makeGraph(self, builder: QgsGraphBuilderInterface, additionalPoints: Iterable[QgsPointXY], feedback: Optional[QgsFeedback] = ...) -> List[QgsPointXY]: ...


class QgsBatchGeocodeAlgorithm(QgsProcessingFeatureBasedAlgorithm):

    def __init__(self, geocoder: QgsGeocoderInterface) -> None: ...

    def outputWkbType(self, inputWkbType: QgsWkbTypes.Type) -> QgsWkbTypes.Type: ...
    def outputFields(self, inputFields: QgsFields) -> QgsFields: ...
    def outputCrs(self, inputCrs: QgsCoordinateReferenceSystem) -> QgsCoordinateReferenceSystem: ...
    def processFeature(self, feature: QgsFeature, a1: QgsProcessingContext, feedback: QgsProcessingFeedback) -> List[QgsFeature]: ...
    def prepareAlgorithm(self, parameters: Dict[str, Any], context: QgsProcessingContext, feedback: QgsProcessingFeedback) -> bool: ...
    def outputName(self) -> str: ...
    def supportInPlaceEdit(self, layer: QgsMapLayer) -> bool: ...
    def inputLayerTypes(self) -> List[int]: ...
    def groupId(self) -> str: ...
    def group(self) -> str: ...
    def tags(self) -> List[str]: ...
    def initParameters(self, configuration: Dict[str, Any] = ...) -> None: ...


class QgsNativeAlgorithms(QgsProcessingProvider):

    def __init__(self, parent: Optional[QtCore.QObject] = ...) -> None: ...

    def loadAlgorithms(self) -> None: ...
    def supportsNonFileBasedOutput(self) -> bool: ...
    def name(self) -> str: ...
    def helpId(self) -> str: ...
    def id(self) -> str: ...
    def svgIconPath(self) -> str: ...
    def icon(self) -> QtGui.QIcon: ...


class QgsAlignRaster(sip.wrapper):

    class ResampleAlg(int):
        ...
    RA_NearestNeighbour: QgsAlignRaster.ResampleAlg = ...
    RA_Bilinear: QgsAlignRaster.ResampleAlg = ...
    RA_Cubic: QgsAlignRaster.ResampleAlg = ...
    RA_CubicSpline: QgsAlignRaster.ResampleAlg = ...
    RA_Lanczos: QgsAlignRaster.ResampleAlg = ...
    RA_Average: QgsAlignRaster.ResampleAlg = ...
    RA_Mode: QgsAlignRaster.ResampleAlg = ...
    RA_Max: QgsAlignRaster.ResampleAlg = ...
    RA_Min: QgsAlignRaster.ResampleAlg = ...
    RA_Median: QgsAlignRaster.ResampleAlg = ...
    RA_Q1: QgsAlignRaster.ResampleAlg = ...
    RA_Q3: QgsAlignRaster.ResampleAlg = ...

    class RasterInfo(sip.wrapper):

        def __init__(self, layerpath: str) -> None: ...

        def identify(self, mx: float, my: float) -> float: ...
        def dump(self) -> None: ...
        def origin(self) -> QtCore.QPointF: ...
        def extent(self) -> QgsRectangle: ...
        def gridOffset(self) -> QtCore.QPointF: ...
        def cellSize(self) -> QtCore.QSizeF: ...
        def bandCount(self) -> int: ...
        def rasterSize(self) -> QtCore.QSize: ...
        def crs(self) -> str: ...
        def isValid(self) -> bool: ...

    class Item(sip.wrapper):

        inputFilename: str = ...
        outputFilename: str = ...
        resampleMethod: QgsAlignRaster.ResampleAlg = ...
        rescaleValues: bool = ...
        srcCellSizeInDestCRS: float = ...

        @overload
        def __init__(self, input: str, output: str) -> None: ...
        @overload
        def __init__(self, a0: QgsAlignRaster.Item) -> None: ...

    class ProgressHandler(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsAlignRaster.ProgressHandler) -> None: ...

        def progress(self, complete: float) -> bool: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsAlignRaster) -> None: ...

    @staticmethod
    def suggestedWarpOutput(info: QgsAlignRaster.RasterInfo, destWkt: str, cellSize: Optional[QtCore.QSizeF] = ..., gridOffset: Optional[Union[QtCore.QPointF, QtCore.QPoint]] = ..., rect: Optional[QgsRectangle] = ...) -> bool: ...
    def createAndWarp(self, raster: QgsAlignRaster.Item) -> bool: ...
    def suggestedReferenceLayer(self) -> int: ...
    def dump(self) -> None: ...
    def errorMessage(self) -> str: ...
    def run(self) -> bool: ...
    def alignedRasterExtent(self) -> QgsRectangle: ...
    def alignedRasterSize(self) -> QtCore.QSize: ...
    def checkInputParameters(self) -> bool: ...
    @overload
    def setParametersFromRaster(self, rasterInfo: QgsAlignRaster.RasterInfo, customCRSWkt: str = ..., customCellSize: QtCore.QSizeF = ..., customGridOffset: Union[QtCore.QPointF, QtCore.QPoint] = ...) -> bool: ...
    @overload
    def setParametersFromRaster(self, filename: str, customCRSWkt: str = ..., customCellSize: QtCore.QSizeF = ..., customGridOffset: Union[QtCore.QPointF, QtCore.QPoint] = ...) -> bool: ...
    def clipExtent(self) -> QgsRectangle: ...
    @overload
    def setClipExtent(self, xmin: float, ymin: float, xmax: float, ymax: float) -> None: ...
    @overload
    def setClipExtent(self, extent: QgsRectangle) -> None: ...
    def destinationCrs(self) -> str: ...
    def setDestinationCrs(self, crsWkt: str) -> None: ...
    def cellSize(self) -> QtCore.QSizeF: ...
    @overload
    def setCellSize(self, x: float, y: float) -> None: ...
    @overload
    def setCellSize(self, size: QtCore.QSizeF) -> None: ...
    def gridOffset(self) -> QtCore.QPointF: ...
    def setGridOffset(self, offset: Union[QtCore.QPointF, QtCore.QPoint]) -> None: ...
    def rasters(self) -> List[QgsAlignRaster.Item]: ...
    def setRasters(self, list: Iterable[QgsAlignRaster.Item]) -> None: ...
    def progressHandler(self) -> QgsAlignRaster.ProgressHandler: ...
    def setProgressHandler(self, progressHandler: QgsAlignRaster.ProgressHandler) -> None: ...


class QgsNineCellFilter(sip.wrapper):

    @overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @overload
    def __init__(self, a0: QgsNineCellFilter) -> None: ...

    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def setOutputNodataValue(self, value: float) -> None: ...
    def outputNodataValue(self) -> float: ...
    def setInputNodataValue(self, value: float) -> None: ...
    def inputNodataValue(self) -> float: ...
    def setZFactor(self, factor: float) -> None: ...
    def zFactor(self) -> float: ...
    def setCellSizeY(self, size: float) -> None: ...
    def cellSizeY(self) -> float: ...
    def setCellSizeX(self, size: float) -> None: ...
    def cellSizeX(self) -> float: ...
    def processRaster(self, feedback: Optional[QgsFeedback] = ...) -> int: ...


class QgsDerivativeFilter(QgsNineCellFilter):

    @overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @overload
    def __init__(self, a0: QgsDerivativeFilter) -> None: ...

    def calcFirstDerY(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def calcFirstDerX(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...
    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsAspectFilter(QgsDerivativeFilter):

    @overload
    def __init__(self, inputFile: str, outputFile: str,
                 outputFormat: str) -> None: ...

    @overload
    def __init__(self, a0: QgsAspectFilter) -> None: ...

    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsExifTools(sip.wrapper):

    class GeoTagDetails(sip.wrapper):

        elevation: float = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsExifTools.GeoTagDetails) -> None: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsExifTools) -> None: ...

    @staticmethod
    def geoTagImage(imagePath: str, location: QgsPointXY, details: QgsExifTools.GeoTagDetails = ...) -> bool: ...
    @staticmethod
    def hasGeoTag(imagePath: str) -> bool: ...
    @staticmethod
    def getGeoTag(imagePath: str) -> Tuple[QgsPoint, bool]: ...


class QgsHillshadeFilter(QgsDerivativeFilter):

    @overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str,
                 lightAzimuth: float = ..., lightAngle: float = ...) -> None: ...

    @overload
    def __init__(self, a0: QgsHillshadeFilter) -> None: ...

    def setLightAngle(self, angle: float) -> None: ...
    def lightAngle(self) -> float: ...
    def setLightAzimuth(self, azimuth: float) -> None: ...
    def lightAzimuth(self) -> float: ...
    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsKernelDensityEstimation(sip.wrapper):

    class Result(int):
        ...
    Success: QgsKernelDensityEstimation.Result = ...
    DriverError: QgsKernelDensityEstimation.Result = ...
    InvalidParameters: QgsKernelDensityEstimation.Result = ...
    FileCreationError: QgsKernelDensityEstimation.Result = ...
    RasterIoError: QgsKernelDensityEstimation.Result = ...

    class OutputValues(int):
        ...
    OutputRaw: QgsKernelDensityEstimation.OutputValues = ...
    OutputScaled: QgsKernelDensityEstimation.OutputValues = ...

    class KernelShape(int):
        ...
    KernelQuartic: QgsKernelDensityEstimation.KernelShape = ...
    KernelTriangular: QgsKernelDensityEstimation.KernelShape = ...
    KernelUniform: QgsKernelDensityEstimation.KernelShape = ...
    KernelTriweight: QgsKernelDensityEstimation.KernelShape = ...
    KernelEpanechnikov: QgsKernelDensityEstimation.KernelShape = ...

    class Parameters(sip.wrapper):

        decayRatio: float = ...
        outputValues: QgsKernelDensityEstimation.OutputValues = ...
        pixelSize: float = ...
        radius: float = ...
        radiusField: str = ...
        shape: QgsKernelDensityEstimation.KernelShape = ...
        source: QgsFeatureSource = ...
        weightField: str = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsKernelDensityEstimation.Parameters) -> None: ...

    def __init__(self, parameters: QgsKernelDensityEstimation.Parameters, outputFile: str, outputFormat: str) -> None: ...

    def finalise(self) -> QgsKernelDensityEstimation.Result: ...
    def addFeature(self, feature: QgsFeature) -> QgsKernelDensityEstimation.Result: ...
    def prepare(self) -> QgsKernelDensityEstimation.Result: ...
    def run(self) -> QgsKernelDensityEstimation.Result: ...


class QgsRasterCalcNode(sip.wrapper):

    class Operator(int):
        ...
    opPLUS: QgsRasterCalcNode.Operator = ...
    opMINUS: QgsRasterCalcNode.Operator = ...
    opMUL: QgsRasterCalcNode.Operator = ...
    opDIV: QgsRasterCalcNode.Operator = ...
    opPOW: QgsRasterCalcNode.Operator = ...
    opSQRT: QgsRasterCalcNode.Operator = ...
    opSIN: QgsRasterCalcNode.Operator = ...
    opCOS: QgsRasterCalcNode.Operator = ...
    opTAN: QgsRasterCalcNode.Operator = ...
    opASIN: QgsRasterCalcNode.Operator = ...
    opACOS: QgsRasterCalcNode.Operator = ...
    opATAN: QgsRasterCalcNode.Operator = ...
    opEQ: QgsRasterCalcNode.Operator = ...
    opNE: QgsRasterCalcNode.Operator = ...
    opGT: QgsRasterCalcNode.Operator = ...
    opLT: QgsRasterCalcNode.Operator = ...
    opGE: QgsRasterCalcNode.Operator = ...
    opLE: QgsRasterCalcNode.Operator = ...
    opAND: QgsRasterCalcNode.Operator = ...
    opOR: QgsRasterCalcNode.Operator = ...
    opSIGN: QgsRasterCalcNode.Operator = ...
    opLOG: QgsRasterCalcNode.Operator = ...
    opLOG10: QgsRasterCalcNode.Operator = ...
    opABS: QgsRasterCalcNode.Operator = ...
    opMAX: QgsRasterCalcNode.Operator = ...
    opMIN: QgsRasterCalcNode.Operator = ...
    opNONE: QgsRasterCalcNode.Operator = ...

    class Type(int):
        ...
    tOperator: QgsRasterCalcNode.Type = ...
    tNumber: QgsRasterCalcNode.Type = ...
    tRasterRef: QgsRasterCalcNode.Type = ...
    tMatrix: QgsRasterCalcNode.Type = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, number: float) -> None: ...
    @overload
    def __init__(self, matrix: QgsRasterMatrix) -> None: ...
    @overload
    def __init__(self, op: QgsRasterCalcNode.Operator, left: QgsRasterCalcNode, right: QgsRasterCalcNode) -> None: ...
    @overload
    def __init__(self, rasterName: str) -> None: ...

    @staticmethod
    def parseRasterCalcString(str: str, parserErrorMsg: str) -> QgsRasterCalcNode: ...
    def findNodes(self, type: QgsRasterCalcNode.Type) -> List[QgsRasterCalcNode]: ...
    def toString(self, cStyle: bool = ...) -> str: ...
    def setRight(self, right: QgsRasterCalcNode) -> None: ...
    def setLeft(self, left: QgsRasterCalcNode) -> None: ...
    def type(self) -> QgsRasterCalcNode.Type: ...


class QgsRasterCalculatorEntry(sip.wrapper):

    bandNumber: int = ...
    raster: QgsRasterLayer = ...
    ref: str = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsRasterCalculatorEntry) -> None: ...

    @staticmethod
    def rasterEntries() -> List[QgsRasterCalculatorEntry]: ...


class QgsRasterCalculator(sip.wrapper):

    class Result(int):
        ...
    Success: QgsRasterCalculator.Result = ...
    CreateOutputError: QgsRasterCalculator.Result = ...
    InputLayerError: QgsRasterCalculator.Result = ...
    Canceled: QgsRasterCalculator.Result = ...
    ParserError: QgsRasterCalculator.Result = ...
    MemoryError: QgsRasterCalculator.Result = ...
    BandError: QgsRasterCalculator.Result = ...
    CalculationError: QgsRasterCalculator.Result = ...

    @overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: QgsRectangle, nOutputColumns: int, nOutputRows: int, rasterEntries: Iterable[QgsRasterCalculatorEntry], transformContext: QgsCoordinateTransformContext) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: QgsRectangle, outputCrs: QgsCoordinateReferenceSystem, nOutputColumns: int, nOutputRows: int, rasterEntries: Iterable[QgsRasterCalculatorEntry], transformContext: QgsCoordinateTransformContext) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: QgsRectangle, nOutputColumns: int, nOutputRows: int, rasterEntries: Iterable[QgsRasterCalculatorEntry]) -> None: ...
    @overload
    def __init__(self, formulaString: str, outputFile: str, outputFormat: str, outputExtent: QgsRectangle, outputCrs: QgsCoordinateReferenceSystem, nOutputColumns: int, nOutputRows: int, rasterEntries: Iterable[QgsRasterCalculatorEntry]) -> None: ...
    @overload
    def __init__(self, a0: QgsRasterCalculator) -> None: ...

    def lastError(self) -> str: ...
    def processCalculation(self, feedback: Optional[QgsFeedback] = ...) -> QgsRasterCalculator.Result: ...


class QgsRasterMatrix(sip.wrapper):

    class OneArgOperator(int):
        ...
    opSQRT: QgsRasterMatrix.OneArgOperator = ...
    opSIN: QgsRasterMatrix.OneArgOperator = ...
    opCOS: QgsRasterMatrix.OneArgOperator = ...
    opTAN: QgsRasterMatrix.OneArgOperator = ...
    opASIN: QgsRasterMatrix.OneArgOperator = ...
    opACOS: QgsRasterMatrix.OneArgOperator = ...
    opATAN: QgsRasterMatrix.OneArgOperator = ...
    opSIGN: QgsRasterMatrix.OneArgOperator = ...
    opLOG: QgsRasterMatrix.OneArgOperator = ...
    opLOG10: QgsRasterMatrix.OneArgOperator = ...
    opABS: QgsRasterMatrix.OneArgOperator = ...

    class TwoArgOperator(int):
        ...
    opPLUS: QgsRasterMatrix.TwoArgOperator = ...
    opMINUS: QgsRasterMatrix.TwoArgOperator = ...
    opMUL: QgsRasterMatrix.TwoArgOperator = ...
    opDIV: QgsRasterMatrix.TwoArgOperator = ...
    opPOW: QgsRasterMatrix.TwoArgOperator = ...
    opEQ: QgsRasterMatrix.TwoArgOperator = ...
    opNE: QgsRasterMatrix.TwoArgOperator = ...
    opGT: QgsRasterMatrix.TwoArgOperator = ...
    opLT: QgsRasterMatrix.TwoArgOperator = ...
    opGE: QgsRasterMatrix.TwoArgOperator = ...
    opLE: QgsRasterMatrix.TwoArgOperator = ...
    opAND: QgsRasterMatrix.TwoArgOperator = ...
    opOR: QgsRasterMatrix.TwoArgOperator = ...
    opMIN: QgsRasterMatrix.TwoArgOperator = ...
    opMAX: QgsRasterMatrix.TwoArgOperator = ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, m: QgsRasterMatrix) -> None: ...

    def absoluteValue(self) -> bool: ...
    def log10(self) -> bool: ...
    def log(self) -> bool: ...
    def changeSign(self) -> bool: ...
    def atangens(self) -> bool: ...
    def tangens(self) -> bool: ...
    def acosinus(self) -> bool: ...
    def cosinus(self) -> bool: ...
    def asinus(self) -> bool: ...
    def sinus(self) -> bool: ...
    def squareRoot(self) -> bool: ...
    def min(self, other: QgsRasterMatrix) -> bool: ...
    def max(self, other: QgsRasterMatrix) -> bool: ...
    def logicalOr(self, other: QgsRasterMatrix) -> bool: ...
    def logicalAnd(self, other: QgsRasterMatrix) -> bool: ...
    def lesserEqual(self, other: QgsRasterMatrix) -> bool: ...
    def greaterEqual(self, other: QgsRasterMatrix) -> bool: ...
    def lesserThan(self, other: QgsRasterMatrix) -> bool: ...
    def greaterThan(self, other: QgsRasterMatrix) -> bool: ...
    def notEqual(self, other: QgsRasterMatrix) -> bool: ...
    def equal(self, other: QgsRasterMatrix) -> bool: ...
    def power(self, other: QgsRasterMatrix) -> bool: ...
    def divide(self, other: QgsRasterMatrix) -> bool: ...
    def multiply(self, other: QgsRasterMatrix) -> bool: ...
    def subtract(self, other: QgsRasterMatrix) -> bool: ...
    def add(self, other: QgsRasterMatrix) -> bool: ...
    def setNodataValue(self, d: float) -> None: ...
    def nodataValue(self) -> float: ...
    def nRows(self) -> int: ...
    def nColumns(self) -> int: ...
    def setData(self, cols: int, rows: int, nodataValue: float) -> float: ...
    def number(self) -> float: ...
    def isNumber(self) -> bool: ...


class QgsRelief(sip.wrapper):

    class ReliefColor(sip.wrapper):

        color: Union[QtGui.QColor, QtCore.Qt.GlobalColor] = ...
        maxElevation: float = ...
        minElevation: float = ...

        @overload
        def __init__(self, c: Union[QtGui.QColor, QtCore.Qt.GlobalColor], min: float, max: float) -> None: ...
        @overload
        def __init__(self, a0: QgsRelief.ReliefColor) -> None: ...

    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...

    def exportFrequencyDistributionToCsv(self, file: str) -> bool: ...
    def calculateOptimizedReliefClasses(self) -> List[QgsRelief.ReliefColor]: ...
    def setReliefColors(self, c: Iterable[QgsRelief.ReliefColor]) -> None: ...
    def reliefColors(self) -> List[QgsRelief.ReliefColor]: ...
    def addReliefColorClass(self, color: QgsRelief.ReliefColor) -> None: ...
    def clearReliefColors(self) -> None: ...
    def setZFactor(self, factor: float) -> None: ...
    def zFactor(self) -> float: ...
    def processRaster(self, feedback: Optional[QgsFeedback] = ...) -> int: ...


class QgsRuggednessFilter(QgsNineCellFilter):

    @overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @overload
    def __init__(self, a0: QgsRuggednessFilter) -> None: ...

    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsSlopeFilter(QgsDerivativeFilter):

    @overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @overload
    def __init__(self, a0: QgsSlopeFilter) -> None: ...

    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsTotalCurvatureFilter(QgsNineCellFilter):

    @overload
    def __init__(self, inputFile: str, outputFile: str, outputFormat: str) -> None: ...
    @overload
    def __init__(self, a0: QgsTotalCurvatureFilter) -> None: ...

    def processNineCellWindow(self) -> Tuple[float, float, float, float, float, float, float, float, float, float]: ...


class QgsFeaturePool(QgsFeatureSink):

    def __init__(self, layer: QgsVectorLayer) -> None: ...

    def removeFeature(self, featureId: int) -> None: ...
    def refreshCache(self, feature: QgsFeature) -> None: ...
    def insertFeature(self, feature: QgsFeature, skipLock: bool = ...) -> None: ...
    def layerName(self) -> str: ...
    def crs(self) -> QgsCoordinateReferenceSystem: ...
    def geometryType(self) -> QgsWkbTypes.GeometryType: ...
    def layerId(self) -> str: ...
    def layer(self) -> QgsVectorLayer: ...
    def deleteFeature(self, fid: int) -> None: ...
    def updateFeature(self, feature: QgsFeature) -> None: ...
    def getFeature(self, id: int, feature: QgsFeature) -> bool: ...


class QgsGeometryCheck(sip.wrapper):

    class Flag(int):
        ...
    AvailableInValidation: QgsGeometryCheck.Flag = ...

    class CheckType(int):
        ...
    FeatureNodeCheck: QgsGeometryCheck.CheckType = ...
    FeatureCheck: QgsGeometryCheck.CheckType = ...
    LayerCheck: QgsGeometryCheck.CheckType = ...

    class ChangeType(int):
        ...
    ChangeAdded: QgsGeometryCheck.ChangeType = ...
    ChangeRemoved: QgsGeometryCheck.ChangeType = ...
    ChangeChanged: QgsGeometryCheck.ChangeType = ...

    class ChangeWhat(int):
        ...
    ChangeFeature: QgsGeometryCheck.ChangeWhat = ...
    ChangePart: QgsGeometryCheck.ChangeWhat = ...
    ChangeRing: QgsGeometryCheck.ChangeWhat = ...
    ChangeNode: QgsGeometryCheck.ChangeWhat = ...

    class LayerFeatureIds(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, a0: QgsGeometryCheck.LayerFeatureIds) -> None: ...

    class Flags(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsGeometryCheck.Flags, QgsGeometryCheck.Flag]) -> None: ...
        @overload
        def __init__(self, a0: QgsGeometryCheck.Flags) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsGeometryCheck.Flags: ...
        def __int__(self) -> int: ...

    class Change(sip.wrapper):

        type: QgsGeometryCheck.ChangeType = ...
        vidx: QgsVertexId = ...
        what: QgsGeometryCheck.ChangeWhat = ...

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, _what: QgsGeometryCheck.ChangeWhat, _type: QgsGeometryCheck.ChangeType, _vidx: QgsVertexId = ...) -> None: ...
        @overload
        def __init__(self, a0: QgsGeometryCheck.Change) -> None: ...

    staticMetaObject: QtCore.QMetaObject = ...

    @overload
    def __init__(self, context: QgsGeometryCheckContext, configuration: Dict[str, Any]) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheck) -> None: ...

    def context(self) -> QgsGeometryCheckContext: ...
    def checkType(self) -> QgsGeometryCheck.CheckType: ...
    def id(self) -> str: ...
    def description(self) -> str: ...
    def resolutionMethods(self) -> List[str]: ...
    def availableResolutionMethods(self) -> List[QgsGeometryCheckResolutionMethod]: ...
    def collectErrors(self, featurePools: Any, errors: Iterable[QgsGeometryCheckError], messages: Iterable[str], feedback: QgsFeedback, ids: QgsGeometryCheck.LayerFeatureIds = ...) -> Tuple[List[QgsGeometryCheckError], List[str]]: ...
    def flags(self) -> QgsGeometryCheck.Flags: ...
    def compatibleGeometryTypes(self) -> Any: ...
    def isCompatible(self, layer: QgsVectorLayer) -> bool: ...
    def prepare(self, context: QgsGeometryCheckContext, configuration: Dict[str, Any]) -> None: ...


class QgsGeometryCheckResolutionMethod(sip.wrapper):

    @overload
    def __init__(self, id: int, name: str, description: str, isStable: bool = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheckResolutionMethod) -> None: ...

    def description(self) -> str: ...
    def name(self) -> str: ...
    def isStable(self) -> bool: ...
    def id(self) -> int: ...


class QgsGeometryCheckContext(sip.wrapper):

    mapCrs: QgsCoordinateReferenceSystem = ...
    reducedTolerance: float = ...
    tolerance: float = ...
    transformContext: QgsCoordinateTransformContext = ...

    def __init__(self, precision: int, mapCrs: QgsCoordinateReferenceSystem, transformContext: QgsCoordinateTransformContext, mProject: QgsProject) -> None: ...

    def project(self) -> QgsProject: ...


class QgsGeometryCheckError(sip.wrapper):

    class ValueType(int):
        ...
    ValueLength: QgsGeometryCheckError.ValueType = ...
    ValueArea: QgsGeometryCheckError.ValueType = ...
    ValueOther: QgsGeometryCheckError.ValueType = ...

    class Status(int):
        ...
    StatusPending: QgsGeometryCheckError.Status = ...
    StatusFixFailed: QgsGeometryCheckError.Status = ...
    StatusFixed: QgsGeometryCheckError.Status = ...
    StatusObsolete: QgsGeometryCheckError.Status = ...

    @overload
    def __init__(self, check: QgsGeometryCheck, layerFeature: QgsGeometryCheckerUtils.LayerFeature, errorLocation: QgsPointXY, vidx: QgsVertexId = ..., value: Any = ..., valueType: QgsGeometryCheckError.ValueType = ...) -> None: ...
    @overload
    def __init__(self, check: QgsGeometryCheck, layerId: str, featureId: int, geometry: QgsGeometry, errorLocation: QgsPointXY, vidx: QgsVertexId = ..., value: Any = ..., valueType: QgsGeometryCheckError.ValueType = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheckError) -> None: ...

    def icon(self) -> QtGui.QIcon: ...
    def update(self, other: QgsGeometryCheckError) -> None: ...
    def closeMatch(self, a0: QgsGeometryCheckError) -> bool: ...
    def isEqual(self, other: QgsGeometryCheckError) -> bool: ...
    def setObsolete(self) -> None: ...
    def setFixFailed(self, reason: str) -> None: ...
    def setFixed(self, method: int) -> None: ...
    def resolutionMessage(self) -> str: ...
    def status(self) -> QgsGeometryCheckError.Status: ...
    def vidx(self) -> QgsVertexId: ...
    def valueType(self) -> QgsGeometryCheckError.ValueType: ...
    def value(self) -> Any: ...
    def location(self) -> QgsPointXY: ...
    def description(self) -> str: ...
    def affectedAreaBBox(self) -> QgsRectangle: ...
    def contextBoundingBox(self) -> QgsRectangle: ...
    def geometry(self) -> QgsGeometry: ...
    def featureId(self) -> int: ...
    def layerId(self) -> str: ...
    def check(self) -> QgsGeometryCheck: ...


class QgsGeometryCheckerUtils(sip.wrapper):

    class LayerFeature(sip.wrapper):

        @overload
        def __init__(self, pool: QgsFeaturePool, feature: QgsFeature, context: QgsGeometryCheckContext, useMapCrs: bool) -> None: ...
        @overload
        def __init__(self, a0: QgsGeometryCheckerUtils.LayerFeature) -> None: ...

        def useMapCrs(self) -> bool: ...
        def id(self) -> str: ...
        def geometry(self) -> QgsGeometry: ...
        def layerId(self) -> str: ...
        def feature(self) -> QgsFeature: ...

    class LayerFeatures(sip.wrapper):

        def __init__(
            self, a0: QgsGeometryCheckerUtils.LayerFeatures) -> None: ...

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheckerUtils) -> None: ...


class QgsGeometryCheckFactory(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheckFactory) -> None: ...

    def checkType(self) -> QgsGeometryCheck.CheckType: ...
    def flags(self) -> QgsGeometryCheck.Flags: ...
    def isCompatible(self, layer: QgsVectorLayer) -> bool: ...
    def description(self) -> str: ...
    def id(self) -> str: ...
    def createGeometryCheck(self, context: QgsGeometryCheckContext, configuration: Dict[str, Any]) -> QgsGeometryCheck: ...


class QgsGeometryCheckRegistry(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheckRegistry) -> None: ...

    def registerGeometryCheck(self, checkFactory: QgsGeometryCheckFactory) -> None: ...

    def geometryCheckFactories(self, layer: QgsVectorLayer, type: QgsGeometryCheck.CheckType, flags: Union[QgsGeometryCheck.Flags, QgsGeometryCheck.Flag] = ...) -> List[QgsGeometryCheckFactory]: ...
    def geometryCheck(self, checkId: str, context: QgsGeometryCheckContext, geometryCheckConfig: Dict[str, Any]) -> QgsGeometryCheck: ...


class QgsSingleGeometryCheckError(sip.wrapper):

    @overload
    def __init__(self, check: QgsSingleGeometryCheck, geometry: QgsGeometry, errorLocation: QgsGeometry, vertexId: QgsVertexId = ...) -> None: ...

    @overload
    def __init__(self, a0: QgsSingleGeometryCheckError) -> None: ...

    def vertexId(self) -> QgsVertexId: ...
    def errorLocation(self) -> QgsGeometry: ...
    def check(self) -> QgsSingleGeometryCheck: ...
    def description(self) -> str: ...
    def isEqual(self, other: QgsSingleGeometryCheckError) -> bool: ...
    def update(self, other: QgsSingleGeometryCheckError) -> None: ...


class QgsGeometryCheckErrorSingle(QgsGeometryCheckError):

    @overload
    def __init__(self, singleError: QgsSingleGeometryCheckError, layerFeature: QgsGeometryCheckerUtils.LayerFeature) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometryCheckErrorSingle) -> None: ...

    def singleError(self) -> QgsSingleGeometryCheckError: ...


class QgsSingleGeometryCheck(QgsGeometryCheck):

    @overload
    def __init__(self, context: QgsGeometryCheckContext, configuration: Dict[str, Any]) -> None: ...
    @overload
    def __init__(self, a0: QgsSingleGeometryCheck) -> None: ...

    def processGeometry(self, geometry: QgsGeometry) -> List[QgsSingleGeometryCheckError]: ...
    def collectErrors(self, featurePools: Any, errors: Iterable[QgsGeometryCheckError], messages: Iterable[str], feedback: Optional[QgsFeedback] = ..., ids: QgsGeometryCheck.LayerFeatureIds = ...) -> None: ...


class QgsGeometrySnapper(QtCore.QObject):

    class SnapMode(int):
        ...
    PreferNodes: QgsGeometrySnapper.SnapMode = ...
    PreferClosest: QgsGeometrySnapper.SnapMode = ...
    PreferNodesNoExtraVertices: QgsGeometrySnapper.SnapMode = ...
    PreferClosestNoExtraVertices: QgsGeometrySnapper.SnapMode = ...
    EndPointPreferNodes: QgsGeometrySnapper.SnapMode = ...
    EndPointPreferClosest: QgsGeometrySnapper.SnapMode = ...
    EndPointToEndPoint: QgsGeometrySnapper.SnapMode = ...

    def __init__(self, referenceSource: QgsFeatureSource) -> None: ...

    def featureSnapped(self) -> None: ...
    def snapFeatures(self, features: Iterable[QgsFeature], snapTolerance: float, mode: QgsGeometrySnapper.SnapMode = ...) -> List[QgsFeature]: ...
    @overload
    def snapGeometry(self, geometry: QgsGeometry, snapTolerance: float, mode: QgsGeometrySnapper.SnapMode = ...) -> QgsGeometry: ...
    @overload
    @staticmethod
    def snapGeometry(geometry: QgsGeometry, snapTolerance: float, referenceGeometries: Iterable[QgsGeometry], mode: QgsGeometrySnapper.SnapMode = ...) -> QgsGeometry: ...


class QgsInternalGeometrySnapper(sip.wrapper):

    @overload
    def __init__(self, snapTolerance: float, mode: QgsGeometrySnapper.SnapMode = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsInternalGeometrySnapper) -> None: ...

    def snappedGeometries(self) -> Any: ...
    def snapFeature(self, feature: QgsFeature) -> QgsGeometry: ...


class QgsGeometrySnapperSingleSource(sip.wrapper):

    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, a0: QgsGeometrySnapperSingleSource) -> None: ...

    @staticmethod
    def run(source: QgsFeatureSource, sink: QgsFeatureSink, thresh: float, feedback: QgsFeedback) -> int: ...


class QgsZonalStatistics(sip.wrapper):

    class Result(int):
        ...
    Success: QgsZonalStatistics.Result = ...
    LayerTypeWrong: QgsZonalStatistics.Result = ...
    LayerInvalid: QgsZonalStatistics.Result = ...
    RasterInvalid: QgsZonalStatistics.Result = ...
    RasterBandInvalid: QgsZonalStatistics.Result = ...
    FailedToCreateField: QgsZonalStatistics.Result = ...
    Canceled: QgsZonalStatistics.Result = ...

    class Statistic(int):
        ...
    Count: QgsZonalStatistics.Statistic = ...
    Sum: QgsZonalStatistics.Statistic = ...
    Mean: QgsZonalStatistics.Statistic = ...
    Median: QgsZonalStatistics.Statistic = ...
    StDev: QgsZonalStatistics.Statistic = ...
    Min: QgsZonalStatistics.Statistic = ...
    Max: QgsZonalStatistics.Statistic = ...
    Range: QgsZonalStatistics.Statistic = ...
    Minority: QgsZonalStatistics.Statistic = ...
    Majority: QgsZonalStatistics.Statistic = ...
    Variety: QgsZonalStatistics.Statistic = ...
    Variance: QgsZonalStatistics.Statistic = ...
    All: QgsZonalStatistics.Statistic = ...

    class Statistics(sip.wrapper):

        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, f: Union[QgsZonalStatistics.Statistics, QgsZonalStatistics.Statistic]) -> None: ...
        @overload
        def __init__(self, a0: QgsZonalStatistics.Statistics) -> None: ...

        def __hash__(self) -> int: ...
        def __bool__(self) -> int: ...
        def __invert__(self) -> QgsZonalStatistics.Statistics: ...
        def __int__(self) -> int: ...

    @overload
    def __init__(self, polygonLayer: QgsVectorLayer, rasterLayer: QgsRasterLayer, attributePrefix: str = ..., rasterBand: int = ..., stats: Union[QgsZonalStatistics.Statistics, QgsZonalStatistics.Statistic] = ...) -> None: ...
    @overload
    def __init__(self, polygonLayer: QgsVectorLayer, rasterInterface: QgsRasterInterface, rasterCrs: QgsCoordinateReferenceSystem, rasterUnitsPerPixelX: float, rasterUnitsPerPixelY: float, attributePrefix: str = ..., rasterBand: int = ..., stats: Union[QgsZonalStatistics.Statistics, QgsZonalStatistics.Statistic] = ...) -> None: ...
    @overload
    def __init__(self, a0: QgsZonalStatistics) -> None: ...

    @staticmethod
    def shortName(statistic: QgsZonalStatistics.Statistic) -> str: ...
    @staticmethod
    def displayName(statistic: QgsZonalStatistics.Statistic) -> str: ...
    @overload
    def calculateStatistics(self, feedback: QgsFeedback) -> QgsZonalStatistics.Result: ...
    @overload
    @staticmethod
    def calculateStatistics(rasterInterface: QgsRasterInterface, geometry: QgsGeometry, cellSizeX: float, cellSizeY: float, rasterBand: int, statistics: Union[QgsZonalStatistics.Statistics, QgsZonalStatistics.Statistic]) -> Dict[int, Any]: ...
