import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::AuditManager::Assessment`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export interface CfnAssessmentProps {
    /**
     * `AWS::AuditManager::Assessment.AssessmentReportsDestination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-assessmentreportsdestination
     */
    readonly assessmentReportsDestination?: CfnAssessment.AssessmentReportsDestinationProperty | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.AwsAccount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-awsaccount
     */
    readonly awsAccount?: CfnAssessment.AWSAccountProperty | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-description
     */
    readonly description?: string;
    /**
     * `AWS::AuditManager::Assessment.FrameworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-frameworkid
     */
    readonly frameworkId?: string;
    /**
     * `AWS::AuditManager::Assessment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-name
     */
    readonly name?: string;
    /**
     * `AWS::AuditManager::Assessment.Roles`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-roles
     */
    readonly roles?: Array<CfnAssessment.RoleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.Scope`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-scope
     */
    readonly scope?: CfnAssessment.ScopeProperty | cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-status
     */
    readonly status?: string;
    /**
     * `AWS::AuditManager::Assessment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare class CfnAssessment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AuditManager::Assessment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAssessment;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute AssessmentId
     */
    readonly attrAssessmentId: string;
    /**
     * @external
     * @cloudformationAttribute CreationTime
     */
    readonly attrCreationTime: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Delegations
     */
    readonly attrDelegations: cdk.IResolvable;
    /**
     * `AWS::AuditManager::Assessment.AssessmentReportsDestination`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-assessmentreportsdestination
     */
    assessmentReportsDestination: CfnAssessment.AssessmentReportsDestinationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.AwsAccount`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-awsaccount
     */
    awsAccount: CfnAssessment.AWSAccountProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-description
     */
    description: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.FrameworkId`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-frameworkid
     */
    frameworkId: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-name
     */
    name: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.Roles`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-roles
     */
    roles: Array<CfnAssessment.RoleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.Scope`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-scope
     */
    scope: CfnAssessment.ScopeProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AuditManager::Assessment.Status`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-status
     */
    status: string | undefined;
    /**
     * `AWS::AuditManager::Assessment.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html#cfn-auditmanager-assessment-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::AuditManager::Assessment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnAssessmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @external
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare namespace CfnAssessment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html
     */
    interface AWSAccountProperty {
        /**
         * `CfnAssessment.AWSAccountProperty.EmailAddress`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html#cfn-auditmanager-assessment-awsaccount-emailaddress
         */
        readonly emailAddress?: string;
        /**
         * `CfnAssessment.AWSAccountProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html#cfn-auditmanager-assessment-awsaccount-id
         */
        readonly id?: string;
        /**
         * `CfnAssessment.AWSAccountProperty.Name`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsaccount.html#cfn-auditmanager-assessment-awsaccount-name
         */
        readonly name?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare namespace CfnAssessment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsservice.html
     */
    interface AWSServiceProperty {
        /**
         * `CfnAssessment.AWSServiceProperty.ServiceName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-awsservice.html#cfn-auditmanager-assessment-awsservice-servicename
         */
        readonly serviceName?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare namespace CfnAssessment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-assessmentreportsdestination.html
     */
    interface AssessmentReportsDestinationProperty {
        /**
         * `CfnAssessment.AssessmentReportsDestinationProperty.Destination`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-assessmentreportsdestination.html#cfn-auditmanager-assessment-assessmentreportsdestination-destination
         */
        readonly destination?: string;
        /**
         * `CfnAssessment.AssessmentReportsDestinationProperty.DestinationType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-assessmentreportsdestination.html#cfn-auditmanager-assessment-assessmentreportsdestination-destinationtype
         */
        readonly destinationType?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare namespace CfnAssessment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html
     */
    interface DelegationProperty {
        /**
         * `CfnAssessment.DelegationProperty.AssessmentId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-assessmentid
         */
        readonly assessmentId?: string;
        /**
         * `CfnAssessment.DelegationProperty.AssessmentName`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-assessmentname
         */
        readonly assessmentName?: string;
        /**
         * `CfnAssessment.DelegationProperty.Comment`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-comment
         */
        readonly comment?: string;
        /**
         * `CfnAssessment.DelegationProperty.ControlSetId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-controlsetid
         */
        readonly controlSetId?: string;
        /**
         * `CfnAssessment.DelegationProperty.CreatedBy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-createdby
         */
        readonly createdBy?: string;
        /**
         * `CfnAssessment.DelegationProperty.CreationTime`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-creationtime
         */
        readonly creationTime?: number;
        /**
         * `CfnAssessment.DelegationProperty.Id`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-id
         */
        readonly id?: string;
        /**
         * `CfnAssessment.DelegationProperty.LastUpdated`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-lastupdated
         */
        readonly lastUpdated?: number;
        /**
         * `CfnAssessment.DelegationProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnAssessment.DelegationProperty.RoleType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-roletype
         */
        readonly roleType?: string;
        /**
         * `CfnAssessment.DelegationProperty.Status`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-delegation.html#cfn-auditmanager-assessment-delegation-status
         */
        readonly status?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare namespace CfnAssessment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-role.html
     */
    interface RoleProperty {
        /**
         * `CfnAssessment.RoleProperty.RoleArn`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-role.html#cfn-auditmanager-assessment-role-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnAssessment.RoleProperty.RoleType`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-role.html#cfn-auditmanager-assessment-role-roletype
         */
        readonly roleType?: string;
    }
}
/**
 * A CloudFormation `AWS::AuditManager::Assessment`.
 *
 * @external
 * @cloudformationResource AWS::AuditManager::Assessment
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-auditmanager-assessment.html
 */
export declare namespace CfnAssessment {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-scope.html
     */
    interface ScopeProperty {
        /**
         * `CfnAssessment.ScopeProperty.AwsAccounts`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-scope.html#cfn-auditmanager-assessment-scope-awsaccounts
         */
        readonly awsAccounts?: Array<CfnAssessment.AWSAccountProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnAssessment.ScopeProperty.AwsServices`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-auditmanager-assessment-scope.html#cfn-auditmanager-assessment-scope-awsservices
         */
        readonly awsServices?: Array<CfnAssessment.AWSServiceProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
