import os
import re
import logging
import json

def _serial():
	with open('/proc/cpuinfo', 'r') as file:
		for line in file:
			if line.strip().startswith('Serial'):
				serial = re.search('Serial.*:.*0*(........+)', line).group(1)
				return serial

	raise Exception('No serial number info found on /proc/cpuinfo')

def _hostname():
	serial = _serial()
	return 'unio-' + serial

def _read_json_config_file(filename):
	with open(filename) as json_file:
	    data = json.load(json_file)
	    return json.dumps(data)

__VERSION__ = '2.0.3'

class Config(object):
	DEBUG = False
	TESTING = False
	CSRF_ENABLED = True
	DEVELOPMENT = False
	APP_ID = os.environ.get('APP_ID')
	SECRET_KEY = os.environ.get('APP_SECRET')
	#SQLALCHEMY_DATABASE_URI = 'postgres://postgres@localhost:5432/postgres'
	#SQLALCHEMY_TRACK_MODIFICATIONS = False
	LOG_LEVEL = logging.DEBUG
	PORT = int(os.environ.get('PORT', '5000'))
	CLOUD_URL = os.environ.get('CLOUD_URL', 'https://cloud.uniosmarthome.com')
	HOSTNAME = _hostname()
	SERIAL = _serial()
	UNIO_VERSION = os.environ.get('UNIO_VERSION', 'unio-server-{}'.format(__VERSION__))

	MQTT_BROKER_URL = os.environ.get('MQTT_BROKER_URL', None)
	MQTT_BROKER_PORT = int(os.environ.get('MQTT_BROKER_PORT', '1883'))
	#MQTT_USERNAME = os.environ.get('MQTT_USERNAME', 'unio')
	#MQTT_PASSWORD = os.environ.get('MQTT_PASSWORD', 'homeassistant')
	MQTT_BASE_TOPIC = os.environ.get('MQTT_BASE_TOPIC', 'homeassistant')
	#MQTT_KEEPALIVE = 5
	MQTT_TLS_ENABLED = False
	MQTT_CLEAN_SESSION = True

	BOARDS = json.loads(os.environ.get('BOARDS', _read_json_config_file('boards.json')))

	# Parameters for SSL enabled
	#MQTT_BROKER_PORT = 8883
	#MQTT_TLS_ENABLED = True
	#MQTT_TLS_INSECURE = True
	#MQTT_TLS_CA_CERTS = 'ca.crt'

class ProductionConfig(Config):
	pass

class StagingConfig(Config):
	DEVELOPMENT = True
	DEBUG = True

class DevelopmentConfig(Config):
	DEVELOPMENT = True
	DEBUG = True

class TestingConfig(Config):
	TESTING = True
