import os

os.environ["GPIOZERO_PIN_FACTORY"] = "pigpio"

from eventlet import monkey_patch
monkey_patch()

from app import app, init_app
from logger import log


application = app

init_app(app, os.environ['APP_SETTINGS'])

if __name__ == '__main__':
	log.warning('Starting Application with {} configuration on port {}.'.format(os.environ['APP_SETTINGS'], app.config['PORT']))

	app.run(
		host='0.0.0.0',
		port=app.config['PORT'],
		debug=app.config['DEBUG'],
		use_reloader=False)