'''DO NOT IMPORT: Marked as Deprecated'''

from api 			import api
from database 		import db
from logger			import log

from hardware 		import deviceManager
from .models 		import Room, Automation, TV, User, Light, Curtain, AirConditioner, Guardian, Camera
#from .schemas 		import RoomSchema, LightSchema, AirConditionerSchema, SecuritySchema, \
#						GuardianSchema, UserSchema, CurtainSchema, HomeSchema, AutomationSchema
#from notifications import Notification

from datetime import datetime, timedelta


@api.on('connect')
def on_connect():
	log.debug('Client connected')

@api.on('disconnect')
def on_disconnect():
	log.debug('Client disconnected')

@api.on('join')
def on_join(data):
	username = 'teste'
	room_id = data['room']
	log.debug(username + ' has entered the room ' + room_id)
	join_room(room_id)

	if room_id == 'light':
		return join_light_room()

	if room_id == 'air_conditioner':
		return join_air_conditioners_room()

	if room_id == 'security':
		return join_security_room()

	if room_id == 'user':
		return join_users_room()

	if room_id == 'home':
		return join_home_room()

	if room_id == 'media':
		return join_media_room()

	if room_id == 'automation':
		return join_automation_room()

	log.warning('Invalid room {}.'.format(room_id))
	return '404'

def join_light_room():
	rooms = Room.query.all()
	# rooms = Room.query\
	# 	.outerjoin(Room.lights)\
	# 	.filter(Room.id==Light.room_id)
		
	return RoomSchema(many=True, only=['id', 'name', 'lights', 'curtains']).dump(rooms)

def join_air_conditioners_room():
	rooms = Room.query\
		.outerjoin(Room.air_conditioners)\
		.filter(Room.id==AirConditioner.room_id)

	return RoomSchema(many=True, only=['id', 'name', 'air_conditioners']).dump(rooms)

def join_security_room():
	guardians = Guardian.query.all()
	cameras = Camera.query.all()
	notifications = Notification.query.filter(Notification.date >= (datetime.now() - timedelta(days=30)))

	return SecuritySchema().dump({
		'notifications': notifications,
		'cameras': cameras,
		'guardians': guardians
	})

def join_users_room():
	users = User.query.all()
	return UserSchema(many=True).dump(users)

def join_home_room():
	rooms = Room.query.all()
	automations = Automation.query.all()

	return HomeSchema().dump({
		'rooms': rooms,
		'automations': automations
	})

def join_media_room():
	rooms = Room.query\
		.outerjoin(Room.tvs)\
		.filter(Room.id==TV.room_id)

	return RoomSchema(many=True, only=['id', 'name', 'tvs']).dump(rooms)

def join_automation_room():
	automations = Automation.query.all()

	return AutomationSchema(many=True).dump(automations)

@api.on('leave')
def on_leave(data):
	username = 'teste'
	room_id = data['room']
	log.debug(username + ' has left the room ' + room_id)
	leave_room(room_id)

@api.on('light_update_request')
def handle_light_update_request(data):
	username = 'teste'
	light_id = data['light_id']
	status = data.get('status')
	power = data.get('power')
	power = int(power) if power is not None else None

	log.debug(username + ' has requested to change light')
	
	light = Light.query.get(light_id)
	lightController = deviceManager.get_light_controller(light.id)

	if status is True and light.power == 0:
		power = 100
	elif power is not None and power == 0:
		status = False
	elif power is not None and power > 0:
		status = True

	status = light.status if status is None else status
	power = light.power if power is None else power
	
	if lightController is not None:
		lightController.update(power, status)
		log.debug('Updating light {}'.format(light))

	light.status = status
	light.power = power

	db.session.commit()

	emit('light_status_update', LightSchema().dump(light), broadcast=True, room="light")
	emit('light_status_update', LightSchema().dump(light), broadcast=True, room="home")
	return True

@api.on('room_light_update_request')
def handle_room_light_update_request(data):
	username = 'teste'
	status = data['status']
	room_id = data['room_id']
	
	log.debug(username + ' has requested to change room lights')

	room = Room.query.get(room_id)
	for light in room.lights:
		lightController = deviceManager.get_light_controller(light.id)
		if lightController is not None:
			lightController.update(light.power, status)
		
		light.status = status

	db.session.commit()

	emit('room_light_status_update', RoomSchema(only=['id', 'lights']).dump(room), broadcast=True, room="light")
	emit('room_light_status_update', RoomSchema(only=['id', 'lights']).dump(room), broadcast=True, room="home")
	return True

@api.on('home_light_update_request')
def handle_home_light_update_request(data):
	username = 'teste'
	status = data['status']
	
	log.debug(username + ' has requested to change home lights')

	rooms = Room.query.all()
	for room in rooms:
		for light in room.lights:
			if light.status != status:
				lightController = deviceManager.get_light_controller(light.id)
				if lightController is not None:
					lightController.update(light.power, status)
				
				light.status = status

	db.session.commit()

	emit('home_light_status_update', status, broadcast=True, room="light")
	emit('home_light_status_update', status, broadcast=True, room="home")
	return True

@api.on('air_conditioner_update_request')
def handle_air_conditioner_update_request(data):
	username = 'teste'
	air_conditioner_id = data['air_conditioner_id']

	log.debug(username + ' has requested to change air_conditioner: ' + str(air_conditioner_id))

	air_conditioner = AirConditioner.query.get(air_conditioner_id)

	status = data.get('status') if data.get('status') is not None else air_conditioner.status
	fan_speed = data.get('fan_speed') if data.get('fan_speed') is not None else air_conditioner.fan_speed
	mode = data.get('mode') if data.get('mode') is not None else air_conditioner.mode
	temperature = data.get('temperature') if data.get('temperature') is not None else air_conditioner.temperature

	air_conditioner_controller = deviceManager.get_air_conditioner_controller(air_conditioner.id)
	
	if air_conditioner_controller is not None:
		air_conditioner_controller.update(air_conditioner.status, status, fan_speed, mode, temperature)
	else:
		log.warning("No controller found for {}".format(air_conditioner))

	air_conditioner.status = status
	air_conditioner.fan_speed = fan_speed
	air_conditioner.mode = mode
	air_conditioner.temperature = temperature

	db.session.commit()

	emit('air_conditioner_status_update', AirConditionerSchema().dump(air_conditioner), broadcast=True, room="air_conditioner")
	emit('air_conditioner_status_update', AirConditionerSchema().dump(air_conditioner), broadcast=True, room="home")
	return True

@api.on('home_air_conditioner_update_request')
def handle_home_air_conditioner_update_request(data):
	username = 'teste'
	status = data['status']
	
	log.debug(username + ' has requested to change home air_conditioners')

	rooms = Room.query.all()
	for room in rooms:
		for air_conditioner in room.air_conditioners:
			# lightController = deviceManager.get_light_controller(light.id)
			# if lightController is not None:
			# 	lightController.toggle(status)
			
			air_conditioner.status = status

	db.session.commit()

	emit('home_air_conditioner_status_update', status, broadcast=True, room="air_conditioner")
	emit('home_air_conditioner_status_update', status, broadcast=True, room="home")
	return True

@api.on('guardian_unlock_request')
def handle_guardian_unlock_request(data):
	username = 'teste'
	guardian_id = data['guardian_id']
	
	log.debug('{} has requested to unlock guardian id: {}'.format(username, guardian_id))

	guardian_controller = deviceManager.get_guardian_controller()
	
	if guardian_controller is not None:
		guardian_controller.unlock()
	else:
		log.warning("No controller found for {}".format(guardian_id))

	return True

@api.on('guardian_update_request')
def handle_guardian_update_request(data):
	username = 'teste'
	guardian_id = data['guardian_id']
	
	guardian = Guardian.query.get(guardian_id)

	if guardian is None:
		log.warning('No model found for guardian with id: {}'.format(guardian_id))
		return

	guardianController = deviceManager.get_guardian_controller()
	bell_mute_alert = data.get('bell_mute_alert')
	bell_mute_notifications = data.get('bell_mute_notifications')

	if bell_mute_alert is not None:
		if bell_mute_alert != guardian.bell_mute_alert:
			log.debug('{} hast requested update guardian={}, mute_bell_alert from={} to={}'.format(username, guardian_id, guardian.bell_mute_alert, bell_mute_alert))

		guardianController.mute_bell_alert = bell_mute_alert

	if bell_mute_notifications is not None:
		if bell_mute_notifications != guardian.bell_mute_notifications:
			log.debug('{} hast requested update guardian={}, mute_bell_notifications from={} to={}'.format(username, guardian_id, guardian.bell_mute_notifications, bell_mute_notifications))

		guardianController.mute_bell_notifications = bell_mute_notifications

	guardian.bell_mute_alert = bell_mute_alert
	guardian.bell_mute_notifications = bell_mute_notifications

	db.session.commit()

	emit('guardian_updated', GuardianSchema().dump(guardian), broadcast=True, room="security")
	return True

@api.on('ir_device_raw_command')
def handle_ir_device_raw_command(data):
	username = 'teste'
	id = data['device_id']
	command_id = data.get('command')
	
	log.debug('{} has requested to send IR Command: {}, device_id={}'.format(username, command_id, id))

	device = TV.query.get(id) #TODO support multiple types
	controller = deviceManager.get_media_controller(device.conf_name)
	controller.update(command_id)
	
	return True

@api.on('curtain_update_request')
def handle_curtain_update_request(data):
	username = 'teste'
	status = data['status']
	curtain_id = data['curtain_id']

	log.debug(username + ' has requested to change curtain to {}'.format(status))
	
	curtain = Curtain.query.get(curtain_id)
	curtainController = deviceManager.get_curtain_controller(curtain.id)
	
	if curtainController is not None:
		if status:
			if curtain.last_status is not Curtain.Status.Opening:
				log.debug('Opening curtain id={}'.format(curtain.id))
				curtain.status = Curtain.Status.Opening
				curtain.last_status = Curtain.Status.Opening

				curtainController.open()
			else:
				log.debug('Closing curtain id={}'.format(curtain.id))
				curtain.status = Curtain.Status.Closing
				curtain.last_status = Curtain.Status.Closing
				
				curtainController.close()
		else:
			log.debug('Stopping curtain id={}'.format(curtain.id))
			curtain.status = Curtain.Status.Stopped
			curtainController.stop()

	db.session.commit()

	emit('curtain_status_update', CurtainSchema().dump(curtain), broadcast=True, room="light")
	emit('curtain_status_update', CurtainSchema().dump(curtain), broadcast=True, room="home")
	return True

@api.on('room_curtain_update_request')
def handle_room_curtain_update_request(data):
	username = 'teste'
	status = data['status']
	room_id = data['room_id']
	
	log.debug(username + ' has requested to change room curtains to {}'.format(status))

	room = Room.query.get(room_id)

	new_status = Curtain.Status.Stopped
	if status is True:
		for curtain in room.curtains:
			if curtain.last_status is not Curtain.Status.Opening:
				new_status = Curtain.Status.Opening
				break
		
		if new_status is Curtain.Status.Stopped:
			new_status = Curtain.Status.Closing

	log.debug('Changing room curtain status to {}'.format(new_status))
	for curtain in room.curtains:
		curtainController = deviceManager.get_curtain_controller(curtain.id)
		if status is True:
			if new_status is Curtain.Status.Opening:
				curtain.status = Curtain.Status.Opening
				curtain.last_status = Curtain.Status.Opening

				log.debug('Opening curtain id={}'.format(curtain.id))
				curtainController.open()
			else:
				curtain.status = Curtain.Status.Closing
				curtain.last_status = Curtain.Status.Closing
				
				log.debug('Closing curtain id={}'.format(curtain.id))
				curtainController.close()
		else:
			curtain.status = Curtain.Status.Stopped

			log.debug('Stopping curtain id={}'.format(curtain.id))
			curtainController.stop()

	db.session.commit()

	emit('room_curtain_status_update', RoomSchema(only=['id', 'curtains']).dump(room), broadcast=True, room="light")
	emit('room_curtain_status_update', RoomSchema(only=['id', 'curtains']).dump(room), broadcast=True, room="home")
	return True

@api.on('automation_trigger_request')
def handle_automation_trigger_request(data):
	pass