import json

from logger import log
from mqtt import mqtt
from hardware import deviceManager

def configure():
	for board in filter(lambda b: hasattr(b, 'inputs'), deviceManager.boards):
		for pin in board.inputs:
			_publish_mqtt_button_discovery(board, pin.address)

def handle_hardware_state_trigger(device_address, status):
	pin, board = deviceManager.get_input_pin(device_address)
	_publish_mqtt_button_update(board, pin.address, status)

def _publish_mqtt_button_update(board, pin, status):
	topic = mqtt.topic('binary_sensor', board, pin)
	payload = 'ON' if status else 'OFF'
	
	mqtt.publish(topic + '/state', payload, retain=True)

def _publish_mqtt_button_discovery(board, pin):
	topic = mqtt.topic('binary_sensor', board, pin)
	unique_id = mqtt.create_device_unique_id(board, pin)

	payload = {
		"~": topic,
		"name": 'UNIO Button - {} - {} - {}'.format(pin, board.host, mqtt.hostname),
		"uniq_id": unique_id,
		"stat_t": "~/state",
		"dev": mqtt.board_hw_info(board)
	}

	mqtt.publish(topic + '/config', json.dumps(payload), retain=True)
