import json

from logger import log
from hardware import deviceManager

from .. import mqtt
from . import light, button, climate


class Message:
	def __init__(self, topic, payload):
		self.topic = topic
		self.payload = payload

def configure(app):
	@app.on_connect()
	def handle_connect(client, userdata, flags, rc):
		log.debug("MQTT Connected!")

		light.configure()
		button.configure()
		climate.configure()

	@app.on_message()
	def handle_mqtt_message(client, userdata, message):
		message = Message(
			topic=message.topic,
			payload=message.payload.decode()
		)

		if light.process_mqtt_message(message):
			return

		if climate.process_mqtt_message(message):
			return

		log.warning('No MQTT Controller registered to process message: {}'.format(message.topic))

