import logging
from logging.handlers import RotatingFileHandler

class Logger:
	def __init__(self, name):
		self.logger = logging.getLogger(name)
		self.loggers = [
			self.logger
		]

		self.debug 		= self.logger.debug
		self.info  		= self.logger.info
		self.warning  	= self.logger.warning
		self.error 		= self.logger.error
		self.critical  	= self.logger.critical
		self.exception 	= self.logger.exception

	def init_app(self, app):
		formatter = logging.Formatter("%(levelname)s %(asctime)s %(threadName)s %(filename)s::%(funcName)s (%(lineno)-d): %(message)s")

		handler = logging.StreamHandler()
		handler.setFormatter(formatter)
		
		if app.config.get('LOG_FILE') is not None:
			file_handler = logging.handlers.RotatingFileHandler(app.config['LOG_FILE'], maxBytes=(1024*1024*250), backupCount=7)
			file_handler.setFormatter(formatter)

		for logger in self.loggers:
			logger.setLevel(app.config['LOG_LEVEL'])
			logger.addHandler(handler)

			if app.config.get('LOG_FILE') is not None:
				logger.addHandler(file_handler)


log = Logger('fhserver')