from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse, convert_int_to_binary_string

class IRRemote(IR):
	def __init__(self, output_pin=26):
		self.protocol_config = {
		#	'duty_cycle': 0.5,
		#	'frequency': 38000,
			'trailing_pulse': True,
			'leading_pulse_duration': 4500,
			'leading_gap_duration': 4500,
			'separator_pulse_duration': 562,
			'separator_gap_duration': 46000,
		#	'one_pulse_duration': 650,
		#	'one_gap_duration': 1650,
		#	'zero_pulse_duration': 650,
		#	'zero_gap_duration': 550
		}
		self.output_pin = output_pin
		log.debug("Output Pin = {}".format(output_pin))

	def update(self, command_id):
		if command_id != 'KEY_POWER':
			log.error('Command not found: {}'.format(command_id))
			return

		#self.ir = IR(26, "NEC", self.protocol_config)
		self.ir = IR(self.output_pin, "NEC", self.protocol_config)

		command = '11100000 11100000 01100111 10011000 |* 11100000 11100000 01100111 10011000'
		log.debug("Sending infra red code: " + command)

		self.ir.send_code(command)
		self.ir.gpio.stop()