from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse, bit_inverse

class ACRemote(IR):
	def __init__(self, output_pin):
		self.protocol_config = {
			'duty_cycle': 0.5,
			'frequency': 38000,
			'trailing_pulse': True,
			'leading_pulse_duration': 4454,
			'leading_gap_duration': 4344,
			'separator_pulse_duration': 568,
			'separator_gap_duration': 5219,
			'one_pulse_duration': 569,
			'one_gap_duration': 1586,
			'zero_pulse_duration': 603,
			'zero_gap_duration': 477
		}
		self.host = host
		self.output_pin = output_pin
		log.debug("Output Pin = {}".format(output_pin))

	def update(self, prev_status, status, fan_speed, mode, temperature):
		#self.ir = IR(26, "NEC", self.protocol_config)
		self.ir = IR(self.output_pin, "NEC", self.protocol_config, host=self.host)

		log.debug("processing ir command with values status={}, fan_speed={}, mode={}, temperature={}".format(status, fan_speed, mode, temperature))
		command = "10110010 01001101 "
				   
		byte3 = self.process_fan_speed(fan_speed, status, mode)
		byte3 += self.process_power(status) + "11"

		command += byte3 + " " + bit_inverse(byte3) + " "

		byte5 = self.process_temperature(temperature, status, mode)
		byte5 += self.process_mode(mode, status)

		command += byte5 + " " + bit_inverse(byte5) + " "

		command += " |* " + command

		log.debug("Sending infra red code: " + command)

		self.ir.send_code(command)
		self.ir.gpio.stop()

	def process_fan_speed(self, fan_speed, status, mode):
		if not status:
			return "0111"

		if mode == "DRY" or mode == "FAN":
			return "0001"

		if fan_speed == "AUTO":
			return "1011"
		elif fan_speed == "LOW":
			return "1001"
		elif fan_speed == "MED" or fan_speed == "MEDIUM":
			return "0101"
		elif fan_speed == "HIGH":
			return "0011"

		print("Warning: unknown fan_speed: " + fan_speed)
		return "1011"

	def process_power(self, status):
		log.debug("Processing power: {}".format(status))
		return "11" if status else "10"

	def process_mode(self, mode, status):
		if not status:
			return "0000"

		if mode == "ICE" or mode == "COOL":
			return "0000"
		elif mode == "DRY" or mode == "FAN":
			return "0100"
		elif mode == "HEAT":
			return "1100"
		elif mode == "AUTO":
			return "1000"

		print("Warning: unknown mode: " + mode)
		return "0000"

	def process_temperature(self, temperature, status, mode):
		if not status:
			return "1110"

		if mode == "FAN":
			return "0100"

		temperature = int(temperature)

		if temperature == 17:
			return "0000" #DEC: 0
		elif temperature == 18:
			return "0001" #DEC: 1
		elif temperature == 19:
			return "0011" #DEC: 3
		elif temperature == 20:
			return "0010" #DEC: 2
		elif temperature == 21:
			return "0110" #DEC: 6
		elif temperature == 22:
			return "0111" #DEC: 7
		elif temperature == 23:
			return "0101" #DEC: 5
		elif temperature == 24:
			return "0100" #DEC: 4
		elif temperature == 25:
			return "1100" #DEC: 12
		elif temperature == 26:
			return "1101" #DEC: 13
		elif temperature == 27:
			return "1001" #DEC: 9
		elif temperature == 28:
			return "1000" #DEC: 8
		elif temperature == 29:
			return "1010" #DEC: 10
		elif temperature == 30:
			return "1011" #DEC: 11

		return "0000"

