from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse, convert_int_to_binary_string

class IRRemote(IR):
	def __init__(self):
		self.protocol_config = {
		#	'duty_cycle': 0.5,
		#	'frequency': 38000,
			'trailing_pulse': True,
			'leading_pulse_duration': 4500,
			'leading_gap_duration': 4500,
			'separator_pulse_duration': 562,
			'separator_gap_duration': 46000,
		#	'one_pulse_duration': 650,
		#	'one_gap_duration': 1650,
		#	'zero_pulse_duration': 650,
		#	'zero_gap_duration': 550
		}
		# self.ir = IR(26, "NEC", self.protocol_config)

	def update(self, command_id):
		if command_id == 'KEY_POWER':
			raw = '6020    1167    1230    1167     620     578     1231     567     621     577     621     577     622     577    1221    1175    1222     573     626'
			return
		elif command_id == 'KEY_VOLUMEUP':
			raw = '909     861     905     864    1791     879     940     829     937     833     938     832     939     830     904    1732    1789     881     907     863     935     834     932'
			return
		elif command_id == 'KEY_VOLUMEDOWN':
			raw = '933     833     933     835    1820     852     935     834     932     837     938     832     935     834     932    1705    1817     853     934     835     931    1705     938'
			return
		elif command_id == 'KEY_PAGEUP':
			raw = '6044    1146    1251    1141     657     542     657     541     657     541    1256    1141     658    1144    1254     538    1281     515     652'
			return
		elif command_id == 'KEY_PAGEDOWN':
			raw = '6049    1141    1256    1140     657     541     658     541     658     540    1258    1143     1254     539    1259     538    1260    1135     652'
			return
		elif command_id == 'KEY_UP':
			raw = '6045    1143    1254    1142     655     543     656     543    1255     542     657     541     657    1141    1257     540    1258    1137     650'
			return
		elif command_id == 'KEY_DOWN':
			raw = '6051    1137    1249    1147     651     547     652     547    1251     546     652     547     1251     546    1253    1143     655     542     656'
			return
		elif command_id == 'KEY_LEFT':
			raw = '6051    1140    1257    1138     660     539     649     549    1249     548     651     548     1249    1147    1251    1146     652    1143     655'
			return
		elif command_id == 'KEY_RIGHT':
			raw = '6054    1135    1257    1139     649     549     650     548    1260     538     650    1151     647     548    1282    1114     652    1143     655'
			return
		elif command_id == 'KEY_MENU':
			raw = '6046    1141    1257    1140     659     539     648     550    1259     539     649     549     650     548    1249     548    1255     541     653'
			return
		elif command_id == 'KEY_BACK':
			raw = '6035    1146    1251    1145     653     545     654     545    1252     545     654    1144     1253    1143     655     543     656     541     657'
			return
		elif command_id == 'KEY_OK':
			raw = '6021    1166    1274    1122     676     522     677     522    1276     521     678    1120     678    1119    1225    1171    1226     569     688'
			return
		elif command_id == 'KEY_MUTE':
			raw = '961     805     961     808    1846     824     963     806     960     810     956     813     969     801     960     809     956    1681     910     859    1795    1742     901'
			return
		else:
			log.error('Command not found: {}'.format(command_id))
			return


		self.ir = IR(26, "NEC", self.protocol_config)

		log.debug("Sending infra red code: " + raw)

		self.ir.send_raw(raw)
		self.ir.gpio.stop()