from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse, convert_int_to_binary_string, bit_inverse

class ACRemote(IR):
	def __init__(self, output_pin, host='localhost'):
		self.protocol_config = {
			'duty_cycle': 0.5,
			'frequency': 38000,
			'trailing_pulse': True,
			'leading_pulse_duration': 4670,
			'leading_gap_duration': 4355,
			'one_pulse_duration': 726,
			'one_gap_duration': 1473,
			'zero_pulse_duration': 728,
			'zero_gap_duration': 474
		}
		self.host = host
		self.output_pin = output_pin
		log.debug("Output Pin = {}".format(output_pin))

	def update(self, prev_status, status, fan_speed, mode, temperature):
		#self.ir = IR(26, "NEC", self.protocol_config)
		self.ir = IR(self.output_pin, "NEC", self.protocol_config, host=self.host)

		log.debug("processing ir command with values status={}, fan_speed={}, mode={}, temperature={}".format(status, fan_speed, mode, temperature))

		byte1 = "00100100"

		byte2 = self.process_temperature(temperature) + self.process_swing(False) + self.process_display(True) + self.process_mute(False) + self.process_power(status)

		byte3 = "00000" + self.process_fan_speed(fan_speed) + self.process_turbo(False)

		byte4 = "00000000"

		byte5 = "00000" + self.process_eco(False) + self.process_mode(mode)

		byte6 = self.process_checksum1(mode, fan_speed, temperature, status, prev_status) + "0000"
		
		byte7 = self.process_checksum2(temperature, mode, fan_speed, byte1, byte2, byte6, status, prev_status) + self.process_checksum3(mode, fan_speed, status, byte1, byte2, byte3, byte5) #xxxx


		byte8 = self.process_mode2(mode) + "0" + self.process_power(status) + self.process_fan_speed(fan_speed) + self.process_swing(False) + self.process_eco(False)

		byte9 = self.process_temperature(temperature) + "0000"

		byte10 = "0000" + self.process_turbo(False) + self.process_display(True) + self.process_power(status) + "0"

		byte11 = "00001010"

		nibble12 = "010"

		byte13 = self.process_swing(False) + "0000000"

		byte14to15 = "10000000 00000000"

		byte16 = "0000" + self.process_checksum4(temperature, mode, status, prev_status)



		command1 = byte1 + " " + byte2 + " " + byte3 + " " + byte4 + " " + byte5 + " " + byte6 + " " + byte7

		command2 = byte8 + " " + byte9 + " " + byte10 + " " + byte11 + " " + nibble12

		command3 = byte13 + " " + byte14to15 + " " + byte16 

		command = command1 + " |* " + command2 + " | " + command3

		log.debug("Sending infra red code: " + command)

		self.ir.send_code(command)
		self.ir.gpio.stop()

	def process_fan_speed(self, fan_speed):
		if fan_speed == "AUTO":
			return "00"
		elif fan_speed == "LOW":
			return "10"
		elif fan_speed == "MED" or fan_speed == "MEDIUM":
			return "01"
		elif fan_speed == "HIGH":
			return "11"

		print("Warning: unknown fan_speed: " + fan_speed)
		return "00"


	def process_swing(self, swing):
		return "1" if swing else "0"

	def process_turbo(self, turbo):
		return "1" if turbo else "0"

	def process_display(self, display):
		return "1" if display else "0"

	def process_mute(self, mute):
		return "1" if mute else "0"

	def process_power(self, status):
		return "1" if status else "0"

	def process_eco(self, eco):
		return "1" if eco else "0"

	def process_mode(self, mode):
		if mode == "COOL" or mode == "ICE":
			return "00"
		elif mode == "FAN":
			return "01"

		print("Warning: unknown mode: " + mode)
		return "00"

	def process_mode2(self, mode):
		if mode == "COOL" or mode == "ICE":
			return "00"
		elif mode == "FAN":
			return "11"

		print("Warning: unknown mode: " + mode)
		return "00"

	def process_temperature(self, temperature):
		temperature = int(temperature)
		binary = "{0:04b}".format(temperature - 16)
		return string_inverse(binary)

	def process_checksum1(self, mode, fan_speed, temperature, status, prev_status):
		if status != prev_status:
			return "1000"

		if temperature == 16:
			return "0110"
		else:
			if mode == "FAN":
				if fan_speed == "HIGH":
					return "1001"
				else:
					return "0010"
			elif mode == "COOL" or mode == "ICE":
				if fan_speed != "AUTO":
					return "0010"
				else:
					return "1010"

	def process_checksum2(self, temperature, mode, fan_speed, byte1, byte2, byte6, status, prev_status):
		# if status != prev_status:
		# 	#return "1000"
		# 	return "1101"

		if status != prev_status:
			return bit_inverse(self.process_temperature(temperature))

		temperature = int(temperature)

		nibble1_1 = byte1[:4]
		nibble2_1 = byte2[:4]

		if mode == "COOL" or mode == "ICE": # nibble7.1 = bit_inverse(nibble1.1 xor nibble2.1)

			result = ''.join("1" if a != b else "0" for a,b in zip(nibble1_1, nibble2_1))
			
			if temperature == 16:
				return "0001"
			else:
				# if fan_speed == "AUTO":
				# 	return bit_inverse(result)
				if fan_speed == "AUTO":
					return bit_inverse(result)
				else:
					return ''.join("1" if a != b else "0" for a,b in zip(result, "0111"))

		elif mode == "FAN": # nibble7.1 = nibble1.1 xor nibble2.1 xor 12
			xor = ''.join("1" if a != b else "0" for a,b in zip(nibble1_1, nibble2_1))
		
			if fan_speed == "LOW" or fan_speed == "MED" or fan_speed == "MEDIUM": # nibble7.1 = nibble1.1 xor nibble2.1 xor 7
				result = ''.join("1" if a != b else "0" for a,b in zip(xor, "0111"))
				return result
			elif fan_speed == "HIGH": # nibble7.1 = nibble1.1 xor nibble2.1 xor 12
				result = ''.join("1" if a != b else "0" for a,b in zip(xor, "1100"))
				return result
		# 	xor = ''.join("1" if a != b else "0" for a,b in zip(nibble1_1, nibble2_1))
		# 	result = ''.join("1" if a != b else "0" for a,b in zip(xor, "1100"))

		# 	return result

			
		# return self.process_checksum1(mode, fan_speed, temperature) 

	def process_checksum3(self, mode, fan_speed, status, byte1, byte2, byte3, byte5):
		if mode == "FAN":
			if fan_speed == "LOW":
				return "0000" if not status else "0001"
			elif fan_speed == "MED" or fan_speed == "MEDIUM":
				return "0110" if not status else "0111"
			elif fan_speed == "HIGH":
				return "0010" if not status else "0011"

			return "0010" if not status else "0011"
		elif mode == "COOL" or mode == "ICE":
			if fan_speed == "AUTO":
				return "0101" if not status else "0100"
			elif fan_speed == "LOW":
				return "0001" if not status else "0000"
			elif fan_speed == "MED" or fan_speed == "MEDIUM":
				return "0111" if not status else "0110"
			elif fan_speed == "HIGH":
				return "0011" if not status else "0010"
		
			return "0101" if not status else "0100"
		
		# if mode == "FAN":
		# 	if fan_speed == "LOW":
		# 		return "0001" if status else "0000"
		# 	elif fan_speed == "MED" or fan_speed == "MEDIUM":
		# 		return "0111" if status else "0110"
		# 	elif fan_speed == "HIGH":
		# 		return "0011" if status else "0010"
			
		# 	return "1001" if status else "1000"

		# else:
		# 	nibble1_2 = byte1[4:]
		# 	nibble3_2 = byte3[4:]
		# 	nibble5_2 = byte5[4:]
		# 	nibble2_2 = byte2[4:]

		# 	# nibble7.2 = (nibble1.2 xor nibble3.2 xor nibble5.2) + (nibble2.2 - 5)

		# 	xor1 = ''.join("1" if a != b else "0" for a,b in zip(nibble1_2, nibble3_2))
		# 	xor2 = ''.join("1" if a != b else "0" for a,b in zip(xor1, nibble5_2))


		# 	return "{0:04b}".format(int(xor2, 2) + (int(nibble2_2, 2) - 5))
		# 	#return "0100"
		
	def process_checksum4(self, temperature, mode, status, prev_status):
		if status != prev_status:
			if mode == "COOL" or mode == "ICE": 
				if not status:
					return "0111"
				else:
					return "0110"
			elif mode == "FAN":
				if not status:
					return "1000"
				else:
					return "1001"
		else:
			if mode == "FAN":
				temperature = int(temperature) - 11
				temperature = temperature % 16

				binary = "{0:04b}".format(temperature)

				return string_inverse(binary)
			
			# COOL && DEFAULT
			temperature = int(temperature) + 2
			temperature = temperature % 16

			binary = "{0:04b}".format(temperature)

			return string_inverse(binary)