from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse

class ACRemote(IR):
	def __init__(self, output_pin, host='localhost'):
		self.protocol_config = {
			'duty_cycle': 0.5,
			'frequency': 38000,
			'trailing_pulse': True
		}
		self.host = host
		self.output_pin = output_pin
		log.debug("Output Pin = {}".format(output_pin))

	def update(self, prev_status, status, fan_speed, mode, temperature):
		#self.ir = IR(26, "NEC", self.protocol_config)
		self.ir = IR(self.output_pin, "NEC", self.protocol_config, host=self.host)

		status = status != prev_status #regra da consul

		log.debug("processing ir command with values status={}, fan_speed={}, mode={}, temperature={}".format(status, fan_speed, mode, temperature))
		command = "11000001 01100000 "

		byte3 = self.process_fan_speed(fan_speed)
		byte3 += self.process_power(status)
		byte3 += self.process_dry_level()

		command += byte3 + " "

		byte4 = self.process_mode(mode)
		byte4 += self.process_temperature(temperature)

		command += byte4 + " "

		command += "00000000 00000000 | 00000000 00000000 00000000 00000000 00000000 00000000 00000000 "
		command += ''.join("1" if a != b else "0" for a,b in zip(byte3,byte4)) #xor between byte3 and byte4

		log.debug("Sending infra red code: " + command)

		self.ir.send_code(command)
		self.ir.gpio.stop()

	def process_fan_speed(self, fan_speed):
		if fan_speed == "AUTO":
			return "00"
		elif fan_speed == "LOW":
			return "10"
		elif fan_speed == "MED" or fan_speed == "MEDIUM":
			return "01"
		elif fan_speed == "HIGH":
			return "11"

		print("Warning: unknown fan_speed: " + fan_speed)
		return "00"

	def process_power(self, status):
		log.debug("Processing power: {}".format(status))
		if status:
			return "10"
		else:
			return "00"

	def process_dry_level(self):
		return "0000" #TODO

	def process_mode(self, mode):
		if mode == "HEAT":
			return "0000"
		elif mode == "ICE" or mode == "COOL":
			return "0100"
		elif mode == "DRY":
			return "1100"
		elif mode == "FAN":
			return "0010"

		print("Warning: unknown mode: " + mode)
		return "0000"

	def process_temperature(self, temperature):
		temperature = int(temperature)

		binary = "{0:04b}".format(temperature - 18)	
		return string_inverse(binary)