from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse, convert_int_to_binary_string

class ACRemote(IR):
	def __init__(self, output_pin, host='localhost'):
		self.protocol_config = {
			'duty_cycle': 0.5,
			'frequency': 38000,
			'trailing_pulse': True,
			'leading_pulse_duration': 9070,
			'leading_gap_duration': 4474,
			'one_pulse_duration': 627,
			'one_gap_duration': 1620,
			'zero_pulse_duration': 615,
			'zero_gap_duration': 535
		}
		self.host = host
		self.output_pin = output_pin
		log.debug("Output Pin = {}".format(output_pin))

	def update(self, prev_status, status, fan_speed, mode, temperature):
		#self.ir = IR(26, "NEC", self.protocol_config)
		self.ir = IR(self.output_pin, "NEC", self.protocol_config, host=self.host)

		log.debug("processing ir command with values status={}, fan_speed={}, mode={}, temperature={}".format(status, fan_speed, mode, temperature))

		byte1 = self.process_mode(mode) + self.process_power(status) + "0000"
		
		byte2 = self.process_temperature(temperature) + "1000"

		byte3 = self.process_fan_speed(fan_speed, mode) + "0000"

		byte4to5 = "00001000 00110000"

		command = byte1 + " " + byte2 + " " + byte3 + " " + byte4to5

		log.debug("Sending infra red code: " + command)

		self.ir.send_code(command)
		self.ir.gpio.stop()

	def process_fan_speed(self, fan_speed, mode):
		if mode == "DRY":
			return "1100"

		if fan_speed == "AUTO":
			return "0000"
		elif fan_speed == "LOW":
			return "1100"
		elif fan_speed == "MED" or fan_speed == "MEDIUM":
			return "0100"
		elif fan_speed == "HIGH":
			return "1000"

		print("Warning: unknown fan_speed: " + fan_speed)
		return "0000"

	def process_power(self, status):
		log.debug("Processing power: {}".format(status))
		return "01" if status else "00"

	def process_mode(self, mode):
		if mode == "ICE" or mode == "COOL":
			return "00"
		elif mode == "DRY":
			return "10"
		elif mode == "FAN":
			return "01"
		elif mode == "HEAT":
			return "11"

		print("Warning: unknown mode: " + mode)
		return "00"

	def process_temperature(self, temperature):
		temperature = int(temperature)
		binary = "{0:04b}".format(temperature - 15)

		return string_inverse(binary)