from irslinger.pyslinger import IR
from logger import log

from hardware.remotes import string_inverse, bit_inverse

class ACRemote(IR):
	def __init__(self, output_pin, host='localhost'):
		self.protocol_config = {
			'duty_cycle': 0.5,
			'frequency': 38400,
			'trailing_pulse': True,
			'leading_pulse_duration': 4320,
			'leading_gap_duration': 4350,
			'separator_pulse_duration': 500,
			'separator_gap_duration': 5000,
			'one_pulse_duration': 500,
			'one_gap_duration': 1650,
		    'zero_pulse_duration': 500,
			'zero_gap_duration': 550
		}
		self.host = host
		self.output_pin = output_pin
		log.debug("Output Pin = {}".format(output_pin))

	def update(self, prev_status, status, fan_speed, mode, temperature):
		#self.ir = IR(26, "NEC", self.protocol_config)
		self.ir = IR(self.output_pin, "NEC", self.protocol_config, host=self.host)

		log.debug("processing ir command with values status={}, fan_speed={}, mode={}, temperature={}".format(status, fan_speed, mode, temperature))
		command = "10110010 01001101 "
				   
		byte3 = self.process_fan_speed(fan_speed, status, mode)
		byte3 += self.process_power(status)
		byte3 += "11"

		command += byte3 + " " + bit_inverse(byte3) + " "

		byte5 = self.process_temperature(temperature, status, mode)
		byte5 += self.process_mode(mode, status)

		command += byte5 + " " + bit_inverse(byte5) + " "

		command += "|* " + command

		log.debug("Sending infra red code: " + command)

		self.ir.send_code(command)
		self.ir.gpio.stop()

	def process_fan_speed(self, fan_speed, status, mode):
		if not status:
			return "0111"

		if mode == "AUTO":
			return "0001"

		if fan_speed == "AUTO":
			return "1011"
		elif fan_speed == "LOW":
			return "1001"
		elif fan_speed == "MED" or fan_speed == "MEDIUM":
			return "0101"
		elif fan_speed == "HIGH":
			return "0011"

		print("Warning: unknown fan_speed: " + fan_speed)
		return "1011"
		
	def process_power(self, status):
		log.debug("Processing power: {}".format(status))
		if status:
			return "11"
		else:
			return "10"

	def process_mode(self, mode, status):
		if not status or mode == "ICE" or mode == "COOL":
			return "0000"
		elif mode == "DRY" or mode == "FAN":
			return "0100"
		elif mode == "HEAT":
			return "1100"
		elif mode == "AUTO":
			return "1000"

		print("Warning: unknown mode: " + mode)
		return "1000"

	def process_temperature(self, temperature, status, mode):
		if not status or mode == "FAN":
			return "1110"

		temperature = int(temperature)

		if temperature == 17:
			return "0000"
		elif temperature == 18:
			return "0001"
		elif temperature == 19:
			return "0011"
		elif temperature == 20:
			return "0010"
		elif temperature == 21:
			return "0110"
		elif temperature == 22:
			return "0111"
		elif temperature == 23:
			return "0101"
		elif temperature == 24:
			return "0100"
		elif temperature == 25:
			return "1100"
		elif temperature == 26:
			return "1101"
		elif temperature == 27:
			return "1001"
		elif temperature == 28:
			return "1000"
		elif temperature == 29:
			return "1010"
		elif temperature == 30:
			return "1011"

		return "0100"
