from . import gpiozero
from . import pin_factory

from logger import log

class Triac(gpiozero.LED):
	def __init__(self, address, host='localhost'):
		self.address = address
		
		factory = None
		if address.startswith('rpi'):
			protocol,pin = address.split('.')
			factory = pin_factory.get_or_create('{}_{}'.format('rpi', host), 'PiGPIOFactory', host=host)
		elif address.startswith('i2c'):
			protocol,addr,pin = address.split('.')
			factory = pin_factory.get_or_create(0x20+int(addr), 'MCP23017Factory')

		super(Triac, self).__init__(int(pin), pin_factory=factory)

	@property
	def status(self):
		return True if self.value == 1 else False

	def toggle(self, status=None):
		status = not status if status is not None else not self.status
		self.on() if status else self.off()

	def __repr__(self):
		return '<Triac address={}, status={}>'.format(self.address, self.status)
