import importlib

LEGACY_FAN_MODE_CODES = {
	'auto': 'AUTO',
	'low': 'LOW',
	'medium': 'MEDIUM',
	'high': 'HIGH'
}

LEGACY_MODE_CODES = {
	'off': 'COOL',
	'cool': 'COOL',
	'dry': 'DRY',
	'fan_only': 'FAN'
}

class ClimateIRDevice:
	def __init__(self, type, host, conf_name, output_pin, name, min_temp, max_temp):
		module_ = importlib.import_module('hardware.remotes.' + conf_name)
		class_ = getattr(module_, 'ACRemote')
		self._remote = class_(output_pin, host)
		
		self.type = type
		self.conf = conf_name
		self.name = name
		self.min_temp = min_temp
		self.max_temp = max_temp

		self.state = {
			'mode': 'off',
			'fan_mode': 'auto',
			'temperature': 18
		}


	def update(self, mode=None, fan_mode=None, temperature=None):
		fan_mode = fan_mode or self.state['fan_mode']
		mode = mode or self.state['mode']
		temperature = int(float(temperature or self.state['temperature']))
		prev_status = self.state['mode'] != 'off'
		status = mode != 'off'
		
		self._remote.update(prev_status, status, LEGACY_FAN_MODE_CODES[fan_mode], LEGACY_MODE_CODES[mode], temperature)
		
		self.state = {
			'mode': mode,
			'fan_mode': fan_mode,
			'temperature': temperature
		}
