from time import sleep
from threading import RLock
from logger import log
from spidev import SpiDev

from gpiozero import DigitalOutputDevice, SPIDevice
from gpiozero.mixins import HoldThread

lock = RLock()
class Dimmer:
	def __init__(self, dimmer_address, power=0, status=False, **spi_args):
		#super(Dimmer, self).__init__(shared=True, **spi_args)
		self.power = power
		self.status = status
		protocol,address,pin = dimmer_address.split('.')
		self.dimmer_channel = int(pin)

		self._spi = SpiDev()
		self._spi.open(0, int(address))
		self._spi.max_speed_hz = 128 * 1000 #kHz
		
	def on(self):
		lock.acquire()
		self.status = True
		self._dim(self.dimmer_channel, self.power)
		lock.release()

	def off(self):
		lock.acquire()
		self.status = False
		self._dim(self.dimmer_channel, 0)
		lock.release()

	def toggle(self):
		status = not self.status
		self.update(self.power, status)

	def update(self, power, status):
		lock.acquire()

		if status is not None:
			self.status = status

		self.power = power

		self._dim(self.dimmer_channel, self.power)
			
		lock.release()

	def _dim(self, dimmer_channel, power):
		lock.acquire()
		try:
			if not self.status:
				power = 0

			log.debug("Dimming channel=%s, power=%s", dimmer_channel, power)

			command = dimmer_channel;

			if dimmer_channel > 4:
				command -= 3;

			command = command * 16 + power // 10;

			log.debug("Dimmer command: {}, {}".format(command, hex(command)))
			
			sleep(0.05)
			self._spi.xfer([command])
			sleep(0.05)
		finally:
			log.debug("Releasing lock channel=%s", dimmer_channel)
			lock.release()