from . import gpiozero
from . import pin_factory

class Button(gpiozero.Button):
	def __init__(self, address, host='localhost', pull_up=True, bounce_delay=0.01):
		factory = None

		if address.startswith('rpi'):
			protocol,pin = address.split('.')
			factory = pin_factory.get_or_create('{}_{}'.format('rpi', host), 'PiGPIOFactory', host=host)
		elif address.startswith('i2c'):
			protocol,addr,pin = address.split('.')
			factory = pin_factory.get_or_create(0x20+int(addr), 'MCP23017Factory')
		else:
			raise Exception

		super(Button, self).__init__(int(pin), pull_up=pull_up, pin_factory=factory)
		self.pin._set_bounce(bounce_delay) #seconds
		self.address = address

	@property
	def status(self):
		return True if self.value == 1 else False

	def __repr__(self):
		return '<Button address={}, status={}>'.format(self.address, self.status)
