import gpiozero
from gpiozero.pins.pigpio import PiGPIOFactory
from gpiozero import MCP23017Factory

from app import app

class PinFactory:
	def __init__(self):
		self._cache = {}

	def get_or_create(self, address, type, host='localhost'):
		factory = self._cache.get(str(address))
		if factory is None:
			if type == 'PiGPIOFactory':
				factory = PiGPIOFactory(host=host)
			elif type == 'MCP23017Factory':
				factory = MCP23017Factory(address=address)
			else:
				raise Exception()
			
			self._cache[str(address)] = factory
		return factory
	
pin_factory = PinFactory()

from .button import Button
from .triac import Triac
from .hvac import ClimateIRDevice
from .lirc import LircIRDevice
#from .dimmer import Dimmer
#from .guardian import Guardian
