from logger import log
from . import boards
import itertools
import re

def canonize_name(name):
	return name.replace('.', '_').replace('-', '_').lower()

class DeviceManager():
	def __init__(self):
		self.boards = []

	def init(self, app):
		self.boards = [boards.board_from_json(board) for board in app.config['BOARDS']]
		self.hostname = app.config['HOSTNAME']
		
	def get_output_pin(self, address, host):
		boards = [b for b in self.boards if hasattr(b, 'outputs')]
		for board in boards:
			for pin in board.outputs:
				if pin.address == address and host == canonize_name(board.host + '_' + self.hostname):
					return pin, board

		raise Exception('No Board found for address={}, host={}'.format(address, host))

	def get_input_pin(self, device_address):
		for board in self.boards:
			for pin in board.inputs:
				if pin.address == device_address:
					return pin, board

		raise Exception('No Board found for device: ' + device_address)

	def get_all_output_pins(self):
		return list(itertools.chain.from_iterable(map(lambda b: b.outputs, filter(lambda b: hasattr(b, 'outputs'), self.boards))))

	def get_all_input_pins(self):
		return list(itertools.chain.from_iterable(map(lambda b: b.inputs, filter(lambda b: hasattr(b, 'inputs'), self.boards))))

	def get_climate_device(self, address, conf, host):
		for board in filter(lambda b: hasattr(b, 'devices'), self.boards):
			for device in filter(lambda d: d.type == 'climate', board.devices):
				if board.address == address and device.conf == conf and host == canonize_name(board.host + '_' + self.hostname):
					return device, board

		raise Exception('No climate device found for conf={} and pin={}'.format(conf, address))


# import importlib
# from time import sleep
# from .models import Dimmer, Triac, Button as ButtonDevice#, Guardian as GuardianDevice
# from .remotes.lirc import LircRemote


# class ButtonController():
# 	def __init__(self, button, model, device):
# 		self.button = button
# 		self.model = model
# 		self.device = device

# 		self.hardware = ButtonDevice(button.address)
# 		self._when_toggle_listeners  = []

# 		self.hardware.when_pressed = self.when_pressed
# 		self.hardware.when_released = self.when_released

# 	def when_pressed(self):
# 		log.debug('{}: event when_pressed'.format(self.__repr__()))
# 		self.toggle()

# 	def when_released(self):
# 		log.debug('{}: event when_released'.format(self.__repr__()))
# 		self.toggle()

# 	def toggle(self):
# 		#self.device.toggle()

# 		for listener in self._when_toggle_listeners:
# 			listener(self.button.address, self.device.status)

# 	def add_on_toggle_listener(self, listener):
# 		self._when_toggle_listeners.append(listener)

# 	def remove_on_toggle_listener(self, listener):
# 		self._when_toggle_listeners.remove(listener)

# 	def __repr__(self):
# 		if hasattr(self.model, 'device_address'):
# 			device_address = self.model.device_address
# 		elif hasattr(self.model, 'open_device_address') and hasattr(self.model, 'close_device_address'):
# 			device_address = '{},{}'.format(self.model.open_device_address, self.model.close_device_address)
# 		else:
# 			device_address = 'None'

# 		return '<ButtonController address={}, device={}>'.format(self.button.address, device_address)

# class CurtainController():
# 	def __init__(self, curtain):
# 		self.curtain = curtain

# 		self.last_status = curtain.last_status
# 		self.status = curtain.status

# 		self.hardware_open = Triac(curtain.open_device_address)
# 		self.hardware_close = Triac(curtain.close_device_address)

# 	def open(self):
# 		from api.models import Curtain
# 		self.status = Curtain.Status.Opening
# 		self.last_status = Curtain.Status.Opening
# 		self.hardware_close.off()
# 		self.hardware_open.on()
# 		#TODO set timer to turn off?

# 	def close(self):
# 		from api.models import Curtain
# 		self.status = Curtain.Status.Closing
# 		self.last_status = Curtain.Status.Closing

# 		self.hardware_open.off()
# 		self.hardware_close.on()
# 		#TODO set timer to turn on?

# 	def stop(self):
# 		from api.models import Curtain
# 		self.status = Curtain.Status.Stopped
		
# 		self.hardware_open.off()
# 		self.hardware_close.off()

# 	def toggle(self):
# 		from api.models import Curtain
# 		if self.status == Curtain.Status.Opening or self.status == Curtain.Status.Closing:
# 			self.stop()
# 		elif self.last_status == Curtain.Status.Closing:
# 			self.open()
# 		else:
# 			self.close()

# 	def __repr__(self):
# 		return '<CurtainController name, open_address={}, close_address={}>'.format(self.curtain.name, self.curtain.open_device_address, self.curtain.close_device_address)

# class AirConditionerController:
# 	#def __init__(self, conf_name):
# 	#	module_ = importlib.import_module('hardware.remotes.' + conf_name)
# 	#	class_ = getattr(module_, 'ACRemote')
# 	#	self._remote = class_()

# 	#def update(self, prev_status, status, fan_speed, mode, temperature):
# 	#	self._remote.update(prev_status, status, fan_speed, mode, temperature)

# 	def __init__(self, conf_name, output_pin):
# 		module_ = importlib.import_module('hardware.remotes.' + conf_name)
# 		class_ = getattr(module_, 'ACRemote')
# 		self._remote = class_(output_pin)

# 	def update(self, prev_status, status, fan_speed, mode, temperature):
# 		self._remote.update(prev_status, status, fan_speed, mode, temperature)

# class IRController:
# 	def __init__(self, conf_name, output_pin):
# 		if conf_name.startswith('lircd.'):
# 			self._remote = LircRemote(conf_name, output_pin)
# 		else:
# 			module_ = importlib.import_module('hardware.remotes.' + conf_name)
# 			class_ = getattr(module_, 'IRRemote')
# 			self._remote = class_()

# 	def update(self, command_id):
# 		self._remote.update(command_id)

# class GuardianController:
# 	def __init__(self, model):
# 		self.device = GuardianDevice(model)

# 		self.unlock = self.device.unlock

# 		self.device.start()















		#from api.models import Room, Light, Button, Guardian, AirConditioner, TV, Curtain, IRBlaster
		
		# self.lights = Light.query.all()
		# self.curtains = Curtain.query.all()
		# self.air_conditioners = AirConditioner.query.all()
		# self.media_devices = TV.query.all() #TODO support multiple device types
		# self.ir_blasters = IRBlaster.query.all()
		# self.guardian = Guardian.query.first()

		# for light in self.lights:
		# 	if light.device_address is None:
		# 		continue

		# 	log.debug('Initializating {}'.format(light))

		# 	if light.device_address.startswith('rpi') or light.device_address.startswith('i2c'):
		# 		light_controller = Triac(light.device_address, power=light.power, status=light.status)
		# 	elif light.device_address.startswith('spi'):
		# 		#TODO support devices on spidev 0 or 1
		# 		light_controller = Dimmer(light.device_address, power=light.power, status=light.status)
		# 	else:
		# 		log.error('Invalid Light address configuration: {}'.format(light.device_address))

		# 	buttons = Button.query.filter_by(device_id=light.id).all()
		# 	for button in buttons:
		# 		log.debug('Initializating {}'.format(button))
		# 		buttonController = ButtonController(button, light, light_controller)
		# 		self.button_controllers[button.id] = buttonController

		# 	light_controller.update(light.power, light.status)
		# 	self.light_controllers[light.id] = light_controller

		# for curtain in self.curtains:
		# 	if curtain.open_device_address is None or curtain.close_device_address is None:
		# 		continue

		# 	log.debug('Initializating {}'.format(curtain))

		# 	curtain_controller = CurtainController(curtain)
		# 	#curtain_controller.stop()
			
		# 	buttons = Button.query.filter_by(device_id=curtain.id).all()
		# 	for button in buttons:
		# 		log.debug('Initializating {}'.format(button))
		# 		buttonController = ButtonController(button, curtain, curtain_controller)
		# 		self.button_controllers[button.id] = buttonController

			
		# 	self.curtain_controllers[curtain.id] = curtain_controller

		# for air_conditioner in self.air_conditioners:
		# 	if air_conditioner.conf_name is None:
		# 		continue

		# 	log.debug('Initializating {}'.format(air_conditioner))

		# 	for ir_blaster in self.ir_blasters:
		# 		if ir_blaster.room_id == air_conditioner.room_id:
		# 			output_pin = ir_blaster.output_pin

		# 	air_conditioner_controller = AirConditionerController(air_conditioner.conf_name, output_pin)
		# 	self.air_conditioner_controllers[air_conditioner.id] = air_conditioner_controller

		# for media_device in self.media_devices:
		# 	if media_device.conf_name is None:
		# 		continue

		# 	log.debug('Initializating {}'.format(media_device))

		# 	for ir_blaster in self.ir_blasters:
		# 		if ir_blaster.room_id == media_device.room_id:
		# 			output_pin = ir_blaster.output_pin

		# 	controller = IRController(media_device.conf_name, output_pin)
		# 	self.media_controllers[media_device.conf_name] = controller

		# if self.guardian is not None:
		# 	log.debug('Initializating Guardian')
		# 	self.guardian_controller = GuardianController(self.guardian)
