import os

import base64
import json
import hashlib
import requests
import socket
import netifaces
from datetime import datetime, timedelta

def do_sync(cloud_url, app_version, serial):
	local_ip = netifaces.ifaddresses('wlan0')[2][0]['addr']
	device_name = socket.gethostname()
	device_id = hashlib.sha1(device_name.encode('utf-8')).hexdigest()

	body = {
		'local_ip': local_ip,
		'device_name': device_name,
		'version': app_version,
		'serial': serial
	}	

	url = '{}/device/{}/log'.format(cloud_url, device_id)
	
	print('Will Sync: {}'.format(url))
	response = requests.post(url, json=body)

	print('Sync Response: {}'.format(response))

	if response.status_code == 201:
		print('Sync Status: OK')
	else:
		print('Sync Error: status={}, body={}'.format(response.status_code, response.text))

module = __import__('config')
class_ = getattr(module, 'DevelopmentConfig')
config = class_()

if __name__ == '__main__':
	print('Synchronizing Application with {} configuration.'.format(os.environ['APP_SETTINGS']))
	do_sync(config.CLOUD_URL, config.UNIO_VERSION, config.SERIAL)
