from flask import Flask

def init_app(app, config_object):
	#Load configuration object
	app.config.from_object(config_object)

	# Init flask modules
	from logger import log
	from hardware import hardware
	from mqtt import mqtt

	log.init_app(app)
	hardware.init_app(app)
	mqtt.init_app(app)

app = Flask('unio-server')

